/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.sequencing;

import java.math.BigDecimal;
import java.util.Vector;
import oracle.toplink.essentials.internal.databaseaccess.Accessor;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.DataModifyQuery;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.ValueReadQuery;
import oracle.toplink.essentials.sequencing.StandardSequence;
import oracle.toplink.essentials.sessions.Record;

public class QuerySequence
extends StandardSequence {
    protected ValueReadQuery selectQuery;
    protected DataModifyQuery updateQuery;
    protected boolean shouldAcquireValueAfterInsert;
    protected boolean shouldUseTransaction;
    protected boolean shouldSkipUpdate;
    protected boolean shouldSelectBeforeUpdate;
    protected boolean wasSelectQueryCreated;
    protected boolean wasUpdateQueryCreated;

    public QuerySequence() {
    }

    public QuerySequence(String name) {
        super(name);
    }

    public QuerySequence(String name, int size) {
        super(name, size);
    }

    public QuerySequence(String name, int size, int initialValue) {
        super(name, size, initialValue);
    }

    public QuerySequence(boolean shouldAcquireValueAfterInsert, boolean shouldUseTransaction) {
        this.setShouldAcquireValueAfterInsert(shouldAcquireValueAfterInsert);
        this.setShouldUseTransaction(shouldUseTransaction);
    }

    public QuerySequence(String name, boolean shouldAcquireValueAfterInsert, boolean shouldUseTransaction) {
        super(name);
        this.setShouldAcquireValueAfterInsert(shouldAcquireValueAfterInsert);
        this.setShouldUseTransaction(shouldUseTransaction);
    }

    public QuerySequence(String name, int size, boolean shouldAcquireValueAfterInsert, boolean shouldUseTransaction) {
        super(name, size);
        this.setShouldAcquireValueAfterInsert(shouldAcquireValueAfterInsert);
        this.setShouldUseTransaction(shouldUseTransaction);
    }

    public QuerySequence(String name, int size, int initialValue, boolean shouldAcquireValueAfterInsert, boolean shouldUseTransaction) {
        super(name, size, initialValue);
        this.setShouldAcquireValueAfterInsert(shouldAcquireValueAfterInsert);
        this.setShouldUseTransaction(shouldUseTransaction);
    }

    public boolean equals(Object obj) {
        if (obj instanceof QuerySequence && super.equals(obj)) {
            QuerySequence other = (QuerySequence)obj;
            return this.getSelectQuery() == other.getSelectQuery() && this.getUpdateQuery() == other.getUpdateQuery() && this.shouldAcquireValueAfterInsert() == other.shouldAcquireValueAfterInsert() && this.shouldUseTransaction() == other.shouldUseTransaction() && this.shouldSkipUpdate() == other.shouldSkipUpdate() && this.shouldSelectBeforeUpdate() == other.shouldSelectBeforeUpdate();
        }
        return false;
    }

    public boolean shouldAcquireValueAfterInsert() {
        return this.shouldAcquireValueAfterInsert;
    }

    public void setShouldAcquireValueAfterInsert(boolean shouldAcquireValueAfterInsert) {
        this.shouldAcquireValueAfterInsert = shouldAcquireValueAfterInsert;
    }

    public boolean shouldUseTransaction() {
        return this.shouldUseTransaction;
    }

    public void setShouldUseTransaction(boolean shouldUseTransaction) {
        this.shouldUseTransaction = shouldUseTransaction;
    }

    public void setSelectQuery(ValueReadQuery query) {
        this.selectQuery = query;
    }

    public ValueReadQuery getSelectQuery() {
        return this.selectQuery;
    }

    public void setUpdateQuery(DataModifyQuery query) {
        this.updateQuery = query;
    }

    public DataModifyQuery getUpdateQuery() {
        return this.updateQuery;
    }

    public void setShouldSkipUpdate(boolean shouldSkipUpdate) {
        this.shouldSkipUpdate = shouldSkipUpdate;
    }

    public boolean shouldSkipUpdate() {
        return this.shouldSkipUpdate;
    }

    public void setShouldSelectBeforeUpdate(boolean shouldSelectBeforeUpdate) {
        this.shouldSelectBeforeUpdate = shouldSelectBeforeUpdate;
    }

    public boolean shouldSelectBeforeUpdate() {
        return this.shouldSelectBeforeUpdate;
    }

    protected ValueReadQuery buildSelectQuery() {
        return null;
    }

    protected DataModifyQuery buildUpdateQuery() {
        return null;
    }

    protected ValueReadQuery buildSelectQuery(String seqName, Integer size) {
        return null;
    }

    protected DataModifyQuery buildUpdateQuery(String seqName, Number sizeOrNewValue) {
        return null;
    }

    public void onConnect() {
        super.onConnect();
        if (this.getSelectQuery() == null) {
            this.setSelectQuery(this.buildSelectQuery());
            boolean bl = this.wasSelectQueryCreated = this.getSelectQuery() != null;
        }
        if (this.getUpdateQuery() == null && !this.shouldSkipUpdate()) {
            this.setUpdateQuery(this.buildUpdateQuery());
            this.wasUpdateQueryCreated = this.getUpdateQuery() != null;
        }
    }

    public void onDisconnect() {
        if (this.wasSelectQueryCreated) {
            this.setSelectQuery(null);
            this.wasSelectQueryCreated = false;
        }
        if (this.wasUpdateQueryCreated) {
            this.setUpdateQuery(null);
            this.wasUpdateQueryCreated = false;
        }
        super.onDisconnect();
    }

    protected Number updateAndSelectSequence(Accessor accessor, AbstractSession writeSession, String seqName, int size) {
        Integer sizeInteger = new Integer(size);
        if (this.shouldSkipUpdate()) {
            return (Number)this.select(accessor, writeSession, seqName, sizeInteger);
        }
        if (this.shouldSelectBeforeUpdate()) {
            BigDecimal currentValue;
            Object result = this.select(accessor, writeSession, seqName, sizeInteger);
            if (result instanceof Number) {
                currentValue = new BigDecimal(((Number)result).longValue());
            } else if (result instanceof String) {
                currentValue = new BigDecimal((String)result);
            } else if (result instanceof Record) {
                Object val = ((Record)result).get("text()");
                currentValue = new BigDecimal((String)val);
            } else {
                return null;
            }
            BigDecimal newValue = currentValue.add(new BigDecimal(size));
            this.update(accessor, writeSession, seqName, newValue);
            return newValue;
        }
        this.update(accessor, writeSession, seqName, sizeInteger);
        return (Number)this.select(accessor, writeSession, seqName, sizeInteger);
    }

    protected Object select(Accessor accessor, AbstractSession writeSession, String seqName, Integer size) {
        Vector args;
        ValueReadQuery query = this.getSelectQuery();
        if (query != null) {
            if (accessor != null) {
                query = (ValueReadQuery)query.clone();
                query.setAccessor(accessor);
            }
        } else {
            query = this.buildSelectQuery(seqName, size);
            if (accessor != null) {
                query.setAccessor(accessor);
            }
        }
        if ((args = this.createArguments(query, seqName, size)) != null) {
            return writeSession.executeQuery((DatabaseQuery)query, args);
        }
        return writeSession.executeQuery(query);
    }

    protected void update(Accessor accessor, AbstractSession writeSession, String seqName, Number sizeOrNewValue) {
        Vector args;
        DataModifyQuery query = this.getUpdateQuery();
        if (query != null) {
            if (accessor != null) {
                query = (DataModifyQuery)query.clone();
                query.setAccessor(accessor);
            }
        } else {
            query = this.buildUpdateQuery(seqName, sizeOrNewValue);
            if (query == null) {
                return;
            }
            if (accessor != null) {
                query.setAccessor(accessor);
            }
        }
        if ((args = this.createArguments(query, seqName, sizeOrNewValue)) != null) {
            writeSession.executeQuery((DatabaseQuery)query, args);
        } else {
            writeSession.executeQuery(query);
        }
    }

    protected Vector createArguments(DatabaseQuery query, String seqName, Number sizeOrNewValue) {
        int nArgs = query.getArguments().size();
        if (nArgs > 0) {
            Vector<Object> args = new Vector<Object>(nArgs);
            args.addElement(seqName);
            if (nArgs > 1) {
                args.addElement(sizeOrNewValue);
            }
            return args;
        }
        return null;
    }
}

