/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.queryframework;

import java.util.List;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.OptimisticLockException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.expressions.ForUpdateClause;
import oracle.toplink.essentials.internal.expressions.ForUpdateOfClause;
import oracle.toplink.essentials.internal.expressions.ObjectExpression;
import oracle.toplink.essentials.internal.expressions.QueryKeyExpression;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.helper.IdentityHashtable;
import oracle.toplink.essentials.internal.helper.InvalidObject;
import oracle.toplink.essentials.internal.helper.NonSynchronizedVector;
import oracle.toplink.essentials.internal.queryframework.DatabaseQueryMechanism;
import oracle.toplink.essentials.internal.queryframework.ExpressionQueryMechanism;
import oracle.toplink.essentials.internal.queryframework.JoinedAttributeManager;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.AggregateObjectMapping;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.ForeignReferenceMapping;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.FetchGroup;
import oracle.toplink.essentials.queryframework.InMemoryQueryIndirectionPolicy;
import oracle.toplink.essentials.queryframework.ObjectBuildingQuery;
import oracle.toplink.essentials.querykeys.ForeignReferenceQueryKey;
import oracle.toplink.essentials.querykeys.QueryKey;
import oracle.toplink.essentials.sessions.Session;

public abstract class ObjectLevelReadQuery
extends ObjectBuildingQuery {
    protected ExpressionBuilder defaultBuilder;
    protected boolean shouldRefreshIdentityMapResult = false;
    protected int cacheUsage = -1;
    public static final int UseDescriptorSetting = -1;
    public static final int DoNotCheckCache = 0;
    public static final int CheckCacheByExactPrimaryKey = 1;
    public static final int CheckCacheByPrimaryKey = 2;
    public static final int CheckCacheThenDatabase = 3;
    public static final int CheckCacheOnly = 4;
    public static final int ConformResultsInUnitOfWork = 5;
    protected boolean shouldRegisterResultsInUnitOfWork = true;
    protected Vector additionalFields;
    protected boolean shouldIncludeData = false;
    protected boolean shouldProcessResultsInUnitOfWork = true;
    protected short distinctState = 0;
    public static final short UNCOMPUTED_DISTINCT = 0;
    public static final short USE_DISTINCT = 1;
    public static final short DONT_USE_DISTINCT = 2;
    protected InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy;
    protected long executionTime = 0L;
    public static final String LOCK_RESULT_PROPERTY = "LOCK_RESULT";
    protected FetchGroup fetchGroup;
    protected String fetchGroupName;
    protected boolean shouldUseDefaultFetchGroup = true;
    protected boolean wasDefaultLockMode = false;
    protected Vector nonFetchJoinAttributeExpressions;
    protected JoinedAttributeManager joinedAttributeManager = new JoinedAttributeManager(this.getDescriptor(), this.getExpressionBuilder(), this);

    public ObjectLevelReadQuery() {
        this.additionalFields = NonSynchronizedVector.newInstance(1);
        this.inMemoryQueryIndirectionPolicy = new InMemoryQueryIndirectionPolicy();
    }

    protected boolean wasDefaultLockMode() {
        return this.wasDefaultLockMode;
    }

    protected void setWasDefaultLockMode(boolean wasDefaultLockMode) {
        this.wasDefaultLockMode = wasDefaultLockMode;
    }

    public Object clone() {
        ObjectLevelReadQuery cloneQuery = (ObjectLevelReadQuery)super.clone();
        cloneQuery.joinedAttributeManager = (JoinedAttributeManager)cloneQuery.getJoinedAttributeManager().clone();
        if (this.hasNonFetchJoinedAttributeExpressions()) {
            cloneQuery.setNonFetchJoinAttributeExpressions((Vector)this.nonFetchJoinAttributeExpressions.clone());
        }
        cloneQuery.joinedAttributeManager.setBaseQuery(cloneQuery);
        return cloneQuery;
    }

    public Object deepClone() {
        ObjectLevelReadQuery clone = (ObjectLevelReadQuery)this.clone();
        if (this.getSelectionCriteria() != null) {
            clone.setSelectionCriteria((Expression)this.getSelectionCriteria().clone());
        } else if (this.defaultBuilder != null) {
            clone.defaultBuilder = (ExpressionBuilder)this.defaultBuilder.clone();
        }
        return clone;
    }

    public void acquireLocks() {
        this.setLockMode((short)1);
        this.setIsPrepared(false);
    }

    public void acquireLocksWithoutWaiting() {
        this.setLockMode((short)2);
        this.setIsPrepared(false);
    }

    public void addAdditionalField(DatabaseField field) {
        this.getAdditionalFields().addElement(field);
        this.setIsPrepared(false);
    }

    public void addAdditionalField(Expression fieldExpression) {
        this.getAdditionalFields().addElement(fieldExpression);
        this.setIsPrepared(false);
    }

    public void addJoinedAttribute(String attributeName) {
        this.addJoinedAttribute(this.getExpressionBuilder().get(attributeName));
    }

    public void addJoinedAttribute(Expression attributeExpression) {
        this.getJoinedAttributeManager().addJoinedAttributeExpression(attributeExpression);
        this.setIsPrePrepared(false);
    }

    public void addNonFetchJoinedAttribute(String attributeName) {
        this.addNonFetchJoinedAttribute(this.getExpressionBuilder().get(attributeName));
    }

    public void addNonFetchJoinedAttribute(Expression attributeExpression) {
        this.getNonFetchJoinAttributeExpressions().add(attributeExpression);
        this.setIsPrePrepared(false);
    }

    protected void addSelectionFieldsForJoinedExpressions(List fields, List joinedExpressions) {
        for (int index = 0; index < joinedExpressions.size(); ++index) {
            ObjectExpression objectExpression = (ObjectExpression)joinedExpressions.get(index);
            objectExpression.getBuilder().setSession(this.getSession());
            objectExpression.getBuilder().setQueryClass(this.getReferenceClass());
            ClassDescriptor descriptor = objectExpression.getMapping().getReferenceDescriptor();
            fields.addAll(descriptor.getFields());
        }
    }

    public Object buildObject(AbstractRecord row) {
        return this.getDescriptor().getObjectBuilder().buildObject(this, row, this.getJoinedAttributeManager());
    }

    public void checkCacheOnly() {
        this.setCacheUsage(4);
    }

    public void checkDescriptor(AbstractSession session) throws QueryException {
        if (this.getReferenceClass() == null) {
            throw QueryException.referenceClassMissing(this);
        }
        if (this.getDescriptor() == null) {
            ClassDescriptor referenceDescriptor = session.getDescriptor(this.getReferenceClass());
            if (referenceDescriptor == null) {
                throw QueryException.descriptorIsMissing(this.getReferenceClass(), this);
            }
            this.setDescriptor(referenceDescriptor);
        }
    }

    protected abstract Object checkEarlyReturnImpl(AbstractSession var1, AbstractRecord var2);

    public Object checkEarlyReturn(AbstractSession session, AbstractRecord translationRow) {
        Object result;
        this.checkPrePrepare(session);
        if (!session.isUnitOfWork()) {
            return this.checkEarlyReturnImpl(session, translationRow);
        }
        UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)session;
        if ((this.shouldCheckCacheOnly() || this.shouldConformResultsInUnitOfWork() || this.getDescriptor().shouldAlwaysConformResultsInUnitOfWork() || this.getLockMode() != 0) && (result = this.checkEarlyReturnImpl(unitOfWork, translationRow)) != null) {
            return result;
        }
        if (this.isReadObjectQuery() && this.isLockQuery()) {
            return null;
        }
        AbstractSession parentSession = unitOfWork.getParentIdentityMapSession(this);
        Object result2 = this.checkEarlyReturn(parentSession, translationRow);
        if (result2 != null) {
            if (result2 == InvalidObject.instance) {
                return result2;
            }
            return this.registerResultInUnitOfWork(result2, unitOfWork, translationRow, false);
        }
        return null;
    }

    public void checkPrepare(AbstractSession session, AbstractRecord translationRow) {
        this.checkPrePrepare(session);
        super.checkPrepare(session, translationRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPrePrepare(AbstractSession session) {
        this.checkDescriptor(session);
        if (!this.isPrePrepared()) {
            ObjectLevelReadQuery objectLevelReadQuery = this;
            synchronized (objectLevelReadQuery) {
                if (!this.isPrePrepared()) {
                    AbstractSession alreadySetSession = this.getSession();
                    this.setSession(session);
                    this.prePrepare();
                    this.setSession(alreadySetSession);
                    this.setIsPrePrepared(true);
                }
            }
        }
    }

    public void changeDescriptor(AbstractSession theSession) {
        this.setDescriptor(null);
        this.checkDescriptor(theSession);
    }

    protected Object conformIndividualResult(Object result, UnitOfWorkImpl unitOfWork, AbstractRecord arguments, Expression selectionCriteriaClone, IdentityHashtable alreadyReturned, boolean buildDirectlyFromRows) {
        Object clone = this.registerIndividualResult(result, unitOfWork, buildDirectlyFromRows);
        if (this.getDescriptor().hasWrapperPolicy() && this.getDescriptor().getWrapperPolicy().isWrapped(clone)) {
            return clone;
        }
        if (unitOfWork.isObjectDeleted(clone)) {
            return null;
        }
        if (!this.isExpressionQuery() || selectionCriteriaClone == null) {
            if (alreadyReturned != null) {
                alreadyReturned.remove(clone);
            }
            return clone;
        }
        try {
            InMemoryQueryIndirectionPolicy policy = this.getInMemoryQueryIndirectionPolicy();
            if (!policy.shouldTriggerIndirection()) {
                policy = new InMemoryQueryIndirectionPolicy(2);
            }
            if (selectionCriteriaClone.doesConform(clone, unitOfWork, arguments, policy)) {
                if (alreadyReturned != null) {
                    alreadyReturned.remove(clone);
                }
                return clone;
            }
        }
        catch (QueryException exception) {
            if (unitOfWork.getShouldThrowConformExceptions() == 1 && exception.getErrorCode() != 6092) {
                throw exception;
            }
            if (alreadyReturned != null) {
                alreadyReturned.remove(clone);
            }
            return clone;
        }
        return null;
    }

    public void conformResultsInUnitOfWork() {
        this.setCacheUsage(5);
    }

    public void dontAcquireLocks() {
        this.setLockMode((short)0);
        this.setIsPrepared(false);
    }

    public void dontCheckCache() {
        this.setCacheUsage(0);
    }

    public void dontRefreshIdentityMapResult() {
        this.setShouldRefreshIdentityMapResult(false);
    }

    public void dontUseDistinct() {
        this.setDistinctState((short)2);
        this.setIsPrepared(false);
    }

    public DatabaseQuery prepareOutsideUnitOfWork(AbstractSession session) {
        if (this.isLockQuery(session) && this.getLockingClause().isForUpdateOfClause()) {
            ObjectLevelReadQuery clone = (ObjectLevelReadQuery)this.clone();
            clone.dontAcquireLocks();
            clone.setIsPrepared(false);
            clone.checkPrePrepare(session);
            return clone;
        }
        return this;
    }

    public Object execute(AbstractSession session, AbstractRecord translationRow) throws DatabaseException, OptimisticLockException {
        if (this.shouldRefreshIdentityMapResult() && this.shouldCheckCacheOnly()) {
            throw QueryException.refreshNotPossibleWithCheckCacheOnly(this);
        }
        return super.execute(session, translationRow);
    }

    public Object executeDatabaseQuery() throws DatabaseException {
        if (this.getSession().isUnitOfWork()) {
            UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)this.getSession();
            if (this.isLockQuery() && !unitOfWork.getCommitManager().isActive() && !unitOfWork.wasTransactionBegunPrematurely()) {
                unitOfWork.beginTransaction();
                unitOfWork.setWasTransactionBegunPrematurely(true);
            }
            if (unitOfWork.isNestedUnitOfWork()) {
                UnitOfWorkImpl nestedUnitOfWork = (UnitOfWorkImpl)this.getSession();
                this.setSession(nestedUnitOfWork.getParent());
                Object result = this.executeDatabaseQuery();
                this.setSession(nestedUnitOfWork);
                return this.registerResultInUnitOfWork(result, nestedUnitOfWork, this.getTranslationRow(), false);
            }
        }
        this.session.validateQuery(this);
        if (this.getQueryId() == 0L) {
            this.setQueryId(this.getSession().getNextQueryId());
        }
        return this.executeObjectLevelReadQuery();
    }

    protected abstract Object executeObjectLevelReadQuery() throws DatabaseException;

    public Object executeInUnitOfWork(UnitOfWorkImpl unitOfWork, AbstractRecord translationRow) throws DatabaseException, OptimisticLockException {
        if (!this.shouldMaintainCache()) {
            return unitOfWork.getParent().executeQuery((DatabaseQuery)this, translationRow);
        }
        Object result = this.execute(unitOfWork, translationRow);
        if (result == InvalidObject.instance) {
            return null;
        }
        return result;
    }

    public Vector getAdditionalFields() {
        return this.additionalFields;
    }

    public int getCacheUsage() {
        return this.cacheUsage;
    }

    public short getDistinctState() {
        return this.distinctState;
    }

    public ExpressionBuilder getExpressionBuilder() {
        if (this.defaultBuilder == null) {
            this.initializeDefaultBuilder();
        }
        return this.defaultBuilder;
    }

    public void setExpressionBuilder(ExpressionBuilder builder) {
        this.defaultBuilder = builder;
    }

    public InMemoryQueryIndirectionPolicy getInMemoryQueryIndirectionPolicy() {
        return this.inMemoryQueryIndirectionPolicy;
    }

    public JoinedAttributeManager getJoinedAttributeManager() {
        return this.joinedAttributeManager;
    }

    public Vector getNonFetchJoinAttributeExpressions() {
        if (this.nonFetchJoinAttributeExpressions == null) {
            this.nonFetchJoinAttributeExpressions = NonSynchronizedVector.newInstance();
        }
        return this.nonFetchJoinAttributeExpressions;
    }

    public DatabaseMapping getLeafMappingFor(Expression expression, ClassDescriptor rootDescriptor) throws QueryException {
        if (expression == null || expression.isFieldExpression()) {
            return null;
        }
        if (!expression.isQueryKeyExpression()) {
            return null;
        }
        QueryKeyExpression qkExpression = (QueryKeyExpression)expression;
        Expression baseExpression = qkExpression.getBaseExpression();
        ClassDescriptor descriptor = this.getLeafDescriptorFor(baseExpression, rootDescriptor);
        return descriptor.getMappingForAttributeName(qkExpression.getName());
    }

    public ClassDescriptor getLeafDescriptorFor(Expression expression, ClassDescriptor rootDescriptor) throws QueryException {
        if (expression.isExpressionBuilder()) {
            Class queryClass = ((ExpressionBuilder)expression).getQueryClass();
            if (queryClass != null && queryClass != this.getReferenceClass()) {
                return this.getSession().getDescriptor(queryClass);
            }
            return rootDescriptor;
        }
        Expression baseExpression = ((QueryKeyExpression)expression).getBaseExpression();
        ClassDescriptor baseDescriptor = this.getLeafDescriptorFor(baseExpression, rootDescriptor);
        ClassDescriptor descriptor = null;
        String attributeName = expression.getName();
        DatabaseMapping mapping = baseDescriptor.getMappingForAttributeName(attributeName);
        if (mapping == null) {
            QueryKey queryKey = baseDescriptor.getQueryKeyNamed(attributeName);
            if (queryKey != null) {
                descriptor = queryKey.isForeignReferenceQueryKey() ? this.getSession().getDescriptor(((ForeignReferenceQueryKey)queryKey).getReferenceClass()) : queryKey.getDescriptor();
            }
            if (descriptor == null) {
                throw QueryException.invalidExpressionForQueryItem(expression, this);
            }
        } else if (mapping.isAggregateObjectMapping()) {
            descriptor = ((AggregateObjectMapping)mapping).getReferenceDescriptor();
        } else if (mapping.isForeignReferenceMapping()) {
            descriptor = ((ForeignReferenceMapping)mapping).getReferenceDescriptor();
        }
        return descriptor;
    }

    public short getLockMode() {
        if (this.lockingClause == null) {
            return -1;
        }
        return this.lockingClause.getLockMode();
    }

    public ForUpdateClause getLockingClause() {
        return this.lockingClause;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public Class getReferenceClass() {
        return super.getReferenceClass();
    }

    public String getReferenceClassName() {
        return super.getReferenceClassName();
    }

    public boolean hasAsOfClause() {
        return this.defaultBuilder != null && this.defaultBuilder.hasAsOfClause();
    }

    public boolean hasNonFetchJoinedAttributeExpressions() {
        return this.nonFetchJoinAttributeExpressions != null && !this.nonFetchJoinAttributeExpressions.isEmpty();
    }

    public boolean hasPartialAttributeExpressions() {
        return false;
    }

    public Vector getSelectionFields() {
        Vector fields;
        if (!(this.hasPartialAttributeExpressions() || this.getJoinedAttributeManager().hasJoinedAttributes() || this.hasFetchGroupAttributeExpressions())) {
            return this.getDescriptor().getAllFields();
        }
        if (this.hasFetchGroupAttributeExpressions()) {
            List fetchGroupAttrExps = this.getFetchGroup().getFetchGroupAttributeExpressions();
            fields = new Vector(fetchGroupAttrExps.size());
            for (int index = 0; index < fetchGroupAttrExps.size(); ++index) {
                Expression expression = (Expression)fetchGroupAttrExps.get(index);
                expression.getBuilder().setSession(this.getSession());
                expression.getBuilder().setQueryClass(this.getReferenceClass());
                Helper.addAllToVector(fields, expression.getFields());
            }
        } else {
            fields = new Vector(this.getDescriptor().getAllFields().size() + this.getJoinedAttributeManager().getJoinedAttributeExpressions().size() + this.getJoinedAttributeManager().getJoinedMappingExpressions().size());
            Helper.addAllToVector(fields, this.getDescriptor().getAllFields());
            this.addSelectionFieldsForJoinedExpressions(fields, this.getJoinedAttributeManager().getJoinedAttributeExpressions());
            this.addSelectionFieldsForJoinedExpressions(fields, this.getJoinedAttributeManager().getJoinedMappingExpressions());
        }
        return fields;
    }

    protected void initializeDefaultBuilder() {
        DatabaseQueryMechanism mech = this.getQueryMechanism();
        if (mech.isExpressionQueryMechanism() && ((ExpressionQueryMechanism)mech).getExpressionBuilder() != null) {
            this.defaultBuilder = ((ExpressionQueryMechanism)mech).getExpressionBuilder();
            return;
        }
        this.defaultBuilder = new ExpressionBuilder();
    }

    public boolean isDistinctComputed() {
        return this.getDistinctState() != 0;
    }

    public boolean isLockQuery() {
        return this.getLockMode() > 0;
    }

    public boolean isLockQuery(Session session) {
        this.checkPrePrepare((AbstractSession)session);
        return this.isLockQuery();
    }

    public boolean isObjectLevelReadQuery() {
        return true;
    }

    protected boolean isPrePrepared() {
        return this.isPrePrepared;
    }

    protected boolean isRegisteringResults() {
        return this.shouldRegisterResultsInUnitOfWork() && this.getDescriptor().shouldRegisterResultsInUnitOfWork() || this.isLockQuery();
    }

    protected void setIsPrePrepared(boolean isPrePrepared) {
        if (this.isPrePrepared && !isPrePrepared) {
            this.setIsPrepared(false);
            this.getJoinedAttributeManager().reset();
        }
        this.isPrePrepared = isPrePrepared;
    }

    protected void prepare() throws QueryException {
        super.prepare();
        this.prepareQuery();
        this.getJoinedAttributeManager().computeJoiningMappingQueries(this.getSession());
    }

    protected void prePrepare() throws QueryException {
        this.buildSelectionCriteria(this.session);
        this.checkDescriptor(this.session);
        if (this.getQueryMechanism().isExpressionQueryMechanism()) {
            this.getJoinedAttributeManager().processJoinedMappings();
        }
        if (this.isDefaultLock()) {
            this.setWasDefaultLockMode(true);
            ForUpdateOfClause lockingClause = null;
            if (this.getJoinedAttributeManager().hasJoinedExpressions()) {
                lockingClause = this.getJoinedAttributeManager().setupLockingClauseForJoinedExpressions(lockingClause, this.getSession());
            }
            if (lockingClause == null) {
                this.lockingClause = ForUpdateClause.newInstance((short)0);
            } else {
                this.lockingClause = lockingClause;
                this.dontUseDistinct();
            }
        } else if (this.getLockMode() == 0) {
            this.setWasDefaultLockMode(true);
        }
    }

    protected void prepareQuery() throws QueryException {
        if (!this.shouldMaintainCache() && this.shouldRefreshIdentityMapResult() && !this.descriptor.isAggregateCollectionDescriptor()) {
            throw QueryException.refreshNotPossibleWithoutCache(this);
        }
        if (this.shouldMaintainCache() && this.hasPartialAttributeExpressions()) {
            throw QueryException.cannotCachePartialObjects(this);
        }
        if (this.descriptor.isAggregateDescriptor()) {
            throw QueryException.aggregateObjectCannotBeDeletedOrWritten(this.descriptor, this);
        }
        if (!(this.getDescriptor().hasFetchGroupManager() || this.getFetchGroup() == null && this.getFetchGroupName() == null)) {
            throw QueryException.fetchGroupValidOnlyIfFetchGroupManagerInDescriptor(this.getDescriptor().getJavaClassName(), this.getName());
        }
        if (this.getDescriptor().hasFetchGroupManager()) {
            this.getDescriptor().getFetchGroupManager().prepareQueryWithFetchGroup(this);
        }
        if (this.getJoinedAttributeManager().hasJoinedExpressions()) {
            this.getJoinedAttributeManager().prepareJoinExpressions(this.getSession());
        } else {
            this.getJoinedAttributeManager().reset();
        }
    }

    public void refreshIdentityMapResult() {
        this.setShouldRefreshIdentityMapResult(true);
    }

    public abstract Object registerResultInUnitOfWork(Object var1, UnitOfWorkImpl var2, AbstractRecord var3, boolean var4);

    public void resetDistinct() {
        this.setDistinctState((short)0);
        this.setIsPrepared(false);
    }

    public void setAdditionalFields(Vector additionalFields) {
        this.additionalFields = additionalFields;
    }

    public void setCacheUsage(int cacheUsage) {
        this.cacheUsage = cacheUsage;
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        super.setDescriptor(descriptor);
        if (this.joinedAttributeManager != null) {
            this.joinedAttributeManager.setDescriptor(descriptor);
        }
    }

    public void setDistinctState(short distinctState) {
        this.distinctState = distinctState;
    }

    public void setExecutionTime(long executionTime) {
        this.executionTime = executionTime;
    }

    public void setInMemoryQueryIndirectionPolicy(InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy) {
        if (inMemoryQueryIndirectionPolicy != null) {
            this.inMemoryQueryIndirectionPolicy = inMemoryQueryIndirectionPolicy;
        }
    }

    public void setLockMode(short lockMode) {
        if (lockMode == 1 || lockMode == 2) {
            this.lockingClause = ForUpdateClause.newInstance(lockMode);
            this.setShouldRefreshIdentityMapResult(true);
        } else if (lockMode == 0) {
            this.lockingClause = ForUpdateClause.newInstance(lockMode);
        } else {
            this.lockingClause = null;
            this.setIsPrePrepared(false);
        }
        this.setIsPrepared(false);
    }

    protected void setNonFetchJoinAttributeExpressions(Vector nonFetchJoinExpressions) {
        this.nonFetchJoinAttributeExpressions = nonFetchJoinExpressions;
    }

    public void setLockingClause(ForUpdateClause clause) {
        if (clause.isForUpdateOfClause()) {
            this.lockingClause = clause;
            this.setIsPrePrepared(false);
        } else {
            this.setLockMode(clause.getLockMode());
        }
    }

    public void setEJBQLString(String ejbqlString) {
        super.setEJBQLString(ejbqlString);
        this.setIsPrePrepared(false);
    }

    public void setReferenceClass(Class aClass) {
        super.setReferenceClass(aClass);
    }

    public void setReferenceClassName(String aClass) {
        super.setReferenceClassName(aClass);
    }

    public void setSelectionCriteria(Expression expression) {
        ExpressionBuilder newBuilder;
        super.setSelectionCriteria(expression);
        if (expression != null && this.defaultBuilder != null && (newBuilder = expression.getBuilder()) != this.defaultBuilder && (newBuilder.getQueryClass() == null || newBuilder.getQueryClass().equals(this.defaultBuilder.getQueryClass()))) {
            this.defaultBuilder = newBuilder;
        }
    }

    public void setShouldIncludeData(boolean shouldIncludeData) {
        this.shouldIncludeData = shouldIncludeData;
    }

    public void setShouldRefreshIdentityMapResult(boolean shouldRefreshIdentityMapResult) {
        this.shouldRefreshIdentityMapResult = shouldRefreshIdentityMapResult;
    }

    public void setShouldRegisterResultsInUnitOfWork(boolean shouldRegisterResultsInUnitOfWork) {
        this.shouldRegisterResultsInUnitOfWork = shouldRegisterResultsInUnitOfWork;
    }

    public boolean shouldCheckCacheOnly() {
        return this.getCacheUsage() == 4;
    }

    public boolean shouldCheckDescriptorForCacheUsage() {
        return this.getCacheUsage() == -1;
    }

    public boolean shouldConformResultsInUnitOfWork() {
        return this.getCacheUsage() == 5;
    }

    public boolean shouldDistinctBeUsed() {
        return this.getDistinctState() == 1;
    }

    public boolean shouldIncludeData() {
        return this.shouldIncludeData;
    }

    public boolean shouldRegisterResultsInUnitOfWork() {
        return this.shouldRegisterResultsInUnitOfWork;
    }

    public boolean shouldReadAllMappings() {
        return !this.hasPartialAttributeExpressions() && !this.hasFetchGroupAttributeExpressions();
    }

    public boolean shouldReadMapping(DatabaseMapping mapping) {
        if (!this.hasPartialAttributeExpressions() && !this.hasFetchGroupAttributeExpressions()) {
            return true;
        }
        if (this.hasFetchGroupAttributeExpressions()) {
            return this.isFetchGroupAttribute(mapping.getAttributeName());
        }
        return true;
    }

    public boolean shouldRefreshIdentityMapResult() {
        return this.shouldRefreshIdentityMapResult;
    }

    public String toString() {
        if (this.getReferenceClass() == null) {
            return super.toString();
        }
        return Helper.getShortClassName(this.getClass()) + "(" + this.getReferenceClass().getName() + ")";
    }

    public void setShouldProcessResultsInUnitOfWork(boolean processResultsInUnitOfWork) {
        this.shouldProcessResultsInUnitOfWork = processResultsInUnitOfWork;
    }

    public boolean shouldProcessResultsInUnitOfWork() {
        return this.shouldProcessResultsInUnitOfWork;
    }

    public void useDistinct() {
        this.setDistinctState((short)1);
        this.setIsPrepared(false);
    }

    public boolean isClonePessimisticLocked(Object clone, UnitOfWorkImpl uow) {
        return false;
    }

    public void recordCloneForPessimisticLocking(Object clone, UnitOfWorkImpl uow) {
        if (this.isLockQuery() && this.lockingClause.isReferenceClassLocked()) {
            uow.addPessimisticLockedClone(clone);
        }
    }

    public boolean isDefaultLock() {
        return this.lockingClause == null;
    }

    public FetchGroup getFetchGroup() {
        return this.fetchGroup;
    }

    public void initializeFetchGroup() {
        if (this.fetchGroup != null) {
            return;
        }
        if (this.fetchGroupName != null) {
            this.fetchGroup = this.getDescriptor().getFetchGroupManager().getFetchGroup(this.fetchGroupName);
            if (this.fetchGroup == null) {
                throw QueryException.fetchGroupNotDefinedInDescriptor(this.fetchGroupName);
            }
        } else if (this.shouldUseDefaultFetchGroup()) {
            this.fetchGroup = this.getDescriptor().getDefaultFetchGroup();
        }
    }

    public void setFetchGroup(FetchGroup newFetchGroup) {
        this.fetchGroup = newFetchGroup;
    }

    public void setFetchGroupName(String groupName) {
        this.fetchGroup = null;
        this.fetchGroupName = groupName;
    }

    public String getFetchGroupName() {
        return this.fetchGroupName;
    }

    public boolean shouldUseDefaultFetchGroup() {
        return this.shouldUseDefaultFetchGroup;
    }

    public void setShouldUseDefaultFetchGroup(boolean shouldUseDefaultFetchGroup) {
        this.shouldUseDefaultFetchGroup = shouldUseDefaultFetchGroup;
    }

    public boolean hasFetchGroupAttributeExpressions() {
        return this.getFetchGroup() != null && this.getFetchGroup().hasFetchGroupAttributeExpressions();
    }

    public boolean isFetchGroupAttribute(String attributeName) {
        if (this.getFetchGroup() == null) {
            return true;
        }
        return this.getFetchGroup().getAttributes().contains(attributeName);
    }
}

