/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing.ejbql;

import java.util.Vector;
import oracle.toplink.essentials.exceptions.EJBQLException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.internal.parsing.NodeFactory;
import oracle.toplink.essentials.internal.parsing.NodeFactoryImpl;
import oracle.toplink.essentials.internal.parsing.ParseTree;
import oracle.toplink.essentials.internal.parsing.ejbql.EJBQLParser;
import persistence.antlr.ANTLRException;
import persistence.antlr.LLkParser;
import persistence.antlr.MismatchedCharException;
import persistence.antlr.MismatchedTokenException;
import persistence.antlr.NoViableAltException;
import persistence.antlr.NoViableAltForCharException;
import persistence.antlr.ParserSharedInputState;
import persistence.antlr.RecognitionException;
import persistence.antlr.Token;
import persistence.antlr.TokenBuffer;
import persistence.antlr.TokenStream;
import persistence.antlr.TokenStreamRecognitionException;

public class EJBQLParserBase
extends LLkParser {
    private boolean verbose = false;
    private Vector errors;
    private String theEjbql = null;
    protected static final int EOF_CHAR = 65535;
    protected NodeFactory factory;

    protected EJBQLParserBase(TokenBuffer tokenBuf, int k_) {
        super(tokenBuf, k_);
        this.initialize();
    }

    public EJBQLParserBase(ParserSharedInputState state, int k_) {
        super(state, k_);
    }

    protected EJBQLParserBase(TokenStream lexer, int k) {
        super(lexer, k);
    }

    public void setNodeFactory(NodeFactory factory) {
        this.factory = factory;
    }

    public NodeFactory getNodeFactory() {
        return this.factory;
    }

    public ParseTree getParseTree() {
        return (ParseTree)this.getRootNode();
    }

    public Object getRootNode() {
        return null;
    }

    public void addError(EJBQLException e) {
        this.getErrors().add(e);
    }

    public void addError(Exception e) {
        this.addError(EJBQLException.generalParsingException(this.getEjbqlString(), e));
    }

    public static EJBQLParser buildParserFor(String ejbqlString) {
        return EJBQLParser.buildParserFor(ejbqlString);
    }

    public static ParseTree buildParseTree(String ejbqlString) throws Exception {
        EJBQLParser parser = EJBQLParserBase.buildParserFor(ejbqlString);
        try {
            parser.document();
        }
        catch (Exception e) {
            parser.addError(e);
        }
        if (parser.hasErrors()) {
            throw parser.generateException();
        }
        return parser.getParseTree();
    }

    public Exception generateException() {
        Exception firstException = (Exception)this.getErrors().elementAt(0);
        if (firstException instanceof EJBQLException) {
            return firstException;
        }
        EJBQLException exception = EJBQLException.generalParsingException(this.getEjbqlString());
        exception.setInternalExceptions(this.getErrors());
        return exception;
    }

    private Vector getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.getErrors().isEmpty();
    }

    public void initialize() {
        this.setErrors(new Vector());
        this.setNodeFactory(new NodeFactoryImpl());
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void output(String output) {
        if (this.isVerbose()) {
            System.out.println(output);
        }
    }

    public void reportError(RecognitionException ex) {
        EJBQLException error = this.handleANTLRException(ex);
        this.addError(error);
    }

    protected EJBQLException handleANTLRException(ANTLRException ex) {
        EJBQLException result = null;
        if (ex instanceof MismatchedCharException) {
            MismatchedCharException mismatched = (MismatchedCharException)ex;
            if (mismatched.mismatchType == 1) {
                result = mismatched.foundChar == 65535 ? EJBQLException.unexpectedEOF(this.getEjbqlString()) : EJBQLException.expectedCharFound(this.getEjbqlString(), String.valueOf((char)mismatched.expecting), String.valueOf((char)mismatched.foundChar));
            }
        } else if (ex instanceof MismatchedTokenException) {
            MismatchedTokenException mismatched = (MismatchedTokenException)ex;
            Token token = mismatched.token;
            if (mismatched.mismatchType == 1 && token != null) {
                result = token.getType() == 1 ? EJBQLException.unexpectedEOF(this.getEjbqlString()) : EJBQLException.syntaxErrorAt(this.getEjbqlString(), token.getText());
            }
        } else if (ex instanceof NoViableAltException) {
            Token token = ((NoViableAltException)ex).token;
            if (token != null) {
                result = token.getType() == 1 ? EJBQLException.unexpectedEOF(this.getEjbqlString()) : EJBQLException.unexpectedToken(this.getEjbqlString(), token.getText());
            }
        } else if (ex instanceof NoViableAltForCharException) {
            NoViableAltForCharException noViableAlt = (NoViableAltForCharException)ex;
            result = EJBQLException.unexpectedChar(this.getEjbqlString(), String.valueOf(noViableAlt.foundChar));
        } else {
            result = ex instanceof TokenStreamRecognitionException ? this.handleANTLRException(((TokenStreamRecognitionException)ex).recog) : EJBQLException.syntaxError(this.getEjbqlString());
        }
        return result;
    }

    private void setErrors(Vector newErrors) {
        this.errors = newErrors;
    }

    public void setVerbose(boolean newVerbose) {
        this.verbose = newVerbose;
    }

    public short getDistinctState() {
        return this.getParseTree().getDistinctState();
    }

    public String getEjbqlString() {
        return this.theEjbql;
    }

    public void setEjbqlString(String theEjbql) {
        this.theEjbql = theEjbql;
    }

    public static EJBQLParser parseEJBQLString(String ejbqlString) throws QueryException {
        EJBQLParser parser = EJBQLParserBase.buildParserFor(ejbqlString);
        try {
            parser.document();
        }
        catch (EJBQLException e) {
            parser.addError(e);
        }
        catch (ANTLRException e) {
            parser.addError(parser.handleANTLRException(e));
        }
        catch (Exception e) {
            parser.addError(e);
        }
        if (parser.hasErrors()) {
            throw (EJBQLException)parser.generateException();
        }
        return parser;
    }
}

