"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _writableTrackingBuffer = _interopRequireDefault(require("../tracking-buffer/writable-tracking-buffer"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const TVP_ROW_TOKEN = Buffer.from([0x01]);
const TVP_END_TOKEN = Buffer.from([0x00]);
const NULL_LENGTH = Buffer.from([0xFF, 0xFF]);
const TVP = {
  id: 0xF3,
  type: 'TVPTYPE',
  name: 'TVP',
  declaration: function (parameter) {
    const value = parameter.value; // Temporary solution. Remove 'any' later.

    return value.name + ' readonly';
  },

  generateTypeInfo(parameter) {
    var _parameter$value, _parameter$value2;

    const databaseName = '';
    const schema = ((_parameter$value = parameter.value) === null || _parameter$value === void 0 ? void 0 : _parameter$value.schema) ?? '';
    const typeName = ((_parameter$value2 = parameter.value) === null || _parameter$value2 === void 0 ? void 0 : _parameter$value2.name) ?? '';
    const bufferLength = 1 + 1 + Buffer.byteLength(databaseName, 'ucs2') + 1 + Buffer.byteLength(schema, 'ucs2') + 1 + Buffer.byteLength(typeName, 'ucs2');
    const buffer = new _writableTrackingBuffer.default(bufferLength, 'ucs2');
    buffer.writeUInt8(this.id);
    buffer.writeBVarchar(databaseName);
    buffer.writeBVarchar(schema);
    buffer.writeBVarchar(typeName);
    return buffer.data;
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    const {
      columns
    } = parameter.value;
    const buffer = Buffer.alloc(2);
    buffer.writeUInt16LE(columns.length, 0);
    return buffer;
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      yield TVP_END_TOKEN;
      yield TVP_END_TOKEN;
      return;
    }

    const {
      columns,
      rows
    } = parameter.value;

    for (let i = 0, len = columns.length; i < len; i++) {
      const column = columns[i];
      const buff = Buffer.alloc(6); // UserType

      buff.writeUInt32LE(0x00000000, 0); // Flags

      buff.writeUInt16LE(0x0000, 4);
      yield buff; // TYPE_INFO

      yield column.type.generateTypeInfo(column); // ColName

      yield Buffer.from([0x00]);
    }

    yield TVP_END_TOKEN;

    for (let i = 0, length = rows.length; i < length; i++) {
      yield TVP_ROW_TOKEN;
      const row = rows[i];

      for (let k = 0, len2 = row.length; k < len2; k++) {
        const column = columns[k];
        const value = row[k];
        const param = {
          value: column.type.validate(value, parameter.collation),
          length: column.length,
          scale: column.scale,
          precision: column.precision
        }; // TvpColumnData

        yield column.type.generateParameterLength(param, options);
        yield* column.type.generateParameterData(param, options);
      }
    }

    yield TVP_END_TOKEN;
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (typeof value !== 'object') {
      throw new TypeError('Invalid table.');
    }

    if (!Array.isArray(value.columns)) {
      throw new TypeError('Invalid table.');
    }

    if (!Array.isArray(value.rows)) {
      throw new TypeError('Invalid table.');
    }

    return value;
  }
};
var _default = TVP;
exports.default = _default;
module.exports = TVP;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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