"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _intn = _interopRequireDefault(require("./intn"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const DATA_LENGTH = Buffer.from([0x02]);
const NULL_LENGTH = Buffer.from([0x00]);
const SmallInt = {
  id: 0x34,
  type: 'INT2',
  name: 'SmallInt',
  declaration: function () {
    return 'smallint';
  },

  generateTypeInfo() {
    return Buffer.from([_intn.default.id, 0x02]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    return DATA_LENGTH;
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    const buffer = Buffer.alloc(2);
    buffer.writeInt16LE(Number(parameter.value), 0);
    yield buffer;
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (typeof value !== 'number') {
      value = Number(value);
    }

    if (isNaN(value)) {
      throw new TypeError('Invalid number.');
    }

    if (value < -32768 || value > 32767) {
      throw new TypeError('Value must be between -32768 and 32767, inclusive.');
    }

    return value | 0;
  }
};
var _default = SmallInt;
exports.default = _default;
module.exports = SmallInt;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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