const clsHmiDetails = require('./hmiDetail.model');
const clsDatabase = require('../database/clsQueryProcess');
const globalData = require('../global/globalData')
const clsIndividual = require('./Test/clsIndividual.model');
const clsGroup = require('./Test/clsGroup.model');
const clsThickness = require('./Test/clsThickness.model');
const clsBreadth = require('./Test/clsBreadth.model');
const clsDiameter = require('./Test/clsDiameter.model');
const clsHardness = require('./Test/clsHardness.model');
const clsFriability = require('./Test/clsFriability.model');
const clsDTmodel = require('./Test/clsDT.model');
const clsLength = require('./Test/clsLength.model');
const serverConfig = require('../global/serverConfig');
const GLOBAL_NOMENCLATURE = require('../global/GLOBAL_NOMENCLATURE');
const clsConfigSettings = require('./clsConfigSettings');
const clsCommonInsertOperation = require('./Product/clsCommonInsertOperation.model');
const clsTappedDensity = require('./Test/clsTappedDensity.model');
const clsPercentageFine = require('./Test/clsPerFine.model');
const clsParticalSizing = require('./Test/clsParticalSizing.model');
const clsDifferential = require('./Test/clsDifferential.model');
const clsLod = require('./Test/clsLod.method');
// const { selectedBin, decideTareEmptyOrNot } = require('./IPC/ipc.model');
const Ipc = require('./IPC/ipc.model');
const clsEmptyShell = require('./Test/clsEmpty.model');
const IPC = require('./IPC/ipc.model');
const { tbl_cubical, tbl_cubicle_product_sample } = require('../../config/dbConnection').models;
const sequelize = require('../../config/dbConnection').sequelize;
const clsActivityLog = require("./clsActivityLog.model");
const clsMonit = require('./MonitorSocket/clsMonitSocket')
const objMonit = new clsMonit();
const objActivityLog = new clsActivityLog();
const database = new clsDatabase();
// const objIpc = new clsIpc();
const objLod = new clsLod();
const objHmi = new clsHmiDetails();
const objIndividual = new clsIndividual();
const objGroup = new clsGroup();
const objThickness = new clsThickness();
const objBreadth = new clsBreadth();
const objDiameter = new clsDiameter();
const objHardness = new clsHardness();
const objFriability = new clsFriability();
const objDT = new clsDTmodel();
const objLength = new clsLength();
const objConfigSettings = new clsConfigSettings();
const objCommonInsert = new clsCommonInsertOperation();
const objTappedDensity = new clsTappedDensity();
const objPercentageFine = new clsPercentageFine();
const objParticalSizing = new clsParticalSizing()
const objDifferential = new clsDifferential()
const objEmptyShell = new clsEmptyShell()
const ipcWeighment = new Ipc()

class WeighmentModel {

    async doubleRotary(data) {
        try {
            var responseobj = {}
            //globalData.arrside = data.Side;

            var tmppbckupobj = globalData.arrside.find(k => k.Hmi == data.Hmi);
            if (tmppbckupobj == undefined) {
                globalData.arrside.push({
                    Hmi: data.Hmi,
                    Side: data.Side,
                });
            } else {
                var index = globalData.arrside.findIndex(k => k.Hmi == data.Hmi);
                globalData.arrside[index].Side = data.Side;
            }
            if (data.Side != '' && data.Side != null) {
                Object.assign(responseobj, { status: 'success' }, { result: ('Side set to ' + data.Side) })


            }
            return responseobj;
        } catch (error) {
            throw new Error(error)
        }

    }

    async OnTestStart(value) {
        try {
            let strHmi = value.Hmi;
            let arrPortDetailForStart = await objHmi.getResbPiNoFromHmi(strHmi)
            let intIdsNo = arrPortDetailForStart[0].IDSNo;
            let intPortNo = arrPortDetailForStart[0].Sys_PortNo;
            let strstatus = "Weighment"
            let productData = value;
            let menuName = productData.menuName;
            let sampleNo = parseFloat(productData.noOfSample);
            let instrumentName = "";
            let responseObj = {};
            var objActivity = {};

            if (sampleNo !== "" && sampleNo !== undefined && (!isNaN(sampleNo))) {
                await objCommonInsert.updateSample(sampleNo, strHmi, menuName)
            }
            var OldsampleNo = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi).selectedProductDetail.noOfSamples;
            var tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
            if (menuName != GLOBAL_NOMENCLATURE.perFineMenu && menuName != GLOBAL_NOMENCLATURE.perFineLayer1Menu && menuName != GLOBAL_NOMENCLATURE.perFineLayer2Menu
                && menuName != GLOBAL_NOMENCLATURE.PSDMenu && menuName != GLOBAL_NOMENCLATURE.PSDLayer1Menu && menuName != GLOBAL_NOMENCLATURE.PSDLayer2Menu
                && menuName != GLOBAL_NOMENCLATURE.TDMenu && menuName != GLOBAL_NOMENCLATURE.TDLayer1Menu && menuName != GLOBAL_NOMENCLATURE.TDLayer2Menu
                && menuName != GLOBAL_NOMENCLATURE.FriabilatorMenu && menuName != GLOBAL_NOMENCLATURE.DTMenu && menuName != GLOBAL_NOMENCLATURE.DTLayer1Menu && menuName != GLOBAL_NOMENCLATURE.DTLayer2Menu
                && menuName != GLOBAL_NOMENCLATURE.LODMenu && menuName != GLOBAL_NOMENCLATURE.LODLayer1Menu && menuName != GLOBAL_NOMENCLATURE.LODLayer2Menu
            ) {

                if (sampleNo != OldsampleNo) {
                    var act = `${menuName} Sample Changes From ${OldsampleNo} To ${sampleNo} Update on TSH ${strHmi}`;

                    Object.assign(
                        objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { activity: act }
                    );
                    await objActivityLog.ActivityLogEntry(objActivity);
                }
            }
            if (value.isPowerBackup) {

                let tempPbkupObj = globalData.monitDetail.find(k => k.Hmi == strHmi);
                let sample = tempPbkupObj.data.length;
                let sampleExist = "";
                if (sample != 0) {
                    sampleExist = `from Sample No. ${sample} `
                }

                let objActivity = {};
                Object.assign(
                    objActivity,
                    { strUserId: value.userId },
                    { strUserName: value.userName },
                    { activity: `${menuName} Test Resumed on TSH ${strHmi} ${sampleExist}through PowerBackup` }
                );

                await objActivityLog.ActivityLogEntry(objActivity);
            }

                await objMonit.monit({
                case: 'TestStart',
                Hmi: strHmi,
                data: {
                    Product: productData.ProductId,
                    Batch: productData.Batch,
                    TestType: menuName
                }
            });


            if (menuName != GLOBAL_NOMENCLATURE.FriabilityMenu) {
                var tmppbckupobj = globalData.DoubSide.find(k => k.Hmi == strHmi);
                if (productData.Rotary == 'Double') {
                    if (tmppbckupobj == undefined) {
                        globalData.DoubSide.push({
                            Hmi: strHmi,
                            Side: [productData.Side],
                        });
                    } else {
                        if (!(tmppbckupobj.Side[0] == productData.Side)) {
                            tmppbckupobj.Side.push(productData.Side)
                        }
                        // var index = globalData.arrside.findIndex(k => k.Hmi == strHmi);
                        // globalData.arrside[index].Side = data.Side;
                    }
                }
            } else {
                var tmppbckupobj = globalData.DoubSideForFriab.find(k => k.Hmi == strHmi);
                if (productData.Rotary == 'Double') {
                    if (tmppbckupobj == undefined) {
                        globalData.DoubSideForFriab.push({
                            Hmi: strHmi,
                            Side: [productData.Side],
                        });
                    } else {
                        if (!(tmppbckupobj.Side[0] == productData.Side)) {
                            tmppbckupobj.Side.push(productData.Side)
                        }
                        // var index = globalData.arrside.findIndex(k => k.Hmi == strHmi);
                        // globalData.arrside[index].Side = data.Side;
                    }
                }
            }
            switch (menuName) {
                case GLOBAL_NOMENCLATURE.LengthMenu:
                case GLOBAL_NOMENCLATURE.SealLengthMenu:
                case GLOBAL_NOMENCLATURE.ThicknessMenu:
                case GLOBAL_NOMENCLATURE.BreadthMenu:
                case GLOBAL_NOMENCLATURE.DiameterMenu:
                    instrumentName = GLOBAL_NOMENCLATURE.Vernier;
                    break;
                case GLOBAL_NOMENCLATURE.EmptyShell:
                case GLOBAL_NOMENCLATURE.IndividualMenu:
                case GLOBAL_NOMENCLATURE.IndLayerMenu:
                case GLOBAL_NOMENCLATURE.IndLayer1Menu:
                case GLOBAL_NOMENCLATURE.GroupMenu:
                case GLOBAL_NOMENCLATURE.GroupIndividual:
                case GLOBAL_NOMENCLATURE.GroupLayerMenu:
                case GLOBAL_NOMENCLATURE.GroupLayer1Menu:
                case GLOBAL_NOMENCLATURE.PercentageFine:
                case GLOBAL_NOMENCLATURE.perFineMenu:
                case GLOBAL_NOMENCLATURE.perFineLayer1Menu:
                case GLOBAL_NOMENCLATURE.perFineLayer2Menu:
                case GLOBAL_NOMENCLATURE.ParticalSizing:
                case GLOBAL_NOMENCLATURE.PSDMenu:
                case GLOBAL_NOMENCLATURE.PSDLayer1Menu:
                case GLOBAL_NOMENCLATURE.PSDLayer2Menu:
                    instrumentName = GLOBAL_NOMENCLATURE.Balance;
                    break;
                case GLOBAL_NOMENCLATURE.HardnessMenu:
                case GLOBAL_NOMENCLATURE.TabletTesterMenu:

                    instrumentName = GLOBAL_NOMENCLATURE.Hardness;
                    break;
                case GLOBAL_NOMENCLATURE.DT:
                case GLOBAL_NOMENCLATURE.DTLayer1Menu:
                case GLOBAL_NOMENCLATURE.DTLayer2Menu:
                    instrumentName = GLOBAL_NOMENCLATURE.DT;
                    break;
                case GLOBAL_NOMENCLATURE.MoistureAnalyzer:
                case GLOBAL_NOMENCLATURE.LODMenu:
                case GLOBAL_NOMENCLATURE.LODLayer1Menu:
                case GLOBAL_NOMENCLATURE.LODLayer2Menu:
                    instrumentName = GLOBAL_NOMENCLATURE.MoistureAnalyzer;
                    break;
                case GLOBAL_NOMENCLATURE.FriabilityMenu:
                case GLOBAL_NOMENCLATURE.FriabilatorMenu:
                    if (menuName == GLOBAL_NOMENCLATURE.FriabilatorMenu) {
                        instrumentName = 'Friabilator';
                    } else {
                        if (serverConfig.friabilityType == "OF") {
                            instrumentName = 'Friabilator';
                        } else {
                            instrumentName = GLOBAL_NOMENCLATURE.Balance;
                        }
                    }

                    break;
                case GLOBAL_NOMENCLATURE.TappedDensity:
                case GLOBAL_NOMENCLATURE.TDMenu:
                case GLOBAL_NOMENCLATURE.TDLayer1Menu:
                case GLOBAL_NOMENCLATURE.TDLayer2Menu:
                    instrumentName = GLOBAL_NOMENCLATURE.TappedDensity;
                    break;
                case GLOBAL_NOMENCLATURE.PercentageFine:
                case GLOBAL_NOMENCLATURE.perFineMenu:
                case GLOBAL_NOMENCLATURE.perFineLayer1Menu:
                case GLOBAL_NOMENCLATURE.perFineLayer2Menu:
                    instrumentName = GLOBAL_NOMENCLATURE.Balance;
                    break;
                case GLOBAL_NOMENCLATURE.Differential:
                    instrumentName = GLOBAL_NOMENCLATURE.Balance;
                    break;
                case GLOBAL_NOMENCLATURE.MoistureAnalyzer:
                case GLOBAL_NOMENCLATURE.LODMenu:
                case GLOBAL_NOMENCLATURE.LODLayer1Menu:
                case GLOBAL_NOMENCLATURE.LODLayer2Menu:
                case GLOBAL_NOMENCLATURE.granulationDry:
                case GLOBAL_NOMENCLATURE.granulationLub:
                case GLOBAL_NOMENCLATURE.lay1Dry:
                case GLOBAL_NOMENCLATURE.lay1Lub:
                case GLOBAL_NOMENCLATURE.lay2Dry:
                case GLOBAL_NOMENCLATURE.lay2Lub:
                    instrumentName = GLOBAL_NOMENCLATURE.MoistureAnalyzer;
                    break;
                case "IPCWC":
                    instrumentName = GLOBAL_NOMENCLATURE.IPCBalance;
                    var ipcWeighment = await ipcWeighment.selectedBin(value)
                    return ipcWeighment
                // break;

            }

            let configSetting = await objConfigSettings.GetConfigSetting(strHmi, instrumentName);
            let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi);
            if (hmiEntryinConfig == undefined) {
                globalData.arrConfigSettings.push({
                    Hmi: strHmi,
                    configSetting: configSetting
                })
            } else {
                hmiEntryinConfig.configSetting = configSetting
            }

            let hmiDetails = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi);
            if (hmiDetails == undefined) {
                globalData.arrWeighmentProductData.push({
                    "Hmi": strHmi,
                    "data": productData
                })
            } else {
                hmiDetails.data = productData;
            }

            if (strstatus === "Weighment") {
                let tempObj = globalData.arrCurrentOperationStatus.find(k => k.Hmi == strHmi);
                if (tempObj === undefined) {
                    globalData.arrCurrentOperationStatus.push({
                        "Hmi": strHmi,
                        "Weighment": "1",
                        "testType": "Weighment"
                    })
                }
                else {
                    tempObj.testType = "Weighment"
                    tempObj.Weighment = "1";
                }
                return Object.assign(responseObj, { status: "success", configsetting: configSetting })
            } else {
                return Object.assign(responseObj, {
                    status: 'fail',
                    message: 'Status is not weighment'
                })
            }

        } catch (error) {
            throw new Error(error)
        }
    }

    async ParsingTestData(__parameterObj) {
        try {
            let result;
            let strIdsNo = __parameterObj.idsNo;
            let strHmi = __parameterObj.Hmi;
            const objSelMenu = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);
            if (objSelMenu != undefined) {


                let strSelectedMenuName = objSelMenu.menuName;
                __parameterObj.menuName = strSelectedMenuName;

                const SampleRemark = globalData.arrSampleRemarkForAllTest.find(k => k.Hmi == strHmi);
                if (SampleRemark == undefined) {
                    globalData.arrSampleRemarkForAllTest.push({
                        "Hmi": strHmi,
                        "OutOfRemark": false
                    });
                }
                strSelectedMenuName = strSelectedMenuName.replace(/\_/g, " ");
                switch (strSelectedMenuName) {
                    case GLOBAL_NOMENCLATURE.EmptyShell: {
                        result = await objIndividual.processEmptyShellData(__parameterObj);
                        return result;
                    }

                    case GLOBAL_NOMENCLATURE.IndividualMenu: {
                        result = await objIndividual.processIndividualData(__parameterObj);
                        return result;
                    }
                    case GLOBAL_NOMENCLATURE.IndLayerMenu: {
                        result = await objIndividual.processIndividualData(__parameterObj);
                        return result;
                    }
                    case GLOBAL_NOMENCLATURE.IndLayer1Menu: {
                        result = await objIndividual.processIndividualData(__parameterObj);
                        return result;
                    }
                    case GLOBAL_NOMENCLATURE.GroupMenu: {
                        result = await objGroup.processGroupData(__parameterObj);
                        return result;
                    }
                    case GLOBAL_NOMENCLATURE.GroupLayerMenu: {
                        result = await objGroup.processGroupData(__parameterObj);
                        return result;
                    }

                    case GLOBAL_NOMENCLATURE.GroupIndividual: {
                        result = await objIndividual.processIndividualData(__parameterObj);
                        return result;
                    }
                    case GLOBAL_NOMENCLATURE.GroupLayer1Menu: {
                        result = await objGroup.processGroupData(__parameterObj);
                        return result;
                    }
                    case GLOBAL_NOMENCLATURE.ThicknessMenu: {
                        result = await objThickness.processThicknessData(__parameterObj);
                        return result;
                    }
                    case GLOBAL_NOMENCLATURE.LengthMenu: 
                    case GLOBAL_NOMENCLATURE.SealLengthMenu: {
                        result = await objLength.processLengthData(__parameterObj);
                        return result;
                    }
                    case GLOBAL_NOMENCLATURE.DiameterMenu: {
                        result = await objDiameter.processDiameterData(__parameterObj);
                        return result;
                    }
                    case GLOBAL_NOMENCLATURE.BreadthMenu: {
                        result = await objBreadth.processBreadthData(__parameterObj);
                        return result;
                    }
                    case GLOBAL_NOMENCLATURE.HardnessMenu: {
                        result = await objHardness.processHardnessData(__parameterObj);
                        return result;
                    }
                    case GLOBAL_NOMENCLATURE.FriabilityMenu:
                    case GLOBAL_NOMENCLATURE.FriabilatorMenu: {
                        if (serverConfig.friabilityType == "OF") {
                            result = await objFriability.processFriabilityData(__parameterObj);
                            return result;
                        }
                        else if (serverConfig.friabilityType == "OB") {
                            result = await objFriability.processBalanceFriabilityData(__parameterObj);
                            return result;
                        }
                        else {
                            result = await objFriability.processBFBO(__parameterObj);
                            return result;
                        }
                    }
                    case GLOBAL_NOMENCLATURE.DTMenu:
                    case GLOBAL_NOMENCLATURE.DTLayer1Menu:
                    case GLOBAL_NOMENCLATURE.DTLayer2Menu:
                        {
                            result = await objDT.processDTData(__parameterObj);
                            return result;
                        }
                    case GLOBAL_NOMENCLATURE.TappedDensity:
                    case GLOBAL_NOMENCLATURE.TDMenu:
                    case GLOBAL_NOMENCLATURE.TDLayer1Menu:
                    case GLOBAL_NOMENCLATURE.TDLayer2Menu:
                        {
                            result = await objTappedDensity.processTappedDensityData(__parameterObj);
                            return result;
                        }
                    case GLOBAL_NOMENCLATURE.PercentageFine:
                    case GLOBAL_NOMENCLATURE.perFineMenu:
                    case GLOBAL_NOMENCLATURE.perFineLayer1Menu:
                    case GLOBAL_NOMENCLATURE.perFineLayer2Menu:
                        {
                            result = await objPercentageFine.processPercentageFineData(__parameterObj);
                            return result;
                        }
                    case GLOBAL_NOMENCLATURE.ParticalSizing:
                    case GLOBAL_NOMENCLATURE.PSDMenu:
                    case GLOBAL_NOMENCLATURE.PSDLayer1Menu:
                    case GLOBAL_NOMENCLATURE.PSDLayer2Menu:
                        {
                            result = await objParticalSizing.processParticalSizingData(__parameterObj);
                            return result;
                        }
                    case GLOBAL_NOMENCLATURE.Differential: {
                        result = await objDifferential.processDifferentialData(__parameterObj);
                        return result;
                    }
                    case GLOBAL_NOMENCLATURE.MoistureAnalyzer:
                    case GLOBAL_NOMENCLATURE.granulationDry:
                    case GLOBAL_NOMENCLATURE.granulationLub:
                    case GLOBAL_NOMENCLATURE.lay1Dry:
                    case GLOBAL_NOMENCLATURE.lay1Lub:
                    case GLOBAL_NOMENCLATURE.lay2Dry:
                    case GLOBAL_NOMENCLATURE.lay2Lub:
                    case GLOBAL_NOMENCLATURE.LODMenu:
                    case GLOBAL_NOMENCLATURE.LODLayer1Menu:
                    case GLOBAL_NOMENCLATURE.LODLayer2Menu:
                        {
                            result = await objLod.insertBulkWeighmentLOD(__parameterObj);
                            return result;
                        }
                    case "IPCWC":
                        result = await ipcWeighment.decideTareEmptyOrNot(__parameterObj)
                        return result;
                    default:
                        console.log('Unknown ', strSelectedMenuName)

                }
            }
        } catch (error) {
            throw new Error(error)
        }

    }

    async verifyLoginAfterTest(values) {
        try {
            const { Hmi: strHmi, userId: strUserId, userPass: strPassword } = values;
            let loginCheck = await this.checkUser(strUserId, strPassword);
            if (loginCheck == undefined) {
                return { status: 'fail', result: 'Incorrect Credentials' };
            }
            const arrUsers = globalData.arrUsers.find(k => k.Hmi == strHmi);
            if (arrUsers == undefined) {
                console.log('no user it must be error')
                return { status: 'fail', message: 'No user detail' }
            }
            //user which has login on system
            const preLoginUser = arrUsers.UserId;
            if (!(preLoginUser.trim() == strUserId.trim())) {
                return { status: 'fail', message: 'Incorrect Credentials' }
            }
            return { status: 'success', message: 'User Matched' }
        } catch (error) {
            throw new Error(error)
        }
    }

    async checkUser(userID, pwd) {
        try {
            const usrDetailsObj = {
                str_tableName: 'tbl_users',
                data: '*',
                condition: [{ str_colName: 'userId', value: userID },
                { str_colName: 'realPassword', value: pwd }
                ]
            }
            let result = await database.select(usrDetailsObj)

            if (result[0][0] != undefined) {
                return result[0][0];
            }
            else {
                return undefined;
            }

        } catch (error) {
            throw new Error(error)
        }
    }


}

module.exports = WeighmentModel;