const date = require("date-and-time");
const globalData = require("../../global/globalData");
const clsActivityLog = require("../clsActivityLog.model");
const clsInstrumentUsage = require("../clsInstrumentUsageLog");
const clsCommonInsertOpt = require("../Product/clsCommonInsertOperation.model");
const clsMqttSender = require("../Mqtt/mqttSender.class");
const DataBase = require("../../database/clsQueryProcess");
const FormulaFunModel = require("../Product/clsformulaFun.model");
const mqttProtocol = require("../../global/GLOBAL_NOMENCLATURE");
const clsCommonUseFunction = require("../clsCommonUseFunction");
const PowerBackup = require("../../Utills/powerBackUp/powerbackup");
const { models } = require("../../../config/dbConnection");
const clsPrintOperations = require("../Print/clsPrintOperation")

const printOperations = new clsPrintOperations()
const objActivityLog = new clsActivityLog();
const objInstrumentUsage = new clsInstrumentUsage();
const objCommonInsertOpt = new clsCommonInsertOpt();
const mqttSender = new clsMqttSender();
const database = new DataBase();
const objformulaFun = new FormulaFunModel();
const objCommonUseFunc = new clsCommonUseFunction();
const objPowerBackup = new PowerBackup();
const { create, all } = require("mathjs");
const config = {};
const mathj = create(all, config);
class PercentageFineModel {

  async processPercentageFineData(__parameterObjPerFine) {
    try {
      let objActivity = {};
      let maxLimitT1, minLimitT1, strTableName, strDetailTbl;
      const strHmi = __parameterObjPerFine.Hmi;
      const strIdsNo = __parameterObjPerFine.idsNo;
      const menuName = __parameterObjPerFine.menuName;
      var DP = __parameterObjPerFine.decPoint;
      let actualWt = mathj.round(__parameterObjPerFine.actualWt,DP).toFixed(DP);
      const objSelMenu = globalData.arrSelectedMenu.find((k) => k.idsNo == strIdsNo);
      const PercentageFineDetail = globalData.arrWeighmentProductData.find((k) => k.Hmi == strHmi);
      let sample = 2;
      let batchNo = PercentageFineDetail.data.Batch;
      let tempCounterObj = globalData.arrWeighmentCounter.find((k) => k.Hmi == strHmi);
      let tempUserObject = globalData.arrUsers.find((k) => k.Hmi === strHmi);
      const sampleRemark = globalData.arrSampleRemarkForAllTest.find((k) => k.Hmi == strHmi);
      maxLimitT1 = objSelMenu.selectedProductDetail.T1Neg;
      minLimitT1 = objSelMenu.selectedProductDetail.T1Pos;
      let _cubicalData = globalData.arrIdsInfo.find((k) => k.idsNo == strIdsNo).cubicalData;
      let tableName = "tbl_powerbackup";
      /**
       * Counter
       */
      if (tempCounterObj === undefined) {
        globalData.arrWeighmentCounter.push({
          Hmi: strHmi,
          counter: 0,
        });
      }
      tempCounterObj = globalData.arrWeighmentCounter.find((k) => k.Hmi == strHmi);
      var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
      var SelectedIdsNo
      if (IPQCObject != undefined) {
          SelectedIdsNo = IPQCObject.selectedIds.Idsno;
      } else {
          SelectedIdsNo = strHmi;
      }
      let __parameterPerFine = {
        objProductDetails: PercentageFineDetail.data,
        uniqueSerialNumber: strIdsNo,
        strBalId: __parameterObjPerFine.instrumentId,
        ProtocolData: Number(__parameterObjPerFine.actualWt).toFixed(DP),
        ProtocolUnit: __parameterObjPerFine.unit,
        ProtocolDecPoint: __parameterObjPerFine.decPoint,
        strHmi: strHmi,
        productType: objSelMenu.selectedProductDetail,
      };

      if (tempCounterObj.counter <= sample) {
        tempCounterObj.counter += 1;
        __parameterPerFine.seqNoOfWt = tempCounterObj.counter;

        var powerbackupobj = {
          cubicaNo: _cubicalData.Sys_CubicNo,
          cubicType: _cubicalData.Sys_CubType,
          cubicSysBFGcode: _cubicalData.Sys_BFGCode,
          cubicBatch: _cubicalData.Sys_Batch,
          menuName: menuName, //ThicknessDetail.data.menuName,
          ProductType: objSelMenu.selectedProductDetail.ProductType,
          Userid: tempUserObject.UserId,
          idsNo: strIdsNo,
          Hmi: strHmi,
          // Incomp_RepSerNo: tempCounterObj.counter,
          ReportType: _cubicalData.Sys_RptType,
          RecSampleNo: tempCounterObj.counter,
          SelectedIds:SelectedIdsNo
        };

        let _check_combination = await objPowerBackup._check_combination_pow(objSelMenu, powerbackupobj, tableName);
        if (_check_combination !== undefined) {
          tempCounterObj.counter = _check_combination.RecSampleNo + 1;
          powerbackupobj.RecSampleNo = tempCounterObj.counter;
          __parameterPerFine.seqNoOfWt = tempCounterObj.counter;
        }
        let sampleNo = tempCounterObj.counter;
        let limitObjResp = await objCommonUseFunc.SendCommon({ strHmi, actualWt, undefined, undefined, minLimitT1, maxLimitT1, menuName, sampleNo });
        let color = limitObjResp.Color;
        let limit = limitObjResp.limit;
        if (tempCounterObj.counter == 1) {
          Object.assign(
            objActivity,
            { strUserId: tempUserObject.UserId },
            { strUserName: tempUserObject.UserName },
            { activity: `${menuName} Weighment Started on TSH ${strHmi}`}
          );
          await objActivityLog.ActivityLogEntry(objActivity);
          // Instrument Usage log for balance start
          await objInstrumentUsage.InstrumentUsage("Balance", strIdsNo, "tbl_instrumentlog_balance", menuName, "started");

          var RepSer = await objCommonInsertOpt.saveIncompleteDataPerFineAndParticalSizing(__parameterPerFine, "F");
          powerbackupobj.Incomp_RepSerNo = RepSer.dataValues.RepSerNo
          await objPowerBackup.getStatusoFTestForPowerBackup(powerbackupobj);

          mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${actualWt} :${color}`);
          // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}BELOW 60 MESH`);
        } else {
          var object = await objCommonInsertOpt.saveIncompleteDataPerFineAndParticalSizing(__parameterPerFine, "F");
          powerbackupobj.Incomp_RepSerNo = object.RepSerNo,
          await objPowerBackup.getStatusoFTestForPowerBackup(powerbackupobj);
          // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${actualWt} ${__parameterObjPerFine.unit}:${color}`);
          mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${actualWt} :${object.meshValue}:${object.msg}`);
        }
        // mqttSender.sendData(strHmi, limit);
        if (sample == tempCounterObj.counter) {
          var data = await objCommonInsertOpt.saveCompleteDataPerFineAndParticalSizing(__parameterPerFine, "F");
          // await models.tbl_powerbackup.destroy({
          //   where:{
          //     CubicalNo : _cubicalData.Sys_CubicNo,
          //     Idsno :strHmi
          //   }
          // })
          Object.assign(
            objActivity,
            { strUserId: tempUserObject.UserId },
            { strUserName: tempUserObject.UserName },
            { activity: `${menuName} Weighment Completed on TSH ${strHmi}` }
          );
          await objActivityLog.ActivityLogEntry(objActivity);
          await objInstrumentUsage.InstrumentUsage("Balance", strIdsNo, "tbl_instrumentlog_balance", "", "completed");

          if(data.remark == "Complies"){
            var intProductType = 1;

            var repop = 'Fine %';

            if(menuName == mqttProtocol.perFineMenu){
              repop = "Fine %"
            }else if(menuName == mqttProtocol.perFineLayer1Menu){
              repop = "% Fine Layer 1"
            }else if(menuName == mqttProtocol.perFineLayer2Menu){
              repop = "% Fine Layer 2"
            }

            var printObj = {
              RepSerNo: data.repserno,
              Side:'NA',
              batchNo:_cubicalData.Sys_Batch,
              cubicleType:_cubicalData.Sys_CubType,
              int_ReportFormat:1,
              recordFrom: "Current",
              reportOption: repop,
              reportType: "Complete",
              testType: "Regular",
              userId: tempUserObject.UserId,
              username: tempUserObject.UserName,
              printNo: 0,
              str_url: intProductType === 1 ? "Tablet" : "Capsule"
            }

            await printOperations.callViewTabReport(printObj, intProductType, strHmi)
          }

          globalData.arrWeighmentCounter.findIndex((k) => k.Hmi == strHmi) == -1 ? globalData.arrWeighmentCounter : globalData.arrWeighmentCounter.splice(globalData.arrWeighmentCounter.findIndex((k) => k.Hmi == strHmi), 1);

          globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi) == -1 ? globalData.arrCurrentOperationStatus : globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);

          //test splice if rotarty is not double
          globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi) == -1 ? globalData.arrSelectedMenu : globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi), 1);
          return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Test Completed`);
        }
      }
    } catch (error) {
      throw new Error(error);
    }
  }
}

module.exports = PercentageFineModel;
