const date = require('date-and-time');
const globalData = require('../../global/globalData')
const clsActivityLog = require('../clsActivityLog.model');
const clsInstrumentUsage = require('../clsInstrumentUsageLog');
const clsCommonInsertOpt = require('../Product/clsCommonInsertOperation.model');
const clsMqttSender = require('../Mqtt/mqttSender.class');
const DataBase = require('../../database/clsQueryProcess');
const FormulaFunModel = require('../Product/clsformulaFun.model');
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const PowerBackup = require("../../Utills/powerBackUp/powerbackup");
const clsPrintOperations = require("../Print/clsPrintOperation");
const { models } = require("../../../config/dbConnection");

const printOperations = new clsPrintOperations();
const objActivityLog = new clsActivityLog();
const objInstrumentUsage = new clsInstrumentUsage();
const objCommonInsertOpt = new clsCommonInsertOpt();
const mqttSender = new clsMqttSender();
const database = new DataBase();
const objformulaFun = new FormulaFunModel();
const objPowerBackup = new PowerBackup();
const { create, all } = require("mathjs");
const config = {};
const mathj = create(all, config);
class ParticalSizingModel {

    async processParticalSizingData(__parameterObjPerFine) {
        try {
            let objActivity = {};
            let maxLimitT1, minLimitT1, strTableName, strDetailTbl;
            const strHmi = __parameterObjPerFine.Hmi;
            const strIdsNo = __parameterObjPerFine.idsNo;
            const menuName = __parameterObjPerFine.menuName;
            var [Balinfo] = await models.tbl_balance.findAll({
                where: {
                    'Bal_ID': __parameterObjPerFine.instrumentId
                }
            })
              var DP = Balinfo.Bal_DP;
            let actualWt = mathj.round(__parameterObjPerFine.actualWt, DP).toFixed(DP);
            const objSelMenu = globalData.arrSelectedMenu.find(k => k.idsNo == strIdsNo);
            const PercentageFineDetail = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi);
            let sample = 7;
            let batchNo = PercentageFineDetail.data.Batch;
            let tempCounterObj = globalData.arrWeighmentCounter.find(k => k.Hmi == strHmi);
            let tempUserObject = globalData.arrUsers.find(k => k.Hmi === strHmi);
            let message;
            const sampleRemark = globalData.arrSampleRemarkForAllTest.find(k => k.Hmi == strHmi);
            maxLimitT1 = objSelMenu.selectedProductDetail.T1Neg;
            minLimitT1 = objSelMenu.selectedProductDetail.T1Pos;
            var _cubicalData = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
            let tableName = "tbl_powerbackup";
            /**
             * Counter
             */
            if (tempCounterObj === undefined) {
                globalData.arrWeighmentCounter.push({
                    'Hmi': strHmi,
                    'counter': 0
                })
            }
            tempCounterObj = globalData.arrWeighmentCounter.find(k => k.Hmi == strHmi);
            var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
            var SelectedIdsNo
            if (IPQCObject != undefined) {
                SelectedIdsNo = IPQCObject.selectedIds.Idsno;
            } else {
                SelectedIdsNo = strHmi;
            }
            let __parameterPerFine = {
                objProductDetails: PercentageFineDetail.data,
                uniqueSerialNumber: strIdsNo,
                strBalId: __parameterObjPerFine.instrumentId,
                ProtocolData: Number(__parameterObjPerFine.actualWt).toFixed(DP),
                ProtocolUnit: __parameterObjPerFine.unit,
                ProtocolDecPoint: __parameterObjPerFine.decPoint,
                strHmi: strHmi,
                productType: objSelMenu.selectedProductDetail
            }
            //powerbackup object
            var powerbackupobj = {
                // strTableName: strTableName,
                // strDetailTbl: strDetailTbl,
                cubicaNo: _cubicalData.Sys_CubicNo,
                cubicType: _cubicalData.Sys_CubType,
                cubicSysBFGcode: _cubicalData.Sys_BFGCode,
                cubicBatch: _cubicalData.Sys_Batch,
                menuName: menuName, //ThicknessDetail.data.menuName,
                ProductType: objSelMenu.selectedProductDetail.ProductType,
                Userid: tempUserObject.UserId,
                idsNo: strIdsNo,
                Hmi: strHmi,
                Incomp_RepSerNo: tempCounterObj.counter,
                ReportType: _cubicalData.Sys_RptType,
                RecSampleNo: tempCounterObj.counter,
                SelectedIds: SelectedIdsNo
            };
            let _check_combination = await objPowerBackup._check_combination_pow(objSelMenu, powerbackupobj, tableName);
            if (_check_combination !== undefined) {
                tempCounterObj.counter = _check_combination.RecSampleNo + 1;
                powerbackupobj.RecSampleNo = tempCounterObj.counter;
            } else {
                tempCounterObj.counter += 1;
            }

            if (tempCounterObj.counter <= sample) {
                __parameterPerFine.seqNoOfWt = tempCounterObj.counter;
                if (tempCounterObj.counter == 1) {
                    Object.assign(objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { activity: `${menuName} Weighment Started on TSH` + strHmi });
                    await objActivityLog.ActivityLogEntry(objActivity);
                    // Instrument Usage log for balance start
                    await objInstrumentUsage.InstrumentUsage('Balance', strIdsNo, 'tbl_instrumentlog_balance', menuName, 'started');

                    let objCheckGranulation = await objCommonInsertOpt.checkGranulation('P', actualWt, strIdsNo, strHmi);
                    if (objCheckGranulation.result == 'success') {
                        console.log(objCheckGranulation)
                    }
                    var lastInserted_repsrno = await objCommonInsertOpt.saveIncompleteDataPerFineAndParticalSizing(__parameterPerFine, "P");
                    powerbackupobj.Incomp_RepSerNo = lastInserted_repsrno.dataValues.RepSerNo;
                    powerbackupobj.RecSampleNo = tempCounterObj.counter;
                    await objPowerBackup.getStatusoFTestForPowerBackup(powerbackupobj);
                    mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}Test Sample:${actualWt}`);
                    // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}ABOVE 20 MESH`);

                } else {
                    switch (tempCounterObj.counter) {
                        case 2:
                            // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}ABOVE 20 MESH:${actualWt} ${__parameterObjPerFine.unit}`);
                            message = "Above 20 MESH";
                            break;
                        case 3:
                            // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}ABOVE 40 MESH:${actualWt} ${__parameterObjPerFine.unit}`);
                            message = "Above 40 MESH";
                            break;
                        case 4:
                            // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}ABOVE 60 MESH:${actualWt} ${__parameterObjPerFine.unit}`);
                            message = "Above 60 MESH";
                            break;
                        case 5:
                            // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}ABOVE 80 MESH:${actualWt} ${__parameterObjPerFine.unit}`);
                            message = "Above 80 MESH";
                            break;
                        case 6:
                            // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}ABOVE 100 MESH:${actualWt} ${__parameterObjPerFine.unit}`);
                            message = "Above 100 MESH";
                            break;
                        case 7:
                            // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}Fines on Collecting Tray:${actualWt}`);
                            message = "Fines on Collecting Tray";
                            break;
                    }

                    //await objCommonInsertOpt.checkGranulation('P', actualWt, strIdsNo, strHmi);
                    await objCommonInsertOpt.saveIncompleteDataPerFineAndParticalSizing(__parameterPerFine, "P");
                    // let tableName = "tbl_powerbackup";
                    powerbackupobj.RecSampleNo = tempCounterObj.counter;
                    await objPowerBackup.updateTestCount(objSelMenu, powerbackupobj, tableName);
                    mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${message}:${actualWt}`);

                }

                if (sample == tempCounterObj.counter) {
                    var data = await objCommonInsertOpt.saveCompleteDataPerFineAndParticalSizing(__parameterPerFine, 'P');
                    Object.assign(objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { activity: `${menuName} Weighment Completed on TSH ${strHmi}` });
                    await objActivityLog.ActivityLogEntry(objActivity);
                    await objInstrumentUsage.InstrumentUsage('Balance', strIdsNo, 'tbl_instrumentlog_balance', '', 'completed');


                    var intProductType = 1;

                    var repop = 'Particle Size';

                    if (menuName == mqttProtocol.PSDMenu) {
                        repop = "Particle Size"
                    } else if (menuName == mqttProtocol.PSDLayer1Menu) {
                        repop = "Particle Size Layer 1"
                    } else if (menuName == mqttProtocol.PSDLayer2Menu) {
                        repop = "Particle Size Layer 2"
                    }

                    var printObj = {
                        RepSerNo: data.repserno,
                        Side: 'NA',
                        batchNo: _cubicalData.Sys_Batch,
                        cubicleType: _cubicalData.Sys_CubType,
                        int_ReportFormat: 1,
                        recordFrom: "Current",
                        reportOption: repop,
                        reportType: "Complete",
                        testType: "Regular",
                        userId: tempUserObject.UserId,
                        username: tempUserObject.UserName,
                        printNo: 0,
                        str_url: intProductType === 1 ? "Tablet" : "Capsule"
                    }

                    await printOperations.callViewTabReport(printObj, intProductType, strHmi);

                    globalData.arrWeighmentCounter.findIndex(k => k.Hmi == strHmi) == -1 ?
                        globalData.arrWeighmentCounter :
                        globalData.arrWeighmentCounter.splice(globalData.arrWeighmentCounter.findIndex(k => k.Hmi == strHmi), 1);

                    globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi) == -1 ? globalData.arrCurrentOperationStatus : globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);

                    //test splice if rotarty is not double
                    globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
                        globalData.arrSelectedMenu :
                        globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Test Completed`);
                }
            }
        }
        catch (error) {

            throw new Error(error);
        }
    }

}

module.exports = ParticalSizingModel;