const date = require('date-and-time');
const moment = require('moment')
const globalData = require('../../global/globalData')
const clsActivityLog = require('../clsActivityLog.model');
const clsInstrumentUsage = require('../clsInstrumentUsageLog');
const clsCommonInsertOpt = require('../Product/clsCommonInsertOperation.model');
const clsMqttSender = require('../Mqtt/mqttSender.class');
const DataBase = require('../../database/clsQueryProcess');
const clsformulaFun = require('../Product/clsformulaFun.model');
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const serverConfig = require('../../global/serverConfig');
const clsMenuRequest = require('../Menu/MenuRequest.model')
const clsBatchSummary = require('../Product/clsBatchSummaryOperation');
const clsProObj = require('../Product/clsProductDetailModel');
const clsSP = require('../../model/Product/clsStoreProcedure');
const maths = require('mathjs');
const { create, all } = require("mathjs");

// const date = require('date-and-time');

const clsPrintOperations = require("../Print/clsPrintOperation")
const printOperations = new clsPrintOperations()
const objActivityLog = new clsActivityLog();
const objInstrumentUsage = new clsInstrumentUsage();
const objCommonInsertOpt = new clsCommonInsertOpt();
const mqttSender = new clsMqttSender();
const database = new DataBase();
const objformulaFun = new clsformulaFun();
const objMenuRequest = new clsMenuRequest();
const objBatchSummary = new clsBatchSummary();
const proObj = new clsProObj();
const objSP = new clsSP();
const clsMonit = require('../MonitorSocket/clsMonitSocket')
const objMonit = new clsMonit();
const { QueryTypes } = require('sequelize');
const config = {};
const mathj = create(all, config);
// const fetchDetails = new clsFetchDetail();

const models = require('../../../config/dbConnection').models;
const sequelize = require('../../../config/dbConnection').sequelize
const { where } = require('sequelize/lib/sequelize');

class FriabilityModel {
    constructor() {
        this.math = maths;
    }
    async processFriabilityData(dataObj) {
        try {
            let strHmi = dataObj.Hmi;
            let strIdsNo = dataObj.idsNo;
            let CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.idsNo == strIdsNo).cubicalData;
            let tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
            // let ProtocolPortNo = __parameterObj.ProtocolPortNo;

            let selectedIdsNo;
            var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strIdsNo);
            if (IPQCObject != undefined) {
                selectedIdsNo = IPQCObject.selectedIds;
            } else {
                selectedIdsNo = strIdsNo;
            }
            let hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.idsNo == selectedIdsNo).cubicalData;

            let __activityObj = {
                strUserId: tempUserObject.UserId,
                strUserName: tempUserObject.UserName,
                activity: `Friability Test Started on TSH ${strHmi}`
            }
            let Friabilitydetail = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi);
            var timeForFriabStart = Friabilitydetail.data.Time
            timeForFriabStart = moment().format(timeForFriabStart, ' hh:mm:ss ');

            await objActivityLog.ActivityLogEntry(__activityObj, timeForFriabStart);


            await objInstrumentUsage.InstrumentUsageForDTandFriab('Friabilator',
                strIdsNo, 'tbl_instrumentlog_friability', 'Friabilator', 'started', timeForFriabStart);

            if (hmiDetailsInPMenu.Sys_RotaryType == "Double" && dataObj.recived_string_type == "Single") {
                console.log("invalid string")
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid string Received`);

            } else if (hmiDetailsInPMenu.Sys_RotaryType == "Single" && dataObj.recived_string_type == "Double") {
                console.log("invalid string")
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid string Received`);
            }
            else {
                //type
                // let strIdsNo = dataObj.idsNo;
                let actualWtA2, actualWtB2;
                let actualWtA1 = dataObj.actualWtAfterDrum1.split(' ');
                let actualWtB1 = dataObj.actualWtBeforeDrum1.split(' ');

                if (dataObj.actualWtAfterDrum2 != undefined) {
                    actualWtA2 = dataObj.actualWtAfterDrum2.split(' ')
                } else {
                    actualWtA2 = 0;
                }
                if (dataObj.actualWtBeforeDrum2 != undefined) {
                    actualWtB2 = dataObj.actualWtBeforeDrum2.split(' ')
                } else {
                    actualWtB2 = 0;
                }


                // let decimal1 = dataObj.decPoint1
                // let decimal2 = dataObj.decPoint2;
                // let unit1 = dataObj.unit1
                // let unit2 = dataObj.unit2;
                const menuName = dataObj.menuName;
                let typeValue;


                let lwtBeforeTest, lwtAfterTest, rwtAfterTest, rwtBeforeTest, nwtBeforeTest, nwtAfterTest;
                let objActivity = {};
                const FriabilityDetail1 = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi);
                const productDetail = globalData.arrProductTypeArray.find(k => k.Hmi == strHmi);
                const objSelMenu = globalData.arrSelectedMenu.find(k => k.idsNo == strIdsNo);
                let batchNo = FriabilityDetail1.data.Batch;
                let sample = FriabilityDetail1.data.noOfSample;
                var menuStartTime = FriabilityDetail1.data.Time
                menuStartTime = moment().format(menuStartTime, ' hh:mm:ss ');
                var menuStartDate = FriabilityDetail1.data.Date
                menuStartDate = moment().format('YYYY-MM-DD', menuStartDate);
                let tempCounterObj = globalData.arrWeighmentCounter.find(k => k.Hmi == strHmi);
                let tempUserObject = globalData.arrUsers.find(k => k.Hmi === strHmi);
                let strTableName, strDetailTbl;

                if (tempCounterObj === undefined) {
                    globalData.arrWeighmentCounter.push({
                        'Hmi': strHmi,
                        'counter': 0
                    })
                }

                tempCounterObj = globalData.arrWeighmentCounter.find(k => k.Hmi == strHmi);

                switch (menuName) {
                    case 'Friability': {
                        strTableName = "tbl_tab_friability";
                        typeValue = 8;
                    }
                        break;
                    default:
                }

                let productObj = FriabilityDetail1.data;
                let side;
                if (hmiDetailsInPMenu.Sys_RotaryType == 'Single') {
                    side = "NA";
                    console.log('single');
                } else {
                    side = "LHS";
                }

                lwtBeforeTest = parseFloat(actualWtB1[0]);
                lwtBeforeTest = this.math.round(lwtBeforeTest, 3)
                // lwtBeforeTest =lwtBeforeTest.toFixed(3)
                rwtBeforeTest = isNaN(parseFloat(actualWtB2[0])) == true ? 0 : parseFloat(actualWtB2[0]);
                rwtBeforeTest = this.math.round(rwtBeforeTest, 3)

                lwtAfterTest = parseFloat(actualWtA1[0]);
                lwtAfterTest = this.math.round(lwtAfterTest, 3)
                rwtAfterTest = isNaN(parseFloat(actualWtA2[0])) == true ? 0 : parseFloat(actualWtA2[0]);
                rwtAfterTest = this.math.round(rwtAfterTest, 3)


                nwtBeforeTest = 0;
                nwtAfterTest = 0;

                if (hmiDetailsInPMenu.Sys_RotaryType == "Single") {
                    nwtBeforeTest = (((lwtBeforeTest - lwtAfterTest) * 100) / lwtBeforeTest);
                    nwtBeforeTest = this.math.round(nwtBeforeTest, 3)
                    nwtAfterTest = 0
                } else {
                    nwtBeforeTest = (((lwtBeforeTest - lwtAfterTest) * 100) / lwtBeforeTest);
                    nwtBeforeTest = this.math.round(nwtBeforeTest, 3)
                    nwtAfterTest = (((rwtBeforeTest - rwtAfterTest) * 100) / rwtBeforeTest);
                    nwtAfterTest = this.math.round(nwtAfterTest, 3)
                }
                var Drum_1 = dataObj.friability_drum1 == undefined ? "" : dataObj.friability_drum1.split('%')
                var Drum_2 = dataObj.friability_drum2 == undefined ? "" : dataObj.friability_drum2.split('%')

                const __parameterFriability = {
                    strTableName: strTableName,
                    strDetailTbl: strDetailTbl,
                    objProductDetails: productDetail.productType,
                    uniqueSerialNumber: strIdsNo,
                    friabId: dataObj.instrumentId,
                    WTBD1: Number(lwtBeforeTest).toFixed(3),
                    WTAD1: Number(lwtAfterTest).toFixed(3),
                    WTBD2: Number(rwtBeforeTest).toFixed(3),
                    WTAD2: Number(rwtAfterTest).toFixed(3),
                    nwtBeforeTest: Number(nwtBeforeTest).toFixed(2),
                    nwtAfterTest: Number(nwtAfterTest).toFixed(2),
                    friability_drum1: Number(Drum_1[0]).toFixed(2),
                    friability_drum2: Number(Drum_2[0]).toFixed(2),
                    strHmi: strHmi,
                    strIdsNo: strIdsNo,
                    seqNoOfWt: tempCounterObj.counter,
                    productType: objSelMenu.selectedProductDetail,
                    Batch: batchNo,
                    interval: FriabilityDetail1.data,
                    menuStartTime: menuStartTime,
                    menuStartDate: menuStartDate,
                    side: side,
                    actualCount: dataObj.actualCount,
                    actualRpm: dataObj.actualRpm,
                }


                // var res = await proObj.productData(productObj)
                // let productDetail = productDetail.productType
                let now = new Date();
                let batchSummaryObject = {
                    BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                    ProductName: hmiDetailsInPMenu.Sys_ProductName,
                    PVersion: hmiDetailsInPMenu.Sys_PVersion,
                    Version: hmiDetailsInPMenu.Sys_Version,
                    Area: hmiDetailsInPMenu.Sys_Area,
                    PrdType: 1,
                    CubType: hmiDetailsInPMenu.Sys_CubType,
                    CubicleNo: hmiDetailsInPMenu.Sys_CubicNo,
                    BatchNo: hmiDetailsInPMenu.Sys_Batch,
                    Unit: hmiDetailsInPMenu.Sys_BatchSizeUnit,
                    Side: side == "NA" ? "Single" : "Double",
                    InstrumentID: CurrentCubicalObj.Sys_FriabID,
                    UserId: tempUserObject.UserId,
                    UserName: tempUserObject.UserName,
                    nwtBeforeTest: Number(nwtBeforeTest).toFixed(3),
                    nwtAfterTest: Number(nwtAfterTest).toFixed(3),
                    lwtBeforeTest: Number(lwtBeforeTest).toFixed(3),
                    lwtAfterTest: Number(lwtAfterTest).toFixed(3),
                    rwtBeforeTest: Number(rwtBeforeTest).toFixed(3),
                    rwtAfterTest: Number(rwtAfterTest).toFixed(3),
                    friability_drum1: Number(nwtBeforeTest).toFixed(2),
                    friability_drum2: Number(rwtAfterTest).toFixed(2),
                    Dept: hmiDetailsInPMenu.Sys_dept,
                    Nom: Number(productDetail.productDetail[0][0].Param8_Nom).toFixed(2),
                    Tol1Neg: productDetail.productDetail[0][0].Param8_T1Neg,
                    Tol1Pos: productDetail.productDetail[0][0].Param8_T1Pos,
                    BatchSize: productDetail.productType.BatchSize,
                    PrTime: moment().format('HH:mm:ss'),
                    PrDate: moment().format('YYYY-MM-DD'),
                }

                console.log(batchSummaryObject);
                let resFri = await this.saveToCompleteData(__parameterFriability, productDetail);
                if (resFri) {
                    Object.assign(objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { activity: `Friability Weighment Completed on TSH ${strHmi}` });

                    await objActivityLog.ActivityLogEntry(objActivity);
                    await objInstrumentUsage.InstrumentUsage('Friabilator', strIdsNo, 'tbl_instrumentlog_friability', '', 'completed');

                }
                var result = await objBatchSummary.saveBatchSummaryFriability(batchSummaryObject, strIdsNo, FriabilityDetail1, dataObj);
                const objUpdateValidation = await models.tbl_cubical.update({
                    'Sys_Validation': 0
                }, {
                    where: {
                        'Sys_rpi': CurrentCubicalObj.Sys_rpi
                    }

                });
                var NMT = FriabilityDetail1.data.NMT.split("%")[0]
                if (dataObj.friability_drum1 != undefined) {
                    var drum1 = __parameterFriability.nwtBeforeTest
                }
                if (dataObj.friability_drum2 != undefined) {
                    var drum2 = __parameterFriability.nwtAfterTest
                }
                var remark1
                if (hmiDetailsInPMenu.Sys_RotaryType == "Single") {
                    if (Number(NMT) >= Number(drum1)) {
                        remark1 = 'Complies'
                    } else {
                        remark1 = 'Not Complies'
                    }
                    mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBD1:${__parameterFriability.WTBD1.concat(' gm')};WTAD1:${__parameterFriability.WTAD1.concat(' gm')};NWTD1:${nwtBeforeTest};Perc1:${dataObj.friability_drum1};`);
                } else {
                    if (Number(NMT) >= Number(drum1) && Number(NMT) >= Number(drum2)) {
                        remark1 = 'Complies'
                    } else {
                        remark1 = 'Not Complies'
                    }
                    mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBD1:${__parameterFriability.WTBD1.concat(' gm')};WTAD1:${__parameterFriability.WTAD1.concat(' gm')};WTBD2:${__parameterFriability.WTBD2.concat(' gm')};WTAD2:${__parameterFriability.WTAD2.concat(' gm')};NWTD1:${nwtBeforeTest};NWTD2:${nwtAfterTest};Perc1:${dataObj.friability_drum1};Perc2:${dataObj.friability_drum2}`);
                }
                // await objOPCops.Friability(resFri,remark1)
                await models.tbl_tab_friability.update({
                    NWtRemark: remark1,
                    Inprocess: 0,
                }, {
                    where: {
                        RepSerNo: resFri
                    }
                });
                if (remark1 == "Complies") {
                    var printObj = {
                        recordFrom: "Current",
                        reportOption: "Friability",
                        reportType: "Complete",
                        testType: "Regular",
                        RepSerNo: resFri,
                        userId: tempUserObject.UserId,
                        username: tempUserObject.UserName,
                        printNo: 0,
                        str_url: productDetail.productType.ProductType === 1 ? "Tablet" : "Capsule"
                    }


                    await printOperations.callViewTabReport(printObj, productDetail.productType.ProductType, strHmi)
                }
                globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi) == -1 ?
                    globalData.arrWeighmentProductData :
                    globalData.arrWeighmentProductData.splice(globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi), 1);

                globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi) == -1 ?
                    globalData.arrProductTypeArray :
                    globalData.arrProductTypeArray.splice(globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi), 1);

                globalData.arrWeighmentCounter.findIndex(k => k.Hmi == strHmi) == -1 ?
                    globalData.arrWeighmentCounter :
                    globalData.arrWeighmentCounter.splice(globalData.arrWeighmentCounter.findIndex(k => k.Hmi == strHmi), 1);

                (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus :
                    globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);
                //test splice if rotarty is not double
                globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
                    globalData.arrSelectedMenu :
                    globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Test Completed `);
            }
        } catch (error) {
            console.log(error);
            throw new Error(error);
        }
    }

    async saveToCompleteData(data, friDetail) {
        try {
            let strHmi = data.strHmi;
            let strIdsNo = data.strIdsNo;
            let CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.idsNo == strIdsNo).cubicalData; //idsNo
            let tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
            let productObj = data.objProductDetails;

            let now = new Date();

            let selectedIdsNo;
            var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strIdsNo);
            if (IPQCObject != undefined) {
                selectedIdsNo = IPQCObject.selectedIds;
            } else {
                selectedIdsNo = strIdsNo;
            }


            let hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.idsNo == selectedIdsNo).cubicalData;

            var result = await models.tbl_tab_friability.findAll({
                attributes: [
                    [sequelize.fn('MAX', sequelize.col("MstSerNo")), "SeqNo"],
                ],
                where: {
                    'BFGCode': productObj.ProductId,
                    'ProductName': productObj.ProductName,
                    'PVersion': productObj.ProductVersion,
                    'Version': productObj.Version,
                    'BatchNo': data.Batch,
                    'IdsNo': strHmi,
                }
            })


            var intMstSerNo;
            if (result[0].SeqNo == null) {
                intMstSerNo = 1;
            } else {
                var newMstSerNo = result[0].SeqNo + 1;
                intMstSerNo = newMstSerNo;
            }

            let instrumentID = data.friabId

            //remove net wt 
            let bRepSerNo = await this.getMaxBRepSerNo(productObj.ProductName, data.Batch, 'tbl_tab_friability', hmiDetailsInPMenu.Sys_RptType, hmiDetailsInPMenu.Sys_RotaryType)
            var lastinserted = await models.tbl_tab_friability.create({
                'MstSerNo': intMstSerNo,
                'BFGCode': productObj.ProductId,
                'ProductName': productObj.ProductName,
                'ProductType': productObj.ProductType,
                'IdsNo': strHmi,
                'CubicalNo': hmiDetailsInPMenu.Sys_CubicNo,
                'CubicleName': hmiDetailsInPMenu.Sys_CubicName,
                'CubicleLocation': hmiDetailsInPMenu.Sys_Location,
                'BatchNo': data.Batch,
                'UserId': tempUserObject.UserId,
                'UserName': tempUserObject.UserName,
                'PrDate': data.menuStartDate,
                'PrTime': data.menuStartTime,
                // 'PrTime': date.format(now, 'HH:mm:ss'),
                'PrEndDate': moment().format('YYYY-MM-DD'),
                'PrEndTime': moment().format('HH:mm:ss'),
                'Side': hmiDetailsInPMenu.Sys_RotaryType !== "Single" ? "Double" : "Single",
                'Unit': 'g',
                'DecimalPoint': 0,
                'WgmtModeNo': 8,
                'FriNMTLimit': friDetail.productDetail[0][0].Param8_Nom,
                'SetCount': friDetail.productDetail[0][0].Param8_T1Neg,
                'SetRPM': friDetail.productDetail[0][0].Param8_T1Pos,
                'FriabilityQty': Number(data.interval.noOfSample),
                'CubicleType': hmiDetailsInPMenu.Sys_CubType,
                'ReportType': hmiDetailsInPMenu.Sys_RptType,
                'MachineCode': hmiDetailsInPMenu.Sys_MachineCode,
                'MFGCode': hmiDetailsInPMenu.Sys_MfgCode,
                'BatchSize': hmiDetailsInPMenu.Sys_BatchSize,
                // 'FriabilityID': CurrentCubicalObj.Sys_FriabID,
                'FriabilityID': instrumentID,
                'BalanceId': CurrentCubicalObj.Sys_BalID,
                'NWtBeforeTest': hmiDetailsInPMenu.Sys_RotaryType == "Single" ? data.WTBD1 : data.nwtBeforeTest,
                'NWtAfterTest': hmiDetailsInPMenu.Sys_RotaryType == "Single" ? data.WTAD1 : data.nwtBeforeTest,
                'NWtPercentage': hmiDetailsInPMenu.Sys_RotaryType == "Single" ? data.nwtBeforeTest : data.nwtBeforeTest,
                'LWtBeforeTest': data.WTBD1,
                'LWtAfterTest': data.WTAD1,
                'LWtPercentage': hmiDetailsInPMenu.Sys_RotaryType == "Single" ? data.WTBD1 : data.nwtBeforeTest,
                'RWtBeforeTest': data.WTBD2,
                'RWtAfterTest': data.WTAD2,
                'RWtPercentage': hmiDetailsInPMenu.Sys_RotaryType == "Single" ? data.WTBD1 : data.nwtAfterTest,
                'PrintNo': 0,
                'IsArchived': 0,
                // 'BalanceId': data.strBalId,
                'PVersion': hmiDetailsInPMenu.Sys_PVersion,
                'Version': hmiDetailsInPMenu.Sys_Version,
                'BRepSerNo': bRepSerNo,
                'RepoLabel11': hmiDetailsInPMenu.Sys_Validation,
                'Lot': 'LotNo',
                'ActualCount': Number(data.actualCount),
                'ActualRPM': Number(data.actualRpm),
                "NMT": Number(data.interval.NMT.split("%")[0]).toFixed(2),
                'Area': hmiDetailsInPMenu.Sys_Area,
                'AppearanceDesc': hmiDetailsInPMenu.Sys_Appearance,
                'MachineSpeed_Min': hmiDetailsInPMenu.Sys_MachineSpeed_Min,
                'MachineSpeed_Max': hmiDetailsInPMenu.Sys_MachineSpeed_Max,
                'GenericName': hmiDetailsInPMenu.Sys_GenericName,
                'BMRNo': hmiDetailsInPMenu.Sys_BMRNo,
                'Stage': hmiDetailsInPMenu.Sys_Stage,
                'Interval': data.interval.interval
            })

            return lastinserted.RepSerNo

        } catch (error) {
            console.log(error)
            throw new Error(error);
        }
    }

    //for Balance With Friability
    async processBalanceFriabilityData(dataObj) {
        try {
            let now = new Date();
            const moment = require('moment')
            let strHmi = dataObj.Hmi;
            let strIdsNo = dataObj.idsNo;
            let receiveWt = dataObj.actualWt;
            let unit = dataObj.unit;
            let mqunit = dataObj.mqtt;
            var deciaml = dataObj.decPoint
            let tempCounterObj = globalData.arrWeighmentCounterForFriab.find(k => k.Hmi == strHmi);
            const FriabilityDetail1 = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi);
            const objSelMenu = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);
            let batchNo = FriabilityDetail1.data.Batch;
            let sample = FriabilityDetail1.data.noOfSample;
            let ProtocolPortNo = dataObj.ProtocolPortNo;
            let CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
            if (mqunit == 'g') {
                var GroupUn = mqunit.includes('g');
                if (GroupUn == true) {
                    mqunit = "g"
                }
            }
            // if (mqunit != 'gm') {
            //     console.log(mqunit);
            //     mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid Weight Recieved!`);
            //     let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
            //     let autoTare = hmiEntryinConfig[0].AutoTare;
            //     let tareCommand = hmiEntryinConfig[0].Tare_Command
            //     mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
            //     return
            // }
            var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
            var SelectstrHmi
            if (IPQCObject != undefined) {
                SelectstrHmi = IPQCObject.selectedIds.Idsno;
            } else {
                SelectstrHmi = strHmi;
            }

            let selectedIdsNo;
            let activityLogMsg = `${mqttProtocol.Friability} Weighment Completed on TSH ${strHmi}`
            if (FriabilityDetail1.data.Rotary == 'Double') {
                let SideArray = globalData.DoubSideForFriab.find(k => k.Hmi == strHmi)
                if (SideArray != undefined) {
                    var Side = globalData.DoubSideForFriab.find(k => k.Hmi == strHmi).Side
                }
                var tempSide;
                if (FriabilityDetail1.data.Rotary == 'Double') {
                    if (FriabilityDetail1.data.Side == 'LHS') {
                        tempSide = 'RHS'
                    } else {
                        tempSide = 'LHS'
                    }
                }
                activityLogMsg = `${mqttProtocol.Friability} Weighment Completed on TSH ${strHmi} For Side ${FriabilityDetail1.data.Side}`
            }
            const productDetail = globalData.arrProductTypeArray.find(k => k.Hmi == strHmi);


            let tempCounterObjAfter = globalData.arrWeighmentCounterAfter.find(k => k.Hmi == strHmi);
            var lstInsertId;
            let hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
            let tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
            let objActivity = {};
            let __activityObj = {};


            //powerbackup

            let powerbacc = await models.tbl_powerbackup.findAll({
                where: {
                    CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
                    // SelectedIds: SelectstrHmi,
                    Sys_Batch: hmiDetailsInPMenu.Sys_Batch,
                    WeighmentName: 'FRIAB',
                    IdsNo: strHmi
                }
            })

            powerbacc = powerbacc.pop();

            if (powerbacc != undefined) {
                if (tempCounterObj === undefined) {
                    globalData.arrWeighmentCounterForFriab.push({
                        'Hmi': strHmi,
                        'counter': powerbacc.Before_Count
                    })
                }

                if (tempCounterObjAfter === undefined) {
                    globalData.arrWeighmentCounterAfter.push({
                        'Hmi': strHmi,
                        'counter': powerbacc.After_Count
                    })
                }
            } else {
                if (tempCounterObj === undefined) {
                    globalData.arrWeighmentCounterForFriab.push({
                        'Hmi': strHmi,
                        'counter': 0
                    })
                }

                if (tempCounterObjAfter === undefined) {
                    globalData.arrWeighmentCounterAfter.push({
                        'Hmi': strHmi,
                        'counter': 0
                    })
                }
            }


            tempCounterObj = globalData.arrWeighmentCounterForFriab.find(k => k.Hmi == strHmi);

            //temp counter for double

            tempCounterObjAfter = globalData.arrWeighmentCounterAfter.find(k => k.Hmi == strHmi);

            if (tempCounterObj.counter == 0) {
                await objInstrumentUsage.InstrumentUsage('Balance',
                    strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'started');
            }

            // }

            const __parameterFriability = {
                objProductDetails: productDetail.productType,
                uniqueSerialNumber: strIdsNo,
                strBalId: dataObj.instrumentId,
                strHmi: strHmi,
                receiveWt: receiveWt,
                seqNoOfWt: tempCounterObj.counter,
                productType: objSelMenu.selectedProductDetail,
                Batch: batchNo,
                unit: unit,
                Api_data: FriabilityDetail1,
                deciaml: deciaml
            }
            // let resSelectFri = await models.tbl_tab_detail8.findAll({
            //     attributes: [[sequelize.fn('max', sequelize.col('RecSeqNo')), 'RecSeqNo']],
            //     where: {
            //         BalanceID: dataObj.instrumentId,
            //         Side:FriabilityDetail1.data.Side
            //     }
            // })
            // let recNo = resSelectFri[0].RecSeqNo + 1


            let removeTimeForMenuDisable = productDetail.productDetail[0][0].Param8_T1Neg / productDetail.productDetail[0][0].Param8_T1Pos;
            var addTime = this.AddMinutesToDate(new moment(), removeTimeForMenuDisable);
            var dateFormat = addTime.split(' ');
            // dateFormat = dateFormat[1];
            var dateFormat1 = dateFormat[1];
            // var dateFormat1 = this.DateFormat(addTime);
            // console.log(dateFormat);



            //before

            if (FriabilityDetail1.data.Rotary == 'Double') {

                if ((tempCounterObj.counter == 0 || tempCounterObj.counter == 1) && (tempCounterObjAfter.counter == 0)) {
                    //send wt  before for both side

                    if (tempCounterObj.counter == 0) {

                        __activityObj = {
                            strUserId: tempUserObject.UserId,
                            strUserName: tempUserObject.UserName,
                            activity: `${mqttProtocol.Friability} Weighment Started on TSH ${strHmi} For Side ${FriabilityDetail1.data.Side}`
                        }


                        await objActivityLog.ActivityLogEntry(__activityObj);


                        /**
                         * Differntiated logon to insert according to double and single
                         */

                        //master entry 
                        // const checkEntry = await models.tbl_tab_friability.findAll({
                        //     attributes: [
                        //         // [sequelize.fn('MAX', sequelize.col("RecNo")), "RecNo"],
                        //         [sequelize.fn('MAX', sequelize.col("MstSerNo")), "lastInsertedID"],
                        //         [sequelize.fn('MAX', sequelize.col("RepSerNo")), "masterRepSerNo"],
                        //     ],
                        //     where: {
                        //         ProductName: CurrentCubicalObj.Sys_ProductName,
                        //         // IdsNo: CurrentCubicalObj.Sys_IDSNo,
                        //         BatchNo: CurrentCubicalObj.Sys_Batch,
                        //         PVersion: CurrentCubicalObj.Sys_PVersion,
                        //         Version: CurrentCubicalObj.Sys_Version,
                        //         BFGCode: CurrentCubicalObj.Sys_BFGCode,
                        //         CubicleType: CurrentCubicalObj.Sys_CubType,
                        //         ReportType: CurrentCubicalObj.Sys_RptType,
                        //         Side: FriabilityDetail1.data.Side

                        //     },
                        //     raw: true
                        // });

                        // if (checkEntry[0].lastInsertedID == null) {
                        lstInsertId = await this.saveToBalanceCompleteData(__parameterFriability, productDetail);
                        //dislay wt ${mqttProtocol.DisplayResult}
                        // }
                        // if (checkEntry[0].lastInsertedID != null) {

                        //     lstInsertId = checkEntry[0]

                        // }
                        // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.selectedIds.Idsno == strHmi);
                        // if (IPQCObject != undefined) {
                        //     strHmi = IPQCObject.idsNo;
                        // } else {
                        //     strHmi = strHmi;
                        // }

                        //detailEntry
                        let entry_lhsweight = await models.tbl_tab_friability.update({
                            LWtBeforeTest: receiveWt
                        }, {
                            where: {
                                RepSerNo: lstInsertId.masterRepSerNo,
                            }
                        });
                        // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
                        // if (IPQCObject != undefined) {
                        //     strHmi = IPQCObject.selectedIds.Idsno;
                        // } else {
                        //     strHmi = strHmi;
                        // }
                        // await objInstrumentUsage.InstrumentUsage('Balance',
                        //     strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'Completed');
                        var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
                        var SelectedIdsNo
                        if (IPQCObject != undefined) {
                            SelectedIdsNo = IPQCObject.selectedIds.Idsno;
                        } else {
                            SelectedIdsNo = strHmi;
                        }
                        const obj = {
                            'CubicalNo': hmiDetailsInPMenu.Sys_CubicNo,
                            // 'WeighmentType': 8,
                            'WeighmentName': 'FRIAB',
                            'Userid': tempUserObject.UserId,
                            'ReportType': hmiDetailsInPMenu.Sys_RptType,
                            // 'RotartyType': hmiDetailsInPMenu.Sys_RotaryType,
                            'Sys_CubType': 1,
                            'Sys_Batch': batchNo,
                            'Sys_BFGCode': hmiDetailsInPMenu.Sys_BFGCode,
                            'Before_Count': 1,
                            'After_Count': 0,
                            "Idsno": strHmi,
                            // 'Time': dateFormat, comp: 'eq',
                            'Incomp_RepSerNo': lstInsertId.masterRepSerNo,
                            'RecSampleNo': 1,
                            'SeqNo': 0,
                            SelectedIds: SelectedIdsNo
                        }


                        if (FriabilityDetail1.data.Rotary == "Single") {
                            Object.assign(obj, { 'EntryTimeStamp': addTime })
                            await models.tbl_powerbackup.create(obj)
                        }
                        // await database.save(saveFriabilityPowerBackup)
                        if (FriabilityDetail1.data.Rotary == "Double" && powerbacc == undefined) {
                            // Object.assign(obj, { 'EntryTimeStamp': addTime })
                            await models.tbl_powerbackup.create(obj)

                        } else {
                            //update
                            // Object.assign(obj, { 'EntryTimeStamp': addTime })
                            if (FriabilityDetail1.data.Rotary == "Double" && powerbacc.Before_Count == 1) {
                                await models.tbl_powerbackup.update({
                                    // Side_RepSerNo:lstInsertId.masterRepSerNo,//03/1223
                                    EntryTimeStamp: addTime
                                }, {
                                    where: {
                                        // CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
                                        WeighmentName: 'FRIAB',
                                        SelectedIds: SelectstrHmi,
                                        Sys_CubType: 1,
                                        IdsNo: strHmi
                                        // TableType : "NULL"
                                    }
                                })
                            }
                        }
                        let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
                        let autoTare = hmiEntryinConfig[0].AutoTare;
                        let tareCommand = hmiEntryinConfig[0].Tare_Command

                        await objMonit.monit({
                            case: 'TestWeight', Hmi: strHmi, data: {
                                Weight: `${Number(
                                    receiveWt
                                )} ${unit}`, srNo: "", message: 'InitialWeight'
                            }
                        });
                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBL1:${receiveWt + " " + unit}`);

                        //monit



                        if (FriabilityDetail1.data.Rotary == "Double") {
                            mqttSender.sendData(strHmi, `${mqttProtocol.Sideprotocol}${tempSide}`);
                            if (autoTare) {
                                mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                            }

                        }
                    }


                    if (FriabilityDetail1.data.Rotary == "Double") {
                        tempCounterObj.counter += 1;
                        let timeForMenuDisable = globalData.arrTimeForMenuDisable.find(k => k.Hmi == strHmi);
                        if (timeForMenuDisable == undefined) {
                            globalData.arrTimeForMenuDisable.push({
                                Hmi: strHmi,
                                idsNo: strIdsNo,
                                // timeForMenuHide: removeTimeForMenuDisable,
                                formatedTime: dateFormat1
                            })
                        } else {
                            // timeForMenuDisable.timeForMenuHide = removeTimeForMenuDisable;
                            timeForMenuDisable.timeForMenuHide = dateFormat1;

                        }
                        //left before wt drum 1 ka 
                    } else if (FriabilityDetail1.data.Rotary == "Single") {
                        tempCounterObjAfter.counter += 1;
                        let timeForMenuDisable = globalData.arrTimeForMenuDisable.find(k => k.Hmi == strHmi);
                        if (timeForMenuDisable == undefined) {
                            globalData.arrTimeForMenuDisable.push({
                                Hmi: strHmi,
                                idsNo: strIdsNo,
                                // timeForMenuHide: removeTimeForMenuDisable,
                                formatedTime: dateFormat1
                            })
                        } else {
                            // timeForMenuDisable.timeForMenuHide = removeTimeForMenuDisable;
                            timeForMenuDisable.timeForMenuHide = dateFormat1;

                        }
                    }


                    /**
                     * For Double update in RWtBeforeTest column
                     */
                    if (tempCounterObj.counter == 2) {
                        __activityObj = {
                            strUserId: tempUserObject.UserId,
                            strUserName: tempUserObject.UserName,
                            activity: `${mqttProtocol.Friability} Weighment Started on IDS ${strHmi} For Side ${FriabilityDetail1.data.Side}`
                        }


                        await objActivityLog.ActivityLogEntry(__activityObj);
                        //No RptType
                        // var sqlquery = `SELECT * FROM tbl_tab_detail8 WHERE RepSerNo = (SELECT MAX(RepSerNo) FROM tbl_tab_master8 WHERE 'IdsNo' = '${strHmi}' AND 'BatchNo' = '${batchNo}') AND 'DataValue2' = 0`;
                        var checkEntry_1 = await models.tbl_tab_friability.findAll({
                            attributes: [
                                [sequelize.fn('MAX', sequelize.col("MstSerNo")), "lastInsertedID"],
                                [sequelize.fn('MAX', sequelize.col("RepSerNo")), "masterRepSerNo"],
                            ],
                            where: {
                                ProductName: CurrentCubicalObj.Sys_ProductName,
                                IdsNo: strHmi,
                                BatchNo: CurrentCubicalObj.Sys_Batch,
                                PVersion: CurrentCubicalObj.Sys_PVersion,
                                Version: CurrentCubicalObj.Sys_Version,
                                BFGCode: CurrentCubicalObj.Sys_BFGCode,
                                CubicleType: CurrentCubicalObj.Sys_CubType,
                                ReportType: CurrentCubicalObj.Sys_RptType,
                                // Side: FriabilityDetail1.data.Side

                            },
                            raw: true
                        });

                        // if (checkEntry[0].lastInsertedID == null) {
                        //     lstInsertId = await this.saveToBalanceCompleteData(__parameterFriability, productDetail);
                        //     //dislay wt ${mqttProtocol.DisplayResult}
                        // }
                        if (checkEntry_1[0].lastInsertedID != null) {

                            lstInsertId = checkEntry_1[0]

                        }
                        // var checkEntry = await models.tbl_tab_friability.findAll({
                        //     attributes: [
                        //         // [sequelize.fn('MAX', sequelize.col("RecNo")), "RecNo"],
                        //         [sequelize.fn('MAX', sequelize.col("MstSerNo")), "lastInsertedID"],
                        //         [sequelize.fn('MAX', sequelize.col("RepSerNo")), "masterRepSerNo"],
                        //     ],
                        //     where: {
                        //         ProductName: CurrentCubicalObj.Sys_ProductName,
                        //         // IdsNo: CurrentCubicalObj.Sys_IDSNo,
                        //         BatchNo: CurrentCubicalObj.Sys_Batch,
                        //         PVersion: CurrentCubicalObj.Sys_PVersion,
                        //         Version: CurrentCubicalObj.Sys_Version,
                        //         BFGCode: CurrentCubicalObj.Sys_BFGCode,
                        //         CubicleType: CurrentCubicalObj.Sys_CubType,
                        //         ReportType: CurrentCubicalObj.Sys_RptType,
                        //         Side: FriabilityDetail1.data.Side,

                        //     },
                        //     raw: true
                        // });
                        // checkEntry = checkEntry[0]
                        // var sqlquery = `SELECT * FROM tbl_tab_detail8 WHERE RepSerNo = (SELECT MAX(RepSerNo) FROM tbl_tab_master8 WHERE BatchNo = '${batchNo}') AND FinalWt = '0' AND Side = '${FriabilityDetail1.data.Side}' AND IdsNo = '${strHmi}' `

                        // var resBatch = await sequelize.query(sqlquery, {
                        //     type: QueryTypes.SELECT
                        // });
                        // //update WTAR2
                        // // sqlquery = `SELECT * FROM tbl_tab_detail8 WHERE RecNo = (SELECT MAX(RecNo) FROM tbl_tab_detail8 WHERE Side = '${FriabilityDetail1.data.Side}') AND UserID = '${FriabilityDetail1.data.userid}' AND UserName = '${FriabilityDetail1.data.userName}'  AND IdsNo = '${strHmi}' AND DataValue2 = 0`
                        // sqlquery = `SELECT * FROM tbl_tab_detail8 WHERE RecNo = (SELECT MAX(RecNo) FROM tbl_tab_detail8 WHERE RepSerNo = '${checkEntry.masterRepSerNo}' AND Side = '${FriabilityDetail1.data.Side}' AND IdsNo = '${strHmi}') AND UserId = '${FriabilityDetail1.data.userId}' AND UserName = '${FriabilityDetail1.data.userName}' AND FinalWt = '0' AND BalanceID = '${dataObj.instrumentId}'`

                        // resBatch = await sequelize.query(sqlquery, {
                        //     type: QueryTypes.SELECT
                        // });
                        // var result = await models.tbl_tab_master8.findAll({
                        //     attributes: [
                        //         // [sequelize.fn('MAX', sequelize.col("RecNo")), "RecNo"],
                        //         [sequelize.fn('MAX', sequelize.col("MstSerNo")), "SeqNo"],
                        //         [sequelize.fn('MAX', sequelize.col("RepSerNo")), "RepSerNo"],
                        //     ],
                        //     where: {
                        //         // 'IdsNo': strHmi,
                        //         BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                        //         ProductName: hmiDetailsInPMenu.Sys_ProductName,
                        //         BatchNo: hmiDetailsInPMenu.Sys_Batch,
                        //         ReportType: hmiDetailsInPMenu.Sys_RptType
                        //     },
                        //     raw: true
                        // })


                        let entry_lhsweight = await models.tbl_tab_friability.update({
                            RWtBeforeTest: receiveWt
                        }, {
                            where: {
                                RepSerNo: lstInsertId.masterRepSerNo,
                            }
                        });
                        await objInstrumentUsage.InstrumentUsage('Balance',
                            strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'Completed');

                        await models.tbl_powerbackup.update({
                            // Side_RepSerNo:result[0].RepSerNo,//03/12/23
                            RecSampleNo: tempCounterObj.counter,
                            Before_Count: tempCounterObj.counter,
                            EntryTimeStamp: addTime
                        }, {
                            where: {
                                CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
                                SelectedIds: SelectstrHmi,
                                WeighmentName: 'FRIAB',
                                IdsNo: strHmi
                            }
                        });

                        await models.tbl_powerbackup.update({
                            After_Count: 0,
                            // EntryTimeStamp: addTime
                        }, {
                            where: {
                                CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
                                IdsNo: strHmi,
                                WeighmentName: 'FRIAB'
                            }
                        });
                        let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
                        let autoTare = hmiEntryinConfig[0].AutoTare;
                        let tareCommand = hmiEntryinConfig[0].Tare_Command

                        await objMonit.monit({
                            case: 'TestWeight', Hmi: strHmi, data: {
                                Weight: `${Number(
                                    receiveWt
                                )} ${unit}`, srNo: "", message: 'InitialWeight'
                            }
                        });
                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBR2:${receiveWt + " " + unit}`);

                        //monit



                        // if (autoTare) {
                        //     mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                        // }

                        let timeForMenuDisable = globalData.arrTimeForMenuDisable.find(k => k.Hmi == strHmi);
                        if (timeForMenuDisable == undefined) {
                            globalData.arrTimeForMenuDisable.push({
                                Hmi: strHmi,
                                idsNo: strIdsNo,
                                // timeForMenuHide: removeTimeForMenuDisable,
                                formatedTime: dateFormat1
                            })
                        } else {
                            // timeForMenuDisable.timeForMenuHide = removeTimeForMenuDisable;
                            timeForMenuDisable.timeForMenuHide = dateFormat1;

                        }

                        // }

                    }
                    //FRIABILITY BEFORE SAMPLE COMPLETED, NOW WAIT FOR 

                    globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi) == -1 ?
                        globalData.arrWeighmentCounterForFriab :
                        globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi), 1);


                    if (FriabilityDetail1.data.Rotary == "Single") {
                        // setTimeout(()=>{mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}FRIAB Test Completed`)},1000);

                        setTimeout(() => { mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Friability Before Samples Completed, now wait for  ${removeTimeForMenuDisable.toFixed(0)} mins`) }, 1000);
                    } else if (FriabilityDetail1.data.Rotary == "Double" && tempCounterObj.counter == 2) {
                        setTimeout(() => { mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Friability Before Samples Completed, now wait for ${removeTimeForMenuDisable.toFixed(0)} mins`) }, 1000);
                    }

                } else {

                    let now = new Date();
                    let timeForMenuDisable = globalData.arrTimeForMenuDisable.find(k => k.Hmi == strHmi);
                    // let initSampletime = new Date(date.format(new Date(), 'YYYY-MM-DD HH:mm:ss'))
                    var initSampletime = moment(powerbacc.EntryTimeStamp).format("MM/DD/YYYY  hh:mm:ss")
                    let currentTime = new Date(date.format(new Date(), 'YYYY-MM-DD HH:mm:ss'))
                    // console.log(this.DateFormat(now, time));
                    // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.selectedIds.Idsno == strHmi);
                    // if (IPQCObject != undefined) {
                    //     strHmi = IPQCObject.idsNo;
                    // } else {
                    //     strHmi = strHmi;
                    // }
                    //No RptType
                    var checkEntry = await models.tbl_tab_friability.findAll({
                        attributes: [
                            // [sequelize.fn('MAX', sequelize.col("RecNo")), "RecNo"],
                            [sequelize.fn('MAX', sequelize.col("MstSerNo")), "lastInsertedID"],
                            [sequelize.fn('MAX', sequelize.col("RepSerNo")), "masterRepSerNo"],
                            [sequelize.fn('MAX', sequelize.col("DecimalPoint")), "DecimalPoint"],
                        ],
                        where: {
                            ProductName: CurrentCubicalObj.Sys_ProductName,
                            IdsNo: strHmi,
                            BatchNo: CurrentCubicalObj.Sys_Batch,
                            PVersion: CurrentCubicalObj.Sys_PVersion,
                            Version: CurrentCubicalObj.Sys_Version,
                            BFGCode: CurrentCubicalObj.Sys_BFGCode,
                            CubicleType: CurrentCubicalObj.Sys_CubType,
                            ReportType: CurrentCubicalObj.Sys_RptType,
                            // Side: FriabilityDetail1.data.Side,

                        },
                        raw: true
                    });
                    checkEntry = checkEntry[0]
                    var deciaml = checkEntry.DecimalPoint
                    receiveWt = Number(receiveWt).toFixed(deciaml)
                    // var sqlquery = `SELECT * FROM tbl_tab_detail8 WHERE RecNo = (SELECT MAX(RecNo) FROM tbl_tab_detail8 WHERE RepSerNo = '${checkEntry.masterRepSerNo}' AND Side = '${FriabilityDetail1.data.Side}' AND IdsNo = '${strHmi}') AND UserId = '${FriabilityDetail1.data.userId}' AND UserName = '${FriabilityDetail1.data.userName}' AND FinalWt = '0' AND BalanceID = '${dataObj.instrumentId}'`
                    // // sqlquery = `SELECT * FROM tbl_tab_detail8 WHERE RecNo = (SELECT MAX(RecNo) FROM tbl_tab_detail8 WHERE Side = '${FriabilityDetail1.data.Side}') AND UserID = '${FriabilityDetail1.data.userid}' AND UserName = '${FriabilityDetail1.data.userName}'  AND IdsNo = '${strHmi}' AND DataValue2 = 0`
                    // var resBatch = await sequelize.query(sqlquery, {
                    //     type: QueryTypes.SELECT
                    // });
                    if (Date.parse(currentTime) >= Date.parse(powerbacc.EntryTimeStamp)) {
                        let __paramProductData = {
                            ProductId: __parameterFriability.objProductDetails.ProductId,
                            ProductName: __parameterFriability.objProductDetails.ProductName,
                            ProductVersion: __parameterFriability.objProductDetails.ProductVersion,
                            Version: __parameterFriability.objProductDetails.Version,
                            Batch: __parameterFriability.Batch,
                            uniqueSerialNumber: __parameterFriability.strHmi
                        }

                        if (FriabilityDetail1.data.Rotary == "Single") {
                            tempCounterObjAfter.counter = 0;
                        }


                        //after enable menu 
                        //clear this array tempCounterObj.counter
                        if (tempCounterObjAfter.counter == 0) {
                            // lstInsertId = await this.saveToBalanceCompleteData(__parameterFriability, productDetail);
                            //dislay wt ${mqttProtocol.DisplayResult}
                            var result = await this.checkProductData(__paramProductData, __parameterFriability.strHmi);
                            // const selectData = {
                            //     str_tableName: 'tbl_tab_friability',
                            //     data: '*',
                            //     condition: [
                            //         { str_colName: 'MstSerNo', value: result[0][0].SeqNo }
                            //     ]
                            // }
                            // let resSelectFri = await database.select(selectData);
                            // let resSelectFri = await models.tbl_tab_friability.findAll({
                            //     where: {
                            //         RecSeqNo: resBatch[0].RecSeqNo
                            //     }
                            // })
                            // resSelectFri = resSelectFri[0];




                            //powerbackup

                            var updateData;
                            if (FriabilityDetail1.data.Rotary == "Single") {

                                await models.tbl_tab_friability.update({
                                    LWtAfterTest: receiveWt,
                                    PrEndTime: moment().format('HH:mm:ss'),
                                    PrEndDate: date.format(new Date(), 'YYYY-MM-DD')
                                }, {
                                    where: {
                                        // RecNo: resBatch[0].RecNo,
                                        // 'MstSerNo': result[0].SeqNo,
                                        "RepSerNo": result[0].RepSerNo,
                                        // IdsNo: strHmi
                                        // 'BFGCode': __parameterFriability.objProductDetails.ProductId,
                                        // 'ProductName': __parameterFriability.objProductDetails.ProductName,
                                        // 'PVersion': __parameterFriability.objProductDetails.ProductVersion,
                                        // 'Version': __parameterFriability.objProductDetails.Version,
                                        // 'BatchNo': __parameterFriability.Batch,
                                        // 'IdsNo': __parameterFriability.uniqueSerialNumber,
                                    }
                                });


                                // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
                                // if (IPQCObject != undefined) {
                                //     strHmi = IPQCObject.selectedIds.Idsno;
                                // } else {
                                //     strHmi = strHmi;
                                // }
                                var NWtBeforeTest = mathj.round((((result.LWtBeforeTest - receiveWt) * 100) / result.LWtBeforeTest), 3).toFixed(3);
                                await objInstrumentUsage.InstrumentUsage('Balance',
                                    strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'Completed');
                                var NMT = __parameterFriability.productType.nominal
                                var drum1 = NWtBeforeTest
                                var remark1

                                // if (Number(NMT) >= Number(drum1)) {
                                //     remark1 = 'Complies'
                                // } else {
                                //     remark1 = 'Not Complies'
                                // }
                                // if (((drum1).includes('-'))) {
                                //     remark1 = 'Not Complies'
                                // } else {
                                //     if (Number(NMT) >= Number(drum1)) {
                                //         remark1 = 'Complies'
                                //     } else {
                                //         remark1 = 'Not Complies'
                                //     }
                                // }
                                NWtBeforeTest = ((drum1).includes('-')) ? 0 : NWtBeforeTest;
                                drum1 = NWtBeforeTest;
                                if ((drum1) == 0) {
                                    remark1 = 'Complies'
                                    // remark1 = 1
                                } else {
                                    if (Number(NMT) > Number(drum1)) {
                                        remark1 = 'Not Complies'
                                        // remark1 = 0
                                    } else {
                                        remark1 = 'Complies'
                                        // remark1 = 1
                                    }
                                }

                                // NWtBeforeTest = (Math.ceil(NWtBeforeTest * 1000) / 1000).toFixed(3)

                                await models.tbl_tab_friability.update({
                                    // LWtPercentage: maths.round(Number(NWtBeforeTest), 3).toFixed(3),
                                    LWtPercentage: (Number(NWtBeforeTest)).toFixed(3),
                                    Remark: remark1,
                                    Inprocess: 0,
                                }, {
                                    where: {
                                        // RecNo: resBatch[0].RecNo,
                                        RepSerNo: result[0].RepSerNo,
                                    }
                                });
                            } else {

                                if ((tempCounterObj.counter != 0 && tempCounterObjAfter.counter == 0)) {
                                    // if (FriabilityDetail1.data.Side == resBatch[0].Side) {
                                    await models.tbl_tab_friability.update({
                                        LWtAfterTest: receiveWt,
                                        PrEndTime: moment().format('HH:mm:ss'),
                                        PrEndDate: date.format(new Date(), 'YYYY-MM-DD')
                                    }, {
                                        where: {
                                            // RecNo: resBatch[0].RecNo,
                                            RepSerNo: result[0].RepSerNo,
                                            // Side: resBatch[0].Side,
                                            IdsNo: strHmi,
                                        }
                                    });
                                }
                                // }


                            }

                            // uppdate according to double rotary
                            let respSelectFri = await models.tbl_tab_friability.findAll({
                                where: {
                                    RepSerNo: result[0].RepSerNo,
                                }
                            })
                            respSelectFri = respSelectFri[0];


                            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
                            // if (IPQCObject != undefined) {
                            //     strHmi = IPQCObject.selectedIds.Idsno;
                            // } else {
                            //     strHmi = strHmi;
                            // }



                            //powerbackup

                            await models.tbl_powerbackup.update({
                                After_Count: 1
                            }, {
                                where: {
                                    'CubicalNo': powerbacc.CubicalNo,
                                    SelectedIds: SelectstrHmi,
                                    WeighmentName: 'FRIAB',
                                    IdsNo: strHmi

                                }
                            })
                            var NMT = __parameterFriability.productType.nominal
                            var NWBeforeTest = mathj.round((((respSelectFri.LWtBeforeTest - receiveWt) * 100) / respSelectFri.LWtBeforeTest), 3).toFixed(3);
                            var drum1 = NWBeforeTest
                            var remark1

                            // if (Number(NMT) >= Number(drum1)) {
                            //     remark1 = 'Complies'
                            // } else {
                            //     remark1 = 'Not Complies'
                            // }
                            // if (((drum1).includes('-'))) {
                            //     remark1 = 'Not Complies'
                            // } else {
                            //     if (Number(NMT) >= Number(drum1)) {
                            //         remark1 = 'Complies'
                            //     } else {
                            //         remark1 = 'Not Complies'
                            //     }
                            // }
                            NWBeforeTest = ((drum1).includes('-')) ? 0 : NWBeforeTest;
                            drum1 = NWBeforeTest;
                            if ((drum1) == 0) {
                                remark1 = 'Complies'
                                // remark1 = 1
                            } else {
                                if (Number(NMT) > Number(drum1)) {
                                    remark1 = 'Complies'
                                    // remark1 = 0
                                } else {
                                    remark1 = 'Not Complies'
                                    // remark1 = 1
                                }
                            }

                            var lastId = await models.tbl_tab_friability.findAll({
                                where: {
                                    RepSerNo: result[0].RepSerNo,
                                }
                            })

                            if (FriabilityDetail1.data.Rotary == "Single") {

                                let NWtBeforeTest = mathj.round((((respSelectFri.InitialWt - respSelectFri.FinalWt) * 100) / respSelectFri.InitialWt), 3).toFixed(3);
                                var batchSummaryObject = {
                                    BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                                    ProductName: hmiDetailsInPMenu.Sys_ProductName,
                                    PVersion: hmiDetailsInPMenu.Sys_PVersion,
                                    Version: hmiDetailsInPMenu.Sys_Version,
                                    PrdType: 1,
                                    CubType: hmiDetailsInPMenu.Sys_CubType,
                                    BatchNo: hmiDetailsInPMenu.Sys_Batch,
                                    Unit: hmiDetailsInPMenu.Sys_BatchSizeUnit,
                                    Side: FriabilityDetail1.data.side,
                                    InstrumentID: respSelectFri.Sys_FriabID,
                                    UserId: tempUserObject.UserId,
                                    UserName: tempUserObject.UserName,
                                    nwtBeforeTest: NWtBeforeTest,
                                    lwtBeforeTest: respSelectFri.InitialWt,
                                    lwtAfterTest: respSelectFri.FinalWt,
                                    Dept: hmiDetailsInPMenu.Sys_dept,
                                    Nom: Number(productDetail.productDetail[0][0].Param8_Nom).toFixed(2),
                                    PrTime: moment(lastId[0].PrTime).format('HH:mm:ss'),
                                    PrDate: date.format(new Date(), 'YYYY-MM-DD'),
                                    remark1: remark1
                                }

                            }

                            // NWtBeforeTest = (Math.ceil(NWBeforeTest * 1000) / 1000).toFixed(3)

                            await models.tbl_tab_friability.update({
                                // LWtPercentage: (Number(NWtBeforeTest)),
                                LWtPercentage: (Number(NWBeforeTest)).toFixed(3),
                                LWtRemark: remark1,
                                Inprocess: 0,
                                // Remark: remark1
                            }, {
                                where: {
                                    // RecNo: resBatch[0].RecNo,
                                    RepSerNo: result[0].RepSerNo,
                                }
                            });
                            if (FriabilityDetail1.data.Rotary == "Double") {


                                // let NWtBeforeTest = (((respSelectFri.InitialWt - respSelectFri.FinalWt) * 100) / respSelectFri.InitialWt).toFixed(5);
                                var batchSummaryObject = {
                                    BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                                    ProductName: hmiDetailsInPMenu.Sys_ProductName,
                                    PVersion: hmiDetailsInPMenu.Sys_PVersion,
                                    Version: hmiDetailsInPMenu.Sys_Version,
                                    PrdType: 1,
                                    CubType: hmiDetailsInPMenu.Sys_CubType,
                                    BatchNo: hmiDetailsInPMenu.Sys_Batch,
                                    Unit: hmiDetailsInPMenu.Sys_BatchSizeUnit,
                                    Side: FriabilityDetail1.data.Rotary,
                                    InstrumentID: respSelectFri.FriabilityID,
                                    UserId: tempUserObject.UserId,
                                    UserName: tempUserObject.UserName,
                                    nwtBeforeTest: NWBeforeTest,
                                    lwtBeforeTest: respSelectFri.LWtBeforeTest,
                                    lwtAfterTest: respSelectFri.LWtAfterTest,
                                    Dept: hmiDetailsInPMenu.Sys_dept,
                                    Nom: Number(productDetail.productDetail[0][0].Param8_Nom).toFixed(2),
                                    PrTime: moment(lastId[0].PrTime).format('HH:mm:ss'),
                                    PrDate: date.format(new Date(), 'YYYY-MM-DD'),
                                    remark1: remark1
                                }
                                await objBatchSummary.saveBatchSummaryFriability(batchSummaryObject, strIdsNo, FriabilityDetail1.data.Side);

                            }
                            let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
                            let autoTare = hmiEntryinConfig[0].AutoTare;
                            let tareCommand = hmiEntryinConfig[0].Tare_Command
                            if (FriabilityDetail1.data.Rotary == "Single") {
                                await objBatchSummary.saveBatchSummaryFriability(batchSummaryObject, strIdsNo, FriabilityDetail1.data.Side);
                                let nwtD1 = (((resSelectFri.InitialWt - receiveWt) * 100) / resSelectFri.InitialWt).toFixed(5);
                                mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBL1:${resSelectFri.InitialWt};WTAL1:${receiveWt + " " + unit};NWTD1:${receiveWt} ${unit}`);
                                const objUpdateValidation = await models.tbl_cubical.update({
                                    'Sys_Validation': 0
                                }, {
                                    where: {
                                        'Sys_IDSNo': strHmi
                                    }

                                });
                                //monit

                                await objMonit.monit({
                                    case: 'TestWeight', Hmi: strHmi, data: {
                                        Weight: `${Number(
                                            receiveWt
                                        )} ${unit}`, srNo: "", message: 'FinalWeight'
                                    }
                                });

                                if (autoTare) {
                                    mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                                }
                            } else {

                                let respSelect = await models.tbl_tab_friability.findAll({
                                    where: {
                                        RepSerNo: result[0].RepSerNo,
                                    }
                                })
                                respSelect = respSelect[0];
                                await objMonit.monit({
                                    case: 'TestWeight', Hmi: strHmi, data: {
                                        Weight: `${Number(
                                            receiveWt
                                        )} ${unit}`, srNo: "", message: 'FinalWeight'
                                    }
                                });
                                mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBL1:${respSelect.InitialWt} ${unit};WTAL1:${receiveWt + " " + unit};NWTD1:${receiveWt} ${unit}`);
                                //monit



                            }
                            // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTAL1:${receiveWt + " " + unit}`);
                            if (autoTare) {
                                mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                            }
                            if (FriabilityDetail1.data.Rotary == "Double") {
                                mqttSender.sendData(strHmi, `${mqttProtocol.Sideprotocol}${tempSide}`);

                            }
                            if (autoTare) {
                                mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                            }

                        }

                        if (FriabilityDetail1.data.Rotary == "Double") {
                            tempCounterObjAfter.counter += 1;
                        }



                        if (tempCounterObjAfter.counter == 2) {
                            //update WTAR2
                            var result = await this.checkProductData(__paramProductData, strHmi);

                            let resSelectFri = await models.tbl_tab_friability.findAll({
                                where: {
                                    RepSerNo: result[0].RepSerNo,
                                    IdsNo: strHmi
                                }
                            })
                            resSelectFri = resSelectFri;

                            let nwtAfterTest;
                            let
                                nwtBeforeTest;
                            resSelectFri = resSelectFri.pop()
                            nwtBeforeTest = mathj.round((((resSelectFri.LWtBeforeTest - resSelectFri.LWtAfterTest) * 100) / resSelectFri.LWtBeforeTest), 3).toFixed(3);
                            nwtAfterTest = mathj.round((((resSelectFri.RWtBeforeTest - receiveWt) * 100) / resSelectFri.RWtBeforeTest), 3).toFixed(3);
                            if (result) {
                                //update WTAR2
                                var result = await models.tbl_tab_friability.findAll({
                                    attributes: [
                                        // [sequelize.fn('MAX', sequelize.col("RecNo")), "RecNo"],
                                        // [sequelize.fn('MAX', sequelize.col("MstSerNo")), "SeqNo"],
                                        [sequelize.fn('MAX', sequelize.col("RepSerNo")), "RepSerNo"],
                                    ],
                                    where: {
                                        'RepSerNo': result[0].RepSerNo,
                                        // 'Side': FriabilityDetail1.data.Side,
                                        IdsNo: strHmi
                                    },
                                    raw: true
                                })
                                const updateData = await models.tbl_tab_friability.update({

                                    RWtAfterTest: receiveWt,
                                    PrEndTime: moment().format('HH:mm:ss'),
                                    PrEndDate: date.format(new Date(), 'YYYY-MM-DD')
                                }, {
                                    where: {
                                        RepSerNo: result[0].RepSerNo,
                                        IdsNo: strHmi
                                        // 'BFGCode': __parameterFriability.objProductDetails.ProductId,
                                        // 'ProductName': __parameterFriability.objProductDetails.ProductName,
                                        // 'PVersion': __parameterFriability.objProductDetails.ProductVersion,
                                        // 'Version': __parameterFriability.objProductDetails.Version,
                                        // 'BatchNo': __parameterFriability.Batch,
                                        // 'IdsNo': __parameterFriability.uniqueSerialNumber
                                        // NWtAfterTest: nwtAfterTest
                                    }
                                });
                                //  result = await models.tbl_tab_detail8.findAll({
                                //     where: {
                                //         'RepSerNo': result[0].RepSerNo,
                                //         'Side': FriabilityDetail1.data.Side,
                                //         IdsNo: strHmi
                                //     },
                                //     raw: true
                                // })
                                var NMT = __parameterFriability.productType.nominal
                                var drum1 = nwtAfterTest
                                var drum2 = nwtBeforeTest
                                var remark1
                                var remark2

                                // if (Number(NMT) >= Number(drum1)) {
                                //     remark1 = 'Complies'
                                // } else {
                                //     remark1 = 'Not Complies'
                                // }
                                nwtAfterTest = ((drum1).includes('-')) ? 0 : nwtAfterTest;
                                drum1 = nwtAfterTest;
                                nwtBeforeTest = ((drum2).includes('-')) ? 0 : nwtBeforeTest;
                                drum2 = nwtBeforeTest;
                                if ((((drum2) == 0))) {
                                    remark2 = 'Complies'
                                } else {
                                    if (Number(NMT) >= Number(drum2)) {
                                        remark2 = 'Complies'
                                    } else {
                                        remark2 = 'Not Complies'
                                    }
                                }
                                if ((((drum1) == 0))) {
                                    remark1 = 'Complies'
                                } else {
                                    if (Number(NMT) >= Number(drum1)) {
                                        remark1 = 'Complies'
                                    } else {
                                        remark1 = 'Not Complies'
                                    }
                                }
                                var finalRemark = 'Complies'
                                if (remark1 == 'Not Complies' || remark2 == 'Not Complies') {
                                    finalRemark = 'Not Complies'
                                }
                                // let finalRemark = resSelectFri.Remark == 'Not Complies' ? 'Not Complies' : remark1
                                await models.tbl_tab_friability.update({
                                    // RWtPercentage: maths.round(Number(nwtAfterTest), 3).toFixed(3),
                                    RWtPercentage: (Number(nwtAfterTest)).toFixed(3),
                                    RWtRemark: remark1,
                                    Inprocess: 0,
                                    Remark: finalRemark
                                }, {
                                    where: {
                                        // RecNo: resBatch[0].RecNo,
                                        RepSerNo: result[0].RepSerNo,
                                    }
                                });
                                // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
                                // if (IPQCObject != undefined) {
                                //     strHmi = IPQCObject.selectedIds.Idsno;
                                // } else {
                                //     strHmi = strHmi;
                                // }
                                await objInstrumentUsage.InstrumentUsage('Balance',
                                    strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'Completed');

                                //power backup
                                const updateDataPower = await models.tbl_powerbackup.update({
                                    'CubicalNo': hmiDetailsInPMenu.Sys_CubicNo,
                                    'WeightmentType': 8,
                                    'RepSerno': result[0].RepSerNo
                                }, {
                                    where: {
                                        After_Count: tempCounterObjAfter.counter,
                                        WeighmentName: 'FRIAB',
                                        IdsNo: strHmi
                                    }

                                })

                                var lastId = await models.tbl_tab_friability.findAll({
                                    where: {
                                        RepSerNo: result[0].RepSerNo,
                                    }
                                })

                                // await database.update(updateDataPower);
                                let batchSummaryObject = {
                                    BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                                    ProductName: hmiDetailsInPMenu.Sys_ProductName,
                                    PVersion: hmiDetailsInPMenu.Sys_PVersion,
                                    Version: hmiDetailsInPMenu.Sys_Version,
                                    PrdType: 1,
                                    CubType: hmiDetailsInPMenu.Sys_CubType,
                                    BatchNo: hmiDetailsInPMenu.Sys_Batch,
                                    Unit: hmiDetailsInPMenu.Sys_BatchSizeUnit,
                                    Side: FriabilityDetail1.data.Rotary,
                                    InstrumentID: resSelectFri.FriabilityID,
                                    UserId: tempUserObject.UserId,
                                    UserName: tempUserObject.UserName,

                                    nwtBeforeTest: nwtAfterTest,
                                    nwtAfterTest: nwtAfterTest,
                                    lwtBeforeTest: resSelectFri.LWtBeforeTest,
                                    lwtAfterTest: receiveWt,
                                    rwtBeforeTest: resSelectFri.RWtBeforeTest,
                                    rwtAfterTest: receiveWt,
                                    Dept: hmiDetailsInPMenu.Sys_dept,
                                    Nom: Number(productDetail.productDetail[0][0].Param8_Nom).toFixed(2),
                                    PrTime: moment(lastId[0].PrTime).format('HH:mm:ss'),
                                    PrDate: date.format(now, 'YYYY-MM-DD'),
                                    remark1: remark1
                                }




                                await objBatchSummary.saveBatchSummaryFriability(batchSummaryObject, strIdsNo, FriabilityDetail1.data.Side);
                                // await objCommonInsertOpt.updateEndDate(strIdsNo, strHmi, 'tbl_tab_master8');
                                const objUpdateValidation = await models.tbl_cubical.update({
                                    'Sys_Validation': 0
                                }, {
                                    where: {
                                        'Sys_IDSNo': strHmi
                                    }

                                });
                                await models.tbl_powerbackup.destroy({
                                    where: {
                                        'CubicalNo': powerbacc.CubicalNo,
                                        WeighmentName: 'FRIAB',
                                        IdsNo: strHmi
                                    }
                                });
                                if (hmiDetailsInPMenu.Sys_RotaryType == 'Double') {
                                    if (Side.length == 1) {
                                        if (Side[0] == 'LHS') {
                                            Side = 'RHS'
                                        } else {
                                            Side = 'LHS'
                                        }
                                        //    if(Number(sample) == Number(tempCounterObj.counter)){
                                        mqttSender.sendData(strHmi, `${mqttProtocol.SideChange}:${tempSide}`);
                                        let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
                                        let autoTare = hmiEntryinConfig[0].AutoTare;
                                        let tareCommand = hmiEntryinConfig[0].Tare_Command
                                        if (autoTare) {
                                            mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                                        }

                                        //    } 
                                    } else {
                                        Object.assign(objActivity,
                                            { strUserId: tempUserObject.UserId },
                                            { strUserName: tempUserObject.UserName },
                                            { activity: activityLogMsg });

                                        await objActivityLog.ActivityLogEntry(objActivity);
                                        // await objInstrumentUsage.InstrumentUsage('Balance', strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'completed');
                                        var respSelect = await models.tbl_tab_friability.findAll({
                                            where: {
                                                RepSerno: result[0].RepSerNo
                                            }
                                        })
                                        respSelect = respSelect[0];
                                        await objMonit.monit({
                                            case: 'TestWeight', Hmi: strHmi, data: {
                                                Weight: `${Number(
                                                    receiveWt
                                                )} ${unit}`, srNo: "", message: 'FinalWeight'
                                            }
                                        });
                                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBR2:${respSelect.RWtBeforeTest} ${unit};WTAR2:${receiveWt + " " + unit};NWTD2:${receiveWt} ${unit}`);

                                        //monit


                                        //mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTAR2:${receiveWt + " " + unit}`);

                                        globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi) == -1 ?
                                            globalData.arrWeighmentProductData :
                                            globalData.arrWeighmentProductData.splice(globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi), 1);

                                        globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi) == -1 ?
                                            globalData.arrProductTypeArray :
                                            globalData.arrProductTypeArray.splice(globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi), 1);

                                        globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi) == -1 ?
                                            globalData.arrWeighmentCounterForFriab :
                                            globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi), 1);

                                        (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus :
                                            globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);
                                        //test splice if rotarty is not double
                                        globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
                                            globalData.arrSelectedMenu :
                                            globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);

                                        globalData.arrWeighmentCounterAfter.findIndex(k => k.Hmi == strHmi) == -1 ?
                                            globalData.arrWeighmentCounterAfter :
                                            globalData.arrWeighmentCounterAfter.splice(globalData.arrWeighmentCounterAfter.findIndex(k => k.Hmi == strHmi), 1);
                                        globalData.DoubSideForFriab.findIndex(k => k.Hmi == strHmi) == -1 ? globalData.DoubSideForFriab : globalData.DoubSideForFriab.splice(globalData.DoubSideForFriab.findIndex(k => k.Hmi == strHmi), 1);

                                        // if (remark1 == "Not Complies") {
                                        //     var reportLimitMsg = "Report Out Of Limit"
                                        // }
                                        // else {
                                        //     reportLimitMsg = "Report Within Limit"
                                        // }

                                        // setTimeout(() => { mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}${reportLimitMsg}`) }, 1000);

                                        setTimeout(() => { mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted} Test Completed`) }, 1000);

                                        // mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}FRIAB Test Completed`);
                                    }

                                    return

                                }
                            }


                        }
                        tempCounterObjAfter = globalData.arrWeighmentCounterAfter.find(k => k.Hmi == strHmi);
                        Object.assign(objActivity,
                            { strUserId: tempUserObject.UserId },
                            { strUserName: tempUserObject.UserName },
                            { activity: activityLogMsg });

                        await objActivityLog.ActivityLogEntry(objActivity);
                        if (tempCounterObjAfter != undefined) {
                            if (tempCounterObjAfter.counter == 0 || FriabilityDetail1.data.Rotary == "Single") {
                                //batch summary 


                                await models.tbl_powerbackup.destroy({
                                    where: {
                                        'CubicalNo': powerbacc.CubicalNo,
                                        WeighmentName: 'FRIAB',
                                        IdsNo: strHmi
                                    }
                                })

                                let updateFriability = await models.tbl_tab_master8.update({
                                    PrEndDate: date.format(new Date(), 'YYYY-MM-DD'),
                                    PrEndTime: date.format(new Date(), 'HH:mm:ss')
                                }, {
                                    where: {
                                        RepSerNo: result[0].RepSerNo
                                    }
                                })


                                Object.assign(objActivity,
                                    { strUserId: tempUserObject.UserId },
                                    { strUserName: tempUserObject.UserName },
                                    { activity: activityLogMsg });

                                await objActivityLog.ActivityLogEntry(objActivity);
                                // await objInstrumentUsage.InstrumentUsage('Balance', strHmi, 'tbl_instrumentlog_balance', 'Friability', 'completed');

                                globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi) == -1 ?
                                    globalData.arrWeighmentProductData :
                                    globalData.arrWeighmentProductData.splice(globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi), 1);

                                globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi) == -1 ?
                                    globalData.arrProductTypeArray :
                                    globalData.arrProductTypeArray.splice(globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi), 1);

                                globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi) == -1 ?
                                    globalData.arrWeighmentCounterForFriab :
                                    globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi), 1);

                                (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus :
                                    globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);
                                //test splice if rotarty is not double
                                globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
                                    globalData.arrSelectedMenu :
                                    globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);


                                // if (remark1 == "Not Complies") {
                                //     var reportLimitMsg = "Report Out Of Limit"
                                // }
                                // else {
                                //     reportLimitMsg = "Report Within Limit"
                                // }

                                // setTimeout(() => { mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}${reportLimitMsg}`) }, 1000);


                                setTimeout(() => { mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted} Test Completed`) }, 1000);
                                //monit
                                await objMonit.monit({
                                    case: 'ReportStatus', Hmi: strHmi, data: {
                                        message: 'Friability Test Completed'
                                    }
                                });

                            }
                        }


                    } else {

                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Friability is blocked for ${removeTimeForMenuDisable.toFixed(0)} min`);
                    }




                }
            } else {

                if ((tempCounterObj.counter == 0) && (tempCounterObjAfter.counter == 0)) {
                    //send wt  before for both side

                    if (tempCounterObj.counter == 0) {

                        __activityObj = {
                            strUserId: tempUserObject.UserId,
                            strUserName: tempUserObject.UserName,
                            activity: `${mqttProtocol.Friability} Weighment Started on TSH ${strHmi}`
                        }


                        await objActivityLog.ActivityLogEntry(__activityObj);


                        /**
                         * Differntiated logon to insert according to double and single
                         */

                        //master entry 
                        // const checkEntry = await models.tbl_tab_master8.findAll({
                        //     attributes: [
                        //         // [sequelize.fn('MAX', sequelize.col("RecNo")), "RecNo"],
                        //         [sequelize.fn('MAX', sequelize.col("MstSerNo")), "lastInsertedID"],
                        //         [sequelize.fn('MAX', sequelize.col("RepSerNo")), "masterRepSerNo"],
                        //     ],
                        //     where: {
                        //         ProductName: CurrentCubicalObj.Sys_ProductName,
                        //         // IdsNo: CurrentCubicalObj.Sys_IDSNo,
                        //         BatchNo: CurrentCubicalObj.Sys_Batch,
                        //         PVersion: CurrentCubicalObj.Sys_PVersion,
                        //         Version: CurrentCubicalObj.Sys_Version,
                        //         BFGCode: CurrentCubicalObj.Sys_BFGCode,
                        //         CubicleType: CurrentCubicalObj.Sys_CubType,
                        //         ReportType: CurrentCubicalObj.Sys_RptType,
                        //         Side: FriabilityDetail1.data.Side,
                        //     },
                        //     raw: true
                        // });

                        // if (checkEntry[0].lastInsertedID == null) {
                        lstInsertId = await this.saveToBalanceCompleteData(__parameterFriability, productDetail);
                        //dislay wt ${mqttProtocol.DisplayResult}
                        // }
                        // if (checkEntry[0].lastInsertedID != null) {

                        //     lstInsertId = checkEntry[0]

                        // }
                        // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.selectedIds.Idsno == strHmi);
                        // if (IPQCObject != undefined) {
                        //     strHmi = IPQCObject.idsNo;
                        // } else {
                        //     strHmi = strHmi;
                        // }

                        //detailEntry
                        let entry_lhsweight = await models.tbl_tab_friability.update({
                            LWtBeforeTest: receiveWt
                        }, {
                            where: {
                                RepSerNo: lstInsertId.masterRepSerNo,
                            }
                        });
                        // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
                        // if (IPQCObject != undefined) {
                        //     strHmi = IPQCObject.selectedIds.Idsno;
                        // } else {
                        //     strHmi = strHmi;
                        // }
                        await objInstrumentUsage.InstrumentUsage('Balance',
                            strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'Completed');

                        var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
                        var SelectedIdsNo
                        if (IPQCObject != undefined) {
                            SelectedIdsNo = IPQCObject.selectedIds.Idsno;
                        } else {
                            SelectedIdsNo = strHmi;
                        }
                        const obj = {
                            'CubicalNo': hmiDetailsInPMenu.Sys_CubicNo,
                            // 'WeighmentType': 8,
                            'WeighmentName': 'FRIAB',
                            'Userid': tempUserObject.UserId,
                            'ReportType': hmiDetailsInPMenu.Sys_RptType,
                            // 'RotartyType': hmiDetailsInPMenu.Sys_RotaryType,
                            'Sys_CubType': 1,
                            'Sys_Batch': batchNo,
                            'Sys_BFGCode': hmiDetailsInPMenu.Sys_BFGCode,
                            'Before_Count': 1,
                            'After_Count': 0,
                            "Idsno": strHmi,
                            // 'Time': dateFormat, comp: 'eq',
                            'Incomp_RepSerNo': lstInsertId.masterRepSerNo,
                            'RecSampleNo': 1,
                            'SeqNo': 0,
                            SelectedIds: SelectedIdsNo
                        }


                        if (FriabilityDetail1.data.Rotary == "Single") {
                            Object.assign(obj, { 'EntryTimeStamp': addTime })
                            await models.tbl_powerbackup.create(obj)

                        }
                        // await database.save(saveFriabilityPowerBackup)
                        if (FriabilityDetail1.data.Rotary == "Double" && powerbacc == undefined) {
                            await models.tbl_powerbackup.create(obj)

                        } else {
                            //update
                            // Object.assign(obj, { 'EntryTimeStamp': addTime })
                            if (FriabilityDetail1.data.Rotary == "Double" && powerbacc.Before_Count == 1) {
                                await models.tbl_powerbackup.update({
                                    EntryTimeStamp: addTime
                                }, {
                                    where: {
                                        CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
                                        WeighmentName: 'FRIAB',
                                        IdsNo: strHmi
                                    }
                                })
                            }
                        }
                        let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
                        let autoTare = hmiEntryinConfig[0].AutoTare;
                        let tareCommand = hmiEntryinConfig[0].Tare_Command

                        await objMonit.monit({
                            case: 'TestWeight', Hmi: strHmi, data: {
                                Weight: `${Number(
                                    receiveWt
                                )}  ${unit}`, srNo: "", message: ''
                            }
                        });

                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBL1:${receiveWt + " " + unit}`);
                        if (FriabilityDetail1.data.Rotary == "Double") {
                            mqttSender.sendData(strHmi, `${mqttProtocol.Sideprotocol}${tempSide}`);
                            if (autoTare) {
                                mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                            }

                        }
                    }

                    if (FriabilityDetail1.data.Rotary == "Double") {
                        tempCounterObj.counter += 1;
                        let timeForMenuDisable = globalData.arrTimeForMenuDisable.find(k => k.Hmi == strHmi);
                        if (timeForMenuDisable == undefined) {
                            globalData.arrTimeForMenuDisable.push({
                                Hmi: strHmi,
                                idsNo: strIdsNo,
                                // timeForMenuHide: removeTimeForMenuDisable,
                                formatedTime: dateFormat1
                            })
                        } else {
                            // timeForMenuDisable.timeForMenuHide = removeTimeForMenuDisable;
                            timeForMenuDisable.timeForMenuHide = dateFormat1;

                        }
                        //left before wt drum 1 ka 
                    } else if (FriabilityDetail1.data.Rotary == "Single") {
                        // await objMonit.monit({
                        //     case: 'TestWeight', Hmi: strHmi, data: {
                        //         Weight: `${Number(
                        //             receiveWt
                        //         )}  ${unit}`, srNo: "", message: 'FinalWeight'
                        //     }
                        // });
                        tempCounterObjAfter.counter += 1;
                        let timeForMenuDisable = globalData.arrTimeForMenuDisable.find(k => k.Hmi == strHmi);
                        if (timeForMenuDisable == undefined) {
                            globalData.arrTimeForMenuDisable.push({
                                Hmi: strHmi,
                                idsNo: strIdsNo,
                                // timeForMenuHide: removeTimeForMenuDisable,
                                formatedTime: dateFormat1
                            })
                        } else {
                            // timeForMenuDisable.timeForMenuHide = removeTimeForMenuDisable;
                            timeForMenuDisable.timeForMenuHide = dateFormat1;

                        }
                    }


                    /**
                     * For Double update in RWtBeforeTest column
                     */
                    if (tempCounterObj.counter == 2) {
                        //update WTAR2
                        //No RptType
                        var result = await models.tbl_tab_master8.findAll({
                            attributes: [
                                // [sequelize.fn('MAX', sequelize.col("RecNo")), "RecNo"],
                                [sequelize.fn('MAX', sequelize.col("MstSerNo")), "SeqNo"],
                                [sequelize.fn('MAX', sequelize.col("RepSerNo")), "RepSerNo"],
                            ],
                            where: {
                                'Idsno': strHmi,
                            },
                            raw: true
                        })

                        await models.tbl_tab_detail8.create({
                            RepSerNo: result[0].RepSerNo,
                            MstSerNo: result[0].SeqNo,
                            RecSeqNo: 2,
                            InitialWt: receiveWt,
                            FinalWt: '0',
                            UserId: tempUserObject.UserId,
                            UserName: tempUserObject.UserName,
                            PrDate: moment().format('YYYY-MM-DD'),
                            PrTime: moment().format('HH:mm:ss'),
                            Side: FriabilityDetail1.data.Side,
                            DecimalPoint: this.precision(Number(receiveWt)),
                            BalanceID: dataObj.instrumentId,
                            IdsNo: strHmi
                        })
                        await objInstrumentUsage.InstrumentUsage('Balance',
                            strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'Completed');


                        //power backup


                        await models.tbl_powerbackup.update({
                            RecSampleNo: tempCounterObj.counter,
                            Before_Count: tempCounterObj.counter,
                            EntryTimeStamp: addTime
                        }, {
                            where: {
                                CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
                                WeighmentName: 'FRIAB',
                                IdsNo: strHmi
                            }
                        })

                        await models.tbl_powerbackup.update({
                            After_Count: 0,
                            // EntryTimeStamp: addTime
                        }, {
                            where: {
                                CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
                                WeighmentName: 'FRIAB',
                                IdsNo: strHmi
                            }
                        })


                        let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
                        let autoTare = hmiEntryinConfig[0].AutoTare;
                        let tareCommand = hmiEntryinConfig[0].Tare_Command
                        await objMonit.monit({
                            case: 'TestWeight', Hmi: strHmi, data: {
                                Weight: `${Number(
                                    receiveWt
                                )}  ${unit}`, srNo: "", message: 'FinalWeight'
                            }
                        });
                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBL1:${respSelect.InitialWt} ${unit};WTAL1:${receiveWt + " " + unit};NWTD1:${receiveWt} ${unit}`);

                        // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBR2:${receiveWt + " " + unit}`);

                        //monit



                        // if (autoTare) {
                        //     mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                        // }

                        let timeForMenuDisable = globalData.arrTimeForMenuDisable.find(k => k.Hmi == strHmi);
                        if (timeForMenuDisable == undefined) {
                            globalData.arrTimeForMenuDisable.push({
                                Hmi: strHmi,
                                idsNo: strIdsNo,
                                // timeForMenuHide: removeTimeForMenuDisable,
                                formatedTime: dateFormat1
                            })
                        } else {
                            // timeForMenuDisable.timeForMenuHide = removeTimeForMenuDisable;
                            timeForMenuDisable.timeForMenuHide = dateFormat1;

                        }

                        // }

                    }
                    //FRIABILITY BEFORE SAMPLE COMPLETED, NOW WAIT FOR 
                    globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi) == -1 ?
                        globalData.arrWeighmentCounterForFriab :
                        globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi), 1);


                    if (FriabilityDetail1.data.Rotary == "Single") {
                        setTimeout(() => { mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Friability Before Samples Completed, now wait for  ${removeTimeForMenuDisable.toFixed(0)} mins`) }, 1000);
                    } else if (FriabilityDetail1.data.Rotary == "Double" && tempCounterObj.counter == 2) {
                        setTimeout(() => { mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Friability Before Samples Completed, now wait for  ${removeTimeForMenuDisable.toFixed(0)} mins`) }, 1000);
                    }

                } else {

                    let now = new Date();
                    let timeForMenuDisable = globalData.arrTimeForMenuDisable.find(k => k.Hmi == strHmi);
                    var initSampletime = moment(powerbacc.EntryTimeStamp).format("MM/DD/YYYY  hh:mm:ss")
                    // let initSampletime = new Date(date.format(new Date(), 'YYYY-MM-DD HH:mm:ss'))
                    let currentTime = new Date(date.format(new Date(), 'YYYY-MM-DD HH:mm:ss'))
                    // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.selectedIds.Idsno == strHmi);
                    // if (IPQCObject != undefined) {
                    //     strHmi = IPQCObject.idsNo;
                    // } else {
                    //     strHmi = strHmi;
                    // }
                    // console.log(this.DateFormat(now, time));
                    //No RptType
                    var checkEntry = await models.tbl_tab_friability.findAll({
                        attributes: [
                            // [sequelize.fn('MAX', sequelize.col("RecNo")), "RecNo"],
                            [sequelize.fn('MAX', sequelize.col("MstSerNo")), "MstSerNo"],
                            [sequelize.fn('MAX', sequelize.col("RepSerNo")), "RepSerNo"],
                        ],
                        where: {
                            ProductName: CurrentCubicalObj.Sys_ProductName,
                            IdsNo: strHmi,
                            BatchNo: CurrentCubicalObj.Sys_Batch,
                            PVersion: CurrentCubicalObj.Sys_PVersion,
                            Version: CurrentCubicalObj.Sys_Version,
                            BFGCode: CurrentCubicalObj.Sys_BFGCode,
                            CubicleType: CurrentCubicalObj.Sys_CubType,
                            ReportType: CurrentCubicalObj.Sys_RptType,
                            // Side: FriabilityDetail1.data.Side,

                        },
                        raw: true
                    });
                    checkEntry = checkEntry                   // var sqlquery = `SELECT * FROM tbl_tab_detail8 WHERE RepSerNo = (SELECT MAX(RepSerNo) FROM tbl_tab_master8 WHERE BatchNo = '${batchNo}') AND FinalWt = '0' AND Side = '${FriabilityDetail1.data.Side}' AND IdsNo = '${strHmi}'`
                    // sqlquery = `SELECT * FROM tbl_tab_detail8 WHERE RecNo = (SELECT MAX(RecNo) FROM tbl_tab_detail8 WHERE RepSerNo = '${checkEntry.masterRepSerNo}' AND Side = '${FriabilityDetail1.data.Side}' AND IdsNo = '${strHmi}') AND UserId = '${FriabilityDetail1.data.userId}' AND UserName = '${FriabilityDetail1.data.userName}' AND FinalWt = '0' AND BalanceID = '${dataObj.instrumentId}'`

                    var resBatch = checkEntry
                    if (Date.parse(currentTime) >= Date.parse(powerbacc.EntryTimeStamp)) {
                        let __paramProductData = {
                            ProductId: __parameterFriability.objProductDetails.ProductId,
                            ProductName: __parameterFriability.objProductDetails.ProductName,
                            ProductVersion: __parameterFriability.objProductDetails.ProductVersion,
                            Version: __parameterFriability.objProductDetails.Version,
                            Batch: __parameterFriability.Batch,
                            uniqueSerialNumber: __parameterFriability.strHmi
                        }

                        if (FriabilityDetail1.data.Rotary == "Single") {
                            tempCounterObjAfter.counter = 0;
                        }


                        //after enable menu 
                        //clear this array tempCounterObj.counter
                        if (tempCounterObjAfter.counter == 0) {
                            // lstInsertId = await this.saveToBalanceCompleteData(__parameterFriability, productDetail);
                            //dislay wt ${mqttProtocol.DisplayResult}
                            var result = await this.checkProductData(__paramProductData, __parameterFriability.strHmi);

                            let resSelectFri = await models.tbl_tab_friability.findAll({
                                where: {
                                    // MstSerNo: resBatch[0].RecSeqNo,
                                    RepSerNo: resBatch[0].RepSerNo,
                                    // 'Side': FriabilityDetail1.data.Side,
                                    IdsNo: strHmi
                                }
                            })
                            resSelectFri = resSelectFri[0];




                            //powerbackup

                            var updateData;
                            if (FriabilityDetail1.data.Rotary == "Single") {

                                await models.tbl_tab_friability.update({
                                    'LWtAfterTest': receiveWt,
                                    PrEndTime: moment().format('HH:mm:ss'),
                                    PrEndDate: date.format(new Date(), 'YYYY-MM-DD')
                                }, {
                                    where: {
                                        // RecNo: resBatch[0].RecNo,
                                        RepSerNo: resBatch[0].RepSerNo,
                                        // 'BFGCode': __parameterFriability.objProductDetails.ProductId,
                                        // 'ProductName': __parameterFriability.objProductDetails.ProductName,
                                        // 'PVersion': __parameterFriability.objProductDetails.ProductVersion,
                                        // 'Version': __parameterFriability.objProductDetails.Version,
                                        // 'BatchNo': __parameterFriability.Batch,
                                        // 'IdsNo':SelectstrHmi
                                    }
                                })

                                // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
                                // if (IPQCObject != undefined) {
                                //     strHmi = IPQCObject.selectedIds.Idsno;
                                // } else {
                                //     strHmi = strHmi;
                                // }
                                await objInstrumentUsage.InstrumentUsage('Balance',
                                    strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'Completed');

                            } else {


                                await models.tbl_tab_friability.update({
                                    'FinalWt': receiveWt,
                                    PrEndTime: moment().format('HH:mm:ss'),
                                    PrEndDate: date.format(new Date(), 'YYYY-MM-DD')
                                }, {
                                    where: {
                                        'MstSerNo': result[0].SeqNo,
                                        'RecSeqNo': recNo,
                                        // 'BFGCode': __parameterFriability.objProductDetails.ProductId,
                                        // 'ProductName': __parameterFriability.objProductDetails.ProductName,
                                        // 'PVersion': __parameterFriability.objProductDetails.ProductVersion,
                                        // 'Version': __parameterFriability.objProductDetails.Version,
                                        // 'BatchNo': __parameterFriability.Batch,
                                        // 'IdsNo': __parameterFriability.uniqueSerialNumber,
                                    }
                                })
                                await objInstrumentUsage.InstrumentUsage('Balance',
                                    strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'Completed');

                            }

                            // uppdate according to double rotary
                            let respSelectFri = await models.tbl_tab_friability.findAll({
                                where: {
                                    RepSerNo: resBatch[0].RepSerNo,
                                }
                            })
                            respSelectFri = respSelectFri[0];






                            //powerbackup

                            await models.tbl_powerbackup.update({
                                After_Count: 1
                            }, {
                                where: {
                                    'CubicalNo': powerbacc.CubicalNo,
                                    WeighmentName: 'FRIAB',
                                    IdsNo: strHmi
                                }
                            })
                            var NWtBeforeTest = mathj.round((((respSelectFri.LWtBeforeTest - receiveWt) * 100) / respSelectFri.LWtBeforeTest), 3).toFixed(3);

                            var NMT = __parameterFriability.productType.nominal
                            var drum1 = NWtBeforeTest
                            var remark1;
                            NWtBeforeTest = ((drum1).includes('-')) ? 0 : NWtBeforeTest;
                            drum1 = NWtBeforeTest;
                            if (((drum1) == 0)) {
                                remark1 = 'Complies'
                            } else {
                                if (Number(NMT) >= Number(drum1)) {
                                    remark1 = 'Complies'
                                } else {
                                    remark1 = 'Not Complies'
                                }
                            }

                            var lastId = await models.tbl_tab_friability.findAll({
                                where: {
                                    RepSerNo: result[0].RepSerNo,
                                }
                            })


                            if (FriabilityDetail1.data.Rotary == "Single") {

                                // var NWtBeforeTest = (((respSelectFri.LWtBeforeTest - receiveWt) * 100) / respSelectFri.LWtBeforeTest).toFixed(2);
                                var batchSummaryObject = {
                                    BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                                    ProductName: hmiDetailsInPMenu.Sys_ProductName,
                                    PVersion: hmiDetailsInPMenu.Sys_PVersion,
                                    Version: hmiDetailsInPMenu.Sys_Version,
                                    PrdType: 1,
                                    CubType: hmiDetailsInPMenu.Sys_CubType,
                                    BatchNo: hmiDetailsInPMenu.Sys_Batch,
                                    Unit: hmiDetailsInPMenu.Sys_BatchSizeUnit,
                                    Side: FriabilityDetail1.data.Rotary,
                                    InstrumentID: respSelectFri.FriabilityID,
                                    UserId: tempUserObject.UserId,
                                    UserName: tempUserObject.UserName,
                                    nwtBeforeTest: NWtBeforeTest,
                                    lwtBeforeTest: respSelectFri.LWtBeforeTest,
                                    lwtAfterTest: respSelectFri.LWtAfterTest,
                                    Dept: hmiDetailsInPMenu.Sys_dept,
                                    Nom: Number(productDetail.productDetail[0][0].Param8_Nom).toFixed(2),
                                    PrTime: moment(lastId[0].PrTime).format('HH:mm:ss'),
                                    PrDate: date.format(new Date(), 'YYYY-MM-DD'),
                                    remark1: remark1
                                }

                            }
                            await objBatchSummary.saveBatchSummaryFriability(batchSummaryObject, strIdsNo, FriabilityDetail1.data.Side);

                            const objUpdateValidation = await models.tbl_cubical.update({
                                'Sys_Validation': 0
                            }, {
                                where: {
                                    'Sys_rpi': hmiDetailsInPMenu.Sys_rpi
                                }

                            });

                            // NWtBeforeTest = (Math.ceil(NWtBeforeTest * 1000) / 1000).toFixed(3)


                            await models.tbl_tab_friability.update({
                                // LWtPercentage: maths.round(Number(NWtBeforeTest), 3).toFixed(3),
                                LWtPercentage: (Number(NWtBeforeTest)).toFixed(3),
                                LWtRemark: remark1,
                                Inprocess: 0,
                                Remark: remark1
                            }, {
                                where: {
                                    // RecNo: resBatch[0].RecNo,
                                    RepSerNo: resBatch[0].RepSerNo,
                                    // 'BFGCode': __parameterFriability.objProductDetails.ProductId,
                                    // 'ProductName': __parameterFriability.objProductDetails.ProductName,
                                    // 'PVersion': __parameterFriability.objProductDetails.ProductVersion,
                                    // 'Version': __parameterFriability.objProductDetails.Version,
                                    // 'BatchNo': __parameterFriability.Batch,
                                    // 'IdsNo': __parameterFriability.uniqueSerialNumber,
                                }
                            });
                            let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
                            let autoTare = hmiEntryinConfig[0].AutoTare;
                            let tareCommand = hmiEntryinConfig[0].Tare_Command
                            if (FriabilityDetail1.data.Rotary == "Single") {
                                // await objBatchSummary.saveBatchSummaryFriability(batchSummaryObject, strIdsNo);
                                let nwtD1 = (((respSelectFri.InitialWt - receiveWt) * 100) / respSelectFri.InitialWt).toFixed(5);

                                await objMonit.monit({
                                    case: 'TestWeight', Hmi: strHmi, data: {
                                        Weight: `${Number(
                                            receiveWt
                                        )} ${nwtD1}  ${unit}`, srNo: "", message: 'FinalWeight'
                                    }
                                });

                                mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBL1:${resBatch[0].InitialWt} ${unit};WTAL1:${receiveWt + " " + unit};NWTD1:${receiveWt} ${unit}`);
                                if (autoTare) {
                                    mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                                }
                            } else {
                                mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBL1:${respSelectFri.InitialWt} ${unit};WTAL1:${receiveWt + " " + unit};NWTD1:${receiveWt} ${unit}`);

                            }
                            // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTAL1:${receiveWt + " " + unit}`);
                            if (autoTare) {
                                mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                            }
                            if (FriabilityDetail1.data.Rotary == "Double") {
                                mqttSender.sendData(strHmi, `${mqttProtocol.Sideprotocol}${tempSide}`);

                            }
                            if (autoTare) {
                                mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                            }

                        }

                        if (FriabilityDetail1.data.Rotary == "Double") {
                            tempCounterObjAfter.counter += 1;
                        }



                        if (tempCounterObjAfter.counter == 2) {
                            //update WTAR2
                            var result = await this.checkProductData(__paramProductData, strHmi);

                            let resSelectFri = await models.tbl_tab_detail8.findAll({
                                where: {
                                    MstSerNo: result[0].SeqNo,
                                    IdsNo: strHmi
                                }
                            })
                            resSelectFri = resSelectFri;

                            let nwtAfterTest;
                            let nwtBeforeTest;
                            nwtBeforeTest = mathj.round((((resSelectFri[0].InitialWt - resSelectFri[0].FinalWt) * 100) / resSelectFri[0].InitialWt), 3).toFixed(3);
                            nwtAfterTest = mathj.round((((resSelectFri[1].InitialWt - receiveWt) * 100) / resSelectFri[1].InitialWt), 3).toFixed(3);
                            if (result) {
                                //update WTAR2
                                var result = await models.tbl_tab_detail8.findAll({
                                    attributes: [
                                        [sequelize.fn('MAX', sequelize.col("RecNo")), "RecNo"],
                                        [sequelize.fn('MAX', sequelize.col("MstSerNo")), "SeqNo"],
                                        [sequelize.fn('MAX', sequelize.col("RepSerNo")), "RepSerNo"],
                                    ],
                                    where: {
                                        'RepSerNo': result[0].RepSerNo,
                                        IdsNo: strHmi,
                                        // 'Side' :FriabilityDetail1.data.Side
                                    },
                                    raw: true
                                })
                                const updateData = await models.tbl_tab_detail8.update({

                                    FinalWt: receiveWt,
                                    PrEndTime: moment().format('HH:mm:ss'),
                                    PrEndDate: date.format(new Date(), 'YYYY-MM-DD')
                                }, {
                                    where: {
                                        'RecNo': result[0].RecNo,
                                        IdsNo: strHmi
                                        // 'BFGCode': __parameterFriability.objProductDetails.ProductId,
                                        // 'ProductName': __parameterFriability.objProductDetails.ProductName,
                                        // 'PVersion': __parameterFriability.objProductDetails.ProductVersion,
                                        // 'Version': __parameterFriability.objProductDetails.Version,
                                        // 'BatchNo': __parameterFriability.Batch,
                                        // 'IdsNo': __parameterFriability.uniqueSerialNumber
                                        // NWtAfterTest: nwtAfterTest
                                    }
                                })
                                await objInstrumentUsage.InstrumentUsage('Balance',
                                    strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'Completed');





                                //power backup
                                const updateDataPower = await models.tbl_powerbackup.update({
                                    'CubicalNo': hmiDetailsInPMenu.Sys_CubicNo,
                                    'WeightmentType': 8,
                                    'RepSerno': result[0].RepSerNo
                                }, {
                                    where: {
                                        After_Count: tempCounterObjAfter.counter,
                                        WeighmentName: 'FRIAB',
                                        IdsNo: strHmi
                                    }

                                })

                                var lastId = await models.tbl_tab_friability.findAll({
                                    where: {
                                        RepSerNo: result[0].RepSerNo,
                                    }
                                })

                                let batchSummaryObject = {
                                    BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                                    ProductName: hmiDetailsInPMenu.Sys_ProductName,
                                    PVersion: hmiDetailsInPMenu.Sys_PVersion,
                                    Version: hmiDetailsInPMenu.Sys_Version,
                                    PrdType: 1,
                                    CubType: hmiDetailsInPMenu.Sys_CubType,
                                    BatchNo: hmiDetailsInPMenu.Sys_Batch,
                                    Unit: hmiDetailsInPMenu.Sys_BatchSizeUnit,
                                    Side: FriabilityDetail1.data.side,
                                    InstrumentID: resSelectFri[1].FriabilityID,
                                    UserId: tempUserObject.UserId,
                                    UserName: tempUserObject.UserName,

                                    nwtBeforeTest: nwtBeforeTest,
                                    nwtAfterTest: nwtAfterTest,
                                    lwtBeforeTest: resSelectFri[0].InitialWt,
                                    lwtAfterTest: resSelectFri[0].FinalWt,
                                    rwtBeforeTest: resSelectFri[1].InitialWt,
                                    rwtAfterTest: resSelectFri[1].FinalWt,
                                    Dept: hmiDetailsInPMenu.Sys_dept,
                                    Nom: Number(productDetail.productDetail.Param8_Nom).toFixed(2),
                                    PrTime: moment(lastId[0].PrTime).format('HH:mm:ss'),
                                    PrDate: date.format(now, 'YYYY-MM-DD')
                                }




                                await objBatchSummary.saveBatchSummaryFriability(batchSummaryObject, strIdsNo, FriabilityDetail1.data.Side);
                                // await objCommonInsertOpt.updateEndDate(strIdsNo, strHmi, 'tbl_tab_master8');
                                const objUpdateValidation = await models.tbl_cubical.update({
                                    'Sys_Validation': 0
                                }, {
                                    where: {
                                        'Sys_IDSNo': strHmi
                                    }

                                });

                                await models.tbl_powerbackup.destroy({
                                    where: {
                                        'CubicalNo': powerbacc.CubicalNo,
                                        WeighmentName: 'FRIAB',
                                        IdsNo: strHmi
                                    }
                                })
                                if (hmiDetailsInPMenu.Sys_RotaryType == 'Double') {
                                    if (Side.length == 1) {
                                        if (Side[0] == 'LHS') {
                                            Side = 'RHS'
                                        } else {
                                            Side = 'LHS'
                                        }
                                        //    if(Number(sample) == Number(tempCounterObj.counter)){
                                        mqttSender.sendData(strHmi, `${mqttProtocol.SideChange}:${tempSide}`);
                                        let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
                                        let autoTare = hmiEntryinConfig[0].AutoTare;
                                        let tareCommand = hmiEntryinConfig[0].Tare_Command
                                        if (autoTare) {
                                            mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                                        }

                                        //    } 
                                    } else {
                                        Object.assign(objActivity,
                                            { strUserId: tempUserObject.UserId },
                                            { strUserName: tempUserObject.UserName },
                                            { activity: activityLogMsg });

                                        await objActivityLog.ActivityLogEntry(objActivity);
                                        // await objInstrumentUsage.InstrumentUsage('Balance', strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'completed');

                                        await objMonit.monit({
                                            case: 'TestWeight', Hmi: strHmi, data: {
                                                Weight: `${Number(
                                                    receiveWt
                                                )}  ${unit}`, srNo: "", message: ''
                                            }
                                        });

                                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBL1:${resSelectFri.InitialWt} ${unit};WTAL1:${receiveWt + " " + unit};NWTD1:${receiveWt} ${unit}`);
                                        //mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTAR2:${receiveWt + " " + unit}`);

                                        //monit

                                        //     if(globalData.monitDetail.length > 0){
                                        //         for(var i = 0; i<globalData.monitDetail.length; i++){
                                        //             await objMonit.monit({
                                        //                 case: 'TestWeight',
                                        //                 Hmi: strHmi,
                                        //                 data: {
                                        //                     Weight: globalData.monitDetail[i].DataValue,
                                        //                     srNo:i,
                                        //                     message: ""
                                        //                 } 
                                        //         })
                                        //     }
                                        //     globalData.monitDetail = []
                                        // }
                                        // await objMonit.monit({
                                        //     case: 'TestWeight', Hmi: strHmi, data: {
                                        //         Weight: `${Number(
                                        //             receiveWt
                                        //         )} ${unit}`, srNo: "", message: 'FinalWeight'
                                        //     }
                                        // });

                                        globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi) == -1 ?
                                            globalData.arrWeighmentProductData :
                                            globalData.arrWeighmentProductData.splice(globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi), 1);

                                        globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi) == -1 ?
                                            globalData.arrProductTypeArray :
                                            globalData.arrProductTypeArray.splice(globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi), 1);

                                        globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi) == -1 ?
                                            globalData.arrWeighmentCounterForFriab :
                                            globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi), 1);

                                        (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus :
                                            globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);
                                        //test splice if rotarty is not double
                                        globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
                                            globalData.arrSelectedMenu :
                                            globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);

                                        globalData.arrWeighmentCounterAfter.findIndex(k => k.Hmi == strHmi) == -1 ?
                                            globalData.arrWeighmentCounterAfter :
                                            globalData.arrWeighmentCounterAfter.splice(globalData.arrWeighmentCounterAfter.findIndex(k => k.Hmi == strHmi), 1);
                                        globalData.DoubSideForFriab.findIndex(k => k.Hmi == strHmi) == -1 ? globalData.DoubSideForFriab : globalData.DoubSideForFriab.splice(globalData.DoubSideForFriab.findIndex(k => k.Hmi == strHmi), 1);

                                        await objMonit.monit({
                                            case: 'ReportStatus', Hmi: strHmi, data: {
                                                message: 'Friability Test Completed'
                                            }
                                        });
                                        setTimeout(() => { mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted} Test Completed`) }, 1000);
                                        // mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}FRIAB Test Completed`);
                                        //monit
                                    }

                                    return

                                }
                            }


                        }
                        tempCounterObjAfter = globalData.arrWeighmentCounterAfter.find(k => k.Hmi == strHmi);
                        if (tempCounterObjAfter != undefined) {
                            if (tempCounterObjAfter.counter == 0 || FriabilityDetail1.data.Rotary == "Single") {
                                //batch summary 


                                await models.tbl_powerbackup.destroy({
                                    where: {
                                        'CubicalNo': powerbacc.CubicalNo,
                                        WeighmentName: 'FRIAB',
                                        IdsNo: strHmi
                                    }
                                })

                                // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.selectedIds.Idsno == strHmi);
                                // if (IPQCObject != undefined) {
                                //     strHmi = IPQCObject.idsNo;
                                // } else {
                                //     strHmi = strHmi;
                                // }

                                let updateFriability = await models.tbl_tab_master8.update({
                                    PrEndDate: date.format(new Date(), 'YYYY-MM-DD'),
                                    PrEndTime: date.format(new Date(), 'HH:mm:ss')
                                }, {
                                    where: {
                                        RepSerNo: result[0].RepSerNo,
                                        IdsNo: strHmi
                                    }
                                })

                                // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
                                // if (IPQCObject != undefined) {
                                //     strHmi = IPQCObject.selectedIds.Idsno;
                                // } else {
                                //     strHmi = strHmi;
                                // }


                                Object.assign(objActivity,
                                    { strUserId: tempUserObject.UserId },
                                    { strUserName: tempUserObject.UserName },
                                    { activity: activityLogMsg });

                                await objActivityLog.ActivityLogEntry(objActivity);
                                await objInstrumentUsage.InstrumentUsage('Balance', strIdsNo, 'tbl_instrumentlog_balance', 'Friability', 'completed');

                                globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi) == -1 ?
                                    globalData.arrWeighmentProductData :
                                    globalData.arrWeighmentProductData.splice(globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi), 1);

                                globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi) == -1 ?
                                    globalData.arrProductTypeArray :
                                    globalData.arrProductTypeArray.splice(globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi), 1);

                                globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi) == -1 ?
                                    globalData.arrWeighmentCounterForFriab :
                                    globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi), 1);

                                (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus :
                                    globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);
                                //test splice if rotarty is not double
                                globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
                                    globalData.arrSelectedMenu :
                                    globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);

                                // if (remark1 == "Not Complies") {
                                //     var reportLimitMsg = "Report Out Of Limit"
                                // }
                                // else {
                                //     reportLimitMsg = "Report Within Limit"
                                // }

                                // setTimeout(() => {  mqttSender.sendData(strHmi,`${mqttProtocol.TestCompleted}${reportLimitMsg}`) }, 1000);


                                setTimeout(() => { mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted} Test Completed`) }, 1000);

                                // mqttSender.sendData(strHmi,`${mqttProtocol.TestCompleted}${reportLimitMsg}`);
                            }
                        }


                    } else {

                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Friability is blocked for ${removeTimeForMenuDisable.toFixed(0)} min`);
                    }




                }
            }
            //disable the menu after  send before wt 
        } catch (error) {
            console.log(error);
            throw new Error(error);
        }

    }


    async saveToBalanceCompleteData(data, friDetail) {
        try {
            let strHmi = data.strHmi;
            let strIdsNo = data.uniqueSerialNumber;
            const FriabilityDetail1 = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi);
            let CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
            let sample = parseFloat(FriabilityDetail1.data.noOfSample);
            let Side = FriabilityDetail1.data.Side;


            let selectedIdsNo;
            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.Hmi == strHmi);
            // if (IPQCObject != undefined) {
            //     selectedIdsNo = IPQCObject.selectedIds;
            // } else {
            //     strHmi = strHmi;
            // }

            let IPQC = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
            let setDataAccToColunSingle = 0;
            let setDataAccToColunDouble = 0;
            if (IPQC.Sys_RptType == 'Double') {
                setDataAccToColunDouble = data.receiveWt;
            } else {
                setDataAccToColunSingle = data.receiveWt;
            }
            let hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData; //idsNo

            let tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
            let productObj = data.objProductDetails;
            let productParams = data.productType;
            let now = new Date();

            let __paramProductData = {
                ProductId: productObj.ProductId,
                ProductName: productObj.ProductName,
                ProductVersion: productObj.ProductVersion,
                Version: productObj.Version,
                Batch: data.Batch,
                Side: Side,
                // uniqueSerialNumber: data.uniqueSerialNumber
                uniqueSerialNumber: strHmi
            }

            var result = await this.checkProductData(__paramProductData, strHmi);
            var intMstSerNo;

            if (result.length <= 0) {
                intMstSerNo = 1;
            } else {
                var newMstSerNo = result[0].SeqNo + 1;
                intMstSerNo = newMstSerNo;
            }
            // if(Side == 'RHS'){
            //     intMstSerNo  =  result[0].SeqNo
            //  }else{
            //     intMstSerNo =   result[0].SeqNo   + 1     
            //  }


            // let bRepSerNo = await this.getMaxBRepSerNo(productObj.ProductName, hmiDetailsInPMenu.Sys_Batch, "tbl_tab_master8", hmiDetailsInPMenu.Sys_RptType, hmiDetailsInPMenu.Sys_CubType)
            // let resultCompleteData = await database.save(saveFriData);
            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.selectedIds.Idsno == strHmi);
            // if (IPQCObject != undefined) {
            //     strHmi = IPQCObject.idsNo;
            // } else {
            //     strHmi = strHmi;
            // }
            let ChangesfriabID = await models.tbl_cubical.findAll({
                where: {
                    Sys_IDSNo: strHmi
                }
            })
            //  IPQCObject = globalData.arr_IPQCRelIds.find(k => k.selectedIds.Idsno == strHmi);
            // if (IPQCObject != undefined) {
            //     strHmi = IPQCObject.selectedIds.Idsno;
            // } else {
            //     strHmi = strHmi;
            // }
            hmiDetailsInPMenu.Sys_FriabID = ChangesfriabID[0].Sys_FriabID
            let resultCompleteData = await models.tbl_tab_friability.create({
                MstSerNo: intMstSerNo,
                SrNo: intMstSerNo,
                Area: hmiDetailsInPMenu.Sys_Area,
                CubicleName: hmiDetailsInPMenu.Sys_CubicName,
                CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
                CubicleType: hmiDetailsInPMenu.Sys_CubType,
                IPQCType: hmiDetailsInPMenu.Sys_IPQCType,
                ProductType: productObj.ProductType,
                ReportType: hmiDetailsInPMenu.Sys_RptType,
                BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                ProductName: hmiDetailsInPMenu.Sys_ProductName,
                PVersion: hmiDetailsInPMenu.Sys_PVersion,
                Version: hmiDetailsInPMenu.Sys_Version,
                BatchNo: hmiDetailsInPMenu.Sys_Batch,
                BMRNo: hmiDetailsInPMenu.Sys_BMRNo,
                BatchSize: hmiDetailsInPMenu.Sys_BatchSize,
                MachineCode: hmiDetailsInPMenu.Sys_MachineCode,
                BalanceId: hmiDetailsInPMenu.Sys_BalID,
                FriabilityID: hmiDetailsInPMenu.Sys_FriabID,
                IdsNo: strHmi,
                Qty: sample,
                UserId: tempUserObject.UserId,
                UserName: tempUserObject.UserName,
                PrDate: moment().format('YYYY-MM-DD'),
                PrTime: moment().format('HH:mm:ss'),
                PrEndDate: moment().format('YYYY-MM-DD'),
                PrEndTime: moment().format('HH:mm:ss'),
                Side: hmiDetailsInPMenu.Sys_RotaryType !== "Single" ? "Double" : "Single",
                Unit: "g",
                DecimalPoint: data.deciaml,
                NMT: Number(friDetail.productDetail[0][0].Param8_Nom).toFixed(2),
                SetCount: friDetail.productDetail[0][0].Param8_T1Neg,
                SetRPM: friDetail.productDetail[0][0].Param8_T1Pos,
                PrintNo: 0,
                IsArchived: 0,
                BatchComplete: 0,
                // LWtBeforeTest: receiveWt,
                // CheckedByID:"" ,
                // CheckedByName: ,
                // CheckedByDate: ,
                // ActualCount: ,
                // ActualRPM: ,
                Inprocess: 1,
                // Remark: ,
                // CheckedByTime: ,
                Sys_Validation: hmiDetailsInPMenu.Sys_Validation,
                Department: hmiDetailsInPMenu.Sys_dept,
                // Interval: FriabilityDetail1.data.interval
            })
            var lastInsertedID = resultCompleteData.MstSerNo;
            var RepSerNo = resultCompleteData.RepSerNo;
            var PrTime = resultCompleteData.PrTime;
            return {
                lastInsertedID: lastInsertedID,
                masterRepSerNo: RepSerNo,
                PrTime: PrTime
            };
        } catch (error) {
            console.log(error);
            throw new Error(error);
        }

    }

    async checkProductData(productObj, selectedIdsNo = "") {
        try {
            // const checkData = {
            //     str_tableName: 'tbl_tab_friability',
            //     data: 'MAX(MstSerNo) AS SeqNo ,MAX(RepSerNo) AS RepSerNo',
            //     condition: [
            //         { str_colName: 'BFGCode', value: productObj.ProductId, comp: 'eq' },
            //         { str_colName: 'ProductName', value: productObj.ProductName, comp: 'eq' },
            //         { str_colName: 'PVersion', value: productObj.ProductVersion, comp: 'eq' },
            //         { str_colName: 'Version', value: productObj.Version, comp: 'eq' },
            //         { str_colName: 'BatchNo', value: productObj.Batch, comp: 'eq' },
            //         { str_colName: 'IdsNo', value: productObj.uniqueSerialNumber, comp: 'eq' },
            //     ]
            // }
            let hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.Hmi == selectedIdsNo).cubicalData;

            // var result = await database.select(checkData);
            var result = await models.tbl_tab_friability.findAll({
                attributes: [
                    [sequelize.fn('MAX', sequelize.col("MstSerNo")), "SeqNo"],
                    [sequelize.fn('MAX', sequelize.col("RepSerNo")), "RepSerNo"]
                ],
                where: {
                    'BFGCode': productObj.ProductId,
                    'ProductName': productObj.ProductName,
                    'PVersion': productObj.ProductVersion,
                    'Version': productObj.Version,
                    'BatchNo': productObj.Batch,
                    'ReportType': hmiDetailsInPMenu.Sys_RptType,

                    'IdsNo': productObj.uniqueSerialNumber,
                },
                raw: true
            })
            return result;
        } catch (error) {
            throw new Error(error);
        }
    }

    AddMinutesToDate(date, minutes) {
        return moment(date.add(minutes, 'minutes')).format('YYYY-MM-DD HH:mm:ss')

        // return new Date(date.getTime() + minutes * 60000);
    }

    DateFormat(date) {
        var days = date.getDate();
        var year = date.getFullYear();
        var month = (date.getMonth() + 1);
        var hours = date.getHours();
        var minutes = date.getMinutes();
        minutes = minutes < 10 ? '0' + minutes : minutes;
        var strTime = month + '/' + days + '/' + year + ' ' + hours + ':' + minutes;
        //var strTime = hours + ':' + minutes;
        return strTime;
    }

    /**
     * process BFBO 
     */
    async processBFBO(dataObj) {
        let strHmi = dataObj.Hmi;
        let strIdsNo = dataObj.idsNo;
        let receiveWt = dataObj.actualWt;
        let unit = dataObj.unit;
        await this.insertFriabilityOnBal(strHmi, strIdsNo, receiveWt);
    }

    async insertFriabilityOnBal(strHmi, IdsNo, protocol) {
        try {
            let now = new Date();
            var actualProtocol = protocol;
            let selectedIds;
            var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
            //var objLotData = globalData.arrLot.find(k => k.idsNo == IdsNo);
            var CurrentCubic = globalData.arrIdsInfo.find(k => k.idsNo == IdsNo).cubicalData;
            if (IPQCObject != undefined) {
                selectedIds = IPQCObject.selectedIds;
            } else {
                selectedIds = IdsNo;
            }
            var tempCubic = globalData.arrIdsInfo.find(k => k.idsNo == selectedIds).cubicalData;
            var objFriBal = globalData.FrabilityOnBal.find(k => k.idsNo == IdsNo);

            let tempCounterObj = globalData.arrWeighmentCounterForFriab.find(k => k.Hmi == strHmi);
            if (tempCounterObj === undefined) {
                globalData.arrWeighmentCounterForFriab.push({ 'Hmi': strHmi, 'counter': 0 })
            }
            tempCounterObj = globalData.arrWeighmentCounterForFriab.find(k => k.Hmi == strHmi);

            if (tempCubic.Sys_RotaryType == "Double") {

                if (objFriBal == undefined) {
                    globalData.FrabilityOnBal.push({ idsNo: selectedIds, dataValue1: actualProtocol, dataValue2: 0 })

                } else {
                    objFriBal.dataValue2 = actualProtocol;
                }
            } else {
                if (objFriBal == undefined) {
                    globalData.FrabilityOnBal.push({ idsNo: selectedIds, dataValue1: actualProtocol, dataValue2: 0 })

                } else {
                    objFriBal.dataValue1 = actualProtocol;
                }
            }

            objFriBal = globalData.FrabilityOnBal.find(k => k.idsNo == IdsNo);
            var menuDetailsArr = globalData.arr_limits.find(k => k.idsNo == IdsNo);
            let tempLimits = menuDetailsArr.Menus.filter(obj => Object.keys(obj) == 'Friability')[0]['Friability'];
            // var objInvalid = globalData.arrBulkInvalid.find(k => k.idsNo == IdsNo);
            var productObj = globalData.arrProductTypeArray.find(k => k.idsNo == IdsNo);
            var rwtAfterTest, rwtBeforeTest, nwtAfterTest, nwtBeforeTest, lwtAfterTest, lwtBeforeTest, decimalPoint;
            var ActualRPM = "";
            var ActualCount = ""
            var intervalFound;




            // var tdValue = actualProtocol.substring(0, 5);//starting 
            // var recPrtotocol = actualProtocol.substring(7).trim().split(" ");
            const tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
            let retuRes = await this.checkFriabilityStatus(IdsNo);

            if (retuRes.status == 'before') {
                if (tempCubic.Sys_RotaryType == 'Double') {
                    tempCounterObj.counter += 1; //counter only for Double rotary
                    lwtBeforeTest = objFriBal.dataValue1;
                    rwtBeforeTest = objFriBal.dataValue2;
                    nwtBeforeTest = 0;
                    decimalPoint = await this.precision(Number(objFriBal.dataValue1))
                } else {
                    lwtBeforeTest = 0;
                    rwtBeforeTest = 0;
                    nwtBeforeTest = objFriBal.dataValue1;
                    decimalPoint = await this.precision(Number(objFriBal.dataValue1))
                }
                var res = await proObj.productData(tempCubic);
                const checkData = {
                    str_tableName: 'tbl_tab_friability',
                    data: 'MAX(MstSerNo) AS SeqNo',
                    condition: [
                        { str_colName: 'BFGCode', value: tempCubic.Sys_BFGCode, comp: 'eq' },
                        { str_colName: 'ProductName', value: tempCubic.Sys_ProductName, comp: 'eq' },
                        { str_colName: 'PVersion', value: tempCubic.Sys_PVersion, comp: 'eq' },
                        { str_colName: 'Version', value: tempCubic.Sys_Version, comp: 'eq' },
                        { str_colName: 'BatchNo', value: tempCubic.Sys_Batch, comp: 'eq' },
                        { str_colName: 'IdsNo', value: selectedIds, comp: 'eq' },
                        { str_colName: 'CubicleType', value: tempCubic.Sys_CubType, comp: 'eq' },
                        { str_colName: 'RepoLabel10', value: tempCubic.Sys_IPQCType, comp: 'eq' },
                    ]
                }
                var result = await database.select(checkData);
                var intMstSerNo;
                if (retuRes.status == 'before') {
                    if (result[0][0].SeqNo == null) {
                        intMstSerNo = 1;
                    } else {
                        intMstSerNo = result[0][0].SeqNo;
                    }
                } else {
                    if (result[0][0].SeqNo == null) {
                        intMstSerNo = 1;
                    } else {
                        var newMstSerNo = result[0][0].SeqNo + 1;
                        intMstSerNo = newMstSerNo;
                    }
                }

                let bRepSerNo = await this.getMaxBRepSerNo(tempCubic.Sys_ProductName, tempCubic.Sys_Batch, 'tbl_tab_friability', tempCubic.Sys_RptType)

                if (tempCounterObj.counter == 1 || tempCubic.Sys_RotaryType == 'Single') {
                    var saveFriData = {
                        str_tableName: 'tbl_tab_friability',
                        data: [
                            { str_colName: 'MstSerNo', value: intMstSerNo },
                            { str_colName: 'InstruId', value: 0 },
                            { str_colName: 'BFGCode', value: tempCubic.Sys_BFGCode },
                            { str_colName: 'ProductName', value: tempCubic.Sys_ProductName },
                            { str_colName: 'ProductType', value: productObj.productType.ProductType },
                            { str_colName: 'IdsNo', value: selectedIds },
                            { str_colName: 'CubicalNo', value: tempCubic.Sys_CubicNo },
                            { str_colName: 'CubicleName', value: tempCubic.Sys_CubicName },
                            { str_colName: 'CubicleLocation', value: tempCubic.Sys_dept },
                            { str_colName: 'BatchNo', value: tempCubic.Sys_Batch },
                            //{ str_colName: 'NoOfSample', value: productObj.Sys_Batch },
                            { str_colName: 'UserId', value: tempUserObject.UserId },
                            { str_colName: 'UserName', value: tempUserObject.UserName },
                            { str_colName: 'PrDate', value: date.format(now, 'YYYY-MM-DD') },
                            { str_colName: 'PrTime', value: date.format(now, 'HH:mm:ss') },
                            { str_colName: 'Side', value: tempCubic.Sys_RotaryType },
                            { str_colName: 'Unit', value: 'g' },
                            { str_colName: 'DecimalPoint', value: decimalPoint },
                            { str_colName: 'WgmtModeNo', value: 8 },
                            { str_colName: 'FriNMTLimit', value: parseFloat(res[1].Param8_Nom) },
                            { str_colName: 'SetCount', value: parseFloat(res[1].Param8_T1Neg) },
                            { str_colName: 'SetRPM', value: parseFloat(res[1].Param8_T1Pos) },
                            { str_colName: 'FriabilityQty', value: tempLimits.noOfSamples },
                            { str_colName: 'CubicleType', value: tempCubic.Sys_CubType },
                            { str_colName: 'RepoLabel10', value: tempCubic.Sys_IPQCType },
                            { str_colName: 'ReportType', value: tempCubic.Sys_RptType },
                            { str_colName: 'MachineCode', value: tempCubic.Sys_MachineCode },
                            { str_colName: 'MFGCode', value: tempCubic.Sys_MfgCode },
                            { str_colName: 'BatchSize', value: `${tempCubic.Sys_BatchSize} ${tempCubic.Sys_BatchSizeUnit}` },
                            { str_colName: 'FriabilityID', value: CurrentCubic.Sys_FriabID },
                            { str_colName: 'NWtBeforeTest', value: nwtBeforeTest },
                            // { str_colName: 'NWtAfterTest', value: nwtAfterTest },
                            { str_colName: 'LWtBeforeTest', value: lwtBeforeTest },
                            // { str_colName: 'LWtAfterTest', value: lwtAfterTest },
                            //{ str_colName: 'RHSSrNo', value: productObj.CubicleType },
                            { str_colName: 'RWtBeforeTest', value: rwtBeforeTest },
                            // { str_colName: 'RWtAfterTest', value: rwtAfterTest },
                            { str_colName: 'PrintNo', value: 0 },
                            { str_colName: 'IsArchived', value: 0 },
                            //{ str_colName: 'BatchComplete', value: date.format(now, 'HH:mm:ss') },
                            //{ str_colName: 'GraphType', value: productObj.HardnessID },
                            { str_colName: 'BalanceId', value: CurrentCubic.Sys_BalID },
                            { str_colName: 'PVersion', value: tempCubic.Sys_PVersion },
                            { str_colName: 'Version', value: tempCubic.Sys_Version },
                            //{ str_colName: 'CheckedByID', value: productObj.RepoLabel11 },
                            //{ str_colName: 'CheckedByName', value: productObj.Sys_BalID },
                            //{ str_colName: 'CheckedByDate', value: productObj.RepoLabel13 },
                            //{ str_colName: 'Stage', value: productObj.PrintNo },
                            //objLotData.LotNo
                            { str_colName: 'BRepSerNo', value: bRepSerNo },
                            { str_colName: 'RepoLabel11', value: tempCubic.Sys_Validation },
                            { str_colName: 'Lot', value: 'NA' },
                            // { str_colName: 'ActualCount', value: parseFloat(res[1].Param8_T1Neg) },
                            // { str_colName: 'ActualRPM', value: parseFloat(res[1].Param8_T1Pos) },
                            { str_colName: 'Area', value: tempCubic.Sys_Area },
                            { str_colName: 'AppearanceDesc', value: tempCubic.Sys_Appearance },
                            { str_colName: 'MachineSpeed_Min', value: tempCubic.Sys_MachineSpeed_Min },
                            { str_colName: 'MachineSpeed_Max', value: tempCubic.Sys_MachineSpeed_Max },
                            { str_colName: 'GenericName', value: tempCubic.Sys_GenericName },
                            { str_colName: 'BMRNo', value: tempCubic.Sys_BMRNo },


                        ]
                    }
                    //console.log(saveFriData);
                    await database.save(saveFriData);
                } else {
                    let updateFriability = {
                        str_tableName: 'tbl_tab_friability',
                        data: [
                            { str_colName: 'RWtBeforeTest', value: rwtBeforeTest },
                            { str_colName: 'PrEndDate', value: date.format(new Date(), 'YYYY-MM-DD') },
                            { str_colName: 'PrEndTime', value: date.format(new Date(), 'HH:mm:ss') },
                        ],
                        condition: [
                            { str_colName: 'RepSerNo', value: retuRes.sqNo },
                        ]
                    }
                    await database.update(updateFriability);
                }

                //objMonitor.monit({ case: 'FRIFINWT', idsNo: IdsNo, data: { test: 'FRIABILITY' } });
                // As soon as Before weight is taken the we have to hide menu for specific time
                var objActivity = {};
                Object.assign(objActivity,
                    { strUserId: tempUserObject.UserId },
                    { strUserName: tempUserObject.UserName },
                    { activity: 'Friability Weighment Started on IDS' + IdsNo });
                await objActivityLog.ActivityLogEntry(objActivity)
                // Instrument usage for Friability completed
                if (serverConfig.friabilityType == 'BFBO' || serverConfig.friabilityType == 'BFBT') {
                    var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
                    if (IPQCObject != undefined) {
                        selectedIds = IPQCObject.selectedIds;
                    } else {
                        selectedIds = IdsNo;
                    }
                    var tempBFBO = globalData.arrBFBO.find(k => k.idsNo == selectedIds);
                    tempBFBO.before = true;
                }
                await objInstrumentUsage.InstrumentUsage('Balance', IdsNo, 'tbl_instrumentlog_balance', 'Friability Weighment', 'started')
                await this.updateFriabilityTime(IdsNo, tempLimits);
                if (tempCubic.Sys_RotaryType == 'Double') {
                    mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBD1:${lwtBeforeTest} g`);
                    mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBD2:${rwtBeforeTest} g`)

                } else {
                    mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBD1:${nwtBeforeTest} g`);
                }

                return true;

            } else {
                //FrabilityOnBal
                if (tempCounterObj.counter == 2 && tempCubic.Sys_RotaryType == "Double") {
                    globalData.FrabilityOnBal.findIndex(k => k.idsNo == selectedIds) == -1 ?
                        globalData.FrabilityOnBal :
                        globalData.FrabilityOnBal.splice(globalData.FrabilityOnBal.findIndex(k => k.idsNo == selectedIds), 1);
                }


                var objFriBal = globalData.FrabilityOnBal.find(k => k.idsNo == IdsNo);
                if (tempCubic.Sys_RotaryType == "Double") {

                    if (objFriBal == undefined) {
                        globalData.FrabilityOnBal.push({ idsNo: selectedIds, dataValue1: actualProtocol, dataValue2: 0 })

                    } else {
                        objFriBal.dataValue2 = actualProtocol;
                    }
                }

                objFriBal = globalData.FrabilityOnBal.find(k => k.idsNo == IdsNo);
                if (tempCubic.Sys_RotaryType == 'Double') {
                    tempCounterObj.counter += 1; //counter only for Double rotary
                    lwtAfterTest = objFriBal.dataValue1;
                    rwtAfterTest = objFriBal.dataValue2;
                    nwtAfterTest = 0;

                } else {
                    lwtAfterTest = 0;
                    rwtAfterTest = 0;
                    nwtAfterTest = objFriBal.dataValue1;

                }


                if (tempCubic.Sys_RotaryType == 'Double' && tempCounterObj.counter == 3) {
                    let updateFriability = await models.tbl_tab_master8.update({
                        LWtAfterTest: lwtAfterTest,
                        PrEndDate: date.format(new Date(), 'YYYY-MM-DD'),
                        PrEndTime: date.format(new Date(), 'HH:mm:ss')
                    }, {
                        where: {
                            RepSerNo: retuRes.sqNo
                        }
                    })
                    // {
                    //     str_tableName: 'tbl_tab_friability',
                    //     data: [
                    //         { str_colName: 'LWtAfterTest', value: lwtAfterTest },
                    //         { str_colName: 'PrEndDate', value: date.format(new Date(), 'YYYY-MM-DD') },
                    //         { str_colName: 'PrEndTime', value: date.format(new Date(), 'HH:mm:ss') },
                    //     ],
                    //     condition: [
                    //         { str_colName: 'RepSerNo', value: retuRes.sqNo },
                    //     ]
                    // }

                } if (tempCubic.Sys_RotaryType == 'Double' && tempCounterObj.counter == 4) {
                    let updateFriability = await models.tbl_tab_master8.update({
                        NWtAfterTest: nwtAfterTest,
                        RWtAfterTest: rwtAfterTest,
                        PrEndDate: date.format(new Date(), 'YYYY-MM-DD'),
                        PrEndTime: date.format(new Date(), 'HH:mm:ss')
                    }, {
                        where: {
                            RepSerNo: retuRes.sqNo
                        }
                    })
                    // let updateFriability = await 
                    // {
                    //     str_tableName: 'tbl_tab_friability',
                    //     data: [
                    //         { str_colName: 'NWtAfterTest', value: nwtAfterTest },
                    //         { str_colName: 'RWtAfterTest', value: rwtAfterTest },
                    //         { str_colName: 'PrEndDate', value: date.format(new Date(), 'YYYY-MM-DD') },
                    //         { str_colName: 'PrEndTime', value: date.format(new Date(), 'HH:mm:ss') },
                    //     ],
                    //     condition: [
                    //         { str_colName: 'RepSerNo', value: retuRes.sqNo },
                    //     ]
                    // }
                    await database.update(updateFriability);
                } else {
                    if (tempCubic.Sys_RotaryType == 'Single') {
                        let updateFriability = await models.tbl_tab_master8.update({
                            NWtAfterTest: nwtAfterTest,
                            PrEndDate: date.format(new Date(), 'YYYY-MM-DD'),
                            PrEndTime: date.format(new Date(), 'HH:mm:ss')
                        }, {
                            where: {
                                RepSerNo: retuRes.sqNo
                            }
                        })
                        // let updateFriability = {
                        //     str_tableName: 'tbl_tab_friability',
                        //     data: [
                        //         { str_colName: 'NWtAfterTest', value: nwtAfterTest },
                        //         { str_colName: 'PrEndDate', value: date.format(new Date(), 'YYYY-MM-DD') },
                        //         { str_colName: 'PrEndTime', value: date.format(new Date(), 'HH:mm:ss') },
                        //     ],
                        //     condition: [
                        //         { str_colName: 'RepSerNo', value: retuRes.sqNo },
                        //     ]
                        // }
                        await database.update(updateFriability);
                    }

                }


                if (tempCubic.Sys_RotaryType == 'Double' && tempCounterObj.counter == 4) {
                    if (serverConfig.friabilityType == 'BFBO' || serverConfig.friabilityType == 'BFBT') {
                        // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
                        // if (IPQCObject != undefined) {
                        //     selectedIds = IPQCObject.selectedIds;
                        // } else {
                        //     selectedIds = IdsNo;
                        // }
                        var tempBFBO = globalData.arrBFBO.find(k => k.idsNo == selectedIds);
                        tempBFBO.before = false;
                        tempBFBO.setParam = false;
                        tempBFBO.after = false;
                    }
                } else {
                    if (tempCubic.Sys_RotaryType == 'Single') {
                        if (serverConfig.friabilityType == 'BFBO' || serverConfig.friabilityType == 'BFBT') {
                            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
                            // if (IPQCObject != undefined) {
                            //     selectedIds = IPQCObject.selectedIds;
                            // } else {
                            //     selectedIds = IdsNo;
                            // }
                            var tempBFBO = globalData.arrBFBO.find(k => k.idsNo == selectedIds);
                            tempBFBO.before = false;
                            tempBFBO.setParam = false;
                            tempBFBO.after = false;
                        }
                    }

                }


                // Selecting the value from friability
                var selectObj = {
                    str_tableName: 'tbl_tab_friability',
                    data: '*',
                    condition: [
                        { str_colName: 'RepSerNo', value: retuRes.sqNo },
                    ]
                }
                let friabilityInfo = await database.select(selectObj);
                // if (serverConfig.ProjectName == 'MLVeer') {
                //     // Added for only MLVERR on 30/05/2020
                //     var SPresu = await objSP.PercentageCalculationForFriability(retuRes.sqNo);
                // }

                //insert batch summary and clear the array
                if (tempCubic.Sys_RotaryType == 'Double' && tempCounterObj.counter == 4) {
                    let batchSummaryObject = {
                        BFGCode: tempCubic.Sys_BFGCode,
                        ProductName: tempCubic.Sys_ProductName,
                        PVersion: tempCubic.Sys_PVersion,
                        Version: tempCubic.Sys_Version,
                        PrdType: 1,
                        CubType: tempCubic.Sys_CubType,
                        BatchNo: tempCubic.Sys_Batch,
                        Unit: 'g',
                        Side: tempCubic.Sys_RotaryType,
                        InstrumentID: CurrentCubic.Sys_BalID,
                        UserId: tempUserObject.UserId,
                        UserName: tempUserObject.UserName,
                        nwtBeforeTestF: friabilityInfo[0][0].NWtBeforeTest,
                        nwtAfterTestF: friabilityInfo[0][0].NWtAfterTest,
                        lwtBeforeTestF: friabilityInfo[0][0].LWtBeforeTest,
                        lwtAfterTestF: friabilityInfo[0][0].LWtAfterTest,
                        rwtBeforeTestF: friabilityInfo[0][0].RWtBeforeTest,
                        rwtAfterTestF: friabilityInfo[0][0].RWtAfterTest,
                        Dept: tempCubic.Sys_dept,
                        Nom: friabilityInfo[0][0].FriNMTLimit,
                        PrTime: date.format(now, 'HH:mm:ss'),
                        PrDate: date.format(now, 'YYYY-MM-DD'),
                        ReportType: 0,
                        DP: friabilityInfo[0][0].DecimalPoint
                    }
                    await objBatchSummary.saveBatchSummaryFriability(batchSummaryObject, IdsNo, FriabilityDetail1.data.Side);
                    var objActivity = {};
                    Object.assign(objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { activity: `${mqttProtocol.Friability} Weighment Completed on IDS ${strHmi} For Side ${FriabilityDetail1.data.Side}` });
                    await objActivityLog.ActivityLogEntry(objActivity);
                    // Instrument usage for Friability completed
                    await objInstrumentUsage.InstrumentUsage('Balance', IdsNo, 'tbl_instrumentlog_balance', '', 'completed');

                    var response = await objSP.getRemarkForFriability(retuRes.sqNo);

                    if (tempCubic.Sys_RotaryType == 'Double') {
                        var netWtD1 = Math.round(friabilityInfo[0][0].LWtAfterTest - friabilityInfo[0][0].LWtBeforeTest);
                        var netWtD2 = Math.round(friabilityInfo[0][0].RWtAfterTest - friabilityInfo[0][0].RWtBeforeTest);

                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBD1:${friabilityInfo[0][0].LWtBeforeTest} g;WTAD1:${friabilityInfo[0][0].LWtAfterTest} g;NWTD1:${netWtD1} g`);
                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBD2 : ${friabilityInfo[0][0].RWtBeforeTest} g;WTAD2:${friabilityInfo[0][0].RWtAfterTest} g;NWTD2:${netWtD2} g`)

                    }



                    mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult} ${response} `);
                    //need to check response of remark 
                    // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}${response}`);
                    globalData.arrBFBO.findIndex(k => k.Hmi == strHmi) == -1 ?
                        globalData.arrBFBO :
                        globalData.arrBFBO.splice(globalData.arrBFBO.findIndex(k => k.Hmi == strHmi), 1);

                    globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi) == -1 ?
                        globalData.arrWeighmentCounterForFriab :
                        globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi), 1);

                    (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus :
                        globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);
                    //test splice if rotarty is not double
                    globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
                        globalData.arrSelectedMenu :
                        globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);
                    mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}Friability Test Completed`);
                } else {
                    if (tempCubic.Sys_RotaryType == 'Single') {
                        let batchSummaryObject = {
                            BFGCode: tempCubic.Sys_BFGCode,
                            ProductName: tempCubic.Sys_ProductName,
                            PVersion: tempCubic.Sys_PVersion,
                            Version: tempCubic.Sys_Version,
                            PrdType: 1,
                            CubType: tempCubic.Sys_CubType,
                            BatchNo: tempCubic.Sys_Batch,
                            Unit: 'g',
                            Side: tempCubic.Sys_RotaryType,
                            InstrumentID: CurrentCubic.Sys_BalID,
                            UserId: tempUserObject.UserId,
                            UserName: tempUserObject.UserName,
                            nwtBeforeTestF: friabilityInfo[0][0].NWtBeforeTest,
                            nwtAfterTestF: friabilityInfo[0][0].NWtAfterTest,
                            lwtBeforeTestF: friabilityInfo[0][0].LWtBeforeTest,
                            lwtAfterTestF: friabilityInfo[0][0].LWtAfterTest,
                            rwtBeforeTestF: friabilityInfo[0][0].RWtBeforeTest,
                            rwtAfterTestF: friabilityInfo[0][0].RWtAfterTest,
                            Dept: tempCubic.Sys_dept,
                            Nom: friabilityInfo[0][0].FriNMTLimit,
                            PrTime: date.format(now, 'HH:mm:ss'),
                            PrDate: date.format(now, 'YYYY-MM-DD'),
                            ReportType: 0,
                            DP: friabilityInfo[0][0].DecimalPoint
                        }
                        await objBatchSummary.saveBatchSummaryFriability(batchSummaryObject, IdsNo, FriabilityDetail1.data.Side);
                        var objActivity = {};
                        Object.assign(objActivity,
                            { strUserId: tempUserObject.UserId },
                            { strUserName: tempUserObject.UserName },
                            { activity: `${mqttProtocol.Friability} Weighment Completed on IDS ${strHmi} For Side ${FriabilityDetail1.data.Side}` });
                        await objActivityLog.ActivityLogEntry(objActivity);
                        // Instrument usage for Friability completed
                        await objInstrumentUsage.InstrumentUsage('Balance', IdsNo, 'tbl_instrumentlog_balance', '', 'completed');

                        var response = await objSP.getRemarkForFriability(retuRes.sqNo);
                        var netWtforSingle = Math.round(friabilityInfo[0][0].NWtAfterTest - friabilityInfo[0][0].NWtBeforeTest);
                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBD1:${friabilityInfo[0][0].NWtBeforeTest};WTAD1:${friabilityInfo[0][0].NWtAfterTest} g;NWTD1:${netWtforSingle} g`);


                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult} ${response} `);


                        //need to check response of remark 
                        // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}${response}`);
                        globalData.arrBFBO.findIndex(k => k.Hmi == strHmi) == -1 ?
                            globalData.arrBFBO :
                            globalData.arrBFBO.splice(globalData.arrBFBO.findIndex(k => k.Hmi == strHmi), 1);

                        globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi) == -1 ?
                            globalData.arrWeighmentCounterForFriab :
                            globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi), 1);

                        (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus :
                            globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);
                        //test splice if rotarty is not double
                        globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
                            globalData.arrSelectedMenu :
                            globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);
                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} Test Completed`);
                    }
                }





                return;
            }
        } catch (error) {
            console.log(error)
            return error;
        }
    }


    async checkFriabilityStatus(IdsNo) {
        var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
        var selectedIds;
        var returnResult = {};
        if (IPQCObject != undefined) {
            selectedIds = IPQCObject.selectedIds;
        } else {
            selectedIds = IdsNo;
        }
        var tempCubic = globalData.arrIdsInfo.find(k => k.idsNo == selectedIds).cubicalData;
        const checkData = {
            str_tableName: 'tbl_tab_friability',
            data: 'MAX(RepSerNo) AS SeqNo',
            condition: [
                { str_colName: 'BFGCode', value: tempCubic.Sys_BFGCode, comp: 'eq' },
                { str_colName: 'ProductName', value: tempCubic.Sys_ProductName, comp: 'eq' },
                { str_colName: 'PVersion', value: tempCubic.Sys_PVersion, comp: 'eq' },
                { str_colName: 'Version', value: tempCubic.Sys_Version, comp: 'eq' },
                { str_colName: 'BatchNo', value: tempCubic.Sys_Batch, comp: 'eq' },
                { str_colName: 'IdsNo', value: selectedIds, comp: 'eq' },
            ]
        }
        var checkFlag = 0;
        var chkResult = await database.select(checkData);
        var result = [];
        if (chkResult[0][0].SeqNo == null) {
            checkFlag = 0;
        } else {
            checkFlag = 1;
        }
        if (checkFlag == 1) {
            var fraibData = {
                str_tableName: 'tbl_tab_friability',
                data: '*',
                condition: [
                    { str_colName: 'RepSerNo', value: chkResult[0][0].SeqNo, comp: 'eq' },
                ]
            }
            result = await database.select(fraibData);
            result = result[0]
        }
        if (result.length > 0) {
            if (tempCubic.Sys_RotaryType == 'Double') {
                if (result[0].LWtBeforeTest != 0 && result[0].LWtAfterTest != 0
                    && result[0].RWtBeforeTest != 0 && result[0].RWtAfterTest != 0) {
                    Object.assign(returnResult, { status: 'before', sqNo: result[0].RepSerNo })

                } else if (result[0].LWtBeforeTest != 0 && result[0].LWtAfterTest == 0
                    && result[0].RWtBeforeTest == 0 && result[0].RWtAfterTest == 0) {
                    Object.assign(returnResult, { status: 'before', sqNo: result[0].RepSerNo })

                } else if (result[0].LWtBeforeTest != 0 && result[0].LWtAfterTest != 0
                    && result[0].RWtBeforeTest != 0 && result[0].RWtAfterTest == 0) {
                    Object.assign(returnResult, { status: 'after', sqNo: result[0].RepSerNo })

                }
                else if (result[0].LWtBeforeTest != 0 && result[0].LWtAfterTest == 0
                    && result[0].RWtBeforeTest != 0 && result[0].RWtAfterTest == 0) {
                    Object.assign(returnResult, { status: 'after', sqNo: result[0].RepSerNo })


                } else if (result[0].LWtBeforeTest == 0 && result[0].LWtAfterTest == 0
                    && result[0].RWtBeforeTest == 0 && result[0].RWtAfterTest == 0) {
                    Object.assign(returnResult, { status: 'before', sqNo: result[0].RepSerNo })

                }
            } else {
                if (result[0].NWtBeforeTest != 0 && result[0].NWtAfterTest != 0) {
                    Object.assign(returnResult, { status: 'before', sqNo: result[0].RepSerNo })

                } else if (result[0].NWtBeforeTest != 0 && result[0].NWtAfterTest == 0) {
                    Object.assign(returnResult, { status: 'after', sqNo: result[0].RepSerNo })

                } else if (result[0].NWtBeforeTest == 0 && result[0].NWtAfterTest == 0) {
                    Object.assign(returnResult, { status: 'before', sqNo: result[0].RepSerNo })

                }
            }
        } else {
            Object.assign(returnResult, { status: 'before', sqNo: 0 })

        }
        return returnResult;
    }

    async updateFriabilityTime(IdsNo, tempLimits) {
        try {
            // Fetching global array for Fraibitlity
            var selectedIds = IdsNo;;
            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
            // if (IPQCObject != undefined) {
            //     selectedIds = IPQCObject.selectedIds;
            // } else {
            //     selectedIds  = IdsNo;
            // }
            let COUNT = parseFloat(tempLimits.T1Neg);
            let RPM = parseFloat(tempLimits.T1Pos);
            let SECONDS = (COUNT / RPM) * 60
            // var tempOBJ = globalData.arrFriabilityMenuVisibility.find(k => k.idsNo == selectedIds);
            // tempOBJ.ETS = SECONDS;
            // console.log(globalData.arrFriabilityMenuVisibility)
        } catch (err) {
            console.log(err);
            return err
        }
    }

    precision(a) {
        if (!isFinite(a)) return 0;
        var e = 1, p = 0;
        while (Math.round(a * e) / e !== a) { e *= 10; p++; }
        return p;
    }

    /**
     * Fribilator Bulk Data
     */
    async insertBulkFriabilityComb(_paramObj) {
        try {
            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
            // var objInvalid = globalData.arrBulkInvalid.find(k => k.idsNo == IdsNo);
            let strHmi = _paramObj.Hmi;
            let strIdsNo = _paramObj.idsNo;
            let receiveWt = _paramObj.actualWt;
            let unit = _paramObj.unit;
            // if (IPQCObject != undefined) {
            //     selectedIds = IPQCObject.selectedIds;
            // } else {
            //     selectedIds = IdsNo;
            // }
            let cubicalData = globalData.arrIdsInfo.find(k => k.idsNo == strIdsNo);
            const tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);

            var objActivity = {};
            Object.assign(objActivity,
                { strUserId: tempUserObject.UserId },
                { strUserName: tempUserObject.UserName },
                { activity: 'Friabilator Started on IDS' + strIdsNo });
            await objActivityLog.ActivityLogEntry(objActivity);
            // Instrument usage for Friability started
            // objInstrumentUsage.InstrumentUsage('Friability', strIdsNo, 'tbl_instrumentlog_friability', 'Friability', 'started');

            let retuRes = await this.checkFriabilityStatus(strIdsNo);

            if (retuRes.status != 'before') {
                var updateFriability = {
                    str_tableName: 'tbl_tab_friability',
                    data: [
                        { str_colName: 'ActualCount', value: _paramObj.rpm },
                        { str_colName: 'ActualRPM', value: _paramObj.rpmCount },
                    ],
                    condition: [
                        { str_colName: 'RepSerNo', value: retuRes.sqNo },
                    ]
                }
                await database.update(updateFriability);


                var selectFriability = {
                    str_tableName: 'tbl_tab_friability',
                    data: '*',
                    condition: [
                        { str_colName: 'RepSerNo', value: retuRes.sqNo },
                    ]
                }
                let getBeforeWt = await database.select(selectFriability);

                /**
                 * getting before weight for double and single
                 */

                if (cubicalData.Sys_RotaryType == "Double") {

                    let lftBefore = getBeforeWt[0][0].LWtBeforeTest;
                    let rwtBefore = getBeforeWt[0][0].RWtBeforeTest;
                } else {
                    let newWt = getBeforeWt[0][0].NWtBeforeTest;
                }


                var objActivity = {};
                Object.assign(objActivity,
                    { strUserId: tempUserObject.UserId },
                    { strUserName: tempUserObject.UserName },
                    { activity: 'Friabilator String completed on IDS' + strIdsNo });
                await objActivityLog.ActivityLogEntry(objActivity);
                objInstrumentUsage.InstrumentUsage('Friability', strIdsNo, 'tbl_instrumentlog_friability', '', 'completed');

                if (serverConfig.friabilityType == 'BFBO' || serverConfig.friabilityType == 'BFBT') {
                    var tempBFBO = globalData.arrBFBO.find(k => k.idsNo == strIdsNo);
                    tempBFBO.setParam = true;
                }


                if (cubicalData.Sys_RotaryType == "Double") {

                    let lftBefore = getBeforeWt[0][0].LWtBeforeTest;
                    let rwtBefore = getBeforeWt[0][0].RWtBeforeTest;
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}Set_RPM:${_paramObj.rpm};Set_Count:${_paramObj.rpmCount}`);
                } else {
                    let newWt = getBeforeWt[0][0].NWtBeforeTest;
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}Set_RPM:${_paramObj.rpm};Set_Count:${_paramObj.rpmCount}`);
                }


            } else {
                if (cubicalData.Sys_RotaryType == "Double") {

                    let lftBefore = getBeforeWt[0][0].LWtBeforeTest;
                    let rwtBefore = getBeforeWt[0][0].RWtBeforeTest;
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}Set_RPM:${_paramObj.rpm};Set_Count:${_paramObj.rpmCount}`);
                } else {
                    let newWt = getBeforeWt[0][0].NWtBeforeTest;
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}Set_RPM:${_paramObj.rpm};Set_Count:${_paramObj.rpmCount}`);
                }
            }

        } catch (err) {
            throw new Error(err);
        }
    }

    async getMaxBRepSerNo(productName, strBatch, strTableName, reportType, cubType) {
        try {
            const tblDetails = await models[strTableName].findAll({
                where: {
                    // PVersion: selectedCub.Sys_PVersion,
                    // Version: selectedCub.Sys_Version,
                    BatchNo: strBatch,
                    // BFGCode: dataObj.objProductDetails.ProductId,
                    ProductName: productName,
                    ReportType: reportType,
                    // CubicleType:cubType

                }
            }
            )
            // const tblDetails1 = await models[incomplete].findAll({
            //     where: {
            //         // PVersion: selectedCub.Sys_PVersion,
            //         // Version: selectedCub.Sys_Version,
            //         BatchNo: strBatch,
            //         // BFGCode: dataObj.objProductDetails.ProductId,
            //         ProductName: productName,
            //         ReportType:reportType,

            //     }
            // }
            // )

            if (tblDetails.length != 0) {
                let maxColumn = tblDetails.length >= 1 ? tblDetails.pop() : tblDetails;
                // if (tblDetails.length != 0) {
                //     let maxColumninc = tblDetails1.length >= 1 ? tblDetails1.pop() : tblDetails1
                let BRepSerNo = maxColumn.BRepSerNo + 1
                return BRepSerNo;
            } else {
                return 1
            }
        } catch (error) {
            throw new Error()
        }
    }


}

// class FriabilityModel {

//     async processFriabilityData(dataObj) {
//         try {
//             let strHmi = dataObj.Hmi;
//             let strIdsNo = dataObj.idsNo;
//             let CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.idsNo == strIdsNo).cubicalData;
//             let tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
//             let __activityObj = {
//                 strUserId: tempUserObject.UserId,
//                 strUserName: tempUserObject.UserName,
//                 activity: `Friabilator Weighment Started on IDS ${strHmi}`
//             }

//             let selectedIdsNo;
//             var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strIdsNo);
//             if (IPQCObject != undefined) {
//                 selectedIdsNo = IPQCObject.selectedIds;
//             } else {
//                 selectedIdsNo = strIdsNo;
//             }
//             let hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.idsNo == selectedIdsNo).cubicalData;
//             await objActivityLog.ActivityLogEntry(__activityObj);
//             await objInstrumentUsage.InstrumentUsage('Balance',
//                 strIdsNo, 'tbl_instrumentlog_friability', 'Friabilator', 'started');

//             if (hmiDetailsInPMenu.Sys_RotaryType == "Double" && dataObj.recived_string_type == "Single") {
//                 console.log("invalid string")
//                 return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid string Received`);

//             }
//             else {
//                 //type
//                 // let strIdsNo = dataObj.idsNo;
//                 let actualWtA1 = dataObj.actualWtAfterDrum1.split(' ');
//                 let actualWtA2 = dataObj.actualWtAfterDrum2.split(' ');
//                 let actualWtB1 = dataObj.actualWtBeforeDrum1.split(' ');
//                 let actualWtB2 = dataObj.actualWtBeforeDrum2.split(' ');
//                 // let decimal1 = dataObj.decPoint1
//                 // let decimal2 = dataObj.decPoint2;
//                 // let unit1 = dataObj.unit1
//                 // let unit2 = dataObj.unit2;
//                 const menuName = dataObj.menuName;
//                 let typeValue;


//                 let lwtBeforeTest, lwtAfterTest, rwtAfterTest, rwtBeforeTest, nwtBeforeTest, nwtAfterTest;
//                 let objActivity = {};
//                 const FriabilityDetail1 = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi);
//                 const productDetail = globalData.arrProductTypeArray.find(k => k.Hmi == selectedIdsNo);
//                 const objSelMenu = globalData.arrSelectedMenu.find(k => k.idsNo == strIdsNo);
//                 let batchNo = FriabilityDetail1.data.Batch;
//                 let sample = FriabilityDetail1.data.noOfSample;
//                 let tempCounterObj = globalData.arrWeighmentCounter.find(k => k.Hmi == strHmi);
//                 let tempUserObject = globalData.arrUsers.find(k => k.Hmi === strHmi);
//                 let strTableName, strDetailTbl;

//                 if (tempCounterObj === undefined) {
//                     globalData.arrWeighmentCounter.push({
//                         'Hmi': strHmi,
//                         'counter': 0
//                     })
//                 }
//                 tempCounterObj = globalData.arrWeighmentCounter.find(k => k.Hmi == strHmi);

//                 switch (menuName) {
//                     case 'Friability': {
//                         strTableName = "tbl_tab_friability";
//                         typeValue = 8;
//                     }
//                         break;
//                     default:
//                 }

//                 let productObj = FriabilityDetail1.data;
//                 let side;
//                 if (productObj.Side == 'Single') {
//                     side = "NA";
//                     console.log('single');
//                 }
//                 else {
//                     side = "LHS";
//                 }

//                 lwtBeforeTest = parseFloat(actualWtB1[0]);
//                 rwtBeforeTest = isNaN(parseFloat(actualWtB2[0])) == true ? 0 : parseFloat(actualWtB2[0]);

//                 lwtAfterTest = parseFloat(actualWtA1[0]);
//                 rwtAfterTest = isNaN(parseFloat(actualWtA2[0])) == true ? 0 : parseFloat(actualWtA2[0]);


//                 nwtBeforeTest = 0;
//                 nwtAfterTest = 0;

//                 if (hmiDetailsInPMenu.Sys_RotaryType == "Single") {
//                     nwtBeforeTest = (((lwtBeforeTest - lwtAfterTest) * 100) / lwtBeforeTest).toFixed(5);
//                     nwtAfterTest = 0

//                 } else {
//                     nwtBeforeTest = (((lwtBeforeTest - lwtAfterTest) * 100) / lwtBeforeTest).toFixed(5);
//                     nwtAfterTest = (((rwtBeforeTest - rwtAfterTest) * 100) / rwtBeforeTest).toFixed(5);
//                 }

//                 const __parameterFriability = {
//                     strTableName: strTableName,
//                     strDetailTbl: strDetailTbl,
//                     objProductDetails: productDetail.productType,
//                     uniqueSerialNumber: strIdsNo,
//                     strBalId: dataObj.instrumentId,
//                     WTBD1: lwtBeforeTest,
//                     WTAD1: lwtAfterTest,
//                     WTBD2: rwtBeforeTest,
//                     WTAD2: rwtAfterTest,
//                     nwtBeforeTest: nwtBeforeTest,
//                     nwtAfterTest: nwtAfterTest,
//                     strHmi: strHmi,
//                     strIdsNo: strIdsNo,
//                     seqNoOfWt: tempCounterObj.counter,
//                     productType: objSelMenu.selectedProductDetail,
//                     Batch: batchNo
//                 }


//                 // var res = await proObj.productData(productObj)
//                 // let productDetail = productDetail.productType
//                 let now = new Date();
//                 let batchSummaryObject = {
//                     BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
//                     ProductName: hmiDetailsInPMenu.Sys_ProductName,
//                     PVersion: hmiDetailsInPMenu.Sys_PVersion,
//                     Version: hmiDetailsInPMenu.Sys_Version,
//                     PrdType: 1,
//                     CubType: hmiDetailsInPMenu.Sys_CubType,
//                     BatchNo: hmiDetailsInPMenu.Sys_Batch,
//                     Unit: hmiDetailsInPMenu.Sys_BatchSizeUnit,
//                     Side: hmiDetailsInPMenu.Sys_RotaryType,
//                     InstrumentID: CurrentCubicalObj.Sys_FriabID,
//                     UserId: tempUserObject.UserId,
//                     UserName: tempUserObject.UserName,
//                     nwtBeforeTest: nwtBeforeTest,
//                     nwtAfterTest: nwtAfterTest,
//                     lwtBeforeTest: lwtBeforeTest,
//                     lwtAfterTest: lwtAfterTest,
//                     rwtBeforeTest: rwtBeforeTest,
//                     rwtAfterTest: rwtAfterTest,
//                     Dept: hmiDetailsInPMenu.Sys_dept,
//                     Nom: productDetail.productDetail.Param8_Nom,
//                     PrTime: date.format(now, 'HH:mm:ss'),
//                     PrDate: date.format(now, 'YYYY-MM-DD')
//                 }

//                 console.log(batchSummaryObject);
//                 let resFri = await this.saveToCompleteData(__parameterFriability, productDetail);
//                 if (resFri) {
//                     Object.assign(objActivity,
//                         { strUserId: tempUserObject.UserId },
//                         { strUserName: tempUserObject.UserName },
//                         { activity: `Friabilator Weighment Completed on IDS ${strHmi}` });

//                     await objActivityLog.ActivityLogEntry(objActivity);
//                     await objInstrumentUsage.InstrumentUsage('Balance', strIdsNo, 'tbl_instrumentlog_friability', '', 'completed');

//                 }
//                 await objBatchSummary.saveBatchSummaryFriability(batchSummaryObject, strIdsNo);

//                 mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBD1:${__parameterFriability.WTBD1};WTAD1:${__parameterFriability.WTAD1};WTBD2:${__parameterFriability.WTBD2};WTAD2:${__parameterFriability.WTAD2};NWTD1:${nwtBeforeTest};NWTD2:${nwtAfterTest}`);

//                 globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi) == -1 ?
//                     globalData.arrWeighmentProductData :
//                     globalData.arrWeighmentProductData.splice(globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi), 1);

//                 globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi) == -1 ?
//                     globalData.arrProductTypeArray :
//                     globalData.arrProductTypeArray.splice(globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi), 1);

//                 globalData.arrWeighmentCounter.findIndex(k => k.Hmi == strHmi) == -1 ?
//                     globalData.arrWeighmentCounter :
//                     globalData.arrWeighmentCounter.splice(globalData.arrWeighmentCounter.findIndex(k => k.Hmi == strHmi), 1);

//                 (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus :
//                     globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);
//                 //test splice if rotarty is not double
//                 globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
//                     globalData.arrSelectedMenu :
//                     globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);
//                 return mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}${menuName} test completed `);
//             }
//         } catch (error) {
//             throw new Error(error);
//         }
//     }

//     async saveToCompleteData(data, friDetail) {
//         try {
//             let strHmi = data.strHmi;
//             let strIdsNo = data.strIdsNo;
//             let CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.idsNo == strIdsNo).cubicalData; //idsNo
//             let tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
//             let productObj = data.objProductDetails;
//             let now = new Date();

//             let selectedIdsNo;
//             var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strIdsNo);
//             if (IPQCObject != undefined) {
//                 selectedIdsNo = IPQCObject.selectedIds;
//             } else {
//                 selectedIdsNo = strIdsNo;
//             }


//             let hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.idsNo == selectedIdsNo).cubicalData;
//             const checkData = {
//                 str_tableName: 'tbl_tab_friability',
//                 data: 'MAX(MstSerNo) AS SeqNo',
//                 condition: [
//                     { str_colName: 'BFGCode', value: productObj.ProductId, comp: 'eq' },
//                     { str_colName: 'ProductName', value: productObj.ProductName, comp: 'eq' },
//                     { str_colName: 'PVersion', value: productObj.ProductVersion, comp: 'eq' },
//                     { str_colName: 'Version', value: productObj.Version, comp: 'eq' },
//                     { str_colName: 'BatchNo', value: data.Batch, comp: 'eq' },
//                     { str_colName: 'IdsNo', value: data.uniqueSerialNumber, comp: 'eq' },
//                 ]
//             }

//             var result = await database.select(checkData)
//             var intMstSerNo;
//             if (result[0][0].SeqNo == null) {
//                 intMstSerNo = 1;
//             } else {
//                 var newMstSerNo = result[0][0].SeqNo + 1;
//                 intMstSerNo = newMstSerNo;
//             }

//             //remove net wt 

//             var saveFriData = {
//                 str_tableName: 'tbl_tab_friability',
//                 data: [
//                     { str_colName: 'MstSerNo', value: intMstSerNo },
//                     { str_colName: 'InstruId', value: 0 },
//                     { str_colName: 'BFGCode', value: productObj.ProductId },
//                     { str_colName: 'ProductName', value: productObj.ProductName },
//                     { str_colName: 'ProductType', value: productObj.ProductType },
//                     { str_colName: 'IdsNo', value: data.uniqueSerialNumber },
//                     { str_colName: 'CubicalNo', value: hmiDetailsInPMenu.Sys_CubicNo },
//                     { str_colName: 'CubicleName', value: hmiDetailsInPMenu.Sys_CubicName },
//                     { str_colName: 'CubicleLocation', value: hmiDetailsInPMenu.Sys_Location },
//                     { str_colName: 'BatchNo', value: data.Batch },
//                     { str_colName: 'UserId', value: tempUserObject.UserId },
//                     { str_colName: 'UserName', value: tempUserObject.UserName },
//                     { str_colName: 'PrDate', value: date.format(now, 'YYYY-MM-DD') },
//                     { str_colName: 'PrTime', value: date.format(now, 'HH:mm:ss') },
//                     { str_colName: 'PrEndDate', value: date.format(now, 'YYYY-MM-DD') },
//                     { str_colName: 'PrEndTime', value: date.format(now, 'HH:mm:ss') },
//                     { str_colName: 'Side', value: hmiDetailsInPMenu.Sys_RotaryType },
//                     { str_colName: 'Unit', value: 'g' },
//                     { str_colName: 'DecimalPoint', value: 0 },
//                     { str_colName: 'WgmtModeNo', value: 8 },
//                     { str_colName: 'FriNMTLimit', value: friDetail.productDetail.Param8_Nom },
//                     { str_colName: 'SetCount', value: friDetail.productDetail.Param8_T1Neg },
//                     { str_colName: 'SetRPM', value: friDetail.productDetail.Param8_T1Pos },
//                     { str_colName: 'FriabilityQty', value: '10' },
//                     { str_colName: 'CubicleType', value: hmiDetailsInPMenu.Sys_CubType },
//                     { str_colName: 'ReportType', value: hmiDetailsInPMenu.Sys_RptType },
//                     { str_colName: 'MachineCode', value: hmiDetailsInPMenu.Sys_MachineCode },
//                     { str_colName: 'MFGCode', value: hmiDetailsInPMenu.Sys_MfgCode },
//                     { str_colName: 'BatchSize', value: hmiDetailsInPMenu.Sys_BatchSize },
//                     { str_colName: 'FriabilityID', value: CurrentCubicalObj.Sys_FriabID },
//                     { str_colName: 'NWtBeforeTest', value: data.nwtBeforeTest },
//                     { str_colName: 'NWtAfterTest', value: data.nwtBeforeTest },
//                     { str_colName: 'LWtBeforeTest', value: data.WTBD1 },
//                     { str_colName: 'LWtAfterTest', value: data.WTAD1 },
//                     { str_colName: 'RWtBeforeTest', value: data.WTBD2 },
//                     { str_colName: 'RWtAfterTest', value: data.WTAD2 },
//                     { str_colName: 'PrintNo', value: 0 },
//                     { str_colName: 'IsArchived', value: 0 },
//                     { str_colName: 'BalanceId', value: CurrentCubicalObj.Sys_BalID },
//                     { str_colName: 'PVersion', value: hmiDetailsInPMenu.Sys_PVersion },
//                     { str_colName: 'Version', value: hmiDetailsInPMenu.Sys_Version },
//                     { str_colName: 'BRepSerNo', value: 0 },
//                     { str_colName: 'RepoLabel11', value: hmiDetailsInPMenu.Sys_Validation },
//                     { str_colName: 'Lot', value: 'LotNo' },
//                     { str_colName: 'ActualCount', value: 25 },
//                     { str_colName: 'ActualRPM', value: 100 },
//                     { str_colName: 'Area', value: hmiDetailsInPMenu.Sys_Area },
//                     { str_colName: 'AppearanceDesc', value: hmiDetailsInPMenu.Sys_Appearance },
//                     { str_colName: 'MachineSpeed_Min', value: hmiDetailsInPMenu.Sys_MachineSpeed_Min },
//                     { str_colName: 'MachineSpeed_Max', value: hmiDetailsInPMenu.Sys_MachineSpeed_Max },
//                     { str_colName: 'GenericName', value: hmiDetailsInPMenu.Sys_GenericName },
//                     { str_colName: 'BMRNo', value: hmiDetailsInPMenu.Sys_BMRNo },

//                 ]
//             }

//             let result1 = await database.save(saveFriData);
//         } catch (error) {
//             throw new Error(error);
//         }
//     }

//     //for Balance With Friability
//     async processBalanceFriabilityData(dataObj) {
//         try {
//             let now = new Date();
//             let strHmi = dataObj.Hmi;
//             let strIdsNo = dataObj.idsNo;
//             let receiveWt = dataObj.actualWt;
//             let unit = dataObj.unit;
//             let tempCounterObj = globalData.arrWeighmentCounter.find(k => k.Hmi == strHmi);
//             const FriabilityDetail1 = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi);
//             const objSelMenu = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);
//             let batchNo = FriabilityDetail1.data.Batch;
//             let sample = FriabilityDetail1.data.noOfSample;
//             let CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;

//             var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
//             if (IPQCObject != undefined) {
//                 strHmi = IPQCObject.selectedIds;
//             } else {
//                 strHmi = strHmi;
//             }
//             if (FriabilityDetail1.data.Rotary == 'Double') {
//                 let SideArray = globalData.DoubSideForFriab.find(k => k.Hmi == strHmi)
//                 if (SideArray != undefined) {
//                     var Side = globalData.DoubSideForFriab.find(k => k.Hmi == strHmi).Side
//                 }
//                 var tempSide;
//                 if (FriabilityDetail1.data.Rotary == 'Double') {
//                     if (FriabilityDetail1.data.Side == 'LHS') {
//                         tempSide = 'RHS'
//                     } else {
//                         tempSide = 'LHS'
//                     }
//                 }
//             }
//             const productDetail = globalData.arrProductTypeArray.find(k => k.Hmi == strHmi);
//             let tempCounterObjAfter = globalData.arrWeighmentCounterAfter.find(k => k.Hmi == strHmi);
//             let lstInsertId;
//             let hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
//             let tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
//             // let objActivity = {};
//             // let __activityObj = {};

//             //powerbackup

//             let powerbacc = await models.tbl_powerbackup.findAll({
//                 where: {
//                     CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
//                     Idsno: strHmi
//                 }
//             })

//             powerbacc = powerbacc.pop();

//             if (powerbacc != undefined) {
//                 if (tempCounterObj === undefined) {
//                     globalData.arrWeighmentCounter.push({
//                         'Hmi': strHmi,
//                         'counter': powerbacc.Before_Count
//                     })
//                 }

//                 if (tempCounterObjAfter === undefined) {
//                     globalData.arrWeighmentCounterAfter.push({
//                         'Hmi': strHmi,
//                         'counter': powerbacc.After_Count
//                     })
//                 }
//             } else {
//                 if (tempCounterObj === undefined) {
//                     globalData.arrWeighmentCounter.push({
//                         'Hmi': strHmi,
//                         'counter': 0
//                     })
//                 }

//                 if (tempCounterObjAfter === undefined) {
//                     globalData.arrWeighmentCounterAfter.push({
//                         'Hmi': strHmi,
//                         'counter': 0
//                     })
//                 }
//             }


//             tempCounterObj = globalData.arrWeighmentCounter.find(k => k.Hmi == strHmi);

//             //temp counter for double

//             tempCounterObjAfter = globalData.arrWeighmentCounterAfter.find(k => k.Hmi == strHmi);

//             const __parameterFriability = {
//                 objProductDetails: productDetail.productType,
//                 uniqueSerialNumber: strIdsNo,
//                 strBalId: dataObj.instrumentId,
//                 strHmi: strHmi,
//                 receiveWt: receiveWt,
//                 seqNoOfWt: tempCounterObj.counter,
//                 productType: objSelMenu.selectedProductDetail,
//                 Batch: batchNo,
//                 unit: unit
//             }


//             let removeTimeForMenuDisable = productDetail.productDetail[0][0].Param8_T1Pos / productDetail.productDetail[0][0].Param8_T1Neg;
//             var addTime = this.AddMinutesToDate(now, removeTimeForMenuDisable);
//             var dateFormat = this.DateFormat(addTime).split(' ');
//             dateFormat = dateFormat[1];
//             var dateFormat1 = this.DateFormat(addTime);
//             // console.log(dateFormat);

//             //before
//             if ((tempCounterObj.counter == 0 || tempCounterObj.counter == 1) && tempCounterObjAfter.counter == 0) {
//                 //send wt  before for both side

//                 if (tempCounterObj.counter == 0) {
//                     // tempCounterObj.counter += 1;
//                     //30/01/23 S Instrument Usage Activity log
//                     let __activityObj = {
//                         strUserId: tempUserObject.UserId,
//                         strUserName: tempUserObject.UserName,
//                         activity: `Friability Weighment Started on TSH ${strHmi}`,
//                     };

//                     await objActivityLog.ActivityLogEntry(__activityObj);
//                     await objInstrumentUsage.InstrumentUsage("Balance", strIdsNo, "tbl_instrumentlog_balance", objSelMenu.menuName, "started");
//                     //30/01/23 E
//                     //master entry 
//                     lstInsertId = await this.saveToBalanceCompleteData(__parameterFriability, productDetail);
//                     //dislay wt ${mqttProtocol.DisplayResult}
//                     var recent_Time = moment().format('YYYY-MM-DD HH:mm:ss')
//                     const obj = {
//                         CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
//                         WeighmentType: 8,
//                         WeighmentName: 'Friability',
//                         Userid: tempUserObject.UserId,
//                         ReportType: hmiDetailsInPMenu.Sys_RptType,
//                         Incomp_RepSerNo: lstInsertId,
//                         ProductType: productDetail.productType.ProductType,
//                         Sys_CubType: 1,
//                         Sys_Batch: CurrentCubicalObj.Sys_Batch,
//                         Sys_BFGCode: CurrentCubicalObj.Sys_BFGCode,
//                         Before_Count: 1,
//                         Idsno: strHmi,
//                         EntryTimeStamp: moment(recent_Time).format('YYYY-MM-DD HH:mm:ss')

//                     }

//                     // if (FriabilityDetail1.data.Rotary == "Single" || FriabilityDetail1.data.Rotary == "Double") {
//                     //     Object.assign(obj, { 'EntryTimeStamp': addTime })
//                     // }
//                     // // await database.save(saveFriabilityPowerBackup);
//                     // await models.tbl_powerbackup.create(obj)
//                     //02/02/23 start
//                     if (FriabilityDetail1.data.Rotary == "Single") {
//                         Object.assign(obj, { 'EntryTimeStamp': addTime })
//                         await models.tbl_powerbackup.create(obj)
//                     }

//                     if (FriabilityDetail1.data.Rotary == "Double" && powerbacc == undefined) {
//                         await models.tbl_powerbackup.create(obj)

//                     } else {
//                         //update
//                         if (FriabilityDetail1.data.Rotary == "Double" && powerbacc.Before_Count == 1) {
//                             await models.tbl_powerbackup.update({
//                                 EntryTimeStamp: addTime
//                             }, {
//                                 where: {
//                                     CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
//                                     WeighmentName: 'FRIAB',
//                                     IdsNo: strHmi
//                                 }
//                             })
//                         }
//                     }
//                     //02/02/23 End
//                     mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBL1:${receiveWt + " " + unit}`);

//                 }

//                 if (FriabilityDetail1.data.Rotary == "Double") {
//                     tempCounterObj.counter += 1;
//                     let timeForMenuDisable = globalData.arrTimeForMenuDisable.find(k => k.Hmi == strHmi);
//                     if (timeForMenuDisable == undefined) {
//                         globalData.arrTimeForMenuDisable.push({
//                             Hmi: strHmi,
//                             idsNo: strIdsNo,
//                             // timeForMenuHide: removeTimeForMenuDisable,
//                             formatedTime: dateFormat1
//                         })
//                     } else {
//                         // timeForMenuDisable.timeForMenuHide = removeTimeForMenuDisable;
//                         timeForMenuDisable.timeForMenuHide = dateFormat1;

//                     }
//                     //left before wt drum 1 ka 
//                 } else if (FriabilityDetail1.data.Rotary == "Single") {
//                     tempCounterObjAfter.counter += 1;
//                     let timeForMenuDisable = globalData.arrTimeForMenuDisable.find(k => k.Hmi == strHmi);
//                     if (timeForMenuDisable == undefined) {
//                         globalData.arrTimeForMenuDisable.push({
//                             Hmi: strHmi,
//                             idsNo: strIdsNo,
//                             // timeForMenuHide: removeTimeForMenuDisable,
//                             formatedTime: dateFormat1
//                         })
//                     } else {
//                         // timeForMenuDisable.timeForMenuHide = removeTimeForMenuDisable;
//                         timeForMenuDisable.timeForMenuHide = dateFormat1;

//                     }
//                 }


//                 /**
//                  * For Double update in RWtBeforeTest column
//                  */
//                 if (tempCounterObj.counter == 2) {
//                     //update WTAR2
//                     var result = await models.tbl_tab_friability.findAll({
//                         attributes: [

//                             [sequelize.fn('MAX', sequelize.col("RepSerNo")), "RepSerNo"],
//                         ],
//                         where: {
//                             IdsNo: strHmi,
//                         },
//                         raw: true
//                     })

//                     await models.tbl_tab_friability.update({
//                         RWtBeforeTest: receiveWt
//                     }, {
//                         where: {
//                             RepSerNo: result[0].RepSerNo
//                         }
//                     })



//                     //power backup


//                     await models.tbl_powerbackup.update({
//                         Before_Count: tempCounterObj.counter,
//                         EntryTimeStamp: moment().format('YYYY-MM-DD HH:mm:ss')
//                     }, {
//                         where: {
//                             CubicalNo: hmiDetailsInPMenu.Sys_CubicNo
//                         }
//                     })


//                     mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBR2:${receiveWt + " " + unit}`);

//                     let timeForMenuDisable = globalData.arrTimeForMenuDisable.find(k => k.Hmi == strHmi);
//                     if (timeForMenuDisable == undefined) {
//                         globalData.arrTimeForMenuDisable.push({
//                             Hmi: strHmi,
//                             idsNo: strIdsNo,
//                             // timeForMenuHide: removeTimeForMenuDisable,
//                             formatedTime: dateFormat1
//                         })
//                     } else {
//                         // timeForMenuDisable.timeForMenuHide = removeTimeForMenuDisable;
//                         timeForMenuDisable.timeForMenuHide = dateFormat1;

//                     }
//                     // }

//                 }


//                 if (FriabilityDetail1.data.Rotary == "Single") {
//                     mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Friability Before Samples Completed,now wait for 4 mins`)
//                 } else if (FriabilityDetail1.data.Rotary == "Double" && tempCounterObj.counter == 2) {
//                     mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Friability Before Samples Completed,now wait for 4 mins`)
//                 }

//             } else {

//                 let now = new Date();
//                 let timeForMenuDisable = globalData.arrTimeForMenuDisable.find(k => k.Hmi == strHmi);
//                 // let initSampletime = new Date(date.format(new Date(powerbacc.EntryTimeStamp), 'YYYY-MM-DD HH:mm:ss'))
//                 // let currentTime = new Date(date.format(new Date(), 'YYYY-MM-DD HH:mm:ss'))
//                 let initSampletime = moment(powerbacc.EntryTimeStamp).add(4, 'minutes').format('YYYY-MM-DD HH:mm:ss')
//                 let currentTime = moment().format('YYYY-MM-DD HH:mm:ss')
//                 // console.log(this.DateFormat(now, time));
//                 if (Date.parse(currentTime) >= Date.parse(initSampletime)) {
//                     let __paramProductData = {
//                         ProductId: __parameterFriability.objProductDetails.ProductId,
//                         ProductName: __parameterFriability.objProductDetails.ProductName,
//                         ProductVersion: __parameterFriability.objProductDetails.ProductVersion,
//                         Version: __parameterFriability.objProductDetails.Version,
//                         Batch: __parameterFriability.Batch,
//                         uniqueSerialNumber: __parameterFriability.strHmi
//                     }

//                     if (FriabilityDetail1.data.Rotary == "Single") {
//                         tempCounterObjAfter.counter = 0;
//                     }

//                     //after enable menu 
//                     //clear this array tempCounterObj.counter
//                     if (tempCounterObjAfter.counter == 0) {
//                         // lstInsertId = await this.saveToBalanceCompleteData(__parameterFriability, productDetail);
//                         //dislay wt ${mqttProtocol.DisplayResult}
//                         var result = await this.checkProductData(__paramProductData);

//                         let resSelectFri = await models.tbl_tab_friability.findAll({
//                             where: {
//                                 RepSerNo: result[0].RepSerNo
//                             }
//                         })
//                         resSelectFri = resSelectFri[0];




//                         //powerbackup

//                         var updateData;
//                         if (FriabilityDetail1.data.Rotary == "Single") {

//                             await models.tbl_tab_friability.update({
//                                 NWtAfterTest: receiveWt
//                             }, {
//                                 where: {
//                                     RepSerNo: result[0].RepSerNo
//                                     // 'BFGCode': __parameterFriability.objProductDetails.ProductId,
//                                     // 'ProductName': __parameterFriability.objProductDetails.ProductName,
//                                     // 'PVersion': __parameterFriability.objProductDetails.ProductVersion,
//                                     // 'Version': __parameterFriability.objProductDetails.Version,
//                                     // 'BatchNo': __parameterFriability.Batch,
//                                     // 'IdsNo': __parameterFriability.uniqueSerialNumber,
//                                 }
//                             })

//                         } else {


//                             await models.tbl_tab_friability.update({
//                                 LWtAfterTest: receiveWt
//                             }, {
//                                 where: {
//                                     RepSerNo: result[0].RepSerNo,

//                                 }
//                             })

//                         }

//                         // uppdate according to double rotary

//                         //powerbackup

//                         await models.tbl_powerbackup.update({
//                             After_Count: 1
//                         }, {
//                             where: {
//                                 'CubicalNo': powerbacc.CubicalNo
//                             }
//                         })

//                         //fetch data form friability table according to RepSrNo

//                         //batch summary 
//                         var batchSummaryObject = {
//                             BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
//                             ProductName: hmiDetailsInPMenu.Sys_ProductName,
//                             PVersion: hmiDetailsInPMenu.Sys_PVersion,
//                             Version: hmiDetailsInPMenu.Sys_Version,
//                             PrdType: 1,
//                             CubType: hmiDetailsInPMenu.Sys_CubType,
//                             BatchNo: hmiDetailsInPMenu.Sys_Batch,
//                             Unit: __parameterFriability.unit,
//                             Side: hmiDetailsInPMenu.Sys_RotaryType,
//                             InstrumentID: hmiDetailsInPMenu.Sys_BalID,
//                             Area: hmiDetailsInPMenu.Sys_Area,
//                             UserId: tempUserObject.UserId,
//                             UserName: tempUserObject.UserName,
//                             BatchSize: hmiDetailsInPMenu.Sys_BatchSize + " " + hmiDetailsInPMenu.Sys_BatchSizeUnit,
//                             // nwtBeforeTest: resSelectFri.NWtBeforeTest,
//                             // nwtAfterTest: resSelectFri.NWtAfterTest,
//                             // lwtBeforeTest: resSelectFri.LWtBeforeTest,
//                             // lwtAfterTest: resSelectFri.LWtAfterTest,
//                             // rwtBeforeTest: resSelectFri.RWtBeforeTest,
//                             // rwtAfterTest: resSelectFri.RWtAfterTest,
//                             Dept: hmiDetailsInPMenu.Sys_dept,
//                             Nom: productDetail.productDetail[0][0].Param8_Nom,
//                             PrTime: moment().format('HH:mm:ss'),
//                             PrDate: moment().format('YYYY-MM-DD')
//                         }


//                         if (FriabilityDetail1.data.Rotary == "Single") {
//                             await objBatchSummary.saveBatchSummaryFriability(batchSummaryObject, strHmi);
//                             let nwtD1 = (((resSelectFri.NWtBeforeTest - receiveWt) * 100) / resSelectFri.NWtBeforeTest).toFixed(5);
//                             mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBL1:${resSelectFri.NWtBeforeTest};WTAL1:${receiveWt + " " + unit};NWTD1:${nwtD1} ${unit}`);
//                         } else {
//                             mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBL1:${resSelectFri.InitialWt} ${unit};WTAL1:${receiveWt + " " + unit};NWTD1:'0' ${unit}`);
//                             // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTAL1:${receiveWt + " " + unit}`);
//                         }

//                     }

//                     if (FriabilityDetail1.data.Rotary == "Double") {
//                         tempCounterObjAfter.counter += 1;
//                     }



//                     if (tempCounterObjAfter.counter == 2) {
//                         //update WTAR2
//                         var result = await this.checkProductData(__paramProductData);

//                         let resSelectFri = await models.tbl_tab_friability.findAll({
//                             where: {
//                                 RepSerNo: result[0].RepSerNo
//                             }
//                         })
//                         resSelectFri = resSelectFri[0];

//                         let nwtAfterTest;
//                         let nwtBeforeTest;
//                         nwtBeforeTest = (((resSelectFri.RWtBeforeTest - receiveWt) * 100) / resSelectFri.RWtBeforeTest).toFixed(5);
//                         nwtAfterTest = (((resSelectFri.LWtAfterTest - receiveWt) * 100) / resSelectFri.LWtAfterTest).toFixed(5);
//                         // if (result) {
//                         const updateData = await models.tbl_tab_friability.update({
//                             RWtAfterTest: receiveWt
//                         }, {
//                             where: {
//                                 RepSerNo: result[0].RepSerNo,
//                                 BFGCode: __parameterFriability.objProductDetails.ProductId,
//                                 ProductName: __parameterFriability.objProductDetails.ProductName,
//                                 PVersion: __parameterFriability.objProductDetails.ProductVersion,
//                                 Version: __parameterFriability.objProductDetails.Version,
//                                 BatchNo: __parameterFriability.Batch,
//                             }
//                         })

//                         //power backup
//                         const updateDataPower = await models.tbl_powerbackup.update({
//                             After_Count: tempCounterObjAfter.counter
//                         }, {
//                             where: {
//                                 CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
//                                 WeighmentType: 8,
//                                 Incomp_RepSerNo: result[0].RepSerNo,
//                             }
//                         })
//                         //batch summary 
//                         var batchSummaryObjectD = {
//                             BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
//                             ProductName: hmiDetailsInPMenu.Sys_ProductName,
//                             PVersion: hmiDetailsInPMenu.Sys_PVersion,
//                             Version: hmiDetailsInPMenu.Sys_Version,
//                             PrdType: 1,
//                             CubType: hmiDetailsInPMenu.Sys_CubType,
//                             BatchNo: hmiDetailsInPMenu.Sys_Batch,
//                             Unit: hmiDetailsInPMenu.Sys_BatchSizeUnit,
//                             Side: hmiDetailsInPMenu.Sys_RotaryType,
//                             InstrumentID: hmiDetailsInPMenu.Sys_BalID,
//                             Area: hmiDetailsInPMenu.Sys_Area,
//                             UserId: tempUserObject.UserId,
//                             UserName: tempUserObject.UserName,
//                             // nwtBeforeTest: resSelectFri.NWtBeforeTest,
//                             // nwtAfterTest: resSelectFri.NWtAfterTest,
//                             // lwtBeforeTest: resSelectFri.LWtBeforeTest,
//                             // lwtAfterTest: resSelectFri.LWtAfterTest,
//                             // rwtBeforeTest: resSelectFri.RWtBeforeTest,
//                             // rwtAfterTest: resSelectFri.RWtAfterTest,
//                             Dept: hmiDetailsInPMenu.Sys_dept,
//                             Nom: productDetail.productDetail[0][0].Param8_Nom,
//                             PrTime: moment().format('HH:mm:ss'),
//                             PrDate: moment().format('YYYY-MM-DD')
//                         }

//                         await objBatchSummary.saveBatchSummaryFriability(batchSummaryObjectD, strHmi);

//                         await models.tbl_powerbackup.destroy({
//                             where: {
//                                 CubicalNo: powerbacc.CubicalNo
//                             }
//                         })

//                         mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBL2:${resSelectFri.InitialWt} ${unit};WTAR2:${receiveWt + " " + unit};NWTD1:${nwtBeforeTest} ${unit} ;NWTD2:${nwtAfterTest} ${unit}`);
//                         //mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTAR2:${receiveWt + " " + unit}`);

//                         let __activityObj = {
//                             strUserId: tempUserObject.UserId,
//                             strUserName: tempUserObject.UserName,
//                             activity: `${objSelMenu.menuName} Weighment Completed on TSH ${strHmi}`,
//                         };

//                         await objActivityLog.ActivityLogEntry(__activityObj);
//                         await objInstrumentUsage.InstrumentUsage("Balance", strIdsNo, "tbl_instrumentlog_balance", '', 'completed');
//                         globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi) == -1 ?
//                             globalData.arrWeighmentProductData :
//                             globalData.arrWeighmentProductData.splice(globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi), 1);

//                         globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi) == -1 ?
//                             globalData.arrProductTypeArray :
//                             globalData.arrProductTypeArray.splice(globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi), 1);

//                         globalData.arrWeighmentCounter.findIndex(k => k.Hmi == strHmi) == -1 ?
//                             globalData.arrWeighmentCounter :
//                             globalData.arrWeighmentCounter.splice(globalData.arrWeighmentCounter.findIndex(k => k.Hmi == strHmi), 1);

//                         (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus :
//                             globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);
//                         //test splice if rotarty is not double
//                         globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
//                             globalData.arrSelectedMenu :
//                             globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);

//                         mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}Friability test completed`);
//                         // }

//                     }

//                     if (tempCounterObjAfter.counter == 0 || FriabilityDetail1.data.Rotary == "Single") {
//                         //batch summary 


//                         await models.tbl_powerbackup.destroy({
//                             where: {
//                                 'CubicalNo': powerbacc.CubicalNo
//                             }
//                         })


//                         var objActivity = {};
//                         Object.assign(objActivity,
//                             { strUserId: tempUserObject.UserId },
//                             { strUserName: tempUserObject.UserName },
//                             { activity: `Friability Weighment Completed on TSH ${strHmi}` });

//                         await objActivityLog.ActivityLogEntry(objActivity);
//                         await objInstrumentUsage.InstrumentUsage('Balance', strIdsNo, 'tbl_instrumentlog_friability', '', 'completed');

//                         globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi) == -1 ?
//                             globalData.arrWeighmentProductData :
//                             globalData.arrWeighmentProductData.splice(globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi), 1);

//                         globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi) == -1 ?
//                             globalData.arrProductTypeArray :
//                             globalData.arrProductTypeArray.splice(globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi), 1);

//                         globalData.arrWeighmentCounter.findIndex(k => k.Hmi == strHmi) == -1 ?
//                             globalData.arrWeighmentCounter :
//                             globalData.arrWeighmentCounter.splice(globalData.arrWeighmentCounter.findIndex(k => k.Hmi == strHmi), 1);

//                         (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus :
//                             globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);
//                         //test splice if rotarty is not double
//                         globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
//                             globalData.arrSelectedMenu :
//                             globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);

//                         mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}Friability test completed`);
//                     }


//                 } else {

//                     mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Friability is blocked for 4 min`);
//                 }


//             }

//             //disable the menu after  send before wt 
//         } catch (error) {
//             throw new Error(error);
//         }

//     }


//     async saveToBalanceCompleteData(data, friDetail) {
//         try {
//             let strHmi = data.strHmi;
//             let strIdsNo = data.uniqueSerialNumber;
//             let CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
//             var actualProtocol = data.receiveWt;
//             let selectedIdsNo;
//             var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strIdsNo);
//             if (IPQCObject != undefined) {
//                 selectedIdsNo = IPQCObject.selectedIds;
//             } else {
//                 selectedIdsNo = strIdsNo;
//             }

//             let IPQC = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
//             let setDataAccToColunSingle = 0;
//             let setDataAccToColunDouble = 0;
//             if (IPQC.Sys_RptType == 'Double') {
//                 setDataAccToColunDouble = data.receiveWt;
//             } else {
//                 setDataAccToColunSingle = data.receiveWt;
//             }
//             let hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData; //idsNo
//             var objFriBal = globalData.FrabilityOnBal.find(k => k.Hmi == strHmi);
//             let tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
//             let productObj = data.objProductDetails;
//             let productParams = data.productType;
//             let now = new Date();
//             if (CurrentCubicalObj.Sys_RotaryType == "Double") {
//                 if (objFriBal == undefined) {
//                     globalData.FrabilityOnBal.push({ Hmi: strHmi, dataValue1: actualProtocol, dataValue2: 0 });
//                     objFriBal = globalData.FrabilityOnBal.find(k => k.Hmi == strHmi);
//                 } else {
//                     objFriBal.dataValue2 = actualProtocol;
//                 }
//             } else {
//                 if (objFriBal == undefined) {
//                     globalData.FrabilityOnBal.push({ Hmi: strHmi, dataValue1: actualProtocol, dataValue2: 0 })
//                     objFriBal = globalData.FrabilityOnBal.find(k => k.Hmi == strHmi);
//                 } else {
//                     objFriBal.dataValue1 = actualProtocol;
//                 }
//             }
//             let __paramProductData = {
//                 ProductId: productObj.ProductId,
//                 ProductName: productObj.ProductName,
//                 ProductVersion: productObj.ProductVersion,
//                 Version: productObj.Version,
//                 Batch: data.Batch,
//                 // uniqueSerialNumber: data.uniqueSerialNumber
//                 uniqueSerialNumber: strHmi
//             }
//             var menuDetailsArr = globalData.arr_limits.find(k => k.Hmi == strHmi);
//             let tempLimits = menuDetailsArr.Menus.filter(obj => Object.keys(obj) == 'FRIAB')[0]['FRIAB'];
//             // var result = await this.checkProductData(__paramProductData); 
//             // var intMstSerNo;
//             // if (result.length <= 0) {
//             //     intMstSerNo = 1;
//             // } else {
//             //     var newMstSerNo = result[0].SeqNo + 1;
//             //     intMstSerNo = newMstSerNo;
//             // }
//             //New code added 27/01/23 S
//             let retuRes = await this.checkFriabilityStatus(strHmi);
//             var rwtAfterTest, rwtBeforeTest, nwtAfterTest, nwtBeforeTest, lwtAfterTest, lwtBeforeTest, decimalPoint;
//             // var decimalPoint ;

//             if (retuRes.status == 'before') {
//                 if (CurrentCubicalObj.Sys_RotaryType == 'Double') {
//                     // tempCounterObj.counter
//                     // tempCounterObj.counter += 1; //counter only for Double rotary
//                     lwtBeforeTest = objFriBal.dataValue1;
//                     rwtBeforeTest = objFriBal.dataValue2;
//                     nwtBeforeTest = 0;
//                     decimalPoint = await this.precision(Number(actualProtocol))
//                 } else {
//                     lwtBeforeTest = 0;
//                     rwtBeforeTest = 0;
//                     nwtBeforeTest = actualProtocol;
//                     decimalPoint = await this.precision(Number(actualProtocol))
//                 }
//             }
//             var result1 = await proObj.productData(__paramProductData);//check product data from product master 
//             const checkData = await models.tbl_tab_friability.findAll({
//                 attributes: [[sequelize.fn('max', sequelize.col('MstSerNo')), 'MstSerNo']],
//                 where: {
//                     BFGCode: CurrentCubicalObj.Sys_BFGCode,
//                     ProductName: CurrentCubicalObj.Sys_ProductName,
//                     PVersion: CurrentCubicalObj.Sys_PVersion,
//                     Version: CurrentCubicalObj.Sys_Version,
//                     BatchNo: CurrentCubicalObj.Sys_Batch,
//                     IdsNo: strHmi,
//                     CubicleType: CurrentCubicalObj.Sys_CubType,
//                     RepoLabel10: CurrentCubicalObj.Sys_IPQCType,
//                 }
//             })

//             var result = checkData;
//             var intMstSerNo;
//             if (retuRes.status == 'before') {
//                 if (result[0].MstSerNo == null) {
//                     intMstSerNo = 1;
//                 } else {
//                     intMstSerNo = result[0].MstSerNo;
//                 }
//             } else {
//                 if (result[0].MstSerNo == null) {
//                     intMstSerNo = 1;
//                 } else {
//                     var newMstSerNo = result[0].MstSerNo + 1;
//                     intMstSerNo = newMstSerNo;
//                 }
//             }

//             //Stored data in friability table
//             var saveFriData = await models.tbl_tab_friability.create({

//                 MstSerNo: intMstSerNo,
//                 InstruId: 0,
//                 BFGCode: CurrentCubicalObj.Sys_BFGCode,
//                 ProductName: CurrentCubicalObj.Sys_ProductName,
//                 ProductType: productObj.ProductType,
//                 IdsNo: strHmi,
//                 CubicalNo: CurrentCubicalObj.Sys_CubicNo,
//                 CubicleName: CurrentCubicalObj.Sys_CubicName,
//                 CubicleLocation: CurrentCubicalObj.Sys_dept,
//                 BatchNo: CurrentCubicalObj.Sys_Batch,
//                 //NoOfSample: productObj.Sys_Batch },
//                 UserId: tempUserObject.UserId,
//                 UserName: tempUserObject.UserName,
//                 PrDate: moment().format('YYYY-MM-DD'),
//                 PrTime: moment().format('HH:mm:ss'),
//                 Side: CurrentCubicalObj.Sys_RotaryType,
//                 Unit: 'g',
//                 DecimalPoint: decimalPoint,
//                 WgmtModeNo: 8,
//                 FriNMTLimit: parseFloat(result1[1].Param8_Nom),
//                 SetCount: parseFloat(result1[1].Param8_T1Neg),
//                 SetRPM: parseFloat(result1[1].Param8_T1Pos),
//                 FriabilityQty: tempLimits.noOfSamples,
//                 CubicleType: CurrentCubicalObj.Sys_CubType,
//                 RepoLabel10: CurrentCubicalObj.Sys_IPQCType,
//                 ReportType: CurrentCubicalObj.Sys_RptType,
//                 MachineCode: CurrentCubicalObj.Sys_MachineCode,
//                 MFGCode: CurrentCubicalObj.Sys_MfgCode,
//                 BatchSize: `${CurrentCubicalObj.Sys_BatchSize} ${CurrentCubicalObj.Sys_BatchSizeUnit}`,
//                 FriabilityID: CurrentCubicalObj.Sys_FriabID,
//                 NWtBeforeTest: nwtBeforeTest,
//                 // NWtAfterTest: nwtAfterTest },
//                 LWtBeforeTest: lwtBeforeTest,
//                 // LWtAfterTest: lwtAfterTest },
//                 //RHSSrNo: productObj.CubicleType },
//                 RWtBeforeTest: rwtBeforeTest,
//                 // RWtAfterTest: rwtAfterTest },
//                 PrintNo: 0,
//                 IsArchived: 0,
//                 //BatchComplete: date.format(now, 'HH:mm:ss') },
//                 //GraphType: productObj.HardnessID },
//                 BalanceId: CurrentCubicalObj.Sys_BalID,
//                 PVersion: CurrentCubicalObj.Sys_PVersion,
//                 Version: CurrentCubicalObj.Sys_Version,
//                 //CheckedByID: productObj.RepoLabel11 },
//                 //CheckedByName: productObj.Sys_BalID },
//                 //CheckedByDate: productObj.RepoLabel13 },
//                 //Stage: productObj.PrintNo },
//                 //objLotData.LotNo
//                 BRepSerNo: 0,
//                 RepoLabel11: CurrentCubicalObj.Sys_Validation,
//                 Lot: 'NA',
//                 // ActualCount: parseFloat(res[1].Param8_T1Neg) },
//                 // ActualRPM: parseFloat(res[1].Param8_T1Pos) },
//                 Area: CurrentCubicalObj.Sys_Area,
//                 AppearanceDesc: CurrentCubicalObj.Sys_Appearance,
//                 MachineSpeed_Min: CurrentCubicalObj.Sys_MachineSpeed_Min,
//                 MachineSpeed_Max: CurrentCubicalObj.Sys_MachineSpeed_Max,
//                 GenericName: CurrentCubicalObj.Sys_GenericName,
//                 BMRNo: CurrentCubicalObj.Sys_BMRNo,



//             })
//             //27/01/23 End
//             var lastInsertedID = saveFriData.dataValues.RepSerNo;
//             return lastInsertedID;
//         } catch (error) {
//             throw new Error(error);
//         }

//     }

//     async checkProductData(productObj) {
//         try {
//             const checkData = await models.tbl_tab_friability.findAll({
//                 attributes: [[sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"]],
//                 where: {
//                     BFGCode: productObj.ProductId,
//                     ProductName: productObj.ProductName,
//                     PVersion: productObj.ProductVersion,
//                     Version: productObj.Version,
//                     BatchNo: productObj.Batch,
//                     IdsNo: productObj.uniqueSerialNumber
//                 }
//             })

//             var result = checkData;
//             return result;
//         } catch (error) {
//             throw new Error(error);
//         }
//     }

//     AddMinutesToDate(date, minutes) {
//         return new Date(date.getTime() + minutes * 60000);
//     }

//     DateFormat(date) {
//         var days = date.getDate();
//         var year = date.getFullYear();
//         var month = (date.getMonth() + 1);
//         var hours = date.getHours();
//         var minutes = date.getMinutes();
//         minutes = minutes < 10 ? '0' + minutes : minutes;
//         var strTime = month + '/' + days + '/' + year + ' ' + hours + ':' + minutes;
//         //var strTime = hours + ':' + minutes;
//         return strTime;
//     }

//     /**
//      * process BFBO 
//      */
//     async processBFBO(dataObj) {
//         let strHmi = dataObj.Hmi;
//         let strIdsNo = dataObj.idsNo;
//         let receiveWt = dataObj.actualWt;
//         let unit = dataObj.unit;
//         await this.insertFriabilityOnBal(strHmi, strIdsNo, receiveWt);
//     }

//     async insertFriabilityOnBal(strHmi, IdsNo, protocol) {
//         try {
//             let now = new Date();
//             var actualProtocol = protocol;
//             let selectedIds;
//             var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
//             //var objLotData = globalData.arrLot.find(k => k.idsNo == IdsNo);
//             var CurrentCubic = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
//             if (IPQCObject != undefined) {
//                 selectedIds = IPQCObject.selectedIds;
//             } else {
//                 selectedIds = IdsNo;
//             }
//             var tempCubic = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
//             var objFriBal = globalData.FrabilityOnBal.find(k => k.Hmi == strHmi);

//             let tempCounterObj = globalData.arrWeighmentCounter.find(k => k.Hmi == strHmi);
//             if (tempCounterObj === undefined) {
//                 globalData.arrWeighmentCounter.push({ 'Hmi': strHmi, 'counter': 0 })
//             }
//             tempCounterObj = globalData.arrWeighmentCounter.find(k => k.Hmi == strHmi);

//             if (tempCubic.Sys_RotaryType == "Double") {

//                 if (objFriBal == undefined) {
//                     globalData.FrabilityOnBal.push({ Hmi: strHmi, dataValue1: actualProtocol, dataValue2: 0 })

//                 } else {
//                     objFriBal.dataValue2 = actualProtocol;
//                 }
//             } else {
//                 if (objFriBal == undefined) {
//                     globalData.FrabilityOnBal.push({ Hmi: strHmi, dataValue1: actualProtocol, dataValue2: 0 })

//                 } else {
//                     objFriBal.dataValue1 = actualProtocol;
//                 }
//             }
//             objFriBal = globalData.FrabilityOnBal.find(k => k.Hmi == strHmi);
//             var menuDetailsArr = globalData.arr_limits.find(k => k.Hmi == strHmi);
//             let tempLimits = menuDetailsArr.Menus.filter(obj => Object.keys(obj) == 'FRIAB')[0]['FRIAB'];
//             // var objInvalid = globalData.arrBulkInvalid.find(k => k.idsNo == IdsNo);
//             var productObj = globalData.arrProductTypeArray.find(k => k.Hmi == strHmi);
//             var rwtAfterTest, rwtBeforeTest, nwtAfterTest, nwtBeforeTest, lwtAfterTest, lwtBeforeTest, decimalPoint;
//             var ActualRPM = "";
//             var ActualCount = ""
//             var intervalFound;

//             const tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
//             let retuRes = await this.checkFriabilityStatus(strHmi);

//             if (retuRes.status == 'before') {
//                 if (tempCubic.Sys_RotaryType == 'Double') {
//                     tempCounterObj.counter += 1; //counter only for Double rotary
//                     lwtBeforeTest = objFriBal.dataValue1;
//                     rwtBeforeTest = objFriBal.dataValue2;
//                     nwtBeforeTest = 0;
//                     decimalPoint = await this.precision(Number(objFriBal.dataValue1))
//                 } else {
//                     lwtBeforeTest = 0;
//                     rwtBeforeTest = 0;
//                     nwtBeforeTest = objFriBal.dataValue1;
//                     decimalPoint = await this.precision(Number(objFriBal.dataValue1))
//                 }
//                 var res = await proObj.productData(tempCubic);
//                 const checkData = await models.tbl_tab_friability.findAll({
//                     attributes: [[sequelize.fn('max', sequelize.col('MstSerNo')), 'MstSerNo']],
//                     where: {
//                         BFGCode: tempCubic.Sys_BFGCode,
//                         ProductName: tempCubic.Sys_ProductName,
//                         PVersion: tempCubic.Sys_PVersion,
//                         Version: tempCubic.Sys_Version,
//                         BatchNo: tempCubic.Sys_Batch,
//                         IdsNo: strHmi,
//                         CubicleType: tempCubic.Sys_CubType,
//                         RepoLabel10: tempCubic.Sys_IPQCType,
//                     }
//                 })

//                 var result = checkData;
//                 var intMstSerNo;
//                 if (retuRes.status == 'before') {
//                     if (result[0].MstSerNo == null) {
//                         intMstSerNo = 1;
//                     } else {
//                         intMstSerNo = result[0].MstSerNo;
//                     }
//                 } else {
//                     if (result[0].MstSerNo == null) {
//                         intMstSerNo = 1;
//                     } else {
//                         var newMstSerNo = result[0].MstSerNo + 1;
//                         intMstSerNo = newMstSerNo;
//                     }
//                 }


//                 if (tempCounterObj.counter == 1 || tempCubic.Sys_RotaryType == 'Single') {
//                     var saveFriData = await models.tbl_tab_friability.create({

//                         MstSerNo: intMstSerNo,
//                         InstruId: 0,
//                         BFGCode: tempCubic.Sys_BFGCode,
//                         ProductName: tempCubic.Sys_ProductName,
//                         ProductType: productObj.productType.ProductType,
//                         IdsNo: strHmi,
//                         CubicalNo: tempCubic.Sys_CubicNo,
//                         CubicleName: tempCubic.Sys_CubicName,
//                         CubicleLocation: tempCubic.Sys_dept,
//                         BatchNo: tempCubic.Sys_Batch,
//                         //NoOfSample: productObj.Sys_Batch },
//                         UserId: tempUserObject.UserId,
//                         UserName: tempUserObject.UserName,
//                         PrDate: moment().format('YYYY-MM-DD'),
//                         PrTime: moment().format('HH:mm:ss'),
//                         Side: tempCubic.Sys_RotaryType,
//                         Unit: 'g',
//                         DecimalPoint: decimalPoint,
//                         WgmtModeNo: 8,
//                         FriNMTLimit: parseFloat(res[1].Param8_Nom),
//                         SetCount: parseFloat(res[1].Param8_T1Neg),
//                         SetRPM: parseFloat(res[1].Param8_T1Pos),
//                         FriabilityQty: tempLimits.noOfSamples,
//                         CubicleType: tempCubic.Sys_CubType,
//                         RepoLabel10: tempCubic.Sys_IPQCType,
//                         ReportType: tempCubic.Sys_RptType,
//                         MachineCode: tempCubic.Sys_MachineCode,
//                         MFGCode: tempCubic.Sys_MfgCode,
//                         BatchSize: `${tempCubic.Sys_BatchSize} ${tempCubic.Sys_BatchSizeUnit}`,
//                         FriabilityID: CurrentCubic.Sys_FriabID,
//                         NWtBeforeTest: nwtBeforeTest,
//                         // NWtAfterTest: nwtAfterTest },
//                         LWtBeforeTest: lwtBeforeTest,
//                         // LWtAfterTest: lwtAfterTest },
//                         //RHSSrNo: productObj.CubicleType },
//                         RWtBeforeTest: rwtBeforeTest,
//                         // RWtAfterTest: rwtAfterTest },
//                         PrintNo: 0,
//                         IsArchived: 0,
//                         //BatchComplete: date.format(now, 'HH:mm:ss') },
//                         //GraphType: productObj.HardnessID },
//                         BalanceId: CurrentCubic.Sys_BalID,
//                         PVersion: tempCubic.Sys_PVersion,
//                         Version: tempCubic.Sys_Version,
//                         //CheckedByID: productObj.RepoLabel11 },
//                         //CheckedByName: productObj.Sys_BalID },
//                         //CheckedByDate: productObj.RepoLabel13 },
//                         //Stage: productObj.PrintNo },
//                         //objLotData.LotNo
//                         BRepSerNo: 0,
//                         RepoLabel11: tempCubic.Sys_Validation,
//                         Lot: 'NA',
//                         // ActualCount: parseFloat(res[1].Param8_T1Neg) },
//                         // ActualRPM: parseFloat(res[1].Param8_T1Pos) },
//                         Area: tempCubic.Sys_Area,
//                         AppearanceDesc: tempCubic.Sys_Appearance,
//                         MachineSpeed_Min: tempCubic.Sys_MachineSpeed_Min,
//                         MachineSpeed_Max: tempCubic.Sys_MachineSpeed_Max,
//                         GenericName: tempCubic.Sys_GenericName,
//                         BMRNo: tempCubic.Sys_BMRNo,



//                     })

//                 } else {
//                     let updateFriability = await models.tbl_tab_friability.update({
//                         RWtBeforeTest: rwtBeforeTest,
//                         PrEndDate: moment().format('YYYY-MM-DD'),
//                         PrEndTime: moment().format('HH:mm:ss')
//                     },
//                         { where: { RepSerNo: retuRes.sqNo } })

//                 }

//                 //objMonitor.monit({ case: 'FRIFINWT', idsNo: IdsNo, data: { test: 'FRIABILITY' } });
//                 // As soon as Before weight is taken the we have to hide menu for specific time
//                 var objActivity = {};
//                 Object.assign(objActivity,
//                     { strUserId: tempUserObject.UserId },
//                     { strUserName: tempUserObject.UserName },
//                     { activity: 'Friability Weighment Started on TSH' + strHmi });
//                 await objActivityLog.ActivityLogEntry(objActivity)
//                 // Instrument usage for Friability completed
//                 if (serverConfig.friabilityType == 'BFBO' || serverConfig.friabilityType == 'BFBT') {
//                     var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
//                     if (IPQCObject != undefined) {
//                         selectedIds = IPQCObject.selectedIds;
//                     } else {
//                         selectedIds = IdsNo;
//                     }
//                     var tempBFBO = globalData.arrBFBO.find(k => k.idsNo == selectedIds);
//                     tempBFBO.before = true;
//                 }
//                 await objInstrumentUsage.InstrumentUsage('Balance', IdsNo, 'tbl_instrumentlog_balance', 'Friability Weighment', 'started')
//                 await this.updateFriabilityTime(IdsNo, tempLimits);
//                 if (tempCubic.Sys_RotaryType == 'Double') {
//                     mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBD1:${lwtBeforeTest} g`);
//                     mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBD2:${rwtBeforeTest} g`)

//                 } else {
//                     mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBD1:${nwtBeforeTest} g`);
//                 }

//                 return true;

//             } else {
//                 //FrabilityOnBal
//                 if (tempCounterObj.counter == 2 && tempCubic.Sys_RotaryType == "Double") {
//                     globalData.FrabilityOnBal.findIndex(k => k.idsNo == selectedIds) == -1 ?
//                         globalData.FrabilityOnBal :
//                         globalData.FrabilityOnBal.splice(globalData.FrabilityOnBal.findIndex(k => k.idsNo == selectedIds), 1);
//                 }


//                 var objFriBal = globalData.FrabilityOnBal.find(k => k.idsNo == IdsNo);
//                 if (tempCubic.Sys_RotaryType == "Double") {

//                     if (objFriBal == undefined) {
//                         globalData.FrabilityOnBal.push({ idsNo: selectedIds, dataValue1: actualProtocol, dataValue2: 0 })

//                     } else {
//                         objFriBal.dataValue2 = actualProtocol;
//                     }
//                 }
//                 objFriBal = globalData.FrabilityOnBal.find(k => k.idsNo == IdsNo);
//                 if (tempCubic.Sys_RotaryType == 'Double') {
//                     tempCounterObj.counter += 1; //counter only for Double rotary
//                     lwtAfterTest = objFriBal.dataValue1;
//                     rwtAfterTest = objFriBal.dataValue2;
//                     nwtAfterTest = 0;

//                 } else {
//                     lwtAfterTest = 0;
//                     rwtAfterTest = 0;
//                     nwtAfterTest = objFriBal.dataValue1;

//                 }


//                 if (tempCubic.Sys_RotaryType == 'Double' && tempCounterObj.counter == 3) {
//                     let updateFriability = {
//                         str_tableName: 'tbl_tab_friability',
//                         data: [
//                             { str_colName: 'LWtAfterTest', value: lwtAfterTest },
//                             { str_colName: 'PrEndDate', value: date.format(new Date(), 'YYYY-MM-DD') },
//                             { str_colName: 'PrEndTime', value: date.format(new Date(), 'HH:mm:ss') },
//                         ],
//                         condition: [
//                             { str_colName: 'RepSerNo', value: retuRes.sqNo },
//                         ]
//                     }
//                     await database.update(updateFriability);
//                 } if (tempCubic.Sys_RotaryType == 'Double' && tempCounterObj.counter == 4) {
//                     let updateFriability = {
//                         str_tableName: 'tbl_tab_friability',
//                         data: [
//                             { str_colName: 'NWtAfterTest', value: nwtAfterTest },
//                             { str_colName: 'RWtAfterTest', value: rwtAfterTest },
//                             { str_colName: 'PrEndDate', value: date.format(new Date(), 'YYYY-MM-DD') },
//                             { str_colName: 'PrEndTime', value: date.format(new Date(), 'HH:mm:ss') },
//                         ],
//                         condition: [
//                             { str_colName: 'RepSerNo', value: retuRes.sqNo },
//                         ]
//                     }
//                     await database.update(updateFriability);
//                 } else {
//                     if (tempCubic.Sys_RotaryType == 'Single') {
//                         let updateFriability = {
//                             str_tableName: 'tbl_tab_friability',
//                             data: [
//                                 { str_colName: 'NWtAfterTest', value: nwtAfterTest },
//                                 { str_colName: 'PrEndDate', value: date.format(new Date(), 'YYYY-MM-DD') },
//                                 { str_colName: 'PrEndTime', value: date.format(new Date(), 'HH:mm:ss') },
//                             ],
//                             condition: [
//                                 { str_colName: 'RepSerNo', value: retuRes.sqNo },
//                             ]
//                         }
//                         await database.update(updateFriability);
//                     }

//                 }


//                 if (tempCubic.Sys_RotaryType == 'Double' && tempCounterObj.counter == 4) {
//                     if (serverConfig.friabilityType == 'BFBO' || serverConfig.friabilityType == 'BFBT') {
//                         var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
//                         if (IPQCObject != undefined) {
//                             selectedIds = IPQCObject.selectedIds;
//                         } else {
//                             selectedIds = IdsNo;
//                         }
//                         var tempBFBO = globalData.arrBFBO.find(k => k.idsNo == selectedIds);
//                         tempBFBO.before = false;
//                         tempBFBO.setParam = false;
//                         tempBFBO.after = false;
//                     }
//                 } else {
//                     if (tempCubic.Sys_RotaryType == 'Single') {
//                         if (serverConfig.friabilityType == 'BFBO' || serverConfig.friabilityType == 'BFBT') {
//                             var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
//                             if (IPQCObject != undefined) {
//                                 selectedIds = IPQCObject.selectedIds;
//                             } else {
//                                 selectedIds = IdsNo;
//                             }
//                             var tempBFBO = globalData.arrBFBO.find(k => k.idsNo == selectedIds);
//                             tempBFBO.before = false;
//                             tempBFBO.setParam = false;
//                             tempBFBO.after = false;
//                         }
//                     }

//                 }


//                 // Selecting the value from friability
//                 var selectObj = {
//                     str_tableName: 'tbl_tab_friability',
//                     data: '*',
//                     condition: [
//                         { str_colName: 'RepSerNo', value: retuRes.sqNo },
//                     ]
//                 }
//                 let friabilityInfo = await database.select(selectObj);
//                 // if (serverConfig.ProjectName == 'MLVeer') {
//                 //     // Added for only MLVERR on 30/05/2020
//                 //     var SPresu = await objSP.PercentageCalculationForFriability(retuRes.sqNo);
//                 // }

//                 //insert batch summary and clear the array
//                 if (tempCubic.Sys_RotaryType == 'Double' && tempCounterObj.counter == 4) {
//                     let batchSummaryObject = {
//                         BFGCode: tempCubic.Sys_BFGCode,
//                         ProductName: tempCubic.Sys_ProductName,
//                         PVersion: tempCubic.Sys_PVersion,
//                         Version: tempCubic.Sys_Version,
//                         PrdType: 1,
//                         CubType: tempCubic.Sys_CubType,
//                         BatchNo: tempCubic.Sys_Batch,
//                         Unit: 'g',
//                         Side: tempCubic.Sys_RotaryType,
//                         InstrumentID: CurrentCubic.Sys_BalID,
//                         UserId: tempUserObject.UserId,
//                         UserName: tempUserObject.UserName,
//                         nwtBeforeTestF: friabilityInfo[0][0].NWtBeforeTest,
//                         nwtAfterTestF: friabilityInfo[0][0].NWtAfterTest,
//                         lwtBeforeTestF: friabilityInfo[0][0].LWtBeforeTest,
//                         lwtAfterTestF: friabilityInfo[0][0].LWtAfterTest,
//                         rwtBeforeTestF: friabilityInfo[0][0].RWtBeforeTest,
//                         rwtAfterTestF: friabilityInfo[0][0].RWtAfterTest,
//                         Dept: tempCubic.Sys_dept,
//                         Nom: friabilityInfo[0][0].FriNMTLimit,
//                         PrTime: date.format(now, 'HH:mm:ss'),
//                         PrDate: date.format(now, 'YYYY-MM-DD'),
//                         ReportType: 0,
//                         DP: friabilityInfo[0][0].DecimalPoint
//                     }
//                     await objBatchSummary.saveBatchSummaryFriability(batchSummaryObject, IdsNo);
//                     var objActivity = {};
//                     Object.assign(objActivity,
//                         { strUserId: tempUserObject.UserId },
//                         { strUserName: tempUserObject.UserName },
//                         { activity: 'Friability Weighment Completed on IDS' + IdsNo });
//                     await objActivityLog.ActivityLogEntry(objActivity);
//                     // Instrument usage for Friability completed
//                     await objInstrumentUsage.InstrumentUsage('Balance', IdsNo, 'tbl_instrumentlog_balance', '', 'completed');

//                     var response = await objSP.getRemarkForFriability(retuRes.sqNo);

//                     if (tempCubic.Sys_RotaryType == 'Double') {
//                         var netWtD1 = Math.round(friabilityInfo[0][0].LWtAfterTest - friabilityInfo[0][0].LWtBeforeTest);
//                         var netWtD2 = Math.round(friabilityInfo[0][0].RWtAfterTest - friabilityInfo[0][0].RWtBeforeTest);

//                         mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBD1:${friabilityInfo[0][0].LWtBeforeTest} g;WTAD1:${friabilityInfo[0][0].LWtAfterTest} g;NWTD1:${netWtD1} g`);
//                         mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBD2 : ${friabilityInfo[0][0].RWtBeforeTest} g;WTAD2:${friabilityInfo[0][0].RWtAfterTest} g;NWTD2:${netWtD2} g`)

//                     }



//                     mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult} ${response} `);
//                     //need to check response of remark 
//                     // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}${response}`);
//                     globalData.arrBFBO.findIndex(k => k.Hmi == strHmi) == -1 ?
//                         globalData.arrBFBO :
//                         globalData.arrBFBO.splice(globalData.arrBFBO.findIndex(k => k.Hmi == strHmi), 1);

//                     globalData.arrWeighmentCounter.findIndex(k => k.Hmi == strHmi) == -1 ?
//                         globalData.arrWeighmentCounter :
//                         globalData.arrWeighmentCounter.splice(globalData.arrWeighmentCounter.findIndex(k => k.Hmi == strHmi), 1);

//                     (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus :
//                         globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);
//                     //test splice if rotarty is not double
//                     globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
//                         globalData.arrSelectedMenu :
//                         globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);
//                     mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}Friability Test Completed`);
//                 } else {
//                     if (tempCubic.Sys_RotaryType == 'Single') {
//                         // let batchSummaryObject = {
//                         //     BFGCode: tempCubic.Sys_BFGCode,
//                         //     ProductName: tempCubic.Sys_ProductName,
//                         //     PVersion: tempCubic.Sys_PVersion,
//                         //     Version: tempCubic.Sys_Version,
//                         //     PrdType: 1,
//                         //     CubType: tempCubic.Sys_CubType,
//                         //     BatchNo: tempCubic.Sys_Batch,
//                         //     Unit: 'g',
//                         //     Side: tempCubic.Sys_RotaryType,
//                         //     InstrumentID: CurrentCubic.Sys_BalID,
//                         //     UserId: tempUserObject.UserId,
//                         //     UserName: tempUserObject.UserName,
//                         //     nwtBeforeTestF: friabilityInfo[0][0].NWtBeforeTest,
//                         //     nwtAfterTestF: friabilityInfo[0][0].NWtAfterTest,
//                         //     lwtBeforeTestF: friabilityInfo[0][0].LWtBeforeTest,
//                         //     lwtAfterTestF: friabilityInfo[0][0].LWtAfterTest,
//                         //     rwtBeforeTestF: friabilityInfo[0][0].RWtBeforeTest,
//                         //     rwtAfterTestF: friabilityInfo[0][0].RWtAfterTest,
//                         //     Dept: tempCubic.Sys_dept,
//                         //     Nom: friabilityInfo[0][0].FriNMTLimit,
//                         //     PrTime: date.format(now, 'HH:mm:ss'),
//                         //     PrDate: date.format(now, 'YYYY-MM-DD'),
//                         //     ReportType: 0,
//                         //     DP: friabilityInfo[0][0].DecimalPoint
//                         // }
//                         await objBatchSummary.saveBatchSummaryFriability(batchSummaryObject, IdsNo);
//                         var objActivity = {};
//                         Object.assign(objActivity,
//                             { strUserId: tempUserObject.UserId },
//                             { strUserName: tempUserObject.UserName },
//                             { activity: 'Friability Weighment Completed on IDS' + IdsNo });
//                         await objActivityLog.ActivityLogEntry(objActivity);
//                         // Instrument usage for Friability completed
//                         await objInstrumentUsage.InstrumentUsage('Balance', IdsNo, 'tbl_instrumentlog_balance', '', 'completed');

//                         var response = await objSP.getRemarkForFriability(retuRes.sqNo);
//                         var netWtforSingle = Math.round(friabilityInfo[0][0].NWtAfterTest - friabilityInfo[0][0].NWtBeforeTest);
//                         mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}WTBD1:${friabilityInfo[0][0].NWtBeforeTest};WTAD1:${friabilityInfo[0][0].NWtAfterTest} g;NWTD1:${netWtforSingle} g`);


//                         mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult} ${response} `);


//                         //need to check response of remark 
//                         // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}${response}`);
//                         globalData.arrBFBO.findIndex(k => k.Hmi == strHmi) == -1 ?
//                             globalData.arrBFBO :
//                             globalData.arrBFBO.splice(globalData.arrBFBO.findIndex(k => k.Hmi == strHmi), 1);

//                         globalData.arrWeighmentCounter.findIndex(k => k.Hmi == strHmi) == -1 ?
//                             globalData.arrWeighmentCounter :
//                             globalData.arrWeighmentCounter.splice(globalData.arrWeighmentCounter.findIndex(k => k.Hmi == strHmi), 1);

//                         (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus :
//                             globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);
//                         //test splice if rotarty is not double
//                         globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
//                             globalData.arrSelectedMenu :
//                             globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);
//                         mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}Friability Test Completed`);
//                     }
//                 }

//                 return;
//             }
//         } catch (error) {
//             console.log(error)
//             return error;
//         }
//     }


//     async checkFriabilityStatus(IdsNo) {
//         var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
//         var strHmi;
//         var returnResult = {};
//         if (IPQCObject != undefined) {
//             strHmi = IPQCObject.strHmi;
//         } else {
//             strHmi = IdsNo;
//         }
//         var tempCubic = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
//         const checkData = await models.tbl_tab_friability.findAll({
//             attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
//             where: {
//                 BFGCode: tempCubic.Sys_BFGCode,
//                 ProductName: tempCubic.Sys_ProductName,
//                 PVersion: tempCubic.Sys_PVersion,
//                 Version: tempCubic.Sys_Version,
//                 BatchNo: tempCubic.Sys_Batch,
//                 IdsNo: strHmi
//             }
//         })
//         var checkFlag = 0;
//         var chkResult = checkData;
//         var result = [];
//         if (chkResult[0].RepSerNo == null) {
//             checkFlag = 0;
//         } else {
//             checkFlag = 1;
//         }
//         if (checkFlag == 1) {
//             var fraibData = await models.tbl_tab_friability.findAll({
//                 where: { RepSerNo: chkResult[0].RepSerNo }
//             })

//             result = fraibData;
//             result = result[0]
//         }
//         if (result.length > 0) {
//             if (tempCubic.Sys_RotaryType == 'Double') {
//                 if (result[0].LWtBeforeTest != 0 && result[0].LWtAfterTest != 0
//                     && result[0].RWtBeforeTest != 0 && result[0].RWtAfterTest != 0) {
//                     Object.assign(returnResult, { status: 'before', sqNo: result[0].RepSerNo })

//                 } else if (result[0].LWtBeforeTest != 0 && result[0].LWtAfterTest == 0
//                     && result[0].RWtBeforeTest == 0 && result[0].RWtAfterTest == 0) {
//                     Object.assign(returnResult, { status: 'before', sqNo: result[0].RepSerNo })

//                 } else if (result[0].LWtBeforeTest != 0 && result[0].LWtAfterTest != 0
//                     && result[0].RWtBeforeTest != 0 && result[0].RWtAfterTest == 0) {
//                     Object.assign(returnResult, { status: 'after', sqNo: result[0].RepSerNo })

//                 }
//                 else if (result[0].LWtBeforeTest != 0 && result[0].LWtAfterTest == 0
//                     && result[0].RWtBeforeTest != 0 && result[0].RWtAfterTest == 0) {
//                     Object.assign(returnResult, { status: 'after', sqNo: result[0].RepSerNo })


//                 } else if (result[0].LWtBeforeTest == 0 && result[0].LWtAfterTest == 0
//                     && result[0].RWtBeforeTest == 0 && result[0].RWtAfterTest == 0) {
//                     Object.assign(returnResult, { status: 'before', sqNo: result[0].RepSerNo })

//                 }
//             } else {
//                 if (result[0].NWtBeforeTest != 0 && result[0].NWtAfterTest != 0) {
//                     Object.assign(returnResult, { status: 'before', sqNo: result[0].RepSerNo })

//                 } else if (result[0].NWtBeforeTest != 0 && result[0].NWtAfterTest == 0) {
//                     Object.assign(returnResult, { status: 'after', sqNo: result[0].RepSerNo })

//                 } else if (result[0].NWtBeforeTest == 0 && result[0].NWtAfterTest == 0) {
//                     Object.assign(returnResult, { status: 'before', sqNo: result[0].RepSerNo })

//                 }
//             }
//         } else {
//             Object.assign(returnResult, { status: 'before', sqNo: 0 })

//         }
//         return returnResult;
//     }

//     async updateFriabilityTime(IdsNo, tempLimits) {
//         try {
//             // Fetching global array for Fraibitlity
//             var selectedIds = IdsNo;;
//             // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
//             // if (IPQCObject != undefined) {
//             //     selectedIds = IPQCObject.selectedIds;
//             // } else {
//             //     selectedIds  = IdsNo;
//             // }
//             let COUNT = parseFloat(tempLimits.T1Neg);
//             let RPM = parseFloat(tempLimits.T1Pos);
//             let SECONDS = (COUNT / RPM) * 60
//             // var tempOBJ = globalData.arrFriabilityMenuVisibility.find(k => k.idsNo == selectedIds);
//             // tempOBJ.ETS = SECONDS;
//             // console.log(globalData.arrFriabilityMenuVisibility)
//         } catch (err) {
//             console.log(err);
//             return err
//         }
//     }

//     precision(a) {
//         if (!isFinite(a)) return 0;
//         var e = 1, p = 0;
//         while (Math.round(a * e) / e !== a) { e *= 10; p++; }
//         return p;
//     }

//     /**
//      * Fribilator Bulk Data
//      */
//     async insertBulkFriabilityComb(_paramObj) {
//         try {
//             // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
//             // var objInvalid = globalData.arrBulkInvalid.find(k => k.idsNo == IdsNo);
//             let strHmi = _paramObj.Hmi;
//             let strIdsNo = _paramObj.idsNo;
//             let receiveWt = _paramObj.actualWt;
//             let unit = _paramObj.unit;
//             // if (IPQCObject != undefined) {
//             //     selectedIds = IPQCObject.selectedIds;
//             // } else {
//             //     selectedIds = IdsNo;
//             // }
//             let cubicalData = globalData.arrIdsInfo.find(k => k.idsNo == strIdsNo);
//             const tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);

//             var objActivity = {};
//             Object.assign(objActivity,
//                 { strUserId: tempUserObject.UserId },
//                 { strUserName: tempUserObject.UserName },
//                 { activity: 'Friabilator Started on IDS' + strIdsNo });
//             await objActivityLog.ActivityLogEntry(objActivity);
//             // Instrument usage for Friability started
//             // objInstrumentUsage.InstrumentUsage('Friability', strIdsNo, 'tbl_instrumentlog_friability', 'Friability', 'started');

//             let retuRes = await this.checkFriabilityStatus(strIdsNo);

//             if (retuRes.status != 'before') {
//                 var updateFriability = {
//                     str_tableName: 'tbl_tab_friability',
//                     data: [
//                         { str_colName: 'ActualCount', value: _paramObj.rpm },
//                         { str_colName: 'ActualRPM', value: _paramObj.rpmCount },
//                     ],
//                     condition: [
//                         { str_colName: 'RepSerNo', value: retuRes.sqNo },
//                     ]
//                 }
//                 await database.update(updateFriability);


//                 var selectFriability = {
//                     str_tableName: 'tbl_tab_friability',
//                     data: '*',
//                     condition: [
//                         { str_colName: 'RepSerNo', value: retuRes.sqNo },
//                     ]
//                 }
//                 let getBeforeWt = await database.select(selectFriability);

//                 /**
//                  * getting before weight for double and single
//                  */

//                 if (cubicalData.Sys_RotaryType == "Double") {

//                     let lftBefore = getBeforeWt[0][0].LWtBeforeTest;
//                     let rwtBefore = getBeforeWt[0][0].RWtBeforeTest;
//                 } else {
//                     let newWt = getBeforeWt[0][0].NWtBeforeTest;
//                 }


//                 var objActivity = {};
//                 Object.assign(objActivity,
//                     { strUserId: tempUserObject.UserId },
//                     { strUserName: tempUserObject.UserName },
//                     { activity: 'Friabilator String completed on IDS' + strIdsNo });
//                 await objActivityLog.ActivityLogEntry(objActivity);
//                 objInstrumentUsage.InstrumentUsage('Friability', strIdsNo, 'tbl_instrumentlog_friability', '', 'completed');

//                 if (serverConfig.friabilityType == 'BFBO' || serverConfig.friabilityType == 'BFBT') {
//                     var tempBFBO = globalData.arrBFBO.find(k => k.idsNo == strIdsNo);
//                     tempBFBO.setParam = true;
//                 }


//                 if (cubicalData.Sys_RotaryType == "Double") {

//                     let lftBefore = getBeforeWt[0][0].LWtBeforeTest;
//                     let rwtBefore = getBeforeWt[0][0].RWtBeforeTest;
//                     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}Set_RPM:${_paramObj.rpm};Set_Count:${_paramObj.rpmCount}`);
//                 } else {
//                     let newWt = getBeforeWt[0][0].NWtBeforeTest;
//                     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}Set_RPM:${_paramObj.rpm};Set_Count:${_paramObj.rpmCount}`);
//                 }


//             } else {
//                 if (cubicalData.Sys_RotaryType == "Double") {

//                     let lftBefore = getBeforeWt[0][0].LWtBeforeTest;
//                     let rwtBefore = getBeforeWt[0][0].RWtBeforeTest;
//                     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}Set_RPM:${_paramObj.rpm};Set_Count:${_paramObj.rpmCount}`);
//                 } else {
//                     let newWt = getBeforeWt[0][0].NWtBeforeTest;
//                     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}Set_RPM:${_paramObj.rpm};Set_Count:${_paramObj.rpmCount}`);
//                 }
//             }

//         } catch (err) {
//             throw new Error(err);
//         }
//     }


// }

module.exports = FriabilityModel;