const date = require("date-and-time");
const moment = require("moment");
const globalData = require("../../global/globalData");
const clsActivityLog = require("../clsActivityLog.model");
const clsInstrumentUsage = require("../clsInstrumentUsageLog");
const clsCommonInsertOpt = require("../Product/clsCommonInsertOperation.model");
const clsMqttSender = require("../Mqtt/mqttSender.class");
const DataBase = require("../../database/clsQueryProcess");
const DbUtill = require("../../Utills/db");
const FormulaFunModel = require("../Product/clsformulaFun.model");
const mqttProtocol = require("../../global/GLOBAL_NOMENCLATURE");
const clsProObj = require("../Product/clsProductDetailModel");
const clsGetMstSrAndSideSr = require("../Product/clsGetMstSrAndSideSr");
const clsIncompleteReport = require("../Product/clsIncompleteReport");
const PowerBackup = require("../../Utills/powerBackUp/powerbackup");
const models = require("../../../config/dbConnection").models;
const clsMonit = require("../MonitorSocket/clsMonitSocket");
const sequelize = require("../../../config/dbConnection").sequelize;
const { QueryTypes } = require("sequelize");
const { Op } = require("sequelize");
const callBrepsrno = require("../Product/clsCommonInsertOperation.model");
const clsCommonUseFunction = require("../clsCommonUseFunction");
// const clsPrintOperation = require('../Print/clsPrintOperation');
// const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const MqttModel = require("../Mqtt/mqttSender.class");
const GLOBAL_NOMENCLATURE = require("../../global/GLOBAL_NOMENCLATURE");
const Batch = require("../Product/clsBatchSummaryOperation");
const clsFormula = require("../../model/Product/clsformulaFun.model");
const objFormula = new clsFormula();
const round_off = new Batch();
const maths = require('mathjs');
// const objcallPrint = new clsPrintOperation()
// const mqttSender = new MqttModel();
const callbeprso = new callBrepsrno();
const objPowerBackup = new PowerBackup();
const objCommonUseFunc = new clsCommonUseFunction();

const objActivityLog = new clsActivityLog();
const objInstrumentUsage = new clsInstrumentUsage();
const objCommonInsertOpt = new clsCommonInsertOpt();
const mqttSender = new clsMqttSender();
const database = new DataBase();
const objformulaFun = new FormulaFunModel();
const proObj = new clsProObj();
const objGetMstSrAndSideSr = new clsGetMstSrAndSideSr();
const objIncompleteReport = new clsIncompleteReport();
const objMonit = new clsMonit();

class Differential {
  async processDifferentialData(__parameterDifferential) {
    try {
      let objActivity = {};
      let maxLimitEmpty,
        minLimitEmpty,
        maxLimitFill,
        minLimitFill,
        strTableName,
        strDetailTbl;
      var strHmi = __parameterDifferential.Hmi;
      const strIdsNo = __parameterDifferential.idsNo;
      const menuName = __parameterDifferential.menuName;
      let mqunit = __parameterDifferential.mqtt;
      const objSelMenuDiff = globalData.arrSelectedMenu.find(
        (k) => k.Hmi == strHmi
      ).selectedProductDetail;
      const DifferentialData = globalData.arrWeighmentProductData.find(
        (k) => k.Hmi == strHmi
      );
      let sample = parseFloat(DifferentialData.data.noOfSample);
      let batchNo = DifferentialData.data.Batch;
      let decimalPoint = __parameterDifferential.decPoint;
      let actualUnit = (__parameterDifferential.unit).toLowerCase();
      var DP = await models.tbl_balance.findAll({
        attributes: ['Bal_DP'],
        where: {
          Bal_ID: __parameterDifferential.instrumentId
        }
      })
      DP = actualUnit != 'mg' ? DP[0].Bal_DP : 1
      let actualWt = Number(__parameterDifferential.actualWt).toFixed(DP)
      let tempCounterObj = globalData.arrWeighmentCounter.find(
        (k) => k.Hmi == strHmi
      );
      let tempUserObject = globalData.arrUsers.find((k) => k.Hmi === strHmi);
      let message;
      let menuDetail = globalData.arr_limits.find((k) => k.Hmi == strHmi);
      // let Side = globalData.DoubSide.find(k => k.Hmi == strHmi)
      let productObj = globalData.arrIdsInfo.find(
        (k) => k.Hmi == strHmi
      ).cubicalData;
      // let individualDetail = menuDetail.Menus.filter((obj) => Object.keys(obj) == 'INDIVI')[0]['INDIVI'];
      const sampleRemark = globalData.arrSampleRemarkForAllTest.find(
        (k) => k.Hmi == strHmi
      );
      let typeValue = "D";
      let mstTableName = "tbl_cap_master3_incomplete";
      let compTableName = "tbl_cap_master3";
      let detailTableName = "tbl_cap_detail3_incomplete";
      let sideNo, mstSerNo;
      // let actualUnit = __parameterDifferential.unit;
      // actualWt = await round_off.calculate_roundoff_value(actualWt, actualUnit);
      let typeVal = 3;
      let now = new Date();
      let side;
      let readingIgnore;
      let _cubicalData = globalData.arrIdsInfo.find(
        (k) => k.Hmi == strHmi
      ).cubicalData;
      let ProtocolPortNo = __parameterDifferential.ProtocolPortNo;
      let objSelMenu = globalData.arrSelectedMenu.find((k) => k.Hmi == strHmi);
      let balunit = objSelMenu.selectedProductDetail.unit;
      let SideArray = globalData.DoubSide.find((k) => k.Hmi == strHmi);
      if (SideArray != undefined) {
        var Side = globalData.DoubSide.find((k) => k.Hmi == strHmi).Side;
      }
      // maxLimitT1Fill = menuDetail
      // minLimitT1Fill =
      // maxLimitFill = objformulaFun.upperLimit(individualDetail);
      // minLimitFill = objformulaFun.lowerLimit(individualDetail);
      maxLimitEmpty = objformulaFun.upperLimit(objSelMenuDiff);
      minLimitEmpty = objformulaFun.lowerLimit(objSelMenuDiff);
      console.log(__parameterDifferential);

      if (_cubicalData.Sys_RotaryType == "Single") {
        side = "NA";
      } else {
        if (_cubicalData.Sys_RotaryType == "Double") {
          if (DifferentialData.data.Side == "LHS") {
            side = "LHS";
          } else {
            side = "RHS";
          }
        }
      }
      //doubt
      // maxLimitEmpty = objformulaFun.upperLimit(individualDetail);
      // minLimitEmpty = objformulaFun.lowerLimit(individualDetail);
      // console.log(__parameterDifferential);
      let powerbacc = await models.tbl_powerbackup.findAll({
        where: {
          CubicalNo: _cubicalData.Sys_CubicNo,
          Idsno: strHmi,
        },
      });

      powerbacc = powerbacc.pop();

      var sideValue = "NA";
      if (
        productObj.Sys_RotaryType == "Single" ||
        productObj.Sys_RotaryType == "N"
      ) {
        sideValue = "NA";
      } else {
        // sideValue = HardnessDetail.data.Side == 'L' ? 'LHS' : 'RHS';
      }
      //   if(powerbacc != undefined){
      //   if (powerbacc.RecSampleNo != undefined) {
      //    globalData.arrWeighmentCounter.push({
      //   Hmi:powerbacc.Idsno,
      //  //  counter: powerbacc.RecSampleNo
      //});
      // }
      //}
      //main counter
      //   if(powerbacc != undefined){
      //   if(powerbacc.Before_Count != undefined){
      //  if (tempCounterObj === undefined) {
      //  globalData.arrWeighmentCounter.push({
      //    Hmi: strHmi,
      //    counter: 1
      // });
      //  }
      //  }
      //}
      if (powerbacc != undefined) {
        if (tempCounterObj === undefined) {
          if (powerbacc.Before_Count == 0 && powerbacc.After_Count == 0) {
            globalData.arrWeighmentCounter.push({
              Hmi: strHmi,
              counter: powerbacc
                ? powerbacc.RecSampleNo + 1
                : powerbacc.RecSampleNo,
            });
          } else {
            globalData.arrWeighmentCounter.push({
              Hmi: strHmi,
              counter: powerbacc ? powerbacc.RecSampleNo : 1,
            });
          }
        }
      } else {
        globalData.arrWeighmentCounter.push({
          Hmi: strHmi,
          counter: powerbacc ? powerbacc.RecSampleNo : 1,
        });
      }

      tempCounterObj = globalData.arrWeighmentCounter.find(
        (k) => k.Hmi == strHmi
      );
      let diffCounter;
      diffCounter = globalData.arrDifferentialCounter.find(
        (k) => k.Hmi == strHmi
      );
      if (powerbacc != undefined) {
        if (powerbacc.Before_Count == 1) {
          if (diffCounter == undefined) {
            globalData.arrDifferentialCounter.push({
              Hmi: strHmi,
              idsNo: strIdsNo,
              counter: powerbacc.Before_Count,
            });
          }
        }
      }

      diffCounter = globalData.arrDifferentialCounter.find(
        (k) => k.Hmi == strHmi
      );
      if (diffCounter == undefined) {
        globalData.arrDifferentialCounter.push({
          Hmi: strHmi,
          idsNo: strIdsNo,
          counter: 1,
        });
      } else {
        diffCounter.counter = diffCounter.counter + 1;
      }

      diffCounter = globalData.arrDifferentialCounter.find(
        (k) => k.Hmi == strHmi
      );

      if (tempCounterObj.counter == 1 && diffCounter.counter == 1) {
        let __activityObj = {
          strUserId: tempUserObject.UserId,
          strUserName: tempUserObject.UserName,
          activity: `${menuName} Weighment Started on TSH ${strHmi}`,
        };

        await objActivityLog.ActivityLogEntry(__activityObj);
        await objInstrumentUsage.InstrumentUsage(
          "Balance",
          strIdsNo,
          "tbl_instrumentlog_balance",
          menuName,
          "started"
        );
      }

      var Individual_Nom = globalData.arrProductTypeArray.find((k) => k.Hmi == strHmi).productDetail[0][0];//await proObj.productData(productObj); 
      //24/02/24
      var T2_Pos_ActualValue, T2_Neg_ActualValue;
      var Individual = {
        nominal: Individual_Nom.Param1_Nom,
        T1Neg: Individual_Nom.Param1_T1Neg,
        T1Pos: Individual_Nom.Param1_T1Pos,
        T2Neg: Individual_Nom.Param1_T2Neg,
        T2Pos: Individual_Nom.Param1_T2Pos,
        unit: Individual_Nom.Param1_Unit,
        LimitOn: Individual_Nom.Param1_LimitOn
      }
      T2_Pos_ActualValue = Number(objFormula.upperLimit(Individual)).toFixed(DP)
      T2_Neg_ActualValue = Number(objFormula.lowerLimit(Individual)).toFixed(DP)

      if (Number(tempCounterObj.counter) <= Number(sample)) {
        var res = await proObj.productData(productObj);
        if (typeValue == "D") {
          //for individual
          var paramNom = `Param1_Nom`;
          var paramT1Neg = `Param1_T1Neg`;
          var paramT1Pos = `Param1_T1Pos`;
          var paramT2Neg = `Param1_T2Neg`;
          var paramT2Pos = `Param1_T2Pos`;
          var limitNo = `Param1_LimitOn`;
          var paramNMT = `Param1_NMTTab`;
          var reportOn = `Param1_IsOnStd`;
          //for Empty
          var paramNomEmpty = `Param0_Nom`;
          var paramT1NegEmpty = `Param0_T1Neg`;
          var paramT1PosEmpty = `Param0_T1Pos`;
          var paramT2NegEmpty = `Param0_T2Neg`;
          var paramT2PosEmpty = `Param0_T2Pos`;
          var limitNoEmpty = `Param0_LimitOn`;
          var paramNMTEmpty = `Param0_NMTTab`;
          var reportOnEmpty = `Param0_IsOnStd`;
          //for Net
          var paramNomNet = `Param3_Nom`;
          var paramT1NegNet = `Param3_T1Neg`;
          var paramT1PosNet = `Param3_T1Pos`;
          var paramT2NegNet = `Param3_T2Neg`;
          var paramT2PosNet = `Param3_T2Pos`;
          var limitNoNet = `Param3_LimitOn`;
          var paramNMTNet = `Param3_NMTTab`;
          var reportOnNet = `Param3_IsOnStd`;
        } else {
          var paramNom = `Param${typeVal}_Nom`;
          var paramT1Neg = `Param${typeVal}_T1Neg`;
          var paramT1Pos = `Param${typeVal}_T1Pos`;
          var paramT2Neg = `Param${typeVal}_T2Neg`;
          var paramT2Pos = `Param${typeVal}_T2Pos`;
          var limitNo = `Param${typeVal}_LimitOn`;
          var paramNMT = `Param${typeVal}_NMTTab`;
          var reportOn = `Param${typeVal}_IsOnStd`;
        }
        let hmiEntryinConfig = globalData.arrConfigSettings.find(
          (k) => k.Hmi == strHmi
        ).configSetting;
        let autoTare = hmiEntryinConfig[0].AutoTare;
        let tareCommand = hmiEntryinConfig[0].Tare_Command;
        // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.selectedIds.Idsno == strHmi);
        // if (IPQCObject != undefined) {
        //     strHmi = IPQCObject.idsNo;
        // } else {
        //     strHmi = strHmi;
        // }

        const productDetailObj = {
          attributes: [
            [sequelize.fn("max", sequelize.col("RepSerNo")), "serialNo"],
          ],
          where: {
            BFGCode: productObj.Sys_BFGCode,
            ProductName: productObj.Sys_ProductName,
            PVersion: productObj.Sys_PVersion,
            Version: productObj.Sys_Version,
            BatchNo: productObj.Sys_Batch,
            Idsno: strHmi,
          },
          // {
        };
        // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
        // if (IPQCObject != undefined) {
        //     strHmi = IPQCObject.selectedIds.Idsno;
        // } else {
        //     strHmi = strHmi;
        // }

        var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
        var SelectedIdsNo
        if (IPQCObject != undefined) {
          SelectedIdsNo = IPQCObject.selectedIds.Idsno;
        } else {
          SelectedIdsNo = strHmi;
        }

        let tableName = "tbl_powerbackup";
        var powerbackupobj = {
          strTableName: mstTableName,
          strDetailTbl: detailTableName,
          cubicaNo: _cubicalData.Sys_CubicNo,
          cubicType: _cubicalData.Sys_CubType,
          cubicSysBFGcode: _cubicalData.Sys_BFGCode,
          cubicBatch: _cubicalData.Sys_Batch,
          menuName: menuName,
          ProductType: 2,
          Userid: tempUserObject.UserId,
          idsNo: strIdsNo,
          Hmi: strHmi,
          RecSampleNo: tempCounterObj.counter,
          ReportType: _cubicalData.Sys_RptType,
          SelectedIds: SelectedIdsNo
        };

        if (productObj.Sys_RptType == 1) {
          //for Initial
          mstSerNo = 0;
          sideNo = 1;
        } else {
          //regular
          let objDifferential = {
            tableName: mstTableName,
            ReportType: 0,
            Side: sideValue,
            BFGCode: productObj.Sys_BFGCode,
            ProductName: productObj.Sys_ProductName,
            PVersion: productObj.Sys_PVersion,
            Version: productObj.Sys_Version,
            BatchNo: productObj.Sys_Batch,
            IdsNo: strHmi,
          };

          if (sideValue == "NA") {
            mstSerNo = await objGetMstSrAndSideSr.getRegularLRMstSerialNo(
              objDifferential
            );
            sideNo = await objGetMstSrAndSideSr.getRegularLRSideNo(
              objDifferential
            );
            if (sideNo < 3) {
              sideNo = sideNo + 1;
            } else {
              sideNo = 1;
              mstSerNo = mstSerNo + 1;
            }
          } else {
            mstSerNo = await objGetMstSrAndSideSr.getRegularLRMstSerialNo(
              objDifferential
            );
            sideNo = await objGetMstSrAndSideSr.getRegularLRSideNo(
              objDifferential
            );
            if (sideNo < 3) {
              sideNo = sideNo + 1;
            } else {
              sideNo = 1;
              mstSerNo = mstSerNo + 1;
            }
          }
        }
        __parameterDifferential.Nominal = Number(res[1].Param3_Nom).toFixed(DP)
        __parameterDifferential.Dp = res[1].Param3_DP
        var dataObj = {
          strTableName: mstTableName,
          strDetailTbl: detailTableName,
          // strDblDetailTbl: dblTable,
          objProductDetails: __parameterDifferential,
          uniqueSerialNumber: strIdsNo,
          strBalId: __parameterDifferential.instrumentId,
          ProtocolData: __parameterDifferential.actualWt,
          ProtocolUnit: (__parameterDifferential.unit).toLowerCase(),
          ProtocolDecPoint: __parameterDifferential.decPoint,
          strHmi: strHmi,
          seqNoOfWt: tempCounterObj.counter,
          productType: objSelMenu.selectedProductDetail.ProductType,
        }
        var dp = __parameterDifferential.decPoint;  //ProtocolDecPoint;
        var result = await models[mstTableName].findAll(productDetailObj);
        let minLimitT2 = DifferentialData.data.T2Neg.split(' ')[0];
        let maxLimitT2 = DifferentialData.data.T2Pos.split(' ')[0];
        let minLimitT1 = DifferentialData.data.T1Neg.split(' ')[0];
        let maxLimitT1 = DifferentialData.data.T1Pos.split(' ')[0];
        if (result[0].serialNo == null || tempCounterObj.counter == 1) {
          let tmpDiffCounter = globalData.arrDifferentialCounter.find(
            (k) => k.Hmi == strHmi
          );
          if (tmpDiffCounter.counter == 1 && tempCounterObj.counter == 1) {
            // let bRepSerNo = await callbeprso.getMaxBRepSerNo(
            //   productObj.Sys_ProductName,
            //   productObj.Sys_Batch,
            //   compTableName,
            //   productObj.Sys_RptType,
            //   mstTableName,
            //   productObj.Sys_CubType
            // );
            var IPQCObject = globalData.arr_IPQCRelIds.find(
              (k) => k.strIdsNo == strIdsNo
            );
            if (IPQCObject != undefined) {
              strHmi = IPQCObject.idsNo;
              let balanceId = await models.tbl_cubical.findAll({
                where: {
                  Sys_IDSNo: strHmi,
                },
              });
              balanceId = balanceId.pop();
              productObj.Sys_BalID = balanceId.Sys_BalID;
            } else {
              strHmi = strHmi;
            }

            let productMaster = globalData.arrProductTypeArray.find(
              (k) => k.Hmi == strHmi
            );

            var LimitOn = productMaster.productDetail[0]

            const objProductDetails = objSelMenu.selectedProductDetail;

            var stdLmtDp = objProductDetails.LimitOn == 0 ? __parameterDifferential.decPoint : 2;
            stdLmtDp = actualUnit != 'mg' ? stdLmtDp : objProductDetails.LimitOn == 1 ? 2 : 1;
            
            var unit_stdlimit = (objProductDetails.LimitOn == 0 ? objProductDetails.unit : '%')
            var std_Limit1;
            var std_Limit2;
            if (Number(objProductDetails.T1Neg) != 0) {
              if (Number(objProductDetails.T1Neg) != Number(objProductDetails.T1Pos)) {
                std_Limit1 = 'NMT' + ' ' + LimitOn[0].Param1_NMTTab + ' ' + 'capsules by' + ' ' + maths.round(objProductDetails.T1Neg, stdLmtDp).toFixed(stdLmtDp) + ' ' + (unit_stdlimit).toLowerCase() + ' ' + '-' + ' ' + maths.round(objProductDetails.T1Pos, stdLmtDp).toFixed(stdLmtDp) + ' ' + (unit_stdlimit).toLowerCase()
              } else {
                std_Limit1 = 'NMT' + ' ' + LimitOn[0].Param1_NMTTab + ' ' + 'capsules by' + ' ' + '±' + ' ' + maths.round(objProductDetails.T1Neg, stdLmtDp).toFixed(stdLmtDp) + ' ' + (unit_stdlimit).toLowerCase()
              }
            } else {
              std_Limit1 = 'NA'
            }
            if (Number(objProductDetails.T2Neg) != Number(objProductDetails.T2Pos)) {
              std_Limit2 = 'None of capsules by ' + ' ' + maths.round(objProductDetails.T2Neg, stdLmtDp).toFixed(stdLmtDp) + ' ' + (unit_stdlimit).toLowerCase() + ' ' + '-' + ' ' + maths.round(objProductDetails.T2Pos, stdLmtDp).toFixed(stdLmtDp) + ' ' + (unit_stdlimit).toLowerCase()
            } else {
              std_Limit2 = 'None of capsules by ±' + ' ' + maths.round(objProductDetails.T2Neg, stdLmtDp).toFixed(stdLmtDp) + ' ' + (unit_stdlimit).toLowerCase();
            }

            var NomNet = DifferentialData.data.Nominal.split(' ')[0]
            NomNet = actualUnit != 'mg' ? NomNet : maths.round(NomNet, 1).toFixed(1)
            const insertIncompleteObj = await models[mstTableName].create({
              MstSerNo: mstSerNo,
              WgmtModeNo: 3,
              ProductType: 2,
              Area: productObj.Sys_Area,
              CubicalNo: productObj.Sys_CubicNo,
              CubicleName: productObj.Sys_CubicName,
              CubicleType: productObj.Sys_CubType,
              IPQCType: productObj.Sys_IPQCType,
              MachineCode: productObj.Sys_MachineCode,
              Department: productObj.Sys_dept,
              BFGCode: productObj.Sys_BFGCode,
              ProductName: productObj.Sys_ProductName,
              PVersion: productObj.Sys_PVersion,
              Version: productObj.Sys_Version,
              BatchNo: productObj.Sys_Batch,
              BatchSize: `${productObj.Sys_BatchSize}`,
              BMRNo: productObj.Sys_BMRNo,
              GraphType: res[1][reportOn],
              Qty: sample,
              GrpQty: sample,
              GrpFreq: sample,
              Idsno: strHmi,
              BalanceId: productObj.Sys_BalID,
              VernierId: productObj.Sys_VernierID,
              FriabilityID: productObj.Sys_FriabID,
              HardnessID: productObj.Sys_HardID,
              UserId: tempUserObject.UserId,
              UserName: tempUserObject.UserName,
              PrDate: moment().format("YYYY-MM-DD"),
              PrTime: moment().format("HH:mm:ss"),
              SideNo: 0,
              Side: side,
              Unit: actualUnit,
              DecimalPoint: DP,
              LimitOn: res[1][limitNo],
              NMT: res[1][paramNMTNet],
              Nom: res[1].Param1_Nom,
              T1NegTol: DifferentialData.data.T1Neg.split(' ')[0],
              T1PosTol: DifferentialData.data.T1Pos.split(' ')[0],
              T2NegTol: DifferentialData.data.T2Neg.split(' ')[0],
              T2PosTol: DifferentialData.data.T2Pos.split(' ')[0],
              T1NegTolActual: 0,
              T1PosTolActual: 0,
              T2NegTolActual: 0,
              T2PosTolActual: 0,
              NomEmpty: 0,
              T1NegEmpty: 0,
              T1PosEmpty: 0,
              T2NegEmpty: 0,
              T2PosEmpty: 0,
              NomNet: NomNet,
              T1NegNet: DifferentialData.data.T1Neg.split(' ')[0],
              T1PosNet: DifferentialData.data.T1Pos.split(' ')[0],
              T2NegNet: DifferentialData.data.T2Neg.split(' ')[0],
              T2PosNet: DifferentialData.data.T2Pos.split(' ')[0],
              T1NegNetActual: maths.round(res[1].Param3_T1Neg, dp).toFixed(dp),
              T1PosNetActual: maths.round(res[1].Param3_T1Pos, dp).toFixed(dp),
              T2NegNetActual: maths.round(res[1].Param3_T2Neg, dp).toFixed(dp),
              T2PosNetActual: maths.round(res[1].Param3_T2Pos, dp).toFixed(dp),
              ReportType: _cubicalData.Sys_RptType,
              PrintNo: 0,
              IsArchived: 0,
              BatchComplete: 0,
              // CheckedByID: 'NA',
              // CheckedByName: 'NA',
              // CheckedByDate: 0,
              Lot: 0,
              NoOfAbove1: 0,
              NoOfBelow1: 0,
              NoOfAbove2: 0,
              NoOfBelow2: 0,
              MinPer: 0,
              MaxPer: 0,
              GroupWeight: 0,
              AvgWeight: 0,
              AvgEmpty: 0,
              AvgNet: 0,
              MinWeight: 0,
              MaxWeight: 0,
              MinWeightEmpty: 0,
              MaxWeightEmpty: 0,
              MinWeightNet: 0,
              MaxWeightNet: 0,
              StdDev: 0,
              Remark: 'NA',
              // FailedRemark: 0,
              FailedRemarkTSH: 0,
              // Inprocess: 0,
              Stage: 0,
              StdLimit1: std_Limit1,
              StdLimit2: std_Limit2,
              Deviation: 0,
              LayerName: 0,
              Layer: 'NA',
              Nom_stdtarget: 0,
              TotalWeight: 0,
              MinGrpWeight: 0,
              MaxGrpWeight: 0,
              AvgGrpWeight: 0,
              // CheckedByTime: 0,
              Inprocess: 1
            });
            const insertRepoRemarkDetail =
              await models.tbl_remark_incomplete_master.create({
                IDSNo: strHmi,
                paramName: menuName,
                tableName: mstTableName,
                BatchNumber: batchNo,
              });

            await insertRepoRemarkDetail;

            var resultincomplete = [insertIncompleteObj];
            var lastInsertedID = resultincomplete[0].RepSerNo;

            const insertIncompleteDetailObj = await models[
              detailTableName
            ].create({
              RepSerNo: lastInsertedID,
              MstSerNo: mstSerNo,
              RecSeqNo: 1,
              DataValue: actualUnit != 'mg' ? maths.round(actualWt, dp).toFixed(dp) : maths.round(actualWt, 1).toFixed(1),
              DP: dp,
              PrDate: moment().format("YYYY-MM-DD"),
              PrTime: moment().format("HH:mm:ss"),
            });

            await objInstrumentUsage.InstrumentUsage("Balance", strIdsNo, "tbl_instrumentlog_balance", menuName, "completed");
            let _check_combination =
              await objPowerBackup._check_empty_combination_pow(objSelMenu, powerbackupobj, tableName);
            if (_check_combination !== undefined) {
              tempCounterObj.counter = _check_combination.RecSampleNo + 1;
            }

            res = insertIncompleteDetailObj;
            //powerbackuppentry
            powerbackupobj.Incomp_RepSerNo = lastInsertedID;
            await objPowerBackup.getStatusoFTestForPowerBackup(powerbackupobj);

            await models.tbl_powerbackup.update(
              {
                Before_Count: 1,
              },
              {
                where: {
                  Idsno: strHmi,
                  // CubicalNo: _cubicalData.Sys_CubicNo
                },
              }
            );

            let limitObjResp = await objCommonUseFunc.SendCommon({
              strHmi,
              actualWt: ntw,
              readingIgnore,
              minLimitT2,
              maxLimitT2,
              minLimitT1,
              maxLimitT1,
              menuName,
              sample,
            });
            let color = limitObjResp.Color;
            // let limit = limitObjResp.limit;

            mqttSender.sendData(
              strHmi,
              `${mqttProtocol.DisplayResult}${mqttProtocol.FilledWeight}:${tempCounterObj.counter}:${actualWt} ${__parameterDifferential.unit}:${color}`
            );

            if (Number(T2_Pos_ActualValue).toFixed(dp) < Number(actualWt).toFixed(dp)) {
              mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} Above Limit`);
            } else if (Number(T2_Neg_ActualValue).toFixed(dp) > Number(actualWt).toFixed(dp)) {
              mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} Below Limit`);
            }

            //monit

            if (autoTare) {
              mqttSender.sendData(
                strHmi,
                `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`
              );
            }
            ///1 sample done before Count. with empty weight//
          } else {
            const selectRepSrNoObj = await models[mstTableName].findAll({
              attributes: [
                [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
              ],
              where: {
                BalanceID: productObj.Sys_BalID,
              },
            });

            var result = [selectRepSrNoObj];
            var masterSrNo = result[0][0].RepSerNo;
            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.selectedIds.Idsno == strHmi);
            // if (IPQCObject != undefined) {
            //     strHmi = IPQCObject.idsNo;
            // } else {
            //     strHmi = strHmi;
            // }

            var sqlquery = `SELECT MAX(RepSerNo) as RepSerNo FROM tbl_cap_master3_incomplete WHERE Idsno = ${strHmi}`;
            var objcheckSideNO = await sequelize.query(sqlquery, {
              type: QueryTypes.SELECT,
            });

            var weightRec = await models.tbl_cap_detail3_incomplete.findAll({
              attributes: [
                [sequelize.fn("max", sequelize.col("RecNo")), "RecNo"],
              ],
              where: {
                RepSerNo: objcheckSideNO[0].RepSerNo,
              },
            });
            var weight = await models.tbl_cap_detail3_incomplete.findAll({
              where: {
                RecNo: weightRec[0].RecNo,
              },
            });

            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
            // if (IPQCObject != undefined) {
            //     strHmi = IPQCObject.selectedIds.Idsno;
            // } else {
            //     strHmi = strHmi;
            // }
            var wtf = Number(weight[0].DataValue).toFixed(DP);

            var wte = Number(weight[0].DataValue1).toFixed(DP);
            if (parseFloat(actualWt) >= parseFloat(wtf)) {
              console.log(`EMPTY WT MUST BE LESS THAN FILLED`);
              mqttSender.sendData(
                strHmi,
                `${mqttProtocol.DisplayMessage}EMPTY WT MUST BE LESS THAN FILLED`
              );
              if (autoTare) {
                mqttSender.sendData(
                  strHmi,
                  `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`
                );
              }
              return;
            }
            var ntw = actualUnit != 'mg' ? Number(weight[0].NetValue).toFixed(DP) : Number(weight[0].NetValue).toFixed(1)

            const updateObj = await models[detailTableName].update(
              {
                DataValue1: actualUnit != 'mg' ? Number(actualWt).toFixed(DP) : Number(actualWt).toFixed(1)
              },
              {
                where: {
                  RepSerNo: masterSrNo,
                  RecSeqNo: tempCounterObj.counter,
                },
              }
            );

            updateObj;
            await objInstrumentUsage.InstrumentUsage("Balance", strIdsNo, "tbl_instrumentlog_balance", menuName, "completed");
            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.selectedIds.Idsno == strHmi);
            // if (IPQCObject != undefined) {
            //     strHmi = IPQCObject.idsNo;
            // } else {
            //     strHmi = strHmi;
            // }
            let resu = `UPDATE tbl_cap_detail3_incomplete
            SET NetValue = CAST(DataValue AS DECIMAL(18, ${DP})) - CAST(DataValue1 AS DECIMAL(18, ${DP}))
            WHERE RepSerNo =  ${masterSrNo} `;
            res = await sequelize.query(resu, { type: QueryTypes.UPDATE });
            var sqlquery = `SELECT MAX(RepSerNo) as RepSerNo FROM tbl_cap_master3_incomplete WHERE Idsno = ${strHmi}`;
            var objcheckSideNO = await sequelize.query(sqlquery, {
              type: QueryTypes.SELECT,
            });

            var sqlquery = `select NetValue from tbl_cap_detail3_incomplete where RepSerNo = ${objcheckSideNO[0].RepSerNo};`;
            var result = await sequelize.query(sqlquery, {
              type: QueryTypes.SELECT,
            });
            var weightRec = await models.tbl_cap_detail3_incomplete.findAll({
              attributes: [
                [sequelize.fn("max", sequelize.col("RecNo")), "RecNo"],
              ],
              where: {
                RepSerNo: objcheckSideNO[0].RepSerNo,
              },
            });
            var weight = await models.tbl_cap_detail3_incomplete.findAll({
              where: {
                RecNo: weightRec[0].RecNo,
              },
            });
            var wtf = actualUnit != 'mg' ? Number(weight[0].DataValue).toFixed(DP) : Number(weight[0].DataValue).toFixed(1)
            var wte = actualUnit != 'mg' ? Number(weight[0].DataValue1).toFixed(DP) : Number(weight[0].DataValue1).toFixed(1)
            var ntw = actualUnit != 'mg' ? Number(weight[0].NetValue).toFixed(DP) : Number(weight[0].NetValue).toFixed(1)
            var unit = __parameterDifferential.unit;
            //Calculations 
            var Calc = await this.calculation_operation(dataObj, objcheckSideNO[0].RepSerNo);

            let tempPbkupObj = globalData.monitDetail.find(
              (k) => k.Hmi == strHmi
            );
            if (tempPbkupObj != undefined) {
              if (tempPbkupObj.data != undefined) {
                if (tempPbkupObj.data.length > 0) {
                  for (var i = 0; i < tempPbkupObj.data.length; i++) {
                    await objMonit.monit({
                      case: "DiffTestWeight",
                      Hmi: strHmi,
                      data: {
                        Weight: {
                          wtf: `${tempPbkupObj.data[i].DataValue}`,
                          unit,
                          wte: `${tempPbkupObj.data[i].DataValue1}`,
                          unit,
                          ntw: `${tempPbkupObj.data[i].NetValue}`,
                          unit,
                          srNo: i + 1,
                        },
                      },
                    });
                  }
                  var index = globalData.monitDetail.findIndex(
                    (k) => k.Hmi == strHmi
                  );
                  globalData.monitDetail[index].data = [];
                }
              }
            }

            await objMonit.monit({
              case: "DiffTestWeight",
              Hmi: strHmi,
              data: {
                Weight: {
                  wtf: `${wtf}`,
                  unit,
                  wte: `${wte}`,
                  unit,
                  ntw: `${ntw}`,
                  unit,
                  srNo: tempCounterObj.counter,
                },
              },
            });
            let limitObjResp = await objCommonUseFunc.SendCommon({
              strHmi,
              actualWt: ntw,
              readingIgnore,
              minLimitT2,
              maxLimitT2,
              minLimitT1,
              maxLimitT1,
              menuName,
              sample,
            });
            let color = limitObjResp.Color;
            let limit = limitObjResp.limit;

            mqttSender.sendData(
              strHmi,
              `${mqttProtocol.DisplayResult}${mqttProtocol.EmptyWeight}:${tempCounterObj.counter}:${actualWt} ${__parameterDifferential.unit}:${ntw} ${__parameterDifferential.unit}:${color}`
            );
            if (limit != 'DisplayMessage:Within Limit') {
              mqttSender.sendData(strHmi, limit);
            }
            //monit

            // await objMonit.monit({
            //     case: 'DiffTestWeight', Hmi: strHmi, data: {
            //         Weight: `${Number(
            //             actualWt,result
            //         )} ${__parameterDifferential.unit}`, srNo: tempCounterObj.counter, message: 'EmptyWeight'
            //     }
            // });

            if (autoTare) {
              mqttSender.sendData(
                strHmi,
                `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`
              );
            }
            //  :${Number(result[0].NetValue)} ${__parameterDifferential.unit}`);
            //   await objPowerBackup.updateTestCount(objSelMenu, powerbackupobj, tableName);
            var updatepow = await models.tbl_powerbackup.update(
              { After_Count: 1 },
              { where: { Idsno: strHmi } }
            );
            // await models.tbl_powerbackup.update(
            //     {
            //         After_Count: 1
            //     },
            //     {
            //         where: {
            //             Idsno:strHmi,
            //             // CubicalNo: powerbacc.CubicalNo
            //         }
            //     }
            // );
            if (powerbacc.Incomp_RepSerNo != null) {
              await models.tbl_powerbackup.update(
                {
                  After_Count: 0,
                  Before_Count: 0,
                },
                {
                  where: {
                    Idsno: strHmi,
                    // CubicalNo: powerbacc.CubicalNo
                  },
                }
              );
            }

            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
            // if (IPQCObject != undefined) {
            //     strHmi = IPQCObject.selectedIds.Idsno;
            // } else {
            //     strHmi = strHmi;
            // }
            T2_Neg_ActualValue = DifferentialData.data.T2Neg.split(' ')[0],
              T2_Pos_ActualValue = DifferentialData.data.T2Pos.split(' ')[0]
            if (Number(T2_Pos_ActualValue).toFixed(dp) < Number(ntw).toFixed(dp)) {
              mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} Above Limit`);
            } else if (Number(T2_Neg_ActualValue).toFixed(dp) > Number(ntw).toFixed(dp)) {
              mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} Below Limit`);
            }
            tempCounterObj.counter = tempCounterObj.counter + 1;
            globalData.arrDifferentialCounter.splice(
              globalData.arrDifferentialCounter.findIndex(
                (k) => k.Hmi == strHmi
              ),
              1
            );
          }
        } else {
          let tmpDiffCounter = globalData.arrDifferentialCounter.find(
            (k) => k.Hmi == strHmi
          );

          // if (diffCounter.counter == 2) {
          //   var sql_query = `SELECT MAX(RepSerNo) as RepSerNo FROM tbl_cap_master3_incomplete WHERE Idsno = ${strHmi}`;
          //   var objcheckSideNO = await sequelize.query(sql_query, {
          //     type: QueryTypes.SELECT,
          //   });
          //   var weight_Rec = await models.tbl_cap_detail3_incomplete.findAll({
          //     attributes: [
          //       [sequelize.fn("max", sequelize.col("RecNo")), "RecNo"],
          //     ],
          //     where: {
          //       RepSerNo: objcheckSideNO[0].RepSerNo,
          //     },
          //   });
          //   var Get_Fillweight =
          //     await models.tbl_cap_detail3_incomplete.findAll({
          //       where: {
          //         RecNo: weight_Rec[0].RecNo,
          //       },
          //     });

          //   if (
          //     Get_Fillweight[0].DataValue1 != "0.00000" &&
          //     tmpDiffCounter.counter == 2
          //   ) {
          //     globalData.arrDifferentialCounter.splice(
          //       globalData.arrDifferentialCounter.findIndex(
          //         (k) => k.Hmi == strHmi
          //       ),
          //       1
          //     );
          //     if (powerbacc.Incomp_RepSerNo != null) {
          //       await models.tbl_powerbackup.update(
          //         {
          //           After_Count: 0,
          //           Before_Count: 0,
          //         },
          //         {
          //           where: {
          //             Idsno: strHmi,
          //             // CubicalNo: powerbacc.CubicalNo
          //           },
          //         }
          //       );
          //     }
          //     //  let data = globalData.arrWeighmentCounter.find((k) => k.Hmi == strHmi);
          //     //  data = data.pop()
          //     globalData.arrWeighmentCounter.findIndex(
          //       (k) => k.Hmi == strHmi
          //     ) == -1
          //       ? globalData.arrWeighmentCounter
          //       : globalData.arrWeighmentCounter.splice(
          //         globalData.arrWeighmentCounter.findIndex(
          //           (k) => k.Hmi == strHmi
          //         ),
          //         1
          //       );
          //     globalData.arrWeighmentCounter.push({
          //       Hmi: strHmi,
          //       counter: tempCounterObj.counter + 1,
          //     });
          //     return;
          //   }
          // }

          const selectRepSrNoObj = await models[mstTableName].findAll({
            attributes: [
              [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
            ],
            where: {
              BalanceID: productObj.Sys_BalID,
            },
          });
          //  {
          //     str_tableName: mstTableName,
          //     data: 'Max (RepSerNo) as RepSerNo',
          //     condition: [
          //         { str_colName: 'BalanceID', value: productObj.Sys_BalID, comp: 'eq' },
          //     ]
          // }
          var result = [selectRepSrNoObj];
          let repSrNo = result[0][0].RepSerNo;

          if (tmpDiffCounter.counter == 1 && tempCounterObj.counter != 1) {
            const insertIncompleteDetailObj = await models[
              detailTableName
            ].create({
              RepSerNo: repSrNo,
              MstSerNo: mstSerNo,
              RecSeqNo: tempCounterObj.counter,
              DataValue: actualUnit != 'mg' ? Number(actualWt).toFixed(DP) : Number(actualWt).toFixed(1),
              DecimalPoint: decimalPoint,
              PrDate: moment().format("YYYY-MM-DD"),
              PrTime: moment().format("HH:mm:ss"),
            });
            //  {
            //     str_tableName: detailTableName,
            //     data: [
            //         { str_colName: 'RepSerNo', value: repSrNo },
            //         { str_colName: 'MstSerNo', value: mstSerNo },
            //         { str_colName: 'RecSeqNo', value: tempCounterObj.counter },
            //         { str_colName: 'DataValue', value: actualWt },
            //         { str_colName: 'DecimalPoint', value: this.precision(Number(actualWt)) },
            //     ]
            // }
            res = insertIncompleteDetailObj;
            await objInstrumentUsage.InstrumentUsage(
              "Balance",
              strIdsNo,
              "tbl_instrumentlog_balance",
              menuName,
              "completed"
            );
            await objPowerBackup.updateTestCount(
              objSelMenu,
              powerbackupobj,
              tableName
            );
            await models.tbl_powerbackup.update(
              {
                Before_Count: 1,
              },
              {
                where: {
                  Idsno: strHmi,
                  // CubicalNo: powerbacc.CubicalNo
                },
              }
            );

            mqttSender.sendData(
              strHmi,
              `${mqttProtocol.DisplayResult}${mqttProtocol.FilledWeight}:${tempCounterObj.counter}:${actualWt} ${__parameterDifferential.unit}`
            );

            if (Number(T2_Pos_ActualValue).toFixed(dp) < Number(actualWt).toFixed(dp)) {
              mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} Above Limit`);
            } else if (Number(T2_Neg_ActualValue).toFixed(dp) > Number(actualWt).toFixed(dp)) {
              mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} Below Limit`);
            }

            //monit
            // await objMonit.monit({
            //     case: 'DiffTestWeight', Hmi: strHmi, data: {
            //         Weight: `${Number(
            //             actualWt
            //         )} ${__parameterDifferential.unit}`, srNo: tempCounterObj.counter, message: 'FilledWeight'
            //     }
            // });

            if (autoTare) {
              mqttSender.sendData(
                strHmi,
                `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`
              );
            }
          } else {
            const selectRepSrNoObj = await models[mstTableName].findAll({
              attributes: [
                [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
              ],
              where: {
                BalanceID: productObj.Sys_BalID,
              },
            });
            // {
            //     str_tableName: mstTableName,
            //     data: 'Max (RepSerNo) as RepSerNo',
            //     condition: [
            //         { str_colName: 'BalanceID', value:BalanceID comp: 'eq' },
            //     ]
            // }
            var result = [selectRepSrNoObj];
            let masterSrNo = result[0][0].RepSerNo;
            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.selectedIds.Idsno == strHmi);
            // if (IPQCObject != undefined) {
            //     strHmi = IPQCObject.idsNo;
            // } else {
            //     strHmi = strHmi;
            // }

            var sqlquery = `SELECT MAX(RepSerNo) as RepSerNo FROM tbl_cap_master3_incomplete WHERE Idsno = ${strHmi}`;
            var objcheckSideNO = await sequelize.query(sqlquery, {
              type: QueryTypes.SELECT,
            });

            var weightRec = await models.tbl_cap_detail3_incomplete.findAll({
              attributes: [
                [sequelize.fn("max", sequelize.col("RecNo")), "RecNo"],
              ],
              where: {
                RepSerNo: objcheckSideNO[0].RepSerNo,
              },
            });
            var weight = await models.tbl_cap_detail3_incomplete.findAll({
              where: {
                RecNo: weightRec[0].RecNo,
              },
            });
            var wtf = Number(weight[0].DataValue);
            if (actualWt >= wtf) {
              console.log(`EMPTY WT MUST BE LESS THAN FILLED`);
              mqttSender.sendData(
                strHmi,
                `${mqttProtocol.DisplayMessage}EMPTY WT MUST BE LESS THAN FILLED`
              );
              if (autoTare) {
                mqttSender.sendData(
                  strHmi,
                  `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`
                );
              }
              return;
            }
            var wte = Number(weight[0].DataValue1).toFixed(DP);
            var ntw = Number(weight[0].NetValue).toFixed(DP);

            const updateObj = await models[detailTableName].update(
              {
                DataValue1: Number(actualWt).toFixed(DP),
              },
              {
                where: {
                  RepSerNo: masterSrNo,
                  RecSeqNo: tempCounterObj.counter,
                },
              }
            );

            updateObj;

            await objInstrumentUsage.InstrumentUsage(
              "Balance",
              strIdsNo,
              "tbl_instrumentlog_balance",
              menuName,
              "completed"
            );


            // monit


            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.selectedIds.Idsno == strHmi);
            // if (IPQCObject != undefined) {
            //     strHmi = IPQCObject.idsNo;
            // } else {
            //     strHmi = strHmi;
            // }
            let resul = `UPDATE tbl_cap_detail3_incomplete
            SET NetValue = CAST(DataValue AS DECIMAL(18, ${DP})) - CAST(DataValue1 AS DECIMAL(18, ${DP}))
            WHERE RepSerNo = ${repSrNo} `;
            res = await sequelize.query(resul, { type: QueryTypes.UPDATE });
            var sqlquery = `SELECT MAX(RepSerNo) as RepSerNo FROM tbl_cap_master3_incomplete WHERE Idsno = ${strHmi};`;
            var objcheckSideNO = await sequelize.query(sqlquery, {
              type: QueryTypes.SELECT,
            });
            var sqlquery = `SELECT NetValue from tbl_cap_detail3_incomplete where RepSerNo = ${objcheckSideNO[0].RepSerNo};`;
            var result = await sequelize.query(sqlquery, {
              type: QueryTypes.SELECT,
            });

            var Recweight = await models.tbl_cap_detail3_incomplete.findAll({
              attributes: [
                [sequelize.fn("max", sequelize.col("RecNo")), "RecNo"],
              ],
              where: {
                RepSerNo: objcheckSideNO[0].RepSerNo,
              },
            });
            var weight = await models.tbl_cap_detail3_incomplete.findAll({
              where: {
                RecNo: Recweight[0].RecNo,
              },
            });

            var wtf = Number(weight[0].DataValue).toFixed(DP);
            var wte = Number(weight[0].DataValue1).toFixed(DP);
            var ntw = Number(weight[0].NetValue).toFixed(DP);
            var unit = __parameterDifferential.unit;
            //Calculations 
            var Calc = await this.calculation_operation(dataObj, objcheckSideNO[0].RepSerNo);

            await objMonit.monit({
              case: "DiffTestWeight",
              Hmi: strHmi,
              data: {
                Weight: {
                  wtf: `${wtf}`,
                  unit,
                  wte: `${wte}`,
                  unit,
                  ntw: `${ntw}`,
                  unit,
                  srNo: tempCounterObj.counter,
                },
              },
            });

            await models.tbl_powerbackup.update(
              {
                After_Count: 1,
              },
              {
                where: {
                  Idsno: strHmi,
                  // CubicalNo: powerbacc.CubicalNo
                },
              }
            );

            if (powerbacc.Incomp_RepSerNo != null) {
              await models.tbl_powerbackup.update(
                {
                  After_Count: 0,
                  Before_Count: 0,
                },
                {
                  where: {
                    Idsno: strHmi,
                  },
                }
              );
            }

            let limitObjResp = await objCommonUseFunc.SendCommon({
              strHmi,
              actualWt: ntw,
              readingIgnore,
              minLimitT2,
              maxLimitT2,
              minLimitT1,
              maxLimitT1,
              menuName,
              sample,
            });
            let color = limitObjResp.Color;
            let limit = limitObjResp.limit;

            mqttSender.sendData(
              strHmi,
              `${mqttProtocol.DisplayResult}${mqttProtocol.EmptyWeight}:${tempCounterObj.counter}:${actualWt} ${__parameterDifferential.unit}:${ntw} ${__parameterDifferential.unit}:${color}`
            );
            if (limit != 'DisplayMessage:Within Limit') {
              mqttSender.sendData(strHmi, limit);
            }

            if (autoTare) {
              mqttSender.sendData(
                strHmi,
                `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`
              );
            }
            // await objPowerBackup.updateTestCount(objSelMenu, powerbackupobj, tableName);
            tempCounterObj.counter = tempCounterObj.counter + 1;
            globalData.arrDifferentialCounter.splice(
              globalData.arrDifferentialCounter.findIndex(
                (k) => k.Hmi == strHmi
              ),
              1
            );
          }
        }
        ///1 sample after count done with afterweight.

        let __parameterDiffObj = {
          strTableName: mstTableName,
          strDetailTbl: detailTableName,
          uniqueSerialNumber: strIdsNo,
          strBalId: __parameterDifferential.instrumentId,
          ProtocolData: actualWt,
          ProtocolUnit: __parameterDifferential.unit,
          ProtocolDecPoint: __parameterDifferential.decPoint,
          objProductDetails: DifferentialData.data,
          strHmi: strHmi,
        };

        // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
        // if (IPQCObject != undefined) {
        //     strHmi = IPQCObject.selectedIds.Idsno;
        // } else {
        //     strHmi = strHmi;
        // }

        let countFromDb = await objIncompleteReport.getDiffIncomepleteData(
          __parameterDiffObj,
          "tbl_cap_master3",
          "tbl_cap_detail3",
          strHmi
        );
        // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
        // if (IPQCObject != undefined) {
        //     strHmi = IPQCObject.selectedIds.Idsno;
        // } else {
        //     strHmi = strHmi;
        // }
        let DataValue1 = countFromDb.detailData.filter((k) => k.DataValue1 == "0");
        if (Number(sample) == Number(countFromDb.detailData.length) && DataValue1.length === 0) {
          await models.tbl_powerbackup.destroy({
            where: {
              // CubicalNo: powerbacc.CubicalNo,
              Idsno: strHmi,
              Sys_Batch: _cubicalData.Sys_Batch
              // WeighmentName: "Differential",
            },
          });

          let mstTableName = "tbl_cap_master3";
          // var updateData = await objcalc.calculation_operation(__parameterDiffObj, objcheckSideNO[0].RepSerNo);
          var response = await objCommonInsertOpt.saveDiffCompleteData(__parameterDiffObj, typeValue);
          // await objCommonInsertOpt.updateEndDate(strIdsNo, strHmi, mstTableName);

          if (Calc == "Not Complies") {
            response.reportStatus = "Report Out Of Limit"
          }
          else {
            response.reportStatus = "Report Within Limit"
          }
          const objUpdateValidation = await models.tbl_cubical.update(
            {
              Sys_Validation: 0,
            },
            {
              where: {
                Sys_IDSNo: strHmi,
              },
            }
          );
          await objMonit.monit({
            case: "ReportStatus",
            Hmi: strHmi,
            data: {
              message: response.reportStatus,
              // message: Calc,
            },
          });
          let productType = 2;
          let Printobj = {
            recordFrom: "Current",
            reportOption: "Differential",
            reportType: "Complete",
            testType: "Regular",
            RepSerNo: response.RepSerNo,
            userId: tempUserObject.UserId,
            username: tempUserObject.UserName,
            printNo: 0,
            str_url: "Capsule",
          };
          // await objcallPrint.callViewTabReport(Printobj, productType, strHmi)

          Object.assign(
            objActivity,
            { strUserId: tempUserObject.UserId },
            { strUserName: tempUserObject.UserName },
            { activity: `${menuName} Weighment Completed on TSH ${strHmi}` }
          );
          // await objInstrumentUsage.InstrumentUsage(
          //     'Balance',
          //     strIdsNo,
          //     'tbl_instrumentlog_balance',
          //     menuName,
          //     'completed'
          // );

          await objActivityLog.ActivityLogEntry(objActivity);
          globalData.arrWeighmentCounter.findIndex((k) => k.Hmi == strHmi) == -1
            ? globalData.arrWeighmentCounter
            : globalData.arrWeighmentCounter.splice(
              globalData.arrWeighmentCounter.findIndex(
                (k) => k.Hmi == strHmi
              ),
              1
            );

          globalData.arrCurrentOperationStatus.findIndex(
            (element) => element.Hmi === strHmi
          ) == -1
            ? globalData.arrCurrentOperationStatus
            : globalData.arrCurrentOperationStatus.splice(
              globalData.arrCurrentOperationStatus.findIndex(
                (element) => element.Hmi === strHmi
              ),
              1
            );

          //test splice if rotarty is not double
          globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi) == -1
            ? globalData.arrSelectedMenu
            : globalData.arrSelectedMenu.splice(
              globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi),
              1
            );

          globalData.arrDifferentialCounter.findIndex((k) => k.Hmi == strHmi) ==
            -1
            ? globalData.arrDifferentialCounter
            : globalData.arrDifferentialCounter.splice(
              globalData.arrDifferentialCounter.findIndex(
                (k) => k.Hmi == strHmi
              ),
              1
            );
          // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}${response.reportStatus}`);
          mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}${response.reportStatus} `);

          if (_cubicalData.Sys_RotaryType == "Double") {
            if (Side.length == 1) {
              if (Side[0] == "LHS") {
                Side = "RHS";
              } else {
                Side = "LHS";
              }
              //    if(Number(sample) == Number(tempCounterObj.counter)){
              mqttSender.sendData(strHmi, `${mqttProtocol.SideChange}:${Side}`);
              await objMonit.monit({
                case: "ReportStatus",
                Hmi: strHmi,
                data: {
                  message: Side,
                },
              });

              //    }
            } else {
              globalData.arrCurrentOperationStatus.findIndex(
                (element) => element.Hmi === strHmi
              ) == -1
                ? globalData.arrCurrentOperationStatus
                : globalData.arrCurrentOperationStatus.splice(
                  globalData.arrCurrentOperationStatus.findIndex(
                    (element) => element.Hmi === strHmi
                  ),
                  1
                );

              globalData.arrOutFlagForTest.findIndex(
                (element) => element.Hmi === strHmi
              ) == -1
                ? globalData.arrOutFlagForTest
                : globalData.arrOutFlagForTest.splice(
                  globalData.arrOutFlagForTest.findIndex(
                    (element) => element.Hmi === strHmi
                  ),
                  1
                );

              //test splice if rotarty is not double
              globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi) == -1
                ? globalData.arrSelectedMenu
                : globalData.arrSelectedMenu.splice(
                  globalData.arrSelectedMenu.findIndex(
                    (k) => k.Hmi == strHmi
                  ),
                  1
                );
              globalData.DoubSide.findIndex((k) => k.Hmi == strHmi) == -1
                ? globalData.DoubSide
                : globalData.DoubSide.splice(
                  globalData.DoubSide.findIndex((k) => k.Hmi == strHmi),
                  1
                );
            }
          }
          return;
        }
      }
    } catch (error) {
      throw new Error(error);
      console.log(error);
    }
  }

  async calculation_operation(Dataobj, repSerNo) {
    var ProdData = Dataobj.objProductDetails;
    var strHmi = ProdData.Hmi;
    var actualWt = Dataobj.ProtocolData
    var DataValue_arr = [];
    var detail_tableName = Dataobj.strDetailTbl;
    var master_tableName = Dataobj.strTableName;
    var Nominal = Dataobj.objProductDetails.Nominal;
    var ProtocolUnit = Dataobj.ProtocolUnit
    //For balanceDp = 3 and vernierDP 2 and Avg(balance)DP=4 and Avg(vernier)DP=3
    var DP = ProtocolUnit != 'mg' ? Dataobj.ProtocolDecPoint : 1
    var avgStdDevDp = ProtocolUnit != 'mg' ? 4 : 1
    var min_max_Per = 2;
    Nominal = ProtocolUnit != 'mg' ? Number(Nominal).toFixed(DP) : Number(Nominal).toFixed(1)
    var get_Datavalue = await models[detail_tableName].findAll({ where: { RepSerNo: repSerNo } });
    var get_Datavalue1 = await models[master_tableName].findAll({ where: { RepSerNo: repSerNo } });
    DataValue_arr.push(get_Datavalue);
    var arr = [];
    var arr2 = [];
    var total_weight = 0
    var total_weight2 = 0
    for (var i = 0; i < get_Datavalue.length; i++) {
      var a = get_Datavalue[i].NetValue;
      arr.push(Number(a));
      // console.log(arr);
      total_weight = Number(total_weight) + Number(get_Datavalue[i].NetValue)

      var b = get_Datavalue[i].DataValue;
      arr2.push(Number(b));
      // console.log(arr2);
      total_weight2 = Number(total_weight2) + Number(get_Datavalue[i].DataValue)
    }
    var dp_Ver_bal = 4;
    var max_value = maths.max(arr);
    max_value = maths.round(max_value, DP).toFixed(DP);
    var min_value = maths.min(arr);
    min_value = maths.round(min_value, DP).toFixed(DP);
    // var std_value = maths.std(arr);

    var std_value = maths.std(arr);
    std_value = std_value.toFixed(avgStdDevDp);
    var total = arr.reduce((acc, total) => {
      return Number(total) + Number(acc);
    }, 0)
    var avg = total / arr.length
    avg = Number(maths.round(maths.abs(avg), avgStdDevDp)).toFixed(avgStdDevDp)
    var total2 = arr2.reduce((acc, total) => {
      return Number(total) + Number(acc);
    }, 0)
    var avg2 = total2 / arr2.length
    avg2 = Number(maths.round(maths.abs(avg2), avgStdDevDp)).toFixed(avgStdDevDp);
    // var Per_Dev = ((Nominal - avg) / Nominal) * 100;
    // Per_Dev = Number(Per_Dev).toFixed(DP);
    var minPer_value = ((Nominal - min_value) / Nominal) * 100;
    minPer_value = maths.abs(minPer_value).toFixed(min_max_Per)
    var maxPer_value = ((max_value - Nominal) / Nominal) * 100;
    maxPer_value = maths.abs(maxPer_value).toFixed(min_max_Per)

    console.log(max_value, min_value, std_value, avg, minPer_value, maxPer_value);

    //No.of Tablets Above and Below limit
    var T1Pos_Tol, T1Neg_Tol, T2Pos_Tol, T2Neg_Tol;
    T1Pos_Tol = get_Datavalue1[0].T1PosNet;
    T1Neg_Tol = get_Datavalue1[0].T1NegNet;
    T2Pos_Tol = get_Datavalue1[0].T2PosNet;
    T2Neg_Tol = get_Datavalue1[0].T2NegNet;

    var nob1 = 0;
    var noa1 = 0;
    var nob2 = 0;
    var noa2 = 0;

    for (var i = 0; i < get_Datavalue.length; i++) {
      if (T1Neg_Tol != 0 && T1Pos_Tol != 0) {
        if (Number(get_Datavalue[i].NetValue) < Number(T1Neg_Tol) && Number(get_Datavalue[i].NetValue) >= Number(T2Neg_Tol)) { //No of below limit 1
          nob1 = nob1 + 1;
        } else if (Number(get_Datavalue[i].NetValue) > Number(T1Pos_Tol) && Number(get_Datavalue[i].NetValue) <= Number(T2Pos_Tol)) { //No of Above limit 1
          noa1 = noa1 + 1;
        }
      }
      if (Number(get_Datavalue[i].NetValue) < Number(T2Neg_Tol)) { //No of below limit 2
        nob2 = nob2 + 1;
      } else if (Number(get_Datavalue[i].NetValue) > Number(T2Pos_Tol)) { //No of Above limit 2
        noa2 = noa2 + 1;
      }
    }
    //update Min and Max value in Master and also Std,minPer,maxPer,%Dev
    var get_Datavalue11 = await models[master_tableName].update({
      AvgWeight: maths.round(avg2, avgStdDevDp).toFixed(avgStdDevDp),
      AvgNet: maths.round(avg, avgStdDevDp).toFixed(avgStdDevDp),
      MinWeightNet: maths.round(min_value, DP).toFixed(DP),
      MaxWeightNet: maths.round(max_value, DP).toFixed(DP),
      StdDev: maths.round(std_value, avgStdDevDp).toFixed(avgStdDevDp),
      MinPer: maths.round(minPer_value, min_max_Per).toFixed(min_max_Per),
      MaxPer: maths.round(maxPer_value, min_max_Per).toFixed(min_max_Per),
      TotalWeight: maths.round(total_weight, DP).toFixed(DP),
      // Deviation: Per_Dev,
      NoOfAbove1: noa1,
      NoOfAbove2: noa2,
      NoOfBelow1: nob1,
      NoOfBelow2: nob2
    }, { where: { RepSerNo: repSerNo } });

    let getLatestUpdatedData = await models[master_tableName].findAll({ where: { RepSerNo: repSerNo } });
    var remark = 'NA'
    if (((Number(getLatestUpdatedData[0].NoOfAbove1) + Number(getLatestUpdatedData[0].NoOfBelow1)) > Number(getLatestUpdatedData[0].NMT) || (Number(getLatestUpdatedData[0].NoOfAbove2) != 0) || Number(getLatestUpdatedData[0].NoOfBelow2) != 0)) {
      remark = 'Not Complies';
    } else {
      remark = 'Complies';
    }
    var objSelMenu = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);

    if (Dataobj.seqNoOfWt == getLatestUpdatedData[0].Qty) {
      if (objSelMenu.selectedProductDetail.isonstd == 1) {
        var get_Datavalue_final = await models[detail_tableName].findAll({ where: { RepSerNo: repSerNo } });
        var get_Datavalue1_final = await models[master_tableName].findAll({ where: { RepSerNo: repSerNo } });

        objSelMenu.selectedProductDetail.nominal = get_Datavalue1_final[0].AvgWeight;

        var Nominal_final = objSelMenu.selectedProductDetail.nominal;
        Nominal_final = Number(Nominal_final).toFixed(DP);

        var typeValue = 1;
        var maxLimitT1_avg = objFormula.upperLimit(objSelMenu.selectedProductDetail, 'T1');
        var maxLimitT2_avg = objFormula.upperLimit(objSelMenu.selectedProductDetail, 'T2');
        var minLimitT2_avg = objFormula.lowerLimit(objSelMenu.selectedProductDetail, 'T2');
        var minLimitT1_avg = objFormula.lowerLimit(objSelMenu.selectedProductDetail, 'T1');

        var DataValue_arr = [];

        get_Datavalue1_final[0].NoOfBelow1 = 0;
        get_Datavalue1_final[0].NoOfAbove1 = 0;
        get_Datavalue1_final[0].NoOfBelow2 = 0;
        get_Datavalue1_final[0].NoOfAbove2 = 0;

        DataValue_arr.push(get_Datavalue_final);
        var arr_final = [];
        for (var j = 0; j < get_Datavalue_final.length; j++) {
          var AB = get_Datavalue_final[j].NetValue;
          arr_final.push(Number(AB));
          console.log(arr_final);
          // }
          if (Number(AB) < Number(minLimitT2_avg)) {
            get_Datavalue1_final[0].NoOfBelow2 = Number(get_Datavalue1_final[0].NoOfBelow2) + 1;
          } else if (Number(AB) > Number(maxLimitT2_avg)) {
            get_Datavalue1_final[0].NoOfAbove2 = Number(get_Datavalue1_final[0].NoOfAbove2) + 1;
          }
          if (maxLimitT1_avg != 0 && minLimitT1_avg != 0) {
            if (Number(AB) < Number(minLimitT1_avg) && Number(AB) >= Number(minLimitT2_avg)) {
              get_Datavalue1_final[0].NoOfBelow1 = Number(get_Datavalue1_final[0].NoOfBelow1) + 1;
            } else if (Number(AB) > Number(maxLimitT1_avg) && Number(AB) <= Number(maxLimitT2_avg)) {
              get_Datavalue1_final[0].NoOfAbove1 = Number(get_Datavalue1_final[0].NoOfAbove1) + 1;
            }
          }
        }
        // arr_final.push(Number(AB));
        // console.log(arr_final);
        var max_value_final = maths.max(arr_final);
        max_value_final = max_value_final.toFixed(DP);
        var min_value_final = maths.min(arr_final);
        min_value_final = min_value_final.toFixed(DP);
        var std_value_final = maths.std(arr_final);
        std_value_final = std_value_final.toFixed(avgStdDevDp);
        var total_final = arr_final.reduce((acc, total_final) => {
          return Number(total_final) + Number(acc);
        }, 0)
        var avg_final = total_final / arr_final.length
        avg_final = Number(maths.round(maths.abs(avg_final), dp_Ver_bal)).toFixed(dp_Ver_bal);
        var minPer_value_final = ((avg_final - min_value_final) / avg_final) * 100;

        minPer_value_final = (minPer_value_final).toFixed(2);
        if (!minPer_value_final.startsWith('-')) {
          minPer_value_final = minPer_value_final
        } else {
          minPer_value_final = maths.abs(minPer_value_final).toFixed(2)
          minPer_value_final = minPer_value_final
        }
        var maxPer_value_final = ((avg_final - max_value_final) / avg_final) * 100;
        maxPer_value_final = (maxPer_value_final).toFixed(2);
        if (!maxPer_value_final.startsWith('-')) {
          maxPer_value_final = maxPer_value_final
        } else {
          maxPer_value_final = maths.abs(maxPer_value_final).toFixed(2)
          maxPer_value_final = maxPer_value_final
        }

        // minPer_value_final = (minPer_value_final).toFixed(2);
        // if (!minPer_value_final.startsWith('-')) {
        //   minPer_value_final = '+' + " " + minPer_value_final
        // }
        // var maxPer_value_final = ((Nominal_final - max_value_final) / Nominal_final) * 100;
        // maxPer_value_final = (maxPer_value_final).toFixed(2);
        // if (!maxPer_value_final.startsWith('-')) {
        //   maxPer_value_final = '+' + " " + maxPer_value_final
        // }

        // console.log();
        console.log(max_value_final, min_value_final, std_value_final, avg_final, minPer_value_final, maxPer_value_final);
        // return arr;

        var master_update = await models[master_tableName].update({
          AvgNet: avg_final,
          StdDev: Number(std_value_final).toFixed(4),
          MinWeight: min_value_final,
          MaxWeight: max_value_final,
          MinPer: minPer_value_final,
          MaxPer: maxPer_value_final,
          NoOfAbove1: noa1,
          NoOfAbove2: noa2,
          NoOfBelow1: nob1,
          NoOfBelow2: nob2,
          TotalWeight: Number(total_weight).toFixed(DP),
          T1NegTol: Number(minLimitT1_avg).toFixed(DP),
          T1PosTol: Number(maxLimitT1_avg).toFixed(DP),
          T2NegTol: Number(minLimitT2_avg).toFixed(DP),
          T2PosTol: Number(maxLimitT2_avg).toFixed(DP),
        }, { where: { RepSerNo: repSerNo } });

        var getUpdatedValue = await models[master_tableName].findAll({ where: { RepSerNo: repSerNo } });

        if (((Number(getUpdatedValue[0].NoOfAbove1) + Number(getUpdatedValue[0].NoOfBelow1)) > Number(getUpdatedValue[0].NMT) || (Number(getUpdatedValue[0].NoOfAbove2) != 0) || Number(getUpdatedValue[0].NoOfBelow2) != 0)) {
          remark = 'Not Complies';
        } else {
          remark = 'Complies';
        }
      }
    }

    await models[master_tableName].update({
      Remark: remark
    }, { where: { RepSerNo: repSerNo } });
    //25/10/2remark3 END
    return remark
  }
  // async saveToCompleteDifferential(intWeighmentNo, cubicalObj, typeValue, tempUserObject, IdsNo, vernierObj, IsBalOrVer = "Balance") {
  //     //update end date and time when sample complete
  //     let now = new Date();
  //     var le;.3
  //     var objProductType = globalData.arrProductTypeArray.find(k => k.idsNo == IdsNo)
  //     const updateIndividualEndTime = ({
  //              BFGCode: cubicalObj.Sys_BFGCode ,
  //            ProductName: cubicalObj.Sys_ProductName ,
  //            PVersion: cubicalObj.Sys_PVersion ,
  //            Version: cubicalObj.Sys_Version ,
  //            BatchNo: cubicalObj.Sys_Batch ,
  //            Idsno: IdsNo},{
  //                where:{
  //                 PrEndDate: date.format(now, 'YYYY-MM-DD') ,
  //                 PrEndTime: date.format(now, 'HH:mm:ss'),
  //                }
  //     })
  //     if (objProductType.productType == 1) {
  //         Object.assign(updateIndividualEndTime,
  //             { str_tableName: 'tbl_tab_master' + intWeighmentNo + '_incomplete' }
  //         );
  //     } else if (objProductType.productType == 2 || objProductType.productType == 4) {
  //         Object.assign(updateIndividualEndTime,
  //             { str_tableName: 'tbl_cap_master' + intWeighmentNo + '_incomplete' }
  //         );
  //     } else if (objProductType.productType == 5) {
  //         Object.assign(updateIndividualEndTime,
  //             { str_tableName: 'tbl_tab_master19_incomplete' }
  //         );
  //     }

  //     //console.log(updateIndividualEndTime);
  //     let updateResult = await models[updateIndividualEndTime].update();
  //     var selectedIds;
  //     var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
  //     if (IPQCObject != undefined) {
  //         selectedIds = IPQCObject.selectedIds;
  //     } else {
  //         selectedIds = IdsNo;
  //     }
  //     const objWeighmentModel = new WeighmentModel();
  //     objWeighmentModel.strProductId = cubicalObj.Sys_BFGCode;
  //     objWeighmentModel.strProductName = cubicalObj.Sys_ProductName;
  //     objWeighmentModel.strProductVersion = cubicalObj.Sys_PVersion;
  //     objWeighmentModel.strVersion = cubicalObj.Sys_Version;
  //     objWeighmentModel.strBatch = cubicalObj.Sys_Batch;
  //     objWeighmentModel.intIdsNo = selectedIds;
  //     let successResult = await individualOperation.saveCompleteData(objWeighmentModel, typeValue, IdsNo);

  //     // if (serverConfig.ProjectName == "RBH" && typeValue == 8) {//Individual empty report always should be within limit
  //     //     successResult = 'LE0'//
  //     // }

  //     // objMonitor.monit({ case: 'LE', idsNo: IdsNo, data: successResult });
  //     // Clear flag for Incomplete remark like (test aborted, balance off, Auto logout);
  //     // if (globalData.arrIncompleteRemark != undefined) {
  //     //     globalData.arrIncompleteRemark = globalData.arrIncompleteRemark.filter(k => k.IdsNo != IdsNo);
  //     // }
  //     // Activity Log for completion of weigghment
  //     var objActivity = {}
  //     // const tempUserObject = globalData.arrUsers.find(k => k.IdsNo === IdsNo);
  //     Object.assign(objActivity,
  //         { strUserId: tempUserObject.UserId },
  //         { strUserName: tempUserObject.UserName },
  //         { activity: 'Weighment completed on IDS' + IdsNo });
  //     // Instrument Usage log for balance start
  //     if (IsBalOrVer == "Vernier") {
  //         objInstrumentUsage.InstrumentUsage('Vernier', IdsNo, 'tbl_instrumentlog_vernier', '', 'completed')
  //     }
  //     else {
  //         objInstrumentUsage.InstrumentUsage('Balance', IdsNo, 'tbl_instrumentlog_balance', '', 'completed')
  //     }

  //     await objActivityLog.ActivityLogEntry(objActivity);
  //     globalData.arrVernierData = globalData.arrVernierData.filter(x => x.IdsNum != IdsNo);

  //     return successResult;
  // }

  precision(a) {
    if (!isFinite(a)) return 0;
    var e = 1,
      p = 0;
    while (Math.round(a * e) / e !== a) {
      e *= 10;
      p++;
    }
    return p;
  }
  async calculateDoubleVal(Nominal, CommingWT, productUnit, balanceunit) {
    if (productUnit != balanceunit) {
      if (balanceunit == "mg" && productUnit == "gm") {
        Nominal = Nominal / 1000;
      } else if (balanceunit == "g" && productUnit == "mg") {
        return true;
      }
      var percent = (80 / 100) * parseFloat(Nominal);
      return CommingWT > parseFloat(Nominal) + percent ? true : false;
    } else {
      var percent = (80 / 100) * parseFloat(Nominal);
      return CommingWT > parseFloat(Nominal) + percent ? true : false;
    }
  }
}

module.exports = Differential;
