const date = require('date-and-time');

const globalData = require('../../global/globalData')
const clsActivityLog = require('../clsActivityLog.model');
const clsInstrumentUsage = require('../clsInstrumentUsageLog');
const clsCommonInsertOpt = require('../Product/clsCommonInsertOperation.model');
const clsMqttSender = require('../Mqtt/mqttSender.class');
const DataBase = require('../../database/clsQueryProcess');
const FormulaFunModel = require('../Product/clsformulaFun.model');
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const clsCommonUseFunction = require('../clsCommonUseFunction');
const PowerBackup = require('../../Utills/powerBackUp/powerbackup');
const models = require('../../../config/dbConnection').models;
const clsCalculation = require('../clsCalculationOperation');
const objcalc = new clsCalculation();
const sequelize = require('../../../config/dbConnection').sequelize;
const moment = require('moment');
const clsPrintOperations = require("../Print/clsPrintOperation")
const printOperations = new clsPrintOperations()

const objActivityLog = new clsActivityLog();
const objInstrumentUsage = new clsInstrumentUsage();
const objCommonInsertOpt = new clsCommonInsertOpt();
const mqttSender = new clsMqttSender();
const database = new DataBase();
const objformulaFun = new FormulaFunModel();
const objCommonUseFunc = new clsCommonUseFunction();
const objPowerBackup = new PowerBackup();

class DiameterModel {

    async processDiameterData(dataObj) {
        try {
            let objActivity = {};
            let maxLimitT1, maxLimitT2, minLimitT2, minLimitT1, strTableName, strDetailTbl;
            const strHmi = dataObj.Hmi;
            const strIdsNo = dataObj.idsNo;
            const menuName = dataObj.menuName;
            let actualWt = dataObj.actualWt;
            let tableName = "tbl_powerbackup";
            let _cubicalData = globalData.arrIdsInfo.find(k => k.idsNo == strIdsNo).cubicalData;
            const objSelMenu = globalData.arrSelectedMenu.find(k => k.idsNo == strIdsNo);
            const DiameterDetail = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi);
            let sample = parseFloat(DiameterDetail.data.noOfSample);
            let batchNo = DiameterDetail.data.Batch;
            var Side = DiameterDetail.data.Side;

            let SelectedIdsNo;
            var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
            if (IPQCObject != undefined) {
                SelectedIdsNo = IPQCObject.selectedIds.Idsno;
            } else {
                SelectedIdsNo = strHmi;
            }

            var reportLimitMsg = "Report Within Limit";
            let tempCounterObj = globalData.arrWeighmentCounter.find(k => k.Hmi == strHmi);
            let tempUserObject = globalData.arrUsers.find(k => k.Hmi === strHmi);
            const sampleRemark = globalData.arrSampleRemarkForAllTest.find(k => k.Hmi == strHmi);

            if (tempCounterObj === undefined) {
                globalData.arrWeighmentCounter.push({
                    'Hmi': strHmi,
                    'counter': 0
                })
            }
            tempCounterObj = globalData.arrWeighmentCounter.find(k => k.Hmi == strHmi);

            switch (menuName) {
                case 'Diameter': {
                    strTableName = "tbl_tab_master6";
                    strDetailTbl = "tbl_tab_detail6";
                    // typeValue = 1;
                    maxLimitT1 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail, 'T1');
                    maxLimitT2 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail);
                    minLimitT2 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail);
                    minLimitT1 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail, 'T1');
                }
                    break;
                default:
                    console.log('unHandled menuName')
                    break;
            }

            let intProductType = objSelMenu.selectedProductDetail.ProductType;
            let __parameterDiameter;
            const __ParamRemark = {
                idsNo: strIdsNo,
                menuName: menuName,
                batchNo: batchNo,
                tableName: strTableName,
            }
            if (sample >= tempCounterObj.counter) {
                tempCounterObj.counter += 1;

                __parameterDiameter = {
                    strTableName: strTableName,
                    strDetailTbl: strDetailTbl,
                    objProductDetails: DiameterDetail.data,
                    uniqueSerialNumber: strIdsNo,
                    strBalId: dataObj.instrumentId,
                    ProtocolData: dataObj.actualWt,
                    ProtocolUnit: dataObj.unit,
                    ProtocolDecPoint: dataObj.decPoint,
                    strHmi: strHmi,
                    seqNoOfWt: tempCounterObj.counter,
                    productType: objSelMenu.selectedProductDetail
                }

                var powerbackupobj = {
                    strTableName: strTableName,
                    strDetailTbl: strDetailTbl,
                    cubicaNo: _cubicalData.Sys_CubicNo,
                    cubicType: _cubicalData.Sys_CubType,
                    cubicSysBFGcode: _cubicalData.Sys_BFGCode,
                    cubicBatch: _cubicalData.Sys_Batch,
                    menuName: menuName,
                    ProductType: objSelMenu.selectedProductDetail.ProductType,
                    Userid: tempUserObject.UserId,
                    idsNo: strIdsNo,
                    Hmi: strHmi,
                    Incomp_RepSerNo: tempCounterObj.counter,
                    ReportType: _cubicalData.Sys_RptType,
                    RecSampleNo: tempCounterObj.counter,
                    SelectedIds: SelectedIdsNo

                }

                let _check_combination = await objPowerBackup._check_combination_pow(objSelMenu, powerbackupobj, tableName);
                if (_check_combination !== undefined) {
                    tempCounterObj.counter = _check_combination.RecSampleNo + 1;
                    __parameterDiameter.seqNoOfWt = tempCounterObj.counter;
                }


                if (tempCounterObj.counter == 1) {

                    var lastInserted_repsrno = await objCommonInsertOpt.insert_Into_Incomplete_Master(__parameterDiameter);
                    powerbackupobj.Incomp_RepSerNo = lastInserted_repsrno.srno;
                    await objPowerBackup.getStatusoFTestForPowerBackup(powerbackupobj);
                    Object.assign(objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { activity: 'Diameter Weighment Started on TSH ' + strHmi });
                    await objActivityLog.ActivityLogEntry(objActivity);
                    await objInstrumentUsage.InstrumentUsage('Vernier', strIdsNo, 'tbl_instrumentlog_vernier', 'Diameter', 'started');
                    await objCommonInsertOpt.InsertIncompleteRemarkEntry(__ParamRemark);


                }
                //insert data into detail table
                powerbackupobj.RecSampleNo = tempCounterObj.counter;
                console.log(tempCounterObj.counter);
                let decimal = await objCommonInsertOpt.insert_Into_Incomplete_Detail(__parameterDiameter);
                powerbackupobj.Incomp_RepSerNo = decimal.repSerNo;
                await objPowerBackup.getStatusoFTestForPowerBackup(powerbackupobj);
                await objPowerBackup.updateTestCount(objSelMenu, powerbackupobj, tableName);
                var updateData = await objcalc.calculation_operation(__parameterDiameter, decimal.repSerNo);
                let sampleNo = tempCounterObj.counter
                let limitObjResp = await objCommonUseFunc.SendCommon({ strHmi, actualWt, minLimitT2, maxLimitT2, minLimitT1, maxLimitT1, menuName, sampleNo })
                let color = limitObjResp.Color;
                let limit = limitObjResp.limit;

                mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${tempCounterObj.counter}:${Number(actualWt).toFixed(2)} ${dataObj.unit}:${color}`);
                mqttSender.sendData(strHmi, limit);


                if (sample == tempCounterObj.counter) {
                    //move data from incomplete to complete 
                    //remove outOfLimit Flag
                    //check nmt range
                    var updateData = await objcalc.calculation_operation(__parameterDiameter, decimal.repSerNo);
                    // if (Side == 'RHS') {
                    //     await objCommonInsertOpt.saveCompleteData(__parameterDiameter, 6, Side);

                    //     await this.updateEndDate(strIdsNo, strHmi, strTableName);
                    // } else {
                    // if (_cubicalData.Sys_RotaryType == "Single") {
                    var response = await objCommonInsertOpt.saveCompleteData(__parameterDiameter, 6);

                    // await this.updateEndDate(strIdsNo, strHmi, strTableName);
                    // }
                    // }

                    // if (Side == 'LHS') {
                    //     mqttSender.sendData(strHmi, `${mqttProtocol.SideChange}: ${Side} And ${mqttProtocol.SideChanges} RHS`);
                    // }
                    if (updateData == "Complies") {
                        var printObj = {
                            RepSerNo: response.RepSerNo,
                            Side: Side,
                            batchNo: _cubicalData.Sys_Batch,
                            cubicleType: _cubicalData.Sys_CubType,
                            int_ReportFormat: 1,
                            printNo: 0,
                            recordFrom: "Current",
                            reportOption: menuName,
                            reportType: "Complete",
                            testType: "Regular",
                            userId: tempUserObject.UserId,
                            username: tempUserObject.UserName,
                            str_url: objSelMenu.selectedProductDetail.ProductType === 1 ? "Tablet" : "Capsule"

                        }

                        await printOperations.callViewTabReport(printObj, intProductType, strHmi)

                    }
                    const _deletePowerbackup = await models.tbl_powerbackup.destroy({
                        where: {
                            Idsno: strHmi,
                            Sys_Batch: _cubicalData.Sys_Batch,
                            WeighmentName: menuName
                        }
                    });

                    if (updateData == "Not Complies") {
                        reportLimitMsg = "Report Out Of Limit"
                    }
                    else {
                        reportLimitMsg = "Report Within Limit"
                    }


                    Object.assign(objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { activity: 'Diameter Weighment Completed on TSH ' + strHmi });
                    await objActivityLog.ActivityLogEntry(objActivity);
                    await objInstrumentUsage.InstrumentUsage('Vernier', strIdsNo, 'tbl_instrumentlog_vernier', '', 'completed');
                    console.log(tempCounterObj.counter);
                    //for loop for checking if sample is between t2 and t1 
                    //and give report accordingly
                    globalData.arrWeighmentCounter.findIndex(k => k.Hmi == strHmi) == -1 ?
                        globalData.arrWeighmentCounter :
                        globalData.arrWeighmentCounter.splice(globalData.arrWeighmentCounter.findIndex(k => k.Hmi == strHmi), 1);

                    (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus :
                        globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);

                    (globalData.arrOutFlagForTest.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrOutFlagForTest :
                        globalData.arrOutFlagForTest.splice(globalData.arrOutFlagForTest.findIndex((element) => element.Hmi === strHmi), 1);
                    //test splice if rotarty is not double
                    globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
                        globalData.arrSelectedMenu :
                        globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);
                    // return mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}${menuName} test Completed`);
                    mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}${reportLimitMsg}`);
                 
                    return;

                }
            }


        } catch (error) {
            throw new Error(error);
        }
    }

    async updateEndDate(strIdsNo, strHmi, strTableName) {
        try {
            const cubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
            const updateThicknessEndTime = await models[strTableName].update({
                PrEndDate: moment().format('YYYY-MM-DD'),
                PrEndTime: moment().format('HH:mm:ss')
            }, {
                where: {
                    BFGCode: cubicalObj.Sys_BFGCode,
                    ProductName: cubicalObj.Sys_ProductName,
                    PVersion: cubicalObj.Sys_PVersion,
                    Version: cubicalObj.Sys_Version,
                    BatchNo: cubicalObj.Sys_Batch,
                    Idsno: strHmi,
                }
            })

        } catch (error) {
            throw new Error(error)
        }
    }
}

module.exports = DiameterModel;