
//modules
const ClearGlobalArrayModel = require('../clearGlobalArrays.model');
const classHmi = require('../hmiDetail.model');
const mqttProtocols = require('../../global/GLOBAL_NOMENCLATURE');
const loggers = require('../winstonLogger');
const clsBalanceParsing = require('../InstrumentParsings/clsBalanceParsing');
const clsHardnessParsing = require('../InstrumentParsings/clsHardnessParsing');
const GLOBAL_NOMENCLATURE = require('../../global/GLOBAL_NOMENCLATURE');
const clsMqttSender = require('../Mqtt/mqttSender.class')
const clsVernierParsing = require('../InstrumentParsings/clsVernierParsing')
const clsFribilityParsing = require('../InstrumentParsings/clsFriabilityParsing');
const clsDTParsing = require('../InstrumentParsings/clsDTParsing');
const clsMoistureAnalyserParsing = require('../InstrumentParsings/clsMoistureAnalyserParsing');
const clsTappedDensity = require('../InstrumentParsings/clsTappedDensityParsing');
const clsPercentageFine = require('../Test/clsPerFine.model');
const globalData = require('../../global/globalData')
const serverConfig = require('../../global/serverConfig')
const models = require('../../../config/dbConnection').models;
const sequelize = require('../../../config/dbConnection').sequelize;

//instances
const objClearArray = new ClearGlobalArrayModel();
const objHmi = new classHmi();
const objBalanceParsing = new clsBalanceParsing();
const objHardnessParsing = new clsHardnessParsing();
const mqttSender = new clsMqttSender();
const objVernierParsing = new clsVernierParsing();
const objFriabilityParsing = new clsFribilityParsing();
const objDTParsing = new clsDTParsing();
const objMoistureParsing = new clsMoistureAnalyserParsing();
const objTappedDensity = new clsTappedDensity();
const { Op } = require('sequelize');



class MQTTHandler {

    precision(a) {
        if (!isFinite(a)) return 0;
        var e = 1, p = 0;
        while (Math.round(a * e) / e !== a) { e *= 10; p++; }
        return p;
    }

    //
    async handleProtocol(str_Protocol, strResberryPi) {
        try {


            //mqttSender.sendData(104,"data")
            loggers.MqttProtocolLogger.info(`protocol : ${str_Protocol} recieved from device ${strResberryPi}`);


            const unWantedProtocols = [
                "ACK_DisableCom".toLowerCase(),
                "ACK_EnableCom".toLowerCase(),
                "Hamster Pro20 not found".toLowerCase(),
                "ACK_Disconnected".toLowerCase(),
                'ack_',
                'nack_'
            ]
            //for MQTT protocol Serial number logic
            // if(str_Protocol.includes("_ack"))
            // {
            //     arrAckProto = str_Protocol.split('_');
            //     globalData.arrMQTTUnsendMsg = globalData.arrMQTTUnsendMsg.filter(item => item.id == arrAckProto[0]);
            // }



            if (str_Protocol == "" ||
                unWantedProtocols.some(el => str_Protocol.toLowerCase().includes(el) || str_Protocol.toLowerCase().startsWith(el))) {
                return;
            }

            if (str_Protocol.toLowerCase() == "Disconnected".toLowerCase()) {
                //create a function that will clear all details
                //await objClearArray.clearDetails(strResberryPi);
                return;
            }

            let strHmi = await objHmi.getHmiNoFromResbPi(strResberryPi);

            // loggers.IdsActivityLogger(strHmi).info(`Protocol:${str_Protocol} from device ${strResberryPi} having alias ${strHmi}`)

            let str_ProtocolData = str_Protocol;
            let ProtocolName = str_ProtocolData.split(":")[0];
            let ProtocolPortNo = str_ProtocolData.split(":")[1];
            // let arrPortDetailForStart1 = await objHmi.idsPortSetting(strHmi);
            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
            // if (IPQCObject != undefined) {
            // strHmi = IPQCObject.selectedIds.Idsno;
            // } else {
            //     strHmi = strHmi;
            // }

            const arrCurrentOperation = globalData.arrCurrentOperationStatus.find(k => k.Hmi == strHmi);
            const arrCalibInProcess = globalData.arrcalibType.find(k => k.Hmi == strHmi);
            if (arrCurrentOperation != undefined) {
                var arrSelectedMenu = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);
                var intPortNo1 = arrSelectedMenu.portNo;
                var strInstrumentType = arrSelectedMenu.InstrumentType;
                var strInstrumentId = arrSelectedMenu.instrumentId;
            } else if (arrCalibInProcess != undefined) {
                let hmiDetails = globalData.arrSelectedBalWithHmi.find(k => k.Hmi == strHmi);
                var intPortNo1 = hmiDetails.portNo;
                var strInstrumentType = hmiDetails.InstrumentType;
                var strInstrumentId = hmiDetails.selectedBal;
            } else {
                console.log('dont proceedd further')
                return
            }

            if (intPortNo1 != ProtocolPortNo) {
                return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid Port Received`)
            }

            //         if(arrSelectedMenu != undefined){
            //         if(arrSelectedMenu.menuName == 'DT'){
            //               var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
            //         if (IPQCObject != undefined) {
            //         strHmi = IPQCObject.selectedIds.Idsno;
            //         }
            //         var dtidChange = await models.tbl_cubical.findAll({
            //             where:{
            //                 Sys_IDSNo:strHmi
            //             }
            //         })
            //         strInstrumentId = dtidChange[0].Sys_DTID
            //         var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.selectedIds.Idsno == strHmi);
            //         if (IPQCObject != undefined) {
            //         strHmi = IPQCObject.idsNo;
            //         }
            //     }
            // }

            //         }
            // let intPortNo1 = arrPortDetailForStart1.Sys_PortNo;
            // let strInstrumentType = arrPortDetailForStart1.Instrument_type;
            // let strInstrumentId = arrPortDetailForStart1.Instrument_id;
            // if (intPortNo1 != ProtocolPortNo) {
            //     loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}${strInstrumentType} ${strInstrumentId} 
            //     connected with Port ${intPortNo1} must be used sended to device ${strHmi}`)
            //     return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}${strInstrumentType} ${strInstrumentId} connected with Port ${intPortNo1} must be used`)
            // }
            
            let result;
            const __paramObj = {
                strHmi: strHmi,
                str_Protocol: str_ProtocolData,
                InstrumentId: strInstrumentId,
                InstrumentType: strInstrumentType,
                ProtocolPortNo: ProtocolPortNo,
                strResberryPi: strResberryPi,
                ProtocolName: ProtocolName
            }

            const objSelMenu = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);
            if (objSelMenu != undefined) {
                let strSelectedMenuName = objSelMenu.menuName;
                __paramObj.menuName = strSelectedMenuName;
            }
            
            if (ProtocolName.toLowerCase() === GLOBAL_NOMENCLATURE.ComRead.toLowerCase()) {
                switch (strInstrumentType) {
                    case GLOBAL_NOMENCLATURE.Balance:
                    case GLOBAL_NOMENCLATURE.IPCBalance:
                        {
                            result = await objBalanceParsing.parsingBalanceData(__paramObj);
                            return result;
                        };
                    case GLOBAL_NOMENCLATURE.TabletTester:
                    case GLOBAL_NOMENCLATURE.Hardness: {
                        result = await objHardnessParsing.parseDataAccordingToModelHardness(__paramObj);
                        return result;
                    };
                    case GLOBAL_NOMENCLATURE.Vernier: {
                        result = await objVernierParsing.parsingVernierData(__paramObj);
                        return result;
                    };
                    case GLOBAL_NOMENCLATURE.DT: {
                        result = await objDTParsing.parsingDTData(__paramObj);
                        return result;
                    };
                    case (GLOBAL_NOMENCLATURE.FriabilatorMenu): {
                        if (GLOBAL_NOMENCLATURE.FriabilatorMenu == "FRIABILATOR") {
                            result = await objFriabilityParsing.parsingFriabilityData(__paramObj);
                            return result;
                        } else {
                            result = await objFriabilityParsing.parsingFriabilityBFBO(__paramObj);
                            return result;
                        }

                    };
                    case "LOD":
                    case GLOBAL_NOMENCLATURE.MoistureAnalyzer: {
                        result = await objMoistureParsing.parseMoistureAnalyserData(__paramObj);
                        return result;
                    };
                    case GLOBAL_NOMENCLATURE.TappedDensity: {
                        result = await objTappedDensity.parsingTappedDensityData(__paramObj);
                        return result;
                    };
                    case GLOBAL_NOMENCLATURE.PercentageFine: {
                        result = await objBalanceParsing.parsingBalanceData(__paramObj);
                        return result;
                    };
                    case GLOBAL_NOMENCLATURE.ParticalSizing: {
                        result = await objBalanceParsing.parsingBalanceData(__paramObj);
                        return result;
                    };

                }
            }
        } catch (error) {
            loggers.MqttProtocolLogger.error(`${error} recieved in calibDecider function from device : ${strResberryPi}`)
            throw new Error(error)
        }

    }

    async GroupAlert(str_Protocol, strResberryPi) {

        let cubicdata = await models.tbl_cubical.findAll({
            where: {
                Sys_rpi: strResberryPi
            }
        })
 
        if (str_Protocol == "Group Flag Set to 0") {
            let updateCubicAlertVal = await models.tbl_batches.update({
                grpflag: 0
            },
                {
                    where: {
                        Batch: cubicdata[0].Sys_Batch,
                        [Op.or]: [{ Status: "S" }, { Status: "R" }],
                    }

                });
            return;
        }
    }
}

module.exports = MQTTHandler;