const date = require('date-and-time')
const objMoment = require('moment');
const requestIp = require('request-ip');
// const mysql = require('mysql2');
const sha1 = require('sha1');
var Comman = require('../Calibration/clsCalibCommonFunction.model');
const serverConfig = require('../../../../IncrencyV4CP10GConfig.json')
var comman = new Comman();
const GLOBAL_NOMENCLATURE = require('../../global/GLOBAL_NOMENCLATURE')
const Database = require('../../database/clsQueryProcess');
const timeZone = require('../../middleware/setTimeZone');
const clsQueryBuilder = require('../../database/clsQueryTransactProcess');
const globalData = require('../../global/globalData')
const clearArrModel = require('../clearGlobalArrays.model');
const clsActivityLog = require('../clsActivityLog.model');
const dbCon = require('../../../INTERFACE/global/dbCon');
const dbConfig = require('../../global/serverConfig');
const loggers = require('../winstonLogger');
const clsCommonOperation = require('../Product/clsCommonInsertOperation.model');
const clsCalibCommonOperation = require('../Calibration/clsCalibCommonFunction.model');
const clsHmi = require('../hmiDetail.model');
const { models } = require('../../../config/dbConnection');
const powerbckup = require('../../Utills/powerBackUp/powerbackup');
const ClearGlobalArrayModel = require('../clearGlobalArrays.model');
const sequelize = require('../../../config/dbConnection').sequelize;
const { QueryTypes } = require('sequelize');
const clsMonit = require('../MonitorSocket/clsMonitSocket')
const objMonit = new clsMonit();
const axios = require("axios");
const moment = require('moment');
const momentObj = require('moment');
const sort = require("../../model/Calibration/checkForPendingCalib");
const CopyObjects = require("../../model/Calibration/clsCopyObject.model");
const copyObjects = new CopyObjects();

const objPowerBackup = new powerbckup();
const database = new Database();
const ObjQueryBuilder = new clsQueryBuilder();
const objActivityLog = new clsActivityLog();
const objClearArr = new clearArrModel();
const objCommonOperation = new clsCommonOperation();
const objCalibCommonOperation = new clsCalibCommonOperation();
const objHmi = new clsHmi();
const objClearArray = new ClearGlobalArrayModel();

class LoginModal {

  async getIDSNo(req) {
    try {

      var rpiId = req.body.rpiId

      var FullIp = requestIp.getClientIp(req);

      var data = await models.tbl_rpi.findAll({
        where: {
          RPIID: rpiId
        }
      })

      if (data.length == 0 || data == undefined)
        return { status: 'fail', Message: 'TSH Not Configured' };

      let arrCubicInfo = await models.tbl_cubical.findAll({
        where: {
          Sys_rpi: rpiId
        }
      })
      if (arrCubicInfo[0] == undefined) {
        return { 'status': "Fail", message: "TSH not configured" };
      }


      var strHmi = data[0].IDSNo;

      let arrusers = globalData.arrUsers.find(k => k.Hmi == strHmi);

      if (arrusers != undefined) {

        var userId = arrusers.UserId;

        var userName = arrusers.UserName;

        var Hmi = strHmi
        console.log("65-login.model.js -> blank source and active 0 -> userId", userId);
        let lastLoginDate = await timeZone.convertDateTime(new Date())

        await models.tbl_users.update({
          active: 0,
          source: '',
          lstActvtyTime: lastLoginDate,
          HostName: strHmi
        }, {
          where: {
            UserID: userId
          }
        })

        await models.tbl_activity_log.create({
          'dt': momentObj().format('YYYY-MM-DD'),
          'tm': momentObj().format('HH:mm:ss'),
          'userid': userId,
          'username': userName,
          'activity': `Power On/Off on TSH ${Hmi}`
        });
        let CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi)
        if (CurrentCubicalObj != undefined) {
          CurrentCubicalObj = CurrentCubicalObj.cubicalData;

          await objCalibCommonOperation.releaseCalibrationInProcess(CurrentCubicalObj.Sys_CubicNo)
          var weighmentStatusObj = globalData.weighmentstatus.find(k => k.strHmi == strHmi);
          if (weighmentStatusObj != undefined) {
            //    CurrentCubicalObj = weighmentStatusObj
            CurrentCubicalObj.Sys_CubicNo = weighmentStatusObj.status
          } else {
            CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData
          }
          if (weighmentStatusObj != undefined) {
            for (let i = 0; i <= globalData.weighmentstatus.length; i++) {
              weighmentStatusObj = globalData.weighmentstatus.find(k => k.strHmi == strHmi)
              if (weighmentStatusObj != undefined) {
                await models.tbl_system_weighingstatus.update({
                  Status: 0,
                  BatchNo: "NULL",
                  CubType: "NULL"
                }, {
                  where: {
                    CubicleNo: weighmentStatusObj.status,
                  }
                })
                globalData.weighmentstatus.findIndex(k => k.strHmi == strHmi) == -1 ? globalData.weighmentstatus : globalData.weighmentstatus.splice(globalData.weighmentstatus.findIndex(k => k.strHmi == strHmi), 1);
              }
            }
          }
          await this.UnlockedWeighingStatus(CurrentCubicalObj.Sys_CubicNo, CurrentCubicalObj.Sys_Batch)
        }

        var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);

        if (IPQCObject != undefined) {
          var cubicalO = await models.tbl_cubical.findAll({
            where: {
              Sys_IDSNo: strHmi
            }
          })
          cubicalO = cubicalO.pop()
          await this.UnlockedWeighingStatus(cubicalO.Sys_CubicNo)
          await objCalibCommonOperation.releaseCalibrationInProcess(cubicalO.Sys_CubicNo)
        }

      }

      return { status: 'success', result: data };

    } catch (error) {
      console.log(error)
    }
  }

  async communicationOff(val) {
    try {
      var Hmi = val.Hmi
      var userId = val.userId
      var userName = val.userName
      var newDate = val.newDate
      var newTime = val.newTime

      await models.tbl_activity_log.create({
        'dt': newDate,
        'tm': newTime,
        'userid': userId,
        'username': userName,
        'activity': `Communication Off on TSH ${Hmi}`
      });

      return { status: 'success', result: "Validated" };

    } catch (error) {
      console.log(error)
    }
  }

  async loginApi(value) {
    var userId = value.userId;
    var userName = value.userName;
    var userPass = value.userPass;
    var rpi = value.resbpi;
    var strHmi = value.Hmi;
    let responseObj = {};
    var source = 'Hardware';


    var user = await models.tbl_users.findAll({
      where: { userID: userId, }
    }) //To check if user have put correct user id 
    var getParameter = await this.getParameterData();
    globalData.arrsAllParameters.push(getParameter);
    var now = new Date();
    // var ClientIp = Ip;
    var TSH_config = await models.tbl_cubical.findAll({ where: { Sys_IDSNo: strHmi } });
    if (TSH_config.length == 0) {
      return { result: "TSH not configured", status: "fail" }

    }
    var ClientIp;
    if (ClientIp === undefined) {
      ClientIp = '127.0.0.1';
    } else {
      ClientIp = ClientIp;
    }
    var ip = ClientIp;
    if (serverConfig.isLDAP == true) {

      var strReturnProtocol = await this.validateUserLDAP(userId, userPass, source, ip, rpi, strHmi)

      if (strReturnProtocol.status == "success") {

        let tmpUserobj = globalData.arrUsers.find(k => k.Hmi == strHmi);

        await objMonit.monit({ case: 'Login', Hmi: strHmi, data: tmpUserobj });

      }
      return strReturnProtocol;
    }
    if (user.length == 0) {

      return { status: "Fail", result: "Incorrect User ID or Password" }
    }
    // var userActive = await models.tbl_users.update({ active: 1 }, { where: { userID: userId } })
    if (user[0] != undefined) {
      var data = user[0];
      var userName = user[0].UserInitials;
      if (data.active == 1) { //active user msg 
        if (data.source == "Hardware") {
          Object.assign(responseObj, { status: 'Fail' }, { result: `User is Already Active On TSH` });
          return responseObj;
        } else {
          Object.assign(responseObj, { status: 'Fail' }, { result: 'User is Already Active On Software' }, { userName: userName });
          return responseObj;
        }
      } else if ((data.locked == 1) && (data.Role != "SuperAdmin") && (data.userType != 1)) {
        Object.assign(responseObj, { status: 'Fail' }, { result: 'User Locked, Please contact Admin' }, { userName: userName })
        return responseObj;
      } else if (data.realPassword !== userPass) {
        const auditUnauthorizedUser = await models.tbl_audit_unauthorized_user.create({
          dt: date.format(now, 'YYYY-MM-DD'),
          tm: date.format(now, 'HH:mm:ss'),
          userid: userId,
          username: user[0].UserName,
          Host: ClientIp
        });
        var addLoginAttampt = await this.addLoginAttamptValue(userId, "Hardware", userPass, ClientIp); //Store Procedure 
        if (addLoginAttampt == 'success') {
          addLoginAttampt = "Unauthorized user "
        }
        Object.assign(responseObj, { status: 'Fail' }, { result: addLoginAttampt }, { userName: userName })
        return responseObj;

      } else if ((data.Status == 1) && (data.Role != "SuperAdmin") && (data.userType != 1)) {
        Object.assign(responseObj, { status: 'Fail' }, { result: 'User Temporary Disabled, Contact Admin' }, { userName: userName })
        return responseObj;
      } else if ((data.Status == 2) && (data.Role != "SuperAdmin") && (data.userType != 1)) {
        Object.assign(responseObj, { status: 'Fail' }, { result: 'User Permanent Disabled, Contact Admin' }, { userName: userName })
        return responseObj;
      } else if ((data.Status == 4) && (data.Role != "SuperAdmin") && (data.userType != 1)) {
        Object.assign(responseObj, { status: 'Fail' }, { result: 'User Auto Disabled, Change Password' }, { userName: userName })
        return responseObj;
      } else if ((data.PwdExpStauts != 1) && (data.Status == 6) && (data.Role != "SuperAdmin") && (data.userType != 1)) {
        Object.assign(responseObj, { status: 'Fail' }, { result: 'User Locked, Please contact Admin' }, { userName: userName })
        return responseObj;
      } else if ((data.PwdExpStauts == 1) && (data.Status == 6) && (data.Role != "SuperAdmin") && (data.userType != 1)) {
        Object.assign(responseObj, { status: 'Fail' }, { result: 'Suspicious Activity Found, Contact Admin' }, { userName: userName })
        return responseObj;
      } else if ((data.PwdChg == 1) && (data.Role != "SuperAdmin") && (data.userType != 1)) {
        Object.assign(responseObj, { status: 'Fail' }, { result: 'Please Change Your Password' }, { userName: userName })
        return responseObj;
      } else if ((data.PwdExpStauts == 1) && (data.Role != "SuperAdmin") && (data.userType != 1)) {
        Object.assign(responseObj, { status: 'Fail' }, { result: 'Password Expired, Please Change Your Password' }, { userName: userName })
        return responseObj;
      } else if ((data.Role != "SuperAdmin") && (data.userType != 1)) {
        var getParameter = await this.getParameterData();

      } else {
        var getUserDetailData = await this.checkIfUserDataExist(userId, userPass, strHmi, userName);
        let objActivity = {};
        var tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
        var objUpdateLoginData = await models.tbl_users.update({
          active: 1,
          HostName: ip,
          source: 'Hardware',
          LastLoginDt: moment().format('YYYY-MM-DD'),
          lstActvtyTime: moment().format('YYYY-MM-DD HH:mm:ss')
        }, { where: { userID: userId } })

        Object.assign(objActivity,
          { strUserId: tempUserObject.UserId },
          { strUserName: tempUserObject.UserName },
          { activity: 'Logged in on TSH' + " " + strHmi }
        );
        await objActivityLog.ActivityLogEntry(objActivity);
        getUserDetailData.result.timeOut = getParameter.tbl_config_TimeoutPeriod;

      }
      var getUserDetailData = await this.checkIfUserDataExist(userId, userPass, strHmi, userName);
      if (Object.keys(getUserDetailData).length != 0) {
        let objActivity = {};
        var tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);

        var objUpdateLoginData = await models.tbl_users.update({
          active: 1,
          HostName: ip,
          source: 'Hardware',
          LastLoginDt: date.format(new Date(), 'YYYY-MM-DD'),
          lstActvtyTime: date.format(new Date(), 'YYYY-MM-DD HH:mm:ss')

        },
          { where: { UserID: userId } });

        Object.assign(objActivity,
          { strUserId: tempUserObject.UserId },
          { strUserName: tempUserObject.UserInitials },
          { activity: 'Logged in on TSH' + " " + strHmi }
        );
        await objActivityLog.ActivityLogEntry(objActivity);
      }
      let timeout = await models.tbl_setallparameter.findAll();
      timeout = timeout[0].tbl_config_TimeoutPeriod;
      getUserDetailData.result.timeOut = timeout;
      return getUserDetailData;
      // }
    } else {
      console.log("User not Valid");
      return { status: "Fail", result: "Validate User on Software And Try Again" }
    }
  }

  async userManagement(userId, userPass, source, ip, time, dates) {
    try {
      let storedProcedureQuery = `CALL userManagement('${userId}','${userPass}','${source}','${ip}',@message,@userName);SELECT @message,@userName;`;
      var result = await sequelize.query(storedProcedureQuery, { type: QueryTypes.SELECT });
      Object.assign(result, { time: time, date: dates })
      return result;
    } catch (error) {
      console.log("Error : ", error);
    }
  }
  async addLoginAttamptValue(userId, source, userPass, ClientIp) {
    try {
      var userManagementData = await this.userManagement(userId, source, userPass, ClientIp);
      var message = userManagementData[1][0]['@message'];
      return message;
    } catch (error) {
      return error;
    }
  }

  async checkIfUserDataExist(userId, userPass, strHmi) {
    try {
      var responseObj = {};
      const selectUserObj = await models.tbl_users.findAll({
        where: { UserID: userId, realPassword: userPass }
      })

      var result = selectUserObj;
      if (result[0] != undefined) {
        let data = [];
        data = result[0];
        const roleName = data.Role;
        var userName = data.UserInitials;
        let allRoleRights = [], allSplRights = [], allRemoveRights = [];
        var roleRights = await this.roleRight(roleName);
        var splRights = await this.splRight(userId);
        var removeRights = await this.removeRight(userId);
        for (let i = 0; i < roleRights.length; i++) {
          allRoleRights.push(roleRights[i].role_rights)
        }
        for (let i = 0; i < splRights.length; i++) {
          allSplRights.push(splRights[i].spl_right)
        }
        for (let i = 0; i < removeRights.length; i++) {
          allRemoveRights.push(removeRights[i].removed_right)
        }

        var tmpUserobj = globalData.arrUsers.find(k => k.Hmi == strHmi);
        if (tmpUserobj == undefined) {
          globalData.arrUsers.push({
            Hmi: strHmi,
            UserId: userId,
            UserName: userName,
            UserPass: userPass,
          });
        } else {
          tmpUserobj.UserId = userId;
          tmpUserobj.UserName = userName;
          tmpUserobj.UserPass = userPass;
        }
        await this.checkForRights(strHmi, userId);

        const userCridentialDetail = {
          UserID: data.UserID,
          UserName: data.UserName,
          realPassword: data.realPassword,
        }

        Object.assign(responseObj, { status: 'success' }, { result: userCridentialDetail })
        // Object.assign(data[0], { rights: allRoleRights }, { splRights: allSplRights }, { removeRights: allRemoveRights })
        // Object.assign(responseObj, { status: 'success' }, { result: data[0] }, { userName: userName })
        return responseObj;
      } else {
        return false;
      }

    } catch (error) {
      return error;
    }
  }

  async roleRight(roleName) {
    var role = await models.tbl_role.findAll({
      where: { role_name: roleName }
    })
    return role;
    //     return dbCon.execute("SELECT `role_rights` FROM `tbl_role` WHERE `role_name` = ?", [roleName]);
  }

  async splRight(userId) {
    var right = await models.tbl_rights_special.findAll({ where: { userid: userId } })
    return right;
    // return dbCon.execute("SELECT `spl_right` FROM `tbl_rights_special` WHERE `userid`=?", [userId]);
  }

  async removeRight(userId) {
    var remove_right = await models.tbl_rights_removed.findAll({ where: { userid: userId } })
    return remove_right;
    // return dbCon.execute("SELECT `removed_right` FROM `tbl_rights_removed` WHERE `userid`=?", [userId]);
  }
  async getParameterData() {
    try {
      const parameterObj = await models.tbl_setallparameter.findAll({
        where: {
          config_id: 1
        }
      })
      if (parameterObj.length > 0) {
        var data = parameterObj[0];
        return data;
      } else {
        return false;
      }
    } catch (error) {
      return error;
    }
  }

  async checkForRights(strHmi, strUserId) {
    try {
      var arr_rights = [];
      let selectRole = await models.tbl_users.findAll({
        where: {
          UserID: strUserId
        }
      })
      let roleResult = selectRole;
      let roleName = roleResult[0].Role;
      // For role Rights
      let selectRights = await models.tbl_role.findAll({
        where: {
          role_name: roleName,
          locked: 0
        }
      })

      let roleRights = selectRights;
      // arr_rights = arr_rights.concat(roleRights[0]).map(k => k.role_rights);
      arr_rights = arr_rights.concat(roleRights).map(k => k.role_rights);
      // For special rights
      let selectSpecialRights = await models.tbl_rights_special.findAll({
        where: {
          userid: strUserId,

        }
      })

      let specialRights = selectSpecialRights;
      let tempSplArr = specialRights.map(k => k.spl_right)
      arr_rights = arr_rights.concat(tempSplArr);
      // For remove rights
      let selectRemoveRights = await models.tbl_rights_removed.findAll({
        where: {
          userid: strUserId,

        }
      })
      let removeRights = selectRemoveRights;
      let tempRmvArr = removeRights.map(k => k.removed_right);
      // arr_rights = arr_rights.filter(
      //     item => tempRmvArr.indexOf(item) < 0
      // );
      let tempRightObj = globalData.arrUserRights.find(t => t.Hmi == strHmi);
      if (tempRightObj == undefined) {
        globalData.arrUserRights.push({
          Hmi: strHmi,
          rights: arr_rights,
          splRights: specialRights,
          removeRights: tempRmvArr
        });
      } else {
        tempRightObj.rights = arr_rights;
        tempRightObj.splRight = specialRights;
        tempRightObj.removeRight = tempRmvArr;

      }
      return 1;
    } catch (error) {
      throw new Error(error)
    }
  }

  async logout(value) {

    try {

      var strHmi = value.Hmi;
      var userName = value.userName;
      var userId = value.userId;
      var autoLogout = value.autoLogout;

      // update monit data about Logout operaion and clear weightment status

      // var cubicleObj = globalData.arrIdsInfo.find(k => k.idsNo == strHmi)
      // var cubicleNo = cubicleObj.cubicalData.Sys_CubicNo

      await models.tbl_cubical.update({
        Sys_WeighmentInProcess: 0,
        Sys_CalibInProcess: 0
      }, { where: { Sys_IDSNo: strHmi } })
      var objUpdateLoginData = await models.tbl_users.update({
        active: 0,
        HostName: '',
        source: '',
        lstActvtyTime: momentObj().format('YYYY-MM-DD HH:mm:ss')
      }, {
        where: {
          UserId: userId
        }
      })
      objUpdateLoginData;

      var msg = '';
      (autoLogout) ? msg = `Auto Logged out from TSH : ${strHmi}` : msg = `Logged out from TSH : ${strHmi}`

      await models.tbl_activity_log.create({
        dt: momentObj().format('YYYY-MM-DD'),
        tm: momentObj().format('HH:mm:ss'),
        userid: userId,
        username: userName,
        activity: msg
      })

      await models.tbl_users.update(
        { active: 0 }, {
        where: {
          UserID: userId
        }
      })
      let CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi)
      if (CurrentCubicalObj != undefined) {
        CurrentCubicalObj = CurrentCubicalObj.cubicalData;

        await objCalibCommonOperation.releaseCalibrationInProcess(CurrentCubicalObj.Sys_CubicNo)
        var weighmentStatusObj = globalData.weighmentstatus.find(k => k.strHmi == strHmi);
        if (weighmentStatusObj != undefined) {
          CurrentCubicalObj.Sys_CubicNo = weighmentStatusObj.status
        } else {
          CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData
        }
        if (weighmentStatusObj != undefined) {
          for (let i = 0; i <= globalData.weighmentstatus.length; i++) {
            weighmentStatusObj = globalData.weighmentstatus.find(k => k.strHmi == strHmi)
            if (weighmentStatusObj != undefined) {
              await models.tbl_system_weighingstatus.update({
                Status: 0,
                BatchNo: "NULL",
                CubType: "NULL"
              }, {
                where: {
                  CubicleNo: weighmentStatusObj.status,
                }
              })
              globalData.weighmentstatus.findIndex(k => k.strHmi == strHmi) == -1 ? globalData.weighmentstatus : globalData.weighmentstatus.splice(globalData.weighmentstatus.findIndex(k => k.strHmi == strHmi), 1);
            }
          }
        }
        await this.UnlockedWeighingStatus(CurrentCubicalObj.Sys_CubicNo)
      }
      var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);

      if (IPQCObject != undefined) {
        var cubicalO = await models.tbl_cubical.findAll({
          where: {
            Sys_IDSNo: strHmi
          }
        })
        cubicalO = cubicalO.pop()
        await this.UnlockedWeighingStatus(cubicalO.Sys_CubicNo)
        await objCalibCommonOperation.releaseCalibrationInProcess(cubicalO.Sys_CubicNo)
      }


      var result = { status: "success", message: 'User logout Successfully.' }
      await objClearArray.clearDetails(strHmi);
      await objMonit.monit({ case: 'Logout', Hmi: strHmi });
      console.log(`${userName} logout Successfully from TSH ${strHmi}`)
      return result;
    }
    catch (error) {
      console.log(error)
      throw new Error(error);
    }
  }

  // async logOut(value) {
  //     try {
  //         console.log("Logout hits 1");
  //         let strUserId = value.userId;
  //         let strUserName = value.userName;
  //         let autoLogout = value.autoLogout;
  //         let mqttConnectionLost = value.mqttConnectionLost
  //         //take hmi from value
  //         let Hmi = value.Hmi;
  //         let dt = new Date();
  //         let now = new Date();
  //         let responseObj = {};
  //         const objTranactionQry = [];
  //         let lastLoginDate = timeZone.convertDateTime(dt)
  //         const logOutUser = await models.tbl_users.update({
  //             active: 0,
  //             source: '',
  //             lstActvtyTime: lastLoginDate,
  //             HostName: ''
  //         }, {
  //             where: {
  //                 UserID: strUserId

  //             }
  //         })
  //         console.log("256-login.model.js -> blank source and active 0 -> userId", strUserId);

  //         let activity = ""
  //         if (autoLogout) {
  //             activity = `Time Out!! Auto`
  //         }
  //         await models.tbl_activity_log.create({
  //             'dt': date.format(now, 'YYYY-MM-DD'),
  //             'tm': date.format(now, 'HH:mm:ss'),
  //             'userid': strUserId,
  //             'username': strUserName,
  //             'activity': `${activity}Logout on IDS ${Hmi}`
  //         })
  //         let CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == Hmi)
  //         if (CurrentCubicalObj != undefined) {
  //             CurrentCubicalObj = CurrentCubicalObj.cubicalData;
  //             await objCalibCommonOperation.releaseCalibrationInProcess(CurrentCubicalObj.Sys_CubicNo)
  //            var  weighmentStatusObj = globalData.weighmentstatus.find(k => k.strHmi == Hmi);
  //             if (weighmentStatusObj != undefined) {
  //                 CurrentCubicalObj.Sys_CubicNo = weighmentStatusObj.status
  //             } else {
  //                 CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == Hmi).cubicalData
  //             }
  //             if (weighmentStatusObj != undefined) {
  //             for(let i = 0; i<=globalData.weighmentstatus.length;i++){
  //                 weighmentStatusObj = globalData.weighmentstatus.find(k => k.strHmi == Hmi)
  //                 if(weighmentStatusObj != undefined){
  //                  await models.tbl_system_weighingstatus.update({
  //                      Status: 0,
  //                      BatchNo: "NULL",
  //                      CubType: "NULL"
  //                  }, {
  //                      where: {
  //                          CubicleNo: weighmentStatusObj.status,
  //                      }
  //                  })
  //                  globalData.weighmentstatus.findIndex(k => k.strHmi == Hmi) == -1 ? globalData.weighmentstatus : globalData.weighmentstatus.splice(globalData.weighmentstatus.findIndex(k => k.strHmi == Hmi), 1);
  //              }
  //              }
  //             }
  //             await this.UnlockedWeighingStatus(CurrentCubicalObj.Sys_CubicNo)
  //         }
  //         var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == Hmi);

  //         if (IPQCObject != undefined) {
  //             var cubicalO = await models.tbl_cubical.findAll({
  //                 where: {
  //                     Sys_IDSNo: Hmi
  //                 }
  //             })
  //             cubicalO = cubicalO.pop()
  //             await this.UnlockedWeighingStatus(cubicalO.Sys_CubicNo)
  //             await objCalibCommonOperation.releaseCalibrationInProcess(cubicalO.Sys_CubicNo)
  //         }



  //         await objClearArr.clearDetails(Hmi);
  //         await objMonit.monit({ case: 'Logout', Hmi: Hmi });
  //         return responseObj = { status: 'success', data: 'User Logout Successfully' }
  //     } catch (error) {
  //         throw new Error(error)
  //     }
  // }
  async loginMain(userId, userPass, source, Ip, strHmi) {
    try {

      var now = new Date();
      const response = await axios.post(
        `http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API/login/loginMain`,
        {
          userId: userId,
          userPass: userPass,
          source: source,
          hmi: `${strHmi}`,

        }
      );
      // let responseObj = {}
      // Object.assign(responseObj, { result: response.data })

      strHmi = strHmi.split('-')[1]
      if (response != undefined) {
        if (response.data != undefined) {
          if (response.data.data != undefined) {
            var tmpUserobj = globalData.arrUsers.find(k => k.Hmi == strHmi);
            if (tmpUserobj == undefined) {
              globalData.arrUsers.push({
                Hmi: strHmi,
                UserName: response.data.userName,
                UserId: response.data.data.UserID,
                UserPass: response.data.data.realPassword
              });
            } else {
              var index = globalData.arrUsers.findIndex(k => k.Hmi == strHmi);
              globalData.arrUsers[index].userName = response.data.userName,
                globalData.arrUsers[index].UserId = response.data.data.UserID,
                globalData.arrUsers[index].userPass = response.data.data.realPassword;
            }
          }
        }
      }

      return response.data
    } catch (error) {
      console.log(error)
      return "Api connection close"
    }
  }
  // async ApiLogin(data) {
  async powerbackup(data) {
    var responseObj = {}
    await objClearArray.clearDetails(data.Hmi);
    var user = await models.tbl_users.findAll({
      where: { userID: data.userId }
    })
    var tmpUserobj = globalData.arrUsers.find(k => k.Hmi == data.Hmi);
    if (tmpUserobj == undefined) {
      globalData.arrUsers.push({
        Hmi: data.Hmi,
        UserName: user[0].UserInitials,
        UserId: user[0].UserID,
        UserPass: user[0].realPassword
      });
    } else {
      var index = globalData.arrUsers.findIndex(k => k.Hmi == data.Hmi);
      globalData.arrUsers[index].userName = data.userName;
      globalData.arrUsers[index].UserId = data.userId;
      globalData.arrUsers[index].userPass = data.userPass;


    }
    // console.log(data)
    var tmpUserRightobj = globalData.arrUserRights.find(k => k.Hmi == data.Hmi);
    if (tmpUserRightobj == undefined) {
      globalData.arrUserRights.push({
        Hmi: data.Hmi,
        rights: data.Rights.concat(data.splRights),
        splRights: data.splRights,
        removeRights: data.removeRights
      });
    } else {
      // var index = globalData.arrUserRights.findIndex(k => k.Hmi == data.Hmi);
      // globalData.arrUserRights[index].rights = data.Rights,
      //     globalData.arrUserRights[index].splRights = data.splRights,
      //     globalData.arrUserRights[index].removeRights = data.removeRights
      //commented on 20/02/23
      // tmpUserRightobj.rights = data.Rights.concat(data.splRights);
      // tmpUserRightobj.splRight = data.splRight;
      // tmpUserRightobj.removeRight = data.removeRight;
      tmpUserRightobj.rights = tmpUserRightobj.rights;
      tmpUserRightobj.splRight = tmpUserRightobj.splRight;
      tmpUserRightobj.removeRight = tmpUserRightobj.removeRight;

    }
    tmpUserobj = globalData.arrUsers.find(k => k.Hmi == data.Hmi);
    //monit
    // await objMonit.monit({ case: 'Login', Hmi: data.Hmi, data: tmpUserobj });

    let arr = []
    var powerbcup = await objPowerBackup.chkPowerBackupPresent(data);
    if (typeof (powerbcup) == 'object') {
      for (let obj in powerbcup) {
        if (powerbcup[obj] != null) {
          if (arr.length == 0) {
            arr.push({ [`${obj}`]: powerbcup[obj] })
            // await models.tbl_activity_log.create({
            //     dt: momentObj().format('YYYY-MM-DD'),
            //     tm: momentObj().format('HH:mm:ss'),
            //     userid: data.userId,
            //     // username: userName,
            //     activity: "Powered On TSH" + ' ' + data.Hmi
            // })
          } else {
            arr[0][obj] = powerbcup[obj]
          }

          //console.log(obj)
        }
      }

      powerbcup = arr[0]
    } else {
      powerbcup = powerbcup
    }


    Object.assign(responseObj, { status: 'success' }, { result: powerbcup })

    return responseObj;
  }
  async UnlockedWeighingStatus(cubicalNo) {
    try {
      await models.tbl_system_weighingstatus.update({
        Status: 0,
        BatchNo: "NULL",
        CubType: "NULL"
      }, {
        where: {
          CubicleNo: cubicalNo,
          // BatchNo:BatchNo,
          // CubicleNo:cubicalNo,
          // CubicleNo:cubicalNo,

        }
      })
    } catch (error) {
      console.log(error)
    }
  }

  //Discarded Powerbackup
  async discardPowerBackup(values) {
    try {
      var { Hmi, userId, userName, menuName } = values;
      // let CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == Hmi).cubicalData;
      // const Entry = await models.tbl_powerbackup.findOne({
      //     where: {
      //         CubicalNo: CurrentCubicalObj.Sys_CubicNo,
      //         WeighmentName: menuName
      //     }
      // })
      // await this.handleIncompleteTest(Hmi,menuName)
      let getProdDetails = globalData.arrSelectedMenu.filter(e => e.Hmi == Hmi)[0]?.selectedProductDetail;
      console.log(getProdDetails);
      console.log(menuName, "discared")
      if (menuName == 'Monthly') {
        menuName = "DAILY"
      }
      if (menuName != "FRIAB") {
        var Entry = await models.tbl_powerbackup.findAll({
          where: {
            Idsno: Hmi,
            WeighmentName: menuName
          }
        })
      }

      if (menuName == "FRIAB") {
        var productObj = globalData.arrIdsInfo.find((k) => k.Hmi == Hmi)
        if (productObj != undefined) {
          productObj = productObj.cubicalData
          var Entry = await models.tbl_powerbackup.findAll({
            where: {
              Idsno: Hmi,
              WeighmentName: menuName,
              Sys_Batch: productObj.Sys_Batch,
              Childcno: productObj.Sys_CubicNo  // productObj.Sys_Child,
            }
          })
        }
      }
      if (Entry != undefined) {
        if (Entry.length != 0) {
          console.log("Discarded")
          if (menuName != "FRIAB") {
            await models.tbl_powerbackup.destroy({
              where: {
                Idsno: Hmi,
                WeighmentName: menuName
              }
            })
          }
          if (menuName == "FRIAB") {
            await models.tbl_powerbackup.destroy({
              where: {
                Idsno: Hmi,
                WeighmentName: menuName,
                Sys_Batch: productObj.cubicalData.Sys_Batch
              }
            })
          };
          //for calibration
          if (Entry[0].WeighmentType != 'NULL')
            if (Entry[0].WeighmentType == "Calib") {
              let objActivity = {};
              Object.assign(
                objActivity,
                { strUserId: userId },
                { strUserName: userName },
                { activity: `${menuName.toUpperCase()} Calibration Discarded on TSH ${Hmi}` }
              );

              await objActivityLog.ActivityLogEntry(objActivity);
              console.log("Calibration Discarded")
              // If you want to delete entire calibration data set this flag to true
              let deleteCalibrationFlag = false;
              await objPowerBackup.moveCalibrationIncompleteToFail(Hmi, deleteCalibrationFlag)
            }


          //for weighment
          if (menuName == GLOBAL_NOMENCLATURE.IndividualMenu || menuName == GLOBAL_NOMENCLATURE.IndLayerMenu || menuName == GLOBAL_NOMENCLATURE.IndLayer1Menu || menuName == GLOBAL_NOMENCLATURE.LengthMenu || menuName == GLOBAL_NOMENCLATURE.SealLengthMenu ||
            menuName == GLOBAL_NOMENCLATURE.ThicknessMenu || menuName == GLOBAL_NOMENCLATURE.BreadthMenu || menuName == GLOBAL_NOMENCLATURE.DiameterMenu || menuName == GLOBAL_NOMENCLATURE.Hardness || menuName == GLOBAL_NOMENCLATURE.Differential) {
            // let objSelMenu = globalData.arrSelectedMenu.find(
            //     (k) => k.Hmi == Hmi
            // );
            var masterTable = '';
            var detailTable = '';
            var detail_tableName = '';
            var master_tableName = '';
            switch (menuName) {
              case GLOBAL_NOMENCLATURE.IndividualMenu:
                if (Entry[0].Sys_CubType == 'Capsule Filling' || Entry[0].ProductType == '2') {
                  masterTable = 'tbl_cap_master1';
                  detailTable = 'tbl_cap_detail1';
                } else {
                  masterTable = 'tbl_tab_master1';
                  detailTable = 'tbl_tab_detail1';
                }
                detail_tableName = detailTable.concat("_incomplete");
                master_tableName = masterTable.concat("_incomplete");
                break;
              case GLOBAL_NOMENCLATURE.IndLayer1Menu:
                masterTable = 'tbl_tab_master11';
                detailTable = 'tbl_tab_detail11';
                detail_tableName = detailTable.concat("_incomplete");
                master_tableName = masterTable.concat("_incomplete");
                break;
              case GLOBAL_NOMENCLATURE.IndLayerMenu:
                masterTable = 'tbl_tab_master9';
                detailTable = 'tbl_tab_detail9';
                detail_tableName = detailTable.concat("_incomplete");
                master_tableName = masterTable.concat("_incomplete");
                break;
              case GLOBAL_NOMENCLATURE.ThicknessMenu:
                masterTable = 'tbl_tab_master3';
                detailTable = 'tbl_tab_detail3';
                detail_tableName = detailTable.concat("_incomplete");
                master_tableName = masterTable.concat("_incomplete");
                break;
              case GLOBAL_NOMENCLATURE.BreadthMenu:
                masterTable = 'tbl_tab_master4';
                detailTable = 'tbl_tab_detail4';
                detail_tableName = detailTable.concat("_incomplete");
                master_tableName = masterTable.concat("_incomplete");
                break;

              case GLOBAL_NOMENCLATURE.LengthMenu:
                masterTable = 'tbl_tab_master5';
                detailTable = 'tbl_tab_detail5';
                detail_tableName = detailTable.concat("_incomplete");
                master_tableName = masterTable.concat("_incomplete");
                break;
              case GLOBAL_NOMENCLATURE.DiameterMenu:
                masterTable = 'tbl_tab_master6';
                detailTable = 'tbl_tab_detail6';
                detail_tableName = detailTable.concat("_incomplete");
                master_tableName = masterTable.concat("_incomplete");
                break;
              case GLOBAL_NOMENCLATURE.Hardness:
                masterTable = 'tbl_tab_masterhtd';
                detailTable = 'tbl_tab_detailhtd';
                detail_tableName = detailTable.concat("_incomplete");
                master_tableName = masterTable.concat("_incomplete");
                break;
              case GLOBAL_NOMENCLATURE.Differential:
                masterTable = 'tbl_cap_master3';
                detailTable = 'tbl_cap_detail3';
                detail_tableName = detailTable.concat("_incomplete");
                master_tableName = masterTable.concat("_incomplete");
                break;
              case GLOBAL_NOMENCLATURE.SealLengthMenu:
                masterTable = "tbl_cap_master5";
                detailTable = "tbl_cap_detail5";
                detail_tableName = detailTable.concat("_incomplete");
                master_tableName = masterTable.concat("_incomplete");
                break;
              default:
                masterTable = 'tbl_tab_master1';
                detailTable = 'tbl_tab_detail1';
                detail_tableName = detailTable.concat("_incomplete");
                master_tableName = masterTable.concat("_incomplete");
                break;
            }


            //average
            // if (objSelMenu.selectedProductDetail.isonstd == 1) {
            //     var get_Datavalue = await models[detail_tableName].findAll({ where: { RepSerNo: Entry[0].Incomp_RepSerNo } })
            //     var get_Datavalue1 = await models[master_tableName].findAll({ where: { RepSerNo: Entry[0].Incomp_RepSerNo } })

            //     objSelMenu.selectedProductDetail.nominal = get_Datavalue1[0].AvgValue;

            //     var Nominal = objSelMenu.selectedProductDetail.nominal;
            //     Nominal = Number(Nominal).toFixed(3);

            //     var typeValue = 1;
            //     var maxLimitT1 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail, 'T1');
            //     var maxLimitT2 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail, 'T2');
            //     var minLimitT2 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail, 'T2');
            //     var minLimitT1 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail, 'T1');

            //     var DataValue_arr = [];

            //     get_Datavalue1[0].NoOfBelowT1 = 0;
            //     get_Datavalue1[0].NoOfAboveT1 = 0;
            //     get_Datavalue1[0].NoOfBelowT2 = 0;
            //     get_Datavalue1[0].NoOfAboveT2 = 0;

            //     DataValue_arr.push(get_Datavalue);
            //     var arr = [];
            //     for (var i = 0; i < get_Datavalue.length; i++) {
            //         var a = get_Datavalue[i].DataValue;

            //         if (Number(a) < Number(minLimitT2)) {
            //             get_Datavalue1[0].NoOfBelowT2 = Number(get_Datavalue1[0].NoOfBelowT2) + 1;
            //         } else if (Number(a) > Number(maxLimitT2)) {
            //             get_Datavalue1[0].NoOfAboveT2 = Number(get_Datavalue1[0].NoOfAboveT2) + 1;
            //         }
            //         if (maxLimitT1 != 0 && minLimitT1 != 0) {
            //             if (Number(a) < Number(minLimitT1) && Number(a) >= Number(minLimitT2)) {
            //                 get_Datavalue1[0].NoOfBelowT1 = Number(get_Datavalue1[0].NoOfBelowT1) + 1;
            //             } else if (Number(a) > Number(maxLimitT1) && Number(a) <= Number(maxLimitT2)) {
            //                 get_Datavalue1[0].NoOfAboveT1 = Number(get_Datavalue1[0].NoOfAboveT1) + 1;
            //             }
            //         }

            //         arr.push(Number(a));
            //         console.log(arr);
            //         var max_value = maths.max(arr);
            //         max_value = max_value.toFixed(3);
            //         var min_value = maths.min(arr);
            //         min_value = min_value.toFixed(3);
            //         var std_value = maths.std(arr);
            //         std_value = std_value.toFixed(3);
            //         var total = arr.reduce((acc, total) => {
            //             return Number(total) + Number(acc);
            //         }, 0)
            //         var avg = total / arr.length
            //         avg = maths.abs(avg).toFixed(3);
            //         var minPer_value = ((Nominal - min_value) / Nominal) * 100;
            //         minPer_value = maths.abs(minPer_value).toFixed(2)
            //         var maxPer_value = ((max_value - Nominal) / Nominal) * 100;
            //         maxPer_value = maths.abs(maxPer_value).toFixed(2)

            //         // console.log();
            //         console.log(max_value, min_value, std_value, avg, minPer_value, maxPer_value);
            //         // return arr;

            //         var get_Datavalue11 = await models[master_tableName].update({
            //             AvgValue: avg,
            //             MinValue: min_value,
            //             MaxValue: max_value,
            //             // StdDev: std_value,
            //             MinPer: minPer_value,
            //             MaxPer: maxPer_value,
            //             NoOfAboveT1: get_Datavalue1[0].NoOfAboveT1,
            //             NoOfAboveT2: get_Datavalue1[0].NoOfAboveT2,
            //             NoOfBelowT1: get_Datavalue1[0].NoOfBelowT1,
            //             NoOfBelowT2: get_Datavalue1[0].NoOfBelowT2,
            //             T1NegTol: Number(minLimitT1).toFixed(3),
            //             T1PosTol: Number(maxLimitT1).toFixed(3),
            //             T2NegTol: Number(minLimitT2).toFixed(3),
            //             T2PosTol: Number(maxLimitT2).toFixed(3),
            //         }, { where: { RepSerNo: Entry[0].Incomp_RepSerNo } });
            //     }
            // }
            var selobjdata = await models[master_tableName].findAll(
              {
                where: {
                  RepSerNo: Entry[0].Incomp_RepSerNo,
                }
              });
            if (selobjdata[0].Side == 'NA') {

              await models[master_tableName].update(
                {
                  Inprocess: 0,
                  PrEndDate: momentObj().format("YYYY-MM-DD"),
                  PrEndTime: momentObj().format("HH:mm:ss"),
                  FailedRemarkTSH: "Aborted test" // FailedRemarkTSH
                }, {
                where: {
                  RepSerNo: Entry[0].Incomp_RepSerNo,
                }
              }
              );
            } else {
              await models[master_tableName].update(
                {
                  Inprocess: 0,
                  PrEndDate: momentObj().format("YYYY-MM-DD"),
                  PrEndTime: momentObj().format("HH:mm:ss"),
                  FailedRemarkTSH: "Aborted test" // FailedRemarkTSH
                }, {
                where: {
                  MstSerNo: selobjdata[0].MstSerNo,
                  BatchNo: selobjdata[0].BatchNo,
                  CubicleName: selobjdata[0].CubicleName,
                  ProductName: selobjdata[0].ProductName
                }
              }
              );
            }
            // await models.tbl_activity_log.create({
            //     'dt': momentObj().format('YYYY-MM-DD'),
            //     'tm': momentObj().format('HH:mm:ss'),
            //     'userid': userId,
            //     'username': userName,
            //     'activity': `${menuName} Test Aborted on TSH ${Hmi}`
            // });
            var hmiDetails = await models[master_tableName].findAll({
              where: {
                RepSerNo: Entry[0].Incomp_RepSerNo,
              }
            })
          }
          if (menuName == GLOBAL_NOMENCLATURE.perFineMenu || menuName == GLOBAL_NOMENCLATURE.perFineLayer1Menu || menuName == GLOBAL_NOMENCLATURE.perFineLayer2Menu || menuName == GLOBAL_NOMENCLATURE.PSDMenu || menuName == GLOBAL_NOMENCLATURE.PSDLayer1Menu || menuName == GLOBAL_NOMENCLATURE.PSDLayer2Menu) {
            let prodType = (getProdDetails.ProductType == 2) ? "cap" : "tab";
            if (menuName == GLOBAL_NOMENCLATURE.perFineMenu || menuName == GLOBAL_NOMENCLATURE.perFineLayer1Menu || menuName == GLOBAL_NOMENCLATURE.perFineLayer2Menu) {
              var master_tableName = `tbl_${prodType}_master17_incomplete`
            } else {
              var master_tableName = `tbl_${prodType}_master18_incomplete`
            }
            await models[master_tableName].update(
              {
                Inprocess: 0,
                PrEndDate: momentObj().format("YYYY-MM-DD"),
                PrEndTime: momentObj().format("HH:mm:ss"),
                FailedRemarkTSH: "Aborted test" // FailedRemarkTSH
              }, {
              where: {
                RepSerNo: Entry[0].Incomp_RepSerNo,
              }
            });
            // await models.tbl_activity_log.create({
            //     'dt': momentObj().format('YYYY-MM-DD'),
            //     'tm': momentObj().format('HH:mm:ss'),
            //     'userid': userId,
            //     'username': userName,
            //     'activity': `${menuName} Test Aborted on TSH ${Hmi}`
            // });
            var hmiDetails = await models[master_tableName].findAll({
              where: {
                RepSerNo: Entry[0].Incomp_RepSerNo,
              }
            })
          }
          //For activity
          if (menuName == GLOBAL_NOMENCLATURE.IndividualMenu || menuName == GLOBAL_NOMENCLATURE.IndLayer1Menu || menuName == GLOBAL_NOMENCLATURE.IndLayerMenu) {
            if (hmiDetails.length != 0) {
              hmiDetails = hmiDetails[0]
              if (hmiDetails.Side != 'NA') {
                var act = `${menuName} Weighment Discarded on TSH ${Hmi} for side ${hmiDetails.Side}`
              } else {
                var act = `${menuName} Weighment Discarded on TSH ${Hmi}`
              }
            }
          } else {
            var act = `${menuName} Weighment Discarded on TSH ${Hmi}`
          }
          if (Entry[0].WeighmentType != "Calib") {
            await models.tbl_activity_log.create({
              'dt': momentObj().format('YYYY-MM-DD'),
              'tm': momentObj().format('HH:mm:ss'),
              'userid': userId,
              'username': userName,
              'activity': act
            });

          }
        }
      }
      // if (Entry != null) {
      //     if (Hmi == Entry.Idsno) {
      //         if (Entry.WeighmentName == 'FRIAB' && Entry.Before_Count == 1) {
      //             const discardEntry = await models.tbl_tab_detail8.findAll({
      //                 attributes: [[sequelize.fn('max', sequelize.col('RecNo')), 'RecNo']],
      //                 where: {
      //                     DataValue2: 0,
      //                     UserID: userId,
      //                     UserName: userName
      //                 }
      //             })
      //             await models.tbl_tab_detail8.destroy({
      //                 where: {
      //                     RecNo: discardEntry[0].RecNo
      //                 }
      //             })

      //         }
      //     }
      // }

      //discard entry when user logout in initial weight


      //clear arrays related to counter and test

      globalData.arrWeighmentCounter.findIndex(k => k.Hmi == Hmi) == -1 ?
        globalData.arrWeighmentCounter :
        globalData.arrWeighmentCounter.splice(globalData.arrWeighmentCounter.findIndex(k => k.Hmi == Hmi), 1);

      (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === Hmi)) == -1 ?
        globalData.arrCurrentOperationStatus :
        globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === Hmi), 1);

      (globalData.arrWeighmentCounterAfter.findIndex((element) => element.Hmi === Hmi)) == -1 ?
        globalData.arrWeighmentCounterAfter :
        globalData.arrWeighmentCounterAfter.splice(globalData.arrWeighmentCounterAfter.findIndex((element) => element.Hmi === Hmi), 1);

      (globalData.arrDifferentialCounter.findIndex((element) => element.Hmi === Hmi)) == -1 ?
        globalData.arrDifferentialCounter :
        globalData.arrDifferentialCounter.splice(globalData.arrDifferentialCounter.findIndex((element) => element.Hmi === Hmi), 1);

      (globalData.arrProtocolData.findIndex((element) => element.Hmi === Hmi)) == -1 ?
        globalData.arrProtocolData :
        globalData.arrProtocolData.splice(globalData.arrProtocolData.findIndex((element) => element.Hmi === Hmi), 1);

      (globalData.arrOutFlagForTest.findIndex((element) => element.Hmi === Hmi)) == -1 ?
        globalData.arrOutFlagForTest :
        globalData.arrOutFlagForTest.splice(globalData.arrOutFlagForTest.findIndex((element) => element.Hmi === Hmi), 1);

      globalData.arrSelectedMenu.findIndex(k => k.Hmi == Hmi) == -1 ?
        globalData.arrSelectedMenu :
        globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == Hmi), 1);

      (globalData.arrOutFlagForTest.findIndex((element) => element.Hmi === Hmi)) == -1 ?
        globalData.arrOutFlagForTest :
        globalData.arrOutFlagForTest.splice(globalData.arrOutFlagForTest.findIndex((element) => element.Hmi === Hmi), 1);

      // (globalData.HardnessMasterEntry.findIndex((element) => element.Hmi === Hmi)) == -1 ?
      //     globalData.HardnessMasterEntry :
      //     globalData.HardnessMasterEntry.splice(globalData.HardnessMasterEntry.findIndex((element) => element.Hmi === Hmi), 1);

      (globalData.DoubSide.findIndex((element) => element.Hmi === Hmi)) == -1 ?
        globalData.DoubSide :
        globalData.DoubSide.splice(globalData.DoubSide.findIndex((element) => element.Hmi === Hmi), 1);

      (globalData.arrside.findIndex((element) => element.Hmi === Hmi)) == -1 ?
        globalData.arrside :
        globalData.arrside.splice(globalData.arrside.findIndex((element) => element.Hmi === Hmi), 1);

      globalData.arrWeighmentCounterForFriab.findIndex((element) => element.Hmi === Hmi) == -1 ?
        globalData.arrWeighmentCounterForFriab :
        globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex((element) => element.Hmi === Hmi), 1);

      // globalData.arrcheckingInCompRepSerNo.findIndex((element) => element.Hmi === Hmi) == -1 ?
      //     globalData.arrcheckingInCompRepSerNo :
      //     globalData.arrcheckingInCompRepSerNo.splice(globalData.arrcheckingInCompRepSerNo.findIndex((element) => element.Hmi === Hmi), 1);

      // globalData.arrPushValuesOfHardness.findIndex((element) => element.Hmi === Hmi) == -1 ?
      //     globalData.arrPushValuesOfHardness :
      //     globalData.arrPushValuesOfHardness.splice(globalData.arrPushValuesOfHardness.findIndex((element) => element.Hmi === Hmi), 1);

      // if (Entry.length != 0) {
      //     if (Entry[0].WeighmentType != "Calib") {
      //         await models.tbl_activity_log.create({
      //             'dt': momentObj().format('YYYY-MM-DD'),
      //             'tm': momentObj().format('HH:mm:ss'),
      //             'userid': userId,
      //             'username': userName,
      //             'activity': `${menuName} Test Discarded on TSH ${Hmi}`
      //         });

      //     }
      // }


      return {
        status: 'success',
        result: "Successfully Discarded Previous Test"
      }

    } catch (error) {
      console.log(error);
      console.error(error)
    }
  }

  //LDAP LOGIN
  async validateUserLDAP(userId, userPass, source, ip, rpi, strHmi) {
    try {
      let dt = new Date();
      let now = new Date();
      strHmi = strHmi.toString();
      let user = await models.tbl_users.findAll({
        where: {
          UserID: userId,
        },
      });
      if (user[0] == undefined) {
        console.log("User not Valid");
        let obj = {
          status: "fail",
          result: "Incorrect User ID Or Password",
        };
        return obj;
      }
      // if (user[0].realPassword == "VALIDATED") {
      //     let username = user[0].UserName;
      //     var UserInitial = user[0].UserInitials
      //     let obj = { username, userPass };
      //     const responses = await axios.post(
      //         `http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API/ldap/validate`,
      //         {
      //             strUserName: username,
      //             strPassword: userPass,
      //             // source: source,
      //             // ip : `IDS-${strHmi}`
      //         }
      //     );
      //     // if (responses.data.response == "Authenticated") {
      //     //     const response = await axios.post(
      //     //         `http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API/login/loginMain`,
      //     //         {
      //     //             user: userId,
      //     //             userId: userId,
      //     //             userPass: "VALIDATED",
      //     //             //  username:userName,
      //     //             source: "Hardware",
      //     //             // ip: `${strHmi}`,
      //     //         }
      //     //     );

      //     //     // }
      //     //     if (response.data.result == 'User Already Active On Software') {
      //     //         let obj = {
      //     //             status: "Fail",
      //     //             result: 'User Already Active On Software',
      //     //         };
      //     //         return obj;
      //     //     }
      //     //     if (response.data.result == "Please Change Your Password") {
      //     //         response.data.result = response.data.data;
      //     //         response.data.data.active = 1;
      //     //         let user = await models.tbl_users.update(
      //     //             {
      //     //                 active: 1,
      //     //             },
      //     //             {
      //     //                 where: {
      //     //                     UserID: userId,
      //     //                 },
      //     //             }
      //     //         );
      //     //         await models.tbl_activity_log.create({
      //     //             dt: date.format(now, "YYYY-MM-DD"),
      //     //             tm: date.format(now, "HH:mm:ss"),
      //     //             userid: userId,
      //     //             username: UserInitial,
      //     //             activity: 'Logged in on TSH:' + " " + strHmi
      //     //         });
      //     //     }
      //     //     if (response.data.result == "User Temporary Disabled, Contact Admin" || response.data.result == "User Locked, Please contact Admin") {
      //     //         response.data.result = "User Disabled Contact Authorized Person";
      //     //     }
      //     //     if (response.data.result == "Password Expired, Please Change Your Password") {
      //     //         response.data.result = response.data.data;
      //     //         response.data.result.active = 1;
      //     //         let user = await models.tbl_users.update(
      //     //             {
      //     //                 active: 1,
      //     //             },
      //     //             {
      //     //                 where: {
      //     //                     UserID: userId,
      //     //                 },
      //     //             }
      //     //         );
      //     //         await models.tbl_activity_log.create({
      //     //             dt: date.format(now, "YYYY-MM-DD"),
      //     //             tm: date.format(now, "HH:mm:ss"),
      //     //             userid: userId,
      //     //             username: UserInitial,
      //     //             activity: 'Logged in on TSH:' + " " + strHmi
      //     //         });
      //     //     }

      //     //     if (response != undefined) {
      //     //         if (
      //     //             response.data.result.active != undefined ||
      //     //             response.data.active == 1
      //     //         ) {
      //     //             if (response.data.result.active == 1) {
      //     //                 var tmpUserobj = globalData.arrUsers.find(
      //     //                     (k) => k.Hmi == strHmi
      //     //                 );
      //     //                 if (tmpUserobj == undefined) {
      //     //                     globalData.arrUsers.push({
      //     //                         Hmi: strHmi,
      //     //                         UserId: userId,
      //     //                         UserName: response.data.result.UserInitials,
      //     //                         UserPass: userPass,
      //     //                     });
      //     //                 } else {
      //     //                     tmpUserobj.UserId = userId;
      //     //                     (tmpUserobj.UserName = response.data.result.UserInitials),
      //     //                         (tmpUserobj.UserPass = userPass);
      //     //                 }

      //     //                 var tmpUserRightobj = globalData.arrUserRights.find(
      //     //                     (k) => k.Hmi == strHmi
      //     //                 );
      //     //                 if (tmpUserRightobj == undefined) {
      //     //                     globalData.arrUserRights.push({
      //     //                         Hmi: strHmi,
      //     //                         rights: response.data.result.rights.concat(
      //     //                             response.data.result.splRights
      //     //                         ),
      //     //                         splRights: response.data.result.splRights,
      //     //                         removeRights: response.data.result.removeRights,
      //     //                     });
      //     //                 } else {
      //     //                     tmpUserRightobj.rights = response.data.result.rights.concat(
      //     //                         response.data.result.splRights
      //     //                     );
      //     //                     (tmpUserRightobj.splRight = response.data.result.splRights),
      //     //                         (tmpUserRightobj.removeRight =
      //     //                             response.data.result.removeRights);
      //     //                 }
      //     //             }
      //     //         }
      //     //     }
      //     //     if (response.data.result.active != undefined || response.data.active == 1) {
      //     //     }
      //     //     let timeout = await models.tbl_setallparameter.findAll();
      //     //     timeout = timeout[0].tbl_config_TimeoutPeriod;
      //     //     response.data.timeOut = timeout;
      //     //     console.log(response);
      //     //     let obj = {
      //     //         status: "success",
      //     //         timeOut: response.data.timeOut,
      //     //         userName: response.data.result.UserInitials,
      //     //         result: response.data.result,
      //     //     };
      //     //     return obj;
      //     // }
      //     if (responses.data.response == "Authenticated failed") {
      //         let obj = {
      //             status: "fail",
      //             result: "Incorrect User ID Or Password",
      //         };
      //         return obj;
      //     }
      //     var tmpUserobj = globalData.arrUsers.find(k => k.Hmi == strHmi);
      //     //monit
      //     // await objMonit.monit({ case: 'Login', Hmi: strHmi, data: tmpUserobj });
      // } else {
      //     console.log("User not Valid");
      //     let obj = {
      //         status: "fail",
      //         result: "Validate User on Software And Try Again",
      //     };
      //     return obj;
      // }

      //login03/06/23 start
      if (user[0].realPassword == 'VALIDATED') {
        //If user pass is validated then check for ldap validation
        const responses = await axios.post(`http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API/ldap/validate`, {
          strUserName: user[0].UserName,
          strPassword: userPass,
          source: 'hardware',
          hmi: `TSH - ${strHmi}`
        })
        //If user is authenticated then login
        if (responses.data.response == 'Authenticated') {
          const checkuser = await axios.post(`http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API/login/chkUserActive`, {
            userId: userId
          });
          //active validation
          if (checkuser.data.result.Status == 1 || checkuser.data.result.Status == 2) {
            var msg = 'User Disabled, Contact Authorized Person';
            return { status: "fail", result: msg }
          }
          if (checkuser.data.result.active == 1) {
            var msg;
            if (checkuser.data.result.source == 'Software') {
              msg = 'User Already Active on Software';
            } else {
              msg = 'User Already Active on TSH';
            }
            return { status: "fail", result: msg }
          } else {
            var response = await axios.post(`http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API/login/validateUser`, {
              userId: user[0].UserID,
              user: user[0].UserID,
              strUserName: user[0].UserInitials,
              // userPass: 'VALIDATED',
              source: 'hardware',
              hmi: `${strHmi}`,
              ip: strHmi,

            });
            if (response.data.result == "User Validated Successfully") {
              var right = await axios.post(`http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API/login/checkuserstatusLds`, {
                user: user[0].UserID,
              });
              var checkuseractive = await axios.post(`http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API/login/chkUserActive`, {
                userId: user[0].UserID
              });
              //user array and rights array push here
              if (checkuseractive.data.result.active == 1) {
                var tmpUserobj = globalData.arrUsers.find(k => k.Hmi == strHmi);
                if (tmpUserobj == undefined) {
                  globalData.arrUsers.push({
                    Hmi: strHmi,
                    UserId: user[0].UserID,
                    UserName: checkuseractive.data.result.UserInitials,
                    UserPass: userPass,
                  });
                } else {
                  tmpUserobj.userId = user[0].UserID;
                  tmpUserobj.userName = checkuseractive.data.result.UserInitials,
                    tmpUserobj.userPass = userPass;
                }

                var tmpUserRightobj = globalData.arrUserRights.find(k => k.Hmi == strHmi);
                if (tmpUserRightobj == undefined) {
                  globalData.arrUserRights.push({
                    Hmi: strHmi,
                    rights: right.data.result[1].rights.concat(right.data.result[2].splRights),
                    splRights: right.data.result[2].splRights,
                    removeRights: right.data.result[3].removeRights
                  });
                } else {
                  tmpUserRightobj.rights = right.data.result[1].rights.concat(right.data.result[2].splRights);
                  tmpUserRightobj.splRight = right.data.result[2].splRights,
                    tmpUserRightobj.removeRight = right.data.result[3].removeRights
                }
                // let CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi);

                // if (CurrentCubicalObj == undefined) {
                //     CurrentCubicalObj = await models.tbl_cubical.findAll({
                //         where: {
                //             Sys_IDSNo: strHmi
                //         }
                //     })
                //     globalData.arrIdsInfo.push({
                //         Hmi: strHmi,
                //         respbi: CurrentCubicalObj[0].Sys_rpi,
                //         cubicalData: CurrentCubicalObj[0]
                //     })
                // } else {
                //     CurrentCubicalObj = CurrentCubicalObj.cubicalData;
                // }
                tmpUserobj = globalData.arrUsers.find(k => k.Hmi == strHmi);
                await objMonit.monit({ case: 'Login', Hmi: strHmi, data: tmpUserobj });

              }

            } else {
              var msg = 'User Already Active on Software';
              return { status: "fail", result: msg }
            }
          }
          console.log(checkuser);
          // if (checkuser.data.result[0].active == 0) {
          //If user is locked or temporary disabled
          // if (response.data.result == 'User Temporary Disabled, Contact Admin' || response.data.result == 'User Locked, Please contact Admin') {
          //     response.data.result = 'User Disabled. Contact Authorized Person'
          // }
          //
          // if (response != undefined) {
          //     if (response.data.result.active != undefined || response.data.active == 1) {
          //         if (response.data.result.active == 1) {
          //             var tmpUserobj = globalData.arrUsers.find(k => k.Hmi == strHmi);
          //             if (tmpUserobj == undefined) {
          //                 globalData.arrUsers.push({
          //                     Hmi: strHmi,
          //                     userId: userId,
          //                     userName: response.data.result.UserInitials,
          //                     userPass: userPass,
          //                 });
          //             } else {
          //                 tmpUserobj.userId = userId;
          //                 tmpUserobj.userName = response.data.result.UserInitials,
          //                     tmpUserobj.userPass = userPass;
          //             }

          //             var tmpUserRightobj = globalData.arrUserRights.find(k => k.Hmi == strHmi);
          //             if (tmpUserRightobj == undefined) {
          //                 globalData.arrUserRights.push({
          //                     Hmi: strHmi,
          //                     rights: response.data.result.rights.concat(response.data.result.splRights),
          //                     splRights: response.data.result.splRights,
          //                     removeRights: response.data.result.removeRights
          //                 });
          //             } else {
          //                 tmpUserRightobj.rights = response.data.result.rights.concat(response.data.result.splRights);
          //                 tmpUserRightobj.splRight = response.data.result.splRights,
          //                     tmpUserRightobj.removeRight = response.data.result.removeRights;
          //             }
          //             let CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi);

          //             if (CurrentCubicalObj == undefined) {
          //                 CurrentCubicalObj = await models.tbl_cubical.findAll({
          //                     where: {
          //                         Sys_IDSNo: strHmi
          //                     }
          //                 })
          //                 globalData.arrIdsInfo.push({
          //                     Hmi: strHmi,
          //                     respbi: CurrentCubicalObj[0].Sys_rpi,
          //                     cubicalData: CurrentCubicalObj[0]
          //                 })
          //             } else {
          //                 CurrentCubicalObj = CurrentCubicalObj.cubicalData;
          //             }
          //             tmpUserobj = globalData.arrUsers.find(k => k.Hmi == strHmi);
          //             await objMonit.monit({ case: 'Login', Hmi: strHmi, data: tmpUserobj });

          //         }
          //     }
          // }

          let timeout = await models.tbl_setallparameter.findAll()
          timeout = timeout[0].tbl_config_TimeoutPeriod
          response.data.timeOut = timeout
          console.log(response);
          console.log(response.data);
          let obj = {
            status: "success",
            timeOut: response.data.timeOut,
            userName: checkuseractive.data.result.UserInitials,
            userId: user[0].UserID,
            result: response.data.result,
          }
          return obj
        }
        //If user is not authenticated then 
        if (responses.data.response == 'Authenticated failed') {
          return { status: "fail", result: "Incorrect User ID or Password" }
        }
        // }
      } else {
        console.log("User not Valid");
        return { status: "fail", result: "Validate User on Software and Try Again" }
      }
      //End 03/06/23
    } catch (error) {
      console.error(error);
    }
  }
  async getResponsefromids(Data) {
    var { userId, Hmi } = Data
    await models.tbl_users.update({ loginCounter: 0 },
      {
        where: { UserID: userId }
      });
    console.log(`TSH Connect to ${Hmi},${userId}`)
    return `TSH Connect to ${Hmi}`

  }

  async moveCalibrationIncompleteToFail(strHmi) {
    try {
      //check bal connected..//take balid//fetch status
      //reset calib

      let strTableName, repNo, strColName, calibAlphabet, calibType;
      let strBalId, pendingMessage;
      const pendingCalib = globalData.glbArrListOfBalWithCalibPending.find(
        (k) => k.Hmi == strHmi
      );

      if (pendingCalib == undefined) {
        return;
      }

      strBalId = pendingCalib.PendingCalibStatus[0].BalId;
      pendingMessage = pendingCalib.PendingCalibStatus[0].Message;
      var Balance_type = pendingCalib.PendingCalibStatus[0].type;
      pendingMessage = pendingMessage.split(" ")[0];
      if (pendingMessage.includes("No")) {
        return;
      }

      // const calibTypeArr = globalData.arrcalibType.find(k => k.Hmi == strHmi);
      // const selectedBal = globalData.arrSelectedBalWithHmi.find(k => k.Hmi == strHmi);

      // if (selectedBal != undefined) {
      //     var strBalId = selectedBal.selectedBal;
      // }

      // if (selectedBal == undefined) {

      //     console.log("return from moveCalibrationIncompleteToFail");
      //     return
      // }
      //get repNo from status table;
      let statusResp = await models.tbl_calibration_status.findOne({
        where: {
          BalID: strBalId,
        },
      });

      let calibrepNo = statusResp.RepNo;

      let calibCounter = globalData.arrCalibCounterApi.find(
        (k) => k.Hmi == strHmi
      );

      // if (calibCounter != undefined) {
      //     if (calibTypeArr != undefined) {
      // switch (calibTypeArr.calibType) {
      switch (pendingMessage.toLowerCase()) {
        case GLOBAL_NOMENCLATURE.Periodic.toLowerCase():
          calibAlphabet = "P";
          // var bln_isPresent = await objCommonCalib.checkIfRecordInIncomplete(calibAlphabet, strBalId)
          strTableName = "tbl_calibration_periodic_master_incomplete";
          repNo = "Periodic_RepNo";
          strColName = "Periodic_BalID";
          calibType = "Monthly";
          break;
        case GLOBAL_NOMENCLATURE.Eccentricity.toLowerCase():
          calibAlphabet = "E";
          // var bln_isPresent = await objCommonCalib.checkIfRecordInIncomplete(calibAlphabet, strBalId)
          strTableName = "tbl_calibration_eccentricity_master_incomplete";
          repNo = "Eccent_RepNo";
          strColName = "Eccent_BalID";
          calibType = "Monthly";
          break;
        case GLOBAL_NOMENCLATURE.Uncertainty.toLowerCase():
          calibAlphabet = "U";
          // var bln_isPresent = await objCommonCalib.checkIfRecordInIncomplete(calibAlphabet, strBalId)
          strTableName = "tbl_calibration_uncertinity_master_incomplete";
          repNo = "Uncertinity_RepNo";
          strColName = "Uncertinity_BalID";
          calibType = "Monthly";
          break;
        case GLOBAL_NOMENCLATURE.Repetability.toLowerCase():
          calibAlphabet = "R";
          // var bln_isPresent = await objCommonCalib.checkIfRecordInIncomplete(calibAlphabet, strBalId)
          strTableName = "tbl_calibration_repetability_master_incomplete";
          repNo = "Repet_RepNo";
          strColName = "Repet_BalID";
          calibType = "Monthly";
          break;
        case "Linearity".toLowerCase():
          calibAlphabet = "L";
          // var bln_isPresent = await objCommonCalib.checkIfRecordInIncomplete(calibAlphabet, strBalId)
          strTableName = "tbl_calibration_linearity_master_incomplete";
          repNo = "Linear_RepNo";
          strColName = "Linear_BalID";
          calibType = "Monthly";
          break;
        default:
          return;
      }
      // if (calibCounter.counterApi != 0) {
      await this.caibrationFails(
        calibAlphabet,
        calibrepNo,
        strBalId,
        calibType,
        true,
        Balance_type
      );
      // }

      //     }
      // }
    } catch (error) {
      console.log(error);
      throw new Error(error);
    }
  }

  async caibrationFails(CalibrationType, RepNo, strBalId, calibType, deleteEntry = false, balType) {
    try {
      // CalibrationType is like 'P', 'R', 'E', 'U'..etc
      // strBalId holds the balance associated with that cubicle
      // RepNo holds the report sr no of incomplete tables
      var tempCaibStatus = globalData.calibrationStatus.find(k => k.BalId == strBalId);
      // getting position of current caibration in sorted array of calibrations
      let sortedArray = await sort.sortedSeqArray(globalData.arrSortedCalib, strBalId, balType); //globalData.arrSortedCalib tbl_calibration_sequnce
      var int_curentCalibrationIndex = sortedArray.indexOf(CalibrationType);
      // calculating first caalibration
      // var str_first_calibration = sortedArray[0];
      //var str_first_calibration = CalibrationType;
      if (calibType == "Yearly") {
        var str_first_calibration = "R"
      } else if (calibType == "Monthly") {
        var str_first_calibration = "R"
      }
      var fRerSrNo = await this.getFrepSrNo(str_first_calibration);
      // fRerSrNo is failed repSrNo which will insert in all failed tables
      var arr_CalibArray = []; // array holds calibration which done and one which failed
      for (let i = 0; i < int_curentCalibrationIndex + 1; i++) {
        arr_CalibArray.push(sortedArray[i])
      }
      // console.log('arr_CalibArray', arr_CalibArray);

      // v holds value such as 'P', 'U', 'E' .....etc

      switch (calibType) {
        case 'Monthly': {
          // {
          //   var objPeriodic = await copyObjects.periodic('tbl_calibration_periodic_master_incomplete'
          //     , 'tbl_calibration_periodic_master_failed', RepNo, 0, 'master')
          //   // Copying Incomplete master to failed master

          //   let columNames = objPeriodic.data.map(obj => obj.str_colName).toString();
          //   var str_Query = `insert into tbl_calibration_periodic_master_failed (${columNames}) select ${columNames} from tbl_calibration_periodic_master_incomplete where Periodic_RepNo = ${RepNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
          //   let resultPeriodic = await sequelize.query(str_Query, { type: sequelize.QueryTypes.INSERT })
          //   // str_Query = 'select SCOPE_IDENTITY() as [Last Inserted Record]'
          //   //  resultPeriodic = await sequelize.query(str_Query, { type: sequelize.QueryTypes.SELECT })


          //   // last inserted Id got here form querymasterInsert[0]
          //   var lastInsertedIdPeriodic = resultPeriodic[0][0].LastInsertedRecord;

          //   // var findobj = await models.tbl_calibration_periodic_master_failed.findAll({

          //   //     where: {
          //   //         "srNo": lastInsertedIdPeriodic
          //   //     }
          //   // })
          //   // Updating the report serial number in failed master
          //   if (lastInsertedIdPeriodic != null) {

          //     await models.tbl_calibration_periodic_master_failed.update({
          //       "Periodic_RepNo": fRerSrNo,
          //       "Periodic_CalbTime": moment(new Date()).format('HH:mm:ss')
          //     }, {
          //       where: {
          //         "srNo": lastInsertedIdPeriodic
          //       }
          //     })


          //     // selecting data from incomplete details for copying
          //     var resultP = await models.tbl_calibration_periodic_detail_incomplete.findAll({
          //       where: {
          //         "Periodic_RepNo": RepNo
          //       }
          //     }); // selected
          //     let res = [{}]
          //     res[0].Periodic_RepNo = resultP[0].Periodic_RepNo
          //     res[0].Periodic_RecNo = resultP[0].Periodic_RecNo
          //     let i = 0;
          //     for (let obj of resultP) {
          //       obj.Periodic_RecNo = resultP[i].Periodic_RecNo
          //       // as we have multiple entries i n details table so we need 
          //       // Async loop



          //       let objCopyPeriodic = await copyObjects.periodic('tbl_calibration_periodic_detail_incomplete'
          //         , 'tbl_calibration_periodic_detail_failed', obj.Periodic_RepNo, obj.Periodic_RecNo, 'detail');

          //       columNames = objCopyPeriodic.data.map(obj => obj.str_colName).toString();
          //       str_Query = `insert into tbl_calibration_periodic_detail_failed (${columNames}) select ${columNames} from tbl_calibration_periodic_detail_incomplete where Periodic_RepNo = ${obj.Periodic_RepNo} AND Periodic_RecNo = ${obj.Periodic_RecNo} select SCOPE_IDENTITY() as [LastInsertedRecord] `
          //       let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

          //       var lastInsertedIdP = detailInsert[0][0].LastInsertedRecord;


          //       await models.tbl_calibration_periodic_detail_failed.update({
          //         "Periodic_RepNo": fRerSrNo
          //       }, {
          //         where: {
          //           "srNo": lastInsertedIdP
          //           // "Periodic_RepNo": res[0].Periodic_RepNo
          //         }
          //       })

          //       // updated repSrNo in failed details 
          //       // console.log('P Copy')
          //       // If ongoing calibration is failed ('Periodic') then only we have to delete
          //       // records from incomplete tables for new entries

          //       i++;
          //     }

          //     if (tempCaibStatus.status['P'] == 0) {
          //       await models.tbl_calibration_periodic_master_incomplete.destroy({
          //         where: {
          //           "Periodic_RepNo": RepNo
          //         }
          //       })
          //       await models.tbl_calibration_periodic_detail_incomplete.destroy({
          //         where: {
          //           "Periodic_RepNo": RepNo
          //         }
          //       })
          //     }
          //   }
          // }
          {
            var objReap = await copyObjects.repetability('tbl_calibration_repetability_master_incomplete'
              , 'tbl_calibration_repetability_master_failed', RepNo, 0, 'master');
            // Copying Incomplete master to failed master
            let columNames = objReap.data.map(obj => obj.str_colName).toString();
            var str_Query = `insert into tbl_calibration_repetability_master_failed (${columNames}) select ${columNames} from tbl_calibration_repetability_master_incomplete where Repet_RepNo = ${RepNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
            let resultReap = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
            // last inserted Id got here form query
            var lastInsertedIdReap = resultReap[0][0].LastInsertedRecord;
            // Updating the report serial number in failed master
            if (lastInsertedIdReap != null) {
              await models.tbl_calibration_repetability_master_failed.update({
                "Repet_RepNo": fRerSrNo,
                "Repet_CalbTime": moment(new Date()).format('HH:mm:ss')
              }, {
                where: {
                  "srNo": lastInsertedIdReap
                }
              }) // failed master report number updated
              // selecting data from incomplete details for copying

              var resultP = await models.tbl_calibration_repetability_detail_incomplete.findAll({
                where: {
                  "Repet_RepNo": RepNo
                }
              }); // selected
              let res = [{}]
              res[0].Repet_RepNo = resultP[0].Repet_RepNo
              res[0].Repet_RecNo = resultP[0].Repet_RecNo
              // as we have multiple entries i n details table so we need 
              // Async loop
              let i = 0;
              for (let obj of resultP) {
                obj.Repet_RecNo = resultP[i].Repet_RecNo
                let objCopyReap = await copyObjects.repetability('tbl_calibration_repetability_detail_incomplete'
                  , 'tbl_calibration_repetability_detail_failed', obj.Repet_RepNo, obj.Repet_RecNo, 'detail');

                columNames = objCopyReap.data.map(obj => obj.str_colName).toString();
                str_Query = `insert into tbl_calibration_repetability_detail_failed (${columNames}) select ${columNames} from tbl_calibration_repetability_detail_incomplete where Repet_RecNo = ${obj.Repet_RecNo} AND Repet_RecNo = ${obj.Repet_RecNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
                let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                var lastInsertedIdU = detailInsert[0][0].LastInsertedRecord;

                await models.tbl_calibration_repetability_detail_failed.update({
                  "Repet_RepNo": fRerSrNo
                }, {
                  where: {
                    "srNo": lastInsertedIdU
                    // "Repet_RepNo": res[0].Repet_RepNo
                  }
                });
                i++;
              }
              if (tempCaibStatus.status['R'] == 0) {
                await models.tbl_calibration_repetability_master_incomplete.destroy({
                  where: {
                    "Repet_RepNo": RepNo
                  }
                });
                await models.tbl_calibration_repetability_detail_incomplete.destroy({
                  where: {
                    "Repet_RepNo": RepNo
                  }
                });
              }
            }
          }
          {
            var objEccen = await copyObjects.eccentricity('tbl_calibration_eccentricity_master_incomplete'
              , 'tbl_calibration_eccentricity_master_failed', RepNo, 0, 'master');
            // console.log(obj)
            let columNames = objEccen.data.map(obj => obj.str_colName).toString();
            var str_Query = `insert into tbl_calibration_eccentricity_master_failed (${columNames}) select ${columNames} from tbl_calibration_eccentricity_master_incomplete where Eccent_RepNo = ${RepNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
            let resultEccen = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
            // console.log(result)
            var lastInsertedIdEccen = resultEccen[0][0].LastInsertedRecord;

            if (lastInsertedIdEccen != null) {
              await models.tbl_calibration_eccentricity_master_failed.update({
                "Eccent_RepNo": fRerSrNo,
                "Eccent_CalbTime": moment(new Date()).format('HH:mm:ss')
              }, {
                where: {
                  "srNo": lastInsertedIdEccen
                }
              })

              var resultP = await models.tbl_calibration_eccentricity_detail_incomplete.findAll({
                where: {
                  "Eccent_RepNo": RepNo
                }
              }); // selected
              let res = [{}]
              res[0].Eccent_RepNo = resultP[0].Eccent_RepNo
              res[0].Eccent_RecNo = resultP[0].Eccent_RecNo
              // console.log(result[0])
              let i = 0;
              for (let obj of resultP) {
                obj.Eccent_RecNo = resultP[i].Eccent_RecNo
                let objCopyEccen = await copyObjects.eccentricity('tbl_calibration_eccentricity_detail_incomplete'
                  , 'tbl_calibration_eccentricity_detail_failed', obj.Eccent_RepNo, obj.Eccent_RecNo, 'detail');
                columNames = objCopyEccen.data.map(obj => obj.str_colName).toString();
                str_Query = `insert into tbl_calibration_eccentricity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_eccentricity_detail_incomplete where Eccent_RepNo = ${obj.Eccent_RepNo} AND Eccent_RecNo = ${obj.Eccent_RecNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
                let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                var lastInsertedIdU = detailInsert[0][0].LastInsertedRecord;

                await models.tbl_calibration_eccentricity_detail_failed.update({
                  "Eccent_RepNo": fRerSrNo,
                  "Eccent_CalbTime": moment(new Date()).format('HH:mm:ss')
                }, {
                  where: {
                    "srNo": lastInsertedIdU
                    // "Eccent_RepNo":  res[0].Eccent_RepNo
                  }
                })
                i++

              }

              if (tempCaibStatus.status['E'] == 0) {
                await models.tbl_calibration_eccentricity_master_incomplete.destroy({
                  where: {
                    "Eccent_RepNo": RepNo
                  }
                });
                await models.tbl_calibration_eccentricity_detail_incomplete.destroy({
                  where: {
                    "Eccent_RepNo": RepNo
                  }
                });
              }


            }


          }


          {
            var objLinear = await copyObjects.linearity('tbl_calibration_linearity_master_incomplete'
              , 'tbl_calibration_linearity_master_failed', RepNo, 0, 'master');
            // Copying Incomplete master to failed master
            let columNames = objLinear.data.map(obj => obj.str_colName).toString();
            var str_Query = `insert into tbl_calibration_linearity_master_failed (${columNames}) select ${columNames} from tbl_calibration_linearity_master_incomplete where Linear_RepNo = ${RepNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
            let resultLinear = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
            // last inserted Id got here form query
            var lastInsertedIdLinear = resultLinear[0][0].LastInsertedRecord;
            // Updating the report serial number in failed master

            if (lastInsertedIdLinear != null) {

              await models.tbl_calibration_linearity_master_failed.update({
                "Linear_RepNo": fRerSrNo,
                "Linear_CalbTime": moment(new Date()).format('HH:mm:ss')
              }, {
                where: {
                  "srNo": lastInsertedIdLinear
                }
              }) // failed master report number updated
              // selecting data from incomplete details for copying

              var resultP = await models.tbl_calibration_linearity_detail_incomplete.findAll({
                where: {
                  "Linear_RepNo": RepNo
                }
              }); // selected
              let res = [{}]
              res[0].Linear_RepNo = resultP[0].Linear_RepNo
              res[0].Linear_RecNo = resultP[0].Linear_RecNo
              // as we have multiple entries i n details table so we need 
              // Async loop
              let i = 0;
              for (let obj of resultP) {
                obj.Linear_RecNo = resultP[i].Linear_RecNo
                let objCopyLinear = await copyObjects.linearity('tbl_calibration_linearity_detail_incomplete'
                  , 'tbl_calibration_linearity_detail_failed', obj.Linear_RepNo, obj.Linear_RecNo, 'detail');

                columNames = objCopyLinear.data.map(obj => obj.str_colName).toString();
                str_Query = `insert into tbl_calibration_linearity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_linearity_detail_incomplete where Linear_RepNo = ${obj.Linear_RepNo} AND Linear_RecNo = ${obj.Linear_RecNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
                let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                var lastInsertedIdU = detailInsert[0][0].LastInsertedRecord;

                await models.tbl_calibration_linearity_detail_failed.update({
                  "Linear_RepNo": fRerSrNo
                }, {
                  where: {
                    "srNo": lastInsertedIdU
                    // "Linear_RepNo": res[0].Linear_RepNo
                  }
                })
                i++;
              }

              if (tempCaibStatus.status['L'] == 0) {
                await models.tbl_calibration_linearity_master_incomplete.destroy({
                  where: {
                    "Linear_RepNo": RepNo
                  }
                })
                await models.tbl_calibration_linearity_detail_incomplete.destroy({
                  where: {
                    "Linear_RepNo": RepNo
                  }
                })
              }

            }
          }
          {
            var objUnccen = await copyObjects.uncertinity('tbl_calibration_uncertinity_master_incomplete'
              , 'tbl_calibration_uncertinity_master_failed', RepNo, 0, 'master');
            // console.log(obj)
            let columNames = objUnccen.data.map(obj => obj.str_colName).toString();
            var str_Query = `insert into tbl_calibration_uncertinity_master_failed (${columNames}) select ${columNames} from tbl_calibration_uncertinity_master_incomplete where Uncertinity_RepNo = ${RepNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
            let resultUnccen = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
            // console.log(result)
            var lastInsertedIdUnccen = resultUnccen[0][0].LastInsertedRecord;
            if (lastInsertedIdUnccen != null) {
              await models.tbl_calibration_uncertinity_master_failed.update({
                "Uncertinity_RepNo": fRerSrNo,
                "Uncertinity_CalbTime": moment(new Date()).format('HH:mm:ss')
              }, {
                where: {
                  "srNo": lastInsertedIdUnccen
                }
              })
              var selectDetailObjUnccen = {
                str_tableName: 'tbl_calibration_uncertinity_detail_incomplete',
                data: 'Uncertinity_RepNo,Uncertinity_RecNo',
                condition: [
                  { str_colName: 'Uncertinity_RepNo', value: RepNo, comp: 'eq' }
                ]
              }
              var resultU = await models.tbl_calibration_uncertinity_detail_incomplete.findAll({
                where: {
                  "Uncertinity_RepNo": RepNo
                }
              }); // selected
              let res = [{}]
              res[0].Uncertinity_RepNo = resultU[0].Uncertinity_RepNo
              res[0].Uncertinity_RecNo = resultU[0].Uncertinity_RecNo
              // console.log(result[0])
              let i = 0;
              for (let obj of resultU) {
                obj.Uncertinity_RecNo = resultU[i].Uncertinity_RecNo
                let objCopyUnccen = await copyObjects.uncertinity('tbl_calibration_uncertinity_detail_incomplete', 'tbl_calibration_uncertinity_detail_failed', obj.Uncertinity_RepNo, obj.Uncertinity_RecNo, 'detail');
                columNames = objCopyUnccen.data.map(obj => obj.str_colName).toString();
                str_Query = `insert into tbl_calibration_uncertinity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_uncertinity_detail_incomplete where Uncertinity_RepNo = ${obj.Uncertinity_RepNo} AND Uncertinity_RecNo = ${obj.Uncertinity_RecNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
                let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                var lastInsertedIdU = detailInsert[0][0].LastInsertedRecord;

                await models.tbl_calibration_uncertinity_detail_failed.update({
                  "Uncertinity_RepNo": fRerSrNo
                }, {
                  where: {
                    "srNo": lastInsertedIdU
                    // "Uncertinity_RepNo": obj.Uncertinity_RepNo
                  }
                })
                i++
              }
              if (tempCaibStatus.status['U'] == 0) {
                await models.tbl_calibration_uncertinity_master_incomplete.destroy({
                  where: {
                    "Uncertinity_RepNo": RepNo
                  }
                });
                await models.tbl_calibration_uncertinity_detail_incomplete.destroy({
                  where: {
                    "Uncertinity_RepNo": RepNo
                  }
                });
              }

            }


          }

          //   await models.tbl_calibration_status.update({

          //     'P': 0,
          //     'E': 0,
          //     'R': 0,
          //     'U': 0,
          //     'L': 0
          //   }, {
          //     where: {
          //       'BalID': strBalId
          //     }
          //   })
          // if (deleteEntry) {

          //     await models.tbl_calibration_periodic_master_incomplete.destroy({
          //         where: {
          //             "Periodic_RepNo": RepNo
          //         }
          //     });
          //     await models.tbl_calibration_periodic_detail_incomplete.destroy({
          //         where: {
          //             "Periodic_RepNo": RepNo
          //         }
          //     });

          //     await models.tbl_calibration_eccentricity_master_incomplete.destroy({
          //         where: {
          //             "Eccent_RepNo": RepNo
          //         }
          //     });
          //     await models.tbl_calibration_eccentricity_detail_incomplete.destroy({
          //         where: {
          //             "Eccent_RepNo": RepNo
          //         }
          //     });

          //     await models.tbl_calibration_repetability_master_incomplete.destroy({
          //         where: {
          //             "Repet_RepNo": RepNo
          //         }
          //     });
          //     await models.tbl_calibration_repetability_detail_incomplete.destroy({
          //         where: {
          //             "Repet_RepNo": RepNo
          //         }
          //     });

          //     let arrselectBalData = await models.tbl_balance.findOne({
          //         where: {
          //             'Bal_ID': strBalId
          //         }
          //     });
          //     arrselectBalData = [[arrselectBalData]]



          //     const bln_storeType = arrselectBalData[0][0].Bal_CalbStoreType
          //     // if (bln_storeType == 1) {
          //     //     // await models.tbl_calibration_status.update({
          //     //     //     // 'P': 0,
          //     //     //     // // 'E': 0,
          //     //     //     // 'R': 0,
          //     //     //     // 'U': 0,
          //     //     //     // 'L': 0
          //     //     // }, {
          //     //     //     where: {
          //     //     //         'BalID': strBalId
          //     //     //     }
          //     //     // });
          //     // } else {
          //     await models.tbl_calibration_status.update({
          //         'P': 0,
          //         'E': 0,
          //         'R': 0,

          //         // 'U': 0,
          //         // 'L': 0
          //     }, {
          //         where: {
          //             'BalID': strBalId
          //         }
          //     });
          // }
          // }



        }
          break;
        case 'Yearly': {
          // First copying data
          {
            var objUnccen = await copyObjects.uncertinity('tbl_calibration_uncertinity_master_incomplete'
              , 'tbl_calibration_uncertinity_master_failed', RepNo, 0, 'master');
            // console.log(obj)
            let columNames = objUnccen.data.map(obj => obj.str_colName).toString();
            var str_Query = `insert into tbl_calibration_uncertinity_master_failed (${columNames}) select ${columNames} from tbl_calibration_uncertinity_master_incomplete where Uncertinity_RepNo = ${RepNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
            let resultUnccen = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
            // console.log(result)
            var lastInsertedIdUnccen = resultUnccen[0];
            if (lastInsertedIdUnccen != 0) {
              await models.tbl_calibration_uncertinity_master_failed.update({
                "Uncertinity_RepNo": fRerSrNo,
                "Uncertinity_CalbTime": moment(new Date()).format('HH:mm:ss')
              }, {
                where: {
                  "srNo": lastInsertedIdUnccen
                }
              })
              var selectDetailObjUnccen = {
                str_tableName: 'tbl_calibration_uncertinity_detail_incomplete',
                data: 'Uncertinity_RepNo,Uncertinity_RecNo',
                condition: [
                  { str_colName: 'Uncertinity_RepNo', value: RepNo, comp: 'eq' }
                ]
              }
              var resultU = await models.tbl_calibration_uncertinity_detail_incomplete.findAll({
                where: {
                  "Uncertinity_RepNo": RepNo
                }
              }); // selected
              let res = [{}]
              res[0].Uncertinity_RepNo = resultU[0].Uncertinity_RepNo
              res[0].Uncertinity_RecNo = resultU[0].Uncertinity_RecNo
              // console.log(result[0])
              let i = 0;
              for (let obj of resultU) {
                obj.Uncertinity_RecNo = resultU[i].Uncertinity_RecNo
                let objCopyUnccen = await copyObjects.uncertinity('tbl_calibration_uncertinity_detail_incomplete', 'tbl_calibration_uncertinity_detail_failed', obj.Uncertinity_RepNo, obj.Uncertinity_RecNo, 'detail');
                columNames = objCopyUnccen.data.map(obj => obj.str_colName).toString();
                str_Query = `insert into tbl_calibration_uncertinity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_uncertinity_detail_incomplete where Uncertinity_RepNo = ${obj.Uncertinity_RepNo} AND Uncertinity_RecNo = ${obj.Uncertinity_RecNo} select SCOPE_IDENTITY() as [LastInsertedRecord]aa`
                let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                var lastInsertedIdU = detailInsert[0];

                await models.tbl_calibration_uncertinity_detail_failed.update({
                  "Uncertinity_RepNo": fRerSrNo
                }, {
                  where: {
                    "srNo": lastInsertedIdU
                    // "Uncertinity_RepNo": obj.Uncertinity_RepNo
                  }
                })
                i++
              }
              if (tempCaibStatus.status['U'] == 0) {
                await models.tbl_calibration_uncertinity_master_incomplete.destroy({
                  where: {
                    "Uncertinity_RepNo": RepNo
                  }
                });
                await models.tbl_calibration_uncertinity_detail_incomplete.destroy({
                  where: {
                    "Uncertinity_RepNo": RepNo
                  }
                });
              }

            }


          }

          // {
          //     var objEccen = await copyObjects.eccentricity('tbl_calibration_eccentricity_master_incomplete'
          //         , 'tbl_calibration_eccentricity_master_failed', RepNo, 0, 'master');
          //     // console.log(obj)
          //     let columNames = objEccen.data.map(obj => obj.str_colName).toString();
          //     var str_Query = `insert into tbl_calibration_eccentricity_master_failed (${columNames}) select ${columNames} from tbl_calibration_eccentricity_master_incomplete where Eccent_RepNo = ${RepNo}`
          //     let resultEccen = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
          //     // console.log(result)
          //     var lastInsertedIdEccen = resultEccen[0];

          //     if (lastInsertedIdEccen != 0) {
          //         await models.tbl_calibration_eccentricity_master_failed.update({
          //             "Eccent_RepNo": fRerSrNo,
          //             "Eccent_CalbTime": moment(new Date()).format('HH:mm:ss')
          //         }, {
          //             where: {
          //                 "srNo": lastInsertedIdEccen
          //             }
          //         })

          //         var resultP = await models.tbl_calibration_eccentricity_detail_incomplete.findAll({
          //             where: {
          //                 "Eccent_RepNo": RepNo
          //             }
          //         }); // selected
          //         let res = [{}]
          //         res[0].Eccent_RepNo = resultP[0].Eccent_RepNo
          //         res[0].Eccent_RecNo = resultP[0].Eccent_RecNo
          //         // console.log(result[0])
          //         let i = 0;
          //         for (let obj of resultP) {
          //             obj.Eccent_RecNo = resultP[i].Eccent_RecNo
          //             let objCopyEccen = await copyObjects.eccentricity('tbl_calibration_eccentricity_detail_incomplete'
          //                 , 'tbl_calibration_eccentricity_detail_failed', obj.Eccent_RepNo, obj.Eccent_RecNo, 'detail');
          //             columNames = objCopyEccen.data.map(obj => obj.str_colName).toString();
          //             str_Query = `insert into tbl_calibration_eccentricity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_eccentricity_detail_incomplete where Eccent_RepNo = ${obj.Eccent_RepNo} AND Eccent_RecNo = ${obj.Eccent_RecNo}`
          //             let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

          //             var lastInsertedIdU = detailInsert[0];

          //             await models.tbl_calibration_eccentricity_detail_failed.update({
          //                 "Eccent_RepNo": fRerSrNo,
          //                 "Eccent_CalbTime": moment(new Date()).format('HH:mm:ss')
          //             }, {
          //                 where: {
          //                     "srNo": lastInsertedIdU
          //                     // "Eccent_RepNo":  res[0].Eccent_RepNo
          //                 }
          //             })
          //             i++

          //         }

          //         if (tempCaibStatus.status['E'].readIntLE() == 0) {
          //             await models.tbl_calibration_eccentricity_master_incomplete.destroy({
          //                 where: {
          //                     "Eccent_RepNo": RepNo
          //                 }
          //             });
          //             await models.tbl_calibration_eccentricity_detail_incomplete.destroy({
          //                 where: {
          //                     "Eccent_RepNo": RepNo
          //                 }
          //             });
          //         }


          //     }


          // }
          {
            var objLinear = await copyObjects.linearity('tbl_calibration_linearity_master_incomplete'
              , 'tbl_calibration_linearity_master_failed', RepNo, 0, 'master');
            // Copying Incomplete master to failed master
            let columNames = objLinear.data.map(obj => obj.str_colName).toString();
            var str_Query = `insert into tbl_calibration_linearity_master_failed (${columNames}) select ${columNames} from tbl_calibration_linearity_master_incomplete where Linear_RepNo = ${RepNo}`
            let resultLinear = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
            // last inserted Id got here form query
            var lastInsertedIdLinear = resultLinear[0];
            // Updating the report serial number in failed master

            if (lastInsertedIdLinear != 0) {

              await models.tbl_calibration_linearity_master_failed.update({
                "Linear_RepNo": fRerSrNo,
                "Linear_CalbTime": moment(new Date()).format('HH:mm:ss')
              }, {
                where: {
                  "srNo": lastInsertedIdLinear
                }
              }) // failed master report number updated
              // selecting data from incomplete details for copying

              var resultP = await models.tbl_calibration_linearity_detail_incomplete.findAll({
                where: {
                  "Linear_RepNo": RepNo
                }
              }); // selected
              let res = [{}]
              res[0].Linear_RepNo = resultP[0].Linear_RepNo
              res[0].Linear_RecNo = resultP[0].Linear_RecNo
              // as we have multiple entries i n details table so we need 
              // Async loop
              let i = 0;
              for (let obj of resultP) {
                obj.Linear_RecNo = resultP[i].Linear_RecNo
                let objCopyLinear = await copyObjects.linearity('tbl_calibration_linearity_detail_incomplete'
                  , 'tbl_calibration_linearity_detail_failed', obj.Linear_RepNo, obj.Linear_RecNo, 'detail');

                columNames = objCopyLinear.data.map(obj => obj.str_colName).toString();
                str_Query = `insert into tbl_calibration_linearity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_linearity_detail_incomplete where Linear_RepNo = ${obj.Linear_RepNo} AND Linear_RecNo = ${obj.Linear_RecNo}`
                let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                var lastInsertedIdU = detailInsert[0];

                await models.tbl_calibration_linearity_detail_failed.update({
                  "Linear_RepNo": fRerSrNo
                }, {
                  where: {
                    "srNo": lastInsertedIdU
                    // "Linear_RepNo": res[0].Linear_RepNo
                  }
                })
                i++;
              }

              if (tempCaibStatus.status['L'] == 0) {
                await models.tbl_calibration_linearity_master_incomplete.destroy({
                  where: {
                    "Linear_RepNo": RepNo
                  }
                })
                await models.tbl_calibration_linearity_detail_incomplete.destroy({
                  where: {
                    "Linear_RepNo": RepNo
                  }
                })
              }

            }
          }

          if (deleteEntry) {
            await models.tbl_calibration_uncertinity_master_incomplete.destroy({
              where: {
                "Uncertinity_RepNo": RepNo
              }
            });
            await models.tbl_calibration_uncertinity_detail_incomplete.destroy({
              where: {
                "Uncertinity_RepNo": RepNo
              }
            });

            // await models.tbl_calibration_eccentricity_master_incomplete.destroy({
            //     where: {
            //         "Eccent_RepNo": RepNo
            //     }
            // });
            // await models.tbl_calibration_eccentricity_detail_incomplete.destroy({
            //     where: {
            //         "Eccent_RepNo": RepNo
            //     }
            // });

            await models.tbl_calibration_linearity_master_incomplete.destroy({
              where: {
                "Linear_RepNo": RepNo
              }
            });
            await models.tbl_calibration_linearity_detail_incomplete.destroy({
              where: {
                "Linear_RepNo": RepNo
              }
            });

            let arrselectBalData = await models.tbl_balance.findOne({
              where: {
                'Bal_ID': strBalId
              }
            });
            arrselectBalData = [[arrselectBalData]]



            const bln_storeType = arrselectBalData[0][0].Bal_CalbStoreType
            // if (bln_storeType == 1) {
            await models.tbl_calibration_status.update({

              // 'E': 0,

              'U': 0,
              'L': 0
            }, {
              where: {
                'BalID': strBalId
              }
            })
            // } else {
            //     await models.tbl_calibration_status.update({

            //         'E': 0,

            //         'U': 0,
            //         'L': 0
            //     }, {
            //         where: {
            //             'BalID': strBalId
            //         }
            //     })
            // }



          }

        }
      }


      // switch (CalibrationType) {
      //     // For case PERIODIC CALIBRATION
      //     case 'P': {
      //         var objPeriodic = await copyObjects.periodic('tbl_calibration_periodic_master_incomplete'
      //             , 'tbl_calibration_periodic_master_failed', RepNo, 0, 'master')
      //         // Copying Incomplete master to failed master

      //         let columNames = objPeriodic.data.map(obj => obj.str_colName).toString();
      //         var str_Query = `insert into tbl_calibration_periodic_master_failed (${columNames}) select ${columNames} from tbl_calibration_periodic_master_incomplete where Periodic_RepNo = ${RepNo}`
      //         let resultPeriodic = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

      //         // last inserted Id got here form querymasterInsert[0]
      //         var lastInsertedIdPeriodic = resultPeriodic[0];
      //         // Updating the report serial number in failed master

      //         await models.tbl_calibration_periodic_master_failed.update({
      //             "Periodic_RepNo": fRerSrNo,
      //             "Periodic_EndTime": moment(new Date()).format('HH:mm:ss')
      //         }, {
      //             where: {
      //                 "srNo": lastInsertedIdPeriodic
      //             }
      //         })


      //         // selecting data from incomplete details for copying
      //         var resultP = await models.tbl_calibration_periodic_detail_incomplete.findAll({
      //             where: {
      //                 "Periodic_RepNo": RepNo
      //             }
      //         }); // selected
      //         let res = [{}]
      //         res[0].Periodic_RepNo = resultP[0].Periodic_RepNo
      //         res[0].Periodic_RecNo = resultP[0].Periodic_RecNo
      //         let i = 0;
      //         for (let obj of resultP) {
      //             obj.Periodic_RecNo = resultP[i].Periodic_RecNo
      //             // as we have multiple entries i n details table so we need 
      //             // Async loop



      //             let objCopyPeriodic = await copyObjects.periodic('tbl_calibration_periodic_detail_incomplete'
      //                 , 'tbl_calibration_periodic_detail_failed', obj.Periodic_RepNo, obj.Periodic_RecNo, 'detail');

      //             columNames = objCopyPeriodic.data.map(obj => obj.str_colName).toString();
      //             str_Query = `insert into tbl_calibration_periodic_detail_failed (${columNames}) select ${columNames} from tbl_calibration_periodic_detail_incomplete where Periodic_RepNo = ${obj.Periodic_RepNo} AND Periodic_RecNo = ${obj.Periodic_RecNo}`
      //             let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

      //             var lastInsertedIdP = detailInsert[0];


      //             await models.tbl_calibration_periodic_detail_failed.update({
      //                 "Periodic_RepNo": fRerSrNo
      //             }, {
      //                 where: {
      //                     "srNo": lastInsertedIdP
      //                     // "Periodic_RepNo": res[0].Periodic_RepNo
      //                 }
      //             })

      //             // updated repSrNo in failed details 
      //             // console.log('P Copy')
      //             // If ongoing calibration is failed ('Periodic') then only we have to delete
      //             // records from incomplete tables for new entries

      //             i++;
      //         }
      //         // for (let obj of res) {
      //         //     obj.Periodic_RecNo = resultU[i].Periodic_RecNo
      //         //     // as we have multiple entries i n details table so we need 
      //         //     // Async loop



      //         //     let objCopyPeriodic = await copyObjects.periodic('tbl_calibration_periodic_detail_incomplete'
      //         //         , 'tbl_calibration_periodic_detail_failed', obj.Periodic_RepNo, obj.Periodic_RecNo, 'detail');

      //         //     columNames = objCopyPeriodic.data.map(obj => obj.str_colName).toString();
      //         //     str_Query = `insert into tbl_calibration_periodic_detail_failed (${columNames}) select ${columNames} from tbl_calibration_periodic_detail_incomplete where Periodic_RepNo = ${obj.Periodic_RepNo}`
      //         //     let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

      //         //     var lastInsertedIdP = detailInsert[0];


      //         //     await models.tbl_calibration_periodic_detail_failed.update({
      //         //         "Periodic_RepNo": fRerSrNo
      //         //     }, {
      //         //         where: {
      //         //             // "srNo": lastInsertedIdP
      //         //             "Periodic_RepNo": res[0].Periodic_RepNo
      //         //         }
      //         //     })

      //         //     // updated repSrNo in failed details 
      //         //     // console.log('P Copy')
      //         //     // If ongoing calibration is failed ('Periodic') then only we have to delete
      //         //     // records from incomplete tables for new entries

      //         // i++;
      //         // }

      //         if (sortedArray.indexOf('P') == int_curentCalibrationIndex) {
      //             // delete records from incomplete tables

      //             await models.tbl_calibration_periodic_master_incomplete.destroy({
      //                 where: {
      //                     "Periodic_RepNo": RepNo
      //                 }
      //             })
      //             await models.tbl_calibration_periodic_detail_incomplete.destroy({
      //                 where: {
      //                     "Periodic_RepNo": RepNo
      //                 }
      //             })


      //         }
      //     }
      //         break;
      //     // For case UNCERTINITY CALIBRATION
      //     case 'U': {
      //         // First copying data
      //         var objUnccen = await copyObjects.uncertinity('tbl_calibration_uncertinity_master_incomplete'
      //             , 'tbl_calibration_uncertinity_master_failed', RepNo, 0, 'master');
      //         // console.log(obj)
      //         let columNames = objUnccen.data.map(obj => obj.str_colName).toString();
      //         var str_Query = `insert into tbl_calibration_uncertinity_master_failed (${columNames}) select ${columNames} from tbl_calibration_uncertinity_master_incomplete where Uncertinity_RepNo = ${RepNo}`
      //         let resultUnccen = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
      //         // console.log(result)
      //         var lastInsertedIdUnccen = resultUnccen[0];

      //         await models.tbl_calibration_uncertinity_master_failed.update({
      //             "Uncertinity_RepNo": fRerSrNo,
      //             "Uncertinity_EndTime": moment(new Date()).format('HH:mm:ss')
      //         }, {
      //             where: {
      //                 "srNo": lastInsertedIdUnccen
      //             }
      //         })
      //         var selectDetailObjUnccen = {
      //             str_tableName: 'tbl_calibration_uncertinity_detail_incomplete',
      //             data: 'Uncertinity_RepNo,Uncertinity_RecNo',
      //             condition: [
      //                 { str_colName: 'Uncertinity_RepNo', value: RepNo, comp: 'eq' }
      //             ]
      //         }
      //         var resultU = await models.tbl_calibration_uncertinity_detail_incomplete.findAll({
      //             where: {
      //                 "Uncertinity_RepNo": RepNo
      //             }
      //         }); // selected
      //         let res = [{}]
      //         res[0].Uncertinity_RepNo = resultU[0].Uncertinity_RepNo
      //         res[0].Uncertinity_RecNo = resultU[0].Uncertinity_RecNo
      //         // console.log(result[0])
      //         let i = 0;
      //         for (let obj of resultU) {
      //             obj.Uncertinity_RecNo = resultU[i].Uncertinity_RecNo
      //             let objCopyUnccen = await copyObjects.uncertinity('tbl_calibration_uncertinity_detail_incomplete', 'tbl_calibration_uncertinity_detail_failed', obj.Uncertinity_RepNo, obj.Uncertinity_RecNo, 'detail');
      //             columNames = objCopyUnccen.data.map(obj => obj.str_colName).toString();
      //             str_Query = `insert into tbl_calibration_uncertinity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_uncertinity_detail_incomplete where Uncertinity_RepNo = ${obj.Uncertinity_RepNo} AND Uncertinity_RecNo = ${obj.Uncertinity_RecNo}`
      //             let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

      //             var lastInsertedIdU = detailInsert[0];

      //             await models.tbl_calibration_uncertinity_detail_failed.update({
      //                 "Uncertinity_RepNo": fRerSrNo
      //             }, {
      //                 where: {
      //                     "srNo": lastInsertedIdU
      //                     // "Uncertinity_RepNo": obj.Uncertinity_RepNo
      //                 }
      //             })
      //             i++
      //         }

      //         if (sortedArray.indexOf('U') == int_curentCalibrationIndex) {
      //             // delete records from incomplete tables
      //             console.log('inside delete')

      //             await models.tbl_calibration_uncertinity_master_incomplete.destroy({
      //                 where: {
      //                     "Uncertinity_RepNo": RepNo
      //                 }
      //             })
      //             await models.tbl_calibration_uncertinity_detail_incomplete.destroy({
      //                 where: {
      //                     "Uncertinity_RepNo": RepNo
      //                 }
      //             })
      //         }
      //     }
      //         break;
      //     // For case ECCENTRICITY CALIBRATION
      //     case 'E': {
      //         // First copying data
      //         var objEccen = await copyObjects.eccentricity('tbl_calibration_eccentricity_master_incomplete'
      //             , 'tbl_calibration_eccentricity_master_failed', RepNo, 0, 'master');
      //         // console.log(obj)
      //         let columNames = objEccen.data.map(obj => obj.str_colName).toString();
      //         var str_Query = `insert into tbl_calibration_eccentricity_master_failed (${columNames}) select ${columNames} from tbl_calibration_eccentricity_master_incomplete where Eccent_RepNo = ${RepNo}`
      //         let resultEccen = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
      //         // console.log(result)
      //         var lastInsertedIdEccen = resultEccen[0]

      //         await models.tbl_calibration_eccentricity_master_failed.update({
      //             "Eccent_RepNo": fRerSrNo,
      //             "Eccent_EndTime": moment(new Date()).format('HH:mm:ss')
      //         }, {
      //             where: {
      //                 "srNo": lastInsertedIdEccen
      //             }
      //         })

      //         var resultP = await models.tbl_calibration_eccentricity_detail_incomplete.findAll({
      //             where: {
      //                 "Eccent_RepNo": RepNo
      //             }
      //         }); // selected
      //         let res = [{}]
      //         res[0].Eccent_RepNo = resultP[0].Eccent_RepNo
      //         res[0].Eccent_RecNo = resultP[0].Eccent_RecNo
      //         // console.log(result[0])
      //         let i = 0;
      //         for (let obj of resultP) {
      //             obj.Eccent_RecNo = resultP[i].Eccent_RecNo
      //             let objCopyEccen = await copyObjects.eccentricity('tbl_calibration_eccentricity_detail_incomplete'
      //                 , 'tbl_calibration_eccentricity_detail_failed', obj.Eccent_RepNo, obj.Eccent_RecNo, 'detail');
      //             columNames = objCopyEccen.data.map(obj => obj.str_colName).toString();
      //             str_Query = `insert into tbl_calibration_eccentricity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_eccentricity_detail_incomplete where Eccent_RepNo = ${obj.Eccent_RepNo} AND Eccent_RecNo = ${obj.Eccent_RecNo}`
      //             let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

      //             var lastInsertedIdU = detailInsert[0];

      //             await models.tbl_calibration_uncertinity_detail_failed.update({
      //                 "Eccent_RepNo": fRerSrNo,
      //                 "Linear_EndTime": moment(new Date()).format('HH:mm:ss')
      //             }, {
      //                 where: {
      //                     "srNo": lastInsertedIdU
      //                     // "Eccent_RepNo":  res[0].Eccent_RepNo
      //                 }
      //             })
      //             i++

      //         }
      //         if (sortedArray.indexOf('E') == int_curentCalibrationIndex) {
      //             // delete records from incomplete tables
      //             console.log('inside delete')

      //             await models.tbl_calibration_eccentricity_master_incomplete.destroy({
      //                 where: {
      //                     "Eccent_RepNo": RepNo
      //                 }
      //             })
      //             await models.tbl_calibration_eccentricity_detail_incomplete.destroy({
      //                 where: {
      //                     "Eccent_RepNo": RepNo
      //                 }
      //             })
      //         }
      //     }
      //         break;
      //     // For case REPETABILITY CALIBRATION
      //     case 'R': {
      //         var objReap = await copyObjects.repetability('tbl_calibration_repetability_master_incomplete'
      //             , 'tbl_calibration_repetability_master_failed', RepNo, 0, 'master');
      //         // Copying Incomplete master to failed master
      //         let columNames = objReap.data.map(obj => obj.str_colName).toString();
      //         var str_Query = `insert into tbl_calibration_repetability_master_failed (${columNames}) select ${columNames} from tbl_calibration_repetability_master_incomplete where Repet_RepNo = ${RepNo}`
      //         let resultReap = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
      //         // last inserted Id got here form query
      //         var lastInsertedIdReap = resultReap[0];
      //         // Updating the report serial number in failed master

      //         await models.tbl_calibration_repetability_master_failed.update({
      //             "Repet_RepNo": fRerSrNo,
      //             "Repet_EndTime": moment(new Date()).format('HH:mm:ss')
      //         }, {
      //             where: {
      //                 "srNo": lastInsertedIdReap
      //             }
      //         }) // failed master report number updated
      //         // selecting data from incomplete details for copying

      //         var resultP = await models.tbl_calibration_repetability_detail_incomplete.findAll({
      //             where: {
      //                 "Repet_RepNo": RepNo
      //             }
      //         }); // selected
      //         let res = [{}]
      //         res[0].Repet_RepNo = resultP[0].Repet_RepNo
      //         res[0].Repet_RecNo = resultP[0].Repet_RecNo
      //         // as we have multiple entries i n details table so we need 
      //         // Async loop
      //         let i = 0;
      //         for (let obj of resultP) {
      //             obj.Repet_RecNo = resultP[i].Repet_RecNo
      //             let objCopyReap = await copyObjects.repetability('tbl_calibration_repetability_detail_incomplete'
      //                 , 'tbl_calibration_repetability_detail_failed', obj.Repet_RepNo, obj.Repet_RecNo, 'detail');

      //             columNames = objCopyReap.data.map(obj => obj.str_colName).toString();
      //             str_Query = `insert into tbl_calibration_repetability_detail_failed (${columNames}) select ${columNames} from tbl_calibration_repetability_detail_incomplete where Repet_RecNo = ${obj.Repet_RecNo} AND Repet_RecNo = ${obj.Repet_RecNo}`
      //             let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

      //             var lastInsertedIdU = detailInsert[0];

      //             await models.tbl_calibration_uncertinity_detail_failed.update({
      //                 "Repet_RepNo": fRerSrNo
      //             }, {
      //                 where: {
      //                     "srNo": lastInsertedIdU
      //                     // "Repet_RepNo": res[0].Repet_RepNo
      //                 }
      //             })
      //             i++
      //         }

      //         if (sortedArray.indexOf('R') == int_curentCalibrationIndex) {
      //             // delete records from incomplete tables
      //             console.log('inside delete')

      //             await models.tbl_calibration_repetability_master_incomplete.destroy({
      //                 where: {
      //                     "Repet_RepNo": RepNo
      //                 }
      //             })
      //             await models.tbl_calibration_repetability_detail_incomplete.destroy({
      //                 where: {
      //                     "Repet_RepNo": RepNo
      //                 }
      //             })

      //         }
      //     }
      //         break;

      //     // For case Linearity CALIBRATION
      //     case 'L': {
      //         var objLinear = await copyObjects.linearity('tbl_calibration_linearity_master_incomplete'
      //             , 'tbl_calibration_linearity_master_failed', RepNo, 0, 'master');
      //         // Copying Incomplete master to failed master
      //         let columNames = objLinear.data.map(obj => obj.str_colName).toString();
      //         var str_Query = `insert into tbl_calibration_linearity_master_failed (${columNames}) select ${columNames} from tbl_calibration_linearity_master_incomplete where Linear_RepNo = ${RepNo}`
      //         let resultLinear = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
      //         // last inserted Id got here form query
      //         var lastInsertedIdLinear = resultLinear[0];
      //         // Updating the report serial number in failed master

      //         await models.tbl_calibration_linearity_master_failed.update({
      //             "Linear_RepNo": fRerSrNo,
      //             "Linear_EndTime": moment(new Date()).format('HH:mm:ss')
      //         }, {
      //             where: {
      //                 "srNo": lastInsertedIdLinear
      //             }
      //         }) // failed master report number updated
      //         // selecting data from incomplete details for copying

      //         var resultP = await models.tbl_calibration_linearity_detail_incomplete.findAll({
      //             where: {
      //                 "Linear_RepNo": RepNo
      //             }
      //         }); // selected
      //         let res = [{}]
      //         res[0].Linear_RepNo = resultP[0].Linear_RepNo
      //         res[0].Linear_RecNo = resultP[0].Linear_RecNo
      //         // as we have multiple entries i n details table so we need 
      //         // Async loop
      //         let i = 0;
      //         for (let obj of res) {
      //             obj.Linear_RecNo = resultP[i].Linear_RecNo
      //             let objCopyLinear = await copyObjects.linearity('tbl_calibration_linearity_detail_incomplete'
      //                 , 'tbl_calibration_linearity_detail_failed', obj.Linear_RepNo, obj.Linear_RecNo, 'detail');

      //             columNames = objCopyLinear.data.map(obj => obj.str_colName).toString();
      //             str_Query = `insert into tbl_calibration_linearity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_linearity_detail_incomplete where Linear_RecNo = ${obj.Linear_RecNo} AND Linear_RecNo = ${obj.Linear_RecNo}`
      //             let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

      //             var lastInsertedIdU = detailInsert[0];

      //             await models.tbl_calibration_linearity_detail_failed.update({
      //                 "Linear_RepNo": fRerSrNo
      //             }, {
      //                 where: {
      //                     "srNo": lastInsertedIdU
      //                     // "Linear_RepNo": res[0].Linear_RepNo
      //                 }
      //             })
      //             i++;
      //         }

      //         if (sortedArray.indexOf('L') == int_curentCalibrationIndex) {
      //             // delete records from incomplete tables
      //             console.log('inside delete')

      //             await models.tbl_calibration_linearity_master_incomplete.destroy({
      //                 where: {
      //                     "Linear_RepNo": RepNo
      //                 }
      //             })
      //             await models.tbl_calibration_linearity_detail_incomplete.destroy({
      //                 where: {
      //                     "Linear_RepNo": RepNo
      //                 }
      //             })

      //         }
      //     }
      //         break;

      // }
    } catch (error) {
      console.log(error)
    }
  }

  async getFrepSrNo(str_first_calibration) {
    // str_first_calibration : - is the first calibration in the process

    switch (str_first_calibration) {
      case "P":
        var str_FailedTable = "tbl_calibration_periodic_master_failed"; // tableName
        var strRepNoColName = "Periodic_RepNo"; //column name
        var fRerSrNo = await this.calculateFrepSr(
          str_FailedTable,
          strRepNoColName
        ); // function call
        return fRerSrNo; // returning promise

      case "U":
        var str_FailedTable = "tbl_calibration_uncertinity_master_failed"; // tableName
        var strRepNoColName = "Uncertinity_RepNo"; //column name
        var fRerSrNo = await this.calculateFrepSr(
          str_FailedTable,
          strRepNoColName
        ); // function call
        return fRerSrNo; // returning promise
      case "R":
        var str_FailedTable = "tbl_calibration_repetability_master_failed"; // tableName
        var strRepNoColName = "Repet_RepNo"; //column name
        var fRerSrNo = await this.calculateFrepSr(
          str_FailedTable,
          strRepNoColName
        ); // function call
        return fRerSrNo; // returning promise
      case "E":
        var str_FailedTable = "tbl_calibration_eccentricity_master_failed"; // tableName
        var strRepNoColName = "Eccent_RepNo"; //column name
        var fRerSrNo = await this.calculateFrepSr(
          str_FailedTable,
          strRepNoColName
        ); // function call
        return fRerSrNo; // returning promise
      case "L":
        var str_FailedTable = "tbl_calibration_linearity_master_failed"; // tableName
        var strRepNoColName = "Linear_RepNo"; //column name
        var fRerSrNo = await this.calculateFrepSr(
          str_FailedTable,
          strRepNoColName
        ); // function call
        return fRerSrNo; // returning promise
      case "V":
        var str_FailedTable = "tbl_calibration_positional_master_failed";
        var strRepNoColName = "Positional_RepNo"; //column name
        var fRerSrNo = await this.calculateFrepSr(
          str_FailedTable,
          strRepNoColName
        ); // function call
        return fRerSrNo; // returning promise
    }
  }

  async calculateFrepSr(str_FailedTable, strRepNoColName) {
    let result = await models[str_FailedTable].findAll({
      attributes: [
        [sequelize.fn("max", sequelize.col(strRepNoColName)), "FRepSrNo"],
      ],
    });

    var FrepSrNo;
    // If entries not present
    if (result[0].FRepSrNo == null) {
      FrepSrNo = 1;
    } else {
      // If there are some records
      FrepSrNo = result[0].FRepSrNo + 1;
    }
    return FrepSrNo;
  }
}
module.exports = LoginModal