const ClassweighmentData = require('../clsProcessWeighment.model');
const DailyCalibrationModel = require('../Calibration/clsdailyCalibration.model');
const ClassPeriodicCalibration = require('../Calibration/clsPeriodicCalibration.model');
const ClassEccenCalibration = require('../Calibration/clsEccentricity.model');
const RepeatabilityCalibrationModel = require('../Calibration/clsRepeatability.model');
const uncertinityCalibrationModel = require('../Calibration/clsUncertainty.model');
const linearityCalibrationModel = require('../Calibration/clslinearity.model');
const classHmi = require('../hmiDetail.model');
const mqttProtocols = require('../../global/GLOBAL_NOMENCLATURE');
const loggers = require('../winstonLogger');
const globalData = require('../../global/globalData');
const clsMqttSender = require('../../model/Mqtt/mqttSender.class');
const GLOBAL_NOMENCLATURE = require('../../global/GLOBAL_NOMENCLATURE');
const { models } = require('../../../config/dbConnection');

const objWeighmentData = new ClassweighmentData();
const dailyCalibrationModel = new DailyCalibrationModel();
const periodiccalibrationModel = new ClassPeriodicCalibration();
const eccentricityCaibration = new ClassEccenCalibration();
const repetabilityCalibration = new RepeatabilityCalibrationModel();
const uncertinityCalibModel = new uncertinityCalibrationModel();
const linearityCalibration = new linearityCalibrationModel();
const objHmi = new classHmi();
const mqttSender = new clsMqttSender();
const { create, all } = require("mathjs");
const config = {};
const mathj = create(all, config);

class BalanceParsing {

    precision(a) {
        if (!isFinite(a)) return 0;
        var e = 1, p = 0;
        while (Math.round(a * e) / e !== a) { e *= 10; p++; }
        return p;
    }

    async parsingBalanceData(dataObj) {
        try {

            let { str_Protocol, strResberryPi, strHmi,
                ProtocolPortNo, InstrumentId, ProtocolName, InstrumentType } = dataObj;
            //here also different balance have different parsing logic
            let data = str_Protocol.split(":")[2].trim();
            let arrWtDetail = data.substr(data.search(/\d/));
            let ProtocolDataAndUnit = arrWtDetail.split(" ");
            let Unit = (ProtocolDataAndUnit[1]).toLowerCase();
            let arrRemoveBlankSpace = ProtocolDataAndUnit.filter(item => item);
            if (!arrRemoveBlankSpace[1]) {
                mqttSender.sendData(strHmi, "", arrRemoveBlankSpace[0]);
                return
            }
            let actualWt = arrRemoveBlankSpace[0];
            if (actualWt.match(/[a-zA-z]/g) != null && (!actualWt.includes(' '))) {
                mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`, actualWt);
                console.log("Invalid Weight Received", actualWt);
                return
            }
            // actualWt = parseFloat(actualWt).toFixed(this.precision(Number(actualWt)));
            // actualWt = parseFloat(mathj.round(actualWt,3)).toFixed(3);
            // var ProtocolDecPoint = actualWt.includes('.') == false ? 0 : actualWt.split('.')[1].length
            // }
            var balanceData = await models.tbl_balance.findOne({
                attributes: ['Bal_DP'],
                where: { Bal_ID: dataObj.InstrumentId }
            })
            if (balanceData) var ProtocolDecPoint = balanceData.Bal_DP;

            actualWt = Unit != 'mg' ? Number(mathj.round(actualWt, ProtocolDecPoint)).toFixed(ProtocolDecPoint) : Number(mathj.round(actualWt, 1)).toFixed(1)

            let negativeWeightCheck = data.substr(data.search(/-/));

            let ProtocolUnit = arrRemoveBlankSpace[1];
            ProtocolUnit =  ProtocolUnit.startsWith('g') ? "gm" : ProtocolUnit;
            // ProtocolUnit = ProtocolUnit.startsWith('g') || ProtocolUnit.startsWith('G') || ProtocolUnit.startsWith('GM') ? "g" : ProtocolUnit;
            let currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.Hmi == strHmi);
            let tempCailibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);
            let arrPortDetailForStart1 = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);//await objHmi.idsPortSetting(strHmi);
            //Instrument Type,ID,PortNo
            //let intPortNo1 = arrPortDetailForStart1.port;
            let strInstrumentType = InstrumentType;
            let strInstrumentId = InstrumentId;

            const __parameterWeighmentObj = {
                idsNo: strResberryPi,
                Hmi: strHmi,
                actualWt: actualWt,
                decPoint: ProtocolDecPoint,
                unit: ProtocolUnit,
                instrumentId: strInstrumentId,
                ProtocolPortNo: ProtocolPortNo
            }

            //unit and Port Validation 11/05/23
            if (arrPortDetailForStart1 != undefined) {
                if (arrPortDetailForStart1.portNo != dataObj.ProtocolPortNo) {
                    return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid Port Received`);

                };
                if ((arrPortDetailForStart1.selectedProductDetail.unit).toLowerCase() == (ProtocolUnit).toLowerCase() || ((arrPortDetailForStart1.selectedProductDetail.unit).toLowerCase() == "g" && (ProtocolUnit).toLowerCase()== 'gm' )) {
                    if (ProtocolUnit.startsWith('g')) {
                        ProtocolUnit = ProtocolUnit == "g" ? "g" : "g"
                    } else {
                        ProtocolUnit = ProtocolUnit;
                    }

                } else {
                    mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid Unit Received`)
                    // if (autoTare)  mqttSender.sendData( strHmi,`${mqttProtocols.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                    return;
                };
            };


            //make function for it and return boolean 
            if (actualWt.endsWith('mg' || 'g' || 'kg' || 'gm')) {
                //log protocol in file
                loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`)
                return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`)
            }

            if (actualWt == (undefined || "NaN" || 0 || NaN) || negativeWeightCheck.charAt(0) == "-" ||
                ProtocolPortNo == (undefined || "") || data.startsWith('I4') || data == "") {

                //log protocol in file
                loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`)
                return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`)
            }


            if (data !== "") {
                if (ProtocolDataAndUnit.length < 1 || ProtocolDataAndUnit[1] == "") {
                    //log protocol in file
                    loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`)
                    return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`);
                }

                if (ProtocolUnit === "A") {
                    return;
                } else {
                    if (strInstrumentType == GLOBAL_NOMENCLATURE.Balance || strInstrumentType == GLOBAL_NOMENCLATURE.IPCBalance) {
                        if (ProtocolUnit == undefined) {
                            ProtocolUnit = ProtocolUnit == undefined ? "g" : "g" ? "g" : ProtocolUnit;
                        } else {
                            if ((ProtocolUnit != "g") && (ProtocolUnit != "G") && (ProtocolUnit != "gm") && (ProtocolUnit != "GM") && (ProtocolUnit != "Gm") && (ProtocolUnit != 'kg') && (ProtocolUnit != "mg") && (ProtocolUnit != 'Mg') && (ProtocolUnit != "MG") && (ProtocolUnit != "mG") && (ProtocolUnit != 'gm') && (ProtocolUnit != 'Kg') && (ProtocolUnit != "KG") && (ProtocolUnit != "gM")) {
                                //log protocol in file
                                loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}Invalid Data String sended to device ${strHmi}`)
                                return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid Data String`);
                            } else {
                                // if (ProtocolUnit == "mg") {
                                //     actualWt = actualWt / 1000;
                                // } else if (ProtocolUnit == ("kg" || "Kg" || "KG")) {
                                //     actualWt = actualWt * 1000;
                                // }
                                // ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;

                            }
                        }

                    } else {
                        //log protocol in file
                        loggers.MqttProtocolLogger.info(`unknown instrument`)
                        console.log('unknown instrument');
                    }

                    //decision making 
                    if (tempCailibType == undefined) {
                        if (currentOpStatus == undefined) {
                            loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
                            console.log('wt recieve without any api called');
                            return;
                        } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

                            await objWeighmentData.ParsingTestData(__parameterWeighmentObj);
                        }
                    } else {
                        var result;
                        var calibType = tempCailibType.calibType;
                        switch (calibType.toLowerCase()) {
                            case 'daily':
                                result = dailyCalibrationModel.verifyWeights(str_Protocol, strResberryPi, actualWt, ProtocolDecPoint)
                                break;
                            case 'periodic':
                                result = periodiccalibrationModel.verifyWeights(str_Protocol, strResberryPi, actualWt, ProtocolDecPoint)
                                break;
                            case 'verCalb':
                                break;
                            case 'sensitivity':
                            case 'uncertainty':
                                result = uncertinityCalibModel.verifyWeights(str_Protocol, strResberryPi, actualWt, ProtocolDecPoint)
                                break;
                            case 'repeatability':
                                result = repetabilityCalibration.verifyWeights(str_Protocol, strResberryPi, actualWt, ProtocolDecPoint)
                                break;
                            case 'eccentricity':
                                result = eccentricityCaibration.verifyWeights(str_Protocol, strResberryPi, actualWt, ProtocolDecPoint)
                                break;
                            case 'crmhei':
                                result = objCrimpHeight.verifyWeights(str_Protocol, strResberryPi, actualWt, ProtocolDecPoint, strHmi);
                                break;
                            case 'crmdia':
                                result = objCrimpDiameter.verifyWeights(str_Protocol, strResberryPi, actualWt, ProtocolDecPoint, strHmi);
                                break;
                            case 'linearity':
                                result = linearityCalibration.verifyWeights(str_Protocol, strResberryPi, actualWt, ProtocolDecPoint)
                                break;
                            case 'positional':
                                break;
                            default:
                                loggers.MqttProtocolLogger.info(`Cal Decider not set : ${calibType}`)
                                console.log('Cal Decider not set');
                                break;
                        }
                        return result;
                    }
                }
            }
        } catch (error) {
            throw new Error(error)
        }
    }
}

module.exports = BalanceParsing;