const Database = require('../../database/clsQueryProcess');
const globalData = require('../../global/globalData');
const database = new Database();
const clsInstrumentUsage = require('../clsInstrumentUsageLog');
const clsActivityLog = require('../clsActivityLog.model');
const clsConfigSettings = require('../clsConfigSettings')
const GLOBAL_NOMENCLATURE = require('../../global/GLOBAL_NOMENCLATURE')
const models = require('../../../config/dbConnection').models;
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const MqttModel = require('../Mqtt/mqttSender.class');
const { Op } = require('sequelize')
var date = require('date-and-time')
var moment = require('moment')
var now = new Date();
const clsHmi = require('../hmiDetail.model');
const { create, all } = require("mathjs");
const config = {};
const mathj = create(all, config);
const clsPrintOperations = require("../Print/clsPrintOperation")

const printOperations = new clsPrintOperations()
const mqttSender = new MqttModel();
const objActivityLog = new clsActivityLog();
const configSetting = new clsConfigSettings()
const objHmi = new clsHmi();
const objInstrumentUsage = new clsInstrumentUsage();

class IPC {

    constructor() {
        this.math = mathj;
    }

    async pendingWeighment(value) {
        try {
            
            var strHmi = value.Hmi

            var CubicalData = await this.getCubicalData(strHmi)

            CubicalData = CubicalData[0]

            var idsInfo = globalData.arrIdsInfo.find(k => k.Hmi == strHmi)

            if (idsInfo == undefined) {
                globalData.arrIdsInfo.push({
                    Hmi: strHmi,
                    idsNo: CubicalData.Sys_rpi,
                    cubicalData: CubicalData
                })
            } else {
                idsInfo.idsNo = CubicalData.Sys_rpi,
                idsInfo.cubicalData = CubicalData
            }

            // var userObj = globalData.arrUsers.find(k => k.Hmi == strHmi);

            // if (userObj == undefined){
            //     globalData.arrUsers.push({
            //         Hmi: strHmi,
            //         UserId: value.UserId,
            //         UserName: value.UserName,
            //         UserPass: "1"
            //     })
            // }else{
            //     userObj.UserId = value.UserId,
            //     userObj.UserName = value.UserName
            //     userObj.UserPass = "1"
            // }

            var cubType = CubicalData.Sys_CubType;

            // if (cubType.toUpperCase() == 'IPQA') return { status: 'fail', message: 'IPQA Selected' }

            var str_tableName = await this.getTableName(cubType, CubicalData.Sys_IPQCType)

            var binInfo = await models[str_tableName].findAll({
                attributes: ['Bin_BinID', 'Bin_TareWt', 'Bin_GrossWt'],
                where: {
                    Bin_IDSNo: strHmi,
                    Bin_ProductID: CubicalData.Sys_BFGCode,
                    Bin_ProductName: CubicalData.Sys_ProductName,
                    Bin_ProductVersion: CubicalData.Sys_PVersion,
                    Bin_Version: CubicalData.Sys_Version,
                    Bin_BatchNo: CubicalData.Sys_Batch,
                    Bin_BatchComplete: 0,
                    Bin_Status: 0
                }
            })

            if (binInfo.length === 0) return { status: 'fail', message: 'NO IPC AVAILABLE' }

            var tare_status = binInfo.some(k => k.Bin_TareWt !== 0)

            var gross_status = binInfo.some(k => k.Bin_TareWt === 0)

            if (!tare_status) {
                return { status: 'success', result: ['Tare Weight'], bin_flag: true }
            }

            if (!gross_status && tare_status) {
                return { status: 'success', result: ['Gross Weight'], bin_flag: true }
            } else {
                return { status: 'success', result: ['Tare Weight', 'Gross Weight'], bin_flag: false }
            }


        }
        catch (error) {
            throw new Error(error);
        }
    }

    async getBinList(value) {
        try {

            var strHmi = value.Hmi;

            var HdHmi = value.HdHmi

            var CubicalData = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData

            var cubType = CubicalData.Sys_CubType;

            var str_tableName = await this.getTableName(cubType, CubicalData.Sys_IPQCType)

            var binInfo = await models[str_tableName].findAll({
                attributes: ['Bin_BinID'],
                where: {
                    Bin_IDSNo: strHmi,
                    Bin_ProductID: CubicalData.Sys_BFGCode,
                    Bin_ProductName: CubicalData.Sys_ProductName,
                    Bin_ProductVersion: CubicalData.Sys_PVersion,
                    Bin_Version: CubicalData.Sys_Version,
                    Bin_BatchNo: CubicalData.Sys_Batch,
                    Bin_BatchComplete: 0,
                    Bin_Status: 0,
                    Bin_TareWt: value.menu == 'Tare Weight' ? 0 : { [Op.ne]: ['0'] }
                }
            })

            var binList = binInfo.map(k => k['Bin_BinID'])

            if (binInfo.length === 0) return { status: 'fail', message: 'NO IPC AVAILABLE' }

            return { status: 'success', result: binList }

        }
        catch (error) {
            throw new Error(error);
        }
    }

    async selectedBin(value) {
        try {
            
            var HdHmi = value.HdHmi
            var strHmi = value.Hmi;

            await this.updateWeighmentStatus(HdHmi, 1);

            var CubicalData = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData

            var cubType = CubicalData.Sys_CubType;

            var str_tableName = await this.getTableName(cubType, CubicalData.Sys_IPQCType)

            var binInfo = await models[str_tableName].findAll({
                attributes: ['Bin_ProductID', 'Bin_ProductName', 'Bin_ProductVersion', 'Bin_Version', 'Bin_BatchNo', 'Bin_TareWt'],
                where: {
                    Bin_BinID: value.selectedBin,
                    Bin_Status: 0,
                    Bin_BatchComplete: 0,
                }
            })

            var userObj = globalData.arrUsers.find(k => k.Hmi == HdHmi);

                if (userObj == undefined){
                    globalData.arrUsers.push({
                        Hmi: HdHmi,
                        UserId: value.UserId,
                        UserName: value.UserName,
                        UserPass: "1"
                    })
                }else{
                    userObj.UserId = value.UserId,
                    userObj.UserName = value.UserName
                    userObj.UserPass = "1"
                }

            //activity log
            if (binInfo[0].Bin_TareWt == 0) {

                userObj = globalData.arrUsers.find(k => k.Hmi == HdHmi);

                var objActivity = {
                    strUserId: userObj.UserId,
                    strUserName: userObj.UserName,
                    activity: 'IPC weighing started on ' + strHmi
                };

                await objActivityLog.ActivityLogEntry(objActivity);

            }

            var config = await configSetting.GetConfigSetting(strHmi, GLOBAL_NOMENCLATURE.IPCBalance)

            var balUnit = await this.getBalUnit(config[0].instrumentId)

            var selectedMenu = globalData.arrSelectedMenu.find(k => k.Hmi == HdHmi)

            var obj = {
                SelectedBin: value.selectedBin,
                BFGCode: binInfo[0].Bin_ProductID,
                ProdName: binInfo[0].Bin_ProductName,
                ProdVersion: binInfo[0].Bin_ProductVersion,
                Version: binInfo[0].Bin_Version,
                Batch: binInfo[0].Bin_BatchNo,
                unit: balUnit.toLowerCase()
            }
            // if( value.hdHmi != strHmi){
            //     strHmi= value.HdHmi
            // }
            if (selectedMenu == undefined) {
                globalData.arrSelectedMenu.push({
                    Hmi: HdHmi,
                    selHmi: strHmi,
                    idsNo: CubicalData.Sys_rpi,
                    menuName: "IPCWC",
                    selectedProductDetail: obj,
                    instrumentId: config[0].instrumentId,
                    InstrumentType: GLOBAL_NOMENCLATURE.IPCBalance,
                    portNo: config[0].portNo,
                })
            } else {
                    selectedMenu.Hmi = HdHmi,
                    selectedMenu.selHmi = strHmi,
                    selectedMenu.idsNo = CubicalData.Sys_rpi,
                    selectedMenu.selectedProductDetail = obj,
                    selectedMenu.instrumentId = config[0].instrumentId,
                    selectedMenu.portNo = config[0].portNo
            }

            var currentOperation = globalData.arrCurrentOperationStatus.find(k => k.Hmi == HdHmi)

            if (currentOperation == undefined) {
                globalData.arrCurrentOperationStatus.push({
                    Hmi: HdHmi,
                    selHmi: strHmi,
                    Weighment: "1",
                    testType: "Weighment"
                })
            }else{
                currentOperation.selHmi = strHmi
                currentOperation.Weighment= "1",
                currentOperation.testType= "Weighment"
            }

            Object.assign(obj, { TareWt: Number(binInfo[0].Bin_TareWt) + " " + balUnit })

            return { status: 'success', result: obj, configsetting: config[0] };

        } catch (error) {
            throw new Error(error);
        }
    }

    async decideTareEmptyOrNot(value) {
        try {

            var HdHmi = value.Hmi;

            var arrSelectedMenu = globalData.arrSelectedMenu.find(k => k.Hmi == HdHmi)
           
            var strHmi = arrSelectedMenu.selHmi

            var CubicalData = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData

            var balUnit = await this.getBalUnit(arrSelectedMenu.instrumentId)

            if (balUnit === 'gm') balUnit = "g"

            if (value.unit === 'gm') value.unit = "g"

            if (balUnit.toLowerCase() !== value.unit.toLowerCase()){
              return mqttSender.sendData(HdHmi, `${mqttProtocol.DisplayMessage}Invalid Unit Received`)
            }

            // if (balUnit.toLowerCase() != value.unit.toLowerCase() ) {
            //     if (! gm_unit.includes(balUnit.toLowerCase()) && ! gm_unit.includes(value.unit.toLowerCase()) ){
            //     return mqttSender.sendData(HdHmi, `${mqttProtocol.DisplayMessage}Invalid Balance Unit Received expected ${balUnit}`)
            //     }
            // }

            var str_tableName = await this.getTableName(CubicalData.Sys_CubType, CubicalData.Sys_IPQCType)

            var binInfo = await models[str_tableName].findAll({
                attributes: ['Bin_TareWt'],
                where: {
                    Bin_BinID: arrSelectedMenu.selectedProductDetail.SelectedBin,
                    Bin_Status: 0,
                    Bin_BatchComplete: 0,
                }
            })

            binInfo[0]['Bin_TareWt'] == 0 ? this.saveEmptyWt(value, strHmi, str_tableName, arrSelectedMenu) :
                this.saveGrossWt(value, strHmi, str_tableName, arrSelectedMenu, binInfo[0]['Bin_TareWt']);

            return;

        } catch (error) {
            throw new Error(error);
        }

    }

    async saveEmptyWt(dataObj, strHmi, str_tableName, arrSelectedMenu) {
        try {
            // var strHmi = dataObj.Hmi;
            var HdHmi = arrSelectedMenu.Hmi
            var dblTareWt = dataObj.actualWt;
            var selectedMenu = arrSelectedMenu.selectedProductDetail
            var BinId = selectedMenu.SelectedBin

            if (0 >= parseFloat(dblTareWt)) return mqttSender.sendData(HdHmi, `${mqttProtocol.DisplayMessage}Tare Weight must be greter than zero`)

            await models[str_tableName].update({
                Bin_TareWt: dblTareWt
            }, {
                where: {
                    Bin_IDSNo: strHmi,
                    Bin_ProductID: selectedMenu.BFGCode,
                    Bin_ProductName: selectedMenu.ProdName,
                    Bin_ProductVersion: selectedMenu.ProdVersion,
                    Bin_Version: selectedMenu.Version,
                    Bin_BatchNo: selectedMenu.Batch,
                    Bin_BinID: BinId,
                    Bin_BatchComplete: 0,
                }
            })

            var userObj = globalData.arrUsers.find(k => k.Hmi == HdHmi);

            var objActivity = {
                strUserId: userObj.UserId,
                strUserName: userObj.UserName,
                activity: `Tare Wt of Bin - ${BinId} taken ${strHmi}`
            };

            await objActivityLog.ActivityLogEntry(objActivity);

            //await objInstrumentUsage.InstrumentUsage(GLOBAL_NOMENCLATURE.IPCBalance, arrSelectedMenu.idsNo, 'tbl_instrumentlog_balance', `IPC - ${BinId}`, 'started')

            globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.selHmi == strHmi), 1)
            globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex(k => k.selHmi == strHmi), 1)
            mqttSender.sendData(HdHmi, `${GLOBAL_NOMENCLATURE.DisplayResult}${dblTareWt} ${dataObj.unit}`);
            return mqttSender.sendData(HdHmi, `${GLOBAL_NOMENCLATURE.TestCompleted}Tare Weight Received`);

        } catch (err) {
            throw new Error(err);
        }
    }

    async saveGrossWt(dataObj, strHmi, str_tableName, arrSelectedMenu, tareWt) {
        try {

            // var strHmi = dataObj.Hmi;
            var HdHmi = arrSelectedMenu.Hmi
            var dblGrossWt = dataObj.actualWt;
            var selectedMenu = arrSelectedMenu.selectedProductDetail
            var BinId = selectedMenu.SelectedBin
        
            var cubicalData = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData

            var tempUserObject = globalData.arrUsers.find(k => k.Hmi == HdHmi);

            if (parseFloat(tareWt) >= parseFloat(dblGrossWt)) return mqttSender.sendData(HdHmi, `${mqttProtocol.DisplayMessage} Gross Weight must be greater than ${parseFloat(this.math.round(tareWt,3)).toFixed(3)}`)

            let tareDp = await this.precision(Number(tareWt));
            let grossDp = await this.precision(Number(dblGrossWt));

            var netWt = Number(dblGrossWt - tareWt)
            tareWt = this.math.round(tareWt,3).toFixed(3)
            dblGrossWt = this.math.round(dblGrossWt,3).toFixed(3)
            netWt = this.math.round(netWt,3).toFixed(3)
            var binSrNo = await models[str_tableName].max('Bin_SrNoWeighment', {
                where: {
                    [Op.and]: [
                        { Bin_IDSNo: strHmi },
                        { Bin_ProductID: selectedMenu.BFGCode },
                        { Bin_ProductName: selectedMenu.ProdName },
                        { Bin_ProductVersion: selectedMenu.ProdVersion },
                        { Bin_Version: selectedMenu.Version },
                        { Bin_BatchNo: selectedMenu.Batch },
                        { Bin_BatchComplete: 0 }
                    ]
                }
            })

            var objActivity = {
                strUserId: tempUserObject.UserId,
                strUserName: tempUserObject.UserName,
                activity: 'IPC weighing Started on ' + strHmi
            }

            await objActivityLog.ActivityLogEntry(objActivity);

            await models[str_tableName].update({
                Bin_PrDate: moment().format('YYYY-MM-DD'),
                Bin_PrTime: moment().format('HH:mm:ss'),
                Bin_InstrumentID: arrSelectedMenu.instrumentId,
                Bin_GrossWt: dblGrossWt,
                bin_NetWeight: netWt,
                Bin_DP: 3,
                Bin_Status: 1,
                Bin_UserID: tempUserObject.UserId,
                Bin_UserName: tempUserObject.UserName,
                Bin_IDSNoWeighment: strHmi,
                Bin_SrNoWeighment: binSrNo + 1
            },{
                where: {
                    Bin_BinID: BinId,
                    Bin_ProductID: selectedMenu.BFGCode,
                    Bin_ProductName: selectedMenu.ProdName,
                    Bin_ProductVersion: selectedMenu.ProdVersion,
                    Bin_Version: selectedMenu.Version,
                    Bin_BatchNo: selectedMenu.Batch,
                    Bin_GrossWt: 0,
                    Bin_Status:0,
                    Bin_BatchComplete: 0,
                }
            });

            var selectBinSettings = await models.tbl_cubicle_bin_setting.findAll({
                attributes: ['Sys_TotalBinSelected'],
                where: {
                    Sys_IDS: strHmi,
                    Sys_PrdID: selectedMenu.BFGCode,
                    Sys_PrdName: selectedMenu.ProdName,
                    Sys_PrdVersion: selectedMenu.ProdVersion,
                    Sys_Version: selectedMenu.Version,
                    Sys_BatchNo: selectedMenu.Batch,
                    // Sys_BinID: {[Op.ne]: ["NULL"]},
                    Sys_TotalBinSelected: {[Op.ne]: ["0"]},
                    Sys_TotalBin: {[Op.ne]: ["0"]},
                }
            })

            var totalBins = await models[str_tableName].count({
                where: {
                    Bin_IDSNo: strHmi,
                    Bin_ProductID: selectedMenu.BFGCode,
                    Bin_ProductName: selectedMenu.ProdName,
                    Bin_ProductVersion: selectedMenu.ProdVersion,
                    Bin_Version: selectedMenu.Version,
                    Bin_BatchNo: selectedMenu.Batch,
                    Bin_BatchComplete: 0,
                    Bin_Status: 1,
                }
            })

            var rec = await models[str_tableName].findAll({
                where: {
                    Bin_IDSNo: strHmi,
                    Bin_ProductID: selectedMenu.BFGCode,
                    Bin_ProductName: selectedMenu.ProdName,
                    Bin_ProductVersion: selectedMenu.ProdVersion,
                    Bin_Version: selectedMenu.Version,
                    Bin_BatchNo: selectedMenu.Batch,
                    Bin_BatchComplete: 0,
                    Bin_Status: 1,
                }
            })

            rec = rec.pop()
            var recno = rec.RecNo;

            if (selectBinSettings[0].Sys_TotalBinSelected === totalBins) {

                // await models[str_tableName].update({
                //     Bin_BatchComplete: 1
                // },{
                //     where: {
                //         Bin_IDSNo: strHmi,
                //         Bin_ProductID: selectedMenu.BFGCode,
                //         Bin_ProductName: selectedMenu.ProdName,
                //         Bin_ProductVersion: selectedMenu.ProdVersion,
                //         Bin_Version: selectedMenu.Version,
                //         Bin_BatchNo: selectedMenu.Batch,
                //         Bin_Status: 1,
                //         Bin_BatchComplete: 0,
                //     }
                // })

                if ( cubicalData.Sys_CubType.toLowerCase() === "granulation" ||
                     cubicalData.Sys_CubType.toLowerCase() === "ipqc" ||
                     cubicalData.Sys_CubType.toLowerCase() === "ipc"){

                var objBatchInfo = cubicalData

                await models[str_tableName].update({
                    Bin_BatchComplete : 1,
                    Bin_ShiftCubic:0
                },{
                    where: {
                        [Op.or] : [
                            { Bin_CubicleNo: objBatchInfo.Sys_CubicNo},
                            // { Bin_ShiftCubic: objBatchInfo.Sys_CubicNo},
                            {
                                [Op.and]:{
                                    Bin_ShiftCubic: objBatchInfo.Sys_CubicNo,
                                    Bin_BatchComplete: 0 
                                }
                            }
                        ]
                    },
                });

                await models[(str_tableName + "_archived")].update({
                    Bin_BatchComplete : 1,
                    Bin_ShiftCubic:0
                },{
                    where: { 
                        [Op.or] : [
                            { Bin_CubicleNo: objBatchInfo.Sys_CubicNo},
                            // { Bin_ShiftCubic: objBatchInfo.Sys_CubicNo},
                            {
                                [Op.and]:{ 
                                    Bin_ShiftCubic: objBatchInfo.Sys_CubicNo,
                                    Bin_BatchComplete: 0 
                                }
                            }
                        ]
                    },
                });

                await models.tbl_bin_list.update({
                    CubicleNo: 0,
                    cubicleType: 'NULL',
                    BatchNo: 'NULL',
                    binStatus: 1,
                    Bin_CubicNo: 0
                },{
                    where: {
                        [Op.or]:[
                            { Bin_CubicNo: objBatchInfo.Sys_CubicNo },
                            {
                                [Op.and]:{
                                    BatchNo: objBatchInfo.Sys_Batch,
                                    cubicleType: objBatchInfo.Sys_CubType,
                                    CubicleNo: objBatchInfo.Sys_CubicNo,
                                    IsDiscarded: 0
                                }
                            }
                        ]
                    },
                });
            }
        }

            var objActivity = {
                strUserId: tempUserObject.UserId,
                strUserName: tempUserObject.UserName,
                activity: 'IPC weighing Completed on ' + strHmi
            }

            await objActivityLog.ActivityLogEntry(objActivity);

            await objInstrumentUsage.InstrumentUsage(GLOBAL_NOMENCLATURE.IPCBalance, arrSelectedMenu.idsNo, 'tbl_instrumentlog_balance', `IPC - ${BinId}`, 'started')

            var printObj = {
                str_ICReport: "Current",
                // reportOption: "IPC",
                str_cubicleType: cubicalData.Sys_CubType,
                printername: rec.Bin_Printer,
                // pid: rec.Bin_ProductID,
                // pname: rec.Bin_ProductName,
                // pv: rec.Bin_ProductVersion,
                // v:rec.Bin_Version,
                // reportType: "Complete",
                // testType: "Regular",
                RecNo: recno,
                UserId: tempUserObject.UserId,
                UserName: tempUserObject.UserName,
                // cubType : cubicalData.Sys_cubTypes,
                // printNo: 0,
                // str_url: intProductType === 1 ? "Tablet" : "Capsule"
            }
            await printOperations.callViewTabReport(printObj, 'Bin', strHmi)

            globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.selHmi == strHmi), 1)
            
            globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex(k => k.selHmi == strHmi), 1)

            mqttSender.sendData(HdHmi, `${mqttProtocol.DisplayResult}${dblGrossWt} ${dataObj.unit}:${netWt} ${dataObj.unit}`)
            return mqttSender.sendData(HdHmi, `${GLOBAL_NOMENCLATURE.TestCompleted}Label Generated`);

        } catch (error) {
            throw new Error(error);
        }
    }

    async getTableName(cubType, cubicIPQCType) {
        try {

            var str_tableName;

            var type = cubType.toUpperCase() == "IPQA" ? cubicIPQCType : cubType

            switch (type.toUpperCase()) {

                case 'COATING':
                    str_tableName = "tbl_bin_master_coat";
                    break;

                case 'COMPRESSION':
                    str_tableName = "tbl_bin_master_comp";
                    break;

                case 'CAPSULE FILLING':
                    str_tableName = "tbl_bin_master_cap";
                    break;

                case 'GRANULATION':
                    str_tableName = "tbl_bin_master_gran";
                    break;

                case 'IPC':
                    str_tableName = "tbl_bin_master_ipc";
                    break;
                    
            }

            // if ((area.toUpperCase() == "COMPRESSION" || area.toUpperCase() == "EFFERVESCENT COMPRESSION"
            //     || area.toUpperCase() == "EFFERVESCENT GRANULATION" || area.toUpperCase() == "GRANULATION")
            //     && cubType.toUpperCase() != 'IPC') {
            //     str_tableName = "tbl_bin_master_comp";
            // }
            // else if (area.toUpperCase() == "COATING" && cubType.toUpperCase() != 'IPC') {
            //     str_tableName = "tbl_bin_master_coat";
            // }
            // else if (area.toUpperCase() == "CAPSULE FILLING" && cubType.toUpperCase() != 'IPC') {
            //     str_tableName = "tbl_bin_master_cap";
            // } else if (cubType.toUpperCase() == 'IPC') {
            //     str_tableName = "tbl_bin_master_ipc";
            // } else if (area.toUpperCase().includes('IPQA')) {
            //     if (cubicIPQCType.toUpperCase() == "COMPRESSION") {
            //         str_tableName = "tbl_bin_master_comp";
            //     } else if (cubicIPQCType.toUpperCase() == "CAPSULE FILLING") {
            //         str_tableName = "tbl_bin_master_cap";
            //     } else if (cubicIPQCType.toUpperCase() == "COATING") {
            //         str_tableName = "tbl_bin_master_coat";
            //     }
            // }

            return str_tableName
        }
        catch {
            throw new Error(error)
        }
    }

    async updateWeighmentStatus(strHmi, intStatus) {
        try {

            var CubicalData = await this.getCubicalData(strHmi)
            CubicalData = CubicalData[0]


            // var selectedIds ;
            // var tempIPQCobj = globalData.arr_IPQCRelIds.find(k => k.Hmi == strHmi);
            // if (currentCubicObj.Sys_CubType == 'IPC') {
            //     var tempBin = globalData.arrBinInfo.find(k => k.Hmi == strHmi);
            //     if (tempBin != undefined) {
            //         selectedIds = tempBin.idsNo;  //doubt
            //     } else {
            //         selectedIds = strHmi;
            //     }
            // } else {
            //     if (tempIPQCobj != undefined) { // IPQC Cubicles
            //         selectedIds = tempIPQCobj.selectedIds;
            //     } else {
            //         selectedIds = strHmi;
            //     }
            // var tempCubicObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;

            var objStatus = await models.tbl_system_weighingstatus.update({
                Status: intStatus,
                BatchNo: intStatus == 0 ? "NULL" : CubicalData.Sys_Batch,
                CubType: intStatus == 0 ? "NULL" : CubicalData.Sys_CubType
            }, {
                where: {
                    CubicleNo: CubicalData.Sys_CubicNo,
                }
            })

            return;

        } catch (error) {
            throw new Error(error);
        }
    }

    async precision(a) {
        if (!isFinite(a)) return 0;
        var e = 1, p = 0;
        while (Math.round(a * e) / e !== a) { e *= 10; p++; }
        return p;
    }

    async getBalUnit(balId) {
        try {
            var balUnit = await models.tbl_balance.findAll({
                attributes: ['Bal_Unit'],
                where: {
                    Bal_ID: balId
                }
            })
            return balUnit[0].Bal_Unit

        } catch (error) {
            throw new Error(error);
        }
    }

    

    async onIpcSelection(value) {
        try {

            var list = await models.tbl_cubicle_bin_setting.findAll({
                attributes: [['Sys_BatchNo','batch'],['Sys_IDS','Hmi']],
               where: {
                    Sys_CubicName:value.cubic,
                    [Op.not]: [
                        { Sys_BinID: null },
                        { Sys_PrdID: null },
                        { Sys_PrdName: null },
                        { Sys_PrdVersion: null },
                        { Sys_Version: null },
                        { Sys_BatchNo: null },
                        { Sys_IDS: 'NA' },
                        { Sys_TotalBinSelected: 0 },
                    ]
                }
            })

            return { status : 'success', result: list }

        }
        catch (error) {
            throw new Error(error)
        }
    }








    async sendIPCProductList(strCubicType, strArea) {
        try {

            var objProductList = await models.tbl_cubical.findAll({
                where: {
                    'Sys_Area': strArea,
                    'Sys_CubType': strCubicType,
                    // 'Sys_ProductName': "NULL",
                }
            })
            var resProduct = [objProductList]
            var strProductList = [];
            resProduct[0].forEach(Product => {
                if (Product.Sys_BFGCode != null && Product.Sys_BFGCode != "" && Product.Sys_BFGCode != "NULL") {
                    strProductList.push({
                        IdsNo: Product.Sys_IDSNo,
                        BFGCode: Product.Sys_BFGCode

                    })
                }
            });


            if (strProductList.length != 0) {
                return strProductList;
            } else {
                return 'Not Set';
            }

        } catch (error) {
            //  return error;
            throw new Error(error);
        }
    }

    /**
     * this function will send a IPC List as per Area
     * Total bins will be saved for the one time if user wants to update the bin then user has to logout and login again.
     * @param {*} idsNo : IDs no on which weighment is in progress
     * @param {*} area : Area name for which list is to be displayed
     * @param {*} cubType : Cubicle type for which list is to be displayed
     * @param {*} fillListAgain : if this flag is true then we will fill list again.
     */
    async sendIPCList(strHmi) {
        try {
            await this.updateWeighmentStatus(strHmi, 0);
            // var objLocation = globalData.arrIPCLocation.find(k => k.idsNo == idsNo);
            var objBin = globalData.arrBinInfo.find(k => k.Hmi == strHmi);
            var strCubicle = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
            objBin.balanceID = strCubicle.Sys_BinBalID;
            var objTotalBins = globalData.arrTotalBins.find(k => k.Hmi == strHmi);
            var cuurentCubicle = globalData.arrIdsInfo.find(k => k.Hmi == objBin.selHmi).cubicalData;
            var area = cuurentCubicle.Sys_Area;
            var cubType = cuurentCubicle.Sys_CubType;

            var str_tableName;
            if ((area.toUpperCase() == "COMPRESSION" || area.toUpperCase() == "EFFERVESCENT COMPRESSION"
                || area.toUpperCase() == "EFFERVESCENT GRANULATION" || area.toUpperCase() == "GRANULATION")
                && cubType.toUpperCase() != 'IPC') {
                str_tableName = "tbl_bin_master_comp";
            }
            else if (area.toUpperCase() == "COATING" && cubType.toUpperCase() != 'IPC') {
                str_tableName = "tbl_bin_master_coat";
            }
            else if (area.toUpperCase() == "CAPSULATION" && cubType.toUpperCase() != 'IPC') {
                str_tableName = "tbl_bin_master_cap";
            } else if (cubType.toUpperCase() == 'IPC') {
                str_tableName = "tbl_bin_master_ipc";
            } else if (area.toUpperCase().includes('IPQA')) {
                var cubicIPQCType = cuurentCubicle.Sys_IPQCType;
                if (cubicIPQCType.toUpperCase() == "COMPRESSION") {
                    str_tableName = "tbl_bin_master_comp";
                } else if (cubicIPQCType.toUpperCase() == "CAPSULATION") {
                    str_tableName = "tbl_bin_master_cap";
                } else if (cubicIPQCType.toUpperCase() == "COATING") {
                    str_tableName = "tbl_bin_master_coat";
                }
            }
            var resBinData = await models[str_tableName].findAll({
                where: {
                    Bin_IDSNo: objBin.selHmi,
                    Bin_ProductID: objBin.selProductId,
                    Bin_ProductName: objBin.selProductName,
                    Bin_ProductVersion: objBin.selProductVersion,
                    Bin_Version: objBin.selVersion,
                    Bin_BatchComplete: 0,
                    Bin_Status: 0,
                    Bin_BatchNo: objBin.selBatch,
                }
            })

            var bins = resBinData.map(obj => { return obj.Bin_BinID; });

            if (objTotalBins == undefined) {
                globalData.arrTotalBins.push({ Hmi: strHmi, selBins: bins })
            }
            else {
                objTotalBins.selBins = bins;
            }

            return await this.sendSelectedBinsByIndex(strHmi, cubType, area);


        } catch (error) {
            throw new Error(error);
        }
    }

    /**
     * This function will update the gross wt as well as net wt into table 
     * also this will update the weighment serial no of bin
     * and will update the bin_status = 1
     * @param {*} objBin : Bin Object which contains all the bin related information.
     */
    async saveContainerWeighment(objBin, area, cubType, IdsNo, strHmi) {
        try {
            var cuurentCubicle = globalData.arrIdsInfo.find(k => k.idsNo == objBin.selIds).cubicalData;
            // var bin = globalData.arrBinSetting;
            area = cuurentCubicle.Sys_Area;
            cubType = cuurentCubicle.Sys_CubType;

            var objUpdateBinInfo
            if ((area.toUpperCase() == "COMPRESSION" || area.toUpperCase() == "EFFERVESCENT COMPRESSION"
                || area.toUpperCase() == "EFFERVESCENT GRANULATION" || area.toUpperCase() == "GRANULATION")
                && cubType.toUpperCase() != 'IPC') {
                objUpdateBinInfo.str_tableName = "tbl_bin_master_comp";
            }
            else if (area.toUpperCase() == "COATING" && cubType.toUpperCase() != 'IPC') {
                objUpdateBinInfo.str_tableName = "tbl_bin_master_coat";
            }
            else if (area.toUpperCase() == "CAPSULATION" && cubType.toUpperCase() != 'IPC') {
                objUpdateBinInfo.str_tableName = "tbl_bin_master_cap";
            } else if (cubType.toUpperCase() == 'IPC') {
                objUpdateBinInfo.str_tableName = "tbl_bin_master_ipc";
            }

            var SerialNoOfContainer = await this.getContainerSerialNo(objBin, objUpdateBinInfo.str_tableName);

            SerialNoOfContainer.SrNo == undefined ? 0 : SerialNoOfContainer.SrNo = SerialNoOfContainer.SrNo + 1;

            objUpdateBinInfo = await models[objUpdateBinInfo.str_tableName].update({
                'Bin_PrDate': objBin.prDate,
                'Bin_PrTime': objBin.prTime,
                'Bin_WeighingBalID': objBin.balanceID,
                'Bin_TareWt': objBin.tareWt,
                'Bin_GrossWt': objBin.grossWt,
                'bin_NetWeight': objBin.netWt,
                'Bin_DP': objBin.dp,
                'Bin_Status': 1,
                'Bin_DoneUserID': objBin.userid,
                'Bin_DoneUserName': objBin.username,
                'Bin_IDSNoWeighment': objBin.idsNo,
                'Bin_SrNoWeighment': SerialNoOfContainer.SrNo,
            }, {
                where: {
                    'Bin_BinID': objBin.selContainer,
                    'Bin_IDSNo': objBin.selIds,
                    'Bin_ProductID': objBin.selProductId,
                    'Bin_ProductName': objBin.selProductName,
                    'Bin_ProductVersion': objBin.selProductVersion,
                    'Bin_Version': objBin.selVersion,
                    'Bin_BatchNo': objBin.selBatch,
                    'Bin_GrossWt': 0,
                }
            });
            var objActivity = {};
            var userObj = globalData.arrUsers.find(k => k.Hmi == strHmi);

            var objActivity = {
                strUserId: userObj.UserId,
                strUserName: userObj.UserName,
                activity: 'IPC weighing Completed on ' + IdsNo
            };
            await objActivityLog.ActivityLogEntry(objActivity);
            var cubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == IdsNo);
            // var bininfo = globalData.arrBinSetting.find(k => k.Sys_IDS == IdsNo);
            var result = objUpdateBinInfo;

            mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}GrossWt:${objBin.grossWt};NetWt : ${objBin.netWt}`);
            mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} IPC Weighing Completed`);
            // if (globalData.arrsAllParameters[0].tbl_PrintingMode == 'Auto' && bininfo.Sys_Printer != 'NA') {
            //     /**
            //      * First here for online ipc print we need id of report
            //      * So we are selecting id from table regarding current parameters
            //      */
            //     var objSelectBinInfo = {
            //         str_tableName: objUpdateBinInfo.str_tableName,
            //         data: '*',
            //         condition: [
            //             { str_colName: 'Bin_BinID', value: objBin.selContainer },
            //             { str_colName: 'Bin_IDSNo', value: objBin.selIds },
            //             { str_colName: 'Bin_ProductID', value: objBin.selProductId },
            //             { str_colName: 'Bin_ProductName', value: objBin.selProductName },
            //             { str_colName: 'Bin_ProductVersion', value: objBin.selProductVersion },
            //             { str_colName: 'Bin_Version', value: objBin.selVersion },
            //             { str_colName: 'Bin_BatchNo', value: objBin.selBatch },
            //         ]
            //     }
            //     var selectRes = await database.select(objSelectBinInfo);
            //     var RecNo = selectRes[0][0].RecNo;
            //     var sendObj = {};
            //     var data = {
            //         str_cubicleType: cubType,
            //         str_ICReport: "Current",
            //         UserId: userObj.UserId,
            //         UserName: userObj.UserName,
            //         RecNo: RecNo,
            //         cubType: cubType,
            //         HmiId: objBin.selIds,
            //         waterMark: "false",
            //         idsNo: objBin.selIds
            //     }
            //     Object.assign(sendObj, { data: data }, { FileName: 'RepoBinLabel' });
            //    // var printResutl = await objPrintReport.generateOnlineIPCReport(sendObj, bininfo.Sys_Printer, objBin);
            // }

            return result;

        } catch (error) {
            throw new Error(error);
        }
    }


    async getContainerSerialNo(objBin, strTableName) {
        try {
            var objSelContainerSr = await models.strTableName.findAll({
                attributes: [[sequelize.fn('max', sequelize.col('Bin_SrNoWeighment')), 'SrNo']],
                where: {
                    'Bin_IDSNo': objBin.selIds,
                    'Bin_ProductID': objBin.selProductId,
                    'Bin_ProductName': objBin.selProductName,
                    'Bin_ProductVersion': objBin.selProductVersion,
                    'Bin_Version': objBin.selVersion,
                    'Bin_BatchNo': objBin.selBatch,
                    'Bin_BatchComplete': 0,
                }
            })
            var result = objSelContainerSr;

            return result[0];

        } catch (error) {
            return error;
        }
    }

    async sendSelectedBinsByIndex(strHmi, cubType, area) {
        try {

            // var objBinIndex = globalData.arrBinIndex.find(k => k.idsNo == idsNo);
            var obj;
            var objTotalBins = globalData.arrTotalBins.find(k => k.Hmi == strHmi);
            var objBin = globalData.arrBinInfo.find(k => k.Hmi == strHmi);
            var strBins = [];
            for (var index = 0; index < objTotalBins.selBins.length; index++) {
                strBins.push(objTotalBins.selBins[index].trim());
            }

            //remove unwanted undefined 
            // strBins = strBins.replace(/undefined,/g, '');

            if (strBins.length == " ") {
                strBins = "No IPC Available";  //doubt
                /**
                 * @description As per SHEETAL, if list of ipc over for IPC cubicle set total bins to 0 in
                 * `tbl_cubicle_bin_setting` for current IPC cubicle 
                 */
                var cubicleObj = globalData.arrIdsInfo.find(k => k.idsNo == strHmi).cubicalData;
                if (cubicleObj.Sys_CubType == 'IPC') {
                    var updateObj = await models.tbl_cubical.update({
                        Sys_TotalBin: 0
                    }, {
                        where: {
                            'Sys_IDS': idsNo,
                        }
                    });
                    var totalSelectedBins = 0;
                    var totolCompleted = 0;
                    var selectBinSettings = await models.tbl_cubicle_bin_setting.findAll({
                        where: {
                            'Sys_IDS': idsNo,

                        }
                    })

                    var binSettingResult = selectBinSettings

                    if (binSettingResult[0].length != 0) {
                        totalSelectedBins = binSettingResult[0][0].Sys_TotalBinSelected;
                    }
                    //----------------------------------------------------------------//
                    var selectCompleted = await models.tbl_bin_master_ipc.findAll({
                        'Bin_IDSNo': objBin.Hmi,
                        'Bin_ProductID': objBin.selProductId,
                        'Bin_ProductName': objBin.selProductName,
                        'Bin_ProductVersion': objBin.selProductVersion,
                        'Bin_Version': objBin.selVersion,
                        'Bin_BatchComplete': 0,
                        'Bin_Status': 1,
                        'Bin_BatchNo': objBin.selBatch,

                    })

                    var completedResult = selectCompleted
                    if (completedResult[0].length != 0) {
                        totolCompleted = completedResult[0].length;
                    }
                    if (totolCompleted == totalSelectedBins) {
                        var updateFlag = await models.tbl_bin_master_ipc.update({
                            'Bin_BatchComplete': 1
                        }, {
                            where: {
                                'Bin_IDSNo': objBin.idsNo,
                                'Bin_ProductID': objBin.selProductId,
                                'Bin_ProductName': objBin.selProductName,
                                'Bin_ProductVersion': objBin.selProductVersion,
                                'Bin_Version': objBin.selVersion,
                                'Bin_Status': 1,
                                'Bin_BatchNo': objBin.selBatch,
                            }
                        })

                    }
                }

                return strBins;
            }
            else {
                obj = {
                    status: "success",
                    binList: strBins
                }
                return obj;
            }

        } catch (error) {
            return error;
        }
    }

    async getCubicalData(strIdsNo) {
        try {
            let cubicalData = await models.tbl_cubical.findAll({
                where: {
                    'Sys_IDSNo': strIdsNo
                }
            });
            return [cubicalData[0]];
        } catch (error) {
            throw new Error(error)
        }
    }
    async getCubicalIdsNo() {
        try {
            const objListBal = await models.tbl_cubical.findAll({
                where: {
                    Sys_IDSNo: {
                        [Op.ne]: "NA",
                    }
                }
            })

            // dbcon.execute('SELECT `Sys_IDSNo` FROM `tbl_cubical` WHERE `Sys_IDSNo` <> "0"')
            return [objListBal];
        } catch (error) {
            throw new Error(error)
        }
    }

}

module.exports = IPC;