"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _decimaln = _interopRequireDefault(require("./decimaln"));

var _writableTrackingBuffer = _interopRequireDefault(require("../tracking-buffer/writable-tracking-buffer"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const NULL_LENGTH = Buffer.from([0x00]);
const Decimal = {
  id: 0x37,
  type: 'DECIMAL',
  name: 'Decimal',
  declaration: function (parameter) {
    return 'decimal(' + this.resolvePrecision(parameter) + ', ' + this.resolveScale(parameter) + ')';
  },
  resolvePrecision: function (parameter) {
    if (parameter.precision != null) {
      return parameter.precision;
    } else if (parameter.value === null) {
      return 1;
    } else {
      return 18;
    }
  },
  resolveScale: function (parameter) {
    if (parameter.scale != null) {
      return parameter.scale;
    } else {
      return 0;
    }
  },

  generateTypeInfo(parameter, _options) {
    let precision;

    if (parameter.precision <= 9) {
      precision = 0x05;
    } else if (parameter.precision <= 19) {
      precision = 0x09;
    } else if (parameter.precision <= 28) {
      precision = 0x0D;
    } else {
      precision = 0x11;
    }

    return Buffer.from([_decimaln.default.id, precision, parameter.precision, parameter.scale]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    const precision = parameter.precision;

    if (precision <= 9) {
      return Buffer.from([0x05]);
    } else if (precision <= 19) {
      return Buffer.from([0x09]);
    } else if (precision <= 28) {
      return Buffer.from([0x0D]);
    } else {
      return Buffer.from([0x11]);
    }
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    const sign = parameter.value < 0 ? 0 : 1;
    const value = Math.round(Math.abs(parameter.value * Math.pow(10, parameter.scale)));
    const precision = parameter.precision;

    if (precision <= 9) {
      const buffer = Buffer.alloc(5);
      buffer.writeUInt8(sign, 0);
      buffer.writeUInt32LE(value, 1);
      yield buffer;
    } else if (precision <= 19) {
      const buffer = new _writableTrackingBuffer.default(9);
      buffer.writeUInt8(sign);
      buffer.writeUInt64LE(value);
      yield buffer.data;
    } else if (precision <= 28) {
      const buffer = new _writableTrackingBuffer.default(13);
      buffer.writeUInt8(sign);
      buffer.writeUInt64LE(value);
      buffer.writeUInt32LE(0x00000000);
      yield buffer.data;
    } else {
      const buffer = new _writableTrackingBuffer.default(17);
      buffer.writeUInt8(sign);
      buffer.writeUInt64LE(value);
      buffer.writeUInt32LE(0x00000000);
      buffer.writeUInt32LE(0x00000000);
      yield buffer.data;
    }
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    value = parseFloat(value);

    if (isNaN(value)) {
      throw new TypeError('Invalid number.');
    }

    return value;
  }
};
var _default = Decimal;
exports.default = _default;
module.exports = Decimal;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJOVUxMX0xFTkdUSCIsIkJ1ZmZlciIsImZyb20iLCJEZWNpbWFsIiwiaWQiLCJ0eXBlIiwibmFtZSIsImRlY2xhcmF0aW9uIiwicGFyYW1ldGVyIiwicmVzb2x2ZVByZWNpc2lvbiIsInJlc29sdmVTY2FsZSIsInByZWNpc2lvbiIsInZhbHVlIiwic2NhbGUiLCJnZW5lcmF0ZVR5cGVJbmZvIiwiX29wdGlvbnMiLCJEZWNpbWFsTiIsImdlbmVyYXRlUGFyYW1ldGVyTGVuZ3RoIiwib3B0aW9ucyIsImdlbmVyYXRlUGFyYW1ldGVyRGF0YSIsInNpZ24iLCJNYXRoIiwicm91bmQiLCJhYnMiLCJwb3ciLCJidWZmZXIiLCJhbGxvYyIsIndyaXRlVUludDgiLCJ3cml0ZVVJbnQzMkxFIiwiV3JpdGFibGVUcmFja2luZ0J1ZmZlciIsIndyaXRlVUludDY0TEUiLCJkYXRhIiwidmFsaWRhdGUiLCJwYXJzZUZsb2F0IiwiaXNOYU4iLCJUeXBlRXJyb3IiLCJtb2R1bGUiLCJleHBvcnRzIl0sInNvdXJjZXMiOlsiLi4vLi4vc3JjL2RhdGEtdHlwZXMvZGVjaW1hbC50cyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBEYXRhVHlwZSB9IGZyb20gJy4uL2RhdGEtdHlwZSc7XG5pbXBvcnQgRGVjaW1hbE4gZnJvbSAnLi9kZWNpbWFsbic7XG5pbXBvcnQgV3JpdGFibGVUcmFja2luZ0J1ZmZlciBmcm9tICcuLi90cmFja2luZy1idWZmZXIvd3JpdGFibGUtdHJhY2tpbmctYnVmZmVyJztcblxuY29uc3QgTlVMTF9MRU5HVEggPSBCdWZmZXIuZnJvbShbMHgwMF0pO1xuXG5jb25zdCBEZWNpbWFsOiBEYXRhVHlwZSAmIHsgcmVzb2x2ZVByZWNpc2lvbjogTm9uTnVsbGFibGU8RGF0YVR5cGVbJ3Jlc29sdmVQcmVjaXNpb24nXT4sIHJlc29sdmVTY2FsZTogTm9uTnVsbGFibGU8RGF0YVR5cGVbJ3Jlc29sdmVTY2FsZSddPiB9ID0ge1xuICBpZDogMHgzNyxcbiAgdHlwZTogJ0RFQ0lNQUwnLFxuICBuYW1lOiAnRGVjaW1hbCcsXG5cbiAgZGVjbGFyYXRpb246IGZ1bmN0aW9uKHBhcmFtZXRlcikge1xuICAgIHJldHVybiAnZGVjaW1hbCgnICsgKHRoaXMucmVzb2x2ZVByZWNpc2lvbihwYXJhbWV0ZXIpKSArICcsICcgKyAodGhpcy5yZXNvbHZlU2NhbGUocGFyYW1ldGVyKSkgKyAnKSc7XG4gIH0sXG5cbiAgcmVzb2x2ZVByZWNpc2lvbjogZnVuY3Rpb24ocGFyYW1ldGVyKSB7XG4gICAgaWYgKHBhcmFtZXRlci5wcmVjaXNpb24gIT0gbnVsbCkge1xuICAgICAgcmV0dXJuIHBhcmFtZXRlci5wcmVjaXNpb247XG4gICAgfSBlbHNlIGlmIChwYXJhbWV0ZXIudmFsdWUgPT09IG51bGwpIHtcbiAgICAgIHJldHVybiAxO1xuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gMTg7XG4gICAgfVxuICB9LFxuXG4gIHJlc29sdmVTY2FsZTogZnVuY3Rpb24ocGFyYW1ldGVyKSB7XG4gICAgaWYgKHBhcmFtZXRlci5zY2FsZSAhPSBudWxsKSB7XG4gICAgICByZXR1cm4gcGFyYW1ldGVyLnNjYWxlO1xuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gMDtcbiAgICB9XG4gIH0sXG5cbiAgZ2VuZXJhdGVUeXBlSW5mbyhwYXJhbWV0ZXIsIF9vcHRpb25zKSB7XG4gICAgbGV0IHByZWNpc2lvbjtcbiAgICBpZiAocGFyYW1ldGVyLnByZWNpc2lvbiEgPD0gOSkge1xuICAgICAgcHJlY2lzaW9uID0gMHgwNTtcbiAgICB9IGVsc2UgaWYgKHBhcmFtZXRlci5wcmVjaXNpb24hIDw9IDE5KSB7XG4gICAgICBwcmVjaXNpb24gPSAweDA5O1xuICAgIH0gZWxzZSBpZiAocGFyYW1ldGVyLnByZWNpc2lvbiEgPD0gMjgpIHtcbiAgICAgIHByZWNpc2lvbiA9IDB4MEQ7XG4gICAgfSBlbHNlIHtcbiAgICAgIHByZWNpc2lvbiA9IDB4MTE7XG4gICAgfVxuXG4gICAgcmV0dXJuIEJ1ZmZlci5mcm9tKFtEZWNpbWFsTi5pZCwgcHJlY2lzaW9uLCBwYXJhbWV0ZXIucHJlY2lzaW9uISwgcGFyYW1ldGVyLnNjYWxlIV0pO1xuICB9LFxuXG4gIGdlbmVyYXRlUGFyYW1ldGVyTGVuZ3RoKHBhcmFtZXRlciwgb3B0aW9ucykge1xuICAgIGlmIChwYXJhbWV0ZXIudmFsdWUgPT0gbnVsbCkge1xuICAgICAgcmV0dXJuIE5VTExfTEVOR1RIO1xuICAgIH1cblxuICAgIGNvbnN0IHByZWNpc2lvbiA9IHBhcmFtZXRlci5wcmVjaXNpb24hO1xuICAgIGlmIChwcmVjaXNpb24gPD0gOSkge1xuICAgICAgcmV0dXJuIEJ1ZmZlci5mcm9tKFsweDA1XSk7XG4gICAgfSBlbHNlIGlmIChwcmVjaXNpb24gPD0gMTkpIHtcbiAgICAgIHJldHVybiBCdWZmZXIuZnJvbShbMHgwOV0pO1xuICAgIH0gZWxzZSBpZiAocHJlY2lzaW9uIDw9IDI4KSB7XG4gICAgICByZXR1cm4gQnVmZmVyLmZyb20oWzB4MERdKTtcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIEJ1ZmZlci5mcm9tKFsweDExXSk7XG4gICAgfVxuICB9LFxuXG4gICogZ2VuZXJhdGVQYXJhbWV0ZXJEYXRhKHBhcmFtZXRlciwgb3B0aW9ucykge1xuICAgIGlmIChwYXJhbWV0ZXIudmFsdWUgPT0gbnVsbCkge1xuICAgICAgcmV0dXJuO1xuICAgIH1cblxuICAgIGNvbnN0IHNpZ24gPSBwYXJhbWV0ZXIudmFsdWUgPCAwID8gMCA6IDE7XG4gICAgY29uc3QgdmFsdWUgPSBNYXRoLnJvdW5kKE1hdGguYWJzKHBhcmFtZXRlci52YWx1ZSAqIE1hdGgucG93KDEwLCBwYXJhbWV0ZXIuc2NhbGUhKSkpO1xuICAgIGNvbnN0IHByZWNpc2lvbiA9IHBhcmFtZXRlci5wcmVjaXNpb24hO1xuICAgIGlmIChwcmVjaXNpb24gPD0gOSkge1xuICAgICAgY29uc3QgYnVmZmVyID0gQnVmZmVyLmFsbG9jKDUpO1xuICAgICAgYnVmZmVyLndyaXRlVUludDgoc2lnbiwgMCk7XG4gICAgICBidWZmZXIud3JpdGVVSW50MzJMRSh2YWx1ZSwgMSk7XG4gICAgICB5aWVsZCBidWZmZXI7XG4gICAgfSBlbHNlIGlmIChwcmVjaXNpb24gPD0gMTkpIHtcbiAgICAgIGNvbnN0IGJ1ZmZlciA9IG5ldyBXcml0YWJsZVRyYWNraW5nQnVmZmVyKDkpO1xuICAgICAgYnVmZmVyLndyaXRlVUludDgoc2lnbik7XG4gICAgICBidWZmZXIud3JpdGVVSW50NjRMRSh2YWx1ZSk7XG4gICAgICB5aWVsZCBidWZmZXIuZGF0YTtcbiAgICB9IGVsc2UgaWYgKHByZWNpc2lvbiA8PSAyOCkge1xuICAgICAgY29uc3QgYnVmZmVyID0gbmV3IFdyaXRhYmxlVHJhY2tpbmdCdWZmZXIoMTMpO1xuICAgICAgYnVmZmVyLndyaXRlVUludDgoc2lnbik7XG4gICAgICBidWZmZXIud3JpdGVVSW50NjRMRSh2YWx1ZSk7XG4gICAgICBidWZmZXIud3JpdGVVSW50MzJMRSgweDAwMDAwMDAwKTtcbiAgICAgIHlpZWxkIGJ1ZmZlci5kYXRhO1xuICAgIH0gZWxzZSB7XG4gICAgICBjb25zdCBidWZmZXIgPSBuZXcgV3JpdGFibGVUcmFja2luZ0J1ZmZlcigxNyk7XG4gICAgICBidWZmZXIud3JpdGVVSW50OChzaWduKTtcbiAgICAgIGJ1ZmZlci53cml0ZVVJbnQ2NExFKHZhbHVlKTtcbiAgICAgIGJ1ZmZlci53cml0ZVVJbnQzMkxFKDB4MDAwMDAwMDApO1xuICAgICAgYnVmZmVyLndyaXRlVUludDMyTEUoMHgwMDAwMDAwMCk7XG4gICAgICB5aWVsZCBidWZmZXIuZGF0YTtcbiAgICB9XG4gIH0sXG5cbiAgdmFsaWRhdGU6IGZ1bmN0aW9uKHZhbHVlKTogbnVtYmVyIHwgbnVsbCB7XG4gICAgaWYgKHZhbHVlID09IG51bGwpIHtcbiAgICAgIHJldHVybiBudWxsO1xuICAgIH1cbiAgICB2YWx1ZSA9IHBhcnNlRmxvYXQodmFsdWUpO1xuICAgIGlmIChpc05hTih2YWx1ZSkpIHtcbiAgICAgIHRocm93IG5ldyBUeXBlRXJyb3IoJ0ludmFsaWQgbnVtYmVyLicpO1xuICAgIH1cbiAgICByZXR1cm4gdmFsdWU7XG4gIH1cbn07XG5cbmV4cG9ydCBkZWZhdWx0IERlY2ltYWw7XG5tb2R1bGUuZXhwb3J0cyA9IERlY2ltYWw7XG4iXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFDQTs7QUFDQTs7OztBQUVBLE1BQU1BLFdBQVcsR0FBR0MsTUFBTSxDQUFDQyxJQUFQLENBQVksQ0FBQyxJQUFELENBQVosQ0FBcEI7QUFFQSxNQUFNQyxPQUF3SSxHQUFHO0VBQy9JQyxFQUFFLEVBQUUsSUFEMkk7RUFFL0lDLElBQUksRUFBRSxTQUZ5STtFQUcvSUMsSUFBSSxFQUFFLFNBSHlJO0VBSy9JQyxXQUFXLEVBQUUsVUFBU0MsU0FBVCxFQUFvQjtJQUMvQixPQUFPLGFBQWMsS0FBS0MsZ0JBQUwsQ0FBc0JELFNBQXRCLENBQWQsR0FBa0QsSUFBbEQsR0FBMEQsS0FBS0UsWUFBTCxDQUFrQkYsU0FBbEIsQ0FBMUQsR0FBMEYsR0FBakc7RUFDRCxDQVA4STtFQVMvSUMsZ0JBQWdCLEVBQUUsVUFBU0QsU0FBVCxFQUFvQjtJQUNwQyxJQUFJQSxTQUFTLENBQUNHLFNBQVYsSUFBdUIsSUFBM0IsRUFBaUM7TUFDL0IsT0FBT0gsU0FBUyxDQUFDRyxTQUFqQjtJQUNELENBRkQsTUFFTyxJQUFJSCxTQUFTLENBQUNJLEtBQVYsS0FBb0IsSUFBeEIsRUFBOEI7TUFDbkMsT0FBTyxDQUFQO0lBQ0QsQ0FGTSxNQUVBO01BQ0wsT0FBTyxFQUFQO0lBQ0Q7RUFDRixDQWpCOEk7RUFtQi9JRixZQUFZLEVBQUUsVUFBU0YsU0FBVCxFQUFvQjtJQUNoQyxJQUFJQSxTQUFTLENBQUNLLEtBQVYsSUFBbUIsSUFBdkIsRUFBNkI7TUFDM0IsT0FBT0wsU0FBUyxDQUFDSyxLQUFqQjtJQUNELENBRkQsTUFFTztNQUNMLE9BQU8sQ0FBUDtJQUNEO0VBQ0YsQ0F6QjhJOztFQTJCL0lDLGdCQUFnQixDQUFDTixTQUFELEVBQVlPLFFBQVosRUFBc0I7SUFDcEMsSUFBSUosU0FBSjs7SUFDQSxJQUFJSCxTQUFTLENBQUNHLFNBQVYsSUFBd0IsQ0FBNUIsRUFBK0I7TUFDN0JBLFNBQVMsR0FBRyxJQUFaO0lBQ0QsQ0FGRCxNQUVPLElBQUlILFNBQVMsQ0FBQ0csU0FBVixJQUF3QixFQUE1QixFQUFnQztNQUNyQ0EsU0FBUyxHQUFHLElBQVo7SUFDRCxDQUZNLE1BRUEsSUFBSUgsU0FBUyxDQUFDRyxTQUFWLElBQXdCLEVBQTVCLEVBQWdDO01BQ3JDQSxTQUFTLEdBQUcsSUFBWjtJQUNELENBRk0sTUFFQTtNQUNMQSxTQUFTLEdBQUcsSUFBWjtJQUNEOztJQUVELE9BQU9WLE1BQU0sQ0FBQ0MsSUFBUCxDQUFZLENBQUNjLGtCQUFTWixFQUFWLEVBQWNPLFNBQWQsRUFBeUJILFNBQVMsQ0FBQ0csU0FBbkMsRUFBK0NILFNBQVMsQ0FBQ0ssS0FBekQsQ0FBWixDQUFQO0VBQ0QsQ0F4QzhJOztFQTBDL0lJLHVCQUF1QixDQUFDVCxTQUFELEVBQVlVLE9BQVosRUFBcUI7SUFDMUMsSUFBSVYsU0FBUyxDQUFDSSxLQUFWLElBQW1CLElBQXZCLEVBQTZCO01BQzNCLE9BQU9aLFdBQVA7SUFDRDs7SUFFRCxNQUFNVyxTQUFTLEdBQUdILFNBQVMsQ0FBQ0csU0FBNUI7O0lBQ0EsSUFBSUEsU0FBUyxJQUFJLENBQWpCLEVBQW9CO01BQ2xCLE9BQU9WLE1BQU0sQ0FBQ0MsSUFBUCxDQUFZLENBQUMsSUFBRCxDQUFaLENBQVA7SUFDRCxDQUZELE1BRU8sSUFBSVMsU0FBUyxJQUFJLEVBQWpCLEVBQXFCO01BQzFCLE9BQU9WLE1BQU0sQ0FBQ0MsSUFBUCxDQUFZLENBQUMsSUFBRCxDQUFaLENBQVA7SUFDRCxDQUZNLE1BRUEsSUFBSVMsU0FBUyxJQUFJLEVBQWpCLEVBQXFCO01BQzFCLE9BQU9WLE1BQU0sQ0FBQ0MsSUFBUCxDQUFZLENBQUMsSUFBRCxDQUFaLENBQVA7SUFDRCxDQUZNLE1BRUE7TUFDTCxPQUFPRCxNQUFNLENBQUNDLElBQVAsQ0FBWSxDQUFDLElBQUQsQ0FBWixDQUFQO0lBQ0Q7RUFDRixDQXpEOEk7O0VBMkQvSSxDQUFFaUIscUJBQUYsQ0FBd0JYLFNBQXhCLEVBQW1DVSxPQUFuQyxFQUE0QztJQUMxQyxJQUFJVixTQUFTLENBQUNJLEtBQVYsSUFBbUIsSUFBdkIsRUFBNkI7TUFDM0I7SUFDRDs7SUFFRCxNQUFNUSxJQUFJLEdBQUdaLFNBQVMsQ0FBQ0ksS0FBVixHQUFrQixDQUFsQixHQUFzQixDQUF0QixHQUEwQixDQUF2QztJQUNBLE1BQU1BLEtBQUssR0FBR1MsSUFBSSxDQUFDQyxLQUFMLENBQVdELElBQUksQ0FBQ0UsR0FBTCxDQUFTZixTQUFTLENBQUNJLEtBQVYsR0FBa0JTLElBQUksQ0FBQ0csR0FBTCxDQUFTLEVBQVQsRUFBYWhCLFNBQVMsQ0FBQ0ssS0FBdkIsQ0FBM0IsQ0FBWCxDQUFkO0lBQ0EsTUFBTUYsU0FBUyxHQUFHSCxTQUFTLENBQUNHLFNBQTVCOztJQUNBLElBQUlBLFNBQVMsSUFBSSxDQUFqQixFQUFvQjtNQUNsQixNQUFNYyxNQUFNLEdBQUd4QixNQUFNLENBQUN5QixLQUFQLENBQWEsQ0FBYixDQUFmO01BQ0FELE1BQU0sQ0FBQ0UsVUFBUCxDQUFrQlAsSUFBbEIsRUFBd0IsQ0FBeEI7TUFDQUssTUFBTSxDQUFDRyxhQUFQLENBQXFCaEIsS0FBckIsRUFBNEIsQ0FBNUI7TUFDQSxNQUFNYSxNQUFOO0lBQ0QsQ0FMRCxNQUtPLElBQUlkLFNBQVMsSUFBSSxFQUFqQixFQUFxQjtNQUMxQixNQUFNYyxNQUFNLEdBQUcsSUFBSUksK0JBQUosQ0FBMkIsQ0FBM0IsQ0FBZjtNQUNBSixNQUFNLENBQUNFLFVBQVAsQ0FBa0JQLElBQWxCO01BQ0FLLE1BQU0sQ0FBQ0ssYUFBUCxDQUFxQmxCLEtBQXJCO01BQ0EsTUFBTWEsTUFBTSxDQUFDTSxJQUFiO0lBQ0QsQ0FMTSxNQUtBLElBQUlwQixTQUFTLElBQUksRUFBakIsRUFBcUI7TUFDMUIsTUFBTWMsTUFBTSxHQUFHLElBQUlJLCtCQUFKLENBQTJCLEVBQTNCLENBQWY7TUFDQUosTUFBTSxDQUFDRSxVQUFQLENBQWtCUCxJQUFsQjtNQUNBSyxNQUFNLENBQUNLLGFBQVAsQ0FBcUJsQixLQUFyQjtNQUNBYSxNQUFNLENBQUNHLGFBQVAsQ0FBcUIsVUFBckI7TUFDQSxNQUFNSCxNQUFNLENBQUNNLElBQWI7SUFDRCxDQU5NLE1BTUE7TUFDTCxNQUFNTixNQUFNLEdBQUcsSUFBSUksK0JBQUosQ0FBMkIsRUFBM0IsQ0FBZjtNQUNBSixNQUFNLENBQUNFLFVBQVAsQ0FBa0JQLElBQWxCO01BQ0FLLE1BQU0sQ0FBQ0ssYUFBUCxDQUFxQmxCLEtBQXJCO01BQ0FhLE1BQU0sQ0FBQ0csYUFBUCxDQUFxQixVQUFyQjtNQUNBSCxNQUFNLENBQUNHLGFBQVAsQ0FBcUIsVUFBckI7TUFDQSxNQUFNSCxNQUFNLENBQUNNLElBQWI7SUFDRDtFQUNGLENBM0Y4STs7RUE2Ri9JQyxRQUFRLEVBQUUsVUFBU3BCLEtBQVQsRUFBK0I7SUFDdkMsSUFBSUEsS0FBSyxJQUFJLElBQWIsRUFBbUI7TUFDakIsT0FBTyxJQUFQO0lBQ0Q7O0lBQ0RBLEtBQUssR0FBR3FCLFVBQVUsQ0FBQ3JCLEtBQUQsQ0FBbEI7O0lBQ0EsSUFBSXNCLEtBQUssQ0FBQ3RCLEtBQUQsQ0FBVCxFQUFrQjtNQUNoQixNQUFNLElBQUl1QixTQUFKLENBQWMsaUJBQWQsQ0FBTjtJQUNEOztJQUNELE9BQU92QixLQUFQO0VBQ0Q7QUF0RzhJLENBQWpKO2VBeUdlVCxPOztBQUNmaUMsTUFBTSxDQUFDQyxPQUFQLEdBQWlCbEMsT0FBakIifQ==