
const Database = require('../database/clsQueryProcess');
const database = new Database();
const globalData = require('../global/globalData');
const models = require('../../config/dbConnection').models;
const sequelize = require('../../config/dbConnection').sequelize;
const { QueryTypes } = require('sequelize');


class Hmi {

    async getHMIStatus(value) {
        let hmi = value.hmi;
        let resObj = {};
        const connectHmiDetailObj = await models.IdsPortDetails.findAll({
            where: 
                {  'HMI': hmi },
        });
        let arrResult = await database.select(connectHmiDetailObj);
        if (arrResult[0][0] == undefined || arrResult[0][0] == "") {
            Object.assign(resObj, { status: "fail" }, { result: 'IDS Not Connected' });
            return resObj;
        }
        else {
            Object.assign(resObj, { status: "success" }, { result: arrResult[0][0] });
            return resObj;
        }
    }

    async getResbPiNoFromHmi(strHmi) {
        let hmiDetails = await models.tbl_rpi.findAll({ where: { "IDSNo": strHmi } })
        hmiDetails[0].IDSNo = hmiDetails[0].RPIID
        return [hmiDetails[0]];
       // let arrRes = await database.select(objHmi);
        //return arrRes[0];
    }


    async getHmiNoFromResbPi(strResberryPi) {
        let objHmi = await models.tbl_rpi.findAll({
            where: {
                RPIID: strResberryPi
            }
        })
     let arrRes= [objHmi[0]];
     return arrRes[0].IDSNo


       
    }

    async getAliasOfRPI(RPi) {
        try {
            let objIdsPortDetails = await models.tbl_rpi.findAll({
                where:
                {
                    RPIID: RPi 
                }
                
            })
            let resIdsPort= [objIdsPortDetails[0]]
            return resIdsPort[0].IDSNo
    
        } catch (error) {

        }
    }
    async pushCalibrationObj(strBalId, strIdsNo, balType) {
        try {
            // var objOwner = globalData.arrPreWeighCalibOwner.find(k => k.idsNo == strIdsNo);
            if (balType == 'analytical') {
                var calibTable = 'tbl_calibration_status';
            } else {
                var calibTable = 'tbl_calibration_status_bin';
            }

            var result = await models[calibTable].findOne({
                where: {
                    'BalID': strBalId
                }
            });
            result = result
            // let calibrationStatus = [];
            const tempObj = {
                P: result.P,
                E: result.E,
                R: result.R,
                U: result.U,
                L: result.L,
                V: result.V
            }
            let statusEqualToOne = Object.keys(tempObj).filter(k => tempObj[k] == 1);
            result = await models[calibTable].findOne({
                where: {
                    'BalID': strBalId
                }
            });
            tempObj.P = result.P;
            tempObj.E = result.E;
            tempObj.R = result.R;
            tempObj.U = result.U;
            tempObj.L = result.L;
            tempObj.V = result.V;

            var objFound = globalData.calibrationStatus.find(k => k.BalId == strBalId);
            if (objFound == undefined) {
                globalData.calibrationStatus.push({ BalId: strBalId, status: tempObj });
            } else {
                objFound.BalId = strBalId;
                objFound.status = tempObj;
                //hmi or  resbppi
            }

            // calibrationStatus.push({ BalId: strBalId, status: tempObj });
            return 0;
        } catch (err) {
            throw new Error(err);
        }
    }
    async checkDateBetween(strBalId, calibdate, arr) {
        try {
            const arrcopy = [...arr];
            let tempcalibdate = calibdate.split('-')[2];
            // arrcopy[(arrcopy.findIndex(k=>k ==  calibdate.split('-')[2])) - 1]
            let previousDueDt = arrcopy[(arrcopy.findIndex(k => k == tempcalibdate)) - 1];
            if (previousDueDt == undefined) {
                return false
            }
           if(previousDueDt.includes('0') == false){
            previousDueDt = previousDueDt.padStart(2, 0)
           }
            let previousDate = calibdate.replace(tempcalibdate, previousDueDt)
            

            var obj = await models.tbl_calibration_periodic_master.findAll({
                where:{
                     'Periodic_BalID': strBalId ,
                     'Periodic_CalbDate': previousDate == null ? calibdate:previousDate,
                }
            })
            var res = obj
            res = res.length > 0 ? res = true : false
            return res;
        } catch (error) {
            throw new Error(error)
        }
    }

}
module.exports = Hmi;