const date = require('date-and-time');

const globalData = require('../../global/globalData')
const clsActivityLog = require('../clsActivityLog.model');
const clsInstrumentUsage = require('../clsInstrumentUsageLog');
const clsCommonInsertOpt = require('../Product/clsCommonInsertOperation.model');
const clsMqttSender = require('../Mqtt/mqttSender.class');
const DataBase = require('../../database/clsQueryProcess');
const FormulaFunModel = require('../Product/clsformulaFun.model');
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const clsCommonUseFunction = require('../clsCommonUseFunction');
const PowerBackup = require('../../Utills/powerBackUp/powerbackup');
const models = require('../../../config/dbConnection').models;
const sequelize = require('../../../config/dbConnection').sequelize;
const clsCalculation = require('../clsCalculationOperation');
const clsPrintOperations = require("../Print/clsPrintOperation")
const printOperations = new clsPrintOperations()
const objcalc = new clsCalculation();
const objActivityLog = new clsActivityLog();
const objInstrumentUsage = new clsInstrumentUsage();
const objCommonInsertOpt = new clsCommonInsertOpt();
const mqttSender = new clsMqttSender();
const database = new DataBase();
const objformulaFun = new FormulaFunModel();
const objCommonUseFunc = new clsCommonUseFunction();
const objPowerBackup = new PowerBackup();
const clsMonit = require('../MonitorSocket/clsMonitSocket')
const objMonit = new clsMonit();



class ThicknessModel {

    async processThicknessData(dataObj) {
        try {
            let objActivity = {};
            let maxLimitT1, maxLimitT2, minLimitT2, minLimitT1, strTableName, strDetailTbl;
            const strHmi = dataObj.Hmi;
            const strIdsNo = dataObj.idsNo;
            const menuName = dataObj.menuName;
            let actualWt = dataObj.actualWt;

            let SelectedIdsNo;
            var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
            if (IPQCObject != undefined) {
                SelectedIdsNo = IPQCObject.selectedIds.Idsno;
            } else {
                SelectedIdsNo = strHmi;
            }
            let reportLimitMsg = "Report Within Limit";
            const objSelMenu = globalData.arrSelectedMenu.find(k => k.idsNo == strIdsNo);
            const ThicknessDetail = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi);
            let sample = parseFloat(ThicknessDetail.data.noOfSample);
            let batchNo = ThicknessDetail.data.Batch;
            let tempCounterObj = globalData.arrWeighmentCounter.find(k => k.Hmi == strHmi);
            let tempUserObject = globalData.arrUsers.find(k => k.Hmi === strHmi);
            const sampleRemark = globalData.arrSampleRemarkForAllTest.find(k => k.Hmi == strHmi);
            let tableName = "tbl_powerbackup";

            var Side = ThicknessDetail.data.Side
            let _cubicalData = globalData.arrIdsInfo.find(k => k.idsNo == strIdsNo).cubicalData;
            if (tempCounterObj === undefined) {
                globalData.arrWeighmentCounter.push({
                    'Hmi': strHmi,
                    'counter': 0
                })
            }
            tempCounterObj = globalData.arrWeighmentCounter.find(k => k.Hmi == strHmi);

            switch (menuName) {
                case 'Thickness': {
                    strTableName = "tbl_tab_master3";
                    strDetailTbl = "tbl_tab_detail3";
                    // typeValue = 1;
                    maxLimitT1 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail, 'T1');
                    maxLimitT2 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail);
                    minLimitT2 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail);
                    minLimitT1 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail, 'T1');
                }
                    break;
                case 'Differential': {
                    strTableName = "tbl_cap_master3";
                    strDetailTbl = "tbl_cap_detail3";
                }
                    break;
            }
            let intProductType = objSelMenu.selectedProductDetail.ProductType;

            let __parameterThickness;
            const __ParamRemark = {
                idsNo: strIdsNo,
                menuName: menuName,
                batchNo: batchNo,
                tableName: strTableName,
            }

            if (sample >= tempCounterObj.counter) {

                tempCounterObj.counter += 1;

                __parameterThickness = {
                    strTableName: strTableName,
                    strDetailTbl: strDetailTbl,
                    objProductDetails: ThicknessDetail.data,
                    uniqueSerialNumber: strIdsNo,
                    strBalId: dataObj.instrumentId,
                    ProtocolData: dataObj.actualWt,
                    ProtocolUnit: dataObj.unit,
                    ProtocolDecPoint: dataObj.decPoint,
                    strHmi: strHmi,
                    seqNoOfWt: tempCounterObj.counter,
                    productType: objSelMenu.selectedProductDetail
                }



                var powerbackupobj = {
                    strTableName: strTableName,
                    strDetailTbl: strDetailTbl,
                    cubicaNo: _cubicalData.Sys_CubicNo,
                    cubicType: _cubicalData.Sys_CubType,
                    cubicSysBFGcode: _cubicalData.Sys_BFGCode,
                    cubicBatch: _cubicalData.Sys_Batch,
                    menuName: ThicknessDetail.data.menuName,
                    ProductType: objSelMenu.selectedProductDetail.ProductType,
                    Userid: tempUserObject.UserId,
                    idsNo: strIdsNo,
                    Hmi: strHmi,
                    Incomp_RepSerNo: tempCounterObj.counter,
                    ReportType: _cubicalData.Sys_RptType,
                    RecSampleNo: tempCounterObj.counter,
                    SelectedIds: SelectedIdsNo
                }

                let _check_combination = await objPowerBackup._check_combination_pow(objSelMenu, powerbackupobj, tableName);
                if (_check_combination !== undefined) {
                    tempCounterObj.counter = _check_combination.RecSampleNo + 1;
                    powerbackupobj.RecSampleNo = tempCounterObj.counter;
                    __parameterThickness.seqNoOfWt = tempCounterObj.counter;
                }

                if (tempCounterObj.counter == 1) {

                    var RepSerno = await objCommonInsertOpt.insert_Into_Incomplete_Master(__parameterThickness);
                    powerbackupobj.Incomp_RepSerNo = RepSerno.srno;
                    await objPowerBackup.getStatusoFTestForPowerBackup(powerbackupobj);
                    Object.assign(objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { activity: 'Thickness Weighment Started on TSH' + strHmi });
                    await objActivityLog.ActivityLogEntry(objActivity);
                    await objInstrumentUsage.InstrumentUsage('Vernier', strIdsNo, 'tbl_instrumentlog_vernier', 'Thickness', 'started');
                    await objCommonInsertOpt.InsertIncompleteRemarkEntry(__ParamRemark);

                }
                //insert data into detail table
                console.log(tempCounterObj.counter);
                var decimal = await objCommonInsertOpt.insert_Into_Incomplete_Detail(__parameterThickness);
                powerbackupobj.Incomp_RepSerNo = decimal.repSerNo;
                await objPowerBackup.getStatusoFTestForPowerBackup(powerbackupobj);
                var incompRepSerNo = await objPowerBackup.updateTestCount(objSelMenu, powerbackupobj, tableName);
                var updateData = await objcalc.calculation_operation(__parameterThickness, decimal.repSerNo);
                // mqttSender.sendData(strHmi, `DisplayResult:${tempCounterObj.counter}:${Number(dataObj.actualWt).toFixed(decimal)} ${dataObj.unit}`)
                let sampleNo = tempCounterObj.counter
                let limitObjResp = await objCommonUseFunc.SendCommon({ strHmi, actualWt, minLimitT2, maxLimitT2, minLimitT1, maxLimitT1, menuName, sampleNo })
                let color = limitObjResp.Color;
                let limit = limitObjResp.limit;

                await objMonit.monit({
                    case: 'TestWeight', Hmi: strHmi, data: {
                        Weight: `${actualWt} ${(dataObj.unit).toLowerCase()}`, srNo: "", message: `${limit}`
                    }
                });

                mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${tempCounterObj.counter}:${Number(actualWt).toFixed(2)} ${dataObj.unit}:${color}`);
                mqttSender.sendData(strHmi, limit);

            }

            // if (parseFloat(actualWt) < parseFloat(minLimitT2) || parseFloat(actualWt) > parseFloat(maxLimitT2)) {
            //     sampleRemark.OutOfRemark = true;
            //     console.log('recieved weight is out of t2 limit');
            //     mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} recieved weight is out of t2 limit`);

            // } else if (parseFloat(actualWt) < parseFloat(minLimitT1) || parseFloat(actualWt) > parseFloat(maxLimitT1)) {
            //     sampleRemark.OutOfRemark = true;
            //     mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} recieved weight is out of t1 limit`);
            //     console.log('recieved weight is out of t1 limit');
            // } else {
            //     mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} recieved weight is within limit`);
            //     console.log('recieved weight is within limit');
            // }

            if (sample == tempCounterObj.counter) {
                //move data from incomplete to complete 
                //remove outOfLimit Flag
                //check nmt range
                var updateData = await objcalc.calculation_operation(__parameterThickness, decimal.repSerNo);
                // if (Side == 'RHS') {
                //     var response = await objCommonInsertOpt.saveCompleteData(__parameterThickness, 3, Side);
                //     await objCommonInsertOpt.updateEndDate(strIdsNo, strHmi, strTableName);
                //     const objUpdateValidation = await models.tbl_cubical.update({
                //         'Sys_Validation': 0
                //     }, {
                //         where: {
                //             'Sys_rpi': _cubicalData.Sys_rpi
                //         }

                //     });
                // } else {
                // if (_cubicalData.Sys_RotaryType == "Single") {
                var response = await objCommonInsertOpt.saveCompleteData(__parameterThickness, 3);
                // await objCommonInsertOpt.updateEndDate(strIdsNo, strHmi, strTableName);
                const objUpdateValidation = await models.tbl_cubical.update({
                    'Sys_Validation': 0
                }, {
                    where: {
                        'Sys_rpi': _cubicalData.Sys_rpi
                    }

                });
                // }
                // }

                // if (Side == 'RHS') {
                if (updateData == "Complies") {
                    var printObj = {
                        RepSerNo: response.RepSerNo,
                        Side: Side,
                        batchNo: _cubicalData.Sys_Batch,
                        cubicleType: _cubicalData.Sys_CubType,
                        int_ReportFormat: 1,
                        printNo: 0,
                        recordFrom: "Current",
                        reportOption: menuName,
                        reportType: "Complete",
                        testType: "Regular",
                        userId: tempUserObject.UserId,
                        username: tempUserObject.UserName,
                        str_url: objSelMenu.selectedProductDetail.ProductType === 1 ? "Tablet" : "Capsule"

                    }

                    await printOperations.callViewTabReport(printObj, intProductType, strHmi);

                }
                // }
                const _deletePowerbackup = await models.tbl_powerbackup.destroy({
                    where: {
                        Idsno: strHmi,
                        Sys_Batch: _cubicalData.Sys_Batch,
                        WeighmentName: menuName
                    }
                })
                if (updateData == "Not Complies") {
                    reportLimitMsg = "Report Out Of Limit"
                }
                else {
                    reportLimitMsg = "Report Within Limit"
                }
                Object.assign(objActivity,
                    { strUserId: tempUserObject.UserId },
                    { strUserName: tempUserObject.UserName },
                    { activity: 'Thickness Weighment Completed on TSH' + strHmi });
                await objActivityLog.ActivityLogEntry(objActivity);
                await objInstrumentUsage.InstrumentUsage('Vernier', strIdsNo, 'tbl_instrumentlog_vernier', '', 'completed');
                console.log(tempCounterObj.counter);
                // if(Side == 'LHS'){
                //     mqttSender.sendData(strHmi, `${mqttProtocol.SideChange}: ${Side} And ${mqttProtocol.SideChanges} RHS`);
                // }

                //clear counter array
                globalData.arrWeighmentCounter.findIndex(k => k.Hmi == strHmi) == -1 ?
                    globalData.arrWeighmentCounter :
                    globalData.arrWeighmentCounter.splice(globalData.arrWeighmentCounter.findIndex(k => k.Hmi == strHmi), 1);

                (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus :
                    globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);
                //test splice if rotarty is not double
                (globalData.arrOutFlagForTest.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrOutFlagForTest :
                    globalData.arrOutFlagForTest.splice(globalData.arrOutFlagForTest.findIndex((element) => element.Hmi === strHmi), 1);

                globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
                    globalData.arrSelectedMenu :
                    globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);

                // setTimeout(mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}${reportLimitMsg}`), 1000);
                await objMonit.monit({
                    case: 'ReportStatus',
                    Hmi: strHmi,
                    data: {
                        message: reportLimitMsg
                    }
                });
                mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}${reportLimitMsg}`);

                return

            }
        } catch (error) {
            throw new Error(error);
        }
    }


}

module.exports = ThicknessModel;