const date = require('date-and-time');

const globalData = require('../../global/globalData')
const clsActivityLog = require('../clsActivityLog.model');
const clsInstrumentUsage = require('../clsInstrumentUsageLog');
const clsCommonInsertOpt = require('../Product/clsCommonInsertOperation.model');
const clsMqttSender = require('../Mqtt/mqttSender.class');
const DataBase = require('../../database/clsQueryProcess');
const FormulaFunModel = require('../Product/clsformulaFun.model');
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const GLOBAL_NOMENCLATURE = require("../../global/GLOBAL_NOMENCLATURE");
const { models } = require('../../../config/dbConnection');
const sequelize = require("../../../config/dbConnection").sequelize;
const { QueryTypes } = require('sequelize');
const moment = require('moment');
const momentObj = require('moment');
const { where } = require('sequelize/lib/sequelize');
const clsMonit = require('../MonitorSocket/clsMonitSocket');

const clsPrintOperations = require("../Print/clsPrintOperation")
const objMonit = new clsMonit();
const printOperations = new clsPrintOperations();
const objActivityLog = new clsActivityLog();
const objInstrumentUsage = new clsInstrumentUsage();
const objCommonInsertOpt = new clsCommonInsertOpt();
const mqttSender = new clsMqttSender();
const database = new DataBase();
const objformulaFun = new FormulaFunModel();

class TappedDensityModel {

    async processTappedDensityData(dataObj) {
        try {
            let objActivity = {};
            let maxLimitT1, maxLimitT2, minLimitT2, minLimitT1, strTableName, strDetailTbl;
            const strHmi = dataObj.Hmi;
            const strIdsNo = dataObj.idsNo;
            const menuName = dataObj.menuName;
            let actualWt = dataObj.arrActualWt;
            const objSelMenu = globalData.arrSelectedMenu.find(k => k.idsNo == strIdsNo);
            const TappedDensityDetail = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi);
            let sample = parseFloat(TappedDensityDetail.data.noOfSample);
            let batchNo = TappedDensityDetail.data.Batch;
            let tempCounterObj = globalData.arrWeighmentCounter.find(k => k.Hmi == strHmi);
            let tempUserObject = globalData.arrUsers.find(k => k.Hmi === strHmi);
            const sampleRemark = globalData.arrSampleRemarkForAllTest.find(k => k.Hmi == strHmi);

            if (tempCounterObj === undefined) {
                globalData.arrWeighmentCounter.push({
                    'Hmi': strHmi,
                    'counter': 0
                })
            }
            tempCounterObj = globalData.arrWeighmentCounter.find(k => k.Hmi == strHmi);



            const __parameterTappedDensity = {
                objProductDetails: TappedDensityDetail.data,
                uniqueSerialNumber: strIdsNo,
                strBalId: dataObj.instrumentId,
                ProtocolData: actualWt,
                Hmi: strHmi,
                menuName: menuName,
                productType: objSelMenu.selectedProductDetail
            }

            const __ParamRemark = {
                idsNo: strIdsNo,
                menuName: menuName,
                batchNo: batchNo,
                tableName: strTableName,
            }


            await this.saveTDTData(__parameterTappedDensity, 15);
        } catch (error) {
            throw new Error(error);
        }
    }

    async saveTDTData(dataObj, menuSeqNo) {
        try {
            let strIdsNo = dataObj.uniqueSerialNumber;
            let strHmi = dataObj.Hmi;
            var menuName = dataObj.menuName;
            var CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
            var arrTDTData = dataObj.ProtocolData;
            var tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
            var Product = globalData.arrProductTypeArray.find(k => k.Hmi == strHmi).productDetail[0];


            if (arrTDTData.length == 18 || arrTDTData.length == 22 || arrTDTData.length == 20 || arrTDTData.length == 16 || arrTDTData.length == 17 || arrTDTData.length == 14) {
                let responseObj = {};
                var count1 = 0, count2 = 0, count3 = 0, count4 = 0, vol1 = 0, vol2 = 0, vol3 = 0, vol4 = 0, add1 = 0, add2 = 0;
                var wtofSampleVal = 0, initialVolumeVal = 0, tapDensityVal = 0, compressIndexVal = 0, hausnerRatioVal = 0, initialDensityVal = 0;
                var model = 0, serial = 0, instru = 0;
                var diff1 = 0, diff2 = 0, diff3 = 0, unit = 0;
                var method = "";
                var BulkDensity = 0;
                var decimalPoint = 0;

                let selectedIdsNo;
                var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strIdsNo);
                if (IPQCObject != undefined) {
                    selectedIdsNo = IPQCObject.selectedIds;
                } else {
                    selectedIdsNo = strIdsNo;
                }

                var cubicalObj = globalData.arrIdsInfo.find(k => k.idsNo == selectedIdsNo).cubicalData;

                // var objLotData = globalData.arrLot.find(k => k.idsNo == IdsNo);
                var ProductType = globalData.arrProductTypeArray.find(k => k.idsNo == selectedIdsNo);
                for (const key of arrTDTData) {
                    if ("modelNo" in key) {
                        model = key['modelNo']
                    }
                    if ("serialNo" in key) {
                        serial = key['serialNo']
                    }
                    if ("instrumentNo" in key) {
                        instru = key['instrumentNo']
                        if (instru.trim() == "") {
                            instru = 0;
                        }
                    }
                    if ("method" in key) {
                        method = key['method']
                    }
                    if ("tapCount1" in key) {
                        count1 = key['tapCount1']
                    }

                    if ("tapCount2" in key) {
                        count2 = key['tapCount2']
                    }
                    if ("tapCount3" in key) {
                        count3 = key['tapCount3']
                    }
                    if ("tapCount4" in key) {
                        count4 = key['tapCount4']
                    }
                    if ("wtOfSample" in key) {
                        wtofSampleVal = key['wtOfSample']
                    }
                    if ("initialVolume" in key) {
                        initialVolumeVal = key['initialVolume']
                    }
                    if ("volumeTapCount1" in key) {
                        vol1 = key['volumeTapCount1']
                    }
                    if ("volumeTapCount2" in key) {
                        vol2 = key['volumeTapCount2']
                    }
                    if ("volumeTapCount3" in key) {
                        vol3 = key['volumeTapCount3']
                    }
                    if ("volumeTapCount4a" in key) {
                        add1 = key['volumeTapCount4a']
                    }
                    if ("volumeTapCount4b" in key) {
                        add2 = key['volumeTapCount4b']
                    }
                    if ("tapDensityWVf" in key) {
                        tapDensityVal = key['tapDensityWVf']
                    }
                    if ("initialDensityWvo" in key) {
                        initialDensityVal = key['initialDensityWvo']
                    }
                    if ("compressibilityIndex" in key) {
                        compressIndexVal = key['compressibilityIndex']
                    }
                    if ("hausnerRatio" in key) {
                        hausnerRatioVal = key['hausnerRatio']
                    }
                    if ("diff_V2_V3" in key) {
                        diff1 = key['diff_V2_V3']
                    }
                    if ("diff_V3_V4a" in key) {
                        diff2 = key['diff_V3_V4a']
                    }
                    if ("diff_V4a_V4b" in key) {
                        diff3 = key['diff_V4a_V4b']
                    }

                }
                wtofSampleVal = wtofSampleVal.split(" ");
                initialVolumeVal = initialVolumeVal.split(" ");
                BulkDensity = parseFloat(wtofSampleVal[0] / initialVolumeVal[0]);

                //Rounding to 2 digits
                BulkDensity = BulkDensity;
                var arrTempSplit = wtofSampleVal[0].split(".");
                decimalPoint = arrTempSplit[1].length;

                let now = new Date();
                // get product parameter
                // var res = await proObj.productData(cubicalObj);
                //final value of Tap density and Bulk Density for report print
                initialDensityVal = initialDensityVal.split(" ")[0].trim();  //for bulk density
                tapDensityVal = tapDensityVal.split(" ")[0].trim() //for Tap density

                //Layer condition
                var productMaster = ProductType.productType
                var layer = 'NA';
                var layerName = 'NA';
                if ((dataObj.objProductDetails.menuName == GLOBAL_NOMENCLATURE.TDLayer1Menu)) {
                    layer = 'Layer 1';
                    layerName = productMaster.IsBilayerLbl;
                } else if ((dataObj.objProductDetails.menuName == GLOBAL_NOMENCLATURE.TDLayer2Menu)) {
                    layer = 'Layer 2';
                    layerName = productMaster.IsTrilayerLbl;
                }

                const checkData = await models.tbl_tapdensity.findAll({
                    attributes: [
                        [sequelize.fn('max', sequelize.col('RepSerNo')), "RepSerNo"]
                    ],
                    where: {
                        BFGCode: cubicalObj.Sys_BFGCode,
                        ProductName: cubicalObj.Sys_ProductName,
                        PVersion: cubicalObj.Sys_PVersion,
                        Version: cubicalObj.Sys_Version,
                        BatchNo: cubicalObj.Sys_Batch,
                        IDSNo: strHmi,
                    }
                })
                let result = checkData;
                var intMstSerNo;
                if (result[0].RepSerNo == null) {
                    intMstSerNo = 1;
                } else {
                    var newMstSerNo = result[0].RepSerNo + 1;
                    intMstSerNo = newMstSerNo;
                }

                let t1PosTd = ((Number(ProductType.productDetail[0][0].Param2_Upp) == 99999) || (Number(ProductType.productDetail[0][0].Param2_Upp) == 0)) ? "NA" : Number(ProductType.productDetail[0][0].Param2_Upp).toFixed(ProductType.productDetail[0][0].Param2_DP)
                let t1NegTd = ((Number(ProductType.productDetail[0][0].Param2_Low) == 99999) || (Number(ProductType.productDetail[0][0].Param2_Low) == 0)) ? "NA" : Number(ProductType.productDetail[0][0].Param2_Low).toFixed(ProductType.productDetail[0][0].Param2_DP)
                let t1PosBulk = ((Number(ProductType.productDetail[0][0].Param3_Upp) == 99999) || (Number(ProductType.productDetail[0][0].Param3_Upp) == 0)) ? "NA" : Number(ProductType.productDetail[0][0].Param3_Upp).toFixed(ProductType.productDetail[0][0].Param2_DP)
                let t1NegBulk = ((Number(ProductType.productDetail[0][0].Param3_Low) == 99999) || (Number(ProductType.productDetail[0][0].Param3_Low) == 0)) ? "NA" : Number(ProductType.productDetail[0][0].Param3_Low).toFixed(ProductType.productDetail[0][0].Param2_DP)
                var saveTDData = await models.tbl_tapdensity.create({
                    MstSerNo: intMstSerNo,
                    BFGCode: cubicalObj.Sys_BFGCode,
                    ProductType: ProductType.productType.ProductType,
                    ProductId: cubicalObj.Sys_BFGCode,
                    ProductName: cubicalObj.Sys_ProductName, // ProductType.productType
                    PVersion: cubicalObj.Sys_PVersion,
                    Version: cubicalObj.Sys_Version,
                    InstrumentID: instru,
                    TDID: CurrentCubicalObj.Sys_TapDensityID,
                    T1PosTD: t1PosTd,
                    T1NegTD: t1NegTd,
                    TPosBulk: t1PosBulk,
                    TNegBulk: t1NegBulk,
                    // ModelNo: model,
                    // SerialNo: serial,
                    BatchNo: cubicalObj.Sys_Batch,
                    BatchSize: `${cubicalObj.Sys_BatchSize} ${cubicalObj.Sys_BatchSizeUnit}`,
                    Department: cubicalObj.Sys_dept,
                    CubicleName: cubicalObj.Sys_CubicName,
                    CubicalNo: cubicalObj.Sys_CubicNo,
                    Idsno: strHmi,
                    MachineCode: cubicalObj.Sys_MachineCode,
                    Unit: 'gm/ml',
                    DecimalPoint: decimalPoint,
                    BulkWeight: wtofSampleVal[0],
                    BulkVolume: initialVolumeVal[0],
                    BulkDensity: initialDensityVal,//Number(BulkDensity).toFixed(3),
                    BulkTestSample: initialDensityVal,//Number(BulkDensity).toFixed(3),
                    TDCount1: "10",
                    TDCount2: "500",
                    TDCount3: "1250",
                    TDCount4: "1250",
                    TDVol1: vol1 == 0 ? 0 : vol1.split(" ")[0].trim(),
                    TDVol2: vol2 == 0 ? 0 : vol2.split(" ")[0].trim(),
                    TDVol3: vol3 == 0 ? 0 : vol3.split(" ")[0].trim(),
                    TDVol4: add1 == 0 ? 0 : add1.split(" ")[0].trim(), //additional tab count 1
                    TDVol5: add2 == 0 ? 0 : add2.split(" ")[0].trim(), //additional tab count 1
                    TDensity: tapDensityVal,
                    // Diff1: diff1 == 0 ? 0 : diff1.split(" ")[0].trim(),
                    // Diff2: diff2 == 0 ? 0 : diff2.split(" ")[0].trim(),
                    // Diff3: diff3 == 0 ? 0 : diff3.split(" ")[0].trim(),
                    // CompressibilityIndex: compressIndexVal == 0 ? 0 : compressIndexVal.split(" ")[0].trim(),
                    HausnerRatio: hausnerRatioVal,
                    PrDate: moment().format('YYYY-MM-DD'),
                    PrTime: moment().format('HH:mm:ss'),
                    PrEndDate: moment().format('YYYY-MM-DD'),
                    PrEndTime: moment().format('HH:mm:ss'),
                    Side: cubicalObj.Sys_RotaryType,
                    UserId: tempUserObject.UserId,
                    UserName: tempUserObject.UserName,
                    BalanceId: CurrentCubicalObj.Sys_BalID,
                    ReportType: cubicalObj.Sys_RptType,
                    CubicleType: 0,
                    Method: method,
                    Layer: layer, //res[0].IsBilayerLbl
                    LayerName: layerName,
                    Stage: cubicalObj.Sys_Stage,
                    Lot: dataObj.objProductDetails.lotno,
                    Area: cubicalObj.Sys_Area,
                    IPQCType: cubicalObj.Sys_IPQCType,
                })


                var tappedResult = saveTDData;
                let lastInsertedId = tappedResult.dataValues.RepSerNo;
                if (cubicalObj.Sys_CubType != "IPQC" && (cubicalObj.Sys_Area == "Granulation" || cubicalObj.Sys_Area == "Granulation IPQC")) {
                    var updateobj = await models.tbl_tapdensity.update({
                        WgmtModeNo: 15,
                        T1PosTD: ProductType.productDetail[0][0].Param7_Upp,
                        T1NegTD: ProductType.productDetail[0][0].Param7_Low,
                        TPosBulk: ProductType.productDetail[0][0].Param10_Upp,
                        TNegBulk: ProductType.productDetail[0][0].Param10_Low

                    }, {
                        where: {
                            RepSerNo: lastInsertedId
                        }
                    })

                }
                else {
                    var updateobj1 = await models.tbl_tapdensity.update({
                        WgmtModeNo: 15,
                        T1PosTD: ProductType.productDetail[0][0].Param15_T1Pos,
                        T1NegTD: ProductType.productDetail[0][0].Param15_T1Neg
                    }, {
                        where: {
                            RepSerNo: lastInsertedId
                        }
                    })
                }
                var obj = await models.tbl_tapdensity.findAll({
                    where: {
                        RepSerNo: lastInsertedId
                    }
                });
                var Tap_result, Bulk_result, final_Remark
                if (Product[0].Param2_Low != 99999 && Product[0].Param2_Upp != 99999) {
                    if (Product[0].Param2_Low <= tapDensityVal && Product[0].Param2_Upp >= tapDensityVal) {
                        Tap_result = "Complies"
                    } else {
                        Tap_result = "Not complies"
                    }
                } else if (Product[0].Param2_Low != 99999) {
                    if (Product[0].Param2_Low <= tapDensityVal) {
                        Tap_result = "Complies"
                    } else {
                        Tap_result = "Not complies"
                    }
                } else if (Product[0].Param2_Upp != 99999) {
                    if (Product[0].Param2_Upp >= tapDensityVal) {
                        Tap_result = "Complies"
                    } else {
                        Tap_result = "Not complies"
                    }
                }
                if (Product[0].Param3_Low != 99999 && Product[0].Param3_Upp != 99999) {

                    if (Product[0].Param3_Low <= initialDensityVal && Product[0].Param3_Upp >= initialDensityVal) {
                        Bulk_result = "Complies"
                    } else {
                        Bulk_result = "Not complies"
                    }
                } else if (Product[0].Param3_Low != 99999) {
                    if (Product[0].Param3_Low <= initialDensityVal) {
                        Bulk_result = "Complies"
                    } else {
                        Bulk_result = "Not complies"
                    }
                } else if (Product[0].Param3_Upp != 99999) {
                    if (Product[0].Param3_Upp >= initialDensityVal) {
                        Bulk_result = "Complies"
                    } else {
                        Bulk_result = "Not complies"
                    }
                }
                if (Tap_result == "Complies" && Bulk_result == "Complies") {
                    final_Remark = "Complies"
                } else {
                    final_Remark = "Not Complies"
                }
                var obj_final = await models.tbl_tapdensity.update({
                    Remark: final_Remark
                }, {
                    where: {
                        RepSerNo: lastInsertedId
                    }
                });
                var objActivity = {};
                Object.assign(objActivity,
                    { strUserId: tempUserObject.UserId },
                    { strUserName: tempUserObject.UserName },
                    { activity: `${menuName} Weighment Completed on TSH ${strHmi}` });
                objActivityLog.ActivityLogEntry(objActivity);
                // Instrument usage for TDT completed
                objInstrumentUsage.InstrumentUsage('TDT', strIdsNo, 'tbl_instrumentlog_tapdensity', '', 'completed');
                Object.assign(responseObj, { status: 'success', repSerNO: lastInsertedId });

                await objMonit.monit({
                    case: 'TestWeight', Hmi: strHmi, data: {
                        Weight: `${tapDensityVal} ${('g/ml').toLowerCase()}`, srNo: "", message: ``
                    }
                });

                mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult} Bulk Density:${initialDensityVal} g/ml,Tap Density:${tapDensityVal} g/ml`);
                mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Test Completed`);
                // For Tap Density We have sent direct request to generate report
                // Online report for Tap Density

                if (final_Remark == "Complies") {
                    var repop = 'Tapped Density';
                    var intProductType = 1;

                    if (menuName == GLOBAL_NOMENCLATURE.TDMenu) {
                        repop = 'Tapped Density';
                    } else if (menuName == GLOBAL_NOMENCLATURE.DTLayer1Menu) {
                        repop = 'Tapped Density Layer 1';
                    } else if (menuName == GLOBAL_NOMENCLATURE.DTLayer2Menu) {
                        repop = 'Tapped Density Layer 2';
                    }

                    var printObj = {
                        RepSerNo: lastInsertedId,
                        Side: 'NA',
                        batchNo: cubicalObj.Sys_Batch,
                        cubicleType: cubicalObj.Sys_CubType,
                        int_ReportFormat: 1,
                        recordFrom: "Current",
                        reportOption: repop,
                        reportType: "Complete",
                        testType: "Regular",
                        userId: tempUserObject.UserId,
                        username: tempUserObject.UserName,
                        printNo: 0,
                        str_url: intProductType === 1 ? "Tablet" : "Capsule"

                    }

                    await printOperations.callViewTabReport(printObj, intProductType, strHmi);
                }

                // if (cubicalObj.Sys_RptType == 0) {
                //     var objOnlineReport = {
                //         // SelectedValue: lastInsertedId,
                //         // UserId: tempUserObject.UserId,
                //         // UserName: tempUserObject.UserName,
                //         // waterMark: true
                //         recordFrom: "Current",
                //         reportOption: "Tapped Density",
                //         reportType: "Complete",
                //         testType: "Regular",
                //         RepSerNo: lastInsertedId,
                //         userId: tempUserObject.UserId,
                //         username: tempUserObject.UserName,
                //         idsNo: IdsNo
                //     }
                //     const objPrinterName = globalData.arrIdsInfo.find(k => k.Sys_IDSNo == IdsNo);

                //     // var objReport = {
                //     //   reportOption : 'Tapped Density',
                //     //   RepSerNo:lastInsertedId
                //     // }
                //     await objPrintReport.generateOnlineReportAsync(objOnlineReport, objPrinterName.Sys_PrinterName);
                //     // await objPrintReport.printReport(objOnlineReport,objReport, objPrinterName.Sys_PrinterName);
                // }
                globalData.arrSelectedMenu.findIndex(
                    (element) => element.Hmi === strHmi
                ) == -1
                    ? globalData.arrSelectedMenu
                    : globalData.arrSelectedMenu.splice(
                        globalData.arrSelectedMenu.findIndex(
                            (element) => element.Hmi === strHmi
                        ),
                        1
                    );
                return responseObj;
            } else {
                console.log('InValid data String');
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid data string received`);
            }
        } catch (err) {
            console.log(err)
            throw new Error(err)
        }
    }
}

module.exports = TappedDensityModel;