const date = require("date-and-time");

const globalData = require("../../global/globalData");
const clsActivityLog = require("../clsActivityLog.model");
const clsInstrumentUsage = require("../clsInstrumentUsageLog");
const clsCommonInsertOpt = require("../Product/clsCommonInsertOperation.model");
const clsMqttSender = require("../Mqtt/mqttSender.class");
const DataBase = require("../../database/clsQueryProcess");
const FormulaFunModel = require("../Product/clsformulaFun.model");
const mqttProtocol = require("../../global/GLOBAL_NOMENCLATURE");
const clsCommonUseFunction = require("../clsCommonUseFunction");
const PowerBackup = require("../../Utills/powerBackUp/powerbackup");
const models = require("../../../config/dbConnection").models;
const sequelize = require("../../../config/dbConnection").sequelize;
const clsCalculation = require('../clsCalculationOperation');
const clsPrintOperations = require("../Print/clsPrintOperation")
const printOperations = new clsPrintOperations()
const objcalc = new clsCalculation();

const objActivityLog = new clsActivityLog();
const objInstrumentUsage = new clsInstrumentUsage();
const objCommonInsertOpt = new clsCommonInsertOpt();
const mqttSender = new clsMqttSender();
const database = new DataBase();
const objformulaFun = new FormulaFunModel();
const objCommonUseFunc = new clsCommonUseFunction();
const objPowerBackup = new PowerBackup();
const clsMonit = require('../MonitorSocket/clsMonitSocket');
const objMonit = new clsMonit();


class LengthModel {
  async processLengthData(dataObj) {
    try {
      let objActivity = {};
      let maxLimitT1,
        maxLimitT2,
        minLimitT2,
        minLimitT1,
        strTableName,
        strDetailTbl;
      const strHmi = dataObj.Hmi;
      const strIdsNo = dataObj.idsNo;
      const menuName = dataObj.menuName;
      let actualWt = dataObj.actualWt;
      let tableName = "tbl_powerbackup";
      let SelectedIdsNo;
      var IPQCObject = globalData.arr_IPQCRelIds.find(
        (k) => k.idsNo == strHmi
      );
      if (IPQCObject != undefined) {
        SelectedIdsNo = IPQCObject.selectedIds.Idsno;
      } else {
        SelectedIdsNo = strHmi;
      }
      let reportLimitMsg = "Report Within Limit";
      const objSelMenu = globalData.arrSelectedMenu.find(
        (k) => k.idsNo == strIdsNo
      );
      const T1Pos = objSelMenu.selectedProductDetail.T1Pos;
      const LengthDetail = globalData.arrWeighmentProductData.find(
        (k) => k.Hmi == strHmi
      );
      let sample = parseFloat(LengthDetail.data.noOfSample);
      let batchNo = LengthDetail.data.Batch;
      let tempCounterObj = globalData.arrWeighmentCounter.find(
        (k) => k.Hmi == strHmi
      );
      let tempUserObject = globalData.arrUsers.find((k) => k.Hmi === strHmi);
      let outFlag = 0;
      const sampleRemark = globalData.arrSampleRemarkForAllTest.find(
        (k) => k.Hmi == strHmi
      );
      let _cubicalData = globalData.arrIdsInfo.find(
        (k) => k.idsNo == strIdsNo
      ).cubicalData;
      if (tempCounterObj === undefined) {
        globalData.arrWeighmentCounter.push({
          Hmi: strHmi,
          counter: 0,
        });
      }
      tempCounterObj = globalData.arrWeighmentCounter.find(
        (k) => k.Hmi == strHmi
      );
      var Side = LengthDetail.data.Side
      switch (menuName) {
        case "Length":
          {
            strTableName = "tbl_tab_master5";
            strDetailTbl = "tbl_tab_detail5";
            // typeValue = 1;
            maxLimitT1 = objformulaFun.upperLimit(
              objSelMenu.selectedProductDetail,
              "T1"
            );
            maxLimitT2 = objformulaFun.upperLimit(
              objSelMenu.selectedProductDetail
            );
            minLimitT2 = objformulaFun.lowerLimit(
              objSelMenu.selectedProductDetail
            );
            minLimitT1 = objformulaFun.lowerLimit(
              objSelMenu.selectedProductDetail,
              "T1"
            );
          }
          break;
        case mqttProtocol.SealLengthMenu:
          {
            strTableName = "tbl_cap_master5";
            strDetailTbl = "tbl_cap_detail5";
            // typeValue = 1;
            maxLimitT1 = objformulaFun.upperLimit(
              objSelMenu.selectedProductDetail,
              "T1"
            );
            maxLimitT2 = objformulaFun.upperLimit(
              objSelMenu.selectedProductDetail
            );
            minLimitT2 = objformulaFun.lowerLimit(
              objSelMenu.selectedProductDetail
            );
            minLimitT1 = objformulaFun.lowerLimit(
              objSelMenu.selectedProductDetail,
              "T1"
            );
          }
          break;
        case "default":
          break;
      }
      let intProductType = objSelMenu.selectedProductDetail.ProductType;
      const __parameterLength = {
        strTableName: strTableName,
        strDetailTbl: strDetailTbl,
        objProductDetails: LengthDetail.data,
        uniqueSerialNumber: strIdsNo,
        strBalId: dataObj.instrumentId,
        ProtocolData: dataObj.actualWt,
        ProtocolUnit: dataObj.unit,
        ProtocolDecPoint: dataObj.decPoint,
        strHmi: strHmi,
        seqNoOfWt: tempCounterObj.counter,
        productType: objSelMenu.selectedProductDetail,
      };
      const __ParamRemark = {
        idsNo: strIdsNo,
        menuName: menuName,
        batchNo: batchNo,
        tableName: strTableName,
      };
      var lastInserted_repsrno;
      if (sample >= tempCounterObj.counter) {
        tempCounterObj.counter += 1;
        __parameterLength.seqNoOfWt = tempCounterObj.counter;
        var powerbackupobj = {
          strTableName: strTableName,
          strDetailTbl: strDetailTbl,
          cubicaNo: _cubicalData.Sys_CubicNo,
          cubicType: _cubicalData.Sys_CubType,
          cubicSysBFGcode: _cubicalData.Sys_BFGCode,
          cubicBatch: _cubicalData.Sys_Batch,
          menuName: menuName, //ThicknessDetail.data.menuName,
          ProductType: objSelMenu.selectedProductDetail.ProductType,
          Userid: tempUserObject.UserId,
          idsNo: strIdsNo,
          Hmi: strHmi,
          Incomp_RepSerNo: tempCounterObj.counter,
          ReportType: _cubicalData.Sys_RptType,
          RecSampleNo: tempCounterObj.counter,
          SelectedIds: SelectedIdsNo
        };

        let _check_combination = await objPowerBackup._check_combination_pow(
          objSelMenu,
          powerbackupobj,
          tableName
        );
        if (_check_combination !== undefined) {
          tempCounterObj.counter = _check_combination.RecSampleNo + 1;
        }

        if (tempCounterObj.counter == 1) {
          var lastInserted_repsrno =
            await objCommonInsertOpt.insert_Into_Incomplete_Master(
              __parameterLength
            );
          powerbackupobj.Incomp_RepSerNo = lastInserted_repsrno.srno;
          await objPowerBackup.getStatusoFTestForPowerBackup(powerbackupobj);
          await objPowerBackup.updateTestCount(objSelMenu, powerbackupobj, tableName);
          Object.assign(
            objActivity,
            { strUserId: tempUserObject.UserId },
            { strUserName: tempUserObject.UserName },
            { activity: "Length Weighment Started on TSH " + strHmi }
          );
          await objActivityLog.ActivityLogEntry(objActivity);
          await objInstrumentUsage.InstrumentUsage(
            "Vernier",
            strIdsNo,
            "tbl_instrumentlog_vernier",
            "Length",
            "started"
          );
          await objCommonInsertOpt.InsertIncompleteRemarkEntry(__ParamRemark);
        }
        //insert data into detail table
        console.log(tempCounterObj.counter);
        __parameterLength.seqNoOfWt = tempCounterObj.counter;
        var decimal = await objCommonInsertOpt.insert_Into_Incomplete_Detail(
          __parameterLength
        );
        // powerbackupobj.lastInserted_repsrno = decimal.repSerNo;
        powerbackupobj.RecSampleNo = tempCounterObj.counter;
        await objPowerBackup.updateTestCount(
          objSelMenu,
          powerbackupobj,
          tableName
        );
        var updateData = await objcalc.calculation_operation(__parameterLength, decimal.repSerNo);
        // mqttSender.sendData(strHmi, `DisplayResult:${tempCounterObj.counter}:${Number(actualWt).toFixed(decimal)} ${dataObj.unit}`)
        let sampleNo = tempCounterObj.counter;
        let limitObjResp = await objCommonUseFunc.SendCommon({
          strHmi,
          actualWt,
          minLimitT2,
          maxLimitT2,
          minLimitT1,
          maxLimitT1,
          menuName,
          sampleNo,
        });
        let color = limitObjResp.Color;
        let limit = limitObjResp.limit;


        await objMonit.monit({
          case: 'TestWeight', Hmi: strHmi, data: {
            Weight: `${actualWt} ${(dataObj.unit).toLowerCase()}`, srNo: "", message: `${limit}`
          }
        });

        mqttSender.sendData(
          strHmi,
          `${mqttProtocol.DisplayResult}${tempCounterObj.counter}:${Number(
            actualWt
          ).toFixed(2)} ${dataObj.unit}:${color}`
        );
        mqttSender.sendData(strHmi, limit);
      }

      if (sample == tempCounterObj.counter) {
        //move data from incomplete to complete
        //remove outOfLimit Flag
        //check nmt range


        var updateData = await objcalc.calculation_operation(__parameterLength, decimal.repSerNo);
        // if (Side == 'RHS') {
        //   var response = await objCommonInsertOpt.saveCompleteData(__parameterLength, 5, Side);
        //   await objCommonInsertOpt.updateEndDate(strIdsNo, strHmi, strTableName);
        // } else {
        //   if (_cubicalData.Sys_RotaryType == "Single") {
        var response = await objCommonInsertOpt.saveCompleteData(__parameterLength, 5);
        // await objCommonInsertOpt.updateEndDate(strIdsNo, strHmi, strTableName);
        // }
        // }
        // if (Side == 'RHS') {
        if (updateData == "Complies") {
          var printObj = {
            RepSerNo: response.RepSerNo,
            Side: Side,
            batchNo: _cubicalData.Sys_Batch,
            cubicleType: _cubicalData.Sys_CubType,
            int_ReportFormat: 1,
            recordFrom: "Current",
            reportOption: menuName,
            reportType: "Complete",
            testType: "Regular",
            userId: tempUserObject.UserId,
            username: tempUserObject.UserName,
            printNo: 0,
            str_url: objSelMenu.selectedProductDetail.ProductType === 1 ? "Tablet" : "Capsule"

          }
          await printOperations.callViewTabReport(printObj, intProductType, strHmi);

        }
        // }
        const _deletePowerbackup = await models.tbl_powerbackup.destroy({
          where: {
            Idsno: strHmi,
            Sys_Batch: _cubicalData.Sys_Batch,
            WeighmentName: menuName
          }
        })
        if (updateData == "Not Complies") {
          reportLimitMsg = "Report Out Of Limit"
        }
        else {
          reportLimitMsg = "Report Within Limit"
        }
        Object.assign(
          objActivity,
          { strUserId: tempUserObject.UserId },
          { strUserName: tempUserObject.UserName },
          { activity: "Length Weighment Completed on TSH " + strHmi }
        );
        await objActivityLog.ActivityLogEntry(objActivity);
        await objInstrumentUsage.InstrumentUsage(
          "Vernier",
          strIdsNo,
          "tbl_instrumentlog_vernier",
          "",
          "completed"
        );
        console.log(tempCounterObj.counter);
        //clear counter array
        globalData.arrWeighmentCounter.findIndex((k) => k.Hmi == strHmi) == -1
          ? globalData.arrWeighmentCounter
          : globalData.arrWeighmentCounter.splice(
            globalData.arrWeighmentCounter.findIndex((k) => k.Hmi == strHmi),
            1
          );

        globalData.arrCurrentOperationStatus.findIndex(
          (element) => element.Hmi === strHmi
        ) == -1
          ? globalData.arrCurrentOperationStatus
          : globalData.arrCurrentOperationStatus.splice(
            globalData.arrCurrentOperationStatus.findIndex(
              (element) => element.Hmi === strHmi
            ),
            1
          );
        //test splice if rotarty is not double
        globalData.arrOutFlagForTest.findIndex(
          (element) => element.Hmi === strHmi
        ) == -1
          ? globalData.arrOutFlagForTest
          : globalData.arrOutFlagForTest.splice(
            globalData.arrOutFlagForTest.findIndex(
              (element) => element.Hmi === strHmi
            ),
            1
          );

        globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi) == -1
          ? globalData.arrSelectedMenu
          : globalData.arrSelectedMenu.splice(
            globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi),
            1
          );


        await objMonit.monit({
          case: 'ReportStatus',
          Hmi: strHmi,
          data: {
            message: reportLimitMsg
          }
        });
        mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}${reportLimitMsg}`);

        return;
      }
    } catch (error) {
      throw new Error(error);
    }
  }
}

module.exports = LengthModel;
