const date = require("date-and-time");
const moment = require("moment");
const globalData = require("../../global/globalData");
const clsActivityLog = require("../clsActivityLog.model");
const clsInstrumentUsage = require("../clsInstrumentUsageLog");
const clsCommonInsertOpt = require("../Product/clsCommonInsertOperation.model");
const clsMqttSender = require("../Mqtt/mqttSender.class");
const DataBase = require("../../database/clsQueryProcess");
const FormulaFunModel = require("../Product/clsformulaFun.model");
const mqttProtocol = require("../../global/GLOBAL_NOMENCLATURE");
const IncompleteReport = require("../Product/clsIncompleteReport");
const clsSaveCompleteHardness = require("../Product/clsWeighmentDataTransfer");
const clsBatchSummary = require("../Product/clsBatchSummaryOperation");
const clsGetMstSrAndSideSr = require("../Product/clsGetMstSrAndSideSr");
const clsProObj = require("../Product/clsProductDetailModel");
const check_srNO_ = require("../Product/cls_consolidate_reportOperation");
const ClsPrintOperations = require("../Print/clsPrintOperation")
const clsMonit = require('../MonitorSocket/clsMonitSocket');

const PrintOperations = new ClsPrintOperations()
const check_srNO = new check_srNO_();
const objGetMstSrAndSideSr = new clsGetMstSrAndSideSr();
const objActivityLog = new clsActivityLog();
const objInstrumentUsage = new clsInstrumentUsage();
const objCommonInsertOpt = new clsCommonInsertOpt();
const mqttSender = new clsMqttSender();
const database = new DataBase();
const objformulaFun = new FormulaFunModel();
const objIncompleteReport = new IncompleteReport();
const objSaveCompleteHardness = new clsSaveCompleteHardness();
const objBatchSummary = new clsBatchSummary();
const proObj = new clsProObj();
const objMonit = new clsMonit();


const { create, all } = require("mathjs");
const config = {};
const mathj = create(all, config);

const PowerBackup = require("../../Utills/powerBackUp/powerbackup");
const objPowerBackup = new PowerBackup();

const models = require("../../../config/dbConnection").models;
const sequelize = require("../../../config/dbConnection").sequelize;

class HardnessModel {
  /***
   * want to check counter sometimes its going proper sometimes wrong when product get completed 425
   */
  async processHardnessData(dataObj) {
    try {
      let objActivity = {};
      let maxLimitT1, maxLimitT2, minLimitT2, minLimitT1;
      const strHmi = dataObj.Hmi;
      const strIdsNo = dataObj.idsNo;
      let data = dataObj.data;
      var dp = 2;
      var hardDp = 0;
      const objSelMenu = globalData.arrSelectedMenu.find(
        (k) => k.idsNo == strIdsNo
      );
      const HardnessDetail = globalData.arrWeighmentProductData.find(
        (k) => k.Hmi == strHmi
      );
      let sample = Number(HardnessDetail.data.noOfSample);
      let batchNo = HardnessDetail.data.Batch;
      let tempUserObject = globalData.arrUsers.find((k) => k.Hmi === strHmi);

      var strTableName = "tbl_tab_masterhtd";
      var strDetailTbl = "tbl_tab_detailhtd";
      let mstTableName = "tbl_tab_masterhtd_incomplete";
      let DetTableName = "tbl_tab_detailhtd_incomplete";
      // var strTableName = "tbl_tab_master7";
      // var strDetailTbl = "tbl_tab_detail7";
      var typeValue = 7;

      let selectedIdsNo;
      var IPQCObject = globalData.arr_IPQCRelIds.find(
        (k) => k.idsNo == strIdsNo
      );
      if (IPQCObject != undefined) {
        selectedIdsNo = IPQCObject.selectedIds;
      } else {
        selectedIdsNo = strIdsNo;
      }

      let hmiDetailsInPMenu = globalData.arrIdsInfo.find(
        (k) => k.idsNo == selectedIdsNo
      ).cubicalData;

      const __parameterHardness = {
        strTableName: strTableName,
        strDetailTbl: strDetailTbl,
        mstTableName: mstTableName,
        DetTableName: DetTableName,
        objProductDetails: HardnessDetail.data,
        uniqueSerialNumber: strIdsNo,
        ProtocolData: dataObj.data,
        strHmi: strHmi,
        productType: objSelMenu.selectedProductDetail,
      };

      var powerBackup = await models.tbl_powerbackup.findAll({
        where: {
          Sys_CubType: hmiDetailsInPMenu.Sys_CubType,
          Sys_BFGCode: HardnessDetail.data.ProductId,
          Sys_Batch: hmiDetailsInPMenu.Sys_Batch,
          Idsno: strHmi,
          WeighmentName: mqttProtocol.Hardness,
        },
      });

      var counter;

      if (powerBackup.length == 0) {
        counter = 1;
      } else {
        counter = powerBackup[0].RecSampleNo + 1;
      }

      // if (Number(sample) < counter + objHardness.length) return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}: samples received more than expected`);

      var repSerNo;
      if (sample >= counter) {
        if (counter == 1) {
          __parameterHardness.strHardnessUnit = "N";

          repSerNo = await this.saveDataIncompleteMasterHardness125(
            __parameterHardness, counter
          );

          Object.assign(
            objActivity,
            { strUserId: tempUserObject.UserId },
            { strUserName: tempUserObject.UserName },
            { activity: "Hardness Weighment Started on TSH " + strHmi }
          );

          await objActivityLog.ActivityLogEntry(objActivity);

          await objInstrumentUsage.InstrumentUsage(
            "Hardness",
            strIdsNo,
            "tbl_instrumentlog_hardness",
            "Hardness",
            "started"
          );

          powerBackup = await models.tbl_powerbackup.findAll({
            where: {
              Sys_CubType: hmiDetailsInPMenu.Sys_CubType,
              Sys_BFGCode: HardnessDetail.data.ProductId,
              Sys_Batch: hmiDetailsInPMenu.Sys_Batch,
              Idsno: strHmi,
              WeighmentName: mqttProtocol.Hardness,
            },
          });
        } else {
          repSerNo = powerBackup[0].Incomp_RepSerNo;
        }

        for (let ele of data) {

          let pattern = (/^(--|NA|FL)$/i);

          var hardnessUnit = objSelMenu.selectedProductDetail.unit;

          // let tempDiamVal = (Number(ele.tempDiamVal) === 0) ? "NA" : mathj.round(ele.tempDiamVal, dp).toFixed(dp)
          // if (pattern.test(ele.tempDiamVal) || ele.tempDiamVal > 999) {
          //   globalData.HardnesDataFlag.diamflag = true
          // }

          // if (pattern.test(ele.tempThickVal) || ele.tempDiamVal > 999) {
          //   globalData.HardnesDataFlag.thickflag = true
          // }

          // if (pattern.test(ele.tempHardVal) || ele.tempDiamVal > 999) {
          //   globalData.HardnesDataFlag.hardflag = true
          // }


          let tempDiamVal = (Number(ele.tempDiamVal) === 0 || pattern.test(ele.tempDiamVal)) ? "NA" : !pattern.test(ele.tempDiamVal) ? ele.tempDiamVal
            : mathj.round(ele.tempDiamVal, dp).toFixed(dp);

          await models[DetTableName].create({
            RepSerNo: repSerNo,
            MstSerNo: 1,
            RecSeqNo: counter,
            DataValueThick: pattern.test(ele.tempThickVal) || !objSelMenu.selectedProductDetail.columnDetail.some(obj => obj.hasOwnProperty('Thickness')) ? "NA" : mathj.round(Number(ele.tempThickVal), dp).toFixed(dp),
            DataValueHard: pattern.test(ele.tempHardVal) || !objSelMenu.selectedProductDetail.columnDetail.some(obj => obj.hasOwnProperty('Hardness')) ? "NA" : Number(ele.tempHardVal).toFixed(hardDp),
            // DataValueBL: powerBackup[0].TableType === "Length" ? tempDiamVal : "NA",
            // DataValueDiam: powerBackup[0].TableType === "Diameter" ? tempDiamVal : "NA",
            DataValueBL: powerBackup[0].TableType === "Length" ? tempDiamVal : powerBackup[0].TableType === "Diameter" ? tempDiamVal : "NA",

            // DecimalPointThick: this.precision(Number(ele.tempThickVal)),
            // DecimalPointDOLOBO: this.precision(Number(ele.tempDiamVal)),
            // DP: this.precision(Number(ele.tempHardVal)),
            idsNo: strHmi,
          });
          let updateres = await this.updatemasterTable(repSerNo, powerBackup, mstTableName, DetTableName, strIdsNo);
          console.log(updateres);
          let val = await models.tbl_powerbackup.update(
            {
              RecSampleNo: counter,
            },
            {
              where: {
                Idsno: strHmi,
                WeighmentName: mqttProtocol.Hardness,
              },
            }
          );

          // Check and process tempThickVal
          let thickVal = ele.tempThickVal;
          if (["NA", "FL", "--", "fl", "na"].includes(thickVal) || thickVal > 999) {
            thickVal = thickVal;  // No rounding/formatting for thickVal
          } else {
            thickVal = mathj.round(thickVal, dp).toFixed(dp);  // Apply rounding/formatting
          }

          // Check and process tempDiamVal
          let diamVal = ele.tempDiamVal;
          if (["NA", "FL", "--"].includes(diamVal) || diamVal > 999) {
            diamVal = diamVal;  // No rounding/formatting for diamVal
          } else {
            diamVal = mathj.round(diamVal, dp).toFixed(dp);
          }

          // Check and process tempHardVal
          let hardVal = ele.tempHardVal;
          if (["NA", "FL", "--"].includes(hardVal) || hardVal > 999) {
            hardVal = hardVal;  // No rounding/formatting for hardVal
          } else {
            hardVal = Number(hardVal).toFixed(hardDp);  // 
          }


          // mqttSender.sendData(
          //   strHmi,
          //   `${mqttProtocol.DisplayResult}${counter}:${mathj.round(ele.tempThickVal, dp).toFixed(dp)} mm:${mathj.round(ele.tempDiamVal, dp).toFixed(dp)} mm:${Number(ele.tempHardVal, hardDp).toFixed(hardDp)} ${hardnessUnit}`
          // );

          await objMonit.monit({
            case: 'TestWeight', Hmi: strHmi, data: {
              Weight: `${hardVal} ${(hardnessUnit).toLowerCase()}`, srNo: "", message: ``
            }
          });
          mqttSender.sendData(
            strHmi,
            `${mqttProtocol.DisplayResult}${counter}:${thickVal} mm:${diamVal} mm:${hardVal} ${hardnessUnit}`
          );

          counter++;

          // let sideStatus;
          // if (__parameterHardness.objProductDetails.Side === "LHS") sideStatus = 0
          // else if (__parameterHardness.objProductDetails.Side === "RHS") sideStatus = 1

          // let result = await objIncompleteReport.getIncomepleteData(
          //   __parameterHardness,
          //   strTableName,
          //   strDetailTbl,
          //   strIdsNo,
          //   __parameterHardness.objProductDetails.Side,
          //   sideStatus
          // );

          //   let detailData = result.detailData

          //   const invalidDataValues = await this.checkForInvalidFields(detailData);
          //   console.log(invalidDataValues);

          //   let updateObject = result.incompleteData

          // if (invalidDataValues.length > 0) {
          //   updateObject = await this.updateInvalidFields(invalidDataValues, updateObject);
          // }


          if (sample + 1 <= counter) break;
        }

        if (sample + 1 <= counter) {
          let updateres = await this.updatemasterTable(repSerNo, powerBackup, mstTableName, DetTableName, strIdsNo);


          let sideStatus;
          if (__parameterHardness.objProductDetails.Side === "LHS") sideStatus = 0
          else if (__parameterHardness.objProductDetails.Side === "RHS") sideStatus = 1

          let result = await objIncompleteReport.getIncomepleteData(
            __parameterHardness,
            strTableName,
            strDetailTbl,
            strIdsNo,
            __parameterHardness.objProductDetails.Side,
            sideStatus
          );

          //  let detailData = result.detailData

          // const invalidDataValues = await this.checkForInvalidFields(detailData);
          // console.log(invalidDataValues);

          // let updateObject = result.incompleteData

          // if (invalidDataValues.length > 0) {
          // updateObject = await this.updateInvalidFields(invalidDataValues, updateObject);
          // }


          // Sample array


          // List of invalid values to check
          // const invalidValues = ['NA', 'FL', '--'];

          // // Function to check if a value is invalid
          // const isInvalid = (value) => {
          //   return invalidValues.includes(value) || parseFloat(value) > 999;
          // };

          // // Function to check each individual field for invalid values
          // const checkInvalidFields = (dataArray) => {
          //   return dataArray.map(item => {
          //     const invalidFields = [];

          //     // Check if DataValueHard is invalid
          //     if (isInvalid(item.DataValueHard)) {
          //       invalidFields.push('DataValueHard');
          //     }

          //     // Check if DataValueThick is invalid
          //     if (isInvalid(item.DataValueThick)) {
          //       invalidFields.push('DataValueThick');
          //     }

          //     // Check if DataValueDiam is invalid
          //     if (isInvalid(item.DataValueDiam)) {
          //       invalidFields.push('DataValueDiam');
          //     }

          //     // Return the item with the invalid fields
          //     if (invalidFields.length > 0) {
          //       return { ...item, invalidFields };
          //     } else {
          //       return null;
          //     }
          //   }).filter(item => item !== null); // Filter out nulls where no invalid fields were found
          // };

          // // Get all objects with invalid fields
          // const invalidDataValues = checkInvalidFields(data);

          // // Output the invalid data values
          // console.log(invalidDataValues);




          // let hardValues = detailData.map(e => e.DataValueHard);
          // let DiamValues = detailData.map(e => e.DataValueHard);
          // let ThicknessValue = detailData.map(e => e.DataValueHard);

          // const invalidSet = new Set(['NA', 'FL', '--']);

          // const hasInvalidOrLarge = values.some(val =>
          //   invalidSet.has(val) || Number(val) > 999
          // );

          // console.log(hasInvalidOrLarge);


          let values = await objSaveCompleteHardness.saveCommonDataToCompleteHardness(
            result,
            typeValue,
            strIdsNo
          );

          // let commomnValue = await objCommonInsertOpt.updateEndDate(
          //   strIdsNo,
          //   strHmi,
          //   strTableName
          // );


          var ThirdParameter = result.incompleteData.BLName == 'Length' ? result.incompleteData.RemarkBL : result.incompleteData.RemarkBL;

          if (result.incompleteData.RemarkHard == 'Not Complies' || result.incompleteData.RemarkThick == 'Not Complies' || ThirdParameter == 'Not Complies') {
            var Remark = 'Not Complies';
          } else if (result.incompleteData.RemarkHard == 'NA' && result.incompleteData.RemarkThick == 'NA' && ThirdParameter == 'NA') {
            Remark = 'NA';
          }
          else {
            Remark = 'Complies';
          }

          const updateRemark = models.tbl_tab_masterhtd.update(
            {
              Remark: Remark,
            },
            {
              where: {
                RepSerNo: values.repSerNo,
              },
            })

          let compltData = result.incompleteData

          if ((compltData.MinPerHard !== "NA" && compltData.MinPerThick !== "NA" && compltData.MinPerBL !== "NA") ||
            (compltData.MinPerHard !== "NA" && compltData.MinPerThick !== "NA") || (compltData.MinPerThick !== "NA" && compltData.MinPerBL !== "NA") ||
            (compltData.MinPerHard !== "NA" && compltData.MinPerBL !== "NA") || (compltData.MinPerHard !== "NA") ||
            (compltData.MinPerThick !== "NA") || (compltData.MinPerBL !== "NA")) {

            let batchValue = await objBatchSummary.saveBatchDataHardness(
              result.incompleteData,
              result.detailData,
              strIdsNo, Remark
            );
          }

          await models.tbl_powerbackup.destroy({
            where: {
              Idsno: strHmi,
              WeighmentName: mqttProtocol.Hardness,
            },
          });

          Object.assign(
            objActivity,
            { strUserId: tempUserObject.UserId },
            { strUserName: tempUserObject.UserName },
            { activity: "Hardness Weighment Completed on TSH " + strHmi }
          );

          await objActivityLog.ActivityLogEntry(objActivity);

          await objInstrumentUsage.InstrumentUsage(
            "Hardness",
            strIdsNo,
            "tbl_instrumentlog_hardness",
            "Hardness",
            "completed"
          );

          await models.tbl_cubical.update({
            Sys_Validation: 0
          }, {
            where: {
              Sys_IDSNo: strHmi
            }
          })

          // var ThirdParameter = completeMastData.ColHeadDOLOBO == 'Length' ? completeMastData.RemarkLB : completeMastData.RemarkDiam ;



          var intProductType = 1
          if (result.incompleteData.Remark == 'Complies') {
            var printObj = {
              recordFrom: "Current",
              reportOption: "Hardness",
              reportType: "Complete",
              testType: "Regular",
              RepSerNo: values.repSerNo,
              userId: tempUserObject.UserId,
              username: tempUserObject.UserName,
              printNo: 0,
              str_url: intProductType === 1 ? "Tablet" : "Capsule",
              Side: "NA",
              batchNo: hmiDetailsInPMenu.Sys_Batch,
              cubicleType: hmiDetailsInPMenu.Sys_CubType,
              int_ReportFormat: 1,
              printNo: 0
            }


            await PrintOperations.callViewTabReport(printObj, intProductType, strHmi)
          }

          globalData.arrCurrentOperationStatus.findIndex(
            (element) => element.Hmi === strHmi
          ) == -1
            ? globalData.arrCurrentOperationStatus
            : globalData.arrCurrentOperationStatus.splice(
              globalData.arrCurrentOperationStatus.findIndex(
                (element) => element.Hmi === strHmi
              ),
              1
            );

          globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi) == -1
            ? globalData.arrSelectedMenu
            : globalData.arrSelectedMenu.splice(
              globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi),
              1
            );

          // return mqttSender.sendData(
          //   strHmi,
          //   `${mqttProtocol.TestCompleted} Test Completed`
          // );

          let reportLimitMsg = "Report Within Limit";
          if (Remark == "Complies" || Remark == "Not Complies") {

            if (Remark != "Complies") {
              reportLimitMsg = "Report Out Of Limit";
            }
            await objMonit.monit({
              case: 'ReportStatus',
              Hmi: strHmi,
              data: {
                message: reportLimitMsg
              }
            });
            return mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}${reportLimitMsg}`);
          }
          else {
            return mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted} Test Completed`
            );
          }

        }
      }
    } catch (error) {
      console.log(error)
      throw new Error(error);
    }
  }


  async processHardnessData125(dataObj125) {
    try {
      let objActivity = {};
      // let maxLimitT1, maxLimitT2, minLimitT2, minLimitT1;
      const strHmi = dataObj125.Hmi;
      const strIdsNo = dataObj125.idsNo;
      // const menuName = dataObj125.menuName;
      let objHardness = dataObj125.objHardness;
      // let actualWt = dataObj125.actualWt;
      const objSelMenu = globalData.arrSelectedMenu.find(
        (k) => k.idsNo == strIdsNo
      );
      const HardnessDetail = globalData.arrWeighmentProductData.find(
        (k) => k.Hmi == strHmi
      );
      let sample = Number(HardnessDetail.data.noOfSample);
      // let batchNo = HardnessDetail.data.Batch;
      let tempUserObject = globalData.arrUsers.find((k) => k.Hmi === strHmi);
      // const sampleRemark = globalData.arrSampleRemarkForAllTest.find(k => k.Hmi == strHmi);
      // let outFlag = 0;
      // const T1Pos = objSelMenu.selectedProductDetail.T1Pos;
      let hmiDetailsInPMenu = globalData.arrIdsInfo.find(
        (k) => k.Hmi == strHmi
      ).cubicalData;

      var strTableName = "tbl_tab_masterhtd";
      var strDetailTbl = "tbl_tab_detailhtd";
      var typeValue = 7;

      const __parameterHardness125 = {
        strTableName: strTableName,
        strDetailTbl: strDetailTbl,
        objProductDetails: HardnessDetail.data,
        uniqueSerialNumber: strIdsNo,
        strBalId: dataObj125.instrumentId,
        ProtocolData: dataObj125.objHardness,
        strHmi: strHmi,
        productType: objSelMenu.selectedProductDetail,
      };

      const powerBackup = await models.tbl_powerbackup.findAll({
        where: {
          Sys_CubType: hmiDetailsInPMenu.Sys_CubType,
          Sys_BFGCode: HardnessDetail.data.ProductId,
          Sys_Batch: hmiDetailsInPMenu.Sys_Batch,
          Idsno: strHmi,
          WeighmentName: mqttProtocol.Hardness,
        },
      });

      var counter;

      if (powerBackup.length == 0) {
        counter = 1;
      } else {
        counter = powerBackup[0].RecSampleNo + 1;
      }

      // if (Number(sample) < counter + objHardness.length) return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}: samples received more than expected`);

      let repSerNo;

      if (sample >= counter) {
        if (counter == 1) {
          __parameterHardness125.strHardnessUnit = "N";

          let objActivity = {};

          Object.assign(
            objActivity,
            { strUserId: tempUserObject.UserId },
            { strUserName: tempUserObject.UserName },
            { activity: "Hardness Weighment Started on TSH " + strHmi }
          );

          await objActivityLog.ActivityLogEntry(objActivity);

          repSerNo = await this.saveDataIncompleteMasterHardness125(
            __parameterHardness125, counter
          );
        } else {
          repSerNo = powerBackup[0].Incomp_RepSerNo;
        }

        for (let i in objHardness) {
          await models.tbl_tab_detailhtd_incomplete.create({
            RepSerNo: repSerNo,
            MstSerNo: 1,
            RecSeqNo: counter,
            DataValueThick: objHardness[i].tempThickVal,
            DataValueHard: mathj.round(objHardness[i].tempHardVal, 1).toFixed(1),
            DataValueDiam: objHardness[i].tempHardVal,
            DataValueBL: objHardness[i].tempDimenVal,
            DecimalPointThick: this.precision(objHardness[i].tempThickVal),
            DecimalPointDOLOBO: this.precision(objHardness[i].tempDimenVal),
            DecimalPointHard: this.precision(objHardness[i].tempHardVal),
            idsNo: strHmi,
          });

          await models.tbl_powerbackup.update(
            {
              RecSampleNo: counter,
            },
            {
              where: {
                Idsno: strHmi,
                WeighmentName: mqttProtocol.Hardness,
              },
            }
          );

          mqttSender.sendData(
            strHmi,
            `${mqttProtocol.DisplayResult}:${counter}:${objHardness[i].tempThickVal} mm:${objHardness[i].tempDimenVal} mm:${objHardness[i].tempHardVal} N`
          );

          counter++;

          if (sample + 1 <= counter) break;
        }

        if (sample + 1 <= counter) {
          let result = await objIncompleteReport.getIncomepleteData(
            __parameterHardness125,
            strTableName,
            strDetailTbl,
            strIdsNo,
            repSerNo
          );

          await objSaveCompleteHardness.saveCommonDataToCompleteHardness(
            result,
            typeValue,
            strIdsNo
          );

          // await objCommonInsertOpt.updateEndDate(
          //   strIdsNo,
          //   strHmi,
          //   strTableName
          // );

          //   await objBatchSummary.saveBatchDataHardness(
          //     result.incompleteData,
          //     result.detailData,
          //     strIdsNo
          //   );

          await models.tbl_powerbackup.destroy({
            where: {
              Idsno: strHmi,
              WeighmentName: mqttProtocol.Hardness,
            },
          });

          await objInstrumentUsage.InstrumentUsage(
            "Hardness",
            strIdsNo,
            "tbl_instrumentlog_hardness",
            "Hardness",
            "completed"
          );

          Object.assign(
            objActivity,
            { strUserId: tempUserObject.UserId },
            { strUserName: tempUserObject.UserName },
            { activity: "Hardness Weighment Completed on TSH " + strHmi }
          );

          await objActivityLog.ActivityLogEntry(objActivity);

          globalData.arrCurrentOperationStatus.findIndex(
            (element) => element.Hmi === strHmi
          ) == -1
            ? globalData.arrCurrentOperationStatus
            : globalData.arrCurrentOperationStatus.splice(
              globalData.arrCurrentOperationStatus.findIndex(
                (element) => element.Hmi === strHmi
              ),
              1
            );
          //test splice if rotarty is not double

          globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi) == -1
            ? globalData.arrSelectedMenu
            : globalData.arrSelectedMenu.splice(
              globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi),
              1
            );

          return mqttSender.sendData(
            strHmi,
            `${mqttProtocol.TestCompleted}Hardness test Completed`
          );
        }
      }
    } catch (error) {
      throw new Error(error);
    }
  }

  /**
   * stable for All parameter
   * @param {*} dataObjMt50
   */
  async processHardnessDataMT50(dataObjMt50) {
    try {
      let recivedWt = dataObjMt50.actualWt;
      let strIdsNo = dataObjMt50.idsNo;
      let strHmi = dataObjMt50.Hmi;
      let strMenuName = dataObjMt50.instrumentType;

      let selectedIdsNo;
      var IPQCObject = globalData.arr_IPQCRelIds.find(
        (k) => k.idsNo == strIdsNo
      );
      if (IPQCObject != undefined) {
        selectedIdsNo = IPQCObject.selectedIds;
      } else {
        selectedIdsNo = strIdsNo;
      }
      let productObj = globalData.arrIdsInfo.find(
        (k) => k.idsNo == selectedIdsNo
      ).cubicalData;
      let productDetail = globalData.arrProductTypeArray.find(
        (k) => k.idsNo == selectedIdsNo
      ).productDetail;
      let paramSetOrNot = globalData.arr_limits.find(
        (k) => k.idsNo == selectedIdsNo
      ).Menus;
      paramSetOrNot =
        paramSetOrNot[mqttProtocol.TabletTester][mqttProtocol.TabletTester][
        columnDetail
        ];
      let thickness = paramSetOrNot.filter(
        (obj) => Object.keys(obj) == "Thickness"
      );
      let breadth = paramSetOrNot.filter(
        (obj) => Object.keys(obj) == "Breadth"
      );
      let diameter = paramSetOrNot.filter(
        (obj) => Object.keys(obj) == "Diameter"
      );

      // let hardness = paramSetOrNot.filter(obj => Object.keys(obj) == 'Hardness');
      let hardness = paramSetOrNot.filter(
        (obj) => Object.keys(obj) == mqttProtocol.TabletTester
      );
      let objHardness = globalData.arrHardnessMT50.find(
        (ht) => ht.idsNo == strIdsNo
      );
      let tempCounterObj = globalData.arrWeighmentCounter.find(
        (k) => k.Hmi == strHmi
      );
      let thicknessVal = 0,
        widthVal = 0,
        diameterVal = 0,
        hardnessVal = 0;
      let tempUserObject = globalData.arrUsers.find((k) => k.Hmi == strHmi);
      const HardnessDetail = globalData.arrWeighmentProductData.find(
        (k) => k.Hmi == strHmi
      );
      let sample = HardnessDetail.data.noOfSample;
      let strSampleNoFromString = "";

      let mstTableName = "tbl_tab_masterhtd_incomplete";
      let DetTableName = "tbl_tab_detailhtd_incomplete";
      let mstSerNo;
      let sideNo;
      let repSerNo;
      const objSelMenu = globalData.arrSelectedMenu.find(
        (k) => k.idsNo == strIdsNo
      );
      let objActivity = {};

      const obj = {
        idsNo: strIdsNo,
        dimensionParam: 0,
        sampleNo: 0,
        colName: "",
        thicknessVal: [],
        thicknessDecimal: 0,
        thicknessNom: 0,
        thicknesneg: 0,
        thicknespos: 0,
        WidthVal: [],
        WidthDecimal: 0,
        WidthNom: 0,
        Widthneg: 0,
        Widthpos: 0,
        DiameterVal: [],
        DiameterDecimal: 0,
        DiametereNom: 0,
        Diameterneg: 0,
        Diameterpos: 0,
        HardnessVal: [],
        HardnessDecimal: 0,
        HardnessNom: 0,
        Hardnessrneg: 0,
        Hardnesspos: 0,
        sampleFromString: "",
      };
      globalData.arrHardnessMT50.push(obj);

      if (tempCounterObj === undefined) {
        globalData.arrWeighmentCounter.push({
          Hmi: strHmi,
          counter: 0,
        });
      }

      tempCounterObj = globalData.arrWeighmentCounter.find(
        (k) => k.Hmi == strHmi
      );

      const __parameterHardnessMt50 = {
        strTableName: mstTableName,
        strDetailTbl: DetTableName,
        objProductDetails: HardnessDetail.data,
        uniqueSerialNumber: strIdsNo,
        strBalId: dataObjMt50.instrumentId,
        ProtocolData: dataObjMt50.actualWt,
        strHmi: strHmi,
        productType: objSelMenu.selectedProductDetail,
      };

      /**
       * remove sample from string
       */
      objHardness = globalData.arrHardnessMT50.find(
        (ht) => ht.idsNo == strIdsNo
      );
      strSampleNoFromString = recivedWt.substring(1, recivedWt.indexOf(" ")); //to get sample number from string
      if (isNaN(strSampleNoFromString) == true) {
        console.log("sample Not found");
        return mqttSender.sendData(
          strHmi,
          `${mqttProtocol.DisplayMessage}Invalid String`
        );
      } else {
        objHardness.sampleFromString = strSampleNoFromString; // saving sample no from hardness
      }

      //thickness
      if (recivedWt.includes("T") && thickness.length != 0) {
        thicknessVal = recivedWt
          .substring(recivedWt.indexOf("T") + 1, recivedWt.indexOf("mm"))
          .trim();
        if (isNaN(thicknessVal) == false) {
          objHardness.thicknessVal = thicknessVal;
          objHardness.thicknessDecimal = this.precision(Number(thicknessVal));
          objHardness.sampleNo = strSampleNoFromString;
        } else {
          objHardness.thicknessVal = 0;
          objHardness.thicknessDecimal = 0;
        }
      } else {
        objHardness.thicknessVal = 0;
        objHardness.thicknessDecimal = 0;
        objHardness.sampleNo = strSampleNoFromString;
      }

      //for width
      if (recivedWt.includes("Wd")) {
        let tempstring = recivedWt.substring(recivedWt.indexOf("Wd"));
        widthVal = tempstring
          .substring(tempstring.indexOf("Wd") + 2, tempstring.indexOf("mm"))
          .trim();
        if (isNaN(widthVal) == false) {
          objHardness.WidthVal = widthVal;
          objHardness.WidthDecimal = this.precision(Number(widthVal));
          objHardness.sampleNo = strSampleNoFromString;
        } else {
          objHardness.WidthVal = 0;
          objHardness.WidthDecimal = 0;
        }
      } else {
        objHardness.WidthVal = 0;
        objHardness.WidthDecimal = 0;
        objHardness.sampleNo = strSampleNoFromString;
      }

      // for Diameter *************************************************************************
      if (recivedWt.includes("D") && diameter.length != 0) {
        let tempstring = recivedWt.substring(recivedWt.indexOf("D") + 1);
        diameterVal = tempstring.substring(0, tempstring.indexOf("mm")).trim();
        if (isNaN(diameterVal) == false) {
          objHardness.DiameterVal = diameterVal;
          objHardness.DiameterDecimal = this.precision(Number(diameterVal));
          objHardness.sampleNo = strSampleNoFromString;
        } else {
          objHardness.DiameterVal = 0;
          objHardness.DiameterDecimal = 0;
        }
      } else {
        objHardness.DiameterVal = 0;
        objHardness.DiameterDecimal = 0;
        objHardness.sampleNo = strSampleNoFromString;
      }
      /*********************************************************************************** */

      // for Hardness *************************************************************************
      if (recivedWt.includes("H") && hardness.length != undefined) {
        if (recivedWt.includes("N")) {
          hardnessVal = recivedWt
            .substring(recivedWt.indexOf("H") + 1, recivedWt.indexOf("N"))
            .trim();
        } else {
          hardnessVal = recivedWt
            .substring(recivedWt.indexOf("H") + 1, recivedWt.indexOf("Kp"))
            .trim();
        }

        if (isNaN(hardnessVal) == false) {
          // if the received value is valid value
          objHardness.HardnessVal = hardnessVal;
          objHardness.HardnessDecimal = this.precision(Number(hardnessVal));
          objHardness.sampleNo = strSampleNoFromString;
        } else {
          objHardness.HardnessVal = 0;
          objHardness.HardnessDecimal = 0;
        }
      } else {
        objHardness.HardnessVal = 0;
        objHardness.HardnessDecimal = 0;
        objHardness.sampleNo = strSampleNoFromString;
      }
      /*********************************************************************************** */

      //this will check if sample is came directly as 2 OR  sample came directly as eual to QTY  (doubt)

      var side = "NA";
      if (productObj.Sys_RotaryType == "Single") {
        side = "NA";
      } else {
        side = HardnessDetail.data.Side == "L" ? "LHS" : "RHS"; //matching side with HardnessDetail which is feel on menu.
      }

      if (Number(sample) >= tempCounterObj.counter) {
        tempCounterObj.counter += 1;
        if (tempCounterObj.counter == 1 && objHardness.sampleFromString == 1) {
          Object.assign(
            objActivity,
            { strUserId: tempUserObject.UserId },
            { strUserName: tempUserObject.UserName },
            { activity: "Hardness Weighment Started on IDS " + strIdsNo }
          );
          await objActivityLog.ActivityLogEntry(objActivity);

          if (productObj.Sys_RptType == 1) {
            //for Initial
            mstSerNo = 1;
            sideNo = 1;
          } else {
            //regular
            let objMt50 = {
              tableName: mstTableName,
              ReportType: 0,
              Side: side,
              BFGCode: productObj.Sys_BFGCode,
              ProductName: productObj.Sys_ProductName,
              PVersion: productObj.Sys_PVersion,
              Version: productObj.Sys_Version,
              BatchNo: productObj.Sys_Batch,
              IdsNo: strIdsNo,
            };

            //doubts
            if (side == "NA") {
              mstSerNo = await objGetMstSrAndSideSr.getRegularLRMstSerialNo(
                objMt50
              );
              sideNo = await objGetMstSrAndSideSr.getRegularLRSideNo(objMt50);
              if (sideNo < 10) {
                sideNo = sideNo + 1;
              } else {
                sideNo = 1;
                mstSerNo = mstSerNo + 1;
              }
            } else {
              mstSerNo = await objGetMstSrAndSideSr.getRegularLRMstSerialNo(
                objMt50
              );
              sideNo = await objGetMstSrAndSideSr.getRegularLRSideNo(objMt50);
              if (sideNo < 5) {
                sideNo = sideNo + 1;
              } else {
                sideNo = 1;
                mstSerNo = mstSerNo + 1;
              }
            }
          }
          //
          let now = new Date();
          let tableName = "tbl_tab_masterhtd_incomplete";
          let insertIncompleteObj = await models[tableName].create({
            MstSerNo: mstSerNo,
            SideNo: sideNo,
            InstruId: 1,
            BFGCode: productObj.Sys_BFGCode,
            ProductName: productObj.Sys_ProductName,
            ProductType: 1,
            Idsno: strIdsNo,
            CubicalNo: productObj.Sys_CubicNo,
            BalanceId: productObj.Sys_BalID,
            VernierId: productObj.Sys_VernierID,
            BatchNo: productObj.Sys_Batch,
            UserId: tempUserObject.UserId,
            UserName: tempUserObject.UserName,
            PrDate: date.format(now, "YYYY-MM-DD"),
            PrTime: date.format(now, "HH:mm:ss"),
            Side: side,
            Qty: HardnessDetail.data.noOfSample,
            Unit: "N",
            DecimalPoint: objHardness.HardnessDecimal,
            CubicleType: productObj.Sys_CubType,
            ReportType: productObj.Sys_RptType,
            MachineCode: productObj.Sys_MachineCode,
            MFGCode: productObj.Sys_MfgCode,
            BatchSize: `${productObj.Sys_BatchSize} ${productObj.Sys_BatchSizeUnit}`,
            HardnessID: productObj.Sys_HardID,
            CubicleName: productObj.Sys_dept,
            CubicleLocation: productObj.Sys_dept,
            IsArchived: 0,
            PVersion: productObj.Sys_PVersion,
            Version: productObj.Sys_Version,
            ColHeadDOLOBO: "Breadth",

            NomThick:
              thickness.length == 0 ? 0 : thickness[0].Thickness.nominal,
            PosTolThick:
              thickness.length == 0 ? 0 : thickness[0].Thickness.T1Neg,
            NegTolThick:
              thickness.length == 0 ? 0 : thickness[0].Thickness.T1Pos,

            // NomHard: hardness.length == 0 ? 0 : hardness[0].Hardness.nominal,
            // PosTolHard: hardness.length == 0 ? 0 : hardness[0].Hardness.T1Pos,
            // NegTolHard: hardness.length == 0 ? 0 : hardness[0].Hardness.T1Neg,

            NomHard: hardness.length == 0 ? 0 : hardness[0].TBTTST.nominal,
            PosTolHard: hardness.length == 0 ? 0 : hardness[0].TBTTST.T1Pos,
            NegTolHard: hardness.length == 0 ? 0 : hardness[0].TBTTST.T1Neg,

            NomDOLOBO: breadth.length == 0 ? 0 : breadth[0].Breadth.nominal,
            PosTolDOLOBO: breadth.length == 0 ? 0 : breadth[0].Breadth.T1Pos,
            NegTolDOLOBO: breadth.length == 0 ? 0 : breadth[0].Breadth.T1Neg,

            NomDiam: diameter.length == 0 ? 0 : diameter[0].Diameter.nominal,
            PosTolDiam: diameter.length == 0 ? 0 : diameter[0].Diameter.T1Pos,
            NegTolDiam: diameter.length == 0 ? 0 : diameter[0].Diameter.T1Neg,

            // GraphType: productlimits.Hardness.isonstd[0] == undefined ? 0 : productlimits.Hardness.isonstd[0] },
            GraphType: 0,
            RepoLabel11: productObj.Sys_Validation,
            Lot: "NA",
            Area: productObj.Sys_Area,
            Stage: productObj.Sys_Stage,
            AppearanceDesc: productObj.Sys_Appearance,
            MachineSpeed_Min: productObj.Sys_MachineSpeed_Min,
            MachineSpeed_Max: productObj.Sys_MachineSpeed_Max,
            GenericName: productObj.Sys_GenericName,
            BMRNo: productObj.Sys_BMRNo,
          });
          var lastInsertedID = insertIncompleteObj._previousDataValues.RepSerNo;
          console.log(insertIncompleteObj);

          // var insertIncompleteObj1 = {
          //     str_tableName: 'tbl_tab_masterhtd_incomplete',
          //     data: [
          //         { str_colName: 'MstSerNo', value: mstSerNo },
          //         { str_colName: 'SideNo', value: sideNo },
          //         { str_colName: 'InstruId', value: 1 },
          //         { str_colName: 'BFGCode', value: productObj.Sys_BFGCode },
          //         { str_colName: 'ProductName', value: productObj.Sys_ProductName },
          //         { str_colName: 'ProductType', value: 1 },
          //         { str_colName: 'Idsno', value: strIdsNo },
          //         { str_colName: 'CubicalNo', value: productObj.Sys_CubicNo },
          //         { str_colName: 'BalanceId', value: productObj.Sys_BalID },
          //         { str_colName: 'VernierId', value: productObj.Sys_VernierID },
          //         { str_colName: 'BatchNo', value: productObj.Sys_Batch },
          //         { str_colName: 'UserId', value: tempUserObject.UserId },
          //         { str_colName: 'UserName', value: tempUserObject.UserName },
          //         { str_colName: 'PrDate', value: date.format(now, 'YYYY-MM-DD') },
          //         { str_colName: 'PrTime', value: date.format(now, 'HH:mm:ss') },
          //         { str_colName: 'Side', value: side },
          //         { str_colName: 'Qty', value: HardnessDetail.data.noOfSample },
          //         { str_colName: 'Unit', value: 'N' },
          //         { str_colName: 'DecimalPoint', value: objHardness.HardnessDecimal },
          //         { str_colName: 'CubicleType', value: productObj.Sys_CubType },
          //         { str_colName: 'ReportType', value: productObj.Sys_RptType },
          //         { str_colName: 'MachineCode', value: productObj.Sys_MachineCode },
          //         { str_colName: 'MFGCode', value: productObj.Sys_MfgCode },
          //         { str_colName: 'BatchSize', value: `${productObj.Sys_BatchSize} ${productObj.Sys_BatchSizeUnit}` },
          //         { str_colName: 'HardnessID', value: productObj.Sys_HardID },
          //         { str_colName: 'CubicleName', value: productObj.Sys_dept },
          //         { str_colName: 'CubicleLocation', value: productObj.Sys_dept },
          //         { str_colName: 'IsArchived', value: 0 },
          //         { str_colName: 'PVersion', value: productObj.Sys_PVersion },
          //         { str_colName: 'Version', value: productObj.Sys_Version },
          //         { str_colName: 'ColHeadDOLOBO', value: "Breadth" },
          //         { str_colName: 'NomThick', value: thickness.length == 0 ? 0 : thickness[0].Thickness.nominal },
          //         { str_colName: 'PosTolThick', value: thickness.length == 0 ? 0 : thickness[0].Thickness.T1Neg },
          //         { str_colName: 'NegTolThick', value: thickness.length == 0 ? 0 : thickness[0].Thickness.T1Pos },
          //         { str_colName: 'NomHard', value: hardness.length == 0 ? 0 : hardness[0].Hardness.nominal },
          //         { str_colName: 'PosTolHard', value: hardness.length == 0 ? 0 : hardness[0].Hardness.T1Pos },
          //         { str_colName: 'NegTolHard', value: hardness.length == 0 ? 0 : hardness[0].Hardness.T1Neg },
          //         { str_colName: 'NomDOLOBO', value: breadth.length == 0 ? 0 : breadth[0].Breadth.nominal },
          //         { str_colName: 'PosTolDOLOBO', value: breadth.length == 0 ? 0 : breadth[0].Breadth.T1Pos },
          //         { str_colName: 'NegTolDOLOBO', value: breadth.length == 0 ? 0 : breadth[0].Breadth.T1Neg },

          //         // { str_colName: 'NomDiam', value: diameter.length == 0 ? 0 : diameter[0].Diameter.nominal },
          //         // { str_colName: 'PosTolDiam', value: diameter.length == 0 ? 0 : diameter[0].Diameter.T1Pos },
          //         // { str_colName: 'NegTolDiam', value: diameter.length == 0 ? 0 : diameter[0].Diameter.T1Neg },

          //         // { str_colName: 'GraphType', value: productlimits.Hardness.isonstd[0] == undefined ? 0 : productlimits.Hardness.isonstd[0] },
          //         { str_colName: 'GraphType', value: 0 },
          //         { str_colName: 'RepoLabel11', value: productObj.Sys_Validation },
          //         { str_colName: 'Lot', value: 'NA' },
          //         { str_colName: 'Area', value: productObj.Sys_Area },
          //         { str_colName: 'Stage', value: productObj.Sys_Stage },
          //         { str_colName: 'AppearanceDesc', value: productObj.Sys_Appearance },
          //         { str_colName: 'MachineSpeed_Min', value: productObj.Sys_MachineSpeed_Min },
          //         { str_colName: 'MachineSpeed_Max', value: productObj.Sys_MachineSpeed_Max },
          //         { str_colName: 'GenericName', value: productObj.Sys_GenericName },
          //         { str_colName: 'BMRNo', value: productObj.Sys_BMRNo },
          //         // { str_colName: 'HTMake', value: 'MT50' },
          //     ]
          // }
          // var masterRes = await database.save(insertIncompleteObj);

          /**
           * Instrument log
           */
          //await objInstrumentUsage.InstrumentUsage('Hardness', strIdsNo, 'tbl_instrumentlog_hardness', 'Hardness', 'started')

          //objHardness.masterId = masterRes[0].insertId;
        }

        if (tempCounterObj.counter == 1) {
          repSerNo = lastInsertedID;
        } else {
          repSerNo = await objCommonInsertOpt.lastInsertedRecords(
            productObj.Sys_ProductName,
            productObj.Sys_BFGCode,
            productObj.Sys_PVersion,
            productObj.Sys_Version,
            "tbl_tab_masterhtd"
          );
        }

        let insertDetailObj = await models[DetTableName].create({
          RepSerNo: repSerNo,
          MstSerNo: 0,
          RecSeqNo: tempCounterObj.counter,
          DataValueThick:
            parseFloat(objHardness.thicknessVal) == 0
              ? 0
              : parseFloat(objHardness.thicknessVal),
          DataValueDOLOBO:
            parseFloat(objHardness.WidthVal) == 0
              ? 0
              : parseFloat(objHardness.WidthVal),
          DataValueHard:
            parseFloat(objHardness.HardnessVal) == 0
              ? 0
              : parseFloat(objHardness.HardnessVal),
          //DataValueDiam: parseFloat(objHardness.DiameterVal) == 0 ? 0 : parseFloat(objHardness.DiameterVal) ,
          DecimalPointThick:
            objHardness.thicknessDecimal == 0
              ? 0
              : objHardness.thicknessDecimal,
          DecimalPointDOLOBO:
            objHardness.WidthDecimal == 0 ? 0 : objHardness.WidthDecimal,
          DecimalPointHard:
            objHardness.HardnessDecimal == 0 ? 0 : objHardness.HardnessDecimal,
          //DecimalPointDiam: objHardness.DiameterDecimal == 0 ? 0 : objHardness.DiameterDecimal ,
          idsNo: strIdsNo,
        });

        // const insertDetailObj = {
        //     str_tableName: DetTableName,
        //     data: [
        //         { str_colName: 'RepSerNo', value: repSerNo },
        //         { str_colName: 'MstSerNo', value: 0 },
        //         { str_colName: 'RecSeqNo', value: tempCounterObj.counter },
        //         { str_colName: 'DataValueThick', value: parseFloat(objHardness.thicknessVal) == 0 ? 0 : parseFloat(objHardness.thicknessVal) },
        //         { str_colName: 'DataValueDOLOBO', value: parseFloat(objHardness.WidthVal) == 0 ? 0 : parseFloat(objHardness.WidthVal) },
        //         { str_colName: 'DataValueHard', value: parseFloat(objHardness.HardnessVal) == 0 ? 0 : parseFloat(objHardness.HardnessVal) },
        //         // { str_colName: 'DataValueDiam', value: parseFloat(objHardness.DiameterVal) == 0 ? 0 : parseFloat(objHardness.DiameterVal) },
        //         { str_colName: 'DecimalPointThick', value: objHardness.thicknessDecimal == 0 ? 0 : objHardness.thicknessDecimal },
        //         { str_colName: 'DecimalPointDOLOBO', value: objHardness.WidthDecimal == 0 ? 0 : objHardness.WidthDecimal },
        //         { str_colName: 'DecimalPointHard', value: objHardness.HardnessDecimal == 0 ? 0 : objHardness.HardnessDecimal },
        //         // { str_colName: 'DecimalPointDiam', value: objHardness.DiameterDecimal == 0 ? 0 : objHardness.DiameterDecimal },
        //         { str_colName: 'idsNo', value: strIdsNo }
        //     ]
        // }
        // let objinsertDetailObj = await database.save(insertDetailObj);

        objHardness.DiameterVal == 0 ? 0 : objHardness.DiameterVal;
        objHardness.HardnessVal == 0 ? 0 : objHardness.HardnessVal;
        objHardness.thicknessVal == 0 ? 0 : objHardness.thicknessVal;
        objHardness.WidthVal == 0 ? 0 : objHardness.WidthVal;

        mqttSender.sendData(
          strHmi,
          `${mqttProtocol.DisplayResult}${objHardness.sampleFromString
          }:Diameter:${parseFloat(objHardness.DiameterVal)};
            Hardness:${parseFloat(
            objHardness.HardnessVal
          )} ; Thickness:${parseFloat(objHardness.thicknessVal)} ;
            Breadth:${parseFloat(objHardness.WidthVal)}`
        );

        if (
          Number(tempCounterObj.counter) == Number(sample) &&
          Number(objHardness.sampleFromString) == Number(sample)
        ) {
          let result = await objIncompleteReport.getIncomepleteData(
            __parameterHardnessMt50,
            "tbl_tab_masterhtd",
            "tbl_tab_detailhtd",
            strIdsNo
          );
          await objSaveCompleteHardness.saveCommonDataToCompleteHardness(
            result,
            7,
            strIdsNo
          );
          // await objCommonInsertOpt.updateEndDate(
          //   strIdsNo,
          //   strHmi,
          //   mstTableName
          // );
          await objBatchSummary.saveBatchDataHardness(
            result.incompleteData,
            result.detailData,
            strIdsNo
          );
          Object.assign(
            objActivity,
            { strUserId: tempUserObject.UserId },
            { strUserName: tempUserObject.UserName },
            { activity: "Hardness Weighment Completed on IDS " + strHmi }
          );
          await objActivityLog.ActivityLogEntry(objActivity);
          await objInstrumentUsage.InstrumentUsage(
            "Hardness",
            strIdsNo,
            "tbl_instrumentlog_hardness",
            "",
            "completed"
          );
          // globalData.arrHardnessMT50.find(ht => ht.idsNo == strIdsNo);
          globalData.arrHardnessMT50.findIndex((k) => k.Hmi == strHmi) == -1
            ? globalData.arrHardnessMT50
            : globalData.arrHardnessMT50.splice(
              globalData.arrHardnessMT50.findIndex((k) => k.Hmi == strHmi),
              1
            );

          globalData.arrWeighmentCounter.findIndex((k) => k.Hmi == strHmi) == -1
            ? globalData.arrWeighmentCounter
            : globalData.arrWeighmentCounter.splice(
              globalData.arrWeighmentCounter.findIndex(
                (k) => k.Hmi == strHmi
              ),
              1
            );

          globalData.arrCurrentOperationStatus.findIndex(
            (element) => element.Hmi === strHmi
          ) == -1
            ? globalData.arrCurrentOperationStatus
            : globalData.arrCurrentOperationStatus.splice(
              globalData.arrCurrentOperationStatus.findIndex(
                (element) => element.Hmi === strHmi
              ),
              1
            );
          //test splice if rotarty is not double
          globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi) == -1
            ? globalData.arrSelectedMenu
            : globalData.arrSelectedMenu.splice(
              globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi),
              1
            );
          return mqttSender.sendData(
            strHmi,
            `${mqttProtocol.TestCompleted}Hardness test Completed`
          );
        }
      }
    } catch (error) {
      throw new Error(error);
    }
  }

  //only hardness
  async processHardnessDataMT50OnlyHardnessData(dataObjMt50OnlyHardness) {
    try {
      let recivedWt = dataObjMt50OnlyHardness.actualWt;
      let strIdsNo = dataObjMt50OnlyHardness.idsNo;
      let strHmi = dataObjMt50OnlyHardness.Hmi;
      let strMenuName = dataObjMt50OnlyHardness.instrumentType;

      //let _cubicalData = globalData.arrIdsInfo.find(k => k.idsNo == strIdsNo).cubicalData;
      let selectedIdsNo;
      var IPQCObject = globalData.arr_IPQCRelIds.find(
        (k) => k.idsNo == strIdsNo
      );
      if (IPQCObject != undefined) {
        selectedIdsNo = IPQCObject.selectedIds;
      } else {
        selectedIdsNo = strIdsNo;
      }
      let currentCubical = globalData.arrIdsInfo.find(
        (k) => k.idsNo == selectedIdsNo
      ).cubicalData;
      //let productDetail = globalData.arrProductTypeArray.find(k => k.idsNo == strIdsNo).productDetail;
      let paramSetOrNot = globalData.arr_limits.find(
        (k) => k.idsNo == selectedIdsNo
      ).Menus;
      let thickness = paramSetOrNot.filter(
        (obj) => Object.keys(obj) == "Thickness"
      );
      let breadth = paramSetOrNot.filter(
        (obj) => Object.keys(obj) == "Breadth"
      );
      let diameter = paramSetOrNot.filter(
        (obj) => Object.keys(obj) == "Diameter"
      );
      // let hardness = paramSetOrNot.filter(obj => Object.keys(obj) == 'Hardness');
      let hardness = paramSetOrNot.filter(
        (obj) => Object.keys(obj) == "TBTTST"
      );
      let objHardness = globalData.arrHardnessMT50.find(
        (ht) => ht.idsNo == strIdsNo
      );
      let tempCounterObj = globalData.arrWeighmentCounter.find(
        (k) => k.Hmi == strHmi
      );
      let thicknessVal = 0,
        widthVal = 0,
        diameterVal = 0,
        hardnessVal = 0;
      let tempUserObject = globalData.arrUsers.find((k) => k.Hmi == strHmi);
      const HardnessDetail = globalData.arrWeighmentProductData.find(
        (k) => k.Hmi == strHmi
      );
      let sample = HardnessDetail.data.noOfSample;
      let strSampleNoFromString = "";
      let productObj = globalData.arrIdsInfo.find(
        (k) => k.idsNo == strIdsNo
      ).cubicalData;
      let mstTableName = "tbl_tab_master7_incomplete";
      let DetTableName = "tbl_tab_detail7_incomplete";
      let mstSerNo;
      let sideNo;
      let repSerNo;
      const objSelMenu = globalData.arrSelectedMenu.find(
        (k) => k.idsNo == strIdsNo
      );
      let objActivity = {};
      let repSeqNo;

      const obj = {
        idsNo: strIdsNo,
        dimensionParam: 0,
        sampleNo: 0,
        HardnessVal: [],
        HardnessDecimal: 0,
        HardnessNom: 0,
        Hardnessrneg: 0,
        Hardnesspos: 0,
        sampleFromString: "",
      };
      globalData.arrHardnessMT50.push(obj);

      if (tempCounterObj === undefined) {
        globalData.arrWeighmentCounter.push({
          Hmi: strHmi,
          counter: 0,
        });
      }

      tempCounterObj = globalData.arrWeighmentCounter.find(
        (k) => k.Hmi == strHmi
      );

      const __parameterHardnessMt50 = {
        strTableName: mstTableName,
        strDetailTbl: DetTableName,
        objProductDetails: HardnessDetail.data,
        uniqueSerialNumber: strIdsNo,
        strBalId: dataObjMt50OnlyHardness.instrumentId,
        ProtocolData: dataObjMt50OnlyHardness.actualWt,
        strHmi: strHmi,
        productType: objSelMenu.selectedProductDetail,
      };

      /**
       * remove sample from string
       */
      objHardness = globalData.arrHardnessMT50.find(
        (ht) => ht.idsNo == strIdsNo
      );
      strSampleNoFromString = recivedWt.substring(1, recivedWt.indexOf(" ")); //to get sample number from string
      if (isNaN(strSampleNoFromString) == true) {
        console.log("sample Not found");
        return mqttSender.sendData(
          strHmi,
          `${mqttProtocol.DisplayMessage}Invalid String`
        );
      } else {
        objHardness.sampleFromString = strSampleNoFromString; // saving sample no from hardness
      }

      // for Hardness *************************************************************************
      if (recivedWt.includes("H") && hardness.length != undefined) {
        if (recivedWt.includes("N")) {
          hardnessVal = recivedWt
            .substring(recivedWt.indexOf("H") + 1, recivedWt.indexOf("N"))
            .trim();
        } else {
          hardnessVal = recivedWt
            .substring(recivedWt.indexOf("H") + 1, recivedWt.indexOf("Kp"))
            .trim();
        }

        if (isNaN(hardnessVal) == false) {
          // if the received value is valid value
          objHardness.HardnessVal = hardnessVal;
          objHardness.HardnessDecimal = this.precision(Number(hardnessVal));
          objHardness.sampleNo = strSampleNoFromString;
        } else {
          objHardness.HardnessVal = 0;
          objHardness.HardnessDecimal = 0;
        }
      } else {
        objHardness.HardnessVal = 0;
        objHardness.HardnessDecimal = 0;
        objHardness.sampleNo = strSampleNoFromString;
      }
      /*********************************************************************************** */

      //this will check if sample is came directly as 2 OR  sample came directly as eual to QTY  (doubt)

      var side = "NA";
      if (productObj.Sys_RotaryType == "Single") {
        side = "NA";
      } else {
        side = HardnessDetail.data.Side == "L" ? "LHS" : "RHS"; //matching side with HardnessDetail which is feel on menu.
      }

      if (Number(sample) >= tempCounterObj.counter) {
        tempCounterObj.counter += 1;

        let tableName = "tbl_powerbackup";
        var powerbackupobj = {
          strTableName: mstTableName,
          strDetailTbl: DetTableName,
          cubicaNo: currentCubical.Sys_CubicNo,
          cubicType: currentCubical.Sys_CubType,
          cubicSysBFGcode: currentCubical.Sys_BFGCode,
          cubicBatch: currentCubical.Sys_Batch,
          menuName: HardnessDetail.data.menuName,
          productType: objSelMenu.selectedProductDetail.ProductType,
          Userid: tempUserObject.UserId,
          idsNo: strIdsNo,
          Hmi: strHmi,
          Incomp_RepSerNo: tempCounterObj.counter,
        };

        let _check_combination = await objPowerBackup._check_combination_pow(
          objSelMenu,
          powerbackupobj,
          tableName
        );
        if (_check_combination !== undefined) {
          tempCounterObj.counter = _check_combination.Incomp_RepSerNo + 1;
        }

        if (tempCounterObj.counter == 1 && objHardness.sampleFromString == 1) {
          Object.assign(
            objActivity,
            { strUserId: tempUserObject.UserId },
            { strUserName: tempUserObject.UserName },
            { activity: "Hardness Weighment Started on IDS " + strIdsNo }
          );
          await objActivityLog.ActivityLogEntry(objActivity);

          if (productObj.Sys_RptType == 1) {
            //for Initial
            mstSerNo = 1;
            sideNo = 1;
          } else {
            //regular
            let objMt50 = {
              tableName: mstTableName,
              ReportType: 0,
              Side: side,
              BFGCode: productObj.Sys_BFGCode,
              ProductName: productObj.Sys_ProductName,
              PVersion: productObj.Sys_PVersion,
              Version: productObj.Sys_Version,
              BatchNo: productObj.Sys_Batch,
              // IdsNo: strIdsNo
              IdsNo: strHmi,
            };

            if (side == "NA") {
              mstSerNo = await objGetMstSrAndSideSr.getRegularLRMstSerialNo(
                objMt50
              );
              sideNo = await objGetMstSrAndSideSr.getRegularLRSideNo(objMt50);
              if (sideNo < 10) {
                sideNo = sideNo + 1;
              } else {
                sideNo = 1;
                mstSerNo = mstSerNo + 1;
              }
            } else {
              mstSerNo = await objGetMstSrAndSideSr.getRegularLRMstSerialNo(
                objMt50
              );
              sideNo = await objGetMstSrAndSideSr.getRegularLRSideNo(objMt50);
              if (sideNo < 5) {
                sideNo = sideNo + 1;
              } else {
                sideNo = 1;
                mstSerNo = mstSerNo + 1;
              }
            }
          }
          var res = await proObj.productData(productObj);
          let now = new Date();

          const insertIncompleteObj =
            await models.tbl_tab_master7_incomplete.create({
              MstSerNo: mstSerNo,
              SideNo: sideNo,
              InstruId: 3,
              BFGCode: productObj.Sys_BFGCode,
              ProductName: productObj.Sys_ProductName,
              ProductType: res[0].ProductType,
              Qty: HardnessDetail.data.noOfSample,
              GrpQty: 0,
              GrpFreq: 0,
              Idsno: strHmi,
              CubicalNo: productObj.Sys_CubicNo,
              BalanceId: currentCubical.Sys_BalID,
              //{ str_colName: 'BalanceNo: productObj.Sys_BalID,
              VernierId: currentCubical.Sys_VernierID,
              //{ str_colName: 'VernierNo: productObj.Sys_BalID,
              BatchNo: productObj.Sys_Batch,
              UserId: tempUserObject.UserId,
              UserName: tempUserObject.UserName,
              PrDate: date.format(now, "YYYY-MM-DD"),
              PrTime: date.format(now, "HH:mm:ss"),
              Side: side,
              Unit: res[1]["Param7_Unit"],
              DecimalPoint: res[1]["Param7_Dp"],
              WgmtModeNo: 7,
              Nom: res[1]["Param7_Nom"],
              T1NegTol: res[1]["Param7_T1Neg"],
              T1PosTol: res[1]["Param7_T1Pos"],
              // { str_colName: 'T2NegTol: res[1][paramT2Neg],
              // { str_colName: 'T2PosTol: res[1][paramT2Pos],
              limitOn: res[1]["Param7_LimitOn"].readUIntLE(),
              // { str_colName: 'T1NMTTab: 0,
              // { str_colName: 'T1NegEmpty: ,
              // { str_colName: 'T1PosEmpty: ,
              // { str_colName: 'T2NegEmpty: ,
              // { str_colName: 'T2PosEmpty: ,
              // { str_colName: 'NomNet: ,
              // { str_colName: 'T1NegNet: ,
              // { str_colName: 'T1PosNet: ,
              // { str_colName: 'T2NegNet: ,
              // { str_colName: 'T2PosNet: ,
              CubicleType: productObj.Sys_CubType,
              ReportType: productObj.Sys_RptType,
              MachineCode: productObj.Sys_MachineCode,
              MFGCode: productObj.Sys_MfgCode,
              BatchSize: `${productObj.Sys_BatchSize} ${productObj.Sys_BatchSizeUnit}`,
              FriabilityID: currentCubical.Sys_FriabID,
              HardnessID: currentCubical.Sys_HardID,
              CubicleName: productObj.Sys_CubicName,
              CubicleLocation: productObj.Sys_dept,
              RepoLabel10: res[0].NominalNomenclature,
              RepoLabel11: productObj.Sys_Validation, // this will store wether the test is validation or not
              IPQCType: productObj.Sys_IPQCType,
              PrintNo: 0,
              IsArchived: 0,
              GraphType: res[1]["Param7_IsOnStd"].readUIntLE(),
              BatchComplete: 0,
              PVersion: productObj.Sys_PVersion,
              Version: productObj.Sys_Version,
              Lot: "NA",
              Area: productObj.Sys_Area,
              AppearanceDesc: productObj.Sys_Appearance,
              MachineSpeed_Min: productObj.Sys_MachineSpeed_Min,
              MachineSpeed_Max: productObj.Sys_MachineSpeed_Max,
              GenericName: productObj.Sys_GenericName,
              BMRNo: productObj.Sys_BMRNo,
            });
          await objPowerBackup.getStatusoFTestForPowerBackup(powerbackupobj);

          var lastInsertedID = insertIncompleteObj._previousDataValues.RepSerNo;

          /**
           * Instrument log need to check
           */
          // await objInstrumentUsage.InstrumentUsage('Hardness', strIdsNo, 'tbl_instrumentlog_hardness', 'Hardness', 'started')

          //objHardness.masterId = masterRes[0].insertId;
        }

        if (tempCounterObj.counter == 1 && objHardness.sampleFromString == 1) {
          repSerNo = lastInsertedID;
          //repSeqNo = await objCommonInsertOpt.lastInsertedSeqNo('tbl_tab_detail7', 1);
        } else {
          repSerNo = await objCommonInsertOpt.lastInsertedRecords(
            productObj.Sys_ProductName,
            productObj.Sys_BFGCode,
            productObj.Sys_PVersion,
            productObj.Sys_Version,
            "tbl_tab_master7"
          );

          // repSeqNo = await objCommonInsertOpt.lastInsertedSeqNo('tbl_tab_detail7', repSerNo);
          // if (repSeqNo == 1) {
          //     repSeqNo = +1;
          // }
        }

        // var insertDetailObj = {
        //     str_tableName: DetTableName,
        //     data: [
        //         { str_colName: 'RepSerNo', value: repSerNo },
        //         { str_colName: 'MstSerNo', value: 0 },
        //         { str_colName: 'RecSeqNo', value: tempCounterObj.counter },
        //         { str_colName: 'DataValue', value: parseFloat(objHardness.HardnessVal) == 0 ? 0 : parseFloat(objHardness.HardnessVal) },
        //         { str_colName: 'DecimalPoint', value: objHardness.HardnessDecimal == 0 ? 0 : objHardness.HardnessDecimal }
        //     ]
        // }
        // let objinsertDetailObj = await database.save(insertDetailObj);

        // if (tempCounterObj.counter == 1) {
        //     repSerNo = 0;
        // }

        // if (tempCounterObj.counter == repSeqNo && Number(objHardness.sampleFromString) == repSeqNo) {

        // } else {
        //     console.log('sample number not match only hardness');
        //     tempCounterObj.counter = -1;
        // }

        await models[DetTableName].create({
          RepSerNo: repSerNo,
          MstSerNo: 0,
          RecSeqNo: tempCounterObj.counter,
          DataValue:
            parseFloat(objHardness.HardnessVal) == 0
              ? 0
              : parseFloat(objHardness.HardnessVal),
          DecimalPoint:
            objHardness.HardnessDecimal == 0 ? 0 : objHardness.HardnessDecimal,
        });

        var incompRepSerNo = await objPowerBackup.updateTestCount(
          objSelMenu,
          powerbackupobj,
          tableName
        );

        objHardness.DiameterVal == 0 ? 0 : objHardness.DiameterVal;
        objHardness.HardnessVal == 0 ? 0 : objHardness.HardnessVal;
        objHardness.thicknessVal == 0 ? 0 : objHardness.thicknessVal;
        objHardness.WidthVal == 0 ? 0 : objHardness.WidthVal;

        // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}Diameter:${parseFloat(objHardness.DiameterVal)};
        // Hardness:${parseFloat(objHardness.HardnessVal)} ; Thickness:${parseFloat(objHardness.thicknessVal)} ;
        // Width:${parseFloat(objHardness.WidthVal)}`);
        mqttSender.sendData(
          strHmi,
          `${mqttProtocol.DisplayResult}Hardness:${tempCounterObj.counter
          }:${parseFloat(objHardness.HardnessVal)} N`
        );

        if (
          tempCounterObj.counter == sample &&
          objHardness.sampleFromString == sample
        ) {
          let result = await objIncompleteReport.getIncomepleteData(
            __parameterHardnessMt50,
            "tbl_tab_master7",
            "tbl_tab_detail7",
            strIdsNo
          );
          var remarkRes = await objSaveCompleteHardness.saveHardnessData8M(
            result,
            repSerNo,
            strIdsNo,
            strHmi,
            "tbl_tab_master7"
          );
          // await objCommonInsertOpt.updateEndDate(
          //   strIdsNo,
          //   strHmi,
          //   mstTableName
          // );
          await objBatchSummary.saveBatchDataHardness(
            result.incompleteData,
            result.detailData,
            strIdsNo
          );
          const _deletePowerbackup = await models.tbl_powerbackup.destroy({
            where: {
              IdsNo: strHmi,
              Sys_Batch: currentCubical.Sys_Batch,
            },
          });

          Object.assign(
            objActivity,
            { strUserId: tempUserObject.UserId },
            { strUserName: tempUserObject.UserName },
            { activity: "Hardness Weighment Completed on IDS " + strHmi }
          );
          await objActivityLog.ActivityLogEntry(objActivity);
          await objInstrumentUsage.InstrumentUsage(
            "Hardness",
            strIdsNo,
            "tbl_instrumentlog_hardness",
            "",
            "completed"
          );
          // globalData.arrHardnessMT50.find(ht => ht.idsNo == strIdsNo);
          globalData.arrHardnessMT50.findIndex((k) => k.Hmi == strHmi) == -1
            ? globalData.arrHardnessMT50
            : globalData.arrHardnessMT50.splice(
              globalData.arrHardnessMT50.findIndex((k) => k.Hmi == strHmi),
              1
            );

          globalData.arrWeighmentCounter.findIndex((k) => k.Hmi == strHmi) == -1
            ? globalData.arrWeighmentCounter
            : globalData.arrWeighmentCounter.splice(
              globalData.arrWeighmentCounter.findIndex(
                (k) => k.Hmi == strHmi
              ),
              1
            );

          globalData.arrCurrentOperationStatus.findIndex(
            (element) => element.Hmi === strHmi
          ) == -1
            ? globalData.arrCurrentOperationStatus
            : globalData.arrCurrentOperationStatus.splice(
              globalData.arrCurrentOperationStatus.findIndex(
                (element) => element.Hmi === strHmi
              ),
              1
            );
          //test splice if rotarty is not double
          globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi) == -1
            ? globalData.arrSelectedMenu
            : globalData.arrSelectedMenu.splice(
              globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi),
              1
            );
          return mqttSender.sendData(
            strHmi,
            `${mqttProtocol.TestCompleted}Hardness test Completed`
          );
        }
      }
    } catch (error) {
      throw new Error(error);
    }
  }

  //mT50 direct
  async processHardnessMT50HTOHR(dataObjMT50HTOHR) {
    let tempRecivedWt = dataObjMT50HTOHR.actualWt;
    let strIdsNo = dataObjMT50HTOHR.idsNo;
    let strHmi = dataObjMT50HTOHR.Hmi;
    let strMenuName = dataObjMT50HTOHR.instrumentType;
    let currentCubical = globalData.arrIdsInfo.find(
      (k) => k.idsNo == strIdsNo
    ).cubicalData;
    let selectedIdsNo;
    var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.idsNo == strIdsNo);
    if (IPQCObject != undefined) {
      selectedIdsNo = IPQCObject.selectedIds;
    } else {
      selectedIdsNo = strIdsNo;
    }

    let productDetail = globalData.arrProductTypeArray.find(
      (k) => k.idsNo == selectedIdsNo
    ).productDetail;
    // let objHardness = globalData.arrHardnessMT50.find(ht => ht.idsNo == strIdsNo);
    let tempCounterObj = globalData.arrWeighmentCounter.find(
      (k) => k.Hmi == strHmi
    );
    let tempUserObject = globalData.arrUsers.find((k) => k.Hmi == strHmi);
    const HardnessDetail = globalData.arrWeighmentProductData.find(
      (k) => k.Hmi == strHmi
    );
    let sample = HardnessDetail.data.noOfSample;
    let strSampleNoFromString = "";
    let productObj = globalData.arrIdsInfo.find(
      (k) => k.idsNo == selectedIdsNo
    ).cubicalData;
    let mstSerNo;
    let sideNo;
    let repSerNo;
    const objSelMenu = globalData.arrSelectedMenu.find(
      (k) => k.idsNo == strIdsNo
    );
    let mstTableName = "tbl_tab_master7_incomplete";
    let DetTableName = "tbl_tab_detail7_incomplete";
    let arrOfDisplayData = [];
    // const objSelMenu = globalData.arrSelectedMenu.find(k => k.idsNo == strIdsNo).selectedProductDetail;

    let objActivity = {};
    if (tempCounterObj === undefined) {
      globalData.arrWeighmentCounter.push({
        Hmi: strHmi,
        counter: 0,
      });
    }

    tempCounterObj = globalData.arrWeighmentCounter.find(
      (k) => k.Hmi == strHmi
    );
    var side = "NA";
    if (productObj.Sys_RotaryType == "Single") {
      side = "NA";
    } else {
      side = HardnessDetail.data.Side == "L" ? "LHS" : "RHS";
    }

    if (Number(sample) >= tempCounterObj.counter) {
      tempCounterObj.counter += 1;

      let tableName = "tbl_powerbackup";
      var powerbackupobj = {
        strTableName: mstTableName,
        strDetailTbl: DetTableName,
        cubicaNo: currentCubical.Sys_CubicNo,
        cubicType: currentCubical.Sys_CubType,
        cubicSysBFGcode: currentCubical.Sys_BFGCode,
        cubicBatch: currentCubical.Sys_Batch,
        menuName: HardnessDetail.data.menuName,
        productType: objSelMenu.selectedProductDetail.ProductType,
        Userid: tempUserObject.UserId,
        idsNo: strIdsNo,
        Hmi: strHmi,
        Incomp_RepSerNo: tempCounterObj.counter,
      };

      let _check_combination = await objPowerBackup._check_combination_pow(
        objSelMenu,
        powerbackupobj,
        tableName
      );
      if (_check_combination !== undefined) {
        tempCounterObj.counter = _check_combination.Incomp_RepSerNo + 1;
      }

      if (tempCounterObj.counter == 1) {
        if (productObj.Sys_RptType == 1) {
          //for Initial
          mstSerNo = 1;
          sideNo = 1;
        } else {
          //regular
          let objMt50 = {
            tableName: mstTableName,
            ReportType: 0,
            Side: side,
            BFGCode: productObj.Sys_BFGCode,
            ProductName: productObj.Sys_ProductName,
            PVersion: productObj.Sys_PVersion,
            Version: productObj.Sys_Version,
            BatchNo: productObj.Sys_Batch,
            IdsNo: strHmi,
          };

          if (side == "NA") {
            mstSerNo = await objGetMstSrAndSideSr.getRegularLRMstSerialNo(
              objMt50
            );
            sideNo = await objGetMstSrAndSideSr.getRegularLRSideNo(objMt50);
            if (sideNo < 10) {
              sideNo = sideNo + 1;
            } else {
              sideNo = 1;
              mstSerNo = mstSerNo + 1;
            }
          } else {
            mstSerNo = await objGetMstSrAndSideSr.getRegularLRMstSerialNo(
              objMt50
            );
            sideNo = await objGetMstSrAndSideSr.getRegularLRSideNo(objMt50);
            if (sideNo < 5) {
              sideNo = sideNo + 1;
            } else {
              sideNo = 1;
              mstSerNo = mstSerNo + 1;
            }
          }
        }

        //insert data
        let now = new Date();
        var res = await proObj.productData(productObj);

        const insertIncompleteObj = await models[
          "tbl_tab_master7_incomplete"
        ].create({
          MstSerNo: mstSerNo,
          SideNo: sideNo,
          InstruId: 3,
          BFGCode: productObj.Sys_BFGCode,
          ProductName: productObj.Sys_ProductName,
          ProductType: res[0].ProductType,
          Qty: HardnessDetail.data.noOfSample,
          GrpQty: 0,
          GrpFreq: 0,
          Idsno: strHmi,
          CubicalNo: productObj.Sys_CubicNo,
          BalanceId: currentCubical.Sys_BalID,
          //{ str_colName: 'BalanceNo: productObj.Sys_BalID ,
          VernierId: currentCubical.Sys_VernierID,
          //{ str_colName: 'VernierNo: productObj.Sys_BalID ,
          BatchNo: productObj.Sys_Batch,
          UserId: tempUserObject.UserId,
          UserName: tempUserObject.UserName,
          PrDate: date.format(now, "YYYY-MM-DD"),
          PrTime: date.format(now, "HH:mm:ss"),
          Side: side,
          Unit: res[1]["Param7_Unit"],
          DecimalPoint: res[1]["Param7_Dp"],
          WgmtModeNo: 7,
          Nom: res[1]["Param7_Nom"],
          T1NegTol: res[1]["Param7_T1Neg"],
          T1PosTol: res[1]["Param7_T1Pos"],
          //T2NegTol: res[1][paramT2Neg] ,
          //T2PosTol: res[1][paramT2Pos] ,
          limitOn: res[1]["Param7_LimitOn"].readUIntLE(),
          //T1NMTTab: 0 ,
          //T1NegEmpty:  ,
          //T1PosEmpty:  ,
          //T2NegEmpty:  ,
          //T2PosEmpty:  ,
          //NomNet:  ,
          //T1NegNet:  ,
          //T1PosNet:  ,
          //T2NegNet:  ,
          //T2PosNet:  ,
          CubicleType: productObj.Sys_CubType,
          ReportType: productObj.Sys_RptType,
          MachineCode: productObj.Sys_MachineCode,
          MFGCode: productObj.Sys_MfgCode,
          BatchSize: `${productObj.Sys_BatchSize} ${productObj.Sys_BatchSizeUnit}`,
          FriabilityID: currentCubical.Sys_FriabID,
          HardnessID: currentCubical.Sys_HardID,
          CubicleName: productObj.Sys_CubicName,
          CubicleLocation: productObj.Sys_dept,
          RepoLabel10: res[0].NominalNomenclature,
          RepoLabel11: productObj.Sys_Validation, // this will store wether the test is validation or not
          //RepoLabel12:  ,
          RepoLabel14: productObj.Sys_IPQCType,
          PrintNo: 0,
          IsArchived: 0,
          GraphType: res[1]["Param7_IsOnStd"].readUIntLE(),
          BatchComplete: 0,
          PVersion: productObj.Sys_PVersion,
          Version: productObj.Sys_Version,
          Lot: "NA", //objLotData.LotNo
          Area: productObj.Sys_Area,
          AppearanceDesc: productObj.Sys_Appearance,
          MachineSpeed_Min: productObj.Sys_MachineSpeed_Min,
          MachineSpeed_Max: productObj.Sys_MachineSpeed_Max,
          GenericName: productObj.Sys_GenericName,
          BMRNo: productObj.Sys_BMRNo,
        });
        // console.log(insertIncompleteObj)
        var masterRes = insertIncompleteObj._previousDataValues.RepSerNo;
        Object.assign(
          objActivity,
          { strUserId: tempUserObject.UserId },
          { strUserName: tempUserObject.UserName },
          { activity: "Hardness Weighment Started on IDS" + strIdsNo }
        );
        await objActivityLog.ActivityLogEntry(objActivity);
        var lastInsertedID = insertIncompleteObj._previousDataValues.RepSerNo;
        /**
         * Instrument log
         */
        await objInstrumentUsage.InstrumentUsage(
          "Hardness",
          strIdsNo,
          "tbl_instrumentlog_hardness",
          "Hardness",
          "started"
        );
      }

      for (let i = 0; i < tempRecivedWt.length; i++) {
        i == 0 ? 0 : (tempCounterObj.counter += 1);
        repSerNo = await objCommonInsertOpt.lastInsertedRecords(
          productObj.Sys_ProductName,
          productObj.Sys_BFGCode,
          productObj.Sys_PVersion,
          productObj.Sys_Version,
          "tbl_tab_master7"
        );

        // var detailObj = {
        //     str_tableName: 'tbl_tab_detail7_incomplete',
        //     data: [
        //         { str_colName: 'RepSerNo', value: repSerNo },
        //         { str_colName: 'MstSerNo', value: 0 },
        //         { str_colName: 'RecSeqNo', value: tempRecivedWt[i].datavalue[0].trim() },
        //         { str_colName: 'DataValue', value: tempRecivedWt[i].datavalue[1].trim() },
        //         { str_colName: 'DecimalPoint', value: this.precision(Number(tempRecivedWt[i].datavalue[1].trim())) }
        //     ]
        // }
        // var detailRes = await database.save(detailObj);

        const detailObj = await models["tbl_tab_detail7_incomplete"].create({
          RepSerNo: repSerNo,
          MstSerNo: 0,
          RecSeqNo: tempRecivedWt[i].datavalue[0].trim(),
          DataValue: tempRecivedWt[i].datavalue[1].trim(),
          DecimalPoint: this.precision(
            Number(tempRecivedWt[i].datavalue[1].trim())
          ),
        });

        var incompRepSerNo = await objPowerBackup.updateTestCount(
          objSelMenu,
          powerbackupobj,
          tableName
        );
        mqttSender.sendData(
          strHmi,
          `${mqttProtocol.DisplayResult}${tempRecivedWt[
            i
          ].datavalue[0].trim()}:${tempRecivedWt[i].datavalue[1].trim()} ${res[1]["Param7_Unit"]
          }`
        );
      }

      if (Number(sample) == tempCounterObj.counter) {
        var remarkRes = await objSaveCompleteHardness.saveHardnessData8M(
          repSerNo,
          strIdsNo
        );
        let objActivity = {};
        await objInstrumentUsage.InstrumentUsage(
          "Hardness",
          strIdsNo,
          "tbl_instrumentlog_hardness",
          "",
          "completed"
        );
        Object.assign(
          objActivity,
          { strUserId: tempUserObject.UserId },
          { strUserName: tempUserObject.UserName },
          { activity: "Hardness Weighment Completed on IDS" + strIdsNo }
        );
        await objActivityLog.ActivityLogEntry(objActivity);
        let rptMsg;
        if (remarkRes == "Complies") {
          rptMsg = "Report Generated Within limit";
        } else {
          rptMsg = "Report Generated WithOut limit";
        }

        globalData.arrHardnessMT50.findIndex((k) => k.Hmi == strHmi) == -1
          ? globalData.arrHardnessMT50
          : globalData.arrHardnessMT50.splice(
            globalData.arrHardnessMT50.findIndex((k) => k.Hmi == strHmi),
            1
          );

        globalData.arrWeighmentCounter.findIndex((k) => k.Hmi == strHmi) == -1
          ? globalData.arrWeighmentCounter
          : globalData.arrWeighmentCounter.splice(
            globalData.arrWeighmentCounter.findIndex((k) => k.Hmi == strHmi),
            1
          );

        globalData.arrCurrentOperationStatus.findIndex(
          (element) => element.Hmi === strHmi
        ) == -1
          ? globalData.arrCurrentOperationStatus
          : globalData.arrCurrentOperationStatus.splice(
            globalData.arrCurrentOperationStatus.findIndex(
              (element) => element.Hmi === strHmi
            ),
            1
          );
        //test splice if rotarty is not double
        globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi) == -1
          ? globalData.arrSelectedMenu
          : globalData.arrSelectedMenu.splice(
            globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi),
            1
          );

        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}${rptMsg}`);
        mqttSender.sendData(
          strHmi,
          `${mqttProtocol.TestCompleted}Hardness Test Completed`
        );
      }
    }
    //console.log(dataObjMT50HTOHR);
  }

  async processHardnessDrSchleuniger(dataObjDrSchleuniger) {
    let recivedWt = dataObjDrSchleuniger.actualWt;
    let strIdsNo = dataObjDrSchleuniger.idsNo;
    let strHmi = dataObjDrSchleuniger.Hmi;
    var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.idsNo == strIdsNo);
    // var objLotData = globalData.arrLot.find(k => k.idsNo == IdsNo);

    var objProductType = globalData.arrProductTypeArray.find(
      (k) => k.idsNo == strIdsNo
    ).productType;
    var selectedIds;
    if (IPQCObject != undefined) {
      selectedIds = IPQCObject.selectedIds;
    } else {
      selectedIds = strIdsNo;
    }
    var currentCubicalObj = globalData.arrIdsInfo.find(
      (k) => k.idsNo == strIdsNo
    ).cubicalData;
    var productObj = globalData.arrIdsInfo.find(
      (k) => k.idsNo == selectedIds
    ).cubicalData;
    const tempUserObject = globalData.arrUsers.find((k) => k.Hmi == strHmi);
    // var objHardness = globalData.arrHardnessDRSCPharmatron.find(ht => ht.idsNo == strIdsNo);
    var menuDetail = globalData.arr_limits.find((al) => al.idsNo == strIdsNo);
    let productlimits = menuDetail.Menus.filter(
      (obj) => Object.keys(obj) == "Hardness"
    )[0]["Hardness"];
    let now = new Date();

    var res = await proObj.productData(productObj);
    //var objArrLimits = globalData.arrIdsInfo.find(k => k.idsNo == IdsNo);
    var side = "NA";
    if (productObj.Sys_RotaryType == "Single") {
      side = "NA";
    } else {
      side = HardnessDetail.data.Side == "L" ? "LHS" : "RHS";
    }

    const insertIncompleteObj = {
      str_tableName: "tbl_tab_master7_incomplete",
      data: [
        { str_colName: "MstSerNo", value: 1 },
        { str_colName: "InstruId", value: 3 },
        { str_colName: "BFGCode", value: productObj.Sys_BFGCode },
        { str_colName: "ProductName", value: productObj.Sys_ProductName },
        { str_colName: "ProductType", value: objProductType.ProductType },
        { str_colName: "Qty", value: productlimits.noOfSamples },
        { str_colName: "GrpQty", value: 0 },
        { str_colName: "GrpFreq", value: 0 },
        { str_colName: "Idsno", value: strIdsNo },
        { str_colName: "CubicalNo", value: productObj.Sys_CubicNo },
        { str_colName: "BalanceId", value: currentCubicalObj.Sys_BalID },
        //{ str_colName: 'BalanceNo', value: productObj.Sys_BalID },
        { str_colName: "VernierId", value: currentCubicalObj.Sys_VernierID },
        //{ str_colName: 'VernierNo', value: productObj.Sys_BalID },
        { str_colName: "BatchNo", value: productObj.Sys_Batch },
        { str_colName: "UserId", value: tempUserObject.UserId },
        { str_colName: "UserName", value: tempUserObject.UserName },
        { str_colName: "PrDate", value: date.format(now, "YYYY-MM-DD") },
        { str_colName: "PrTime", value: date.format(now, "HH:mm:ss") },
        { str_colName: "Side", value: side },
        { str_colName: "Unit", value: res[1]["Param7_Unit"] },
        { str_colName: "DecimalPoint", value: res[1]["Param7_Dp"] },
        { str_colName: "WgmtModeNo", value: 7 },
        { str_colName: "Nom", value: res[1]["Param7_Nom"] },
        { str_colName: "T1NegTol", value: res[1]["Param7_T1Neg"] },
        { str_colName: "T1PosTol", value: res[1]["Param7_T1Pos"] },
        // { str_colName: 'T2NegTol', value: res[1][paramT2Neg] },
        // { str_colName: 'T2PosTol', value: res[1][paramT2Pos] },
        {
          str_colName: "limitOn",
          value: res[1]["Param7_LimitOn"].readUIntLE(),
        },
        // { str_colName: 'T1NMTTab', value: 0 },
        // { str_colName: 'T1NegEmpty', value:  },
        // { str_colName: 'T1PosEmpty', value:  },
        // { str_colName: 'T2NegEmpty', value:  },
        // { str_colName: 'T2PosEmpty', value:  },
        // { str_colName: 'NomNet', value:  },
        // { str_colName: 'T1NegNet', value:  },
        // { str_colName: 'T1PosNet', value:  },
        // { str_colName: 'T2NegNet', value:  },
        // { str_colName: 'T2PosNet', value:  },
        { str_colName: "CubicleType", value: productObj.Sys_CubType },
        { str_colName: "ReportType", value: productObj.Sys_RptType },
        { str_colName: "MachineCode", value: productObj.Sys_MachineCode },
        { str_colName: "MFGCode", value: productObj.Sys_MfgCode },
        {
          str_colName: "BatchSize",
          value: `${productObj.Sys_BatchSize} ${productObj.Sys_BatchSizeUnit}`,
        },
        { str_colName: "FriabilityID", value: currentCubicalObj.Sys_FriabID },
        { str_colName: "HardnessID", value: currentCubicalObj.Sys_HardID },
        { str_colName: "CubicleName", value: productObj.Sys_CubicName },
        { str_colName: "CubicleLocation", value: productObj.Sys_dept },
        { str_colName: "RepoLabel10", value: res[0].NominalNomenclature },
        { str_colName: "RepoLabel11", value: productObj.Sys_Validation }, // this will store wether the test is validation or not
        // { str_colName: 'RepoLabel12', value:  },
        // { str_colName: 'RepoLabel13', value:  },
        { str_colName: "PrintNo", value: 0 },
        { str_colName: "IsArchived", value: 0 },
        {
          str_colName: "GraphType",
          value: res[1]["Param7_IsOnStd"].readUIntLE(),
        },
        { str_colName: "BatchComplete", value: 0 },
        { str_colName: "PVersion", value: productObj.Sys_PVersion },
        { str_colName: "Version", value: productObj.Sys_Version },
        { str_colName: "Lot", value: "NA" }, //objLotData.LotNo
        { str_colName: "Area", value: productObj.Sys_Area },
        { str_colName: "AppearanceDesc", value: productObj.Sys_Appearance },
        {
          str_colName: "MachineSpeed_Min",
          value: productObj.Sys_MachineSpeed_Min,
        },
        {
          str_colName: "MachineSpeed_Max",
          value: productObj.Sys_MachineSpeed_Max,
        },
        { str_colName: "GenericName", value: productObj.Sys_GenericName },
        { str_colName: "BMRNo", value: productObj.Sys_BMRNo },
      ],
    };
    console.log(insertIncompleteObj);
    var masterRes = await database.save(insertIncompleteObj);
    var lastInsertedID = masterRes[0].insertId;
    let objActivity = {};
    Object.assign(
      objActivity,
      { strUserId: tempUserObject.UserId },
      { strUserName: tempUserObject.UserName },
      { activity: "Hardness Weighment Started on IDS" + strIdsNo }
    );
    await objActivityLog.ActivityLogEntry(objActivity);

    let counter = 0;
    for (const dataVal in recivedWt) {
      let strDataVal = recivedWt[dataVal].datavalue.split(":");
      let strCounter = strDataVal[0].trim();
      let hardnessval = parseFloat(strDataVal[1].trim());
      let decimalPoint = this.precision(parseFloat(hardnessval));
      var detailObj = {
        str_tableName: "tbl_tab_detail7_incomplete",
        data: [
          { str_colName: "RepSerNo", value: lastInsertedID },
          { str_colName: "MstSerNo", value: 0 },
          { str_colName: "RecSeqNo", value: strCounter },
          { str_colName: "DataValue", value: hardnessval },
          { str_colName: "DecimalPoint", value: decimalPoint },
        ],
      };
      var detailRes = await database.save(detailObj);
      mqttSender.sendData(
        strHmi,
        `${mqttProtocol.DisplayResult}${strCounter}:${hardnessval} ${res[1]["Param7_Unit"]}`
      );
      counter++;
    }

    if (productlimits.noOfSamples == counter) {
      var remarkRes = await objSaveCompleteHardness.saveHardnessData8M(
        repSerNo,
        strIdsNo
      );
      let objActivity = {};
      await objInstrumentUsage.InstrumentUsage(
        "Hardness",
        strIdsNo,
        "tbl_instrumentlog_hardness",
        "",
        "completed"
      );
      Object.assign(
        objActivity,
        { strUserId: tempUserObject.UserId },
        { strUserName: tempUserObject.UserName },
        { activity: "Hardness Weighment Completed on IDS" + strIdsNo }
      );
      await objActivityLog.ActivityLogEntry(objActivity);
      let rptMsg;
      if (remarkRes == "Complies") {
        rptMsg = "Report Generated Within limit";
      } else {
        rptMsg = "Report Generated WithOut limit";
      }
      mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}${rptMsg}`);
      mqttSender.sendData(
        strHmi,
        `${mqttProtocol.TestCompleted}Hardness Test Completed`
      );
    }
  }

  async saveDataIncompleteMasterHardness125(dataObj, counter) {
    try {
      let now = new Date();
      let strHmi = dataObj.strHmi;
      let strIdsNo = dataObj.uniqueSerialNumber;
      let CurrentCubical = globalData.arrIdsInfo.find(
        (k) => k.Hmi == strHmi
      ).cubicalData; //selected
      let selectedIdsNo = strIdsNo;
      var selectedIds;
      var IPQCObject = globalData.arr_IPQCRelIds.find(
        (k) => k.strIdsNo == strIdsNo
      );
      if (IPQCObject != undefined) {
        selectedIds = IPQCObject.selectedIds.Idsno;
      } else {
        selectedIds = strHmi;
      }
      // let productObj = globalData.arrIdsInfo.find(
      //   (k) => k.idsNo == strIdsNo
      // ).cubicalData;

      let hmiDetailsInPMenu = globalData.arrIdsInfo.find(
        (k) => k.idsNo == selectedIdsNo
      ).cubicalData;
      let productDetail = globalData.arrProductTypeArray.find(
        (k) => k.idsNo == selectedIdsNo
      );
      var arrUsers = globalData.arrUsers.find((k) => k.Hmi == strHmi);
      var DiamNom;
      var DiamNeg;
      var DiamNeg1;
      var DiamNeg2;
      var DiamNeg3;
      var DiamPos;
      var DiamPos1;
      var DiamPos2;
      var DiamPos3;

      var BLNom;
      var BLNeg;
      var BLNeg1;
      var BLNeg2;
      var BLNeg3;
      var BLPos;
      var BLPos1;
      var BLPos2;
      var BLPos3;

      var dp = 2;
      var hardDp = 0;

      var hardnessDetail = dataObj.objProductDetails.columnDetail.find(
        (k) => "Hardness" in k
      );
      if (hardnessDetail !== undefined) {
        var HardNom = (Number(hardnessDetail.Hardness.Nom) == 0 || Number(hardnessDetail.Hardness.Nom) == 99999) ? "NA" : hardnessDetail.Hardness.Nom.toFixed(hardDp);
        var HardNeg1 = (Number(hardnessDetail.Hardness.T1ActualNeg) == 0 || Number(hardnessDetail.Hardness.T1ActualNeg) == 99999) ? "NA" : hardnessDetail.Hardness.T1ActualNeg.toFixed(hardDp);
        var HardNeg2 = (Number(hardnessDetail.Hardness.T2ActualNeg) == 0 || Number(hardnessDetail.Hardness.T2ActualNeg) == 99999) ? "NA" : hardnessDetail.Hardness.T2ActualNeg.toFixed(hardDp);
        var HardNeg3 = (Number(hardnessDetail.Hardness.T3ActualNeg) == 0 || Number(hardnessDetail.Hardness.T3ActualNeg) == 99999) ? "NA" : hardnessDetail.Hardness.T3ActualNeg.toFixed(hardDp);
        var HardPos1 = (Number(hardnessDetail.Hardness.T1ActualPos) == 0 || Number(hardnessDetail.Hardness.T1ActualPos) == 99999) ? "NA" : hardnessDetail.Hardness.T1ActualPos.toFixed(hardDp);
        var HardPos2 = (Number(hardnessDetail.Hardness.T2ActualPos) == 0 || Number(hardnessDetail.Hardness.T2ActualPos) == 99999) ? "NA" : hardnessDetail.Hardness.T2ActualPos.toFixed(hardDp);
        var HardPos3 = (Number(hardnessDetail.Hardness.T3ActualPos) == 0 || Number(hardnessDetail.Hardness.T3ActualPos) == 99999) ? "NA" : hardnessDetail.Hardness.T3ActualPos.toFixed(hardDp);
      }
      let colHeadDolobo;
      let side;
      if (hmiDetailsInPMenu.Sys_RotaryType == "Single") {
        side = "NA";
      } else {
        side = "LHS";
      }
      //confirm
      let menuDetail = globalData.arr_limits.find((k) => k.idsNo == strIdsNo);
      let tempObj;
      let thicknessNom,
        thicknesneg,
        thicknespos,
        thicknesneg1,
        thicknespos1,
        thicknesneg2,
        thicknespos2,
        thicknesneg3,
        thicknespos3;
      let tempLimObjHardness,
        tempLimObjThickness,
        tempLimObjlength,
        tempLimObjDiameter,
        tempLimObjBreadth;
      tempLimObjHardness =
        menuDetail.Menus.filter((obj) => Object.keys(obj) == "Hardness")[0] ==
          undefined
          ? undefined
          : menuDetail.Menus.filter((obj) => Object.keys(obj) == "Hardness")[0][
          "Hardness"
          ];

      tempLimObjThickness =
        tempLimObjHardness.columnDetail.filter((obj) => Object.keys(obj) == "Thickness")[0] ==
          undefined
          ? undefined
          : tempLimObjHardness.columnDetail.filter((obj) => Object.keys(obj) == "Thickness")[0]["Thickness"];

      tempLimObjlength =
        tempLimObjHardness.columnDetail.filter((obj) => Object.keys(obj) == "Length")[0] ==
          undefined
          ? undefined
          : tempLimObjHardness.columnDetail.filter((obj) => Object.keys(obj) == "Length")[0][
          "Length"
          ];

      tempLimObjDiameter =
        tempLimObjHardness.columnDetail.filter((obj) => Object.keys(obj) == "Diameter")[0] ==
          undefined
          ? undefined
          : tempLimObjHardness.columnDetail.filter((obj) => Object.keys(obj) == "Diameter")[0][
          "Diameter"
          ];

      tempLimObjBreadth =
        tempLimObjHardness.columnDetail.filter((obj) => Object.keys(obj) == "Breadth")[0] ==
          undefined
          ? undefined
          : tempLimObjHardness.columnDetail.filter((obj) => Object.keys(obj) == "Breadth")[0][
          "Breadth"
          ];

      colHeadDolobo =
        tempLimObjlength != undefined
          ? "Length"
          : tempLimObjBreadth != undefined
            ? "Breadth"
            : tempLimObjDiameter != undefined
              ? "Diameter"
              : "NA";

      if (tempLimObjDiameter != undefined) {
        // diameter
        DiamNom = mathj.round(Number(tempLimObjDiameter.Nom), dp).toFixed(dp);
        DiamNeg1 = mathj.round(Number(tempLimObjDiameter.T1ActualNeg), dp).toFixed(dp);
        DiamPos1 = mathj.round(Number(tempLimObjDiameter.T1ActualPos), dp).toFixed(dp);
        DiamNeg2 = mathj.round(Number(tempLimObjDiameter.T2ActualNeg), dp).toFixed(dp);
        DiamPos2 = mathj.round(Number(tempLimObjDiameter.T2ActualPos), dp).toFixed(dp);
        DiamNeg3 = mathj.round(Number(tempLimObjDiameter.T3ActualNeg), dp).toFixed(dp);
        DiamPos3 = mathj.round(Number(tempLimObjDiameter.T3ActualPos), dp).toFixed(dp);

      } else if (tempLimObjlength != undefined) {
        //length
        BLNom = mathj.round(Number(tempLimObjlength.Nom), dp).toFixed(dp);
        BLNeg1 = mathj.round(Number(tempLimObjlength.T1ActualNeg), dp).toFixed(dp);
        BLPos1 = mathj.round(Number(tempLimObjlength.T1ActualPos), dp).toFixed(dp);
        BLNeg2 = mathj.round(Number(tempLimObjlength.T2ActualNeg), dp).toFixed(dp);
        BLPos2 = mathj.round(Number(tempLimObjlength.T2ActualPos), dp).toFixed(dp);
        BLNeg3 = mathj.round(Number(tempLimObjlength.T3ActualNeg), dp).toFixed(dp);
        BLPos3 = mathj.round(Number(tempLimObjlength.T3ActualPos), dp).toFixed(dp);
      } else if (tempLimObjBreadth != undefined) {
        BLNom = mathj.round(Number(tempLimObjBreadth.Nom), dp).toFixed(dp);
        BLNeg1 = mathj.round(Number(tempLimObjBreadth.T1ActualNeg), dp).toFixed(dp);
        BLPos1 = mathj.round(Number(tempLimObjBreadth.T1ActualPos), dp).toFixed(dp);
        BLNeg2 = mathj.round(Number(tempLimObjBreadth.T2ActualNeg), dp).toFixed(dp);
        BLPos2 = mathj.round(Number(tempLimObjBreadth.T2ActualPos), dp).toFixed(dp);
        BLNeg3 = mathj.round(Number(tempLimObjBreadth.T3ActualNeg), dp).toFixed(dp);
        BLPos3 = mathj.round(Number(tempLimObjBreadth.T3ActualPos), dp).toFixed(dp);
      } else {
        BLNom = "NA";
        BLNeg1 = "NA";
        BLPos1 = "NA";
        BLNeg2 = "NA";
        BLPos2 = "NA";
        BLNeg3 = "NA";
        BLPos3 = "NA";
      }

      if (tempLimObjThickness != undefined) {
        thicknessNom = mathj.round(Number(tempLimObjThickness.Nom), dp).toFixed(dp);
        thicknesneg1 = mathj.round(Number(tempLimObjThickness.T1ActualNeg), dp).toFixed(dp);
        thicknespos1 = mathj.round(Number(tempLimObjThickness.T1ActualPos), dp).toFixed(dp);
        thicknesneg2 = mathj.round(Number(tempLimObjThickness.T2ActualNeg), dp).toFixed(dp);
        thicknespos2 = mathj.round(Number(tempLimObjThickness.T2ActualPos), dp).toFixed(dp);
        thicknesneg3 = mathj.round(Number(tempLimObjThickness.T3ActualNeg), dp).toFixed(dp);
        thicknespos3 = mathj.round(Number(tempLimObjThickness.T3ActualPos), dp).toFixed(dp);
      } else {
        thicknessNom = "NA";
        thicknesneg1 = "NA";
        thicknespos1 = "NA";
        thicknesneg2 = "NA";
        thicknespos2 = "NA";
        thicknesneg3 = "NA";
        thicknespos3 = "NA";
      }
      var res = await proObj.productData(hmiDetailsInPMenu);
      var check_master_SRno = await check_srNO.check_master_SRno(dataObj, hmiDetailsInPMenu, strHmi, hardnessDetail.Hardness, dataObj.strTableName, side)

      let insertHardness = await models[dataObj.mstTableName].create({
        MstSerNo: check_master_SRno,
        WgmtModeNo: 7,
        ProductType: 1,
        Area: hmiDetailsInPMenu.Sys_Area,
        CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
        CubicleName: hmiDetailsInPMenu.Sys_CubicName,
        CubicleType: hmiDetailsInPMenu.Sys_CubType,
        IPQCType: hmiDetailsInPMenu.Sys_IPQCType,
        // CoatingType: '',
        MachineCode: hmiDetailsInPMenu.Sys_MachineCode,
        Department: hmiDetailsInPMenu.Sys_dept,
        BFGCode: dataObj.objProductDetails.ProductId,
        ProductName: dataObj.objProductDetails.ProductName,
        PVersion: hmiDetailsInPMenu.Sys_PVersion,
        Version: hmiDetailsInPMenu.Sys_Version,
        BatchNo: hmiDetailsInPMenu.Sys_Batch,
        BatchSize: hmiDetailsInPMenu.Sys_BatchSize,
        BMRNo: 0,
        GraphType: tempLimObjHardness.isonstd,
        Qty: dataObj.objProductDetails.noOfSample,
        // GrpQty: '',
        // GrpFreq: '',
        Stage: hmiDetailsInPMenu.Sys_Stage,
        Idsno: strHmi,
        HardnessID: CurrentCubical.Sys_HardID,
        UserId: arrUsers.UserId,
        UserName: arrUsers.UserName,
        PrDate: moment().format("YYYY-MM-DD"),
        PrTime: moment().format("HH:mm:ss"),
        PrEndDate: moment().format("YYYY-MM-DD"),
        PrEndTime: moment().format("HH:mm:ss"),
        Side: dataObj.objProductDetails.Side,
        // SideNo: '',
        BLName: colHeadDolobo,
        Unit: tempLimObjHardness.unit,
        DecimalPoint: 2,
        // LimitOn: '',
        // BLName: '',
        Nom_stdtarget: HardNom,
        NomThick: thicknessNom,
        // NomDiam: DiamNom,
        // NomBL: BLNom,
        NomBL: DiamNom != undefined ? DiamNom : BLNom,
        T1NegTolHard: HardNeg1,
        T1PosTolHard: HardPos1,
        // T2NegTolHard: HardNeg1,
        // T2PosTolHard: HardPos1,
        T1NegTolThick: thicknesneg1,
        T1PosTolThick: thicknespos1,
        // T1NegTolDiam: DiamNeg1,
        // T1PosTolDiam: DiamPos1,
        // T1NegTolBL: BLNeg1,
        // T1PosTolBL: BLPos1,
        T1NegTolBL: DiamNeg1 != undefined ? DiamNeg1 : BLNeg1,
        T1PosTolBL: DiamPos1 != undefined ? DiamPos1 : BLPos1,
        // T1NegTolActualHard: HardNeg1,
        // T1PosTolActualHard: HardPos1,
        // T1NegTolActualThick: 0,
        // T1PosTolActualThick: 0,
        // T1NegTolActualDiam: 0,
        // T1PosTolActualDiam: 0,
        // T1NegTolActualBL: 0,
        // T1PosTolActualBL: 0,
        T1NegTolActualHard: HardNeg1,
        T1PosTolActualHard: HardPos1,
        T1NegTolActualThick: thicknesneg1,
        T1PosTolActualThick: thicknespos1,
        // T1NegTolActualDiam: DiamNeg1,
        // T1PosTolActualDiam: DiamPos1,
        // T1NegTolActualBL: BLNeg1,
        // T1PosTolActualBL: ,
        T1NegTolActualBL: DiamNeg1 != undefined ? DiamNeg1 : BLNeg1,
        T1PosTolActualBL: DiamPos1 != undefined ? DiamPos1 : BLPos1,
        ReportType: hmiDetailsInPMenu.Sys_RptType,
        // PrintNo: '',
        // IsArchived: '',
        // BatchComplete: '',
        // CheckedByID: '',
        // CheckedByName: '',
        // CheckedByDate: '',
        Lot: dataObj.objProductDetails.lotno,
        AvgHard: "NULL",
        AvgThick: "NULL",
        // AvgDiam: "NULL",
        AvgBL: "NULL",
        MinWeightHard: "NULL",
        MaxWeightHard: "NULL",
        MinWeightThick: "NULL",
        MaxWeightThick: "NULL",
        // MinWeightDiam: "NULL",
        // MaxWeightDiam: "NULL",
        MinWeightBL: "NULL",
        MaxWeightBL: "NULL",
        StdDevHard: "NULL",
        StdDevThick: "NULL",
        // StdDevDiam: "NULL",
        StdDevBL: "NULL",

        // FailedRemark: 0,
        FailedRemarkTSH: 0,
        Inprocess: 1,
        LayerName: 0,
        Nom_stdtarget: HardNom,
        T2NegTolHard: HardNeg1,
        T2PosTolHard: HardPos1,
        T2NegTolThick: thicknesneg2,
        T2PosTolThick: thicknespos2,
        // T2NegTolDiam: DiamNeg2,
        // T2PosTolDiam: DiamPos2,
        T2NegTolBL: BLNeg2 != undefined ? BLNeg2 : DiamNeg2,
        T2PosTolBL: BLPos2 != undefined ? BLPos2 : DiamPos2,

        T2NegTolActualHard: HardNeg1,
        T2PosTolActualHard: HardPos1,
        // T2NegTolActualThick: 0,
        // T2PosTolActualThick: 0,
        // T2NegTolActualDiam: 0,
        // T2PosTolActualDiam: 0,
        // T2NegTolActualBL: 0,
        // T2PosTolActualBL: 0,
        // StdLimit1: res[1]["Param7_T1Neg"],
        // StdLimit2: res[1]["Param7_T1Pos"],
        // T2NegTolActualHard: HardNeg2,
        // T2PosTolActualHard: HardPos2,
        T2NegTolActualThick: thicknesneg2,
        T2PosTolActualThick: thicknespos2,
        // T2NegTolActualDiam: DiamNeg2,
        // T2PosTolActualDiam: DiamPos2,
        T2NegTolActualBL: BLNeg2 != undefined ? BLNeg2 : DiamNeg2,
        T2PosTolActualBL: BLPos2 != undefined ? BLPos2 : DiamPos2,

        T3NegTolHard: HardNeg3,
        T3PosTolHard: HardPos3,
        T3NegTolThick: thicknesneg3,
        T3PosTolThick: thicknespos3,
        // T3NegTolDiam: DiamNeg3,
        // T3PosTolDiam: DiamPos3,
        T3NegTolBL: BLNeg3 != undefined ? BLNeg3 : DiamNeg3,
        T3PosTolBL: BLPos3 != undefined ? BLPos3 : DiamPos3,
        T3NegTolActualHard: "NA",
        T3PosTolActualHard: "NA",
        T3NegTolActualThick: "NA",
        T3PosTolActualThick: "NA",
        T3NegTolActualDiam: "NA",
        T3PosTolActualDiam: "NA",
        T3NegTolActualBL: "NA",
        T3PosTolActualBL: "NA",
        // T3NegTolActualHard: HardNeg3,
        // T3PosTolActualHard: HardPos3,
        // T3NegTolActualThick: thicknesneg3,
        // T3PosTolActualThick: thicknespos3,
        // T3NegTolActualDiam: doloboNeg3,
        // T3PosTolActualDiam: doloboPos3,
        // T3NegTolActualBL: doloboNeg3,
        // T3PosTolActualBL: doloboPos3,
        Layer: "NA",
        CheckedByTime: moment().format('HH:mm:ss'),
      });
      await models.tbl_powerbackup.create({
        CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
        WeighmentType: "T",
        WeighmentName: mqttProtocol.Hardness,
        ProductType: dataObj.productType.ProductType,
        Userid: dataObj.objProductDetails.userId,
        ReportType: CurrentCubical.Sys_RptType,
        Incomp_RepSerNo: insertHardness.dataValues.RepSerNo,
        EntryTimeStamp: moment().format("YYYY-MM-DD HH:mm:ss"),
        Idsno: strHmi,
        Sys_CubType: hmiDetailsInPMenu.Sys_CubType,
        Sys_BFGCode: dataObj.objProductDetails.ProductId,
        Sys_Batch: hmiDetailsInPMenu.Sys_Batch,
        Instrument_Model: CurrentCubical.Sys_HardID,
        TableType: colHeadDolobo,
        RecSampleNo: counter,
        SelectedIds: selectedIds,
        Side_RepSerNo: 0

      });

      return insertHardness.dataValues.RepSerNo;
    } catch (error) {
      throw new Error(error);
    }
  }

  precision(a) {
    if (!isFinite(a)) return 0;
    var e = 1,
      p = 0;
    while (Math.round(a * e) / e !== a) {
      e *= 10;
      p++;
    }
    return p;
  }

  async updatemasterTable(repSerNo, powerBackup, mstTableName, DetTableName, strIdsNo) {
    try {

      var avgHardDp = 1;
      var stdDevDp = 4;
      var dp = 2;
      var hardDp = 0;
      var masterData = await models[mstTableName].findOne({
        where: {
          RepSerNo: repSerNo,
        },
      });

      let menuDetail = globalData.arr_limits.find((k) => k.idsNo == strIdsNo);

      let hardnessMenu = menuDetail.Menus.find(item => item.Hardness);

      if (hardnessMenu) {
        let columnDetail = hardnessMenu.Hardness.columnDetail;

        var hasThickness = columnDetail.some(item => 'Thickness' in item);
        var hasHardness = columnDetail.some(item => 'Hardness' in item);
        var hasLength = columnDetail.some(item => 'Length' in item);
        var hasDiameter = columnDetail.some(item => "Diameter" in item);
        var hasBreadth = columnDetail.some(item => "Breadth" in item);

      }

      let nomHard = masterData.Nom_stdtarget;
      let nomThick = masterData.NomThick;
      // let nomDiam = masterData.NomDiam;
      let nomBL = masterData.NomBL;


      var detailData = await models[DetTableName].findAll({
        where: {
          RepSerNo: repSerNo,
        },
      });
      // let count = DetailData.length;
      var above_flag = 0
      var below_flag = 0
      // for (var i = 0; i < detailData.length; i++) {
      //   var dataValHard = parseFloat(detailData[i].DataValueHard);
      //   if (Number(masterData.T1NegTolHard) !== 0 && Number(masterData.T1NegTolHard) !== 99999 && Number(masterData.T1NegTolHard) > Number(dataValHard)) {
      //     below_flag = below_flag + 1;
      //   }
      //   if (Number(masterData.T1PosTolHard) !== 0 && Number(masterData.T1PosTolHard) !== 99999 && Number(dataValHard) > Number(masterData.T1PosTolHard)) {
      //     above_flag = above_flag + 1;
      //   }
      // }
      //find Master Data
      var MasterData = await models[mstTableName].findAll({
        where: {
          RepSerNo: repSerNo,
        },
      });

      if (masterData.AvgHard == "NULL" || (masterData.AvgHard !== "NULL" && masterData.AvgHard !== "NA") && hasHardness == true) {

        let hardFilterNa = detailData.filter(e => {
          const val = e.DataValueHard;
          return val === "NA" || val === "FL" || val === "--" || val === "fl" || (val) > 999;
        });

        if (hardFilterNa.length == 0) {

          let hardFilterNa = detailData.filter(e => e.DataValueHard != "NA")
          var avgHard = mathj
            .round(mathj.mean([...hardFilterNa.map((k) => k.DataValueHard)]), avgHardDp)
            .toFixed(avgHardDp);
          var minHard = mathj
            .round(mathj.min([...hardFilterNa.map((k) => k.DataValueHard)]), hardDp)
            .toFixed(hardDp);
          var maxHard = mathj
            .round(mathj.max([...hardFilterNa.map((k) => k.DataValueHard)]), hardDp)
            .toFixed(hardDp);
          // var stdHardDeviation = mathj
          //   .round(mathj.std([...detailData.map((k) => k.DataValue)]), 1)
          //   .toFixed(4);
          var stdHardDeviation = mathj.std([...hardFilterNa.map((k) => k.DataValueHard)]).toFixed(stdDevDp);

          var minPer_value = ((nomHard - minHard) / nomHard) * 100;
          minPer_value = (minPer_value).toString().includes('-') ? (minPer_value).toString().split('-')[1] : minPer_value;
          minPer_value = mathj.abs(minPer_value).toFixed(2);
          var maxPer_value = ((nomHard - maxHard) / nomHard) * 100;
          maxPer_value = (maxPer_value).toString().includes('-') ? (maxPer_value).toString().split('-')[1] : maxPer_value;
          maxPer_value = mathj.abs(maxPer_value).toFixed(2);

          var remarkHard = hardFilterNa.some((k) => ((Number(masterData.T1NegTolActualHard) !== 0 && Number(masterData.T1NegTolActualHard) !== 99999 && Number(masterData.T1NegTolActualHard) > Number(k.DataValueHard))) || (Number(masterData.T1PosTolActualHard) !== 0 && Number(masterData.T1PosTolActualHard) !== 99999 && Number(k.DataValueHard) > Number(masterData.T1PosTolActualHard)));

          remarkHard = remarkHard === true ? "Not Complies" : "Complies";
        }
        else {

          avgHard = "NA";
          minHard = "NA";
          maxHard = "NA";
          stdHardDeviation = "NA";
          minPer_value = "NA";
          maxPer_value = "NA";
          remarkHard = "NA"
        }

      }
      else if (hasHardness == false) {
        avgHard = "NA";
        minHard = "NA";
        maxHard = "NA";
        stdHardDeviation = "NA";
        minPer_value = "NA";
        maxPer_value = "NA";
      }
      // arrHTDetail.push(dataValHard);


      // var avgThick = "NA";
      // var minThick = "NA";
      // var maxThick = "NA";
      // var stdThickDeviation = "NA";
      // var avgPara = "NA";
      // var minPara = "NA";
      // var maxPara = "NA";
      // var stdParaDeviation = "NA";
      // var remarkDiam = "NA";
      // var remarkBL = "NA";
      // var remarkThick = "NA";

      // let thickFilterNa = detailData.filter(e => e.DataValueThick == "NA")

      if (masterData.AvgThick == "NULL" || (masterData.AvgThick !== "NULL" && masterData.AvgThick !== "NA") && hasThickness == true) {

        let thickFilterNa = detailData.filter(e => {
          const val = e.DataValueThick;
          return val === "NA" || val === "FL" || val === "--" || val === "fl" || (val) > 999;
        });

        if (thickFilterNa.length == 0) {
          var avgThick = mathj
            .round(mathj.mean([...detailData.map((k) => k.DataValueThick)]), dp)
            .toFixed(dp);
          var minThick = mathj
            .round(mathj.min([...detailData.map((k) => k.DataValueThick)]), dp)
            .toFixed(dp);
          var maxThick = mathj
            .round(mathj.max([...detailData.map((k) => k.DataValueThick)]), dp)
            .toFixed(dp);
          var stdThickDeviation = mathj
            .round(mathj.std([...detailData.map((k) => k.DataValueThick)]), stdDevDp)
            .toFixed(stdDevDp);

          var minPer_Thick = ((nomThick - minThick) / nomThick) * 100;
          minPer_Thick = (minPer_Thick).toString().includes('-') ? (minPer_Thick).toString().split('-')[1] : minPer_Thick;
          minPer_Thick = mathj.abs(minPer_Thick).toFixed(2);
          var maxPer_Thick = ((nomThick - maxThick) / nomThick) * 100;
          maxPer_Thick = (maxPer_Thick).toString().includes('-') ? (maxPer_Thick).toString().split('-')[1] : maxPer_Thick;
          maxPer_Thick = mathj.abs(maxPer_Thick).toFixed(2);

          var remarkThick = detailData.some((k) => Number(masterData.T2NegTolThick) > Number(k.DataValueThick) || Number(k.DataValueThick) > Number(masterData.T2PosTolThick));

          remarkThick = remarkThick === true ? "Not Complies" : "Complies";
        }
        else {
          avgThick = "NA";
          minThick = "NA";
          maxThick = "NA";
          stdThickDeviation = "NA";
          minPer_Thick = "NA";
          maxPer_Thick = "NA";
          remarkThick = "NA"
        }
      }
      else if (hasThickness == false) {
        avgThick = "NA";
        minThick = "NA";
        maxThick = "NA";
        stdThickDeviation = "NA";
        minPer_Thick = "NA";
        maxPer_Thick = "NA";
        remarkThick = "NA"
      }




      if (powerBackup[0].TableType === 'Diameter') {

        if (masterData.AvgBL == "NULL" || (masterData.AvgBL !== "NULL" && masterData.AvgBL !== "NA") && hasDiameter == true) {

          let diamFilterNa = detailData.filter(e => {
            const val = e.DataValueBL;
            return val === "NA" || val === "FL" || val === "--" || val === "fl" || (val) > 999;
          });

          if (diamFilterNa.length == 0) {
            var avgPara = mathj
              .round(mathj.mean([...detailData.map((k) => k.DataValueBL)]), dp)
              .toFixed(dp);
            var minPara = mathj
              .round(mathj.min([...detailData.map((k) => k.DataValueBL)]), dp)
              .toFixed(dp);
            var maxPara = mathj
              .round(mathj.max([...detailData.map((k) => k.DataValueBL)]), dp)
              .toFixed(dp);
            var stdParaDeviation = mathj
              .round(mathj.std([...detailData.map((k) => k.DataValueBL)]), stdDevDp)
              .toFixed(stdDevDp);

            var minPer_Diam = ((nomBL - minPara) / nomBL) * 100;
            minPer_Diam = (minPer_Diam).toString().includes('-') ? (minPer_Diam).toString().split('-')[1] : minPer_Diam;
            minPer_Diam = mathj.abs(minPer_Diam).toFixed(2);
            var maxPer_Diam = ((nomBL - maxPara) / nomBL) * 100;
            maxPer_Diam = (maxPer_Diam).toString().includes('-') ? (maxPer_Diam).toString().split('-')[1] : maxPer_Diam;
            maxPer_Diam = mathj.abs(maxPer_Diam).toFixed(2);

            //  var remarkDiam = detailData.some((k) => Number(masterData.T2NegTolDiam) > Number(k.DataValueDiam) || Number(k.DataValueDiam) > Number(masterData.T2PosTolDiam));

            var remarkDiam = detailData.some((k) => Number(masterData.T2NegTolBL) > Number(k.DataValueBL) || Number(k.DataValueBL) > Number(masterData.T2PosTolBL));

            remarkDiam = remarkDiam === true ? "Not Complies" : "Complies";
          }
          else {
            avgPara = "NA";
            minPara = "NA";
            maxPara = "NA";
            stdParaDeviation = "NA";
            minPer_Diam = "NA";
            maxPer_Diam = "NA";
            remarkDiam = "NA"
          }

        }
        else if (hasDiameter == false) {
          avgPara = "NA";
          minPara = "NA";
          maxPara = "NA";
          stdParaDeviation = "NA";
          minPer_Diam = "NA";
          maxPer_Diam = "NA";
          remarkDiam = "NA"

        }
      }
      else {

        if (masterData.AvgBL == "NULL" || (masterData.AvgBL !== "NULL" && masterData.AvgBL !== "NA") && (hasBreadth == true || hasLength == true)) {

          let blFilterNa = detailData.filter(e => {
            const val = e.DataValueBL;
            return val === "NA" || val === "FL" || val === "--" || val === "fl" || (val) > 999;
          });


          // let blFilterNa = detailData.filter(e => e.DataValueBL == "NA")
          if (blFilterNa.length == 0) {
            var avgPara = mathj
              .round(mathj.mean([...detailData.map((k) => k.DataValueBL)]), dp)
              .toFixed(dp);
            var minPara = mathj
              .round(mathj.min([...detailData.map((k) => k.DataValueBL)]), dp)
              .toFixed(dp);
            var maxPara = mathj
              .round(mathj.max([...detailData.map((k) => k.DataValueBL)]), dp)
              .toFixed(dp);
            var stdParaDeviation = mathj
              .round(mathj.std([...detailData.map((k) => k.DataValueBL)]), stdDevDp)
              .toFixed(stdDevDp);

            var minPer_BL = ((nomBL - minPara) / nomBL) * 100;
            minPer_BL = (minPer_BL).toString().includes('-') ? (minPer_BL).toString().split('-')[1] : minPer_BL;
            minPer_BL = mathj.abs(minPer_BL).toFixed(2);
            var maxPer_BL = ((nomBL - maxPara) / nomBL) * 100;
            maxPer_BL = (maxPer_BL).toString().includes('-') ? (maxPer_BL).toString().split('-')[1] : maxPer_BL;
            maxPer_BL = mathj.abs(maxPer_BL).toFixed(2);

            var remarkBL = detailData.some((k) => Number(masterData.T2NegTolBL) > Number(k.DataValueBL) || Number(k.DataValueBL) > Number(masterData.T2PosTolBL));

            remarkBL = remarkBL === true ? "Not Complies" : "Complies";
          }
          else {
            avgPara = "NA";
            minPara = "NA";
            maxPara = "NA";
            stdParaDeviation = "NA";
            minPer_BL = "NA";
            maxPer_BL = "NA";
            remarkBL = "NA";
          }
        }
        else if (hasBreadth == false || hasLength == false) {
          avgPara = "NA";
          minPara = "NA";
          maxPara = "NA";
          stdParaDeviation = "NA";
          minPer_BL = "NA";
          maxPer_BL = "NA";
          remarkBL = "NA";
        }
      }

      await models[mstTableName].update(
        {
          MinPerHard: minPer_value,
          MaxPerHard: maxPer_value,
          MinPerThick: minPer_Thick,
          MaxPerThick: maxPer_Thick,
          // MinPerDiam:minPer_Diam,
          // MaxPerDiam:maxPer_Diam,
          // MinPerBL:minPer_BL,
          // MaxPerBL:maxPer_BL,
          MinPerBL: minPer_Diam ?? minPer_BL,
          MaxPerBL: maxPer_Diam ?? maxPer_BL,
          AvgHard: avgHard,
          AvgThick: avgThick,
          // AvgDiam: powerBackup[0].TableType === "Diameter" ? avgPara : "NA",
          // AvgBL: powerBackup[0].TableType === "Length" ? avgPara : "NA",
          AvgBL: powerBackup[0].TableType === "Length" ? avgPara : powerBackup[0].TableType === "Diameter" ? avgPara : "NA",
          MinWeightHard: minHard,
          MaxWeightHard: maxHard,
          MinWeightThick: minThick,
          MaxWeightThick: maxThick,
          // MinWeightDiam: powerBackup[0].TableType === "Diameter" ? minPara : "NA",
          // MaxWeightDiam: powerBackup[0].TableType === "Diameter" ? maxPara : "NA",
          // MinWeightBL: powerBackup[0].TableType === "Length" ? minPara : "NA",
          // MaxWeightBL: powerBackup[0].TableType === "Length" ? maxPara : "NA",
          MinWeightBL: powerBackup[0].TableType === "Length" ? minPara : powerBackup[0].TableType === "Diameter" ? minPara : "NA",
          MaxWeightBL: powerBackup[0].TableType === "Length" ? maxPara : powerBackup[0].TableType === "Diameter" ? maxPara : "NA",
          StdDevHard: stdHardDeviation,
          StdDevThick: stdThickDeviation,
          // StdDevDiam: powerBackup[0].TableType === "Diameter" ? stdParaDeviation : "NA",
          // StdDevBL: powerBackup[0].TableType === "Length" ? stdParaDeviation : "NA",
          StdDevBL: powerBackup[0].TableType === "Length" || powerBackup[0].TableType === "Diameter" ? stdParaDeviation : "NA",
          RemarkHard: remarkHard,
          // NoOfAbove2: above_flag,
          // NoOfBelow2: below_flag,
          RemarkThick: remarkThick,
          // RemarkDiam: remarkDiam,
          // RemarkBL: remarkBL,
          RemarkBL: remarkDiam != undefined ? remarkDiam : remarkBL,
        },
        {
          where: {
            RepSerNo: repSerNo,
          },
        }
      );
    } catch (err) {
      console.log(err)
      throw new Error(err);
    }
  }

  // Function to check for invalid fields in the data
  // async checkForInvalidFields(dataArray) {
  //   // List of invalid values to check
  //   const invalidValues = ['NA', 'FL', '--'];

  //   // Function to check if a value is invalid
  //   const isInvalid = (value) => {
  //     return invalidValues.includes(value) || parseFloat(value) > 999;
  //   };

  //   // Function to check each individual field for invalid values
  //   const checkInvalidFields = (dataArray) => {
  //     return dataArray.map(item => {
  //       const invalidFields = [];

  //       // Check if DataValueHard is invalid
  //       if (isInvalid(item.DataValueHard)) {
  //         invalidFields.push('DataValueHard');
  //       }

  //       // Check if DataValueThick is invalid
  //       if (isInvalid(item.DataValueThick)) {
  //         invalidFields.push('DataValueThick');
  //       }

  //       // Check if DataValueDiam is invalid
  //       if (isInvalid(item.DataValueDiam)) {
  //         invalidFields.push('DataValueDiam');
  //       }

  //       // Return the item with the invalid fields
  //       if (invalidFields.length > 0) {
  //         return { ...item, invalidFields };
  //       } else {
  //         return null;
  //       }
  //     }).filter(item => item !== null); // Filter out nulls where no invalid fields were found
  //   };

  //   // Get all objects with invalid fields
  //   const invalidDataValues = checkInvalidFields(dataArray);

  //   // Return the result
  //   return invalidDataValues;
  // }

  // async updateInvalidFields(dataArray, updateObject) {
  //   // Iterate over each data item
  //   dataArray.forEach(item => {
  //     // Check if DataValueHard is in invalidFields
  //     if (item.invalidFields.includes('DataValueHard')) {
  //       // Update the AvgHard value in the updateObject
  //       updateObject.AvgHard = 'NA'; 
  //       updateObject.MinWeightHard = 'NA';
  //       updateObject.MaxWeightHard = 'NA';
  //       updateObject.StdDevHard = 'NA';
  //       updateObject.MinPerHard = 'NA';
  //       updateObject.MaxPerHard = 'NA';
  //       // Update AvgHard to "NA"
  //       console.log(`Updated AvgHard to 'NA' for RecNo: ${item.RecNo}`);
  //     }

  //     // Check if DataValueThick is in invalidFields
  //     if (item.invalidFields.includes('DataValueThick')) {
  //       // Update the AvgThick value in the updateObject
  //       updateObject.AvgThick = 'NA';  // Update AvgThick to "NA"
  //       updateObject.MinWeightThick = 'NA';
  //       updateObject.MaxWeightThick = 'NA';
  //       updateObject.StdDevThick = 'NA';
  //       updateObject.MinPerThick = 'NA';
  //       updateObject.MaxPerThick = 'NA';
  //       console.log(`Updated AvgThick to 'NA' for RecNo: ${item.RecNo}`);
  //     }

  //     // Check if DataValueDiam is in invalidFields
  //     if (item.invalidFields.includes('DataValueDiam')) {
  //       // Update the AvgDiam value in the updateObject
  //       updateObject.AvgDiam = 'NA';  // Update AvgDiam to "NA"
  //       updateObject.MinWeightDiam = 'NA';
  //       updateObject.MaxWeightDiam = 'NA';
  //       updateObject.StdDevDiam = 'NA';
  //       updateObject.MinPerDiam = 'NA';
  //       updateObject.MaxPerDiam = 'NA';
  //       console.log(`Updated AvgDiam to 'NA' for RecNo: ${item.RecNo}`);
  //     }

  //     // Check if DataValueBL is in invalidFields (for this example, assume this field can also be invalid)
  //     if (item.invalidFields.includes('DataValueBL')) {
  //       // Update the AvgBL value in the updateObject
  //       updateObject.AvgBL = 'NA';  // Update AvgBL to "NA"
  //       updateObject.MinWeightBL = 'NA';
  //       updateObject.MaxWeightBL = 'NA';
  //       updateObject.StdDevBL = 'NA';
  //       updateObject.MinPerBL = 'NA';
  //       updateObject.MaxPerBL = 'NA';
  //       console.log(`Updated AvgBL to 'NA' for RecNo: ${item.RecNo}`);
  //     }
  //   });

  //   // Return the updated object
  //   return updateObject;
  // }





}

module.exports = HardnessModel;