const globalData = require("../../global/globalData");
const clsCommonInsertOpt = require("../Product/clsCommonInsertOperation.model");
const clsIncompleteReport = require("../Product/clsIncompleteReport");
const clsActivityLog = require("../clsActivityLog.model");
const clsInstrumentUsage = require("../clsInstrumentUsageLog");
const FormulaFunModel = require("../Product/clsformulaFun.model");
const mqttProtocol = require("../../global/GLOBAL_NOMENCLATURE");
const MqttModel = require("../Mqtt/mqttSender.class");
const Database = require("../../database/clsQueryProcess");
const clsCommonUseFunction = require("../clsCommonUseFunction");
const GLOBAL_NOMENCLATURE = require("../../global/GLOBAL_NOMENCLATURE");
const PowerBackup = require("../../Utills/powerBackUp/powerbackup");
const models = require("../../../config/dbConnection").models;
const sequelize = require("../../../config/dbConnection").sequelize;
const { QueryTypes } = require("sequelize");

const database = new Database();
const objIncompleteReport = new clsIncompleteReport();
const objCommonInsertOpt = new clsCommonInsertOpt();
const objActivityLog = new clsActivityLog();
const objInstrumentUsage = new clsInstrumentUsage();
const objformulaFun = new FormulaFunModel();
const mqttSender = new MqttModel();
const objCommonUseFunc = new clsCommonUseFunction();
const objPowerBackup = new PowerBackup();

class EmptyShell {
  async processEmptyShellData(__parameterObj) {
    try {
      let strHmi = __parameterObj.Hmi;
      let strIdsNo = __parameterObj.idsNo;
      let actualWt = __parameterObj.actualWt;
      let unit = __parameterObj.unit;
      let ProtocolPortNo = __parameterObj.ProtocolPortNo;
      const strMenuName = __parameterObj.menuName;
      let objResIndividualActivity;
      let objResIndividual;
      let objActivity = {};
      let typeValue;
      let outFlag = 0;
      let reportLimitMsg = "Report generated is Within limit";
      let minLimitT2;
      let maxLimitT2;
      let maxLimitT1;
      let minLimitT1;
      let masterTable;
      let detailTable;

      // const menuDetailsArr = globalData.arr_limits.find(k => k.Hmi == strHmi);
      let individualDetail = globalData.arrWeighmentProductData.find(
        (k) => k.Hmi == strHmi
      );

      let objSelMenu = globalData.arrSelectedMenu.find(
        (k) => k.idsNo == strIdsNo
      );
      let sample = parseFloat(individualDetail.data.noOfSample);
      let batchNo = individualDetail.data.Batch;
      //let menuDetail = menuDetailsArr.Menus.filter(obj => Object.keys(obj) == strMenuName)[0][strMenuName];
      let selectedIdsNo;
      var IPQCObject = globalData.arr_IPQCRelIds.find(
        (k) => k.idsNo == strIdsNo
      );
      if (IPQCObject != undefined) {
        selectedIdsNo = IPQCObject.selectedIds;
      } else {
        selectedIdsNo = strIdsNo;
      }
      // let productDetail = globalData.arrProductTypeArray.find(k => k.Hmi == strHmi).productType;
      switch (strMenuName) {
        case `${GLOBAL_NOMENCLATURE.EmptyShell}`:
          masterTable = models.tbl_tab_master19;
          detailTable = models.tbl_tab_detail19;
          typeValue = 1;
          maxLimitT1 = objformulaFun.upperLimit(
            objSelMenu.selectedProductDetail,
            "T1"
          );
          maxLimitT2 = objformulaFun.upperLimit(
            objSelMenu.selectedProductDetail
          );
          minLimitT2 = objformulaFun.lowerLimit(
            objSelMenu.selectedProductDetail
          );
          minLimitT1 = objformulaFun.lowerLimit(
            objSelMenu.selectedProductDetail,
            "T1"
          );
          break;
      }
      let tempCounterObj = globalData.arrWeighmentCounter.find(
        (k) => k.Hmi == strHmi
      );
      if (tempCounterObj === undefined) {
        globalData.arrWeighmentCounter.push({ Hmi: strHmi, counter: 0 });
      }
      tempCounterObj = globalData.arrWeighmentCounter.find(
        (k) => k.Hmi == strHmi
      );
      // globalData.arrUserRights
      let tempUserObject = globalData.arrUsers.find((k) => k.Hmi == strHmi);
      // console.log(tempUserObject);
      let __parameterIndividual = {
        strTableName: masterTable,
        strDetailTbl: detailTable,
        objProductDetails: individualDetail.data,
        uniqueSerialNumber: strIdsNo,
        strBalId: __parameterObj.instrumentId,
        ProtocolData: __parameterObj.actualWt,
        ProtocolUnit: __parameterObj.unit,
        ProtocolDecPoint: __parameterObj.decPoint,
        strHmi: strHmi,
        seqNoOfWt: tempCounterObj.counter,
        productType: objSelMenu.selectedProductDetail,
      };
      let decimal;
      let _cubicalData = globalData.arrIdsInfo.find(
        (k) => k.idsNo == strIdsNo
      ).cubicalData;

      if (sample >= tempCounterObj.counter) {
        tempCounterObj.counter += 1;

        /**
         * call powerbackup function to check that test is pending or not if for that user then
         * ask user to continue the test or start test from new.
         * call function from powerbackup
         */
        let powerbackupobj = {
          strTableName: masterTable.tableName,
          strDetailTbl: detailTable.tableName,
          cubicaNo: _cubicalData.Sys_CubicNo,
          cubicType: _cubicalData.Sys_CubType,
          cubicSysBFGcode: _cubicalData.Sys_BFGCode,
          cubicBatch: _cubicalData.Sys_Batch,
          menuName: individualDetail.data.menuName,
          productType: objSelMenu.selectedProductDetail.ProductType,
          Userid: tempUserObject.UserId,
          idsNo: strIdsNo,
          Hmi: strHmi,
          Incomp_RepSerNo: tempCounterObj.counter,
        };

    
        let incompRepSerNo = await objPowerBackup.getStatusoFTestForPowerBackup(
          powerbackupobj
        );
        if (incompRepSerNo !== undefined) {
          tempCounterObj.counter = incompRepSerNo;
        }
        //   console.log(incompRepSerNo);

        const __ParamRemark = {
          idsNo: strIdsNo,
          menuName: strMenuName,
          batchNo: batchNo,
          tableName: masterTable,
        };

        if (tempCounterObj.counter == 1) {
          let __activityObj = {
            strUserId: tempUserObject.UserId,
            strUserName: tempUserObject.UserName,
            activity: `${strMenuName} Weighment Started on IDS ${strHmi}`,
          };

          await objActivityLog.ActivityLogEntry(__activityObj);
          // await objInstrumentUsage.InstrumentUsage('Balance',
          //     strIdsNo, 'tbl_instrumentlog_balance', strMenuName, 'started');

          await objCommonInsertOpt.insert_Into_Incomplete_Master(
            __parameterIndividual
          );
          // let TableName =  masterTable + "_incomplete"
          const insertRepoRemarkDetail =
            await models.tbl_remark_incomplete_master.create({
              IDSNo: strIdsNo,
              paramName: strMenuName,
              tableName: masterTable.name + "_incomplete",
              BatchNumber: batchNo,
            });
          // {
          //     str_tableName: 'tbl_remark_incomplete_master',
          //     data: [
          //         { str_colName: 'IDSNo', value: strIdsNo },
          //         { str_colName: 'paramName', value: strMenuName },
          //         { str_colName: 'tableName', value: masterTable + "_incomplete" },
          //         { str_colName: 'BatchNumber', value: batchNo }
          //     ]
          // }

          await insertRepoRemarkDetail;
          // insert into remark table
        }
        //insert data into detail table
        //console.log(tempCounterObj.counter);
        decimal = await objCommonInsertOpt.insert_Into_Incomplete_Detail(
          __parameterIndividual
        );

        let hmiEntryinConfig = globalData.arrConfigSettings.find(
          (k) => k.Hmi == strHmi
        ).configSetting;
        let autoTare = hmiEntryinConfig[0].AutoTare;
        let tareCommand = hmiEntryinConfig[0].Tare_Command.concat(`\r\n`);

        let sampleNo = tempCounterObj.counter;
        let limitObjResp = await objCommonUseFunc.SendCommon({
          strHmi,
          actualWt,
          minLimitT2,
          maxLimitT2,
          minLimitT1,
          maxLimitT1,
          strMenuName,
          sampleNo,
        });
        let color = limitObjResp.Color;
        let limit = limitObjResp.limit;

        mqttSender.sendData(
          strHmi,
          `${mqttProtocol.DisplayResult}${tempCounterObj.counter}:${Number(
            actualWt
          ).toFixed(decimal)} ${unit}:${color}`
        );

        if (autoTare) {
          mqttSender.sendData(
            strHmi,
            `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`
          );
        }

        mqttSender.sendData(strHmi, limit);
        // let __activityObj = {
        //     strUserId: tempUserObject.UserId,
        //     strUserName: tempUserObject.UserName,
        //     activity: `${strMenuName} Weighment Completed on HMI ${strHmi}`
        // }

        // await objActivityLog.ActivityLogEntry(__activityObj);
        // await objInstrumentUsage.InstrumentUsage('Balance',
        //     strIdsNo, 'tbl_instrumentlog_balance', strMenuName, 'complete');
      }

      //checking for t2 limit
      // if (parseFloat(actualWt) < parseFloat(minLimitT2) || parseFloat(actualWt) > parseFloat(maxLimitT2)) {
      //     outFlag += 1
      //     console.log('recived weight is out of t2 limit');
      //     mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} recivied weight is out of t2 limit`);

      // }
      // if (outFlag == 0 && parseFloat(maxLimitT1) != 0) {
      //     if (parseFloat(actualWt) < parseFloat(minLimitT1) || parseFloat(actualWt) > parseFloat(maxLimitT1)) {
      //         outFlag += 1
      //         mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} recivied weight is out of t1 limit`);
      //         console.log('recived weight is out of t1 limit');
      //     }
      // }

      if (Number(sample) == Number(tempCounterObj.counter)) {
        //move data from incomplete to complete
        //remove outOfLimit Flag
        //check nmt range
        //limit checking

        await objCommonInsertOpt.saveCompleteData(
          __parameterIndividual,
          typeValue
        );
        // await objCommonInsertOpt.updateEndDate(strIdsNo, strHmi, masterTable);

        const _deletePowerbackup = await models.tbl_powerbackup.destroy({
          where: {
            Idsno: strHmi,
            Sys_Batch: _cubicalData.Sys_Batch,
          },
        });
        // let result = await objIncompleteReport.getIncomepleteData(__parameterIndividual, __parameterIndividual.strTableName, __parameterIndividual.strDetailTbl, strIdsNo);

        Object.assign(
          objActivity,
          { strUserId: tempUserObject.UserId },
          { strUserName: tempUserObject.UserName },
          { activity: `${strMenuName} Weighment Completed on IDS ${strHmi}` }
        );
        objResIndividualActivity = await objActivityLog.ActivityLogEntry(
          objActivity
        );
        objResIndividual = await objInstrumentUsage.InstrumentUsage(
          "Balance",
          strIdsNo,
          "tbl_instrumentlog_balance",
          "",
          "completed"
        );
        console.log(tempCounterObj.counter);
        globalData.arrWeighmentCounter.findIndex((k) => k.Hmi == strHmi) == -1
          ? globalData.arrWeighmentCounter
          : globalData.arrWeighmentCounter.splice(
              globalData.arrWeighmentCounter.findIndex((k) => k.Hmi == strHmi),
              1
            );

        globalData.arrCurrentOperationStatus.findIndex(
          (element) => element.Hmi === strHmi
        ) == -1
          ? globalData.arrCurrentOperationStatus
          : globalData.arrCurrentOperationStatus.splice(
              globalData.arrCurrentOperationStatus.findIndex(
                (element) => element.Hmi === strHmi
              ),
              1
            );

        globalData.arrOutFlagForTest.findIndex(
          (element) => element.Hmi === strHmi
        ) == -1
          ? globalData.arrOutFlagForTest
          : globalData.arrOutFlagForTest.splice(
              globalData.arrOutFlagForTest.findIndex(
                (element) => element.Hmi === strHmi
              ),
              1
            );

        //test splice if rotarty is not double
        globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi) == -1
          ? globalData.arrSelectedMenu
          : globalData.arrSelectedMenu.splice(
              globalData.arrSelectedMenu.findIndex((k) => k.Hmi == strHmi),
              1
            );
        return mqttSender.sendData(
          strHmi,
          `${mqttProtocol.TestCompleted}${strMenuName} test Completed`
        );
      }
    } catch (error) {}

    if (autoTare) {
      mqttSender.sendData(
        strHmi,
        `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`
      );
    }
  }

  //checking for t2 limit
  // if (parseFloat(actualWt) < parseFloat(minLimitT2) || parseFloat(actualWt) > parseFloat(maxLimitT2)) {
  //     outFlag += 1
  //     console.log('recived weight is out of t2 limit');
  //     mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} recivied weight is out of t2 limit`);
}

// let result = await objIncompleteReport.getIncomepleteData(__parameterIndividual, __parameterIndividual.strTableName, __parameterIndividual.strDetailTbl, strIdsNo);


module.exports = EmptyShell;
