const date = require('date-and-time');

const globalData = require('../../global/globalData')
const clsActivityLog = require('../clsActivityLog.model');
const clsInstrumentUsage = require('../clsInstrumentUsageLog');
const clsCommonInsertOpt = require('../Product/clsCommonInsertOperation.model');
const clsMqttSender = require('../Mqtt/mqttSender.class');
const DataBase = require('../../database/clsQueryProcess');
const clsformulaFun = require('../Product/clsformulaFun.model');
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const clsCommonUseFunction = require('../clsCommonUseFunction');
const PowerBackup = require('../../Utills/powerBackUp/powerbackup');
const models = require('../../../config/dbConnection').models;
const sequelize = require('../../../config/dbConnection').sequelize;
const clsCalculation = require('../clsCalculationOperation');
const clsPrintOperations = require("../Print/clsPrintOperation")
const printOperations = new clsPrintOperations()
const objcalc = new clsCalculation();
const objActivityLog = new clsActivityLog();
const objInstrumentUsage = new clsInstrumentUsage();
const objCommonInsertOpt = new clsCommonInsertOpt();
const mqttSender = new clsMqttSender();
const database = new DataBase();
const objformulaFun = new clsformulaFun();
const objCommonUseFunc = new clsCommonUseFunction();
const clsMonit = require('../MonitorSocket/clsMonitSocket');
const objMonit = new clsMonit();

const objPowerBackup = new PowerBackup();


class BreadthModel {

    async processBreadthData(dataObj) {
        try {
            const strHmi = dataObj.Hmi;
            const strIdsNo = dataObj.idsNo;
            let actualWt = dataObj.actualWt;
            const menuName = dataObj.menuName;
            let typeValue;
            let minLimitT2;
            let maxLimitT2;
            let maxLimitT1;
            let minLimitT1;
            let objActivity = {};
            const BreadthDetail = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi);
            const objSelMenu = globalData.arrSelectedMenu.find(k => k.idsNo == strIdsNo);
            let batchNo = BreadthDetail.data.Batch;
            let sample = parseFloat(BreadthDetail.data.noOfSample);
            let tempCounterObj = globalData.arrWeighmentCounter.find(k => k.Hmi == strHmi);
            let tempUserObject = globalData.arrUsers.find(k => k.Hmi === strHmi);
            let strTableName, strDetailTbl;
            let outFlag = 0;
            let _cubicalData = globalData.arrIdsInfo.find(k => k.idsNo == strIdsNo).cubicalData;
            let tableName = "tbl_powerbackup";
            var Side = BreadthDetail.data.Side

            let SelectedIdsNo;
            var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
            if (IPQCObject != undefined) {
                SelectedIdsNo = IPQCObject.selectedIds.Idsno;
            } else {
                SelectedIdsNo = strHmi;
            }

            var reportLimitMsg = "Report Within Limit";
            if (tempCounterObj === undefined) {
                globalData.arrWeighmentCounter.push({
                    'Hmi': strHmi,
                    'counter': 0
                })
            }
            tempCounterObj = globalData.arrWeighmentCounter.find(k => k.Hmi == strHmi);

            switch (menuName) {
                case 'Breadth': {
                    strTableName = "tbl_tab_master4";
                    strDetailTbl = "tbl_tab_detail4";
                    typeValue = 4;
                    maxLimitT1 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail, 'T1');
                    maxLimitT2 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail);
                    minLimitT2 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail);
                    minLimitT1 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail, 'T1');
                }
                    break;
                case deafult:
                    break;
            }
            let intProductType = objSelMenu.selectedProductDetail.ProductType;

            let __parameterBreadth;

            if (sample >= tempCounterObj.counter) {
                tempCounterObj.counter += 1;

                __parameterBreadth = {
                    strTableName: strTableName,
                    strDetailTbl: strDetailTbl,
                    objProductDetails: BreadthDetail.data,
                    uniqueSerialNumber: strIdsNo,
                    strBalId: dataObj.instrumentId,
                    ProtocolData: dataObj.actualWt,
                    ProtocolUnit: dataObj.unit,
                    ProtocolDecPoint: dataObj.decPoint,
                    strHmi: strHmi,
                    seqNoOfWt: tempCounterObj.counter,
                    productType: objSelMenu.selectedProductDetail
                }

                var powerbackupobj = {
                    strTableName: strTableName,
                    strDetailTbl: strDetailTbl,
                    cubicaNo: _cubicalData.Sys_CubicNo,
                    cubicType: _cubicalData.Sys_CubType,
                    cubicSysBFGcode: _cubicalData.Sys_BFGCode,
                    cubicBatch: _cubicalData.Sys_Batch,
                    menuName: menuName,
                    ProductType: objSelMenu.selectedProductDetail.ProductType,
                    Userid: tempUserObject.UserId,
                    idsNo: strIdsNo,
                    Hmi: strHmi,
                    Incomp_RepSerNo: tempCounterObj.counter,
                    ReportType: _cubicalData.Sys_RptType,
                    RecSampleNo: tempCounterObj.counter,
                    SelectedIds: SelectedIdsNo

                }

                let _check_combination = await objPowerBackup._check_combination_pow(objSelMenu, powerbackupobj, tableName);
                if (_check_combination !== undefined) {
                    tempCounterObj.counter = _check_combination.RecSampleNo + 1;
                    powerbackupobj.RecSampleNo = tempCounterObj.counter;
                }


                if (tempCounterObj.counter == 1) {

                    var RepNo = await objCommonInsertOpt.insert_Into_Incomplete_Master(__parameterBreadth);
                    powerbackupobj.Incomp_RepSerNo = RepNo.srno
                    await objPowerBackup.getStatusoFTestForPowerBackup(powerbackupobj);

                    Object.assign(objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { activity: 'Breadth Weighment Started on TSH ' + strHmi });
                    await objActivityLog.ActivityLogEntry(objActivity);
                    await objInstrumentUsage.InstrumentUsage('Vernier', strIdsNo, 'tbl_instrumentlog_vernier', 'Breadth', 'started');

                }
                //insert data into detail table
                console.log(tempCounterObj.counter);
                let decimal = await objCommonInsertOpt.insert_Into_Incomplete_Detail(__parameterBreadth);
                powerbackupobj.Incomp_RepSerNo = decimal.repSerNo;
                await objPowerBackup.getStatusoFTestForPowerBackup(powerbackupobj);
                await objPowerBackup.updateTestCount(objSelMenu, powerbackupobj, tableName);
                var updateData = await objcalc.calculation_operation(__parameterBreadth, decimal.repSerNo);
                //mqttSender.sendData(strHmi, `DisplayResult:${tempCounterObj.counter}:${Number(dataObj.actualWt).toFixed(decimal)} ${dataObj.unit}`)
                let sampleNo = tempCounterObj.counter
                let limitObjResp = await objCommonUseFunc.SendCommon({ strHmi, actualWt, minLimitT2, maxLimitT2, minLimitT1, maxLimitT1, menuName, sampleNo })
                let color = limitObjResp.Color;
                let limit = limitObjResp.limit;

                await objMonit.monit({
                    case: 'TestWeight', Hmi: strHmi, data: {
                        Weight: `${actualWt} ${(dataObj.unit).toLowerCase()}`, srNo: "", message: `${limit}`
                    }
                });

                mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${tempCounterObj.counter}:${Number(actualWt).toFixed(2)} ${dataObj.unit}:${color}`);
                mqttSender.sendData(strHmi, limit);

                if (sample == tempCounterObj.counter) {
                    //move data from incomplete to complete 
                    //remove outOfLimit Flag
                    //check nmt range
                    var updateData = await objcalc.calculation_operation(__parameterBreadth, decimal.repSerNo);
                    // if (Side == 'RHS') {
                    //     var response = await objCommonInsertOpt.saveCompleteData(__parameterBreadth, 4, Side);
                    //     await objCommonInsertOpt.updateEndDate(strIdsNo, strHmi, strTableName);
                    // } else {
                    // if (_cubicalData.Sys_RotaryType == "Single") {
                    var response = await objCommonInsertOpt.saveCompleteData(__parameterBreadth, 4);
                    // await objCommonInsertOpt.updateEndDate(strIdsNo, strHmi, strTableName);
                    // }
                    // }

                    // if (Side == 'RHS') {
                    if (updateData == "Complies") {
                        var printObj = {
                            RepSerNo: response.RepSerNo,
                            Side: Side,
                            batchNo: _cubicalData.Sys_Batch,
                            cubicleType: _cubicalData.Sys_CubType,
                            int_ReportFormat: 1,
                            printNo: 0,
                            recordFrom: "Current",
                            reportOption: menuName,
                            reportType: "Complete",
                            testType: "Regular",
                            userId: tempUserObject.UserId,
                            username: tempUserObject.UserName,
                            str_url: objSelMenu.selectedProductDetail.ProductType === 1 ? "Tablet" : "Capsule"

                        }

                        await printOperations.callViewTabReport(printObj, intProductType, strHmi)

                        // }
                    }
                    const _deletePowerbackup = await models.tbl_powerbackup.destroy({
                        where: {
                            Idsno: strHmi,
                            Sys_Batch: _cubicalData.Sys_Batch,
                            WeighmentName: menuName
                        }
                    })
                    if (updateData == "Not Complies") {
                        reportLimitMsg = "Report Out Of Limit"
                    }
                    else {
                        reportLimitMsg = "Report Within Limit"
                    }


                    Object.assign(objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { activity: 'Breadth Weighment Completed on TSH' + strHmi });
                    await objActivityLog.ActivityLogEntry(objActivity);
                    await objInstrumentUsage.InstrumentUsage('Breadth', strIdsNo, 'tbl_instrumentlog_vernier', '', 'completed');
                    console.log(tempCounterObj.counter);

                    //for loop for checking if sample is between t2 and t1 
                    //and give report accordingly
                    globalData.arrWeighmentCounter.findIndex(k => k.Hmi == strHmi) == -1 ?
                        globalData.arrWeighmentCounter :
                        globalData.arrWeighmentCounter.splice(globalData.arrWeighmentCounter.findIndex(k => k.Hmi == strHmi), 1);

                    (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus :
                        globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);

                    (globalData.arrOutFlagForTest.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrOutFlagForTest :
                        globalData.arrOutFlagForTest.splice(globalData.arrOutFlagForTest.findIndex((element) => element.Hmi === strHmi), 1);
                    //test splice if rotarty is not double
                    globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
                        globalData.arrSelectedMenu :
                        globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);

                    await objMonit.monit({
                        case: 'ReportStatus',
                        Hmi: strHmi,
                        data: {
                            message: reportLimitMsg
                        }
                    });
                    mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}${reportLimitMsg}`);

                    return

                }

            }


        } catch (error) {
            throw new Error(error);
        }
    }


}

module.exports = BreadthModel;