const globalData = require("../../global/globalData");
const date = require("date-and-time");
const Database = require("../../database/clsQueryProcess");
const IncompleteReport = require("./clsIncompleteReport");
const clsWeighmentDataTransfer = require("./clsWeighmentDataTransfer");
const clsFormula = require("../Product/clsformulaFun.model");
const BatchSummaryModel = require("../Product/clsBatchSummaryOperation");
const GLOBAL_NOMENCLATURE = require("../../global/GLOBAL_NOMENCLATURE");
const check_srNO_ = require("./cls_consolidate_reportOperation");
// const dbcon = require('../../Utills/db');
const moment = require("moment");
const objWeighmentDataTransfer = new clsWeighmentDataTransfer();
const objIncompleteReport = new IncompleteReport();
const check_srNO = new check_srNO_();
const database = new Database();
const objFormula = new clsFormula();
const now = new Date();
const objBatchSummary = new BatchSummaryModel();
const { Op } = require("sequelize");
// const { tbl_cubical } = require('sequelize');
const models = require("../../../config/dbConnection").models;
const sequelize = require("../../../config/dbConnection").sequelize;
const { QueryTypes } = require("sequelize");
const momentObj = require("moment");
const { create, all } = require("mathjs");
const config = {};
const maths = create(all, config);
// const { create } = require("joi/lib/ref");
class InsertOperation {
  async insert_Into_Incomplete_Master(dataObj) {
    try {
      const strIdsNo = dataObj.uniqueSerialNumber;
      let objSelMenu = globalData.arrSelectedMenu.find(
        (k) => k.idsNo == strIdsNo
      );
      // var detaTable = dataObj.strMasterTbl
      const strTableName = dataObj.strTableName;
      var detailTable = dataObj.strDetailTbl
      const objProductDetails = objSelMenu.selectedProductDetail;
      const strBalId = dataObj.strBalId;
      const ProtocolData = dataObj.ProtocolData;
      const ProtocolUnit = dataObj.ProtocolUnit;
      const ProtocolDecPoint = ProtocolUnit != 'mg' ? dataObj.ProtocolDecPoint : 1
      const strHmi = dataObj.strHmi;
      const intProductType = dataObj.productType;
      const intNominal = dataObj.objProductDetails.Nominal;
      const DecPoint = ProtocolUnit == 'mm' ? 2 : 3;
      let side;
      var SideARR = globalData.arrside.find(k => k.Hmi == strHmi)
      if (SideARR == undefined) {
        if (dataObj.objProductDetails.Rotary == "Single") {
          side = "NA";
        } else if (dataObj.objProductDetails.Rotary == "Double") {
          side = dataObj.objProductDetails.Side;
        }
      } else {
        side = SideARR.Side
      }
      let hmiDetailsInPMenu = globalData.arrIdsInfo.find(
        (k) => k.Hmi == strHmi
      ).cubicalData;
      //const objSelMenu = globalData.arrSelectedMenu.find(k => k.idsNo == strIdsNo);
      let selectedIdsNo;
      var IPQCObject = globalData.arr_IPQCRelIds.find(
        (k) => k.idsNo == strIdsNo
      );
      if (IPQCObject != undefined) {
        selectedIdsNo = IPQCObject.selectedIds;
      } else {
        selectedIdsNo = strIdsNo;
      }

      let selectedCub = globalData.arrIdsInfo.find(
        (k) => k.idsNo == selectedIdsNo
      ).cubicalData;

      let productMaster = globalData.arrProductTypeArray.find(
        (k) => k.idsNo == selectedIdsNo
      );
      // var LimitOn = await models[strTableName].findAll({
      //   where: {
      //     ProductId: productMaster.productType.ProductId,
      //     ProductName: productMaster.productType.ProductName,
      //     ProductVersion: productMaster.productType.ProductVersion
      //   }
      // });

      var LimitOn = productMaster.productDetail[0]
      //for calculation,extra part added
      var dp = objProductDetails.LimitOn == 0 ? ProtocolDecPoint : 2;  //ProtocolDecPoint;
      var unit_stdlimit = (objProductDetails.LimitOn == 0 ? objProductDetails.unit : '%')
      var std_Limit1;
      var std_Limit2;
      let product_type = (objProductDetails.ProductType == 1) ? "tablets" : "capsules"
      if (Number(objProductDetails.T1Neg) != 0) {
        if (Number(objProductDetails.T1Neg) != Number(objProductDetails.T1Pos)) {
          std_Limit1 = 'NMT' + ' ' + LimitOn[0].Param1_NMTTab + ' ' + product_type + ' ' + 'deviate' + ' ' + 'by' + ' ' + maths.round(objProductDetails.T1Neg, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase() + ' ' + '-' + ' ' + maths.round(objProductDetails.T1Pos, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase()
        } else {
          std_Limit1 = 'NMT' + ' ' + LimitOn[0].Param1_NMTTab + ' ' + product_type + ' ' + 'deviate' + ' ' + 'by' + ' ' + '±' + ' ' + maths.round(objProductDetails.T1Neg, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase()
        }
      } else {
        std_Limit1 = 'NA'
      }
      if (Number(objProductDetails.T2Neg) != Number(objProductDetails.T2Pos)) {
        std_Limit2 = 'None of' + ' ' + product_type + ' ' + 'deviate' + ' ' + 'by' + ' ' + maths.round(objProductDetails.T2Neg, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase() + ' ' + '-' + ' ' + maths.round(objProductDetails.T2Pos, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase()
      } else {
        std_Limit2 = 'None of' + ' ' + product_type + ' ' + 'deviate' + ' ' + 'by ±' + ' ' + maths.round(objProductDetails.T2Neg, dp).toFixed(dp) + ' ' + (unit_stdlimit).toLowerCase();
      }

      // var nob1 = 0;
      // var noa1 = 0;
      // var nob2 = 0;
      // var noa2 = 0;

      // if (Number(ProtocolData) < Number(dataObj.objProductDetails.T2Neg)) { //No of below limit 2
      //   nob2 = 1;
      // } else if (Number(ProtocolData) > Number(dataObj.objProductDetails.T2Pos)) { //No of Above limit 2
      //   noa2 = 1;
      // }
      // if (dataObj.objProductDetails.T1Neg != 0 && dataObj.objProductDetails.T1Pos != 0) {
      //   if (Number(ProtocolData) < Number(dataObj.objProductDetails.T1Neg) && Number(ProtocolData) >= Number(dataObj.objProductDetails.T2Neg)) { //No of below limit 1
      //     nob1 = 1;
      //   } else if (Number(ProtocolData) > Number(dataObj.objProductDetails.T1Pos) && Number(ProtocolData) <= Number(dataObj.objProductDetails.T2Pos)) { //No of Above limit 1
      //     noa1 = 1;
      //   }
      // }


      let tblName = strTableName.concat("_incomplete");
      var check_master_SRno = await check_srNO.check_master_SRno(dataObj, hmiDetailsInPMenu, strHmi, objProductDetails, strTableName, side)
      const Nom = intNominal.split(' ')[0]

      const insertObj = await models[tblName].create({
        MstSerNo: check_master_SRno,
        // InstruId: 1,
        BFGCode: dataObj.objProductDetails.ProductId,
        ProductName: dataObj.objProductDetails.ProductName,
        ProductType: productMaster.productType.ProductType,
        Qty: Number(dataObj.objProductDetails.noOfSample),
        GrpQty: 0,
        GrpFreq: 0,
        Idsno: Number(strHmi),
        CubicalNo: selectedCub.Sys_CubicNo,
        Department: hmiDetailsInPMenu.Sys_dept,
        BalanceId: hmiDetailsInPMenu.Sys_BalID,
        BalanceNo: 0,
        // VernierId: hmiDetailsInPMenu.Sys_VernierID,
        VernierId: dataObj.strBalId,
        VernierNo: 0,
        BatchNo: dataObj.objProductDetails.Batch,
        UserId: dataObj.objProductDetails.userId,
        UserName: dataObj.objProductDetails.userName,
        PrDate: momentObj().format("YYYY-MM-DD"),
        PrTime: momentObj().format("HH:mm:ss"),
        PrEndDate: momentObj().format("YYYY-MM-DD"),
        PrEndTime: momentObj().format("HH:mm:ss"),
        // PrEndTime: '',
        Side: side,
        // SideNo:0,
        Unit: (ProtocolUnit).toLowerCase(),
        DecimalPoint: ProtocolDecPoint,
        WgmtModeNo: Number(dataObj.strTableName.split('master')[1]),
        Nom: ProtocolUnit != 'mg' ? Nom : Number(Nom).toFixed(1),        
        T1NegTolActual: Number(objProductDetails.T1Neg.toString()).toFixed(ProtocolDecPoint),
        T1PosTolActual: Number(objProductDetails.T1Pos.toString()).toFixed(ProtocolDecPoint),
        T2NegTolActual: Number(objProductDetails.T2Neg.toString()).toFixed(ProtocolDecPoint),
        T2PosTolActual: Number(objProductDetails.T2Pos.toString()).toFixed(ProtocolDecPoint),
        T1NegTol: Number(dataObj.objProductDetails.T1Neg.split(' ')[0]).toFixed(ProtocolDecPoint),
        T1PosTol: Number(dataObj.objProductDetails.T1Pos.split(' ')[0]).toFixed(ProtocolDecPoint),
        T2NegTol: Number(dataObj.objProductDetails.T2Neg.split(' ')[0]).toFixed(ProtocolDecPoint),
        T2PosTol: Number(dataObj.objProductDetails.T2Pos.split(' ')[0]).toFixed(ProtocolDecPoint),
        NMT: objProductDetails.NMT,
        limitOn: objProductDetails.LimitOn.toString(),
        // T1NMTTab:  objProductDetailsNMT
        NomEmpty: "0",
        T1NegEmpty: "0",
        T1PosEmpty: "0",
        T2NegEmpty: "0",
        T2PosEmpty: "0",
        NomNet: "0",
        T1NegNet: "0",
        T1PosNet: "0",
        T2NegNet: "0",
        T2PosNet: "0",
        CubicleType: selectedCub.Sys_CubType,
        IPQCType: hmiDetailsInPMenu.Sys_IPQCType,
        ReportType: hmiDetailsInPMenu.Sys_RptType,
        MachineCode: selectedCub.Sys_MachineCode,
        MFGCode: selectedCub.Sys_MfgCode,
        BatchSize: selectedCub.Sys_BatchSize,
        FriabilityID: hmiDetailsInPMenu.Sys_FriabID,
        HardnessID: hmiDetailsInPMenu.Sys_HardID,
        CubicleName: selectedCub.Sys_CubicName,
        CubicleLocation: selectedCub.Sys_Location,
        Stage: selectedCub.Sys_Stage,
        // RepoLabel10: "Standard",
        // RepoLabel11: 0,
        // RepoLabel12: "Null",
        // RepoLabel13: "Null",
        Layer: "NA",
        Nom_stdtarget: "NULL",
        PrintNo: 0,
        IsArchived: 0,
        GraphType: objProductDetails.isonstd,
        BatchComplete: 0,
        PVersion: selectedCub.Sys_PVersion,
        Version: selectedCub.Sys_Version,
        BRepSerNo: 0,
        Lot: dataObj.objProductDetails.lotno,
        Area: selectedCub.Sys_Area,
        AvgWeight: 0,
        MinWeight: 0,
        MaxWeight: 0,
        StdDev: 0,
        MinPer: 0,
        MaxPer: 0,
        StdLimit1: std_Limit1,
        StdLimit2: std_Limit2,
        NoOfBelow1: 0,
        NoOfAbove1: 0,
        NoOfBelow2: 0,
        NoOfAbove2: 0,
        Inprocess: 1,
      });

      let arrResult = [insertObj.dataValues];
      var obj = {
        srno: arrResult[0].RepSerNo,
      }
      return obj
    } catch (error) {
      throw new Error(error);
    }
  }

  async insert_Into_Incomplete_Detail(dataObj) {
    try {
      const strmasterTbl = dataObj.strTableName;
      const strDetailTbl = dataObj.strDetailTbl;
      const strHmi = dataObj.strHmi;
      const strProtocolData = dataObj.ProtocolData;
      const strProtocolUnit = dataObj.ProtocolUnit;
      const strDecPoint = strProtocolUnit != 'mg' ? dataObj.ProtocolDecPoint : 1
      const seqNoOfWt = dataObj.seqNoOfWt;
      let userobj = globalData.arrUsers.find(k => k.Hmi == strHmi)
      var decimal;
      let strIdsNo = dataObj.uniqueSerialNumber;
      let selectedIdsNo;

      var IPQCObject = globalData.arr_IPQCRelIds.find(
        (k) => k.idsNo == strIdsNo
      );
      if (IPQCObject != undefined) {
        selectedIdsNo = IPQCObject.selectedIds;
      } else {
        selectedIdsNo = strIdsNo;
      }
      let side;
      var SideARR = globalData.arrside.find(k => k.Hmi == strHmi)
      if (SideARR == undefined) {
        if (dataObj.objProductDetails.Rotary == "Single") {
          side = "NA";
        } else if (dataObj.objProductDetails.Rotary == "Double") {
          side = dataObj.objProductDetails.Side;
        }
      } else {
        side = SideARR.Side
      }

      let hmiDetailsInPMenu = globalData.arrIdsInfo.find(
        (k) => k.idsNo == selectedIdsNo
      ).cubicalData;

      let repSerNo = await this.lastInsertedRecords(
        hmiDetailsInPMenu.Sys_ProductName,
        hmiDetailsInPMenu.Sys_BFGCode,
        hmiDetailsInPMenu.Sys_PVersion,
        hmiDetailsInPMenu.Sys_Version,
        strmasterTbl,
        hmiDetailsInPMenu.Sys_Batch,
        strHmi,
      );

      /**
       * get decimal
       */
      let tbName = strDetailTbl.concat("_incomplete");
      const selectRepSrNoObj = await models[tbName].findAll({
        where: {
          RepSerNo: repSerNo,
        },
      });
      let arrResult_RepNo = [selectRepSrNoObj];
      if (arrResult_RepNo[0].length == 0) {
        decimal = strDecPoint;
      } else {
        decimal = arrResult_RepNo[0][0].DP;
      }

      let tbNamemaster = strmasterTbl.concat("_incomplete");
      const selectObj = await models[tbNamemaster].findAll({
        where: {
          RepSerNo: repSerNo
        },
      });
      var dp;
      if (dataObj.ProtocolUnit == 'mm') {
        dp = 2
      } else if (dataObj.ProtocolUnit == 'mg') {
        dp = 1
      } else {
        dp = selectObj[0].DecimalPoint
      }
      var sample_count = selectRepSrNoObj.length
      if(sample_count == Number(dataObj.objProductDetails.noOfSample)){
         return { repSerNo: repSerNo, decimal: decimal };
      }
      var tableName = strDetailTbl.concat("_incomplete");
      const insertDetail = await models[tableName].create({
        RepSerNo: repSerNo,
        MstSerNo: selectObj[0].MstSerNo,
        RecSeqNo: seqNoOfWt,
        DataValue: Number(strProtocolData).toFixed(dp),
        DP: decimal,
        UserId: userobj.UserId,
        UserName: userobj.UserName,
        Side: side,
        PrDate: momentObj().format("YYYY-MM-DD"),
        PrTime: momentObj().format("HH:mm:ss"),
        PrEndDate: momentObj().format("YYYY-MM-DD"),
        PrEndTime: momentObj().format("HH:mm:ss"),
        BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
        ProductName: hmiDetailsInPMenu.Sys_ProductName,
        PVersion: hmiDetailsInPMenu.Sys_PVersion,
        Version: hmiDetailsInPMenu.Sys_Version,
        BatchNo: hmiDetailsInPMenu.Sys_Batch,
        InstrumentID: dataObj.strBalId,
      });


      let arrResult = [insertDetail.dataValues];
      let obj = {
        repSerNo: repSerNo,
        decimal: dp
      }
      return obj;
    } catch (error) {
      throw new Error(error);
    }
  }

  // async insert_Into_Dbl_Detail(dataObj) {
  //   try {
  //     const seqNoOfWt = dataObj.seqNoOfWt;
  //     const strmasterTbl = dataObj.strTableName;
  //     const strDecPoint = dataObj.ProtocolDecPoint;
  //     let strIdsNo = dataObj.uniqueSerialNumber;
  //     const strProtocolData = dataObj.ProtocolData;
  //     let decimal;
  //     let selectedIdsNo;

  //     var IPQCObject = globalData.arr_IPQCRelIds.find(
  //       (k) => k.idsNo == strIdsNo
  //     );
  //     if (IPQCObject != undefined) {
  //       selectedIdsNo = IPQCObject.selectedIds;
  //     } else {
  //       selectedIdsNo = strIdsNo;
  //     }

  //     let hmiDetailsInPMenu = globalData.arrIdsInfo.find(
  //       (k) => k.idsNo == selectedIdsNo
  //     ).cubicalData;

  //     let repSerNo = await this.lastInsertedRecords(
  //       hmiDetailsInPMenu.Sys_ProductName,
  //       hmiDetailsInPMenu.Sys_BFGCode,
  //       hmiDetailsInPMenu.Sys_PVersion,
  //       hmiDetailsInPMenu.Sys_Version,
  //       strmasterTbl
  //     );

  //     const selectRepSrNoObj = await models[dataObj.strDblDetailTbl].findAll({
  //       where: {
  //         RepSerNo: repSerNo,
  //       },
  //     });

  //     let arrResult_RepNo = [selectRepSrNoObj];
  //     if (arrResult_RepNo[0].length == 0) {
  //       decimal = strDecPoint;
  //     } else {
  //       decimal = arrResult_RepNo[0][0].DecimalPoint;
  //     }
  //     const insertObj = await models[dataObj.strDblDetailTbl].create({
  //       RepSerNo: repSerNo,
  //       MstSerNo: 1,
  //       InstruId: 1,
  //       RecSeqNo: seqNoOfWt,
  //       DataValue: strProtocolData,
  //       DecimalPoint: decimal,
  //     });

  //     let arrResult = [insertObj];
  //     return arrResult[0];
  //   } catch (error) {
  //     throw new Error(error);
  //   }
  // }

  async lastInsertedRecords(
    strProductName,
    StrBFGCode,
    StrProductVersion,
    StrVersion,
    tableName, Batch, IDSNo
  ) {
    try {
      let intMstSerNo;
      // var selectRepSrNoObj = {
      //     str_tableName: tableName.concat('_incomplete'),
      //     data: 'max(RepSerNo) as RepSerNo',
      //     condition: [
      //         { str_colName: 'ProductName', value: strProductName, comp: 'eq' },
      //         { str_colName: 'BFGCode', value: StrBFGCode, comp: 'eq' },
      //         { str_colName: 'PVersion', value: StrProductVersion, comp: 'eq' },
      //         { str_colName: 'Version', value: StrVersion, comp: 'eq' },
      // { str_colName: 'BatchNo', value: cubicalObj.Sys_Batch, comp: 'eq' },
      // { str_colName: 'Idsno', value: cubicalObj.Sys_IDSNo, comp: 'eq' },

      tableName = tableName.concat("_incomplete");
      let selectRepSrNoObj = await models[tableName].findAll({
        attributes: [
          [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
        ],
        where: {
          ProductName: strProductName,
          BFGCode: StrBFGCode,
          PVersion: StrProductVersion,
          Version: StrVersion,
          BatchNo: Batch,
          Idsno: IDSNo
        },
      });

      let arrResultDaily_RepNo = [selectRepSrNoObj];

      let intDaily_RepNo = arrResultDaily_RepNo[0].RepSerNo;
      if (arrResultDaily_RepNo[0][0].RepSerNo == null) {
        intMstSerNo = 1;
      } else {
        var newMstSerNo = arrResultDaily_RepNo[0][0].RepSerNo;
        intMstSerNo = newMstSerNo;
      }
      return intMstSerNo;
    } catch (error) {
      console.log(error);
    }
  }

  async lastInsertedSeqNo(tableName, repSerNo) {
    try {
      tableName = tableName.concat("_incomplete");
      let selectRepSrNoObj = await models[tableName].findAll({
        attributes: [
          [sequelize.fn("max", sequelize.col("RecSeqNo")), "RecSeqNo"],
        ],
        where: {
          RecSeqNo: repSerNo,
          // BatchNo:cubicalObj.Sys_Batch,
          // Idsno:cubicalObj.Sys_IDSNo
        },
      });

      let arrResultDaily_RepNo = [selectRepSrNoObj];

      // let intDaily_RepNo = arrResultDaily_RepNo[0].RepSerNo;
      let intMstSerNo;
      if (arrResultDaily_RepNo[0][0].RecSeqNo == null) {
        intMstSerNo = 1;
      } else {
        var newMstSerNo = arrResultDaily_RepNo[0][0].RecSeqNo;
        intMstSerNo = newMstSerNo + 1;
      }
      return intMstSerNo;
    } catch (error) {
      console.log(error);
    }
  }
  async saveCompleteData(dataObj, strTypeValue, Side) {
    try {
      let masterTable;
      let detailTable;
      let strHmi = dataObj.strHmi;
      let typeValue = strTypeValue;
      let strIdsNo = dataObj.uniqueSerialNumber;

      let selectedIdsNo;
      var IPQCObject = globalData.arr_IPQCRelIds.find(
        (k) => k.idsNo == strIdsNo
      );
      if (IPQCObject != undefined) {
        selectedIdsNo = IPQCObject.selectedIds;
      } else {
        selectedIdsNo = strIdsNo;
      }

      let objProductDetail = globalData.arrProductTypeArray.find(
        (k) => k.idsNo == selectedIdsNo
      );
      let objProductType = objProductDetail.productType;

      if (objProductType.ProductType == 1) {
        masterTable = "tbl_tab_master" + typeValue;
        detailTable = "tbl_tab_detail" + typeValue;
      } else if (
        objProductType.ProductType == 2 ||
        objProductType.ProductType == 4
      ) {
        if (typeValue == "D") {
          masterTable = "tbl_cap_master3";
          detailTable = "tbl_cap_detail3";
        } else {
          masterTable = "tbl_cap_master" + typeValue;
          detailTable = "tbl_cap_detail" + typeValue;
        }
      } else if (objProductType.ProductType == 19) {
        masterTable = "tbl_tab_master19";
        detailTable = "tbl_tab_detail19";
      }
      // if (Side == 'RHS') {
      //   for (let i = 0; i < 2; i++) {
      //     let result = await objIncompleteReport.getIncomepleteData(
      //       dataObj,
      //       masterTable,
      //       detailTable,
      //       strHmi, Side, i
      //     );
      //     let reportStatus = await this.removeLimitForRemark(
      //       result,
      //       typeValue,
      //       strHmi,
      //       objProductType
      //     );
      //     if (typeValue == "D") {
      //       await objBatchSummary.saveBatchDataDiff(
      //         3,
      //         result,
      //         strIdsNo,
      //         reportStatus
      //       );
      //     } else {
      //       await objBatchSummary.saveBatchData(
      //         typeValue,
      //         result,
      //         strHmi,
      //         strIdsNo
      //       );
      //     }

      //     var isWTTrfr = await objWeighmentDataTransfer.saveCommonDataToComplete(
      //       result,
      //       typeValue,
      //       strHmi
      //     );
      //     await this.deleteIncompleteRemarkEntry(strHmi, strIdsNo);
      //   }
      // } else {
      let result = await objIncompleteReport.getIncomepleteData(
        dataObj,
        masterTable,
        detailTable,
        strHmi
      );
      let reportStatus = await this.removeLimitForRemark(
        result,
        typeValue,
        strHmi,
        objProductType
      )
      if (typeValue == "D") {
        await objBatchSummary.saveBatchDataDiff(
          3,
          result,
          strIdsNo,
          reportStatus
        );
      } else {
        await objBatchSummary.saveBatchData(
          typeValue,
          result,
          strHmi,
          strIdsNo
        );
      }

      var isWTTrfr = await objWeighmentDataTransfer.saveCommonDataToComplete(
        result,
        typeValue,
        strHmi
      );
      await this.deleteIncompleteRemarkEntry(strHmi, strIdsNo);
      // }
      return isWTTrfr

    } catch (error) {
      throw new Error(error);
    }
  }

  async removeLimitForRemark(result, typeValue, IdsNo, objProductType) {
    try {

      let objMenuDetail = globalData.arrSelectedMenu.find(
        (k) => k.Hmi == IdsNo
      );
      let menuName = objMenuDetail.menuName;
      let selectedIdsNo;
      var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.Hmi == IdsNo);
      if (IPQCObject != undefined) {
        selectedIdsNo = IPQCObject.selectedIds;
      } else {
        selectedIdsNo = IdsNo;
      }

      let menuDetailsArr = globalData.arr_limits.find(
        (k) => k.Hmi == selectedIdsNo
      );
      let menuDetail = menuDetailsArr.Menus.filter(
        (obj) => Object.keys(obj) == menuName
      )[0][menuName];
      var outOfLimitCount = 0;
      const valuesForAvg = [];
      let sum = 0;
      var ResultOfReport = "Report Within Limit";
      let T1Pos;
      var nosOfAboveTabletForT1 = result.incompleteData.NoOfAbove1;
      var nosOfBelowTabletForT1 = result.incompleteData.NoOfBelow1;
      var nosOfAboveTabletForT2 = result.incompleteData.NoOfAbove2;
      var nosOfBelowTabletForT2 = result.incompleteData.NoOfBelow2;
      if (result.incompleteData.GraphType == "1") {
        for (const val of result.detailData) {
          valuesForAvg.push(val.DataValue);
          sum += parseFloat(val.DataValue);
        }

        let avg = sum / valuesForAvg.length;

      }

      switch (typeValue.toString()) {
        case "1":
          T1Pos = menuDetail.T1Pos;
          break;
        case "8":
          var paramName = "Ind_Layer";
          // if (serverConfig.ProjectName == "RBH") {
          //     paramName = 'Ind_Empty';
          // }
          T1Pos = menuDetail.T1Pos;
          break;
        case "L":
          T1Pos = menuDetail.T1Pos;
          break;
        case "3":
          T1Pos = menuDetail.T1Pos;
          break;
        case "4":
          if (objProductType.ProductType == 1) {
            T1Pos = menuDetail.T1Pos;
          } else {
            T1Pos = menuDetail.T1Pos;
          }
          break;
        case "5":
          T1Pos = menuDetail.T1Pos;
          break;
        case "6":
          T1Pos = menuDetail.T1Pos;
          break;
        default:
          T1Pos = 1;
      }
      //T2 limit
      // for (const val of result.detailData) {
      //   if (
      //     parseFloat(val.DataValue) > parseFloat(dbl_upperLimit.upperLimit2) ||
      //     parseFloat(val.DataValue) < parseFloat(dbl_lowerLimit.lowerLimit2)
      //   ) {
      //     outOfLimitCount += 1;
      //   }
      // }

      if (outOfLimitCount > 0) {
        // ResultOfReport = `LE1`;
        ResultOfReport = `Report Out of Limit`;
        // objForLimit.flag = true
        console.log("Report Out of Limit From T2");
      }

      //For T1 calculations for balance related parameter only
      if (outOfLimitCount == 0 && parseFloat(T1Pos) != 0) {
        // for (const val of result.detailData) {
        //   if (
        //     parseFloat(val.DataValue) >
        //       parseFloat(dbl_upperLimit.upperLimit1) ||
        //     parseFloat(val.DataValue) < parseFloat(dbl_lowerLimit.lowerLimit1)
        //   ) {
        //     outOfLimitCount += 1;
        //   }
        // }
        if (nosOfBelowTabletForT2 != 0 || nosOfAboveTabletForT2 != 0 || nosOfAboveTabletForT1 !=0 || nosOfBelowTabletForT1 !=0) {
          ResultOfReport = "Report Out of Limit";
          // objForLimit.flag = true
          // console.log("Report Out of Limit From T1")
        }
      }
      return ResultOfReport;
    } catch (error) {
      throw new Error(error);
    }
  }

  async updateEndDate(strIdsNo, strHmi, strTableName) {
    try {
      const cubicalObj = globalData.arrIdsInfo.find(
        (k) => k.Hmi == strHmi
      ).cubicalData;

      const updateThicknessEndTime = await models[strTableName].update(
        {
          PrEndDate: momentObj().format("YYYY-MM-DD"),
          PrEndTime: momentObj().format("HH:mm:ss"),
        },
        {
          where: {
            BFGCode: cubicalObj.Sys_BFGCode,
            ProductName: cubicalObj.Sys_ProductName,
            PVersion: cubicalObj.Sys_PVersion,
            Version: cubicalObj.Sys_Version,
            BatchNo: cubicalObj.Sys_Batch,
            // Idsno: strHmi,
          },
        }
      );
      // {
      //     str_tableName: strTableName,
      //     data: [
      //         { str_colName: 'PrEndDate', value: date.format(new Date(), 'YYYY-MM-DD') },
      //         { str_colName: 'PrEndTime', value: date.format(new Date(), 'HH:mm:ss') }
      //     ],
      //     condition: [
      //        BFGCode: cubicalObj.Sys_BFGCode ,
      //        ProductName: cubicalObj.Sys_ProductName ,
      //        PVersion: cubicalObj.Sys_PVersion ,
      //        Version: cubicalObj.Sys_Version ,
      //        BatchNo: cubicalObj.Sys_Batch ,
      //        Idsno: strIdsNo ,
      //     ]
      // }

      updateThicknessEndTime;
    } catch (error) {
      throw new Error(error);
    }
  }

  async deleteIncompleteRemarkEntry(strHmi, strIdsNo) {
    try {
      let CubicInfo = globalData.arrIdsInfo.find((k) => k.Hmi == strHmi);
      let StrBatch = CubicInfo.cubicalData.Sys_Batch;
      const objRemark = await models.tbl_remark_incomplete_master.destroy({
        where: {
          IDSNo: strHmi,
          BatchNumber: StrBatch,
        },
      });
      //  {
      //     str_tableName: "tbl_remark_incomplete_master",
      //     data: '*',
      //     condition: [
      //         { str_colName: 'IDSNo', value: strIdsNo },
      //         { str_colName: 'BatchNumber', value: StrBatch }
      //     ]
      // }
    } catch (error) {
      throw new Error(error);
    }
  }

  async InsertIncompleteRemarkEntry(dataObj) {
    try {
      let strIdsNo = dataObj.idsNo;
      let strMenuName = dataObj.menuName;
      let batchNo = dataObj.batchNo;
      const masterTable = dataObj.tableName;

      const checkForAlreadyEntry = await tbl_remark_incomplete_master.findAll({
        where: {
          IDSNo: strIdsNo,
          BatchNumber: batchNo,
        },
      });
      // {
      //     str_tableName: 'tbl_remark_incomplete_master',
      //     data: '*',
      //     condition: [
      //         { str_colName: 'IDSNo', value: strIdsNo },
      //         { str_colName: 'BatchNumber', value: batchNo }
      //     ]
      // }
      let result = checkForAlreadyEntry;
      if (result[0].length == 0) {
        const insertRepoRemarkDetail =
          await models.tbl_remark_incomplete_master.create({});
        // {
        //     str_tableName: 'tbl_remark_incomplete_master',
        //     data: [
        //         { str_colName: 'IDSNo', value: strIdsNo },
        //         { str_colName: 'paramName', value: strMenuName },
        //         { str_colName: 'tableName', value: masterTable + "_incomplete" },
        //         { str_colName: 'BatchNumber', value: batchNo }
        //     ]
        // }

        await database.save(insertRepoRemarkDetail);
      } else {
        const insertRepoRemarkDetail = {
          str_tableName: "tbl_remark_incomplete_master",
          condition: [
            { str_colName: "IDSNo", value: strIdsNo },
            { str_colName: "BatchNumber", value: batchNo },
          ],
          data: [
            { str_colName: "paramName", value: strMenuName },
            { str_colName: "tableName", value: masterTable + "_incomplete" },
          ],
        };

        await database.update(insertRepoRemarkDetail);
      }
    } catch (error) { }
  }

  async updateSample(sampleNo, strHmi, menuName) {
    try {
      if (
        menuName == GLOBAL_NOMENCLATURE.IndLayerMenu ||
        menuName == GLOBAL_NOMENCLATURE.IndividualMenu ||
        menuName == GLOBAL_NOMENCLATURE.IndLayer1Menu ||
        menuName == GLOBAL_NOMENCLATURE.PercentageFine ||
        menuName == GLOBAL_NOMENCLATURE.ParticalSizing ||
        menuName == GLOBAL_NOMENCLATURE.Differential
      ) {
        menuName = GLOBAL_NOMENCLATURE.IndividualMenu;
      } else if (
        menuName == GLOBAL_NOMENCLATURE.GroupLayer1Menu ||
        menuName == GLOBAL_NOMENCLATURE.GroupLayerMenu ||
        menuName == GLOBAL_NOMENCLATURE.GroupMenu
      ) {
        menuName = GLOBAL_NOMENCLATURE.GroupMenu;
      } else if (
        menuName == GLOBAL_NOMENCLATURE.FriabilityMenu ||
        menuName == GLOBAL_NOMENCLATURE.FriabilatorMenu
      ) {
        menuName = GLOBAL_NOMENCLATURE.FriabilityMenu;
      } else if (menuName == GLOBAL_NOMENCLATURE.TappedDensity) {
        menuName = GLOBAL_NOMENCLATURE.TappedDensity;
      } else if (
        menuName == GLOBAL_NOMENCLATURE.MoistureAnalyzer ||
        menuName == "LOD"
      ) {
        menuName = GLOBAL_NOMENCLATURE.IndividualMenu;
      } else if (
        menuName == GLOBAL_NOMENCLATURE.ThicknessMenu ||
        menuName == GLOBAL_NOMENCLATURE.BreadthMenu ||
        menuName == GLOBAL_NOMENCLATURE.LengthMenu ||
        menuName == GLOBAL_NOMENCLATURE.DiameterMenu ||
        menuName == GLOBAL_NOMENCLATURE.SealLengthMenu
      ) {
        menuName == GLOBAL_NOMENCLATURE.ThicknessMenu
      }

      const cubicalDetails = globalData.arrIdsInfo.find(
        (k) => k.Hmi == strHmi
      ).cubicalData;
      if (menuName == GLOBAL_NOMENCLATURE.ThicknessMenu){
        var updateSample = await models.tbl_cubicle_product_sample.update(
          {
            [`Thickness`]: sampleNo,
          },
          {
            where: {
              Sys_CubicNo: cubicalDetails.Sys_CubicNo,
            },
          }
        );
      }
        if(menuName == GLOBAL_NOMENCLATURE.BreadthMenu){
        var updateSample = await models.tbl_cubicle_product_sample.update(
          {
            [`Breadth`]: sampleNo,
           
          },
          {
            where: {
              Sys_CubicNo: cubicalDetails.Sys_CubicNo,
            },
          }
        );
      }
        if(menuName == GLOBAL_NOMENCLATURE.LengthMenu){
        var updateSample = await models.tbl_cubicle_product_sample.update(
          {
            
            [`Length`]: sampleNo,
          
          },
          {
            where: {
              Sys_CubicNo: cubicalDetails.Sys_CubicNo,
            },
          }
        );
      }
        if(menuName == GLOBAL_NOMENCLATURE.DiameterMenu){
        var updateSample = await models.tbl_cubicle_product_sample.update(
          {
          
            [`Diameter`]: sampleNo,
          },
          {
            where: {
              Sys_CubicNo: cubicalDetails.Sys_CubicNo,
            },
          }
        );
      }
        if(menuName == GLOBAL_NOMENCLATURE.SealLengthMenu) {
        var updateSample = await models.tbl_cubicle_product_sample.update(
          {
           
            [`Length`]: sampleNo,
     
          },
          {
            where: {
              Sys_CubicNo: cubicalDetails.Sys_CubicNo,
            },
          }
        );
        
        await [updateSample];
      } else {
        const updateSampleObj = await models.tbl_cubicle_product_sample.update(
          { [`${menuName}`]: sampleNo },
          {
            where: {
              Sys_CubicNo: cubicalDetails.Sys_CubicNo,
            },
          }
        );
        await [updateSampleObj];
      }

      // {
      //     str_tableName: 'tbl_cubicle_product_sample',
      //     data: [
      //         { str_colName: menuName, value: sampleNo },
      //     ],
      //     condition: [
      //         { str_colName: 'Sys_CubicNo', value: cubicalDetails.Sys_CubicNo },
      //         // { str_colName: 'Sys_BFGCode', value: cubicalDetails.Sys_BFGCode },
      //         // { str_colName: 'Sys_ProductName', value: cubicalDetails.Sys_CubType },
      //         // { str_colName: 'Sys_PVersion', value: cubicalDetails.Sys_PVersion },
      //         // { str_colName: 'Sys_CubType', value: cubicalDetails.Sys_Version },
      //     ]
      // }

      // await [updateSampleObj];
    } catch (error) {
      throw new Error(error);
    }
  }

  async getCubicalData(strIdsNo) {
    try {
      // const objListBal = {
      //     str_tableName: 'tbl_cubical',
      //     data: '*',
      //     condition: [
      //         { str_colName: 'Sys_IDSNo', value: strIdsNo }
      //     ]
      // }
      // let cubicalData = await database.select(objListBal);
      let cubicalData = await models.tbl_cubical.findAll({
        where: {
          Sys_IDSNo: strIdsNo,
        },
      });
      return [cubicalData[0]];
    } catch (error) {
      throw new Error(error);
    }
  }

  async getCubicalIdsNo() {
    try {
      const objListBal = await models.tbl_cubical.findAll({
        where: {
          Sys_IDSNo: {
            [Op.ne]: "NA",
          },
        },
      });

      // dbcon.execute('SELECT `Sys_IDSNo` FROM `tbl_cubical` WHERE `Sys_IDSNo` <> "0"')
      return [objListBal];
    } catch (error) {
      throw new Error(error);
    }
  }

  async saveIncompleteDataPerFineAndParticalSizing(_parameterObjPerFineAndParticalSizing, testType) {
    try {


      //cubicalObj, protocol, intNos, typeValue, tempUserObject, strIdsNo
      let strIdsNo = _parameterObjPerFineAndParticalSizing.uniqueSerialNumber;
      let strHmi = _parameterObjPerFineAndParticalSizing.strHmi;
      let cubicalObj = globalData.arrIdsInfo.find((k) => k.idsNo == strIdsNo).cubicalData;
      let Menuname = globalData.arrSelectedMenu.find((k) => k.idsNo == strIdsNo).menuName
      var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
      // if (IPQCObject != undefined) {
      //     strHmi = IPQCObject.idsNo;
      // } else {
      //     strHmi = strHmi;
      // }
      if (IPQCObject != undefined) {
        strHmi = IPQCObject.idsNo;
        var tempCubicInfo = await models.tbl_cubical.findAll({
          where: {
            Sys_IDSNo: strHmi
          }

        })
        tempCubicInfo = tempCubicInfo.pop()
        cubicalObj.Sys_BalID = tempCubicInfo.Sys_BalID
      }
      // if (Menuname.includes('%')) {
      //   DP = 2
      // } else {
      //   DP = 3
      // }
      let DP = _parameterObjPerFineAndParticalSizing.ProtocolDecPoint;
      let newWeight = maths.round(_parameterObjPerFineAndParticalSizing.ProtocolData, DP).toFixed(DP)//as per DS 
      let tempUserObject = globalData.arrUsers.find((k) => k.Hmi == strHmi);
      let productType = _parameterObjPerFineAndParticalSizing.productType.ProductType;
      let actualSampleValue = _parameterObjPerFineAndParticalSizing.seqNoOfWt;
      let noOfSample = _parameterObjPerFineAndParticalSizing.objProductDetails.noOfSample;
      let productDetail = globalData.arrProductTypeArray.find((k) => k.idsNo == strIdsNo).productDetail;
      let productMaster = globalData.arrProductTypeArray.find((k) => k.idsNo == strIdsNo).productType;
      let actualUnit = _parameterObjPerFineAndParticalSizing.ProtocolUnit;
      let decimalValue = _parameterObjPerFineAndParticalSizing.ProtocolDecPoint;
      let masterTable, detailTable, typeVal, WgmtModeNo;
      let limit = _parameterObjPerFineAndParticalSizing.productType
      let perDp = 2;
      var layer, T1NegTol, T1PosTol;
      var layerName = 'NA';
      if ((Menuname == GLOBAL_NOMENCLATURE.perFineMenu)) {
        layer = 'NA';
        T1NegTol = ((productDetail[0][0].Param46_Low == 99999) || (Number(productDetail[0][0].Param46_Low) == 0)) ? 'NA' : Number(productDetail[0][0].Param46_Low).toFixed(perDp);
        T1PosTol = ((productDetail[0][0].Param46_Upp == 99999) || (Number(productDetail[0][0].Param46_Upp) == 0)) ? 'NA' : Number(productDetail[0][0].Param46_Upp).toFixed(perDp);
      } else if (Menuname == GLOBAL_NOMENCLATURE.PSDMenu) {
        T1NegTol = ((productDetail[0][0].Param47_Low == 99999) || (Number(productDetail[0][0].Param47_Low) == 0)) ? 'NA' : Number(productDetail[0][0].Param47_Low).toFixed(perDp);
        T1PosTol = ((productDetail[0][0].Param47_Upp == 99999) || (Number(productDetail[0][0].Param47_Upp) == 0)) ? 'NA' : Number(productDetail[0][0].Param47_Upp).toFixed(perDp);
      }
      if ((Menuname == GLOBAL_NOMENCLATURE.perFineLayer1Menu) || (Menuname == GLOBAL_NOMENCLATURE.PSDLayer1Menu)) {
        layer = 'Layer 1';
        if (Menuname == GLOBAL_NOMENCLATURE.perFineLayer1Menu) {
          T1NegTol = ((productDetail[0][0].Param48_Low == 99999) || (Number(productDetail[0][0].Param48_Low) == 0)) ? 'NA' : Number(productDetail[0][0].Param48_Low).toFixed(perDp);
          T1PosTol = ((productDetail[0][0].Param48_Upp == 99999) || (Number(productDetail[0][0].Param48_Upp) == 0)) ? 'NA' : Number(productDetail[0][0].Param48_Upp).toFixed(perDp);
        } else {
          T1NegTol = ((productDetail[0][0].Param64_Low == 99999) || (Number(productDetail[0][0].Param64_Low) == 0)) ? 'NA' : Number(productDetail[0][0].Param64_Low).toFixed(perDp);
          T1PosTol = ((productDetail[0][0].Param64_Upp == 99999) || (Number(productDetail[0][0].Param64_Upp) == 0)) ? 'NA' : Number(productDetail[0][0].Param64_Upp).toFixed(perDp);
        }
        layerName = productMaster.IsBilayerLbl;
      } else if ((Menuname == GLOBAL_NOMENCLATURE.perFineLayer2Menu) || (Menuname == GLOBAL_NOMENCLATURE.PSDLayer2Menu)) {
        layer = 'Layer 2';
        if (Menuname == GLOBAL_NOMENCLATURE.perFineLayer2Menu) {
          T1NegTol = productDetail[0][0].Param49_Low == 99999 ? 'NA' : Number(productDetail[0][0].Param49_Low).toFixed(productDetail[0][0].Param49_DP);
          T1PosTol = productDetail[0][0].Param49_Upp == 99999 ? 'NA' : Number(productDetail[0][0].Param49_Upp).toFixed(productDetail[0][0].Param49_DP);
        } else {
          T1NegTol = productDetail[0][0].Param65_Low == 99999 ? 'NA' : Number(productDetail[0][0].Param65_Low).toFixed(productDetail[0][0].Param65_DP);
          T1PosTol = productDetail[0][0].Param65_Upp == 99999 ? 'NA' : Number(productDetail[0][0].Param65_Upp).toFixed(productDetail[0][0].Param65_DP);
        }
        layerName = productMaster.IsTrilayerLbl;
      }

      if (testType == "P") {
        if (productType == 1) {
          masterTable = "tbl_tab_master18_incomplete";
          detailTable = "tbl_tab_detail18_incomplete";
        } else {
          masterTable = "tbl_cap_master18_incomplete";
          detailTable = "tbl_cap_detail18_incomplete";
        }
        typeVal = 9;
        WgmtModeNo = 18;
      } else {
        if (productType == 1) {
          masterTable = "tbl_tab_master17_incomplete";
          detailTable = "tbl_tab_detail17_incomplete";
        } else {
          masterTable = "tbl_cap_master17_incomplete";
          detailTable = "tbl_cap_detail17_incomplete";
        }
        typeVal = 8;
        WgmtModeNo = 17;
      }


      if (actualSampleValue <= noOfSample) {
        var paramT1Neg = `Param${typeVal}_Low`;
        var paramT1Pos = `Param${typeVal}_Upp`;
        const masterData = await models[masterTable].findAll({
          attributes: [[sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"]],
          where: {
            BFGCode: cubicalObj.Sys_BFGCode,
            ProductName: cubicalObj.Sys_ProductName,
            PVersion: cubicalObj.Sys_PVersion,
            Version: cubicalObj.Sys_Version,
            BatchNo: cubicalObj.Sys_Batch,
          },
        });
        // const masterData = {
        //   str_tableName: masterTable,
        //   data: "MAX(RepSerNo) AS serialNo",
        //   condition: [
        //     { str_colName: "BFGCode", value: cubicalObj.Sys_BFGCode, comp: "eq" },
        //     {
        //       str_colName: "ProductName",
        //       value: cubicalObj.Sys_ProductName,
        //       comp: "eq",
        //     },
        //     {
        //       str_colName: "PVersion",
        //       value: cubicalObj.Sys_PVersion,
        //       comp: "eq",
        //     },
        //     { str_colName: "Version", value: cubicalObj.Sys_Version, comp: "eq" },
        //     { str_colName: "BatchNo", value: cubicalObj.Sys_Batch, comp: "eq" },
        //   ],
        // };
        // let result = await database.select(masterData);
        var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
        // if (IPQCObject != undefined) {
        //     strHmi = IPQCObject.idsNo;
        // } else {
        //     strHmi = strHmi;
        // }
        if (IPQCObject != undefined) {
          strHmi = IPQCObject.idsNo;
          var tempCubicInfo = await models.tbl_cubical.findAll({
            where: {
              Sys_IDSNo: strHmi
            }

          })
          tempCubicInfo = tempCubicInfo.pop()
          cubicalObj.Sys_BalID = tempCubicInfo.Sys_BalID
        }
        var intMstSerNo;
        if (actualSampleValue == 1) {
          intMstSerNo = 1;
          const masterObj = await models[masterTable].create({
            MstSerNo: intMstSerNo,
            InstruId: 1,
            BFGCode: cubicalObj.Sys_BFGCode,
            ProductName: cubicalObj.Sys_ProductName,
            ProductType: productType,
            Area: cubicalObj.Sys_Area,
            Department: cubicalObj.Sys_dept,
            Qty: noOfSample,
            GrpQty: noOfSample,
            GrpFreq: noOfSample,
            Idsno: strHmi,
            CubicalNo: cubicalObj.Sys_CubicNo,
            BalanceId: cubicalObj.Sys_BalID,
            VernierId: cubicalObj.Sys_VernierID,
            BatchNo: cubicalObj.Sys_Batch,
            UserId: tempUserObject.UserId,
            UserName: tempUserObject.UserName,
            PrDate: momentObj().format("YYYY-MM-DD"),
            PrTime: momentObj().format("HH:mm:ss"),
            Side: cubicalObj.Sys_RotaryType,
            Unit: actualUnit,
            DecimalPoint: DP,
            WgmtModeNo: WgmtModeNo,
            Nom: 0,
            StdLimit1: T1NegTol,
            StdLimit2: T1PosTol,
            CubicleType: cubicalObj.Sys_CubType,
            ReportType: cubicalObj.Sys_RptType,
            MachineCode: cubicalObj.Sys_MachineCode,
            MFGCode: cubicalObj.Sys_MfgCode,
            BatchSize: `${cubicalObj.Sys_BatchSize} ${cubicalObj.Sys_BatchSizeUnit}`,
            FriabilityID: cubicalObj.Sys_FriabID,
            HardnessID: cubicalObj.Sys_HardID,
            CubicleName: cubicalObj.Sys_CubicName,
            CubicleLocation: cubicalObj.Sys_dept,
            RepoLabel10: productMaster.IsBilayerLbl,
            RepoLabel11: cubicalObj.Sys_Validation,
            PrintNo: 0,
            IsArchived: 0,
            GraphType: 0,
            BatchComplete: 0,
            PVersion: cubicalObj.Sys_PVersion,
            Version: cubicalObj.Sys_Version,
            Lot: _parameterObjPerFineAndParticalSizing.objProductDetails.lotno, //objLotData.LotNo
            AppearanceDesc: cubicalObj.Sys_Appearance,
            MachineSpeed_Min: cubicalObj.Sys_MachineSpeed_Min,
            MachineSpeed_Max: cubicalObj.Sys_MachineSpeed_Max,
            GenericName: cubicalObj.Sys_GenericName,
            BMRNo: cubicalObj.Sys_BMRNo,
            Layer: layer,
            LayerName: layerName,
            Stage: cubicalObj.Sys_Stage,
            Inprocess: 1,
            SieveID: cubicalObj.Sys_SieveShakerID,
            Remark: 'NA',
            IPQCType: cubicalObj.Sys_IPQCType,
          });
          var masterResult = masterObj;
          var lastInsertedID = masterResult.dataValues.RepSerNo;
          const checkTabDetails = await models[detailTable].findAll({
            where: { RepSerNo: lastInsertedID }
          });
          var detaildata = checkTabDetails;
          // if (!Menuname.includes('%')) {
          if (detaildata.length == 0) {
            const detailObj = await models[detailTable].create({
              RepSerNo: lastInsertedID,
              MstSerNo: 0,
              RecSeqNo: 1,
              DataValue: Number(newWeight).toFixed(DP),
              DP: decimalValue,
              MeshValue: 'TestSample',
              StdLimit1: '-',
              StdLimit2: '-',
              SampleQuantity: newWeight,
              FinePer: '-'
            });
            // }
          }
          return masterResult
        } else {
          const checkTabDetails = await models[detailTable].findAll({
            attributes: [
              [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
            ],
          });
          let tabDetails = checkTabDetails;
          // const checkTabDetails = {
          //   str_tableName: detailTable,
          //   data: "MAX(RecNo) AS SeqNo",
          // };
          // let tabDetails = await database.select(checkTabDetails);
          // const selrepo = {
          //   str_tableName: detailTable,
          //   data: "*",
          //   condition: [{ str_colName: "RecNo", value: tabDetails[0][0].SeqNo }],
          // };
          // let resRepoSr = await database.select(selrepo);
          const selrepo = await models[detailTable].findAll({
            attributes: [
              [sequelize.fn("max", sequelize.col("RecSeqNo")), "RecSeqNo"],
            ],
            where: { RepSerNo: tabDetails[0].RepSerNo },
          });

          let resRepoSr = selrepo;

          var recSeqNo = resRepoSr[0].RecSeqNo + 1;

          tabDetails = await models[detailTable].findAll({
            where: {
              RepSerNo: tabDetails[0].RepSerNo
            }
          });

          var testSample = tabDetails[0].SampleQuantity;

          let meshValue = '', T2Neg, T2Pos, limit_msg, remark;
          if (testType == "P") {
            switch (recSeqNo) {
              case 2:
                meshValue = 'Above 20 Mesh';
                if (Menuname == GLOBAL_NOMENCLATURE.PSDMenu) {
                  T2Neg = productDetail[0][0].Param47_Low;
                  T2Pos = productDetail[0][0].Param47_Upp;
                } else if (Menuname == GLOBAL_NOMENCLATURE.PSDLayer1Menu) {
                  T2Neg = productDetail[0][0].Param64_Low;
                  T2Pos = productDetail[0][0].Param64_Upp;
                } else if (Menuname == GLOBAL_NOMENCLATURE.PSDLayer2Menu) {
                  T2Neg = productDetail[0][0].Param65_Low;
                  T2Pos = productDetail[0][0].Param65_Upp;
                }
                break;
              case 3:
                meshValue = 'Above 40 Mesh';
                if (Menuname == GLOBAL_NOMENCLATURE.PSDMenu) {
                  T2Neg = productDetail[0][0].Param47_Low;
                  T2Pos = productDetail[0][0].Param47_Upp;
                } else if (Menuname == GLOBAL_NOMENCLATURE.PSDLayer1Menu) {
                  T2Neg = productDetail[0][0].Param64_Low;
                  T2Pos = productDetail[0][0].Param64_Upp;
                } else if (Menuname == GLOBAL_NOMENCLATURE.PSDLayer2Menu) {
                  T2Neg = productDetail[0][0].Param65_Low;
                  T2Pos = productDetail[0][0].Param65_Upp;
                }
                break;
              case 4:
                meshValue = 'Above 60 Mesh';
                if (Menuname == GLOBAL_NOMENCLATURE.PSDMenu) {
                  T2Neg = productDetail[0][0].Param47_Low;
                  T2Pos = productDetail[0][0].Param47_Upp;
                } else if (Menuname == GLOBAL_NOMENCLATURE.PSDLayer1Menu) {
                  T2Neg = productDetail[0][0].Param64_Low;
                  T2Pos = productDetail[0][0].Param64_Upp;
                } else if (Menuname == GLOBAL_NOMENCLATURE.PSDLayer2Menu) {
                  T2Neg = productDetail[0][0].Param65_Low;
                  T2Pos = productDetail[0][0].Param65_Upp;
                }
                break;
              case 5:
                meshValue = 'Above 80 Mesh';
                if (Menuname == GLOBAL_NOMENCLATURE.PSDMenu) {
                  T2Neg = productDetail[0][0].Param47_Low;
                  T2Pos = productDetail[0][0].Param47_Upp;
                } else if (Menuname == GLOBAL_NOMENCLATURE.PSDLayer1Menu) {
                  T2Neg = productDetail[0][0].Param64_Low;
                  T2Pos = productDetail[0][0].Param64_Upp;
                } else if (Menuname == GLOBAL_NOMENCLATURE.PSDLayer2Menu) {
                  T2Neg = productDetail[0][0].Param65_Low;
                  T2Pos = productDetail[0][0].Param65_Upp;
                }
                break;
              case 6:
                meshValue = 'Above 100 Mesh';
                if (Menuname == GLOBAL_NOMENCLATURE.PSDMenu) {
                  T2Neg = productDetail[0][0].Param47_Low;
                  T2Pos = productDetail[0][0].Param47_Upp;
                } else if (Menuname == GLOBAL_NOMENCLATURE.PSDLayer1Menu) {
                  T2Neg = productDetail[0][0].Param64_Low;
                  T2Pos = productDetail[0][0].Param64_Upp;
                } else if (Menuname == GLOBAL_NOMENCLATURE.PSDLayer2Menu) {
                  T2Neg = productDetail[0][0].Param65_Low;
                  T2Pos = productDetail[0][0].Param65_Upp;
                }
                break;
              case 7:
                // meshValue = 'Below 100 Mesh';
                meshValue = 'The Fines on the collecting tray';
                if (Menuname == GLOBAL_NOMENCLATURE.PSDMenu) {
                  T2Neg = productDetail[0][0].Param47_Low;
                  T2Pos = productDetail[0][0].Param47_Upp;
                } else if (Menuname == GLOBAL_NOMENCLATURE.PSDLayer1Menu) {
                  T2Neg = productDetail[0][0].Param64_Low;
                  T2Pos = productDetail[0][0].Param64_Upp;
                } else if (Menuname == GLOBAL_NOMENCLATURE.PSDLayer2Menu) {
                  T2Neg = productDetail[0][0].Param65_Low;
                  T2Pos = productDetail[0][0].Param65_Upp;
                }
                break;
            }
          } else {
            switch (recSeqNo) {
              case 2:
                meshValue = '60 Mesh';
                if (Menuname == GLOBAL_NOMENCLATURE.perFineMenu) {
                  T2Neg = productDetail[0][0].Param46_Low;
                  T2Pos = productDetail[0][0].Param46_Upp;
                } else if (Menuname == GLOBAL_NOMENCLATURE.perFineLayer1Menu) {
                  T2Neg = productDetail[0][0].Param48_Low;
                  T2Pos = productDetail[0][0].Param48_Upp;
                } else if (Menuname == GLOBAL_NOMENCLATURE.perFineLayer2Menu) {
                  T2Neg = productDetail[0][0].Param49_Low;
                  T2Pos = productDetail[0][0].Param49_Upp;
                }
                break;
            }
          }

          const insertIncompleteDetailObj = await models[detailTable].create({
            RepSerNo: tabDetails[0].RepSerNo,
            MstSerNo: 0,
            RecSeqNo: recSeqNo,
            DataValue: Number(maths.round(newWeight, DP)).toFixed(DP),
            DecimalPoint: decimalValue,
            MeshValue: meshValue,
            StdLimit1: Number(maths.round(T2Neg, perDp)).toFixed(perDp),
            StdLimit2: Number(maths.round(T2Pos, perDp)).toFixed(perDp),
            Quantity: testSample,
            // FinePer: Number(maths.round((Number(newWeight) / Number(testSample)) * 100, perDp)).toFixed(perDp), //percentage
            // QuantityRetained: Number(maths.round((Number(newWeight) / Number(tabDetails[0].DataValue)) * 100,perDp)).toFixed(perDp), 
            FinePer: Number((Number(newWeight) / Number(testSample)) * 100).toFixed(perDp) == ('NAN' || 'Infinity') ? 0.0 :Number((Number(newWeight) / Number(testSample)) * 100).toFixed(perDp),
            QuantityRetained: ((Number(newWeight) / Number(tabDetails[0].DataValue)) * 100).toFixed(perDp)==('NaN'||"Infinity") ? 0.0 : ((Number(newWeight) / Number(tabDetails[0].DataValue)) * 100).toFixed(perDp), //for PSD
            
            //for PSD
            SampleQuantity: Number(maths.round(tabDetails[0].DataValue, DP)).toFixed(DP)
          });
          var PSDCal = await models[detailTable].findAll({ where: { RepSerNo: tabDetails[0].RepSerNo } });
          if (PSDCal.length == 7) {
            var cal = Number(PSDCal[4].FinePer) + Number(PSDCal[5].FinePer) + Number(PSDCal[6].FinePer);
            // var meshPer = Number(maths.round((maths.multiply((maths.divide(cal, maths.number(PSDCal[0].DataValue))), 100)), perDp)).toFixed(perDp)
            await models[detailTable].update({
              MeshPer: Number(cal).toFixed(perDp)
            }, {
              where: {
                RepSerNo: tabDetails[0].RepSerNo,
                MeshValue: 'Above 60 Mesh'
              }
            });

          }
          if (Menuname.includes('%')) { // %fine remark
            var perFine = Number((Number(newWeight) / Number(testSample)) * 100).toFixed(DP)==('NaN'||"Infinity") ? 0.0 :  Number((Number(newWeight) / Number(testSample)) * 100).toFixed(DP);

            // var perFine = Number((Number(newWeight) / Number(testSample)) * 100).toFixed(DP);
            newWeight =  Number(maths.round(perFine, perDp)).toFixed(perDp)
          } else if (PSDCal.length == 7) {
            newWeight = cal
          } else {
            newWeight = newWeight
          }

          // if (Number(newWeight) < Number(T2Neg)) {
          //   limit_msg = 'Below limit'
          // } else if (Number(newWeight) > Number(T2Pos)) {
          //   limit_msg = 'Above limit'
          // } else {
          //   limit_msg = 'within limit'
          // }
          if (T2Neg != 99999) {
            if (Number(newWeight) < Number(T2Neg)) {
              limit_msg = 'Below limit'
            }
          }
          if (T2Pos != 99999) {
            if (Number(newWeight) > Number(T2Pos)) {
              limit_msg = 'Above limit'
            }
            else {
              limit_msg = 'within limit'
            }
          }
          if ((T2Neg != 99999) && (T2Pos != 99999)) {
            if (Number(newWeight) < Number(T2Neg)) {
              limit_msg = 'Below limit'
            }
            if (Number(newWeight) > Number(T2Pos)) {
              limit_msg = 'Above limit'
            }
          }
          // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${meshValue}:${Number(newWeight)} ${limit_msg}`);
          const updateEndTimeObj = await models[masterTable].findAll({
            attributes: [
              [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
            ],
            where: {
              // PrEndDate: moment().format("YYYY-MM-DD"),
              // PrEndTime: moment().format("HH:mm:ss"),
              BFGCode: cubicalObj.Sys_BFGCode,
              ProductName: cubicalObj.Sys_ProductName,
              PVersion: cubicalObj.Sys_PVersion,
              BatchNo: cubicalObj.Sys_Batch,

            },
          });



          const Obj = await models[masterTable].findAll({
            where: {
              RepSerNo: updateEndTimeObj[0].RepSerNo
            },
          });
          // var get_Datavalue = await models[detailTable].findAll({ where: { RepSerNo: repSerNo } })
          // DataValue_arr.push(get_Datavalue);
          // var arr = [];
          // for (var i = 0; i < get_Datavalue.length; i++) {
          //   var a = get_Datavalue[i].DataValue;
          //   arr.push(Number(a));
          //   console.log(arr);
          // }
          // if (Menuname.includes('%')) {
          if (limit_msg == 'Below limit' || limit_msg == 'Above limit') {
            remark = 'Not Complies'
          } else {
            remark = 'Complies'
          }
          // }
          if (Obj[0].Remark == null || Obj[0].Remark != 'Not Complies') {
            if (actualSampleValue == noOfSample) {
              const Obj_update = await models[masterTable].update({
                Remark: remark
              }, {
                where: {
                  RepSerNo: updateEndTimeObj[0].RepSerNo
                }
              });
            }

          }
          return { meshValue: meshValue, msg: limit_msg, RepSerNo: tabDetails[0].RepSerNo }
        }
      }
    } catch (error) {

    }
  }

  async saveCompleteDataPerFineAndParticalSizing(dataObj, strTypeValue) {
    try {
      let masterTable;
      let detailTable;
      let strHmi = dataObj.strHmi;
      let testType = strTypeValue;
      let typeValue;
      let strIdsNo = dataObj.uniqueSerialNumber;
      let objProductDetail = globalData.arrProductTypeArray.find(
        (k) => k.Hmi == strHmi
      );
      let objProductType = objProductDetail.productType;

      if (testType == "P") {
        if (objProductType.ProductType == 1) {
          masterTable = "tbl_tab_master18";
          detailTable = "tbl_tab_detail18";
        } else {
          masterTable = "tbl_cap_master18";
          detailTable = "tbl_cap_detail18";
        }
        typeValue = 18;
      } else {
        if (objProductType.ProductType == 1) {
          masterTable = "tbl_tab_master17";
          detailTable = "tbl_tab_detail17";
        } else {
          masterTable = "tbl_cap_master17";
          detailTable = "tbl_cap_detail17";
        }
        typeValue = 17;
      }

      let result = await objIncompleteReport.getIncomepleteData(
        dataObj,
        masterTable,
        detailTable,
        strIdsNo
      );
      let isWTTrfr =
        await objWeighmentDataTransfer.saveDataToCompletePerFineAndParticalSizing(
          result,
          typeValue,
          strIdsNo
        );
      return isWTTrfr
    } catch (error) {
      throw new Error(error);
    }
  }

  async checkGranulation(typeValue, weightValue, IdsNo, strHmi) {
    try {


      // let IdsNo = IdsNo;
      let cubicalObj = globalData.arrIdsInfo.find((k) => k.idsNo == IdsNo).cubicalData;
      let responseObj = {};
      let objProductDetail = globalData.arrProductTypeArray.find((k) => k.Hmi == strHmi);
      let ProductType = objProductDetail.productType.ProductType;
      var masterTable, detailTable;
      if (typeValue == "P") {
        if (ProductType == 1) {
          masterTable = "tbl_tab_master18_incomplete";
          detailTable = "tbl_tab_detail18_incomplete";
        } else {
          masterTable = "tbl_cap_master18_incomplete";
          detailTable = "tbl_cap_detail18_incomplete";
        }
      } else {
        if (ProductType == 1) {
          masterTable = "tbl_tab_master17_incomplete";
          detailTable = "tbl_tab_detail17_incomplete";
        } else {
          masterTable = "tbl_cap_master17_incomplete";
          detailTable = "tbl_cap_detail17_incomplete";
        }
      }
      var incomingWt = parseFloat(weightValue);
      const masterData = await models[masterTable].findAll({
        attributes: [
          [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
        ],
        where: {
          BFGCode: cubicalObj.Sys_BFGCode,
          ProductName: cubicalObj.Sys_ProductName,
          PVersion: cubicalObj.Sys_PVersion,
          Version: cubicalObj.Sys_Version,
          BatchNo: cubicalObj.Sys_Batch,
        },
      });
      // {
      //     str_tableName: masterTable,
      //     data: 'MAX(RepSerNo) AS serialNo',
      //     condition: [
      //         { str_colName: 'BFGCode', value: cubicalObj.Sys_BFGCode, comp: 'eq' },
      //         { str_colName: 'ProductName', value: cubicalObj.Sys_ProductName, comp: 'eq' },
      //         { str_colName: 'PVersion', value: cubicalObj.Sys_PVersion, comp: 'eq' },
      //         { str_colName: 'Version', value: cubicalObj.Sys_Version, comp: 'eq' },
      //         { str_colName: 'BatchNo', value: cubicalObj.Sys_Batch, comp: 'eq' },
      //     ]
      // }
      let masterResult = masterData;
      var masterSrNo = masterResult[0].RepSerNo;
      const detailData = await models[detailTable].findAll({
        where: {
          RepSerNo: masterSrNo,
        },
      });
      //  {
      //     str_tableName: detailTable,
      //     data: '*',
      //     condition: [
      //         { str_colName: 'RepSerNo', value: masterSrNo, comp: 'eq' },
      //     ]
      // }
      let detailResult = detailData;
      var finalData = detailResult[0];
      var arrReading;
      arrReading = [];
      if (finalData != undefined) {
        for (var i = 0; i < finalData.length; i++) {
          var val = finalData[i].DataValue;
          arrReading.push(val);
        }
      }
      var sampleval = arrReading.shift();
      // console.log('sampleval   '+sampleval);
      // console.log(arrReading);
      var sumval = 0;
      var sumFinalVal;
      if (arrReading.length == 0) {
        if (sampleval < incomingWt) {
          Object.assign(responseObj, { result: "fail" });
          return responseObj;
        } else {
          Object.assign(responseObj, { result: "success" });
          return responseObj;
        }
        arrReading = "";
      } else {
        for (var j = 0; j < arrReading.length; j++) {
          sumval += parseFloat(arrReading[j]);
        }
        sumFinalVal = sumval;
        var finalCount = sumFinalVal;
        if (sampleval < finalCount) {
          Object.assign(responseObj, { result: "fail" });
          return responseObj;
        } else {
          Object.assign(responseObj, { result: "success" });
          return responseObj;
        }
        arrReading = "";
      }
    } catch (error) {
      console.log(error)

    }
  }

  async insert_Into_Incomplete_Master_Empty(dataObj) {
    const strTableName = dataObj.strTableName;
    const strIdsNo = dataObj.uniqueSerialNumber;
    let objSelMenu = globalData.arrSelectedMenu.find(
      (k) => k.idsNo == strIdsNo
    );
    const objProductDetails = objSelMenu.selectedProductDetail;
    const strBalId = dataObj.strBalId;
    const ProtocolData = dataObj.ProtocolData;
    const ProtocolUnit = dataObj.ProtocolUnit;
    const ProtocolDecPoint = dataObj.ProtocolDecPoint;
    const strHmi = dataObj.strHmi;
    // const intProductType = dataObj.productType.ProductType;
    // const intNominal = dataObj.productType.nominal;
    let side;
    if (dataObj.objProductDetails.Rotary == "Single") {
      side = "NA";
    } else if (dataObj.objProductDetails.Rotary == "Double") {
      side = "LHS";
    }

    let hmiDetailsInPMenu = globalData.arrIdsInfo.find(
      (k) => k.Hmi == strHmi
    ).cubicalData;
    //const objSelMenu = globalData.arrSelectedMenu.find(k => k.idsNo == strIdsNo);
    let selectedIdsNo;
    var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.idsNo == strIdsNo);
    if (IPQCObject != undefined) {
      selectedIdsNo = IPQCObject.selectedIds;
    } else {
      selectedIdsNo = strIdsNo;
    }

    let selectedCub = globalData.arrIdsInfo.find(
      (k) => k.idsNo == selectedIdsNo
    ).cubicalData;

    let productMaster = globalData.arrProductTypeArray.find(
      (k) => k.idsNo == selectedIdsNo
    );


    let tblName = strTableName.concat("_incomplete");

    const insertObj = await models[tblName].create({
      MstSerNo: 1,
      InstruId: 1,
      BFGCode: dataObj.objProductDetails.ProductId,
      ProductName: dataObj.objProductDetails.ProductName,
      Qty: dataObj.objProductDetails.noOfSample,
      GrpQty: 0,
      GrpFreq: 0,
      Idsno: strHmi,
      CubicalNo: selectedCub.Sys_CubicNo,
      BalanceId: hmiDetailsInPMenu.Sys_BalID,
      BalanceNo: 0,
      VernierId: hmiDetailsInPMenu.Sys_VernierID,
      VernierNo: 0,
      BatchNo: dataObj.objProductDetails.Batch,
      UserId: dataObj.objProductDetails.userid,
      UserName: dataObj.objProductDetails.userName,
      PrDate: date.format(now, "YYYY-MM-DD"),
      PrTime: date.format(now, "HH:mm:ss"),
      PrEndDate: date.format(new Date(), "YYYY-MM-DD"),
      PrEndTime: date.format(new Date(), "HH:mm:ss"),
      // PrEndTime: '',
      Side: "NA",
      Unit: ProtocolUnit,
      DecimalPoint: ProtocolDecPoint,
      WgmtModeNo: 1,
      //    Nom: intNominal,
      //    T1NegTol: objProductDetails.T1Neg,
      //    T1PosTol: objProductDetails.T1Pos,
      //    T2NegTol: objProductDetails.T2Neg,
      //    T2PosTol: objProductDetails.T2Pos,
      limitOn: 0,
      // T1NMTTab:  objProductDetailsNMT
      NomEmpty: 0,
      T1NegEmpty: 0,
      T1PosEmpty: 0,
      T2NegEmpty: 0,
      T2PosEmpty: 0,
      NomNet: 0,
      T1NegNet: 0,
      T1PosNet: 0,
      T2NegNet: 0,
      T2PosNet: 0,
      CubicleType: selectedCub.Sys_CubType,
      ReportType: 0,
      MachineCode: selectedCub.Sys_MachineCode,
      MFGCode: selectedCub.Sys_MfgCode,
      BatchSize: selectedCub.Sys_BatchSize,
      FriabilityID: hmiDetailsInPMenu.Sys_FriabID,
      HardnessID: hmiDetailsInPMenu.Sys_HardID,
      CubicleName: selectedCub.Sys_CubicName,
      CubicleLocation: selectedCub.Sys_Location,
      RepoLabel10: "Standard",
      RepoLabel11: 0,
      RepoLabel12: "Null",
      RepoLabel13: "Null",
      PrintNo: 0,
      IsArchived: 0,
      GraphType: 0,
      BatchComplete: 0,
      PVersion: selectedCub.Sys_PVersion,
      Version: selectedCub.Sys_Version,
      BRepSerNo: 0,
      Lot: selectedCub.Sys_LotNo,
      Area: selectedCub.Sys_Area,
    });

    let arrResult = [insertObj];
    return arrResult[0];
  }
  catch(error) {
    console.log(error);
  }
  async saveCompleteEmptyData(dataObj, strTypeValue) {
    try {
      let masterTable;
      let detailTable;
      let strHmi = dataObj.strHmi;
      let typeValue = strTypeValue;
      let strIdsNo = dataObj.uniqueSerialNumber;

      let selectedIdsNo;
      var IPQCObject = globalData.arr_IPQCRelIds.find(
        (k) => k.idsNo == strIdsNo
      );
      if (IPQCObject != undefined) {
        selectedIdsNo = IPQCObject.selectedIds;
      } else {
        selectedIdsNo = strIdsNo;
      }
      if (dataObj.objProductDetails.menuName == "EMPTY") {
        masterTable = "tbl_cap_master9";
        detailTable = "tbl_cap_detail9";
      }

      // const __paramGetInComp = {
      //     data: dataObj,
      //     masterTable: masterTable,
      //     detailTable: detailTable,
      //     strIdsNo: strIdsNo
      // }
      let result = await objIncompleteReport.getIncomepleteEmptyShellData(
        dataObj,
        masterTable,
        detailTable,
        strHmi
      );
      // let reportStatus = await this.removeLimitForRemark(result, typeValue, strIdsNo, objProductType)
      // await objBatchSummary.saveBatchSummaryEmpty(typeValue, result, strHmi, strIdsNo);
      let isWTTrfr = await objWeighmentDataTransfer.saveEmptyDataToComplete(
        result,
        typeValue,
        strHmi
      );
      await this.deleteEmptyIncompleteRemarkEntry(strHmi, strIdsNo);
    } catch (error) {
      throw new Error(error);
    }
  }

  async deleteEmptyIncompleteRemarkEntry(strHmi, strIdsNo) {
    try {
      let CubicInfo = globalData.arrIdsInfo.find((k) => k.Hmi == strHmi);
      let StrBatch = CubicInfo.cubicalData.Sys_Batch;
      const objRemark = await models.tbl_remark_incomplete_master.destroy({
        where: {
          IDSNo: strHmi,
          BatchNumber: StrBatch,
        },
      });
      //  {
      //     str_tableName: "tbl_remark_incomplete_master",
      //     data: '*',
      //     condition: [
      //         { str_colName: 'IDSNo', value: strIdsNo },
      //         { str_colName: 'BatchNumber', value: StrBatch }
      //     ]
      // }
    } catch (error) {
      throw new Error(error);
    }
  }

  async insert_Into_Incomplete_Empty_Detail(dataObj) {
    try {
      const strmasterTbl = dataObj.strTableName;
      const strDetailTbl = dataObj.strDetailTbl;
      const strHmi = dataObj.strHmi;
      const strProtocolData = dataObj.ProtocolData;
      const strDecPoint = dataObj.ProtocolDecPoint;
      const seqNoOfWt = dataObj.seqNoOfWt;
      let decimal;
      let strIdsNo = dataObj.uniqueSerialNumber;
      let selectedIdsNo;

      var IPQCObject = globalData.arr_IPQCRelIds.find(
        (k) => k.idsNo == strIdsNo
      );
      if (IPQCObject != undefined) {
        selectedIdsNo = IPQCObject.selectedIds;
      } else {
        selectedIdsNo = strIdsNo;
      }

      let hmiDetailsInPMenu = globalData.arrIdsInfo.find(
        (k) => k.idsNo == selectedIdsNo
      ).cubicalData;

      let repSerNo = await this.lastInsertedRecords(
        hmiDetailsInPMenu.Sys_ProductName,
        hmiDetailsInPMenu.Sys_BFGCode,
        hmiDetailsInPMenu.Sys_PVersion,
        hmiDetailsInPMenu.Sys_Version,
        strmasterTbl
      );

      /**
       * get decimal
       */
      let tbName = strDetailTbl.concat("_incomplete");
      const selectRepSrNoObj = await models[tbName].findAll({
        where: {
          RepSerNo: repSerNo,
        },
      });
      // {
      //     str_tableName: strDetailTbl.concat('_incomplete'),
      //     data: '*',
      //     condition: [
      //         { str_colName: 'RepSerNo', value: repSerNo, comp: 'eq' },

      //     ]
      // }
      let arrResult_RepNo = [selectRepSrNoObj];
      if (arrResult_RepNo[0].length == 0) {
        decimal = strDecPoint;
      } else {
        decimal = arrResult_RepNo[0][0].DecimalPoint;
      }

      var tableName = strDetailTbl.concat("_incomplete");
      const insertDetail = await models[tableName].create({
        RepSerNo: repSerNo,
        MstSerNo: 0,
        RecSeqNo: seqNoOfWt,
        DataValue: strProtocolData,
        DecimalPoint: decimal,
        UserId: dataObj.objProductDetails.userid,
        UserName: dataObj.objProductDetails.userName,
        PrDate: date.format(now, "YYYY-MM-DD"),
        PrTime: date.format(now, "HH:mm:ss"),
        PrEndDate: date.format(new Date(), "YYYY-MM-DD"),
        PrEndTime: date.format(new Date(), "HH:mm:ss"),
      });
      //  {
      //     str_tableName: strDetailTbl + "_incomplete",
      //     data: [
      //         { str_colName: 'RepSerNo', value: repSerNo },
      //         { str_colName: 'MstSerNo', value: 0 },
      //         { str_colName: 'RecSeqNo', value: seqNoOfWt },
      //         { str_colName: 'DataValue', value: strProtocolData },
      //         { str_colName: 'DecimalPoint', value: decimal }
      //     ]
      // }

      let arrResult = [insertDetail];
      return decimal;
    } catch (error) {
      throw new Error(error);
    }
  }

  async getMaxBRepSerNo(
    productName,
    strBatch,
    strTableName,
    reportType,
    incomplete,
    Sys_CubType
  ) {
    try {
      const tblDetails = await models[strTableName].findAll({
        attributes: [
          [sequelize.fn("max", sequelize.col("BRepSerNo")), "BRepSerNo"],
        ],

        where: {
          // PVersion: selectedCub.Sys_PVersion,
          // Version: selectedCub.Sys_Version,
          BatchNo: strBatch,
          BFGCode: dataObj.objProductDetails.ProductId,
          ProductName: productName,
          ReportType: reportType,
          CubicleType: Sys_CubType,
        },
      });

      if (incomplete == undefined) {
        incomplete = strTableName.concat("_incomplete");
      }

      const tblDetails1 = await models[incomplete].findAll({
        attributes: [
          [sequelize.fn("max", sequelize.col("BRepSerNo")), "BRepSerNo"],
        ],
        where: {
          // PVersion: selectedCub.Sys_PVersion,
          // Version: selectedCub.Sys_Version,
          BatchNo: strBatch,
          BFGCode: dataObj.objProductDetails.ProductId,
          ProductName: productName,
          ReportType: reportType,
          CubicleType: Sys_CubType,
        },
      });
      let incomBRepSerNo = 0;
      let BRepSerNo = 0;

      if (tblDetails.length != 0) {
        let maxColumn = tblDetails.length >= 1 ? tblDetails.pop() : tblDetails;
        BRepSerNo = maxColumn.BRepSerNo + 1;
      }
      if (tblDetails1.length != 0) {
        let maxColumninc =
          tblDetails1.length >= 1 ? tblDetails1.pop() : tblDetails1;
        incomBRepSerNo = maxColumninc.BRepSerNo + 1;
      }
      let result = Math.max(BRepSerNo, incomBRepSerNo);
      if (result == 0) {
        return 1;
      } else {
        return isNaN(result) ? 1 : result;
      }
    } catch (error) {
      throw new Error(error);
    }
  }

  async saveDiffCompleteData(dataObj, strTypeValue) {
    try {
      let masterTable;
      let detailTable;
      let strHmi = dataObj.strHmi;
      let typeValue = strTypeValue;
      let strIdsNo = dataObj.uniqueSerialNumber;

      let selectedIdsNo;
      // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
      // if (IPQCObject != undefined) {
      //     strHmi = IPQCObject.selectedIds.Idsno;
      // } else {
      //     strHmi = strHmi;
      // }

      let objProductDetail = globalData.arrProductTypeArray.find(
        (k) => k.Hmi == strHmi
      );
      let objProductType = objProductDetail.productType;

      if (objProductType.ProductType == 1) {
        masterTable = "tbl_tab_master" + typeValue;
        detailTable = "tbl_tab_detail" + typeValue;
      } else if (
        objProductType.ProductType == 2 ||
        objProductType.ProductType == 4
      ) {
        if (typeValue == "D") {
          masterTable = "tbl_cap_master3";
          detailTable = "tbl_cap_detail3";
        } else {
          masterTable = "tbl_cap_master" + typeValue;
          detailTable = "tbl_cap_detail" + typeValue;
        }
      } else if (objProductType.ProductType == 5) {
        masterTable = "tbl_tab_master19";
        detailTable = "tbl_tab_detail19";
      }

      // const __paramGetInComp = {
      //     data: dataObj,
      //     masterTable: masterTable,
      //     detailTable: detailTable,
      //     strIdsNo: strIdsNo
      // }

      // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.selectedIds.Idsno == strHmi);
      // if (IPQCObject != undefined) {
      //     strHmi = IPQCObject.idsNo;
      // } else {
      //     strHmi = strHmi;
      // }

      let result = await objIncompleteReport.getDiffIncomepleteData(
        dataObj,
        masterTable,
        detailTable,
        strHmi
      );
      let reportStatus = await this.removeLimitForRemark(
        result,
        typeValue,
        strHmi,
        objProductType
      );
      if (typeValue == "D") {
        await objBatchSummary.saveBatchDataDiff(
          "D",
          result,
          strHmi,
          reportStatus
        );
      } else {
        await objBatchSummary.saveBatchData(
          typeValue,
          result,
          strHmi,
          strIdsNo
        );
      }

      let saveResponse = await objWeighmentDataTransfer.saveDiffDataToComplete(
        result,
        typeValue,
        strHmi
      );
      await this.deleteIncompleteRemarkEntry(strHmi, strIdsNo);

      // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}:${reportStatus}`);
      return { reportStatus: reportStatus, RepSerNo: saveResponse.RepSerNo };
    } catch (error) {
      throw new Error(error);
    }
  }
}

module.exports = InsertOperation;
