const moment = require('moment');


const ClassweighmentData = require('../clsProcessWeighment.model');
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const classHmi = require('../hmiDetail.model');
const mqttProtocols = require('../../global/GLOBAL_NOMENCLATURE');
const loggers = require('../winstonLogger');
const globalData = require('../../global/globalData');
const clsMqttSender = require('../Mqtt/mqttSender.class');
const savingObject = require('../Test/clsLod.method')
const datasave = new savingObject()
const GLOBAL_NOMENCLATURE = require('../../global/GLOBAL_NOMENCLATURE');
const clsActivityLog = require('../clsActivityLog.model');
const objActivityLog = new clsActivityLog();
const objWeighmentData = new ClassweighmentData();
const models = require('../../../config/dbConnection').models;

const objHmi = new classHmi();
const mqttSender = new clsMqttSender();

class MoistureAnalyserParsing {

  precision(a) {
    if (!isFinite(a)) return 0;
    var e = 1, p = 0;
    while (Math.round(a * e) / e !== a) { e *= 10; p++; }
    return p;
  }

  async parseMoistureAnalyserData(dataObj) {
    try {
        var { str_Protocol, strResberryPi, strHmi, ProtocolPortNo, InstrumentId, ProtocolName } = dataObj;
        //const EQUIP_MODEL_NAME = await this.getDetailOfBulkInstrumentModel(instrumentId);
        var LodInfo = await this.getDetailOfBulkInstrumentModel(InstrumentId, "Moisture Analyzer");
        var LodModel = LodInfo.Eqp_Model
        var result;
        if (LodModel == 'HS153') {
            await this.parseMoistureAnalyserData_HS153(dataObj)
            return;
        } else if (LodModel == 'HR83') {
            await this.parseMoistureAnalyserData_HR83(dataObj)
            return
        } 
        return

    } catch (error) {
        throw new Error(error)
    }
}

  async parseMoistureAnalyserData_HS153(dataObj) {
    try {
      var { str_Protocol, strResberryPi, strHmi, ProtocolPortNo, instrumentId, ProtocolName } = dataObj;
      var strHmi = dataObj.strHmi;
      var IdsNo = dataObj.strResberryPi;
      var actualProtocol = dataObj.str_Protocol.trim();
      let str_1 = actualProtocol.split("\n");
      var mqtt_Port = dataObj.ProtocolPortNo;
      var tempCubicInfo = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData
      var tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
      //here also different balance have different parsing logic
      // let data_array = str_Protocol.split("\n");
      // let data = str_Protocol.split(":")[2].trim();
      let test_duration_found = false;
      let arm_found = false;
      let arr = [];
      let obj = {}
      var flag = false
      for (let i = 0; i < str_1.length; i++) {
        if (str_1[i].trim().length === 0) continue
        if (str_1[i].includes("Type")) {
          let Modal = str_1[i].replace('Type', ' ').trim().split();
          Modal = Modal[0]
          if ((parseInt(Modal)) == undefined) {
            // await this.ActivityLog(IdsNo, `Invalid Data`)
            return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`);
          }
          obj["Modal"] = Modal;
          arr.push({ "Modal": Modal })
        }

        // if (str_1[i].includes("Start Weight")) {
        //   // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
        //   let Start_Weight = str_1[i].replace('Start Weight', ' ').trim().split(' ');
        //   Start_Weight = Start_Weight[0];
        //   if (Start_Weight != 'off') {
        //     if (isNaN(Start_Weight) == true || Start_Weight == '' || Start_Weight == undefined) {
        //       // await this.ActivityLog(strHmi, `Invalid Data`)
        //       return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`);
        //     }
        //     Start_Weight = { 'iniWt': Number(Start_Weight).toFixed(3), 'flag': true, 'type': arr[0].Modal };
        //     obj["iniWt"] = Start_Weight;
        //     arr.push({ "iniWt": Start_Weight })
        //   }
        // }

        // if (i > 32) {
        //   flag = true
        // } else {
        //   flag = false
        // }
        // if(flag == true){
        if (str_1[i].includes("Start Weight")) {
          if (str_1[i].includes("Start Weight Tol")) {
            console.log("start weight tol")
            continue;
          }
          
          if (flag == false){
            flag = true;
            continue;
          }
           else if (flag == true) {
            // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
            // var processMenu = await this.considerSecondOccurrence(actualProtocol);
            let Start_Weight = str_1[i].replace('Start Weight', ' ').trim().split(' ');
            Start_Weight = Start_Weight[0];
            if (Start_Weight != 'off') {
              if (isNaN(Start_Weight) == true || Start_Weight == '' || Start_Weight == undefined) {
                // await this.ActivityLog(strHmi, `Invalid Data`)
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`);
              }
              Start_Weight = { 'iniWt': Number(Start_Weight).toFixed(3), 'flag': true, 'type': arr[0].Modal };
              obj["iniWt"] = Start_Weight;
              arr.push({ "iniWt": Start_Weight })
            }
          }
        }
      // }

        if (str_1[i].includes("Dry Weight")) {
          let Dry_Weight = str_1[i].replace('Dry Weight', ' ').trim().split(' ');
          Dry_Weight = Dry_Weight[0]
          if (isNaN(Dry_Weight) == true || Dry_Weight == '' || Dry_Weight == undefined) {
            // await this.ActivityLog(strHmi, `Invalid Data`)
            return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`);
          }
          Dry_Weight = { 'finalWt': Number(Dry_Weight).toFixed(3), 'flag': true };
          obj["finalWt"] = Dry_Weight;
          arr.push({ "finalWt": Dry_Weight })
        }

        if (str_1[i].includes("Drying Temp")) {
          let Drying_Temp = str_1[i].trim().replace('Drying Temp', ' ').trim().split(' ');
          Drying_Temp = Drying_Temp[0]
          if (isNaN(Drying_Temp) == true || Drying_Temp == '' || Drying_Temp == undefined) {
            // await this.ActivityLog(strHmi, `Invalid Data`)
            return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`);
          }
          Drying_Temp = { 'setTemp': Drying_Temp, 'flag': true };
          obj["setTemp"] = Drying_Temp;
          arr.push({ "setTemp": Drying_Temp })
        }

        if (str_1[i].includes("Total Time")) {

          const timeRegex = /(\d+:\d+)/;
          const match = str_1[i].match(timeRegex);

          if (match) {
            var timeString = match[1];

            const [hours, minutes] = timeString.split(':').map(Number);

            const totalTimeInMinutes = hours * 60 + minutes;

            console.log('Total time in minutes:', totalTimeInMinutes);
          } else {
            return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`);
          }
          var Total_Time = str_1[i].replace('Total Time', ' ').trim().split();
          Total_Time = Total_Time[0]
          var time_data = Total_Time.trim().split(' min')
          var time_data = "00:" + "0" + time_data[0]
          var time_data = time_data.trim()
          // var time_data = time_valur[1]

          // const time = /min$/
          var time = /^([0-1]?\d|2[0-3])(?::([0-5]?\d))?(?::([0-5]?\d))?$/

          if (time.test(time_data) == false) {
            // await this.ActivityLog(strHmi, `Invalid Data`)
            return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`);
          }
          // if  (isNaN(parseInt(Total_Time)) == true || Total_Time.endsWith('min') == false) {
          //   await this.ActivityLog(strHmi, `Invalid Data`)
          //   return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
          //   }else{
          //   var Total_Time = str_1[i].replace('Total Time', ' ').trim().split(' ');
          //   // Total_Time = Total_Time[0]
          //   const time = /^\d+:\d{2}\s+min$/
          //   if (time.test(Total_Time[0])){
          //     await this.ActivityLog(strHmi, `Invalid Data`)
          //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
          //   } 

          //   // if (isNaN(Total_Time[0]) == true || Total_Time[1].includes('min') == false) {
          //   //   await this.ActivityLog(strHmi, `Invalid Data`)
          //   //   return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
          //   // }
          // }
          timeString = { 'totaltime': time_data, 'flag': true };
          obj["totaltime"] = time_data;
          arr.push({ "totaltime": time_data })
        }

        // else {
        //   // var Error = "Invalid String"
        //   // console.log(Error)
        //   await this.ActivityLog(strHmi, `Invalid Data`)
        //   return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
        // }
      }

      console.log(obj);
      dataObj.Parsedata = arr;
      // var Parsedata = dataObj.Parsedata
      console.log(arr)

      if (obj != undefined) {
        if (!obj["Modal"] || obj.iniWt == undefined || obj.Modal == '' || obj.finalWt == undefined || obj.setTemp == undefined
          || obj.totaltime == undefined) {
          mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
          return
        }
      }
      if (arr.length == 0) {
        // return mqttSender.sendData(strHmi, "Invalid String recieved")
        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`);

      }
      let dtData = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi).data;
      let currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.Hmi == strHmi);
      let tempCailibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);
      // let arrPortDetailForStart1 = await objHmi.idsPortSetting(strHmi)
      // let intPortNo1 = arrPortDetailForStart1.Sys_PortNo;
      // let strInstrumentType = arrPortDetailForStart1.Instrument_type;
      let strInstrumentId = dataObj.InstrumentId;
      const __parameterWeighmentObj = {
        idsNo: strResberryPi,
        Hmi: strHmi,
        actualWt: arr[0],
        instrumentId: strInstrumentId,
        dataObj: dataObj
      }
      if (arr == "") {
        return mqttSender.sendData(strHmi, "Invalid String Recieved")
      } else {
        // if (strInstrumentType == GLOBAL_NOMENCLATURE.Balance) {
        //     if (ProtocolUnit == undefined) {
        //         ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;
        //     } else {
        //         if ((ProtocolUnit != "g") && (ProtocolUnit != "kg") && (ProtocolUnit != "mg")) {
        //             //log protocol in file
        //             loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}Invalid Data String sended to device ${strHmi}`)
        //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid Data String`);
        //         } else {
        //             if (ProtocolUnit == "mg") {
        //                 actualWt = actualWt / 1000;
        //             } else if (ProtocolUnit == ("kg" || "Kg" || "KG")) {
        //                 actualWt = actualWt * 1000;
        //             }
        //             ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;

        //         }
        //     }

        // } else {
        //     //log protocol in file
        //     loggers.MqttProtocolLogger.info(`unknown instrument`)
        //     console.log('unknown instrument');
        // }

        //decision making 
        if (tempCailibType == undefined) {
          if (currentOpStatus == undefined) {
            loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
            console.log('wt recieve without any api called');
            return;
          } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

            await objWeighmentData.ParsingTestData(__parameterWeighmentObj);
          }
        } else {
          console.log('calibration is on and dt weighment part has clash')
        }
      }
      // }
      // } catch (error) {
      //     throw new Error(error)
      // }




    } catch (error) {
      throw new Error(error)
    }
  }

  async parseMoistureAnalyserData_HR83(dataObj) {
    try {
      var { str_Protocol, strResberryPi, strHmi, ProtocolPortNo, instrumentId, ProtocolName } = dataObj;
      var strHmi = dataObj.strHmi;
      var IdsNo = dataObj.strResberryPi;
      var actualProtocol = dataObj.str_Protocol.trim();
      let str_1 = actualProtocol.split("\n");
      var mqtt_Port = dataObj.ProtocolPortNo;
      var tempCubicInfo = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData
      var tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
      //here also different balance have different parsing logic
      // let data_array = str_Protocol.split("\n");
      // let data = str_Protocol.split(":")[2].trim();
      let test_duration_found = false;
      let arm_found = false;
      let arr = [];
      let obj = {}
      for (let i = 0; i < str_1.length; i++) {
        if (str_1[i].trim().length === 0) continue
        if (str_1[i].includes("Type:")) {
          let Modal = str_1[i].replace('Type:', ' ').trim().split();
          Modal = Modal[0]
          if ((parseInt(Modal)) == undefined) {
            // await this.ActivityLog(IdsNo, `Invalid Data`)
            return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`);
          }
          obj["Modal"] = Modal;
          arr.push({ "Modal": Modal })
        }

        // if (str_1[i].includes("Start Weight")) {
        //   // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
        //   let Start_Weight = str_1[i].replace('Start Weight', ' ').trim().split(' ');
        //   Start_Weight = Start_Weight[0];
        //   if (Start_Weight != 'off') {
        //     if (isNaN(Start_Weight) == true || Start_Weight == '' || Start_Weight == undefined) {
        //       // await this.ActivityLog(strHmi, `Invalid Data`)
        //       return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`);
        //     }
        //     Start_Weight = { 'iniWt': Number(Start_Weight).toFixed(3), 'flag': true, 'type': arr[0].Modal };
        //     obj["iniWt"] = Start_Weight;
        //     arr.push({ "iniWt": Start_Weight })
        //   }
        // }

        // var flag
        // if (i > 32) {
        //   flag = true
        // } else {
        //   flag = false
        // }
        // if(flag == true){
        if (str_1[i].includes("Wet weight")) {
            let Start_Weight = str_1[i].replace('Wet weight', ' ').trim().split(' ');
            Start_Weight = Start_Weight[0];
            if (Start_Weight != 'off') {
              if (isNaN(Start_Weight) == true || Start_Weight == '' || Start_Weight == undefined) {
                // await this.ActivityLog(strHmi, `Invalid Data`)
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`);
              }
              Start_Weight = { 'iniWt': Number(Start_Weight).toFixed(3), 'flag': true, 'type': arr[0].Modal };
              obj["iniWt"] = Start_Weight;
              arr.push({ "iniWt": Start_Weight })
            }
          
        }
      // }

        if (str_1[i].includes("Dry weight")) {
          let Dry_Weight = str_1[i].replace('Dry weight', ' ').trim().split(' ');
          Dry_Weight = Dry_Weight[0]
          if (isNaN(Dry_Weight) == true || Dry_Weight == '' || Dry_Weight == undefined) {
            // await this.ActivityLog(strHmi, `Invalid Data`)
            return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`);
          }
          Dry_Weight = { 'finalWt': Number(Dry_Weight).toFixed(3), 'flag': true };
          obj["finalWt"] = Dry_Weight;
          arr.push({ "finalWt": Dry_Weight })
        }

        if (str_1[i].includes("Drying temp.")) {
          let Drying_Temp = str_1[i].trim().replace('Drying temp.', ' ').trim().split(' ');
          Drying_Temp = Drying_Temp[0]
          if (isNaN(Drying_Temp) == true || Drying_Temp == '' || Drying_Temp == undefined) {
            // await this.ActivityLog(strHmi, `Invalid Data`)
            return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`);
          }
          Drying_Temp = { 'setTemp': Drying_Temp, 'flag': true };
          obj["setTemp"] = Drying_Temp;
          arr.push({ "setTemp": Drying_Temp })
        }

        if (str_1[i].includes("Total time")) {

          const timeRegex = /(\d+:\d+)/;
          const match = str_1[i].match(timeRegex);

          if (match) {
            var timeString = match[1];

            const [hours, minutes] = timeString.split(':').map(Number);

            const totalTimeInMinutes = hours * 60 + minutes;

            console.log('Total time in minutes:', totalTimeInMinutes);
          } else {
            return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`);
          }
          var Total_Time = str_1[i].replace('Total time', ' ').trim().split();
          Total_Time = Total_Time[0]
          var time_data = Total_Time.trim().split(' min')
          var time_data = "00:" + "0" + time_data[0]
          var time_data = time_data.trim()
          // var time_data = time_valur[1]

          // const time = /min$/
          var time = /^([0-1]?\d|2[0-3])(?::([0-5]?\d))?(?::([0-5]?\d))?$/

          if (time.test(time_data) == false) {
            // await this.ActivityLog(strHmi, `Invalid Data`)
            return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`);
          }
          
          timeString = { 'totaltime': time_data, 'flag': true };
          obj["totaltime"] = time_data;
          arr.push({ "totaltime": time_data })
        }

        // else {
        //   // var Error = "Invalid String"
        //   // console.log(Error)
        //   await this.ActivityLog(strHmi, `Invalid Data`)
        //   return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
        // }
      }

      console.log(obj);
      dataObj.Parsedata = arr;
      // var Parsedata = dataObj.Parsedata
      console.log(arr)

      if (obj != undefined) {
        if (!obj["Modal"] || obj.iniWt == undefined || obj.Modal == '' || obj.finalWt == undefined || obj.setTemp == undefined
          || obj.totaltime == undefined) {
          mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
          return
        }
      }
      if (arr.length == 0) {
        // return mqttSender.sendData(strHmi, "Invalid String recieved")
        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`);

      }
      let dtData = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi).data;
      let currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.Hmi == strHmi);
      let tempCailibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);
      // let arrPortDetailForStart1 = await objHmi.idsPortSetting(strHmi)
      // let intPortNo1 = arrPortDetailForStart1.Sys_PortNo;
      // let strInstrumentType = arrPortDetailForStart1.Instrument_type;
      let strInstrumentId = dataObj.InstrumentId;
      const __parameterWeighmentObj = {
        idsNo: strResberryPi,
        Hmi: strHmi,
        actualWt: arr[0],
        instrumentId: strInstrumentId,
        dataObj: dataObj
      }
      if (arr == "") {
        return mqttSender.sendData(strHmi, "Invalid String Recieved")
      } else {
        // if (strInstrumentType == GLOBAL_NOMENCLATURE.Balance) {
        //     if (ProtocolUnit == undefined) {
        //         ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;
        //     } else {
        //         if ((ProtocolUnit != "g") && (ProtocolUnit != "kg") && (ProtocolUnit != "mg")) {
        //             //log protocol in file
        //             loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}Invalid Data String sended to device ${strHmi}`)
        //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid Data String`);
        //         } else {
        //             if (ProtocolUnit == "mg") {
        //                 actualWt = actualWt / 1000;
        //             } else if (ProtocolUnit == ("kg" || "Kg" || "KG")) {
        //                 actualWt = actualWt * 1000;
        //             }
        //             ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;

        //         }
        //     }

        // } else {
        //     //log protocol in file
        //     loggers.MqttProtocolLogger.info(`unknown instrument`)
        //     console.log('unknown instrument');
        // }

        //decision making 
        if (tempCailibType == undefined) {
          if (currentOpStatus == undefined) {
            loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
            console.log('wt recieve without any api called');
            return;
          } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

            await objWeighmentData.ParsingTestData(__parameterWeighmentObj);
          }
        } else {
          console.log('calibration is on and dt weighment part has clash')
        }
      }
      // }
      // } catch (error) {
      //     throw new Error(error)
      // }




    } catch (error) {
      throw new Error(error)
    }
  }

  async getDetailOfBulkInstrumentModel(instrumentId, instrumentType) {
    try {
        const obj = await models.tbl_otherequipment.findAll({
            where: {
                Eqp_ID: instrumentId,
                Eqp_Type: instrumentType
            }
        })
        let res = [obj];
        if (res[0].length <= 0) {
            return undefined
        }
        return res[0][0];
    } catch (error) {
        throw new Error(error)
    }
}
  async ActivityLog(idsNo, Activity) {
    var objUserInfo = globalData.arrUsers.find(k => k.Hmi == idsNo);
    var objActivity = {};
    Object.assign(objActivity,
      { strUserId: objUserInfo.UserId },
      { strUserName: objUserInfo.UserName },
      { activity: Activity })
    await objActivityLog.ActivityLogEntry(objActivity)
  }
}

module.exports = MoistureAnalyserParsing;