const date = require('date-and-time');
const globalData = require('../../global/globalData');
const sort = require('./checkForPendingCalib');
const dbCon = require('../../Utills/db');
const maths = require('mathjs')
const { QueryTypes } = require('sequelize');

const sequelize = require('../../../config/dbConnection').sequelize
const models = require('../../../config/dbConnection').models
// *****************************************************************************************************//
// Below function return the maximum RepNo for calibration                                             //
// ****************************************************************************************************//
async function getReportSerialNumber(Caibration, strBalId, strHmi, balType) {
    try {

        // if (balType == 'analytical') {
            var calibTable_bal = 'tbl_calibration_status';
        // } else {
            var calibTable_status = 'tbl_calibration_status_bin';
        // }
        // Calibration holds vaues like 'P', 'U', 'E' ... etc
        /**
         * 
         * @description 1) For the very first calibration in the sequence array the rep sr number will be the maximum of all calibration 
         * plus 1, and immediately update that rep Sr no infront of that balance ID in `caibration_status`
         *              2) For the remaining calibrations, the rep sr number will be the rep sr number infront of that balance Id 
         */
        // var result = await dbCon.execute(`SELECT MAX(RepNo) AS RepNo FROM tbl_calibration_status`);
        var result = await sequelize.query(`SELECT MAX(RepNo) AS RepNo FROM  ${calibTable_bal}`,{type: QueryTypes.SELECT});
        var result_bin = await sequelize.query(`SELECT MAX(RepNo) AS RepNo FROM  ${calibTable_status}`,{type: QueryTypes.SELECT});
        if(result[0].RepNo != null || result_bin[0].RepNo != null){
            var res = []
            res.push( result[0].RepNo, result_bin[0].RepNo)
            var max_repno = maths.max(res)
            max_repno = max_repno + 1
        }


        var RepNo;
        var sortedArray = await sort.sortedSeqArray(globalData.arrSortedCalib, strBalId,balType);
         if (balType == 'analytical') {
            var calibTable = 'tbl_calibration_status';
        } else {
             calibTable = 'tbl_calibration_status_bin';
        }
        if (sortedArray[0] == Caibration) {
            await sequelize.query(`UPDATE ${calibTable} SET RepNo=${max_repno} WHERE BalID = '${strBalId}'`,{type: QueryTypes.UPDATE});
            RepNo = max_repno;
            return RepNo;
        } else {
            var resultLatest = await sequelize.query(`SELECT MAX(RepNo) AS RepNo FROM ${calibTable} WHERE BalID = '${strBalId}'`,{type: QueryTypes.SELECT});
            RepNo = resultLatest[0].RepNo;
            return RepNo;
        }
    } catch (err) {

        throw new Error(err)
    }

}

function getRepSrNoWRTBalance(strBalId, balType) {

    if (balType == 'analytical') {
        var calibTable = 'tbl_calibration_status';
    } else {
        var calibTable = 'tbl_calibration_status_bin';
    }
    return sequelize.query(`SELECT RepNo FROM ${calibTable} WHERE BalID = '${strBalId}'`,{type:QueryTypes.SELECT})

}
module.exports.getRepSrNoWRTBalance = getRepSrNoWRTBalance;
module.exports.getReportSerialNumber = getReportSerialNumber;