const dbCon = require('../../Utills/db');
var checkForPenCal = require('./checkForPendingCalib');
var sort = require('./checkForPendingCalib');
var Comman = require('./clsCalibCommonFunction.model');
var comman = new Comman();
const FetchDetail = require('./../clsFetchDetails.model');
const fetchDetails = new FetchDetail()
const PowerBackup = require("../../Utills/powerBackUp/powerbackup");
const objPowerBackup = new PowerBackup();
const Database = require('./../../database/clsQueryProcess');
const database = new Database();
const FormulaFunction = require('./../Product/clsformulaFun.model'); //make this function
const objFormulaFunction = new FormulaFunction();
const globalData = require('./../../global/globalData');
const obj_getRepSrNo = require('../Calibration/repSrNo');
const date = require('date-and-time');
const clsActivityLog = require('../clsActivityLog.model');
const objActivityLog = new clsActivityLog();
const MqttModel = require('../Mqtt/mqttSender.class');
const mqttSender = new MqttModel();
const InstrumentUsage = require('../clsInstrumentUsageLog');
const objInstrumentUsage = new InstrumentUsage();
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const sequelize = require('../../../config/dbConnection').sequelize
const models = require('../../../config/dbConnection').models;
const { Op } = require('sequelize')
const clsHmiModel = require('../hmiDetail.model')
const objHmiModel = new clsHmiModel();
const loggers = require('../winstonLogger');
const maths = require('mathjs');

const clsMonit = require('../MonitorSocket/clsMonitSocket')
const objMonit = new clsMonit();

class CalibrationModel {
    // ****************************************************************************************************//
    // Below function takes argument as str_Protocol, IdSSrNo and stores all balance information related to
    // that IDS
    //**************************************************************************************************** */
    async getCalibWeights(strBalID, strHmi, rasbpi) {
        try {
            // calculating balance Id assigned to that IDS
            // const tempCubicInfo = globalData.arrIdsInfo.find(k => k.Sys_IDSNo == parseInt(IDSSrNo));
            var strBalId = strBalID;
            let resObj = {};
            let srNo = 0;
            let hmiDetails = globalData.arrSelectedBalWithHmi.find(k => k.Hmi == strHmi);
            let TempCalibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);

            let arr = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi).BalList;
            let removeBalType = arr.filter(k => k.BalanceId == strBalId)

            if (TempCalibType != undefined) {
                TempCalibType.calibType = mqttProtocol.Repetability.toLowerCase();
            } else {
                globalData.arrcalibType.push({ Hmi: strHmi, calibType: mqttProtocol.Repetability.toLowerCase() })
            }

            let strPortNo = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi).BalList.find(i => i.BalanceId == strBalId).PortNo;

            //monit
            await objMonit.monit({ case: 'Calibration', Hmi: strHmi, data: { calibType: mqttProtocol.Repetability } });

            if (hmiDetails == undefined) {
                globalData.arrSelectedBalWithHmi.push({
                    "Hmi": strHmi,
                    "rasbpi": rasbpi,
                    "selectedBal": strBalId,
                    "portNo": strPortNo,
                    "InstrumentType": "Balance",
                })
            } else {
                hmiDetails.rasbpi = rasbpi;
                hmiDetails.selectedBal = strBalId;
                hmiDetails.portNo = strPortNo;
                hmiDetails.InstrumentType = "Balance";
            }

            // Check if there is entries in incomplete tables so we need to move it into failed tables
            // var bln_isPresent = await comman.checkIfRecordInIncomplete('E', strBalId)

            // Storing all the balance details for 'tbl_balance' in global array
            var result = await models.tbl_balance.findAll({
                where: {
                    'Bal_ID': strBalId
                }
            })

            result = [result]

            let arrBal = globalData.arrBalance.find(k => k.Hmi == strHmi);
            if (arrBal == undefined) {
                globalData.arrBalance.push({
                    Hmi: strHmi,
                    balId: strBalId,
                    balance_info: result[0]
                });
            } else {
                arrBal.balId = strBalId,
                    arrBal.balance_info = result[0]
            }

            // var tempIM = globalData.arrHexInfo.find(k => k.idsNo == IDSSrNo);
            var tempBalace = globalData.arrBalance.find(k => k.Hmi == strHmi)

            result = await models.tbl_balance_weights.findAll({

                where: {
                    'Bal_ID': strBalId,
                    'Bal_IsRepetability': 1
                },
                order: [['Bal_StdWt', 'ASC']]
            })
            result = [result];


            var strUnitOfBal = globalData.arrBalance.find(k => k.Hmi == strHmi);
            var strUnitAccordingDb;
            if (strUnitOfBal.balance_info[0].Bal_Unit == "g") {
                strUnitAccordingDb = "g";
            } else {
                strUnitAccordingDb = strUnitOfBal.balance_info[0].Bal_Unit;
            }
            // If Array of weights is Already present in globalData then we have to update this so we first remove 
            // and push new one OR Else if not present then we add new one
            var found = globalData.arrBalCalibWeights.some(function (el) {
                return el.Hmi == strHmi;
            });
            if (found) {
                const tempObj = globalData.arrBalCalibWeights.find(k => k.Hmi == strHmi);
                // removing Current obj
                var index = globalData.arrBalCalibWeights.indexOf(tempObj);
                if (index !== -1) globalData.arrBalCalibWeights.splice(index, 1);
                globalData.arrBalCalibWeights.push({
                    Hmi: strHmi,
                    balId: strBalId,
                    calibWt: result[0] // array
                })
            } else {
                globalData.arrBalCalibWeights.push({
                    Hmi: strHmi,
                    balId: strBalId,
                    calibWt: result[0] // array
                })
            }
            // Instrument Usage log for balance start

            // if (serverConfig.ProjectName == "RBH") { // Set in serverconfig file

            //     await objInstrumentUsage.InstrumentUsage('Balance', IDSSrNo, 'tbl_instrumentlog_balance', 'Linearity Calibration', 'started');
            //     return 'CB01' + objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt,tempBalace.balance_info[0].Bal_DP) + `g, 0.000,Linearity Calib,${TareCmd}`;
            // }
            // else {
            // await objInstrumentUsage.InstrumentUsage('Balance', IDSSrNo, 'tbl_instrumentlog_balance', 'Periodic Calibration', 'started');
            // return 'CB01' + objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt,tempBalace.balance_info[0].Bal_DP) + `g, 0.000,Periodic Calib,${TareCmd}`;
            // { 'Hmi': strHmi, 'BalId' :  strBalId , 'counter': srNo }
            let tempCounter = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi);
            if (tempCounter == undefined) {

                // var bln_isPresent = await comman.checkIfRecordInIncomplete('R', strBalId)
                // if (bln_isPresent == true) {

                //     let result = await models.tbl_calibration_repetability_master_incomplete.findAll({
                //         where: {
                //             "Repet_BalID": strBalId
                //         }
                //     })


                //     let int_Repet_RepNo = result[0].Repet_RepNo;
                //     let a = comman.caibrationFails('R', int_Repet_RepNo, strBalId ,'Monthly')

                // }

                globalData.arrCalibCounterApi.push({ 'Hmi': strHmi, 'BalId': strBalId, 'counterApi': srNo })
            }
            const tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
            let _calib_count = tempCounter == undefined ? 0 : tempCounter.counterApi
            // }
            var _powerbackupCalib = {
                strTableName: 'tbl_calibration_periodic_master_incomplete',
                strDetailTbl: 'tbl_calibration_periodic_detail_incomplete',
                cubicaNo: 'NUll',
                cubicType: 'NUll',
                cubicSysBFGcode: 'NUll',
                cubicBatch: 'NUll',
                menuName: 'Repeatability',
                productType: 'NUll',
                Userid: tempUserObject.UserId,
                idsNo: rasbpi,
                Hmi: strHmi,
                RecSampleNo: _calib_count,
                ReportType: 'NUll',
                _bal_id: strBalId

            }
            let _check_combination = await objPowerBackup._check_calibration_entry(strHmi, _powerbackupCalib, "tbl_powerbackup");
            if (_check_combination !== undefined) {
                // let tempCounter = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi);
                if (tempCounter == undefined) {
                    tempCounter = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi);
                }
                tempCounter.counterApi = _check_combination.RecSampleNo + 1;
                _powerbackupCalib.RecSampleNo = tempCounter.counterApi
                tempCounter.counterApi = tempCounter.counterApi
            }
            else {
                if (tempCounter != undefined) {
                    tempCounter.counterApi += 1;
                    _powerbackupCalib.RecSampleNo = tempCounter.counterApi
                    tempCounter.counterApi = tempCounter.counterApi
                }
            }
            if (tempCounter == undefined) {
                let strResPiNo = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi).ResbPi;
                // await objInstrumentUsage.InstrumentUsage('Balance', strResPiNo, 'tbl_instrumentlog_balance', 'Repeatability Calibration', 'started');
                let data = {
                    Srno: 0,
                    Bal_StdWt: parseFloat(result[0][0].Bal_StdWt).toFixed(tempBalace.balance_info[0].Bal_DP) + " " + strUnitAccordingDb,
                    Bal_NegTol: parseFloat(result[0][0].Bal_NegTol).toFixed(tempBalace.balance_info[0].Bal_DP) + " " + strUnitAccordingDb,
                    Bal_PosTol: parseFloat(result[0][0].Bal_PosTol).toFixed(tempBalace.balance_info[0].Bal_DP) + " " + strUnitAccordingDb,
                }
                let intsend = globalData.arrsendWt.find(k => k.Hmi == strHmi);
                if (intsend == undefined) {
                    globalData.arrsendWt.push({ 'Hmi': strHmi, 'BalId': strBalId, 'sendWt': objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP) });
                }
                else {
                    intsend.strBalId = strBalId;
                    intsend.sendWt = objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP)
                }
                return Object.assign(resObj, {
                    status: 'success',
                    result: data
                });
            }
            else {

                let result1 = await models.tbl_precalibration_repeatability.findAll({
                    where: {
                        "Equipment_ID": strBalId,
                        "Equipment_Type": removeBalType[0].type == "analytical" ? "Balance" : "IPC Balance"
                    }
                })

                var repeat_precalib_weights = result1[0];
                var counterRepeat = repeat_precalib_weights.Repeat_Count;

                if (tempCounter.counterApi == counterRepeat) {

                    await objMonit.monit({ case: 'CalibDone', Hmi: strHmi, data: { calibType: mqttProtocol.Repetability } });
                    (globalData.arrSelectedBalWithHmi.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrSelectedBalWithHmi : globalData.arrSelectedBalWithHmi.splice(globalData.arrSelectedBalWithHmi.findIndex((element) => element.Hmi === strHmi), 1);
                    (globalData.arrcalibType.findIndex(k => k.Hmi == strHmi) == -1 ? globalData.arrcalibType : globalData.arrcalibType.splice(globalData.arrcalibType.findIndex(k => k.Hmi == strHmi), 1));


                    (globalData.arrsendWt.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrsendWt : globalData.arrsendWt.splice(globalData.arrsendWt.findIndex((element) => element.Hmi === strHmi), 1);

                    (globalData.arrCalibCounter.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCalibCounter : globalData.arrCalibCounter.splice(globalData.arrCalibCounter.findIndex((element) => element.Hmi === strHmi), 1); //counter clear
                    (globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCalibCounterApi : globalData.arrCalibCounterApi.splice(globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi), 1);

                    await models.tbl_powerbackup.destroy({
                        where: {
                            WeighmentName: 'Repeatability',
                            Idsno: strHmi
                        }
                    })
                    //globalData.arrCalibCounterApi.splice( globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi), 1)
                    return Object.assign(resObj, {
                        status: 'success',
                        message: 'Calibration Successful'
                    });


                } else {


                    let intsendWt = globalData.arrsendWt.find(k => k.Hmi == strHmi);
                    if (intsendWt == undefined) {
                        globalData.arrsendWt.push({ 'Hmi': strHmi, 'BalId': strBalId, 'sendWt': objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP) });
                    }
                    else {
                        intsendWt.strBalId = strBalId;
                        intsendWt.sendWt = objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP)
                    }
                    let data = {
                        Srno: tempCounter.counterApi,

                        Bal_StdWt: parseFloat(result[0][0].Bal_StdWt).toFixed(tempBalace.balance_info[0].Bal_DP) + " " + strUnitAccordingDb,
                        Bal_NegTol: parseFloat(result[0][0].Bal_NegTol).toFixed(tempBalace.balance_info[0].Bal_DP) + " " + strUnitAccordingDb,
                        Bal_PosTol: parseFloat(result[0][0].Bal_PosTol).toFixed(tempBalace.balance_info[0].Bal_DP) + " " + strUnitAccordingDb,

                        // Bal_StdWt: objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP) + " " + strUnitAccordingDb,
                        // Bal_NegTol: objFormulaFunction.FormatNumberString(result[0][0].Bal_NegTol, tempBalace.balance_info[0].Bal_DP) + " " + strUnitAccordingDb,
                        // Bal_PosTol: objFormulaFunction.FormatNumberString(result[0][0].Bal_PosTol, tempBalace.balance_info[0].Bal_DP) + " " + strUnitAccordingDb,
                    }
                    return Object.assign(resObj, {
                        status: 'success',
                        result: data
                    });

                }






                // }
                // await objInstrumentUsage.InstrumentUsage('Balance', IDSSrNo, 'tbl_instrumentlog_balance', 'Periodic Calibration', 'started');
                // return 'CB01' + result[0][0].Bal_StdWt + 'g, 0.000,Periodic Calib,';

                // }


            }
        }
        catch (err) {
            console.log("Error from getCalibWeights of Repeatability", err)
            return `Error from getCalibWeights of Repeatability ${err}`;
        }

    }


    //**************************************************************************************************************** */
    // Below function verifies recived weights is in range of tolerences and stores in database as in given situation
    // Also send next weights for calibrations
    //**************************************************************************************************************** */
    async verifyWeights(str_Protocol, strResPiNo, ProtocolData, ProtocolDecPoint) {
        try {
            let tempstrResPiNo = strResPiNo;
            let strHmi = await objHmiModel.getHmiNoFromResbPi(strResPiNo);
            strResPiNo = await objHmiModel.getAliasOfRPI(strResPiNo)
            let removeBalOfThatHmi = globalData.arrSelectedBalWithHmi.find(k => k.Hmi == strHmi);
            let strBalId = removeBalOfThatHmi.selectedBal
            let now = new Date();
            var str_ProtocolData = str_Protocol;
            str_ProtocolData.split(':');
            let ProtocolName = str_ProtocolData.split(":")[0];
            let ProtocolPortNo = str_ProtocolData.split(":")[1];
            let resObj = {};
            let data = str_ProtocolData.split(":");
            var new_string = data[2].substr(data[2].search(/\d/));
            new_string = new_string.trim();
            let ProtocolDataAndUnit = new_string.split(" ");
            ProtocolDataAndUnit = ProtocolDataAndUnit.filter(k => k)
            let recieveWt = ProtocolData;

            let arrRemoveUnit = ProtocolDataAndUnit.filter(item => item);
            let unit = arrRemoveUnit[1];
            var srNo = 0;

            let arr = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi).BalList;
            let removeBalType = arr.filter(k => k.BalanceId == strBalId)
            //wadadadas///

            // calculating Balance Id related to that Ids
            // const tempCubicInfo = globalData.arrIdsInfo.find(k => k.Sys_IDSNo == parseInt(IDSSrNo));
            // var strBalId = tempCubicInfo.Sys_BalID;
            // calculating below parameted from string 
            // var srNo = str_Protocol.split(',')[0].substring(2, 4); // Weight Sr Number
            // var sendWt = str_Protocol.split(',')[0].substring(4).slice(0, -1); // Weight send for calibration
            // var recieveWt = str_Protocol.split(',')[1].split(' ')[0]; // recived weight after calibration
            // fetching calibration weights for that balance from global array with reference to Ids
            var objBalRelWt = globalData.arrBalCalibWeights.find(k => k.Hmi == strHmi); //get the current wt. 

            //pushing while getting first wt globalData.arrBalCalibWeights
            // globalData.arrBalCalibWeights.push({
            //     Hmi: strHmi,
            //     balId : strBalId,
            //     calibWt: result[0] // array
            // })

            //current send wt
            let tempSendWt = globalData.arrsendWt.find(k => k.Hmi == strHmi);
            const objSentWt = objBalRelWt.calibWt.find(j => j.Bal_StdWt == parseFloat(tempSendWt.sendWt));

            let result = await models.tbl_precalibration_repeatability.findAll({
                where: {
                    "Equipment_ID": strBalId,
                    "Standard_Weight_Block": objSentWt.Bal_StdWt,
                    "Equipment_Type": removeBalType[0].type == "analytical" ? "Balance" : "IPC Balance"
                }
            })
            var repeatability_precalib_weights = result[0];
            var counterEcc = repeatability_precalib_weights.Repeat_Count;

            var tempObj = globalData.arrCalibCounter.find(k => k.Hmi == strHmi);
            const tempBalObject = globalData.arrBalance.find(k => k.Hmi == strHmi);
            var strUnitAccordingDb;
            if (tempBalObject.balance_info[0].Bal_Unit.startsWith('g')) {
                strUnitAccordingDb = "g";
            } else {
                strUnitAccordingDb = tempBalObject.balance_info[0].Bal_Unit;
            }

            var perferUnit;
            if (unit == undefined) {
                perferUnit = "g";
            } else {
                if (unit.toLowerCase() === "gm" || unit.toLowerCase() === "g")
                    perferUnit = "g";
                else
                    perferUnit = unit.toLowerCase();
            }

            if (strUnitAccordingDb.toLowerCase() !== perferUnit) {
                let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
                let autoTare = hmiEntryinConfig[0].AutoTare;
                let tareCommand = hmiEntryinConfig[0].Tare_Command
                mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Please Check the Balance Setting`);
                mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                return
            } else {
                if (tempObj === undefined) {
                    globalData.arrCalibCounter.push({ 'Hmi': strHmi, 'BalId': strBalId, 'counter': srNo });
                }
                else {
                    tempObj.BalId = strBalId
                    tempObj.counter = tempObj.counter + 1;
                }
            }


            var resArrOfDecimal = globalData.glbArrOfDecimal.find(k => k.Hmi == strHmi);
            if (resArrOfDecimal == undefined) {

                globalData.glbArrOfDecimal.push({
                    Hmi: strHmi,
                    decimalPoint: ProtocolDecPoint
                })
            }
            else {
                var resArrOfDecimal1 = globalData.glbArrOfDecimal.find(k => k.Hmi == strHmi);
                if (resArrOfDecimal1.decimalPoint >= ProtocolDecPoint) {
                    resArrOfDecimal1.decimalPoint = resArrOfDecimal1.decimalPoint;
                } else {
                    resArrOfDecimal1.decimalPoint = ProtocolDecPoint;
                }
            }
            resArrOfDecimal = globalData.glbArrOfDecimal.find(k => k.Hmi == strHmi);

            if (parseInt(srNo) <= counterEcc) {
                //"CB0"


                var int_RepSrNo;


                // getting only balanceInfo
                const balanceInfo = tempBalObject.balance_info[0];
                // getting userIfo logged in for that cubicle
                recieveWt = Number(recieveWt).toFixed(balanceInfo.Bal_DP)
                var strUnitAccordingDb;
                if (balanceInfo.Bal_Unit == "") {
                    strUnitAccordingDb = "g";
                } else {
                    strUnitAccordingDb = balanceInfo.Bal_Unit;
                }
                var ResponseFrmPC = ""
                // getting reCaibration status from `tbl_recalibration_balance_status` on start up
                let BalanceRecalibStatusObject;
                if (removeBalType[0].type == "analytical") {
                    BalanceRecalibStatusObject = globalData.arrBalanceRecalibStatus.find(k => k.Bal_ID == strBalId);
                } else {
                    BalanceRecalibStatusObject = globalData.arrBalanceRecalibStatusIPC.find(k => k.Bal_ID == strBalId);
                }
                const tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
                var tempCounter = globalData.arrCalibCounter.find(k => k.Hmi == strHmi);
                // var tempDetailCounterObjInsert = globalData.arrCalibInsertCounter.find(k => k.Hmi == strHmi);
                var _powerbackupCalib = {
                    strTableName: 'tbl_calibration_periodic_master_incomplete',
                    strDetailTbl: 'tbl_calibration_periodic_detail_incomplete',
                    cubicaNo: 'NUll',
                    cubicType: 'NUll',
                    cubicSysBFGcode: 'NUll',
                    cubicBatch: 'NUll',
                    menuName: 'Repeatability',
                    productType: 'NUll',
                    Userid: tempUserObject.UserId,
                    idsNo: strResPiNo,
                    Hmi: strHmi,
                    RecSampleNo: tempCounter.counter,
                    ReportType: 'NUll',
                    _bal_id: strBalId

                }
                let _check_combination = await objPowerBackup._check_calibration_entry(strHmi, _powerbackupCalib, "tbl_powerbackup");
                if (_check_combination !== undefined) {
                    // let tempCounter = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi);
                    // if(tempCounter == undefined){
                    //     tempCounter  = globalData.arrCalibCounter.find(k => k.Hmi == strHmi);
                    // }
                    tempCounter.counter = _check_combination.RecSampleNo + 1;
                    // if(tempDetailCounterObjInsert.insertingDetailCounter == 1){
                    // tempDetailCounterObjInsert.insertingDetailCounter = tempCounter.counter + 1
                    // }
                    // _powerbackupCalib.RecSampleNo = tempCounter.counter 
                    tempCounter.counter = tempCounter.counter
                }
                _powerbackupCalib = {
                    strTableName: 'tbl_calibration_periodic_master_incomplete',
                    strDetailTbl: 'tbl_calibration_periodic_detail_incomplete',
                    cubicaNo: 'NUll',
                    cubicType: 'NUll',
                    cubicSysBFGcode: 'NUll',
                    cubicBatch: 'NUll',
                    menuName: 'Repeatability',
                    productType: 'NUll',
                    Userid: tempUserObject.UserId,
                    idsNo: strResPiNo,
                    Hmi: strHmi,
                    RecSampleNo: tempCounter.counter,
                    ReportType: 'NUll',
                    _bal_id: strBalId

                }
                await objPowerBackup.get_Calib_Status_oF_Test_ForPowerBackup(_powerbackupCalib);
                var remark = "Not Ok"
                if (parseInt(tempCounter.counter) == 0) {
                    /** code for storing all the wgt in column of std wgt ,neg tol and pos tol */
                    var combineStdWt = "";
                    var combineLowerLimit = "";
                    var combineUpperLimit = "";
                    for (let i of objBalRelWt.calibWt) {
                        combineStdWt = combineStdWt + i.Bal_StdWt + ",";
                        combineLowerLimit = combineLowerLimit + i.Bal_NegTol + ",";
                        combineUpperLimit = combineUpperLimit + i.Bal_PosTol + ",";
                    }
                    combineLowerLimit = combineLowerLimit.slice(0, -1)
                    combineStdWt = combineStdWt.slice(0, -1)
                    combineUpperLimit = combineUpperLimit.slice(0, -1)

                    // removing cubicle according to resberryPi
                    var resulCubicleNo = await models.tbl_cubical.findAll({
                        where: {
                            "Sys_IDSNo": strResPiNo
                        }
                    });
                    // Inserting entries in master table for daily/Periodic calibration
                    // Object for inserting data for Incommplete master
                    var RepNo = await obj_getRepSrNo.getReportSerialNumber('R', strBalId, strHmi, removeBalType[0].type);
                    // Selecting Preclalibration weight from tbl_calibration_periodic_detail_incomplete
                    result = await models.tbl_precalibration_repeatability.findAll({
                        where: {
                            "Equipment_ID": strBalId,
                            "Standard_Weight_Block": objSentWt.Bal_StdWt,
                            "Equipment_Type": removeBalType[0].type == "analytical" ? "Balance" : "IPC Balance"
                        }
                    })

                    // Inserting 1st weight data in  tbl_calibration_periodic_detail_incomplete
                    const repet_precalib_weights = result[0];
                    await models.tbl_calibration_repetability_master_incomplete.create({
                        'Repet_RepNo': RepNo,
                        'Repet_CalbDate': date.format(now, 'YYYY-MM-DD'),
                        'Repet_CalbTime': date.format(now, 'HH:mm:ss'),
                        'Repet_BalID': balanceInfo.Bal_ID,
                        'Repet_BalSrNo': balanceInfo.Bal_SrNo,
                        'Repet_Make': balanceInfo.Bal_Make,
                        'Repet_Model': balanceInfo.Bal_Model,
                        'Repet_Unit': balanceInfo.Bal_Unit,
                        'Repet_Dept': balanceInfo.Bal_Dept,
                        'Repet_LeastCnt': balanceInfo.Bal_LeastCnt,
                        'Repet_MaxCap': balanceInfo.Bal_MaxCap,
                        'Repet_MinCap': balanceInfo.Bal_MinCap,
                        'Repet_ZeroError': 0,
                        'Repet_SpritLevel': 0,
                        'Repet_GerneralCare': 0,
                        "Repet_CubicalNo": resulCubicleNo[0].Sys_CubicNo,
                        "Repet_CubicalName": resulCubicleNo[0].Sys_CubicName,
                        "Repet_Area": resulCubicleNo[0].Sys_Area,
                        // "Decimal_Point": resArrOfDecimal.decimalPoint,
                        "Repet_DP": balanceInfo.Bal_DP,

                        // { str_colName: 'Repet_UserID': tempUserObject.UserId ,
                        // { str_colName: 'Repet_UserName': tempUserObject.UserName ,
                        'Repet_UserID': tempUserObject.UserId,
                        'Repet_UserName': tempUserObject.UserName,
                        'Repet_DueDate': balanceInfo.Bal_CalbDueDtU,
                        'Repet_Location': resulCubicleNo[0].Sys_Location,
                        'Repet_RoomNo': resulCubicleNo[0].Sys_RoomNo,
                        'Repet_StdWeight': Number(repet_precalib_weights.Standard_Weight_Block).toFixed(balanceInfo.Bal_DP),
                        'Repet_NegTol': Number(repet_precalib_weights.Negative_Tolerance).toFixed(balanceInfo.Bal_DP),
                        'Repet_PosTol': Number(repet_precalib_weights.Positive_Tolerance).toFixed(balanceInfo.Bal_DP),
                        'Repet_PrintNo': 0,
                        'Repet_AllWeightboxID': repet_precalib_weights.CalibrationBox_ID,
                        'Repet_AllWeightboxCert': repet_precalib_weights.CalibrationBox_Calibration_CertificateNo,
                        'Repet_AllWeightboxValidUpto': repet_precalib_weights.CalibrationBox_Validity_Date,
                        "Repet_Mean": '0.000',
                        "Repet_Deviation": '0.0000',
                        "Repet_Per": 'NA',
                        "Repet_Remark": "NA"
                    })



                    await models.tbl_calibration_repetability_detail_incomplete.create({
                        'Repet_RecNo': 1,
                        'Repet_RepNo': RepNo,
                        'Repet_BalStdWt': Number(objSentWt.Bal_StdWt).toFixed(balanceInfo.Bal_DP),
                        'Repet_BalNegTol': Number(objSentWt.Bal_NegTol).toFixed(balanceInfo.Bal_DP),
                        'Repet_BalPosTol': Number(objSentWt.Bal_PosTol).toFixed(balanceInfo.Bal_DP),
                        'Repet_ActualWt': recieveWt.toString(),
                        'Repet_StdWtID': repet_precalib_weights.CalibrationBox_ID,
                        'Repet_StdWt': repet_precalib_weights.CalibrationBox_Selected_Elements,
                        'Repet_WtIdentification': '',
                        'Repet_WeightBox_certfctNo': repet_precalib_weights.CalibrationBox_Calibration_CertificateNo,
                        'PercentofCapacity': repet_precalib_weights.Percent_of_Capacity.toString(),
                        "Repet_DP": balanceInfo.Bal_DP,
                        "Repet_Remark": remark,
                        "Repet_ValDate": repet_precalib_weights.CalibrationBox_Validity_Date,
                    })
                    await models.tbl_powerbackup.update({
                        Incomp_RepSerNo: RepNo
                    }, {
                        where: {
                            Idsno: strHmi
                        }
                    });
                    var objSentWtBal_StdWt = objFormulaFunction.FormatNumberString(objSentWt.Bal_StdWt, balanceInfo.Bal_DP)
                    objSentWtBal_StdWt = Number(objSentWtBal_StdWt).toFixed(balanceInfo.Bal_DP)
                    // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${tempCounter.counter + 1}:${objSentWtBal_StdWt + " " + strUnitAccordingDb}:${recieveWt + " " + perferUnit}`);
                    // activity Entry for Perioic Calibration start

                    var objActivity = {}
                    Object.assign(objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { activity: `${mqttProtocol.Repetability} Calibration Started On TSH ${strHmi}` }
                    );
                    await objActivityLog.ActivityLogEntry(objActivity);
                    await objInstrumentUsage.InstrumentUsage('Balance', tempstrResPiNo, 'tbl_instrumentlog_balance', 'Repeatability Calibration', 'started');

                } else {
                    var int_Repet_RecNo1;
                    // Selecting data from tbl_calibration_periodic_master_incomplete based on 'strBalId'

                    let result = await models.tbl_calibration_repetability_master_incomplete.findAll({
                        attributes: [[sequelize.fn('max', sequelize.col('Repet_RepNo')), "Repet_RepNo"]],

                        where: {
                            "Repet_BalID": strBalId
                        }
                    })
                    var int_repetability_RepNo = result[0].Repet_RepNo;
                    // Selecting Periodic_RecNo from tbl_calibration_periodic_detail_incomplete based on 'int_periodic_RepNo'

                    result = await models.tbl_calibration_repetability_detail_incomplete.findAll({
                        attributes: [
                            [sequelize.fn('max', sequelize.col('Repet_RecNo')), "Repet_RecNo"]

                        ],
                        where: {
                            "Repet_RepNo": int_repetability_RepNo
                        },
                        raw: true
                    })
                    const repetability_RecNo = result[0].Repet_RecNo;
                    int_Repet_RecNo1 = repetability_RecNo + 1;

                    // Selecting selectpreCalibWtObj from tbl_precalibration_periodic based on 'strBalId' and
                    // First weight was sent
                    result = await models.tbl_precalibration_repeatability.findAll({
                        where: {
                            "Equipment_ID": strBalId,
                            "Equipment_Type": removeBalType[0].type == "analytical" ? "Balance" : "IPC Balance"
                        }
                    })

                    const repet_precalib_weights = result[0];

                    // Inserting data in tbl_calibration_periodic_detail_incomplete
                    await models.tbl_calibration_repetability_detail_incomplete.create({
                        'Repet_RecNo': int_Repet_RecNo1,
                        'Repet_RepNo': int_repetability_RepNo,
                        'Repet_BalStdWt': Number(objSentWt.Bal_StdWt).toFixed(balanceInfo.Bal_DP),
                        'Repet_BalNegTol': Number(objSentWt.Bal_NegTol).toFixed(balanceInfo.Bal_DP),
                        'Repet_BalPosTol': Number(objSentWt.Bal_PosTol).toFixed(balanceInfo.Bal_DP),
                        'Repet_ActualWt': recieveWt.toString(),
                        'Repet_StdWtID': repet_precalib_weights.CalibrationBox_ID,
                        'Repet_StdWt': repet_precalib_weights.CalibrationBox_Selected_Elements,
                        'Repet_WtIdentification': '',
                        'Repet_WeightBox_certfctNo': repet_precalib_weights.CalibrationBox_Calibration_CertificateNo,
                        'PercentofCapacity': repet_precalib_weights.Percent_of_Capacity.toString(),
                        "Repet_DP": balanceInfo.Bal_DP,
                        "Repet_Remark": remark,
                        "Repet_ValDate": repet_precalib_weights.CalibrationBox_Validity_Date,
                    })

                    // await models.tbl_calibration_repetability_master_incomplete.update({
                    //     "Decimal_Point": resArrOfDecimal.decimalPoint,
                    //     //"Uncertinity_EndTime": date.format(new Date(), 'HH:mm:ss')
                    // }, {
                    //     where: {
                    //         "Repet_RepNo": int_repetability_RepNo
                    //     }
                    // });

                    var objSentWtBal_StdWt = objFormulaFunction.FormatNumberString(objSentWt.Bal_StdWt, balanceInfo.Bal_DP);
                    objSentWtBal_StdWt = Number(objSentWtBal_StdWt)
                    // await objInstrumentUsage.InstrumentUsage('Balance', tempstrResPiNo, 'tbl_instrumentlog_balance', '', 'completed');

                }





                let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
                let autoTare = hmiEntryinConfig[0].AutoTare;
                let tareCommand = hmiEntryinConfig[0].Tare_Command


                if (objSentWt.Bal_NegTol <= parseFloat(recieveWt) && (parseFloat(recieveWt) <= objSentWt.Bal_PosTol)) {
                    if (parseInt(tempCounter.counter) != counterEcc - 1) {
                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${tempCounter.counter + 1}:${Number(objSentWtBal_StdWt).toFixed(balanceInfo.Bal_DP) + " " + strUnitAccordingDb}:${Number(recieveWt).toFixed(balanceInfo.Bal_DP) + " " + perferUnit}`);
                    }
                    if (autoTare) {
                        mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                    }

                    await objMonit.monit({ case: 'CalibWeight', Hmi: strHmi, data: { Weight: recieveWt } });
                    if (parseInt(tempCounter.counter) == 0) {
                        var int_repetability_RepNo = RepNo
                        var int_Repet_RecNo1 = 1
                    }
                    remark = "Ok"
                    var resultupdate = await models.tbl_calibration_repetability_detail_incomplete.update({
                        Repet_Remark: remark
                    }, {
                        where: {
                            'Repet_RecNo': int_Repet_RecNo1,
                            'Repet_RepNo': int_repetability_RepNo,
                        }
                    })

                    if (parseInt(tempCounter.counter) == counterEcc - 1) {


                        // var tempCounter1 = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi);
                        // var setSrnoToZero = globalData.arrCalibCounter.find(k => k.Hmi == strHmi);
                        // setSrnoToZero.counter = 0 ;
                        // tempCounter1.counterApi = tempCounter1.counterApi + 1;
                        let tempCount = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi);
                        tempCount.counterApi = tempCount.counterApi + 1;
                        console.log('done');

                        //need to be done
                        // let balCalDetPeri = globalData.arrBalCaibDet.find(k => k.strBalId == strBalId);
                        // balCalDetPeri.isPeriodicDone = true;


                        // Updating Periodic status from 0 -> 1 in calibration_status table as well as our global array
                        // which holding calibration status
                        // If this calibration is last calibration then we have to move all caibration records
                        // to complete tables
                        // objFailedFlag.failFlagPeriodic = false;

                        //var objAccepancelimit=await this.checkEccentricityAccepancelimit(strBalId,balanceInfo.Bal_DP)

                        // if (objAccepancelimit=='Not Complies'){
                        //     console.log('Fail')
                        // }

                        result = await models.tbl_calibration_repetability_master_incomplete.findAll({
                            attributes: [
                                [sequelize.fn('max', sequelize.col('Repet_RepNo')), "Repet_RepNo"]

                            ],
                            where: {
                                "Repet_BalID": strBalId
                            },
                            raw: true
                        })

                        // let intPeriodic_RepNo = result[0]["max(`Periodic_RepNo`)"];
                        let intRepet_RepNo = result[0].Repet_RepNo;
                        var data1 = await models.tbl_calibration_repetability_detail_incomplete.findAll({
                            where: {
                                Repet_RepNo: intRepet_RepNo
                            }
                        });
                        var ar1 = [];
                        for (var i = 0; i < data1.length; i++) {
                            var a = data1[i].Repet_ActualWt;
                            ar1.push(Number(a));
                        }
                        let Mean_value = maths.mean(ar1);

                        let std_value = maths.std(ar1);
                        std_value = Number(std_value).toFixed(4);

                        let repet_per = Number(2 * (0.41 * balanceInfo.Bal_LeastCnt) / objSentWtBal_StdWt) * 100;
                        repet_per = repet_per.toFixed(2);

                        let remarks = Number(repet_per) >= 0.10 ? "Not Complies" : "Complies"

                        let data2 = await models.tbl_calibration_repetability_master_incomplete.update({
                            Repet_Remark: remarks,
                            Repet_Mean: Mean_value.toFixed(balanceInfo.Bal_DP),
                            Repet_Deviation: std_value,
                            Repet_Per: repet_per,
                        }, {
                            where: {
                                "Repet_RepNo": intRepet_RepNo,
                                "Repet_BalID": strBalId
                            }
                        });
                        // data = data[0]
                        // maths.mean(a, b, c, ...)

                        var removedArrOfDecimal = globalData.glbArrOfDecimal.find(k => k.Hmi == strHmi);
                        let decimalNumber = removedArrOfDecimal.decimalPoint;

                        // result = await models.tbl_calibration_repetability_master_incomplete.update({
                        //     //  "Decimal_Point": decimalNumber,
                        //     "Repet_EndTime": date.format(new Date(),'HH:mm:ss')
                        // }, {
                        //     where: {
                        //         "Repet_RepNo": intRepet_RepNo
                        //     }
                        // })



                        var arr_sortedCalibArray = await sort.sortedSeqArray(globalData.arrSortedCalib, strBalId, removeBalType[0].type);
                        let lastCalibration = arr_sortedCalibArray[arr_sortedCalibArray.length - 1];
                        // //find globalData.calibrationStatus according to hmi.
                        var calibType = 'R';
                        for (var i in globalData.calibrationStatus) {
                            if (globalData.calibrationStatus[i].BalId == strBalId) {
                                globalData.calibrationStatus[i].status[calibType] = 1;
                                break; //Stop this loop, we found it!
                            }
                        }
                        await comman.updateCalibStatus('R', strBalId, removeBalType[0].type)
                        await comman.incompleteToComplete('R', strBalId, removeBalType[0].type, false);
                        if (lastCalibration == 'R') {
                            await comman.UpdateRecalibFLagPeriodic(strBalId, removeBalType[0].type, "monthly");
                            BalanceRecalibStatusObject.PeriodicBalRecalib = 0;
                        }
                        let strResPiNo = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi).ResbPi;
                        await objInstrumentUsage.InstrumentUsage('Balance', strResPiNo, 'tbl_instrumentlog_balance', '', 'completed')
                        // objInstrumentUsage.InstrumentUsage('Balance', IDSSrNo, 'tbl_instrumentlog_balance', '', 'completed')
                        // result = await checkForPenCal.checkForPendingCalib(strBalId, IDSSrNo);
                        // activity Entry for Perioic Calibration Completion
                        // const tempUserObject = globalData.arrUsers.find(k => k.IdsNo == IDSSrNo);
                        if (balanceInfo.Bal_ChangeWt == 1) {
                            await models.tbl_balance.update({
                                Bal_ChangeWt: 0
                            }, {
                                where: { 'Bal_ID': strBalId }
                            });
                        }
                        var objActivity = {}

                        Object.assign(objActivity,
                            { strUserId: tempUserObject.UserId },
                            { strUserName: tempUserObject.UserName },
                            { activity: `${mqttProtocol.Repetability} Calibration Completed On TSH ${strHmi}` });

                        await objActivityLog.ActivityLogEntry(objActivity);

                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${tempCounter.counter + 1}:${Number(objSentWtBal_StdWt).toFixed(balanceInfo.Bal_DP) + " " + strUnitAccordingDb}:${Number(recieveWt).toFixed(balanceInfo.Bal_DP) + " " + perferUnit}`);

                        mqttSender.sendData(strHmi, `${mqttProtocol.Repetability} Calibration Completed`);

                        return Object.assign(resObj,
                            { strUserId: tempUserObject.UserId },
                            { strUserName: tempUserObject.UserName },
                            { status: 'Repeatability Calibration Completed' });
                    } else {
                        var tempCounter = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi);
                        tempCounter.counterApi = tempCounter.counterApi + 1;
                    }

                } else {
                    // We have to move records to failed tables
                    let result = await models.tbl_calibration_repetability_master_incomplete.findAll({
                        attributes: [
                            [sequelize.fn('max', sequelize.col('Repet_RepNo')), "Repet_RepNo"]

                        ],
                        where: {
                            "Repet_BalID": strBalId
                        },
                        raw: true
                    })

                    // let intPeriodic_RepNo = result[0]["max(`Periodic_RepNo`)"];
                    let intRepet_RepNo = result[0].Repet_RepNo;
                    var data1 = await models.tbl_calibration_repetability_detail_incomplete.findAll({
                        where: {
                            Repet_RepNo: intRepet_RepNo
                        }
                    });
                    var ar1 = [];
                    for (var i = 0; i < data1.length; i++) {
                        var a = data1[i].Repet_ActualWt;
                        ar1.push(Number(a));
                    }
                    let Mean_value = maths.mean(ar1);

                    let std_value = maths.std(ar1);
                    std_value = Number(std_value).toFixed(4);

                    // let repet_per = Number(2*std_value/objSentWtBal_StdWt)*100;
                    let repet_per = Number(2 * (0.41 * balanceInfo.Bal_LeastCnt) / objSentWtBal_StdWt) * 100;
                    repet_per = repet_per.toFixed(2);

                    let remarks = Number(repet_per) >= 0.10 ? "Not Complies" : "Complies"

                    let data2 = await models.tbl_calibration_repetability_master_incomplete.update({
                        Repet_Remark: "Not Complies",
                        Repet_Mean: Mean_value.toFixed(balanceInfo.Bal_DP),
                        Repet_Deviation: std_value,
                        Repet_Per: repet_per,
                    }, {
                        where: {
                            "Repet_RepNo": intRepet_RepNo,
                            "Repet_BalID": strBalId
                        }
                    });
                    await objMonit.monit({ case: 'CalibFail', Hmi: strHmi, data: { calibType: mqttProtocol.Repetability } });

                    result = await models.tbl_calibration_repetability_master_incomplete.findAll({
                        attributes: [[sequelize.fn('max', sequelize.col('Repet_RepNo')), "Repet_RepNo"]],
                        where: {
                            "Repet_BalID": strBalId
                        }
                    })
                    let int_Repet_RepNo
                    if (result[0].length == 0) {
                        int_Repet_RepNo = 1;
                    } else {
                        int_Repet_RepNo = result[0].Repet_RepNo;

                        var removedArrOfDecimal = globalData.glbArrOfDecimal.find(k => k.Hmi == strHmi);
                        let decimalNumber = removedArrOfDecimal.decimalPoint;

                        // await models.tbl_calibration_repetability_master_incomplete.update({
                        //     "Decimal_Point": decimalNumber,
                        //     //"Uncertinity_EndTime": date.format(new Date(), 'HH:mm:ss')
                        // }, {
                        //     where: {
                        //         "Repet_RepNo": int_Repet_RepNo
                        //     }
                        // });

                        await comman.caibrationFails('R', int_Repet_RepNo, strBalId, 'Monthly', false, removeBalType[0].type);
                    }

                    (globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCalibCounterApi : globalData.arrCalibCounterApi.splice(globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi), 1);
                    (globalData.arrCalibCounter.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCalibCounter : globalData.arrCalibCounter.splice(globalData.arrCalibCounter.findIndex((element) => element.Hmi === strHmi), 1);

                    globalData.arrCurrentOperationStatus.findIndex(k => k.Hmi == strHmi) == -1 ? globalData.arrCurrentOperationStatus : globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex(k => k.Hmi == strHmi), 1)
                    globalData.arrcalibType.findIndex(k => k.Hmi == strHmi) == -1 ? globalData.arrcalibType : globalData.arrcalibType.splice(globalData.arrcalibType.findIndex(k => k.Hmi == strHmi), 1)
                    await models.tbl_powerbackup.destroy({
                        where: {
                            WeighmentName: 'Repeatability',
                            Idsno: strHmi
                        }
                    })
                    // objFailedFlag.failFlagPeriodic = true;
                    var objActivity = {};
                    Object.assign(objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { activity: `${mqttProtocol.Repetability} Calibration Failed On TSH ${strHmi}` }
                    );
                    await objActivityLog.ActivityLogEntry(objActivity);
                    // await objInstrumentUsage.InstrumentUsage('Balance', tempstrResPiNo, 'tbl_instrumentlog_balance', '', 'completed');
                    mqttSender.sendData(strHmi, `DisplayResult:${tempCounter.counter + 1}:${Number(objSentWtBal_StdWt).toFixed(balanceInfo.Bal_DP) + " " + strUnitAccordingDb}:${Number(recieveWt).toFixed(balanceInfo.Bal_DP) + " " + perferUnit}:Calibration Failed`);
                    if (autoTare) {
                        mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                    }
                    // mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}false:Calibration Failed`);
                    console.log('Calibration Failed');
                    return 'CF';

                }

            }
        }
        catch (err) {
            console.log("Error from verifyWeights of repeatability", err)
            return `Error from verifyWeights of repeatability  ${err}`;
        }

    }

    async RaspberryDetailsWithHmi(strRasPi) {
        try {
            const obj = {
                str_tableName: 'tbl_idsport_details',
                data: '*',
                condition: [
                    { str_colName: 'Sys_IDSNo', value: strRasPi }
                ]
            }

            let arrRes = await database.select(obj);
            return arrRes[0][0].HMI
        } catch (error) {
            throw new Error(error)
        }
    }


    async checkEccentricityAccepancelimit(strBalId, Bal_DP) {
        try {


            var masterTableName = 'tbl_calibration_eccentricity_master_incomplete';
            var detailTableName = 'tbl_calibration_eccentricity_detail_incomplete';

            var dp = Bal_DP

            // const selectRepSrNoObj = {
            //     str_tableName: detailTableName,
            //     data: 'MAX(repet_repno) as Eccent_RepNo',
            //     condition: [
            //         { str_colName: 'Eccent_RepNo', value: strBalId, comp: 'eq' },
            //     ]
            // }


            var SqlQuery = `SELECT * FROM ${detailTableName} WHERE Eccent_RepNo=`
            SqlQuery = SqlQuery + `(SELECT MAX(Eccent_RepNo) AS Eccent_RepNo FROM ${masterTableName} WHERE Eccent_BalID ='${strBalId}')`

            var objselectRepSrNoObj = await dbCon.query(SqlQuery)

            if (objselectRepSrNoObj[0].length > 0) {
                var detailData = objselectRepSrNoObj[0];
                var repSrNo = objselectRepSrNoObj[0][0].Eccent_RepNo;
                var count = 0, finalVal;
                for (var i = 0; i < detailData.length; i++) {
                    /**
                     * formula used
                     * (C1-C) X100/C1,
                     * (C2-C) X100/C2,
                     * (C3-C) X100/C3
                     * (C4-C) X100/C4
                     */
                    var recNo = i + 1;
                    const data = await dbCon.execute(`SELECT ROUND(ABS((ROUND(Eccent_ActualWt,${dp}) - 
                    (SELECT ROUND(Eccent_ActualWt,${dp}) FROM tbl_calibration_eccentricity_detail 
                    WHERE Eccent_RepNo = ${repSrNo} AND Eccent_RecNo = 1))*100/(SELECT ROUND(Eccent_ActualWt,${dp}) FROM tbl_calibration_eccentricity_detail 
                    WHERE Eccent_RepNo = ${repSrNo} AND Eccent_RecNo = ${recNo})) ,${dp})AS Deviation,
                    CASE WHEN (SELECT (ROUND(ABS((ROUND(Eccent_ActualWt,${dp}) - (SELECT ROUND(Eccent_ActualWt,${dp}) FROM tbl_calibration_eccentricity_detail 
                    WHERE Eccent_RepNo = ${repSrNo} AND Eccent_RecNo = 1))*100/(SELECT ROUND(Eccent_ActualWt,${dp}) FROM tbl_calibration_eccentricity_detail 
                    WHERE Eccent_RepNo = ${repSrNo} AND Eccent_RecNo = ${recNo})) ,${dp})) > 0.05) THEN 'Not Ok' ELSE 'Ok' END AS remark  
                    FROM
                   ${detailTableName}
                    WHERE
                    Eccent_RepNo = ${repSrNo} AND Eccent_RecNo = ${recNo}`);


                    const remarkData = data[0][0];
                    if (remarkData.remark == "Not Ok") {
                        count = count + 1;
                    }
                }
                if (count > 0) { finalVal = 'Not Complies'; } else { finalVal = 'Complies'; };
                return finalVal;
            }
            else {
                return "Data not Found"
            }
        }
        catch (error) {
            console.log(error);
            throw new Error(error);
        }

    }
    async precision(a) {
        if (!isFinite(a)) return 0;
        var e = 1, p = 0;
        while (Math.round(a * e) / e !== a) { e *= 10; p++; }
        return p;
    }

}
module.exports = CalibrationModel