const globalData = require('../../global/globalData');
const Database = require('../../database/clsQueryProcess');
const sort = require('./checkForPendingCalib');
const normaDate = require('../../middleware/setTimeZone');
const CopyObjects = require('./clsCopyObject.model');
const obj_getRepSrNo = require('./repSrNo');
const database = new Database();
const copyObjects = new CopyObjects();
const moment = require('moment')
const models = require('../../../config/dbConnection').models
const sequelize = require('../../../config/dbConnection').sequelize;
const { QueryTypes } = require('sequelize');
class CommanFunction {
    //************************************************************************************************8 */
    //Below function checks if data is present or not in incomplete master tables
    //************************************************************************************************* */
    // async checkIfRecordInIncomplete(calibrationType, strBalId) {
    //     switch (calibrationType) {
    //         case 'P':


    //             var result = await models.tbl_calibration_periodic_master_incomplete.findAll({
    //                 where: {
    //                     "Periodic_BalID": strBalId
    //                 }
    //             })

    //             break;
    //         case 'R':

    //             var result = await models.tbl_calibration_repetability_master_incomplete.findAll({
    //                 where: {
    //                     "Repet_BalID": strBalId
    //                 }
    //             })

    //             break;
    //         case 'U':

    //             var result = await models.tbl_calibration_uncertinity_master_incomplete.findAll({
    //                 where: {
    //                     "Uncertinity_BalID": strBalId
    //                 }
    //             })

    //             break;
    //         case 'E':

    //             var result = await models.tbl_calibration_eccentricity_master_incomplete.findAll({
    //                 where: {
    //                     "Eccent_BalID": strBalId
    //                 }
    //             })

    //             break;
    //         case 'L':

    //             var result = await models.tbl_calibration_linearity_master_incomplete.findAll({
    //                 where: {
    //                     "Linear_BalID": strBalId
    //                 }
    //             })

    //             break;
    //     }
    //     result = [result]
    //     if (result[0].length == 0) {
    //         return false;
    //     } else {
    //         return true;
    //     }


    // }

    sortObject(obj) {
        return new Promise((resolve, reject) => {
            var arr = [];
            for (var prop in obj) {
                if (obj.hasOwnProperty(prop)) {
                    arr.push({
                        'key': prop,
                        'value': obj[prop]
                    });
                }
            }
            arr.sort(function (a, b) { return a.value - b.value; });
            //arr.sort(function(a, b) { a.value.toLowerCase().localeCompare(b.value.toLowerCase()); }); //use this to sort as strings
            resolve(arr); // returns array
        })
    }




    //****************************************************************************************************** */
    // Below Function handles failed calibration, it will move incomplete tables to failed tables 
    //******************************************************************************************************* */
    async caibrationFails(CalibrationType, RepNo, strBalId, calibType, deleteEntry = false, balType) {
        try {
            // CalibrationType is like 'P', 'R', 'E', 'U'..etc
            // strBalId holds the balance associated with that cubicle
            // RepNo holds the report sr no of incomplete tables
            var tempCaibStatus = globalData.calibrationStatus.find(k => k.BalId == strBalId);
            // getting position of current caibration in sorted array of calibrations
            let sortedArray = await sort.sortedSeqArray(globalData.arrSortedCalib, strBalId, balType); //globalData.arrSortedCalib tbl_calibration_sequnce
            var int_curentCalibrationIndex = sortedArray.indexOf(CalibrationType);
            // calculating first caalibration
            // var str_first_calibration = sortedArray[0];
            //var str_first_calibration = CalibrationType;
            if (calibType == "Monthly") {
                var str_first_calibration = "P"
            } else if (calibType == "Monthly") {
                var str_first_calibration = "P"
            }
            var fRerSrNo = await this.getFrepSrNo(str_first_calibration);
            // fRerSrNo is failed repSrNo which will insert in all failed tables
            var arr_CalibArray = []; // array holds calibration which done and one which failed
            for (let i = 0; i < int_curentCalibrationIndex + 1; i++) {
                arr_CalibArray.push(sortedArray[i])
            }
            // console.log('arr_CalibArray', arr_CalibArray);

            // v holds value such as 'P', 'U', 'E' .....etc

            switch (calibType) {
                case 'Monthly': {
                    {
                        var objPeriodic = await copyObjects.periodic('tbl_calibration_periodic_master_incomplete'
                            , 'tbl_calibration_periodic_master_failed', RepNo, 0, 'master')
                        // Copying Incomplete master to failed master

                        let columNames = objPeriodic.data.map(obj => obj.str_colName).toString();
                        var str_Query = `insert into tbl_calibration_periodic_master_failed (${columNames}) select ${columNames} from tbl_calibration_periodic_master_incomplete where Periodic_RepNo = ${RepNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
                        let resultPeriodic = await sequelize.query(str_Query, { type: sequelize.QueryTypes.INSERT })
                        // str_Query = 'select SCOPE_IDENTITY() as [Last Inserted Record]'
                        //  resultPeriodic = await sequelize.query(str_Query, { type: sequelize.QueryTypes.SELECT })


                        // last inserted Id got here form querymasterInsert[0]
                        var lastInsertedIdPeriodic = resultPeriodic[0][0].LastInsertedRecord;

                        // var findobj = await models.tbl_calibration_periodic_master_failed.findAll({

                        //     where: {
                        //         "srNo": lastInsertedIdPeriodic
                        //     }
                        // })
                        // Updating the report serial number in failed master
                        if (lastInsertedIdPeriodic != null) {

                            await models.tbl_calibration_periodic_master_failed.update({
                                "Periodic_RepNo": fRerSrNo,
                                "Periodic_CalbTime": moment(new Date()).format('HH:mm:ss'),
                                // "Periodic_DueDate": moment().format("YYYY-MM-DD")
                            }, {
                                where: {
                                    "srNo": lastInsertedIdPeriodic
                                }
                            })


                            // selecting data from incomplete details for copying
                            var resultP = await models.tbl_calibration_periodic_detail_incomplete.findAll({
                                where: {
                                    "Periodic_RepNo": RepNo
                                }
                            }); // selected
                            let res = [{}]
                            res[0].Periodic_RepNo = resultP[0].Periodic_RepNo
                            res[0].Periodic_RecNo = resultP[0].Periodic_RecNo
                            let i = 0;
                            for (let obj of resultP) {
                                obj.Periodic_RecNo = resultP[i].Periodic_RecNo
                                // as we have multiple entries i n details table so we need 
                                // Async loop



                                let objCopyPeriodic = await copyObjects.periodic('tbl_calibration_periodic_detail_incomplete'
                                    , 'tbl_calibration_periodic_detail_failed', obj.Periodic_RepNo, obj.Periodic_RecNo, 'detail');

                                columNames = objCopyPeriodic.data.map(obj => obj.str_colName).toString();
                                str_Query = `insert into tbl_calibration_periodic_detail_failed (${columNames}) select ${columNames} from tbl_calibration_periodic_detail_incomplete where Periodic_RepNo = ${obj.Periodic_RepNo} AND Periodic_RecNo = ${obj.Periodic_RecNo} select SCOPE_IDENTITY() as [LastInsertedRecord] `
                                let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                                var lastInsertedIdP = detailInsert[0][0].LastInsertedRecord;


                                await models.tbl_calibration_periodic_detail_failed.update({
                                    "Periodic_RepNo": fRerSrNo
                                }, {
                                    where: {
                                        "srNo": lastInsertedIdP
                                        // "Periodic_RepNo": res[0].Periodic_RepNo
                                    }
                                })

                                // updated repSrNo in failed details 
                                // console.log('P Copy')
                                // If ongoing calibration is failed ('Periodic') then only we have to delete
                                // records from incomplete tables for new entries

                                i++;
                            }

                            if (tempCaibStatus.status['P'] == 0) {
                                await models.tbl_calibration_periodic_master_incomplete.destroy({
                                    where: {
                                        "Periodic_RepNo": RepNo
                                    }
                                })
                                await models.tbl_calibration_periodic_detail_incomplete.destroy({
                                    where: {
                                        "Periodic_RepNo": RepNo
                                    }
                                })
                            }
                        }
                    }
                    {
                        var objUnccen = await copyObjects.uncertinity('tbl_calibration_uncertinity_master_incomplete'
                            , 'tbl_calibration_uncertinity_master_failed', RepNo, 0, 'master');
                        // console.log(obj)
                        let columNames = objUnccen.data.map(obj => obj.str_colName).toString();
                        var str_Query = `insert into tbl_calibration_uncertinity_master_failed (${columNames}) select ${columNames} from tbl_calibration_uncertinity_master_incomplete where Uncertinity_RepNo = ${RepNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
                        let resultUnccen = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
                        // console.log(result)
                        var lastInsertedIdUnccen = resultUnccen[0][0].LastInsertedRecord;
                        if (lastInsertedIdUnccen != null) {
                            await models.tbl_calibration_uncertinity_master_failed.update({
                                "Uncertinity_RepNo": fRerSrNo,
                                "Uncertinity_CalbTime": moment(new Date()).format('HH:mm:ss')
                            }, {
                                where: {
                                    "srNo": lastInsertedIdUnccen
                                }
                            })
                            var selectDetailObjUnccen = {
                                str_tableName: 'tbl_calibration_uncertinity_detail_incomplete',
                                data: 'Uncertinity_RepNo,Uncertinity_RecNo',
                                condition: [
                                    { str_colName: 'Uncertinity_RepNo', value: RepNo, comp: 'eq' }
                                ]
                            }
                            var resultU = await models.tbl_calibration_uncertinity_detail_incomplete.findAll({
                                where: {
                                    "Uncertinity_RepNo": RepNo
                                }
                            }); // selected
                            let res = [{}]
                            res[0].Uncertinity_RepNo = resultU[0].Uncertinity_RepNo
                            res[0].Uncertinity_RecNo = resultU[0].Uncertinity_RecNo
                            // console.log(result[0])
                            let i = 0;
                            for (let obj of resultU) {
                                obj.Uncertinity_RecNo = resultU[i].Uncertinity_RecNo
                                let objCopyUnccen = await copyObjects.uncertinity('tbl_calibration_uncertinity_detail_incomplete', 'tbl_calibration_uncertinity_detail_failed', obj.Uncertinity_RepNo, obj.Uncertinity_RecNo, 'detail');
                                columNames = objCopyUnccen.data.map(obj => obj.str_colName).toString();
                                str_Query = `insert into tbl_calibration_uncertinity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_uncertinity_detail_incomplete where Uncertinity_RepNo = ${obj.Uncertinity_RepNo} AND Uncertinity_RecNo = ${obj.Uncertinity_RecNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
                                let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                                var lastInsertedIdU = detailInsert[0][0].LastInsertedRecord;

                                await models.tbl_calibration_uncertinity_detail_failed.update({
                                    "Uncertinity_RepNo": fRerSrNo
                                }, {
                                    where: {
                                        "srNo": lastInsertedIdU
                                        // "Uncertinity_RepNo": obj.Uncertinity_RepNo
                                    }
                                })
                                i++
                            }
                            if (tempCaibStatus.status['U'] == 0) {
                                await models.tbl_calibration_uncertinity_master_incomplete.destroy({
                                    where: {
                                        "Uncertinity_RepNo": RepNo
                                    }
                                });
                                await models.tbl_calibration_uncertinity_detail_incomplete.destroy({
                                    where: {
                                        "Uncertinity_RepNo": RepNo
                                    }
                                });
                            }

                        }


                    }

                    {
                        var objReap = await copyObjects.repetability('tbl_calibration_repetability_master_incomplete'
                            , 'tbl_calibration_repetability_master_failed', RepNo, 0, 'master');
                        // Copying Incomplete master to failed master
                        let columNames = objReap.data.map(obj => obj.str_colName).toString();
                        var str_Query = `insert into tbl_calibration_repetability_master_failed (${columNames}) select ${columNames} from tbl_calibration_repetability_master_incomplete where Repet_RepNo = ${RepNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
                        let resultReap = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
                        // last inserted Id got here form query
                        var lastInsertedIdReap = resultReap[0][0].LastInsertedRecord;
                        // Updating the report serial number in failed master
                        if (lastInsertedIdReap != null) {
                            await models.tbl_calibration_repetability_master_failed.update({
                                "Repet_RepNo": fRerSrNo,
                                "Repet_CalbTime": moment(new Date()).format('HH:mm:ss')
                            }, {
                                where: {
                                    "srNo": lastInsertedIdReap
                                }
                            }) // failed master report number updated
                            // selecting data from incomplete details for copying

                            var resultP = await models.tbl_calibration_repetability_detail_incomplete.findAll({
                                where: {
                                    "Repet_RepNo": RepNo
                                }
                            }); // selected
                            let res = [{}]
                            res[0].Repet_RepNo = resultP[0].Repet_RepNo
                            res[0].Repet_RecNo = resultP[0].Repet_RecNo
                            // as we have multiple entries i n details table so we need 
                            // Async loop
                            let i = 0;
                            for (let obj of resultP) {
                                obj.Repet_RecNo = resultP[i].Repet_RecNo
                                let objCopyReap = await copyObjects.repetability('tbl_calibration_repetability_detail_incomplete'
                                    , 'tbl_calibration_repetability_detail_failed', obj.Repet_RepNo, obj.Repet_RecNo, 'detail');

                                columNames = objCopyReap.data.map(obj => obj.str_colName).toString();
                                str_Query = `insert into tbl_calibration_repetability_detail_failed (${columNames}) select ${columNames} from tbl_calibration_repetability_detail_incomplete where Repet_RepNo = ${obj.Repet_RepNo} AND Repet_RecNo = ${obj.Repet_RecNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
                                let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                                var lastInsertedIdU = detailInsert[0][0].LastInsertedRecord;

                                await models.tbl_calibration_repetability_detail_failed.update({
                                    "Repet_RepNo": fRerSrNo
                                }, {
                                    where: {
                                        "srNo": lastInsertedIdU
                                        // "Repet_RepNo": res[0].Repet_RepNo
                                    }
                                });
                                i++;
                            }
                            if (tempCaibStatus.status['R'] == 0) {
                                await models.tbl_calibration_repetability_master_incomplete.destroy({
                                    where: {
                                        "Repet_RepNo": RepNo
                                    }
                                });
                                await models.tbl_calibration_repetability_detail_incomplete.destroy({
                                    where: {
                                        "Repet_RepNo": RepNo
                                    }
                                });
                            }
                        }
                    }
                    {
                        var objEccen = await copyObjects.eccentricity('tbl_calibration_eccentricity_master_incomplete'
                            , 'tbl_calibration_eccentricity_master_failed', RepNo, 0, 'master');
                        // console.log(obj)
                        let columNames = objEccen.data.map(obj => obj.str_colName).toString();
                        var str_Query = `insert into tbl_calibration_eccentricity_master_failed (${columNames}) select ${columNames} from tbl_calibration_eccentricity_master_incomplete where Eccent_RepNo = ${RepNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
                        let resultEccen = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
                        // console.log(result)
                        var lastInsertedIdEccen = resultEccen[0][0].LastInsertedRecord;

                        if (lastInsertedIdEccen != null) {
                            await models.tbl_calibration_eccentricity_master_failed.update({
                                "Eccent_RepNo": fRerSrNo,
                                "Eccent_CalbTime": moment(new Date()).format('HH:mm:ss')
                            }, {
                                where: {
                                    "srNo": lastInsertedIdEccen
                                }
                            })

                            var resultP = await models.tbl_calibration_eccentricity_detail_incomplete.findAll({
                                where: {
                                    "Eccent_RepNo": RepNo
                                }
                            }); // selected
                            let res = [{}]
                            res[0].Eccent_RepNo = resultP[0].Eccent_RepNo
                            res[0].Eccent_RecNo = resultP[0].Eccent_RecNo
                            // console.log(result[0])
                            let i = 0;
                            for (let obj of resultP) {
                                obj.Eccent_RecNo = resultP[i].Eccent_RecNo
                                let objCopyEccen = await copyObjects.eccentricity('tbl_calibration_eccentricity_detail_incomplete'
                                    , 'tbl_calibration_eccentricity_detail_failed', obj.Eccent_RepNo, obj.Eccent_RecNo, 'detail');
                                columNames = objCopyEccen.data.map(obj => obj.str_colName).toString();
                                str_Query = `insert into tbl_calibration_eccentricity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_eccentricity_detail_incomplete where Eccent_RepNo = ${obj.Eccent_RepNo} AND Eccent_RecNo = ${obj.Eccent_RecNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
                                let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                                var lastInsertedIdU = detailInsert[0][0].LastInsertedRecord;

                                await models.tbl_calibration_eccentricity_detail_failed.update({
                                    "Eccent_RepNo": fRerSrNo,
                                    "Eccent_CalbTime": moment(new Date()).format('HH:mm:ss')
                                }, {
                                    where: {
                                        "srNo": lastInsertedIdU
                                        // "Eccent_RepNo":  res[0].Eccent_RepNo
                                    }
                                })
                                i++

                            }

                            if (tempCaibStatus.status['E'] == 0) {
                                await models.tbl_calibration_eccentricity_master_incomplete.destroy({
                                    where: {
                                        "Eccent_RepNo": RepNo
                                    }
                                });
                                await models.tbl_calibration_eccentricity_detail_incomplete.destroy({
                                    where: {
                                        "Eccent_RepNo": RepNo
                                    }
                                });
                            }


                        }


                    }
                    if (deleteEntry) {
                        await models.tbl_calibration_periodic_master_incomplete.destroy({
                            where: {
                                "Periodic_RepNo": RepNo
                            }
                        });
                        await models.tbl_calibration_periodic_detail_incomplete.destroy({
                            where: {
                                "Periodic_RepNo": RepNo
                            }
                        });

                        await models.tbl_calibration_eccentricity_master_incomplete.destroy({
                            where: {
                                "Eccent_RepNo": RepNo
                            }
                        });
                        await models.tbl_calibration_eccentricity_detail_incomplete.destroy({
                            where: {
                                "Eccent_RepNo": RepNo
                            }
                        });

                        await models.tbl_calibration_repetability_master_incomplete.destroy({
                            where: {
                                "Repet_RepNo": RepNo
                            }
                        });
                        await models.tbl_calibration_repetability_detail_incomplete.destroy({
                            where: {
                                "Repet_RepNo": RepNo
                            }
                        });

                        let arrselectBalData = await models.tbl_balance.findOne({
                            where: {
                                'Bal_ID': strBalId
                            }
                        });
                        arrselectBalData = [[arrselectBalData]]



                        const bln_storeType = arrselectBalData[0][0].Bal_CalbStoreType
                        // if (bln_storeType == 1) {
                        //     // await models.tbl_calibration_status.update({
                        //     //     // 'P': 0,
                        //     //     // // 'E': 0,
                        //     //     // 'R': 0,
                        //     //     // 'U': 0,
                        //     //     // 'L': 0
                        //     // }, {
                        //     //     where: {
                        //     //         'BalID': strBalId
                        //     //     }
                        //     // });
                        // } else {
                        await models.tbl_calibration_status.update({
                            'P': 0,
                            'E': 0,
                            'R': 0,
                            'U': 0,
                            'L': 0
                        }, {
                            where: {
                                'BalID': strBalId
                            }
                        });
                    }
                    // }



                }
                    break;
                case 'Yearly': {
                    // First copying data
                    {
                        var objUnccen = await copyObjects.uncertinity('tbl_calibration_uncertinity_master_incomplete'
                            , 'tbl_calibration_uncertinity_master_failed', RepNo, 0, 'master');
                        // console.log(obj)
                        let columNames = objUnccen.data.map(obj => obj.str_colName).toString();
                        var str_Query = `insert into tbl_calibration_uncertinity_master_failed (${columNames}) select ${columNames} from tbl_calibration_uncertinity_master_incomplete where Uncertinity_RepNo = ${RepNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
                        let resultUnccen = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
                        // console.log(result)
                        var lastInsertedIdUnccen = resultUnccen[0];
                        if (lastInsertedIdUnccen != 0) {
                            await models.tbl_calibration_uncertinity_master_failed.update({
                                "Uncertinity_RepNo": fRerSrNo,
                                "Uncertinity_CalbTime": moment(new Date()).format('HH:mm:ss')
                            }, {
                                where: {
                                    "srNo": lastInsertedIdUnccen
                                }
                            })
                            var selectDetailObjUnccen = {
                                str_tableName: 'tbl_calibration_uncertinity_detail_incomplete',
                                data: 'Uncertinity_RepNo,Uncertinity_RecNo',
                                condition: [
                                    { str_colName: 'Uncertinity_RepNo', value: RepNo, comp: 'eq' }
                                ]
                            }
                            var resultU = await models.tbl_calibration_uncertinity_detail_incomplete.findAll({
                                where: {
                                    "Uncertinity_RepNo": RepNo
                                }
                            }); // selected
                            let res = [{}]
                            res[0].Uncertinity_RepNo = resultU[0].Uncertinity_RepNo
                            res[0].Uncertinity_RecNo = resultU[0].Uncertinity_RecNo
                            // console.log(result[0])
                            let i = 0;
                            for (let obj of resultU) {
                                obj.Uncertinity_RecNo = resultU[i].Uncertinity_RecNo
                                let objCopyUnccen = await copyObjects.uncertinity('tbl_calibration_uncertinity_detail_incomplete', 'tbl_calibration_uncertinity_detail_failed', obj.Uncertinity_RepNo, obj.Uncertinity_RecNo, 'detail');
                                columNames = objCopyUnccen.data.map(obj => obj.str_colName).toString();
                                str_Query = `insert into tbl_calibration_uncertinity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_uncertinity_detail_incomplete where Uncertinity_RepNo = ${obj.Uncertinity_RepNo} AND Uncertinity_RecNo = ${obj.Uncertinity_RecNo} select SCOPE_IDENTITY() as [LastInsertedRecord]aa`
                                let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                                var lastInsertedIdU = detailInsert[0];

                                await models.tbl_calibration_uncertinity_detail_failed.update({
                                    "Uncertinity_RepNo": fRerSrNo
                                }, {
                                    where: {
                                        "srNo": lastInsertedIdU
                                        // "Uncertinity_RepNo": obj.Uncertinity_RepNo
                                    }
                                })
                                i++
                            }
                            if (tempCaibStatus.status['U'] == 0) {
                                await models.tbl_calibration_uncertinity_master_incomplete.destroy({
                                    where: {
                                        "Uncertinity_RepNo": RepNo
                                    }
                                });
                                await models.tbl_calibration_uncertinity_detail_incomplete.destroy({
                                    where: {
                                        "Uncertinity_RepNo": RepNo
                                    }
                                });
                            }

                        }


                    }

                    // {
                    //     var objEccen = await copyObjects.eccentricity('tbl_calibration_eccentricity_master_incomplete'
                    //         , 'tbl_calibration_eccentricity_master_failed', RepNo, 0, 'master');
                    //     // console.log(obj)
                    //     let columNames = objEccen.data.map(obj => obj.str_colName).toString();
                    //     var str_Query = `insert into tbl_calibration_eccentricity_master_failed (${columNames}) select ${columNames} from tbl_calibration_eccentricity_master_incomplete where Eccent_RepNo = ${RepNo}`
                    //     let resultEccen = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
                    //     // console.log(result)
                    //     var lastInsertedIdEccen = resultEccen[0];

                    //     if (lastInsertedIdEccen != 0) {
                    //         await models.tbl_calibration_eccentricity_master_failed.update({
                    //             "Eccent_RepNo": fRerSrNo,
                    //             "Eccent_CalbTime": moment(new Date()).format('HH:mm:ss')
                    //         }, {
                    //             where: {
                    //                 "srNo": lastInsertedIdEccen
                    //             }
                    //         })

                    //         var resultP = await models.tbl_calibration_eccentricity_detail_incomplete.findAll({
                    //             where: {
                    //                 "Eccent_RepNo": RepNo
                    //             }
                    //         }); // selected
                    //         let res = [{}]
                    //         res[0].Eccent_RepNo = resultP[0].Eccent_RepNo
                    //         res[0].Eccent_RecNo = resultP[0].Eccent_RecNo
                    //         // console.log(result[0])
                    //         let i = 0;
                    //         for (let obj of resultP) {
                    //             obj.Eccent_RecNo = resultP[i].Eccent_RecNo
                    //             let objCopyEccen = await copyObjects.eccentricity('tbl_calibration_eccentricity_detail_incomplete'
                    //                 , 'tbl_calibration_eccentricity_detail_failed', obj.Eccent_RepNo, obj.Eccent_RecNo, 'detail');
                    //             columNames = objCopyEccen.data.map(obj => obj.str_colName).toString();
                    //             str_Query = `insert into tbl_calibration_eccentricity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_eccentricity_detail_incomplete where Eccent_RepNo = ${obj.Eccent_RepNo} AND Eccent_RecNo = ${obj.Eccent_RecNo}`
                    //             let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                    //             var lastInsertedIdU = detailInsert[0];

                    //             await models.tbl_calibration_eccentricity_detail_failed.update({
                    //                 "Eccent_RepNo": fRerSrNo,
                    //                 "Eccent_CalbTime": moment(new Date()).format('HH:mm:ss')
                    //             }, {
                    //                 where: {
                    //                     "srNo": lastInsertedIdU
                    //                     // "Eccent_RepNo":  res[0].Eccent_RepNo
                    //                 }
                    //             })
                    //             i++

                    //         }

                    //         if (tempCaibStatus.status['E'].readIntLE() == 0) {
                    //             await models.tbl_calibration_eccentricity_master_incomplete.destroy({
                    //                 where: {
                    //                     "Eccent_RepNo": RepNo
                    //                 }
                    //             });
                    //             await models.tbl_calibration_eccentricity_detail_incomplete.destroy({
                    //                 where: {
                    //                     "Eccent_RepNo": RepNo
                    //                 }
                    //             });
                    //         }


                    //     }


                    // }
                    {
                        var objLinear = await copyObjects.linearity('tbl_calibration_linearity_master_incomplete'
                            , 'tbl_calibration_linearity_master_failed', RepNo, 0, 'master');
                        // Copying Incomplete master to failed master
                        let columNames = objLinear.data.map(obj => obj.str_colName).toString();
                        var str_Query = `insert into tbl_calibration_linearity_master_failed (${columNames}) select ${columNames} from tbl_calibration_linearity_master_incomplete where Linear_RepNo = ${RepNo}`
                        let resultLinear = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
                        // last inserted Id got here form query
                        var lastInsertedIdLinear = resultLinear[0];
                        // Updating the report serial number in failed master

                        if (lastInsertedIdLinear != 0) {

                            await models.tbl_calibration_linearity_master_failed.update({
                                "Linear_RepNo": fRerSrNo,
                                "Linear_CalbTime": moment(new Date()).format('HH:mm:ss')
                            }, {
                                where: {
                                    "srNo": lastInsertedIdLinear
                                }
                            }) // failed master report number updated
                            // selecting data from incomplete details for copying

                            var resultP = await models.tbl_calibration_linearity_detail_incomplete.findAll({
                                where: {
                                    "Linear_RepNo": RepNo
                                }
                            }); // selected
                            let res = [{}]
                            res[0].Linear_RepNo = resultP[0].Linear_RepNo
                            res[0].Linear_RecNo = resultP[0].Linear_RecNo
                            // as we have multiple entries i n details table so we need 
                            // Async loop
                            let i = 0;
                            for (let obj of resultP) {
                                obj.Linear_RecNo = resultP[i].Linear_RecNo
                                let objCopyLinear = await copyObjects.linearity('tbl_calibration_linearity_detail_incomplete'
                                    , 'tbl_calibration_linearity_detail_failed', obj.Linear_RepNo, obj.Linear_RecNo, 'detail');

                                columNames = objCopyLinear.data.map(obj => obj.str_colName).toString();
                                str_Query = `insert into tbl_calibration_linearity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_linearity_detail_incomplete where Linear_RepNo = ${obj.Linear_RepNo} AND Linear_RecNo = ${obj.Linear_RecNo}`
                                let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                                var lastInsertedIdU = detailInsert[0];

                                await models.tbl_calibration_linearity_detail_failed.update({
                                    "Linear_RepNo": fRerSrNo
                                }, {
                                    where: {
                                        "srNo": lastInsertedIdU
                                        // "Linear_RepNo": res[0].Linear_RepNo
                                    }
                                })
                                i++;
                            }

                            if (tempCaibStatus.status['L'] == 0) {
                                await models.tbl_calibration_linearity_master_incomplete.destroy({
                                    where: {
                                        "Linear_RepNo": RepNo
                                    }
                                })
                                await models.tbl_calibration_linearity_detail_incomplete.destroy({
                                    where: {
                                        "Linear_RepNo": RepNo
                                    }
                                })
                            }

                        }
                    }

                    if (deleteEntry) {
                        await models.tbl_calibration_uncertinity_master_incomplete.destroy({
                            where: {
                                "Uncertinity_RepNo": RepNo
                            }
                        });
                        await models.tbl_calibration_uncertinity_detail_incomplete.destroy({
                            where: {
                                "Uncertinity_RepNo": RepNo
                            }
                        });

                        // await models.tbl_calibration_eccentricity_master_incomplete.destroy({
                        //     where: {
                        //         "Eccent_RepNo": RepNo
                        //     }
                        // });
                        // await models.tbl_calibration_eccentricity_detail_incomplete.destroy({
                        //     where: {
                        //         "Eccent_RepNo": RepNo
                        //     }
                        // });

                        await models.tbl_calibration_linearity_master_incomplete.destroy({
                            where: {
                                "Linear_RepNo": RepNo
                            }
                        });
                        await models.tbl_calibration_linearity_detail_incomplete.destroy({
                            where: {
                                "Linear_RepNo": RepNo
                            }
                        });

                        let arrselectBalData = await models.tbl_balance.findOne({
                            where: {
                                'Bal_ID': strBalId
                            }
                        });
                        arrselectBalData = [[arrselectBalData]]



                        const bln_storeType = arrselectBalData[0][0].Bal_CalbStoreType
                        // if (bln_storeType == 1) {
                        await models.tbl_calibration_status.update({

                            // 'E': 0,

                            'U': 0,
                            'L': 0
                        }, {
                            where: {
                                'BalID': strBalId
                            }
                        })
                        // } else {
                        //     await models.tbl_calibration_status.update({

                        //         'E': 0,

                        //         'U': 0,
                        //         'L': 0
                        //     }, {
                        //         where: {
                        //             'BalID': strBalId
                        //         }
                        //     })
                        // }



                    }

                }
            }


            // switch (CalibrationType) {
            //     // For case PERIODIC CALIBRATION
            //     case 'P': {
            //         var objPeriodic = await copyObjects.periodic('tbl_calibration_periodic_master_incomplete'
            //             , 'tbl_calibration_periodic_master_failed', RepNo, 0, 'master')
            //         // Copying Incomplete master to failed master

            //         let columNames = objPeriodic.data.map(obj => obj.str_colName).toString();
            //         var str_Query = `insert into tbl_calibration_periodic_master_failed (${columNames}) select ${columNames} from tbl_calibration_periodic_master_incomplete where Periodic_RepNo = ${RepNo}`
            //         let resultPeriodic = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

            //         // last inserted Id got here form querymasterInsert[0]
            //         var lastInsertedIdPeriodic = resultPeriodic[0];
            //         // Updating the report serial number in failed master

            //         await models.tbl_calibration_periodic_master_failed.update({
            //             "Periodic_RepNo": fRerSrNo,
            //             "Periodic_EndTime": moment(new Date()).format('HH:mm:ss')
            //         }, {
            //             where: {
            //                 "srNo": lastInsertedIdPeriodic
            //             }
            //         })


            //         // selecting data from incomplete details for copying
            //         var resultP = await models.tbl_calibration_periodic_detail_incomplete.findAll({
            //             where: {
            //                 "Periodic_RepNo": RepNo
            //             }
            //         }); // selected
            //         let res = [{}]
            //         res[0].Periodic_RepNo = resultP[0].Periodic_RepNo
            //         res[0].Periodic_RecNo = resultP[0].Periodic_RecNo
            //         let i = 0;
            //         for (let obj of resultP) {
            //             obj.Periodic_RecNo = resultP[i].Periodic_RecNo
            //             // as we have multiple entries i n details table so we need 
            //             // Async loop



            //             let objCopyPeriodic = await copyObjects.periodic('tbl_calibration_periodic_detail_incomplete'
            //                 , 'tbl_calibration_periodic_detail_failed', obj.Periodic_RepNo, obj.Periodic_RecNo, 'detail');

            //             columNames = objCopyPeriodic.data.map(obj => obj.str_colName).toString();
            //             str_Query = `insert into tbl_calibration_periodic_detail_failed (${columNames}) select ${columNames} from tbl_calibration_periodic_detail_incomplete where Periodic_RepNo = ${obj.Periodic_RepNo} AND Periodic_RecNo = ${obj.Periodic_RecNo}`
            //             let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

            //             var lastInsertedIdP = detailInsert[0];


            //             await models.tbl_calibration_periodic_detail_failed.update({
            //                 "Periodic_RepNo": fRerSrNo
            //             }, {
            //                 where: {
            //                     "srNo": lastInsertedIdP
            //                     // "Periodic_RepNo": res[0].Periodic_RepNo
            //                 }
            //             })

            //             // updated repSrNo in failed details 
            //             // console.log('P Copy')
            //             // If ongoing calibration is failed ('Periodic') then only we have to delete
            //             // records from incomplete tables for new entries

            //             i++;
            //         }
            //         // for (let obj of res) {
            //         //     obj.Periodic_RecNo = resultU[i].Periodic_RecNo
            //         //     // as we have multiple entries i n details table so we need 
            //         //     // Async loop



            //         //     let objCopyPeriodic = await copyObjects.periodic('tbl_calibration_periodic_detail_incomplete'
            //         //         , 'tbl_calibration_periodic_detail_failed', obj.Periodic_RepNo, obj.Periodic_RecNo, 'detail');

            //         //     columNames = objCopyPeriodic.data.map(obj => obj.str_colName).toString();
            //         //     str_Query = `insert into tbl_calibration_periodic_detail_failed (${columNames}) select ${columNames} from tbl_calibration_periodic_detail_incomplete where Periodic_RepNo = ${obj.Periodic_RepNo}`
            //         //     let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

            //         //     var lastInsertedIdP = detailInsert[0];


            //         //     await models.tbl_calibration_periodic_detail_failed.update({
            //         //         "Periodic_RepNo": fRerSrNo
            //         //     }, {
            //         //         where: {
            //         //             // "srNo": lastInsertedIdP
            //         //             "Periodic_RepNo": res[0].Periodic_RepNo
            //         //         }
            //         //     })

            //         //     // updated repSrNo in failed details 
            //         //     // console.log('P Copy')
            //         //     // If ongoing calibration is failed ('Periodic') then only we have to delete
            //         //     // records from incomplete tables for new entries

            //         // i++;
            //         // }

            //         if (sortedArray.indexOf('P') == int_curentCalibrationIndex) {
            //             // delete records from incomplete tables

            //             await models.tbl_calibration_periodic_master_incomplete.destroy({
            //                 where: {
            //                     "Periodic_RepNo": RepNo
            //                 }
            //             })
            //             await models.tbl_calibration_periodic_detail_incomplete.destroy({
            //                 where: {
            //                     "Periodic_RepNo": RepNo
            //                 }
            //             })


            //         }
            //     }
            //         break;
            //     // For case UNCERTINITY CALIBRATION
            //     case 'U': {
            //         // First copying data
            //         var objUnccen = await copyObjects.uncertinity('tbl_calibration_uncertinity_master_incomplete'
            //             , 'tbl_calibration_uncertinity_master_failed', RepNo, 0, 'master');
            //         // console.log(obj)
            //         let columNames = objUnccen.data.map(obj => obj.str_colName).toString();
            //         var str_Query = `insert into tbl_calibration_uncertinity_master_failed (${columNames}) select ${columNames} from tbl_calibration_uncertinity_master_incomplete where Uncertinity_RepNo = ${RepNo}`
            //         let resultUnccen = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
            //         // console.log(result)
            //         var lastInsertedIdUnccen = resultUnccen[0];

            //         await models.tbl_calibration_uncertinity_master_failed.update({
            //             "Uncertinity_RepNo": fRerSrNo,
            //             "Uncertinity_EndTime": moment(new Date()).format('HH:mm:ss')
            //         }, {
            //             where: {
            //                 "srNo": lastInsertedIdUnccen
            //             }
            //         })
            //         var selectDetailObjUnccen = {
            //             str_tableName: 'tbl_calibration_uncertinity_detail_incomplete',
            //             data: 'Uncertinity_RepNo,Uncertinity_RecNo',
            //             condition: [
            //                 { str_colName: 'Uncertinity_RepNo', value: RepNo, comp: 'eq' }
            //             ]
            //         }
            //         var resultU = await models.tbl_calibration_uncertinity_detail_incomplete.findAll({
            //             where: {
            //                 "Uncertinity_RepNo": RepNo
            //             }
            //         }); // selected
            //         let res = [{}]
            //         res[0].Uncertinity_RepNo = resultU[0].Uncertinity_RepNo
            //         res[0].Uncertinity_RecNo = resultU[0].Uncertinity_RecNo
            //         // console.log(result[0])
            //         let i = 0;
            //         for (let obj of resultU) {
            //             obj.Uncertinity_RecNo = resultU[i].Uncertinity_RecNo
            //             let objCopyUnccen = await copyObjects.uncertinity('tbl_calibration_uncertinity_detail_incomplete', 'tbl_calibration_uncertinity_detail_failed', obj.Uncertinity_RepNo, obj.Uncertinity_RecNo, 'detail');
            //             columNames = objCopyUnccen.data.map(obj => obj.str_colName).toString();
            //             str_Query = `insert into tbl_calibration_uncertinity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_uncertinity_detail_incomplete where Uncertinity_RepNo = ${obj.Uncertinity_RepNo} AND Uncertinity_RecNo = ${obj.Uncertinity_RecNo}`
            //             let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

            //             var lastInsertedIdU = detailInsert[0];

            //             await models.tbl_calibration_uncertinity_detail_failed.update({
            //                 "Uncertinity_RepNo": fRerSrNo
            //             }, {
            //                 where: {
            //                     "srNo": lastInsertedIdU
            //                     // "Uncertinity_RepNo": obj.Uncertinity_RepNo
            //                 }
            //             })
            //             i++
            //         }

            //         if (sortedArray.indexOf('U') == int_curentCalibrationIndex) {
            //             // delete records from incomplete tables
            //             console.log('inside delete')

            //             await models.tbl_calibration_uncertinity_master_incomplete.destroy({
            //                 where: {
            //                     "Uncertinity_RepNo": RepNo
            //                 }
            //             })
            //             await models.tbl_calibration_uncertinity_detail_incomplete.destroy({
            //                 where: {
            //                     "Uncertinity_RepNo": RepNo
            //                 }
            //             })
            //         }
            //     }
            //         break;
            //     // For case ECCENTRICITY CALIBRATION
            //     case 'E': {
            //         // First copying data
            //         var objEccen = await copyObjects.eccentricity('tbl_calibration_eccentricity_master_incomplete'
            //             , 'tbl_calibration_eccentricity_master_failed', RepNo, 0, 'master');
            //         // console.log(obj)
            //         let columNames = objEccen.data.map(obj => obj.str_colName).toString();
            //         var str_Query = `insert into tbl_calibration_eccentricity_master_failed (${columNames}) select ${columNames} from tbl_calibration_eccentricity_master_incomplete where Eccent_RepNo = ${RepNo}`
            //         let resultEccen = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
            //         // console.log(result)
            //         var lastInsertedIdEccen = resultEccen[0]

            //         await models.tbl_calibration_eccentricity_master_failed.update({
            //             "Eccent_RepNo": fRerSrNo,
            //             "Eccent_EndTime": moment(new Date()).format('HH:mm:ss')
            //         }, {
            //             where: {
            //                 "srNo": lastInsertedIdEccen
            //             }
            //         })

            //         var resultP = await models.tbl_calibration_eccentricity_detail_incomplete.findAll({
            //             where: {
            //                 "Eccent_RepNo": RepNo
            //             }
            //         }); // selected
            //         let res = [{}]
            //         res[0].Eccent_RepNo = resultP[0].Eccent_RepNo
            //         res[0].Eccent_RecNo = resultP[0].Eccent_RecNo
            //         // console.log(result[0])
            //         let i = 0;
            //         for (let obj of resultP) {
            //             obj.Eccent_RecNo = resultP[i].Eccent_RecNo
            //             let objCopyEccen = await copyObjects.eccentricity('tbl_calibration_eccentricity_detail_incomplete'
            //                 , 'tbl_calibration_eccentricity_detail_failed', obj.Eccent_RepNo, obj.Eccent_RecNo, 'detail');
            //             columNames = objCopyEccen.data.map(obj => obj.str_colName).toString();
            //             str_Query = `insert into tbl_calibration_eccentricity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_eccentricity_detail_incomplete where Eccent_RepNo = ${obj.Eccent_RepNo} AND Eccent_RecNo = ${obj.Eccent_RecNo}`
            //             let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

            //             var lastInsertedIdU = detailInsert[0];

            //             await models.tbl_calibration_uncertinity_detail_failed.update({
            //                 "Eccent_RepNo": fRerSrNo,
            //                 "Linear_EndTime": moment(new Date()).format('HH:mm:ss')
            //             }, {
            //                 where: {
            //                     "srNo": lastInsertedIdU
            //                     // "Eccent_RepNo":  res[0].Eccent_RepNo
            //                 }
            //             })
            //             i++

            //         }
            //         if (sortedArray.indexOf('E') == int_curentCalibrationIndex) {
            //             // delete records from incomplete tables
            //             console.log('inside delete')

            //             await models.tbl_calibration_eccentricity_master_incomplete.destroy({
            //                 where: {
            //                     "Eccent_RepNo": RepNo
            //                 }
            //             })
            //             await models.tbl_calibration_eccentricity_detail_incomplete.destroy({
            //                 where: {
            //                     "Eccent_RepNo": RepNo
            //                 }
            //             })
            //         }
            //     }
            //         break;
            //     // For case REPETABILITY CALIBRATION
            //     case 'R': {
            //         var objReap = await copyObjects.repetability('tbl_calibration_repetability_master_incomplete'
            //             , 'tbl_calibration_repetability_master_failed', RepNo, 0, 'master');
            //         // Copying Incomplete master to failed master
            //         let columNames = objReap.data.map(obj => obj.str_colName).toString();
            //         var str_Query = `insert into tbl_calibration_repetability_master_failed (${columNames}) select ${columNames} from tbl_calibration_repetability_master_incomplete where Repet_RepNo = ${RepNo}`
            //         let resultReap = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
            //         // last inserted Id got here form query
            //         var lastInsertedIdReap = resultReap[0];
            //         // Updating the report serial number in failed master

            //         await models.tbl_calibration_repetability_master_failed.update({
            //             "Repet_RepNo": fRerSrNo,
            //             "Repet_EndTime": moment(new Date()).format('HH:mm:ss')
            //         }, {
            //             where: {
            //                 "srNo": lastInsertedIdReap
            //             }
            //         }) // failed master report number updated
            //         // selecting data from incomplete details for copying

            //         var resultP = await models.tbl_calibration_repetability_detail_incomplete.findAll({
            //             where: {
            //                 "Repet_RepNo": RepNo
            //             }
            //         }); // selected
            //         let res = [{}]
            //         res[0].Repet_RepNo = resultP[0].Repet_RepNo
            //         res[0].Repet_RecNo = resultP[0].Repet_RecNo
            //         // as we have multiple entries i n details table so we need 
            //         // Async loop
            //         let i = 0;
            //         for (let obj of resultP) {
            //             obj.Repet_RecNo = resultP[i].Repet_RecNo
            //             let objCopyReap = await copyObjects.repetability('tbl_calibration_repetability_detail_incomplete'
            //                 , 'tbl_calibration_repetability_detail_failed', obj.Repet_RepNo, obj.Repet_RecNo, 'detail');

            //             columNames = objCopyReap.data.map(obj => obj.str_colName).toString();
            //             str_Query = `insert into tbl_calibration_repetability_detail_failed (${columNames}) select ${columNames} from tbl_calibration_repetability_detail_incomplete where Repet_RecNo = ${obj.Repet_RecNo} AND Repet_RecNo = ${obj.Repet_RecNo}`
            //             let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

            //             var lastInsertedIdU = detailInsert[0];

            //             await models.tbl_calibration_uncertinity_detail_failed.update({
            //                 "Repet_RepNo": fRerSrNo
            //             }, {
            //                 where: {
            //                     "srNo": lastInsertedIdU
            //                     // "Repet_RepNo": res[0].Repet_RepNo
            //                 }
            //             })
            //             i++
            //         }

            //         if (sortedArray.indexOf('R') == int_curentCalibrationIndex) {
            //             // delete records from incomplete tables
            //             console.log('inside delete')

            //             await models.tbl_calibration_repetability_master_incomplete.destroy({
            //                 where: {
            //                     "Repet_RepNo": RepNo
            //                 }
            //             })
            //             await models.tbl_calibration_repetability_detail_incomplete.destroy({
            //                 where: {
            //                     "Repet_RepNo": RepNo
            //                 }
            //             })

            //         }
            //     }
            //         break;

            //     // For case Linearity CALIBRATION
            //     case 'L': {
            //         var objLinear = await copyObjects.linearity('tbl_calibration_linearity_master_incomplete'
            //             , 'tbl_calibration_linearity_master_failed', RepNo, 0, 'master');
            //         // Copying Incomplete master to failed master
            //         let columNames = objLinear.data.map(obj => obj.str_colName).toString();
            //         var str_Query = `insert into tbl_calibration_linearity_master_failed (${columNames}) select ${columNames} from tbl_calibration_linearity_master_incomplete where Linear_RepNo = ${RepNo}`
            //         let resultLinear = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
            //         // last inserted Id got here form query
            //         var lastInsertedIdLinear = resultLinear[0];
            //         // Updating the report serial number in failed master

            //         await models.tbl_calibration_linearity_master_failed.update({
            //             "Linear_RepNo": fRerSrNo,
            //             "Linear_EndTime": moment(new Date()).format('HH:mm:ss')
            //         }, {
            //             where: {
            //                 "srNo": lastInsertedIdLinear
            //             }
            //         }) // failed master report number updated
            //         // selecting data from incomplete details for copying

            //         var resultP = await models.tbl_calibration_linearity_detail_incomplete.findAll({
            //             where: {
            //                 "Linear_RepNo": RepNo
            //             }
            //         }); // selected
            //         let res = [{}]
            //         res[0].Linear_RepNo = resultP[0].Linear_RepNo
            //         res[0].Linear_RecNo = resultP[0].Linear_RecNo
            //         // as we have multiple entries i n details table so we need 
            //         // Async loop
            //         let i = 0;
            //         for (let obj of res) {
            //             obj.Linear_RecNo = resultP[i].Linear_RecNo
            //             let objCopyLinear = await copyObjects.linearity('tbl_calibration_linearity_detail_incomplete'
            //                 , 'tbl_calibration_linearity_detail_failed', obj.Linear_RepNo, obj.Linear_RecNo, 'detail');

            //             columNames = objCopyLinear.data.map(obj => obj.str_colName).toString();
            //             str_Query = `insert into tbl_calibration_linearity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_linearity_detail_incomplete where Linear_RecNo = ${obj.Linear_RecNo} AND Linear_RecNo = ${obj.Linear_RecNo}`
            //             let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

            //             var lastInsertedIdU = detailInsert[0];

            //             await models.tbl_calibration_linearity_detail_failed.update({
            //                 "Linear_RepNo": fRerSrNo
            //             }, {
            //                 where: {
            //                     "srNo": lastInsertedIdU
            //                     // "Linear_RepNo": res[0].Linear_RepNo
            //                 }
            //             })
            //             i++;
            //         }

            //         if (sortedArray.indexOf('L') == int_curentCalibrationIndex) {
            //             // delete records from incomplete tables
            //             console.log('inside delete')

            //             await models.tbl_calibration_linearity_master_incomplete.destroy({
            //                 where: {
            //                     "Linear_RepNo": RepNo
            //                 }
            //             })
            //             await models.tbl_calibration_linearity_detail_incomplete.destroy({
            //                 where: {
            //                     "Linear_RepNo": RepNo
            //                 }
            //             })

            //         }
            //     }
            //         break;

            // }
        } catch (error) {
            console.log(error)
        }
    }


    //******************************************************************************************************* */
    // Below function calculates failed report serial number whichever is first calibration in will calculate
    // w.r.t to that calibration which different than actual report serial number
    //******************************************************************************************************* */
    async getFrepSrNo(str_first_calibration) {
        // str_first_calibration : - is the first calibration in the process

        switch (str_first_calibration) {
            case 'P':
                var str_FailedTable = 'tbl_calibration_periodic_master_failed'; // tableName
                var strRepNoColName = 'Periodic_RepNo'; //column name
                var fRerSrNo = await this.calculateFrepSr(str_FailedTable, strRepNoColName)// function call
                return fRerSrNo // returning promise

            case 'U':
                var str_FailedTable = 'tbl_calibration_uncertinity_master_failed'; // tableName
                var strRepNoColName = 'Uncertinity_RepNo'; //column name
                var fRerSrNo = await this.calculateFrepSr(str_FailedTable, strRepNoColName)// function call
                return fRerSrNo // returning promise
            case 'R':
                var str_FailedTable = 'tbl_calibration_repetability_master_failed'; // tableName
                var strRepNoColName = 'Repet_RepNo'; //column name
                var fRerSrNo = await this.calculateFrepSr(str_FailedTable, strRepNoColName)// function call
                return fRerSrNo // returning promise
            case 'E':
                var str_FailedTable = 'tbl_calibration_eccentricity_master_failed'; // tableName
                var strRepNoColName = 'Eccent_RepNo'; //column name
                var fRerSrNo = await this.calculateFrepSr(str_FailedTable, strRepNoColName)// function call
                return fRerSrNo // returning promise
            case 'L':
                var str_FailedTable = 'tbl_calibration_linearity_master_failed'; // tableName
                var strRepNoColName = 'Linear_RepNo'; //column name
                var fRerSrNo = await this.calculateFrepSr(str_FailedTable, strRepNoColName)// function call
                return fRerSrNo // returning promise
            case 'V':
                var str_FailedTable = 'tbl_calibration_positional_master_failed';
                var strRepNoColName = 'Positional_RepNo'; //column name
                var fRerSrNo = await this.calculateFrepSr(str_FailedTable, strRepNoColName)// function call
                return fRerSrNo // returning promise
        }

    }

    //****************************************************************************************************** */
    // Below function calculates failed report serial number as FrepSrNo
    //****************************************************************************************************** */
    async calculateFrepSr(str_FailedTable, strRepNoColName) {

        // let res = await models[str_FailedTable].max(strRepNoColName)
        let result = await models[str_FailedTable].findAll({
            attributes: [[sequelize.fn('max', sequelize.col(strRepNoColName)), 'FRepSrNo']]
        })



        // const selectObj = {
        //     str_tableName: str_FailedTable,
        //     data: `MAX(${strRepNoColName}) AS FRepSrNo`
        // }
        // let result = database.select(selectObj)
        var FrepSrNo;
        // If entries not present
        if (result[0].FRepSrNo == null) {
            FrepSrNo = 1;
        } else {
            // If there are some records
            FrepSrNo = result[0].FRepSrNo + 1;
        }
        return FrepSrNo

    }

    //****************************************************************************************** */
    // Below function updates the status to 0 -> 1 for that particular Caibration in 
    // calibration_status table
    //****************************************************************************************** */  
    async updateCalibStatus(columName, strBalId, balType) {
        try {
            if (balType == 'analytical') {
                var calibTable = 'tbl_calibration_status';
            } else {
                var calibTable = 'tbl_calibration_status_bin';
            }

            await models[calibTable].update({
                [`${columName}`]: 1
            }, {
                where: {
                    "BalID": strBalId
                }
            })


        } catch (error) {
            console.error(`Reject Promise while updating the calibration status for${columName, strBalId}`)
            throw new Error(error)
        }
    }

    async UpdateRecalibFLagPeriodic(strBalId, balType, calibMode) {
        try {

            if (balType == 'analytical') {
                var recalliTable = `tbl_recalibration_balance_status`;
            } else {
                var recalliTable = `tbl_recalibration_balance_status_bin`;
            }

            let column = calibMode == "yearly" ? "YearBalRecalib" : "PeriodicBalRecalib";
            // Need to ask
            await models[recalliTable].update({
                [`${column}`]: 0,
                "RecalibSetDt_periodic": null
            }, {
                where: {
                    "Bal_ID": strBalId
                }
            });

            //set new Balance to false
            await models.tbl_balance.update({
                "IsNewBalance": 0
            }, {
                where: {
                    "Bal_ID": strBalId
                }
            });

            return 0;
        } catch (err) {
            throw new Error(err);
        }
    }

    //****************************************************************************************************** */
    // Below function copies data from incomplete tables to complete tables after successfull calibration 
    // of all types
    //****************************************************************************************************** */
    async incompleteToComplete(CalibrationType, strBalId, balType, calibMoveFlag) {
        try {

            let calibTypeInGlbArr = globalData.arrCommonUsage.find(k => k.BalId == strBalId);
            let calibType = calibTypeInGlbArr.calibType;
            let isNewBal = calibTypeInGlbArr.isNewBal;
            // CalibrationType - OnGoing caaibration type i-e P, R, L .....
            var res = await obj_getRepSrNo.getRepSrNoWRTBalance(strBalId, balType);
            // report serial number which same for all calibration recived from 'calibration status'
            var intRepSrNo = res[0].RepNo;
            var arr_sortedCalibArray = await sort.sortedSeqArray(globalData.arrSortedCalib, strBalId, balType);
            // we are finding length of sorted array that we have 
            let length = arr_sortedCalibArray.length;
            // here we finding last calibration
            let lastCalibration = arr_sortedCalibArray[length - 1];
            // If current calibration is last calibration then we can proceed for copying
            //data from incomplete to complete tabled
            if (CalibrationType == lastCalibration || calibMoveFlag) {
                // let balCalDetPeri = globalData.arrBalCaibDet.find(k => k.strBalId == strBalId);
                // balCalDetPeri.isPeriodicDone = true;
                console.log('copying starts for complete....')
                //  arr_sortedCalibArray.forEach((v) => {  //Async for loop

                //here as according to monthly or yearly we have to loop


                // let monthlyseqArr = jsonConfig.CalibSequence.monthly
                // let yearlyseqArr = jsonConfig.CalibSequence.yearly;
                // arr_sortedCalibArray = monthlyseqArr
                for (let v of arr_sortedCalibArray) {
                    switch (v) {
                        // V holds value like P,L,E.....
                        // case periodic calibration
                        case 'P':



                            // Copy Incomplete to complete for master
                            await database.copy2('tbl_calibration_periodic_master_incomplete'
                                , 'tbl_calibration_periodic_master', 'Periodic_RepNo', intRepSrNo);  //copied..
                            // Copy Incomplete to complete for detail
                            await database.copy2('tbl_calibration_periodic_detail_incomplete'
                                , 'tbl_calibration_periodic_detail', 'Periodic_RepNo', intRepSrNo)//copied..
                            // deleting entries from incomplete table




                            await models.tbl_calibration_periodic_master_incomplete.destroy({
                                where: {
                                    "Periodic_RepNo": intRepSrNo
                                }
                            })
                            await models.tbl_calibration_periodic_detail_incomplete.destroy({
                                where: {
                                    "Periodic_RepNo": intRepSrNo
                                }
                            })
                            console.log('PERIODIC COPIED..');

                            break;
                        // case Uncertinity calibration
                        case 'U':

                            // Copy Incomplete to complete for master
                            await database.copy2('tbl_calibration_uncertinity_master_incomplete'
                                , 'tbl_calibration_uncertinity_master', 'Uncertinity_RepNo', intRepSrNo); //copied..
                            // Copy Incomplete to complete for detail
                            await database.copy2('tbl_calibration_uncertinity_detail_incomplete'
                                , 'tbl_calibration_uncertinity_detail', 'Uncertinity_RepNo', intRepSrNo); //copied..
                            // deleting entries from incomplete table

                            await models.tbl_calibration_uncertinity_master_incomplete.destroy({
                                where: {
                                    "Uncertinity_RepNo": intRepSrNo
                                }
                            })
                            await models.tbl_calibration_uncertinity_detail_incomplete.destroy({
                                where: {
                                    "Uncertinity_RepNo": intRepSrNo
                                }
                            })
                            console.log('UNCERTINITY COPIED..')

                            break;
                        // case Repetabilty calibration
                        case 'R':
                            // Copy Incomplete to complete for master

                            await database.copy2('tbl_calibration_repetability_master_incomplete'
                                , 'tbl_calibration_repetability_master', 'Repet_RepNo', intRepSrNo); //copied..
                            // Copy Incomplete to complete for detail
                            await database.copy2('tbl_calibration_repetability_detail_incomplete'
                                , 'tbl_calibration_repetability_detail', 'Repet_RepNo', intRepSrNo);//copied..
                            // deleting entries from incomplete table


                            await models.tbl_calibration_repetability_master_incomplete.destroy({
                                where: {
                                    "Repet_RepNo": intRepSrNo
                                }
                            })
                            await models.tbl_calibration_repetability_detail_incomplete.destroy({
                                where: {
                                    "Repet_RepNo": intRepSrNo
                                }
                            })

                            console.log('REPETABILITY COPIED..')

                            break;
                        // case Eccentricity calibration
                        case 'E':

                            // Copy Incomplete to complete for master
                            await database.copy2('tbl_calibration_eccentricity_master_incomplete'
                                , 'tbl_calibration_eccentricity_master', 'Eccent_RepNo', intRepSrNo);//copied..
                            // Copy Incomplete to complete for detail
                            await database.copy2('tbl_calibration_eccentricity_detail_incomplete'
                                , 'tbl_calibration_eccentricity_detail', 'Eccent_RepNo', intRepSrNo);//copied..
                            // deleting entries from incomplete table



                            await models.tbl_calibration_eccentricity_master_incomplete.destroy({
                                where: {
                                    "Eccent_RepNo": intRepSrNo
                                }
                            })
                            await models.tbl_calibration_eccentricity_detail_incomplete.destroy({
                                where: {
                                    "Eccent_RepNo": intRepSrNo
                                }
                            })


                            console.log('ECCENTRICITY COPIED..')

                            break;

                        // case Linearity calibration
                        case 'L':

                            // Copy Incomplete to complete for master
                            await database.copy2('tbl_calibration_linearity_master_incomplete'
                                , 'tbl_calibration_linearity_master', 'Linear_RepNo', intRepSrNo) //copied..
                            // Copy Incomplete to complete for detail
                            await database.copy2('tbl_calibration_linearity_detail_incomplete'
                                , 'tbl_calibration_linearity_detail', 'Linear_RepNo', intRepSrNo); //copied..
                            // deleting entries from incomplete table


                            await models.tbl_calibration_linearity_master_incomplete.destroy({
                                where: {
                                    "Linear_RepNo": intRepSrNo
                                }
                            })
                            await models.tbl_calibration_linearity_detail_incomplete.destroy({
                                where: {
                                    "Linear_RepNo": intRepSrNo
                                }
                            })

                            console.log('LINEARITY COPIED..')

                            break;
                    }
                }
                // Updating Our golbal array that all calibration is completed with complete status

                if (isNewBal) {

                    if (lastCalibration == CalibrationType) {
                        await models.tbl_calibration_status.update({
                            'P': 0,
                            'E': 0,
                            'R': 0,
                            'U': 0,
                            'L': 0
                        }, {
                            where: {
                                'BalID': strBalId
                            }
                        })

                        for (var i in globalData.calibrationStatus) {
                            if (globalData.calibrationStatus[i].BalId == strBalId) {
                                globalData.calibrationStatus[i].status['P'] = 0;
                                globalData.calibrationStatus[i].status['E'] = 0;
                                globalData.calibrationStatus[i].status['R'] = 0;
                                globalData.calibrationStatus[i].status['U'] = 0;
                                globalData.calibrationStatus[i].status['L'] = 0;
                                break; //Stop this loop, we found it!
                            }
                        }
                    }
                } else {
                    for (var i in globalData.calibrationStatus) {
                        if (globalData.calibrationStatus[i].BalId == strBalId) {
                            globalData.calibrationStatus[i].status['P'] = 0;
                            globalData.calibrationStatus[i].status['E'] = 0;
                            globalData.calibrationStatus[i].status['R'] = 0;
                            globalData.calibrationStatus[i].status['U'] = 0;
                            globalData.calibrationStatus[i].status['L'] = 0;
                            break; //Stop this loop, we found it!
                        }
                    }
                    // Updating table 'calibration_status' that all calibration is completed with complete status
                    var table;
                    var BalanceRecalibStatusObject
                    if (balType == 'IPC Balance') {
                        table = "tbl_calibration_status_bin",
                            BalanceRecalibStatusObject = globalData.arrBalanceRecalibStatusIPC.find(k => k.Bal_ID == strBalId);
                    } else {
                        table = "tbl_calibration_status",
                            BalanceRecalibStatusObject = globalData.arrBalanceRecalibStatus.find(k => k.Bal_ID == strBalId);
                    }

                    await models[table].update({
                        'P': 0,
                        'E': 0,
                        'R': 0,
                        'U': 0,
                        'L': 0
                    }, {
                        where: {
                            'BalID': strBalId
                        }
                    })
                }

                var table;
                var BalanceRecalibStatusObject
                if (balType == 'IPC Balance') {
                    table = "tbl_calibration_status_bin",
                        BalanceRecalibStatusObject = globalData.arrBalanceRecalibStatusIPC.find(k => k.Bal_ID == strBalId);
                } else {
                    table = "tbl_calibration_status",
                        BalanceRecalibStatusObject = globalData.arrBalanceRecalibStatus.find(k => k.Bal_ID == strBalId);
                }
                await models[table].update({
                    'P': 0,
                    'E': 0,
                    'R': 0,
                    'U': 0,
                    'L': 0
                }, {
                    where: {
                        'BalID': strBalId
                    }
                })
                var res1 = await models.tbl_balance.findAll({
                    where: {
                        'Bal_ID': strBalId
                    }
                });
                var normalDate = ''
                if (res1[0].Bal_ChangeWt == 1) {
                    await models.tbl_balance.update({
                        Bal_ChangeWt: 0
                    }, {
                        where: { 'Bal_ID': strBalId }
                    });
                }
                if (BalanceRecalibStatusObject != undefined) {
                    if (lastCalibration == "P" && BalanceRecalibStatusObject.PeriodicBalRecalib == 1) {
                        var res1 = await models.tbl_balance.findAll({
                            where: {
                                'Bal_ID': strBalId
                            }
                        });
                        //dateInUTC 
                        if (res1[0].Bal_CalbStoreType == 1) {
                            let days = res1[0].Bal_CalbDuration;
                            let monthlyDueDate = res1[0].Bal_CalbDueDt;
                            let yearlyDueDt = res1[0].Bal_CalbDueDtYear;
                            var date = new Date();
                            //var dateInUTC = new Date(date.setDate(date.getMonth() + 2));
                            // var dateInUTC = new Date(new Date().setMonth(new Date().getMonth() + (days)))
                            // var dateInUTC = new Date(new Date(monthlyDueDate).setMonth(new Date(monthlyDueDate).getMonth() + (days)))


                            normalDate = monthlyDueDate
                            // var month = moment().format("YYYY-MM-DD").split('-')[1]
                            // var newDate = moment().format("YYYY-MM-DD")
                            // var dateInUTC = moment()
                            // // var LastDate = moment(dateInUTC).format("YYYY-MM-DD").split('-')[0]
                            // // if(newDate != LastDate){

                            // dateInUTC = dateInUTC.set({ 'year': newDate, 'date': Datess })

                            // dateInUTC = moment().add(days, 'days')
                            // var normalDate = normaDate.convertDate(dateInUTC);
                            // normalDate = normaDate.convertDate(dateInUTC);
                        } else {
                            var arr = res1[0].Bal_CalbDates.split(',');
                            var today = new Date();
                            var todayDate = moment().format('YYYY-MM-DD');
                            var month = today.getMonth() + 1;
                            month = ("0" + month).slice(-2);
                            var year = today.getFullYear();
                            var arr_calibdates = []
                            for (let d of arr) {
                                var day = ("0" + d).slice(-2)
                                var date = '';
                                date = year + '-' + month + '-' + day;
                                arr_calibdates.push(date);
                            }
                            var lastCalibDate
                            // = await this.checkIfLatestEntryResBal(strBalId);
                            // if(lastCalibDate.length == 0){
                            let now = new Date();
                            lastCalibDate = moment(now).format('YYYY-MM-DD');
                            // }
                            lastCalibDate = moment(lastCalibDate).format('YYYY-MM-DD')
                            console.log(arr_calibdates);
                            normalDate = "";
                            // for (const [i, ddmmyy] of arr_calibdates.entries()) {
                            //     if (lastCalibDate < ddmmyy) {
                            //         normalDate = arr_calibdates[i];
                            //         break;
                            //     } else if (lastCalibDate == ddmmyy) {
                            //         normalDate = arr_calibdates[i + 1];
                            //         break;
                            //     }
                            // }
                            for (let index = 0; index < arr_calibdates.length; index++) {
                                if (lastCalibDate < arr_calibdates[index]) {
                                    normalDate = arr_calibdates[index];
                                    break;
                                } else if (lastCalibDate == arr_calibdates[index]) {
                                    if (arr_calibdates.length - 1 < index + 1) {
                                        normalDate = "";
                                    } else {
                                        normalDate = arr_calibdates[index + 1];
                                    }
                                    break;
                                }

                            }
                            if (normalDate == "") {
                                var day = ("0" + arr[0]).slice(-2)
                                var date = '';
                                var todaysmonth = today.getMonth() + 1;
                                var month = today.getMonth() + 2;

                                month = ("0" + month).slice(-2);
                                if (todaysmonth == 12) {
                                    month = "01";
                                    year = year + 1;
                                }
                                date = year + '-' + month + '-' + day;
                                normalDate = date;
                            }
                        }


                        // }
                        let maxRecord = await this.getMaxRecord("tbl_calibration_periodic_master",
                            "Periodic_RepNo",
                            "Periodic_BalID",
                            strBalId);

                        await this.updateNextDueDate("tbl_calibration_periodic_master",
                            maxRecord,
                            normalDate,
                            "Periodic_DueDate",
                            "Periodic_RepNo")
                        return 'ok';
                        return 'ok';
                    }
                }
                // console.log('as', globalData.calibrationStatus)

                /* Updating the calibration Duedates in tbl_balance after succesfull data copying if store
           type is 1 i-e set_days
           */

                // -----Start-----
                // if (BalanceRecalibStatusObject.PeriodicBalRecalib == 1 || BalanceRecalibStatusObject.YearBalRecalib == 1) {
                //     return 'ok';
                // } else {

                if (res1[0].Bal_CalbStoreType == 1) {
                    let days = res1[0].Bal_CalbDuration;
                    let monthlyDueDate = res1[0].Bal_CalbDueDt;
                    let yearlyDueDt = res1[0].Bal_CalbDueDtYear;
                    var date = new Date();
                    //var dateInUTC = new Date(date.setDate(date.getMonth() + 2));
                    // var dateInUTC = new Date(new Date().setMonth(new Date().getMonth() + (days)))
                    // var dateInUTC = new Date(new Date(monthlyDueDate).setMonth(new Date(monthlyDueDate).getMonth() + (days)))


                    var Datess = monthlyDueDate.split('-')[2]
                    // var month = moment().format("YYYY-MM-DD").split('-')[1]
                    var newDate = moment().format("YYYY-MM-DD").split('-')[0]
                    var dateInUTC = moment()
                    // var LastDate = moment(dateInUTC).format("YYYY-MM-DD").split('-')[0]
                    // if(newDate != LastDate){

                    dateInUTC = dateInUTC.set({ 'year': newDate, 'date': Datess })

                    dateInUTC = moment().add(days, 'days')
                    var normalDate = normaDate.convertDate(dateInUTC);
                    normalDate = normaDate.convertDate(dateInUTC);

                } else {
                    var arr = res1[0].Bal_CalbDates.split(',');
                    var today = new Date();
                    var todayDate = moment().format('YYYY-MM-DD');
                    var month = today.getMonth() + 1;
                    month = ("0" + month).slice(-2);
                    var year = today.getFullYear();
                    var arr_calibdates = []
                    for (let d of arr) {
                        var day = ("0" + d).slice(-2)
                        var date = '';
                        date = year + '-' + month + '-' + day;
                        arr_calibdates.push(date);
                    }
                    var lastCalibDate
                    // = await this.checkIfLatestEntryResBal(strBalId);
                    // if(lastCalibDate.length == 0){
                    let now = new Date();
                    lastCalibDate = moment(now).format('YYYY-MM-DD');
                    // }
                    lastCalibDate = moment(lastCalibDate).format('YYYY-MM-DD')
                    console.log(arr_calibdates);
                    normalDate = "";
                    // for (const [i, ddmmyy] of arr_calibdates.entries()) {
                    //     if (lastCalibDate < ddmmyy) {
                    //         normalDate = arr_calibdates[i];
                    //         break;
                    //     } else if (lastCalibDate == ddmmyy) {
                    //         normalDate = arr_calibdates[i + 1];
                    //         break;
                    //     }
                    // }
                    for (let index = 0; index < arr_calibdates.length; index++) {
                        if (lastCalibDate < arr_calibdates[index]) {
                            normalDate = arr_calibdates[index];
                            break;
                        } else if (lastCalibDate == arr_calibdates[index]) {
                            if (arr_calibdates.length - 1 < index + 1) {
                                normalDate = "";
                            } else {
                                normalDate = arr_calibdates[index + 1];
                            }
                            break;
                        }

                    }
                    if (normalDate == "") {
                        var day = ("0" + arr[0]).slice(-2)
                        var date = '';
                        var todaysmonth = today.getMonth() + 1;
                        var month = today.getMonth() + 2;

                        month = ("0" + month).slice(-2);
                        if (todaysmonth == 12) {
                            month = "01";
                            year = year + 1;
                        }
                        date = year + '-' + month + '-' + day;
                        normalDate = date;
                    }
                }
                if (isNewBal) {

                    //update only day in yeatly calib
                    var res1 = await models.tbl_balance.findAll({
                        where: {
                            'Bal_ID': strBalId
                        }
                    });
                    //dateInUTC 
                    if (res1[0].Bal_CalbStoreType == 1) {
                        let days = res1[0].Bal_CalbDuration;
                        let monthlyDueDate = res1[0].Bal_CalbDueDt;
                        let yearlyDueDt = res1[0].Bal_CalbDueDtYear;
                        var date = new Date();
                        //var dateInUTC = new Date(date.setDate(date.getMonth() + 2));
                        // var dateInUTC = new Date(new Date().setMonth(new Date().getMonth() + (days)))
                        // var dateInUTC = new Date(new Date(monthlyDueDate).setMonth(new Date(monthlyDueDate).getMonth() + (days)))

                        if (monthlyDueDate <= moment().format('YYYY-MM-DD')) {
                            var Datess = monthlyDueDate.split('-')[2]
                            var month = moment().format("YYYY-MM-DD").split('-')[1]
                            var newDate = moment().format("YYYY-MM-DD").split('-')[0]
                            var dateInUTC = moment()
                            // var LastDate = moment(dateInUTC).format("YYYY-MM-DD").split('-')[0]
                            // if(newDate != LastDate){

                            dateInUTC = dateInUTC.set({ 'year': newDate, 'month': month - 1, 'date': Datess })
                            monthlyDueDate = normaDate.convertDate(dateInUTC);

                            if (monthlyDueDate <= moment().format('YYYY-MM-DD')) {
                                dateInUTC = moment().add(days, 'days')
                                monthlyDueDate = normaDate.convertDate(dateInUTC);
                            }
                            // var normalDate = normaDate.convertDate(dateInUTC);
                            // monthlyDueDate = normaDate.convertDate(dateInUTC);
                            normalDate = monthlyDueDate
                        } else {
                            normalDate = monthlyDueDate
                        }


                        // var month = moment().format("YYYY-MM-DD").split('-')[1]
                        // var newDate = moment().format("YYYY-MM-DD")
                        // var dateInUTC = moment()
                        // // var LastDate = moment(dateInUTC).format("YYYY-MM-DD").split('-')[0]
                        // // if(newDate != LastDate){

                        // dateInUTC = dateInUTC.set({ 'year': newDate, 'date': Datess })

                        // dateInUTC = moment().add(days, 'days')
                        // var normalDate = normaDate.convertDate(dateInUTC);
                        // normalDate = normaDate.convertDate(dateInUTC);

                    } else {
                        var arr = res1[0].Bal_CalbDates.split(',');
                        var today = new Date();
                        var todayDate = moment().format('YYYY-MM-DD');
                        var month = today.getMonth() + 1;
                        month = ("0" + month).slice(-2);
                        var year = today.getFullYear();
                        var arr_calibdates = []
                        for (let d of arr) {
                            var day = ("0" + d).slice(-2)
                            var date = '';
                            date = year + '-' + month + '-' + day;
                            arr_calibdates.push(date);
                        }
                        var lastCalibDate
                        // = await this.checkIfLatestEntryResBal(strBalId);
                        // if(lastCalibDate.length == 0){
                        let now = new Date();
                        lastCalibDate = moment(now).format('YYYY-MM-DD');
                        // }
                        lastCalibDate = moment(lastCalibDate).format('YYYY-MM-DD')
                        console.log(arr_calibdates);
                        normalDate = "";
                        // for (const [i, ddmmyy] of arr_calibdates.entries()) {
                        //     if (lastCalibDate < ddmmyy) {
                        //         normalDate = arr_calibdates[i];
                        //         break;
                        //     } else if (lastCalibDate == ddmmyy) {
                        //         normalDate = arr_calibdates[i + 1];
                        //         break;
                        //     }
                        // }
                        for (let index = 0; index < arr_calibdates.length; index++) {
                            if (lastCalibDate < arr_calibdates[index]) {
                                normalDate = arr_calibdates[index];
                                break;
                            } else if (lastCalibDate == arr_calibdates[index]) {
                                if (arr_calibdates.length - 1 < index + 1) {
                                    normalDate = "";
                                } else {
                                    normalDate = arr_calibdates[index + 1];
                                }
                                break;
                            }

                        }
                        if (normalDate == "") {
                            var day = ("0" + arr[0]).slice(-2)
                            var date = '';
                            var todaysmonth = today.getMonth() + 1;
                            var month = today.getMonth() + 2;

                            month = ("0" + month).slice(-2);
                            if (todaysmonth == 12) {
                                month = "01";
                                year = year + 1;
                            }
                            date = year + '-' + month + '-' + day;
                            normalDate = date;
                        }
                    }

                    // }
                    var updateBalDueDates = await models.tbl_balance.update({
                        'IsNewBalance': 0,
                        'Bal_CalbDueDt': normalDate,
                        'Bal_CalbDueDtL': normalDate,
                        'Bal_CalbDueDtU': normalDate,
                        'Bal_CalbDueDtR': normalDate,
                        'Bal_CalbDueDtE': normalDate
                    },
                        {
                            where: {
                                'Bal_ID': strBalId,
                            }
                        })
                    let maxRecord = await this.getMaxRecord("tbl_calibration_periodic_master",
                        "Periodic_RepNo",
                        "Periodic_BalID",
                        strBalId);

                    await this.updateNextDueDate("tbl_calibration_periodic_master",
                        maxRecord,
                        normalDate,
                        "Periodic_DueDate",
                        "Periodic_RepNo")
                    // -----end-----
                    return 'ok'
                }


                // adding days to current date

                //change this logic to update acc to due dt fro monthly and specific 
                // let calibType = "yearly"
                let calibTypeInGlbArr = globalData.arrCommonUsage.find(k => k.BalId == strBalId);
                let calibType = calibTypeInGlbArr.calibType;
                let isperiodic = calibTypeInGlbArr.isPeriodic;

                if (BalanceRecalibStatusObject.PeriodicBalRecalib == 1) {
                    var res1 = await models.tbl_balance.findAll({
                        where: {
                            'Bal_ID': strBalId
                        }
                    });
                    //dateInUTC 
                    if (res1[0].Bal_CalbStoreType == 1) {
                        let days = res1[0].Bal_CalbDuration;
                        let monthlyDueDate = res1[0].Bal_CalbDueDt;
                        let yearlyDueDt = res1[0].Bal_CalbDueDtYear;
                        var date = new Date();
                        //var dateInUTC = new Date(date.setDate(date.getMonth() + 2));
                        // var dateInUTC = new Date(new Date().setMonth(new Date().getMonth() + (days)))
                        // var dateInUTC = new Date(new Date(monthlyDueDate).setMonth(new Date(monthlyDueDate).getMonth() + (days)))


                        normalDate = monthlyDueDate
                        // var month = moment().format("YYYY-MM-DD").split('-')[1]
                        // var newDate = moment().format("YYYY-MM-DD")
                        // var dateInUTC = moment()
                        // // var LastDate = moment(dateInUTC).format("YYYY-MM-DD").split('-')[0]
                        // // if(newDate != LastDate){

                        // dateInUTC = dateInUTC.set({ 'year': newDate, 'date': Datess })

                        // dateInUTC = moment().add(days, 'days')
                        // var normalDate = normaDate.convertDate(dateInUTC);
                        // normalDate = normaDate.convertDate(dateInUTC);

                    } else {
                        var arr = res1[0].Bal_CalbDates.split(',');
                        var today = new Date();
                        var todayDate = moment().format('YYYY-MM-DD');
                        var month = today.getMonth() + 1;
                        month = ("0" + month).slice(-2);
                        var year = today.getFullYear();
                        var arr_calibdates = []
                        for (let d of arr) {
                            var day = ("0" + d).slice(-2)
                            var date = '';
                            date = year + '-' + month + '-' + day;
                            arr_calibdates.push(date);
                        }
                        var lastCalibDate
                        // = await this.checkIfLatestEntryResBal(strBalId);
                        // if(lastCalibDate.length == 0){
                        let now = new Date();
                        lastCalibDate = moment(now).format('YYYY-MM-DD');
                        // }
                        lastCalibDate = moment(lastCalibDate).format('YYYY-MM-DD')
                        console.log(arr_calibdates);
                        normalDate = "";
                        // for (const [i, ddmmyy] of arr_calibdates.entries()) {
                        //     if (lastCalibDate < ddmmyy) {
                        //         normalDate = arr_calibdates[i];
                        //         break;
                        //     } else if (lastCalibDate == ddmmyy) {
                        //         normalDate = arr_calibdates[i + 1];
                        //         break;
                        //     }
                        // }
                        for (let index = 0; index < arr_calibdates.length; index++) {
                            if (lastCalibDate < arr_calibdates[index]) {
                                normalDate = arr_calibdates[index];
                                break;
                            } else if (lastCalibDate == arr_calibdates[index]) {
                                if (arr_calibdates.length - 1 < index + 1) {
                                    normalDate = "";
                                } else {
                                    normalDate = arr_calibdates[index + 1];
                                }
                                break;
                            }

                        }
                        if (normalDate == "") {
                            var day = ("0" + arr[0]).slice(-2)
                            var date = '';
                            var todaysmonth = today.getMonth() + 1;
                            var month = today.getMonth() + 2;

                            month = ("0" + month).slice(-2);
                            if (todaysmonth == 12) {
                                month = "01";
                                year = year + 1;
                            }
                            date = year + '-' + month + '-' + day;
                            normalDate = date;
                        }
                    }


                    // }
                    let maxRecord = await this.getMaxRecord("tbl_calibration_periodic_master",
                        "Periodic_RepNo",
                        "Periodic_BalID",
                        strBalId);

                    await this.updateNextDueDate("tbl_calibration_periodic_master",
                        maxRecord,
                        normalDate,
                        "Periodic_DueDate",
                        "Periodic_RepNo")
                    return 'ok';
                } else {
                    var selectBalsetDays = await models.tbl_balance.findAll({
                        where: {
                            'Bal_ID': strBalId,
                        }
                    })

                    // let days = selectBalsetDays[0].Bal_CalbDuration;
                    // var date = new Date();
                    // // adding days to current date
                    // var dateInUTC = new Date(date.setDate(date.getDate() + days));
                    // var normalDate = await normaDate.convertDate(dateInUTC);
                    var updateBalDueDates = await models.tbl_balance.update({
                        'IsNewBalance': 0,
                        'Bal_CalbDueDt': normalDate,
                        'Bal_CalbDueDtL': normalDate,
                        'Bal_CalbDueDtU': normalDate,
                        'Bal_CalbDueDtR': normalDate,
                        'Bal_CalbDueDtE': normalDate
                    },
                        {
                            where: {
                                'Bal_ID': strBalId,
                            }
                        })
                    let maxRecord = await this.getMaxRecord("tbl_calibration_periodic_master",
                        "Periodic_RepNo",
                        "Periodic_BalID",
                        strBalId);

                    await this.updateNextDueDate("tbl_calibration_periodic_master",
                        maxRecord,
                        normalDate,
                        "Periodic_DueDate",
                        "Periodic_RepNo")

                    // -----end-----
                    return 'ok'
                }


                // -----end-----
                return 'ok'

            } else {
                return 'ok';
            }
        } catch (err) {
            throw new Error(err);
        }
    }

    async releaseCalibrationInProcess(cubicalNo) {
        try {
            await models.tbl_cubical.update({
                Sys_CalibInProcess: 0
            }, {
                where: {
                    Sys_CubicNo: cubicalNo
                }
            })

        } catch (error) {
            console.log(error)
            throw new Error(error)
        }
    }


    async getMaxRecord(tableName, repNoCol, balIdCol, strBalid) {
        try {
            const maxData = await models[tableName].findAll({
                attributes: [[sequelize.fn('max', sequelize.col(repNoCol)), 'RepNo']],
                where: {
                    [`${balIdCol}`]: strBalid
                }
            });

            return maxData

        } catch (error) {
            console.log(error);
        }
    }

    async updateNextDueDate(tableName, maxData, date, strDateCol, strRepNo) {
        try {

            const maxId = maxData[0].RepNo;
            await models[tableName].update({
                [`${strDateCol}`]: date
            }
                , {
                    where: {
                        [`${strRepNo}`]: maxId
                    }
                });

        } catch (error) {
            console.log(error);
        }
    }

    async resetCalib(strBalId) {
        try {
            var result = await models.tbl_calibration_status.findOne({
                where: {
                    'BalID': strBalId
                }
            });
            result = result
            // let calibrationStatus = [];
            const tempObj = {
                P: result.P,
                E: result.E,
                R: result.R,
                U: result.U,
                L: result.L,
                V: result.V
            }
            let statusEqualToOne = Object.keys(tempObj).filter(k => tempObj[k] == 1);
            if (statusEqualToOne.length > 0) {
                //check date in their respective table inompMaster
                let tableName, maxRepNo, balId, calbDate, calibAlphabet, calibType;
                var lastCalib = statusEqualToOne.pop();

                switch (lastCalib) {
                    case 'P': {
                        tableName = 'tbl_calibration_periodic_master_incomplete'
                        maxRepNo = 'Periodic_RepNo'
                        balId = 'Periodic_BalID'
                        calbDate = 'Periodic_CalbDate'
                        calibAlphabet = "P"
                        calibType = "Monthly"
                    }
                        break;
                    case 'E': {
                        tableName = 'tbl_calibration_eccentricity_master_incomplete'
                        maxRepNo = 'Eccent_RepNo'
                        balId = 'Eccent_BalID'
                        calbDate = 'Eccent_CalbDate'
                        calibAlphabet = "E"
                        calibType = "Monthly"
                    }
                        break;
                    case 'R': {
                        tableName = 'tbl_calibration_repetability_master_incomplete'
                        maxRepNo = 'Repet_RepNo'
                        balId = 'Repet_BalID'
                        calbDate = 'Repet_CalbDate'
                        calibAlphabet = "R"
                        calibType = "Monthly"
                    }
                        break;
                    case 'U': {
                        tableName = 'tbl_calibration_uncertinity_master_incomplete'
                        maxRepNo = 'Uncertinity_RepNo'
                        balId = 'Uncertinity_BalID'
                        calbDate = 'Uncertinity_CalbDate'
                        calibAlphabet = "U"
                        calibType = "Monthly"
                    }
                        break;
                    case 'L': {
                        tableName = 'tbl_calibration_linearity_master_incomplete'
                        maxRepNo = 'Linear_RepNo'
                        balId = 'Linear_BalID'
                        calbDate = 'Linear_CalbDate'
                        calibAlphabet = "L"
                        calibType = "Monthly"
                    }
                        break;
                }

                let maxRepSerNo = await models[tableName].findAll({
                    attributes: [[sequelize.fn('max', sequelize.col(`${[maxRepNo]}`)), "SrNo"]],
                    where: {
                        [balId]: strBalId
                    }

                })
                let result = await models[tableName].findAll({
                    where: {
                        [maxRepNo]: maxRepSerNo[0].SrNo
                    }

                })

                // let dateOnWhichCalibWasDone = result[0].Periodic_CalbDate;
                let dateOnWhichCalibWasDone = result[0][calbDate];
                if (!(dateOnWhichCalibWasDone == moment().format('YYYY-MM-DD'))) {
                    //update calib 

                    //call fail function and move from incomplete to fail


                    let resp = await models.tbl_balance.findOne({
                        where: {
                            Bal_ID: strBalId
                        }
                    });

                    let isNewBal = resp.IsNewBalance;


                    // let isNewBal = globalData.arrCommonUsage.find(k=>k.BalId == strBalId).isNewBal;

                    //new bal then handle status 0
                    // isNewBal.readUIntLE()
                    if (isNewBal) {
                        await this.caibrationFails(calibAlphabet, maxRepSerNo[0].SrNo, strBalId, calibType, true)
                    } else {
                        await this.caibrationFails(calibAlphabet, maxRepSerNo[0].SrNo, strBalId, calibType, true)
                    }

                    console.log(result)
                }
            }
            result = await models.tbl_calibration_status.findOne({
                where: {
                    'BalID': strBalId
                }
            });
            tempObj.P = result.P;
            tempObj.E = result.E;
            tempObj.R = result.R;
            tempObj.U = result.U;
            tempObj.L = result.L;
            tempObj.V = result.V;

            var objFound = globalData.calibrationStatus.find(k => k.BalId == strBalId);
            if (objFound == undefined) {
                globalData.calibrationStatus.push({ BalId: strBalId, status: tempObj });
            } else {
                objFound.BalId = strBalId;
                objFound.status = tempObj;
                //hmi or  resbppi
            }

            // calibrationStatus.push({ BalId: strBalId, status: tempObj });
            return 0;
        } catch (error) {
            console.log(error)
        }
    }

    async caibrationFails_differ(CalibrationType, RepNo, strBalId, calibType, deleteEntry = false, balType) {
        try {
            // CalibrationType is like 'P', 'R', 'E', 'U'..etc
            // strBalId holds the balance associated with that cubicle
            // RepNo holds the report sr no of incomplete tables
            var tempCaibStatus = globalData.calibrationStatus.find(k => k.BalId == strBalId);
            // getting position of current caibration in sorted array of calibrations
            let sortedArray = await sort.sortedSeqArray(globalData.arrSortedCalib, strBalId, balType); //globalData.arrSortedCalib tbl_calibration_sequnce
            var int_curentCalibrationIndex = sortedArray.indexOf(CalibrationType);
            // calculating first caalibration
            // var str_first_calibration = sortedArray[0];
            //var str_first_calibration = CalibrationType;
            if (calibType == "Monthly") {
                var str_first_calibration = "P"
            } else if (calibType == "Monthly") {
                var str_first_calibration = "P"
            }
            var fRerSrNo = await this.getFrepSrNo(str_first_calibration);
            // fRerSrNo is failed repSrNo which will insert in all failed tables
            var arr_CalibArray = []; // array holds calibration which done and one which failed
            for (let i = 0; i < int_curentCalibrationIndex + 1; i++) {
                arr_CalibArray.push(sortedArray[i])
            }
            // console.log('arr_CalibArray', arr_CalibArray);

            // v holds value such as 'P', 'U', 'E' .....etc

            switch (calibType) {
                case 'Monthly': {
                    {
                        var objPeriodic = await copyObjects.periodic('tbl_calibration_periodic_master_incomplete'
                            , 'tbl_calibration_periodic_master_failed', RepNo, 0, 'master')
                        // Copying Incomplete master to failed master

                        let columNames = objPeriodic.data.map(obj => obj.str_colName).toString();
                        var str_Query = `insert into tbl_calibration_periodic_master_failed (${columNames}) select ${columNames} from tbl_calibration_periodic_master_incomplete where Periodic_RepNo = ${RepNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
                        let resultPeriodic = await sequelize.query(str_Query, { type: sequelize.QueryTypes.INSERT })
                        // str_Query = 'select SCOPE_IDENTITY() as [Last Inserted Record]'
                        //  resultPeriodic = await sequelize.query(str_Query, { type: sequelize.QueryTypes.SELECT })


                        // last inserted Id got here form querymasterInsert[0]
                        var lastInsertedIdPeriodic = resultPeriodic[0][0].LastInsertedRecord;

                        // var findobj = await models.tbl_calibration_periodic_master_failed.findAll({

                        //     where: {
                        //         "srNo": lastInsertedIdPeriodic
                        //     }
                        // })
                        // Updating the report serial number in failed master
                        if (lastInsertedIdPeriodic != null) {

                            await models.tbl_calibration_periodic_master_failed.update({
                                "Periodic_RepNo": fRerSrNo,
                                "Periodic_CalbTime": moment(new Date()).format('HH:mm:ss')
                            }, {
                                where: {
                                    "srNo": lastInsertedIdPeriodic
                                }
                            })


                            // selecting data from incomplete details for copying
                            var resultP = await models.tbl_calibration_periodic_detail_incomplete.findAll({
                                where: {
                                    "Periodic_RepNo": RepNo
                                }
                            }); // selected
                            let res = [{}]
                            res[0].Periodic_RepNo = resultP[0].Periodic_RepNo
                            res[0].Periodic_RecNo = resultP[0].Periodic_RecNo
                            let i = 0;
                            for (let obj of resultP) {
                                obj.Periodic_RecNo = resultP[i].Periodic_RecNo
                                // as we have multiple entries i n details table so we need 
                                // Async loop



                                let objCopyPeriodic = await copyObjects.periodic('tbl_calibration_periodic_detail_incomplete'
                                    , 'tbl_calibration_periodic_detail_failed', obj.Periodic_RepNo, obj.Periodic_RecNo, 'detail');

                                columNames = objCopyPeriodic.data.map(obj => obj.str_colName).toString();
                                str_Query = `insert into tbl_calibration_periodic_detail_failed (${columNames}) select ${columNames} from tbl_calibration_periodic_detail_incomplete where Periodic_RepNo = ${obj.Periodic_RepNo} AND Periodic_RecNo = ${obj.Periodic_RecNo} select SCOPE_IDENTITY() as [LastInsertedRecord] `
                                let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                                var lastInsertedIdP = detailInsert[0][0].LastInsertedRecord;


                                await models.tbl_calibration_periodic_detail_failed.update({
                                    "Periodic_RepNo": fRerSrNo
                                }, {
                                    where: {
                                        "srNo": lastInsertedIdP
                                        // "Periodic_RepNo": res[0].Periodic_RepNo
                                    }
                                })

                                // updated repSrNo in failed details 
                                // console.log('P Copy')
                                // If ongoing calibration is failed ('Periodic') then only we have to delete
                                // records from incomplete tables for new entries

                                i++;
                            }

                            if (tempCaibStatus.status['P'] == 1) {
                                await models.tbl_calibration_periodic_master_incomplete.destroy({
                                    where: {
                                        "Periodic_RepNo": RepNo
                                    }
                                })
                                await models.tbl_calibration_periodic_detail_incomplete.destroy({
                                    where: {
                                        "Periodic_RepNo": RepNo
                                    }
                                })
                            }
                        }
                    }
                    {
                        var objReap = await copyObjects.repetability('tbl_calibration_repetability_master_incomplete'
                            , 'tbl_calibration_repetability_master_failed', RepNo, 0, 'master');
                        // Copying Incomplete master to failed master
                        let columNames = objReap.data.map(obj => obj.str_colName).toString();
                        var str_Query = `insert into tbl_calibration_repetability_master_failed (${columNames}) select ${columNames} from tbl_calibration_repetability_master_incomplete where Repet_RepNo = ${RepNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
                        let resultReap = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
                        // last inserted Id got here form query
                        var lastInsertedIdReap = resultReap[0][0].LastInsertedRecord;
                        // Updating the report serial number in failed master
                        if (lastInsertedIdReap != null) {
                            await models.tbl_calibration_repetability_master_failed.update({
                                "Repet_RepNo": fRerSrNo,
                                "Repet_CalbTime": moment(new Date()).format('HH:mm:ss')
                            }, {
                                where: {
                                    "srNo": lastInsertedIdReap
                                }
                            }) // failed master report number updated
                            // selecting data from incomplete details for copying

                            var resultP = await models.tbl_calibration_repetability_detail_incomplete.findAll({
                                where: {
                                    "Repet_RepNo": RepNo
                                }
                            }); // selected
                            let res = [{}]
                            res[0].Repet_RepNo = resultP[0].Repet_RepNo
                            res[0].Repet_RecNo = resultP[0].Repet_RecNo
                            // as we have multiple entries i n details table so we need 
                            // Async loop
                            let i = 0;
                            for (let obj of resultP) {
                                obj.Repet_RecNo = resultP[i].Repet_RecNo
                                let objCopyReap = await copyObjects.repetability('tbl_calibration_repetability_detail_incomplete'
                                    , 'tbl_calibration_repetability_detail_failed', obj.Repet_RepNo, obj.Repet_RecNo, 'detail');

                                columNames = objCopyReap.data.map(obj => obj.str_colName).toString();
                                str_Query = `insert into tbl_calibration_repetability_detail_failed (${columNames}) select ${columNames} from tbl_calibration_repetability_detail_incomplete where Repet_RepNo = ${obj.Repet_RepNo} AND Repet_RecNo = ${obj.Repet_RecNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
                                let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                                var lastInsertedIdU = detailInsert[0][0].LastInsertedRecord;

                                await models.tbl_calibration_repetability_detail_failed.update({
                                    "Repet_RepNo": fRerSrNo
                                }, {
                                    where: {
                                        "srNo": lastInsertedIdU
                                        // "Repet_RepNo": res[0].Repet_RepNo
                                    }
                                });
                                i++;
                            }
                            if (tempCaibStatus.status['R'] == 1) {
                                await models.tbl_calibration_repetability_master_incomplete.destroy({
                                    where: {
                                        "Repet_RepNo": RepNo
                                    }
                                });
                                await models.tbl_calibration_repetability_detail_incomplete.destroy({
                                    where: {
                                        "Repet_RepNo": RepNo
                                    }
                                });
                            }
                        }
                    }
                    {
                        var objEccen = await copyObjects.eccentricity('tbl_calibration_eccentricity_master_incomplete'
                            , 'tbl_calibration_eccentricity_master_failed', RepNo, 0, 'master');
                        // console.log(obj)
                        let columNames = objEccen.data.map(obj => obj.str_colName).toString();
                        var str_Query = `insert into tbl_calibration_eccentricity_master_failed (${columNames}) select ${columNames} from tbl_calibration_eccentricity_master_incomplete where Eccent_RepNo = ${RepNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
                        let resultEccen = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
                        // console.log(result)
                        var lastInsertedIdEccen = resultEccen[0][0].LastInsertedRecord;

                        if (lastInsertedIdEccen != null) {
                            await models.tbl_calibration_eccentricity_master_failed.update({
                                "Eccent_RepNo": fRerSrNo,
                                "Eccent_CalbTime": moment(new Date()).format('HH:mm:ss')
                            }, {
                                where: {
                                    "srNo": lastInsertedIdEccen
                                }
                            })

                            var resultP = await models.tbl_calibration_eccentricity_detail_incomplete.findAll({
                                where: {
                                    "Eccent_RepNo": RepNo
                                }
                            }); // selected
                            let res = [{}]
                            res[0].Eccent_RepNo = resultP[0].Eccent_RepNo
                            res[0].Eccent_RecNo = resultP[0].Eccent_RecNo
                            // console.log(result[0])
                            let i = 0;
                            for (let obj of resultP) {
                                obj.Eccent_RecNo = resultP[i].Eccent_RecNo
                                let objCopyEccen = await copyObjects.eccentricity('tbl_calibration_eccentricity_detail_incomplete'
                                    , 'tbl_calibration_eccentricity_detail_failed', obj.Eccent_RepNo, obj.Eccent_RecNo, 'detail');
                                columNames = objCopyEccen.data.map(obj => obj.str_colName).toString();
                                str_Query = `insert into tbl_calibration_eccentricity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_eccentricity_detail_incomplete where Eccent_RepNo = ${obj.Eccent_RepNo} AND Eccent_RecNo = ${obj.Eccent_RecNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
                                let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                                var lastInsertedIdU = detailInsert[0][0].LastInsertedRecord;

                                await models.tbl_calibration_eccentricity_detail_failed.update({
                                    "Eccent_RepNo": fRerSrNo,
                                    "Eccent_CalbTime": moment(new Date()).format('HH:mm:ss')
                                }, {
                                    where: {
                                        "srNo": lastInsertedIdU
                                        // "Eccent_RepNo":  res[0].Eccent_RepNo
                                    }
                                })
                                i++

                            }

                            if (tempCaibStatus.status['E'] == 1) {
                                await models.tbl_calibration_eccentricity_master_incomplete.destroy({
                                    where: {
                                        "Eccent_RepNo": RepNo
                                    }
                                });
                                await models.tbl_calibration_eccentricity_detail_incomplete.destroy({
                                    where: {
                                        "Eccent_RepNo": RepNo
                                    }
                                });
                            }


                        }


                    }


                    //   {
                    //     var objLinear = await copyObjects.linearity('tbl_calibration_linearity_master_incomplete'
                    //       , 'tbl_calibration_linearity_master_failed', RepNo, 0, 'master');
                    //     // Copying Incomplete master to failed master
                    //     let columNames = objLinear.data.map(obj => obj.str_colName).toString();
                    //     var str_Query = `insert into tbl_calibration_linearity_master_failed (${columNames}) select ${columNames} from tbl_calibration_linearity_master_incomplete where Linear_RepNo = ${RepNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
                    //     let resultLinear = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
                    //     // last inserted Id got here form query
                    //     var lastInsertedIdLinear = resultLinear[0][0].LastInsertedRecord;
                    //     // Updating the report serial number in failed master

                    //     if (lastInsertedIdLinear != null) {

                    //       await models.tbl_calibration_linearity_master_failed.update({
                    //         "Linear_RepNo": fRerSrNo,
                    //         "Linear_CalbTime": moment(new Date()).format('HH:mm:ss')
                    //       }, {
                    //         where: {
                    //           "srNo": lastInsertedIdLinear
                    //         }
                    //       }) // failed master report number updated
                    //       // selecting data from incomplete details for copying

                    //       var resultP = await models.tbl_calibration_linearity_detail_incomplete.findAll({
                    //         where: {
                    //           "Linear_RepNo": RepNo
                    //         }
                    //       }); // selected
                    //       let res = [{}]
                    //       res[0].Linear_RepNo = resultP[0].Linear_RepNo
                    //       res[0].Linear_RecNo = resultP[0].Linear_RecNo
                    //       // as we have multiple entries i n details table so we need 
                    //       // Async loop
                    //       let i = 0;
                    //       for (let obj of resultP) {
                    //         obj.Linear_RecNo = resultP[i].Linear_RecNo
                    //         let objCopyLinear = await copyObjects.linearity('tbl_calibration_linearity_detail_incomplete'
                    //           , 'tbl_calibration_linearity_detail_failed', obj.Linear_RepNo, obj.Linear_RecNo, 'detail');

                    //         columNames = objCopyLinear.data.map(obj => obj.str_colName).toString();
                    //         str_Query = `insert into tbl_calibration_linearity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_linearity_detail_incomplete where Linear_RepNo = ${obj.Linear_RepNo} AND Linear_RecNo = ${obj.Linear_RecNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
                    //         let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                    //         var lastInsertedIdU = detailInsert[0][0].LastInsertedRecord;

                    //         await models.tbl_calibration_linearity_detail_failed.update({
                    //           "Linear_RepNo": fRerSrNo
                    //         }, {
                    //           where: {
                    //             "srNo": lastInsertedIdU
                    //             // "Linear_RepNo": res[0].Linear_RepNo
                    //           }
                    //         })
                    //         i++;
                    //       }

                    //       if (tempCaibStatus.status['L'] == 1) {
                    //         await models.tbl_calibration_linearity_master_incomplete.destroy({
                    //           where: {
                    //             "Linear_RepNo": RepNo
                    //           }
                    //         })
                    //         await models.tbl_calibration_linearity_detail_incomplete.destroy({
                    //           where: {
                    //             "Linear_RepNo": RepNo
                    //           }
                    //         })
                    //       }

                    //     }
                    //   }
                    {
                        var objUnccen = await copyObjects.uncertinity('tbl_calibration_uncertinity_master_incomplete'
                            , 'tbl_calibration_uncertinity_master_failed', RepNo, 0, 'master');
                        // console.log(obj)
                        let columNames = objUnccen.data.map(obj => obj.str_colName).toString();
                        var str_Query = `insert into tbl_calibration_uncertinity_master_failed (${columNames}) select ${columNames} from tbl_calibration_uncertinity_master_incomplete where Uncertinity_RepNo = ${RepNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
                        let resultUnccen = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
                        // console.log(result)
                        var lastInsertedIdUnccen = resultUnccen[0][0].LastInsertedRecord;
                        if (lastInsertedIdUnccen != null) {
                            await models.tbl_calibration_uncertinity_master_failed.update({
                                "Uncertinity_RepNo": fRerSrNo,
                                "Uncertinity_CalbTime": moment(new Date()).format('HH:mm:ss')
                            }, {
                                where: {
                                    "srNo": lastInsertedIdUnccen
                                }
                            })
                            var selectDetailObjUnccen = {
                                str_tableName: 'tbl_calibration_uncertinity_detail_incomplete',
                                data: 'Uncertinity_RepNo,Uncertinity_RecNo',
                                condition: [
                                    { str_colName: 'Uncertinity_RepNo', value: RepNo, comp: 'eq' }
                                ]
                            }
                            var resultU = await models.tbl_calibration_uncertinity_detail_incomplete.findAll({
                                where: {
                                    "Uncertinity_RepNo": RepNo
                                }
                            }); // selected
                            let res = [{}]
                            res[0].Uncertinity_RepNo = resultU[0].Uncertinity_RepNo
                            res[0].Uncertinity_RecNo = resultU[0].Uncertinity_RecNo
                            // console.log(result[0])
                            let i = 0;
                            for (let obj of resultU) {
                                obj.Uncertinity_RecNo = resultU[i].Uncertinity_RecNo
                                let objCopyUnccen = await copyObjects.uncertinity('tbl_calibration_uncertinity_detail_incomplete', 'tbl_calibration_uncertinity_detail_failed', obj.Uncertinity_RepNo, obj.Uncertinity_RecNo, 'detail');
                                columNames = objCopyUnccen.data.map(obj => obj.str_colName).toString();
                                str_Query = `insert into tbl_calibration_uncertinity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_uncertinity_detail_incomplete where Uncertinity_RepNo = ${obj.Uncertinity_RepNo} AND Uncertinity_RecNo = ${obj.Uncertinity_RecNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
                                let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                                var lastInsertedIdU = detailInsert[0][0].LastInsertedRecord;

                                await models.tbl_calibration_uncertinity_detail_failed.update({
                                    "Uncertinity_RepNo": fRerSrNo
                                }, {
                                    where: {
                                        "srNo": lastInsertedIdU
                                        // "Uncertinity_RepNo": obj.Uncertinity_RepNo
                                    }
                                })
                                i++
                            }
                            if (tempCaibStatus.status['U'] == 1) {
                                await models.tbl_calibration_uncertinity_master_incomplete.destroy({
                                    where: {
                                        "Uncertinity_RepNo": RepNo
                                    }
                                });
                                await models.tbl_calibration_uncertinity_detail_incomplete.destroy({
                                    where: {
                                        "Uncertinity_RepNo": RepNo
                                    }
                                });
                            }

                        }


                    }

                    await models.tbl_calibration_status.update({

                        'P': 0,
                        'E': 0,
                        'R': 0,
                        'U': 0,
                        'L': 0
                    }, {
                        where: {
                            'BalID': strBalId
                        }
                    })
                    // if (deleteEntry) {

                    //     await models.tbl_calibration_periodic_master_incomplete.destroy({
                    //         where: {
                    //             "Periodic_RepNo": RepNo
                    //         }
                    //     });
                    //     await models.tbl_calibration_periodic_detail_incomplete.destroy({
                    //         where: {
                    //             "Periodic_RepNo": RepNo
                    //         }
                    //     });

                    //     await models.tbl_calibration_eccentricity_master_incomplete.destroy({
                    //         where: {
                    //             "Eccent_RepNo": RepNo
                    //         }
                    //     });
                    //     await models.tbl_calibration_eccentricity_detail_incomplete.destroy({
                    //         where: {
                    //             "Eccent_RepNo": RepNo
                    //         }
                    //     });

                    //     await models.tbl_calibration_repetability_master_incomplete.destroy({
                    //         where: {
                    //             "Repet_RepNo": RepNo
                    //         }
                    //     });
                    //     await models.tbl_calibration_repetability_detail_incomplete.destroy({
                    //         where: {
                    //             "Repet_RepNo": RepNo
                    //         }
                    //     });

                    //     let arrselectBalData = await models.tbl_balance.findOne({
                    //         where: {
                    //             'Bal_ID': strBalId
                    //         }
                    //     });
                    //     arrselectBalData = [[arrselectBalData]]



                    //     const bln_storeType = arrselectBalData[0][0].Bal_CalbStoreType
                    //     // if (bln_storeType == 1) {
                    //     //     // await models.tbl_calibration_status.update({
                    //     //     //     // 'P': 0,
                    //     //     //     // // 'E': 0,
                    //     //     //     // 'R': 0,
                    //     //     //     // 'U': 0,
                    //     //     //     // 'L': 0
                    //     //     // }, {
                    //     //     //     where: {
                    //     //     //         'BalID': strBalId
                    //     //     //     }
                    //     //     // });
                    //     // } else {
                    //     await models.tbl_calibration_status.update({
                    //         'P': 0,
                    //         'E': 0,
                    //         'R': 0,

                    //         // 'U': 0,
                    //         // 'L': 0
                    //     }, {
                    //         where: {
                    //             'BalID': strBalId
                    //         }
                    //     });
                    // }
                    // }



                }
                    break;
                case 'Yearly': {
                    // First copying data
                    {
                        var objUnccen = await copyObjects.uncertinity('tbl_calibration_uncertinity_master_incomplete'
                            , 'tbl_calibration_uncertinity_master_failed', RepNo, 0, 'master');
                        // console.log(obj)
                        let columNames = objUnccen.data.map(obj => obj.str_colName).toString();
                        var str_Query = `insert into tbl_calibration_uncertinity_master_failed (${columNames}) select ${columNames} from tbl_calibration_uncertinity_master_incomplete where Uncertinity_RepNo = ${RepNo} select SCOPE_IDENTITY() as [LastInsertedRecord]`
                        let resultUnccen = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
                        // console.log(result)
                        var lastInsertedIdUnccen = resultUnccen[0];
                        if (lastInsertedIdUnccen != 0) {
                            await models.tbl_calibration_uncertinity_master_failed.update({
                                "Uncertinity_RepNo": fRerSrNo,
                                "Uncertinity_CalbTime": moment(new Date()).format('HH:mm:ss')
                            }, {
                                where: {
                                    "srNo": lastInsertedIdUnccen
                                }
                            })
                            var selectDetailObjUnccen = {
                                str_tableName: 'tbl_calibration_uncertinity_detail_incomplete',
                                data: 'Uncertinity_RepNo,Uncertinity_RecNo',
                                condition: [
                                    { str_colName: 'Uncertinity_RepNo', value: RepNo, comp: 'eq' }
                                ]
                            }
                            var resultU = await models.tbl_calibration_uncertinity_detail_incomplete.findAll({
                                where: {
                                    "Uncertinity_RepNo": RepNo
                                }
                            }); // selected
                            let res = [{}]
                            res[0].Uncertinity_RepNo = resultU[0].Uncertinity_RepNo
                            res[0].Uncertinity_RecNo = resultU[0].Uncertinity_RecNo
                            // console.log(result[0])
                            let i = 0;
                            for (let obj of resultU) {
                                obj.Uncertinity_RecNo = resultU[i].Uncertinity_RecNo
                                let objCopyUnccen = await copyObjects.uncertinity('tbl_calibration_uncertinity_detail_incomplete', 'tbl_calibration_uncertinity_detail_failed', obj.Uncertinity_RepNo, obj.Uncertinity_RecNo, 'detail');
                                columNames = objCopyUnccen.data.map(obj => obj.str_colName).toString();
                                str_Query = `insert into tbl_calibration_uncertinity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_uncertinity_detail_incomplete where Uncertinity_RepNo = ${obj.Uncertinity_RepNo} AND Uncertinity_RecNo = ${obj.Uncertinity_RecNo} select SCOPE_IDENTITY() as [LastInsertedRecord]aa`
                                let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                                var lastInsertedIdU = detailInsert[0];

                                await models.tbl_calibration_uncertinity_detail_failed.update({
                                    "Uncertinity_RepNo": fRerSrNo
                                }, {
                                    where: {
                                        "srNo": lastInsertedIdU
                                        // "Uncertinity_RepNo": obj.Uncertinity_RepNo
                                    }
                                })
                                i++
                            }
                            if (tempCaibStatus.status['U'] == 0) {
                                await models.tbl_calibration_uncertinity_master_incomplete.destroy({
                                    where: {
                                        "Uncertinity_RepNo": RepNo
                                    }
                                });
                                await models.tbl_calibration_uncertinity_detail_incomplete.destroy({
                                    where: {
                                        "Uncertinity_RepNo": RepNo
                                    }
                                });
                            }

                        }


                    }

                    // {
                    //     var objEccen = await copyObjects.eccentricity('tbl_calibration_eccentricity_master_incomplete'
                    //         , 'tbl_calibration_eccentricity_master_failed', RepNo, 0, 'master');
                    //     // console.log(obj)
                    //     let columNames = objEccen.data.map(obj => obj.str_colName).toString();
                    //     var str_Query = `insert into tbl_calibration_eccentricity_master_failed (${columNames}) select ${columNames} from tbl_calibration_eccentricity_master_incomplete where Eccent_RepNo = ${RepNo}`
                    //     let resultEccen = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
                    //     // console.log(result)
                    //     var lastInsertedIdEccen = resultEccen[0];

                    //     if (lastInsertedIdEccen != 0) {
                    //         await models.tbl_calibration_eccentricity_master_failed.update({
                    //             "Eccent_RepNo": fRerSrNo,
                    //             "Eccent_CalbTime": moment(new Date()).format('HH:mm:ss')
                    //         }, {
                    //             where: {
                    //                 "srNo": lastInsertedIdEccen
                    //             }
                    //         })

                    //         var resultP = await models.tbl_calibration_eccentricity_detail_incomplete.findAll({
                    //             where: {
                    //                 "Eccent_RepNo": RepNo
                    //             }
                    //         }); // selected
                    //         let res = [{}]
                    //         res[0].Eccent_RepNo = resultP[0].Eccent_RepNo
                    //         res[0].Eccent_RecNo = resultP[0].Eccent_RecNo
                    //         // console.log(result[0])
                    //         let i = 0;
                    //         for (let obj of resultP) {
                    //             obj.Eccent_RecNo = resultP[i].Eccent_RecNo
                    //             let objCopyEccen = await copyObjects.eccentricity('tbl_calibration_eccentricity_detail_incomplete'
                    //                 , 'tbl_calibration_eccentricity_detail_failed', obj.Eccent_RepNo, obj.Eccent_RecNo, 'detail');
                    //             columNames = objCopyEccen.data.map(obj => obj.str_colName).toString();
                    //             str_Query = `insert into tbl_calibration_eccentricity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_eccentricity_detail_incomplete where Eccent_RepNo = ${obj.Eccent_RepNo} AND Eccent_RecNo = ${obj.Eccent_RecNo}`
                    //             let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                    //             var lastInsertedIdU = detailInsert[0];

                    //             await models.tbl_calibration_eccentricity_detail_failed.update({
                    //                 "Eccent_RepNo": fRerSrNo,
                    //                 "Eccent_CalbTime": moment(new Date()).format('HH:mm:ss')
                    //             }, {
                    //                 where: {
                    //                     "srNo": lastInsertedIdU
                    //                     // "Eccent_RepNo":  res[0].Eccent_RepNo
                    //                 }
                    //             })
                    //             i++

                    //         }

                    //         if (tempCaibStatus.status['E'].readIntLE() == 0) {
                    //             await models.tbl_calibration_eccentricity_master_incomplete.destroy({
                    //                 where: {
                    //                     "Eccent_RepNo": RepNo
                    //                 }
                    //             });
                    //             await models.tbl_calibration_eccentricity_detail_incomplete.destroy({
                    //                 where: {
                    //                     "Eccent_RepNo": RepNo
                    //                 }
                    //             });
                    //         }


                    //     }


                    // }
                    {
                        var objLinear = await copyObjects.linearity('tbl_calibration_linearity_master_incomplete'
                            , 'tbl_calibration_linearity_master_failed', RepNo, 0, 'master');
                        // Copying Incomplete master to failed master
                        let columNames = objLinear.data.map(obj => obj.str_colName).toString();
                        var str_Query = `insert into tbl_calibration_linearity_master_failed (${columNames}) select ${columNames} from tbl_calibration_linearity_master_incomplete where Linear_RepNo = ${RepNo}`
                        let resultLinear = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
                        // last inserted Id got here form query
                        var lastInsertedIdLinear = resultLinear[0];
                        // Updating the report serial number in failed master

                        if (lastInsertedIdLinear != 0) {

                            await models.tbl_calibration_linearity_master_failed.update({
                                "Linear_RepNo": fRerSrNo,
                                "Linear_CalbTime": moment(new Date()).format('HH:mm:ss')
                            }, {
                                where: {
                                    "srNo": lastInsertedIdLinear
                                }
                            }) // failed master report number updated
                            // selecting data from incomplete details for copying

                            var resultP = await models.tbl_calibration_linearity_detail_incomplete.findAll({
                                where: {
                                    "Linear_RepNo": RepNo
                                }
                            }); // selected
                            let res = [{}]
                            res[0].Linear_RepNo = resultP[0].Linear_RepNo
                            res[0].Linear_RecNo = resultP[0].Linear_RecNo
                            // as we have multiple entries i n details table so we need 
                            // Async loop
                            let i = 0;
                            for (let obj of resultP) {
                                obj.Linear_RecNo = resultP[i].Linear_RecNo
                                let objCopyLinear = await copyObjects.linearity('tbl_calibration_linearity_detail_incomplete'
                                    , 'tbl_calibration_linearity_detail_failed', obj.Linear_RepNo, obj.Linear_RecNo, 'detail');

                                columNames = objCopyLinear.data.map(obj => obj.str_colName).toString();
                                str_Query = `insert into tbl_calibration_linearity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_linearity_detail_incomplete where Linear_RepNo = ${obj.Linear_RepNo} AND Linear_RecNo = ${obj.Linear_RecNo}`
                                let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                                var lastInsertedIdU = detailInsert[0];

                                await models.tbl_calibration_linearity_detail_failed.update({
                                    "Linear_RepNo": fRerSrNo
                                }, {
                                    where: {
                                        "srNo": lastInsertedIdU
                                        // "Linear_RepNo": res[0].Linear_RepNo
                                    }
                                })
                                i++;
                            }

                            if (tempCaibStatus.status['L'] == 0) {
                                await models.tbl_calibration_linearity_master_incomplete.destroy({
                                    where: {
                                        "Linear_RepNo": RepNo
                                    }
                                })
                                await models.tbl_calibration_linearity_detail_incomplete.destroy({
                                    where: {
                                        "Linear_RepNo": RepNo
                                    }
                                })
                            }

                        }
                    }

                    if (deleteEntry) {
                        await models.tbl_calibration_uncertinity_master_incomplete.destroy({
                            where: {
                                "Uncertinity_RepNo": RepNo
                            }
                        });
                        await models.tbl_calibration_uncertinity_detail_incomplete.destroy({
                            where: {
                                "Uncertinity_RepNo": RepNo
                            }
                        });

                        // await models.tbl_calibration_eccentricity_master_incomplete.destroy({
                        //     where: {
                        //         "Eccent_RepNo": RepNo
                        //     }
                        // });
                        // await models.tbl_calibration_eccentricity_detail_incomplete.destroy({
                        //     where: {
                        //         "Eccent_RepNo": RepNo
                        //     }
                        // });

                        await models.tbl_calibration_linearity_master_incomplete.destroy({
                            where: {
                                "Linear_RepNo": RepNo
                            }
                        });
                        await models.tbl_calibration_linearity_detail_incomplete.destroy({
                            where: {
                                "Linear_RepNo": RepNo
                            }
                        });

                        let arrselectBalData = await models.tbl_balance.findOne({
                            where: {
                                'Bal_ID': strBalId
                            }
                        });
                        arrselectBalData = [[arrselectBalData]]



                        const bln_storeType = arrselectBalData[0][0].Bal_CalbStoreType
                        // if (bln_storeType == 1) {
                        await models.tbl_calibration_status.update({

                            // 'E': 0,

                            'U': 0,
                            'L': 0
                        }, {
                            where: {
                                'BalID': strBalId
                            }
                        })
                        // } else {
                        //     await models.tbl_calibration_status.update({

                        //         'E': 0,

                        //         'U': 0,
                        //         'L': 0
                        //     }, {
                        //         where: {
                        //             'BalID': strBalId
                        //         }
                        //     })
                        // }



                    }

                }
            }


            // switch (CalibrationType) {
            //     // For case PERIODIC CALIBRATION
            //     case 'P': {
            //         var objPeriodic = await copyObjects.periodic('tbl_calibration_periodic_master_incomplete'
            //             , 'tbl_calibration_periodic_master_failed', RepNo, 0, 'master')
            //         // Copying Incomplete master to failed master

            //         let columNames = objPeriodic.data.map(obj => obj.str_colName).toString();
            //         var str_Query = `insert into tbl_calibration_periodic_master_failed (${columNames}) select ${columNames} from tbl_calibration_periodic_master_incomplete where Periodic_RepNo = ${RepNo}`
            //         let resultPeriodic = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

            //         // last inserted Id got here form querymasterInsert[0]
            //         var lastInsertedIdPeriodic = resultPeriodic[0];
            //         // Updating the report serial number in failed master

            //         await models.tbl_calibration_periodic_master_failed.update({
            //             "Periodic_RepNo": fRerSrNo,
            //             "Periodic_EndTime": moment(new Date()).format('HH:mm:ss')
            //         }, {
            //             where: {
            //                 "srNo": lastInsertedIdPeriodic
            //             }
            //         })


            //         // selecting data from incomplete details for copying
            //         var resultP = await models.tbl_calibration_periodic_detail_incomplete.findAll({
            //             where: {
            //                 "Periodic_RepNo": RepNo
            //             }
            //         }); // selected
            //         let res = [{}]
            //         res[0].Periodic_RepNo = resultP[0].Periodic_RepNo
            //         res[0].Periodic_RecNo = resultP[0].Periodic_RecNo
            //         let i = 0;
            //         for (let obj of resultP) {
            //             obj.Periodic_RecNo = resultP[i].Periodic_RecNo
            //             // as we have multiple entries i n details table so we need 
            //             // Async loop



            //             let objCopyPeriodic = await copyObjects.periodic('tbl_calibration_periodic_detail_incomplete'
            //                 , 'tbl_calibration_periodic_detail_failed', obj.Periodic_RepNo, obj.Periodic_RecNo, 'detail');

            //             columNames = objCopyPeriodic.data.map(obj => obj.str_colName).toString();
            //             str_Query = `insert into tbl_calibration_periodic_detail_failed (${columNames}) select ${columNames} from tbl_calibration_periodic_detail_incomplete where Periodic_RepNo = ${obj.Periodic_RepNo} AND Periodic_RecNo = ${obj.Periodic_RecNo}`
            //             let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

            //             var lastInsertedIdP = detailInsert[0];


            //             await models.tbl_calibration_periodic_detail_failed.update({
            //                 "Periodic_RepNo": fRerSrNo
            //             }, {
            //                 where: {
            //                     "srNo": lastInsertedIdP
            //                     // "Periodic_RepNo": res[0].Periodic_RepNo
            //                 }
            //             })

            //             // updated repSrNo in failed details 
            //             // console.log('P Copy')
            //             // If ongoing calibration is failed ('Periodic') then only we have to delete
            //             // records from incomplete tables for new entries

            //             i++;
            //         }
            //         // for (let obj of res) {
            //         //     obj.Periodic_RecNo = resultU[i].Periodic_RecNo
            //         //     // as we have multiple entries i n details table so we need 
            //         //     // Async loop



            //         //     let objCopyPeriodic = await copyObjects.periodic('tbl_calibration_periodic_detail_incomplete'
            //         //         , 'tbl_calibration_periodic_detail_failed', obj.Periodic_RepNo, obj.Periodic_RecNo, 'detail');

            //         //     columNames = objCopyPeriodic.data.map(obj => obj.str_colName).toString();
            //         //     str_Query = `insert into tbl_calibration_periodic_detail_failed (${columNames}) select ${columNames} from tbl_calibration_periodic_detail_incomplete where Periodic_RepNo = ${obj.Periodic_RepNo}`
            //         //     let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

            //         //     var lastInsertedIdP = detailInsert[0];


            //         //     await models.tbl_calibration_periodic_detail_failed.update({
            //         //         "Periodic_RepNo": fRerSrNo
            //         //     }, {
            //         //         where: {
            //         //             // "srNo": lastInsertedIdP
            //         //             "Periodic_RepNo": res[0].Periodic_RepNo
            //         //         }
            //         //     })

            //         //     // updated repSrNo in failed details 
            //         //     // console.log('P Copy')
            //         //     // If ongoing calibration is failed ('Periodic') then only we have to delete
            //         //     // records from incomplete tables for new entries

            //         // i++;
            //         // }

            //         if (sortedArray.indexOf('P') == int_curentCalibrationIndex) {
            //             // delete records from incomplete tables

            //             await models.tbl_calibration_periodic_master_incomplete.destroy({
            //                 where: {
            //                     "Periodic_RepNo": RepNo
            //                 }
            //             })
            //             await models.tbl_calibration_periodic_detail_incomplete.destroy({
            //                 where: {
            //                     "Periodic_RepNo": RepNo
            //                 }
            //             })


            //         }
            //     }
            //         break;
            //     // For case UNCERTINITY CALIBRATION
            //     case 'U': {
            //         // First copying data
            //         var objUnccen = await copyObjects.uncertinity('tbl_calibration_uncertinity_master_incomplete'
            //             , 'tbl_calibration_uncertinity_master_failed', RepNo, 0, 'master');
            //         // console.log(obj)
            //         let columNames = objUnccen.data.map(obj => obj.str_colName).toString();
            //         var str_Query = `insert into tbl_calibration_uncertinity_master_failed (${columNames}) select ${columNames} from tbl_calibration_uncertinity_master_incomplete where Uncertinity_RepNo = ${RepNo}`
            //         let resultUnccen = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
            //         // console.log(result)
            //         var lastInsertedIdUnccen = resultUnccen[0];

            //         await models.tbl_calibration_uncertinity_master_failed.update({
            //             "Uncertinity_RepNo": fRerSrNo,
            //             "Uncertinity_EndTime": moment(new Date()).format('HH:mm:ss')
            //         }, {
            //             where: {
            //                 "srNo": lastInsertedIdUnccen
            //             }
            //         })
            //         var selectDetailObjUnccen = {
            //             str_tableName: 'tbl_calibration_uncertinity_detail_incomplete',
            //             data: 'Uncertinity_RepNo,Uncertinity_RecNo',
            //             condition: [
            //                 { str_colName: 'Uncertinity_RepNo', value: RepNo, comp: 'eq' }
            //             ]
            //         }
            //         var resultU = await models.tbl_calibration_uncertinity_detail_incomplete.findAll({
            //             where: {
            //                 "Uncertinity_RepNo": RepNo
            //             }
            //         }); // selected
            //         let res = [{}]
            //         res[0].Uncertinity_RepNo = resultU[0].Uncertinity_RepNo
            //         res[0].Uncertinity_RecNo = resultU[0].Uncertinity_RecNo
            //         // console.log(result[0])
            //         let i = 0;
            //         for (let obj of resultU) {
            //             obj.Uncertinity_RecNo = resultU[i].Uncertinity_RecNo
            //             let objCopyUnccen = await copyObjects.uncertinity('tbl_calibration_uncertinity_detail_incomplete', 'tbl_calibration_uncertinity_detail_failed', obj.Uncertinity_RepNo, obj.Uncertinity_RecNo, 'detail');
            //             columNames = objCopyUnccen.data.map(obj => obj.str_colName).toString();
            //             str_Query = `insert into tbl_calibration_uncertinity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_uncertinity_detail_incomplete where Uncertinity_RepNo = ${obj.Uncertinity_RepNo} AND Uncertinity_RecNo = ${obj.Uncertinity_RecNo}`
            //             let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

            //             var lastInsertedIdU = detailInsert[0];

            //             await models.tbl_calibration_uncertinity_detail_failed.update({
            //                 "Uncertinity_RepNo": fRerSrNo
            //             }, {
            //                 where: {
            //                     "srNo": lastInsertedIdU
            //                     // "Uncertinity_RepNo": obj.Uncertinity_RepNo
            //                 }
            //             })
            //             i++
            //         }

            //         if (sortedArray.indexOf('U') == int_curentCalibrationIndex) {
            //             // delete records from incomplete tables
            //             console.log('inside delete')

            //             await models.tbl_calibration_uncertinity_master_incomplete.destroy({
            //                 where: {
            //                     "Uncertinity_RepNo": RepNo
            //                 }
            //             })
            //             await models.tbl_calibration_uncertinity_detail_incomplete.destroy({
            //                 where: {
            //                     "Uncertinity_RepNo": RepNo
            //                 }
            //             })
            //         }
            //     }
            //         break;
            //     // For case ECCENTRICITY CALIBRATION
            //     case 'E': {
            //         // First copying data
            //         var objEccen = await copyObjects.eccentricity('tbl_calibration_eccentricity_master_incomplete'
            //             , 'tbl_calibration_eccentricity_master_failed', RepNo, 0, 'master');
            //         // console.log(obj)
            //         let columNames = objEccen.data.map(obj => obj.str_colName).toString();
            //         var str_Query = `insert into tbl_calibration_eccentricity_master_failed (${columNames}) select ${columNames} from tbl_calibration_eccentricity_master_incomplete where Eccent_RepNo = ${RepNo}`
            //         let resultEccen = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
            //         // console.log(result)
            //         var lastInsertedIdEccen = resultEccen[0]

            //         await models.tbl_calibration_eccentricity_master_failed.update({
            //             "Eccent_RepNo": fRerSrNo,
            //             "Eccent_EndTime": moment(new Date()).format('HH:mm:ss')
            //         }, {
            //             where: {
            //                 "srNo": lastInsertedIdEccen
            //             }
            //         })

            //         var resultP = await models.tbl_calibration_eccentricity_detail_incomplete.findAll({
            //             where: {
            //                 "Eccent_RepNo": RepNo
            //             }
            //         }); // selected
            //         let res = [{}]
            //         res[0].Eccent_RepNo = resultP[0].Eccent_RepNo
            //         res[0].Eccent_RecNo = resultP[0].Eccent_RecNo
            //         // console.log(result[0])
            //         let i = 0;
            //         for (let obj of resultP) {
            //             obj.Eccent_RecNo = resultP[i].Eccent_RecNo
            //             let objCopyEccen = await copyObjects.eccentricity('tbl_calibration_eccentricity_detail_incomplete'
            //                 , 'tbl_calibration_eccentricity_detail_failed', obj.Eccent_RepNo, obj.Eccent_RecNo, 'detail');
            //             columNames = objCopyEccen.data.map(obj => obj.str_colName).toString();
            //             str_Query = `insert into tbl_calibration_eccentricity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_eccentricity_detail_incomplete where Eccent_RepNo = ${obj.Eccent_RepNo} AND Eccent_RecNo = ${obj.Eccent_RecNo}`
            //             let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

            //             var lastInsertedIdU = detailInsert[0];

            //             await models.tbl_calibration_uncertinity_detail_failed.update({
            //                 "Eccent_RepNo": fRerSrNo,
            //                 "Linear_EndTime": moment(new Date()).format('HH:mm:ss')
            //             }, {
            //                 where: {
            //                     "srNo": lastInsertedIdU
            //                     // "Eccent_RepNo":  res[0].Eccent_RepNo
            //                 }
            //             })
            //             i++

            //         }
            //         if (sortedArray.indexOf('E') == int_curentCalibrationIndex) {
            //             // delete records from incomplete tables
            //             console.log('inside delete')

            //             await models.tbl_calibration_eccentricity_master_incomplete.destroy({
            //                 where: {
            //                     "Eccent_RepNo": RepNo
            //                 }
            //             })
            //             await models.tbl_calibration_eccentricity_detail_incomplete.destroy({
            //                 where: {
            //                     "Eccent_RepNo": RepNo
            //                 }
            //             })
            //         }
            //     }
            //         break;
            //     // For case REPETABILITY CALIBRATION
            //     case 'R': {
            //         var objReap = await copyObjects.repetability('tbl_calibration_repetability_master_incomplete'
            //             , 'tbl_calibration_repetability_master_failed', RepNo, 0, 'master');
            //         // Copying Incomplete master to failed master
            //         let columNames = objReap.data.map(obj => obj.str_colName).toString();
            //         var str_Query = `insert into tbl_calibration_repetability_master_failed (${columNames}) select ${columNames} from tbl_calibration_repetability_master_incomplete where Repet_RepNo = ${RepNo}`
            //         let resultReap = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
            //         // last inserted Id got here form query
            //         var lastInsertedIdReap = resultReap[0];
            //         // Updating the report serial number in failed master

            //         await models.tbl_calibration_repetability_master_failed.update({
            //             "Repet_RepNo": fRerSrNo,
            //             "Repet_EndTime": moment(new Date()).format('HH:mm:ss')
            //         }, {
            //             where: {
            //                 "srNo": lastInsertedIdReap
            //             }
            //         }) // failed master report number updated
            //         // selecting data from incomplete details for copying

            //         var resultP = await models.tbl_calibration_repetability_detail_incomplete.findAll({
            //             where: {
            //                 "Repet_RepNo": RepNo
            //             }
            //         }); // selected
            //         let res = [{}]
            //         res[0].Repet_RepNo = resultP[0].Repet_RepNo
            //         res[0].Repet_RecNo = resultP[0].Repet_RecNo
            //         // as we have multiple entries i n details table so we need 
            //         // Async loop
            //         let i = 0;
            //         for (let obj of resultP) {
            //             obj.Repet_RecNo = resultP[i].Repet_RecNo
            //             let objCopyReap = await copyObjects.repetability('tbl_calibration_repetability_detail_incomplete'
            //                 , 'tbl_calibration_repetability_detail_failed', obj.Repet_RepNo, obj.Repet_RecNo, 'detail');

            //             columNames = objCopyReap.data.map(obj => obj.str_colName).toString();
            //             str_Query = `insert into tbl_calibration_repetability_detail_failed (${columNames}) select ${columNames} from tbl_calibration_repetability_detail_incomplete where Repet_RecNo = ${obj.Repet_RecNo} AND Repet_RecNo = ${obj.Repet_RecNo}`
            //             let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

            //             var lastInsertedIdU = detailInsert[0];

            //             await models.tbl_calibration_uncertinity_detail_failed.update({
            //                 "Repet_RepNo": fRerSrNo
            //             }, {
            //                 where: {
            //                     "srNo": lastInsertedIdU
            //                     // "Repet_RepNo": res[0].Repet_RepNo
            //                 }
            //             })
            //             i++
            //         }

            //         if (sortedArray.indexOf('R') == int_curentCalibrationIndex) {
            //             // delete records from incomplete tables
            //             console.log('inside delete')

            //             await models.tbl_calibration_repetability_master_incomplete.destroy({
            //                 where: {
            //                     "Repet_RepNo": RepNo
            //                 }
            //             })
            //             await models.tbl_calibration_repetability_detail_incomplete.destroy({
            //                 where: {
            //                     "Repet_RepNo": RepNo
            //                 }
            //             })

            //         }
            //     }
            //         break;

            //     // For case Linearity CALIBRATION
            //     case 'L': {
            //         var objLinear = await copyObjects.linearity('tbl_calibration_linearity_master_incomplete'
            //             , 'tbl_calibration_linearity_master_failed', RepNo, 0, 'master');
            //         // Copying Incomplete master to failed master
            //         let columNames = objLinear.data.map(obj => obj.str_colName).toString();
            //         var str_Query = `insert into tbl_calibration_linearity_master_failed (${columNames}) select ${columNames} from tbl_calibration_linearity_master_incomplete where Linear_RepNo = ${RepNo}`
            //         let resultLinear = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
            //         // last inserted Id got here form query
            //         var lastInsertedIdLinear = resultLinear[0];
            //         // Updating the report serial number in failed master

            //         await models.tbl_calibration_linearity_master_failed.update({
            //             "Linear_RepNo": fRerSrNo,
            //             "Linear_EndTime": moment(new Date()).format('HH:mm:ss')
            //         }, {
            //             where: {
            //                 "srNo": lastInsertedIdLinear
            //             }
            //         }) // failed master report number updated
            //         // selecting data from incomplete details for copying

            //         var resultP = await models.tbl_calibration_linearity_detail_incomplete.findAll({
            //             where: {
            //                 "Linear_RepNo": RepNo
            //             }
            //         }); // selected
            //         let res = [{}]
            //         res[0].Linear_RepNo = resultP[0].Linear_RepNo
            //         res[0].Linear_RecNo = resultP[0].Linear_RecNo
            //         // as we have multiple entries i n details table so we need 
            //         // Async loop
            //         let i = 0;
            //         for (let obj of res) {
            //             obj.Linear_RecNo = resultP[i].Linear_RecNo
            //             let objCopyLinear = await copyObjects.linearity('tbl_calibration_linearity_detail_incomplete'
            //                 , 'tbl_calibration_linearity_detail_failed', obj.Linear_RepNo, obj.Linear_RecNo, 'detail');

            //             columNames = objCopyLinear.data.map(obj => obj.str_colName).toString();
            //             str_Query = `insert into tbl_calibration_linearity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_linearity_detail_incomplete where Linear_RecNo = ${obj.Linear_RecNo} AND Linear_RecNo = ${obj.Linear_RecNo}`
            //             let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

            //             var lastInsertedIdU = detailInsert[0];

            //             await models.tbl_calibration_linearity_detail_failed.update({
            //                 "Linear_RepNo": fRerSrNo
            //             }, {
            //                 where: {
            //                     "srNo": lastInsertedIdU
            //                     // "Linear_RepNo": res[0].Linear_RepNo
            //                 }
            //             })
            //             i++;
            //         }

            //         if (sortedArray.indexOf('L') == int_curentCalibrationIndex) {
            //             // delete records from incomplete tables
            //             console.log('inside delete')

            //             await models.tbl_calibration_linearity_master_incomplete.destroy({
            //                 where: {
            //                     "Linear_RepNo": RepNo
            //                 }
            //             })
            //             await models.tbl_calibration_linearity_detail_incomplete.destroy({
            //                 where: {
            //                     "Linear_RepNo": RepNo
            //                 }
            //             })

            //         }
            //     }
            //         break;

            // }
        } catch (error) {
            console.log(error)
        }
    }



}

module.exports = CommanFunction;