const globalData = require("../../global/globalData");
const GLOBAL_NOMENCLATURE = require("../../global/GLOBAL_NOMENCLATURE");
const clsStoreProcedure = require("../Product/clsStoreProcedure");
const Database = require("../../database/clsQueryProcess");
const dbCon = require("../../global/dbCon");
const clsFormulaFun = require("../Product/clsformulaFun.model");
const clsProObj = require("../Product/clsProductDetailModel");
const date = require("date-and-time");
const objStoreProcedure = new clsStoreProcedure();
let now = new Date();
const database = new Database();
const formulaFun = new clsFormulaFun();
const proObj = new clsProObj();
const models = require("../../../config/dbConnection").models;
const sequelize = require("../../../config/dbConnection").sequelize;
const { QueryTypes, Op } = require("sequelize");
const moment = require("moment");
const maths = require("mathjs");

const { create, all } = require("mathjs");
const { Console } = require("winston/lib/winston/transports");
const config = {};
const mathj = create(all, config);
class BatchSummary {
  constructor() {
    // var mathj;
    this.math = maths;
  }

  async saveBatchData(typeValue, resultdata, strHmi, strIdsNo) {
    try {
      let responseObj = {};
      let strInstrumentId = "";
      let masterTable, detailTable, finalSum;
      let typeVal, sideVal, checkSideMasterTable;
      const objProductArray = globalData.arrIdsInfo.find(
        (k) => k.Hmi == strHmi
      );
      const objWeighment = objProductArray.cubicalData;

      let selectedIdsNo;
      var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.Hmi == strHmi);
      if (IPQCObject != undefined) {
        selectedIdsNo = IPQCObject.selectedIds;
      } else {
        selectedIdsNo = strIdsNo;
      }

      let selectedCubical = globalData.arrIdsInfo.find(
        (k) => k.Hmi == strHmi
      ).cubicalData;

      let objProductTypeDetails = globalData.arrProductTypeArray.find(
        (k) => k.Hmi == strHmi
      );
      const objProdMasterDetails = objProductTypeDetails.productType;
      const objProdDetail = objProductTypeDetails.productDetail[0][0];
      const arrCheck = [1, 2, 3, 4, 5, 6, 8, "L", 9, 11];
      const product_limit = globalData.arrWeighmentProductData.find(
        (k) => k.Hmi == strHmi
      ).data;

      if (arrCheck.some((type) => type == typeValue)) {
        if (typeValue == 9) {
          masterTable = "tbl_batchsummary_master9";
          detailTable = "tbl_batchsummary_detail9";
        } else if (typeValue == "L") {
          masterTable = "tbl_batchsummary_master11";
          detailTable = "tbl_batchsummary_detail11";
        } else {
          if (
            objProdMasterDetails.ProductType == 2 ||
            objProdMasterDetails.ProductType == 1
          ) {
            if (typeValue == 4) {
              masterTable = "tbl_batchsummary_master4";
              detailTable = "tbl_batchsummary_detail4";
            } else {
              masterTable = "tbl_batchsummary_master" + typeValue;
              detailTable = "tbl_batchsummary_detail" + typeValue;
            }
          } else {
            if (cubicalObj.Sys_Area == "Dosa Dry Syrup") {
              masterTable = "tbl_batchsummary_master19";
              detailTable = "tbl_batchsummary_detail19";
            } else {
              masterTable = "tbl_batchsummary_master" + typeValue;
              detailTable = "tbl_batchsummary_detail" + typeValue;
            }
          }
        }

        let sum = resultdata.detailData.reduce((acc, obj) => {
          return acc + Number(obj.DataValue);
        }, 0);
        finalSum = sum;

        if (typeValue == 8) {
          typeVal = 9;
        } else if (typeValue == "L") {
          typeVal = 11;
        } else if (typeValue == "P") {
          typeVal = 18;
        } else {
          typeVal = typeValue;
        }

        let resOfSP = await objStoreProcedure.fetchDetailForStats(
          resultdata,
          typeVal
        );
        let maxVal = resOfSP.max; //Math.max(...arrDetail);
        let minVal = resOfSP.min; //Math.min(...arrDetail);
        let avgVal = resOfSP.avg; //(finalSum / count);
        if (
          objWeighment.Sys_RptType == 0 &&
          objWeighment.Sys_Validation == 0 &&
          objWeighment.Sys_BatchReuse == 0 &&
          (objWeighment.Sys_CubType == "Compression" ||
            (objWeighment.Sys_CubType == "Coating" && objWeighment.Sys_IPQCType != "Compression") ||
            objWeighment.Sys_CubType == "Capsule Filling" ||
            objWeighment.Sys_CubType == "IPQC" ||
            objWeighment.Sys_CubType == "Dosa Dry")
        ) {
          let res = objProdDetail;
          let paramNom = `Param${typeVal}_Nom`;
          let limitNo = `Param${typeVal}_LimitOn`;
          let nom = parseFloat(res[paramNom]);
          let limit = res[limitNo];
          let minPer, maxPer;
          if (limit == 0) {
            //standard
            minPer = (((nom - minVal) / nom) * 100);
            maxPer = (((maxVal - nom) / nom) * 100);
          } //average
          else {
            minPer = (((avgVal - minVal) / avgVal) * 100);
            maxPer = (((maxVal - avgVal) / avgVal) * 100);
          }
          if (
            typeValue == "1" ||
            typeValue == "2" ||
            typeValue == "8" ||
            typeValue == "L" ||
            typeValue == "9" ||
            typeValue == "K" ||
            typeValue == 11
          ) {
            strInstrumentId = resultdata.incompleteData.BalanceId;
          } else if (
            typeValue == "3" ||
            typeValue == "4" ||
            typeValue == "5" ||
            typeValue == "6"
          ) {
            strInstrumentId = resultdata.incompleteData.VernierId;
          }

          if (resultdata.incompleteData.Side == "LHS") {
            sideVal = "LHS";
          } else if (resultdata.incompleteData.Side == "RHS") {
            sideVal = "RHS";
          } else {
            sideVal = "NA";
          }
          if (resultdata.incompleteData.Side == "NA") {
            checkSideMasterTable = resultdata.incompleteData.Side;
          } else {
            checkSideMasterTable = "LHS";
          }
          // We only want to check side for NA and left side in master table so again we declare
          // side variable for this specific perpose
          const checkMasterObj = await models[masterTable].findAll({
            attributes: [
              [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
            ],
            where: {
              BFGCode: resultdata.incompleteData.BFGCode,
              ProductName: resultdata.incompleteData.ProductName,
              PVersion: resultdata.incompleteData.PVersion,
              Version: resultdata.incompleteData.Version,
              Side: checkSideMasterTable,
              Area: resultdata.incompleteData.Area,
              BatchNo: resultdata.incompleteData.BatchNo,
            },
          });
          // {
          //     str_tableName: masterTable,
          //     data: 'MAX(RepSerNo) AS SrNo',
          //     condition: [
          //         { str_colName: 'BFGCode', value: resultdata.incompleteData.BFGCode, comp: 'eq' },
          //         { str_colName: 'ProductName', value: resultdata.incompleteData.ProductName, comp: 'eq' },
          //         { str_colName: 'PVersion', value: resultdata.incompleteData.PVersion, comp: 'eq' },
          //         { str_colName: 'Version', value: resultdata.incompleteData.Version, comp: 'eq' },
          //         { str_colName: 'Side', value: checkSideMasterTable, comp: 'eq' },
          //         { str_colName: 'CubType', value: resultdata.incompleteData.CubicleType, comp: 'eq' },
          //         { str_colName: 'BatchNo', value: resultdata.incompleteData.BatchNo, comp: 'eq' },
          //     ]
          // }
          let resultData = checkMasterObj;
          let masterSrNo;
          var DP = resultdata.incompleteData.Unit == 'mm' ? 2 : resultdata.incompleteData.DecimalPoint;
          var avg_dp = resultdata.incompleteData.Unit == 'mm' ? 2 : resultdata.incompleteData.Unit == 'mg' ? 1 : 4;
          var decimal = resultdata.incompleteData.Unit == 'mm' ? 2 : resultdata.incompleteData.DecimalPoint;
          const SampleRemark = globalData.arrSampleRemarkForAllTest.find(
            (k) => k.Hmi == strHmi
          );
          let remark = "Complies";
          if (SampleRemark.OutOfRemark == true) {
            remark = "Not Complies";
          } else {
            remark = "Complies";
          }

          let recSeqNo = await this.calculateSeqNo(
            sideVal,
            masterTable,
            detailTable,
            resultdata.incompleteData
          );

          if (resultData[0].RepSerNo == null) {
            const objInsertMasterData = await models[masterTable].create({
              BFGCode: resultdata.incompleteData.BFGCode,
              ProductName: resultdata.incompleteData.ProductName,
              PVersion: resultdata.incompleteData.PVersion,
              Version: resultdata.incompleteData.Version,
              PrdType: resultdata.incompleteData.ProductType,
              CubicleType: resultdata.incompleteData.CubicleType,
              CubicleName: resultdata.incompleteData.CubicleName,
              BatchNo: resultdata.incompleteData.BatchNo,
              Stage: selectedCubical.Sys_Stage,
              Department: selectedCubical.Sys_dept,
              Nom: nom.toFixed(DP),
              Tol1Neg: product_limit.T1Neg.split(" ")[0], //resultdata.incompleteData.T1NegTol,
              Tol1Pos: product_limit.T1Pos.split(" ")[0], //resultdata.incompleteData.T1PosTol,
              Tol2Neg: product_limit.T2Neg.split(" ")[0], //resultdata.incompleteData.T2NegTol,
              Tol2Pos: product_limit.T2Pos.split(" ")[0], //resultdata.incompleteData.T2PosTol,
              DP: DP,
              Tol1NegActual: product_limit.T1Neg.split(" ")[0],
              Tol1PosActual: product_limit.T1Pos.split(" ")[0],
              Tol2NegActual: product_limit.T2Neg.split(" ")[0],
              Tol2PosActual: product_limit.T2Pos.split(" ")[0],
              StartDate: moment().format('YYYY-MM-DD'),
              EndDate: moment().format('YYYY-MM-DD'),
              //LODLayer: resultdata.incompleteDatad ,
              Unit: resultdata.incompleteData.Unit,
              FinalMinDT: resultdata.incompleteData.PrDate,
              FinalMaxDT: moment(resultdata.incompleteData.PrTime).format("HH:mm:ss"),
              FinalAvgDT: resultdata.incompleteData.PrEndDate,
              Side: sideVal,
              BatchCompleted: resultdata.incompleteData.BatchComplete,
              IsArchived: resultdata.incompleteData.IsArchived,
              LimitOn: limit,
              NMTLimit: resultdata.incompleteData.T1NMTTab,
              Area: selectedCubical.Sys_Area,
              GenericName: resultdata.incompleteData.GenericName,
              BMRNo: resultdata.incompleteData.BMRNo,
              BatchSize: `${selectedCubical.Sys_BatchSize} ${selectedCubical.Sys_BatchSizeUnit}`,
              ReportType: resultdata.incompleteData.GraphType,
              StdLimit1: resultdata.incompleteData.StdLimit1,
              StdLimit2: resultdata.incompleteData.StdLimit2,
              // MinValue: minVal,
              // MaxValue: maxVal,
              // AvgValue: avgVal,
              Remark: resultdata.incompleteData.Remark,
            });
            var masterResult = objInsertMasterData.dataValues;
            masterSrNo = masterResult.RepSerNo;
            //     let masterResult = objInsertMasterData.dataValues;
            //     masterSrNo = masterResult.RepSerNo;
            //     const objInsertDetailData = await models[detailTable].create({
            //         RepSerNo: masterSrNo,
            //         RecSeqNo: recSeqNo,
            //         Date: resultdata.incompleteData.PrDate,
            //         Time: resultdata.incompleteData.PrTime,
            //         InstrumentID: strInstrumentId,
            //         Side: sideVal,
            //         MinPer: minPer,
            //         MaxPer: maxPer,
            //         Min: minVal,
            //         Max: maxVal,
            //         Avg: avgVal,
            //         // { str_colName: 'MinTimeDT: resultdata.incompleteDataTol,
            //         // { str_colName: 'MaxTimeDT: resultdata.incompleteDataTol,
            //         TestResult: remark,
            //         UserID: resultdata.incompleteData.UserId,
            //         UserName: resultdata.incompleteData.UserName,

            //     })

            //     Object.assign(responseObj, { status: 'success' })
            //     return responseObj;
          }
          //  else {
          // masterSrNo = resultData[0].SrNo;

          masterSrNo = masterSrNo != undefined ? masterSrNo : resultData[0].RepSerNo;
          var Nominal = Number(resultdata.incompleteData.Nom);
          var Per_Dev = ((Nominal - Number(avgVal).toFixed(3)) / Nominal) * 100;
          Per_Dev = Number(Per_Dev).toFixed(2);
          // if((product_limit.menuName).includes('Group')){
          //   var objInsertDetailData = await models[detailTable].create({
          //     RepSerNo: masterSrNo,
          //     RecSeqNo: recSeqNo,
          //     Date: resultdata.incompleteData.PrDate,
          //     Time: moment(resultdata.incompleteData.PrTime).format("HH:mm:ss"),
          //     InstrumentID: strInstrumentId,
          //     Side: sideVal,
          //     NoOfSample: resultdata.incompleteData.Qty,
          //     MinPer: Number(minPer).toFixed(DP),
          //     MaxPer: Number(maxPer).toFixed(DP),
          //     Min: Number( minVal).toFixed(DP),
          //     Max:  Number(maxVal).toFixed(DP),
          //     Avg: Number(resultdata.incompleteData.AvgGrpWeight).toFixed(DP),
          //     Deviation: Per_Dev,
          //     TestResult: remark,
          //     UserID: resultdata.incompleteData.UserId,
          //     UserName: resultdata.incompleteData.UserName,
          //   });
          // }else{

          var objInsertDetailData = await models[detailTable].create({
            RepSerNo: masterSrNo,
            RecSeqNo: recSeqNo,
            Date: resultdata.incompleteData.PrDate,
            Time: moment(resultdata.incompleteData.PrTime).format("HH:mm:ss"),
            InstrumentID: strInstrumentId,
            Side: sideVal,
            NoOfSample: resultdata.incompleteData.Qty,
            Min_Per: Number(minPer).toFixed(2),
            Max_Per: Number(maxPer).toFixed(2),
            Min: Number(minVal).toFixed(decimal),
            Max: Number(maxVal).toFixed(decimal),
            Avg: Number(avgVal).toFixed(avg_dp),
            Deviation: Per_Dev,
            TestResult: remark,
            UserID: resultdata.incompleteData.UserId,
            UserName: resultdata.incompleteData.UserName,
          });
          // }

          //batch calculation and update in batch master
          var Complies_Result = await models[detailTable].findAll({
            where: {
              RepSerNo: masterSrNo,
              TestResult: "Complies",
              // InstrumentID: resultdata.incompleteData.BalanceId
            },
          });
          var arr = [];
          var arr_min = [];
          var arr_avg = [];
          var arr_minPer = [];
          var arr_maxPer = [];
          var max_value = 0;
          var min_value = 0;
          var average = 0;
          var avg = 0;
          var max_Per = 0;
          var min_Per = 0;
          if (Complies_Result.length != 0) {
            for (var i = 0; i < Complies_Result.length; i++) {
              var Max = Complies_Result[i].Max;
              arr.push(Number(Max));
              // console.log(arr);
              var Min = Complies_Result[i].Min;
              arr_min.push(Number(Min));
              // console.log(arr_min);
              max_value = maths.max(arr);
              min_value = maths.min(arr_min);
              var minper = Complies_Result[i].Min_Per;
              arr_minPer.push(Number(minper));
              var maxper = Complies_Result[i].Max_Per;
              arr_maxPer.push(Number(maxper));
              max_Per = maths.max(arr_maxPer);
              min_Per = maths.min(arr_minPer);
              average = Complies_Result[i].Avg;
              arr_avg.push(Number(average));
              // console.log(average);
              var total = arr_avg.reduce((acc, total) => {
                return Number(total) + Number(acc);
              }, 0);
              avg = total / arr_avg.length;
              avg = mathj.round(Number(avg), avg_dp).toFixed(avg_dp);
            }
          }
          var update_Master = await models[masterTable].update(
            {
              MaxValue: max_value == 0 ? "NA" : mathj.round(Number(max_value), DP).toFixed(DP),
              MinValue: min_value == 0 ? "NA" : mathj.round(Number(min_value), DP).toFixed(DP),
              AvgValue: avg == 0 ? "NA" : mathj.round(Number(avg), avg_dp).toFixed(avg_dp),
              Min_Per: min_Per == 0 ? "NA" : Number(min_Per).toFixed(2),
              Max_Per: max_Per == 0 ? "NA" : Number(max_Per).toFixed(2),
              EndDate: moment().format('YYYY-MM-DD'),
              CubicleName: resultdata.incompleteData.CubicleName,
            },
            {
              where: {
                RepSerNo: masterSrNo,
              },
            }
          );
          // }

          let detailResult = objInsertDetailData;
          Object.assign(responseObj, { status: "success" });
          return responseObj;
          // }
        }
      } else {
        return false;
      }
    } catch (error) {
      console.log(error);
      throw new Error(error);
    }
  }

  // async saveBatchDataHardness(masterData, DetailData, idsNo) {
  //     try {
  //         var now = new Date();
  //         let responseObj = {};
  //         var selectedIds = idsNo;

  //         // console.log(masterData, DetailData);
  //         var cubicalObj = globalData.arrIdsInfo.find(k => k.idsNo == selectedIds).cubicalData;

  //         var menuDetail = globalData.arr_limits.find(k => k.idsNo == idsNo);

  //         let tempLimObjHardness = menuDetail.Menus.filter(obj => Object.keys(obj) == "Hardness")[0] == undefined ?
  //             undefined : menuDetail.Menus.filter(obj => Object.keys(obj) == "Hardness")[0]['Hardness'];

  //         let tempLimObjThickness = menuDetail.Menus.filter(obj => Object.keys(obj) == "Thickness")[0] == undefined ?
  //             undefined : menuDetail.Menus.filter(obj => Object.keys(obj) == "Thickness")[0]['Thickness'];

  //         let tempLimObjlength = menuDetail.Menus.filter(obj => Object.keys(obj) == "Length")[0] == undefined ?
  //             undefined : menuDetail.Menus.filter(obj => Object.keys(obj) == "Length")[0]['Length'];

  //         let tempLimObjDiameter = menuDetail.Menus.filter(obj => Object.keys(obj) == "Diameter")[0] == undefined ?
  //             undefined : menuDetail.Menus.filter(obj => Object.keys(obj) == "Diameter")[0]['Diameter'];

  //         let tempLimObjBreadth = menuDetail.Menus.filter(obj => Object.keys(obj) == "Breadth")[0] == undefined ?
  //             undefined : menuDetail.Menus.filter(obj => Object.keys(obj) == "Breadth")[0]['Breadth'];

  //         let sideVal = "NA";
  //         if (masterData.Side == 'LHS') {
  //             sideVal = "LEFT";
  //         } else if (masterData.Side == 'RHS') {
  //             sideVal = "RIGHT";
  //         } else {
  //             sideVal = "NA";
  //         }
  //         let checkSideMasterTable;
  //         if (masterData.Side == 'NA') {
  //             checkSideMasterTable = masterData.Side;
  //         } else {
  //             checkSideMasterTable = 'LEFT';
  //         }
  //         let sumHT = 0;
  //         let sumT = 0;
  //         let sumDLB = 0;
  //         let arrHTDetail = [];
  //         let arrTDetail = [];
  //         let arrDLBDetail = [];
  //         let outFlagHTD = 0;
  //         let outFlagThickness = 0;
  //         let outFlagDOLOBO = 0;
  //         let remark;
  //         let maxHTDLimit = parseFloat(tempLimObjHardness.T1Pos);
  //         let minHTDLimit = parseFloat(tempLimObjHardness.T1Neg);
  //         if (tempLimObjThickness == undefined) {
  //             var maxTLimit = 0;
  //             var minTLimit = 0;
  //         } else {
  //             var maxTLimit = parseFloat(formulaFun.upperLimit(tempLimObjThickness, 'T2'));
  //             var minTLimit = parseFloat(formulaFun.lowerLimit(tempLimObjThickness, 'T2'));
  //         }

  //         // if(masterData.NomDOLOBO != 0) {
  //         if (masterData.ColHeadDOLOBO == 'NA') {
  //             var maxDLBLimit = 0;
  //             var minDLBLimit = 0;
  //         } else {
  //             if (tempLimObjlength == undefined && tempLimObjBreadth == undefined && tempLimObjDiameter == undefined) {
  //                 var maxDLBLimit = 0;
  //                 var minDLBLimit = 0;
  //             } else {
  //                 // tempLimObjlength == undefined ? tempLimObjBreadth == undefined ?  tempLimObjBreadth : tempLimObjDiameter ;
  //                 let a = tempLimObjlength != undefined ? tempLimObjlength : tempLimObjBreadth != undefined ? tempLimObjBreadth : tempLimObjDiameter;
  //                 var maxDLBLimit = parseFloat(formulaFun.upperLimit(a));
  //                 var minDLBLimit = parseFloat(formulaFun.lowerLimit(a));
  //             }

  //         }

  //         let count = DetailData.length;
  //         for (var i = 0; i < DetailData.length; i++) {
  //             var dataValHard = parseFloat(DetailData[i].DataValueHard);
  //             if ((minHTDLimit > dataValHard) || (dataValHard > maxHTDLimit)) {
  //                 outFlagHTD = outFlagHTD + 1;
  //             }
  //             arrHTDetail.push(dataValHard);
  //             var dataValThick = parseFloat(DetailData[i].DataValueThick);
  //             if (minTLimit != 0 && maxTLimit != 0) {
  //                 if ((minTLimit > dataValThick) || (dataValThick > maxTLimit)) {
  //                     outFlagThickness = outFlagThickness + 1;
  //                 }
  //             }
  //             arrTDetail.push(dataValThick);
  //             var dataValDLB = parseFloat(DetailData[i].DataValueDOLOBO);
  //             if (minDLBLimit != 0 && maxDLBLimit != 0) {
  //                 if ((minDLBLimit > dataValDLB) || (dataValDLB > maxDLBLimit)) {
  //                     outFlagDOLOBO = outFlagDOLOBO + 1;
  //                 }
  //             }
  //             arrDLBDetail.push(dataValDLB);
  //         }

  //         if (masterData.NomDOLOBO != 0) {
  //             if (outFlagHTD != 0 || outFlagThickness != 0 || outFlagDOLOBO != 0) {
  //                 remark = 'Not Complies';
  //             } else {
  //                 remark = 'Complies';
  //             }
  //         } else {
  //             if (outFlagHTD != 0 || outFlagThickness != 0) {
  //                 remark = 'Not Complies'
  //             } else {
  //                 remark = 'Complies';
  //             }
  //         }

  //         for (var j = 0; j < arrHTDetail.length; j++) {
  //             sumHT = sumHT + parseFloat(arrHTDetail[j]);
  //         }
  //         for (var k = 0; k < arrTDetail.length; k++) {
  //             sumT = sumT + parseFloat(arrTDetail[k]);
  //         }
  //         for (var l = 0; l < arrDLBDetail.length; l++) {
  //             sumDLB = sumDLB + parseFloat(arrDLBDetail[l]);
  //         }
  //         var MaxHard = Math.max(...arrHTDetail);
  //         var MinHard = Math.min(...arrHTDetail);
  //         var avgHard = (sumHT / count);
  //         var MaxThick = Math.max(...arrTDetail);
  //         var MinThick = Math.min(...arrTDetail);
  //         var AvgThick = (sumT / count);
  //         var MaxDLB = Math.max(...arrDLBDetail);
  //         var MinDLB = Math.min(...arrDLBDetail);
  //         var AvgDLB = (sumDLB / count);

  //         if (((cubicalObj.Sys_RptType == 0) && (cubicalObj.Sys_Validation == 0) && (cubicalObj.Sys_CubType == 'Compression') || (cubicalObj.Sys_CubType == 'Coating'))) {
  //             // let res = await proObj.productData(cubicalObj);
  //             // var paramNom = `Param7_Nom`;
  //             // var limitNo = `Param7_LimitOn`;
  //             // var nom = parseFloat(res[1][paramNom]);
  //             // var limit = res[1][limitNo].readUIntLE();
  //             // if(masterData.ColHeadDOLOBO == 'Le')

  //             // const checkMasterObj = {
  //             //     str_tableName: 'tbl_batchsummary_master_hdlb',
  //             //     data: 'MAX(RepSerNo) AS SrNo',
  //             //     condition: [
  //             //         { str_colName: 'BFGCode', value: masterData.BFGCode, comp: 'eq' },
  //             //         { str_colName: 'ProductName', value: masterData.ProductName, comp: 'eq' },
  //             //         { str_colName: 'PVersion', value: masterData.PVersion, comp: 'eq' },
  //             //         { str_colName: 'Version', value: masterData.Version, comp: 'eq' },
  //             //         { str_colName: 'Side', value: checkSideMasterTable, comp: 'eq' },
  //             //         { str_colName: 'CubType', value: cubicalObj.Sys_CubType, comp: 'eq' },
  //             //         { str_colName: 'BatchNo', value: masterData.BatchNo, comp: 'eq' },
  //             //     ]
  //             // }

  //             // let DP = await objDP.precision(resultdata.incompleteData.T2PosTol);
  //             // let resultData = await database.select(checkMasterObj);
  //             var masterSrNo;
  //             const checkMasterObj = await models['tbl_batchsummary_master_hdlb'].findAll({
  //                 attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'SrNo']],
  //                 where: {
  //                     BFGCode: masterData.BFGCode,
  //                     ProductName: masterData.ProductName,
  //                     PVersion: masterData.PVersion,
  //                     Version: masterData.Version,
  //                     Side: checkSideMasterTable,
  //                     CubType: cubicalObj.Sys_CubType,
  //                     BatchNo: masterData.BatchNo,
  //                 }
  //             })
  //             let resultData = checkMasterObj;

  //             let recSeqNo = await this.calculateSeqNo(sideVal, 'tbl_batchsummary_master_hdlb', 'tbl_batchsummary_detail_hdlb', masterData);
  //             if (resultData[0].SrNo == null) {
  //                 // let masterDataInsert = {
  //                 //     str_tableName: 'tbl_batchsummary_master_hdlb',
  //                 //     data: [
  //                 //         { str_colName: 'BFGCode', value: masterData.BFGCode },
  //                 //         { str_colName: 'ProductName', value: masterData.ProductName },
  //                 //         { str_colName: 'PVersion', value: masterData.PVersion },
  //                 //         { str_colName: 'Version', value: masterData.Version },
  //                 //         { str_colName: 'PrdType', value: 1 },
  //                 //         { str_colName: 'CubType', value: masterData.CubicleType },
  //                 //         { str_colName: 'BatchNo', value: masterData.BatchNo },
  //                 //         { str_colName: 'Stage', value: masterData.Stage },
  //                 //         { str_colName: 'Dept', value: cubicalObj.Sys_dept },
  //                 //         { str_colName: 'NomHard', value: masterData.NomHard },
  //                 //         { str_colName: 'LwrHard', value: masterData.NegTolHard },
  //                 //         { str_colName: 'UppHard', value: masterData.PosTolHard },
  //                 //         { str_colName: 'UnitHard', value: masterData.Unit },
  //                 //         { str_colName: 'NomThick', value: masterData.NomThick },
  //                 //         { str_colName: 'LwrThick', value: masterData.NegTolThick },
  //                 //         { str_colName: 'UppThick', value: masterData.PosTolThick },
  //                 //         { str_colName: 'NomDLB', value: masterData.NomDOLOBO },
  //                 //         { str_colName: 'LwrDLB', value: masterData.NegTolDOLOBO },
  //                 //         { str_colName: 'UppDLB', value: masterData.PosTolDOLOBO },
  //                 //         { str_colName: 'DLBParamName', value: masterData.ColHeadDOLOBO },
  //                 //         { str_colName: 'Side', value: sideVal },
  //                 //         { str_colName: 'BatchCompleted', value: masterData.BatchComplete[0] },
  //                 //         { str_colName: 'IsArchived', value: masterData.IsArchived[0] },
  //                 //         { str_colName: 'LimitOn', value: 0 }
  //                 //     ]
  //                 // }
  //                 // let saveBatchSumm = await database.save(masterDataInsert);
  //                 // masterSrNo = saveBatchSumm[0].insertId;

  //                 const masterDataInsert = await models['tbl_batchsummary_master_hdlb'].create({
  //                     BFGCode: masterData.BFGCode,
  //                     ProductName: masterData.ProductName,
  //                     PVersion: masterData.PVersion,
  //                     Version: masterData.Version,
  //                     PrdType: 1,
  //                     CubType: masterData.CubicleType,
  //                     BatchNo: masterData.BatchNo,
  //                     Stage: masterData.Stage,
  //                     Dept: cubicalObj.Sys_dept,
  //                     NomHard: masterData.NomHard,
  //                     LwrHard: masterData.NegTolHard,
  //                     UppHard: masterData.PosTolHard,
  //                     UnitHard: masterData.Unit,
  //                     NomThick: masterData.NomThick,
  //                     LwrThick: masterData.NegTolThick,
  //                     UppThick: masterData.PosTolThick,
  //                     NomDLB: masterData.NomDOLOBO,
  //                     LwrDLB: masterData.NegTolDOLOBO,
  //                     UppDLB: masterData.PosTolDOLOBO,
  //                     DLBParamName: masterData.ColHeadDOLOBO,
  //                     Side: sideVal,
  //                     BatchCompleted: masterData.BatchComplete[0],
  //                     IsArchived: masterData.IsArchived[0],
  //                     LimitOn: 0
  //                 });
  //                 masterSrNo = masterDataInsert._previousDataValues.RepSerNo;

  //                 const objInsertDetailData = await models['tbl_batchsummary_detail_hdlb'].create({
  //                     RepSerNo: masterSrNo,
  //                     RecSeqNo: recSeqNo,
  //                     Date: masterData.PrDate,
  //                     Time: masterData.PrTime,
  //                     InstrumentID: masterData.HardnessID,
  //                     Side: sideVal,
  //                     MinHard: MinHard,
  //                     MaxHard: MaxHard,
  //                     AvgHard: avgHard,
  //                     MinThick: MinThick,
  //                     MaxThick: MaxThick,
  //                     AvgThick: AvgThick,
  //                     MinDLB: MinDLB,
  //                     MaxDLB: MaxDLB,
  //                     AvgDLB: AvgDLB,
  //                     //MinTimeDT': resultdata.incompleteData.T1PosTol ,
  //                     //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
  //                     TestResult: remark,
  //                     UserID: masterData.UserId,
  //                     UserName: masterData.UserName,
  //                 });

  //                 // const objInsertDetailData = {
  //                 //     str_tableName: 'tbl_batchsummary_detail_hdlb',
  //                 //     data: [
  //                 //         { str_colName: 'RepSerNo', value: masterSrNo },
  //                 //         { str_colName: 'RecSeqNo', value: recSeqNo },
  //                 //         { str_colName: 'Date', value: masterData.PrDate },
  //                 //         { str_colName: 'Time', value: masterData.PrTime },
  //                 //         { str_colName: 'InstrumentID', value: masterData.HardnessID },
  //                 //         { str_colName: 'Side', value: sideVal },
  //                 //         { str_colName: 'MinHard', value: MinHard },
  //                 //         { str_colName: 'MaxHard', value: MaxHard },
  //                 //         { str_colName: 'AvgHard', value: avgHard },
  //                 //         { str_colName: 'MinThick', value: MinThick },
  //                 //         { str_colName: 'MaxThick', value: MaxThick },
  //                 //         { str_colName: 'AvgThick', value: AvgThick },
  //                 //         { str_colName: 'MinDLB', value: MinDLB },
  //                 //         { str_colName: 'MaxDLB', value: MaxDLB },
  //                 //         { str_colName: 'AvgDLB', value: AvgDLB },
  //                 //         // { str_colName: 'MinTimeDT', value: resultdata.incompleteData.T1PosTol },
  //                 //         // { str_colName: 'MaxTimeDT', value: resultdata.incompleteData.T2NegTol },
  //                 //         { str_colName: 'TestResult', value: remark },
  //                 //         { str_colName: 'UserID', value: masterData.UserId },
  //                 //         { str_colName: 'UserName', value: masterData.UserName },

  //                 //     ]
  //                 // }
  //                 // //console.log(objInsertDetailData);
  //                 // let detailResult1 = await database.save(objInsertDetailData);
  //                 Object.assign(responseObj, { status: 'success' })
  //                 return responseObj;

  //             } else {
  //                 masterSrNo = resultData[0].SrNo;
  //                 //     const checkDetailObj = {
  //                 //         str_tableName: detailTable,
  //                 //         data: 'MAX(RecSeqNo) AS SeqNo',
  //                 //         condition: [
  //                 //             { str_colName: 'RepSerNo', value: masterSrNo, comp: 'eq' },
  //                 //         ]
  //                 //     }
  //                 //    let detailres = await database.select(checkDetailObj);
  //                 //         var seqNum = detailres[0][0].SeqNo;
  //                 //         var seqNo = seqNum + 1;
  //                 // const objInsertDetailData = {
  //                 //     str_tableName: 'tbl_batchsummary_detail_hdlb',
  //                 //     data: [
  //                 //         { str_colName: 'RepSerNo', value: masterSrNo },
  //                 //         { str_colName: 'RecSeqNo', value: recSeqNo },
  //                 //         { str_colName: 'Date', value: masterData.PrDate },
  //                 //         { str_colName: 'Time', value: masterData.PrTime },
  //                 //         { str_colName: 'InstrumentID', value: masterData.HardnessID },
  //                 //         { str_colName: 'Side', value: sideVal },
  //                 //         { str_colName: 'MinHard', value: MinHard },
  //                 //         { str_colName: 'MaxHard', value: MaxHard },
  //                 //         { str_colName: 'AvgHard', value: avgHard },
  //                 //         { str_colName: 'MinThick', value: MinThick },
  //                 //         { str_colName: 'MaxThick', value: MaxThick },
  //                 //         { str_colName: 'AvgThick', value: AvgThick },
  //                 //         { str_colName: 'MinDLB', value: MinDLB },
  //                 //         { str_colName: 'MaxDLB', value: MaxDLB },
  //                 //         { str_colName: 'AvgDLB', value: AvgDLB },
  //                 //         // { str_colName: 'MinTimeDT', value: resultdata.incompleteData.T1PosTol },
  //                 //         // { str_colName: 'MaxTimeDT', value: resultdata.incompleteData.T2NegTol },
  //                 //         { str_colName: 'TestResult', value: remark },
  //                 //         { str_colName: 'UserID', value: masterData.UserId },
  //                 //         { str_colName: 'UserName', value: masterData.UserName },
  //                 //     ]
  //                 // }
  //                 // await database.save(objInsertDetailData);

  //                 const objInsertDetailData = await models['tbl_batchsummary_detail_hdlb'].create({
  //                     RepSerNo: masterSrNo,
  //                     RecSeqNo: recSeqNo,
  //                     Date: masterData.PrDate,
  //                     Time: masterData.PrTime,
  //                     InstrumentID: masterData.HardnessID,
  //                     Side: sideVal,
  //                     MinHard: MinHard,
  //                     MaxHard: MaxHard,
  //                     AvgHard: avgHard,
  //                     MinThick: MinThick,
  //                     MaxThick: MaxThick,
  //                     AvgThick: AvgThick,
  //                     MinDLB: MinDLB,
  //                     MaxDLB: MaxDLB,
  //                     AvgDLB: AvgDLB,
  //                     //MinTimeDT: resultdata.incompleteData.T1PosTol ,
  //                     //MaxTimeDT: resultdata.incompleteData.T2NegTol ,
  //                     TestResult: remark,
  //                     UserID: masterData.UserId,
  //                     UserName: masterData.UserName,
  //                 });
  //                 Object.assign(responseObj, { status: 'success', remark: remark });
  //                 return responseObj;
  //             }
  //         }
  //     } catch (error) {
  //         throw new Error(error)
  //     }
  // }

  async calculatefraibSeqNo(
    side,
    masterTableName,
    detailTableName,
    inCompleteData
  ) {
    try {
      let selectedSide;
      if (side == "NA") {
        selectedSide = side;
      } else {
        selectedSide = "LHS";
      }
      let selectDetailData = await models[masterTableName].findAll({
        attributes: [
          [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
        ],
        where: {
          BFGCode: inCompleteData.BFGCode,
          ProductName: inCompleteData.ProductName,
          PVersion: inCompleteData.PVersion,
          Version: inCompleteData.Version,
          BatchNo: inCompleteData.BatchNo,
          Side: selectedSide,
        },
      });
      //  {
      //     str_tableName: masterTableName,
      //     data: 'MAX(RepSerNo) AS RepSerNo',
      //     condition: [
      //       BFGCode: inCompleteData.BFGCode ,
      //       ProductName: inCompleteData.ProductName ,
      //       PVersion: inCompleteData.PVersion ,
      //       Version: inCompleteData.Version ,
      //       BatchNo: inCompleteData.BatchNo ,
      //       Side: selectedSide
      //     ]
      // }
      let selectRes = [selectDetailData];
      if (selectRes[0][0].RepSerNo === null) {
        return 1;
      } else {
        var selectDetail;
        if (detailTableName == "tbl_batchsummary_detail8") {
          selectDetail = await models[detailTableName].findAll({
            attributes: [
              [sequelize.fn("max", sequelize.col("RecSeqNo")), "RepSerNo"],
            ],
            where: {
              RepSerNo: selectRes[0][0].RepSerNo,
              // Side: side
            },
          });
        } else {
          selectDetail = await models[detailTableName].findAll({
            attributes: [
              [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
            ],
            where: {
              RepSerNo: selectRes[0][0].RepSerNo,
              Side: side,
            },
          });
        }
        // {
        //     str_tableName: detailTableName,
        //     data: 'MAX(RecSeqNo) AS RecSeqNo',
        //     condition: [
        //         { str_colName: 'RepSerNo', value: selectRes[0][0].RepSerNo },
        //         { str_colName: 'Side', value: side }
        //     ]
        // }
        let reqSeqRes = [selectDetail];
        if (reqSeqRes[0][0].RepSerNo === null) {
          return 1;
        } else {
          return reqSeqRes[0][0].RepSerNo + 1;
        }
      }
    } catch (error) {
      throw new Error(error);
    }
  }

  // async saveBatchSummaryDT(
  //   InsertIdLHS = 0,
  //   InsertIdRHS = 0,
  //   selectedcubicalObj,
  //   idsNo,
  //   menuname,
  //   objProductDetails,
  //   ALl_data,
  //   result_data
  // ) {
  //   try {
  //     // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == idsNo);
  //     let selectedIds = idsNo;
  //     var result = result_data;
  //     // if (IPQCObject != undefined) {
  //     //     selectedIds = IPQCObject.selectedIds;
  //     // } else {
  //     //     selectedIds = idsNo;
  //     // }
  //     var table;
  //     var data_all = ALl_data;
  //     var detailtable;
  //     var batchtable;
  //     var detaitable;
  //     if (menuname == GLOBAL_NOMENCLATURE.DT) {
  //       table = "tbl_tab_master13";
  //       detaitable = "tbl_tab_detail13";
  //       batchtable = "tbl_batchsummary_master13";
  //       detailtable = "tbl_batchsummary_detail13";
  //     } else if (menuname == GLOBAL_NOMENCLATURE.DTLayer1Menu) {
  //       table = "tbl_tab_master19";
  //       detaitable = "tbl_tab_detail19";
  //       detailtable = "tbl_batchsummary_detail19";
  //       batchtable = "tbl_batchsummary_master19";
  //     } else {
  //       table = "tbl_tab_master20";
  //       detaitable = "tbl_tab_detail20";
  //       detailtable = "tbl_batchsummary_detail20";
  //       batchtable = "tbl_batchsummary_master20";
  //     }
  //     let cubicalObj = selectedcubicalObj;
  //     //if (((cubicalObj.Sys_RptTyp0e == 0) && (cubicalObj.Sys_Validation == 0) && (cubicalObj.Sys_CubType == 'Compression') || (cubicalObj.Sys_CubType == 'Coating') || (cubicalObj.Sys_CubType == 'Capsule Filling'))) {
  //     if (
  //       cubicalObj.Sys_RptType == 0 &&
  //       cubicalObj.Sys_Validation == 0 &&
  //       cubicalObj.Sys_CubType != "IPQA" &&
  //       cubicalObj.Sys_CubType != "IPQC"
  //     ) {
  //       /**
  //        * SELECT MAX(`DT_RunTime`) AS 'Max', MIN(`DT_RunTime`) AS 'Min', TIME_FORMAT(SEC_TO_TIME(AVG(HOUR(`DT_RunTime`) * 3600 +
  //        *(MINUTE(`DT_RunTime`) * 60) + SECOND(`DT_RunTime`))),'%H:%i:%s') AS 'Avg' FROM `tbl_tab_detail13` WHERE `RepSerNo`=1
  //        */
  //       // let res = await proObj.productData(selectedcubicalObj);

  //       let res = globalData.arrProductTypeArray.find(
  //         (k) => k.Hmi == selectedIds
  //       ).productType;
  //       let res1 = globalData.arrProductTypeArray.find(
  //         (k) => k.Hmi == selectedIds
  //       ).productDetail;
  //       res1 = res1[0][0];
  //       var masterResult;
  //       var ProductType = res.ProductType;
  //       // var tblMstName = ProductType == 1 ? 'tbl_tab_master13' : 'tbl_cap_master6'
  //       // var tblDetName = ProductType == 1 ? 'tbl_tab_detail13' : 'tbl_cap_detail6'

  //       // if (selectedcubicalObj.Sys_RotaryType == 'Double') {
  //       //masterResult = await database.execute(`SELECT * FROM tbl_tab_master13 WHERE RepSerNo = '${InsertIdLHS}' OR RepSerNo = '${InsertIdRHS}'`);
  //       // masterResult = await sequelize.query(`SELECT * FROM ${table} WHERE RepSerNo = '${InsertIdLHS}' OR RepSerNo = '${InsertIdRHS}'`);
  //       // } else {
  //       //masterResult = await dbCon.execute(`SELECT * FROM tbl_tab_master13 WHERE RepSerNo = '${InsertIdLHS}'`);
  //       masterResult = await sequelize.query(
  //         `SELECT * FROM ${table} WHERE RepSerNo = '${InsertIdLHS}'`
  //       );
  //       // }
  //       if (masterResult[0].length != 0) {
  //         for (let obj of masterResult[0]) {
  //           //         let detailResult = await dbCon.execute(`SELECT MAX(DT_RunTime) AS 'Max', MIN(DT_RunTime) AS 'Min', TIME_FORMAT(SEC_TO_TIME(AVG(HOUR(DT_RunTime) * 3600 +
  //           // (MINUTE(DT_RunTime) * 60) + SECOND(DT_RunTime))),'%H:%i:%s') AS 'Avg' FROM tbl_tab_detail13 WHERE RepSerNo='${obj.RepSerNo}'`);
  //           let detailResult =
  //             await sequelize.query(`SELECT  MAX(DT_RunTime) AS 'Max', 
  //                       MIN(DT_RunTime) AS 'Min', 
  //                       CONVERT(varchar(8), DATEADD(second, AVG(DATEDIFF(second, '00:00:00', DT_RunTime)), '00:00:00'), 108) AS 'Avg'
  //                        FROM ${detaitable} WHERE RepSerNo='${obj.RepSerNo}'`);

  //           let side = "NA";
  //           if (selectedcubicalObj.Sys_RotaryType == "Single") {
  //             side = "NA";
  //           } else {
  //             if (obj.Side == "NA") {
  //               side = "NA";
  //             } else if (obj.Side == "LHS") {
  //               side = "LEFT";
  //             } else {
  //               side = "RIGHT";
  //             }
  //           }

  //           // var result = 'Compiles';
  //           /**
  //                        * @description Comparing DT std time and max time
  //                        * var startTime = "01:00:00";
  //                           var endTime = "01:00:00";
  //                           var regExp = /(\d{1,2})\:(\d{1,2})\:(\d{1,2})/;
  //                           if(parseInt(endTime .replace(regExp, "$1$2$3")) > parseInt(startTime .replace(regExp, "$1$2$3"))){
  //                           console.log('true')
  //                           } else {
  //                           console.log('false')
  //                           }
  //                        */
  //           var regExp = /(\d{1,2})\:(\d{1,2})\:(\d{1,2})/;
  //           var stdTime = ProductType == 1 ? res1.Param13_Nom : res1.Param6_Nom;
  //           var maxTime = detailResult[0][0].Max;
  //           // if (parseInt(maxTime.replace(regExp, "$1$2$3")) > parseInt(stdTime.replace(regExp, "$1$2$3"))) {
  //           //     result = 'Not Complies';
  //           // } else {
  //           //     result = 'Complies';
  //           // }
  //           let checkSideMasterTable;
  //           if (selectedcubicalObj.Sys_RotaryType != "Double") {
  //             checkSideMasterTable = "NA";
  //           } else {
  //             checkSideMasterTable = "LEFT";
  //           }

  //           const checkMasterObj = await models[batchtable].findAll({
  //             attributes: [
  //               [sequelize.fn("max", sequelize.col("RepSerNo")), "SrNo"],
  //             ],
  //             where: {
  //               BFGCode: selectedcubicalObj.Sys_BFGCode,

  //               ProductName: selectedcubicalObj.Sys_ProductName,

  //               PVersion: selectedcubicalObj.Sys_PVersion,

  //               Version: selectedcubicalObj.Sys_Version,

  //               CubicleType: obj.CubicleType,

  //               Side: checkSideMasterTable,

  //               BatchNo: obj.BatchNo,
  //             },
  //           });
  //           let resultData = checkMasterObj;
  //           let incompleteData = {
  //             BFGCode: obj.BFGCode,
  //             ProductName: obj.ProductName,
  //             PVersion: obj.PVersion,
  //             Version: obj.Version,
  //             BatchNo: obj.BatchNo,
  //           };
  //           var detailData;
  //           let recSeqNo = await this.calculateDTSeqNo(
  //             side,
  //             batchtable,
  //             detailtable,
  //             incompleteData
  //           );
  //           obj.PrTime = moment(obj.PrTime).format("HH:mm:ss");
  //           if (resultData[0].SrNo == null) {
  //             let masterData = await models[batchtable].create({
  //               BFGCode: obj.BFGCode,
  //               ProductName: obj.ProductName,
  //               PVersion: obj.PVersion,
  //               Version: obj.Version,
  //               PrdType: obj.ProductType,
  //               CubicleType: obj.CubicleType,
  //               BatchNo: obj.BatchNo,
  //               Nom: objProductDetails.nominal,
  //               Stage: selectedcubicalObj.Sys_Stage,
  //               Dept: selectedcubicalObj.Sys_dept,
  //               Tol1Neg: objProductDetails.T1Neg, //; res[1].Param13_T1Neg,
  //               Tol1Pos: objProductDetails.T1Pos, //res[1].Param13_T1Pos,
  //               StdTime: objProductDetails.nominal, //res[1].Param13_Nom,
  //               Side: checkSideMasterTable,
  //               BatchCompleted: 0,
  //               IsArchived: 0,
  //               Area: selectedcubicalObj.Sys_Area,
  //               GenericName: cubicalObj.Sys_GenericName,
  //               BMRNo: cubicalObj.Sys_BMRNo,
  //               // 'Stage': cubicalObj.Sys_Stage,
  //               BatchSize: `${cubicalObj.Sys_BatchSize}`,
  //               TempRange:
  //                 objProductDetails.T1Neg + "-" + objProductDetails.T1Pos,
  //               ReportType: 0,

  //               // "NMT": ProductType == 1 ? res1.Param13_Nom : res1.Param6_Nom
  //             });
  //             let masterBatchSummary = masterData;
  //             var masterSrNo = masterBatchSummary.RepSerNo;

  //             if (selectedcubicalObj.Sys_RotaryType == "Double") {
  //               if (data_all.side == "A") {
  //                 detailData = await models[detailtable].create({
  //                   RepSerNo: masterSrNo,
  //                   RecSeqNo: recSeqNo,
  //                   Date: obj.PrDate,
  //                   Time: obj.PrTime,
  //                   //'InstrumentID': cubicalObj.Sys_DTID ,
  //                   InstrumentID: obj.InstrumentID,
  //                   Side: "LEFT",
  //                   MinTimeDT: data_all.JarA.DT_MinVal,
  //                   MaxTimeDT: data_all.JarA.DT_MaxVal,
  //                   AvgTimeDT: detailResult[0][0].Avg,
  //                   TestResult: result,
  //                   UserID: obj.UserId,
  //                   UserName: obj.UserName,
  //                 });
  //               } else {
  //                 recSeqNo = recSeqNo - 1;
  //                 detailData = await models[detailtable].create({
  //                   RepSerNo: masterSrNo,
  //                   RecSeqNo: recSeqNo,
  //                   Date: obj.PrDate,
  //                   Time: obj.PrTime,
  //                   //'InstrumentID': cubicalObj.Sys_DTID ,
  //                   InstrumentID: obj.InstrumentID,
  //                   Side: "RIGHT",
  //                   MinTimeDT: data_all.JarB.DT_MinVal,
  //                   MaxTimeDT: data_all.JarB.DT_MaxVal,
  //                   AvgTimeDT: detailResult[0][0].Avg,
  //                   TestResult: result,
  //                   UserID: obj.UserId,
  //                   UserName: obj.UserName,
  //                 });
  //               }
  //             } else {
  //               if (data_all.side == "A") {
  //                 detailData = await models[detailtable].create({
  //                   RepSerNo: masterSrNo,
  //                   RecSeqNo: recSeqNo,
  //                   Date: obj.PrDate,
  //                   Time: obj.PrTime,
  //                   //'InstrumentID': cubicalObj.Sys_DTID ,
  //                   InstrumentID: obj.InstrumentID,
  //                   Side: "NA",
  //                   MinTimeDT: data_all.JarA.DT_MinVal,
  //                   MaxTimeDT: data_all.JarA.DT_MaxVal,
  //                   AvgTimeDT: detailResult[0][0].Avg,
  //                   TestResult: result,
  //                   UserID: obj.UserId,
  //                   UserName: obj.UserName,
  //                 });
  //               } else {
  //                 detailData = await models[detailtable].create({
  //                   RepSerNo: masterSrNo,
  //                   RecSeqNo: recSeqNo,
  //                   Date: obj.PrDate,
  //                   Time: obj.PrTime,
  //                   //'InstrumentID': cubicalObj.Sys_DTID ,
  //                   InstrumentID: obj.InstrumentID,
  //                   Side: "NA",
  //                   MinTimeDT: data_all.JarB.DT_MinVal,
  //                   MaxTimeDT: data_all.JarB.DT_MaxVal,
  //                   AvgTimeDT: detailResult[0][0].Avg,
  //                   TestResult: result,
  //                   UserID: obj.UserId,
  //                   UserName: obj.UserName,
  //                 });
  //               }
  //             }
  //           } else {
  //             var masterSrNo = resultData[0].SrNo;
  //             // if (selectedcubicalObj.Sys_RotaryType == 'Double') {

  //             //      detailData = await models[detailtable].create({
  //             //         'RepSerNo': masterSrNo,
  //             //         'RecSeqNo': recSeqNo,
  //             //         'Date': obj.PrDate,
  //             //         'Time': obj.PrTime,
  //             //         //'InstrumentID': cubicalObj.Sys_DTID ,
  //             //         'InstrumentID': obj.InstrumentID,
  //             //         'Side': 'LEFT',
  //             //         'MinTimeDT': data_all.JarA.DT_MinVal,
  //             //         'MaxTimeDT': data_all.JarA.DT_MaxVal,
  //             //         'AvgTimeDT': detailResult[0][0].Avg,
  //             //         'TestResult': result,
  //             //         'UserID': obj.UserId,
  //             //         'UserName': obj.UserName
  //             //     });
  //             //      detailData = await models[detailtable].create({
  //             //         'RepSerNo': masterSrNo,
  //             //         'RecSeqNo': recSeqNo,
  //             //         'Date': obj.PrDate,
  //             //         'Time': obj.PrTime,
  //             //         //'InstrumentID': cubicalObj.Sys_DTID ,
  //             //         'InstrumentID': obj.InstrumentID,
  //             //         'Side': 'RIGHT',
  //             //         'MinTimeDT': data_all.JarB.DT_MinVal,
  //             //         'MaxTimeDT': data_all.JarB.DT_MaxVal,
  //             //         'AvgTimeDT': detailResult[0][0].Avg,
  //             //         'TestResult': result,
  //             //         'UserID': obj.UserId,
  //             //         'UserName': obj.UserName
  //             //     });
  //             // }else {

  //             if (selectedcubicalObj.Sys_RotaryType == "Double") {
  //               if (data_all.side == "A") {
  //                 detailData = await models[detailtable].create({
  //                   RepSerNo: masterSrNo,
  //                   RecSeqNo: recSeqNo,
  //                   Date: obj.PrDate,
  //                   Time: obj.PrTime,
  //                   //'InstrumentID': cubicalObj.Sys_DTID ,
  //                   InstrumentID: obj.InstrumentID,
  //                   Side: "LEFT",
  //                   MinTimeDT: data_all.JarA.DT_MinVal,
  //                   MaxTimeDT: data_all.JarA.DT_MaxVal,
  //                   AvgTimeDT: detailResult[0][0].Avg,
  //                   TestResult: result,
  //                   UserID: obj.UserId,
  //                   UserName: obj.UserName,
  //                 });
  //               } else {
  //                 recSeqNo = recSeqNo - 1;
  //                 detailData = await models[detailtable].create({
  //                   RepSerNo: masterSrNo,
  //                   RecSeqNo: recSeqNo,
  //                   Date: obj.PrDate,
  //                   Time: obj.PrTime,
  //                   //'InstrumentID': cubicalObj.Sys_DTID ,
  //                   InstrumentID: obj.InstrumentID,
  //                   Side: "RIGHT",
  //                   MinTimeDT: data_all.JarB.DT_MinVal,
  //                   MaxTimeDT: data_all.JarB.DT_MaxVal,
  //                   AvgTimeDT: detailResult[0][0].Avg,
  //                   TestResult: result,
  //                   UserID: obj.UserId,
  //                   UserName: obj.UserName,
  //                 });
  //               }
  //             } else {
  //               if (data_all.side == "A") {
  //                 detailData = await models[detailtable].create({
  //                   RepSerNo: masterSrNo,
  //                   RecSeqNo: recSeqNo,
  //                   Date: obj.PrDate,
  //                   Time: obj.PrTime,
  //                   //'InstrumentID': cubicalObj.Sys_DTID ,
  //                   InstrumentID: obj.InstrumentID,
  //                   Side: "NA",
  //                   MinTimeDT: data_all.JarA.DT_MinVal,
  //                   MaxTimeDT: data_all.JarA.DT_MaxVal,
  //                   AvgTimeDT: detailResult[0][0].Avg,
  //                   TestResult: result,
  //                   UserID: obj.UserId,
  //                   UserName: obj.UserName,
  //                 });
  //               } else {
  //                 detailData = await models[detailtable].create({
  //                   RepSerNo: masterSrNo,
  //                   RecSeqNo: recSeqNo,
  //                   Date: obj.PrDate,
  //                   Time: obj.PrTime,
  //                   //'InstrumentID': cubicalObj.Sys_DTID ,
  //                   InstrumentID: obj.InstrumentID,
  //                   Side: "NA",
  //                   MinTimeDT: data_all.JarB.DT_MinVal,
  //                   MaxTimeDT: data_all.JarB.DT_MaxVal,
  //                   AvgTimeDT: detailResult[0][0].Avg,
  //                   TestResult: result,
  //                   UserID: obj.UserId,
  //                   UserName: obj.UserName,
  //                 });
  //               }
  //               // }
  //             }
  //           }
  //           let completeUpdate =
  //             await sequelize.query(`SELECT  MAX(MaxTimeDT) AS 'Max', 
  //       MIN(MinTimeDT) AS 'Min', 
  //       CONVERT(varchar(12), DATEADD(SECOND, AVG(DATEDIFF(SECOND, '00:00:00', AvgTimeDT)), '00:00:00'), 108) AS 'Avg'
  //        FROM ${detailtable} WHERE RepSerNo='${masterSrNo}'`);
  //           if (result == "Complies") {
  //             let masterData = await models[batchtable].update(
  //               {
  //                 FinalMinDT: moment(completeUpdate[0][0].Min).format(
  //                   "HH:mm:ss"
  //                 ),
  //                 FinalMaxDT: moment(completeUpdate[0][0].Max).format(
  //                   "HH:mm:ss"
  //                 ),
  //                 FinalAvgDT: completeUpdate[0][0].Avg,
  //               },
  //               {
  //                 where: {
  //                   RepSerNo: masterSrNo,
  //                 },
  //               }
  //             );
  //           }
  //           return;
  //         }
  //       }
  //     }
  //   } catch (error) {
  //     throw new Error(error);
  //   }
  // }

  async saveBatchSummaryDT(InsertIdLHS = 0, InsertIdRHS = 0, selectedcubicalObj, idsNo) {
    try {
      // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == idsNo);
      let selectedIds = idsNo;
      // if (IPQCObject != undefined) {
      //     selectedIds = IPQCObject.selectedIds;
      // } else {
      //     selectedIds = idsNo;
      // }

      let cubicalObj = selectedcubicalObj
      //if (((cubicalObj.Sys_RptTyp0e == 0) && (cubicalObj.Sys_Validation == 0) && (cubicalObj.Sys_CubType == 'Compression') || (cubicalObj.Sys_CubType == 'Coating') || (cubicalObj.Sys_CubType == 'Capsule Filling'))) {
      if ((cubicalObj.Sys_RptType == 0) && (cubicalObj.Sys_Validation == 0) && (cubicalObj.Sys_BatchReuse == 0)
        && (cubicalObj.Sys_CubType != 'IPQA') && (cubicalObj.Sys_CubType != 'IPQC')) {

        /**
         * SELECT MAX(`DT_RunTime`) AS 'Max', MIN(`DT_RunTime`) AS 'Min', TIME_FORMAT(SEC_TO_TIME(AVG(HOUR(`DT_RunTime`) * 3600 +
         *(MINUTE(`DT_RunTime`) * 60) + SECOND(`DT_RunTime`))),'%H:%i:%s') AS 'Avg' FROM `tbl_tab_detail13` WHERE `RepSerNo`=1
         */
        // let res = await proObj.productData(selectedcubicalObj);

        let res = globalData.arrProductTypeArray.find(k => k.Hmi == selectedIds).productType;
        let res1 = globalData.arrProductTypeArray.find(k => k.Hmi == selectedIds).productDetail;
        res1 = res1[0][0]
        var masterResult;
        var ProductType = res.ProductType
        var tblMstName = ProductType == 1 ? 'tbl_tab_master13' : 'tbl_cap_master6'
        var tblDetName = ProductType == 1 ? 'tbl_tab_detail13' : 'tbl_cap_detail6'

        if (selectedcubicalObj.Sys_RotaryType == 'Double') {
          //masterResult = await database.execute(`SELECT * FROM tbl_tab_master13 WHERE RepSerNo = '${InsertIdLHS}' OR RepSerNo = '${InsertIdRHS}'`);
          masterResult = await sequelize.query(`SELECT * FROM ${tblMstName} WHERE RepSerNo = '${InsertIdLHS}' OR RepSerNo = '${InsertIdRHS}'`);
        } else {
          //masterResult = await dbCon.execute(`SELECT * FROM tbl_tab_master13 WHERE RepSerNo = '${InsertIdLHS}'`);
          masterResult = await sequelize.query(`SELECT * FROM ${tblMstName} WHERE RepSerNo = '${InsertIdLHS}'`);
        }
        if (masterResult[0].length != 0) {
          for (let obj of masterResult[0]) {
            //         let detailResult = await dbCon.execute(`SELECT MAX(DT_RunTime) AS 'Max', MIN(DT_RunTime) AS 'Min', TIME_FORMAT(SEC_TO_TIME(AVG(HOUR(DT_RunTime) * 3600 +
            // (MINUTE(DT_RunTime) * 60) + SECOND(DT_RunTime))),'%H:%i:%s') AS 'Avg' FROM tbl_tab_detail13 WHERE RepSerNo='${obj.RepSerNo}'`);

            // let detailResult = await sequelize.query(`SELECT MAX(DT_MaxVal) AS 'Max', MIN(DT_MinVal) AS 'Min', TIME_FORMAT(SEC_TO_TIME(AVG(HOUR(DT_RunTime) * 3600 +
            // (MINUTE(DT_MaxVal) * 60) + SECOND(DT_MinVal))),'%H:%i:%s') AS 'Avg' FROM ${tblDetName} WHERE RepSerNo='${obj.RepSerNo}'`);

            let detailResult = await sequelize.query(`SELECT  MAX(DT_RunTime) AS 'Max', 
                        MIN(DT_RunTime) AS 'Min', MAX(DT_Temp) AS 'MaxTemp', 
                        MIN(DT_Temp) AS 'MinTemp',
                        CONVERT(varchar(8), DATEADD(second, AVG(DATEDIFF(second, '00:00:00', DT_RunTime)), '00:00:00'), 108) AS 'Avg'
                         FROM ${tblDetName} WHERE RepSerNo='${obj.RepSerNo}'`);

            let side = 'NA';
            if (selectedcubicalObj.Sys_RotaryType == 'Single') {
              side = 'NA';
            } else {
              if (obj.Side == 'NA') {
                side = 'NA';
              } else if (obj.Side == 'LHS') {
                side = 'LHS';
              } else {
                side = 'RHS';
              }
            }

            var result = 'Compiles';
            /**
             * @description Comparing DT std time and max time
             * var startTime = "01:00:00";
                var endTime = "01:00:00";
                var regExp = /(\d{1,2})\:(\d{1,2})\:(\d{1,2})/;
                if(parseInt(endTime .replace(regExp, "$1$2$3")) > parseInt(startTime .replace(regExp, "$1$2$3"))){
                console.log('true')
                } else {
                console.log('false')
                }
             */
            var regExp = /(\d{1,2})\:(\d{1,2})\:(\d{1,2})/;
            var stdTime = ProductType == 1 ? res1.Param13_Nom : res1.Param6_Nom;
            var PosTemp = ProductType == 1 ? res1.Param13_T1Pos : res1.Param6_T1Pos;
            var NegTemp = ProductType == 1 ? res1.Param13_T1Neg : res1.Param6_T1Neg;
            var maxTime = detailResult[0][0].Max;
            var maxTemp = masterResult[0][0].MaxTemp
            var minTemp = masterResult[0][0].MinTemp;
            var setTemp = masterResult[0][0].Media_Temp;
            // if (parseInt(maxTime.replace(regExp, "$1$2$3")) > parseInt(stdTime.replace(regExp, "$1$2$3")) ||
            //   ((maxTemp > PosTemp) || (minTemp < NegTemp)) ||
            //   ((setTemp > PosTemp) || (setTemp < NegTemp)))
            if (parseInt(maxTime.replace(regExp, "$1$2$3")) > parseInt(stdTime.replace(regExp, "$1$2$3")) || ((maxTemp > PosTemp) || (minTemp < NegTemp))) {
              result = 'Not Complies';
            } else {
              result = 'Complies';
            }
            let checkSideMasterTable;
            if (selectedcubicalObj.Sys_RotaryType != 'Double') {
              checkSideMasterTable = 'NA';
            } else {
              checkSideMasterTable = 'LHS';

            }
            const checkMasterObj = await models.tbl_batchsummary_master13.findAll({
              attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
              where: {

                'BFGCode'
                  : selectedcubicalObj.Sys_BFGCode,

                'ProductName'
                  : selectedcubicalObj.Sys_ProductName,

                'PVersion'
                  : selectedcubicalObj.Sys_PVersion,

                'Version'
                  : selectedcubicalObj.Sys_Version,

                'CubicleType'
                  : obj.CubicleType,

                'Side'
                  : checkSideMasterTable,

                'BatchNo'
                  : obj.BatchNo,
              }

            });
            let resultData = checkMasterObj;
            // const checkMasterObj = {
            //     str_tableName: 'tbl_batchsummary_master13',
            //     data: 'MAX(RepSerNo) AS SrNo',
            //     condition: [
            //         { str_colName: 'BFGCode
            //         { str_colName: 'ProductName', value: selectedcubicalObj.Sys_ProductName, comp: 'eq' },
            //         { str_colName: 'PVersion', value: selectedcubicalObj.Sys_PVersion, comp: 'eq' },
            //         { str_colName: 'Version', value: selectedcubicalObj.Sys_Version, comp: 'eq' },
            //         { str_colName: 'CubType', value: obj.CubicleType, comp: 'eq' },
            //         { str_colName: 'Side', value: checkSideMasterTable, comp: 'eq' },
            //         { str_colName: 'BatchNo', value: obj.BatchNo, comp: 'eq' },
            //     ]
            // }
            // let resultData = await database.select(checkMasterObj);
            let incompleteData = {
              BFGCode: obj.BFGCode,
              ProductName: obj.ProductName,
              PVersion: obj.PVersion,
              Version: obj.Version,
              BatchNo: obj.BatchNo
            }
            let recSeqNo = await this.calculateSeqNo(side, 'tbl_batchsummary_master13', 'tbl_batchsummary_detail13', incompleteData);
            if (resultData[0].RepSerNo == null) {
              let masterData = await models.tbl_batchsummary_master13.create({

                'BFGCode': obj.BFGCode,
                'ProductName': obj.ProductName,
                'PVersion': obj.PVersion,
                'Version': obj.Version,
                'PrdType': obj.ProductType,
                'CubicleType': obj.CubicleType,
                'BatchNo': obj.BatchNo,
                'Stage': selectedcubicalObj.Sys_Stage,
                'Department': selectedcubicalObj.Sys_dept,
                "TempRange": obj.T1NegTol + " - " + obj.T1PosTol,
                // "Stages":"",
                "StdTime": obj.Nom,
                'Tol1Neg': obj.T1NegTol,//; res[1].Param13_T1Neg,
                'Tol1Pos': obj.T1PosTol,//res[1].Param13_T1Pos,
                'DTStdTime': ProductType == 1 ? res1.Param13_Nom : res1.Param6_Nom,//res[1].Param13_Nom,
                'Side': checkSideMasterTable,
                'BatchCompleted': 0,
                'IsArchived': 0,
                'Area': selectedcubicalObj.Sys_Area,
                'GenericName': cubicalObj.Sys_GenericName,
                'BMRNo': cubicalObj.Sys_BMRNo,
                'BatchSize': `${cubicalObj.Sys_BatchSize}`,
                'ReportType': 0,

              });
              // let masterData = {
              //     str_tableName: 'tbl_batchsummary_master13',
              //     data: [
              //         { str_colName: 'BFGCode': obj.BFGCode },
              //         { str_colName: 'ProductName': obj.ProductName },
              //         { str_colName: 'PVersion': obj.PVersion },
              //         { str_colName: 'Version': obj.Version },
              //         { str_colName: 'PrdType', value: obj.ProductType },
              //         { str_colName: 'CubType', value: obj.CubicleType },
              //         { str_colName: 'BatchNo', value: obj.BatchNo },
              //         { str_colName: 'Stage', value: selectedcubicalObj.Sys_Stage },
              //         { str_colName: 'Dept', value: selectedcubicalObj.Sys_dept },
              //         { str_colName: 'Tol1Neg', value: ProductType == 1 ? res1.Param6_T1Neg : res1.Param6_T1Neg },//; res[1].Param13_T1Neg },
              //         { str_colName: 'Tol1Pos', value: ProductType == 1 ? res1.Param13_T1Pos : res1.Param6_T1Pos },//res[1].Param13_T1Pos },
              //         { str_colName: 'DTStdTime', value: ProductType == 1 ? res1.Param13_Nom : res1.Param6_Nom },//res[1].Param13_Nom },
              //         { str_colName: 'Side', value: checkSideMasterTable },
              //         { str_colName: 'BatchCompleted', value: 0 },
              //         { str_colName: 'IsArchived', value: 0 },
              //         { str_colName: 'Area', value: selectedcubicalObj.Sys_Area },
              //         { str_colName: 'GenericName', value: cubicalObj.Sys_GenericName },
              //         { str_colName: 'BMRNo', value: cubicalObj.Sys_BMRNo },+
              //         { str_colName: 'BatchSize', value: `${cubicalObj.Sys_BatchSize} ${cubicalObj.Sys_BatchSizeUnit}` },
              //         { str_colName: 'ReportType', value: 0 },
              //     ]
              // }
              let masterBatchSummary = masterData;
              var masterSrNo = masterBatchSummary.RepSerNo;
              let detailData = await models.tbl_batchsummary_detail13.create({
                'RepSerNo': masterSrNo,
                'RecSeqNo': recSeqNo,
                'Date': obj.PrDate,
                'Time': moment(obj.PrTime).format("HH:mm:ss"),
                //'InstrumentID': cubicalObj.Sys_DTID ,
                'InstrumentID': obj.InstrumentID,
                'Side': side,
                'MinTimeDT': detailResult[0][0].Min,
                'MaxTimeDT': detailResult[0][0].Max,
                'AvgTimeDT': detailResult[0][0].Avg,
                'TestResult': result,
                'UserID': obj.UserId,
                'UserName': obj.UserName
              });

            } else {
              var masterSrNo = resultData[0].RepSerNo;

              let detailData = await models.tbl_batchsummary_detail13.create({
                'RepSerNo': masterSrNo,
                'RecSeqNo': recSeqNo,
                'Date': obj.PrDate,
                'Time': moment(obj.PrTime).format("HH:mm:ss"),
                //'InstrumentID': cubicalObj.Sys_DTID ,
                'InstrumentID': obj.InstrumentID,
                'Side': side,
                'MinTimeDT': detailResult[0][0].Min,
                'MaxTimeDT': detailResult[0][0].Max,
                'AvgTimeDT': detailResult[0][0].Avg,
                'TestResult': result,
                'UserID': obj.UserId,
                'UserName': obj.UserName
              });
              // let detailData = {
              //     str_tableName: 'tbl_batchsummary_detail13',
              //     data: [
              //         { str_colName: 'RepSerNo', value: masterSrNo },
              //         { str_colName: 'RecSeqNo', value: recSeqNo },
              //         { str_colName: 'Date', value: obj.PrDate },
              //         { str_colName: 'Time', value: obj.PrTime },
              //         { str_colName: 'InstrumentID', value: obj.DTID },
              //         { str_colName: 'Side', value: side },
              //         { str_colName: 'MinTimeDT', value: detailResult[0][0].Min },
              //         { str_colName: 'MaxTimeDT', value: detailResult[0][0].Max },
              //         { str_colName: 'AvgTimeDT', value: detailResult[0][0].Avg },
              //         { str_colName: 'TestResult', value: result },
              //         { str_colName: 'UserID', value: obj.UserId },
              //         { str_colName: 'UserName', value: obj.UserName }
              //     ]
              // }
              // await database.save(detailData);

            }

            var batchdetail = "tbl_batchsummary_detail13";
            let completeUpdate = await sequelize.query(`SELECT  MAX(MaxTimeDT) AS 'Max',MIN(MinTimeDT) AS 'Min',
            CONVERT(varchar(12), DATEADD(SECOND, AVG(DATEDIFF(SECOND, '00:00:00', AvgTimeDT)), '00:00:00'), 108) 
            AS 'Avg'FROM ${batchdetail} WHERE RepSerNo='${masterSrNo}' AND TestResult ='Complies'`);
            if (result == 'Complies') {
              let masterData = await models.tbl_batchsummary_master13.update({
                FinalMinDT: moment(completeUpdate[0][0].Min).format('HH:mm:ss'),
                FinalMaxDT: moment(completeUpdate[0][0].Max).format('HH:mm:ss'),
                FinalAvgDT: completeUpdate[0][0].Avg,
                // Remark: "Within Limit"
              }, {
                where: {
                  'RepSerNo': masterSrNo,
                }
              })
            }
            return
          }
        }
      }
    } catch (error) {
      throw new Error(error)
    }

  }

  async saveBatchSummaryFriability(
    masterData,
    idsNo,
    FriabilityDetail1,
    dataObj
  ) {
    try {
      var now = new Date();
      let responseObj = {};
      //var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == idsNo);
      var selectedIds = idsNo;
      // if (IPQCObject != undefined) {
      //     selectedIds = IPQCObject.selectedIds;
      // } else {
      //     selectedIds = idsNo;
      // }
      var remark = masterData.remark1;

      let avgDp = 3;

      var friab_data = dataObj;
      let strfraibModel = await this.CheckfriabModel(selectedIds);
      var cubicalObj = globalData.arrIdsInfo.find(
        (k) => k.idsNo == selectedIds
      ).cubicalData;
      //var tempLimObj = globalData.arr_limits.find(k => k.idsNo == idsNo);
      if (
        (cubicalObj.Sys_RptType == 0 &&
          cubicalObj.Sys_Validation == 0 &&
          cubicalObj.Sys_BatchReuse == 0 &&
          cubicalObj.Sys_CubType == "Compression") ||
        (cubicalObj.Sys_CubType == "Coating" && cubicalObj.Sys_CubType != "Compression")
      ) {
        let result = "Complies";
        let sideVal = "NA";
        if (masterData.Side == "Double") {
          sideVal = "LHS";
        } else {
          sideVal = "NA";
        }

        const checkMasterObj = await models.tbl_batchsummary_master8.findAll({
          attributes: [
            [sequelize.fn("max", sequelize.col("RepSerNo")), "SrNo"],
          ],
          where: {
            BFGCode: masterData.BFGCode,
            ProductName: masterData.ProductName,
            PVersion: masterData.PVersion,
            Version: masterData.Version,
            Side: sideVal,
            CubicleType: cubicalObj.Sys_CubType,
            BatchNo: masterData.BatchNo,
          },
        });
        // {
        //     str_tableName: 'tbl_batchsummary_master8',
        //     data: 'MAX(RepSerNo) AS SrNo',
        //     condition: [
        //         { str_colName: 'BFGCode', value: masterData.BFGCode, comp: 'eq' },
        //         { str_colName: 'ProductName', value: masterData.ProductName, comp: 'eq' },
        //         { str_colName: 'PVersion', value: masterData.PVersion, comp: 'eq' },
        //         { str_colName: 'Version', value: masterData.Version, comp: 'eq' },
        //         { str_colName: 'Side', value: sideVal, comp: 'eq' },
        //         { str_colName: 'CubType', value: cubicalObj.Sys_CubType, comp: 'eq' },
        //         { str_colName: 'BatchNo', value: masterData.BatchNo, comp: 'eq' },
        //     ]
        // }
        var masterSrNo;
        let resultData = checkMasterObj;
        let recSeqNo = await this.calculatefraibSeqNo(
          sideVal,
          "tbl_batchsummary_master8",
          "tbl_batchsummary_detail8",
          masterData
        );
        // let ProdRes = await proObj.productData(cubicalObj);
        // let ProdRes = globalData.arrProductTypeArray.find(k => k.idsNo == selectedIds).productType;

        if (resultData[0].SrNo == null) {
          let masterDataInsert = await models.tbl_batchsummary_master8.create({
            BFGCode: masterData.BFGCode,
            Area: masterData.CubType,
            ProductName: masterData.ProductName,
            PVersion: masterData.PVersion,
            // Make: strfraibModel.Eqp_Make,
            // ModelNo: strfraibModel.Eqp_Model,
            StartDate: moment().format('YYYY-MM-DD'),
            EndDate: moment().format('YYYY-MM-DD'),
            Stage: cubicalObj.Sys_Stage,
            CubicalNo: masterData.CubicalNo,
            Version: masterData.Version,
            PrdType: 1,
            CubicleType: masterData.CubType,
            BatchNo: masterData.BatchNo,
            // 'Unit': masterData.Unit,
            Department: masterData.Dept,
            Nom: masterData.Nom,
            Tol1Neg: masterData.Tol1Neg,
            Tol1Pos: masterData.Tol1Pos,
            BatchSize: masterData.BatchSize,
            Side: sideVal,
            ReportType: 0,
            BatchCompleted: 0,
            IsArchived: 0,
          });
          //  {
          //     str_tableName: 'tbl_batchsummary_master8',
          //     data: [
          //         { str_colName: 'BFGCode', value: masterData.BFGCode },
          //         { str_colName: 'ProductName', value: masterData.ProductName },
          //         { str_colName: 'PVersion', value: masterData.PVersion },
          //         { str_colName: 'Version', value: masterData.Version },
          //         { str_colName: 'PrdType', value: 1 },
          //         { str_colName: 'CubType', value: masterData.CubType },
          //         { str_colName: 'BatchNo', value: masterData.BatchNo },
          //         { str_colName: 'Unit', value: masterData.Unit },
          //         { str_colName: 'Dept', value: masterData.Dept },
          //         { str_colName: 'Nom', value: masterData.Nom },
          //         // { str_colName: 'LwrHard', value: masterData.NegTolHard },
          //         // { str_colName: 'UppHard', value: masterData.PosTolHard },
          //         // { str_colName: 'UnitHard', value: masterData.Unit },
          //         // { str_colName: 'NomThick', value: masterData.NomThick },
          //         // { str_colName: 'LwrThick', value: masterData.NegTolThick },
          //         // { str_colName: 'UppThick', value: masterData.PosTolThick },
          //         // { str_colName: 'NomDLB', value: masterData.NomDOLOBO },
          //         // { str_colName: 'LwrDLB', value: masterData.NegTolDOLOBO },
          //         // { str_colName: 'UppDLB', value: masterData.PosTolDOLOBO },
          //         // { str_colName: 'DLBParamName', value: masterData.ColHeadDOLOBO },
          //         { str_colName: 'Side', value: sideVal },
          //         { str_colName: 'BatchCompleted', value: 0 },
          //         { str_colName: 'IsArchived', value: 0 }
          //     ]
          // }
          let saveBatchSumm = masterDataInsert;
          masterSrNo = saveBatchSumm.RepSerNo;
          if (sideVal == "NA") {
            /**
             * @formula
             * calculation = ((before-After)/Before)*100
             */
            let calculation =
              ((masterData.lwtBeforeTest - masterData.lwtAfterTest) /
                masterData.lwtBeforeTest) *
              100;
            if (calculation > masterData.Nom) {
              result = "Not Complies";
            } else {
              result = "Complies";
            }
            await models.tbl_batchsummary_detail8.create({
              RepSerNo: masterSrNo,
              RecSeqNo: recSeqNo,
              Date: masterData.PrDate,
              Time: masterData.PrTime,
              InstrumentID: masterData.InstrumentID,
              Side: "NA",
              InitialWeight: masterData.lwtBeforeTest,
              FinalWeight: masterData.lwtAfterTest,
              Friability: Number(masterData.nwtBeforeTest).toFixed(3),
              Min: Number(masterData.nwtBeforeTest).toFixed(3),
              Max: Number(masterData.nwtBeforeTest).toFixed(3),
              Avg: Number(masterData.nwtBeforeTest).toFixed(avgDp),
              TestResult: remark,
              UserID: masterData.UserId,
              UserName: masterData.UserName,
            });
            // {
            //     str_tableName: 'tbl_batchsummary_detail8',
            //     data: [
            //         { str_colName: 'RepSerNo', value: masterSrNo },
            //         { str_colName: 'RecSeqNo', value: recSeqNo },
            //         { str_colName: 'Date', value: masterData.PrDate },
            //         { str_colName: 'Time', value: masterData.PrTime },
            //         { str_colName: 'InstrumentID', value: masterData.InstrumentID },
            //         { str_colName: 'Side', value: 'NA' },
            //         { str_colName: 'Min', value: calculation < 0 ? 0 : calculation },
            //         { str_colName: 'Max', value: calculation < 0 ? 0 : calculation },
            //         { str_colName: 'Avg', value: calculation < 0 ? 0 : calculation },
            //         { str_colName: 'TestResult', value: result },
            //         { str_colName: 'UserID', value: masterData.UserId },
            //         { str_colName: 'UserName', value: masterData.UserName },

            //     ]
            // }
            //console.log(objInsertDetailData);
            Object.assign(responseObj, { status: "success" });
            // return responseObj;
          } else {
            let resultLHS;
            let resultRHS;
            /**
             * @formula
             * calculation = ((before-After)/Before)*100
             */
            if (FriabilityDetail1 == 'LHS') {
              let calculationLHS =
                ((masterData.lwtBeforeTest - masterData.lwtAfterTest) /
                  masterData.lwtBeforeTest) *
                100;
              if (calculationLHS > masterData.Nom) {
                resultLHS = "Not Complies";
              } else {
                resultLHS = "Complies";
              }
              await models.tbl_batchsummary_detail8.create({
                RepSerNo: masterSrNo,
                RecSeqNo: recSeqNo,
                Date: masterData.PrDate,
                Time: masterData.PrTime,
                InstrumentID: masterData.InstrumentID,
                Side: "LHS",
                InitialWeight: masterData.lwtBeforeTest,
                FinalWeight: masterData.lwtAfterTest,
                Friability: Number(masterData.nwtBeforeTest).toFixed(3),
                Min: Number(masterData.nwtBeforeTest).toFixed(3),
                Max: Number(masterData.nwtBeforeTest).toFixed(3),
                Avg: Number(masterData.nwtBeforeTest).toFixed(avgDp),
                TestResult: remark,
                UserID: masterData.UserId,
                UserName: masterData.UserName,
              });
            } else {
              //  {
              //     str_tableName: 'tbl_batchsummary_detail8',
              //     data: [
              //         { str_colName: 'RepSerNo', value: masterSrNo },
              //         { str_colName: 'RecSeqNo', value: recSeqNo },
              //         { str_colName: 'Date', value: masterData.PrDate },
              //         { str_colName: 'Time', value: masterData.PrTime },
              //         { str_colName: 'InstrumentID', value: masterData.InstrumentID },
              //         { str_colName: 'Side', value: 'LEFT' },
              //         { str_colName: 'Min', value: calculationLHS },
              //         { str_colName: 'Max', value: calculationLHS },
              //         { str_colName: 'Avg', value: calculationLHS },
              //         { str_colName: 'TestResult', value: resultLHS },
              //         { str_colName: 'UserID', value: masterData.UserId },
              //         { str_colName: 'UserName', value: masterData.UserName },

              //     ]
              // }

              let calculationRHS =
                ((masterData.rwtBeforeTest - masterData.rwtAfterTest) /
                  masterData.rwtBeforeTest) *
                100;
              if (calculationRHS > masterData.Nom) {
                resultRHS = "Not Complies";
              } else {
                resultRHS = "Complies";
              }
              const objInsertDetailDataRHS =
                await models.tbl_batchsummary_detail8.create({
                  RepSerNo: masterSrNo,
                  RecSeqNo: recSeqNo,
                  Date: masterData.PrDate,
                  Time: masterData.PrTime,
                  InstrumentID: masterData.InstrumentID,
                  Side: "RHS",
                  InitialWeight: masterData.rwtBeforeTest,
                  FinalWeight: masterData.rwtAfterTest,
                  Friability: Number(masterData.nwtAfterTest).toFixed(3),
                  Min: Number(masterData.nwtAfterTest).toFixed(3),
                  Max: Number(masterData.nwtAfterTest).toFixed(3),
                  Avg: Number(masterData.nwtAfterTest).toFixed(avgDp),
                  TestResult: remark,
                  UserID: masterData.UserId,
                  UserName: masterData.UserName,
                });
            }
            // {
            //     str_tableName: 'tbl_batchsummary_detail8',
            //     data: [
            //         { str_colName: 'RepSerNo', value: masterSrNo },
            //         { str_colName: 'RecSeqNo', value: recSeqNo },
            //         { str_colName: 'Date', value: masterData.PrDate },
            //         { str_colName: 'Time', value: masterData.PrTime },
            //         { str_colName: 'InstrumentID', value: masterData.InstrumentID },
            //         { str_colName: 'Side', value: 'RIGHT' },
            //         { str_colName: 'Min', value: calculationRHS },
            //         { str_colName: 'Max', value: calculationRHS },
            //         { str_colName: 'Avg', value: calculationRHS },
            //         { str_colName: 'TestResult', value: resultRHS },
            //         { str_colName: 'UserID', value: masterData.UserId },
            //         { str_colName: 'UserName', value: masterData.UserName },

            //     ]
            // }
            //console.log(objInsertDetailData);
            Object.assign(responseObj, { status: "success" });
            // return responseObj;
          }
        } else {
          masterSrNo = resultData[0].SrNo;
          if (sideVal == "NA") {
            /**
             * @formula
             * calculation = ((before-After)/Before)*100
             */
            let calculation =
              ((masterData.lwtBeforeTest - masterData.lwtAfterTest) /
                masterData.lwtBeforeTest) *
              100;
            if (calculation > masterData.Nom) {
              result = "Not Complies";
            } else {
              result = "Complies";
            }
            const objInsertDetailData =
              await models.tbl_batchsummary_detail8.create({
                RepSerNo: masterSrNo,
                RecSeqNo: recSeqNo,
                Date: masterData.PrDate,
                Time: masterData.PrTime,
                InstrumentID: masterData.InstrumentID,
                Side: "NA",
                InitialWeight: masterData.lwtBeforeTest,
                FinalWeight: masterData.lwtAfterTest,
                Friability: Number(masterData.nwtBeforeTest).toFixed(3),
                Min: Number(masterData.nwtBeforeTest).toFixed(3),
                Max: Number(masterData.nwtBeforeTest).toFixed(3),
                Avg: Number(masterData.nwtBeforeTest).toFixed(avgDp),
                TestResult: remark,
                UserID: masterData.UserId,
                UserName: masterData.UserName,
              });
            // {
            //     str_tableName: 'tbl_batchsummary_detail8',
            //     data: [
            //         { str_colName: 'RepSerNo', value: masterSrNo },
            //         { str_colName: 'RecSeqNo', value: recSeqNo },
            //         { str_colName: 'Date', value: masterData.PrDate },
            //         { str_colName: 'Time', value: masterData.PrTime },
            //         { str_colName: 'InstrumentID', value: masterData.InstrumentID },
            //         { str_colName: 'Side', value: 'NA' },
            //         { str_colName: 'Min', value: calculation },
            //         { str_colName: 'Max', value: calculation },
            //         { str_colName: 'Avg', value: calculation },
            //         { str_colName: 'TestResult', value: result },
            //         { str_colName: 'UserID', value: masterData.UserId },
            //         { str_colName: 'UserName', value: masterData.UserName },

            //     ]
            // }
            //console.log(objInsertDetailData);
            // (objInsertDetailData);
            Object.assign(responseObj, { status: "success" });
            // return responseObj;
          } else {
            let resultLHS;
            let resultRHS;
            /**
             * @formula
             * calculation = ((before-After)/Before)*100
             */
            if (FriabilityDetail1 == 'LHS') {
              let calculationLHS =
                ((masterData.lwtBeforeTest - masterData.lwtAfterTest) /
                  masterData.lwtBeforeTest) *
                100;
              if (calculationLHS > masterData.Nom) {
                resultLHS = "Not Complies";
              } else {
                resultLHS = "Complies";
              }
              const objInsertDetailDataLHS =
                await models.tbl_batchsummary_detail8.create({
                  RepSerNo: masterSrNo,
                  RecSeqNo: recSeqNo,
                  Date: masterData.PrDate,
                  Time: masterData.PrTime,
                  InstrumentID: masterData.InstrumentID,
                  Side: "LHS",
                  InitialWeight: masterData.lwtBeforeTest,
                  FinalWeight: masterData.lwtAfterTest,
                  Friability: Number(masterData.nwtBeforeTest).toFixed(3),
                  Min: Number(masterData.nwtBeforeTest).toFixed(3),
                  Max: Number(masterData.nwtBeforeTest).toFixed(3),
                  Avg: Number(masterData.nwtBeforeTest).toFixed(avgDp),
                  TestResult: remark,
                  UserID: masterData.UserId,
                  UserName: masterData.UserName,
                });
            } else {
              // {
              //     str_tableName: 'tbl_batchsummary_detail8',
              //     data: [
              //         { str_colName: 'RepSerNo', value: masterSrNo },
              //         { str_colName: 'RecSeqNo', value: recSeqNo },
              //         { str_colName: 'Date', value: masterData.PrDate },
              //         { str_colName: 'Time', value: masterData.PrTime },
              //         { str_colName: 'InstrumentID', value: masterData.InstrumentID },
              //         { str_colName: 'Side', value: 'LEFT' },
              //         { str_colName: 'Min', value: calculationLHS },
              //         { str_colName: 'Max', value: calculationLHS },
              //         { str_colName: 'Avg', value: calculationLHS },
              //         { str_colName: 'TestResult', value: resultLHS },
              //         { str_colName: 'UserID', value: masterData.UserId },
              //         { str_colName: 'UserName', value: masterData.UserName },

              //     ]
              // }
              // (objInsertDetailDataLHS);
              let calculationRHS =
                ((masterData.rwtBeforeTest - masterData.rwtAfterTest) /
                  masterData.rwtBeforeTest) *
                100;
              if (calculationRHS > masterData.Nom) {
                resultRHS = "Not Complies";
              } else {
                resultRHS = "Complies";
              }
              const objInsertDetailDataRHS =
                await models.tbl_batchsummary_detail8.create({
                  RepSerNo: masterSrNo,
                  RecSeqNo: recSeqNo,
                  Date: masterData.PrDate,
                  Time: masterData.PrTime,
                  InstrumentID: masterData.InstrumentID,
                  Side: "RHS",
                  InitialWeight: masterData.rwtBeforeTest,
                  FinalWeight: masterData.rwtAfterTest,
                  Friability: Number(masterData.nwtAfterTest).toFixed(3),
                  Min: Number(masterData.nwtAfterTest).toFixed(3),
                  Max: Number(masterData.nwtAfterTest).toFixed(3),
                  Avg: Number(masterData.nwtAfterTest).toFixed(avgDp),
                  TestResult: remark,
                  UserID: masterData.UserId,
                  UserName: masterData.UserName,
                });
            }
            // {
            //     str_tableName: 'tbl_batchsummary_detail8',
            //     data: [
            //         { str_colName: 'RepSerNo', value: masterSrNo },
            //         { str_colName: 'RecSeqNo', value: recSeqNo },
            //         { str_colName: 'Date', value: masterData.PrDate },
            //         { str_colName: 'Time', value: masterData.PrTime },
            //         { str_colName: 'InstrumentID', value: masterData.InstrumentID },
            //         { str_colName: 'Side', value: 'RIGHT' },
            //         { str_colName: 'Min', value: calculationRHS },
            //         { str_colName: 'Max', value: calculationRHS },
            //         { str_colName: 'Avg', value: calculationRHS },
            //         { str_colName: 'TestResult', value: resultRHS },
            //         { str_colName: 'UserID', value: masterData.UserId },
            //         { str_colName: 'UserName', value: masterData.UserName },

            //     ]
            // }
            //console.log(objInsertDetailData);
            // (objInsertDetailDataRHS);
            Object.assign(responseObj, { status: "success" });
            // return responseObj;
          }
        }
        let entry = await this.calculatefriab(masterSrNo,);
        // if(check_entry.length != undefined){
        await models.tbl_batchsummary_master8.update(
          {
            MinValue: entry.min == Infinity ? "NA" : entry.min,
            MaxValue: entry.max == -Infinity ? "NA" : entry.max,
            EndDate: moment().format('YYYY-MM-DD'),
            AvgValue:
              entry.avg.toFixed(avgDp) == "NaN" ? "NA" : entry.avg.toFixed(avgDp),
          },
          {
            where: {
              RepSerNo: masterSrNo,
            },
          }
        );
      } else {
        return "success";
      }
    } catch (error) {
      console.log(error)
    }
  }
  async CheckfriabModel(idsNo) {
    var cubicInfo = globalData.arrIdsInfo.find(
      (k) => k.idsNo == idsNo
    ).cubicalData;
    var Sys_FriabID = cubicInfo.Sys_FriabID;

    var selectOtherEquip = await models["tbl_otherequipment"].findAll({
      where: {
        Eqp_ID: Sys_FriabID,
      },
    });
    return [selectOtherEquip][0][0];
  }

  /**
   *
   * @param {*} masterData
   * @param {*} DetailData
   * @description `saveBatchDataHardness` Save the batch Summary Data for `Hardness`
   */
  async saveBatchDataHardness(masterData, DetailData, idsNo, Remark) {
    try {
      var now = new Date();
      let responseObj = {};
      var selectedIds = idsNo;
      // console.log(masterData, DetailData);
      var cubicalObj = globalData.arrIdsInfo.find(k => k.idsNo == selectedIds).cubicalData;
      var menuDetail = globalData.arr_limits.find(k => k.idsNo == idsNo);
      let tempLimObjHardness = menuDetail.Menus.filter(obj => Object.keys(obj) == "Hardness")[0] == undefined ?
        undefined : menuDetail.Menus.filter(obj => Object.keys(obj) == "Hardness")[0]['Hardness'];
      let tempLimObjThickness = menuDetail.Menus.filter(obj => Object.keys(obj) == "Thickness")[0] == undefined ?
        undefined : menuDetail.Menus.filter(obj => Object.keys(obj) == "Thickness")[0]['Thickness'];
      let tempLimObjlength = menuDetail.Menus.filter(obj => Object.keys(obj) == "Length")[0] == undefined ?
        undefined : menuDetail.Menus.filter(obj => Object.keys(obj) == "Length")[0]['Length'];
      let tempLimObjDiameter = menuDetail.Menus.filter(obj => Object.keys(obj) == "Diameter")[0] == undefined ?
        undefined : menuDetail.Menus.filter(obj => Object.keys(obj) == "Diameter")[0]['Diameter'];
      let tempLimObjBreadth = menuDetail.Menus.filter(obj => Object.keys(obj) == "Breadth")[0] == undefined ?
        undefined : menuDetail.Menus.filter(obj => Object.keys(obj) == "Breadth")[0]['Breadth'];
      let sideVal = "NA";
      if (masterData.Side == 'LHS') {
        sideVal = "LHS";
      } else if (masterData.Side == 'RHS') {
        sideVal = "RHS";
      } else {
        sideVal = "NA";
      }
      let checkSideMasterTable;
      if (masterData.Side == 'NA') {
        checkSideMasterTable = masterData.Side;
      } else {
        checkSideMasterTable = 'LHS';
      }
      let sumHT = 0;
      let sumT = 0;
      let sumDLB = 0;
      let sumDiam = 0;
      let arrHTDetail = [];
      let arrTDetail = [];
      let arrDLBDetail = [];
      let arrDiamDetail = [];
      // let outFlagHTD = 0;
      // let outFlagThickness = 0;
      // let outFlagDOLOBO = 0;
      // let outFlagDiam = 0;
      let remark;
      var dp = 2;
      let avgHrd = 1;
      let hardDp = 0;

      var HardnessException = DetailData.some(item => item.DataValueHard === 'NA' ||
        item.DataValueHard === 'FL' ||
        item.DataValueHard === '--' ||
        parseInt(item.DataValueHard) > 999
      );
      var ThicknessException = DetailData.some(item => item.DataValueThick === 'NA' ||
        item.DataValueThick === 'FL' ||
        item.DataValueThick === '--' ||
        parseInt(item.DataValueThick) > 999
      );
      var DLBException = DetailData.some(item => item.DataValueBL === 'NA' ||
        item.DataValueBL === 'FL' ||
        item.DataValueBL === '--' ||
        parseInt(item.DataValueBL) > 999
      );


      let count = DetailData.length;
      for (var i = 0; i < DetailData.length; i++) {
        if (!HardnessException) {
          if (DetailData[i].DataValueHard !== "NA" && DetailData[i].DataValueHard !== "FL" && (DetailData[i].DataValueHard) < 999) {
            var dataValHard = parseFloat(DetailData[i].DataValueHard);
            // if ((minHTDLimit > dataValHard) || (dataValHard > maxHTDLimit)) {
            //   outFlagHTD = outFlagHTD + 1;
            // }
            arrHTDetail.push(dataValHard);
          }
        } else {
          arrHTDetail = []
        }

        if (!ThicknessException) {
          if (DetailData[i].DataValueThick !== "NA" && DetailData[i].DataValueThick !== "FL" && (DetailData[i].DataValueThick) < 999) {
            var dataValThick = parseFloat(DetailData[i].DataValueThick);
            // if (minTLimit != 0 && maxTLimit != 0) {
            //   if ((minTLimit > dataValThick) || (dataValThick > maxTLimit)) {
            //     outFlagThickness = outFlagThickness + 1;
            //   }
            // }
            arrTDetail.push(dataValThick);
          }
        } else {
          arrTDetail = []
        }

        if (!DLBException) {
          if (DetailData[i].DataValueBL !== "NA" && DetailData[i].DataValueBL !== "FL" && (DetailData[i].DataValueBL) < 999) {
            var dataValDLB = parseFloat(DetailData[i].DataValueBL);
            // if (minDLBLimit != 0 && maxDLBLimit != 0) {
            //   if ((minDLBLimit > dataValDLB) || (dataValDLB > maxDLBLimit)) {
            //     outFlagDOLOBO = outFlagDOLOBO + 1;
            //   }
            // }
            arrDLBDetail.push(dataValDLB);
          }
        } else {
          arrDLBDetail = []
        }

        if (!DLBException) {
          if (DetailData[i].DataValueDiam !== "NA" && DetailData[i].DataValueDiam !== "FL" && (DetailData[i].DataValueDiam) < 999) {
            var dataValDiam = parseFloat(DetailData[i].DataValueDiam);
            // if (minDLBLimit != 0 && maxDLBLimit != 0) {
            //   if ((minDLBLimit > dataValDiam) || (dataValDiam > maxDLBLimit)) {
            //     outFlagDiam = outFlagDiam + 1;
            //   }
            // }
            arrDiamDetail.push(dataValDiam);
          }
        } else {
          arrDiamDetail = []
        }
      }

      // if (masterData.NomDOLOBO != 0) {
      //   if (outFlagHTD != 0 || outFlagThickness != 0 || outFlagDOLOBO != 0 || outFlagDiam != 0) {
      //     remark = 'Not Complies';
      //   } else {
      //     remark = 'Complies';
      //   }
      // } else {
      //   if (outFlagHTD != 0 || outFlagThickness != 0) {
      //     remark = 'Not Complies'
      //   } else {
      //     remark = 'Complies';
      //   }
      // }

      for (var j = 0; j < arrHTDetail.length; j++) {
        sumHT = sumHT + parseFloat(arrHTDetail[j]);
      }
      for (var k = 0; k < arrTDetail.length; k++) {
        sumT = sumT + parseFloat(arrTDetail[k]);
      }
      for (var l = 0; l < arrDLBDetail.length; l++) {
        sumDLB = sumDLB + parseFloat(arrDLBDetail[l]);
      }
      for (var d = 0; d < arrDiamDetail.length; d++) {
        sumDiam = sumDiam + parseFloat(arrDiamDetail[d]);
      }
      var MaxHard = Math.max(...arrHTDetail);
      var MinHard = Math.min(...arrHTDetail);
      var avgHard = (sumHT / count);
      var MaxThick = (arrTDetail.length > 0) ? Math.max(...arrTDetail) : "NA";
      var MinThick = (arrTDetail.length > 0) ? Math.min(...arrTDetail) : "NA";
      var AvgThick = (arrTDetail.length > 0) ? (sumT / count) : "NA";
      var MaxDLB = (arrDLBDetail.length > 0) ? Math.max(...arrDLBDetail) : "NA";
      var MinDLB = (arrDLBDetail.length > 0) ? Math.min(...arrDLBDetail) : "NA";
      var AvgDLB = (arrDLBDetail.length > 0) ? (sumDLB / count) : "NA";
      var MaxDiam = (arrDiamDetail.length > 0) ? Math.max(...arrDiamDetail) : "NA";
      var MinDiam = (arrDiamDetail.length > 0) ? Math.min(...arrDiamDetail) : "NA";
      var AvgDiam = (arrDiamDetail.length > 0) ? (sumDiam / count) : "NA";

      if (((cubicalObj.Sys_RptType == 0) &&
        cubicalObj.Sys_BatchReuse == 0 &&
        (cubicalObj.Sys_Validation == 0) &&
        (cubicalObj.Sys_CubType == 'Compression') ||
        (cubicalObj.Sys_CubType == 'Coating' && cubicalObj.Sys_IPQCType != "Compression"))) {
        // let res = await proObj.productData(cubicalObj);
        // var paramNom = `Param7_Nom`;
        // var limitNo = `Param7_LimitOn`;
        // var nom = parseFloat(res[1][paramNom]);
        // var limit = res[1][limitNo].readUIntLE();
        // if(masterData.ColHeadDOLOBO == 'Le')

        // const checkMasterObj = {
        //     str_tableName: 'tbl_batchsummary_master_hdlb',
        //     data: 'MAX(RepSerNo) AS SrNo',
        //     condition: [
        //         { str_colName: 'BFGCode', value: masterData.BFGCode, comp: 'eq' },
        //         { str_colName: 'ProductName', value: masterData.ProductName, comp: 'eq' },
        //         { str_colName: 'PVersion', value: masterData.PVersion, comp: 'eq' },
        //         { str_colName: 'Version', value: masterData.Version, comp: 'eq' },
        //         { str_colName: 'Side', value: checkSideMasterTable, comp: 'eq' },
        //         { str_colName: 'CubType', value: cubicalObj.Sys_CubType, comp: 'eq' },
        //         { str_colName: 'BatchNo', value: masterData.BatchNo, comp: 'eq' },
        //     ]
        // }

        // let DP = await objDP.precision(resultdata.incompleteData.T2PosTol);
        // let resultData = await database.select(checkMasterObj);
        var masterSrNo;

        if (((cubicalObj.Sys_RptType == 0) && (cubicalObj.Sys_Validation == 0) && (cubicalObj.Sys_BatchReuse == 0) && (cubicalObj.Sys_CubType == 'Compression') || (cubicalObj.Sys_CubType == 'Coating' && cubicalObj.Sys_IPQCType != "Compression"))) {

          var masterSrNo;
          const checkMasterObj = await models['tbl_batchsummary_masterhtd'].findAll({
            attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'SrNo']],
            where: {
              BFGCode: masterData.BFGCode,
              ProductName: masterData.ProductName,
              PVersion: masterData.PVersion,
              Version: masterData.Version,
              Side: checkSideMasterTable,
              CubicleType: cubicalObj.Sys_CubType,
              BatchNo: masterData.BatchNo,
            }
          })

          let resultData = checkMasterObj;

          let recSeqNo = await this.calculateSeqNo(sideVal, 'tbl_batchsummary_masterhtd', 'tbl_batchsummary_detailhtd', masterData);



          if (resultData[0].SrNo == null) {

            const masterDataInsert = await models['tbl_batchsummary_masterhtd'].create({
              Area: masterData.Area,
              ReportType: masterData.ReportType,
              CubicalNo: masterData.CubicalNo,
              CubicleType: masterData.CubicleType,
              BatchSize: masterData.BatchSize,
              BLName: masterData.BLName,
              TolNegHard: masterData.T1NegTolHard,
              TolPosHard: masterData.T1PosTolHard,
              TolNegThick: masterData.T2NegTolThick,
              TolPosThick: masterData.T2PosTolThick,
              TolNegDiam: masterData.T2NegTolDiam,
              TolPosDiam: masterData.T2PosTolDiam,
              TolNegBL: masterData.T2NegTolBL,
              TolPosBL: masterData.T2PosTolBL,
              TolNegActualHard: masterData.T1NegTolActualHard,
              TolPosActualHard: masterData.T1PosTolActualHard,
              TolNegActualThick: masterData.T2NegTolActualThick,
              TolPosActualThick: masterData.T2PosTolActualThick,
              TolPosActualDiam: masterData.T2NegTolActualDiam,
              TolNegActualDiam: masterData.T2PosTolActualDiam,
              TolNegActualBL: masterData.T2NegTolActualBL,
              TolPosActualBL: masterData.T2PosTolActualBL,

              NomHard: masterData.Nom_stdtarget,
              NomThick: masterData.NomThick,
              NomDiam: masterData.NomDiam,
              NomBL: masterData.NomBL,

              MinValueHard: (Remark === "Not Complies") ? "NA" : masterData.MinWeightHard,
              MaxValueHard: (Remark === "Not Complies") ? "NA" : masterData.MaxWeightHard,
              AvgValueHard: (Remark === "Not Complies") ? "NA" : masterData.AvgHard,

              MinValueThick: (Remark === "Not Complies") ? "NA" : masterData.MinWeightThick,
              MaxValueThick: (Remark === "Not Complies") ? "NA" : masterData.MaxWeightThick,
              AvgValueThick: (Remark === "Not Complies") ? "NA" : masterData.AvgThick,

              MinValueDiam: (Remark === "Not Complies") ? "NA" : masterData.MinWeightDiam,
              MaxValueDiam: (Remark === "Not Complies") ? "NA" : masterData.MaxWeightDiam,
              AvgValueDiam: (Remark === "Not Complies") ? "NA" : masterData.AvgDiam,

              MinValueBL: (Remark === "Not Complies") ? "NA" : masterData.MinWeightBL,
              MaxValueBL: (Remark === "Not Complies") ? "NA" : masterData.MaxWeightBL,
              AvgValueBL: (Remark === "Not Complies") ? "NA" : masterData.AvgBL,

              StartDateHard: moment().format("YYYY-MM-DD"),
              EndDateHard: moment().format("YYYY-MM-DD"),
              StartDateThick: moment().format("YYYY-MM-DD"),
              EndDateThick: moment().format("YYYY-MM-DD"),
              StartDateDiam: moment().format("YYYY-MM-DD"),
              EndDateDiam: moment().format("YYYY-MM-DD"),
              StartDateBL: moment().format("YYYY-MM-DD"),
              EndDateBL: moment().format("YYYY-MM-DD"),
              Unit: masterData.Unit,
              BFGCode: masterData.BFGCode,
              ProductName: masterData.ProductName,
              PVersion: masterData.PVersion,
              Version: masterData.Version,
              PrdType: 1,
              CubType: masterData.CubicleType,
              BatchNo: masterData.BatchNo,
              Stage: masterData.Stage,
              Department: cubicalObj.Sys_dept,
              // NomHard: masterData.NomHard,
              // LwrHard: masterData.NegTolHard,
              // UppHard: masterData.PosTolHard,
              // UnitHard: masterData.Unit,
              // LwrThick: masterData.NegTolThick,
              // UppThick: masterData.PosTolThick,
              // NomDLB: masterData.NomDOLOBO,
              // LwrDLB: masterData.NegTolDOLOBO,
              // UppDLB: masterData.PosTolDOLOBO,

              // DLBParamName: masterData.ColHeadDOLOBO,
              Remark: Remark,
              Side: checkSideMasterTable,
              BatchCompleted: 0,
              IsArchived: 0,
              LimitOn: 0
            });

            masterSrNo = masterDataInsert._previousDataValues.RepSerNo;


            await models['tbl_batchsummary_detailhtd'].create({
              RepSerNo: masterSrNo,
              RecSeqNo: recSeqNo,
              Date: masterData.PrDate,
              Time: moment(masterData.PrTime).format("HH:mm:ss"),
              InstrumentID: masterData.HardnessID,
              Side: sideVal,
              MinHard: (Number(masterData.MinWeightHard) == 0) ? "NA" : masterData.MinWeightHard,
              MaxHard: (Number(masterData.MaxWeightHard) == 0) ? "NA" : masterData.MaxWeightHard,
              AvgHard: (Number(masterData.AvgHard) == 0) ? "NA" : masterData.AvgHard,
              MinThick: (MinThick == "NA") ? "NA" : mathj.round(Number(MinThick), dp).toFixed(dp),
              MaxThick: (MaxThick == "NA") ? "NA" : mathj.round(Number(MaxThick), dp).toFixed(dp),
              AvgThick: (AvgThick == "NA") ? "NA" : mathj.round(Number(AvgThick), dp).toFixed(dp),
              MinDiam: (MinDiam == "NA") ? "NA" : mathj.round(Number(MinDiam), dp).toFixed(dp),
              MaxDiam: (MaxDiam == "NA") ? "NA" : mathj.round(Number(MaxDiam), dp).toFixed(dp),
              AvgDiam: (AvgDiam == "NA") ? "NA" : mathj.round(Number(AvgDiam), dp).toFixed(dp),
              MinBL: (MinDLB == "NA") ? "NA" : mathj.round(Number(MinDLB), dp).toFixed(dp),
              MaxBL: (MaxDLB == "NA") ? "NA" : mathj.round(Number(MaxDLB), dp).toFixed(dp),
              AvgBL: (AvgDLB == "NA") ? "NA" : mathj.round(Number(AvgDLB), dp).toFixed(dp),
              // MinTimeDT': resultdata.incompleteData.T1PosTol ,
              // MaxTimeDT': resultdata.incompleteData.T2NegTol ,
              TestResult: Remark,
              UserID: masterData.UserId,
              UserName: masterData.UserName,
            });

            Object.assign(responseObj, { status: 'success' })
            return responseObj;


          } else {
            var repSerNo = resultData[0].SrNo
            masterSrNo = resultData[0].SrNo;
            //     const checkDetailObj = {
            //         str_tableName: detailTable,
            //         data: 'MAX(RecSeqNo) AS SeqNo',
            //         condition: [
            //             { str_colName: 'RepSerNo', value: masterSrNo, comp: 'eq' },
            //         ]
            //     }
            //    let detailres = await database.select(checkDetailObj);
            //         var seqNum = detailres[0][0].SeqNo;
            //         var seqNo = seqNum + 1;
            // const objInsertDetailData = {
            //     str_tableName: 'tbl_batchsummary_detail_hdlb',
            //     data: [
            //         { str_colName: 'RepSerNo', value: masterSrNo },
            //         { str_colName: 'RecSeqNo', value: recSeqNo },
            //         { str_colName: 'Date', value: masterData.PrDate },
            //         { str_colName: 'Time', value: masterData.PrTime },
            //         { str_colName: 'InstrumentID', value: masterData.HardnessID },
            //         { str_colName: 'Side', value: sideVal },
            //         { str_colName: 'MinHard', value: MinHard },
            //         { str_colName: 'MaxHard', value: MaxHard },
            //         { str_colName: 'AvgHard', value: avgHard },
            //         { str_colName: 'MinThick', value: MinThick },
            //         { str_colName: 'MaxThick', value: MaxThick },
            //         { str_colName: 'AvgThick', value: AvgThick },
            //         { str_colName: 'MinDLB', value: MinDLB },
            //         { str_colName: 'MaxDLB', value: MaxDLB },
            //         { str_colName: 'AvgDLB', value: AvgDLB },
            //         // { str_colName: 'MinTimeDT', value: resultdata.incompleteData.T1PosTol },
            //         // { str_colName: 'MaxTimeDT', value: resultdata.incompleteData.T2NegTol },
            //         { str_colName: 'TestResult', value: remark },
            //         { str_colName: 'UserID', value: masterData.UserId },
            //         { str_colName: 'UserName', value: masterData.UserName },
            //     ]
            // }
            // await database.save(objInsertDetailData);

            // var minHardValue = checkMasterObj[0].MinValueHard,
            //   maxHardValue = checkMasterObj[0].MaxValueHard,
            //   AvgHardValue = checkMasterObj[0].AvgValueHard,
            //   recSeqNoHard = 0
            // var minThickValue = checkMasterObj[0].MinValueThick,
            //   maxThickValue = checkMasterObj[0].MaxValueThick,
            //   AvgThickValue = checkMasterObj[0].AvgValueThick,
            //   recSeqNoThick = 0
            // var minDiamValue = checkMasterObj[0].MinValueDiam,
            //   maxDiamValue = checkMasterObj[0].MaxValueDiam,
            //   AvgDiamValue = checkMasterObj[0].AvgValueDiam,
            //   recSeqNoDiam = 0
            // var minBLValue = checkMasterObj[0].MinValueBL,
            //   maxBLValue = checkMasterObj[0].MaxValueBL,
            //   AvgBLValue = checkMasterObj[0].AvgValueBL,
            //   recSeqNoBL = 0

            await models['tbl_batchsummary_detailhtd'].create({
              RepSerNo: masterSrNo,
              RecSeqNo: recSeqNo,
              Date: masterData.PrDate,
              Time: moment(masterData.PrTime).format("HH:mm:ss"),
              InstrumentID: masterData.HardnessID,
              Side: sideVal,
              MinHard: masterData.MinWeightHard,
              MaxHard: masterData.MaxWeightHard,
              AvgHard: masterData.AvgHard,
              MinThick: (MinThick == "NA") ? "NA" : mathj.round(Number(MinThick), dp).toFixed(dp),
              MaxThick: (MaxThick == "NA") ? "NA" : mathj.round(Number(MaxThick), dp).toFixed(dp),
              AvgThick: (AvgThick == "NA") ? "NA" : mathj.round(Number(AvgThick), dp).toFixed(dp),
              MinDiam: (MinDiam == "NA") ? "NA" : mathj.round(Number(MinDiam), dp).toFixed(dp),
              MaxDiam: (MaxDiam == "NA") ? "NA" : mathj.round(Number(MaxDiam), dp).toFixed(dp),
              AvgDiam: (AvgDiam == "NA") ? "NA" : mathj.round(Number(AvgDiam), dp).toFixed(dp),
              MinBL: (MinDLB == "NA") ? "NA" : mathj.round(Number(MinDLB), dp).toFixed(dp),
              MaxBL: (MaxDLB == "NA") ? "NA" : mathj.round(Number(MaxDLB), dp).toFixed(dp),
              AvgBL: (AvgDLB == "NA") ? "NA" : mathj.round(Number(AvgDLB), dp).toFixed(dp),
              //MinTimeDT': resultdata.incompleteData.T1PosTol ,
              //MaxTimeDT': resultdata.incompleteData.T2NegTol ,
              TestResult: Remark,
              UserID: masterData.UserId,
              UserName: masterData.UserName,
            });


            let getAllData = await models.tbl_batchsummary_detailhtd.findAll({
              where: {
                RepSerNo: masterSrNo,
                TestResult: 'Complies'
              }
            })

            let minHard = getAllData.filter(e => e.MinHard != "NA").map(e => e.MinHard);
            let maxHard = getAllData.filter(e => e.MaxHard != "NA").map(e => e.MaxHard);
            let avgHard = getAllData.filter(e => e.AvgHard != "NA").map(e => e.AvgHard);
            let minThick = getAllData.filter(e => e.MinThick != "NA").map(e => e.MinThick);
            let maxThick = getAllData.filter(e => e.MaxThick != "NA").map(e => e.MaxThick);
            let avgThick = getAllData.filter(e => e.AvgThick != "NA").map(e => e.AvgThick);
            let maxDiam = getAllData.filter(e => e.MaxDiam != "NA").map(e => e.MaxDiam);
            let minDiam = getAllData.filter(e => e.MinDiam != "NA").map(e => e.MinDiam);
            let avgDiam = getAllData.filter(e => e.AvgDiam != "NA").map(e => e.AvgDiam);
            let maxBL = getAllData.filter(e => e.MaxBL != "NA").map(e => e.MaxBL);
            let minBL = getAllData.filter(e => e.MinBL != "NA").map(e => e.MinBL);
            let avgBL = getAllData.filter(e => e.AvgBL != "NA").map(e => e.AvgBL);

            let minValueHard = (minHard.length > 0) ? mathj.round(Number(mathj.min(minHard)), hardDp).toFixed(hardDp) : 'NA';
            let maxValueHard = (maxHard.length > 0) ? mathj.round(Number(mathj.max(maxHard)), hardDp).toFixed(hardDp) : 'NA';
            let avgValueHard = (avgHard.length > 0) ? mathj.round(Number(mathj.mean(avgHard)), avgHrd).toFixed(avgHrd) : 'NA';
            let minValueThick = (minThick.length > 0) ? mathj.round(Number(mathj.min(minThick)), dp).toFixed(dp) : 'NA';
            let maxValueThick = (maxThick.length > 0) ? mathj.round(Number(mathj.max(maxThick)), dp).toFixed(dp) : 'NA';
            let avgValueThick = (avgThick.length > 0) ? mathj.round(Number(mathj.mean(avgThick)), dp).toFixed(dp) : 'NA';
            let minValueDiam = (minDiam.length > 0) ? mathj.round(Number(mathj.min(minDiam)), dp).toFixed(dp) : 'NA';
            let maxValueDiam = (maxDiam.length > 0) ? mathj.round(Number(mathj.max(maxDiam)), dp).toFixed(dp) : 'NA';
            let avgValueDiam = (avgDiam.length > 0) ? mathj.round(Number(mathj.mean(avgDiam)), dp).toFixed(dp) : 'NA';
            let minValueBL = (minBL.length > 0) ? mathj.round(Number(mathj.min(minBL)), dp).toFixed(dp) : 'NA';
            let maxValueBL = (maxBL.length > 0) ? mathj.round(Number(mathj.max(maxBL)), dp).toFixed(dp) : 'NA';
            let avgValueBL = (avgBL.length > 0) ? mathj.round(Number(mathj.mean(avgBL)), dp).toFixed(dp) : 'NA';

            await models.tbl_batchsummary_masterhtd.update({
              MinValueHard: minValueHard,
              MaxValueHard: maxValueHard,
              AvgValueHard: avgValueHard,
              MinValueThick: minValueThick,
              MaxValueThick: maxValueThick,
              AvgValueThick: avgValueThick,
              MinValueDiam: minValueDiam,
              MaxValueDiam: maxValueDiam,
              AvgValueDiam: avgValueDiam,
              MinValueBL: minValueBL,
              MaxValueBL: maxValueBL,
              AvgValueBL: avgValueBL,
              EndDate: moment().format("YYYY-MM-DD"),
            }, {
              where: {
                RepSerNo: resultData[0].SrNo,
              }
            });
            // await models.tbl_batchsummary_masterhtd.update({
            //   MinValueHard: Number(completeUpdate[0][0].MinHard).toFixed(hardDp),
            //   MaxValueHard: Number(completeUpdate[0][0].MaxHard).toFixed(hardDp),
            //   AvgValueHard: Number(completeUpdate[0][0].AvgHard).toFixed(avgHrd),
            //   MinValueThick: Number(completeUpdate[0][0].MinThick).toFixed(dp),
            //   MaxValueThick: Number(completeUpdate[0][0].MaxThick).toFixed(dp),
            //   AvgValueThick: Number(completeUpdate[0][0].AvgThick).toFixed(dp),
            //   MinValueDiam: Number(completeUpdate[0][0].MinDiam).toFixed(dp),
            //   MaxValueDiam: Number(completeUpdate[0][0].MaxDiam).toFixed(dp),
            //   AvgValueDiam: Number(completeUpdate[0][0].AvgDiam).toFixed(dp),
            //   MinValueBL: Number(completeUpdate[0][0].MinBL).toFixed(dp),
            //   MaxValueBL: Number(completeUpdate[0][0].MaxBL).toFixed(dp),
            //   AvgValueBL: Number(completeUpdate[0][0].AvgBL).toFixed(dp),
            //   EndDate: moment().format("YYYY-MM-DD"),
            // }, {
            //   where: {
            //     RepSerNo: resultData[0].SrNo,
            //   }
            // });

            Object.assign(responseObj, { status: 'success', remark: remark });
            return responseObj;
          }

        }
      }
    } catch (error) {
      throw new Error(error)
    }
  }

  async saveBatchDataHardness8M(masterData, DetailData, idsNo) {
    var now = new Date();
    let responseObj = {};
    // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == idsNo);
    var selectedIds = idsNo;
    // console.log(masterData, DetailData);
    var cubicalObj = globalData.arrIdsInfo.find(
      (k) => k.idsNo == selectedIds
    ).cubicalData;
    var menuDetails = globalData.arr_limits.find((k) => k.idsNo == idsNo);
    var tempLimObj = menuDetails.Menus.filter(
      (obj) => Object.keys(obj) == "Hardness"
    )[0];
    let resultForHardess = {};
    // masterData.RepSerNo
    Object.assign(
      resultForHardess,
      { incompleteTableName: "tbl_tab_master7_incomplete" },
      { incompletedetailTableName: "tbl_tab_detail7_incomplete" }
    );

    let sideVal = "NA";
    if (masterData.Side == "LHS") {
      sideVal = "LEFT";
    } else if (masterData.Side == "RHS") {
      sideVal = "RIGHT";
    } else {
      sideVal = "NA";
    }
    let checkSideMasterTable;
    if (masterData.Side == "NA") {
      checkSideMasterTable = masterData.Side;
    } else {
      checkSideMasterTable = "LEFT";
    }
    let sumHT = 0;
    let arrHTDetail = [];
    let outFlagHTD = 0;
    let remark = "";
    let maxHTDLimit = parseFloat(tempLimObj.Hardness.T1Pos);
    let minHTDLimit = parseFloat(tempLimObj.Hardness.T1Neg);
    let count = DetailData.length;
    for (var i = 0; i < DetailData.length; i++) {
      var dataValHard = parseFloat(DetailData[i].DataValue);
      if (minHTDLimit > dataValHard || dataValHard > maxHTDLimit) {
        outFlagHTD = outFlagHTD + 1;
      }
      arrHTDetail.push(dataValHard);
    }
    if (masterData.T1NegTol != 0) {
      if (outFlagHTD != 0) {
        remark = "Not Complies";
      } else {
        remark = "Complies";
      }
    }

    var resOfSP = await objStoreProcedure.fetchDetailForStats(
      resultForHardess,
      7,
      masterData.RepSerNo
    );
    var MaxHard = resOfSP[1][0]["@maxWeight"]; //Math.max(...arrDetail);
    var MinHard = resOfSP[1][0]["@minWeight"]; //Math.min(...arrDetail);
    var avgHard = resOfSP[1][0]["@average"]; //(finalSum / count);
    if (
      (cubicalObj.Sys_RptType == 0 &&
        cubicalObj.Sys_Validation == 0 &&
        cubicalObj.Sys_CubType == "Compression") ||
      (cubicalObj.Sys_CubType == "Coating" && cubicalObj.Sys_IPQCType != "Compression")
    ) {
      // let res = await proObj.productData(cubicalObj);
      // var paramNom = `Param7_Nom`;
      // var limitNo = `Param7_LimitOn`;
      // var nom = parseFloat(res[1][paramNom]);
      // var limit = res[1][limitNo].readUIntLE();
      // if(masterData.ColHeadDOLOBO == 'Le')

      const checkMasterObj = {
        str_tableName: "tbl_batchsummary_master7",
        data: "MAX(RepSerNo) AS SrNo",
        condition: [
          { str_colName: "BFGCode", value: masterData.BFGCode, comp: "eq" },
          {
            str_colName: "ProductName",
            value: masterData.ProductName,
            comp: "eq",
          },
          { str_colName: "PVersion", value: masterData.PVersion, comp: "eq" },
          { str_colName: "Version", value: masterData.Version, comp: "eq" },
          { str_colName: "Side", value: checkSideMasterTable, comp: "eq" },
          { str_colName: "CubType", value: cubicalObj.Sys_CubType, comp: "eq" },
          { str_colName: "BatchNo", value: masterData.BatchNo, comp: "eq" },
        ],
      };
      var masterSrNo;
      // let DP = await objDP.precision(resultdata.incompleteData.T2PosTol);
      let resultData = await database.select(checkMasterObj);
      let recSeqNo = await this.calculateSeqNo(
        sideVal,
        "tbl_batchsummary_master7",
        "tbl_batchsummary_detail7",
        masterData
      );
      if (resultData[0][0].SrNo == null) {
        let masterDataInsert = {
          str_tableName: "tbl_batchsummary_master7",
          data: [
            { str_colName: "BFGCode", value: masterData.BFGCode },
            { str_colName: "ProductName", value: masterData.ProductName },
            { str_colName: "PVersion", value: masterData.PVersion },
            { str_colName: "Version", value: masterData.Version },
            { str_colName: "PrdType", value: 1 },
            { str_colName: "CubType", value: masterData.CubicleType },
            { str_colName: "BatchNo", value: masterData.BatchNo },
            // { str_colName: 'Stage', value: masterData.Stage },
            { str_colName: "Dept", value: cubicalObj.Sys_dept },
            { str_colName: "Nom", value: masterData.Nom },
            { str_colName: "Tol1Neg", value: masterData.T1NegTol },
            { str_colName: "Tol1Pos", value: masterData.T1PosTol },
            // { str_colName: 'Tol2Neg', value: masterData.Unit },
            // { str_colName: 'Tol2Pos', value: masterData.NomThick },
            { str_colName: "DP", value: 2 },
            { str_colName: "Unit", value: masterData.Unit },
            { str_colName: "Side", value: sideVal },
            {
              str_colName: "BatchCompleted",
              value: masterData.BatchComplete[0],
            },
            { str_colName: "IsArchived", value: masterData.IsArchived[0] },
            { str_colName: "LimitOn", value: 0 },
            { str_colName: "Area", value: cubicalObj.Sys_Area },
            { str_colName: "GenericName", value: cubicalObj.Sys_GenericName },
            { str_colName: "BMRNo", value: cubicalObj.Sys_BMRNo },
            {
              str_colName: "BatchSize",
              value: `${cubicalObj.Sys_BatchSize} ${cubicalObj.Sys_BatchSizeUnit}`,
            },
            { str_colName: "ReportType", value: masterData.GraphType },
          ],
        };
        let saveBatchSumm = await database.save(masterDataInsert);
        masterSrNo = saveBatchSumm[0].insertId;
        const objInsertDetailData = {
          str_tableName: "tbl_batchsummary_detail7",
          data: [
            { str_colName: "RepSerNo", value: masterSrNo },
            { str_colName: "RecSeqNo", value: recSeqNo },
            { str_colName: "Date", value: masterData.PrDate },
            { str_colName: "Time", value: masterData.PrTime },
            { str_colName: "InstrumentID", value: masterData.HardnessID },
            { str_colName: "Side", value: sideVal },
            { str_colName: "Min", value: MinHard },
            { str_colName: "Max", value: MaxHard },
            { str_colName: "Avg", value: avgHard },
            // { str_colName: 'MinTimeDT', value: resultdata.incompleteData.T1PosTol },
            // { str_colName: 'MaxTimeDT', value: resultdata.incompleteData.T2NegTol },
            { str_colName: "TestResult", value: remark },
            { str_colName: "UserID", value: masterData.UserId },
            { str_colName: "UserName", value: masterData.UserName },
          ],
        };
        //console.log(objInsertDetailData);
        let detailResult1 = await database.save(objInsertDetailData);
        Object.assign(responseObj, { status: "success" });
        return remark;
      } else {
        masterSrNo = resultData[0][0].SrNo;
        //     const checkDetailObj = {
        //         str_tableName: detailTable,
        //         data: 'MAX(RecSeqNo) AS SeqNo',
        //         condition: [
        //             { str_colName: 'RepSerNo', value: masterSrNo, comp: 'eq' },
        //         ]
        //     }
        //    let detailres = await database.select(checkDetailObj);
        //         var seqNum = detailres[0][0].SeqNo;
        //         var seqNo = seqNum + 1;
        const objInsertDetailData = {
          str_tableName: "tbl_batchsummary_detail7",
          data: [
            { str_colName: "RepSerNo", value: masterSrNo },
            { str_colName: "RecSeqNo", value: recSeqNo },
            { str_colName: "Date", value: masterData.PrDate },
            { str_colName: "Time", value: masterData.PrTime },
            { str_colName: "InstrumentID", value: masterData.HardnessID },
            { str_colName: "Side", value: sideVal },
            { str_colName: "Min", value: MinHard },
            { str_colName: "Max", value: MaxHard },
            { str_colName: "Avg", value: avgHard },
            // { str_colName: 'MinTimeDT', value: resultdata.incompleteData.T1PosTol },
            // { str_colName: 'MaxTimeDT', value: resultdata.incompleteData.T2NegTol },
            { str_colName: "TestResult", value: remark },
            { str_colName: "UserID", value: masterData.UserId },
            { str_colName: "UserName", value: masterData.UserName },
          ],
        };
        await database.save(objInsertDetailData);
        Object.assign(responseObj, { status: "success" });
        return remark;
      }
    } else {
      return remark;
    }
  }

  async saveBatchDataDiff(typeValue, resultdata, IdsNo, ResultOfReport) {
    try {
      let now = new Date();
      let responseObj = {};
      let arrDetail = [];
      let DP = resultdata.incompleteData.DecimalPoint;
      let avgDp = resultdata.incompleteData.Unit != 'mg' ? 4 : 1
      let strIdsNo = IdsNo;
      let strInstrumentId = "";
      let objProductType = globalData.arrProductTypeArray.find(
        (k) => k.Hmi == IdsNo
      );
      let objArr_limits = globalData.arr_limits.find((k) => k.Hmi == IdsNo);
      let cubicalObj = globalData.arrIdsInfo.find(
        (k) => k.Hmi == IdsNo
      ).cubicalData;
      let masterTable, detailTable, finalSum;
      // const objWeighment = objProductArray.cubicalData;
      let sum = 0;

      masterTable = "tbl_batchsummary_masterdiff";
      detailTable = "tbl_batchsummary_detaildiff";

      for (var i = 0; i < resultdata.detailData.length; i++) {
        var dataVal = resultdata.detailData[i].NetValue;
        arrDetail.push(dataVal);
      }

      for (var j = 0; j < arrDetail.length; j++) {
        sum = sum + parseFloat(arrDetail[j]);
      }

      finalSum = sum;

      var count = arrDetail.length;
      // var maxVal = Math.max(...arrDetail);
      // var minVal = Math.min(...arrDetail);
      // var avgVal = (finalSum / count);
      let remark = "Complies";
      if (ResultOfReport == "Within of Limit") {
        remark = "Complies";
      } else {
        remark = "Not Complies";
      }

      var resOfSP = await objStoreProcedure.fetchDetailForStats(
        resultdata,
        "diff"
      );
      let maxVal = Number(resOfSP.max).toFixed(DP); //Math.max(...arrDetail);
      let minVal = Number(resOfSP.min).toFixed(DP); //Math.min(...arrDetail);
      let avgVal = Number(resOfSP.avg).toFixed(avgDp);

      if (
        cubicalObj.Sys_RptType == 0 &&
        cubicalObj.Sys_Validation == 0 &&
        cubicalObj.Sys_CubType == "Capsule Filling" &&
        cubicalObj.Sys_BatchReuse == 0
      ) {
        let res = await proObj.productData(cubicalObj);
        var paramNom = `Param3_Nom`;
        var limitNo = `Param3_LimitOn`;
        var nom = Number(res[1][paramNom]).toFixed(DP);
        var limit = res[1][limitNo];
        var minPer, maxPer;
        if (limit == 0) {
          //standard
          minPer = Math.abs(((nom - minVal) / nom) * 100);
          maxPer = Math.abs(((maxVal - nom) / nom) * 100);
        } //average
        else {
          minPer = Math.abs(((avgVal - minVal) / avgVal) * 100);
          maxPer = Math.abs(((maxVal - avgVal) / avgVal) * 100);
        }
        if (typeValue == "D") {
          strInstrumentId = resultdata.incompleteData.BalanceId;
        }
        let sideVal = "NA";
        if (resultdata.incompleteData.Side == "LHS") {
          sideVal = "LEFT";
        } else if (resultdata.incompleteData.Side == "RHS") {
          sideVal = "RIGHT";
        } else {
          sideVal = "NA";
        }
        let checkSideMasterTable;
        if (resultdata.incompleteData.Side == "NA") {
          checkSideMasterTable = resultdata.incompleteData.Side;
        } else {
          checkSideMasterTable = "LEFT";
        }
        // We only want to check side for NA and left side in master table so again we declare
        // side variable for this specific perpose
        const checkMasterObj = await models[masterTable].findAll({
          attributes: [
            [sequelize.fn("max", sequelize.col("RepSerNo")), "SrNo"],
          ],
          where: {
            BFGCode: objProductType.productType.ProductId,
            ProductName: objProductType.productType.ProductName,
            PVersion: objProductType.productType.ProductVersion,
            Version: objProductType.productType.Version,
            Side: checkSideMasterTable,
            CubicleType: resultdata.incompleteData.CubicleType,
            BatchNo: resultdata.incompleteData.BatchNo,
          },
        });

        let resultData = [checkMasterObj];
        var masterSrNo;

        let recSeqNo = await this.calculateSeqNo(
          sideVal,
          masterTable,
          detailTable,
          resultdata.incompleteData
        );

        if (resultData[0][0].SrNo == null) {
          const objInsertMasterData = await models[masterTable].create({
            BFGCode: resultdata.incompleteData.BFGCode,
            CubicleName: resultdata.incompleteData.CubicleName,
            ProductName: resultdata.incompleteData.ProductName,
            PVersion: resultdata.incompleteData.PVersion,
            Version: resultdata.incompleteData.Version,
            PrdType: resultdata.incompleteData.ProductType,
            CubicleType: resultdata.incompleteData.CubicleType,
            BatchNo: resultdata.incompleteData.BatchNo,
            Stage: cubicalObj.Sys_Stage,
            Department: cubicalObj.Sys_dept,
            Nom: nom,
            Tol1Neg: resultdata.incompleteData.T1NegNet,
            Tol1Pos: resultdata.incompleteData.T1PosNet,
            Tol2Neg: resultdata.incompleteData.T2NegNet,
            Tol2Pos: resultdata.incompleteData.T2PosNet,
            DP: DP,
            Unit: resultdata.incompleteData.Unit,
            Side: sideVal,
            BatchCompleted:
              resultdata.incompleteData.BatchComplete,
            IsArchived: resultdata.incompleteData.IsArchived,
            LimitOn: limit,
            NMTLimit: resultdata.incompleteData.T1NMTTab,
            Area: cubicalObj.Sys_Area,
            GenericName: cubicalObj.Sys_GenericName,
            BMRNo: cubicalObj.Sys_BMRNo,
            BatchSize: `${cubicalObj.Sys_BatchSize}${cubicalObj.Sys_BatchSizeUnit}`,
            ReportType: resultdata.incompleteData.ReportType,
            StdLimit1: resultdata.incompleteData.StdLimit1,
            StdLimit2: resultdata.incompleteData.StdLimit2
          });
          let masterResult = [objInsertMasterData];
          masterSrNo = masterResult[0].RepSerNo;
          masterSrNo =
            masterSrNo != undefined ? masterSrNo : resultData[0].SrNo;
          var Nominal = Number(resultdata.incompleteData.Nom).toFixed(DP);
          var Per_Dev = ((Nominal - Number(avgVal).toFixed(DP)) / Nominal) * 100;
          Per_Dev = mathj.round(Number(Per_Dev), DP).toFixed(DP);
          const objInsertDetailData = await models[detailTable].create({
            RepSerNo: masterSrNo,
            RecSeqNo: recSeqNo,
            Date: resultdata.incompleteData.PrDate,
            Time: moment(resultdata.incompleteData.PrTime).format('HH:mm:ss'),
            InstrumentID: strInstrumentId,
            Side: sideVal,
            Min_Per: minPer,
            Max_Per: maxPer,
            Min: minVal,
            Max: maxVal,
            Avg: avgVal,
            TestResult: resultdata.incompleteData.Remark,
            UserID: resultdata.incompleteData.UserId,
            UserName: resultdata.incompleteData.UserName,
          });

          var Complies_Result = await models[detailTable].findAll({
            where: {
              RepSerNo: masterSrNo,
              TestResult: "Complies",
              // InstrumentID: resultdata.incompleteData.BalanceId
            },
          });
          var arr = [];
          var arr_min = [];
          var arr_avg = [];
          var max_value = 0;
          var min_value = 0;
          var average = 0;
          var avg = 0;
          if (Complies_Result.length != 0) {
            for (var i = 0; i < Complies_Result.length; i++) {
              var Max = Complies_Result[i].Max;
              arr.push(Number(Max));
              // console.log(arr);
              var Min = Complies_Result[i].Min;
              arr_min.push(Number(Min));
              // console.log(arr_min);
              max_value = maths.max(arr);
              min_value = maths.min(arr_min);
              average = Complies_Result[i].Avg;
              arr_avg.push(Number(average));
              // console.log(average);
              var total = arr_avg.reduce((acc, total) => {
                return Number(total) + Number(acc);
              }, 0);
              avg = total / arr_avg.length;
              avg = mathj.round(Number(avg), avgDp).toFixed(avgDp);
            }
          }
          var update_Master = await models[masterTable].update(
            {
              MaxValue: Number(max_value) == 0 ? "NA" : mathj.round(Number(max_value), DP).toFixed(DP),
              MinValue: Number(min_value) == 0 ? "NA" : mathj.round(Number(min_value), DP).toFixed(DP),
              AvgValue: Number(avg) == 0 ? "NA" : mathj.round(Number(avg), avgDp).toFixed(avgDp),

            },
            {
              where: {
                RepSerNo: masterSrNo,
              },
            }
          );
          // }

          let detailResult = objInsertDetailData;
          Object.assign(responseObj, { status: "success" });
          return responseObj;
        } else {

          masterSrNo = resultData[0][0].SrNo;
          masterSrNo =
            masterSrNo != undefined ? masterSrNo : resultData[0].SrNo;
          var Nominal = Number(resultdata.incompleteData.Nom).toFixed(DP);
          var Per_Dev = ((Nominal - Number(avgVal).toFixed(DP)) / Nominal) * 100;
          Per_Dev = Number(Per_Dev).toFixed(avgDp);
          const objInsertDetailData = await models[detailTable].create({
            RepSerNo: masterSrNo,
            RecSeqNo: recSeqNo,
            Date: resultdata.incompleteData.PrDate,
            Time: moment(resultdata.incompleteData.PrTime).format('HH:mm:ss'),
            InstrumentID: strInstrumentId,
            Side: sideVal,
            Min_Per: minPer,
            Max_Per: maxPer,
            Min: minVal,
            Max: maxVal,
            Avg: avgVal,
            Deviation: Per_Dev,
            TestResult: resultdata.incompleteData.Remark,
            UserID: resultdata.incompleteData.UserId,
            UserName: resultdata.incompleteData.UserName,
          });
          var Complies_Result = await models[detailTable].findAll({
            where: {
              RepSerNo: masterSrNo,
              TestResult: "Complies",
              // InstrumentID: resultdata.incompleteData.BalanceId
            },
          });
          var arr = [];
          var arr_min = [];
          var arr_avg = [];
          var max_value = 0;
          var min_value = 0;
          var average = 0;
          var avg = 0;
          if (Complies_Result.length != 0) {
            for (var i = 0; i < Complies_Result.length; i++) {
              var Max = Complies_Result[i].Max;
              arr.push(Number(Max));
              // console.log(arr);
              var Min = Complies_Result[i].Min;
              arr_min.push(Number(Min));
              // console.log(arr_min);
              max_value = maths.max(arr);
              min_value = maths.min(arr_min);
              average = Complies_Result[i].Avg;
              arr_avg.push(Number(average));
              // console.log(average);
              var total = arr_avg.reduce((acc, total) => {
                return Number(total) + Number(acc);
              }, 0);
              avg = total / arr_avg.length;
              avg = mathj.round(Number(avg), avgDp).toFixed(avgDp);
              // avg = Number(avg).toFixed(DP);
            }
          }
          var update_Master = await models[masterTable].update(
            {
              MaxValue: Number(max_value) == 0 ? "NA" : Number(max_value).toFixed(DP),
              MinValue: Number(min_value) == 0 ? "NA" : Number(min_value).toFixed(DP),
              AvgValue: Number(avg) == 0 ? "NA" : mathj.round(Number(avg), avgDp).toFixed(avgDp),
              // AvgValue: Number(avg) == 0 ? "NA" : Number(avg).toFixed(avgDp),
              CubicleName: resultdata.incompleteData.CubicleName,
            },
            {
              where: {
                RepSerNo: masterSrNo,
              },
            }
          );
          let detailResult = objInsertDetailData;
          Object.assign(responseObj, { status: "success" });
          return responseObj;
        }
      }
    } catch (err) {
      console.log(err);
      return err;
    }
  }

  /**
   *
   * @param {*} masterData
   * @param {*} idsNo
   * @param {*} tempLodData
   * @param {*} tempUserObject
   * @description  `saveBatchSummaryLOD` Save the batch Summary Data for `LOD`
   */
  async saveBatchSummaryLOD(masterData, idsNo, tempLodData, tempUserObject) {
    // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == idsNo);
    var selectedIds = idsNo;
    // if (IPQCObject != undefined) {
    //     selectedIds = IPQCObject.selectedIds;
    // } else {
    //     selectedIds = idsNo;
    // }
    let tempMenuLOD = globalData.arrLODTypeSelectedMenu.find(
      (k) => k.idsNo == idsNo
    );
    var cubicalObj = globalData.arrIdsInfo.find(
      (k) => k.Hmi == selectedIds
    ).cubicalData;
    if (
      (cubicalObj.Sys_RptType == 0 &&
        cubicalObj.Sys_Validation == 0 &&
        cubicalObj.Sys_CubType == "Compression") ||
      (cubicalObj.Sys_CubType == "Coating" && cubicalObj.Sys_IPQCType != "Compression")
    ) {
      let sideVal;
      if (cubicalObj.Sys_RotaryType == "Double") {
        sideVal = "LEFT";
      } else {
        sideVal = "NA";
      }
      let checkSideMasterTable;
      if (cubicalObj.Sys_RotaryType != "Double") {
        checkSideMasterTable = "NA";
      } else {
        checkSideMasterTable = "LEFT";
      }
      const checkMasterObj = await models.tbl_batchsummary_master16.findAll({
        attributes: [
          [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
        ],
        where: {
          BFGCode: cubicalObj.Sys_BFGCode,
          ProductName: cubicalObj.Sys_ProductName,
          PVersion: cubicalObj.Sys_PVersion,
          Version: cubicalObj.Sys_Version,
          Side: checkSideMasterTable,
          CubType: cubicalObj.Sys_CubType,
          BatchNo: cubicalObj.Sys_Batch,
        },
      });

      var masterSrNo;
      let resultData = checkMasterObj;
      let incompleteData = {
        BFGCode: cubicalObj.Sys_BFGCode,
        ProductName: cubicalObj.Sys_ProductName,
        PVersion: cubicalObj.Sys_PVersion,
        Version: cubicalObj.Sys_Version,
        BatchNo: cubicalObj.Sys_Batch,
      };
      let recSeqNo = await this.calculateSeqNo(
        sideVal,
        "tbl_batchsummary_master16",
        "tbl_batchsummary_detail16",
        incompleteData
      );
      let ProdRes = await proObj.productData(cubicalObj);
      let minTemp;
      let maxTemp;
      if (
        cubicalObj.Sys_Area == "Effervescent Granulation" ||
        cubicalObj.Sys_Area == "Granulation"
      ) {
        minTemp = ProdRes[1]["Param1_Low"];
        maxTemp = ProdRes[1]["Param1_Upp"];
        switch (tempMenuLOD.selectedLOD) {
          case "GRANULES DRY ":
            minTemp = ProdRes[1]["Param1_Low"];
            maxTemp = ProdRes[1]["Param1_Upp"];
            break;
          case "GRANULES LUB":
            minTemp = ProdRes[1]["Param2_Low"];
            maxTemp = ProdRes[1]["Param2_Upp"];
            break;
          case "LAYER1 DRY":
            minTemp = ProdRes[1]["Param3_Low"];
            maxTemp = ProdRes[1]["Param3_Upp"];
            break;
          case "LAYER1 LUB":
            minTemp = ProdRes[1]["Param4_Low"];
            maxTemp = ProdRes[1]["Param4_Upp"];
            break;
          case "LAYER2 DRY":
            minTemp = ProdRes[1]["Param5_Low"];
            maxTemp = ProdRes[1]["Param5_Upp"];
            break;
          case "LAYER2 LUB":
            minTemp = ProdRes[1]["Param6_Low"];
            maxTemp = ProdRes[1]["Param6_Upp"];
            break;
        }
      } else {
        minTemp = ProdRes[1]["Param16_T1Neg"];
        maxTemp = ProdRes[1]["Param16_T1Pos"];
      }
      var now = new Date();
      let average =
        ((tempLodData.IniWt - tempLodData.finalWt) / tempLodData.IniWt) * 100;
      let result = "Complies";
      if (minTemp < average && average < maxTemp) {
        result = "Complies";
      } else {
        result = "Not Complies";
      }
      if (resultData[0][0].SrNo == null) {
        let masterDataInsert = await models.tbl_batchsummary_master16.create({
          BFGCode: cubicalObj.Sys_BFGCode,
          ProductName: cubicalObj.Sys_ProductName,
          PVersion: cubicalObj.Sys_PVersion,
          Version: cubicalObj.Sys_Version,
          PrdType: 1,
          CubType: cubicalObj.Sys_CubType,
          BatchNo: cubicalObj.Sys_Batch,
          Stage: cubicalObj.Sys_Stage,
          Dept: cubicalObj.Sys_dept,
          LODLayer: "NA",
          Side: sideVal,
          BatchCompleted: 0,
          IsArchived: 0,
          LimitOn: 0,
          Area: cubicalObj.Sys_Area,
          GenericName: cubicalObj.Sys_GenericName,
          BMRNo: cubicalObj.Sys_BMRNo,
          BatchSize: `${cubicalObj.Sys_BatchSize} ${cubicalObj.Sys_BatchSizeUnit}`,
          ReportType: cubicalObj.Sys_RptType,
        });

        let saveBatchSumm = masterDataInsert;
        masterSrNo = saveBatchSumm[0].insertId;

        let detailDataInsert = await models.tbl_batchsummary_detail16.create({
          RepSerNo: masterSrNo,
          RecSeqNo: recSeqNo,
          Date: moment().format("YYYY-MM-DD"),
          Time: moment().format("HH:mm:ss"),
          InstrumentID: cubicalObj.Sys_MoistID,
          Side: "NA",
          Min: minTemp,
          Max: maxTemp,
          Avg: average,
          TestResult: result,
          UserID: tempUserObject.UserId,
          UserName: tempUserObject.UserName,
          LODStage: cubicalObj.Sys_MAStage,
        });
      } else {
        masterSrNo = resultData[0][0].SrNo;
        await models.tbl_batchsummary_detail16.create({
          RepSerNo: masterSrNo,
          RecSeqNo: recSeqNo,
          Date: moment().format("YYYY-MM-DD"),
          Time: moment().format("HH:mm:ss"),
          InstrumentID: cubicalObj.Sys_MoistID,
          Side: "NA",
          Min: minTemp,
          Max: maxTemp,
          Avg: average,
          TestResult: result,
          UserID: tempUserObject.UserId,
          UserName: tempUserObject.UserName,
          LODStage: cubicalObj.Sys_MAStage,
        });
      }
      return "success";
    } else {
      return "success";
    }
  }

  async calculate_roundoff_value(actualWt, unit) {
    let ActualWt1 = actualWt;
    let Actual_unit = unit;
    if (Actual_unit != undefined) {
      if (Actual_unit == "mg") {
        ActualWt1 = math.round(ActualWt1, 1);
        return ActualWt1;
      }
      if (Actual_unit == "g" || Actual_unit == "gm") {
        ActualWt1 = this.math.round(ActualWt1, 4);
        return ActualWt1;
      }
    }
  }

  async calculatefriab(data) {
    // for (let obj of data) {

    let dataValue = [];
    //fetch details record
    const checkdetailObj = await models.tbl_batchsummary_detail8.findAll({
      where: {
        TestResult: "Complies",
        RepSerNo: data,
      },
    });

    //many records or 1

    for (let obj of checkdetailObj) {
      dataValue.push(Number(obj.Friability));
    }

    //fetch min and max from this arr;
    var min = Math.min(...dataValue);
    var max = Math.max(...dataValue);

    let total = dataValue.reduce((acc, total) => {
      return Number(total) + Number(acc);
    }, 0);

    var avg = total / dataValue.length;
    avg = Number(avg.toFixed(3));
    return {
      min: Number(min).toFixed(3),
      max: Number(max).toFixed(3),
      avg: avg,
    };
  }
  async calculateDTSeqNo(
    side,
    masterTableName,
    detailTableName,
    inCompleteData
  ) {
    try {
      let selectedSide;
      if (side == "NA") {
        selectedSide = side;
      } else {
        selectedSide = "LEFT";
      }
      let selectDetailData = await models[masterTableName].findAll({
        attributes: [
          [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
        ],
        where: {
          BFGCode: inCompleteData.BFGCode,
          ProductName: inCompleteData.ProductName,
          PVersion: inCompleteData.PVersion,
          Version: inCompleteData.Version,
          BatchNo: inCompleteData.BatchNo,
          // Side: selectedSide
        },
      });

      let selectRes = [selectDetailData];
      if (selectRes[0][0].RepSerNo === null) {
        return 1;
      } else {
        var selectDetail;

        selectDetail = await models[detailTableName].findAll({
          attributes: [
            [sequelize.fn("max", sequelize.col("RecSeqNo")), "RepSerNo"],
          ],
          where: {
            RepSerNo: selectRes[0][0].RepSerNo,
            // Side: side
          },
        });

        let reqSeqRes = [selectDetail];
        if (reqSeqRes[0][0].RepSerNo === null) {
          return 1;
        } else {
          return reqSeqRes[0][0].RepSerNo + 1;
        }
      }
    } catch (error) {
      throw new Error(error);
    }
  }
  async calculateSeqNo(side, masterTableName, detailTableName, inCompleteData) {
    try {
      let selectedSide;
      if (side == "NA") {
        selectedSide = side;
      } else {
        selectedSide = "LHS";
      }
      let selectDetailData = await models[masterTableName].findAll({
        attributes: [
          [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
        ],
        where: {
          BFGCode: inCompleteData.BFGCode,
          ProductName: inCompleteData.ProductName,
          PVersion: inCompleteData.PVersion,
          Version: inCompleteData.Version,
          BatchNo: inCompleteData.BatchNo,
          Side: selectedSide,
        },
      });
      let selectRes = [selectDetailData];
      if (selectRes[0][0].RepSerNo === null) {
        return 1;
      } else {
        var selectDetail;

        selectDetail = await models[detailTableName].findAll({
          attributes: [
            [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
            [sequelize.fn("max", sequelize.col("RecSeqNo")), "RecSeqNo"],
          ],
          where: {
            RepSerNo: selectRes[0][0].RepSerNo,
            Side: side,
          },
        });
        let reqSeqRes = [selectDetail];
        if (reqSeqRes[0][0].RepSerNo === null) {
          return 1;
        } else {
          return reqSeqRes[0][0].RecSeqNo + 1;
        }
      }
    } catch (error) {
      throw new Error(error);
    }
  }

  async saveGroupBatchData(resultdata, typeValue, strHmi, strIdsNo, strMastertbl, limit_batch) {
    try {
      let responseObj = {};

      // resultdata = resultdata.length > 1 ? resultdata[0]: resultdata;

      let strInstrumentId = "";
      let masterTable, detailTable, finalSum;
      let typeVal, sideVal, checkSideMasterTable;
      const objProductArray = globalData.arrIdsInfo.find(k => k.Hmi == strHmi);
      const objWeighment = objProductArray.cubicalData;

      let selectedIdsNo;


      if (objWeighment.Sys_RotaryType == "Single") {
        resultdata = resultdata.length == undefined ? resultdata : resultdata[0]
      }
      if (objWeighment.Sys_RotaryType == "Double") {
        resultdata = resultdata.length >= 1 ? resultdata[0] : resultdata
      }

      let selectedCubical = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;

      let objProductTypeDetails = globalData.arrProductTypeArray.find(k => k.Hmi == strHmi);
      const objProdMasterDetails = objProductTypeDetails.productType;
      const objProdDetail = objProductTypeDetails.productDetail[0][0];
      const arrCheck = [1, 3, 4, 5, 6, 8, 'L', 9, 11, 2, 10, 12];

      if (arrCheck.some(type => type == typeValue)) {
        if (typeValue == 9) {
          masterTable = 'tbl_batchsummary_master9';
          detailTable = 'tbl_batchsummary_detail9';
        }
        else if (typeValue == 'L') {
          masterTable = 'tbl_batchsummary_master11';
          detailTable = 'tbl_batchsummary_detail11';
        }
        else {
          if (objProdMasterDetails.ProductType == 2 || objProdMasterDetails.ProductType == 1) {
            if (typeValue == 4) {
              masterTable = 'tbl_batchsummary_master6';
              detailTable = 'tbl_batchsummary_detail6';
            }
            else {
              masterTable = 'tbl_batchsummary_master' + typeValue;
              detailTable = 'tbl_batchsummary_detail' + typeValue;
            }

          }
          else {
            if (cubicalObj.Sys_Area == 'Dosa Dry Syrup') {
              masterTable = 'tbl_batchsummary_master19';
              detailTable = 'tbl_batchsummary_detail19';
            } else {
              masterTable = 'tbl_batchsummary_master' + typeValue;
              detailTable = 'tbl_batchsummary_detail' + typeValue;
            }
          }

        }
        let detaildata;
        if (objProdMasterDetails.ProductType == 1) {
          if (typeValue == 2) {
            detaildata = 'tbl_tab_detail2'
          } else if (typeValue == 10) {
            detaildata = 'tbl_tab_detail10'
          } else {
            detaildata = 'tbl_tab_detail12'
          }
        } else {
          detaildata = 'tbl_cap_detail2'
        }
        let detdata = await models[detaildata].findAll({
          where: {
            BatchNo: resultdata.incompleteData.BatchNo,
            BFGCode: resultdata.incompleteData.BFGCode
          }
        })


        let sum = detdata.reduce((acc, obj) => { return acc + Number(obj.DataValue); }, 0);
        finalSum = sum;


        if (typeValue == 8) {
          typeVal = 9;
        }
        else if (typeValue == 'L') {
          typeVal = 11;
        }
        else if (typeValue == 'P') {
          typeVal = 18;
        }
        else {
          typeVal = typeValue;
        }
        let resultdata1 = resultdata.incompleteData.RepSerNo
        let info;
        let resOfSP = await this.fetchDetailForStats(resultdata, typeValue);
        let maxVal = resOfSP.max;
        let minVal = resOfSP.min; //Math.min(...arrDetail);
        let avgVal = resOfSP.avg;  //(finalSum / count);
        if ((objWeighment.Sys_RptType == 0) &&
          (objWeighment.Sys_Validation == 0)) {
          if ((objWeighment.Sys_CubType == 'Compression') || (objWeighment.Sys_CubType == 'Coating' && objWeighment.Sys_IPQCType != "Compression") ||
            (objWeighment.Sys_CubType == 'Capsule Filling') || (objWeighment.Sys_CubType == 'IPQC') || (objWeighment.Sys_CubType == 'Dosa Dry')) {
            let res = objProdDetail;
            let paramNom = `Param${typeVal}_Nom`;
            let limitNo = `Param${typeVal}_LimitOn`;
            let nom = parseFloat(res[paramNom]);
            let limit = res[limitNo];
            let minPer, maxPer;
            if (limit == 0)//standard
            {
              minPer = Math.abs(((nom * minVal) / 100) - nom);
              maxPer = Math.abs(((nom * maxVal) / 100) + nom);
              //minPer = Math.abs(((nom - minVal) / nom) * 100);
              //maxPer = Math.abs(((maxVal - nom) / nom) * 100);
            }
            else//average
            {
              minPer = Math.abs(((avgVal - minVal) / avgVal) * 100);
              maxPer = Math.abs(((maxVal - avgVal) / avgVal) * 100);
            }
            if (typeValue == "1" || typeValue == "8" || typeValue == "L"
              || typeValue == "9" || typeValue == "K") {
              strInstrumentId = resultdata.incompleteData.BalanceId;
            } else if (typeValue == "3" || typeValue == "4" || typeValue == "5" || typeValue == "6") {
              strInstrumentId = resultdata.incompleteData.VernierId;
            }

            if (resultdata.incompleteData.Side == 'LHS') {
              sideVal = "LEFT";
            } else if (resultdata.incompleteData.Side == 'RHS') {
              sideVal = "RIGHT";
            } else {
              sideVal = "NA";
            }
            if (resultdata.incompleteData.Side == 'NA') {
              checkSideMasterTable = resultdata.incompleteData.Side;
            } else {
              checkSideMasterTable = 'LEFT';
            }
            // We only want to check side for NA and left side in master table so again we declare 
            // side variable for this specific perpose
            const checkMasterObj = await models[masterTable].findAll({
              attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'SrNo']],
              where: {
                BFGCode: resultdata.incompleteData.BFGCode,
                ProductName: resultdata.incompleteData.ProductName,
                PVersion: resultdata.incompleteData.PVersion,
                Version: resultdata.incompleteData.Version,
                // Side: checkSideMasterTable,
                CubicleType: resultdata.incompleteData.CubicleType,
                BatchNo: resultdata.incompleteData.BatchNo,
                ReportType: resultdata.incompleteData.ReportType,

              }
            })
            // {
            //     str_tableName: masterTable,
            //     data: 'MAX(RepSerNo) AS SrNo',
            //     condition: [
            //         { str_colName: 'BFGCode', value: resultdata.incompleteData.BFGCode, comp: 'eq' },
            //         { str_colName: 'ProductName', value: resultdata.incompleteData.ProductName, comp: 'eq' },
            //         { str_colName: 'PVersion', value: resultdata.incompleteData.PVersion, comp: 'eq' },
            //         { str_colName: 'Version', value: resultdata.incompleteData.Version, comp: 'eq' },
            //         { str_colName: 'Side', value: checkSideMasterTable, comp: 'eq' },
            //         { str_colName: 'CubType', value: resultdata.incompleteData.CubicleType, comp: 'eq' },
            //         { str_colName: 'BatchNo', value: resultdata.incompleteData.BatchNo, comp: 'eq' },
            //     ]
            // }
            let resultData = checkMasterObj;
            let masterSrNo;
            let DP = resultdata.incompleteData.DecimalPoint;
            const SampleRemark = globalData.arrSampleRemarkForAllTest.find(k => k.Hmi == strHmi);
            var remark = 'Complies';
            if (limit_batch != undefined) {
              if (limit_batch == "Not Complies") {
                remark = "Not Complies";
              } else {
                remark = "Complies";
              }
            }
            let mastertab;
            if (objProdMasterDetails.ProductType == 2) {
              mastertab = 'tbl_cap_master2'
            } else {
              if (typeValue == 2) {
                mastertab = 'tbl_tab_master2'
              } else if (typeValue == 10) {
                mastertab = 'tbl_tab_master10'
              } else {
                mastertab = 'tbl_tab_master12'
              }
            }
            const __paramProductInfoData = {
              side: resultdata.incompleteData.Side,
              masterTable: mastertab,
              detailTable: detaildata,
              BFGCode: resultdata.incompleteData.BFGCode,
              ProductName: resultdata.incompleteData.ProductName,
              PVersion: resultdata.incompleteData.PVersion,
              Version: resultdata.incompleteData.Version,
              BatchNo: resultdata.incompleteData.BatchNo,
              CubicleType: resultdata.incompleteData.CubicleType,
              ReportType: resultdata.incompleteData.ReportType,
            }


            let recSeqNo = await this.calculateSeqNo(__paramProductInfoData.side, mastertab, detaildata, __paramProductInfoData);

            if (resultData[0].SrNo == null) {
              const objInsertMasterData = await models[masterTable].create({
                Area: resultdata.incompleteData.Area,
                BFGCode: resultdata.incompleteData.BFGCode,
                ProductName: resultdata.incompleteData.ProductName,
                PVersion: resultdata.incompleteData.PVersion,
                Version: resultdata.incompleteData.Version,
                PrdType: resultdata.incompleteData.ProductType,
                CubicleType: resultdata.incompleteData.CubicleType,
                BatchNo: resultdata.incompleteData.BatchNo,
                // Stage: selectedCubical.Sys_Stage,
                Department: selectedCubical.Sys_dept,
                Nom: nom,
                Tol1Neg: resultdata.incompleteData.T1NegTol,
                Tol1Pos: resultdata.incompleteData.T1PosTol,
                Tol2Neg: resultdata.incompleteData.T2NegTol,
                Tol2Pos: resultdata.incompleteData.T2PosTol,
                DP: DP,
                //LODLayer: resultdata.incompleteData.UserId ,
                Unit: resultdata.incompleteData.Unit,
                FinalMinDT: resultdata.incompleteData.PrDate,
                FinalMaxDT: resultdata.incompleteData.PrDate,
                FinalAvgDT: resultdata.incompleteData.PrDate,
                Side: sideVal,
                MinValue: minVal == null ? detdata[0].DataValue : minVal,
                MaxValue: maxVal == null ? detdata[0].DataValue : maxVal,
                AvgValue: avgVal == null ? detdata[0].DataValue : avgVal,
                // BatchCompleted: resultdata.incompleteData.BatchComplete,
                BatchCompleted: Buffer.isBuffer(resultdata.incompleteData.BatchComplete) ? resultdata.incompleteData.BatchComplete[0] : resultdata.incompleteData.BatchComplete,
                // IsArchived: resultdata.incompleteData.IsArchived,
                IsArchived: Buffer.isBuffer(resultdata.incompleteData.IsArchived) ? resultdata.incompleteData.IsArchived[0] : resultdata.incompleteData.IsArchived,
                LimitOn: limit,
                NMTLimit: resultdata.incompleteData.T1NMTTab,
                // Area: selectedCubical.Sys_Area,
                GenericName: resultdata.incompleteData.GenericName,
                BMRNo: resultdata.incompleteData.BMRNo,
                BatchSize: `${selectedCubical.Sys_BatchSize}`,
                ReportType: resultdata.incompleteData.ReportType

              })

              let masterResult = objInsertMasterData;
              masterSrNo = masterResult.RepSerNo;
              const objInsertDetailData = await models[detailTable].create({
                RepSerNo: masterSrNo,
                RecSeqNo: recSeqNo,
                Date: resultdata.incompleteData.PrDate,
                Time: moment(resultdata.incompleteData.PrTime).format('HH:mm:ss'),
                InstrumentID: resultdata.incompleteData.BalanceId,
                Side: sideVal,
                Min_Per: isNaN(minPer) ? detdata[0].DataValue : minPer,
                Max_Per: isNaN(minPer) ? detdata[0].DataValue : maxPer,
                Min: minVal == null ? detdata[0].DataValue : minVal,
                Max: maxVal == null ? detdata[0].DataValue : maxVal,
                Avg: avgVal == null ? detdata[0].DataValue : avgVal,
                // { str_colName: 'MinTimeDT: resultdata.incompleteData.T1PosTol,
                // { str_colName: 'MaxTimeDT: resultdata.incompleteData.T2NegTol,
                TestResult: resultdata.incompleteData.Remark,
                UserID: resultdata.incompleteData.UserId,
                UserName: resultdata.incompleteData.UserName,


              })
              var update_Master = await models[masterTable].update({
                Min_Per: isNaN(minPer) ? detdata[0].DataValue : minPer,
                Max_Per: isNaN(minPer) ? detdata[0].DataValue : maxPer,
              }, {
                where: {
                  RepSerNo: masterSrNo,
                }
              });
              Object.assign(responseObj, { status: 'success' })
              return responseObj;

            } else {
              masterSrNo = resultData[0].SrNo;
              //     const checkDetailObj = {
              //         str_tableName: detailTable,
              //         data: 'MAX(RecSeqNo) AS SeqNo',
              //         condition: [
              //             { str_colName: 'RepSerNo', value: masterSrNo, comp: 'eq' },
              //         ]
              //     }
              //    let detailres = await database.select(checkDetailObj);
              //         var seqNum = detailres[0][0].SeqNo;
              //         var seqNo = seqNum + 1;
              let checkMasterObj = await models[strMastertbl].findAll({
                where: {
                  BFGCode: resultdata.incompleteData.BFGCode,
                  ProductName: resultdata.incompleteData.ProductName,
                  PVersion: resultdata.incompleteData.PVersion,
                  Version: resultdata.incompleteData.Version,
                  // Side: checkSideMasterTable,
                  CubicleType: resultdata.incompleteData.CubicleType,
                  ReportType: resultdata.incompleteData.ReportType,
                  BatchNo: resultdata.incompleteData.BatchNo
                }
              })

              const objInsertDetailData = await models[detailTable].create({
                RepSerNo: masterSrNo,
                RecSeqNo: recSeqNo,
                Date: resultdata.incompleteData.PrDate,
                Time: moment(resultdata.incompleteData.PrTime).format('HH:mm:ss'),
                InstrumentID: resultdata.incompleteData.BalanceId,
                Side: sideVal,
                Min_Per: isNaN(minPer) ? detdata[0].DataValue : minPer,
                Max_Per: isNaN(minPer) ? detdata[0].DataValue : maxPer,
                Min: minVal == null ? detdata[0].DataValue : minVal,
                Max: maxVal == null ? detdata[0].DataValue : maxVal,
                Avg: avgVal == null ? detdata[0].DataValue : avgVal,
                // { str_colName: 'MinTimeDT: resultdata.incompleteData.T1PosTol,
                // { str_colName: 'MaxTimeDT: resultdata.incompleteData.T2NegTol,
                TestResult: resultdata.incompleteData.Remark,
                UserID: resultdata.incompleteData.UserId,
                UserName: resultdata.incompleteData.UserName,

              })
              let res = await this.fetchallBatchDetailsRecord(mastertab, checkMasterObj, detaildata)


              // const objInsertDetailData = await models[detailTable].update({
              //   // RepSerNo: masterSrNo,
              //   // RecSeqNo: recSeqNo,
              //   Date: resultdata.incompleteData.PrDate,
              //   Time: moment(resultdata.incompleteData.PrTime).format('HH:mm:ss'),
              //   // InstrumentID: resultdata.incompleteData.BalanceId,
              //   Side: sideVal,
              //   MinPer: res.min,
              //   MaxPer: res.avg,
              //   Min: res.min,
              //   Max: res.max,
              //   Avg: res.avg,
              //   // { str_colName: 'MinTimeDT: resultdata.incompleteData.T1PosTol ,
              //   // { str_colName: 'MaxTimeDT: resultdata.incompleteData.T2NegTol ,
              //   // { str_colName: 'AvgTimeDT: resultdata.incompleteData.T2PosTol ,
              //   TestResult: remark,
              //   UserID: resultdata.incompleteData.UserId,
              //   UserName: resultdata.incompleteData.UserName,

              // }, {
              //   where: {
              //     RepSerNo: masterSrNo,
              //   }
              // })


              const objupdateData = await models[masterTable].update({
                MinValue: Number(res.min).toFixed(3),
                MaxValue: Number(res.max).toFixed(3),
                AvgValue: Number(res.avg).toFixed(4)
              }, { where: { RepSerNo: masterSrNo, } });

              let detailResult = (objInsertDetailData);
              Object.assign(responseObj, { status: 'success' })
              return responseObj;
            }

          }
        }
      } else {
        return false;
      }

    } catch (error) {
      console.log(error);
      throw new Error(error)
    }
  }

  async fetchDetailForStats(resultdata, TestType, RepSerNoFromTable = 0) {
    try {

      var masterTable, detailTable, RepSerNo;
      var int_paramNo;
      if (RepSerNoFromTable == 0) {
        var RepSerNo = resultdata.incompleteData.RepSerNo
      } else {
        var RepSerNo = RepSerNoFromTable
      }
      masterTable = resultdata.incompleteTableName;
      detailTable = resultdata.incompletedetailTableName;

      let storedProcedureQuery = await models[detailTable].findAll({
        where: {
          RepSerNo: RepSerNo
        }
      })

      var array = []
      if (TestType == 'diff') {
        for (var i = 0; i < storedProcedureQuery.length; i++) {
          var arr = storedProcedureQuery[i].NetValue;
          array.push(arr)
        }
      } else {
        for (var i = 0; i < storedProcedureQuery.length; i++) {
          var arr = storedProcedureQuery[i].DataValue;
          array.push(arr)
        }
      }

      var obj = {}
      let min = maths.min(array)
      obj["min"] = min;
      let max = maths.max(array)
      obj["max"] = max;
      console.log(min, max);

      let total = array.reduce((acc, total) => {
        return Number(total) + Number(acc);
      }, 0)
      let avg = total / array.length
      obj["avg"] = avg;
      console.log(avg)
      return obj;








      // if(true) {
      //     var config = {
      //         user: 'sa',
      //         password: '123',
      //         server: 'TS1033\\SQLEXPRESS',
      //         database: 'increncyV4_indore',
      //         options: {
      //             encrypt: true,
      //             enableArithAbort: true
      //         },
      //     };

      //     // request.input('detailTableName',sql.VarChar(100),detailTable);
      //     // request.input('RepSerNo',sql.Int,parseInt(RepSerNo));
      //     // request.input('weighmentModeNumber',sql.Int,parseInt(TestType));
      //     let pool = await sql.connect(config)
      //     let result2 = await pool.request()
      //         .input('detailTableName',sql.VarChar(100),detailTable)
      //         .input('RepSerNo',sql.Int,parseInt(RepSerNo))
      //         .input('weighmentModeNumber',sql.Int,parseInt(TestType))
      //         .output('minDataValue',sql.VarChar(15))
      //         .output('maxDataValue',sql.VarChar(15))
      //         .output('avgDataValue',sql.VarChar(15))
      //         .execute('batchSummaryReportCalculationsForInterface');
      //         console.log(result2)



      // let storedProcedureQuery = `CALL userManagement('${userId}','${userPass}','${source}','${ip}',@message,@userName);SELECT @message,@userName;`;    
      // var result = await sequelize.query(storedProcedureQuery,{ type: QueryTypes.SELECT });
      // return result;

      // }
      // let storedProcedureQuery =`CALL batchSummaryReportCalculationsForInterface('${detailTable}','${RepSerNo}','${TestType}',@minWeight,@maxWeight,@average);SELECT @minWeight,@maxWeight,@average;`;    
      // var result = await sequelize.query(storedProcedureQuery,{ type: QueryTypes.SELECT });
      // return result;

      // // let storedProcedureQuery= await sequelize.query
      // ( ,{ type: QueryTypes.SELECT }).then(function (rows){
      //     console.log(rows);
      // })
    } catch (error) {
      console.log(error)

    }

  }
  async fetchallBatchDetailsRecord(masterTable, resultdata, detailTable) {
    try {
      let dataValue = []




      for (let obj of resultdata) {


        //fetch details record
        const checkdetailObj = await models[detailTable].findAll({
          where: {
            RepSerNo: obj.RepSerNo,
            Remark: "Complies"
            // Sys_Validation: 0
          }
        });

        //many records or 1

        for (let obj of checkdetailObj) {
          dataValue.push(obj.DataValue)
        }



      }

      //fetch min and max from this arr;
      let min = Math.min(...dataValue)
      let max = Math.max(...dataValue)


      let total = dataValue.reduce((acc, total) => {
        return Number(total) + Number(acc);
      }, 0)

      let avg = total / dataValue.length
      return {
        min: Number(min).toFixed(3),
        max: Number(max).toFixed(3),
        avg: Number(avg).toFixed(4)
      }

    } catch (error) {
      console.log(error);
    }
  }
}
module.exports = BatchSummary;
