//packages
const date = require('date-and-time');
const moment = require('moment')
//modules
const clsHmiModel = require('../hmiDetail.model');
const Database = require('../../database/clsQueryProcess');
const globalData = require('../../global/globalData');
const PreWeighmentCheck = require('../preWeighmentCheck');
const serverConfig = require('../../global/serverConfig');
const clsFormulaFun = require('../Product/clsformulaFun.model');
const GLOBAL_NOMENCLATURE = require('../../global/GLOBAL_NOMENCLATURE');
const clsCommonOperation = require('../Product/clsCommonInsertOperation.model');
const IPC = require('../IPC/ipc.model');
const { length, unique } = require('joi/lib/types/array');
const models = require('../../../config/dbConnection').models;
const sequelize = require('../../../config/dbConnection').sequelize;
const { QueryTypes } = require('sequelize');
const Hmi = require('../hmiDetail.model');
const { variance } = require('stats-lite');
const { Op } = require('sequelize');
const clsCalibCommonOperation = require('../Calibration/clsCalibCommonFunction.model');
const { log } = require('winston');

//instances of classes
const objHmiModel = new clsHmiModel();
const database = new Database();
const objPreCheck = new PreWeighmentCheck();
const objFormulaFun = new clsFormulaFun();
const objCommonOperation = new clsCommonOperation();
const objCalibCommonOperation = new clsCalibCommonOperation();

let now = new Date();
var ipcWeighment = new IPC()


class Menu {

    async getMenu(values) {
        try {
            let resObj = {};
            let strHmi = values.Hmi;
            let strUserId = values.userId;
            let strUserName = values.userName;
            let objIdsNo = await objHmiModel.getResbPiNoFromHmi(strHmi);
            let IdsNo = objIdsNo[0].IDSNo;
            let selectedIdsNo;
            let objCalibratedBal = globalData.glbArrListOfCalibratedBal.find(k => k.Hmi == strHmi);
            if (objCalibratedBal == undefined) {
                globalData.glbArrListOfCalibratedBal.push({
                    idsNo: IdsNo,
                    Hmi: strHmi,
                    CalibratedBalList: [" "]
                });
            }
            else {
                objCalibratedBal.CalibratedBalList = [" "];
            }

            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
            // if (IPQCObject != undefined) {
            //     selectedIdsNo = IPQCObject.selectedIds;
            // } else {
            selectedIdsNo = IdsNo;
            // }

            var selectedHmi = await objHmiModel.getHmiNoFromResbPi(selectedIdsNo);

            let checkFri = globalData.arrBFBO.find(k => k.idsNo == IdsNo);

            if (checkFri == undefined) {
                globalData.arrBFBO.push({ idsNo: IdsNo, before: false, setParam: false, after: false });
            } else {
                checkFri.idsNo = IdsNo;
            }

            (globalData.arrcalibType.findIndex((element) => element.Hmi === strHmi)) == -1 ?
                globalData.arrcalibType : globalData.arrcalibType.splice(globalData.arrcalibType.findIndex((element) => element.Hmi === strHmi), 1);

            (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ?
                globalData.arrCurrentOperationStatus :
                globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);

            var tempArrRightsObj = globalData.arrUserRights.find(k => k.Hmi == strHmi);
            if (tempArrRightsObj == undefined) {
                tempArrRightsObj = globalData.arrUserRights.find(k => k.selectedIds == strHmi);
                if (tempArrRightsObj != undefined) {
                    if (!tempArrRightsObj.rights.includes('Test')) {
                        return Object.assign(resObj, {
                            status: 'fail',
                            message: 'User does not have Test right'
                        })
                    }
                } else {
                    console.log("Data incorrect rights");
                }
            }

            if (!tempArrRightsObj.rights.includes('Test')) {
                return Object.assign(resObj, {
                    status: 'fail',
                    message: 'User does not have Test right'
                })
            }


            var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
            /// let CheckHmi = IPQCObject.idsNo == undefined?selectedHmi : IPQCObject.idsNo;
            if (IPQCObject != undefined) {
                var cubicalO = await models.tbl_cubical.findAll({
                    where: {
                        Sys_IDSNo: selectedHmi
                    }
                })
                cubicalO = cubicalO.pop()
            }
            if (IPQCObject != undefined) {
                selectedHmi = IPQCObject.selectedIds.Idsno;
            }
            var cubicalObj = await models.tbl_cubical.findAll({
                where: {
                    Sys_IDSNo: selectedHmi
                }
            })

            let area = cubicalObj[0].Sys_CubType;
            let ipqcArea = cubicalObj[0].Sys_IPQCType;

            // if (ipqcArea == "Compression" || ipqcArea == "Coating") {
            //     area = ipqcArea;
            // }

            if (area == "IPQC") area = ipqcArea;

            let arrResCubicalObj = [[cubicalObj[0]]];


            if (arrResCubicalObj[0].length < 0) {
                //return with error message
                console.log('no entry in cubical');
            }
            if (cubicalO != undefined) {
                if (cubicalO.Sys_BalID != 'None') {
                    if (cubicalObj[0].Sys_BalID != cubicalO.Sys_BalID) {
                        arrResCubicalObj[0][0].Sys_BalID = cubicalO.Sys_BalID
                    }
                }
            }
            let cubicObj = globalData.arrIdsInfo.find(k => k.idsNo == selectedIdsNo);
            if (cubicObj == undefined) {
                globalData.arrIdsInfo.push({
                    Hmi: strHmi,
                    idsNo: IdsNo,
                    cubicalData: arrResCubicalObj[0][0]
                })
            } else {
                cubicObj.idsNo = IdsNo;
                cubicObj.cubicalData = arrResCubicalObj[0][0];
            }
            if (selectedHmi != strHmi) {
                selectedHmi = strHmi
            }
            await objCalibCommonOperation.releaseCalibrationInProcess(arrResCubicalObj[0][0].Sys_CubicNo)

            let checkIfProductSet = await objPreCheck.CheckProductSet(selectedHmi);
            if (!checkIfProductSet) {
                return Object.assign(resObj, { status: 'fail', message: 'Product not set' })
            }

            let checkBatchStatus = await objPreCheck.CheckBatchStatus(selectedIdsNo, selectedHmi);
            if (!checkBatchStatus.status) {
                return Object.assign(resObj, { status: 'fail', message: checkBatchStatus.message })
            }

            await this.lockedWeighingStatus(arrResCubicalObj[0][0].Sys_CubicNo, arrResCubicalObj[0][0].Sys_Batch, arrResCubicalObj[0][0].Sys_CubType)

            if (IPQCObject != undefined) {
                let weighstatus = globalData.weighmentstatus.find(k => k.status == arrResCubicalObj[0][0].Sys_CubicNo);
                // if (weighstatus != undefined) {
                //     await this.UnlockedWeighingStatus(weighstatus.status)
                // }
                if (weighstatus == undefined) {
                    globalData.weighmentstatus.push({
                        status: arrResCubicalObj[0][0].Sys_CubicNo,
                        strHmi: selectedHmi
                    })
                } else {
                    weighstatus.status = arrResCubicalObj[0][0].Sys_CubicNo
                }
            }
            // let cubicObjCurrent = globalData.arrIdsInfo.find(k => k.Hmi == selectedHmi).cubicalData;

            const Product = {
                ProductId: arrResCubicalObj[0][0].Sys_BFGCode,
                ProductName: arrResCubicalObj[0][0].Sys_ProductName,
                ProductVersion: arrResCubicalObj[0][0].Sys_PVersion,
                Version: arrResCubicalObj[0][0].Sys_Version,
            }

            const selectProductMaster = await models.tbl_product_master.findAll({
                where: {
                    ProductName: Product.ProductName,
                    ProductId: Product.ProductId,
                    ProductVersion: Product.ProductVersion,
                    Version: Product.Version
                }
            })

            var productType = selectProductMaster[0].ProductType;

            let cubicObjCurrent = globalData.arrIdsInfo.find(k => k.idsNo == IdsNo).cubicalData;

            const __parameterObj = {
                Product: Product,
                IdsNo: IdsNo,
                CubicalType: cubicObjCurrent.Sys_CubType,
                AreaInCubical: cubicObjCurrent.Sys_Area,
                AllCubicalData: cubicObjCurrent,
                Hmi: strHmi
            }
            var processMenu = await this.processCubical(__parameterObj, IdsNo);
            if (processMenu == undefined) {
                processMenu = [processMenu]
                return Object.assign(resObj, { status: 'fail' })
            }
            if (processMenu[0] == "") {
                return Object.assign(resObj, { status: 'fail', message: 'Check Configuration' })
            }
            if (cubicObjCurrent.Sys_Area == 'Coating') {
                processMenu = processMenu.filter(function (item) {
                    return !item.includes('Layer');
                });

                console.log(processMenu);
            }
            if (cubicObjCurrent.Sys_BatchReuse == 1) {
                processMenu = processMenu.filter(k => k != "Group")
            }

            // for(const processMenu1 of processMenu){
            //     var remark = await this.VerifyReport(processMenu1,cubicObjCurrent,productType)
            //     if(remark == true){
            //         return Object.assign(resObj, { status: 'fail', message: 'Unable To Continue, Verify Report' })
            //     }
            // }
            var selectRepSrNoObj = await models.tbl_powerbackup.findAll({
                where: {
                    CubicalNo: cubicObjCurrent.Sys_CubicNo
                }
            })

            // if (area == "Compression" || area == "Coating") {
            //     processMenu = processMenu.concat("Appearance");
            // }

            let powerbacc = [selectRepSrNoObj];
            powerbacc = powerbacc[0].pop();
            let time;
            var FriabMain = ''
            var FriabSide;
            var FriabSide1;
            var FraibSidelhs;
            var FraibSideBeforeRhs;
            var FraibSideBeforeLhs;
            var FraibSideAfterLhsFin;
            let Before_Count = 0;
            let After_Count = 0;

            if (powerbacc != undefined && powerbacc.WeighmentName.includes('FRIAB')) {
                if (powerbacc.Before_Count == 1 && cubicObjCurrent.Sys_RotaryType == "Double") {
                    FriabSide = await models.tbl_tab_friability.findAll({
                        where: {
                            RepSerNo: powerbacc.Incomp_RepSerNo,
                            UserID: powerbacc.Userid,
                            IdsNo: powerbacc.Idsno

                        }
                    })
                    FriabSide = FriabSide[0].LWtBeforeTest
                    // FriabSide1 = await models.tbl_tab_detail8.findAll({
                    //     //  attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
                    //     //  attributes: [[sequelize.fn('max', sequelize.col('RecNo')), 'RecNo']],
                    //     where: {
                    //         RecNo: FriabSide[0].RecNo

                    //     }
                    // })

                    // FriabMain = FriabSide1[0].Side

                    // if (FriabMain == 'LHS') {
                    //     FriabMain = 'RHS'
                    // } else {
                    //     FriabMain = 'LHS'
                    // }
                }
                else {
                    if (powerbacc.After_Count == 1 && cubicObjCurrent.Sys_RotaryType == "Double" && powerbacc.WeighmentName.includes('FRIAB')) {
                        FriabSide1 = await models.tbl_tab_friability.findAll({
                            where: {
                                RepSerNo: powerbacc.Incomp_RepSerNo,
                                UserID: powerbacc.Userid,
                                IdsNo: powerbacc.Idsno

                            }
                        })
                        FriabSide1 = FriabSide1[0].LWtBeforeTest
                        // var sqlquery = `SELECT * FROM tbl_tab_detail8 WHERE RepSerNo = (SELECT MAX(RepSerNo) FROM tbl_tab_master8 WHERE BatchNo = '${cubicObjCurrent.Sys_Batch}') AND DataValue2 = 0 AND Side = '${FriabilityDetail1.data.Side}' AND IdsNo = '${strHmi}' `

                        // var resBatch = await sequelize.query(sqlquery, {
                        //     type: QueryTypes.SELECT
                        // }); 

                        FriabMain = FriabSide1[0].Side

                        if (FriabMain == 'LHS') {
                            FriabMain = 'LHS'
                        } else {
                            FriabMain = 'RHS'
                        }
                    }
                }

                // powerbackup condition when LHS value of after weight is received logged out
                if (powerbacc.Before_Count == 2 && powerbacc.After_Count == 1 && cubicObjCurrent.Sys_RotaryType == "Double" && powerbacc.WeighmentName.includes('FRIAB')) {
                    FraibSidelhs = await models.tbl_tab_friability.findAll({
                        where: {
                            RepSerNo: powerbacc.Incomp_RepSerNo,
                            UserID: powerbacc.Userid,
                            IdsNo: powerbacc.Idsno,
                        }
                    })
                    if (FraibSidelhs.length != 0) {
                        FraibSideBeforeLhs = FraibSidelhs[0].LWtBeforeTest + ' ' + 'g'
                        FraibSideBeforeRhs = FraibSidelhs[0].RWtBeforeTest + ' ' + 'g'
                        FraibSideAfterLhsFin = FraibSidelhs[0].LWtAfterTest + ' ' + 'g'
                    }

                    var side_friab = {
                        FraibSiderhs: FraibSideBeforeRhs,
                        FraibSidelhs: FraibSideBeforeLhs,
                        FraibSideAfterLhs: FraibSideAfterLhsFin
                    }
                }

                if (powerbacc.Before_Count == 2 && powerbacc.After_Count != 1 && cubicObjCurrent.Sys_RotaryType == "Double" && powerbacc.WeighmentName.includes('FRIAB')) {
                    FraibSidelhs = await models.tbl_tab_friability.findAll({
                        where: {
                            RepSerNo: powerbacc.Incomp_RepSerNo,
                            UserID: powerbacc.Userid,
                            IdsNo: powerbacc.Idsno,
                        }
                    })
                    if (FraibSidelhs.length != 0) {
                        FraibSideBeforeLhs = FraibSidelhs[0].LWtBeforeTest + ' ' + 'g'
                        FraibSideBeforeRhs = FraibSidelhs[0].RWtBeforeTest + ' ' + 'g'
                    }

                    var side_friab = {
                        FraibSiderhs: FraibSideBeforeRhs,
                        FraibSidelhs: FraibSideBeforeLhs,
                        FraibSideAfterLhs: 'NA'
                    }
                }

                if (powerbacc.Before_Count == 1 && cubicObjCurrent.Sys_RotaryType == "Single" && powerbacc.WeighmentName.includes('FRIAB')) {
                    FraibSidelhs = await models.tbl_tab_friability.findAll({
                        //  attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
                        // attributes: [[sequelize.fn('max', sequelize.col('RecNo')), 'RecNo']],
                        where: {
                            RepSerNo: powerbacc.Incomp_RepSerNo,
                            UserID: powerbacc.Userid,
                            IdsNo: powerbacc.Idsno,
                            // Side: 'NA'

                        }
                    })
                    // FraibSidelhs = await models.tbl_tab_friability.findAll({
                    //     where: {
                    //         FinalWt: 0,
                    //         RecNo: FraibSidelhs[0].RecNo

                    //     }
                    // })
                    FraibSideBeforeLhs = FraibSidelhs[0].LWtBeforeTest + ' ' + 'g'

                    var side_friab = {
                        FraibSiderhs: 0,
                        FraibSidelhs: FraibSideBeforeLhs,
                    }

                }

                if (powerbacc.Before_Count == 1 && cubicObjCurrent.Sys_RotaryType == "Double" && powerbacc.WeighmentName.includes('FRIAB')) {
                    FraibSidelhs = await models.tbl_tab_friability.findAll({
                        //  attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
                        // attributes: [[sequelize.fn('max', sequelize.col('RecNo')), 'RecNo']],
                        where: {
                            RepSerNo: powerbacc.Incomp_RepSerNo,
                            UserID: powerbacc.Userid,
                            IdsNo: powerbacc.Idsno,
                            // Side: 'LHS'

                        }
                    })
                    FraibSideBeforeLhs = FraibSidelhs[0].LWtBeforeTest + ' ' + 'g'

                    var side_friab = {
                        FraibSiderhs: 0,
                        FraibSidelhs: FraibSideBeforeLhs,
                        FraibSideAfterLhs: 'NA'
                    }

                }
            }


            if (powerbacc != undefined && powerbacc.WeighmentName.includes('FRIAB')) {
                if (strHmi != powerbacc.Idsno) {
                    powerbacc.Before_Count = 0
                    powerbacc.After_Count = 0
                    side_friab = 0

                }
            }
            if (powerbacc != undefined && powerbacc.WeighmentName.includes('FRIAB')) {
                Before_Count = powerbacc.Before_Count,
                    After_Count = powerbacc.After_Count

                side_friab = side_friab

                if (side_friab.FraibSiderhs == 0) {
                    side_friab.FraibSiderhs = 'NA'
                }
            }

            if (powerbacc == undefined) {
                time = 0;
            } else {
                // time = moment(powerbacc.EntryTimeStamp).format("hh:mm")

                time = moment(powerbacc.EntryTimeStamp).format("MM/DD/YYYY  hh:mm:ss")
                let hours = powerbacc.EntryTimeStamp.getHours()
                let meridian = hours >= 12 ? " PM" : " AM"
                time = time.concat(meridian)
            }
            // var Before_Count = 0;
            // var After_Count = 0;
            // if (powerbacc != undefined) {
            //     if (strHmi != powerbacc.Idsno) {
            //         powerbacc.Before_Count = 0
            //         powerbacc.After_Count = 0
            //     }
            // }
            // if (powerbacc != undefined) {
            //     Before_Count = powerbacc.Before_Count,
            //     After_Count = powerbacc.After_Count
            // }
            //need to check it once 
            if (cubicObjCurrent.Sys_Area == "Coating") {
                area = "Coating"

            }
            if (powerbacc) {
                let date1 = new Date();
                let initSampletime = new Date(date.format(new Date(this.DateFormat(now, time)), 'YYYY-MM-DD HH:mm:ss')).toLocaleString().replace(',', ' ');
                let currentTime = new Date(date.format(new Date(), 'YYYY-MM-DD HH:mm:ss'))
                console.log(this.DateFormat(now, time));

                if (Date.parse(currentTime) >= Date.parse(time) || time == "Invalid Date") {
                    console.log('time match or excced');
                    return Object.assign(resObj, {
                        status: 'success',
                        Area: area,
                        result: processMenu,
                        Before_Count: Before_Count,
                        After_Count: After_Count,
                        Fraib_before: side_friab
                    })
                } else {
                    console.log('time not match');
                    let hideMenu = processMenu.filter(k => k != 'FRIAB');
                    return Object.assign(resObj, {
                        status: 'success',
                        Area: area,
                        result: hideMenu,
                        Before_Count: Before_Count,
                        After_Count: After_Count,
                        Fraib_before: side_friab
                    })
                }
            } else {
                return Object.assign(resObj, {
                    status: 'success',
                    Area: area,
                    result: processMenu,
                    Before_Count: Before_Count,
                    After_Count: After_Count,
                    Fraib_before: side_friab
                })
            }
        } catch (error) {
            throw new Error(error);
        }
    }

    async subGetMenu(values) {
        try {
            let resObj = {};
            let strHmi = values.Hmi;
            let strUserId = values.userId;
            let strUserName = values.userName;
            let menuName = values.menuName;

            let cubicObjCurrent = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;

            if (cubicObjCurrent != undefined) {
                const selectProductMaster = await models.tbl_product_master.findAll({
                    where: {
                        ProductName: cubicObjCurrent.Sys_ProductName,
                        ProductId: cubicObjCurrent.Sys_BFGCode,
                        ProductVersion: cubicObjCurrent.Sys_PVersion,
                        Version: cubicObjCurrent.Sys_Version
                    }
                })
                var arrResProductMaster = [[selectProductMaster[0]]];

                var intProductType = arrResProductMaster[0][0].ProductType;

                var tableName;
                (intProductType == 1) ? tableName = models.tbl_product_gran : tableName = models.tbl_product_gran_cap
                var TableName = tableName.tableName;

                const selectObj = await models[TableName].findAll({
                    where: {
                        ProductName: cubicObjCurrent.Sys_ProductName,
                        ProductId: cubicObjCurrent.Sys_BFGCode,
                        ProductVersion: cubicObjCurrent.Sys_PVersion,
                        Version: cubicObjCurrent.Sys_Version
                    }
                })
                var arrProductDetail = [[selectObj[0]]];
            }

            if (menuName == "LOD") {
                const cubicObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi);

                let MenuAccordingToParamsSet = await Promise.all(Object.keys(arrProductDetail[0][0]).map(async (data) => {
                    let obj = {}
                    let objCalibratedBal = globalData.glbArrListOfCalibratedBal.find(k => k.Hmi == strHmi);
                    switch (data) {
                        case 'Param1_Upp':  // granulation dry
                            if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999) {

                                if ((intProductType == 1 || intProductType == 2) &&
                                    cubicObj.cubicalData.Sys_MoistID != 'None') {
                                    obj[GLOBAL_NOMENCLATURE.granulationDry] = {
                                        'nominal': arrProductDetail[0][0].Param1_Nom,
                                        'T1Neg': arrProductDetail[0][0].Param1_Low,
                                        'T1Pos': arrProductDetail[0][0].Param1_Upp,
                                        'LimitOn': arrProductDetail[0][0].Param1_IsOnStd,
                                        'dp': arrProductDetail[0][0].Param1_DP,
                                        'isonstd': arrProductDetail[0][0].Param1_IsOnStd,
                                        // 'noOfSamples': objSamples.Individual,
                                        'ProductType': intProductType,
                                        // 'isonstd': 1,
                                        'unit': ''
                                    }
                                }
                            }
                            break;
                        case 'Param43_Upp':  // granulation lubricant
                            if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999) {

                                if ((intProductType == 1 || intProductType == 2) &&
                                    cubicObj.cubicalData.Sys_MoistID != 'None' //&& strInstrument == 'LOD'
                                ) {
                                    obj[GLOBAL_NOMENCLATURE.granulationLub] = {
                                        'nominal': arrProductDetail[0][0].Param43_Nom,
                                        'T1Neg': arrProductDetail[0][0].Param43_Low,
                                        'T1Pos': arrProductDetail[0][0].Param43_Upp,
                                        'LimitOn': arrProductDetail[0][0].Param43_IsOnStd,
                                        'dp': arrProductDetail[0][0].Param43_DP,
                                        'isonstd': arrProductDetail[0][0].Param43_IsOnStd,
                                        // 'noOfSamples': objSamples.Individual,
                                        'ProductType': intProductType,
                                        // 'isonstd': 1,
                                        'unit': ''
                                    }
                                }
                            }
                            break;
                        case 'Param4_Upp':  // layer 1 dry
                            if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999) {

                                if ((intProductType == 1 || intProductType == 2) &&
                                    cubicObj.cubicalData.Sys_MoistID != 'None' //&& strInstrument == 'LOD'
                                ) {
                                    obj[GLOBAL_NOMENCLATURE.lay1Dry] = {
                                        'nominal': arrProductDetail[0][0].Param4_Nom,
                                        'T1Neg': arrProductDetail[0][0].Param4_Low,
                                        'T1Pos': arrProductDetail[0][0].Param4_Upp,
                                        'LimitOn': arrProductDetail[0][0].Param4_IsOnStd,
                                        'dp': arrProductDetail[0][0].Param4_DP,
                                        'isonstd': arrProductDetail[0][0].Param4_IsOnStd,
                                        // 'noOfSamples': objSamples.Individual,
                                        'ProductType': intProductType,
                                        // 'isonstd': 1,
                                        'unit': ''
                                    }
                                }
                            }
                            break;
                        case 'Param44_Upp':  // layer 1 lubricant
                            if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999) {

                                if ((intProductType == 1 || intProductType == 2) &&
                                    cubicObj.cubicalData.Sys_MoistID != 'None' //&& strInstrument == 'LOD'
                                ) {
                                    obj[GLOBAL_NOMENCLATURE.lay1Lub] = {
                                        'nominal': arrProductDetail[0][0].Param44_Nom,
                                        'T1Neg': arrProductDetail[0][0].Param44_Low,
                                        'T1Pos': arrProductDetail[0][0].Param44_Upp,
                                        'LimitOn': arrProductDetail[0][0].Param44_IsOnStd,
                                        'dp': arrProductDetail[0][0].Param44_DP,
                                        'isonstd': arrProductDetail[0][0].Param44_IsOnStd,
                                        // 'noOfSamples': objSamples.Individual,
                                        'ProductType': intProductType,
                                        // 'isonstd': 1,
                                        'unit': ''
                                    }
                                }
                            }
                            break;

                        // case 'Param5_Upp':  // layer 2 dry
                        // if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999) {

                        //     if ((intProductType == 1 || intProductType == 2) &&
                        //         cubicObj.cubicalData.Sys_MoistID != 'None'//&& strInstrument == 'LOD'
                        //     ) {
                        //         obj[GLOBAL_NOMENCLATURE.lay2Dry] = {
                        //             'nominal': arrProductDetail[0][0].Param5_Nom,
                        //             'T1Neg': arrProductDetail[0][0].Param5_Low,
                        //             'T1Pos': arrProductDetail[0][0].Param5_Upp,
                        //             'LimitOn': arrProductDetail[0][0].Param5_IsOnStd,
                        //             'dp': arrProductDetail[0][0].Param5_DP,
                        //             'isonstd': arrProductDetail[0][0].Param5_IsOnStd,
                        //             // 'noOfSamples': objSamples.Individual,
                        //             'ProductType': intProductType,
                        //             // 'isonstd': 1,
                        //             'unit': ''
                        //         }
                        //     }
                        // }
                        // break;

                        // case 'Param6_Upp':  // layer 2 lubricant
                        //     if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999) {

                        //         if ((intProductType == 1 || intProductType == 2) &&
                        //             cubicObj.cubicalData.Sys_MoistID != 'None' //&& strInstrument == 'LOD'
                        //         ) {
                        //             obj[GLOBAL_NOMENCLATURE.lay2Lub] = {
                        //                 'nominal': arrProductDetail[0][0].Param6_Nom,
                        //                 'T1Neg': arrProductDetail[0][0].Param6_Low,
                        //                 'T1Pos': arrProductDetail[0][0].Param6_Upp,
                        //                 'LimitOn': arrProductDetail[0][0].Param6_IsOnStd,
                        //                 'dp': arrProductDetail[0][0].Param6_DP,
                        //                 'isonstd': arrProductDetail[0][0].Param6_IsOnStd,
                        //                 // 'noOfSamples': objSamples.Individual,
                        //                 'ProductType': intProductType,
                        //                 'isonstd': 1,
                        //                 'unit': ''
                        //             }
                        //         }
                        //     }
                        //     break;
                    }

                    if (Object.keys(obj).length != 0 && obj.constructor === Object) {
                        return obj;
                    };
                }))
                let removeUndefinedFromArray = MenuAccordingToParamsSet.filter(v => v != undefined);
                let MenusToBeShown = removeUndefinedFromArray
                MenusToBeShown = [].concat.apply([], MenusToBeShown);
                MenusToBeShown = MenusToBeShown.filter(menu => menu != undefined)
                MenusToBeShown = MenusToBeShown.map(JSON.stringify);
                /**
                 * Set will remove Duplicate obj from array.
                 */
                var uniqueSet = [...new Set(MenusToBeShown)];
                //to put groupind last

                var element = uniqueSet.filter(k =>
                    k.indexOf(GLOBAL_NOMENCLATURE.lay2Lub) !== -1
                )
                if (element != undefined && element.length != 0) {
                    var CutIndx = uniqueSet.findIndex(x => x == element)
                    var PutIndx = Object.keys(uniqueSet).length;
                    (uniqueSet).splice(CutIndx, 1);
                    (uniqueSet).splice(PutIndx, 0, element);
                }
                //
                MenusToBeShown = Array.from(uniqueSet).map(JSON.parse);

                let glbArr = globalData.arr_limits.find(k => k.Hmi == strHmi);
                if (glbArr == undefined) {
                    globalData.arr_limits.push({
                        Hmi: strHmi,
                        // idsNo: idsNo,
                        Menus: MenusToBeShown
                    })
                } else {
                    // glbArr.idsNo = idsNo;
                    glbArr.Menus = MenusToBeShown;
                }

                MenusToBeShown = MenusToBeShown.map((e, index) => {
                    if (Object.keys(e).length > 1) {
                        return Object.getOwnPropertyNames(e).toString().split(',')
                    } else {
                        return Object.getOwnPropertyNames(e)[0]
                    }
                })

                var processMenu = MenusToBeShown.toString().split(',');

                return Object.assign(resObj, {
                    status: 'success',
                    result: processMenu,
                })

            } else {
                return Object.assign(resObj, {
                    status: 'success',
                    result: values,
                })
            }
        } catch (error) {
            console.log(error);
            throw new Error(error);
        }
    }

    async processCubical(objCubicalData, strIdsNo) {
        try {
            let Product = objCubicalData.Product;
            let cubicalObj = globalData.arrIdsInfo.find(k => k.idsNo == strIdsNo).cubicalData; //current
            let strHmi = objCubicalData.Hmi;
            let idsNo = objCubicalData.IdsNo;
            let selectedIdsNo;
            var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == idsNo);
            if (IPQCObject != undefined) {
                selectedIdsNo = IPQCObject.selectedIds;
            } else {
                selectedIdsNo = strIdsNo;
            }
            let objCubicalData1 = globalData.arrIdsInfo.find(k => k.idsNo == selectedIdsNo).cubicalData;
            let cubicalArea = objCubicalData1.Sys_Area;
            var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.strIdsNo == idsNo);
            if (IPQCObject != undefined) {
                if (IPQCObject.idsNo == IPQCObject.selectedIds.Idsno) {
                    cubicalArea = cubicalArea == 'IPQC' ? objCubicalData1.Sys_IPQCType : cubicalArea == 'IPQC' ? objCubicalData1.Sys_IPQCType : cubicalArea
                }
            }

            var selectedHmi = await objHmiModel.getHmiNoFromResbPi(selectedIdsNo);
            // cubicalArea = cubicalArea == 'IPQC' ? objCubicalData1.Sys_IPQCType : cubicalArea ==  'IPQC' ? objCubicalData1.Sys_IPQCType:cubicalArea

            //check cubical product combination in product master
            const selectProductMaster = await models.tbl_product_master.findAll({
                where: {
                    ProductName: Product.ProductName,
                    ProductId: Product.ProductId,
                    ProductVersion: Product.ProductVersion,
                    Version: Product.Version
                }
            })
            let arrResProductMaster = [selectProductMaster]
            if (arrResProductMaster[0].length < 0) {
                console.log('Cubical product does not match in product master ')
                return;
            }
            let productType = arrResProductMaster[0][0].ProductType;
            //check productType
            let tableName;
            let TableName;
            if (productType == 1) {
                switch (cubicalArea) {
                    case 'Compression':
                    case 'Effervescent Compression':
                    case 'IPQC':
                    case 'IPC':
                        tableName = "tbl_product_tablet";
                        TableName = models.tbl_product_tablet
                        break;
                    case 'Coating':
                    case 'Pallet Coating':
                        tableName = 'tbl_product_tablet_coated';
                        TableName = models.tbl_product_tablet_coated
                        break;
                    case 'Granulation IPQC':
                    case 'Granulation':
                        tableName = 'tbl_product_gran';
                        TableName = models.tbl_product_gran
                        break;
                }

            } else if (productType == 2 && (cubicalArea == "Capsulation" || cubicalArea == 'Capsule Filling' || cubicalObj.Sys_IPQCType == 'Capsule Filling')) {
                tableName = 'tbl_product_capsule';
                TableName = models.tbl_product_capsule
            } else if (productType == 2 && (cubicalArea == "Granulation" || cubicalArea == "Granulation IPQC")) {
                tableName = 'tbl_product_gran_cap';
                TableName = models.tbl_product_gran_cap
            } else if (productType == 2 && cubicalArea == "Pallet Coating") {
                tableName = "tbl_product_capsule";
                TableName = models.tbl_product_capsule
            } else if (productType == 3 && cubicalArea == "Multihaler") {
                tableName = 'tbl_product_multihaler';
                TableName = models.tbl_product_multihaler
            } else {
                console.log("nothing found on menu")
            }

            if (cubicalArea == "Coating" && objCubicalData1.Sys_IPQCType == "Compression") {
                tableName = 'tbl_product_tablet';
                TableName = models.tbl_product_tablet
            }
            if ((cubicalArea == "IPQC" || cubicalArea == "IPQC") && objCubicalData1.Sys_IPQCType == "Granulation") {
                tableName = 'tbl_product_gran';
                TableName = models.tbl_product_gran
            } else if ((cubicalArea == "IPQC" || cubicalArea == "IPQC") && objCubicalData1.Sys_IPQCType == "Coating") {
                tableName = 'tbl_product_tablet_coated';
                TableName = models.tbl_product_tablet_coated

            }

            const selectObj = await models[tableName].findAll({
                where: {
                    ProductName: Product.ProductName,
                    ProductId: Product.ProductId,
                    ProductVersion: Product.ProductVersion,
                    Version: Product.Version
                }
            })
            let arrResOfProductDetail = [[selectObj[0]]];
            let tempObjProdType = globalData.arrProductTypeArray.find(k => k.Hmi == strHmi);
            if (tempObjProdType == undefined) {
                globalData.arrProductTypeArray.push({
                    Hmi: selectedHmi,
                    idsNo: selectedIdsNo,
                    productType: arrResProductMaster[0][0],
                    productDetail: arrResOfProductDetail
                });
            } else {
                tempObjProdType.productType = arrResProductMaster[0][0];
                tempObjProdType.productDetail = arrResOfProductDetail;
            }

            const selctProductSamples = await models.tbl_cubicle_product_sample.findAll({
                where: {
                    Sys_CubicNo: objCubicalData1.Sys_CubicNo,
                }
            })
            let arrProductSample = [selctProductSamples];

            //according to instrument connect give menu 
            let port1 = cubicalObj.Sys_Port1;
            let port2 = cubicalObj.Sys_Port2;
            let port3 = cubicalObj.Sys_Port3;
            let port4 = cubicalObj.Sys_Port4;
            var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
            if (IPQCObject != undefined) {
                strHmi = IPQCObject.idsNo;
            } else {
                strHmi = strHmi;
            }
            if (IPQCObject != undefined) {
                var instrumentId = await models.tbl_cubical.findAll({
                    where: {
                        Sys_IDSNo: strHmi
                    }
                })
                instrumentId = instrumentId.pop()
                port1 = instrumentId.Sys_Port1;
                port2 = instrumentId.Sys_Port2;
                port3 = instrumentId.Sys_Port3;
                port4 = instrumentId.Sys_Port4;

            }
            let uniqueSet;
            let tempPortsArr = [port1, port2, port3, port4];
            let removedNoneFromArr = tempPortsArr.filter(f => f !== "None");

            let MenusToBeShown = await Promise.all(removedNoneFromArr.map((instrument, index) => {
                let __Paramsobj = {
                    instrument: instrument,
                    ProductDetail: arrResOfProductDetail,
                    Hmi: strHmi,
                    idsNo: idsNo,
                    prdType: productType,
                    PortNo: index + 1,
                    Samples: arrProductSample[0][0]
                }
                return this.CheckParamsSet(__Paramsobj, strIdsNo)
            }))

            // if ()

            MenusToBeShown = [].concat.apply([], MenusToBeShown)
            MenusToBeShown = MenusToBeShown.filter(menu => menu != undefined)
            MenusToBeShown = MenusToBeShown.map(JSON.stringify)
            /**
             * Set will remove Duplicate obj from array.
             */
            uniqueSet = [...new Set(MenusToBeShown)];
            //to put groupind last

            var element = uniqueSet.filter(k =>
                k.indexOf("GRPIND") !== -1
            )
            if (element != undefined && element.length != 0) {
                var CutIndx = uniqueSet.findIndex(x => x == element)
                var PutIndx = Object.keys(uniqueSet).length;
                (uniqueSet).splice(CutIndx, 1);
                (uniqueSet).splice(PutIndx, 0, element);
            }
            //
            MenusToBeShown = Array.from(uniqueSet).map(JSON.parse);
            if (MenusToBeShown[0] == undefined) {
                console.log('Blank')
                return;
            }

            // console.log(MenusToBeShown);
            let arr1 = [], arr2 = []
            if (MenusToBeShown[0].hasOwnProperty('Hardness')) {
                console.log(MenusToBeShown[0])
                MenusToBeShown[0].Hardness.columnDetail.map(k => {
                    // console.log(k)

                    let existColumnDetail = arr1.filter(j => Object.getOwnPropertyNames(j)[0] == Object.getOwnPropertyNames(k)[0])
                    if (existColumnDetail.length <= 0) {
                        arr1.push(k)
                        arr2.push(Object.getOwnPropertyNames(k)[0])
                    }
                })
            }
            if (MenusToBeShown[0].hasOwnProperty('Hardness')) {
                MenusToBeShown[0].Hardness.columnDetail = arr1
                MenusToBeShown[0].Hardness.column = arr2
            }
            let glbArr = globalData.arr_limits.find(k => k.Hmi == strHmi);
            if (glbArr == undefined) {
                globalData.arr_limits.push({
                    Hmi: strHmi,
                    idsNo: idsNo,
                    Menus: MenusToBeShown
                })
            } else {
                glbArr.idsNo = idsNo;
                glbArr.Menus = MenusToBeShown;
            }

            MenusToBeShown = MenusToBeShown.map((e, index) => {
                if (Object.keys(e).length > 1) {
                    return Object.getOwnPropertyNames(e).toString().split(',')
                } else {
                    return Object.getOwnPropertyNames(e)[0]
                }
            })
            if (MenusToBeShown.includes('Group') && cubicalObj.Sys_BatchReuse == 1) {
                MenusToBeShown = MenusToBeShown.filter(item => item !== 'Group');
                return MenusToBeShown
            }
            return MenusToBeShown.toString().split(',');

        } catch (error) {
            throw new Error(error)
        }
    }

    async CheckParamsSet(values, strIdsNo) {
        try {
            let strInstrument = values.instrument;
            let result;
            switch (strInstrument.toUpperCase()) {
                case 'BALANCE':
                case 'IPC BALANCE':
                    result = await this.streamDataMenuMaking(values, strIdsNo);
                    break;
                case 'VERNIER':
                    result = await this.streamDataMenuMaking(values, strIdsNo);
                    break;
                case 'TBTTST':
                case 'TABLET TESTER':
                case 'HARDNESS':
                    result = await this.bulkDataMenuMaking(values, strIdsNo)
                    break;
                case 'FRIABILATOR':
                    result = await this.bulkDataMenuMaking(values, strIdsNo)
                    break;
                case 'DISINTEGRATION TESTER':
                    result = this.bulkDataMenuMaking(values, strIdsNo);
                    break;
                case 'MOISTURE ANALYZER':
                    result = this.bulkDataMenuMaking(values, strIdsNo);
                    break;
                case 'TAP DENSITY':
                    result = this.bulkDataMenuMaking(values, strIdsNo);
                    break;
                case 'SIEVE SHAKER':
                    result = this.streamDataMenuMaking(values, strIdsNo);
                    break
                case 'EMPTY SHELL':
                    result = this.EmptyShellStart(values, strIdsNo);
            }
            return result;
        } catch (error) {
            throw new Error(error)
        }
    }

    async streamDataMenuMaking(values, currentIdsNo) {
        try {
            let strInstrument = values.instrument;
            let strHmi = values.Hmi;
            let intPortNo = values.PortNo;
            let arrProductDetail = values.ProductDetail;
            let objSamples = values.Samples;
            let intProductType = values.prdType;
            const cubicObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi);
            let IdsNo = cubicObj.idsNo;
            let objCalibratedBalIPC;
            let objCalibratedBalAnalytical;
            let selectedIdsNo;
            var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);

            if (IPQCObject != undefined) {
                selectedIdsNo = IPQCObject.selectedIds.Idsno
                strHmi = IPQCObject.idsNo;
            } else {
                strHmi = strHmi;
            }

            var rpttype
            var areaName
            var SGroupNom
            var SGroupNomR
            var SIPQCType

            if (IPQCObject != undefined) {
                var ipqcData = globalData.arrIdsInfo.find(k => k.cubicalData.Sys_IDSNo == selectedIdsNo);
                rpttype = ipqcData.cubicalData.Sys_RptType,
                    areaName = ipqcData.cubicalData.Sys_Area,
                    SGroupNom = ipqcData.cubicalData.Sys_GroupNom,
                    SGroupNomR = ipqcData.cubicalData.Sys_GroupNomR
                SIPQCType = ipqcData.cubicalData.Sys_IPQCType

                var instrumentId = await models.tbl_cubical.findAll({
                    where: {
                        Sys_IDSNo: strHmi
                        // Sys_IDSNo: IPQCObject.selectedIds.Idsno
                    }
                });
                instrumentId = instrumentId.pop()
                instrumentId = await this.update_ipqc_instrument([instrumentId])
                cubicObj.cubicalData = instrumentId
                cubicObj.cubicalData.Sys_RptType = rpttype
                if (cubicObj.cubicalData.Sys_Area == 'IPQC' && areaName == 'Coating') {
                    cubicObj.cubicalData.Sys_Area = areaName,
                        cubicObj.cubicalData.Sys_GroupNom = SGroupNom,
                        cubicObj.cubicalData.Sys_GroupNomR = SGroupNomR,
                        cubicObj.cubicalData.Sys_IPQCType = SIPQCType
                }
                // var users2 = JSON.parse(JSON.stringify(users));
            }
            var selectBalanceDetail = await models.tbl_balance.findOne({ where: { Bal_ID: cubicObj.cubicalData.Sys_BalID } })


            let MenuAccordingToParamsSet = await Promise.all(Object.keys(arrProductDetail[0][0]).map(async (data) => {
                let obj = {}
                let objCalibratedBal = globalData.glbArrListOfCalibratedBal.find(k => k.idsNo == currentIdsNo);
                if (IPQCObject != undefined) {
                    cubicObj.cubicalData.Sys_RptType = rpttype
                    if (cubicObj.cubicalData.Sys_Area == 'IPQC' && areaName == 'Coating') {
                        cubicObj.cubicalData.Sys_Area = areaName
                        cubicObj.cubicalData.Sys_GroupNom = SGroupNom,
                            cubicObj.cubicalData.Sys_GroupNomR = SGroupNomR,
                            cubicObj.cubicalData.Sys_IPQCType = SIPQCType
                    }
                }
                if (objCalibratedBal != undefined) {
                    objCalibratedBalAnalytical = objCalibratedBal.CalibratedBalList.filter(k => k.balType != "IPC Balance");
                    objCalibratedBalIPC = objCalibratedBal.CalibratedBalList.filter(k => k.balType == "IPC Balance");
                } else {
                    objCalibratedBalAnalytical = [];
                    objCalibratedBalIPC = [];
                }

                switch (data) {

                    case 'Param1_Nom': //Individual

                        if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999) {
                            console.log(cubicObj.cubicalData.Sys_RptType, "ind");

                            if ((intProductType == 1 || intProductType == 2) &&
                                cubicObj.cubicalData.Sys_BalID != "None" &&
                                strInstrument == "Balance"
                                && (objCalibratedBalAnalytical.length != 0) && (objSamples.Individual != 0)
                            ) {
                                let unit = arrProductDetail[0][0].Param1_Unit//await this.getBalanceUnit(cubicObj.cubicalData.Sys_BalID);
                                console.log(unit)
                                obj[`${GLOBAL_NOMENCLATURE.IndividualMenu}`] = {
                                    'nominal': arrProductDetail[0][0].Param1_Nom,
                                    'T1Neg': arrProductDetail[0][0].Param1_T1Neg,
                                    'T1Pos': arrProductDetail[0][0].Param1_T1Pos,
                                    'T2Neg': arrProductDetail[0][0].Param1_T2Neg,
                                    'T2Pos': arrProductDetail[0][0].Param1_T2Pos,
                                    'LimitOn': arrProductDetail[0][0].Param1_LimitOn,
                                    'dp': selectBalanceDetail.Bal_DP,
                                    'isonstd': arrProductDetail[0][0].Param1_IsOnStd,
                                    'noOfSamples': objSamples.Individual,
                                    'NMT': arrProductDetail[0][0].Param1_NMTTab,
                                    'ProductType': intProductType,
                                    'unit': unit
                                }
                            } else if (intProductType == 3 &&
                                cubicObj.cubicalData.Sys_BalID != "None" &&
                                strInstrument == "Balance"
                            ) {
                                if (arrProductDetail[0][0].MutihalerType[0] == 1) {
                                    obj[GLOBAL_NOMENCLATURE.dryCart] = {
                                        'nominal': arrProductDetail[0][0].Param1_Nom,
                                        'T1Neg': arrProductDetail[0][0].Param1_T1Neg,
                                        'T1Pos': arrProductDetail[0][0].Param1_T1Pos,
                                        'T2Neg': arrProductDetail[0][0].Param1_T2Neg,
                                        'T2Pos': arrProductDetail[0][0].Param1_T2Pos,
                                        'LimitOn': arrProductDetail[0][0].Param1_LimitOn,
                                        'dp': selectBalanceDetail.Bal_DP,
                                        'isonstd': arrProductDetail[0][0].Param1_IsOnStd,
                                        'noOfSamples': objSamples.Individual,
                                        'NMT': arrProductDetail[0][0].Param1_NMTTab,
                                        'ProductType': intProductType
                                    },
                                        obj[GLOBAL_NOMENCLATURE.netCart] = {
                                            'nominal': arrProductDetail[0][0].Param1_Nom,
                                            'T1Neg': arrProductDetail[0][0].Param1_T1Neg,
                                            'T1Pos': arrProductDetail[0][0].Param1_T1Pos,
                                            'T2Neg': arrProductDetail[0][0].Param1_T2Neg,
                                            'T2Pos': arrProductDetail[0][0].Param1_T2Pos,
                                            'LimitOn': arrProductDetail[0][0].Param1_LimitOn,
                                            'dp': selectBalanceDetail.Bal_DP,
                                            'isonstd': arrProductDetail[0][0].Param1_IsOnStd,
                                            'noOfSamples': objSamples.Individual,
                                            'NMT': arrProductDetail[0][0].Param1_NMTTab,
                                            'ProductType': intProductType
                                        }
                                } else {
                                    //for Dpi Strip
                                    let unit = await this.getBalanceUnit(cubicObj.cubicalData.Sys_BalID);
                                    // console.log(unit)
                                    obj[GLOBAL_NOMENCLATURE.dryPowder] = {
                                        'nominal': arrProductDetail[0][0].Param1_Nom,
                                        'T1Neg': arrProductDetail[0][0].Param1_T1Neg,
                                        'T1Pos': arrProductDetail[0][0].Param1_T1Pos,
                                        'T2Neg': arrProductDetail[0][0].Param1_T2Neg,
                                        'T2Pos': arrProductDetail[0][0].Param1_T2Pos,
                                        'LimitOn': arrProductDetail[0][0].Param1_LimitOn,
                                        'dp': selectBalanceDetail.Bal_DP,
                                        'isonstd': arrProductDetail[0][0].Param1_IsOnStd,
                                        'noOfSamples': objSamples.Individual,
                                        'NMT': arrProductDetail[0][0].Param1_NMTTab,
                                        'ProductType': intProductType,
                                        'unit': unit
                                    }
                                }
                            }
                        }
                        break;
                    // case 'Param2_Nom'://group  //commented for coating area, grp std value is in cubicle setting.
                    case 'Param2_T2Neg'://group
                        if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999) {
                            console.log(cubicObj.cubicalData.Sys_RptType, "grp");
                            let menuName = (intProductType == 1 || intProductType == 2) ?
                                GLOBAL_NOMENCLATURE.GroupMenu : intProductType == 3 &&
                                    arrProductDetail[0][0].MutihalerType[0] == 1 ? GLOBAL_NOMENCLATURE.sealedcart : undefined

                            if (cubicObj.cubicalData.Sys_BalID != "None" &&
                                strInstrument == "Balance" &&
                                (objCalibratedBalAnalytical.length != 0) &&
                                (objSamples.Group != 0 || objSamples.GrpCoat != 0)
                            ) {
                                let unit = await this.getBalanceUnit(cubicObj.cubicalData.Sys_BalID);

                                if (cubicObj.cubicalData.Sys_RptType == 0 && arrProductDetail[0][0].Param1_Unit == ('mg')) {
                                    var nomData = (arrProductDetail[0][0].Param1_Nom * objSamples.GrpCoat) / 1000
                                }
                                if (cubicObj.cubicalData.Sys_RptType == 1 && arrProductDetail[0][0].Param1_Unit == ('mg')) {
                                    var nomData = (arrProductDetail[0][0].Param1_Nom * objSamples.Group) / 1000
                                }
                                if (cubicObj.cubicalData.Sys_RptType == 0 && arrProductDetail[0][0].Param1_Unit == ('g')) {
                                    nomData = (arrProductDetail[0][0].Param1_Nom * objSamples.GrpCoat)
                                }
                                if (cubicObj.cubicalData.Sys_RptType == 1 && arrProductDetail[0][0].Param1_Unit == ('g')) {
                                    nomData = (arrProductDetail[0][0].Param1_Nom * objSamples.Group)
                                }
                                if ((cubicObj.cubicalData.Sys_Area === 'Coating' || cubicObj.cubicalData.Sys_Area === 'IPQC') &&
                                    cubicObj.cubicalData.Sys_IPQCType === 'Coating') {
                                    if (cubicObj.cubicalData.Sys_RptType == 0) {
                                        nomData = cubicObj.cubicalData.Sys_GroupNomR
                                    } else {
                                        nomData = cubicObj.cubicalData.Sys_GroupNom
                                    }
                                }
                                obj[menuName] = {
                                    // 'nominal': arrProductDetail[0][0].Param2_Nom,
                                    // 'nominal': cubicObj.cubicalData.Sys_RptType == 0 ? ((arrProductDetail[0][0].Param1_Unit == ('mg') || arrProductDetail[0][0].Param1_Unit == ('g'))  ? (arrProductDetail[0][0].Param1_Nom * objSamples.GrpCoat) / 1000 : (arrProductDetail[0][0].Param1_Nom * objSamples.Group)) : (arrProductDetail[0][0].Param1_Unit == ('mg') || arrProductDetail[0][0].Param1_Unit == ('g')) ? (arrProductDetail[0][0].Param1_Nom * objSamples.Group) / 1000 : (arrProductDetail[0][0].Param1_Nom * objSamples.Group),
                                    'nominal': nomData,
                                    'T1Neg': arrProductDetail[0][0].Param2_T1Neg,
                                    'T1Pos': arrProductDetail[0][0].Param2_T1Pos,
                                    'T2Neg': arrProductDetail[0][0].Param2_T2Neg,
                                    'T2Pos': arrProductDetail[0][0].Param2_T2Pos,
                                    'LimitOn': arrProductDetail[0][0].Param2_LimitOn,
                                    'dp': selectBalanceDetail.Bal_DP,//arrProductDetail[0][0].Param2_DP,
                                    'isonstd': arrProductDetail[0][0].Param2_IsOnStd,
                                    'noOfSamples': cubicObj.cubicalData.Sys_RptType == 0 ? (objSamples.GrpCoat) : (objSamples.Group),//objSamples.Group,
                                    'NMT': arrProductDetail[0][0].Param2_NMTTab,
                                    'ProductType': intProductType,
                                    'unit': unit
                                }
                            }
                        }
                        break;
                    case 'Param3_Nom'://thickness or differntial
                        if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999) {

                            if (cubicObj.cubicalData.Sys_VernierID != "None" && intProductType == 1 &&
                                strInstrument == "Vernier"
                            ) {

                                let unit = await this.getVerinerUnit(cubicObj.cubicalData.Sys_VernierID);
                                obj[GLOBAL_NOMENCLATURE.ThicknessMenu] = {
                                    'nominal': arrProductDetail[0][0].Param3_Nom,
                                    'T1Neg': arrProductDetail[0][0].Param3_T1Neg,
                                    'T1Pos': arrProductDetail[0][0].Param3_T1Pos,
                                    'T2Neg': arrProductDetail[0][0].Param3_T2Neg,
                                    'T2Pos': arrProductDetail[0][0].Param3_T2Pos,
                                    'LimitOn': arrProductDetail[0][0].Param3_LimitOn,
                                    'dp': 2,
                                    'isonstd': arrProductDetail[0][0].Param3_IsOnStd,
                                    'noOfSamples': objSamples.Thickness,
                                    'NMT': arrProductDetail[0][0].Param3_NMTTab,
                                    'ProductType': intProductType,
                                    'unit': unit
                                }
                            }

                            if (cubicObj.cubicalData.Sys_BalID != "None" && intProductType == 2 &&
                                strInstrument == "Balance"
                            ) {

                                // let unit = await this.getBalanceUnit(cubicObj.cubicalData.Sys_BalID);
                                let unit = arrProductDetail[0][0].Param3_Unit

                                // let result = await models.tbl_setnominalcapsule.findAll({
                                //     // attributes: [
                                //     //     sequelize.fn(sequelize.col("Std")), "Std"
                                //     // ],
                                //     where:{
                                //             ProductName: cubicObj.cubicalData.Sys_ProductName,
                                //             ProductVersion: cubicObj.cubicalData.Sys_PVersion,
                                //             Version: cubicObj.cubicalData.Sys_Version,
                                //             BatchNo: cubicObj.cubicalData.Sys_Batch,
                                //             CubicleName:cubicObj.cubicalData.Sys_CubicName,
                                //             CubicleNo:cubicObj.cubicalData.Sys_CubicNo,
                                //             Area:cubicObj.cubicalData.Sys_Area
                                //     }
                                // })
                                // let nom = result
                                obj[`${GLOBAL_NOMENCLATURE.Differential}`] = {
                                    'nominal': arrProductDetail[0][0].Param3_Nom,
                                    'T1Neg': arrProductDetail[0][0].Param3_T1Neg,
                                    'T1Pos': arrProductDetail[0][0].Param3_T1Pos,
                                    'T2Neg': arrProductDetail[0][0].Param3_T2Neg,
                                    'T2Pos': arrProductDetail[0][0].Param3_T2Pos,
                                    'LimitOn': arrProductDetail[0][0].Param3_LimitOn,
                                    'dp': selectBalanceDetail.Bal_DP,
                                    'isonstd': arrProductDetail[0][0].Param3_IsOnStd,
                                    'noOfSamples': objSamples.Individual,
                                    'NMT': arrProductDetail[0][0].Param3_NMTTab,
                                    'ProductType': intProductType,
                                    'unit': unit
                                }
                            }



                        }
                        break;
                    case 'Param4_Nom'://diameter or breadth
                        if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999) {

                            let menuName = intProductType == 1 ? GLOBAL_NOMENCLATURE.BreadthMenu :
                                intProductType == 2 ? GLOBAL_NOMENCLATURE.DiameterMenu : undefined;

                            if (cubicObj.cubicalData.Sys_VernierID != "None" &&
                                strInstrument == "Vernier"
                            ) {
                                let unit = await this.getVerinerUnit(cubicObj.cubicalData.Sys_VernierID);
                                obj[menuName] = {
                                    'nominal': arrProductDetail[0][0].Param4_Nom,
                                    'T1Neg': arrProductDetail[0][0].Param4_T1Neg,
                                    'T1Pos': arrProductDetail[0][0].Param4_T1Pos,
                                    'T2Neg': arrProductDetail[0][0].Param4_T2Neg,
                                    'T2Pos': arrProductDetail[0][0].Param4_T2Pos,
                                    'LimitOn': arrProductDetail[0][0].Param4_LimitOn,
                                    'dp': 2,
                                    'isonstd': arrProductDetail[0][0].Param4_IsOnStd,
                                    'noOfSamples': objSamples.Diameter,
                                    'NMT': arrProductDetail[0][0].Param4_NMTTab,
                                    'ProductType': intProductType,
                                    'unit': unit
                                }
                            }
                        }
                        break;
                    case 'Param5_Nom'://length
                        if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999) {
                            if ((intProductType == 1) &&
                                cubicObj.cubicalData.Sys_VernierID != "None" &&
                                strInstrument == "Vernier"
                            ) {
                                let unit = await this.getVerinerUnit(cubicObj.cubicalData.Sys_VernierID);
                                obj['Length'] = {
                                    'nominal': arrProductDetail[0][0].Param5_Nom,
                                    'T1Neg': arrProductDetail[0][0].Param5_T1Neg,
                                    'T1Pos': arrProductDetail[0][0].Param5_T1Pos,
                                    'T2Neg': arrProductDetail[0][0].Param5_T2Neg,
                                    'T2Pos': arrProductDetail[0][0].Param5_T2Pos,
                                    'LimitOn': arrProductDetail[0][0].Param5_LimitOn,
                                    'dp': 2,
                                    'isonstd': arrProductDetail[0][0].Param5_IsOnStd,
                                    'noOfSamples': objSamples.Diameter,
                                    'NMT': arrProductDetail[0][0].Param5_NMTTab,
                                    'ProductType': intProductType,
                                    'unit': unit
                                }
                            }
                            if ((intProductType == 2) && cubicObj.cubicalData.Sys_VernierID != "None" &&
                                strInstrument == "Vernier") {
                                var unit = await this.getVerinerUnit(cubicObj.cubicalData.Sys_VernierID);
                                obj[`${GLOBAL_NOMENCLATURE.SealLengthMenu}`] = {
                                    'nominal': arrProductDetail[0][0].Param5_Nom,
                                    'T1Neg': arrProductDetail[0][0].Param5_T1Neg,
                                    'T1Pos': arrProductDetail[0][0].Param5_T1Pos,
                                    'T2Neg': arrProductDetail[0][0].Param5_T2Neg,
                                    'T2Pos': arrProductDetail[0][0].Param5_T2Pos,
                                    'LimitOn': arrProductDetail[0][0].Param5_LimitOn,
                                    'dp': arrProductDetail[0][0].Param5_Dp,
                                    'isonstd': arrProductDetail[0][0].Param5_IsOnStd,
                                    'noOfSamples': objSamples.Diameter,
                                    'NMT': arrProductDetail[0][0].Param5_NMTTab,
                                    'ProductType': intProductType,
                                    'unit': unit
                                }
                            }
                        }
                        break;
                    case 'Param6_Nom'://diameter
                        if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999) {

                            if (intProductType == 1 &&
                                cubicObj.cubicalData.Sys_VernierID != "None" &&
                                strInstrument == "Vernier"
                            ) {
                                let unit = await this.getVerinerUnit(cubicObj.cubicalData.Sys_VernierID);
                                obj[GLOBAL_NOMENCLATURE.DiameterMenu] = {
                                    'nominal': arrProductDetail[0][0].Param6_Nom,
                                    'T1Neg': arrProductDetail[0][0].Param6_T1Neg,
                                    'T1Pos': arrProductDetail[0][0].Param6_T1Pos,
                                    'T2Neg': arrProductDetail[0][0].Param6_T2Neg,
                                    'T2Pos': arrProductDetail[0][0].Param6_T2Pos,
                                    'LimitOn': arrProductDetail[0][0].Param6_LimitOn,
                                    'dp': 2,
                                    'isonstd': arrProductDetail[0][0].Param6_IsOnStd,
                                    'noOfSamples': objSamples.Diameter,
                                    'NMT': arrProductDetail[0][0].Param6_NMTTab,
                                    'ProductType': intProductType,
                                    'unit': unit
                                }
                            }
                        }
                        break;
                    case 'Param9_Nom'://Individual layer
                        if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999) {

                            if (intProductType == 1 &&
                                cubicObj.cubicalData.Sys_BalID != "None" &&
                                strInstrument == "Balance" && (objCalibratedBalAnalytical.length != 0)
                            ) {
                                let unit = arrProductDetail[0][0].Param9_Unit//await this.getBalanceUnit(cubicObj.cubicalData.Sys_BalID);
                                obj[`${GLOBAL_NOMENCLATURE.IndLayerMenu}`] = {
                                    'nominal': arrProductDetail[0][0].Param9_Nom,
                                    'T1Neg': arrProductDetail[0][0].Param9_T1Neg,
                                    'T1Pos': arrProductDetail[0][0].Param9_T1Pos,
                                    'T2Neg': arrProductDetail[0][0].Param9_T2Neg,
                                    'T2Pos': arrProductDetail[0][0].Param9_T2Pos,
                                    'LimitOn': arrProductDetail[0][0].Param9_LimitOn,
                                    'dp': arrProductDetail[0][0].Param9_DP,
                                    'isonstd': arrProductDetail[0][0].Param9_IsOnStd,
                                    'noOfSamples': objSamples.Individual,
                                    'NMT': arrProductDetail[0][0].Param9_NMTTab,
                                    'ProductType': intProductType,
                                    'unit': unit
                                }
                            }

                        }
                        break;
                    case 'Param10_Nom'://Group layer
                        if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999) {

                            if (intProductType == 1 &&
                                cubicObj.cubicalData.Sys_BalID != "None" &&
                                strInstrument == "Balance" && (objCalibratedBalAnalytical.length != 0)
                            ) {
                                let unit = await this.getBalanceUnit(cubicObj.cubicalData.Sys_BalID);
                                obj[`${GLOBAL_NOMENCLATURE.GroupLayerMenu}`] = {
                                    'nominal': arrProductDetail[0][0].Param10_Nom,
                                    'T1Neg': arrProductDetail[0][0].Param10_T1Neg,
                                    'T1Pos': arrProductDetail[0][0].Param10_T1Pos,
                                    'T2Neg': arrProductDetail[0][0].Param10_T2Neg,
                                    'T2Pos': arrProductDetail[0][0].Param10_T2Pos,
                                    'LimitOn': arrProductDetail[0][0].Param10_LimitOn,
                                    'dp': 3, //arrProductDetail[0][0].Param10_DP,
                                    'isonstd': arrProductDetail[0][0].Param10_IsOnStd,
                                    'noOfSamples': objSamples.Group,
                                    'NMT': arrProductDetail[0][0].Param10_NMTTab,
                                    'ProductType': intProductType,
                                    'unit': unit
                                }
                            }

                        }
                        break;
                    case 'Param11_Nom'://Individual layer 1
                        if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999) {
                            if (intProductType == 1 &&
                                cubicObj.cubicalData.Sys_BalID != "None" &&
                                strInstrument == "Balance" && (objCalibratedBalAnalytical.length != 0)
                            ) {
                                let unit = arrProductDetail[0][0].Param11_Unit//await this.getBalanceUnit(cubicObj.cubicalData.Sys_BalID);
                                obj[`${GLOBAL_NOMENCLATURE.IndLayer1Menu}`] = {
                                    'nominal': arrProductDetail[0][0].Param11_Nom,
                                    'T1Neg': arrProductDetail[0][0].Param11_T1Neg,
                                    'T1Pos': arrProductDetail[0][0].Param11_T1Pos,
                                    'T2Neg': arrProductDetail[0][0].Param11_T2Neg,
                                    'T2Pos': arrProductDetail[0][0].Param11_T2Pos,
                                    'LimitOn': arrProductDetail[0][0].Param11_LimitOn,
                                    'dp': arrProductDetail[0][0].Param11_DP,
                                    'isonstd': arrProductDetail[0][0].Param11_IsOnStd,
                                    'noOfSamples': objSamples.Individual,
                                    'NMT': arrProductDetail[0][0].Param11_NMTTab,
                                    'ProductType': intProductType,
                                    'unit': unit
                                }
                            }

                        }
                        break;
                    case 'Param12_Nom'://Group layer 1
                        if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999) {
                            if (intProductType == 1 &&
                                cubicObj.cubicalData.Sys_BalID != "None" &&
                                strInstrument == "Balance" && (objCalibratedBalAnalytical.length != 0)

                            ) {
                                let unit = await this.getBalanceUnit(cubicObj.cubicalData.Sys_BalID);

                                obj[`${GLOBAL_NOMENCLATURE.GroupLayer1Menu}`] = {
                                    'nominal': arrProductDetail[0][0].Param12_Nom,
                                    'T1Neg': arrProductDetail[0][0].Param12_T1Neg,
                                    'T1Pos': arrProductDetail[0][0].Param12_T1Pos,
                                    'T2Neg': arrProductDetail[0][0].Param12_T2Neg,
                                    'T2Pos': arrProductDetail[0][0].Param12_T2Pos,
                                    'LimitOn': arrProductDetail[0][0].Param12_LimitOn,
                                    'dp': 3, //arrProductDetail[0][0].Param12_DP,
                                    'isonstd': arrProductDetail[0][0].Param12_IsOnStd,
                                    'noOfSamples': objSamples.Group,
                                    'NMT': arrProductDetail[0][0].Param12_NMTTab,
                                    'ProductType': intProductType,
                                    'unit': unit
                                }
                            }

                        }
                        break;
                    case 'Param8_Nom'://Friability
                        if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999) {
                            if (serverConfig.friabilityType == 'OB' || serverConfig.friabilityType == 'BFBO' || serverConfig.friabilityType == 'BFBT') {
                                if (intProductType == 1 &&
                                    cubicObj.cubicalData.Sys_BalID != "None" && strInstrument == "Balance" &&
                                    cubicObj.cubicalData.Sys_FriabID != "None" && objSamples.Friability != 0
                                ) {
                                    let unit = await this.getBalanceUnit(cubicObj.cubicalData.Sys_BalID);
                                    //arr
                                    let checkFri = globalData.arrBFBO.find(k => k.idsNo == IdsNo);
                                    let friabMenu = `${GLOBAL_NOMENCLATURE.FriabilityMenu}`;
                                    // before: false, setParam: false, after: false
                                    if ((checkFri.before) && (!checkFri.setParam)) {
                                        friabMenu = "Friability"
                                    }

                                    obj[friabMenu] = {
                                        'nominal': arrProductDetail[0][0].Param8_Nom,
                                        'T1Neg': arrProductDetail[0][0].Param8_T1Neg,
                                        'T1Pos': arrProductDetail[0][0].Param8_T1Pos,
                                        'LimitOn': arrProductDetail[0][0].Param8_LimitOn,
                                        'dp': selectBalanceDetail.Bal_DP,
                                        'isonstd': arrProductDetail[0][0].Param8_IsOnStd,
                                        'noOfSamples': objSamples.Friability,
                                        'NMT': arrProductDetail[0][0].Param8_NMTTab,
                                        'ProductType': intProductType,
                                        'unit': unit
                                    }
                                }
                            }

                        }
                        break;
                    // case 'Param8_Upp': // for % fine and from tab_gran
                    //     if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999) {
                    //         // check for product type and check LOD is set 
                    //         if ((intProductType == 1 || intProductType == 2) && cubicObj.cubicalData.Sys_BalID != 'None' && strInstrument == 'Balance'
                    //             // && (CubicInfo.Sys_Area == 'Effervescent Granulation' || CubicInfo.Sys_Area == 'Granulation')
                    //         ) {
                    //             let unit = await this.getBalanceUnit(cubicObj.cubicalData.Sys_BalID);
                    //             obj[GLOBAL_NOMENCLATURE.PercentageFine] = {
                    //                 'nominal': arrProductDetail[0][0].Param8_Nom,
                    //                 'T1Neg': arrProductDetail[0][0].Param8_Low,
                    //                 'T1Pos': arrProductDetail[0][0].Param8_Upp,
                    //                 'LimitOn': 1,
                    //                 'dp': arrProductDetail[0][0].Param8_Dp,
                    //                 'isonstd': 1,
                    //                 'noOfSamples': 2, //In % Fine we cant edit sample 
                    //                 'ProductType': intProductType,
                    //                 'unit': unit
                    //             }
                    //         }
                    //     }
                    //     break;
                    // case 'Param9_Upp': // for particalsizing and from tab_gran
                    //     if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999) {
                    //         // check for product type and check LOD is set 
                    //         if ((intProductType == 1 || intProductType == 2) && cubicObj.cubicalData.Sys_BalID != 'None' && strInstrument == 'Balance'
                    //             // && (CubicInfo.Sys_Area == 'Effervescent Granulation' || CubicInfo.Sys_Area == 'Granulation')
                    //         ) {
                    //             let unit = await this.getBalanceUnit(cubicObj.cubicalData.Sys_BalID);
                    //             obj[GLOBAL_NOMENCLATURE.ParticalSizing] = {
                    //                 'nominal': arrProductDetail[0][0].Param9_Nom,
                    //                 'T1Neg': arrProductDetail[0][0].Param9_Low,
                    //                 'T1Pos': arrProductDetail[0][0].Param9_Upp,
                    //                 'LimitOn': 1,
                    //                 'dp': arrProductDetail[0][0].Param9_DP,
                    //                 'isonstd': 1,
                    //                 'noOfSamples': 7,
                    //                 'ProductType': intProductType,
                    //                 'unit': unit
                    //             }
                    //         }
                    //     }
                    // break;
                    case "Param46_Low":// %fine
                        if (
                            // parseFloat(arrProductDetail[0][0][data]) >= 0 && parseFloat(arrProductDetail[0][0][data]) != 99999 &&
                            // parseFloat(arrProductDetail[0][0]["Param46_Upp"]) > 0 && parseFloat(arrProductDetail[0][0]["Param46_Upp"]) !== 99999 &&
                            // parseFloat(arrProductDetail[0][0]["Param46_Low"]) >= 0 && parseFloat(arrProductDetail[0][0]["Param46_Low"]) !== 99999 &&
                            parseFloat(arrProductDetail[0][0][data]) != 99999 ||
                            parseFloat(arrProductDetail[0][0]["Param46_Upp"]) !== 99999 ||
                            parseFloat(arrProductDetail[0][0]["Param46_Low"]) !== 99999 &&
                            // strInstrument === GLOBAL_NOMENCLATURE.SieveShaker && 
                            // cubicObj.cubicalData.Sys_SieveShakerID !== "None" &&
                            cubicObj.cubicalData.Sys_BalID.toUpperCase() !== "NONE"
                            && (cubicObj.cubicalData.Sys_Area.toUpperCase() === "GRANULATION" || cubicObj.cubicalData.Sys_Area.toUpperCase() === "IPQC" || cubicObj.cubicalData.Sys_Area.toUpperCase() === "IPQC") && cubicObj.cubicalData.Sys_CubType.toUpperCase() === "IPQC"
                            && strInstrument === GLOBAL_NOMENCLATURE.Balance) {

                            var unit = await this.getBalanceUnit(cubicObj.cubicalData.Sys_BalID)

                            obj[GLOBAL_NOMENCLATURE.perFineMenu] = {

                                "Below60_Max": arrProductDetail[0][0]["Param46_Upp"] == 99999 ? 'NA' : arrProductDetail[0][0]["Param46_Upp"],
                                "Below60_Min": arrProductDetail[0][0]["Param46_Low"] == 99999 ? 'NA' : arrProductDetail[0][0]["Param46_Low"],
                                'ProductType': intProductType,
                                'DP': selectBalanceDetail.Bal_DP,
                                // 'isonstd': 1,
                                'unit': unit
                            }
                        }
                        break;
                    // case "Param48_Low":// %fine layer 1
                    //     if (parseFloat(arrProductDetail[0][0][data]) !== 99999 ||
                    //         parseFloat(arrProductDetail[0][0]["Param48_Upp"]) !== 99999 ||
                    //         parseFloat(arrProductDetail[0][0]["Param48_Low"]) !== 99999 &&
                    //         // strInstrument === GLOBAL_NOMENCLATURE.SieveShaker && 
                    //         // cubicObj.cubicalData.Sys_SieveShakerID !== "None" &&
                    //         (cubicObj.cubicalData.Sys_Area.toUpperCase() === "GRANULATION" || cubicObj.cubicalData.Sys_Area.toUpperCase() === "IPQC" || cubicObj.cubicalData.Sys_Area.toUpperCase() === "IPQC") && cubicObj.cubicalData.Sys_CubType.toUpperCase() === "IPQC" &&
                    //         cubicObj.cubicalData.Sys_BalID.toUpperCase() !== "NONE" &&
                    //         strInstrument === GLOBAL_NOMENCLATURE.Balance
                    //     ) {

                    //         var unit = await this.getBalanceUnit(cubicObj.cubicalData.Sys_BalID)

                    //         obj[GLOBAL_NOMENCLATURE.perFineLayer1Menu] = {
                    //             // "Below30_Max": arrProductDetail[0][0]["Param21_Upp"],
                    //             // "Below40_Max": arrProductDetail[0][0]["Param22_Upp"],
                    //             "Below60_Max": arrProductDetail[0][0]["Param48_Upp"] == 99999 ? 'NA' : arrProductDetail[0][0]["Param48_Upp"],
                    //             "Below60_Min": arrProductDetail[0][0]["Param48_Low"] == 99999 ? 'NA' : arrProductDetail[0][0]["Param48_Low"],
                    //             'ProductType': intProductType,
                    //             'DP': arrProductDetail[0][0]["Param48_DP"],
                    //             // 'isonstd': 1,
                    //             'unit': unit
                    //         }
                    //     }
                    //     break;
                    // case "Param49_Low": // %fine layer 2
                    //     if (parseFloat(arrProductDetail[0][0][data]) != 99999 ||
                    //         parseFloat(arrProductDetail[0][0]["Param49_Upp"]) !== 99999 ||
                    //         parseFloat(arrProductDetail[0][0]["Param49_Low"]) !== 99999 &&
                    //         // strInstrument === GLOBAL_NOMENCLATURE.SieveShaker && cubicObj.cubicalData.Sys_SieveShakerID !== "None" && 
                    //         (cubicObj.cubicalData.Sys_Area.toUpperCase() === "GRANULATION" || cubicObj.cubicalData.Sys_Area.toUpperCase() === "IPQC" || cubicObj.cubicalData.Sys_Area.toUpperCase() === "IPQC") && cubicObj.cubicalData.Sys_CubType.toUpperCase() === "IPQC" &&
                    //         cubicObj.cubicalData.Sys_BalID.toUpperCase() !== "NONE" &&
                    //         strInstrument === GLOBAL_NOMENCLATURE.Balance
                    //     ) {
                    //         var unit = await this.getBalanceUnit(cubicObj.cubicalData.Sys_BalID)

                    //         obj[GLOBAL_NOMENCLATURE.perFineLayer2Menu] = {
                    //             "Below60_Max": arrProductDetail[0][0]["Param49_Upp"] == 99999 ? 'NA' : arrProductDetail[0][0]["Param49_Upp"],
                    //             "Below60_Min": arrProductDetail[0][0]["Param49_Low"] == 99999 ? 'NA' : arrProductDetail[0][0]["Param49_Low"],
                    //             'ProductType': intProductType,
                    //             'DP': arrProductDetail[0][0]["Param49_DP"],
                    //             // 'isonstd': 1,
                    //             'unit': unit
                    //         }
                    //     }

                    //     break;
                    case "Param47_Low": // PSD 
                        if (parseFloat(arrProductDetail[0][0][data]) != 99999 ||
                            parseFloat(arrProductDetail[0][0]["Param47_Upp"]) !== 99999 ||
                            parseFloat(arrProductDetail[0][0]["Param47_Low"]) !== 99999 &&
                            // strInstrument === GLOBAL_NOMENCLATURE.SieveShaker && cubicObj.cubicalData.Sys_SieveShakerID !== "None" && 
                            (cubicObj.cubicalData.Sys_Area.toUpperCase() === "GRANULATION" || cubicObj.cubicalData.Sys_Area.toUpperCase() === "IPQC" || cubicObj.cubicalData.Sys_Area.toUpperCase() === "IPQC") && cubicObj.cubicalData.Sys_CubType.toUpperCase() === "IPQC" &&
                            cubicObj.cubicalData.Sys_BalID.toUpperCase() !== "NONE" &&
                            strInstrument === GLOBAL_NOMENCLATURE.Balance
                        ) {
                            var unit = await this.getBalanceUnit(cubicObj.cubicalData.Sys_BalID)

                            obj[GLOBAL_NOMENCLATURE.PSDMenu] = {
                                "Below60_Max": arrProductDetail[0][0]["Param47_Upp"] == 99999 ? 'NA' : arrProductDetail[0][0]["Param47_Upp"],
                                "Below60_Min": arrProductDetail[0][0]["Param47_Low"] == 99999 ? 'NA' : arrProductDetail[0][0]["Param47_Low"],
                                'ProductType': intProductType,
                                'DP': selectBalanceDetail.Bal_DP,
                                // 'isonstd': 1,
                                'unit': unit
                            }
                        }

                        break;
                    // case "Param64_Low": // PSD layer 1
                    //     if (parseFloat(arrProductDetail[0][0][data]) != 99999 ||
                    //         parseFloat(arrProductDetail[0][0]["Param64_Upp"]) !== 99999 ||
                    //         parseFloat(arrProductDetail[0][0]["Param64_Low"]) !== 99999 &&
                    //         // strInstrument === GLOBAL_NOMENCLATURE.SieveShaker && cubicObj.cubicalData.Sys_SieveShakerID !== "None" && 
                    //         (cubicObj.cubicalData.Sys_Area.toUpperCase() === "GRANULATION" || cubicObj.cubicalData.Sys_Area.toUpperCase() === "IPQC" || cubicObj.cubicalData.Sys_Area.toUpperCase() === "IPQC") && cubicObj.cubicalData.Sys_CubType.toUpperCase() === "IPQC" &&
                    //         cubicObj.cubicalData.Sys_BalID.toUpperCase() !== "NONE" &&
                    //         strInstrument === GLOBAL_NOMENCLATURE.Balance
                    //     ) {
                    //         var unit = await this.getBalanceUnit(cubicObj.cubicalData.Sys_BalID)

                    //         obj[GLOBAL_NOMENCLATURE.PSDLayer1Menu] = {
                    //             "Below60_Max": arrProductDetail[0][0]["Param64_Upp"] == 99999 ? 'NA' : arrProductDetail[0][0]["Param64_Upp"],
                    //             "Below60_Min": arrProductDetail[0][0]["Param64_Low"] == 99999 ? 'NA' : arrProductDetail[0][0]["Param64_Low"],
                    //             'ProductType': intProductType,
                    //             'DP': arrProductDetail[0][0]["Param64_DP"],
                    //             // 'isonstd': 1,
                    //             'unit': unit
                    //         }
                    //     }

                    //     break;
                    // case "Param65_Low": // PSD layer 2
                    //     if (parseFloat(arrProductDetail[0][0][data]) != 99999 ||
                    //         parseFloat(arrProductDetail[0][0]["Param65_Upp"]) !== 99999 ||
                    //         parseFloat(arrProductDetail[0][0]["Param65_Low"]) !== 99999 &&
                    //         // strInstrument === GLOBAL_NOMENCLATURE.SieveShaker && cubicObj.cubicalData.Sys_SieveShakerID !== "None" && 
                    //         (cubicObj.cubicalData.Sys_Area.toUpperCase() === "GRANULATION" || cubicObj.cubicalData.Sys_Area.toUpperCase() === "IPQC" || cubicObj.cubicalData.Sys_Area.toUpperCase() === "IPQC") && cubicObj.cubicalData.Sys_CubType.toUpperCase() === "IPQC" &&
                    //         cubicObj.cubicalData.Sys_BalID.toUpperCase() !== "NONE" &&
                    //         strInstrument === GLOBAL_NOMENCLATURE.Balance
                    //     ) {
                    //         var unit = await this.getBalanceUnit(cubicObj.cubicalData.Sys_BalID)

                    //         obj[GLOBAL_NOMENCLATURE.PSDLayer2Menu] = {
                    //             "Below60_Max": arrProductDetail[0][0]["Param65_Upp"] == 99999 ? 'NA' : arrProductDetail[0][0]["Param65_Upp"],
                    //             "Below60_Min": arrProductDetail[0][0]["Param65_Low"] == 99999 ? 'NA' : arrProductDetail[0][0]["Param65_Low"],
                    //             'ProductType': intProductType,
                    //             'DP': arrProductDetail[0][0]["Param65_DP"],
                    //             // 'isonstd': 1,
                    //             'unit': unit
                    //         }
                    //     }

                    //     break;
                    default:
                    // if (objCalibratedBalIPC.length > 0 && cubicObj.cubicalData.Sys_BinBalID != 'None') {
                    //     obj['IPCWC'] = {
                    //     }
                    // }
                }

                if (Object.keys(obj).length != 0 && obj.constructor === Object) {
                    return obj;
                };
            }))

            let removeUndefinedFromArray = MenuAccordingToParamsSet.filter(v => v != undefined);

            // if (// strInstrument === GLOBAL_NOMENCLATURE.SieveShaker && cubicObj.cubicalData.Sys_SieveShakerID.toUpperCase() !== "NONE" &&
            //     (cubicObj.cubicalData.Sys_Area.toUpperCase() === "GRANULATION" || cubicObj.cubicalData.Sys_Area.toUpperCase() === "IPQC" || cubicObj.cubicalData.Sys_Area.toUpperCase() === "IPQC") && cubicObj.cubicalData.Sys_CubType.toUpperCase() === "IPQC"
            //     && cubicObj.cubicalData.Sys_BalID.toUpperCase() !== "NONE" && strInstrument === GLOBAL_NOMENCLATURE.Balance
            // ) {
            //     var unit = await this.getBalanceUnit(cubicObj.cubicalData.Sys_BalID)
            //     var menupresent = removeUndefinedFromArray.find(k => { return (k.hasOwnProperty(GLOBAL_NOMENCLATURE.perFineMenu)) });
            //     if (menupresent) {
            //         removeUndefinedFromArray.push({
            //             [GLOBAL_NOMENCLATURE.PSDMenu]: {
            //                 ProductType: 1,
            //                 unit: unit
            //             }
            //         })
            //     }
            //     var menupreLyr1 = removeUndefinedFromArray.find(k => { return (k.hasOwnProperty(GLOBAL_NOMENCLATURE.perFineLayer1Menu)) });
            //     if (menupreLyr1) {
            //         removeUndefinedFromArray.push({
            //             [GLOBAL_NOMENCLATURE.PSDLayer1Menu]: {
            //                 ProductType: 1,
            //                 unit: unit
            //             }
            //         })
            //     }
            //     var menupreLyr2 = removeUndefinedFromArray.find(k => { return (k.hasOwnProperty(GLOBAL_NOMENCLATURE.perFineLayer2Menu)) });
            //     if (menupreLyr2) {
            //         removeUndefinedFromArray.push({
            //             [GLOBAL_NOMENCLATURE.PSDLayer2Menu]: {
            //                 ProductType: 1,
            //                 unit: unit
            //             }
            //         })
            //     }

            //     // removeUndefinedFromArray.push({
            //     //     [GLOBAL_NOMENCLATURE.PSDMenu]: {
            //     //         ProductType: 1,
            //     //         unit: unit
            //     //     }
            //     // }, {
            //     //     [GLOBAL_NOMENCLATURE.PSDLayer1Menu]: {
            //     //         ProductType: 1,
            //     //         unit: unit
            //     //     },
            //     // }, {
            //     //     [GLOBAL_NOMENCLATURE.PSDLayer2Menu]: {
            //     //         ProductType: 1,
            //     //         unit: unit
            //     //     },
            //     // })
            // }

            if (strInstrument.toUpperCase() === GLOBAL_NOMENCLATURE.IPCBalance.toUpperCase()
                && cubicObj.cubicalData.Sys_BinBalID.toUpperCase() !== "NONE"
                && (
                    (cubicObj.cubicalData.Sys_Area.toUpperCase() === "COMPRESSION" && cubicObj.cubicalData.Sys_CubType.toUpperCase() === "COMPRESSION") ||
                    (cubicObj.cubicalData.Sys_Area.toUpperCase() === "COATING" && cubicObj.cubicalData.Sys_CubType.toUpperCase() === "COATING") ||
                    (cubicObj.cubicalData.Sys_Area.toUpperCase() === "GRANULATION" && cubicObj.cubicalData.Sys_CubType.toUpperCase() === "GRANULATION")
                    // cubicObj.cubicalData.Sys_CubType.toUpperCase() === "COATING" ||
                )) {
                removeUndefinedFromArray.push({ [GLOBAL_NOMENCLATURE.IPCMenu]: {} })
            }

            return removeUndefinedFromArray

        } catch (error) {
            console.log(error)
            throw new Error(error)
        }
    }

    async getBalanceUnit(BalId) {
        try {
            let selctBalanceDetail = await models.tbl_balance.findAll({
                where:
                {
                    Bal_ID: BalId
                }
            })
            let arrProductSample = [selctBalanceDetail];
            return arrProductSample[0][0].Bal_Unit;

        } catch (error) {
            throw new Error(error);
        }
    }

    async getVerinerUnit(VerId) {
        try {
            let selctVernierDetail = await models.tbl_vernier.findAll({
                where: {
                    VernierID: VerId
                }

            })
            let arrProductSample = [selctVernierDetail];
            return arrProductSample[0][0].RangeUnit;

        } catch (error) {
            throw new Error(error);
        }

    }

    async bulkDataMenuMaking(values, currentIdsNo) {
        try {
            let strInstrument = values.instrument;
            let strHmi = values.Hmi;
            let strIdsNo = values.idsNo;
            let intPortNo = values.PortNo;
            let arrProductDetail = values.ProductDetail;
            let objSamples = values.Samples;
            let intProductType = values.prdType;
            const cubicObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi);
            let strHardnessModel;
            let arrHardnessColumn = [];
            let arrHardnessColumnDetail = [];
            let objThickness = {};
            let objBreadth = {};
            let objDiameter = {};
            let objHardness = {};
            let objLength = {};
            var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
            if (IPQCObject != undefined) {
                strHmi = IPQCObject.idsNo;
            } else {
                strHmi = strHmi;
            }
            if (IPQCObject != undefined) {
                var instrumentId = await models.tbl_cubical.findAll({
                    where: {
                        Sys_IDSNo: strHmi
                    }
                })
                instrumentId = instrumentId.pop()
                instrumentId = await this.update_ipqc_instrument([instrumentId])
                cubicObj.cubicalData = instrumentId

            }

            let MenuAccordingToParamsSet = await Promise.all(Object.keys(arrProductDetail[0][0]).map(async (data) => {
                let obj = {}
                let objCalibratedBal = globalData.glbArrListOfCalibratedBal.find(k => k.Hmi == strHmi);
                switch (data) {
                    case 'Param6_T1Neg': //DT
                        if ((arrProductDetail[0][0][data]) > 0 && (arrProductDetail[0][0][data]) !== 99999 &&
                            (arrProductDetail[0][0]['Param6_T1Pos']) > 0 && (arrProductDetail[0][0]["Param6_T1Pos"]) !== 99999) {

                            if (intProductType == 2 &&
                                cubicObj.cubicalData.Sys_DTID != "None" &&
                                strInstrument == "Disintegration Tester" &&
                                objSamples.DT != 0 &&
                                (cubicObj.cubicalData.Sys_Area.toUpperCase() === 'COMPRESSION' || cubicObj.cubicalData.Sys_CubType.toUpperCase() === "IPQC")) {
                                obj[GLOBAL_NOMENCLATURE.DTMenu] = {
                                    'nominal': arrProductDetail[0][0].Param6_Nom,
                                    'T1Neg': arrProductDetail[0][0].Param6_T1Neg,
                                    'T1Pos': arrProductDetail[0][0].Param6_T1Pos,
                                    // 'T2Neg': arrProductDetail[0][0].Param6_T2Neg,
                                    // 'T2Pos': arrProductDetail[0][0].Param6_T2Pos,
                                    'LimitOn': arrProductDetail[0][0].Param6_LimitOn,
                                    'dp': arrProductDetail[0][0].Param6_DP,
                                    'isonstd': arrProductDetail[0][0].Param6_IsOnStd,
                                    'noOfSamples': objSamples.DT,
                                    // 'NMT': arrProductDetail[0][0].Param6_NMTTab,
                                    'ProductType': intProductType,
                                    // 'unit': 'mm'
                                }
                            }
                        }
                        break;
                    case 'Param19_T1Neg': //DT Layer 1
                        if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999 &&
                            parseFloat(arrProductDetail[0][0]['Param19_T1Pos']) > 0 && parseFloat(arrProductDetail[0][0]["Param19_T1Pos"]) != 99999 &&
                            cubicObj.cubicalData.Sys_Area.toUpperCase() === 'COMPRESSION' && cubicObj.cubicalData.Sys_CubType.toUpperCase() === "IPQC"
                            // && parseFloat(arrProductDetail[0][0]['Param19_T1Nom']) > 0 && parseFloat(arrProductDetail[0][0]["Param19_T1Nom"]) != 99999
                        ) {
                            if ((intProductType == 1 || intProductType == 2) &&
                                cubicObj.cubicalData.Sys_DTID != "None" &&
                                strInstrument == "Disintegration Tester") {
                                obj[GLOBAL_NOMENCLATURE.DTLayer1Menu] = {
                                    'nominal': arrProductDetail[0][0].Param19_Nom,
                                    'T1Neg': arrProductDetail[0][0].Param19_T1Neg,
                                    'T1Pos': arrProductDetail[0][0].Param19_T1Pos,
                                    'T2Neg': arrProductDetail[0][0].Param19_T2Neg,
                                    'T2Pos': arrProductDetail[0][0].Param19_T2Pos,
                                    'LimitOn': arrProductDetail[0][0].Param19_LimitOn,
                                    'dp': arrProductDetail[0][0].Param19_Dp,
                                    'isonstd': arrProductDetail[0][0].Param19_IsOnStd,
                                    'noOfSamples': objSamples.Differential,
                                    'NMT': arrProductDetail[0][0].Param19_NMTTab,
                                    'ProductType': intProductType,
                                    'unit': 'mm'
                                }
                            }
                        }
                        break;
                    case 'Param20_T1Neg': //DT Layer 2
                        if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999 &&
                            parseFloat(arrProductDetail[0][0]['Param20_T1Pos']) > 0 && parseFloat(arrProductDetail[0][0]["Param20_T1Pos"]) != 99999
                        ) {
                            if ((intProductType == 1 || intProductType == 2) &&
                                cubicObj.cubicalData.Sys_DTID !== "None" &&
                                strInstrument === "Disintegration Tester" &&
                                cubicObj.cubicalData.Sys_Area.toUpperCase() === 'COMPRESSION' && cubicObj.cubicalData.Sys_CubType.toUpperCase() === "IPQC"
                            ) {
                                obj[GLOBAL_NOMENCLATURE.DTLayer2Menu] = {
                                    'nominal': arrProductDetail[0][0].Param20_Nom,
                                    'T1Neg': arrProductDetail[0][0].Param20_T1Neg,
                                    'T1Pos': arrProductDetail[0][0].Param20_T1Pos,
                                    'T2Neg': arrProductDetail[0][0].Param20_T2Neg,
                                    'T2Pos': arrProductDetail[0][0].Param20_T2Pos,
                                    'LimitOn': arrProductDetail[0][0].Param20_LimitOn,
                                    'dp': arrProductDetail[0][0].Param20_Dp,
                                    'isonstd': arrProductDetail[0][0].Param20_IsOnStd,
                                    'noOfSamples': objSamples.Differential,
                                    'NMT': arrProductDetail[0][0].Param20_NMTTab,
                                    'ProductType': intProductType,
                                    'unit': 'mm'
                                }
                            }
                        }
                        break;
                    case 'Param7_Nom': // hardness 
                        if ((parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999) || (parseFloat(arrProductDetail[0][0]['Param7_T1Pos']) > 0 && parseFloat(arrProductDetail[0][0]['Param7_T1Pos']) != 99999) || (parseFloat(arrProductDetail[0][0]['Param7_T1Neg']) > 0 && parseFloat(arrProductDetail[0][0]['Param7_T1Neg']) != 99999)) {
                            let dimDp = 2
                            if (cubicObj.cubicalData.Sys_HardID != "None" && (strInstrument == "Hardness" || strInstrument == "Tablet Tester") && intProductType == 1) {
                                obj[`${GLOBAL_NOMENCLATURE.HardnessMenu}`] = {
                                    'nominal': arrProductDetail[0][0].Param7_Nom,
                                    'T1Neg': arrProductDetail[0][0].Param7_T1Neg == 99999 ? 'NA' : arrProductDetail[0][0].Param7_T1Neg,
                                    'T1Pos': arrProductDetail[0][0].Param7_T1Pos == 99999 ? 'NA' : arrProductDetail[0][0].Param7_T1Pos,
                                    // 'T2Neg': arrProductDetail[0][0].Param7_T2Neg,
                                    // 'T2Pos': arrProductDetail[0][0].Param7_T2Pos,
                                    'LimitOn': arrProductDetail[0][0].Param7_LimitOn,
                                    'dp': arrProductDetail[0][0].Param7_Dp,
                                    'isonstd': arrProductDetail[0][0].Param7_IsOnStd,
                                    'noOfSamples': objSamples.Hardness,
                                    // 'NMT': arrProductDetail[0][0].Param7_NMTTab,
                                    'ProductType': intProductType,
                                    'unit': arrProductDetail[0][0].Param7_Unit
                                }
                                strHardnessModel = await this.CheckHardnessModel(strIdsNo);
                                let strMt50Type = strHardnessModel.Eqp_HT_Type;
                                // if (strHardnessModel.Eqp_Make == "Pharmatron") {
                                //     if (strMt50Type == 'HTOHL') {
                                //         obj[`${GLOBAL_NOMENCLATURE.TabletTesterMenu}`]['column'] = ["Hardness"];
                                //     } else if (strMt50Type == "HTALL") {
                                objThickness = {
                                    Nom: arrProductDetail[0][0]['Param3_Nom'],
                                    T1Neg: arrProductDetail[0][0]['Param3_T1Neg'],
                                    T1Pos: arrProductDetail[0][0]['Param3_T1Pos'],
                                    T2Pos: arrProductDetail[0][0]['Param3_T2Pos'],
                                    T2Neg: arrProductDetail[0][0]['Param3_T2Neg'],
                                    T3Pos: arrProductDetail[0][0]['Param3_T3Pos'],
                                    T3Neg: arrProductDetail[0][0]['Param3_T3Neg'],
                                    LimitOn: arrProductDetail[0][0]['Param3_LimitOn'],
                                }

                                objBreadth = {
                                    Nom: arrProductDetail[0][0]['Param4_Nom'],
                                    T1Neg: arrProductDetail[0][0]['Param4_T1Neg'],
                                    T1Pos: arrProductDetail[0][0]['Param4_T1Pos'],
                                    T2Pos: arrProductDetail[0][0]['Param4_T2Pos'],
                                    T2Neg: arrProductDetail[0][0]['Param4_T2Neg'],
                                    T3Pos: arrProductDetail[0][0]['Param4_T3Pos'],
                                    T3Neg: arrProductDetail[0][0]['Param4_T3Neg'],
                                    LimitOn: arrProductDetail[0][0]['Param4_LimitOn'],


                                };

                                objDiameter = {
                                    Nom: arrProductDetail[0][0]['Param6_Nom'],
                                    T1Neg: arrProductDetail[0][0]['Param6_T1Neg'],
                                    T1Pos: arrProductDetail[0][0]['Param6_T1Pos'],
                                    T2Pos: arrProductDetail[0][0]['Param6_T2Pos'],
                                    T2Neg: arrProductDetail[0][0]['Param6_T2Neg'],
                                    T3Pos: arrProductDetail[0][0]['Param6_T3Pos'],
                                    T3Neg: arrProductDetail[0][0]['Param6_T3Neg'],
                                    LimitOn: arrProductDetail[0][0]['Param6_LimitOn'],
                                };

                                objHardness = {

                                    Nom: arrProductDetail[0][0]['Param7_Nom'],
                                    T1Neg: arrProductDetail[0][0]['Param7_T1Neg'],
                                    T1Pos: arrProductDetail[0][0]['Param7_T1Pos'],
                                    T2Neg: arrProductDetail[0][0]['Param7_T2Neg'],
                                    T2Pos: arrProductDetail[0][0]['Param7_T2Pos'],
                                    T3Neg: arrProductDetail[0][0]['Param7_T3Neg'],
                                    T3Pos: arrProductDetail[0][0]['Param7_T3Pos'],
                                    LimitOn: arrProductDetail[0][0]['Param7_LimitOn'],
                                };

                                objLength = {
                                    Nom: arrProductDetail[0][0]['Param5_Nom'],
                                    T1Neg: arrProductDetail[0][0]['Param5_T1Neg'],
                                    T1Pos: arrProductDetail[0][0]['Param5_T1Pos'],
                                    T2Pos: arrProductDetail[0][0]['Param5_T2Pos'],
                                    T2Neg: arrProductDetail[0][0]['Param5_T2Neg'],
                                    T3Pos: arrProductDetail[0][0]['Param5_T3Pos'],
                                    T3Neg: arrProductDetail[0][0]['Param5_T3Neg'],
                                    LimitOn: arrProductDetail[0][0]['Param5_LimitOn'],

                                };
                                arrProductDetail[0][0]['Param3_Nom'] == (99999 || 0) ? 0 : arrHardnessColumn.push("Thickness");
                                // arrProductDetail[0][0]['Param4_Nom'] == (99999 || 0) ? 0 : arrHardnessColumn.push("Breadth");
                                arrProductDetail[0][0]['Param6_Nom'] == (99999 || 0) ? 0 : arrHardnessColumn.push("Diameter");
                                arrProductDetail[0][0]['Param7_T1Pos'] == (99999 || 0) ? 0 : arrHardnessColumn.push("Hardness");
                                arrProductDetail[0][0]['Param7_T1Neg'] == (99999 || 0) ? 0 : arrHardnessColumn.push("Hardness");
                                arrProductDetail[0][0]['Param7_Nom'] == (99999 || 0) ? 0 : arrHardnessColumn.push("Hardness");
                                arrProductDetail[0][0]['Param5_Nom'] == (99999 || 0) ? 0 : arrHardnessColumn.push("Length");

                                // for column detail 
                                arrProductDetail[0][0]['Param3_Nom'] == (99999 || 0) ? 0 : arrHardnessColumnDetail.push({ "Thickness": objThickness });
                                // arrProductDetail[0][0]['Param4_Nom'] == (99999 || 0) ? 0 : arrHardnessColumnDetail.push({ "Breadth": objBreadth });
                                arrProductDetail[0][0]['Param6_Nom'] == (99999 || 0) ? 0 : arrHardnessColumnDetail.push({ "Diameter": objDiameter });
                                arrProductDetail[0][0]['Param7_T1Pos'] == (99999 || 0) ? 0 : arrHardnessColumnDetail.push({ "Hardness": objHardness });
                                arrProductDetail[0][0]['Param7_T1Neg'] == (99999 || 0) ? 0 : arrHardnessColumnDetail.push({ "Hardness": objHardness });
                                arrProductDetail[0][0]['Param7_Nom'] == (99999 || 0) ? 0 : arrHardnessColumnDetail.push({ "Hardness": objHardness });
                                arrProductDetail[0][0]['Param5_Nom'] == (99999 || 0) ? 0 : arrHardnessColumnDetail.push({ "Length": objLength });

                                obj[`${GLOBAL_NOMENCLATURE.HardnessMenu}`].column = arrHardnessColumn;
                                obj[`${GLOBAL_NOMENCLATURE.HardnessMenu}`].columnDetail = arrHardnessColumnDetail;
                                // }
                                // }
                                if (strHardnessModel.Eqp_Make == "Sotax ST50") {
                                    objThickness = {
                                        Nom: arrProductDetail[0][0]['Param3_Nom'],
                                        T1Neg: arrProductDetail[0][0]['Param3_T1Neg'],
                                        T1Pos: arrProductDetail[0][0]['Param3_T1Pos'],
                                        T2Pos: arrProductDetail[0][0]['Param3_T2Pos'],
                                        T2Neg: arrProductDetail[0][0]['Param3_T2Neg'],
                                    }

                                    // objBreadth = {
                                    //     Nom: arrProductDetail[0][0]['Param3_Nom'],
                                    //     T1Neg: arrProductDetail[0][0]['Param3_T1Neg'],
                                    //     T1Pos: arrProductDetail[0][0]['Param3_T1Pos'],
                                    //     T2Pos: arrProductDetail[0][0]['Param3_T2Pos'],
                                    //     T2Neg: arrProductDetail[0][0]['Param3_T2Neg'],

                                    // };

                                    // objDiameter = {
                                    //     Nom: arrProductDetail[0][0]['Param3_Nom'],
                                    //     T1Neg: arrProductDetail[0][0]['Param3_T1Neg'],
                                    //     T1Pos: arrProductDetail[0][0]['Param3_T1Pos'],
                                    //     T2Pos: arrProductDetail[0][0]['Param3_T2Pos'],
                                    //     T2Neg: arrProductDetail[0][0]['Param3_T2Neg'],

                                    // };

                                    objHardness = {
                                        Nom: arrProductDetail[0][0]['Param3_Nom'],
                                        T1Neg: arrProductDetail[0][0]['Param3_T1Neg'],
                                        T1Pos: arrProductDetail[0][0]['Param3_T1Pos']
                                    };

                                    arrProductDetail[0][0]['Param3_Nom'] == (99999 || 0) ? 0 : arrHardnessColumn.push("Thickness");
                                    arrProductDetail[0][0]['Param4_Nom'] == (99999 || 0) ? 0 : arrHardnessColumn.push("Breadth");
                                    arrProductDetail[0][0]['Param6_Nom'] == (99999 || 0) ? 0 : arrHardnessColumn.push("Diameter");
                                    arrProductDetail[0][0]['Param7_T1Pos'] == (99999 || 0) ? 0 : arrHardnessColumn.push("Hardness");

                                    //for column detail
                                    arrProductDetail[0][0]['Param3_Nom'] == (99999 || 0) ? 0 : arrHardnessColumnDetail.push({ "Thickness": objThickness });
                                    arrProductDetail[0][0]['Param4_Nom'] == (99999 || 0) ? 0 : arrHardnessColumnDetail.push({ "Breadth": objBreadth });
                                    arrProductDetail[0][0]['Param6_Nom'] == (99999 || 0) ? 0 : arrHardnessColumnDetail.push({ "Diameter": objDiameter });
                                    arrProductDetail[0][0]['Param7_T1Pos'] == (99999 || 0) ? 0 : arrHardnessColumnDetail.push({ "Hardness": objHardness });
                                    obj[`${GLOBAL_NOMENCLATURE.HardnessMenu}`].column = arrHardnessColumn;
                                    obj[`${GLOBAL_NOMENCLATURE.HardnessMenu}`].columnDetail = arrHardnessColumnDetail;
                                }

                            }

                        }
                        break;
                    case 'Param8_Nom': // for Friability
                        if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999) {

                            if (cubicObj.cubicalData.Sys_FriabID != "None" && (strInstrument == "Friability" || strInstrument == "Friabilator")
                                && intProductType == 1 && cubicObj.cubicalData.Sys_Area.toUpperCase() === 'COMPRESSION' && cubicObj.cubicalData.Sys_CubType.toUpperCase() === "IPQC" && serverConfig.friabilityType == "OF") {
                                obj[GLOBAL_NOMENCLATURE.FriabilatorMenu] = {
                                    'nominal': arrProductDetail[0][0].Param8_Nom,
                                    'T1Neg': arrProductDetail[0][0].Param8_T1Neg,
                                    'T1Pos': arrProductDetail[0][0].Param8_T1Pos,
                                    'LimitOn': arrProductDetail[0][0].Param8_LimitOn,
                                    'dp': arrProductDetail[0][0].Param8_Dp,
                                    'isonstd': arrProductDetail[0][0].Param8_IsOnStd,
                                    'noOfSamples': objSamples.Individual,
                                    'NMT': arrProductDetail[0][0].Param8_NMTTab,
                                    'ProductType': intProductType,
                                    'unit': 'g'
                                }
                            }
                        }
                        break;
                    case 'Param13_T1Neg':
                        // if (arrProductDetail[0][0][data] != 'null:null:null') {

                        if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999 &&
                            parseFloat(arrProductDetail[0][0]['Param13_T1Pos']) > 0 && parseFloat(arrProductDetail[0][0]["Param13_T1Pos"]) != 99999 &&
                            // ((cubicObj.cubicalData.Sys_IPQCType.toUpperCase() === 'COMPRESSION' && cubicObj.cubicalData.Sys_CubType.toUpperCase() === "IPQC") || (cubicObj.cubicalData.Sys_IPQCType === 'Coating' && cubicObj.cubicalData.Sys_CubType === "IPQC"))
                            // && parseFloat(arrProductDetail[0][0]['Param19_T1Nom']) > 0 && parseFloat(arrProductDetail[0][0]["Param19_T1Nom"]) != 99999
                            (cubicObj.cubicalData.Sys_CubType.toUpperCase() === "IPQC")
                        ) {
                            console.log("Inside case")
                            if (intProductType == 1 &&
                                cubicObj.cubicalData.Sys_DTID != "None" &&
                                strInstrument == "Disintegration Tester" && objSamples.DT != 0) {
                                console.log("inside if case")
                                obj[GLOBAL_NOMENCLATURE.DT] = {
                                    'nominal': arrProductDetail[0][0].Param13_Nom,
                                    'T1Neg': arrProductDetail[0][0].Param13_T1Neg,
                                    'T1Pos': arrProductDetail[0][0].Param13_T1Pos,
                                    'LimitOn': arrProductDetail[0][0].Param13_LimitOn,
                                    'dp': arrProductDetail[0][0].Param13_DP,
                                    'isonstd': arrProductDetail[0][0].Param13_IsOnStd,
                                    'noOfSamples': objSamples.DT,
                                    // 'NMT': arrProductDetail[0][0].Param13_NMTTab,
                                    'ProductType': intProductType,
                                    //'unit': 'mm'
                                }
                            }
                        }
                        // }

                        break;
                    case 'Param16_T1Pos':
                        if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999) {

                            if (intProductType == 1 && cubicObj.cubicalData.Sys_MoistID != 'None' && (strInstrument == 'Moisture Analyzer' || strInstrument == "LOD")
                                && (cubicObj.cubicalData.Sys_Area.toUpperCase() === 'COATING')) {
                                obj[GLOBAL_NOMENCLATURE.LODMenu] = {
                                    'nominal': arrProductDetail[0][0].Param16_Nom,
                                    'T1Neg': arrProductDetail[0][0].Param16_T1Neg,
                                    'T1Pos': arrProductDetail[0][0].Param16_T1Pos,
                                    'LimitOn': 1,
                                    'dp': 3, //arrProductDetail[0][0].Param1_DP,
                                    'isonstd': 1,
                                    'noOfSamples': objSamples.Individual,
                                    'ProductType': intProductType,
                                    'isonstd': 1,
                                    'unit': ''
                                }
                            }
                        }
                        break;
                    case 'Param2_Low': // Tapped Density
                        if (parseFloat(arrProductDetail[0][0][data]) != 99999 ||
                            parseFloat(arrProductDetail[0][0]["Param2_Upp"]) != 99999 ||
                            parseFloat(arrProductDetail[0][0]["Param3_Upp"]) != 99999 ||
                            parseFloat(arrProductDetail[0][0]["Param3_Low"]) != 99999
                        ) {

                            if (cubicObj.cubicalData.Sys_TapDensityID != 'None' && (strInstrument == 'TDT' || strInstrument == "Tap Density")
                                && (cubicObj.cubicalData.Sys_Area.toUpperCase() === 'GRANULATION' || cubicObj.cubicalData.Sys_Area.toUpperCase() === 'IPQC' || cubicObj.cubicalData.Sys_Area.toUpperCase() === 'IPQC') && cubicObj.cubicalData.Sys_CubType.toUpperCase() === "IPQC"
                                // && cubicObj.cubicalData.Sys_CubType != 'Granulation' && cubicObj.cubicalData.Sys_Area != 'Granulation'
                            ) {
                                obj[GLOBAL_NOMENCLATURE.TDMenu] = {
                                    'BulkDensity_Upp': arrProductDetail[0][0].Param3_Upp == 99999 ? 'NA' : arrProductDetail[0][0].Param3_Upp,
                                    'BulkDensity_Low': arrProductDetail[0][0].Param3_Low == 99999 ? 'NA' : arrProductDetail[0][0].Param3_Low,
                                    'TapDensity_Upp': arrProductDetail[0][0].Param2_Upp == 99999 ? 'NA' : arrProductDetail[0][0].Param2_Upp,
                                    'TapDensity_Low': arrProductDetail[0][0].Param2_Low == 99999 ? 'NA' : arrProductDetail[0][0].Param2_Low,
                                    // 'nominal': arrProductDetail[0][0].Param2_Nom,
                                    // 'T1Neg': arrProductDetail[0][0].Param2_Low,
                                    // 'T1Pos': arrProductDetail[0][0].Param2_Upp,
                                    // 'LimitOn': arrProductDetail[0][0].Param2_LimitOn,
                                    'dp': arrProductDetail[0][0].Param2_DP,
                                    'ProductType': intProductType,
                                    'unit': ''
                                }
                            }
                        }

                        break;
                    case 'Param6_Low': // Tapped Density Layer 1

                        if (parseFloat(arrProductDetail[0][0][data]) != 99999 ||
                            parseFloat(arrProductDetail[0][0]["Param5_Upp"]) != 99999 ||
                            parseFloat(arrProductDetail[0][0]["Param6_Upp"]) != 99999 ||
                            parseFloat(arrProductDetail[0][0]["Param5_Low"]) != 99999
                        ) {

                            if (intProductType == 1 && cubicObj.cubicalData.Sys_TapDensityID != 'None' && (strInstrument == 'TDT' || strInstrument == "Tap Density")
                                && (cubicObj.cubicalData.Sys_Area.toUpperCase() === 'GRANULATION' || cubicObj.cubicalData.Sys_Area.toUpperCase() === 'IPQC' || cubicObj.cubicalData.Sys_Area.toUpperCase() === 'IPQC') && cubicObj.cubicalData.Sys_CubType.toUpperCase() === "IPQC"
                                // && cubicObj.cubicalData.Sys_CubType != 'Granulation' && cubicObj.cubicalData.Sys_Area != 'Granulation'
                            ) {
                                obj[GLOBAL_NOMENCLATURE.TDLayer1Menu] = {
                                    'BulkDensity_Upp': arrProductDetail[0][0].Param6_Upp == 99999 ? 'NA' : arrProductDetail[0][0].Param6_Upp,
                                    'BulkDensity_Low': arrProductDetail[0][0].Param6_Low == 99999 ? 'NA' : arrProductDetail[0][0].Param6_Low,
                                    'TapDensity_Upp': arrProductDetail[0][0].Param5_Upp == 99999 ? 'NA' : arrProductDetail[0][0].Param5_Upp,
                                    'TapDensity_Low': arrProductDetail[0][0].Param5_Low == 99999 ? 'NA' : arrProductDetail[0][0].Param5_Low,
                                    // 'nominal': arrProductDetail[0][0].Param2_Nom,
                                    // 'T1Neg': arrProductDetail[0][0].Param2_Low,
                                    // 'T1Pos': arrProductDetail[0][0].Param2_Upp,
                                    // 'LimitOn': arrProductDetail[0][0].Param2_LimitOn,
                                    // 'dp': arrProductDetail[0][0].Param2_DP,
                                    'ProductType': intProductType,
                                    'unit': ''
                                }
                            }
                        }
                        break;
                    case 'Param9_Low': // Tapped Density Layer 2

                        if (parseFloat(arrProductDetail[0][0][data]) != 99999 ||
                            parseFloat(arrProductDetail[0][0]["Param8_Upp"]) != 99999 ||
                            parseFloat(arrProductDetail[0][0]["Param9_Upp"]) != 99999 ||
                            parseFloat(arrProductDetail[0][0]["Param8_Low"]) != 99999
                        ) {

                            if (intProductType == 1 && cubicObj.cubicalData.Sys_TapDensityID != 'None' && (strInstrument == 'TDT' || strInstrument == "Tap Density")
                                && (cubicObj.cubicalData.Sys_Area.toUpperCase() === 'GRANULATION' || cubicObj.cubicalData.Sys_Area.toUpperCase() === 'IPQC' || cubicObj.cubicalData.Sys_Area.toUpperCase() === 'IPQC') && cubicObj.cubicalData.Sys_CubType.toUpperCase() === "IPQC"
                                // && cubicObj.cubicalData.Sys_CubType != 'Granulation' && cubicObj.cubicalData.Sys_Area != 'Granulation'
                            ) {

                                obj[GLOBAL_NOMENCLATURE.TDLayer2Menu] = {
                                    'BulkDensity_Upp': arrProductDetail[0][0].Param9_Upp == 99999 ? 'NA' : arrProductDetail[0][0].Param9_Upp,
                                    'BulkDensity_Low': arrProductDetail[0][0].Param9_Low == 99999 ? 'NA' : arrProductDetail[0][0].Param9_Low,
                                    'TapDensity_Upp': arrProductDetail[0][0].Param8_Upp == 99999 ? 'NA' : arrProductDetail[0][0].Param8_Upp,
                                    'TapDensity_Low': arrProductDetail[0][0].Param8_Low == 99999 ? 'NA' : arrProductDetail[0][0].Param8_Low,
                                    // 'nominal': arrProductDetail[0][0].Param2_Nom,
                                    // 'T1Neg': arrProductDetail[0][0].Param2_Low,
                                    // 'T1Pos': arrProductDetail[0][0].Param2_Upp,
                                    // 'LimitOn': arrProductDetail[0][0].Param2_LimitOn,
                                    // 'dp': arrProductDetail[0][0].Param2_DP,
                                    'ProductType': intProductType,
                                    'unit': ''
                                }
                            }
                        }
                        break;
                    case 'Param1_Upp':  // for lod and from tab_gran LOD

                        if (parseFloat(arrProductDetail[0][0][data]) != 99999 ||
                            parseFloat(arrProductDetail[0][0]["Param1_Low"]) != 99999 || parseFloat(arrProductDetail[0][0]["Param1_Upp"]) != 99999) {

                            if ((intProductType == 1 || intProductType == 2) &&
                                (cubicObj.cubicalData.Sys_MoistID !== 'None' && strInstrument == GLOBAL_NOMENCLATURE.MoistureAnalyzer) &&
                                (cubicObj.cubicalData.Sys_Area.toUpperCase() === 'GRANULATION' || cubicObj.cubicalData.Sys_Area.toUpperCase() === 'IPQC' || cubicObj.cubicalData.Sys_Area.toUpperCase() === 'IPQC') && cubicObj.cubicalData.Sys_CubType.toUpperCase() === "IPQC") {
                                obj[GLOBAL_NOMENCLATURE.LODMenu] = {
                                    'nominal': arrProductDetail[0][0].Param1_Nom,
                                    // 'T1Neg': arrProductDetail[0][0].Param1_Neg,
                                    // 'T1Pos': arrProductDetail[0][0].Param1_Upp,
                                    'T1Neg': (arrProductDetail[0][0].Param1_Low) != 99999 ? arrProductDetail[0][0].Param1_Low : "NA",
                                    'T1Pos': (arrProductDetail[0][0].Param1_Upp) != 99999 ? arrProductDetail[0][0].Param1_Upp : "NA",
                                    'LimitOn': 1,
                                    'dp': 3, //arrProductDetail[0][0].Param1_DP,
                                    'isonstd': 1,
                                    'noOfSamples': objSamples.Individual,
                                    'ProductType': intProductType,
                                    'isonstd': 1,
                                    'unit': ''
                                }
                            }
                        }
                        break;
                    case 'Param7_Upp':  // for lod and from tab_gran LOD Layer 2
                        if (parseFloat(arrProductDetail[0][0][data]) != 99999 ||
                            parseFloat(arrProductDetail[0][0]["Param7_Low"]) != 99999 || parseFloat(arrProductDetail[0][0]["Param7_Upp"]) != 99999) {

                            if ((intProductType == 1 || intProductType == 2) &&
                                (cubicObj.cubicalData.Sys_MoistID !== 'None' && strInstrument == GLOBAL_NOMENCLATURE.MoistureAnalyzer) &&
                                (cubicObj.cubicalData.Sys_Area.toUpperCase() === 'GRANULATION' || cubicObj.cubicalData.Sys_Area.toUpperCase() === 'IPQC' || cubicObj.cubicalData.Sys_Area.toUpperCase() === 'IPQC') && cubicObj.cubicalData.Sys_CubType.toUpperCase() === "IPQC") {
                                obj[GLOBAL_NOMENCLATURE.LODLayer2Menu] = {
                                    'nominal': arrProductDetail[0][0].Param7_Nom,
                                    // 'T1Neg': arrProductDetail[0][0].Param7_Low,
                                    // 'T1Pos': arrProductDetail[0][0].Param7_Upp,
                                    'T1Neg': (arrProductDetail[0][0].Param7_Low) != 99999 ? arrProductDetail[0][0].Param7_Low : "NA",
                                    'T1Pos': (arrProductDetail[0][0].Param7_Upp) != 99999 ? arrProductDetail[0][0].Param7_Upp : "NA",
                                    'LimitOn': 1,
                                    'dp': 3, //arrProductDetail[0][0].Param7_DP,
                                    'isonstd': 1,
                                    'noOfSamples': objSamples.Individual,
                                    'ProductType': intProductType,
                                    'isonstd': 1,
                                    'unit': ''
                                }
                            }
                        }
                        break;
                    case 'Param4_Upp':  // layer 1 dry
                        if (parseFloat(arrProductDetail[0][0][data]) != 99999 ||
                            parseFloat(arrProductDetail[0][0]["Param4_Low"]) != 99999 || parseFloat(arrProductDetail[0][0]["Param4_Upp"]) != 99999) {

                            if ((intProductType == 1 || intProductType == 2) &&
                                (cubicObj.cubicalData.Sys_MoistID !== 'None' && strInstrument == GLOBAL_NOMENCLATURE.MoistureAnalyzer) &&
                                (cubicObj.cubicalData.Sys_Area.toUpperCase() === 'GRANULATION' || cubicObj.cubicalData.Sys_Area.toUpperCase() === 'IPQC' || cubicObj.cubicalData.Sys_Area.toUpperCase() === 'IPQC') && cubicObj.cubicalData.Sys_CubType.toUpperCase() === "IPQC") {
                                obj[GLOBAL_NOMENCLATURE.LODLayer1Menu] = {
                                    'nominal': arrProductDetail[0][0].Param4_Nom,
                                    // 'T1Neg': arrProductDetail[0][0].Param4_Low,
                                    // 'T1Pos': arrProductDetail[0][0].Param4_Upp,
                                    'T1Neg': (arrProductDetail[0][0].Param4_Low) != 99999 ? arrProductDetail[0][0].Param4_Low : "NA",
                                    'T1Pos': (arrProductDetail[0][0].Param4_Upp) != 99999 ? arrProductDetail[0][0].Param4_Upp : "NA",
                                    'LimitOn': arrProductDetail[0][0].Param4_IsOnStd,
                                    'dp': arrProductDetail[0][0].Param4_DP,
                                    'isonstd': arrProductDetail[0][0].Param4_IsOnStd,
                                    // 'noOfSamples': objSamples.Individual,
                                    'ProductType': intProductType,
                                    // 'isonstd': 1,
                                    'unit': ''
                                }
                            }
                        }
                        break;
                    case 'Param2_Upp':
                        if (parseFloat(arrProductDetail[0][0][data]) > 0 && parseFloat(arrProductDetail[0][0][data]) != 99999) {

                            if ((intProductType == 1 || intProductType == 2) &&
                                cubicObj.cubicalData.Sys_MoistID != 'None' && strInstrument == 'LOD'
                            ) {
                                obj['LAY1DRY'] = {
                                    'nominal': arrProductDetail[0][0].Param3_Nom,
                                    'T1Neg': arrProductDetail[0][0].Param3_Low,
                                    'T1Pos': arrProductDetail[0][0].Param3_Upp,
                                    'LimitOn': 1,
                                    'dp': arrProductDetail[0][0].Param3_DP,
                                    'isonstd': 1,
                                    'noOfSamples': objSamples.Individual,
                                    'ProductType': intProductType,
                                    'isonstd': 1,
                                    'unit': ''
                                }
                            }
                        }
                        break;


                }
                if (Object.keys(obj).length != 0 && obj.constructor === Object) {
                    return obj;
                };
            }))

            let removeUndefinedFromArray = MenuAccordingToParamsSet.filter(v => v != undefined);

            return removeUndefinedFromArray;

        } catch (error) {
            throw new Error(error);
        }
    }

    async onMenuStart(value) {
        try {
            let menuName = value.menuName;
            let resObj = {}
            let strInstrumentType, instrumentId, portNo, unit, Nomunit;
            let strHmi = value.Hmi;
            let objIdsNo = await objHmiModel.getResbPiNoFromHmi(strHmi);
            let strIdsNo = objIdsNo[0].IDSNo;
            let selectedIdsNo;

            var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.strIdsNo == strIdsNo);
            if (IPQCObject != undefined) {
                selectedIdsNo = IPQCObject.selectedIds;
            } else {
                selectedIdsNo = strIdsNo;
            }

            var obj = {
                Hmi: strHmi,
                idsNo: strIdsNo,
                menuType: menuName
            }

            if (menuName.toUpperCase() === GLOBAL_NOMENCLATURE.IPCMenu) {
                //check coridor or with in and implement coridor logic futher. 

                var resBinList = await ipcWeighment.getBinList({ Hmi: strHmi, idsNo: strIdsNo, menu: "Gross Weight" })

                return resBinList

            } else {
                var CubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == strIdsNo)

                var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.strIdsNo == strIdsNo);
                if (IPQCObject != undefined) {
                    strHmi = IPQCObject.selectedIds.Idsno;
                    // var Sys_RotaryType =CubicInfo.cubicalData.Sys_RotaryType
                    // var Sys_RptType = CubicInfo.cubicalData.Sys_RptType
                } else {
                    strHmi = strHmi;
                }
                if (IPQCObject != undefined) {
                    var cubicalmain = await models.tbl_cubical.findAll({
                        where: {
                            Sys_IDSNo: strHmi
                        }
                    })
                    cubicalmain = cubicalmain.pop()
                    CubicInfo.cubicalData = cubicalmain
                    //     if (IPQCObject != undefined) {
                    //         strHmi = IPQCObject.idsNo
                    //     } 

                    //    var instrument = await models.tbl_cubical.findAll({
                    //         where: {
                    //             Sys_IDSNo: strHmi
                    //         }
                    //     })
                    //      instrument = instrument.pop()
                    //     instrument = await this.update_ipqc_instrument([instrument])
                    //     CubicInfo.cubicalData = instrument


                    // CubicInfo.cubicalData.Sys_RotaryType = Sys_RotaryType
                    // CubicInfo.cubicalData.Sys_RptType = Sys_RptType
                    var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.strIdsNo == strIdsNo);
                    if (IPQCObject != undefined) {
                        strHmi = IPQCObject.idsNo;
                    } else {
                        strHmi = strHmi;
                    }

                }

                let prodtDetail1 = globalData.arr_limits.find(k => k.idsNo == strIdsNo); //not current idsno
                // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.strIdsNo == strIdsNo);
                // if (IPQCObject != undefined) {
                //     strIdsNo = IPQCObject.selectedIds.Idsno;
                // } else {
                //     strIdsNo = strIdsNo;
                // }
                CubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == strIdsNo).cubicalData;
                // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.strIdsNo == strIdsNo);
                // if (IPQCObject != undefined) {
                //     strIdsNo = IPQCObject.idsNo;
                // } else {
                //     strIdsNo = strIdsNo;
                // }
                let CurrentCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == strIdsNo).cubicalData;
                // let prodtDetail1 = globalData.arr_limits.find(k => k.idsNo == strIdsNo); //not current idsno

                // let CubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == selectedIdsNo).cubicalData;
                // let CurrentCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == strIdsNo).cubicalData;


                let intRptType = CubicInfo.Sys_RptType;
                let sysArea = CubicInfo.Sys_Area;
                let productName = CubicInfo.Sys_ProductName;
                let StrBFGCode = CubicInfo.Sys_BFGCode;
                let StrBatch = CubicInfo.Sys_Batch;
                let StrRotaryType = CubicInfo.Sys_RotaryType;
                let obj1;
                let arr = [];
                let i = 1;


                const selectProductMaster = await models.tbl_product_master.findAll({
                    where: {
                        ProductId: CubicInfo.Sys_BFGCode,
                        ProductName: CubicInfo.Sys_ProductName,
                        ProductVersion: CubicInfo.Sys_PVersion,
                        Version: CubicInfo.Sys_Version,
                    }
                })
                var productType = selectProductMaster[0].ProductType;

                var remark = await this.VerifyReport(value.menuName, CubicInfo, productType, strHmi)
                if (remark == true) {
                    value.menuName = value.menuName == "PSD" ? 'PARTICLE SIZE' : value.menuName
                    return Object.assign(resObj, { status: 'fail', message: `Remark Pending for ${(value.menuName).toUpperCase()} Test` })
                }

                (globalData.arrcalibType.findIndex((element) => element.Hmi === strHmi)) == -1 ?
                    globalData.arrcalibType : globalData.arrcalibType.splice(globalData.arrcalibType.findIndex((element) => element.Hmi === strHmi), 1);

                (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ?
                    globalData.arrCurrentOperationStatus :
                    globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);

                let arrBal = await objCommonOperation.getCubicalData(strHmi);
                let objdetails = arrBal[0];

                for (let obj in objdetails) {
                    if (objdetails[`Sys_Port${i}`] == undefined || objdetails[`Sys_Port${i}`] == "NULL" || objdetails[`Sys_Port${i}`] == "None" || objdetails[`Sys_Port${i}`] == null) {
                        i++;
                        continue;
                    }
                    else {
                        if (objdetails[`Sys_Port${i}`] == "Balance") {
                            arr.push(
                                { "BalanceId": objdetails['Sys_BalID'], "PortNo": i, Type: objdetails[`Sys_Port${i}`] }
                            )
                        } else if (objdetails[`Sys_Port${i}`] == "Vernier") {
                            arr.push(
                                { "VernierId": objdetails['Sys_VernierID'], "PortNo": i, Type: objdetails[`Sys_Port${i}`] }
                            )
                        } else if (objdetails[`Sys_Port${i}`] == "Hardness" || objdetails[`Sys_Port${i}`] == "TBTTST" || objdetails[`Sys_Port${i}`] == "Tablet Tester") {
                            arr.push(
                                { "HardnessId": objdetails['Sys_HardID'], "PortNo": i, Type: objdetails[`Sys_Port${i}`] }
                            )
                        }
                        else if (objdetails[`Sys_Port${i}`] == "Friabilator" || objdetails[`Sys_Port${i}`] == "Friability") {
                            arr.push(
                                { "FriabilityId": objdetails['Sys_FriabID'], "PortNo": i, Type: objdetails[`Sys_Port${i}`] }
                            )
                        }
                        else if (objdetails[`Sys_Port${i}`] == "Disintegration Tester" || objdetails[`Sys_Port${i}`] == "DT") {
                            arr.push(
                                { "DTId": objdetails['Sys_DTID'], "PortNo": i, Type: objdetails[`Sys_Port${i}`] }
                            )
                        }
                        else if (objdetails[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.MoistureAnalyzer) {
                            arr.push(
                                { "MoistureAnalyserId": objdetails['Sys_MoistID'], "PortNo": i, Type: objdetails[`Sys_Port${i}`] }
                            )
                        }
                        else if (objdetails[`Sys_Port${i}`] == "Tap Density") {
                            arr.push(
                                { "TappedDensityId": objdetails['Sys_TapDensityID'], "PortNo": i, Type: objdetails[`Sys_Port${i}`] }
                            )
                        }
                        i++;
                    }
                }

                switch (menuName) {
                    case GLOBAL_NOMENCLATURE.IndividualMenu: {
                        menuName = GLOBAL_NOMENCLATURE.IndividualMenu;
                        strInstrumentType = GLOBAL_NOMENCLATURE.Balance;
                        instrumentId = arr.find(k => k.BalanceId).BalanceId;
                        portNo = arr.find(k => k.BalanceId).PortNo;
                    }
                        break;
                    case GLOBAL_NOMENCLATURE.IndLayerMenu: {
                        menuName = GLOBAL_NOMENCLATURE.IndLayerMenu;
                        strInstrumentType = GLOBAL_NOMENCLATURE.Balance;
                        instrumentId = arr.find(k => k.BalanceId).BalanceId;
                        portNo = arr.find(k => k.BalanceId).PortNo;

                    }
                        break;
                    case GLOBAL_NOMENCLATURE.IndLayer1Menu: {
                        menuName = GLOBAL_NOMENCLATURE.IndLayer1Menu;
                        strInstrumentType = GLOBAL_NOMENCLATURE.Balance;
                        instrumentId = arr.find(k => k.BalanceId).BalanceId;
                        portNo = arr.find(k => k.BalanceId).PortNo;

                    }
                        break;
                    case GLOBAL_NOMENCLATURE.GroupIndividual: {
                        menuName = GLOBAL_NOMENCLATURE.GroupIndividual;
                        strInstrumentType = GLOBAL_NOMENCLATURE.Balance;
                        instrumentId = arr.find(k => k.BalanceId).BalanceId;
                        portNo = arr.find(k => k.BalanceId).PortNo;
                    }
                        break;
                    case GLOBAL_NOMENCLATURE.GroupMenu: {
                        menuName = GLOBAL_NOMENCLATURE.GroupMenu;
                        strInstrumentType = GLOBAL_NOMENCLATURE.Balance;
                        instrumentId = arr.find(k => k.BalanceId).BalanceId;
                        portNo = arr.find(k => k.BalanceId).PortNo;
                    }
                        break;
                    case GLOBAL_NOMENCLATURE.GroupLayerMenu: {
                        menuName = GLOBAL_NOMENCLATURE.GroupLayerMenu;
                        strInstrumentType = GLOBAL_NOMENCLATURE.Balance;
                        instrumentId = arr.find(k => k.BalanceId).BalanceId;
                        portNo = arr.find(k => k.BalanceId).PortNo;
                    }
                        break;
                    case GLOBAL_NOMENCLATURE.GroupLayer1Menu: {
                        menuName = GLOBAL_NOMENCLATURE.GroupLayer1Menu;
                        strInstrumentType = GLOBAL_NOMENCLATURE.Balance;
                        instrumentId = arr.find(k => k.BalanceId).BalanceId;
                        portNo = arr.find(k => k.BalanceId).PortNo;
                    }
                        break;
                    case GLOBAL_NOMENCLATURE.ThicknessMenu: {
                        menuName = GLOBAL_NOMENCLATURE.ThicknessMenu;
                        strInstrumentType = GLOBAL_NOMENCLATURE.Vernier;
                        instrumentId = arr.find(k => k.VernierId).VernierId;
                        portNo = arr.find(k => k.VernierId).PortNo;
                    }
                        break;
                    case GLOBAL_NOMENCLATURE.DiameterMenu: {
                        menuName = GLOBAL_NOMENCLATURE.DiameterMenu;
                        strInstrumentType = GLOBAL_NOMENCLATURE.Vernier;
                        instrumentId = arr.find(k => k.VernierId).VernierId;
                        portNo = arr.find(k => k.VernierId).PortNo;
                    }
                        break;
                    case GLOBAL_NOMENCLATURE.BreadthMenu: {
                        menuName = GLOBAL_NOMENCLATURE.BreadthMenu;
                        strInstrumentType = GLOBAL_NOMENCLATURE.Vernier;
                        instrumentId = arr.find(k => k.VernierId).VernierId;
                        portNo = arr.find(k => k.VernierId).PortNo;

                    }
                        break;
                    case GLOBAL_NOMENCLATURE.TabletTesterMenu:
                    case GLOBAL_NOMENCLATURE.HardnessMenu: {
                        // menuName = GLOBAL_NOMENCLATURE.TabletTester;
                        menuName = menuName;
                        strInstrumentType = GLOBAL_NOMENCLATURE.Hardness;
                        instrumentId = arr.find(k => k.HardnessId).HardnessId;
                        portNo = arr.find(k => k.HardnessId).PortNo;

                    }
                        break;
                    case GLOBAL_NOMENCLATURE.FriabilityMenu:
                    case GLOBAL_NOMENCLATURE.FriabilatorMenu: {
                        if (menuName == GLOBAL_NOMENCLATURE.FriabilatorMenu) {
                            menuName = GLOBAL_NOMENCLATURE.FriabilatorMenu;
                            strInstrumentType = GLOBAL_NOMENCLATURE.FriabilatorMenu;
                            portNo = arr.find(k => k.FriabilityId).PortNo;
                            instrumentId = arr.find(k => k.FriabilityId).FriabilityId;

                        } else {
                            menuName = GLOBAL_NOMENCLATURE.FriabilityMenu;
                            if (serverConfig.friabilityType == "OF") {
                                strInstrumentType = GLOBAL_NOMENCLATURE.Friability;
                                portNo = arr.find(k => k.FriabilityId).PortNo;
                                instrumentId = arr.find(k => k.FriabilityId).FriabilityId;
                            } else {
                                strInstrumentType = GLOBAL_NOMENCLATURE.Balance;
                                portNo = arr.find(k => k.BalanceId).PortNo;
                                // instrumentId = arr.find(k => k.FriabilityId).FriabilityId;
                                instrumentId = arr.find(k => k.BalanceId).BalanceId;
                            }
                        }
                    }
                        break;

                    case GLOBAL_NOMENCLATURE.DTMenu:
                    case GLOBAL_NOMENCLATURE.DTLayer1Menu:
                    case GLOBAL_NOMENCLATURE.DTLayer2Menu:
                        {
                            // menuName = GLOBAL_NOMENCLATURE.DTMenu;
                            strInstrumentType = GLOBAL_NOMENCLATURE.DT;
                            instrumentId = arr.find(k => k.DTId).DTId;
                            portNo = arr.find(k => k.DTId).PortNo;
                        }
                        break;
                    case GLOBAL_NOMENCLATURE.LengthMenu:
                    case GLOBAL_NOMENCLATURE.SealLengthMenu: {

                        // menuName = GLOBAL_NOMENCLATURE.LengthMenu;
                        strInstrumentType = GLOBAL_NOMENCLATURE.Vernier;
                        instrumentId = arr.find(k => k.VernierId).VernierId;
                        portNo = arr.find(k => k.VernierId).PortNo;

                    }
                        break;

                    case GLOBAL_NOMENCLATURE.MoistureAnalyzer:
                    case GLOBAL_NOMENCLATURE.LODMenu:
                    case GLOBAL_NOMENCLATURE.LODLayer1Menu:
                    case GLOBAL_NOMENCLATURE.LODLayer2Menu:
                    case GLOBAL_NOMENCLATURE.granulationDry:
                    case GLOBAL_NOMENCLATURE.granulationLub:
                    case GLOBAL_NOMENCLATURE.lay1Dry:
                    case GLOBAL_NOMENCLATURE.lay1Lub:
                    case GLOBAL_NOMENCLATURE.lay2Dry:
                    case GLOBAL_NOMENCLATURE.lay2Lub:
                        {
                            // menuName = GLOBAL_NOMENCLATURE.MoistureAnalyzer;
                            // strInstrumentType = GLOBAL_NOMENCLATURE.MoistureAnalyzer;
                            // menuName = "LOD";
                            // menuName = menuName;
                            strInstrumentType = GLOBAL_NOMENCLATURE.MoistureAnalyzer;
                            instrumentId = arr.find(k => k.MoistureAnalyserId).MoistureAnalyserId;
                            portNo = arr.find(k => k.MoistureAnalyserId).PortNo;
                        }
                        break;

                    case GLOBAL_NOMENCLATURE.TappedDensity:
                    case GLOBAL_NOMENCLATURE.TDMenu:
                    case GLOBAL_NOMENCLATURE.TDLayer1Menu:
                    case GLOBAL_NOMENCLATURE.TDLayer2Menu:
                        {
                            // menuName = GLOBAL_NOMENCLATURE.TappedDensity;
                            strInstrumentType = GLOBAL_NOMENCLATURE.TappedDensity;
                            instrumentId = arr.find(k => k.TappedDensityId).TappedDensityId;
                            portNo = arr.find(k => k.TappedDensityId).PortNo;
                        }
                        break;

                    case GLOBAL_NOMENCLATURE.PercentageFine:
                    case GLOBAL_NOMENCLATURE.perFineMenu:
                    case GLOBAL_NOMENCLATURE.perFineLayer1Menu:
                    case GLOBAL_NOMENCLATURE.perFineLayer2Menu:
                        {
                            // menuName = GLOBAL_NOMENCLATURE.PercentageFine;
                            strInstrumentType = GLOBAL_NOMENCLATURE.Balance;
                            instrumentId = arr.find(k => k.BalanceId).BalanceId;
                            portNo = arr.find(k => k.BalanceId).PortNo;
                        }
                        break;

                    case GLOBAL_NOMENCLATURE.ParticalSizing:
                    case GLOBAL_NOMENCLATURE.PSDMenu:
                    case GLOBAL_NOMENCLATURE.PSDLayer1Menu:
                    case GLOBAL_NOMENCLATURE.PSDLayer2Menu: {
                        // menuName = GLOBAL_NOMENCLATURE.ParticalSizing;
                        strInstrumentType = GLOBAL_NOMENCLATURE.Balance;
                        instrumentId = arr.find(k => k.BalanceId).BalanceId;
                        portNo = arr.find(k => k.BalanceId).PortNo;
                    }
                        break;

                    case GLOBAL_NOMENCLATURE.Differential: {
                        menuName = GLOBAL_NOMENCLATURE.Differential;
                        strInstrumentType = GLOBAL_NOMENCLATURE.Balance;
                        instrumentId = arr.find(k => k.BalanceId).BalanceId;
                        portNo = arr.find(k => k.BalanceId).PortNo;
                    }
                        break;

                    case GLOBAL_NOMENCLATURE.EmptyShell: {
                        menuName = GLOBAL_NOMENCLATURE.EmptyShell;
                        strInstrumentType = GLOBAL_NOMENCLATURE.Balance;
                        instrumentId = arr.find(k => k.BalanceId).BalanceId;
                        portNo = arr.find(k => k.BalanceId).PortNo;
                    }
                        break;

                }
                const removeSelectMenuDetail = prodtDetail1.Menus.reduce((object, key) => {
                    if (Object.keys(key) == menuName) {

                        let b = Object.keys(key);
                        object[Object.keys(key)] = key[b];
                    }
                    return object;
                }, {});

                let productDetail = Object.values(removeSelectMenuDetail)[0];

                //storing menu stype globally
                let objSelMenu = globalData.arrSelectedMenu.find(k => k.idsNo == strIdsNo);
                if (objSelMenu == undefined) {
                    globalData.arrSelectedMenu.push({
                        Hmi: strHmi,
                        idsNo: strIdsNo,
                        menuName: menuName,
                        selectedProductDetail: productDetail,
                        instrumentId: instrumentId,
                        InstrumentType: strInstrumentType,
                        portNo: portNo
                    })
                } else {
                    objSelMenu.idsNo = strIdsNo;
                    objSelMenu.Hmi = strHmi;
                    objSelMenu.menuName = menuName;
                    objSelMenu.selectedProductDetail = productDetail;
                    objSelMenu.instrumentId = instrumentId;
                    objSelMenu.InstrumentType = strInstrumentType;
                    objSelMenu.portNo = portNo;
                }

                objSelMenu = globalData.arrSelectedMenu.find(k => k.idsNo == strIdsNo);
                let T1_Pos_ActualValue, T1_Neg_ActualValue, T2_Pos_ActualValue, T2_Neg_ActualValue;

                /**
                 * getting uppper and lower value.
                 */
                if (productDetail.dp == undefined && productDetail.unit == 'mm') { productDetail.dp = 2 }
                if (menuName != GLOBAL_NOMENCLATURE.DTMenu && menuName != GLOBAL_NOMENCLATURE.DTLayer1Menu && menuName != GLOBAL_NOMENCLATURE.DTLayer2Menu
                    && menuName != "TBTTST" && menuName != "Hardness"
                    && menuName != "FRIABI" && menuName != "FRIAB" && menuName != 'FRIABILATOR'
                    && menuName != "Percentage Fine" && menuName != GLOBAL_NOMENCLATURE.perFineMenu && menuName != GLOBAL_NOMENCLATURE.perFineLayer1Menu && menuName != GLOBAL_NOMENCLATURE.perFineLayer2Menu
                    && menuName != 'Particle Sizing' && menuName != GLOBAL_NOMENCLATURE.PSDMenu && menuName != GLOBAL_NOMENCLATURE.PSDLayer1Menu && menuName != GLOBAL_NOMENCLATURE.PSDLayer2Menu
                    && menuName != 'GRPIND'
                    && menuName != 'Tapped Density' && menuName != GLOBAL_NOMENCLATURE.TDMenu && menuName != GLOBAL_NOMENCLATURE.TDLayer1Menu && menuName != GLOBAL_NOMENCLATURE.TDLayer2Menu
                    && menuName != GLOBAL_NOMENCLATURE.LODMenu && menuName != GLOBAL_NOMENCLATURE.lay1Lub && menuName != GLOBAL_NOMENCLATURE.granulationLub && menuName != GLOBAL_NOMENCLATURE.LODLayer1Menu && menuName != GLOBAL_NOMENCLATURE.LODLayer2Menu
                ) {
                    T1_Pos_ActualValue = productDetail.unit != 'mg' ? Number(objFormulaFun.upperLimit(objSelMenu.selectedProductDetail, "T1"))
                        .toFixed(productDetail.dp).concat(` ${productDetail.unit}`) : Number(objFormulaFun.upperLimit(objSelMenu.selectedProductDetail, "T1"))
                        .toFixed(1).concat(` ${productDetail.unit}`)

                    T1_Neg_ActualValue = productDetail.unit != 'mg' ? Number(objFormulaFun.lowerLimit(objSelMenu.selectedProductDetail, "T1"))
                        .toFixed(productDetail.dp).concat(` ${productDetail.unit}`) : Number(objFormulaFun.lowerLimit(objSelMenu.selectedProductDetail, "T1"))
                        .toFixed(1).concat(` ${productDetail.unit}`)

                    // T2_Pos_ActualValue = Number(objFormulaFun.upperLimit(objSelMenu.selectedProductDetail))
                    //     .toFixed(productDetail.dp).concat(` ${productDetail.unit}`);

                    T2_Pos_ActualValue = productDetail.unit != 'mg' ? (Math.round(Number(objFormulaFun.upperLimit(objSelMenu.selectedProductDetail))
                        * Math.pow(10, productDetail.dp)) / Math.pow(10, productDetail.dp)).toFixed(productDetail.dp).concat(` ${productDetail.unit}`) : (Math.round(Number(objFormulaFun.upperLimit(objSelMenu.selectedProductDetail))
                    * Math.pow(10, productDetail.dp)) / Math.pow(10, productDetail.dp)).toFixed(1).concat(` ${productDetail.unit}`)

                    // T2_Neg_ActualValue = Number(objFormulaFun.lowerLimit(objSelMenu.selectedProductDetail))
                    //     .toFixed(productDetail.dp).concat(` ${productDetail.unit}`);

                    T2_Neg_ActualValue = productDetail.unit != 'mg' ? (Math.round(Number(objFormulaFun.lowerLimit(objSelMenu.selectedProductDetail))
                        * Math.pow(10, productDetail.dp)) / Math.pow(10, productDetail.dp)).toFixed(productDetail.dp).concat(` ${productDetail.unit}`) : (Math.round(Number(objFormulaFun.lowerLimit(objSelMenu.selectedProductDetail))
                    * Math.pow(10, productDetail.dp)) / Math.pow(10, productDetail.dp)).toFixed(1).concat(` ${productDetail.unit}`)
                }

                let objHardness = objSelMenu.selectedProductDetail.columnDetail;
                let dimDp = 2;
                if (menuName === "Hardness") {
                    for (let keys of objHardness) {
                        if (keys["Thickness"] !== undefined) {
                            keys.Thickness.T1ActualNeg = Number(Number(keys.Thickness.Nom) - Number(keys.Thickness.T1Neg)).toFixed(dimDp);
                            keys.Thickness.T1ActualPos = Number(Number(keys.Thickness.Nom) + Number(keys.Thickness.T1Pos)).toFixed(dimDp);
                            keys.Thickness.T2ActualNeg = Number(Number(keys.Thickness.Nom) - Number(keys.Thickness.T2Neg)).toFixed(dimDp);
                            keys.Thickness.T2ActualPos = Number(Number(keys.Thickness.Nom) + Number(keys.Thickness.T2Pos)).toFixed(dimDp);
                            keys.Thickness.T3ActualNeg = Number(Number(keys.Thickness.Nom) - Number(keys.Thickness.T3Neg)).toFixed(dimDp);
                            keys.Thickness.T3ActualPos = Number(Number(keys.Thickness.Nom) + Number(keys.Thickness.T3Pos)).toFixed(dimDp);
                            keys.Thickness.Unit = "mm"
                        } else if (keys["Diameter"] !== undefined) {
                            keys.Diameter.T1ActualNeg = Number(Number(keys.Diameter.Nom) - Number(keys.Diameter.T1Neg)).toFixed(dimDp);
                            keys.Diameter.T1ActualPos = Number(Number(keys.Diameter.Nom) + Number(keys.Diameter.T1Pos)).toFixed(dimDp);
                            keys.Diameter.T2ActualNeg = Number(Number(keys.Diameter.Nom) - Number(keys.Diameter.T2Neg)).toFixed(dimDp);
                            keys.Diameter.T2ActualPos = Number(Number(keys.Diameter.Nom) + Number(keys.Diameter.T2Pos)).toFixed(dimDp);
                            keys.Diameter.T3ActualNeg = Number(Number(keys.Diameter.Nom) - Number(keys.Diameter.T3Neg)).toFixed(dimDp);
                            keys.Diameter.T3ActualPos = Number(Number(keys.Diameter.Nom) + Number(keys.Diameter.T3Pos)).toFixed(dimDp);
                            keys.Diameter.Unit = "mm"
                        } else if (keys["Length"] !== undefined) {
                            keys.Length.T1ActualNeg = Number(Number(keys.Length.Nom) - Number(keys.Length.T1Neg)).toFixed(dimDp);
                            keys.Length.T1ActualPos = Number(Number(keys.Length.Nom) + Number(keys.Length.T1Pos)).toFixed(dimDp);
                            keys.Length.T2ActualNeg = Number(Number(keys.Length.Nom) - Number(keys.Length.T2Neg)).toFixed(dimDp);
                            keys.Length.T2ActualPos = Number(Number(keys.Length.Nom) + Number(keys.Length.T2Pos)).toFixed(dimDp);
                            keys.Length.T3ActualNeg = Number(Number(keys.Length.Nom) - Number(keys.Length.T3Neg)).toFixed(dimDp);
                            keys.Length.T3ActualPos = Number(Number(keys.Length.Nom) + Number(keys.Length.T3Pos)).toFixed(dimDp);
                            keys.Length.Unit = "mm"
                        }
                        else if (keys["Hardness"] !== undefined) {
                            keys.Hardness.T1ActualNeg = keys.Hardness.T1Neg
                            keys.Hardness.T1ActualPos = keys.Hardness.T1Pos
                            keys.Hardness.T2ActualNeg = keys.Hardness.T2Neg
                            keys.Hardness.T2ActualPos = keys.Hardness.T2Pos
                            keys.Hardness.T3ActualNeg = keys.Hardness.T3Neg
                            keys.Hardness.T3ActualPos = keys.Hardness.T3Pos
                            keys.Hardness.Unit = objSelMenu.selectedProductDetail.unit
                        }
                    }
                }
                /**
                 * check Rotary and make 
                 */
                var modelDetails;
                if ((menuName == "Disintegration_Tester" || menuName == GLOBAL_NOMENCLATURE.DTMenu ||
                    menuName == GLOBAL_NOMENCLATURE.DTLayer1Menu || menuName == GLOBAL_NOMENCLATURE.DTLayer2Menu
                )) {
                    const EQUIP_MODEL_NAME = await this.getDetailOfBulkInstrumentModel(instrumentId);
                    if (EQUIP_MODEL_NAME.Eqp_Model == undefined) {
                        modelDetails = "JAR A"
                    } else {
                        modelDetails = Object.entries(GLOBAL_NOMENCLATURE.DTModels).filter(k => k[0] == EQUIP_MODEL_NAME.Eqp_Model)[0][1];
                        console.log(modelDetails)
                        if (modelDetails == undefined) {
                            modelDetails = "NA"
                        }
                    }

                }


                /*
                add editableSide : true/false based on double rotary
                add editableSampleNo: true/false
                Side :
                */
                //static configuration
                let editableSide = true;
                let editableSampleNo = true;
                let showLot = false;
                var side;
                if (!(menuName.replace(/\_/g, " ") == GLOBAL_NOMENCLATURE.DTMenu) && menuName.replace(/\_/g, " ") == GLOBAL_NOMENCLATURE.DTLayer1Menu && menuName.replace(/\_/g, " ") == GLOBAL_NOMENCLATURE.DTLayer2Menu) {
                    side = StrRotaryType == "Double" ? ['LHS', 'RHS'] : "NA";
                }
                let tblMaster;
                let tblDetails;
                // if (productDetail.ProductType == 2) {
                //     tblMaster = 'tbl_cap_master2';
                //     tblDetails = 'tbl_cap_detail2';
                // }

                switch (menuName) {
                    case GLOBAL_NOMENCLATURE.GroupMenu:
                        if (productDetail.ProductType == 2) {
                            tblMaster = 'tbl_cap_master2';
                            tblDetails = 'tbl_cap_detail2';
                        } else {
                            tblMaster = "tbl_tab_master2";
                            tblDetails = 'tbl_tab_detail2';
                        }
                        break;
                    case GLOBAL_NOMENCLATURE.SealLengthMenu:
                        tblMaster = "tbl_cap_master5"
                        tblDetails = "tbl_cap_detail5"
                        break;
                    case GLOBAL_NOMENCLATURE.Differential:
                        tblMaster = "tbl_cap_master3"
                        tblDetails = "tbl_cap_detail3"
                        break;
                    case GLOBAL_NOMENCLATURE.ThicknessMenu:
                        tblMaster = "tbl_tab_master3"
                        tblDetails = "tbl_tab_detail3"
                        break;
                    case GLOBAL_NOMENCLATURE.BreadthMenu:
                        tblMaster = "tbl_tab_master4"
                        tblDetails = "tbl_tab_detail4"
                        break;
                    case GLOBAL_NOMENCLATURE.LengthMenu:
                        tblMaster = "tbl_tab_master5"
                        tblDetails = "tbl_tab_detail5"
                        break;
                    case GLOBAL_NOMENCLATURE.DiameterMenu:
                        tblMaster = "tbl_tab_master6"
                        tblDetails = "tbl_tab_detail6"
                        break;
                    case GLOBAL_NOMENCLATURE.LODMenu:
                        tblMaster = "tbl_lodmaster"
                        console.log("LOD menu");
                        break;
                    case GLOBAL_NOMENCLATURE.IndividualMenu:
                        if (productType == 1) {
                            tblMaster = "tbl_tab_master1"
                            tblDetails = "tbl_tab_detail1"
                        } else {
                            tblMaster = "tbl_cap_master1"
                            tblDetails = "tbl_cap_detail1"
                        }
                        break;
                    case GLOBAL_NOMENCLATURE.perFineMenu:
                        if (productType == 1) {
                            tblMaster = "tbl_tab_master17";
                            tblDetails = "tbl_tab_detail17"
                        } else {
                            tblMaster = "tbl_cap_master17";
                            tblDetails = "tbl_cap_detail17"
                        }
                        break;


                    case GLOBAL_NOMENCLATURE.Hardness:
                        tblMaster = "tbl_tab_masterhtd";
                        tblDetails = "tbl_tab_detailhtd";
                        break;
                    default:
                        break;
                }
                let resultCompleteData = [];
                if (tblMaster != undefined) {
                    resultCompleteData = await models[tblMaster].findAll({
                        attributes: [
                            [sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"],
                        ],
                        where: {
                            'BFGCode': CubicInfo.Sys_BFGCode,
                            'ProductName': CubicInfo.Sys_ProductName,
                            'PVersion': CubicInfo.Sys_PVersion,
                            'Version': CubicInfo.Sys_Version,
                            'BatchNo': CubicInfo.Sys_Batch,
                            'CubicleType': CubicInfo.Sys_CubType,
                            'ReportType': CubicInfo.Sys_RptType
                        }
                    })

                    if (resultCompleteData[0].RepSerNo == null) {
                        if (CubicInfo.Sys_Area == "Coating" || (CubicInfo.Sys_Area == "IPQC" && CubicInfo.Sys_IPQCType == "Coating")) {
                            showLot = true;
                        }
                    }
                }

                var lastInsertedSide;
                if (menuName != GLOBAL_NOMENCLATURE.FriabilityMenu && menuName != GLOBAL_NOMENCLATURE.DT && StrRotaryType == "Double") {
                    if (resultCompleteData[0].RepSerNo == null) {
                        side = ["LHS"];
                    } else {
                        if (menuName == GLOBAL_NOMENCLATURE.Hardness) {
                            let masterSide = await models[tblMaster].findAll({ attributes: ['Side'], where: { RepSerNo: resultCompleteData[0].RepSerNo } });
                            if (masterSide) lastInsertedSide = masterSide;
                        } else {
                            let maxRecNo = await models[tblDetails].max('RecNo', { where: { RepSerno: resultCompleteData[0].RepSerNo } });
                            if (maxRecNo) {
                                lastInsertedSide = await models[tblDetails].findOne({
                                    attributes: ['Side'],
                                    where: { RecNo: maxRecNo }
                                });
                            }
                        }
                        if (lastInsertedSide) {
                            var arrSide = ['LHS', 'RHS'];
                            if (menuName == GLOBAL_NOMENCLATURE.Hardness) {
                                side = arrSide.filter(e => e != lastInsertedSide[0].Side);
                            } else {
                                side = arrSide.filter(e => e != lastInsertedSide.Side);
                            }
                        }
                    }
                }
                else {
                    side = (StrRotaryType == "Double") ? ['LHS', 'RHS'] : "NA";
                }

                // var side = StrRotaryType == "Double" ? ['LHS', 'RHS'] : "NA";

                obj1 = {
                    "menuName": menuName.replace(/\_/g, " "),
                    "noOfSample": productDetail.noOfSamples == undefined ? undefined : productDetail.noOfSamples.toString(),
                    "Rotary": StrRotaryType,
                    "ProductId": StrBFGCode,
                    "ProductName": productName,
                    "Batch": StrBatch,
                    "Nominal": productDetail.nominal == null ? null : productDetail.nominal.toString().includes(':') ? productDetail.nominal : Number(productDetail.nominal).toFixed(productDetail.dp).concat(` ${productDetail.unit}`),
                    "Dp": productDetail.dp,
                    "T1Neg": T1_Neg_ActualValue != undefined ? T1_Neg_ActualValue.trim() : Number(productDetail.T1Neg).toFixed(productDetail.dp).concat(` ${productDetail.unit}`).trim(),
                    "T1Pos": T1_Pos_ActualValue != undefined ? T1_Pos_ActualValue.trim() : Number(productDetail.T1Pos).toFixed(productDetail.dp).concat(` ${productDetail.unit}`).trim(),
                    "T2Neg": T2_Neg_ActualValue != undefined ? T2_Neg_ActualValue.trim() : productDetail.T2Neg == undefined ? undefined : Number(productDetail.T2Neg).toFixed(productDetail.dp).concat(` ${productDetail.unit}`).trim(),
                    "T2Pos": T2_Pos_ActualValue != undefined ? T2_Pos_ActualValue.trim() : productDetail.T2Pos == undefined ? undefined : Number(productDetail.T2Pos).toFixed(productDetail.dp).concat(` ${productDetail.unit}`).trim(),
                    "AirVibrationLimit": "0.014",
                    "showLot": showLot
                }


                // obj1 = {
                //     "menuName": menuName.replace(/\_/g, " "),
                //     "noOfSample": productDetail.noOfSamples == undefined ? undefined : productDetail.noOfSamples.toString(),
                //     "Rotary": StrRotaryType,
                //     "ProductId": StrBFGCode,
                //     "ProductName": productName,
                //     "Batch": StrBatch,
                //     "Nominal": productDetail.nominal == null ? null : productDetail.nominal.toString().includes(':') ? productDetail.nominal : Number(productDetail.nominal).toFixed(productDetail.dp).concat(` ${productDetail.unit}`),
                //     "Dp": productDetail.dp,
                //     "T1Neg": T1_Neg_ActualValue != undefined ? T1_Neg_ActualValue.trim() : Number(productDetail.T1Neg).toFixed(productDetail.dp).concat(` ${productDetail.unit}`).trim(),
                //     "T1Pos": T1_Pos_ActualValue != undefined ? T1_Pos_ActualValue.trim() : Number(productDetail.T1Pos).toFixed(productDetail.dp).concat(` ${productDetail.unit}`).trim(),
                //     "T2Neg": T2_Neg_ActualValue != undefined ? T2_Neg_ActualValue.trim() : productDetail.T2Neg == undefined ? undefined : Number(productDetail.T2Neg).toFixed(productDetail.dp).concat(` ${productDetail.unit}`).trim(),
                //     "T2Pos": T2_Pos_ActualValue != undefined ? T2_Pos_ActualValue.trim() : productDetail.T2Pos == undefined ? undefined : Number(productDetail.T2Pos).toFixed(productDetail.dp).concat(` ${productDetail.unit}`).trim(),
                //     "AirVibrationLimit": "0.014",
                //     "showLot": showLot
                // }


                if ((menuName.replace(/\_/g, " ") == (GLOBAL_NOMENCLATURE.granulationDry)) || (menuName.replace(/\_/g, " ") == (GLOBAL_NOMENCLATURE.granulationLub)) || (menuName.replace(/\_/g, " ") == (GLOBAL_NOMENCLATURE.lay1Dry)) || (menuName.replace(/\_/g, " ") == (GLOBAL_NOMENCLATURE.lay1Lub)) ||
                    (menuName.replace(/\_/g, " ") == (GLOBAL_NOMENCLATURE.LODMenu)) || (menuName.replace(/\_/g, " ") == (GLOBAL_NOMENCLATURE.LODLayer1Menu)) || (menuName.replace(/\_/g, " ") == (GLOBAL_NOMENCLATURE.LODLayer2Menu))
                ) {
                    // obj1['T1Neg'] = Number(obj1.T1Neg).toFixed(2), //for granulation 2 decimal
                    // obj1['T1Pos'] = Number(obj1.T1Pos).toFixed(2)
                    obj1['T1Neg'] = obj1.T1Neg != 'NaN' ? Number(obj1.T1Neg).toFixed(2) : "NA",
                        obj1['T1Pos'] = obj1.T1Pos != 'NaN' ? Number(obj1.T1Pos).toFixed(2) : "NA"

                }

                if ((menuName.replace(/\_/g, " ") == (GLOBAL_NOMENCLATURE.perFineMenu)) || ((menuName.replace(/\_/g, " ") == GLOBAL_NOMENCLATURE.perFineLayer1Menu) || ((menuName.replace(/\_/g, " ") == GLOBAL_NOMENCLATURE.perFineLayer2Menu)))
                ) {
                    obj1['noOfSample'] = 2;
                    obj1['min'] = (((productDetail.Below60_Min) == "NA") || (Number(productDetail.Below60_Min) == 0)) ? 'NA' : Number(productDetail.Below60_Min).toFixed(2);
                    obj1['max'] = (((productDetail.Below60_Max) == "NA") || (Number(productDetail.Below60_Max) == 0)) ? 'NA' : Number(productDetail.Below60_Max).toFixed(2);
                }

                if ((menuName.replace(/\_/g, " ") == (GLOBAL_NOMENCLATURE.PSDMenu) || menuName.replace(/\_/g, " ") == GLOBAL_NOMENCLATURE.PSDLayer1Menu || menuName.replace(/\_/g, " ") == GLOBAL_NOMENCLATURE.PSDLayer2Menu)
                ) {
                    obj1['noOfSample'] = 7;
                    obj1['min'] = (((productDetail.Below60_Min) == "NA") || (Number(productDetail.Below60_Min) == 0)) ? 'NA' : Number(productDetail.Below60_Min).toFixed(2);
                    obj1['max'] = (((productDetail.Below60_Max) == "NA") || (Number(productDetail.Below60_Max) == 0)) ? 'NA' : Number(productDetail.Below60_Max).toFixed(2);
                }

                if ((menuName.replace(/\_/g, " ") == (GLOBAL_NOMENCLATURE.TabletTesterMenu || GLOBAL_NOMENCLATURE.HardnessMenu))) {
                    const HardnessType = await this.getDetailOfBulkInstrumentModel(instrumentId);
                    obj1['type'] = HardnessType.Eqp_HT_Type;
                }

                // if ((menuName.replace(/\_/g, " ") == GLOBAL_NOMENCLATURE.FriabilityMenu &&
                //     (serverConfig.friabilityType == 'OB' || serverConfig.friabilityType == 'BFBO' ||
                //         serverConfig.friabilityType == 'BFBT'))) {
                //     obj1['type'] = serverConfig.friabilityType;
                //     let retuRes = await this.checkFriabilityStatus(strHmi);
                //     var respSerNo = retuRes.sqNo;
                //     var selectObj = await models.tbl_tab_friability.findAll({
                //         where: {
                //             RepSerNo: respSerNo
                //         }
                //     })
                //     // {
                //     //     str_tableName: 'tbl_tab_friability',
                //     //     data: '*',
                //     //     condition: [
                //     //         { str_colName: 'RepSerNo', value: respSerNo },
                //     //     ]
                //     // }
                //     let friabilityInfo = [selectObj];
                //     //console.log(retuRes);
                //     if (serverConfig.friabilityType == 'BFBT' || serverConfig.friabilityType == 'BFBO' || serverConfig.friabilityType == 'OB') {
                //         if (StrRotaryType == "Double") {
                //             if (retuRes.status == 'after') {
                //                 obj1['Before_Drum1'] = friabilityInfo[0][0].LWtBeforeTest;
                //                 obj1['Before_Drum2'] = friabilityInfo[0][0].RWtBeforeTest;
                //             }

                //             //send before wt of D1 & D2 from db
                //         } else {
                //             if (retuRes.status == 'after') {
                //                 obj1['Before_Drum1'] = friabilityInfo[0][0].NWtBeforeTest;
                //             }
                //             //here we will send only be before wt of D1 
                //         }
                //     }

                // }

                if ((menuName.replace(/\_/g, " ") == GLOBAL_NOMENCLATURE.FriabilatorMenu)
                ) {
                    obj1['type'] = serverConfig.friabilityType;
                    let unit = obj1.T1Pos.split(' ')[1]
                    obj1.SetRpm = obj1.T1Pos.replace(` ${unit}`, '')
                    obj1.SetCount = obj1.T1Neg.replace(` ${unit}`, '')
                    obj1.NMT = obj1.Nominal.replace(` ${unit}`, '')
                    delete obj1.Nominal;
                    delete obj1.T1Neg;
                    delete obj1.T1Pos;
                    delete obj1.T2Neg;
                    delete obj1.T2Pos;
                }

                if ((menuName.replace(/\_/g, " ") == GLOBAL_NOMENCLATURE.FriabilityMenu)
                ) {
                    obj1["SetRpm"] = Number(obj1.T1Pos.split(" ")[0])
                    obj1["SetCount"] = Number(obj1.T1Neg.split(" ")[0])
                    obj1.NMT = Number(obj1.Nominal.split(' ')[0]) //obj1.Nominal.replace(` ${unit}`, ' %')
                    delete obj1.Nominal;
                    delete obj1.T1Neg;
                    delete obj1.T1Pos;
                    delete obj1.T2Neg;
                    delete obj1.T2Pos;
                }

                if ((menuName.replace(/\_/g, " ") == (GLOBAL_NOMENCLATURE.HardnessMenu))) {
                    obj1['column'] = productDetail.column;
                    obj1['columnDetail'] = productDetail.columnDetail;
                }

                if (!(menuName.replace(/\_/g, " ") == GLOBAL_NOMENCLATURE.DTMenu &&
                    menuName.replace(/\_/g, " ") == GLOBAL_NOMENCLATURE.DTLayer1Menu &&
                    menuName.replace(/\_/g, " ") == GLOBAL_NOMENCLATURE.DTLayer2Menu)) {
                    obj1['editableSide'] = editableSide;
                    obj1['editableSampleNo'] = editableSampleNo;
                    obj1['Side'] = StrRotaryType == "Single" ? "NA" : side;

                }

                if ((menuName.replace(/\_/g, " ") == GLOBAL_NOMENCLATURE.DTMenu) ||
                    menuName.replace(/\_/g, " ") == GLOBAL_NOMENCLATURE.DTLayer1Menu ||
                    menuName.replace(/\_/g, " ") == GLOBAL_NOMENCLATURE.DTLayer2Menu) {
                    obj1['editableSide'] = false;
                    obj1['editableSampleNo'] = false;
                    obj1['Side'] = StrRotaryType == "Single" ? "NA" : side;
                    obj1['Jar'] = StrRotaryType == "Double" ? ["JarA&B"] : modelDetails;
                }
                if ((menuName.replace(/\_/g, " ") == GLOBAL_NOMENCLATURE.Differential)) {
                    obj1['column'] = productDetail.column;;
                    obj1['columnDetail'] = productDetail.columnDetail;
                }

                if (menuName.replace(/\_/g, " ") == GLOBAL_NOMENCLATURE.TDMenu ||
                    menuName.replace(/\_/g, " ") == GLOBAL_NOMENCLATURE.TDLayer1Menu ||
                    menuName.replace(/\_/g, " ") == GLOBAL_NOMENCLATURE.TDLayer2Menu
                ) {

                    let t1PosTd = ((Number(objSelMenu.selectedProductDetail.TapDensity_Upp) == 99999) || (Number(objSelMenu.selectedProductDetail.TapDensity_Upp) == 0)) ? "NA" : Number(objSelMenu.selectedProductDetail.TapDensity_Upp).toFixed(objSelMenu.selectedProductDetail.dp)
                    let t1NegTd = ((Number(objSelMenu.selectedProductDetail.TapDensity_Low) == 99999) || (Number(objSelMenu.selectedProductDetail.TapDensity_Low) == 0)) ? "NA" : Number(objSelMenu.selectedProductDetail.TapDensity_Low).toFixed(objSelMenu.selectedProductDetail.dp)
                    let t1PosBulk = ((Number(objSelMenu.selectedProductDetail.BulkDensity_Upp) == 99999) || (Number(objSelMenu.selectedProductDetail.BulkDensity_Upp) == 0)) ? "NA" : Number(objSelMenu.selectedProductDetail.BulkDensity_Upp).toFixed(objSelMenu.selectedProductDetail.dp)
                    let t1NegBulk = ((Number(objSelMenu.selectedProductDetail.BulkDensity_Low) == 99999) || (Number(objSelMenu.selectedProductDetail.BulkDensity_Low) == 0)) ? "NA" : Number(objSelMenu.selectedProductDetail.BulkDensity_Low).toFixed(objSelMenu.selectedProductDetail.dp)

                    obj1["TapDensity_Upp"] = t1PosTd
                    obj1["TapDensity_Low"] = t1NegTd
                    obj1["BulkDensity_Upp"] = t1PosBulk
                    obj1["BulkDensity_Low"] = t1NegBulk
                }
                // }else if (menuName.replace(/\_/g, " ") == GLOBAL_NOMENCLATURE.TDLayer1Menu){
                //     obj1["TapDensity_Upp"] = objSelMenu.selectedProductDetail.Param5_Upp
                //     obj1["TapDensity_Low"] = objSelMenu.selectedProductDetail.Param5_Low
                //     obj1["BulkDensity_Upp"] = objSelMenu.selectedProductDetail.Param6_Upp
                //     obj1["BulkDensity_Low"] = objSelMenu.selectedProductDetail.Param6_Low
                // }else if (menuName.replace(/\_/g, " ") == GLOBAL_NOMENCLATURE.TDLayer2Menu){
                //     obj1["TapDensity_Upp"] = objSelMenu.selectedProductDetail.Param8_Upp
                //     obj1["TapDensity_Low"] = objSelMenu.selectedProductDetail.Param8_Low
                //     obj1["BulkDensity_Upp"] = objSelMenu.selectedProductDetail.Param9_Upp
                //     obj1["BulkDensity_Low"] = objSelMenu.selectedProductDetail.Param9_Low
                // }

                if (menuName === "Hardness") {
                    obj1["T1Neg"] = (productDetail.T1Neg != "NA") ? obj1["T1Neg"] : "NA"
                    obj1["T1Pos"] = (productDetail.T1Pos != "NA") ? obj1["T1Pos"] : "NA"
                }

                //check for incomplete report remark
                let reportPendingStatus = await objPreCheck.checkReportRemarkPending(strIdsNo)
                if (reportPendingStatus != false) {
                    return Object.assign(resObj, {
                        status: "fail",
                        message: `Incomplete Report Remark is Pending for Test ${reportPendingStatus.menuName}.Unable to Continue operation`
                    })
                } else {
                    return Object.assign(resObj, {
                        status: "success",
                        result: obj1
                    })
                }
            }
        } catch (error) {
            throw new Error(error)
        }
    }

    /**
     * @description:function will give jars or basket according to model
     * 
     */
    async getDetailOfBulkInstrumentModel(instrumentId) {
        try {
            const obj = await models.tbl_otherequipment.findAll({
                where: {
                    Eqp_ID: instrumentId
                }
            })
            let res = [obj];
            if (res[0].length <= 0) {
                return undefined
            }
            return res[0][0];
        } catch (error) {
            throw new Error(error)
        }
    }

    async checkFriabilityStatus(IdsNo) {
        var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == IdsNo);
        var selectedIds;
        var returnResult = {};
        if (IPQCObject != undefined) {
            selectedIds = IPQCObject.selectedIds;
        } else {
            selectedIds = IdsNo;
        }
        var tempCubic = globalData.arrIdsInfo.find(k => k.Hmi == selectedIds).cubicalData;//globalData.arrIdsInfo.find(k => k.idsNo == selectedIds).cubicalData;
        const checkData = await models.tbl_tab_friability.findAll({
            attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'SeqNo']],
            where: {
                BFGCode: tempCubic.Sys_BFGCode,
                ProductName: tempCubic.Sys_ProductName,
                PVersion: tempCubic.Sys_PVersion,
                Version: tempCubic.Sys_Version,
                BatchNo: tempCubic.Sys_Batch,
                IdsNo: selectedIds,
            }
        })
        // {
        //     str_tableName: 'tbl_tab_friability',
        //     data: 'MAX(RepSerNo) AS SeqNo',
        //     condition: [
        //         { str_colName: 'BFGCode', value: tempCubic.Sys_BFGCode, comp: 'eq' },
        //         { str_colName: 'ProductName', value: tempCubic.Sys_ProductName, comp: 'eq' },
        //         { str_colName: 'PVersion', value: tempCubic.Sys_PVersion, comp: 'eq' },
        //         { str_colName: 'Version', value: tempCubic.Sys_Version, comp: 'eq' },
        //         { str_colName: 'BatchNo', value: tempCubic.Sys_Batch, comp: 'eq' },
        //         { str_colName: 'IdsNo', value: selectedIds, comp: 'eq' },
        //     ]
        // }
        var checkFlag = 0;
        var chkResult = [checkData];
        var result = [];
        if (chkResult[0][0].SeqNo == null) {
            checkFlag = 0;
        } else {
            checkFlag = 1;
        }
        if (checkFlag == 1) {
            var fraibData = await models.tbl_tab_friability.findAll({
                where: {
                    RepSerNo: chkResult[0][0].SeqNo
                }
            })
            //  {
            //     str_tableName: 'tbl_tab_friability',
            //     data: '*',
            //     condition: [
            //         { str_colName: 'RepSerNo', value: chkResult[0][0].SeqNo, comp: 'eq' },
            //     ]
            // }
            result = [fraibData];
            result = result[0]
        }
        if (result.length > 0) {
            if (tempCubic.Sys_RotaryType == 'Double') {
                if (result[0].LWtBeforeTest != 0 && result[0].LWtAfterTest != 0
                    && result[0].RWtBeforeTest != 0 && result[0].RWtAfterTest != 0) {
                    Object.assign(returnResult, { status: 'before', sqNo: result[0].RepSerNo })

                } else if (result[0].LWtBeforeTest != 0 && result[0].LWtAfterTest == 0
                    && result[0].RWtBeforeTest == 0 && result[0].RWtAfterTest == 0) {
                    Object.assign(returnResult, { status: 'before', sqNo: result[0].RepSerNo })

                } else if (result[0].LWtBeforeTest != 0 && result[0].LWtAfterTest != 0
                    && result[0].RWtBeforeTest != 0 && result[0].RWtAfterTest == 0) {
                    Object.assign(returnResult, { status: 'after', sqNo: result[0].RepSerNo })

                }
                else if (result[0].LWtBeforeTest != 0 && result[0].LWtAfterTest == 0
                    && result[0].RWtBeforeTest != 0 && result[0].RWtAfterTest == 0) {
                    Object.assign(returnResult, { status: 'after', sqNo: result[0].RepSerNo })


                } else if (result[0].LWtBeforeTest == 0 && result[0].LWtAfterTest == 0
                    && result[0].RWtBeforeTest == 0 && result[0].RWtAfterTest == 0) {
                    Object.assign(returnResult, { status: 'before', sqNo: result[0].RepSerNo })

                }
            } else {
                if (result[0].NWtBeforeTest != 0 && result[0].NWtAfterTest != 0) {
                    Object.assign(returnResult, { status: 'before', sqNo: result[0].RepSerNo })

                } else if (result[0].NWtBeforeTest != 0 && result[0].NWtAfterTest == 0) {
                    Object.assign(returnResult, { status: 'after', sqNo: result[0].RepSerNo })

                } else if (result[0].NWtBeforeTest == 0 && result[0].NWtAfterTest == 0) {
                    Object.assign(returnResult, { status: 'before', sqNo: result[0].RepSerNo })

                }
            }
        } else {
            Object.assign(returnResult, { status: 'before', sqNo: 0 })

        }
        return returnResult;
    }

    DateFormat(date, time) {
        var days = date.getDate();
        var year = date.getFullYear();
        var month = (date.getMonth() + 1);

        // minutes = minutes < 10 ? '0' + minutes : minutes;
        var strTime = month + '/' + days + '/' + year + ' ' + time;
        //var strTime = hours + ':' + minutes;
        return strTime;
    }
    async CheckHardnessModel(idsNo) {
        try {
            var cubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == idsNo).cubicalData;
            var hardnessId = cubicInfo.Sys_HardID;
            var selectOtherEquip = await models.tbl_otherequipment.findAll({
                where: {
                    Eqp_ID: hardnessId
                }
            })
            var result = [selectOtherEquip];
            return result[0][0];
        } catch (error) {
            throw new Error(error);
        }
    }

    async lockedWeighingStatus(cubicalNo, BatchNo, CubType) {
        try {
            await models.tbl_system_weighingstatus.update({
                Status: 1,
                BatchNo: BatchNo,
                CubType: CubType
            }, {
                where: {
                    CubicleNo: cubicalNo

                }
            })
        } catch (error) {
            console.log(error)
        }
    }

    // *****************************************************************************************//
    // FOR GROUP ALERT 
    // *****************************************************************************************//

    async prepareAlertObject() {
        const objTime = await this.getBatchTime(); //All Batches data fetch
        const objAlertInfo = await this.getAlertInfo();//alert info fetch
        const alertObject = await this.AlertObject(objTime, objAlertInfo);//all alert array initialize
    }

    async getBatchTime() {
        try {
            let arrBatches = await models.tbl_batches.findAll({
                where: {
                    [Op.or]: [{ Status: "S" }, { Status: "R" }, { Status: "P" }]
                }
            });
            return arrBatches;

        } catch (error) {
            throw new Error(error)
        }
    }

    async getAlertInfo() {
        try {
            let arrAlert = await models.tbl_alert_param_duration.findAll();
            return arrAlert;

        } catch (error) {
            throw new Error(error)
        }
    }

    async AlertObject(objTime, objAlertInfo) {


        for (const value of objTime) {
            if (value.tm1 != null && value.tm1 != undefined) {
                const alertObject = {
                    intCubicleNo: "",
                    strBatch: "",
                    intGroupParam: "",
                    AlertTime: "",
                    IDSNO: "",
                    AlertDate: ""
                }
                alertObject.intCubicleNo = value.CubicNo;
                // alertObject.strBatch = value.Batch;
                // alertObject.AlertTime = value.tm;
                alertObject.AlertDate = value.dt1;

                // if (value.tm1.split(":")[0].length == 1) {
                //     let updateTime = "0" + value.tm1
                //     alertObject.AlertTime = updateTime;
                // }
                // else {
                alertObject.AlertTime = moment(value.tm1, "HH:mm:ss").format("HH:mm:ss");
                // }

                var cubdata = await models.tbl_cubical.findAll()
                globalData.arrAlertInfo = cubdata;

                var AlertParam = objAlertInfo.filter(k => k.CubicNo == alertObject.intCubicleNo);
                var CubicParam = globalData.arrAlertInfo.filter(k => k.Sys_CubicNo == alertObject.intCubicleNo);
                alertObject.intGroupParam = AlertParam[0].Group;
                alertObject.IDSNO = CubicParam[0].Sys_IDSNo;
                alertObject.strBatch = CubicParam[0].Sys_Batch;

                // here we will check if product set to cubicle has group weighment or not
                if (CubicParam != undefined) {
                    if (CubicParam[0].Sys_CubType != 'Granulation') {
                        const Product = ({
                            ProductId: CubicParam[0].Sys_BFGCode,
                            ProductName: CubicParam[0].Sys_ProductName,
                            ProductVersion: CubicParam[0].Sys_PVersion,
                            Version: CubicParam[0].Sys_Version,
                        })
                        //check in product master wheather group alowed or not
                        let tableName;
                        if (CubicParam[0].Sys_CubType == 'Compression') {
                            tableName = 'tbl_product_tablet';
                        } else if (CubicParam[0].Sys_CubType == 'Coating') {
                            tableName = 'tbl_product_tablet';
                        } else if (CubicParam[0].Sys_CubType == 'Capsule Filling') {
                            tableName = 'tbl_product_capsule';
                        }
                        if (tableName != undefined) {
                            let response = await models[tableName].findAll({
                                where: {
                                    ProductId: Product.ProductId,
                                    ProductName: Product.ProductName,
                                    ProductVersion: Product.ProductVersion,
                                    Version: Product.Version
                                }
                            })
                            if (response.length > 0) {
                                if ((response[0].Param2_Nom != 99999 && AlertParam[0].Group != 0)) {
                                    globalData.alertArr.push(alertObject);
                                }
                            }
                        }
                    }
                }
            }
        }
        return 'Success'

    }

    async OnAppearance(value) {
        try {
            var get_Datails = await models.tbl_cubical.findAll({
                where: {
                    Sys_IDSNo: value.Hmi
                }
            });
            let rotary = get_Datails[0].Sys_RotaryType;
            let side = ""
            side = rotary === 'Single' ? side = "NA" : side = ["LHS", "RHS"];

            let res = await models.tbl_product_master.findAll({
                where: {
                    ProductId: get_Datails[0].Sys_BFGCode,
                    ProductName: get_Datails[0].Sys_ProductName,
                    ProductVersion: get_Datails[0].Sys_PVersion,
                    Version: get_Datails[0].Sys_Version,
                }
            });
            var Appearance_Desc = get_Datails[0].Sys_Area == 'Coating' ? res[0].Appearance_Desc_Coat : res[0].Appearance_Desc;
            let machineSpeed = get_Datails[0].Sys_MachineSpeed_Min + "-" + get_Datails[0].Sys_MachineSpeed_Max;
            let obj = {
                ProductId: get_Datails[0].Sys_BFGCode,
                ProductName: get_Datails[0].Sys_ProductName,
                Batch: get_Datails[0].Sys_Batch,
                Rotary: rotary,
                Comp_MC_Speed: machineSpeed,
                Appearance_Desc: Appearance_Desc,
                Upper_Surface: res[0].Upper_Surface,
                Lower_Surface: res[0].Lower_Surface,
                Side: side,
                Actual_Speed: "",
                Remark: "",
            }
            return Object.assign({
                status: "success",
                result: obj
            })

        } catch (error) {
            throw new Error(error);
        }
    }

    async testAppearance(value) {
        try {
            let get_Datails = await models.tbl_cubical.findAll({
                where: {
                    Sys_IDSNo: value.Hmi
                }
            });

            let Speed = get_Datails[0].Sys_MachineSpeed_Min + "-" + get_Datails[0].Sys_MachineSpeed_Max;

            let res = await models.tbl_product_master.findAll({
                where: {
                    ProductId: get_Datails[0].Sys_BFGCode,
                    ProductName: get_Datails[0].Sys_ProductName,
                    ProductVersion: get_Datails[0].Sys_PVersion,
                    Version: get_Datails[0].Sys_Version,
                }
            })

            let getArea = (get_Datails[0].Sys_Area == "IPQC" || get_Datails[0].Area == "IPQC") ? get_Datails[0].Sys_IPQCType : get_Datails[0].Sys_Area;

            let checkExist = await models.tbl_tab_masterapp.findAll({
                where: {
                    BFGCode: get_Datails[0].Sys_BFGCode,
                    ProductName: get_Datails[0].Sys_ProductName,
                    ProductType: res[0].ProductType,
                    BatchNo: get_Datails[0].Sys_Batch,
                    ReportType: get_Datails[0].Sys_RptType
                    // Side: value.Side,
                }
            })
            let repNo;
            if (checkExist.length >= 1) {
                repNo = checkExist[0].RepSerNo;
            }
            var Appearance_Desc = get_Datails[0].Sys_Area == 'Coating' ? res[0].Appearance_Desc_Coat : res[0].Appearance_Desc;
            if (checkExist.length < 1 || checkExist == undefined) {
                let masterApp = await models.tbl_tab_masterapp.create({
                    Area: get_Datails[0].Sys_Area,
                    Department: get_Datails[0].Sys_dept,
                    CubicalNo: get_Datails[0].Sys_CubicNo,
                    CubicleName: get_Datails[0].Sys_CubicName,
                    CubicleType: get_Datails[0].Sys_CubType,
                    IPQCType: get_Datails[0].Sys_IPQCType,
                    MachineCode: get_Datails[0].Sys_MachineCode,
                    BFGCode: get_Datails[0].Sys_BFGCode,
                    ProductName: get_Datails[0].Sys_ProductName,
                    ProductType: res[0].ProductType,
                    BatchNo: get_Datails[0].Sys_Batch,
                    PVersion: get_Datails[0].Sys_PVersion,
                    Version: get_Datails[0].Sys_Version,
                    BatchSize: get_Datails[0].Sys_BatchSize,
                    BMRNo: get_Datails[0].Sys_BMRNo,
                    Idsno: value.Hmi,
                    Stage: get_Datails[0].Sys_Stage,
                    Unit: get_Datails[0].Sys_BatchSizeUnit,
                    Lot: get_Datails[0].Sys_LotNo,
                    BalanceId: get_Datails[0].Sys_BalID,
                    VernierId: get_Datails[0].Sys_VernierID,
                    FriabilityId: get_Datails[0].Sys_FriabID,
                    HardnessId: get_Datails[0].Sys_HardID,
                    Inprocess: get_Datails[0].Sys_CalibInProcess,
                    UserId: value.userId,
                    UserName: value.userName,
                    Comp_MC_Speed: Speed,
                    Appearance_Desc: Appearance_Desc,
                    Upper_Surface: res[0].Upper_Surface,
                    Lower_Surface: res[0].Lower_Surface,
                    WgmtModeNo: 14,
                    Side: value.Side,
                    Layer: 'NA',
                    ReportType: get_Datails[0].Sys_RptType,
                    PrDate: moment().format('YYYY-MM-DD'),
                    PrEndDate: moment().format('YYYY-MM-DD'),
                    PrEndTime: moment().format('HH:mm:ss'),
                    PrTime: moment().format('HH:mm:ss'),

                });

                let masterRes = await models.tbl_tab_masterapp.findAll({
                    attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
                    where: {
                        Idsno: value.Hmi,
                        BatchNo: get_Datails[0].Sys_Batch,
                        BFGCode: get_Datails[0].Sys_BFGCode,
                        ProductName: get_Datails[0].Sys_ProductName,
                    }
                });
                repNo = masterRes[0].RepSerNo;
            }

            var testResult = value.Remark === "OK" ? "Complies" : "Not Complies";
            let getRecSeqNo = await models.tbl_tab_detailapp.findAll({
                attributes: [[sequelize.fn('max', sequelize.col('RecSeqNo')), 'RecSeqNo']],
                where: {
                    RepSerNo: repNo,
                }
            })
            var RecSeqNo = getRecSeqNo[0].RecSeqNo == null ? 1 : getRecSeqNo[0].RecSeqNo + 1;
            let result = await models.tbl_tab_detailapp.create({
                RepSerNo: repNo,
                RecSeqNo: RecSeqNo,
                UserId: value.userId,
                UserName: value.userName,
                BFGCode: value.ProductId,
                ProductName: value.ProductName,
                Version: get_Datails[0].Sys_Version,
                PVersion: get_Datails[0].Sys_PVersion,
                BatchNo: value.Batch,
                Remark: value.Remark,
                Side: value.Side,
                TestResult: testResult,
                PrDate: moment().format('YYYY-MM-DD'),
                PrEndDate: moment().format('YYYY-MM-DD'),
                PrEndTime: moment().format('HH:mm:ss'),
                PrTime: moment().format('HH:mm:ss'),

            });
            // console.log(getArea);
            let getRecNo = await models.tbl_tab_detailapp.findAll({
                attributes: [[sequelize.fn('max', sequelize.col('RecNo')), 'RecNo']],
                where: {
                    RepSerNo: repNo,
                }
            })
            console.log(getArea)
            if (getArea === "Compression") {
                await models.tbl_tab_detailapp.update({
                    Actual_Speed: Number(value.Actual_Speed),
                }, { where: { RecNo: getRecNo[0].RecNo } });
            }
            else {
                if (checkExist.length < 1 || checkExist == undefined) {
                    await models.tbl_tab_masterapp.update({
                        Lot: value.lotno,
                    }, { where: { RepSerNo: repNo } });
                }
            }

            return Object.assign({
                status: 'success',
                message: 'Appearance Test Completed'
            })
        } catch (error) {
            throw new Error(error);
        }
    }
    async update_ipqc_instrument(value) {
        try {


            var getdaqdetails = value
            let i = 1;
            for (let obj in getdaqdetails[0]) {
                if (getdaqdetails[0][`Sys_Port${i}`] == undefined ||
                    getdaqdetails[0][`Sys_Port${i}`] == "None" ||
                    getdaqdetails[0][`Sys_Port${i}`] == "NULL" ||
                    getdaqdetails[0][`Sys_Port${i}`] == null) {
                    i++;
                    continue;
                }
                else {
                    let type = getdaqdetails[0][`Sys_Port${i}`];
                    if (getdaqdetails[0][`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Balance) {
                        if (getdaqdetails[0][`Sys_BalID`] != 'None') {
                            value[0].Sys_BalID = getdaqdetails[0][`Sys_BalID`]



                        }
                    }
                    else if (getdaqdetails[0][`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.IPCBalance) {
                        // InstrumentType = GLOBAL_NOMENCLATURE.Balance;
                        if (getdaqdetails[0][`Sys_BinBalID`] != 'None') {
                            value[0].Sys_BinBalID = getdaqdetails[0][`Sys_BinBalID`]
                        }
                    }
                    else if (getdaqdetails[0][`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Vernier) {
                        if (getdaqdetails[0][`Sys_VernierID`] != 'None') {
                            value[0].Sys_VernierID = getdaqdetails[0][`Sys_VernierID`]
                        }
                    }
                    else if (getdaqdetails[0][`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Hardness ||
                        getdaqdetails[0][`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.TabletTester
                    ) {
                        if (getdaqdetails[0][`Sys_HardID`] != 'None') {
                            value[0].Sys_HardID = getdaqdetails[0][`Sys_HardID`]

                        }
                    }
                    else if (getdaqdetails[0][`Sys_Port${i}`] == "Friabilator" ||
                        getdaqdetails[0][`Sys_Port${i}`] == "Friability"
                    ) {

                        let type = "Friability";
                        if (getdaqdetails[0][`Sys_Port${i}`] == "Friabilator") {
                            type = "Friabilator"
                        }
                        if (getdaqdetails[0][`Sys_FriabID`] != 'None') {
                            value[0].Sys_FriabID = getdaqdetails[0][`Sys_FriabID`]

                        }
                    }
                    else if (getdaqdetails[0][`Sys_Port${i}`] == "Disintegration Tester") {
                        if (getdaqdetails[0][`Sys_DTID`] != 'None') {
                            value[0].Sys_DTID = getdaqdetails[0][`Sys_DTID`]

                        }
                    }
                    else if ((getdaqdetails[0][`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.MoistureAnalyzer || getdaqdetails[0][`Sys_Port${i}`] == "LOD")) {
                        if (getdaqdetails[0][`Sys_MoistID`] != 'None') {
                            value[0].Sys_MoistID = getdaqdetails[0]['Sys_MoistID']

                        }
                    }
                    else if (getdaqdetails[0][`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.TappedDensity) {
                        if (getdaqdetails[0][`Sys_TapDensityID`] != 'None') {
                            value[0].Sys_TapDensityID = getdaqdetails[0]['Sys_TapDensityID']

                        }
                    }
                    i++;
                }
            }
            return value[0]
        } catch (error) {

        }
    }
    // async VerifyReport(menu, currentCubicle, productType, strHmi) {
    //     try {
    //         var tablename
    //         switch (menu) {
    //             case GLOBAL_NOMENCLATURE.SealLengthMenu:
    //                 tablename = "tbl_cap_master5_incomplete"
    //                 console.log("Lock length menu");
    //                 break;
    //             case GLOBAL_NOMENCLATURE.Differential:
    //                 tablename = "tbl_cap_master3_incomplete"
    //                 console.log("Differential menu");
    //                 break;
    //             case GLOBAL_NOMENCLATURE.ThicknessMenu:
    //                 tablename = "tbl_tab_master3_incomplete"
    //                 console.log("Thickness menu");
    //                 break;
    //             case GLOBAL_NOMENCLATURE.BreadthMenu:
    //                 tablename = "tbl_tab_master4_incomplete"
    //                 console.log("Breadth menu");
    //                 break;
    //             case GLOBAL_NOMENCLATURE.LengthMenu:
    //                 tablename = "tbl_tab_master5_incomplete"
    //                 console.log("Length menu");
    //                 break;
    //             case GLOBAL_NOMENCLATURE.DiameterMenu:
    //                 tablename = "tbl_tab_master6_incomplete"
    //                 console.log("Diameter menu");
    //                 break;
    //             case GLOBAL_NOMENCLATURE.LODMenu:
    //                 tablename = "tbl_lodmaster"
    //                 console.log("LOD menu");
    //                 break;
    //             case GLOBAL_NOMENCLATURE.IndividualMenu:
    //                 if (productType == 1) {
    //                     tablename = "tbl_tab_master1_incomplete"
    //                 } else {
    //                     tablename = "tbl_cap_master1_incomplete"
    //                 }
    //                 console.log("Individual menu");
    //                 break;
    //             case GLOBAL_NOMENCLATURE.perFineMenu:
    //                 if (productType == 1) {
    //                     tablename = "tbl_tab_master17_incomplete";
    //                 } else {
    //                     tablename = "tbl_cap_master17_incomplete";
    //                 }
    //                 console.log("perFineMenu menu");
    //                 break;
    //             case GLOBAL_NOMENCLATURE.PSDMenu:
    //                 if (productType == 1) {
    //                     tablename = "tbl_tab_master18_incomplete";
    //                 } else {
    //                     tablename = "tbl_cap_master18_incomplete";
    //                 }
    //                 console.log("ParticalSizing menu");
    //                 break;
    //             case GLOBAL_NOMENCLATURE.Hardness:
    //                 tablename = "tbl_tab_masterhtd_incomplete";
    //                 console.log("Hardness menu");
    //                 break;
    //             default:
    //                 return false
    //         }
    //         var verifyrep = await models[tablename].findAll({
    //             // attributes: [[sequelize.fn('max', sequelize.col('MstSerNo')), 'RepSerNo']],
    //             where: {
    //                 IdsNo: strHmi,
    //                 BFGCode: currentCubicle.Sys_BFGCode,
    //                 ProductName: currentCubicle.Sys_ProductName,
    //                 BatchNo: currentCubicle.Sys_Batch,
    //                 ReportType: currentCubicle.Sys_RptType,
    //                 IPQCType: currentCubicle.Sys_IPQCType,
    //                 CheckedByID: { [Op.or]: ["NULL", null] },
    //                 CheckedByName: { [Op.or]: ["NULL", null] },
    //                 Inprocess: 0
    //             },

    //         })
    //         if ((verifyrep.length) > 0) {
    //             return true
    //         } else {
    //             return false
    //         }


    //     } catch (error) {
    //         throw new Error(error);
    //     }
    // }

    // async VerifyReport(menu, currentCubicle, productType, strHmi) {
    //     try {
    //         var tablename1;
    //         var tablename2;
    //         switch (menu) {
    //             case GLOBAL_NOMENCLATURE.SealLengthMenu:
    //                 tablename1 = "tbl_cap_master5_incomplete"
    //                 tablename2 = "tbl_cap_master5"
    //                 console.log("Lock length menu");
    //                 break;
    //             case GLOBAL_NOMENCLATURE.Differential:
    //                 tablename1 = "tbl_cap_master3_incomplete"
    //                 tablename2 = "tbl_cap_master3"
    //                 console.log("Differential menu");
    //                 break;
    //             case GLOBAL_NOMENCLATURE.ThicknessMenu:
    //                 tablename1 = "tbl_tab_master3_incomplete"
    //                 tablename2 = "tbl_tab_master3"
    //                 console.log("Thickness menu");
    //                 break;
    //             case GLOBAL_NOMENCLATURE.BreadthMenu:
    //                 tablename1 = "tbl_tab_master4_incomplete"
    //                 tablename2 = "tbl_tab_master4"
    //                 console.log("Breadth menu");
    //                 break;
    //             case GLOBAL_NOMENCLATURE.LengthMenu:
    //                 tablename1 = "tbl_tab_master5_incomplete"
    //                 tablename2 = "tbl_tab_master5"
    //                 console.log("Length menu");
    //                 break;
    //             case GLOBAL_NOMENCLATURE.DiameterMenu:
    //                 tablename1 = "tbl_tab_master6_incomplete"
    //                 tablename2 = "tbl_tab_master6"
    //                 console.log("Diameter menu");
    //                 break;
    //             case GLOBAL_NOMENCLATURE.LODMenu:
    //                 tablename1 = "tbl_lodmaster"
    //                 console.log("LOD menu");
    //                 break;
    //             case GLOBAL_NOMENCLATURE.IndividualMenu:
    //                 if (productType == 1) {
    //                     tablename1 = "tbl_tab_master1_incomplete"
    //                     tablename2 = "tbl_tab_master1"
    //                 } else {
    //                     tablename1 = "tbl_cap_master1_incomplete"
    //                     tablename2 = "tbl_cap_master1"
    //                 }
    //                 console.log("Individual menu");
    //                 break;
    //             case GLOBAL_NOMENCLATURE.perFineMenu:
    //                 if (productType == 1) {
    //                     tablename1 = "tbl_tab_master17_incomplete";
    //                     tablename2 = "tbl_tab_master17";
    //                 } else {
    //                     tablename1 = "tbl_cap_master17_incomplete";
    //                     tablename2 = "tbl_cap_master17";
    //                 }
    //                 console.log("perFineMenu menu");
    //                 break;
    //             case GLOBAL_NOMENCLATURE.PSDMenu:
    //                 if (productType == 1) {
    //                     tablename1 = "tbl_tab_master18_incomplete";
    //                     tablename2 = "tbl_tab_master18";
    //                 } else {
    //                     tablename1 = "tbl_cap_master18_incomplete";
    //                     tablename2 = "tbl_cap_master18";
    //                 }
    //                 console.log("ParticalSizing menu");
    //                 break;
    //             case GLOBAL_NOMENCLATURE.Hardness:
    //                 tablename1 = "tbl_tab_masterhtd_incomplete";
    //                 // tablename2 = "tbl_tab_masterhtd";
    //                 console.log("Hardness menu");
    //                 break;
    //             case GLOBAL_NOMENCLATURE.FriabilityMenu:
    //                 // tablename1 = "tbl_tab_masterhtd_incomplete";
    //                 tablename2 = "tbl_tab_friability";
    //                 console.log("friab menu");
    //                 break;
    //             default:
    //                 return false
    //         }

    //     if(tablename1 !== undefined){


    //         var verifyrep = await models[tablename1].findAll({
    //             // attributes: [[sequelize.fn('max', sequelize.col('MstSerNo')), 'RepSerNo']],
    //             where: {
    //                 IdsNo: strHmi,
    //                 BFGCode: currentCubicle.Sys_BFGCode,
    //                 ProductName: currentCubicle.Sys_ProductName,
    //                 BatchNo: currentCubicle.Sys_Batch,
    //                 ReportType: currentCubicle.Sys_RptType,
    //                 IPQCType: currentCubicle.Sys_IPQCType,
    //                 CheckedByID: { [Op.or]: ["NULL", null] },
    //                 CheckedByName: { [Op.or]: ["NULL", null] },
    //                 Inprocess: 0
    //             },

    //         })

    //          if ((verifyrep.length) > 0  ) {
    //             return true
    //         }
    //         else {
    //             return false
    //         }
    //     }
    //     else if(tablename2!== undefined){


    //         var verifyrep2 = await models[tablename2].findAll({
    //             // attributes: [[sequelize.fn('max', sequelize.col('MstSerNo')), 'RepSerNo']],
    //             where: {
    //                 IdsNo: strHmi,
    //                 BFGCode: currentCubicle.Sys_BFGCode,
    //                 ProductName: currentCubicle.Sys_ProductName,
    //                 BatchNo: currentCubicle.Sys_Batch,
    //                 ReportType: currentCubicle.Sys_RptType,
    //                 IPQCType: currentCubicle.Sys_IPQCType,
    //                 CheckedByID: { [Op.or]: ["NULL", null] },
    //                 CheckedByName: { [Op.or]: ["NULL", null] },
    //                 Inprocess: 0,
    //                 Remark : "Not Complies"
    //             },

    //         })

    //         if ((verifyrep2.length) > 0) {
    //             return true
    //         }
    //         else {
    //             return false
    //         }

    //     }


    //     } catch (error) {
    //         throw new Error(error);
    //     }
    // }


    async VerifyReport(menu, currentCubicle, productType, strHmi) {
        try {
            let tablename1;
            let tablename2;

            switch (menu) {
                case GLOBAL_NOMENCLATURE.SealLengthMenu:
                    tablename1 = "tbl_cap_master5_incomplete";
                    tablename2 = "tbl_cap_master5";
                    break;
                case GLOBAL_NOMENCLATURE.Differential:
                    tablename1 = "tbl_cap_master3_incomplete";
                    tablename2 = "tbl_cap_master3";
                    break;
                case GLOBAL_NOMENCLATURE.ThicknessMenu:
                    tablename1 = "tbl_tab_master3_incomplete";
                    tablename2 = "tbl_tab_master3";
                    break;
                case GLOBAL_NOMENCLATURE.BreadthMenu:
                    tablename1 = "tbl_tab_master4_incomplete";
                    tablename2 = "tbl_tab_master4";
                    break;
                case GLOBAL_NOMENCLATURE.LengthMenu:
                    tablename1 = "tbl_tab_master5_incomplete";
                    tablename2 = "tbl_tab_master5";
                    break;
                case GLOBAL_NOMENCLATURE.DiameterMenu:
                    tablename1 = "tbl_tab_master6_incomplete";
                    tablename2 = "tbl_tab_master6";
                    break;
                case GLOBAL_NOMENCLATURE.LODMenu:
                    tablename1 = "tbl_lodmaster";
                    break;
                case GLOBAL_NOMENCLATURE.IndividualMenu:
                    if (productType == 1) {
                        tablename1 = "tbl_tab_master1_incomplete";
                        tablename2 = "tbl_tab_master1";
                    } else {
                        tablename1 = "tbl_cap_master1_incomplete";
                        tablename2 = "tbl_cap_master1";
                    }
                    break;
                case GLOBAL_NOMENCLATURE.perFineMenu:
                    if (productType == 1) {
                        tablename1 = "tbl_tab_master17_incomplete";
                        tablename2 = "tbl_tab_master17";
                    } else {
                        tablename1 = "tbl_cap_master17_incomplete";
                        tablename2 = "tbl_cap_master17";
                    }
                    break;
                case GLOBAL_NOMENCLATURE.PSDMenu:
                    if (productType == 1) {
                        tablename1 = "tbl_tab_master18_incomplete";
                        tablename2 = "tbl_tab_master18";
                    } else {
                        tablename1 = "tbl_cap_master18_incomplete";
                        tablename2 = "tbl_cap_master18";
                    }
                    break;
                case GLOBAL_NOMENCLATURE.Hardness:
                    tablename1 = "tbl_tab_masterhtd_incomplete";
                    tablename2 = "tbl_tab_masterhtd";
                    break;
                case GLOBAL_NOMENCLATURE.FriabilityMenu:
                    tablename2 = "tbl_tab_friability";
                    break;
                case GLOBAL_NOMENCLATURE.DT:
                    if (productType == 1) {
                        tablename2 = "tbl_tab_master13";
                    } else {
                        tablename2 = "tbl_cap_master6";
                    }
                    break;
                case GLOBAL_NOMENCLATURE.TDMenu:
                    if (productType == 1) {
                        tablename2 = "tbl_tapdensity";
                    }
                    break;
                default:
                    return false;
            }

            const whereClause = {
                IdsNo: strHmi,
                BFGCode: currentCubicle.Sys_BFGCode,
                ProductName: currentCubicle.Sys_ProductName,
                BatchNo: currentCubicle.Sys_Batch,
                ReportType: currentCubicle.Sys_RptType,
                // IPQCType: currentCubicle.Sys_IPQCType,
                Area: currentCubicle.Sys_Area,
                CheckedByID: { [Op.or]: ["NULL", null] },
                CheckedByName: { [Op.or]: ["NULL", null] },
                Inprocess: 0
            };

            if (tablename1 !== undefined) {
                var verifyrep = await models[tablename1].findAll({ where: whereClause });
                if (verifyrep.length > 0) {
                    return true;
                }
            }

            if (tablename2 !== undefined) {
                var verifyrep2 = await models[tablename2].findAll({
                    where: {
                        ...whereClause,
                        Remark: "Not Complies",
                    }
                });
                if (verifyrep2.length > 0) {
                    return true;
                }
            }

            return false;

        } catch (error) {
            throw new Error(error);
        }
    }

}

module.exports = Menu 