const ClassweighmentData = require('../clsProcessWeighment.model');
const DailyCalibrationModel = require('../Calibration/clsdailyCalibration.model');
const ClassPeriodicCalibration = require('../Calibration/clsPeriodicCalibration.model');
const ClassEccenCalibration = require('../Calibration/clsEccentricity.model');
const RepeatabilityCalibrationModel = require('../Calibration/clsRepeatability.model');
const uncertinityCalibrationModel = require('../Calibration/clsUncertainty.model');
const classHmi = require('../hmiDetail.model');
const mqttProtocols = require('../../global/GLOBAL_NOMENCLATURE');
const loggers = require('../winstonLogger');
const globalData = require('../../global/globalData');
const clsMqttSender = require('../../model/Mqtt/mqttSender.class');
const GLOBAL_NOMENCLATURE = require('../../global/GLOBAL_NOMENCLATURE');
const serverConfig = require('../../global/serverConfig');
const { Console } = require('winston/lib/winston/transports');
const clsActivityLog = require('../clsActivityLog.model');
const objActivityLog = new clsActivityLog();
const InstrumentUsage = require('../clsInstrumentUsageLog');
const objInstrumentUsage = new InstrumentUsage();

const objWeighmentData = new ClassweighmentData();
const dailyCalibrationModel = new DailyCalibrationModel();
const periodiccalibrationModel = new ClassPeriodicCalibration();
const eccentricityCaibration = new ClassEccenCalibration();
const repetabilityCalibration = new RepeatabilityCalibrationModel();
const uncertinityCalibModel = new uncertinityCalibrationModel();
const objHmi = new classHmi();
const mqttSender = new clsMqttSender();
const { create, all } = require("mathjs");
const config = {};
const mathj = create(all, config);

class TappedDensityParsing {

    precision(a) {
        if (!isFinite(a)) return 0;
        var e = 1, p = 0;
        while (Math.round(a * e) / e !== a) { e *= 10; p++; }
        return p;
    }

    async parsingTappedDensityData(dataObj) {
        try {
            var { str_Protocol, strResberryPi, strHmi, ProtocolPortNo, InstrumentId, ProtocolName } = dataObj;
            var data, strModelNo;
            var strInstrumentType;
            var strHmi = dataObj.strHmi;
            var idsNo = dataObj.strResberryPi;
            var intPortNo1 = dataObj.ProtocolPortNo;
            var menuName = dataObj.menuName;
            strInstrumentType = dataObj.InstrumentType;
            var strInstrumentId = dataObj.InstrumentId;
            var currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.Hmi == strHmi);
            var tempCailibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);
            var data_array, __parameterWeighmentObj;
            var tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);

            var data_found = false;
            data_array = str_Protocol.split("\n");

            var array = [];
            var obj = {};

            var objActivity = {};
            Object.assign(objActivity,
                { strUserId: tempUserObject.UserId },
                { strUserName: tempUserObject.UserName },
                { activity: `${menuName} Weighment Started on TSH ${strHmi}` });

            objActivityLog.ActivityLogEntry(objActivity);
            // Instrument usage for TDT started
            objInstrumentUsage.InstrumentUsage('TDT', idsNo, 'tbl_instrumentlog_tapdensity', 'TDT', 'started')
            // for (let i = 0; i < data_array.length; i++) {
            //     data = data_array[i].trim();
            //     if (data == "" || data == null) {
            //         continue;
            //     } else {
            //         data_found = true;
            //     }

            //     if (data_found === true && data.includes("Instrument Sr. No.")) {  //Instrument Sr. No.
            //         let strInstrument = data.split("Instrument Sr. No.").filter(k => k);
            //         strInstrument = strInstrument[0].split(':')[1].trim();
            //         strInstrument = strInstrument.split(' ').join('');
            //         if (strInstrument.length !== 0) {
            //             let InstrumentNo = { 'InstrumentSrNo': strInstrument };
            //             array.push(InstrumentNo);
            //         } else {
            //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         }
            //     } else if (data_found === true && data.includes("Equipment Id.")) {
            //         let strEquipmentID = data.split("Equipment Id.").filter(k => k);
            //         strEquipmentID = strEquipmentID[0].split(':')[1].trim();
            //         strEquipmentID = strEquipmentID.split(' ').join('');
            //         if (strEquipmentID.length !== 0) {
            //             let EquipmentID = { 'EquipmentID': strEquipmentID };
            //             array.push(EquipmentID);
            //         } else {
            //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         }

            //     } else if (data_found === true && data.includes("Test Method")) {
            //         let strTestMethod = data.split("Test Method").filter(k => k);
            //         strTestMethod = strTestMethod[0].split(':')[1].trim();
            //         strTestMethod = strTestMethod.split(' ').join('');
            //         if (strTestMethod.length !== 0) {
            //             let TestMethod = { 'TestMethod': strTestMethod };
            //             array.push(TestMethod);
            //         } else {
            //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         }
            //     } else if (data_found === true && data.includes("Method")) {
            //         let strUSPMtd = data.split("Method").filter(k => k);
            //         strUSPMtd = strUSPMtd[0].split(':')[1].trim();
            //         strUSPMtd = strUSPMtd.split(' ') //.join('');
            //         // strUSPMtd = strUSPMtd.split(' ');
            //         // var regExp = /(\d{1,2})\:(\d{1,2})\:(\d{1,2})/;
            //         if (strUSPMtd.length == 1) { strUSPMtd = strUSPMtd[0]; } else { strUSPMtd = strUSPMtd[0] + " " + strUSPMtd[1] }
            //         // strUSPMtd = strUSPMtd[0]+ " " + strUSPMtd[1];
            //         // var pattern = /^[a-zA-Z- ]{1,}$/gi //&& strUSPMtd.match(pattern)
            //         if (strUSPMtd.length !== 0 && strUSPMtd.includes('USP') ) {
            //             let USP_Method = { 'USP_Method': strUSPMtd };
            //             array.push(USP_Method);
            //             obj["USP_Method"] = USP_Method;
            //         } else {
            //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         }
            //     } else if (data_found === true && data.includes("Weight of sample (W)")) {
            //         let strWtOfSample = data.split(":");
            //         strWtOfSample = strWtOfSample[1]
            //         if (strWtOfSample.length != 0) {
            //             var unit_wtOfSample = strWtOfSample.trim().split(' ')[1]
            //             if (unit_wtOfSample == "GM") {
            //                 unit_wtOfSample = unit_wtOfSample.toLowerCase();
            //             }
            //             if (unit_wtOfSample == undefined || unit_wtOfSample != "gms") {
            //                 return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //             }
            //             var Samplewt = strWtOfSample.trim().split(' ')[0]
            //             if (isNaN(Number(Samplewt)) == true) {
            //                 return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //             }
            //             let objWtOfSample = { 'Samplewt': mathj.round(strWtOfSample.trim().split(' ')[0],2).toFixed(2) };
            //             array.push(objWtOfSample);
            //             obj["Samplewt"] = objWtOfSample;
            //         } else {
            //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         }
            //     }
            //     //start
            //     else if (data_found === true && data.includes("Count1")) {
            //         let strtapCount1 = data.split(":");
            //         strtapCount1 = strtapCount1[1]
            //         if (strtapCount1.length !== 0) {
            //             let objtapCount1 = { 'tapCount1': strtapCount1.trim().split(' ')[0] };
            //             if (isNaN(objtapCount1.tapCount1) == true) {
            //                 return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //             }
            //             array.push(objtapCount1);
            //             obj["tapCount1"] = objtapCount1;

            //         } else {
            //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         }
            //     }
            //     else if (data_found === true && data.includes("Count2")) {
            //         let strtapCount2 = data.split(":");
            //         strtapCount2 = strtapCount2[1]
            //         if (strtapCount2.length !== 0) {
            //             let objtapCount2 = { 'tapCount2': strtapCount2.trim().split(' ')[0] };
            //             if (isNaN(objtapCount2.tapCount2) == true) {
            //                 return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //             }
            //             array.push(objtapCount2);
            //             obj["tapCount2"] = objtapCount2;

            //         } else {
            //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         }
            //     } else if (data_found === true && data.includes("Count3")) {
            //         let strtapCount3 = data.split(":");
            //         strtapCount3 = strtapCount3[1]
            //         if (strtapCount3.length !== 0) {
            //             let objtapCount3 = { 'tapCount3': strtapCount3.trim().split(' ')[0] };
            //             if (isNaN(objtapCount3.tapCount3) == true) {
            //                 return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //             }
            //             array.push(objtapCount3);
            //             obj["tapCount3"] = objtapCount3;

            //         } else {
            //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         }
            //     }
            //     else if (data_found === true && data.includes("Count4")) {
            //         let strtapCount4 = data.split(":");
            //         strtapCount4 = strtapCount4[1]
            //         if (strtapCount4.length !== 0) {
            //             let objtapCount4 = { 'tapCount4': strtapCount4.trim().split(' ')[0] };
            //             if (isNaN(objtapCount4.tapCount4) == true) {
            //                 return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //             }
            //             array.push(objtapCount4);
            //             obj["tapCount4"] = objtapCount4;

            //         } else {
            //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         }
            //     }
            //     //end
            //     else if (data_found === true && data.includes("Initial volume (Vo)")) {
            //         let strInitialVolume = data.split(":");
            //         strInitialVolume = strInitialVolume[1]
            //         if (strInitialVolume.length !== 0) {
            //             var unit_initialVolume = strInitialVolume.trim().split(' ')[1]
            //             if (unit_initialVolume == "ML") {
            //                 unit_initialVolume = unit_initialVolume.toLowerCase();
            //             }
            //             if (unit_initialVolume == undefined || unit_initialVolume != "ml") {
            //                 return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //             }
            //             let objInitialVolume = { 'initialVolume': strInitialVolume.trim().split(' ')[0] };
            //             if (isNaN(objInitialVolume.initialVolume) == true) {
            //                 return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //             }
            //             array.push(objInitialVolume);
            //             obj["initialVolume"] = objInitialVolume;

            //         } else {
            //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         }
            //     } else if (data_found === true && data.includes("Volume with Tap Count1 (V1)")) {
            //         let strVolumeTapCount1 = data.split(":");
            //         if (strVolumeTapCount1[1].length != 0) {
            //             let strVolumeTapCount1 = data.split(":");
            //             var unit_volumeTapCount1 = strVolumeTapCount1[1].trim().split(' ')[1]
            //             if (unit_volumeTapCount1 == "ML") {
            //                 unit_volumeTapCount1 = unit_volumeTapCount1.toLowerCase();
            //             }
            //             if (unit_volumeTapCount1 == undefined || unit_volumeTapCount1 != "ml") {
            //                 return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //             }
            //             strVolumeTapCount1 = strVolumeTapCount1[1].trim().split(' ')[0]
            //             let objVolumeTapCount1 = { 'volumeTapCount1': strVolumeTapCount1 };
            //             if (isNaN(objVolumeTapCount1.volumeTapCount1) == true) {
            //                 return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //             }
            //             array.push(objVolumeTapCount1);
            //             obj["volumeTapCount1"] = objVolumeTapCount1;
            //         } else {
            //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         }
            //     } else if (data_found === true && data.includes("Volume with Tap Count2 (V2)")) {
            //         let strVolumeTapCount2 = data.split(":");
            //         if (strVolumeTapCount2[1].length != 0) {
            //             var unit_volumeTapCount2 = strVolumeTapCount2[1].trim().split(' ')[1]
            //             if (unit_volumeTapCount2 == "ML") {
            //                 unit_volumeTapCount2 = unit_volumeTapCount2.toLowerCase();
            //             }
            //             if (unit_volumeTapCount2 == undefined || unit_volumeTapCount2 != "ml") {
            //                 return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //             }
            //             strVolumeTapCount2 = strVolumeTapCount2[1].trim().split(' ')[0]
            //             let objVolumeTapCount2 = { 'volumeTapCount2': strVolumeTapCount2 };
            //             if (isNaN(objVolumeTapCount2.volumeTapCount2) == true) {
            //                 return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //             }
            //             array.push(objVolumeTapCount2);
            //             obj["volumeTapCount2"] = objVolumeTapCount2;
            //         } else {
            //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         }
            //     } else if (data_found === true && data.includes("Volume with Tap Count3 (V3 )")) {
            //         let strVolumeTapCount3 = data.split(":");
            //         if (strVolumeTapCount3[1].length != 0) {
            //             var unit_volumeTapCount3 = strVolumeTapCount3[1].trim().split(' ')[1]
            //             if (unit_volumeTapCount3 == "ML") {
            //                 unit_volumeTapCount3 = unit_volumeTapCount3.toLowerCase();
            //             }
            //             if (unit_volumeTapCount3 == undefined || unit_volumeTapCount3 != "ml") {
            //                 return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //             }
            //             strVolumeTapCount3 = strVolumeTapCount3[1].trim().split(' ')[0]
            //             let objVolumeTapCount3 = { 'volumeTapCount3': strVolumeTapCount3 };
            //             if (isNaN(objVolumeTapCount3.volumeTapCount3) == true) {
            //                 return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //             }
            //             array.push(objVolumeTapCount3);
            //             obj["volumeTapCount3"] = objVolumeTapCount3;
            //         } else {
            //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         }
            //     } else if (data_found === true && data.includes("Diff.(V2-V3 )")) {
            //         let strDiff_V2_V3 = data.split(":");
            //         if (strDiff_V2_V3.length != 0) {
            //             var unit_strDiff_V2_V3 = strDiff_V2_V3[1].trim().split(' ')[1]
            //             if (unit_strDiff_V2_V3 == "ML") {
            //                 unit_strDiff_V2_V3 = unit_strDiff_V2_V3.toLowerCase();
            //             }
            //             if (unit_strDiff_V2_V3 == undefined || unit_strDiff_V2_V3 != "ml") {
            //                 return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //             }
            //             let objDiff_V2_V3 = { 'Diff(ml)': strDiff_V2_V3[1].trim().split(' ')[0] };
            //             if (isNaN(objDiff_V2_V3.diff_V2_V3) == true) {
            //                 return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //             }
            //             array.push(objDiff_V2_V3);
            //             obj["diff_V2_V3"] = objDiff_V2_V3;
            //         } else {
            //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         }
            //         // } else if (data_found === true && data.includes("Volume with Tap Count4 (V4a)")) {
            //         //     let strVolumeTapCount4a = data.split(":");
            //         //     if (strVolumeTapCount4a[1].length != 0) {
            //         //         var unit_volumeTapCount4a = strVolumeTapCount4a[1].trim().split(' ')[1]
            //         //         if (unit_volumeTapCount4a == "ML") {
            //         //             unit_volumeTapCount4a = unit_volumeTapCount4a.toLowerCase();
            //         //         }
            //         //         if (unit_volumeTapCount4a == undefined || unit_volumeTapCount4a != "ml") {
            //         //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         //         }
            //         //         strVolumeTapCount4a = strVolumeTapCount4a[1].trim().split(' ')[0]
            //         //         let objVolumeTapCount4a = { 'volumeTapCount4a': strVolumeTapCount4a };
            //         //         if (isNaN(objVolumeTapCount4a.volumeTapCount4a) == true) {
            //         //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         //         }
            //         //         array.push(objVolumeTapCount4a);
            //         //         obj["volumeTapCount4a"] = objVolumeTapCount4a;
            //         //     } else {
            //         //         return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         //     }

            //         //     // let objVolumeTapCount4a = { 'volumeTapCount4a': strVolumeTapCount4a[1].trim() };
            //         //     // array.push(objVolumeTapCount4a);

            //         // } else if (data_found === true && data.includes("Diff.(V3-V4a)")) {
            //         //     let strDiff_V3_V4a = data.split(":");
            //         //     if (strDiff_V3_V4a.length != 0) {
            //         //         var unit_strDiff_V3_V4a = strDiff_V3_V4a[1].trim().split(' ')[1]
            //         //         if (unit_strDiff_V3_V4a == "ML") {
            //         //             unit_strDiff_V3_V4a = unit_strDiff_V3_V4a.toLowerCase();
            //         //         }
            //         //         if (unit_strDiff_V3_V4a == undefined || unit_strDiff_V3_V4a != "ml") {
            //         //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         //         }
            //         //         let objDiff_V3_V4a = { 'diff_V3_V4a': strDiff_V3_V4a[1].trim().split(' ')[0] };
            //         //         if (isNaN(objDiff_V3_V4a.diff_V3_V4a) == true) {
            //         //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         //         }
            //         //         array.push(objDiff_V3_V4a);
            //         //         obj["diff_V3_V4a"] = objDiff_V3_V4a;
            //         //     } else {
            //         //         return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         //     }
            //         //     // let objDiff_V3_V4a = { 'diff_V3_V4a': strDiff_V3_V4a[1].trim() };
            //         //     // array.push(objDiff_V3_V4a);
            //         // } else if (data_found === true && data.includes("Volume with Tap Count4 (V4b)")) {
            //         //     let strVolumeTapCount4b = data.split(":");
            //         //     if (strVolumeTapCount4b[1].length != 0) {
            //         //         var unit_volumeTapCount4b = strVolumeTapCount4b[1].trim().split(' ')[1]
            //         //         if (unit_volumeTapCount4b == "ML") {
            //         //             unit_volumeTapCount4b = unit_volumeTapCount4b.toLowerCase();
            //         //         }
            //         //         if (unit_volumeTapCount4b == undefined || unit_volumeTapCount4b != "ml") {
            //         //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         //         }
            //         //         strVolumeTapCount4b = strVolumeTapCount4b[1].trim().split(' ')[0]
            //         //         let objVolumeTapCount4b = { 'volumeTapCount4b': strVolumeTapCount4b };
            //         //         if (isNaN(objVolumeTapCount4b.volumeTapCount4b) == true) {
            //         //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         //         }
            //         //         array.push(objVolumeTapCount4b);
            //         //         obj["volumeTapCount4b"] = objVolumeTapCount4b;
            //         //     } else {
            //         //         return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         //     }
            //         //     // let objVolumeTapCount4b = { 'volumeTapCount4b': strVolumeTapCount4b[1].trim() };
            //         //     // array.push(objVolumeTapCount4b);
            //         // } else if (data_found === true && data.includes("Diff.(V4a-V4b)")) {
            //         //     let strDiff_V4a_V4b = data.split(":");
            //         //     if (strDiff_V4a_V4b.length != 0) {
            //         //         var unit_strDiff_V4a_V4b = strDiff_V4a_V4b[1].trim().split(' ')[1]
            //         //         if (unit_strDiff_V4a_V4b == "ML") {
            //         //             unit_strDiff_V4a_V4b = unit_strDiff_V4a_V4b.toLowerCase();
            //         //         }
            //         //         if (unit_strDiff_V4a_V4b == undefined || unit_strDiff_V4a_V4b != "ml") {
            //         //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         //         }
            //         //         let objDiff_V4a_V4b = { 'diff_V4a_V4b': strDiff_V4a_V4b[1].trim().split(' ')[0] };
            //         //         if (isNaN(objDiff_V4a_V4b.diff_V4a_V4b) == true) {
            //         //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         //         }
            //         //         array.push(objDiff_V4a_V4b);
            //         //         obj["diff_V4a_V4b"] = objDiff_V4a_V4b;
            //         //     } else {
            //         //         return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         //     }

            //         //     // let objDiff_V4a_V4b = { 'diff_V4a_V4b': strDiff_V4a_V4b[1].trim() };
            //         //     // array.push(objDiff_V4a_V4b);
            //         // } else if (data_found === true && data.includes("Volume with Tap Count4 (V4c)")) {
            //         //     let strVolumeTapCount4c = data.split(":");
            //         //     if (strVolumeTapCount4c[1].length != 0) {
            //         //         var unit_volumeTapCount4c = strVolumeTapCount4c[1].trim().split(' ')[1]
            //         //         if (unit_volumeTapCount4c == "ML") {
            //         //             unit_volumeTapCount4c = unit_volumeTapCount4c.toLowerCase();
            //         //         }
            //         //         if (unit_volumeTapCount4c == undefined || unit_volumeTapCount4c != "ml") {
            //         //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         //         }
            //         //         strVolumeTapCount4c = strVolumeTapCount4c[1].trim().split(' ')[0]
            //         //         let objVolumeTapCount4c = { 'volumeTapCount4c': strVolumeTapCount4c };
            //         //         if (isNaN(objVolumeTapCount4c.volumeTapCount4c) == true) {
            //         //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         //         }
            //         //         array.push(objVolumeTapCount4c);
            //         //         obj["volumeTapCount4c"] = objVolumeTapCount4c;
            //         //     } else {
            //         //         return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         //     }

            //         //     // let objVolumeTapCount4c = { 'volumeTapCount4c': strVolumeTapCount4c[1].trim() };
            //         //     // array.push(objVolumeTapCount4c);
            //         // } else if (data_found === true && data.includes("Diff.(V4b-V4c)")) {
            //         //     let strDiff_V4b_V4c = data.split(":");
            //         //     if (strDiff_V4b_V4c.length != 0) {
            //         //         var unit_strDiff_V4b_V4c = strDiff_V4b_V4c[1].trim().split(' ')[1]
            //         //         if (unit_strDiff_V4b_V4c == "ML") {
            //         //             unit_strDiff_V4b_V4c = unit_strDiff_V4b_V4c.toLowerCase();
            //         //         }
            //         //         if (unit_strDiff_V4b_V4c == undefined || unit_strDiff_V4b_V4c != "ml") {
            //         //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         //         }
            //         //         let objDiff_V4b_V4c = { 'diff_V4b_V4c': strDiff_V4b_V4c[1].trim().split(' ')[0] };
            //         //         if (isNaN(objDiff_V4b_V4c.diff_V4b_V4c) == true) {
            //         //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         //         }
            //         //         array.push(objDiff_V4b_V4c);
            //         //         obj["diff_V4b_V4c"] = objDiff_V4b_V4c;
            //         //     } else {
            //         //         return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         //     }
            //         //     // let objDiff_V4b_V4c = { 'diff_V4b_V4c': strDiff_V4b_V4c[1].trim() };
            //         //     // array.push(objDiff_V4b_V4c);
            //     } else if (data_found === true && data.includes("Tap Density (W/Vf)")) {
            //         let strTapDensityWVf = data.split(":")[1].trim();
            //         if (strTapDensityWVf.length != 0) {
            //             var unit_tapDensityWVf = strTapDensityWVf.split(' ')[1]
            //             if (unit_tapDensityWVf == "GMS/ML" || unit_tapDensityWVf == "gms/ML" || unit_tapDensityWVf == "GMS/ml") {
            //                 unit_tapDensityWVf = unit_tapDensityWVf.toLowerCase();
            //             }
            //             if (unit_tapDensityWVf == undefined || unit_tapDensityWVf != "gms/ml") {
            //                 return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //             }
            //             let objTapDensityWVf = { 'tapDensityWVf': mathj.round(strTapDensityWVf.trim().split(' ')[0],2).toFixed(2) }
            //             if (isNaN(objTapDensityWVf.tapDensityWVf) == true) {
            //                 return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //             }
            //             array.push(objTapDensityWVf);
            //             obj["tapDensityWVf"] = objTapDensityWVf;
            //         } else {
            //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         }
            //     } else if (data_found === true && data.includes("Initial Density (W/Vo)")) {
            //         let strinitialDensityWvo = data.split(":")[1].trim();
            //         if (strinitialDensityWvo.length != 0) {
            //             var unit_initialDensityWvo = strinitialDensityWvo.split(' ')[1]
            //             if (unit_initialDensityWvo == "GM/ML" || unit_initialDensityWvo == "gm/ML" || unit_initialDensityWvo == "GM/ml") {
            //                 unit_initialDensityWvo = unit_initialDensityWvo.toLowerCase();
            //             }
            //             if (unit_initialDensityWvo == undefined || unit_initialDensityWvo != "gm/ml") {
            //                 return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //             }
            //             let objinitialDensityWvo = { 'initialDensityWvo': strinitialDensityWvo.trim().split(' ')[0] };
            //             if (isNaN(objinitialDensityWvo.initialDensityWvo) == true) {
            //                 return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //             }
            //             array.push(objinitialDensityWvo);
            //             obj["initialDensityWvo"] = objinitialDensityWvo;
            //         } else {
            //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         }
            //     } else if (data_found === true && data.includes("Compressibility Index ([(Vo-Vf)/Vo]x100)")) {
            //         let strCompressibilityIndex = data.split(":");
            //         let objCompressibilityIndex = { 'compressibilityIndex': strCompressibilityIndex[1].trim() };
            //         array.push(objCompressibilityIndex);
            //         obj["compressibilityIndex"] = objCompressibilityIndex;
            //     } else if (data_found === true && data.includes("Hausner Ratio (Vo/Vf)")) {
            //         let strHausnerRatio = data.split(":");
            //         let objHausnerRatio = { 'hausnerRatio': strHausnerRatio[1].trim() };
            //         array.push(objHausnerRatio);
            //         obj["hausnerRatio"] = objHausnerRatio;
            //     } else if (data_found === true && data.includes("Final Volume (Vf)")) {
            //         let strBulkDensity = data.split(":")[1].trim();
            //         if (strBulkDensity.length != 0) {
            //             var unit_BulkDensity = strBulkDensity.split(' ')[1]
            //             if (unit_BulkDensity == "GMS/ML" || unit_BulkDensity == "gms/ML" || unit_BulkDensity == "GMS/ml") {
            //                 unit_BulkDensity = unit_BulkDensity.toLowerCase();
            //             }
            //             if (unit_BulkDensity == undefined || unit_BulkDensity != "gms/ml") {
            //                 return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //             }
            //             let objBulkDensityWVf = { 'BulkDensityWVf': mathj.round(strBulkDensity.trim().split(' ')[0],2).toFixed(2) }
            //             if (isNaN(objBulkDensityWVf.BulkDensityWVf) == true) {
            //                 return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //             }
            //             array.push(objBulkDensityWVf);
            //             obj["BulkDensityWVf"] = objBulkDensityWVf;
            //         } else {
            //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            //         }
            //     }

            //     else {
            //         //console.log('invalid string recived');
            //     }
            // }
            for (let i = 0; i < data_array.length; i++) {
                data = data_array[i].trim();
                if (data == "" || data == null) {
                    continue;
                } else {
                    data_found = true;
                }

                if (data_found === true && data.includes("Model No")) {
                    let strModelNo = data.split("Date").filter(k => k);
                    strModelNo = strModelNo[0].split(':')[1].trim();
                    strModelNo = strModelNo.split(' ').join('');
                    if (strModelNo.length !== 0) {
                        let modelNo = { 'modelNo': strModelNo };
                        array.push(modelNo);
                    } else {
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                    }
                } else if (data_found === true && data.includes("Serial No")) {
                    let strSerialNo = data.split("   ").filter(k => k);
                    strSerialNo = strSerialNo[0].split(':')[1].trim();
                    strSerialNo = strSerialNo.split(' ').join('');
                    if (strSerialNo.length !== 0) {
                        let objSerialNo = { 'serialNo': strSerialNo };
                        if (typeof objSerialNo.serialNo != 'number') {
                            objSerialNo = { "serialNo": "0" }
                        }
                        array.push(objSerialNo);
                        let instrument = { 'instrumentNo': strSerialNo };
                        if (typeof instrument.instrumentNo != 'number') {
                            instrument = { "instrumentNo": "0" }
                        }
                        array.push(instrument);
                    } else {
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                    }
                } else if (data_found === true && data.includes("Method") && data.includes("Tap Count1")) {
                    let strMethod = data.split("Tap Count1").filter(k => k);
                    strMethod = strMethod[0].split(':')[1].trim();
                    // strMethod = strMethod.split(' ').join(''); //commented by rupali on 16/08/23
                    var TapCount1 = data.split("Tap").filter(k => k);
                    TapCount1 = TapCount1[1].trim().split(':')[1].trim()
                    //if (strMethod.length !== 0 && TapCount1.length !== 0) {
                    if (strMethod.length !== 0) {
                        let objMethod = { 'method': strMethod };
                        // let objTapCount1 = { 'tapCount1': TapCount1 }
                        // if ((objMethod.method) != "USP II") {
                        //     // objActivityLog.ActivityLogEntry(strHmi, `Invalid Data`)
                        //     return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`);
                        // }
                        // array.push(objMethod, objTapCount1);
                        array.push(objMethod);
                        obj["method"] = objMethod;
                        // obj["tapCount1"] = objTapCount1;
                    } else {
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                    }
                } else if (data_found === true && data.includes("Method") && !data.includes("Tap Count1")) {
                    let strMethod = data.split("Method").filter(k => k);
                    strMethod = strMethod[0].split(':')[1].trim();
                    if (strMethod.length !== 0) {
                        let objMethod = { 'method': strMethod };
                        // let objTapCount1 = { 'tapCount1': TapCount1 }
                        if ((objMethod.method) != "USP II") {
                            // objActivityLog.ActivityLogEntry(strHmi, `Invalid Data`)
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`);
                        }
                        // array.push(objMethod, objTapCount1);
                        array.push(objMethod);
                        obj["method"] = objMethod;
                        // obj["tapCount1"] = objTapCount1;
                    } else {
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                    }


                } else if (data_found === true && data.includes("Tap Count2:")){
                    let strtapCount2 = data.split(":");
                    strtapCount2 = strtapCount2[1]
                    if (strtapCount2.length !== 0) {
                        let objtapCount2 = { 'tapCount2': strtapCount2.trim().split(' ')[0] };
                        if (isNaN(objtapCount2.tapCount2) == true) {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                    } else {
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                    }
                } else if (data_found === true && data.includes("Tap Count3:")){
                    let strtapCount3 = data.split(":");
                    strtapCount3 = strtapCount3[1]
                    if (strtapCount3.length !== 0) {
                        let objtapCount3 = { 'tapCount3': strtapCount3.trim().split(' ')[0] };
                        if (isNaN(objtapCount3.tapCount3) == true) {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                    } else {
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                    }
                } else if (data_found === true && data.includes("Tap Count4:")){
                    let strtapCount4 = data.split(":");
                    strtapCount4 = strtapCount4[1]
                    if (strtapCount4.length !== 0) {
                        let objtapCount4 = { 'tapCount4': strtapCount4.trim().split(' ')[0] };
                        if (isNaN(objtapCount4.tapCount4) == true) {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                    } else {
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                    }
                } else if (data_found === true && data.includes("Weight of sample (W)")) {
                    let strWtOfSample = data.split(":");
                    strWtOfSample = strWtOfSample[1]
                    if (strWtOfSample.length != 0) {
                        var unit_wtOfSample = strWtOfSample.trim().split(' ')[1]
                        if (unit_wtOfSample == "GM") {
                            unit_wtOfSample = unit_wtOfSample.toLowerCase();
                        }
                        if (unit_wtOfSample == undefined || (unit_wtOfSample != "gm" && unit_wtOfSample != "g")) {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        let objWtOfSample = { 'wtOfSample': strWtOfSample.trim().split(' ')[0] };
                        if (isNaN(objWtOfSample.wtOfSample) == true) {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        array.push(objWtOfSample);
                        obj["wtOfSample"] = objWtOfSample;
                    } else {
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                    }
                } else if (data_found === true && data.includes("Initial volume (Vo)")) {
                    let strInitialVolume = data.split(":");
                    strInitialVolume = strInitialVolume[1]
                    if (strInitialVolume.length !== 0) {
                        var unit_initialVolume = strInitialVolume.trim().split(' ')[1]
                        if (unit_initialVolume == "ML") {
                            unit_initialVolume = unit_initialVolume.toLowerCase();
                        }
                        if (unit_initialVolume == undefined || unit_initialVolume != "ml") {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        let objInitialVolume = { 'initialVolume': strInitialVolume.trim().split(' ')[0] };
                        if (isNaN(objInitialVolume.initialVolume) == true) {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        array.push(objInitialVolume);
                        obj["initialVolume"] = objInitialVolume;

                    } else {
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                    }
                } else if (data_found === true && data.includes("Volume with Tap Count1 (V1)")) {
                    let strVolumeTapCount1 = data.split(":");
                    if (strVolumeTapCount1[1].length != 0) {
                        let strVolumeTapCount1 = data.split(":");
                        var unit_volumeTapCount1 = strVolumeTapCount1[1].trim().split(' ')[1]
                        if (unit_volumeTapCount1 == "ML") {
                            unit_volumeTapCount1 = unit_volumeTapCount1.toLowerCase();
                        }
                        if (unit_volumeTapCount1 == undefined || unit_volumeTapCount1 != "ml") {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        strVolumeTapCount1 = strVolumeTapCount1[1].trim().split(' ')[0]
                        let objVolumeTapCount1 = { 'volumeTapCount1': strVolumeTapCount1 };
                        if (isNaN(objVolumeTapCount1.volumeTapCount1) == true) {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        array.push(objVolumeTapCount1);
                        obj["volumeTapCount1"] = objVolumeTapCount1;
                    } else {
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                    }
                } else if (data_found === true && data.includes("Volume with Tap Count2 (V2)")) {
                    let strVolumeTapCount2 = data.split(":");
                    if (strVolumeTapCount2[1].length != 0) {
                        var unit_volumeTapCount2 = strVolumeTapCount2[1].trim().split(' ')[1]
                        if (unit_volumeTapCount2 == "ML") {
                            unit_volumeTapCount2 = unit_volumeTapCount2.toLowerCase();
                        }
                        if (unit_volumeTapCount2 == undefined || unit_volumeTapCount2 != "ml") {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        strVolumeTapCount2 = strVolumeTapCount2[1].trim().split(' ')[0]
                        let objVolumeTapCount2 = { 'volumeTapCount2': strVolumeTapCount2 };
                        if (isNaN(objVolumeTapCount2.volumeTapCount2) == true) {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        array.push(objVolumeTapCount2);
                        obj["volumeTapCount2"] = objVolumeTapCount2;
                    } else {
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                    }
                } else if (data_found === true && data.includes("Volume with Tap Count3 (V3 )")) {
                    let strVolumeTapCount3 = data.split(":");
                    if (strVolumeTapCount3[1].length != 0) {
                        var unit_volumeTapCount3 = strVolumeTapCount3[1].trim().split(' ')[1]
                        if (unit_volumeTapCount3 == "ML") {
                            unit_volumeTapCount3 = unit_volumeTapCount3.toLowerCase();
                        }
                        if (unit_volumeTapCount3 == undefined || unit_volumeTapCount3 != "ml") {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        strVolumeTapCount3 = strVolumeTapCount3[1].trim().split(' ')[0]
                        let objVolumeTapCount3 = { 'volumeTapCount3': strVolumeTapCount3 };
                        if (isNaN(objVolumeTapCount3.volumeTapCount3) == true) {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        array.push(objVolumeTapCount3);
                        obj["volumeTapCount3"] = objVolumeTapCount3;
                    } else {
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                    }
                } else if (data_found === true && data.includes("Diff.(V2-V3 )")) {
                    let strDiff_V2_V3 = data.split(":");
                    if (strDiff_V2_V3.length != 0) {
                        var unit_strDiff_V2_V3 = strDiff_V2_V3[1].trim().split(' ')[1]
                        if (unit_strDiff_V2_V3 == "ML") {
                            unit_strDiff_V2_V3 = unit_strDiff_V2_V3.toLowerCase();
                        }
                        if (unit_strDiff_V2_V3 == undefined || unit_strDiff_V2_V3 != "ml") {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        let objDiff_V2_V3 = { 'diff_V2_V3': strDiff_V2_V3[1].trim().split(' ')[0] };
                        if (isNaN(objDiff_V2_V3.diff_V2_V3) == true) {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        array.push(objDiff_V2_V3);
                        obj["diff_V2_V3"] = objDiff_V2_V3;
                    } else {
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                    }
                } else if (data_found === true && data.includes("Volume with Tap Count4 (V4a)")) {
                    let strVolumeTapCount4a = data.split(":");
                    if (strVolumeTapCount4a[1].length != 0) {
                        var unit_volumeTapCount4a = strVolumeTapCount4a[1].trim().split(' ')[1]
                        if (unit_volumeTapCount4a == "ML") {
                            unit_volumeTapCount4a = unit_volumeTapCount4a.toLowerCase();
                        }
                        if (unit_volumeTapCount4a == undefined || unit_volumeTapCount4a != "ml") {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        strVolumeTapCount4a = strVolumeTapCount4a[1].trim().split(' ')[0]
                        let objVolumeTapCount4a = { 'volumeTapCount4a': strVolumeTapCount4a };
                        if (isNaN(objVolumeTapCount4a.volumeTapCount4a) == true) {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        array.push(objVolumeTapCount4a);
                        obj["volumeTapCount4a"] = objVolumeTapCount4a;
                    } else {
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                    }

                    // let objVolumeTapCount4a = { 'volumeTapCount4a': strVolumeTapCount4a[1].trim() };
                    // array.push(objVolumeTapCount4a);

                } else if (data_found === true && data.includes("Diff.(V3-V4a)")) {
                    let strDiff_V3_V4a = data.split(":");
                    if (strDiff_V3_V4a.length != 0) {
                        var unit_strDiff_V3_V4a = strDiff_V3_V4a[1].trim().split(' ')[1]
                        if (unit_strDiff_V3_V4a == "ML") {
                            unit_strDiff_V3_V4a = unit_strDiff_V3_V4a.toLowerCase();
                        }
                        if (unit_strDiff_V3_V4a == undefined || unit_strDiff_V3_V4a != "ml") {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        let objDiff_V3_V4a = { 'diff_V3_V4a': strDiff_V3_V4a[1].trim().split(' ')[0] };
                        if (isNaN(objDiff_V3_V4a.diff_V3_V4a) == true) {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        array.push(objDiff_V3_V4a);
                        obj["diff_V3_V4a"] = objDiff_V3_V4a;
                    } else {
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                    }
                    // let objDiff_V3_V4a = { 'diff_V3_V4a': strDiff_V3_V4a[1].trim() };
                    // array.push(objDiff_V3_V4a);
                } else if (data_found === true && data.includes("Volume with Tap Count4 (V4b)")) {
                    let strVolumeTapCount4b = data.split(":");
                    if (strVolumeTapCount4b[1].length != 0) {
                        var unit_volumeTapCount4b = strVolumeTapCount4b[1].trim().split(' ')[1]
                        if (unit_volumeTapCount4b == "ML") {
                            unit_volumeTapCount4b = unit_volumeTapCount4b.toLowerCase();
                        }
                        if (unit_volumeTapCount4b == undefined || unit_volumeTapCount4b != "ml") {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        strVolumeTapCount4b = strVolumeTapCount4b[1].trim().split(' ')[0]
                        let objVolumeTapCount4b = { 'volumeTapCount4b': strVolumeTapCount4b };
                        if (isNaN(objVolumeTapCount4b.volumeTapCount4b) == true) {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        array.push(objVolumeTapCount4b);
                        obj["volumeTapCount4b"] = objVolumeTapCount4b;
                    } else {
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                    }
                    // let objVolumeTapCount4b = { 'volumeTapCount4b': strVolumeTapCount4b[1].trim() };
                    // array.push(objVolumeTapCount4b);
                } else if (data_found === true && data.includes("Diff.(V4a-V4b)")) {
                    let strDiff_V4a_V4b = data.split(":");
                    if (strDiff_V4a_V4b.length != 0) {
                        var unit_strDiff_V4a_V4b = strDiff_V4a_V4b[1].trim().split(' ')[1]
                        if (unit_strDiff_V4a_V4b == "ML") {
                            unit_strDiff_V4a_V4b = unit_strDiff_V4a_V4b.toLowerCase();
                        }
                        if (unit_strDiff_V4a_V4b == undefined || unit_strDiff_V4a_V4b != "ml") {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        let objDiff_V4a_V4b = { 'diff_V4a_V4b': strDiff_V4a_V4b[1].trim().split(' ')[0] };
                        if (isNaN(objDiff_V4a_V4b.diff_V4a_V4b) == true) {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        array.push(objDiff_V4a_V4b);
                        obj["diff_V4a_V4b"] = objDiff_V4a_V4b;
                    } else {
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                    }

                    // let objDiff_V4a_V4b = { 'diff_V4a_V4b': strDiff_V4a_V4b[1].trim() };
                    // array.push(objDiff_V4a_V4b);
                } else if (data_found === true && data.includes("Volume with Tap Count4 (V4c)")) {
                    let strVolumeTapCount4c = data.split(":");
                    if (strVolumeTapCount4c[1].length != 0) {
                        var unit_volumeTapCount4c = strVolumeTapCount4c[1].trim().split(' ')[1]
                        if (unit_volumeTapCount4c == "ML") {
                            unit_volumeTapCount4c = unit_volumeTapCount4c.toLowerCase();
                        }
                        if (unit_volumeTapCount4c == undefined || unit_volumeTapCount4c != "ml") {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        strVolumeTapCount4c = strVolumeTapCount4c[1].trim().split(' ')[0]
                        let objVolumeTapCount4c = { 'volumeTapCount4c': strVolumeTapCount4c };
                        if (isNaN(objVolumeTapCount4c.volumeTapCount4c) == true) {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        array.push(objVolumeTapCount4c);
                        obj["volumeTapCount4c"] = objVolumeTapCount4c;
                    } else {
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                    }

                    // let objVolumeTapCount4c = { 'volumeTapCount4c': strVolumeTapCount4c[1].trim() };
                    // array.push(objVolumeTapCount4c);
                } else if (data_found === true && data.includes("Diff.(V4b-V4c)")) {
                    let strDiff_V4b_V4c = data.split(":");
                    if (strDiff_V4b_V4c.length != 0) {
                        var unit_strDiff_V4b_V4c = strDiff_V4b_V4c[1].trim().split(' ')[1]
                        if (unit_strDiff_V4b_V4c == "ML") {
                            unit_strDiff_V4b_V4c = unit_strDiff_V4b_V4c.toLowerCase();
                        }
                        if (unit_strDiff_V4b_V4c == undefined || unit_strDiff_V4b_V4c != "ml") {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        let objDiff_V4b_V4c = { 'diff_V4b_V4c': strDiff_V4b_V4c[1].trim().split(' ')[0] };
                        if (isNaN(objDiff_V4b_V4c.diff_V4b_V4c) == true) {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        array.push(objDiff_V4b_V4c);
                        obj["diff_V4b_V4c"] = objDiff_V4b_V4c;
                    } else {
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                    }
                    // let objDiff_V4b_V4c = { 'diff_V4b_V4c': strDiff_V4b_V4c[1].trim() };
                    // array.push(objDiff_V4b_V4c);
                } else if (data_found === true && data.includes("Tap Density (W/Vf)")) {
                    let strTapDensityWVf = data.split(":")[1].trim();
                    if (strTapDensityWVf.length != 0) {
                        var unit_tapDensityWVf = strTapDensityWVf.split(' ')[1]
                        if (unit_tapDensityWVf == "GM/ML" || unit_tapDensityWVf == "gm/ML" || unit_tapDensityWVf == "GM/ml") {
                            unit_tapDensityWVf = unit_tapDensityWVf.toLowerCase();
                        }
                        if (unit_tapDensityWVf == undefined || unit_tapDensityWVf != "gm/ml") {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        let objTapDensityWVf = { 'tapDensityWVf': strTapDensityWVf.trim().split(' ')[0] }
                        if (isNaN(objTapDensityWVf.tapDensityWVf) == true) {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        array.push(objTapDensityWVf);
                        obj["tapDensityWVf"] = objTapDensityWVf;
                    } else {
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                    }
                } else if (data_found === true && data.includes("Initial Density (W/Vo)")) { //rupali
                    let strinitialDensityWvo = data.split(":")[1].trim();
                    if (strinitialDensityWvo.length != 0) {
                        var unit_initialDensityWvo = strinitialDensityWvo.split(' ')[1]
                        if (unit_initialDensityWvo == "GM/ML" || unit_initialDensityWvo == "gm/ML" || unit_initialDensityWvo == "GM/ml") {
                            unit_initialDensityWvo = unit_initialDensityWvo.toLowerCase();
                        }
                        if (unit_initialDensityWvo == undefined || unit_initialDensityWvo != "gm/ml") {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        let objinitialDensityWvo = { 'initialDensityWvo': strinitialDensityWvo.trim().split(' ')[0] };
                        if (isNaN(objinitialDensityWvo.initialDensityWvo) == true) {
                            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                        }
                        array.push(objinitialDensityWvo);
                        obj["initialDensityWvo"] = objinitialDensityWvo;
                    } else {
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                    }
                } else if (data_found === true && data.includes("Compressibility Index ([(Vo-Vf)/Vo]x100)")) {
                    let strCompressibilityIndex = data.split(":");
                    let objCompressibilityIndex = { 'compressibilityIndex': strCompressibilityIndex[1].trim() };
                    array.push(objCompressibilityIndex);
                    obj["compressibilityIndex"] = objCompressibilityIndex;
                } else if (data_found === true && data.includes("Hausner Ratio (Vo/Vf)")) {
                    let strHausnerRatio = data.split(":");
                    let objHausnerRatio = { 'hausnerRatio': strHausnerRatio[1].trim() };
                    array.push(objHausnerRatio);
                    obj["hausnerRatio"] = objHausnerRatio;
                } else {
                    //console.log('invalid string recived');
                }
            }
            
            if (obj != undefined) {
                if (!obj["initialDensityWvo"] || !obj["tapDensityWVf"] || !obj["volumeTapCount1"] ||
                    !obj["volumeTapCount2"]  || !obj["diff_V2_V3"] ||
                    !obj["wtOfSample"] || !obj["initialVolume"] || !obj["method"] == true) {
                    return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                }
            } else {
                return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            }

            let tapDensityWt = globalData.arrTapDensity.find(k => k.Hmi == strHmi);
            if (tapDensityWt == undefined) {
                globalData.arrTapDensity.push({
                    Hmi: strHmi,
                    idsNo: strResberryPi,
                    actualWt: array
                })
            } else {
                tapDensityWt.actualWt = array;
            }

            tapDensityWt = globalData.arrTapDensity.find(k => k.Hmi == strHmi);

            __parameterWeighmentObj = {
                idsNo: strResberryPi,
                Hmi: strHmi,
                arrActualWt: tapDensityWt.actualWt,
                instrumentId: strInstrumentId,
                menuName: menuName
            }


            if (tempCailibType == undefined) {
                if (currentOpStatus == undefined) {
                    loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
                    console.log('wt recieve without any api called');
                    return;
                } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

                    await objWeighmentData.ParsingTestData(__parameterWeighmentObj);
                }
            } else {
                console.log('calibration will not do here')
            }
            // }
        } catch (error) {
            throw new Error(error)
        }
    }
}

module.exports = TappedDensityParsing;