
const ClassweighmentData = require('../clsProcessWeighment.model');
const classHmi = require('../hmiDetail.model');
const mqttProtocols = require('../../global/GLOBAL_NOMENCLATURE');
const loggers = require('../winstonLogger');
const globalData = require('../../global/globalData');
const clsMqttSender = require('../../model/Mqtt/mqttSender.class');
const GLOBAL_NOMENCLATURE = require('../../global/GLOBAL_NOMENCLATURE');
// const clsDatabase = require('../../database/clsQueryProcess');
const clsHardness125 = require('../../model/Test/clsHardness.model');
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');

const objWeighmentData = new ClassweighmentData();
const objHmi = new classHmi();
const mqttSender = new clsMqttSender();
// const database = new clsDatabase();
const objHardness125 = new clsHardness125();

const models = require('../../../config/dbConnection').models;
const sequelize = require('../../../config/dbConnection').sequelize;

class HardnessParsing {

    async parseDataAccordingToModelHardness(dataObj) {
        let strIdsNo = dataObj.strResberryPi;
        let strHardnessModel = await this.CheckHardnessModel(strIdsNo);
        if (strHardnessModel.Eqp_Model == 'TBH425' || strHardnessModel.Eqp_Model == "TBH 425 TD") {
            await this.parsingHardnessData_Erweka425(dataObj);
        } else if (strHardnessModel.Eqp_Make == 'Dr Schleuniger') {
            await this.parsingHardnessDrSchleuniger(dataObj);
        }
        else if (strHardnessModel.Eqp_Make == "Sotax MT50") {
            let strMt50Type = strHardnessModel.Eqp_HT_Type;
            if (strMt50Type == 'HTOHL') {
                // Taking only hardness from all parameters
                await this.parsingHardnessData_OnlyHardness(dataObj);   // only mt50 hardness 
            } else if (strMt50Type == 'HTOHR') {
                // HTOHR Routine MT  50 DIRECT
                await this.parsingHardnessMT50HTOHR(dataObj);
            } else {
                // HTALL
                await this.parsingHardnessData_SotaxMT50(dataObj); // expecpt only mt50 hardness 
            }

            if (strHardnessModel.Eqp_Make == "Sotax ST50") {
                // HTALL
                await this.parsingHardnessData_SotaxMT50(dataObj);

            }
        }
        else {
            if (strHardnessModel.Eqp_Make == 'TBH425 TD') {
                await this.parsingHardnessData_Erweka425(dataObj);
            } else {
                await this.parsingHardnessData_Erweka125(dataObj);
            }
        }
    }

    async CheckHardnessModel(idsNo) {
        var cubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == idsNo).cubicalData;

        var strHmi = globalData.arrIdsInfo.find(k => k.idsNo == idsNo).Hmi;
        let ChangesHardnessID = await models.tbl_cubical.findAll({
            where: {
                Sys_IDSNo: strHmi
            }
        })
        cubicInfo.Sys_HardID = ChangesHardnessID[0].Sys_HardID
        var hardnessId = cubicInfo.Sys_HardID;
        // var selectOtherEquip = {
        //     str_tableName: 'tbl_otherequipment',
        //     data: 'Eqp_Make,Eqp_HT_Type',
        //     condition: [
        //         { str_colName: 'Eqp_ID', value: hardnessId }
        //     ]
        // }
        // var result = await database.select(selectOtherEquip);
        // return result[0][0];
        var selectOtherEquip = await models['tbl_otherequipment'].findAll({
            where: {
                Eqp_ID: hardnessId
            },
            // include: {
            //     model: tbl_otherequipment,
            //     attributes:['Eqp_Make', 'Eqp_HT_Type']
            // }
        });
        return [selectOtherEquip][0][0];
    }

    async parsingHardnessData_Erweka425(dataObj) {
        try {

            var { str_Protocol, strResberryPi, strHmi, ProtocolPortNo, instrumentId, ProtocolName } = dataObj;
            var currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.Hmi == strHmi);
            var tempCailibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);
            var tempActualProtocol = str_Protocol.split(':')[2].trim().split('\n')
            var arrPortDetailForStart = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi)
            if (Number(arrPortDetailForStart.portNo) != Number(ProtocolPortNo)) {
                console.log('Invalid Port')
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid Port`)
            }
            if (tempActualProtocol.length == 0) {
                console.log('INVALID STRING')
                // loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}Invalid String Received on Device ${strHmi}`)
                return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            }
            var arrHardness = []
            var sample = {}
            var ind = 1
            for (var ele of tempActualProtocol) {
                if (ele.trim().length != 0) {
                    ele = ele.slice(1).trim()
                    var pattern, keys
                    if (ind == 1) {
                        // pattern = (/^(([0-9]{1,}(\.\d*)?)|(--))(\s*)?mg$/i)
                        pattern = (/^((([0-9]{1,}(\.\d*)?)|(--)|([A-Za-z]{2})))\s*mg$/i)
                        keys = "tempWt"
                    } else if (ind == 2) {
                        // pattern = (/^(([0-9]{1,}(\.\d*)?)|(--))(\s*)?mm$/i)
                        pattern = (/^((([0-9]{1,}(\.\d*)?)|(--)|([A-Za-z]{2})))\s*mm$/i)

                        keys = "tempThickVal"
                    } else if (ind == 3) {
                        pattern = (/^((([0-9]{1,}(\.\d*)?)|(--)|([A-Za-z]{2})))\s*mm$/i)
                        keys = "tempDiamVal"
                    } else if (ind == 4) {
                        // pattern = (/^(([0-9]{1,}(\.\d*)?)|(--))(\s*)?(N|KP|SC)$/i)
                        // pattern = (/^(([0-9]{1,}(\.\d*)?)|(--)|(NA|FL|N|KP|SC))(\s*)?(mm)$/i)
                    pattern = /^(([0-9]{1,}(\.\d*)?)|(NA|FL|--)|(N|Kp|Sc))(\s*)?(mm|N|kp)$/i;

                        // pattern = (/^([0-9]+(\.\d*)?)(\s*)?(N|KP|SC)$/i)
                        keys = "tempHardVal"
                    }
                    var status = pattern.test(ele)
                    if (!status) {
                        console.log('INVALID STRING')
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                    }
                    if (ind == 4 && !ele.toLowerCase().endsWith(arrPortDetailForStart.selectedProductDetail.unit.toLowerCase())) {
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid Unit Received`)
                    }
                    // var value = ele.match(/[0-9.]/g)
                    var value = ele.match(/[0-9.]+|NA|FL|--/gi)

                    value = value == null ? 0 : value.join("")
                    if ((ind == 4 && value == 0) || (value.length == 0 && value <= 0)) {
                        console.log('INVALID STRING')
                        // loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}Invalid String Received on Device ${strHmi}`)
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                    }
                    sample[keys] = value
                    if (ind == 4) {
                        arrHardness.push(sample)
                        sample = {}
                        ind = 1
                    } else {
                        ind++
                    }
                }
            }

            let menu = [...new Set(arrPortDetailForStart.selectedProductDetail.column)];

            // if ((!menu.includes(GLOBAL_NOMENCLATURE.ThicknessMenu) && Number(arrHardness[0].tempThickVal) != 0) ||
            //     ((!menu.includes(GLOBAL_NOMENCLATURE.LengthMenu) && !menu.includes(GLOBAL_NOMENCLATURE.DiameterMenu)) && Number(arrHardness[0].tempDiamVal) != 0)) {
            //     return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            // }

            if (ind != 1) {
                console.log('INVALID STRING')
                // loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}Invalid String Received on Device ${strHmi}`)
                return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            }

            const __parameterWeighmentObj = {
                idsNo: strResberryPi,
                Hmi: strHmi,
                data: arrHardness,
            }
            if (tempCailibType == undefined) {
                if (currentOpStatus == undefined) {
                    // loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
                    console.log('wt recieve without any api called');
                    return;
                } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

                    await objHardness125.processHardnessData(__parameterWeighmentObj);
                }
            } else {
                console.log('Hardeness 425 Parsing Error');
            }



        } catch (error) {
            throw new Error(error)
        }
    }

    async parsingHardnessData_Erweka125(dataObj) {
        try {

            var { str_Protocol, strResberryPi, strHmi, ProtocolPortNo, instrumentId, ProtocolName } = dataObj;

            var strIdsNo = strResberryPi;

            // var currentCubicle = globalData.arrIdsInfo.find(k => k.idsNo == strIdsNo).cubicalData;
            var currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.Hmi == strHmi);

            var arrPortDetailForStart = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi)

            if (Number(arrPortDetailForStart.portNo) != Number(ProtocolPortNo)) {
                console.log('Invalid Port')
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid Port`)
            }

            var tempCailibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);


            var tempThickVal = 0;
            var tempDimenVal = 0;
            var tempHardVal = 0;
            var now = new Date();
            var actualProtocol = str_Protocol;
            var arrProtocol = [];
            var tempActualProtocol;

            tempActualProtocol = str_Protocol.split(':')[2].trim().split('\n')

            if (tempActualProtocol.length == 0) {
                console.log('INVALID STRING')
                // loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}Invalid String Received on Device ${strHmi}`)
                return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
            }

            // arrProtocol.push(actualProtocol);

            var arrHardness = []

            for (let sample of tempActualProtocol) {

                if (sample.length != 0) {

                    tempActualProtocol = sample.split(';')

                    if (tempActualProtocol.length != 3) {
                        console.log('INVALID STRING')
                        loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}Invalid String Received on Device ${strHmi}`)
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Received`)
                    }

                    tempThickVal = Number(tempActualProtocol[0].trim()) == '99999' ? 0 : parseFloat(tempActualProtocol[0].trim())
                    tempDimenVal = Number(tempActualProtocol[1].trim()) == '99999' ? 0 : parseFloat(tempActualProtocol[1].trim())
                    tempHardVal = Number(tempActualProtocol[2].trim()) == '99999' ? 0 : parseFloat(tempActualProtocol[2].trim())


                    if (isNaN(tempThickVal) || isNaN(tempDimenVal) || isNaN(tempHardVal) ||
                        tempThickVal <= 0 || tempDimenVal <= 0 || tempHardVal <= 0) {
                        console.log('INVALID STRING')
                        loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}Invalid String Recieved on Device ${strHmi}`)
                        return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Recieved`)
                    } else {
                        arrHardness.push({
                            tempThickVal: tempThickVal,
                            tempDimenVal: tempDimenVal,
                            tempHardVal: tempHardVal
                        })
                    }
                }
            }

            const __parameterHardness125Obj = {
                idsNo: strResberryPi,
                Hmi: strHmi,
                objHardness: arrHardness,
                // actualWt: arrProtocol,
                menuName: 'Hardness'
            }

            if (tempCailibType == undefined) {
                if (currentOpStatus == undefined) {
                    // loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
                    console.log('wt recieve without any api called');
                    return;
                } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {
                    await objHardness125.processHardnessData125(__parameterHardness125Obj);
                }
            } else {
                console.log('Hardeness 125 Parsing Error');
            }

        } catch (error) {
            throw new Error(error)
        }

    }

    async parsingHardnessData_SotaxMT50(dataObj) {
        let strProtocol;
        let HardID = dataObj.instrumentId;
        let ProtocolPortNo = dataObj.ProtocolPortNo;
        let strIdsNo = dataObj.strResberryPi;
        let strHmi = dataObj.strHmi;
        strProtocol = dataObj.str_Protocol.split("\n");
        let _stringChecking = strProtocol.toString().includes("@");
        let actualRecivedProtocol;
        let currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.Hmi == strHmi);
        let tempCailibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);
        let arrPortDetailForStart1 = await objHmi.idsPortSetting(strHmi)
        let intPortNo1 = arrPortDetailForStart1.Sys_PortNo;
        let strInstrumentType = arrPortDetailForStart1.Instrument_type;
        let strInstrumentId = arrPortDetailForStart1.Instrument_id;

        if (_stringChecking == true) {
            console.log('string is valid');
            if (strProtocol.indexOf("Values:") != -1) {
                actualRecivedProtocol = strProtocol[strProtocol.indexOf("Values:") + 1].trim();
            } else {
                actualRecivedProtocol = strProtocol[0].split(":")[2].trim();
            }
        } else {
            console.log('string comes till values or @ is not their in string')
        }


        const __parameterWeighmentObjMT50 = {
            idsNo: strIdsNo,
            Hmi: strHmi,
            actualWt: actualRecivedProtocol,
            // decPoint: ProtocolDecPoint,
            // unit: ProtocolUnit,
            instrumentId: strInstrumentId,
            instrumentType: strInstrumentType
        }

        if (intPortNo1 != ProtocolPortNo) {
            //log protocol in file
            loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}${strInstrumentType} ${strInstrumentId} connected with Port ${intPortNo1} must be used sended to device ${strHmi}`)
            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}${strInstrumentType} ${strInstrumentId} connected with Port ${intPortNo1} must be used`)
        }


        //decision making 
        if (tempCailibType == undefined) {
            if (currentOpStatus == undefined) {
                loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
                console.log('wt recieve without any api called');
                return;
            } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

                await objHardness125.processHardnessDataMT50(__parameterWeighmentObjMT50);
            }
        } else {
            console.log('Hardeness Mt50 Parsing Error');
        }

        //console.log(strProtocol);
    }


    /**
     * Parsing MT50 Direct
     * @returns 
     */
    async parsingHardnessMT50HTOHR(dataObj) {
        let strProtocol;
        let HardID = dataObj.instrumentId;
        let ProtocolPortNo = dataObj.ProtocolPortNo;
        let strIdsNo = dataObj.strResberryPi;
        let strHmi = dataObj.strHmi;
        strProtocol = dataObj.str_Protocol.split("\n");
        let _stringChecking = strProtocol.toString().includes("Meas. Values");
        let _stringCheckingForStatictics = strProtocol.toString().includes("Statistics");
        let actualRecivedProtocol;
        let currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.Hmi == strHmi);
        let tempCailibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);
        let arrPortDetailForStart1 = await objHmi.idsPortSetting(strHmi)
        let intPortNo1 = arrPortDetailForStart1.Sys_PortNo;
        let strInstrumentType = arrPortDetailForStart1.Instrument_type;
        let strInstrumentId = arrPortDetailForStart1.Instrument_id;
        let data, data_found;
        let arrOfHardnessValue = [];

        for (let i = 0; i < strProtocol.length; i++) {
            data = strProtocol[i].trim();
            if (data == "" || data == null)
                continue;
            if (data.search("Meas. Values") != -1) {
                data_found = true;
                continue;
            }
            if (data_found === true && data.search("Statistics") == -1) {

                let datavalue = data.split(":");
                arrOfHardnessValue.push({ datavalue });


            } else if (data.search("Statistics") != -1) {
                data_found = false;
            }
        }
        //console.log(arrOfHardnessValue);




        const __parameterWeighmentObjMT50 = {
            idsNo: strIdsNo,
            Hmi: strHmi,
            actualWt: arrOfHardnessValue,
            // decPoint: ProtocolDecPoint,
            // unit: ProtocolUnit,
            instrumentId: strInstrumentId,
            instrumentType: strInstrumentType
        }

        if (intPortNo1 != ProtocolPortNo) {
            //log protocol in file
            loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}${strInstrumentType} ${strInstrumentId} connected with Port ${intPortNo1} must be used sended to device ${strHmi}`)
            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}${strInstrumentType} ${strInstrumentId} connected with Port ${intPortNo1} must be used`)
        }


        //decision making 
        if (tempCailibType == undefined) {
            if (currentOpStatus == undefined) {
                loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
                console.log('wt recieve without any api called');
                return;
            } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

                await objHardness125.processHardnessMT50HTOHR(__parameterWeighmentObjMT50);
            }
        } else {
            console.log('Hardeness Mt50 Parsing Error');
        }

    }

    async parsingHardnessDrSchleuniger(dataObj) {
        let strProtocol;
        let HardID = dataObj.instrumentId;
        let ProtocolPortNo = dataObj.ProtocolPortNo;
        let strIdsNo = dataObj.strResberryPi;
        let strHmi = dataObj.strHmi;
        strProtocol = dataObj.str_Protocol.split('\n');
        let strProtocoltemp = dataObj.str_Protocol;
        let _stringChecking = strProtocoltemp.toString().includes("Hardness");
        let actualRecivedProtocol;
        let currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.Hmi == strHmi);
        let tempCailibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);
        let arrPortDetailForStart1 = await objHmi.idsPortSetting(strHmi)
        let intPortNo1 = arrPortDetailForStart1.Sys_PortNo;
        let strInstrumentType = arrPortDetailForStart1.Instrument_type;
        let strInstrumentId = arrPortDetailForStart1.Instrument_id;
        let data, data_found;
        var arrOfHardnessValue = [];
        var validSampleForstring = 1;
        var countN = 1;
        let checkFlag;
        if (_stringChecking == true) {
            for (let i = 0; i < strProtocol.length; i++) {
                data = strProtocol[i].trim();
                // console.log(data);
                if (data == "" || data == null)
                    continue;
                if (data.search("Valid Samples") != -1 && validSampleForstring == 1) {
                    validSampleForstring = validSampleForstring + 1;
                    continue;
                }

                else if (data.search("Valid Samples") != -1 && validSampleForstring == 2) {
                    data_found = true;
                    checkFlag = 2;
                }
                else if (validSampleForstring == 2 && checkFlag == 2 && data.search("Signature") == -1 && data_found == true
                ) {
                    let datavalue = data.replace(' ', ':');
                    arrOfHardnessValue.push({ datavalue });

                }

                else if (data.search("Signature") != -1) {
                    data_found = false;
                }
            }

            let filterData = arrOfHardnessValue.filter(empty => empty);
            let removeElementforN = filterData.shift();
            let arrOfObjHardnessData = filterData;

            const __parameterWeighmentObj8M = {
                idsNo: strIdsNo,
                Hmi: strHmi,
                actualWt: arrOfObjHardnessData,
                instrumentId: strInstrumentId,
                instrumentType: strInstrumentType
            }

            if (intPortNo1 != ProtocolPortNo) {
                //log protocol in file
                loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}${strInstrumentType} ${strInstrumentId} connected with Port ${intPortNo1} must be used sended to device ${strHmi}`)
                return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}${strInstrumentType} ${strInstrumentId} connected with Port ${intPortNo1} must be used`)
            }


            if (tempCailibType == undefined && arrOfObjHardnessData.length != 0) {
                if (currentOpStatus == undefined) {
                    loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
                    console.log('wt recieve without any api called');
                    return;
                } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

                    await objHardness125.processHardnessDrSchleuniger(__parameterWeighmentObj8M);
                }
            } else {
                console.log('DrSchleuniger string is not valid');
            }

        } else {
            console.log('DrSchleuniger string is not valid')
        }

        //check that hardness is their 2 times in a string 
        //if hardness exist in a string then parse the below incoming string.
    }



    //only hardness
    async parsingHardnessData_OnlyHardness(dataObj) {
        let strProtocol;
        let HardID = dataObj.instrumentId;
        let ProtocolPortNo = dataObj.ProtocolPortNo;
        let strIdsNo = dataObj.strResberryPi;
        let strHmi = dataObj.strHmi;
        strProtocol = dataObj.str_Protocol.split("\n");
        let _stringChecking = strProtocol.toString().includes("@");
        let actualRecivedProtocol;
        let currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.Hmi == strHmi);
        let tempCailibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);
        let arrPortDetailForStart1 = await objHmi.idsPortSetting(strHmi)
        let intPortNo1 = arrPortDetailForStart1.Sys_PortNo;
        let strInstrumentType = arrPortDetailForStart1.Instrument_type;
        let strInstrumentId = arrPortDetailForStart1.Instrument_id;

        if (_stringChecking == true) {
            console.log('string is valid');
            if (strProtocol.indexOf("Values:") != -1) {
                actualRecivedProtocol = strProtocol[strProtocol.indexOf("Values:") + 1].trim();
            } else {
                actualRecivedProtocol = strProtocol[0].split(":")[2].trim();
            }
        } else {
            console.log('string comes till values or @ is not their in string')
        }


        const __parameterWeighmentObjMT50 = {
            idsNo: strIdsNo,
            Hmi: strHmi,
            actualWt: actualRecivedProtocol,
            // decPoint: ProtocolDecPoint,
            // unit: ProtocolUnit,
            instrumentId: strInstrumentId,
            instrumentType: strInstrumentType
        }

        if (intPortNo1 != ProtocolPortNo) {
            //log protocol in file
            loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}${strInstrumentType} ${strInstrumentId} connected with Port ${intPortNo1} must be used sended to device ${strHmi}`)
            return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}${strInstrumentType} ${strInstrumentId} connected with Port ${intPortNo1} must be used`)
        }


        //decision making 
        if (tempCailibType == undefined) {
            if (currentOpStatus == undefined) {
                loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
                console.log('wt recieve without any api called');
                return;
            } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

                await objHardness125.processHardnessDataMT50OnlyHardnessData(__parameterWeighmentObjMT50);
            }
        } else {
            console.log('Hardeness Mt50 Parsing Error');
        }

        //console.log(strProtocol);
    }

}

module.exports = HardnessParsing;