const ClassweighmentData = require("../clsProcessWeighment.model");
const DailyCalibrationModel = require("../Calibration/clsdailyCalibration.model");
const ClassPeriodicCalibration = require("../Calibration/clsPeriodicCalibration.model");
const ClassEccenCalibration = require("../Calibration/clsEccentricity.model");
const RepeatabilityCalibrationModel = require("../Calibration/clsRepeatability.model");
const uncertinityCalibrationModel = require("../Calibration/clsUncertainty.model");
const classHmi = require("../hmiDetail.model");
const mqttProtocols = require("../../global/GLOBAL_NOMENCLATURE");
const loggers = require("../winstonLogger");
const globalData = require("../../global/globalData");
const clsMqttSender = require("../../model/Mqtt/mqttSender.class");
const GLOBAL_NOMENCLATURE = require("../../global/GLOBAL_NOMENCLATURE");
const serverConfig = require("../../global/serverConfig");
const { Console } = require("winston/lib/winston/transports");
const clsFriability = require("../Test/clsFriability.model");

const objWeighmentData = new ClassweighmentData();
const dailyCalibrationModel = new DailyCalibrationModel();
const periodiccalibrationModel = new ClassPeriodicCalibration();
const eccentricityCaibration = new ClassEccenCalibration();
const repetabilityCalibration = new RepeatabilityCalibrationModel();
const uncertinityCalibModel = new uncertinityCalibrationModel();
const objHmi = new classHmi();
const mqttSender = new clsMqttSender();
const objFriability = new clsFriability();

class FriabilityParsing {
  precision(a) {
    if (!isFinite(a)) return 0;
    var e = 1,
      p = 0;
    while (Math.round(a * e) / e !== a) {
      e *= 10;
      p++;
    }
    return p;
  }

  async parsingFriabilityData(dataObj) {
    try {
      let {
        str_Protocol,
        strResberryPi,
        strHmi,
        ProtocolPortNo,
        instrumentId,
        ProtocolName,
      } = dataObj;
      // let data,actualWtf,actualWts,ProtocolDecPoint1,ProtocolDecPoint2,ProtocolUnit1,ProtocolUnit2,
      // negativeWeightCheck1,negativeWeightCheck2,arrProtocolDataAndUnitfirstWt,arrProtocolDataAndUnitSecondWt,strInstrumentType,
      let data,
        weight_before_drum1,
        weight_before_drum2,
        weight_after_drum1,
        weight_after_drum2,
        friability_drum1,
        friability_drum2;
      let type;
      if (
        str_Protocol.search("DRUM-A") != -1 &&
        str_Protocol.search("DRUM-B") != -1
      ) {
        type = "Double";
      } else {
        type = "Single";
      }

      // let strInstrumentType;
      const arrCurrentOperation = globalData.arrCurrentOperationStatus.find(
        (k) => k.Hmi == strHmi
      );
      const arrCalibInProcess = globalData.arrcalibType.find(
        (k) => k.Hmi == strHmi
      );
      if (arrCurrentOperation != undefined) {
        const arrSelectedMenu = globalData.arrSelectedMenu.find(
          (k) => k.Hmi == strHmi
        );
        var intPortNo1 = arrSelectedMenu.portNo;
        var strInstrumentType = arrSelectedMenu.InstrumentType;
        var strInstrumentId = arrSelectedMenu.instrumentId;
      } else if (arrCalibInProcess != undefined) {
        let hmiDetails = globalData.arrSelectedBalWithHmi.find(
          (k) => k.Hmi == strHmi
        );
        var intPortNo1 = hmiDetails.portNo;
        var strInstrumentType = hmiDetails.InstrumentType;
        var strInstrumentId = hmiDetails.selectedBal;
      }
      let hmiDetailsInPMenu = globalData.arrIdsInfo.find(
        (k) => k.idsNo == strResberryPi
      ).cubicalData;
      let data_array, __parameterWeighmentObj;
      // currentOpStatus, tempCailibType, __parameterWeighmentObj;
      let drum_found = false;
      var weight_before_drum2_array;
      var friability_drum2_array;
      var weight_after_drum2_array;
      var actualCount;
      var actualRpm;
      var drum1, drum2, drum3, drum4, per1, per2;

      // if (serverConfig.friabilityType == "OF") {
      //data_array.slice(data_array.map(k=>k.trim()).findIndex(l=>l.includes("CALCULATIONS")))
      data_array = str_Protocol.split("\n");
      data_array = str_Protocol.split("\n");
      for (let i = 0; i < data_array.length; i++) {
        data = data_array[i].trim();
        if (data == "" || data == null) continue;
        if (data.search("DRUM-") != -1) {
          drum_found = true;
          continue;
        }
        if (drum_found === true && data.search("WEIGHT BEFORE TEST") != -1) {
          let weight_before_array = data.split("|");
          let weight_before_drum1_array = weight_before_array[0].split(":");
          if (weight_before_array[1] != undefined) {
            weight_before_drum2_array = weight_before_array[1].split(":");
          }
          weight_before_drum1 = weight_before_drum1_array[1].trim();
          drum1 = weight_before_drum1.split(/\s+/gi);
          // if(drum1.includes('gm')){
          if (
            isNaN(Number(drum1[0])) ||
            Number(drum1[0]) <= 0 ||
            (drum1[1] != "gm" && drum1[1] != "g")
          ) {
            return mqttSender.sendData(
              strHmi,
              `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`
            );
          }
          // }
          if (weight_before_array[1] != undefined) {
            weight_before_drum2 =
              weight_before_drum2_array[1] == undefined
                ? ""
                : weight_before_drum2_array[1].trim();
            if (weight_before_drum2_array[1] !== undefined){
            drum2 = weight_before_drum2.split(/\s+/gi);
            if (
              isNaN(Number(drum2[0])) ||
              Number(drum2[0]) <= 0 ||
              (drum2[1] !== "gm" && drum2[1] !== "g")
            ) {
              return mqttSender.sendData(
                strHmi,
                `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`
              );
            }
        }
            // // if(drum2.includes('gm')){
            //     if(drum2[0] == ''){
            //         return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`)
            //     }
            // }
          }
          console.log(
            `weight_before_drum1 : ${weight_before_drum1} ; weight_before_drum2 :  ${weight_before_drum2}`
          );
        } else if (
          drum_found === true &&
          data.search("WEIGHT AFTER TEST") != -1
        ) {
          let weight_after_array = data.split("|");
          let weight_after_drum1_array = weight_after_array[0].split(":");

          if (weight_after_array[1] != undefined) {
            weight_after_drum2_array = weight_after_array[1].split(":");
          }

          weight_after_drum1 = weight_after_drum1_array[1].trim();
          drum3 = weight_after_drum1.split(/\s+/gi);
          if (
            isNaN(Number(drum3[0])) ||
            Number(drum3[0]) <= 0 ||
            (drum3[1] != "gm" && drum3[1] != "g")
          ) {
            return mqttSender.sendData(
              strHmi,
              `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`
            );
          }

          if (weight_after_array[1] != undefined) {
            weight_after_drum2 =
              weight_after_drum2_array[1] == undefined
                ? ""
                : weight_after_drum2_array[1].trim();
            // drum4 = weight_after_drum2.split('gm')
            // if()
            if (weight_after_drum2_array[1] !== undefined) {
              drum4 = weight_after_drum2.split(/\s+/gi);
              if (
                isNaN(Number(drum4[0])) ||
                Number(drum4[0]) <= 0 ||
                (drum4[1] != "gm" &&
                  drum4[1] != "g")
              ) {
                return mqttSender.sendData(
                  strHmi,
                  `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`
                );
              }
            }
          }
          console.log(
            `weight_after_drum1 : ${weight_after_drum1} ; weight_after_drum2 : ${weight_after_drum2}`
          );
        } else if (drum_found === true && data.search("FRIABILITY") !== -1) {
          let friability_array = data.split("|");
          let friability_drum1_array = friability_array[0].split(":");
          if (friability_array[1] != undefined) {
            friability_drum2_array = friability_array[1].split(":");
          }
          friability_drum1 = friability_drum1_array[1].trim();
          let drum5 = friability_drum1.split(/\s+/gi)
          if (
            isNaN(Number(drum5[0])) ||
            Number(drum5[0]) < 0 
          ) {
            // return mqttSender.sendData(
            //   strHmi,
            //   `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`
            // );
          }
          if (friability_array[1] != undefined) {
            friability_drum2 =
              friability_drum2_array[1] == undefined
                ? ""
                : friability_drum2_array[1].trim();
            if (friability_drum2_array[1] !== undefined) {
              let drum6 = friability_drum2.split(/\s+/gi);
              if (
                isNaN(Number(drum6[0])) ||
                Number(drum6[0]) < 0 
              ) {
                // return mqttSender.sendData(
                //   strHmi,
                //   `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`
                // );
              }
            }
            // per2 = friability_drum2.split('%')
            // // if(per2.includes('%')){
            //     if(per2[0] == ''){
            //         return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`)
            //     }
            // }
          }
          console.log(
            `friability_drum1 : ${friability_drum1}; 2 : ${friability_drum2}`
          );
        } else {
          //console.log('invalid string recived');
        }
      }
      // for (let i = 0; i < data_array.length; i++) {
      //     data = data_array[i].trim();
      //     if (data == "" || data == null)
      //         continue;
      //     if (data.search("DRUM-") != -1) {
      //         drum_found = true;
      //         continue;
      //     }
      //     if (data.search('SET RPM') !== -1 || data.search('SET COUNT') !== -1){
      //         // var pattern = /^SET RPM(\s*)?:(\s*)?\d{1,}(\s*)?SET COUNT(\s*)?:(\s*)?\d{1,}(\s*)?$/i
      //         var pattern = /^(SET RPM|SET COUNT)(\s*)?:(\s*)?\d{1,}/i
      //         if (data.startsWith("SET COUNT") && actualCount !== undefined ||
      //             data.startsWith("SET RPM") && actualRpm !== undefined ||
      //             pattern.test(data) === undefined) return this.invalidMqttSendData(strHmi)
      //         var value = data.split(":")
      //             if(data.startsWith("SET RPM"))
      //             {actualRpm = Number(value[1].trim())
      //             if (actualRpm <= 0) return this.invalidMqttSendData(strHmi)}
      //             else{actualCount = Number(value[1].trim())
      //             if (actualCount <= 0) return this.invalidMqttSendData(strHmi)}
      //     }
      //     if (drum_found === true && (data.search("WGT BEFORE TEST") != -1)) {
      //         let weight_before_array = data.split("|");
      //         let weight_before_drum1_array = weight_before_array[0].split(":");
      //         if (weight_before_array[1] != undefined) {
      //             weight_before_drum2_array = weight_before_array[1].split(":");
      //         }
      //         weight_before_drum1 = weight_before_drum1_array[1].trim();
      //         if (weight_before_array[1] != undefined) {
      //             weight_before_drum2 = weight_before_drum2_array[1] == undefined ? '' : weight_before_drum2_array[1].trim();
      //         }
      //         console.log(`weight_before_drum1 : ${weight_before_drum1} ; weight_before_drum2 :  ${weight_before_drum2}`)
      //     }
      //     else if (drum_found === true && (data.search("WGT AFTER TEST") != -1)) {
      //         let weight_after_array = data.split("|");
      //         let weight_after_drum1_array = weight_after_array[0].split(":");
      //         if (weight_after_array[1] != undefined) {
      //             weight_after_drum2_array = weight_after_array[1].split(":");
      //         }
      //         weight_after_drum1 = weight_after_drum1_array[1].trim();
      //         if (weight_after_array[1] != undefined) {
      //             weight_after_drum2 = weight_after_drum2_array[1] == undefined ? '' : weight_after_drum2_array[1].trim();
      //         }
      //         console.log(`weight_after_drum1 : ${weight_after_drum1} ; weight_after_drum2 : ${weight_after_drum2}`)
      //     }
      //     else if (drum_found === true && data.search("FRIABILITY") != -1) {
      //         let friability_array = data.split("|");
      //         let friability_drum1_array = friability_array[0].split(":");
      //         if (friability_array[1] != undefined) {
      //             friability_drum2_array = friability_array[1].split(":");
      //         }
      //         friability_drum1 = Number(friability_drum1_array[1].slice(0,-1).trim());
      //         if (friability_array[1] != undefined) {
      //             friability_drum2 = friability_drum2_array[1] == undefined ? '' : Number(friability_drum2_array[1].slice(0,-1).trim());
      //         }
      //         console.log(`friability_drum1 : ${friability_drum1}; 2 : ${friability_drum2}`)
      //     }
      //     else {
      //         //console.log('invalid string recived');
      //     }
      // }
      //data = str_Protocol.search("DRUM-1")
      console.log(data);

      // }

      const setRpmRegex =
        /SET RPM(\s*)?:(\s*)?(\d+)(\s*)SET COUNT(\s*)?:(\s*)?(\d+)/gi;
      // const setCountRegex = /SET COUNT\s+:\s+(\d+)/gi;

      const setRpmMatch = str_Protocol.match(setRpmRegex);
      // const setCountMatch = str_Protocol.match(setCountRegex);

      if (!setRpmMatch) {
        return mqttSender.sendData(
          strHmi,
          `${mqttProtocols.DisplayMessage}Invalid String Recieved`
        );
      }

      if (setRpmMatch) {
        var actualRpmAndCount = setRpmMatch[0].split(":");

        actualRpm = actualRpmAndCount[1].split(/SET COUNT/gi)[0].trim();
        actualCount = actualRpmAndCount[2].trim();

        console.log(`SET RPM: ${actualRpm} SET COUNT: ${actualCount}`);
        if (isNaN(Number(actualRpm)) || isNaN(Number(actualCount)))
          return mqttSender.sendData(
            strHmi,
            `${mqttProtocols.DisplayMessage}Invalid String Recieved`
          );
        actualRpm = Number(actualRpm).toFixed();
        actualCount = Number(actualCount).toFixed();
      }

      // if (setCountMatch) {
      //      actualCount = setCountMatch[0];
      //     if( isNaN(Number(actualCount))) return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Recieved`)
      //     console.log(`SET COUNT: ${actualCount}`);
      //     actualCount = Number(actualCount).toFixed()
      // }

      __parameterWeighmentObj = {
        idsNo: strResberryPi,
        Hmi: strHmi,
        actualWtBeforeDrum1: weight_before_drum1,
        actualWtBeforeDrum2: weight_before_drum2,
        actualWtAfterDrum1: weight_after_drum1,
        actualWtAfterDrum2: weight_after_drum2,
        friability_drum1: friability_drum1,
        friability_drum2: friability_drum2,
        instrumentId: strInstrumentId,
        recived_string_type: type,
        actualCount,
        actualRpm,
      };

      let a = weight_before_drum1;
      let b = weight_before_drum2;
      let c = weight_after_drum1;
      let d = weight_after_drum2;

      weight_before_drum1 = weight_before_drum1.split(" "); //WBD1
      console.log(weight_after_drum1);
      // if (weight_before_drum1[0].endsWith('g') || weight_before_drum1[0].endsWith('gm') || weight_before_drum1[0].endsWith('mm') || weight_before_drum1[0].endsWith('kg')) {
      //     //log protocol in file
      //     loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`)
      //     return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`)
      // }

      if (
        weight_before_drum1 == undefined ||
        weight_before_drum1 == "" ||
        weight_before_drum1 == 0
      ) {
        //log protocol in file
        loggers.MqttProtocolLogger.info(
          `protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`
        );
        return mqttSender.sendData(
          strHmi,
          `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`
        );
      }
      if (
        weight_after_drum1 == undefined ||
        weight_after_drum1 == "" ||
        weight_after_drum1 == 0 ||
        weight_after_drum1.includes("gm") == false
      ) {
        //log protocol in file
        loggers.MqttProtocolLogger.info(
          `protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`
        );
        return mqttSender.sendData(
          strHmi,
          `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`
        );
      }
      // if (
      //   friability_drum1 == undefined ||
      //   friability_drum1 == "" ||
      //   friability_drum1 == 0 
      // ) {
      //   //log protocol in file
      //   loggers.MqttProtocolLogger.info(
      //     `protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`
      //   );
      //   return mqttSender.sendData(
      //     strHmi,
      //     `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`
      //   );
      // }
      if (hmiDetailsInPMenu.Sys_RotaryType == "Double") {
        if (
          weight_before_drum2 == undefined ||
          weight_before_drum2 == "" ||
          weight_before_drum2 == 0 ||
          weight_before_drum2.includes("gm") == false
        ) {
          //log protocol in file
          loggers.MqttProtocolLogger.info(
            `protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`
          );
          return mqttSender.sendData(
            strHmi,
            `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`
          );
        }
        if (
          weight_after_drum2 == undefined ||
          weight_after_drum2 == "" ||
          weight_after_drum2 == 0 ||
          weight_after_drum2.includes("gm") == false
        ) {
          //log protocol in file
          loggers.MqttProtocolLogger.info(
            `protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`
          );
          return mqttSender.sendData(
            strHmi,
            `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`
          );
        }
        // if (
        //   friability_drum2 == undefined ||
        //   friability_drum2 == "" ||
        //   friability_drum2 == 0 
        // ) {
        //   //log protocol in file
        //   loggers.MqttProtocolLogger.info(
        //     `protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`
        //   );
        //   return mqttSender.sendData(
        //     strHmi,
        //     `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`
        //   );
        // }
      }

      if (data_array !== "") {
        if (weight_before_drum1.length < 1 || weight_before_drum1[1] == "") {
          //log protocol in file
          loggers.MqttProtocolLogger.info(
            `protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`
          );
          return mqttSender.sendData(
            strHmi,
            `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`
          );
        }

        if (weight_before_drum1[1] === "A") {
          return;
        } else {
          if (strInstrumentType == GLOBAL_NOMENCLATURE.FriabilatorMenu) {
            if (weight_before_drum1[1] == undefined) {
              weight_before_drum1[1] =
                weight_before_drum1[1] == undefined
                  ? "g"
                  : weight_before_drum1[1];
            } else {
              if (
                weight_before_drum1[1] != "g" &&
                weight_before_drum1[1] != "kg" &&
                weight_before_drum1[1] != "mg" &&
                weight_before_drum1[1] != "gm"
              ) {
                //log protocol in file
                loggers.MqttProtocolLogger.info(
                  `protocol : ${mqttProtocols.DisplayMessage}Invalid Data String sended to device ${strHmi}`
                );
                return mqttSender.sendData(
                  strHmi,
                  `${mqttProtocols.DisplayMessage}Invalid Data String`
                );
              } else {
                // if (ProtocolUnit1 == "mg") {
                //     actualWt = actualWt / 1000;
                // } else if (ProtocolUnit == ("kg" || "Kg" || "KG")) {
                //     actualWt = actualWt * 1000;
                // }
                // ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;
                console.log("convert unit if needed");
              }
            }
          } else {
            //log protocol in file
            loggers.MqttProtocolLogger.info(`unknown instrument`);
            console.log("unknown instrument");
          }

          //decision making
          if (arrCalibInProcess == undefined) {
            if (arrCurrentOperation == undefined) {
              loggers.MqttProtocolLogger.info(
                `Weight recieve without any api called`
              );
              console.log("wt recieve without any api called");
              return;
            } else if (
              arrCurrentOperation.Weighment == 1 &&
              arrCurrentOperation.testType == "Weighment"
            ) {
              await objWeighmentData.ParsingTestData(__parameterWeighmentObj);
            }
          } else {
            console.log("calibration will not do here");
          }
        }
      }
    } catch (error) {
      throw new Error(error);
    }
  }

  // async parsingFriabilityData(dataObj) {
  //     try {
  //         let { str_Protocol, strResberryPi, strHmi, ProtocolPortNo, instrumentId, ProtocolName } = dataObj;
  //         // let data,actualWtf,actualWts,ProtocolDecPoint1,ProtocolDecPoint2,ProtocolUnit1,ProtocolUnit2,
  //         // negativeWeightCheck1,negativeWeightCheck2,arrProtocolDataAndUnitfirstWt,arrProtocolDataAndUnitSecondWt,strInstrumentType,
  //         let data, weight_before_drum1, weight_before_drum2, weight_after_drum1, weight_after_drum2, friability_drum1, friability_drum2;
  //         let type;
  //         if (str_Protocol.search("DRUM-1") != -1 && str_Protocol.search("DRUM-2") != -1) {
  //             type = 'Double';
  //         }
  //         else {
  //             type = 'Single'
  //         }

  //         let strInstrumentType;
  //         let arrPortDetailForStart1 = await objHmi.idsPortSetting(strHmi)
  //         let intPortNo1 = arrPortDetailForStart1.Sys_PortNo;
  //         strInstrumentType = arrPortDetailForStart1.Instrument_type;
  //         let strInstrumentId = arrPortDetailForStart1.Instrument_id;
  //         let currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.Hmi == strHmi);
  //         let tempCailibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);
  //         let data_array, __parameterWeighmentObj;
  //         // currentOpStatus, tempCailibType, __parameterWeighmentObj;
  //         let drum_found = false;
  //         if (serverConfig.friabilityType == "OF") {

  //             data_array = str_Protocol.split("\n");
  //             for (let i = 0; i < data_array.length; i++) {
  //                 data = data_array[i].trim();
  //                 if (data == "" || data == null)
  //                     continue;
  //                 if (data.search("DRUM-1") != -1) {
  //                     drum_found = true;
  //                     continue;
  //                 }
  //                 if (drum_found === true && data.search("WEIGHT BEFORE TEST") != -1) {
  //                     let weight_before_array = data.split("|");
  //                     let weight_before_drum1_array = weight_before_array[0].split(":");
  //                     let weight_before_drum2_array = weight_before_array[1].split(":");
  //                     weight_before_drum1 = weight_before_drum1_array[1].trim();
  //                     weight_before_drum2 = weight_before_drum2_array[1] == undefined ? '' : weight_before_drum2_array[1].trim();
  //                     console.log(`weight_before_drum1 : ${weight_before_drum1} ; weight_before_drum2 :  ${weight_before_drum2}`)
  //                 }
  //                 else if (drum_found === true && data.search("WEIGHT AFTER TEST") != -1) {
  //                     let weight_after_array = data.split("|");
  //                     let weight_after_drum1_array = weight_after_array[0].split(":");
  //                     let weight_after_drum2_array = weight_after_array[1].split(":");
  //                     weight_after_drum1 = weight_after_drum1_array[1].trim();
  //                     weight_after_drum2 = weight_after_drum2_array[1] == undefined ? '' : weight_after_drum2_array[1].trim();
  //                     console.log(`weight_after_drum1 : ${weight_after_drum1} ; weight_after_drum2 : ${weight_after_drum2}`)
  //                 }
  //                 else if (drum_found === true && data.search("FRIABILITY") != -1) {
  //                     let friability_array = data.split("|");
  //                     let friability_drum1_array = friability_array[0].split(":");
  //                     let friability_drum2_array = friability_array[1].split(":");

  //                     friability_drum1 = friability_drum1_array[1].trim();
  //                     friability_drum2 = friability_drum2_array[1] == undefined ? '' : friability_drum2_array[1].trim();
  //                     console.log(`friability_drum1 : ${friability_drum1}; 2 : ${friability_drum2}`)
  //                 }
  //                 else {
  //                     //console.log('invalid string recived');
  //                 }
  //             }
  //             //data = str_Protocol.search("DRUM-1")
  //             console.log(data);

  //         }

  //         __parameterWeighmentObj = {
  //             idsNo: strResberryPi,
  //             Hmi: strHmi,
  //             actualWtBeforeDrum1: weight_before_drum1,
  //             actualWtBeforeDrum2: weight_before_drum2,
  //             actualWtAfterDrum1: weight_after_drum1,
  //             actualWtAfterDrum2: weight_after_drum2,
  //             instrumentId: strInstrumentId,
  //             recived_string_type: type
  //         }

  //         let a = weight_before_drum1;
  //         let b = weight_before_drum2;
  //         let c = weight_after_drum1;
  //         let d = weight_after_drum2;

  //         weight_before_drum1 = weight_before_drum1.split(' '); //WBD1
  //         console.log(weight_after_drum1)
  //         if (weight_before_drum1[0].endsWith('g') || weight_before_drum1[0].endsWith('mm') || weight_before_drum1[0].endsWith('kg')) {
  //             //log protocol in file
  //             loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`)
  //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`)
  //         }

  //         if (Number(weight_before_drum1[0]) == (undefined || "NaN" || 0 || NaN) ||
  //             ProtocolPortNo == undefined || ProtocolPortNo == "" || data_array == "") {

  //             //log protocol in file
  //             loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`)
  //             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`)
  //         }

  //         if (data_array !== "") {
  //             if (weight_before_drum1.length < 1 || weight_before_drum1[1] == "") {
  //                 //log protocol in file
  //                 loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`)
  //                 return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`);
  //             }

  //             if (weight_before_drum1[1] === "A") {
  //                 return;
  //             } else {
  //                 if (strInstrumentType == GLOBAL_NOMENCLATURE.Friability) {
  //                     if (weight_before_drum1[1] == undefined) {
  //                         weight_before_drum1[1] = weight_before_drum1[1] == undefined ? "g" : weight_before_drum1[1];
  //                     } else {
  //                         if ((weight_before_drum1[1] != "g") && (weight_before_drum1[1] != "kg") && (weight_before_drum1[1] != "mg")) {
  //                             //log protocol in file
  //                             loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}Invalid Data String sended to device ${strHmi}`)
  //                             return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid Data String`);
  //                         } else {
  //                             // if (ProtocolUnit1 == "mg") {
  //                             //     actualWt = actualWt / 1000;
  //                             // } else if (ProtocolUnit == ("kg" || "Kg" || "KG")) {
  //                             //     actualWt = actualWt * 1000;
  //                             // }
  //                             // ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;
  //                             console.log('convert unit if needed');

  //                         }
  //                     }

  //                 } else {
  //                     //log protocol in file
  //                     loggers.MqttProtocolLogger.info(`unknown instrument`)
  //                     console.log('unknown instrument');
  //                 }

  //                 //decision making
  //                 if (tempCailibType == undefined) {
  //                     if (currentOpStatus == undefined) {
  //                         loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
  //                         console.log('wt recieve without any api called');
  //                         return;
  //                     } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

  //                         await objWeighmentData.ParsingTestData(__parameterWeighmentObj);
  //                     }
  //                 } else {
  //                     console.log('calibration will not do here')
  //                 }
  //             }
  //         }
  //     } catch (error) {
  //         throw new Error(error)
  //     }
  // }

  async parsingFriabilityBFBO(dataObj) {
    try {
      let {
        str_Protocol,
        strResberryPi,
        strHmi,
        ProtocolPortNo,
        instrumentId,
        ProtocolName,
      } = dataObj;
      let strInstrumentType;
      let arrPortDetailForStart1 = await objHmi.idsPortSetting(strHmi);
      let intPortNo1 = arrPortDetailForStart1.Sys_PortNo;
      strInstrumentType = arrPortDetailForStart1.Instrument_type;
      let strInstrumentId = arrPortDetailForStart1.Instrument_id;
      let currentOpStatus = globalData.arrCurrentOperationStatus.find(
        (k) => k.Hmi == strHmi
      );
      let tempCailibType = globalData.arrcalibType.find((k) => k.Hmi == strHmi);
      let data_array, __parameterWeighmentObj, data, strRpm, strCount;
      let flag = false;

      data_array = str_Protocol.split("\n");
      for (let i = 0; i < data_array.length; i++) {
        data = data_array[i].trim();
        if (data == "" || data == null) continue;

        if (data.search("SET RPM") != -1) {
          flag = true;
          if (data.search("SET RPM") != -1 && data.search("SET COUNT") != -1) {
            let removeRpm = data
              .slice(0, data.indexOf("SET COUNT") - 1)
              .trim()
              .split(":");
            strRpm = removeRpm[1].trim();
            let removedCount = data
              .slice(data.indexOf("SET COUNT"))
              .trim()
              .split(":");
            strCount = removedCount[1].trim();
          } else {
            let removeRpm = data.split(":");
            strRpm = removeRpm[1].trim();
          }
        } else if (data.search("SET COUNT") != -1) {
          flag = true;
          let removedCount = data.split(":");
          strCount = removedCount[1].trim();
        }
      }

      __parameterWeighmentObj = {
        idsNo: strResberryPi,
        Hmi: strHmi,
        rpm: strRpm,
        rpmCount: strCount,
        instrumentId: strInstrumentId,
      };

      let checkStatus = globalData.arrFriGetRpmCout.find(
        (k) => k.idsNo == strResberryPi
      );
      if (checkStatus == undefined) {
        globalData.arrFriGetRpmCout.push({
          idsNo: strResberryPi,
          rpm: strRpm,
          rpmcount: strCount,
          flag: flag,
        });
      } else {
        checkStatus.rpm = strRpm;
        checkStatus.rpmcount = strCount;
        checkStatus.flag = flag;
      }

      if (flag == true) {
        if (strInstrumentType == GLOBAL_NOMENCLATURE.FriabilatorMenu) {
          if (
            strCount == " " &&
            strRpm == " " &&
            strRpm == undefined &&
            strCount == undefined
          ) {
            //log protocol in file
            loggers.MqttProtocolLogger.info(
              `protocol : ${mqttProtocols.DisplayMessage}Invalid Data String sended to device ${strHmi}`
            );
            return mqttSender.sendData(
              strHmi,
              `${mqttProtocols.DisplayMessage}Invalid Data String`
            );
          }
        } else {
          //log protocol in file
          loggers.MqttProtocolLogger.info(`unknown instrument`);
          console.log("unknown instrument");
        }

        //decision making
        if (tempCailibType == undefined) {
          if (currentOpStatus == undefined) {
            loggers.MqttProtocolLogger.info(
              `Weight recieve without any api called`
            );
            console.log("wt recieve without any api called");
            return;
          } else if (
            currentOpStatus.Weighment == 1 &&
            currentOpStatus.testType == "Weighment"
          ) {
            await objFriability.insertBulkFriabilityComb(
              __parameterWeighmentObj
            );
          }
        } else {
          console.log("calibration will not do here");
        }
      }
    } catch (error) {
      throw new Error(error);
    }
  }

  invalidMqttSendData(strHmi) {
    return mqttSender.sendData(
      strHmi,
      `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`
    );
  }
}

module.exports = FriabilityParsing;
