const moment = require('moment');
const date = require('date-and-time');
const ClassweighmentData = require('../clsProcessWeighment.model');
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const classHmi = require('../hmiDetail.model');
const mqttProtocols = require('../../global/GLOBAL_NOMENCLATURE');
const loggers = require('../winstonLogger');
const globalData = require('../../global/globalData');
const clsMqttSender = require('../Mqtt/mqttSender.class');
const GLOBAL_NOMENCLATURE = require('../../global/GLOBAL_NOMENCLATURE');
const clsMenuRequest = require('../Menu/MenuRequest.model');

const objWeighmentData = new ClassweighmentData();
const models = require('../../../config/dbConnection').models;
const objHmi = new classHmi();
const mqttSender = new clsMqttSender();
const objMenuRequest = new clsMenuRequest();

class FriabilityParsing {

    precision(a) {
        if (!isFinite(a)) return 0;
        var e = 1, p = 0;
        while (Math.round(a * e) / e !== a) { e *= 10; p++; }
        return p;
    }

    async parsingDTData(dataObj) {
        try {
            var { str_Protocol, strResberryPi, strHmi, ProtocolPortNo, InstrumentId, ProtocolName } = dataObj;
            //const EQUIP_MODEL_NAME = await this.getDetailOfBulkInstrumentModel(instrumentId);
            var DTInfo = await this.getDetailOfBulkInstrumentModel(InstrumentId, "Disintegration Tester");

            var DTModel = DTInfo.Eqp_Model

            var currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.Hmi == strHmi)
            var tempCailibType = globalData.arrcalibType.find(k => k.Hmi == strHmi)

            var arrPortDetailForStart = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi)

            if (Number(arrPortDetailForStart.portNo) != Number(ProtocolPortNo)) {
                console.log('Invalid Port')
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid Port`)
            }

            var result;
            if (DTModel == 'Labindia' || DTModel == 'Labindia-1000P') {
                await this.parseBulkWeighmentDTLabIndia(dataObj, DTInfo)
                return;
            } else if (DTModel == 'Electrolab') {
                await this.parseBulkWeighmentDTLabIndia(dataObj, DTInfo)
                return
            } else if (DTModel == 'Electrolab-ED3PO' || DTModel == 'ED 3PO') {
                await this.parseBulkWeighmentDTED3PO(dataObj, DTInfo);
                return
            } else if (DTModel == 'EDI-2SA') {
                await this.parseBulkWeighmentDT(dataObj, DTInfo)
                return
            }

            // if (result == false) return await this.invalidDataString(strHmi)

            // const __parameterWeighmentObj = {
            //     idsNo: strResberryPi,
            //     Hmi: strHmi,
            //     actualWt: result,
            //     // instrumentId: strInstrumentId,
            //     model: DTInfo
            // }

            // if (tempCailibType == undefined) {
            //     if (currentOpStatus == undefined) {

            //         console.log('wt recieve without any api called');
            //         return;
            //     } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

            //         await objWeighmentData.ParsingTestData(__parameterWeighmentObj);
            //     }
            // } else {
            //     console.log('calibration is on and dt weighment part has clash')
            // }

            return

        } catch (error) {
            throw new Error(error)
        }
    }

    async parseBulkWeighmentDTLabIndia(dataObj, DTModel) {
        try {
            let { str_Protocol, strResberryPi, strHmi, ProtocolPortNo, instrumentId, ProtocolName } = dataObj;
            //here also different balance have different parsing logic
            var Instrumenttype = DTModel.Eqp_Make
            Instrumenttype = Instrumenttype.toLowerCase();
            let data_array = str_Protocol.split("\n");
            let data = str_Protocol.split(":")[2].trim();
            let arm_found = false;
            let startTimeFound = false;
            let basketRackFound = true;
            let test_duration_found = false;
            let basket_A_Found = false;
            let basket_B_Found = false;
            let arr = [];
            for (let i = 0; i < data_array.length; i++) {
                data = data_array[i].trim();
                if (data == "" || data == null)
                    continue;
                // if(data.search("Model No") != -1) {
                //     let ModelNo = data.slice(data.search('Model No'));
                //      ModelNo = ModelNo.split(':')[1].trim()
                //      ModelNo = ModelNo.split(' ')[0]
                //      ModelNo = ModelNo.toLowerCase();
                //      if(ModelNo != Instrumenttype){
                //         return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String recieved`)
                //      }
                // }
                if (data.search("Run Date & Time") != -1) {
                    let runDateArr = data.split('Run Date & Time:');
                    runDateArr = runDateArr[1].trim().split(' ').filter(k => k)
                    let startDate = runDateArr[0];
                    let time = runDateArr[1]
                    arr.push({ Start_Date: startDate, time: time });
                    // arm_found = true;
                    continue;
                }
                if (data.search("BASKET RACK") != -1) {
                    // let startDateArr = data.slice(data.search('Start Date'));\
                    // let startDate = startDateArr.split(':')[1].trim()
                    // arr.push({ Start_Date: startDate });
                    basketRackFound = true;
                    let a = data.split("BASKET RACK").filter(k => k).length;
                    if (a > 1) {
                        basket_A_Found = true
                        basket_B_Found = true
                    } else {
                        let basketinString = data.split("BASKET RACK")[1].trim()
                        if (basketinString == 'A') {
                            basket_A_Found = true
                        } else {
                            basket_B_Found = true
                        }
                    }
                    arr[0]['BasketA'] = basket_A_Found
                    arr[0]['BasketB'] = basket_B_Found
                    continue
                }
                if (basketRackFound && data.startsWith("00:00:00")) {
                    // var startTime_array = data.split("|");
                    // var start_time_Jar_A = startTime_array[1].trim();   
                    // var start_time_Jar_B = startTime_array[2].trim();

                    if (basket_A_Found && basket_B_Found) {
                        arr[0]['Jar_A_minTemp'] = data.split(' ').filter(k => k)[1];
                        arr[0]['Jar_B_minTemp'] = data.split(' ').filter(k => k)[3];
                    } else if (basket_A_Found) {
                        arr[0]['Jar_A_minTemp'] = data.split(' ').filter(k => k)[1];
                        arr[0]['Jar_B_minTemp'] = '';
                    } else if (basket_B_Found) {
                        arr[0]['Jar_A_minTemp'] = '';
                        arr[0]['Jar_B_minTemp'] = data.split(' ').filter(k => k)[1];
                    } else {
                        console.log('ddd')
                    }

                    // arr.push({ 'start_time_Jar_A': start_time_Jar_A, 'start_time_Jar_B': start_time_Jar_B })


                    test_duration_found = true;

                    continue;
                } else if (basketRackFound && data.startsWith("Bath Temp")) {
                    //Test_furation_found = true;
                    var Bath_Temp = data.split(':').filter(k => k);
                    Bath_Temp = Bath_Temp[1].trim()

                    var BathTemp = Bath_Temp


                    arr[0]['BathTemp'] = BathTemp;
                    console.log(data)
                    continue;
                } else if (basketRackFound && data.startsWith("Apparatus Type")) {
                    //Test_furation_found = true;
                    var Apparatus_Type = data.split(':').filter(k => k);
                    Apparatus_Type = Apparatus_Type[1].trim().split(' ')[1]

                    var Apparatus_Type = Apparatus_Type


                    arr[0]['ApparatusType'] = Apparatus_Type;
                    console.log(data)
                    continue;
                }
                else if (basketRackFound && data.startsWith("Program No.")) {
                    //Test_furation_found = true;
                    var Program_No = data.split(':').filter(k => k);
                    Program_No = Program_No[1].trim()

                    var Program_No = Program_No


                    arr[0]['Program_No'] = Program_No;
                    console.log(data)
                    continue;
                }
                else if (basketRackFound && data.startsWith("Media Temp")) {
                    //Test_furation_found = true;
                    var Media_Temp = data.split(':').filter(k => k);
                    Media_Temp = Media_Temp[1].trim()

                    var Media_Temp = Media_Temp


                    arr[0]['MediaTemp'] = Media_Temp;
                    console.log(data)
                    continue;
                }
                else if (basketRackFound && data.startsWith("01")) {
                    //Test_furation_found = true;
                    let firstSampleArr = data.split('01').filter(k => k)
                    if (firstSampleArr.length > 1) {
                        var firstSampleLHSArr = firstSampleArr[0].split(' ').filter(k => k);
                        var firstSampleLHS = firstSampleLHSArr[0].trim();
                        var firstSampleLHSTemp = firstSampleLHSArr[1].trim();
                        var firstSampleRHSArr = firstSampleArr[1].split(' ').filter(k => k);
                        var firstSampleRHS = firstSampleRHSArr[0].trim();
                        var firstSampleRHSTemp = firstSampleRHSArr[1].trim();
                    } else {
                        firstSampleLHSArr = firstSampleArr[0].split(' ').filter(k => k);
                        var firstSampleLHS = firstSampleLHSArr[0].trim();
                        var firstSampleLHSTemp = firstSampleLHSArr[1].trim();
                    }
                    if (arr[0].BasketA && arr[0].BasketB) {
                        arr[0]['1_SampleLHS'] = firstSampleLHS;
                        arr[0]['1_SampleLHSTemp'] = firstSampleLHSTemp;
                        arr[0]["1_SampleRHS"] = firstSampleRHS == undefined ? "" : firstSampleRHS;
                        arr[0]["1_SampleRHSTemp"] = firstSampleRHSTemp == undefined ? "" : firstSampleRHSTemp;
                    } else if (arr[0].BasketA) {
                        arr[0]['1_SampleLHS'] = firstSampleLHS == undefined ? "" : firstSampleLHS;
                        arr[0]['1_SampleLHSTemp'] = firstSampleLHSTemp == undefined ? "" : firstSampleLHSTemp;
                        arr[0]["1_SampleRHS"] = "";
                        arr[0]["1_SampleRHSTemp"] = "";
                    } else if (arr[0].BasketB) {
                        arr[0]['1_SampleRHS'] = firstSampleLHS == undefined ? "" : firstSampleLHS;
                        arr[0]['1_SampleRHSTemp'] = firstSampleLHSTemp == undefined ? "" : firstSampleLHSTemp;
                        arr[0]["1_SampleLHS"] = "";
                        arr[0]["1_SampleLHSTemp"] = "";
                    }
                    console.log(data)
                    continue;
                }
                else if (basketRackFound && data.startsWith("02")) {
                    //Test_furation_found = true;
                    let firstSampleArr = data.split('02').filter(k => k)
                    if (firstSampleArr.length > 1) {
                        var firstSampleLHSArr = firstSampleArr[0].split(' ').filter(k => k);
                        var firstSampleLHS = firstSampleLHSArr[0].trim();
                        var firstSampleLHSTemp = firstSampleLHSArr[1].trim();
                        var firstSampleRHSArr = firstSampleArr[1].split(' ').filter(k => k);
                        var firstSampleRHS = firstSampleRHSArr[0].trim();
                        var firstSampleRHSTemp = firstSampleRHSArr[1].trim();
                    } else {
                        firstSampleLHSArr = firstSampleArr[0].split(' ').filter(k => k);
                        var firstSampleLHS = firstSampleLHSArr[0].trim();
                        var firstSampleLHSTemp = firstSampleLHSArr[1].trim();
                    }
                    if (arr[0].BasketA && arr[0].BasketB) {
                        arr[0]['2_SampleLHS'] = firstSampleLHS;
                        arr[0]['2_SampleLHSTemp'] = firstSampleLHSTemp;
                        arr[0]["2_SampleRHS"] = firstSampleRHS == undefined ? "" : firstSampleRHS;
                        arr[0]["2_SampleRHSTemp"] = firstSampleRHSTemp == undefined ? "" : firstSampleRHSTemp;
                    } else if (arr[0].BasketA) {
                        arr[0]['2_SampleLHS'] = firstSampleLHS == undefined ? "" : firstSampleLHS;
                        arr[0]['2_SampleLHSTemp'] = firstSampleLHSTemp == undefined ? "" : firstSampleLHSTemp;
                        arr[0]["2_SampleRHS"] = "";
                        arr[0]["2_SampleRHSTemp"] = "";
                    } else if (arr[0].BasketB) {
                        arr[0]['2_SampleRHS'] = firstSampleLHS == undefined ? "" : firstSampleLHS;
                        arr[0]['2_SampleRHSTemp'] = firstSampleLHSTemp == undefined ? "" : firstSampleLHSTemp;
                        arr[0]["2_SampleLHS"] = "";
                        arr[0]["2_SampleLHSTemp"] = "";
                    }
                    console.log(data)
                    continue;
                } else if (basketRackFound && data.startsWith("03")) {
                    let firstSampleArr = data.split('03').filter(k => k)
                    if (firstSampleArr.length > 1) {
                        var firstSampleLHSArr = firstSampleArr[0].split(' ').filter(k => k);
                        var firstSampleLHS = firstSampleLHSArr[0].trim();
                        var firstSampleLHSTemp = firstSampleLHSArr[1].trim();
                        var firstSampleRHSArr = firstSampleArr[1].split(' ').filter(k => k);
                        var firstSampleRHS = firstSampleRHSArr[0].trim();
                        var firstSampleRHSTemp = firstSampleRHSArr[1].trim();
                    } else {
                        firstSampleLHSArr = firstSampleArr[0].split(' ').filter(k => k);
                        var firstSampleLHS = firstSampleLHSArr[0].trim();
                        var firstSampleLHSTemp = firstSampleLHSArr[1].trim();
                    }
                    if (arr[0].BasketA && arr[0].BasketB) {
                        arr[0]['3_SampleLHS'] = firstSampleLHS;
                        arr[0]['3_SampleLHSTemp'] = firstSampleLHSTemp;
                        arr[0]["3_SampleRHS"] = firstSampleRHS == undefined ? "" : firstSampleRHS;
                        arr[0]["3_SampleRHSTemp"] = firstSampleRHSTemp == undefined ? "" : firstSampleRHSTemp;
                    } else if (arr[0].BasketA) {
                        arr[0]['3_SampleLHS'] = firstSampleLHS == undefined ? "" : firstSampleLHS;
                        arr[0]['3_SampleLHSTemp'] = firstSampleLHSTemp == undefined ? "" : firstSampleLHSTemp;
                        arr[0]["3_SampleRHS"] = "";
                        arr[0]["3_SampleRHSTemp"] = "";
                    } else if (arr[0].BasketB) {
                        arr[0]['3_SampleRHS'] = firstSampleLHS == undefined ? "" : firstSampleLHS;
                        arr[0]['3_SampleRHSTemp'] = firstSampleLHSTemp == undefined ? "" : firstSampleLHSTemp;
                        arr[0]["3_SampleLHS"] = "";
                        arr[0]["3_SampleLHSTemp"] = "";
                    }
                    console.log(data)
                    continue;
                } else if (basketRackFound && data.startsWith("04")) {
                    let firstSampleArr = data.split('04').filter(k => k)
                    if (firstSampleArr.length > 1) {
                        var firstSampleLHSArr = firstSampleArr[0].split(' ').filter(k => k);
                        var firstSampleLHS = firstSampleLHSArr[0].trim();
                        var firstSampleLHSTemp = firstSampleLHSArr[1].trim();
                        var firstSampleRHSArr = firstSampleArr[1].split(' ').filter(k => k);
                        var firstSampleRHS = firstSampleRHSArr[0].trim();
                        var firstSampleRHSTemp = firstSampleRHSArr[1].trim();
                    } else {
                        firstSampleLHSArr = firstSampleArr[0].split(' ').filter(k => k);
                        var firstSampleLHS = firstSampleLHSArr[0].trim();
                        var firstSampleLHSTemp = firstSampleLHSArr[1].trim();
                    }
                    if (arr[0].BasketA && arr[0].BasketB) {
                        arr[0]['4_SampleLHS'] = firstSampleLHS;
                        arr[0]['4_SampleLHSTemp'] = firstSampleLHSTemp;
                        arr[0]["4_SampleRHS"] = firstSampleRHS == undefined ? "" : firstSampleRHS;
                        arr[0]["4_SampleRHSTemp"] = firstSampleRHSTemp == undefined ? "" : firstSampleRHSTemp;
                    } else if (arr[0].BasketA) {
                        arr[0]['4_SampleLHS'] = firstSampleLHS == undefined ? "" : firstSampleLHS;
                        arr[0]['4_SampleLHSTemp'] = firstSampleLHSTemp == undefined ? "" : firstSampleLHSTemp;
                        arr[0]["4_SampleRHS"] = "";
                        arr[0]["4_SampleRHSTemp"] = "";
                    } else if (arr[0].BasketB) {
                        arr[0]['4_SampleRHS'] = firstSampleLHS == undefined ? "" : firstSampleLHS;
                        arr[0]['4_SampleRHSTemp'] = firstSampleLHSTemp == undefined ? "" : firstSampleLHSTemp;
                        arr[0]["4_SampleLHS"] = "";
                        arr[0]["4_SampleLHSTemp"] = "";
                    }
                    console.log(data)
                    continue;
                } else if (basketRackFound && data.startsWith("05")) {
                    let firstSampleArr = data.split('05').filter(k => k)
                    if (firstSampleArr.length > 1) {
                        var firstSampleLHSArr = firstSampleArr[0].split(' ').filter(k => k);
                        var firstSampleLHS = firstSampleLHSArr[0].trim();
                        var firstSampleLHSTemp = firstSampleLHSArr[1].trim();
                        var firstSampleRHSArr = firstSampleArr[1].split(' ').filter(k => k);
                        var firstSampleRHS = firstSampleRHSArr[0].trim();
                        var firstSampleRHSTemp = firstSampleRHSArr[1].trim();
                    } else {
                        firstSampleLHSArr = firstSampleArr[0].split(' ').filter(k => k);
                        var firstSampleLHS = firstSampleLHSArr[0].trim();
                        var firstSampleLHSTemp = firstSampleLHSArr[1].trim();
                    }
                    if (arr[0].BasketA && arr[0].BasketB) {
                        arr[0]['5_SampleLHS'] = firstSampleLHS;
                        arr[0]['5_SampleLHSTemp'] = firstSampleLHSTemp;
                        arr[0]["5_SampleRHS"] = firstSampleRHS == undefined ? "" : firstSampleRHS;
                        arr[0]["5_SampleRHSTemp"] = firstSampleRHSTemp == undefined ? "" : firstSampleRHSTemp;
                    } else if (arr[0].BasketA) {
                        arr[0]['5_SampleLHS'] = firstSampleLHS == undefined ? "" : firstSampleLHS;
                        arr[0]['5_SampleLHSTemp'] = firstSampleLHSTemp == undefined ? "" : firstSampleLHSTemp;
                        arr[0]["5_SampleRHS"] = "";
                        arr[0]["5_SampleRHSTemp"] = "";
                    } else if (arr[0].BasketB) {
                        arr[0]['5_SampleRHS'] = firstSampleLHS == undefined ? "" : firstSampleLHS;
                        arr[0]['5_SampleRHSTemp'] = firstSampleLHSTemp == undefined ? "" : firstSampleLHSTemp;
                        arr[0]["5_SampleLHS"] = "";
                        arr[0]["5_SampleLHSTemp"] = "";
                    }
                    console.log(data)
                    continue;
                } else if (basketRackFound && data.startsWith("06")) {
                    //Test_furation_found = true;
                    let firstSampleArr = data.split('06').filter(k => k)
                    if (firstSampleArr.length > 1) {
                        var firstSampleLHSArr = firstSampleArr[0].split(' ').filter(k => k);
                        var firstSampleLHS = firstSampleLHSArr[0].trim();
                        var firstSampleLHSTemp = firstSampleLHSArr[1].trim();
                        var firstSampleRHSArr = firstSampleArr[1].split(' ').filter(k => k);
                        var firstSampleRHS = firstSampleRHSArr[0].trim();
                        var firstSampleRHSTemp = firstSampleRHSArr[1].trim();
                    } else {
                        firstSampleLHSArr = firstSampleArr[0].split(' ').filter(k => k);
                        var firstSampleLHS = firstSampleLHSArr[0].trim();
                        var firstSampleLHSTemp = firstSampleLHSArr[1].trim();
                    }
                    if (arr[0].BasketA && arr[0].BasketB) {
                        arr[0]['6_SampleLHS'] = firstSampleLHS;
                        arr[0]['6_SampleLHSTemp'] = firstSampleLHSTemp;
                        arr[0]["6_SampleRHS"] = firstSampleRHS == undefined ? "" : firstSampleRHS;
                        arr[0]["6_SampleRHSTemp"] = firstSampleRHSTemp == undefined ? "" : firstSampleRHSTemp;
                    } else if (arr[0].BasketA) {
                        arr[0]['6_SampleLHS'] = firstSampleLHS == undefined ? "" : firstSampleLHS;
                        arr[0]['6_SampleLHSTemp'] = firstSampleLHSTemp == undefined ? "" : firstSampleLHSTemp;
                        arr[0]["6_SampleRHS"] = "";
                        arr[0]["6_SampleRHSTemp"] = "";
                    } else if (arr[0].BasketB) {
                        arr[0]['6_SampleRHS'] = firstSampleLHS == undefined ? "" : firstSampleLHS;
                        arr[0]['6_SampleRHSTemp'] = firstSampleLHSTemp == undefined ? "" : firstSampleLHSTemp;
                        arr[0]["6_SampleLHS"] = "";
                        arr[0]["6_SampleLHSTemp"] = "";
                    }
                    console.log(data)
                    continue;
                }
                // else if (arm_found && basketRackFound && data.startsWith("HALT DUR.")) {
                //     //Test_furation_found = true;
                //     var HALT_DUR_ARR = data.split('|');
                //     var HALT_DUR_JAR_A = HALT_DUR_ARR[1].trim();
                //     var HALT_DUR_JAR_B = HALT_DUR_ARR[2].trim();

                //     arr[0]['HALT_DUR_JAR_A'] = HALT_DUR_JAR_A;
                //     arr[0]["HALT_DUR_JAR_B"] = HALT_DUR_JAR_B;

                //     console.log(data)
                //     continue;
                // } 
                // else if (arm_found && basketRackFound && data.startsWith("TEMP. MIN.")) {
                //     //Test_furation_found = true;
                //     var temperature_Arr = data.split(':');
                //     temperature_Arr = temperature_Arr[1].split(' ').filter(k => k);

                //     var Jar_A_minTemp = temperature_Arr[0];
                //     var Jar_B_minTemp = temperature_Arr[1];

                //     arr[0]['Jar_A_minTemp'] = Jar_A_minTemp;
                //     arr[0]["Jar_B_minTemp"] = Jar_B_minTemp;

                //     console.log(data)
                //     continue;
                // } else if (arm_found && basketRackFound && data.startsWith("TEMP. MAX.")) {
                //     var temperature_Arr = data.split(':');
                //     temperature_Arr = temperature_Arr[1].split(' ').filter(k => k);

                //     var Jar_A_maxTemp = temperature_Arr[0];
                //     var Jar_B_maxTemp = temperature_Arr[1];

                //     arr[0]['Jar_A_maxTemp'] = Jar_A_maxTemp;
                //     arr[0]["Jar_B_maxTemp"] = Jar_B_maxTemp;

                //     console.log(data)
                //     continue;
                // }  
                else {
                    console.log('invalid string recived');
                }
            }
            const TimeFormat = "HH:mm:ss";

            console.log(arr)
            if (arr.length == 0) {
                return mqttSender.sendData(strHmi, "Invalid String Received")
            }
            let dtData = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi).data;

            //VALIDATION PART COMPLETE
            //Mutliple string validation 
            // if (arr[0].BasketA && arr[0].BasketB == true) {
            //     console.log('Innvaldldk');
            //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String recieved`)
            // }
            // Single String A & B validation
            if (dtData.Side == "Jar A") {
                let JarAValidation = Object.entries(arr[0]).map(([k, j]) => {
                    if (k.startsWith('_SampleLHS') || k.startsWith("_SampleLHSTemp") || k.startsWith("Jar_A_minTemp")) {
                        if (j.trim() == "N.A." || j.trim() == 'A' || j.trim() == undefined || j.trim() == 0) {
                            return "Validation fail"
                        }
                        if (k.endsWith('_SampleLHS') ||
                            k.startsWith('startDate') || k.startsWith('time')) {
                            // if (!moment(j.trim(), TimeFormat, true).isValid()) {
                            //     console.log('time match fail')
                            //     return "Validation fail";
                            // }
                        }
                    }
                })
                let validateJarAData = JarAValidation.filter(k => k).includes('Validation fail')
                if (validateJarAData) {
                    console.log('Innvaldldk');
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`)
                }
            } else if (dtData.Side == "Jar B") {
                let JarBValidation = Object.entries(arr[0]).map(([k, j]) => {
                    if (k.endsWith('_SampleRHS') || k.startsWith("_SampleRHSTemp") || k.endsWith('Jar_B_minTemp')) {
                        if (j.trim() == "N.A." || j.trim() == 'B' || j.trim() == undefined || j.trim() == 0) {
                            return "Validation fail"
                        }
                        if (k.endsWith('_SampleRHS') ||
                            k.startsWith('startDate') || k.startsWith('time')) {
                            // if (!moment(j.trim(), TimeFormat, true).isValid()) {
                            //     console.log('time match fail')
                            //     return "Validation fail";
                            // }
                        }
                    }
                })
                let validateJarBData = JarBValidation.filter(k => k).includes('Validation fail')
                if (validateJarBData) {
                    console.log('Innvaldldk');
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`)
                }
            } else if (dtData.Side == "NA") {
                let Jar_A_B_Validation = Object.entries(arr[0]).map(([k, j]) => {
                    if (k.endsWith('_SampleLHS') || k.endsWith('_SampleRHS') ||
                        k.startsWith("_SampleLHSTemp") || k.startsWith("_SampleRHSTemp") || k.endsWith('Jar_A_minTemp') || k.endsWith('Jar_B_minTemp') ||
                        k.endsWith('Jar_A') || k.endsWith('Jar_B')) {
                        if (j.trim() == "N.A." || j.trim() == 'A' || j.trim() == undefined || j.trim() == 'B' || j.trim() == 0) {
                            return "Validation fail";
                        }
                        if (k.endsWith('_SampleLHS') || k.endsWith('_SampleRHS') ||
                            k.startsWith('stratDate') || k.startsWith('time')
                        ) {
                            // if (!moment(j.trim(), TimeFormat, true).isValid()) {
                            //     console.log('time match fail')
                            //     return "Validation fail";
                            // }
                        }
                    }
                })
                let validateDoubleRotaryData = Jar_A_B_Validation.filter(k => k).includes('Validation fail')
                if (validateDoubleRotaryData) {
                    console.log('Innvaldldk');
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`)
                }
            }
            ///END OF VALIDATION PART
            // this line of code for 24 hour validation string......
            // let runTime = moment.utc(moment(endTimeval, "HH:mm:ss").diff(moment(startTimeval, "HH:mm:ss"))).format("HH:mm:ss")
            // end ....24...
            let currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.Hmi == strHmi);
            let tempCailibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);
            const arrSelectedMenu = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);
            var intPortNo1 = arrSelectedMenu.portNo;
            var strInstrumentType = arrSelectedMenu.InstrumentType;
            var strInstrumentId = arrSelectedMenu.instrumentId;
            const __parameterWeighmentObj = {
                idsNo: strResberryPi,
                Hmi: strHmi,
                actualWt: arr[0],
                instrumentId: strInstrumentId,
                model: "Labindia"
            }
            if (arr == "") {
            } else {
                if (tempCailibType == undefined) {
                    if (currentOpStatus == undefined) {
                        loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
                        console.log('wt recieve without any api called');
                        return;
                    } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

                        await objWeighmentData.ParsingTestData(__parameterWeighmentObj);
                    }
                } else {
                    console.log('calibration is on and dt weighment part has clash')
                }
            }
        } catch (error) {

        }
    }

    async parseBulkWeighmentDTED3PO(dataObj, DTModel) {
        try {
            let { str_Protocol, strResberryPi, strHmi, ProtocolPortNo, instrumentId, ProtocolName } = dataObj;
            //here also different balance have different parsing logic
            var Instrumenttype = DTModel.Eqp_Model
            Instrumenttype = Instrumenttype.toLowerCase();
            let data_array = str_Protocol.split("\n");
            let data = str_Protocol.split(":");
            let startDateFound = false;
            let startTimeFound = false;
            let test_duration_found = false;
            let basket_A_Found = false;
            let basket_B_Found = false;
            let arr = [];

            const arrWeighmentArr = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi)
            let jarSelected = arrWeighmentArr.data.Jar.split(' ')[1];

            for (let i = 0; i < data_array.length; i++) {
                data = data_array[i].trim();
                //  console.log(data)
                if (data == "" || data == null)
                    continue;
                if (data.search("MODEL") != -1) {
                    let ModelNo = data.slice(data.search('MODEL'));
                    ModelNo = ModelNo.split(':')[1].trim()
                    ModelNo = ModelNo.split(' ')[0]
                    ModelNo = ModelNo.toLowerCase();
                    if (ModelNo.includes("po") != Instrumenttype.includes("po")) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`)
                    }
                }
                if (data.search("START DATE") != -1) {
                    let startDateArr = data.split('START DATE').filter(k => k);
                    startDateArr = startDateArr[1].trim().split(' ').filter(k => k)
                    let startDate = startDateArr[1];
                    // let time = runDateArr[1]
                    arr.push({ Start_Date: startDate });
                    startDateFound = true;
                    continue;
                }
                if (startDateFound && data.search("START TIME") != -1) {
                    // let startDateArr = data.slice(data.search('Start Date'));
                    // let startDate = startDateArr.split(':')[1].trim()
                    // arr.push({ Start_Date: startDate });
                    startTimeFound = true;
                    let startTime = data.split("START TIME")[1].trim().split(': ')[1];
                    if (startTime == undefined || startTime >= '24:00:00') {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received `)
                    }
                    arr[0]['startTime'] = startTime
                    continue
                }
                if (startDateFound && startTimeFound && data.startsWith("END TIME")) {

                    let endTime = data.split("END TIME")[1].trim().split(': ')[1];

                    arr[0]['endTime'] = endTime
                    continue
                } else if (startDateFound && startTimeFound && data.startsWith(`JAR ${jarSelected} TEMP`)) {

                    let jarTemp = data.split(':')[1].trim().split(' ')[0]
                    if (isNaN(jarTemp) == true || jarTemp == '' || jarTemp == undefined) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received `)
                    }
                    arr[0]['A_tempMax'] = [jarTemp]
                    arr[0]['A_tempMin'] = '0.0'
                    console.log(data)
                    continue;
                } else if (startDateFound && startTimeFound && data.startsWith("TEST RUN DURATION")) {
                    //Test_furation_found = true;
                    // let testRunDuration = data.split(': ')[1].trim()
                    let testRunDuration = data.split("TEST RUN DURATION")[1].trim().split(': ')[1];
                    if (testRunDuration == undefined || testRunDuration >= '24:00:00') {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received `)
                    }
                    arr[0]['testRunDuration'] = testRunDuration
                    console.log(data)
                    continue;
                } else if (startDateFound && startTimeFound && data.startsWith("TEST HALT DURATION")) {
                    // let testHaltDuration = data.split(': ')[1].trim()
                    let testHaltDuration = data.split("TEST HALT DURATION")[1].trim().split(': ')[1];
                    if (testHaltDuration == undefined || testHaltDuration >= '24:00:00') {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received `)
                    }
                    arr[0]['testHaltDuration'] = testHaltDuration
                    console.log(data)
                    continue;
                } else if (startDateFound && startTimeFound && data.startsWith("BASKET")) {
                    if (startDateFound && startTimeFound && data.startsWith("BASKET TYPE")) {
                        let testBasket = data.split(':')[1].trim()
                        var val = testBasket.split(" ")

                        let isMeshFlag = (val[1] == "Mesh") ? true : false;
                        let isBolusFlag = (val[0] == "Bolus") ? true : false;
                        if (!isMeshFlag && !isBolusFlag) {
                            return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received `)
                        }
                        if (isMeshFlag) {
                            if (isNaN(val[0])) {
                                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received `)
                            }
                        } else {
                            if (isNaN(val[1])) {
                                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received `)
                            }
                        }
                        // if(!isBolusFlag && (isMeshFlag || isNaN(val[0]))) {
                        //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received `)
                        // }
                        // if(!isMeshFlag && (isBolusFlag || isNaN(val[1]))) {
                        //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received `)
                        // }

                        //   if(val[1] != "Mesh"){
                        //     if(val[0] != "Bolus"){
                        //         return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received `)
                        //     }else if(isNaN(val[1]) == true){
                        //         return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received `)
                        //     }
                        //   }else if(isNaN(val[0]) == true){
                        //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received `)
                        //   }

                        //     if (isNaN(val[0]) == true || val[1] != "Mesh" || val[0] != "Bolus") {
                        //         return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received `)
                        //     }
                        arr[0]['JarBasket'] = testBasket
                        console.log(data)
                        continue;
                    } else {
                        let basketValue = data.split("BASKET")[1].trim().split(': ')[1];
                        if (basketValue == 'A') {
                            console.log('BASKET A');
                        } else if (basketValue == 'B') {
                            console.log('BASKET B');
                        } else if (basketValue == 'C') {
                            console.log('BASKET C');
                        } else {
                            return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received `)
                        }

                    }

                }
                else if (startDateFound && startTimeFound && data.startsWith("BATH TEMP")) {
                    let BathTemp = data.split(':')[1].trim().split(' ')[0]
                    var val = BathTemp.split(" ")
                    if (isNaN(val[0]) == true || BathTemp == '' || BathTemp == undefined) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received `)
                    }
                    arr[0]['BathTemp'] = BathTemp
                    console.log(data)
                    continue;
                }
                else {
                    // console.log('invalid string recived');
                }
            }
            const TimeFormat = "HH:mm:ss";
            const basketRegex = /BASKET\s+:\s+(\w+)/;
            const match = str_Protocol.match(basketRegex);
            if (match) {
                const basketValue = match[1];
                if (basketValue != jarSelected) {
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received `)
                }
                console.log("Basket Value:", basketValue);
            } else {
                console.log("BASKET not found in the test report.");
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received `)
            }
            console.log(arr)
            if (arr.length == 0) {
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received `)
            }
            let dtData = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi).data;

            //VALIDATION PART
            // Validation change by basket...k
            if (dtData.Jar == "Jar A") {
                if (arr[0].hasOwnProperty('A_tempMax') &&
                    arr[0].hasOwnProperty('A_tempMin') &&
                    arr[0].hasOwnProperty('BathTemp') &&
                    arr[0].hasOwnProperty('endTime') &&
                    arr[0].hasOwnProperty('JarBasket') &&
                    arr[0].hasOwnProperty('Start_Date') &&
                    arr[0].hasOwnProperty('testHaltDuration') &&
                    arr[0].hasOwnProperty('testRunDuration')) {
                    let JarAValidation = Object.entries(arr[0]).map(([k, j]) => {
                        if (k.startsWith('JarBasket') || k.startsWith("Jar_A") || k.endsWith('Jar_A')) {
                            if (j.trim() == "C" || j.trim() == 'B' || j.trim() == undefined) {
                                return "Validation fail"
                            }
                        }
                        if (k.endsWith('Start_Date')) {
                            var b = j.split('/').reverse().join("-");
                            const now = new Date();
                            if (date.format(now, 'YYYY-MM-DD') != b) {
                                return "Validation fail"
                            }
                        }

                        if (k.endsWith('testJarArTemp') ||
                            k.startsWith('startTime') || k.startsWith('endTime') || k.startsWith('testRunDuration') || k.startsWith('testHaltDuration')) {
                            if (!moment(j.trim(), TimeFormat, true).isValid()) {
                                console.log('time match fail')
                                return "Validation fail";
                            }
                        }


                    })
                    let validateJarAData = JarAValidation.filter(k => k).includes('Validation fail')
                    if (validateJarAData) {
                        console.log('Innvaldldk');
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received `)
                    }
                } else {
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received `)
                }
            } else if (dtData.Jar == "Jar B") {
                if (arr[0].hasOwnProperty('A_tempMax') &&
                    arr[0].hasOwnProperty('A_tempMin') &&
                    arr[0].hasOwnProperty('BathTemp') &&
                    arr[0].hasOwnProperty('endTime') &&
                    arr[0].hasOwnProperty('JarBasket') &&
                    arr[0].hasOwnProperty('Start_Date') &&
                    arr[0].hasOwnProperty('testHaltDuration') &&
                    arr[0].hasOwnProperty('testRunDuration')) {
                    let JarBValidation = Object.entries(arr[0]).map(([k, j]) => {
                        if (k.startsWith('JarBasket') || k.startsWith("Jar_B") || k.endsWith('Jar_B')) {
                            if (j.trim() == "C" || j.trim() == 'A' || j.trim() == undefined) {
                                return "Validation fail"
                            }
                        }
                        if (k.endsWith('Start_Date')) {
                            var b = j.split('/').reverse().join("-");
                            const now = new Date();
                            if (date.format(now, 'YYYY-MM-DD') != b) {
                                return "Validation fail"
                            }
                        }
                        if (k.endsWith('testJarArTemp') ||
                            k.startsWith('startTime') || k.startsWith('endTime') || k.startsWith('testRunDuration') || k.startsWith('testHaltDuration')) {
                            if (!moment(j.trim(), TimeFormat, true).isValid()) {
                                console.log('time match fail')
                                return "Validation fail";
                            }
                        }
                    })
                    let validateJarBData = JarBValidation.filter(k => k).includes('Validation fail')
                    if (validateJarBData) {
                        console.log('Innvaldldk');
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received `)
                    }
                } else {
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received `)
                }
            } else if (dtData.Jar == "Jar C") {
                if (arr[0].hasOwnProperty('A_tempMax') &&
                    arr[0].hasOwnProperty('A_tempMin') &&
                    arr[0].hasOwnProperty('BathTemp') &&
                    arr[0].hasOwnProperty('endTime') &&
                    arr[0].hasOwnProperty('JarBasket') &&
                    arr[0].hasOwnProperty('Start_Date') &&
                    arr[0].hasOwnProperty('testHaltDuration') &&
                    arr[0].hasOwnProperty('testRunDuration')) {
                    let JarCValidation = Object.entries(arr[0]).map(([k, j]) => {
                        if (k.startsWith('JarBasket') || k.startsWith("Jar_C") || k.endsWith('Jar_C')) {
                            if (j.trim() == "A" || j.trim() == 'B' || j.trim() == undefined) {
                                return "Validation fail"
                            }
                        }
                        if (k.endsWith('Start_Date')) {
                            var b = j.split('/').reverse().join("-");
                            const now = new Date();
                            if (date.format(now, 'YYYY-MM-DD') != b) {
                                return "Validation fail"
                            }
                        }
                        if (k.endsWith('testJarArTemp') ||
                            k.startsWith('startTime') || k.startsWith('endTime') || k.startsWith('testRunDuration') || k.startsWith('testHaltDuration')) {
                            if (!moment(j.trim(), TimeFormat, true).isValid()) {
                                console.log('time match fail')
                                return "Validation fail";
                            }
                        }
                    })
                    let validateJarCData = JarCValidation.filter(k => k).includes('Validation fail')
                    if (validateJarCData) {
                        console.log('Innvaldldk');
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`)
                    }
                } else {
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received `)
                }
            } else if (dtData.Jar == "NA") {
                let Jar_A_B_C_Validation = Object.entries(arr[0]).map(([k, j]) => {
                    if (k.endsWith('JarBasket') || k.endsWith('JarBasket') || k.endsWith('JarBasket') ||
                        k.startsWith("Jar_A") || k.startsWith("Jar_B") || k.startsWith('Jar_C') ||
                        k.endsWith('Jar_A') || k.endsWith('Jar_B') || k.endsWith('Jar_C')) {
                        if (j.trim() == "A" || j.trim() == 'B' || j.trim() == 'C' || j.trim() == undefined) {
                            return "Validation fail";
                        }
                        if (k.endsWith('testJarArTemp') || k.endsWith('testJarArTemp') ||
                            k.startsWith('startTime') || k.startsWith('endTime') || k.startsWith('testRunDuration') || k.startsWith('testHaltDuration')
                        ) {
                            if (!moment(j.trim(), TimeFormat, true).isValid()) {
                                console.log('time match fail')
                                return "Validation fail";
                            }
                        }
                    }
                })
                let validateDoubleRotaryData = Jar_A_B_C_Validation.filter(k => k).includes('Validation fail')
                if (validateDoubleRotaryData) {
                    console.log('Innvaldldk');
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`)
                }
            }

            ///END OF VALIDATION PART
            let currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.Hmi == strHmi);
            let tempCailibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);
            const arrSelectedMenu = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);
            var intPortNo1 = arrSelectedMenu.portNo;
            var strInstrumentType = arrSelectedMenu.InstrumentType;
            var strInstrumentId = arrSelectedMenu.instrumentId;
            const __parameterWeighmentObj = {
                idsNo: strResberryPi,
                Hmi: strHmi,
                actualWt: arr[0],
                instrumentId: strInstrumentId,
                model: "Electrolab-ED3POX"
            }
            if (arr == "") {
            } else {
                if (tempCailibType == undefined) {
                    if (currentOpStatus == undefined) {
                        loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
                        console.log('wt recieve without any api called');
                        return;
                    } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

                        await objWeighmentData.ParsingTestData(__parameterWeighmentObj);
                    }
                } else {
                    console.log('calibration is on and dt weighment part has clash')
                }
            }
        } catch (error) {

        }
    }

    async parseBulkWeighment_for_EDI_2SA(dataObj, strHmi) {
        try {

            //here also different balance have different parsing logic
            var data_array = dataObj.split("\n");

            var flag = 0

            var obj = {
                jar_A_Obj: {
                    jar_A_Arr: []
                },
                jar_B_Obj: {
                    jar_B_Arr: []
                }
            }

            var sampleNo = 1

            const arrWeighmentArr = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi)

            var Rotary = arrWeighmentArr.data.Rotary

            var jarSelected = arrWeighmentArr.data.Side

            var pattern1 = /^N\.?A\.?$/i

            for (let i = 0; i < data_array.length; i++) {

                var data = data_array[i].replace(/\|/gi, ' ').trim()

                if (data.length == 0) continue;

                if (flag == 0 && data.startsWith('Sr. No.')) {

                    var pattern = /^\d{2}\/\d{2}\/\d{4}$/

                    var extractData = data.split(/Start Date:/gi)

                    if (extractData.length != 2 ||
                        !pattern.test(extractData[1].trim()))
                        return false

                    obj.startDate = extractData[1].trim()

                    flag++

                    continue

                }
                else if (flag == 1 && data.startsWith('START TIME')) {

                    var pattern = /^\d{2}:\d{2}:\d{2}$/

                    var extractData = data.split(/\s+/g)

                    if (extractData.length != 4 ||
                        jarSelected == "A" && !(pattern.test(extractData[2]) && pattern1.test(extractData[3])) ||
                        jarSelected == "B" && !(pattern1.test(extractData[2]) && pattern.test(extractData[3])) ||
                        Rotary != "Single" && !(pattern.test(extractData[2]) && pattern.test(extractData[3])))
                        return false

                    obj.jar_A_Obj.startTime = extractData[2]

                    obj.jar_B_Obj.startTime = extractData[3]

                    flag++

                    continue

                } else if (flag == 2 && data.startsWith('END TIME')) {

                    var pattern = /^\d{2}:\d{2}:\d{2}$/

                    var extractData = data.split(/\s+/gi)

                    if (extractData.length != 4 ||
                        jarSelected == "A" && !(pattern.test(extractData[2]) && pattern1.test(extractData[3])) ||
                        jarSelected == "B" && !(pattern1.test(extractData[2]) && pattern.test(extractData[3])) ||
                        Rotary != "Single" && !(pattern.test(extractData[2]) && pattern.test(extractData[3]))
                    )
                        return false

                    obj.jar_A_Obj.endTime = extractData[2]

                    obj.jar_B_Obj.endTime = extractData[3]

                    flag++

                    continue

                } else if (flag == 3 && data.startsWith('TEST ON DUR.')) {

                    flag++

                    continue;

                } else if (flag == 4) {

                    if (data.startsWith('HALT DUR.')) {

                        var pattern = /^\d{2}:\d{2}:\d{2}$/

                        var extractData = data.split(/\s+/gi)

                        if (extractData.length != 4 ||
                            obj.jar_A_Obj.jar_A_Arr.length == 0 ||
                            obj.jar_B_Obj.jar_B_Arr.length == 0 ||
                            jarSelected == "A" && !(pattern.test(extractData[2]) && pattern1.test(extractData[3])) ||
                            jarSelected == "B" && !(pattern1.test(extractData[2]) && pattern.test(extractData[3])) ||
                            Rotary != "Single" && !(pattern.test(extractData[2]) && pattern.test(extractData[3])))
                            return false

                        obj.jar_A_Obj.haltDuration = extractData[2]

                        obj.jar_B_Obj.haltDuration = extractData[3]

                        flag++

                        continue

                    }

                    var pattern = /^\d{2}:\d{2}:\d{2}$/

                    var extractData = data.split(/\s+/gi)

                    if (extractData.length != 3 ||
                        extractData[0] != sampleNo ||
                        jarSelected == "A" && !(pattern.test(extractData[1]) && pattern1.test(extractData[2])) ||
                        jarSelected == "B" && !(pattern1.test(extractData[1]) && pattern.test(extractData[2])) ||
                        Rotary != "Single" && !(pattern.test(extractData[1]) && pattern.test(extractData[2])))
                        return false

                    obj.jar_A_Obj.jar_A_Arr.push({ sampleNo: sampleNo, data: extractData[1] })

                    obj.jar_B_Obj.jar_B_Arr.push({ sampleNo: sampleNo, data: extractData[2] })

                    sampleNo++

                    continue

                } else if (flag == 5 && data.startsWith('TEMP. MIN.')) {

                    var pattern = /^\d{1,}(.\d{1,})?$/

                    data = data.replace(':', '')

                    var extractData = data.split(/\s+/gi)

                    if (extractData.length != 4 ||
                        jarSelected == "A" && !(pattern.test(extractData[2]) && extractData[3] == '--') ||
                        jarSelected == "B" && !(extractData[2] == '--' && pattern.test(extractData[3])) ||
                        Rotary != "Single" && !(pattern.test(extractData[2]) && pattern.test(extractData[3])))
                        return false


                    obj.jar_A_Obj.tempMin = extractData[2]

                    obj.jar_B_Obj.tempMin = extractData[3]

                    flag++

                    continue

                } else if (flag == 6 && data.startsWith('TEMP. MAX.')) {

                    var pattern = /^\d{1,}(.\d{1,})?$/

                    data = data.replace(':', '')

                    var extractData = data.split(/\s+/gi)

                    if (extractData.length != 4 ||
                        jarSelected == "A" && !(pattern.test(extractData[2]) && extractData[3] == '--') ||
                        jarSelected == "B" && !(extractData[2] = '--' && pattern.test(extractData[3])) ||
                        Rotary != "Single" && !(pattern.test(extractData[2]) && pattern.test(extractData[3])))
                        return false

                    obj.jar_A_Obj.tempMax = extractData[2]

                    obj.jar_B_Obj.tempMax = extractData[3]

                    flag++

                    continue

                }

            }

            if (flag != 7) return false

            return obj

        } catch (error) {
            throw new Error(error)
        }
    }


    async parseBulkWeighmentDT(dataObj, DTModel) {
        try {
            let { str_Protocol, strResberryPi, strHmi, ProtocolPortNo, instrumentId, ProtocolName } = dataObj;
            //here also different balance have different parsing logic
            var Instrumenttype = DTModel.Eqp_Model
            Instrumenttype = Instrumenttype.toLowerCase();
            let data_array = str_Protocol.split("\n");
            let data = str_Protocol.split(":")[2].trim();
            let test_duration_found = false;
            let arm_found = false;
            let arr = [];
            function checkForGarbage(testData, arr) {
                const isValidChars = /^[0-9.:]+$/.test(testData);
                if (!isValidChars) {
                    console.log('Garbage Data Found');
                    arr = []
                    return true;
                }
            }

            function isValidTimeString(timeStr) {
                //hh:mm:ss 24 hour format validation
                const timeRegex = /^([01]\d|2[0-3]):([0-5]\d):([0-5]\d)$/;
                return timeRegex.test(timeStr);
            }

            for (let i = 0; i < data_array.length; i++) {
                data = data_array[i].trim();
                if (data == "" || data == null)
                    continue;
                if (data.search("ARM A") != -1) {
                    arm_found = true;
                    continue;
                }
                if (data.search("Model No") != -1) {
                    let ModelNo = data.slice(data.search('Model No'));
                    ModelNo = ModelNo.split(':')[1].trim()
                    ModelNo = ModelNo.split(' ')[0]
                    ModelNo = ModelNo.toLowerCase();
                    if (ModelNo != Instrumenttype) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`)
                    }
                }
                if (data.search("MODE") != -1) {
                    var mode = data.split(/[\sN]+/g).filter((k) => k != "")[2]
                    // arr.push({ Mode: mode})
                    arr[0]['Mode'] = mode;

                }
                if (data.search("BASKET TYPE") != -1) {
                    var JarBasketA = data.split("|")[1].split(/[\sN]+/g).filter((k) => k != "");
                    var JarBasketB = data.split("|")[2].split(/[\sN]+/g).filter((k) => k != "");

                    if (checkForGarbage(JarBasketA[0], arr) || checkForGarbage(JarBasketB[0], arr)) return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`);

                    arr[0]['JarBasketA'] = JarBasketA.join().replace(',', ' ');
                    arr[0]['JarBasketB'] = JarBasketB.join().replace(',', ' ');
                }
                if (data.search("SET TEMP.") != -1) {
                    var SetTempA = data.split("|")[1].split(/[\sN]+/g).filter((k) => k != "")[0];
                    var SetTempB = data.split("|")[2].split(/[\sN]+/g).filter((k) => k != "")[0];
                    if (checkForGarbage(SetTempA, arr) || checkForGarbage(SetTempB, arr)) return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`);
                    arr[0]['SetTempA'] = SetTempA;
                    arr[0]['SetTempB'] = SetTempB;
                }
                if (data.search("Start Date") != -1) {
                    let startDateArr = data.slice(data.search('Start Date'));
                    let startDate = startDateArr.split(':')[1].trim();
                    // arr[0]['Start_Date'] = startDate;
                    arr.push({ Start_Date: startDate });
                }
                if (arm_found === true && data.search("START TIME") != -1) {
                    var startTime_array = data.split("|");
                    var start_time_Jar_A = startTime_array[1].trim();
                    var start_time_Jar_B = startTime_array[2].trim();

                    if(!isValidTimeString(start_time_Jar_A) || !isValidTimeString(start_time_Jar_B)){
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`)
                    };

                    arr[0]['start_time_Jar_A'] = start_time_Jar_A;
                    arr[0]['start_time_Jar_B'] = start_time_Jar_B;
                    // arr.push({ 'start_time_Jar_A': start_time_Jar_A, 'start_time_Jar_B': start_time_Jar_B })

                }
                else if (arm_found === true && data.search("END TIME") != -1) {
                    var EndTime_array = data.split("|");
                    var end_time_Jar_A = EndTime_array[1].trim();
                    var end_time_Jar_B = EndTime_array[2].trim();

                    if(!isValidTimeString(end_time_Jar_A) || !isValidTimeString(end_time_Jar_B)){
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`)
                    };

                    arr[0]['end_time_Jar_A'] = end_time_Jar_A;
                    arr[0]['end_time_Jar_B'] = end_time_Jar_B;

                }
                else if (arm_found === true && data.search("TEST ON DUR.") != -1) {

                    test_duration_found = true;
                    var firstSampleArr = data.split('|');
                    var firstSampleLHS = firstSampleArr[1].trim();
                    var firstSampleRHS = firstSampleArr[2].trim();
                    let isLHSGarbage = firstSampleLHS != 'N.A.' ? checkForGarbage(firstSampleLHS) : '';
                    let isRHSGarbage = firstSampleRHS != 'N.A.' ? checkForGarbage(firstSampleRHS) : '';
                    if (isLHSGarbage || isRHSGarbage || !isValidTimeString(firstSampleLHS) || !isValidTimeString(firstSampleRHS)) return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`)
                    arr[0]['1_SampleLHS'] = firstSampleLHS;
                    arr[0]["1_SampleRHS"] = firstSampleRHS;
                    console.log(data)
                    continue;
                }
                else if (test_duration_found === true && data.startsWith("1.")) {
                    //Test_furation_found = true;
                    var firstSampleArr = data.split('|');
                    var firstSampleLHS = firstSampleArr[1].trim();
                    var firstSampleRHS = firstSampleArr[2].trim();

                    arr[0]['1_SampleLHS'] = firstSampleLHS;
                    arr[0]["1_SampleRHS"] = firstSampleRHS;
                    console.log(data)
                    continue;
                }
                else if (test_duration_found === true && data.startsWith("2.")) {
                    //Test_furation_found = true;
                    var secondSampleArr = data.split('|');
                    var secondSampleLHS = secondSampleArr[1].trim();
                    var secondSampleRHS = secondSampleArr[2].trim();

                    arr[0]['2_SampleLHS'] = secondSampleLHS;
                    arr[0]["2_SampleRHS"] = secondSampleRHS;

                    console.log(data)
                    continue;
                }
                else if (test_duration_found === true && data.startsWith("3.")) {
                    //Test_furation_found = true;
                    var thirdSampleArr = data.split('|');
                    var thirdSampleLHS = thirdSampleArr[1].trim();
                    var thirdSampleRHS = thirdSampleArr[2].trim();

                    arr[0]['3_SampleLHS'] = thirdSampleLHS;
                    arr[0]["3_SampleRHS"] = thirdSampleRHS;
                    console.log(data)
                    continue;
                }
                else if (test_duration_found === true && data.startsWith("4.")) {
                    //Test_furation_found = true;
                    var fourthSampleArr = data.split('|');
                    var fourthSampleLHS = fourthSampleArr[1].trim();
                    var fourthSampleRHS = fourthSampleArr[2].trim();

                    arr[0]['4_SampleLHS'] = fourthSampleLHS;
                    arr[0]["4_SampleRHS"] = fourthSampleRHS;

                    console.log(data)
                    continue;
                }
                else if (test_duration_found === true && data.startsWith("5.")) {
                    //Test_furation_found = true;
                    var fifthSampleArr = data.split('|');
                    var fifthSampleLHS = fifthSampleArr[1].trim();
                    var fifthSampleRHS = fifthSampleArr[2].trim();

                    arr[0]['5_SampleLHS'] = fifthSampleLHS;
                    arr[0]["5_SampleRHS"] = fifthSampleRHS;
                    console.log(data)
                    continue;
                }
                else if (test_duration_found === true && data.startsWith("6.")) {
                    //Test_furation_found = true;
                    var sixthSampleArr = data.split('|');
                    var sixthSampleLHS = sixthSampleArr[1].trim();
                    var sixthSampleRHS = sixthSampleArr[2].trim();

                    arr[0]['6_SampleLHS'] = sixthSampleLHS;
                    arr[0]["6_SampleRHS"] = sixthSampleRHS;

                    console.log(data)
                    continue;
                }
                else if (test_duration_found === true && data.startsWith("HALT DUR.")) {
                    //Test_furation_found = true;
                    var HALT_DUR_ARR = data.split('|');
                    var HALT_DUR_JAR_A = HALT_DUR_ARR[1].trim();
                    var HALT_DUR_JAR_B = HALT_DUR_ARR[2].trim();
                    let isJarAGarbage = HALT_DUR_JAR_A != 'N.A.' ? checkForGarbage(HALT_DUR_JAR_A) : '';
                    let isJarBGarbage = HALT_DUR_JAR_B != 'N.A.' ? checkForGarbage(HALT_DUR_JAR_B) : '';

                    const isValidTimeFormat = (timeStr) => {
                        const timeRegex = /^\d{2}:\d{2}:\d{2}$/;
                        return timeRegex.test(timeStr);

                    };

                    let isJarAInvalidFormat = HALT_DUR_JAR_A !== 'N.A.' && !isValidTimeFormat(HALT_DUR_JAR_A);
                    let isJarBInvalidFormat = HALT_DUR_JAR_B !== 'N.A.' && !isValidTimeFormat(HALT_DUR_JAR_B);


                    if (isJarAGarbage || isJarBGarbage || isJarAInvalidFormat || isJarBInvalidFormat || !isValidTimeString(HALT_DUR_JAR_A) || !isValidTimeString(HALT_DUR_JAR_B)) return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`)
                    arr[0]['HALT_DUR_JAR_A'] = HALT_DUR_JAR_A;
                    arr[0]["HALT_DUR_JAR_B"] = HALT_DUR_JAR_B;
                    console.log(data)
                    continue;
                }
                else if (test_duration_found === true && data.startsWith("TEMP. MIN.")) {
                    //Test_furation_found = true;
                    var temperature_Arr = data.split(':');
                    temperature_Arr = temperature_Arr[1].split(' ').filter(k => k);

                    var Jar_A_minTemp = temperature_Arr[0];
                    var Jar_B_minTemp = temperature_Arr[1].includes('C') ? temperature_Arr[2] : temperature_Arr[1];
                    let isJarAGarbage = Jar_A_minTemp != '--' ? checkForGarbage(Jar_A_minTemp, arr) : '';
                    let isJarBGarbage = Jar_B_minTemp != '--' ? checkForGarbage(Jar_B_minTemp, arr) : '';
                    if (isJarAGarbage || isJarBGarbage) return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`)
                    arr[0]['Jar_A_minTemp'] = Jar_A_minTemp;
                    arr[0]["Jar_B_minTemp"] = Jar_B_minTemp;

                    console.log(data)
                    continue;
                }
                else if (test_duration_found === true && data.startsWith("TEMP. MAX.")) {
                    var temperature_Arr = data.split(':');
                    temperature_Arr = temperature_Arr[1].split(' ').filter(k => k);

                    var Jar_A_maxTemp = temperature_Arr[0];
                    var Jar_B_maxTemp = temperature_Arr[1].includes('C') ? temperature_Arr[2] : temperature_Arr[1];
                    let isJarAGarbage = Jar_A_maxTemp != '--' ? checkForGarbage(Jar_A_maxTemp, arr) : '';
                    let isJarBGarbage = Jar_B_maxTemp != '--' ? checkForGarbage(Jar_B_maxTemp, arr) : '';
                    if (isJarAGarbage || isJarBGarbage) return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`)
                    arr[0]['Jar_A_maxTemp'] = Jar_A_maxTemp;
                    arr[0]["Jar_B_maxTemp"] = Jar_B_maxTemp;

                    console.log(data)
                    continue;
                }
                else {
                    console.log('invalid string recived');
                }
            }
            const TimeFormat = "HH:mm:ss";

            console.log(arr)
            if (arr.length == 0) {
                return mqttSender.sendData(strHmi, "Invalid String Received");
            }

            let signatureFound = data_array.some(line => line.includes("SIGNATURE"));
            if (!signatureFound) {
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`);
            }

            const mode1 = arr[0]?.Mode?.toLowerCase() || '';
            const isDual = mode1.includes('Dual');

            const requiredKeys = [
                'start_time_Jar_A',
                'end_time_Jar_A',
                '1_SampleLHS',
                'HALT_DUR_JAR_A',
                'Jar_A_minTemp',
                'Jar_A_maxTemp'
            ];

            if (arr[0]['start_time_Jar_B'] !== 'N.A.') {
                requiredKeys.push(
                    'start_time_Jar_B',
                    'end_time_Jar_B',
                    '1_SampleRHS',
                    'HALT_DUR_JAR_B',
                    'Jar_B_minTemp',
                    'Jar_B_maxTemp'
                );
            }

            for (let key of requiredKeys) {
                if (!arr[0]?.hasOwnProperty(key) || arr[0][key] === '') {
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`);
                }
            }

            if (isDual && (arr[0]['start_time_Jar_A'] && arr[0]['start_time_Jar_B'] !== 'N.A.')) {
                const requiredDualRotaryKeys = [
                    'start_time_Jar_A',
                    'end_time_Jar_A',
                    '1_SampleLHS',
                    'HALT_DUR_JAR_A',
                    'Jar_A_minTemp',
                    'Jar_A_maxTemp',
                    'start_time_Jar_B',
                    'end_time_Jar_B',
                    '1_SampleRHS',
                    'HALT_DUR_JAR_B',
                    'Jar_B_minTemp',
                    'Jar_B_maxTemp'
                ];

                const isValidKey = (key) => {
                    return arr[0].hasOwnProperty(key) &&
                        arr[0][key] !== '' &&
                        arr[0][key] !== 'N.A.' &&
                        arr[0][key] !== '--';
                };

                for (let key of requiredDualRotaryKeys) {
                    if (!isValidKey(key)) {
                        console.log(`Missing or invalid key in Dual Rotary: ${key}`);
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`);
                    }
                }
            }
            if (globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi).data.Rotary == "Single") {
                if (arr[0]["1_SampleRHS"] != 'N.A.' && arr[0]["1_SampleLHS"] != 'N.A.') {
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`)
                }
            }
            let dtData = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi).data;

            if (dtData.Jar == "Jar A") {
                let JarAValidation = Object.entries(arr[0]).map(([k, j]) => {
                    if (k.endsWith('_SampleLHS') || k.startsWith("Jar_A") || k.endsWith('Jar_A')) {
                        if (j.trim() == "N.A." || j.trim() == '--' || j.trim() == undefined) {
                            return "Validation fail"
                        }
                    }
                    if (k.endsWith('Start_Date')) {
                        var b = j.split('/').reverse().join("-");
                        const now = new Date();
                        if (date.format(now, 'YYYY-MM-DD') != b) {
                            return "Validation fail"
                        }
                    }
                    if (k.endsWith('JarBasketA')) {
                        if (j.trim() == "N.A." || j.trim() == '--' ||
                            j.trim() == undefined || j.trim() == "" ||
                            j.split(' ')[1] != "Mesh") {
                            return "Validation fail"
                        }
                    }
                    if (k.endsWith('Jar_A_minTemp') || k.endsWith('Jar_A_maxTemp') || k.endsWith('SetTempA')) {
                        if (isNaN(j)) {
                            return "Validation fail"
                        }
                    }
                    if (k.endsWith('_SampleLHS') ||
                        k.startsWith('start_time_Jar_A') || k.startsWith('end_time_Jar_A')) {
                        if (!moment(j.trim(), TimeFormat, true).isValid()) {
                            console.log('time match fail')
                            return "Validation fail";
                        }
                    }
                })
                let validateJarAData = JarAValidation.filter(k => k).includes('Validation fail')
                if (validateJarAData) {
                    console.log('Innvaldldk');
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`);
                }
            } else if (dtData.Jar == "Jar B") {
                let JarBValidation = Object.entries(arr[0]).map(([k, j]) => {
                    if (k.endsWith('_SampleRHS') || k.startsWith("Jar_B") || k.endsWith('Jar_B')) {
                        if (j.trim() == "N.A." || j.trim() == '--' || j.trim() == undefined) {
                            return "Validation fail"
                        }
                    }
                    if (k.endsWith('Start_Date')) {
                        var b = j.split('/').reverse().join("-");
                        const now = new Date();
                        if (date.format(now, 'YYYY-MM-DD') != b) {
                            return "Validation fail"
                        }
                    }
                    if (k.endsWith('JarBasketB')) {
                        if (j.trim() == "N.A." || j.trim() == '--' ||
                            j.trim() == undefined || j.trim() == "" ||
                            j.split(' ')[1] != "Mesh") {
                            return "Validation fail"
                        }
                    }
                    if (k.endsWith('Jar_B_minTemp') || k.endsWith('Jar_B_maxTemp') || k.endsWith('SetTempB')) {
                        if (isNaN(j)) {
                            return "Validation fail"
                        }
                    }
                    if (k.endsWith('_SampleRHS') ||
                        k.startsWith('start_time_Jar_B') || k.startsWith('end_time_Jar_B')) {
                        if (!moment(j.trim(), TimeFormat, true).isValid()) {
                            console.log('time match fail')
                            return "Validation fail";
                        }
                    }
                })
                let validateJarBData = JarBValidation.filter(k => k).includes('Validation fail')
                if (validateJarBData) {
                    console.log('Innvaldldk');
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`)
                }
            } else if (dtData.Jar == 'JarA&B') {
                let Jar_A_B_C_Validation = Object.entries(arr[0]).map(([k, j]) => {


                    if (k.endsWith('_SampleLHS') || k.endsWith('_SampleRHS') ||
                        k.startsWith("Jar_A") || k.startsWith("Jar_B") ||
                        k.endsWith('Jar_A') || k.endsWith('Jar_B')) {
                        if (j.trim() == "N.A." || j.trim() == '--' || j.trim() == undefined || j.trim() == '') {
                            return "Validation fail";
                        }
                        if (k.endsWith('_SampleLHS') || k.endsWith('_SampleRHS') ||
                            k.startsWith('start_time') || k.startsWith('end_time')
                        ) {
                            if (!moment(j.trim(), TimeFormat, true).isValid()) {
                                console.log('time match fail')
                                return "Validation fail";
                            }
                        }
                    }

                    if (k.endsWith('Start_Date')) {
                        var b = j.split('/').reverse().join("-");
                        const now = new Date();
                        if (date.format(now, 'YYYY-MM-DD') != b) {
                            return "Validation fail"
                        }
                    }
                })
                let validateDoubleRotaryData = Jar_A_B_C_Validation.filter(k => k).includes('Validation fail')
                if (validateDoubleRotaryData) {
                    console.log("Validation failed — sending Invalid String Received");
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Received`);
                }
            }

            let currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.Hmi == strHmi);
            let tempCailibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);
            const arrSelectedMenu = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);
            var intPortNo1 = arrSelectedMenu.portNo;
            var strInstrumentType = arrSelectedMenu.InstrumentType;
            var strInstrumentId = arrSelectedMenu.instrumentId;
            const __parameterWeighmentObj = {
                idsNo: strResberryPi,
                Hmi: strHmi,
                actualWt: arr[0],
                instrumentId: strInstrumentId,
                model: "EDI-2SA"
            }
            if (arr == "") {
            } else {
                if (tempCailibType == undefined) {
                    if (currentOpStatus == undefined) {
                        loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
                        console.log('wt recieve without any api called');
                        return;
                    } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

                        await objWeighmentData.ParsingTestData(__parameterWeighmentObj);
                    }
                } else {
                    console.log('calibration is on and dt weighment part has clash')
                }
            }
        } catch (error) {
            throw new Error(error)
        }
    }

    async parseBulkWeighmentED2SAPOx(dataObj, DTModel) {
        try {
            let { str_Protocol, strResberryPi, strHmi, ProtocolPortNo, InstrumentId, ProtocolName } = dataObj;
            //here also different balance have different parsing logic
            var Instrumenttype = DTModel.Eqp_Model
            Instrumenttype = Instrumenttype.toLowerCase();
            let data_array = str_Protocol.split("\n");
            let data = str_Protocol.split(":")[2].trim();
            let arm_found = false;
            let startTimeFound = false;
            let basketRackFound = true;
            let test_duration_found = false;
            let basket_A_Found = false;
            let basket_B_Found = false;
            let arr = [];
            let HALT_DUR_JAR_A, HALT_DUR_JAR_B;
            //if NA then jar HALT_DUR_JAR_A



            for (let i = 0; i < data_array.length; i++) {
                data = data_array[i].trim();
                if (data == "" || data == null)
                    continue;
                if (data.search("ARM A") != -1 || data.search("BASKET A") != -1) {
                    arm_found = true;
                    continue;
                }

                // if(data.startsWith("Model No")){
                //     let model = data.slice(data.search('Model No'));
                //     model = data.split(':')[1].trim()
                //     model = model.split(' ')[0]
                //     mode,l
                //     if(model != dataObj.mainmodels){
                //         return mqttSender.sendData(strHmi, "Invalid String recieved")
                //     }
                // }
                if (data.search("Model No") != -1) {
                    let ModelNo = data.slice(data.search('Model No'));
                    ModelNo = ModelNo.split(':')[1].trim()
                    ModelNo = ModelNo.split(' ')[0]
                    ModelNo = ModelNo.toLowerCase();
                    if (ModelNo.includes("sapox") != Instrumenttype.includes("sapox") || ModelNo.includes("sapo") != Instrumenttype.includes("sapo")) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Recieved`)
                    }
                }
                if (data.search("Start Date") != -1) {
                    let startDateArr = data.slice(data.search('Start Date'));
                    let startDate = startDateArr.split(':')[1].trim()
                    arr.push({ Start_Date: startDate });
                }
                if (arm_found === true && data.search("START TIME") != -1) {
                    var startTime_array = data.split("|");
                    var start_time_Jar_A = startTime_array[1].trim();
                    var start_time_Jar_B = startTime_array[2].trim();
                    arr[0]['start_time_Jar_A'] = start_time_Jar_A;
                    arr[0]['start_time_Jar_B'] = start_time_Jar_B;
                    // arr.push({ 'start_time_Jar_A': start_time_Jar_A, 'start_time_Jar_B': start_time_Jar_B })

                }
                else if (arm_found === true && data.search("END TIME") != -1) {
                    var EndTime_array = data.split("|");
                    var end_time_Jar_A = EndTime_array[1].trim();
                    var end_time_Jar_B = EndTime_array[2].trim();
                    arr[0]['end_time_Jar_A'] = end_time_Jar_A;
                    arr[0]['end_time_Jar_B'] = end_time_Jar_B;

                }
                else if (arm_found === true && data.search("TEST ON DUR.") != -1) {
                    test_duration_found = true;

                    continue;
                }
                else if (test_duration_found === true && data.startsWith("1.")) {
                    //Test_furation_found = true;
                    var firstSampleArr = data.split('|');
                    var firstSampleLHS = firstSampleArr[1].trim();
                    var firstSampleRHS = firstSampleArr[2].trim();

                    arr[0]['1_SampleLHS'] = firstSampleLHS;
                    arr[0]["1_SampleRHS"] = firstSampleRHS;
                    console.log(data)
                    continue;
                }
                else if (test_duration_found === true && data.startsWith("2.")) {
                    //Test_furation_found = true;
                    var secondSampleArr = data.split('|');
                    var secondSampleLHS = secondSampleArr[1].trim();
                    var secondSampleRHS = secondSampleArr[2].trim();

                    arr[0]['2_SampleLHS'] = secondSampleLHS;
                    arr[0]["2_SampleRHS"] = secondSampleRHS;

                    console.log(data)
                    continue;
                }
                else if (test_duration_found === true && data.startsWith("3.")) {
                    //Test_furation_found = true;
                    var thirdSampleArr = data.split('|');
                    var thirdSampleLHS = thirdSampleArr[1].trim();
                    var thirdSampleRHS = thirdSampleArr[2].trim();

                    arr[0]['3_SampleLHS'] = thirdSampleLHS;
                    arr[0]["3_SampleRHS"] = thirdSampleRHS;
                    console.log(data)
                    continue;
                }
                else if (test_duration_found === true && data.startsWith("4.")) {
                    //Test_furation_found = true;
                    var fourthSampleArr = data.split('|');
                    var fourthSampleLHS = fourthSampleArr[1].trim();
                    var fourthSampleRHS = fourthSampleArr[2].trim();

                    arr[0]['4_SampleLHS'] = fourthSampleLHS;
                    arr[0]["4_SampleRHS"] = fourthSampleRHS;

                    console.log(data)
                    continue;
                }
                else if (test_duration_found === true && data.startsWith("5.")) {
                    //Test_furation_found = true;
                    var fifthSampleArr = data.split('|');
                    var fifthSampleLHS = fifthSampleArr[1].trim();
                    var fifthSampleRHS = fifthSampleArr[2].trim();

                    arr[0]['5_SampleLHS'] = fifthSampleLHS;
                    arr[0]["5_SampleRHS"] = fifthSampleRHS;
                    console.log(data)
                    continue;
                }
                else if (test_duration_found === true && data.startsWith("6.")) {
                    //Test_furation_found = true;
                    var sixthSampleArr = data.split('|');
                    var sixthSampleLHS = sixthSampleArr[1].trim();
                    var sixthSampleRHS = sixthSampleArr[2].trim();

                    arr[0]['6_SampleLHS'] = sixthSampleLHS;
                    arr[0]["6_SampleRHS"] = sixthSampleRHS;

                    console.log(data)
                    continue;
                }
                else if (test_duration_found === true && data.startsWith("HALT DUR.")) {
                    //Test_furation_found = true;
                    var HALT_DUR_ARR = data.split('|');
                    HALT_DUR_JAR_A = HALT_DUR_ARR[1].trim();
                    HALT_DUR_JAR_B = HALT_DUR_ARR[2].trim();

                    arr[0]['HALT_DUR_JAR_A'] = HALT_DUR_JAR_A;
                    arr[0]["HALT_DUR_JAR_B"] = HALT_DUR_JAR_B;

                    console.log(data)
                    continue;
                }
                else if (test_duration_found === true && data.startsWith("TEMP. MIN.")) {
                    //Test_furation_found = true;
                    var temperature_Arr = data.split(':');
                    temperature_Arr = temperature_Arr[1].split(' ').filter(k => k);
                    if (temperature_Arr.length > 3) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Recieved`)
                    }
                    var Jar_Bath_min = temperature_Arr[0];
                    var Jar_A_minTemp = temperature_Arr[1];
                    var Jar_B_minTemp = temperature_Arr[2];


                    arr[0]["Jar_Bath_min"] = Jar_Bath_min;
                    arr[0]['Jar_A_minTemp'] = Jar_A_minTemp == undefined ? '' : Jar_A_minTemp;
                    arr[0]["Jar_B_minTemp"] = Jar_B_minTemp == undefined ? '' : Jar_B_minTemp;


                    console.log(data)
                    continue;
                }
                else if (test_duration_found === true && data.startsWith("TEMP. MAX.")) {
                    var temperature_Arr = data.split(':');
                    temperature_Arr = temperature_Arr[1].split(' ').filter(k => k);
                    if (temperature_Arr.length > 3) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Recieved`)
                    }
                    var Jar_Bath_max = temperature_Arr[0];
                    var Jar_A_maxTemp = temperature_Arr[1];
                    var Jar_B_maxTemp = temperature_Arr[2];

                    arr[0]["Jar_Bath_max"] = Jar_Bath_max;
                    arr[0]['Jar_A_maxTemp'] = Jar_A_maxTemp == undefined ? '' : Jar_A_maxTemp;
                    arr[0]["Jar_B_maxTemp"] = Jar_B_maxTemp == undefined ? '' : Jar_B_maxTemp;

                    console.log(data)
                    continue;
                }
                else {
                    console.log('string recived');
                }
            }
            const TimeFormat = "HH:mm:ss";

            console.log(arr)
            if (HALT_DUR_JAR_A === "NA" || HALT_DUR_JAR_B === "NA") {
                if (HALT_DUR_JAR_A != 'NA') {
                    arr[0]['Jar_A_minTemp'] = Jar_A_minTemp == undefined ? '' : Jar_A_minTemp;
                    arr[0]["Jar_A_maxTemp"] = Jar_A_maxTemp == undefined ? '' : Jar_A_maxTemp;
                }
                else {
                    arr[0]['Jar_B_minTemp'] = Jar_A_minTemp == undefined ? '' : Jar_A_minTemp;
                    arr[0]["Jar_B_maxTemp"] = Jar_A_maxTemp == undefined ? '' : Jar_A_maxTemp;
                }
                if (HALT_DUR_JAR_A == 'NA') {
                    arr[0]['Jar_A_minTemp'] = '';
                    arr[0]["Jar_A_maxTemp"] = '';
                } else {
                    arr[0]['Jar_B_minTemp'] = '';
                    arr[0]["Jar_B_maxTemp"] = '';
                }
                //not take sample 
            }
            if (arr.length == 0) {
                return mqttSender.sendData(strHmi, "Invalid String Recieved")
            }
            let dtData = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi).data;
            //VALIDATION PART
            // if(HALT_DUR_JAR_A === "NA" || HALT_DUR_JAR_B === "NA"){
            //     //not take sample 
            // }
            if (dtData.Side == "Jar A") {
                let JarAValidation = Object.entries(arr[0]).map(([k, j]) => {
                    if (k.endsWith('_SampleLHS') || k.startsWith("Jar_A") || k.endsWith('Jar_A')) {
                        if (j.trim() == "N.A." || j.trim() == '--' || j.trim() == '') {
                            return "Validation fail"
                        }
                    }
                    if (k.endsWith('_SampleLHS') ||
                        k.startsWith('start_time_Jar_A') || k.startsWith('end_time_Jar_A') || k.startsWith("HALT_DUR_JAR_A")) {
                        if (j.trim() == '24:00:00') {
                            return "Validation fail";
                        }
                        if (!moment(j.trim(), TimeFormat, true).isValid()) {
                            console.log('time match fail')
                            return "Validation fail";
                        }
                    }
                })
                let validateJarAData = JarAValidation.filter(k => k).includes('Validation fail')
                // if(arr[0].Jar_B_maxTemp != '' && arr[0].Jar_B_minTemp != ''){
                //     validateJarAData = true
                // }
                if (validateJarAData) {
                    console.log('Innvaldldk');
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Recieved`)
                }
            } else if (dtData.Side == "Jar B") {
                let JarBValidation = Object.entries(arr[0]).map(([k, j]) => {
                    if (k.endsWith('_SampleRHS') || k.startsWith("Jar_B") || k.endsWith('Jar_B') || k.startsWith("HALT_DUR_JAR_B")) {
                        if (j.trim() == "N.A." || j.trim() == '--' || j.trim() == '') {
                            return "Validation fail"
                        }
                        if (k.endsWith('_SampleRHS') ||
                            k.startsWith('start_time_Jar_B') || k.startsWith('end_time_Jar_B') || k.startsWith("HALT_DUR_JAR_B")) {
                            if (j.trim() == '24:00:00') {
                                return "Validation fail";
                            }
                            if (!moment(j.trim(), TimeFormat, true).isValid()) {
                                console.log('time match fail')
                                return "Validation fail";
                            }
                        }
                    }
                })
                let validateJarBData = JarBValidation.filter(k => k).includes('Validation fail')
                // if(arr[0].Jar_A_maxTemp != '' && arr[0].Jar_A_minTemp != '' ){
                //     validateJarBData = true
                // }
                if (validateJarBData) {
                    console.log('Innvaldldk');
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Recieved`)
                }
            } else if (dtData.Side == "NA") {
                let Jar_A_B_C_Validation = Object.entries(arr[0]).map(([k, j]) => {
                    if (k.endsWith('_SampleLHS') || k.endsWith('_SampleRHS') ||
                        k.startsWith("Jar_A") || k.startsWith("Jar_B") ||
                        k.endsWith('JAR_A') || k.endsWith('JAR_B') ||
                        k.endsWith('Jar_A') || k.endsWith('Jar_B')) {
                        if (j.trim() == "N.A." || j.trim() == '--' || j.trim() == undefined || j.trim() == '') {
                            return "Validation fail";
                        }
                        if (k.endsWith('_SampleLHS') || k.endsWith('_SampleRHS') ||
                            k.startsWith('start_time') || k.startsWith('end_time') || k.startsWith("HALT_DUR_JAR_A") || k.startsWith("HALT_DUR_JAR_B")
                        ) {
                            if (j.trim() == '24:00:00') {
                                return "Validation fail";
                            }
                            if (!moment(j.trim(), TimeFormat, true).isValid()) {
                                console.log('time match fail')
                                return "Validation fail";
                            }
                        }
                    }
                })
                let validateDoubleRotaryData = Jar_A_B_C_Validation.filter(k => k).includes('Validation fail')
                if (validateDoubleRotaryData) {
                    console.log('Innvaldldk');
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Recieved`)
                }


            }
            if (arr[0].Jar_A_maxTemp == '--') arr[0].Jar_A_maxTemp = ''
            if (arr[0].Jar_A_minTemp == '--') arr[0].Jar_A_minTemp = ''
            if (arr[0].Jar_B_maxTemp == '--') arr[0].Jar_B_maxTemp = ''
            if (arr[0].Jar_B_minTemp == '--') arr[0].Jar_B_minTemp = ''

            if (arr[0].Jar_A_maxTemp != '' || arr[0].Jar_A_minTemp != '') {
                if (isNaN(arr[0].Jar_A_maxTemp) || isNaN(arr[0].Jar_A_minTemp)) {
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Recieved`)
                }
            }



            if (arr[0].Jar_A_maxTemp != '' || arr[0].Jar_A_minTemp != '') {
                if (arr[0].Jar_A_maxTemp < arr[0].Jar_A_minTemp) {
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Recieved`)
                }
            }



            if (arr[0].Jar_B_maxTemp != '' || arr[0].Jar_B_minTemp != '') {
                if (isNaN(arr[0].Jar_B_maxTemp) || isNaN(arr[0].Jar_B_minTemp)) {
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Recieved`)
                }
            }
            if (arr[0].Jar_B_maxTemp != '' || arr[0].Jar_B_minTemp != '') {
                if (arr[0].Jar_B_maxTemp < arr[0].Jar_B_minTemp) {
                    return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String Recieved`)
                }
            }
            let currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.Hmi == strHmi);
            let tempCailibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);
            const arrSelectedMenu = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);
            var intPortNo1 = arrSelectedMenu.portNo;
            var strInstrumentType = arrSelectedMenu.InstrumentType;
            var strInstrumentId = arrSelectedMenu.instrumentId;
            const __parameterWeighmentObj = {
                idsNo: strResberryPi,
                Hmi: strHmi,
                actualWt: arr[0],
                instrumentId: strInstrumentId,
                model: DTModel //"ED2SAPOx"
            }
            if (arr == "") {
            } else {
                if (tempCailibType == undefined) {
                    if (currentOpStatus == undefined) {
                        loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
                        console.log('wt recieve without any api called');
                        return;
                    } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

                        await objWeighmentData.ParsingTestData(__parameterWeighmentObj);
                    }
                } else {
                    console.log('calibration is on and dt weighment part has clash')
                }
            }
        } catch (error) {
            console.log(error);
        }
    }

    async invalidDataString(strHmi) {
        console.log('Invalid String')
        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid string Received`)
    }

    async getDetailOfBulkInstrumentModel(instrumentId, instrumentType) {
        try {
            const obj = await models.tbl_otherequipment.findAll({
                where: {
                    Eqp_ID: instrumentId,
                    Eqp_Type: instrumentType
                }
            })
            let res = [obj];
            if (res[0].length <= 0) {
                return undefined
            }
            return res[0][0];
        } catch (error) {
            throw new Error(error)
        }
    }


}

module.exports = FriabilityParsing;