var checkForPenCal = require('./checkForPendingCalib');
var sort = require('./checkForPendingCalib');
var Comman = require('./clsCalibCommonFunction.model');
var comman = new Comman();
const PowerBackup = require("../../Utills/powerBackUp/powerbackup");
const objPowerBackup = new PowerBackup();
const FetchDetail = require('./../clsFetchDetails.model');
const fetchDetails = new FetchDetail()
const Database = require('./../../database/clsQueryProcess');
const database = new Database();
const FormulaFunction = require('./../Product/clsformulaFun.model'); //make this function
const objFormulaFunction = new FormulaFunction();
const globalData = require('./../../global/globalData');
const obj_getRepSrNo = require('../Calibration/repSrNo');
const date1 = require('date-and-time');
const clsActivityLog = require('../clsActivityLog.model');
const objActivityLog = new clsActivityLog();
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const MqttModel = require('../Mqtt/mqttSender.class');
const mqttSender = new MqttModel();
const clsHmiModel = require('../hmiDetail.model')
const objHmiModel = new clsHmiModel();
const InstrumentUsage = require('../clsInstrumentUsageLog');
const objInstrumentUsage = new InstrumentUsage();
const sequelize = require('../../../config/dbConnection').sequelize
const models = require('../../../config/dbConnection').models;
const { Op } = require('sequelize')
const clsCommomInsertOperation = require('../Product/clsCommonInsertOperation.model')
const objClsInsertOp = new clsCommomInsertOperation();
const normaDate = require('../../middleware/setTimeZone');
const moment = require('moment')
const GlobalNomenclature = require('../../global/GLOBAL_NOMENCLATURE');

const clsMonit = require('../MonitorSocket/clsMonitSocket')
const objMonit = new clsMonit();

class CalibrationModel {
    // ****************************************************************************************************//
    // Below function takes argument as str_Protocol, IdSSrNo and stores all balance information related to
    // that IDS  
    //**************************************************************************************************** */
    async getCalibWeights(strBalID, strHmi, rasbpi) {
        try {
            // calculating balance Id assigned to that IDS
            // const tempCubicInfo = globalData.arrIdsInfo.find(k => k.Sys_IDSNo == parseInt(IDSSrNo));
            console.log('api hit')
            var strBalId = strBalID;
            let resObj = {};
            let srNo = 0;
            let hmiDetails = globalData.arrSelectedBalWithHmi.find(k => k.Hmi == strHmi);
            let TempCalibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);
            var objDelay = globalData.delayApi.find(k => k.Hmi == strHmi)
            if (objDelay == undefined) {
                globalData.arrCalibInsertCounter.findIndex((element) => element.Hmi === strHmi) == -1 ? globalData.arrCalibInsertCounter : globalData.arrCalibInsertCounter.splice(globalData.arrCalibInsertCounter.findIndex((element) => element.Hmi === strHmi), 1);
                (globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCalibCounterApi : globalData.arrCalibCounterApi.splice(globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi), 1);
                (globalData.arrCalibCounter.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCalibCounter : globalData.arrCalibCounter.splice(globalData.arrCalibCounter.findIndex((element) => element.Hmi === strHmi), 1);
            }

            if (TempCalibType != undefined) {
                TempCalibType.calibType = mqttProtocol.Periodic.toLowerCase();
                await fetchDetails.getBalanceCalibDetails(strBalId, strHmi)

            } else {
                globalData.arrcalibType.push({ Hmi: strHmi, calibType: mqttProtocol.Periodic.toLowerCase() })
                await fetchDetails.getBalanceCalibDetails(strBalId, strHmi) /**globalData.arrBalCaibDet.push({
                    strBalId: strBalId,
                    isPeriodicDone: true,
                }) */
            }

            let strPortNo = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi).BalList.find(i => i.BalanceId == strBalId).PortNo;

            //monit
            await objMonit.monit({ case: 'Calibration', Hmi: strHmi, data: { calibType: mqttProtocol.Periodic } });

            if (hmiDetails == undefined) {
                globalData.arrSelectedBalWithHmi.push({
                    "Hmi": strHmi,
                    "rasbpi": rasbpi,
                    "selectedBal": strBalId,
                    "portNo": strPortNo,
                    "InstrumentType": "Balance",
                })
            } else {
                hmiDetails.rasbpi = rasbpi;
                hmiDetails.selectedBal = strBalId;
                hmiDetails.portNo = strPortNo;
                hmiDetails.InstrumentType = "Balance";
            }
            var result = await models.tbl_balance.findAll({
                where: {
                    'Bal_ID': strBalId
                }
            })

            result = [result]

            let arrBal = globalData.arrBalance.find(k => k.Hmi == strHmi);
            if (arrBal == undefined) {
                globalData.arrBalance.push({
                    Hmi: strHmi,
                    balId: strBalId,
                    balance_info: result[0]
                });
            } else {
                arrBal.balId = strBalId,
                    arrBal.balance_info = result[0]
            }

            // var tempIM = globalData.arrHexInfo.find(k => k.idsNo == IDSSrNo);
            var tempBalace = globalData.arrBalance.find(k => k.Hmi == strHmi)
            let balanceInfo = tempBalace.balance_info[0];

            result = await models.tbl_balance_weights.findAll({

                where: {
                    'Bal_ID': strBalId,
                    'Bal_Periodic': 1
                },
                order: [['Bal_StdWt', 'ASC']]
            })
            result = [result];


            //compare gm and send g 
            var strUnitOfBal = globalData.arrBalance.find(k => k.Hmi == strHmi);
            var strUnitAccordingDb;
            if (strUnitOfBal.balance_info[0].Bal_Unit.toLowerCase() == "g") {
                strUnitAccordingDb = "g";
            } else {
                strUnitAccordingDb = strUnitOfBal.balance_info[0].Bal_Unit;
            }



            // If Array of weights is Already present in globalData then we have to update this so we first remove 
            // and push new one OR Else if not present then we add new one
            var found = globalData.arrBalCalibWeights.some(function (el) {
                return el.Hmi == strHmi;
            });
            if (found) {
                const tempObj = globalData.arrBalCalibWeights.find(k => k.Hmi == strHmi);
                // removing Current obj
                var index = globalData.arrBalCalibWeights.indexOf(tempObj);
                if (index !== -1) globalData.arrBalCalibWeights.splice(index, 1);
                globalData.arrBalCalibWeights.push({
                    Hmi: strHmi,
                    balId: strBalId,
                    calibWt: result[0] // array
                })
            } else {
                globalData.arrBalCalibWeights.push({
                    Hmi: strHmi,
                    balId: strBalId,
                    calibWt: result[0] // array
                })
            }
            // Instrument Usage log for balance start

            // if (serverConfig.ProjectName == "RBH") { // Set in serverconfig file

            //     await objInstrumentUsage.InstrumentUsage('Balance', IDSSrNo, 'tbl_instrumentlog_balance', 'Linearity Calibration', 'started');
            //     return 'CB01' + objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt,tempBalace.balance_info[0].Bal_DP) + `g, 0.000,Linearity Calib,${TareCmd}`;
            // }
            // else {
            // await objInstrumentUsage.InstrumentUsage('Balance', IDSSrNo, 'tbl_instrumentlog_balance', 'Periodic Calibration', 'started');
            // return 'CB01' + objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt,tempBalace.balance_info[0].Bal_DP) + `g, 0.000,Periodic Calib,${TareCmd}`;
            // { 'Hmi': strHmi, 'BalId' :  strBalId , 'counter': srNo }
            var strUnitOfBal = globalData.arrBalance.find(k => k.Hmi == strHmi);
            let tempCounter = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi);
            if (tempCounter == undefined) {

                globalData.arrCalibCounterApi.push({ 'Hmi': strHmi, 'BalId': strBalId, 'counterApi': srNo })
            }
            const tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);

            let _calib_count = tempCounter == undefined ? 0 : tempCounter.counterApi
            var _powerbackupCalib = {
                strTableName: 'tbl_calibration_periodic_master_incomplete',
                strDetailTbl: 'tbl_calibration_periodic_detail_incomplete',
                cubicaNo: 'NUll',
                cubicType: 'NUll',
                cubicSysBFGcode: 'NUll',
                cubicBatch: 'NUll',
                menuName: 'Periodic',
                productType: 'NUll',
                Userid: tempUserObject.UserId,
                idsNo: rasbpi,
                Hmi: strHmi,
                RecSampleNo: _calib_count,
                ReportType: 'NUll',
                _bal_id: strBalId

            }
            let _check_combination = await objPowerBackup._check_calibration_entry(strHmi, _powerbackupCalib, "tbl_powerbackup");
            if (_check_combination !== undefined) {
                if (tempCounter == undefined) {
                    tempCounter = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi);
                }
                tempCounter.counterApi = _check_combination.RecSampleNo + 1;
                _powerbackupCalib.RecSampleNo = tempCounter.counterApi
                tempCounter.counterApi = tempCounter.counterApi
            }
            else {
                if (tempCounter != undefined) {
                    tempCounter.counterApi += 1;
                    _powerbackupCalib.RecSampleNo = tempCounter.counterApi
                    tempCounter.counterApi = tempCounter.counterApi
                }
            }
            if (tempCounter == undefined) {
                let strResPiNo = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi).ResbPi;
                // await objInstrumentUsage.InstrumentUsage('Balance', strResPiNo, 'tbl_instrumentlog_balance', 'Periodic Calibration', 'started');
                let data = {
                    Srno: 0,
                    Bal_StdWt: parseFloat(result[0][0].Bal_StdWt).toFixed(balanceInfo.Bal_DP) + " " + strUnitAccordingDb, // objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt,tempBalace.balance_info[0].Bal_DP)
                    Bal_NegTol: parseFloat(result[0][0].Bal_NegTol).toFixed(balanceInfo.Bal_DP) + " " + strUnitAccordingDb,
                    Bal_PosTol: parseFloat(result[0][0].Bal_PosTol).toFixed(balanceInfo.Bal_DP) + " " + strUnitAccordingDb,
                }
                var objBalRelWt = globalData.arrBalCalibWeights.find(k => k.Hmi == strHmi); //get the current wt. 
                if (objBalRelWt != undefined) {
                    objBalRelWt.ID = result[0][0].Id
                }
                let intsend = globalData.arrsendWt.find(k => k.Hmi == strHmi);
                if (intsend == undefined) {
                    globalData.arrsendWt.push({ 'Hmi': strHmi, 'BalId': strBalId, 'sendWt': objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, balanceInfo.Bal_DP) });
                }
                else {
                    intsend.strBalId = strBalId;
                    intsend.sendWt = objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, balanceInfo.Bal_DP)
                }
                //globalData.arrsendWt.push({ 'Hmi': strHmi, 'BalId': strBalId, 'sendWt': objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP) });
                return Object.assign(resObj, {//{ 'Hmi': strHmi, 'BalId' :  strBalId , 'counter': srNo   objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP}
                    status: 'success',
                    result: data
                });
            }
            else {
                if (tempCounter.counterApi == result[0].length) {

                    await objMonit.monit({ case: 'CalibDone', Hmi: strHmi, data: { calibType: mqttProtocol.Periodic } });
                    (globalData.arrSelectedBalWithHmi.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrSelectedBalWithHmi : globalData.arrSelectedBalWithHmi.splice(globalData.arrSelectedBalWithHmi.findIndex((element) => element.Hmi === strHmi), 1);
                    (globalData.arrcalibType.findIndex(k => k.Hmi == strHmi) == -1 ? globalData.arrcalibType : globalData.arrcalibType.splice(globalData.arrcalibType.findIndex(k => k.Hmi == strHmi), 1));
                    (globalData.delayApi.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.delayApi : globalData.delayApi.splice(globalData.delayApi.findIndex((element) => element.Hmi === strHmi), 1);

                    (globalData.arrCalibCounter.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCalibCounter : globalData.arrCalibCounter.splice(globalData.arrCalibCounter.findIndex((element) => element.Hmi === strHmi), 1); //counter clear
                    (globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCalibCounterApi : globalData.arrCalibCounterApi.splice(globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi), 1);
                    await models.tbl_powerbackup.destroy({
                        where: {
                            WeighmentName: 'Periodic',
                            Idsno: strHmi
                        }
                    })
                    //globalData.arrCalibCounterApi.splice( globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi), 1)
                    console.log('done')
                    return Object.assign(resObj, {
                        status: 'success',
                        message: 'Calibration Successful'
                    });
                } else {
                    let intsendWt = globalData.arrsendWt.find(k => k.Hmi == strHmi);
                    if (_check_combination !== undefined) {
                        globalData.arrsendWt.push({
                            'Hmi': strHmi, 'BalId': strBalId, 'sendWt': objFormulaFunction.FormatNumberString(result[0][tempCounter.counterApi].Bal_StdWt, balanceInfo.Bal_DP)
                        }
                        )
                        intsendWt = globalData.arrsendWt.find(k => k.Hmi == strHmi);
                    }

                    if (intsendWt == undefined) {
                        globalData.arrsendWt.push({ 'Hmi': strHmi, 'BalId': strBalId, 'sendWt': objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, balanceInfo.Bal_DP) });
                    }
                    else {
                        intsendWt.strBalId = strBalId;
                        intsendWt.sendWt = objFormulaFunction.FormatNumberString(result[0][tempCounter.counterApi].Bal_StdWt, balanceInfo.Bal_DP)
                    }
                    let data = {
                        Srno: tempCounter.counterApi,
                        Bal_StdWt: parseFloat(result[0][tempCounter.counterApi].Bal_StdWt).toFixed(balanceInfo.Bal_DP) + " " + strUnitAccordingDb,
                        Bal_NegTol: parseFloat(result[0][tempCounter.counterApi].Bal_NegTol).toFixed(balanceInfo.Bal_DP) + " " + strUnitAccordingDb,
                        Bal_PosTol: parseFloat(result[0][tempCounter.counterApi].Bal_PosTol).toFixed(balanceInfo.Bal_DP) + " " + strUnitAccordingDb,
                    }
                    var objBalRelWt = globalData.arrBalCalibWeights.find(k => k.Hmi == strHmi); //get the current wt. 
                    if (objBalRelWt != undefined) {
                        objBalRelWt.ID = result[0][tempCounter.counterApi].Id
                    } else {
                        objBalRelWt.ID = result[0][tempCounter.counterApi].Id
                    }
                    return Object.assign(resObj, {
                        status: 'success',
                        result: data
                    });
                }


            }






            // }
            // await objInstrumentUsage.InstrumentUsage('Balance', IDSSrNo, 'tbl_instrumentlog_balance', 'Periodic Calibration', 'started');
            // return 'CB01' + result[0][0].Bal_StdWt + 'g, 0.000,Periodic Calib,';

            // }


        }
        catch (err) {
            console.log("Error from getCalibWeights of Periodic", err)
            return `Error from getCalibWeights of Periodic ${err}`;
        }

    }


    //**************************************************************************************************************** */
    // Below function verifies recived weights is in range of tolerences and stores in database as in given situation
    // Also send next weights for calibrations
    //**************************************************************************************************************** */
    async verifyWeights(str_Protocol, strResPiNo, ProtocolData, ProtocolDecPoint) {
        try {
            let tempstrResPiNo = strResPiNo;
            let strHmi = await objHmiModel.getHmiNoFromResbPi(strResPiNo);
            strResPiNo = await objHmiModel.getAliasOfRPI(strResPiNo)
            let removeBalOfThatHmi = globalData.arrSelectedBalWithHmi.find(k => k.Hmi == strHmi);
            let strBalId = removeBalOfThatHmi.selectedBal
            let now = new Date();
            var str_ProtocolData = str_Protocol;
            str_ProtocolData.split(':');
            let ProtocolName = str_ProtocolData.split(":")[0];
            let ProtocolPortNo = str_ProtocolData.split(":")[1];
            let resObj = {};
            let data = str_ProtocolData.split(":");
            var new_string = data[2].substr(data[2].search(/\d/));
            new_string = new_string.trim();
            let ProtocolDataAndUnit = new_string.split(" ");
            ProtocolDataAndUnit = ProtocolDataAndUnit.filter(k => k)
            let recieveWt = ProtocolData;
            var insertingDetailCounter = 1;
            let arrRemoveUnit = ProtocolDataAndUnit.filter(item => item);
            let unit = arrRemoveUnit[1];
            var srNo = 0;

            let arr = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi).BalList;
            let removeBalType = arr.filter(k => k.BalanceId == strBalId)

            //wadadadas///

            // calculating Balance Id related to that Ids
            // const tempCubicInfo = globalData.arrIdsInfo.find(k => k.Sys_IDSNo == parseInt(IDSSrNo));
            // var strBalId = tempCubicInfo.Sys_BalID;
            // calculating below parameted from string 
            // var srNo = str_Protocol.split(',')[0].substring(2, 4); // Weight Sr Number
            // var sendWt = str_Protocol.split(',')[0].substring(4).slice(0, -1); // Weight send for calibration
            // var recieveWt = str_Protocol.split(',')[1].split(' ')[0]; // recived weight after calibration
            // fetching calibration weights for that balance from global array with reference to Ids
            var objBalRelWt = globalData.arrBalCalibWeights.find(k => k.Hmi == strHmi); //get the current wt. 
            //pushing while getting first wt globalData.arrBalCalibWeights
            // globalData.arrBalCalibWeights.push({
            //     Hmi: strHmi,
            //     balId : strBalId,
            //     calibWt: result[0] // array
            // })

            //current send wt
            let tempSendWt = globalData.arrsendWt.find(k => k.Hmi == strHmi);
            const objSentWt = objBalRelWt.calibWt.find(j => j.Id == parseFloat(objBalRelWt.ID));
            // console.log(objSentWt)

            //doubt
            // var objFailedFlag = globalData.arrFlagForFailCalib.find(k => k.idsNo == IDSSrNo);
            // if (objFailedFlag == undefined) {
            //     globalData.arrFlagForFailCalib.push({
            //         idsNo: IDSSrNo,
            //         failFlagDaily: false,
            //         failFlagPeriodic: false
            //     });
            //     objFailedFlag = globalData.arrFlagForFailCalib.find(k => k.idsNo == IDSSrNo);
            // }
            var tempObj = globalData.arrCalibCounter.find(k => k.Hmi == strHmi);
            const tempBalObject = globalData.arrBalance.find(k => k.Hmi == strHmi);
            var tempDetailCounterObj = globalData.arrCalibInsertCounter.find(k => k.Hmi == strHmi);
            var strUnitAccordingDb;
            if (tempBalObject.balance_info[0].Bal_Unit.startsWith('g')) {
                strUnitAccordingDb = "g";
            } else {
                strUnitAccordingDb = tempBalObject.balance_info[0].Bal_Unit;
            }

            var perferUnit;
            if (unit == undefined) {
                perferUnit = "g";
            } else {
                if (unit.toLowerCase() === "g")
                    perferUnit = "g";
                else
                    perferUnit = unit.toLowerCase();
            }

            if (strUnitAccordingDb.toLowerCase() !== perferUnit) {
                let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
                let autoTare = hmiEntryinConfig[0].AutoTare;
                let tareCommand = hmiEntryinConfig[0].Tare_Command
                mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Please Check the Balance Setting`);
                mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                return
            } else {
                if (tempObj === undefined) {
                    globalData.arrCalibCounter.push({ 'Hmi': strHmi, 'BalId': strBalId, 'counter': srNo });
                    globalData.arrCalibInsertCounter.push({ 'Hmi': strHmi, 'BalId': strBalId, 'insertingDetailCounter': insertingDetailCounter })
                }
                else {
                    tempObj.BalId = strBalId
                    tempObj.counter = tempObj.counter + 1;

                    tempDetailCounterObj.BalId = strBalId;
                    tempDetailCounterObj.insertingDetailCounter = tempDetailCounterObj.insertingDetailCounter + 1;
                }
            }




            if (parseInt(srNo) <= objBalRelWt.calibWt.length) {
                //"CB0"


                var int_RepSrNo;


                // getting only balanceInfo
                const balanceInfo = tempBalObject.balance_info[0];
                let BalanceRecalibStatusObject;
                if (removeBalType[0].type == "analytical") {
                    BalanceRecalibStatusObject = globalData.arrBalanceRecalibStatus.find(k => k.Bal_ID == strBalId);
                } else {
                    BalanceRecalibStatusObject = globalData.arrBalanceRecalibStatusIPC.find(k => k.Bal_ID == strBalId);
                }
                // getting userIfo logged in for that cubicle
                recieveWt = Number(recieveWt).toFixed(balanceInfo.Bal_DP)
                if (balanceInfo != undefined) {
                    // var balanceInfo = tempBalObject.balance_info[0]
                    if (balanceInfo.Bal_CalbStoreType == 1) {
                        var days = balanceInfo.Bal_CalbDuration;
                        var monthlyDueDate = balanceInfo.Bal_CalbDueDt;
                        var Datess = monthlyDueDate.split('-')[2]
                        var newDate = moment().format("YYYY-MM-DD")
                        // if (BalanceRecalibStatusObject.PeriodicBalRecalib == 1) {
                        // if (moment().format("YYYY-MM-DD") >= monthlyDueDate) {

                        // var dateInUTC = moment()
                        // dateInUTC = dateInUTC.set({ 'year': newDate, 'date': Datess })


                        // // dateInUTC = moment().add(days, 'days')
                        // var normalDate = normaDate.convertDate(dateInUTC);
                        // balanceInfo.Bal_CalbDueDt = normalDate
                        // balanceInfo.Bal_CalbDueDt = monthlyDueDate
                        // }
                        // } else {
                        // var normalDate = normaDate.convertDate(dateInUTC);
                        balanceInfo.Bal_CalbDueDt = newDate

                        // }
                    } else {
                        var newDate = moment().format("YYYY-MM-DD")
                        balanceInfo.Bal_CalbDueDt = newDate
                        // var arr1 = balanceInfo.Bal_CalbDates.split(',');
                        // var today = new Date();
                        // var todayDate = moment().format('YYYY-MM-DD');
                        // var month = today.getMonth() + 1;
                        // month = ("0" + month).slice(-2);
                        // var year = today.getFullYear();
                        // var arr_calibdates = []
                        // for (let d of arr1) {
                        //     var day = ("0" + d).slice(-2)
                        //     var date = '';
                        //     date = year + '-' + month + '-' + day;
                        //     arr_calibdates.push(date);
                        // }
                        // let now = new Date();
                        // var lastCalibDate = moment(now).format('YYYY-MM-DD');

                        // lastCalibDate = moment(lastCalibDate).format('YYYY-MM-DD')
                        // console.log(arr_calibdates);
                        // var normalDate = "";
                        // for (let index = 0; index < arr_calibdates.length; index++) {
                        //     if (lastCalibDate < arr_calibdates[index]) {
                        //         normalDate = arr_calibdates[index];
                        //         break;
                        //     } else if (lastCalibDate == arr_calibdates[index]) {
                        //         if (arr_calibdates.length - 1 < index + 1) {
                        //             normalDate = "";
                        //         } else {
                        //             normalDate = arr_calibdates[index + 1];
                        //         }
                        //         break;
                        //     }

                        // }
                        // if (normalDate == "") {
                        //     var day = ("0" + arr1[0]).slice(-2)
                        //     var date = '';
                        //     var todaysmonth = today.getMonth() + 1;
                        //     var month = today.getMonth() + 2;

                        //     month = ("0" + month).slice(-2);
                        //     if (todaysmonth == 12) {
                        //         month = "01";
                        //         year = year + 1;
                        //     }
                        //     date = year + '-' + month + '-' + day;
                        //     normalDate = date;
                        //     balanceInfo.Bal_CalbDueDt = normalDate
                        // } else {
                        //     balanceInfo.Bal_CalbDueDt = normalDate
                        // }
                    }
                    // if (balanceInfo.IsNewBalance == 1) {
                    //     if (moment().format("YYYY-MM-DD") < monthlyDueDate) {
                    //         balanceInfo.Bal_CalbDueDt = monthlyDueDate
                    //     }
                    // }

                }

                var ResponseFrmPC = ""
                // getting reCaibration status from `tbl_recalibration_balance_status` on start up


                const tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
                var tempDetailCounterObjInsert = globalData.arrCalibInsertCounter.find(k => k.Hmi == strHmi);
                var tempCounter = globalData.arrCalibCounter.find(k => k.Hmi == strHmi);

                //29/05/22
                var _powerbackupCalib = {
                    strTableName: 'tbl_calibration_periodic_master_incomplete',
                    strDetailTbl: 'tbl_calibration_periodic_detail_incomplete',
                    cubicaNo: 'NUll',
                    cubicType: 'NUll',
                    cubicSysBFGcode: 'NUll',
                    cubicBatch: 'NUll',
                    menuName: 'Periodic',
                    productType: 'NUll',
                    Userid: tempUserObject.UserId,
                    idsNo: strResPiNo,
                    Hmi: strHmi,
                    RecSampleNo: tempCounter.counter,
                    ReportType: 'NUll',
                    _bal_id: strBalId

                }
                let _check_combination = await objPowerBackup._check_calibration_entry(strHmi, _powerbackupCalib, "tbl_powerbackup");
                if (_check_combination !== undefined) {
                    // let tempCounter = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi);
                    // if(tempCounter == undefined){
                    //     tempCounter  = globalData.arrCalibCounter.find(k => k.Hmi == strHmi);
                    // }
                    tempCounter.counter = _check_combination.RecSampleNo + 1;
                    if (tempDetailCounterObjInsert.insertingDetailCounter == 1) {
                        tempDetailCounterObjInsert.insertingDetailCounter = tempCounter.counter + 1
                    }
                    // _powerbackupCalib.RecSampleNo = tempCounter.counter 
                    tempCounter.counter = tempCounter.counter
                }
                _powerbackupCalib = {
                    strTableName: 'tbl_calibration_periodic_master_incomplete',
                    strDetailTbl: 'tbl_calibration_periodic_detail_incomplete',
                    cubicaNo: 'NUll',
                    cubicType: 'NUll',
                    cubicSysBFGcode: 'NUll',
                    cubicBatch: 'NUll',
                    menuName: 'Periodic',
                    productType: 'NUll',
                    Userid: tempUserObject.UserId,
                    idsNo: strResPiNo,
                    Hmi: strHmi,
                    RecSampleNo: tempCounter.counter,
                    ReportType: 'NUll',
                    _bal_id: strBalId

                }
                await objPowerBackup.get_Calib_Status_oF_Test_ForPowerBackup(_powerbackupCalib);

                var resArrOfDecimal = globalData.glbArrOfDecimal.find(k => k.Hmi == strHmi);
                if (resArrOfDecimal == undefined) {

                    globalData.glbArrOfDecimal.push({
                        Hmi: strHmi,
                        decimalPoint: ProtocolDecPoint
                    })
                }
                else {
                    var resArrOfDecimal1 = globalData.glbArrOfDecimal.find(k => k.Hmi == strHmi);
                    if (resArrOfDecimal1.decimalPoint >= ProtocolDecPoint) {
                        resArrOfDecimal1.decimalPoint = resArrOfDecimal1.decimalPoint;
                    } else {
                        resArrOfDecimal1.decimalPoint = ProtocolDecPoint;
                    }
                }
                resArrOfDecimal = globalData.glbArrOfDecimal.find(k => k.Hmi == strHmi);
                // detail tolerance added
                var combineTolernacedetail = "";
                var minimum = Number(objSentWt.Bal_StdWt - objSentWt.Bal_NegTol).toFixed(balanceInfo.Bal_DP);
                var maximum = Number(objSentWt.Bal_PosTol - objSentWt.Bal_StdWt).toFixed(balanceInfo.Bal_DP);
                if (minimum == maximum) {
                    combineTolernacedetail = combineTolernacedetail + '± ' + Number(minimum).toFixed(balanceInfo.Bal_DP);
                } else {
                    combineTolernacedetail = combineTolernacedetail + '- ' + Number(minimum).toFixed(balanceInfo.Bal_DP) + ' + ' + Number(maximum).toFixed(balanceInfo.Bal_DP);
                }


                if (parseInt(tempCounter.counter) == 0) {
                    /** code for storing all the wgt in column of std wgt ,neg tol and pos tol */
                    var combineStdWt = "";
                    var combineLowerLimit = "";
                    var combineUpperLimit = "";
                    var combineTolernace = "";
                    var minimumVal;
                    var maximumval;
                    for (let i of objBalRelWt.calibWt) {
                        combineStdWt = combineStdWt + Number(i.Bal_StdWt).toFixed(balanceInfo.Bal_DP) + ",";
                        combineLowerLimit = combineLowerLimit + Number(i.Bal_NegTol).toFixed(balanceInfo.Bal_DP) + ",";
                        combineUpperLimit = combineUpperLimit + Number(i.Bal_PosTol).toFixed(balanceInfo.Bal_DP) + ",";
                        minimumVal = i.Bal_StdWt - i.Bal_NegTol;
                        maximumval = i.Bal_PosTol - i.Bal_StdWt
                        if (minimumVal == maximumval) {
                            combineTolernace = combineTolernace + '± ' + minimumVal.toFixed(balanceInfo.Bal_DP) + ",";
                        } else {
                            combineTolernace = combineTolernace + '- ' + minimumVal.toFixed(balanceInfo.Bal_DP) + ' + ' + maximumval.toFixed(balanceInfo.Bal_DP) + ",";
                        }

                    }
                    combineLowerLimit = combineLowerLimit.slice(0, -1)
                    combineStdWt = combineStdWt.slice(0, -1)
                    combineUpperLimit = combineUpperLimit.slice(0, -1)
                    // Inserting entries in master table for daily/Periodic calibration
                    // Object for inserting data for Incommplete master


                    // removing cubicle according to resberryPi


                    var resulCubicleNo = await objClsInsertOp.getCubicalData(strResPiNo);


                    var RepNo = await obj_getRepSrNo.getReportSerialNumber('P', strBalId, strHmi, removeBalType[0].type);
                    var result = await models.tbl_precalibration_periodic.findAll({
                        attributes: [
                            [sequelize.fn('DISTINCT', sequelize.col('CalibrationBox_ID')), 'CalibrationBox_ID'],
                        ],
                        where: {
                            'Equipment_ID': strBalId,
                            // 'Standard_Weight_Block': objSentWt.Bal_StdWt,
                            'Equipment_Type': removeBalType[0].type == "analytical" ? "Balance" : "IPC Balance"
                        }
                    })

                    // Inserting 1st weight data in  tbl_calibration_periodic_detail_incomplete
                    var periodic_precalib_weights = result;
                    var weight_box_id = "";
                    var result_weightboc = "";
                    for (let i of periodic_precalib_weights) {
                        weight_box_id = i.CalibrationBox_ID.split(',')
                        for (let j = 0; j <= weight_box_id.length; j++) {
                            if (result_weightboc == '') {
                                result_weightboc = result_weightboc + weight_box_id[j] + ",";
                            } else {
                                if (weight_box_id[j] != undefined) {
                                    if (!result_weightboc.includes(weight_box_id[j])) {
                                        result_weightboc = result_weightboc + weight_box_id[j] + ",";
                                    }
                                }
                            }
                        }

                    }
                    var result1 = await models.tbl_precalibration_periodic.findAll({
                        where: {
                            'Equipment_ID': strBalId,
                            // 'Standard_Weight_Block': objSentWt.Bal_StdWt,
                            'Equipment_Type': removeBalType[0].type == "analytical" ? "Balance" : "IPC Balance"
                        }
                    })
                    await models.tbl_calibration_periodic_master_incomplete.create({
                        'Periodic_RepNo': RepNo,
                        'Periodic_CalbDate': moment().format('YYYY-MM-DD'),
                        'Periodic_CalbTime': moment().format('HH:mm:ss'),
                        'Periodic_BalID': balanceInfo.Bal_ID,
                        'Periodic_BalSrNo': balanceInfo.Bal_SrNo,
                        'Periodic_Make': balanceInfo.Bal_Make,
                        'Periodic_Model': balanceInfo.Bal_Model,
                        'Periodic_Unit': balanceInfo.Bal_Unit,
                        'Periodic_Dept': resulCubicleNo[0].Sys_dept == 'NULL' ? 'NA' : resulCubicleNo[0].Sys_dept,
                        'Periodic_LeastCnt': balanceInfo.Bal_LeastCnt,
                        'Periodic_MaxCap': balanceInfo.Bal_MaxCap.toFixed(balanceInfo.Bal_DP),
                        'Periodic_MinCap': balanceInfo.Bal_MinCap,
                        'Periodic_ZeroError': 0,
                        'Periodic_SpritLevel': 0,
                        'Periodic_GerneralCare': 0,
                        'Periodic_UserID': tempUserObject.UserId,
                        'Periodic_UserName': tempUserObject.UserName,
                        'Periodic_PrintNo': 0,
                        'Periodic_IsRecalib': BalanceRecalibStatusObject.PeriodicBalRecalib,
                        'Periodic_Location': balanceInfo.Bal_Location,
                        'Periodic_CubicalNo': resulCubicleNo[0].Sys_CubicNo,
                        'Periodic_Bal_MaxOR': Number(balanceInfo.Bal_MaxoptRange).toFixed(balanceInfo.Bal_DP),
                        'Periodic_Bal_MinOR': Number(balanceInfo.Bal_MinoptRange).toFixed(balanceInfo.Bal_DP),
                        'Periodic_RoomNo': balanceInfo.Bal_CalbDuration,
                        'Periodic_DueDate': balanceInfo.Bal_CalbDueDt,
                        // "Decimal_Point": resArrOfDecimal.decimalPoint,
                        "Periodic_DP": balanceInfo.Bal_DP,
                        'Periodic_StdWeight': combineStdWt,
                        'Periodic_NegTol': combineLowerLimit,
                        'Periodic_PosTol': combineUpperLimit,
                        'Periodic_AllWeightboxID': result_weightboc,
                        'Periodic_AllWeightboxCert': result1[0].CalibrationBox_Calibration_CertificateNo,
                        'Periodic_AllWeightboxValidUpto': result1[0].CalibrationBox_Validity_Date,
                        "Periodic_Frequency": "Monthly",
                        "Periodic_IsBinBalance": balanceInfo.IsBinBalance,
                        "Periodic_RoomNo": "",
                        "Periodic_CalbReason": "",
                        "Periodic_Pattern": "Circular/Square/Rectangular",
                        // "Periodic_calibStatus": balanceInfo.Bal_Status,
                        "Periodic_CubicalName": resulCubicleNo[0].CubicleID,
                        "Periodic_Area": resulCubicleNo[0].Sys_Area,
                        "Periodic_IDSNo": strHmi,
                        "Tolerance": combineTolernace,
                        "Periodic_Bal_Cert_No": balanceInfo.Bal_Cert_No
                    })


                    result = await models.tbl_precalibration_periodic.findAll({
                        where: {
                            'Equipment_ID': strBalId,
                            'Standard_Weight_Block': objSentWt.Bal_StdWt,
                            'Equipment_Type': removeBalType[0].type == "analytical" ? "Balance" : "IPC Balance"
                        }
                    })

                    // Inserting 1st weight data in  tbl_calibration_periodic_detail_incomplete
                    periodic_precalib_weights = result[0];

                    var remark
                    if (objSentWt.Bal_NegTol <= parseFloat(recieveWt) && (parseFloat(recieveWt) <= objSentWt.Bal_PosTol)) {
                        remark = 'Ok'
                    } else {
                        remark = 'Not Ok'
                    }

                    await models.tbl_calibration_periodic_detail_incomplete.create({
                        'Periodic_RepNo': RepNo,
                        'Periodic_RecNo': 1,
                        'Periodic_BalStdWt': Number(objSentWt.Bal_StdWt).toFixed(balanceInfo.Bal_DP),
                        'Periodic_BalNegTol': Number(objSentWt.Bal_NegTol).toFixed(balanceInfo.Bal_DP),
                        'Periodic_BalPosTol': Number(objSentWt.Bal_PosTol).toFixed(balanceInfo.Bal_DP),
                        'Periodic_ActualWt': recieveWt,
                        'Periodic_StdWtBoxID': periodic_precalib_weights.CalibrationBox_ID,
                        'Periodic_StdWt': periodic_precalib_weights.CalibrationBox_Selected_Elements,
                        'Periodic_WtIdentification': '',
                        'Periodic_WeightBox_certfctNo': periodic_precalib_weights.CalibrationBox_Calibration_CertificateNo,
                        'PercentofCapacity': 0,
                        'Periodic_DP': balanceInfo.Bal_DP,
                        'Periodic_ValDate': periodic_precalib_weights.CalibrationBox_Validity_Date,
                        "Periodic_Tolerance": combineTolernacedetail,
                        'Periodic_Remark': remark
                    })
                    await models.tbl_powerbackup.update({
                        Incomp_RepSerNo: RepNo,
                        WeighmentName: "Periodic"
                    }, {
                        where: {
                            Idsno: strHmi
                        }
                    });

                    // let objSentWtBal_StdWt = objFormulaFunction.FormatNumberString(objSentWt.Bal_StdWt, balanceInfo.Bal_DP)
                    var objSentWtBal_StdWt = parseFloat(objSentWt.Bal_StdWt).toFixed(balanceInfo.Bal_DP);
                    // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${tempCounter.counter + 1}:${objSentWtBal_StdWt + " " + strUnitAccordingDb}:${recieveWt + " " + perferUnit}`);

                    // activity Entry for Perioic Calibration start
                    var objDelay = globalData.delayApi.find(k => k.Hmi == strHmi)
                    if (objDelay == undefined) {
                        globalData.delayApi.push({
                            Flag: 1,
                            Hmi: strHmi
                        })
                    }
                    var objActivity = {}
                    Object.assign(objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { activity: `${mqttProtocol.Periodic} Calibration Started On TSH ${strHmi}` }
                    );
                    await objActivityLog.ActivityLogEntry(objActivity);
                    await objInstrumentUsage.InstrumentUsage('Balance', tempstrResPiNo, 'tbl_instrumentlog_balance', 'Periodic Calibration', 'started');

                } else {
                    var int_periodic_RecNo1;
                    // Selecting data from tbl_calibration_periodic_master_incomplete based on 'strBalId'

                    let result = await models.tbl_calibration_periodic_master_incomplete.findAll({

                        attributes: [[sequelize.fn('max', sequelize.col('Periodic_RepNo')), "Periodic_RepNo"]],
                        where: {
                            "Periodic_BalID": strBalId
                        }
                    })


                    let int_periodic_RepNo = result[0].Periodic_RepNo;
                    // Selecting Periodic_RecNo from tbl_calibration_periodic_detail_incomplete based on 'int_periodic_RepNo'

                    result = await models.tbl_calibration_periodic_detail_incomplete.findAll({
                        attributes: [
                            [sequelize.fn('max', sequelize.col('Periodic_RecNo')), "Periodic_RecNo"],

                        ],
                        where: {
                            "Periodic_RepNo": int_periodic_RepNo
                        },
                        raw: true
                    })

                    const Periodic_RecNo = result[0].Periodic_RecNo;
                    int_periodic_RecNo1 = Periodic_RecNo + 1;

                    // Selecting selectpreCalibWtObj from tbl_precalibration_periodic based on 'strBalId' and
                    // First weight was sent
                    result = await models.tbl_precalibration_periodic.findAll({
                        where: {
                            'Equipment_ID': strBalId,
                            'Standard_Weight_Block': objSentWt.Bal_StdWt,
                            'Equipment_Type': removeBalType[0].type == "analytical" ? "Balance" : "IPC Balance"
                        }
                    })


                    const periodic_precalib_weights = result[0];
                    // Inserting data in tbl_calibration_periodic_detail_incomplete
                    var remark
                    if (objSentWt.Bal_NegTol <= parseFloat(recieveWt) && (parseFloat(recieveWt) <= objSentWt.Bal_PosTol)) {
                        remark = 'Ok'
                    } else {
                        remark = 'Not Ok'
                    }

                    await models.tbl_calibration_periodic_detail_incomplete.create({
                        'Periodic_RepNo': int_periodic_RepNo,
                        'Periodic_RecNo': int_periodic_RecNo1,
                        'Periodic_BalStdWt': Number(objSentWt.Bal_StdWt).toFixed(balanceInfo.Bal_DP),
                        'Periodic_BalNegTol': Number(objSentWt.Bal_NegTol).toFixed(balanceInfo.Bal_DP),
                        'Periodic_BalPosTol': Number(objSentWt.Bal_PosTol).toFixed(balanceInfo.Bal_DP),
                        'Periodic_ActualWt': recieveWt,
                        'Periodic_StdWtBoxID': periodic_precalib_weights.CalibrationBox_ID,
                        'Periodic_StdWt': periodic_precalib_weights.CalibrationBox_Selected_Elements,
                        'Periodic_WtIdentification': '',
                        'Periodic_WeightBox_certfctNo': periodic_precalib_weights.CalibrationBox_Calibration_CertificateNo,
                        'PercentofCapacity': 0,
                        // 'Periodic_CertDate': periodic_precalib_weights.CalibrationBox_Calibration_Date,
                        'Periodic_DP': balanceInfo.Bal_DP,
                        'Periodic_ValDate': periodic_precalib_weights.CalibrationBox_Validity_Date,
                        "Periodic_Tolerance": combineTolernacedetail,
                        'Periodic_Remark': remark
                    })

                    // await models.tbl_calibration_periodic_master_incomplete.update({
                    //     "Decimal_Point": resArrOfDecimal.decimalPoint,
                    //     //"Uncertinity_EndTime": date.format(new Date(), 'HH:mm:ss')
                    // }, {
                    //     where: {
                    //         "Periodic_RepNo": int_periodic_RepNo
                    //     }
                    // });
                    // let objSentWtBal_StdWt = objFormulaFunction.FormatNumberString(objSentWt.Bal_StdWt, balanceInfo.Bal_DP)
                    var objSentWtBal_StdWt = parseFloat(objSentWt.Bal_StdWt).toFixed(balanceInfo.Bal_DP);
                    //  mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${tempCounter.counter + 1}:${objSentWtBal_StdWt + " " + strUnitAccordingDb}:${recieveWt + " " + perferUnit}`);

                    // await objInstrumentUsage.InstrumentUsage('Balance', tempstrResPiNo, 'tbl_instrumentlog_balance', '', 'completed');

                }

                let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi).configSetting;
                let autoTare = hmiEntryinConfig[0].AutoTare;
                let tareCommand = hmiEntryinConfig[0].Tare_Command


                if (objSentWt.Bal_NegTol <= parseFloat(recieveWt) && (parseFloat(recieveWt) <= objSentWt.Bal_PosTol)) {

                    if (parseInt(tempCounter.counter) != objBalRelWt.calibWt.length - 1) {
                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${tempCounter.counter + 1}:${Number(objSentWtBal_StdWt).toFixed(balanceInfo.Bal_DP) + " " + strUnitAccordingDb}:${Number(recieveWt).toFixed(balanceInfo.Bal_DP) + " " + perferUnit}`);
                    }

                    if (autoTare) {
                        mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                    }

                    await objMonit.monit({ case: 'CalibWeight', Hmi: strHmi, data: { Weight: recieveWt } });


                    if (parseInt(tempCounter.counter) == objBalRelWt.calibWt.length - 1) {
                        console.log('done');
                        let tempCount = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi);
                        tempCount.counterApi = tempCount.counterApi + 1;
                        // let balCalDetPeri = globalData.arrBalCaibDet.find(k => k.strBalId == strBalId);
                        // balCalDetPeri.isPeriodicDone = true;
                        // Updating Periodic status from 0 -> 1 in calibration_status table as well as our global array
                        // which holding calibration status
                        // If this calibration is last calibration then we have to move all caibration records
                        // to complete tables
                        // objFailedFlag.failFlagPeriodic = false;
                        var arr_sortedCalibArray = await sort.sortedSeqArray(globalData.arrSortedCalib, strBalId, removeBalType[0].type);
                        let lastCalibration = arr_sortedCalibArray[arr_sortedCalibArray.length - 1];
                        //find globalData.calibrationStatus according to hmi.

                        //remove max decimal from globalData.glbArrOfDecimal
                        var removedArrOfDecimal = globalData.glbArrOfDecimal.find(k => k.Hmi == strHmi);
                        let decimalNumber = removedArrOfDecimal.decimalPoint;


                        //update max decimal point in master table


                        result = await models.tbl_calibration_periodic_master_incomplete.findAll({
                            attributes: [
                                [sequelize.fn('max', sequelize.col('Periodic_RepNo')), "Periodic_RepNo"]

                            ],
                            where: {
                                "Periodic_BalID": strBalId
                            },
                            raw: true
                        })

                        // let intPeriodic_RepNo = result[0]["max(`Periodic_RepNo`)"];
                        let intPeriodic_RepNo = result[0].Periodic_RepNo;


                        result = await models.tbl_calibration_periodic_master_incomplete.update({
                            // "Decimal_Point": decimalNumber,
                            "Periodic_EndTime": date1.format(new Date(), 'HH:mm:ss')
                        }, {
                            where: {
                                "Periodic_RepNo": intPeriodic_RepNo
                            }
                        })

                        // const UpdateObj = {
                        //     str_tableName: "tbl_calibration_periodic_master_incomplete",
                        //     data: [
                        //         { str_colName: 'Decimal_Point', value: decimalNumber },
                        //     ],
                        //     condition: [
                        //         { str_colName: 'Periodic_RepNo', value: intPeriodic_RepNo, comp: 'eq' },
                        //     ]
                        // }
                        // await database.update(UpdateObj);

                        globalData.glbArrOfDecimal.splice(globalData.glbArrOfDecimal.findIndex((element) => element.Hmi === strHmi), 1)

                        var calibType = 'P';
                        for (var i in globalData.calibrationStatus) {
                            if (globalData.calibrationStatus[i].BalId == strBalId) {
                                globalData.calibrationStatus[i].status[calibType] = 1;
                                break; //Stop this loop, we found it!
                            }
                        }

                        /**
                         * Update According To IPC Balance or Analytical Balance
                         */
                        await comman.updateCalibStatus('P', strBalId, removeBalType[0].type)
                        await comman.incompleteToComplete('P', strBalId, removeBalType[0].type);
                        if (lastCalibration == 'P') {
                            await comman.UpdateRecalibFLagPeriodic(strBalId, removeBalType[0].type, "monthly");
                            BalanceRecalibStatusObject.PeriodicBalRecalib = 0;
                        }
                        let strResPiNo = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi).ResbPi;
                        await objInstrumentUsage.InstrumentUsage('Balance', strResPiNo, 'tbl_instrumentlog_balance', '', 'completed');
                        // objInstrumentUsage.InstrumentUsage('Balance', IDSSrNo, 'tbl_instrumentlog_balance', '', 'completed')
                        // result = await checkForPenCal.checkForPendingCalib(strBalId, IDSSrNo);
                        // activity Entry for Perioic Calibration Completion
                        // const tempUserObject = globalData.arrUsers.find(k => k.IdsNo == IDSSrNo);
                        var objActivity = {}

                        //  globalData.arrCalibCounter.splice(globalData.arrCalibCounter.findIndex((e) => e.Hmi == strHmi) , 1);
                        // //  globalData.arrCalibCounterApi.splice(globalData.arrCalibCounterApi.findIndex((e) => e.Hmi == strHmi) , 1);

                        // mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${tempCounter.counter + 1}:${objSentWtBal_StdWt + " " + strUnitAccordingDb}:${recieveWt + " " + perferUnit}`);

                        Object.assign(objActivity,
                            { strUserId: tempUserObject.UserId },
                            { strUserName: tempUserObject.UserName },
                            { activity: `${mqttProtocol.Periodic} Calibration Completed On TSH ${strHmi}` });

                        await objActivityLog.ActivityLogEntry(objActivity);

                        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${tempCounter.counter + 1}:${Number(objSentWtBal_StdWt).toFixed(balanceInfo.Bal_DP) + " " + strUnitAccordingDb}:${Number(recieveWt).toFixed(balanceInfo.Bal_DP) + " " + perferUnit}`);
                        mqttSender.sendData(strHmi, `${mqttProtocol.Periodic} Calibration Completed`);

                        return Object.assign(resObj,
                            { strUserId: "tempUserObject.UserId" },
                            { strUserName: "tempUserObject.UserName" },
                            { status: 'Perioic Calibration Completed' });
                        // return result;

                    } else {
                        // console.log('else');
                        var tempCounter = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi);
                        tempCounter.counterApi = tempCounter.counterApi + 1; //{ 'Hmi': strHmi, 'BalId' :  strBalId , 'counterApi': srNo }

                    }

                } else {
                    // We have to move records to failed tables
                    await models.tbl_powerbackup.destroy({
                        where: {
                            WeighmentName: "Periodic",
                            Idsno: strHmi
                        }
                    })
                    await objMonit.monit({ case: 'CalibFail', Hmi: strHmi, data: { calibType: mqttProtocol.Periodic } });

                    let result = await models.tbl_calibration_periodic_master_incomplete.findAll({
                        attributes: [[sequelize.fn('max', sequelize.col('Periodic_RepNo')), 'Periodic_RepNo']],
                        where: {
                            "Periodic_BalID": strBalId
                        }
                    })


                    let int_periodic_RepNo;
                    if (result.length == 0) {
                        int_periodic_RepNo = 1;
                    } else {
                        int_periodic_RepNo = result[0].Periodic_RepNo;

                        var removedArrOfDecimal = globalData.glbArrOfDecimal.find(k => k.Hmi == strHmi);
                        let decimalNumber = removedArrOfDecimal.decimalPoint;

                        // await models.tbl_calibration_periodic_master_incomplete.update({
                        //     "Decimal_Point": decimalNumber,
                        //     //"Uncertinity_EndTime": date.format(new Date(), 'HH:mm:ss')
                        // }, {
                        //     where: {
                        //         "Periodic_RepNo": int_periodic_RepNo
                        //     }
                        // });

                        await comman.caibrationFails('P', int_periodic_RepNo, strBalId, 'Monthly', false, removeBalType[0].type);
                    }

                    (globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCalibCounterApi : globalData.arrCalibCounterApi.splice(globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi), 1);
                    (globalData.arrCalibCounter.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCalibCounter : globalData.arrCalibCounter.splice(globalData.arrCalibCounter.findIndex((element) => element.Hmi === strHmi), 1);
                    (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus : globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1)
                        (globalData.arrcalibType.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrcalibType : globalData.arrcalibType.splice(globalData.arrcalibType.findIndex((element) => element.Hmi === strHmi), 1)
                            (globalData.delayApi.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.delayApi : globalData.delayApi.splice(globalData.delayApi.findIndex((element) => element.Hmi === strHmi), 1)


                    var objActivity = {};
                    Object.assign(objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { activity: `${mqttProtocol.Periodic} Calibration Failed On TSH ${strHmi}` }
                    );
                    await objActivityLog.ActivityLogEntry(objActivity);
                    // await objInstrumentUsage.InstrumentUsage('Balance', tempstrResPiNo, 'tbl_instrumentlog_balance', '', 'completed');
                    mqttSender.sendData(strHmi, `DisplayResult:${tempCounter.counter + 1}:${Number(objSentWtBal_StdWt).toFixed(balanceInfo.Bal_DP) + " " + strUnitAccordingDb}:${Number(recieveWt).toFixed(balanceInfo.Bal_DP) + " " + perferUnit}:Calibration Failed`);
                    if (autoTare) {
                        mqttSender.sendData(strHmi, `${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                    }
                    //mqttSender.sendData(strHmi, `${mqttProtocol.TestCompleted}false:Calibration Failed`);
                    console.log('Calibration Failed');
                    return 'CF';

                }

            }
        }
        catch (err) {
            console.log("Error from verifyWeights of Periodic", err)
            return `Error from verifyWeights of Periodic  ${err}`;
        }

    }

    async RaspberryDetailsWithHmi(strRasPi) {
        try {
            const obj = {
                str_tableName: 'tbl_idsport_details',
                data: '*',
                condition: [
                    { str_colName: 'Sys_IDSNo', value: strRasPi }
                ]
            }

            let arrRes = await database.select(obj);
            return arrRes[0][0].HMI
        } catch (error) {
            throw new Error(error)
        }
    }

    async precision(a) {
        if (!isFinite(a)) return 0;
        var e = 1, p = 0;
        while (Math.round(a * e) / e !== a) { e *= 10; p++; }
        return p;
    }
}
module.exports = CalibrationModel