const DailyCalibrationModel = require('./clsdailyCalibration.model');
const PeriodicCalibrationModel = require('./clsPeriodicCalibration.model')
const EccentricityCalibrationModel = require('./clsEccentricity.model');
const RepeatabilityCalibrationModel = require('./clsRepeatability.model'); 
const UncertinityCalibrationModel = require('./clsUncertainty.model');
const LinearityCalibrationModel = require('./clsLinearity.model');
const GLOBAL_NOMENCLATURE = require('../../global/GLOBAL_NOMENCLATURE');

const dailyCalibrationModel = new DailyCalibrationModel();
const periodiccalibrationModel = new PeriodicCalibrationModel();
const eccentricityCaibration = new EccentricityCalibrationModel();
const repetabilityCalibration = new RepeatabilityCalibrationModel();
const uncertinityCalibModel = new UncertinityCalibrationModel();
const linearityCalibration = new LinearityCalibrationModel();
//************************************************************************************************************ */
// Below function Checks for which type of calibration is going on. calibType variable holds the current selected 
// calibration Type Also this function invokes On 'CP'
//************************************************************************************************************* */
function calibPendingDecider(strCalibType, strHmi, strBalId, rasbpi) {
    return new Promise((resolve, reject) => {
        // tempCailibType = globalData.arrcalibType.find(k=>k.idsNo == IDSSrNo); 
        // var calibType = tempCailibType.calibType;
        switch (strCalibType.toLowerCase()) {
            case GLOBAL_NOMENCLATURE.Daily.toLowerCase():
                dailyCalibrationModel.getCalibWeights(strBalId, strHmi, rasbpi).then(result => {
                    resolve(result);
                })
                break;
            case GLOBAL_NOMENCLATURE.Periodic.toLowerCase():
                periodiccalibrationModel.getCalibWeights(strBalId, strHmi, rasbpi).then(result => {
                    resolve(result);
                });
                break;
            case 'verCalb':
                break;
            case GLOBAL_NOMENCLATURE.Uncertainty.toLowerCase():
                uncertinityCalibModel.getCalibWeights(strBalId, strHmi, rasbpi).then(result => {
                    resolve(result);
                })
                break;
            case GLOBAL_NOMENCLATURE.Repetability.toLowerCase():
                repetabilityCalibration.getCalibWeights(strBalId, strHmi, rasbpi).then(result => {
                    resolve(result);
                })
                break;
            case GLOBAL_NOMENCLATURE.Eccentricity.toLowerCase():
                eccentricityCaibration.getCalibWeights(strBalId, strHmi, rasbpi).then(result => {
                    resolve(result);
                })
                break;
            case 'linearity':
                linearityCalibration.getCalibWeights(strBalId, strHmi, rasbpi).then(result => {
                    resolve(result);
                })
                break;
            case 'positional':
                break;
            default:
                console.log('Cal Decider not set');
                break;
        }
    })
}

module.exports.calibPendingDecider = calibPendingDecider;
