const Database = require('../../database/clsQueryProcess');
const database = new Database();
const globalData = require('../../global/globalData');
const serverConfig = require('../../global/serverConfig');
const moment = require('moment');
const date1 = require('date-and-time');
const mqttProtocols = require('../../global/GLOBAL_NOMENCLATURE');
// const clsprotocolHandler = require('../../controller/login.controller');
const clsPreWeighmentCheck = require('../../../Interface/model/preWeighmentCheck');
const clsdailyCalibration = require('../../../Interface/model/Calibration/clsdailyCalibration.model')
const clsMqttSender = require('../../model/Mqtt/mqttSender.class');
const { models } = require('../../../config/dbConnection');
const { Op } = require('sequelize');
// const protocolHandler = new clsprotocolHandler();
var objPreWeighmentCheck = new clsPreWeighmentCheck();
var objdaily = new clsdailyCalibration();
const mqttSender = new clsMqttSender();

class AlertModel {
    constructor() { }
    /**
     * @description Given function will show alert
     */

    async showAlert() {
        //  console.log('AlertArray', globalData.alertArrTemp);
        try {


            let alertArray = [];
            alertArray = globalData.alertArrTemp;

            // var regExp = /(\d{1,2})\:(\d{1,2})\:(\d{1,2})/;
            if (alertArray.length > 0) {
                for (let i = 0; i < alertArray.length; i++) {

                    var strHmi = alertArray[i].IDSNO;

                    var result = await models.tbl_cubical.findAll({
                        where: {
                            Sys_Batch: alertArray[i].strBatch,
                            Sys_IDSNo: alertArray[i].IDSNO,
                            Sys_CubicNo: alertArray[i].intCubicleNo
                        }
                    })
                    var result = [result];
                    if (result[0].length > 0 && result[0][0].Sys_BatchReuse != 1) {
                        var batchStartCheck = await objPreWeighmentCheck.checkBatchStartFORAlert(alertArray[i]);
                        var batchStartCheck = batchStartCheck.message

                        let now = new Date();
                        let todayDate = moment(now).format('YYYY-MM-DD');
                        var updateTime;
                        var currentTime = moment(now).format('HH:mm:ss');

                        const chkAlertParam = await models.tbl_alert_param_duration.findAll({
                            where: {
                                CubicNo: alertArray[i].intCubicleNo,
                                Batch: alertArray[i].strBatch,
                            }
                        });

                        if (result[0][0].Sys_Area != 'Capsule Filling') {
                            var response = await models.tbl_product_tablet.findAll({
                                where: {
                                    ProductId: result[0][0].Sys_BFGCode,
                                    ProductName: result[0][0].Sys_ProductName,
                                    ProductVersion: result[0][0].Sys_PVersion,
                                    Version: result[0][0].Sys_Version
                                }
                            })
                        } else {
                            var response = await models.tbl_product_capsule.findAll({
                                where: {
                                    ProductId: result[0][0].Sys_BFGCode,
                                    ProductName: result[0][0].Sys_ProductName,
                                    ProductVersion: result[0][0].Sys_PVersion,
                                    Version: result[0][0].Sys_Version
                                }
                            })
                        }

                        if (chkAlertParam[0].Group > 0 && (response[0].Param2_Nom != 99999 && response[0].Param2_Nom != null) &&
                            (response[0].Param2_T2Neg != 99999 && response[0].Param2_T2Neg != null) && (response[0].Param2_T2Pos != 99999 && response[0].Param2_T2Pos != null)) {
                            if (alertArray[i].AlertTime.split(":")[0].length == 1) {
                                let updateTime1 = "0" + alertArray[i].AlertTime
                                updateTime = updateTime1;
                            }
                            else {
                                updateTime = alertArray[i].AlertTime;
                            }
                            // updatedTime = moment(alertArray[i].AlertTime, 'HH:mm:ss')
                            //     .add(alertArray[i].intGroupParam, 'minutes')
                            let datetimeA = moment(moment(alertArray[i].AlertDate).format('YYYY-MM-DD') + " " + updateTime);
                            let datetimeB = moment(moment(todayDate).format('YYYY-MM-DD') + " " + currentTime);
                            let datetimeC = datetimeB.diff(datetimeA, 'minutes');

                            if (batchStartCheck === "Batch Started") {
                                // var impresentt = globalData.impresentarr.find(k => parseFloat(k.ids) == alertArray[i].IDSNO);
                                if (datetimeC >= alertArray[i].intGroupParam) {

                                    var flagstatus = await objPreWeighmentCheck.checkgrpflag(alertArray[i]);

                                    mqttSender.sendDataAlert(`${(alertArray[i].IDSNO)}`, `${mqttProtocols.DisplayMessage}Group Weighment Pending`);

                                    if (flagstatus == 0) {
                                        var getTime = [];
                                        let time = moment(moment(alertArray[i].AlertDate).format('YYYY-MM-DD') + " " + updateTime)
                                        getTime.push(time);

                                        for (let value of getTime) {
                                            var setTime = moment(value).add(alertArray[i].intGroupParam, 'minutes');
                                            //   console.log(setTime);
                                            let datetime1 = setTime
                                            let datetime2 = datetimeB;
                                            let datetimer = datetime2.diff(datetime1, 'minutes');
                                            if (datetimer < 0) {
                                                alertArray[i].AlertTime = moment(value).format('HH:mm:ss');
                                                // alertArray[i].AlertDate = moment(todayDate).format('YYYY-MM-DD');
                                                alertArray[i].AlertDate = moment(now);
                                                var groupAlertRes = await models.tbl_batches.update({
                                                    dt1: date1.format(now, 'YYYY-MM-DD'),
                                                    tm1: moment(value).format('HH:mm:ss'),
                                                    grpflag: 1
                                                }, {
                                                    where: {
                                                        Batch: alertArray[i].strBatch,
                                                        [Op.or]: [{ Status: "S" }, { Status: "R" }],
                                                        CubicNo: alertArray[i].intCubicleNo,
                                                        Prod_Name: result[0][0].Sys_ProductName,
                                                    }
                                                });

                                                // var groupAlertRes = await database.execute(`UPDATE tbl_batches SET dt1='${date1.format(now, 'YYYY-MM-DD')}', tm1='${moment(value).format('HH:mm:ss')}', grpflag =1 WHERE Batch= '${alertArray[i].strBatch}' AND (Status = 'S' OR Status = 'R')`);
                                                console.log(` time updated successfully: ` + moment(value).format('HH:mm:ss'));
                                            } else {
                                                getTime.push(setTime);
                                            }
                                        }


                                    }

                                }

                            }
                        }
                    } else {
                        globalData.alertArrTemp = globalData.alertArrTemp.filter(k => k.IDSNO != alertArray[i].IDSNO);
                        console.log("data filter batch is resume");
                        alertArray = alertArray.filter(k => k.IDSNO != alertArray[i].IDSNO);
                    }
                    // globalData.alertArr.findIndex(
                    //     (element) => element.IDSNO === strHmi
                    //   ) == -1
                    //     ? globalData.alertArr
                    //     : globalData.alertArr.splice(
                    //       globalData.alertArr.findIndex(
                    //         (element) => element.IDSNO === strHmi
                    //       ),
                    //       1
                    //     );
                }
            }
        } catch (error) {
            console.log(error);

        }
    }

    /**
     * @param {*} IDSNO IDSSR NO
     * @description Below function is for alerts
     */
    async handleDRProtocol(IDSNO) {
        return new Promise((resolve, reject) => {
            // First we have to update the time for specific Ids in alerts array
            // let now = new Date();
            // let tempAlertObj = globalData.alertArrTemp.find(k => k.IDSNO == parseInt(IDSNO));
            // if (tempAlertObj != undefined) {
            //     let currentTime = date1.format(now, 'hh:mm:ss')
            //     tempAlertObj.AlertTime = currentTime;
            // }
            // console.log(globalData.alertArrTemp)
            resolve('+');
        })
    }
    /**
     * 
     */

    async updateAlertObject() {
        let cubiData = await models.tbl_cubical.findAll({
            where: {
                Sys_flagAlert: "1"
            },
        });
        let result = [cubiData];
        if (result[0].length > 0) {  //if user set or update alert flag
            for (let val of result[0]) {
                let cubicNo = val.Sys_CubicNo;

                let tempAlertObj = globalData.alertArrTemp.find(k => k.intCubicleNo == cubicNo);
                const objAlert = await models.tbl_alert_param_duration.findAll()

                let alerParam = [objAlert];

                let objAlertParam = alerParam[0].find(k => k.CubicNo == cubicNo);

                var batchesParam = await models.tbl_batches.findAll({
                    where: {
                        Batch: val.Sys_Batch,
                        [Op.or]: [{ Status: "S" }, { Status: "R" }],
                        CubicNo: cubicNo,
                        Prod_Name: val.Sys_ProductName
                    }
                })
                var batchesParam = [batchesParam]
                var tm1

                if (batchesParam[0].length > 0) {
                    // if (val.Sys_RptType == 1) {
                    //     globalData.alertArrTemp = globalData.alertArrTemp
                    //     .filter(k => k.IDSNO != val.Sys_IDSNo)
                    // } else {
                    if (tempAlertObj !== undefined) {
                        if (objAlertParam.Group == 0) { // Group alerts are only for Standard run

                            globalData.alertArrTemp = globalData.alertArrTemp
                                .filter(k => k.IDSNO != val.Sys_IDSNo)

                        } else {

                            tempAlertObj.strBatch = val.Sys_Batch;
                            tempAlertObj.intGroupParam = objAlertParam.Group;
                            tempAlertObj.AlertTime = moment(batchesParam[0][0].tm1, 'HH:mm:ss').format('HH:mm:ss');
                            tempAlertObj.IDSNO = val.Sys_IDSNo;
                            tempAlertObj.AlertDate = batchesParam[0][0].dt1;
                            tempAlertObj.impresent = false;

                        }
                    } else {
                        if (objAlertParam.Group != 0) {
                            let tempobj = {
                                intCubicleNo: cubicNo,
                                strBatch: val.Sys_Batch,
                                intGroupParam: objAlertParam.Group,
                                AlertTime: moment(batchesParam[0][0].tm1, 'HH:mm:ss').format('HH:mm:ss'),
                                IDSNO: val.Sys_IDSNo,
                                AlertDate: batchesParam[0][0].dt1,
                                // impresent: false

                            }
                            globalData.alertArrTemp.push(tempobj)
                            console.log("data push sucessfully");
                        }
                    }
                    // }
                }
                if (batchesParam[0].length == 0) {
                    if (objAlertParam.Group == 0) {
                        globalData.alertArrTemp = globalData.alertArrTemp
                            .filter(k => k.IDSNO != val.Sys_IDSNo)
                        console.log("data deleted sucessfully" + val.Sys_IDSNo);

                    }
                }
                let updateCubicAlertVal = await models.tbl_cubical.update({ //once all data gets fetched, set flag alert 0 in cub
                    Sys_flagAlert: 0
                },
                    {
                        where: {
                            Sys_CubicNo: cubicNo
                        }

                    });
                // await database.update(updateCubicAlertVal);
                console.log("flag alert set 0 in cubical");
            }
            //  console.log('ASD',globalData.alertArrTemp)
        }


    }
}
module.exports = AlertModel;
