'use strict'

const mssql = require('./')

const sqlConfig = {
  password: 'Upper_l0wercase',
  database: 'di_production',
  stream: false,
  authentication: {
    type: 'test',
  },
  options: {
    trustServerCertificate: true,
    enableArithAbort: true,
    encrypt: true,
    abortTransactionOnError: false,
  },
  pool: {
    max: 1,
    min: 0,
  },
  port: 1433,
  user: 'sa',
  server: 'localhost',
}

async function main () {
  const pool = new mssql.ConnectionPool(sqlConfig)
  await pool.connect()

  const table = new mssql.Table('Sandbox.dbo.BulkTest')
  table.create = true
  table.columns.add('ABigInt', mssql.BigInt);
  table.rows.add(1.2)

  const transaction = new mssql.Transaction(pool);
  await transaction.begin();

  try {
    const request = new mssql.Request(transaction)
    await request.bulk(table)
    await transaction.commit();
  } catch (error) {
    console.error(error)
    await transaction.rollback();
  } finally {
    await pool.close();
  }
}

main().catch(console.error);
