const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_cap_detail6', {
    RecNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    RepSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    MstSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    RecSeqNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    DT_Side: {
      type: DataTypes.STRING(10),
      allowNull: false,
      defaultValue: "0"
    },
    DT_Jar: {
      type: DataTypes.STRING(10),
      allowNull: true,
      defaultValue: "NA"
    },
    DT_Temp: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: "NULL"
    },
    DT_StartDate: {
      type: DataTypes.STRING(50),
      allowNull: false
    },
    DT_StartTm: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: "00:00:00"
    },
    DT_EndTm: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: "00:00:00"
    },
    DT_RunTime: {
      type: DataTypes.STRING(50),
      allowNull: false
    },
    DT_Remark: {
      type: DataTypes.STRING(200),
      allowNull: false
    },
    DT_DoneByID: {
      type: DataTypes.STRING(50),
      allowNull: false
    },
    DT_DoneByName: {
      type: DataTypes.STRING(300),
      allowNull: false
    },
    DT_HaltDur: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Layer: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    LayerName: {
      type: DataTypes.STRING(50),
      allowNull: true
    }
  }, {
    sequelize,
    tableName: 'tbl_cap_detail6',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: "PK__tbl_cap___36047C744EBC040E",
        unique: true,
        fields: [
          { name: "RecNo" },
        ]
      },
    ]
  });
};
