const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  var seq = sequelize.define('tbl_calibration_repetability_master_temp', {
    Repet_RepNo: {
      type: DataTypes.INTEGER,
      allowNull: false
    },
    Repet_CalbDate: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Rep_DueDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    Rep_CalbTime: {
      type: DataTypes.TIME,
      allowNull: true
    },
    Rep_CubicalNo: {
      type:DataTypes.INTEGER,
      allowNull:true,
      defaultValue: 0
    },
    Rep_CubicalName:{
      type:DataTypes.STRING(500),
      allowNull:true,
      defaultValue: "NULL"
    },
    Rep_Area:{
      type:DataTypes.STRING(500),
      allowNull:true,
      defaultValue: "NULL"
    },
    Rep_IDSNo:{
      type:DataTypes.INTEGER,
      allowNull:true,
      defaultValue: 0
    },
    Rep_BalID: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Rep_Serial: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Rep_Make: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Rep_Model: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Rep_Unit: {
      type: DataTypes.STRING(5),
      allowNull: true,
      defaultValue: "NULL"
    },
    Rep_Dept: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Rep_MassWeight: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Rep_LeastCnt: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Rep_MaxCap: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Rep_MinCap: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Rep_Bal_MinOR:{
      type:DataTypes.STRING(50),
      allowNull:true,
      defaultValue:"0"
    },
    Rep_Bal_MaxOR:{
      type:DataTypes.STRING(50),
      allowNull:true,
      defaultValue: "0"
    },
    Rep_ZeroError: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Rep_SpritLevel: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Rep_GeneralCare: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Rep_UserID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Rep_UserName: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue: "NULL"
    },
    Rep_VerifyID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Rep_VerifyName: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue: "NULL"
    },
    Rep_VerifyDate: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "1992-12-08 00:00:00"
    },
    Rep_PrintNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Rep_IsRecalib:{
      type:DataTypes.INTEGER,
      allowNull:true,
      defaultValue: 0
    },
    Rep_DP: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Rep_StdWeight: {
      type: DataTypes.STRING(5000),
      allowNull: true,
      defaultValue: "0"
    },
    Rep_NegTol: {
      type: DataTypes.STRING(5000),
      allowNull: true,
      defaultValue: "0"
    },
    Rep_PosTol: {
      type: DataTypes.STRING(5000),
      allowNull: true,
      defaultValue: "0"
    },
    Rep_Remark:{
      type:DataTypes.STRING(500),
      allowNull:true,
      defaultValue: "NULL"

    },
    Rep_AllWeightboxID: {
      type: DataTypes.STRING(1000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Rep_AllWeightboxCert: {
      type: DataTypes.STRING(1000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Rep_AllWeightboxValidUpto: {
      type: DataTypes.STRING(1000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Rep_IsBinBalance: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    HMIID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
  Rep_Per:{
    type:DataTypes.STRING(50),
    allowNull:true,
    defaultValue: "0"
  },
  Rep_Deviation:{
    type:DataTypes.STRING(50),
    allowNull:true,
    defaultValue: "0"
  },
  Rep_Mean:{
    type:DataTypes.STRING(50),
    allowNull:true,
    defaultValue: "0"
  },
  Rep_Location: {
    type: DataTypes.STRING(50),
    allowNull: true,
    defaultValue: "NULL"
  },
  Rep_RoomNo: {
    type: DataTypes.STRING(50),
    allowNull: true,
    defaultValue: "NULL"
  },
  Rep_calibStatus: {
    type: DataTypes.STRING(50),
    allowNull: true,
    defaultValue: "NULL"
  },
  Rep_CalbReason: {
    type: DataTypes.STRING(50),
    allowNull: true,
    defaultValue: "NULL"
  },
  Rep_Pattern: {
    type: DataTypes.STRING(50),
    allowNull: true,
    defaultValue: "NULL"
  },
  Rep_Frequency: {
    type: DataTypes.STRING(50),
    allowNull: true,
    defaultValue: "NULL"
  },
  Rep_Bal_Cert_No: {
    type: DataTypes.STRING(50),
    allowNull: true,
    defaultValue: "NULL"
  }

  }, {
    sequelize,
    tableName: 'tbl_calibration_repetability_master_temp',
    timestamps: false
  });
  seq.removeAttribute('id')
  return seq
};
