const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  var seq = sequelize.define('tbl_calibration_linearity_detail_temp', {
    Linear_RepNo: {
      type: DataTypes.INTEGER,
      allowNull: false
    },
    Linear_RecNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Linear_BalStdWt: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: 0.00000
    },
    Linear_BalNegTol: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: 0.00000
    },
    Linear_BalPosTol: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: 0.00000
    },
    Linear_ActualWt: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: 0.00000
    },
    Linear_StdWtBoxID: {
      type: DataTypes.STRING(5000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Linear_StdWt: {
      type: DataTypes.STRING(5000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Linear_WtIdentification: {
      type: DataTypes.STRING(5000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Linear_WeightBox_certfctNo: {
      type: DataTypes.STRING(5000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Linear_DP: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    PercentofCapacity: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },    
    Linear_ValDate: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    HMIID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Linear_Tolerance: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Linear_Remark : {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Linear_Diff : {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    }
  }, {
    sequelize,
    tableName: 'tbl_calibration_linearity_detail_temp',
    timestamps: false
  });
  seq.removeAttribute('id')
  return seq
};
