const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_calibration_daily_master_incomplete', {
    Daily_RepNo: {
      autoIncrement: true,
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    },
    Daily_CalbDate: {
      type: DataTypes.DATEONLY,
      allowNull: false
    },
    Daily_CalbTime: {
      type: DataTypes.TIME,
      allowNull: false,
      defaultValue: "00:00:00"
    },
    Daily_BalID: {
      type: DataTypes.STRING(100),
      allowNull: false,
      defaultValue: "NULL"
    },
    Daily_BalSrNo: {
      type: DataTypes.STRING(100),
      allowNull: false,
      defaultValue: "NULL"
    },
    Daly_Make: {
      type: DataTypes.STRING(100),
      allowNull: false,
      defaultValue: "NULL"
    },
    Daily_Model: {
      type: DataTypes.STRING(100),
      allowNull: false,
      defaultValue: "NULL"
    },
    Daily_Unit: {
      type: DataTypes.STRING(5),
      allowNull: false,
      defaultValue: "NULL"
    },
    Daily_Dept: {
      type: DataTypes.STRING(100),
      allowNull: false,
      defaultValue: "NULL"
    },
    Daily_LeastCnt: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: 0.00000
    },
    Daily_MaxCap: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: 0.00000
    },
    Daily_MinCap: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: 0.00000
    },
    Daily_ZeroError: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: "NULL"
    },
    Daily_SpiritLevel: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: "NULL"
    },
    Daily_GeneralCare: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: "NULL"
    },
    Daily_UserID: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: "NULL"
    },
    Daily_UserName: {
      type: DataTypes.STRING(250),
      allowNull: false,
      defaultValue: "NULL"
    },
    Daily_VerifyID: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: "NULL"
    },
    Daily_VerifyName: {
      type: DataTypes.STRING(250),
      allowNull: false,
      defaultValue: "NULL"
    },   
    Daily_VerifyDate: {
      type: DataTypes.TIME,
      allowNull: false,
      defaultValue: "1992-12-08 00:00:00"
    },     
    Daily_PrintNo: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: 0
    },
    Daily_IsRecalib: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: "NULL"
    },
    Daily_Location: {
      type: DataTypes.STRING(250),
      allowNull: false,
      defaultValue: "NULL"
    },
    Daily_CubicalNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    Daily_Bal_MaxoptRange: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: 0.00000
    },
    Daily_Bal_MinoptRange: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: 0.00000
    },
    Decimal_Point: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Daily_StdWeight: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "0"
    },
    Daily_NegTol: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "0"
    },
    Daily_PosTol: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "0"
    },
    Daily_RoomNo: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: "0"
    },
    Daily_NextPeriodicDate: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Daily_Reason: {
      type: DataTypes.STRING(250),
      allowNull: false,
      defaultValue: "NULL"
    },
    CalibrationStatus: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    Daily_AllWeightboxID: {
      type: DataTypes.STRING(1000),
      allowNull: true,
      defaultValue: "NULL"

    },
    Daily_AllWeightboxCert: {
      type: DataTypes.STRING(1000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Daily_AllWeightboxValidUpto: {
      type: DataTypes.STRING(1000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Daily_IsBinBalance: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Daily_CalibChange:{
      type:DataTypes.INTEGER,
      allowNull:true,
      defaultValue: 0
    },
    Daily_Pattern:{
      type:DataTypes.STRING(200),
      allowNull:true,
      defaultValue: "NULL"
    },
    Daily_FormNo:{
      type:DataTypes.STRING(200),
      allowNull:true,
      defaultValue: "NULL"
    },
    Daily_VersionNo:{
      type:DataTypes.STRING(200),
      allowNull:true,
      defaultValue: "NULL"
    },
    Daily_Status:{
      type:DataTypes.STRING(200),
      allowNull:true,
      defaultValue: "NULL"
    },
    Daily_Remark:{
      type:DataTypes.STRING(200),
      allowNull:true,
      defaultValue: "NULL"
    },
    Tolerance:{
      type:DataTypes.STRING(1000),
      allowNull:true,
      defaultValue: "NULL"
    },
    Daily_Bal_Cert_No: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: "NULL"
    }
  }, {
    sequelize,
    tableName: 'tbl_calibration_daily_master_incomplete',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "Daily_RepNo" },
        ]
      },
    ]
  });
};
