const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_product_master', {
    Id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    ProductId: {
      type: DataTypes.STRING(25),
      allowNull: false,
      defaultValue: "NULL"
    },
    ProductName: {
      type: DataTypes.STRING(300),
      allowNull: false,
      defaultValue: "NULL"
    },
    ProductType: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    ProductVersion: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: "NA"
    },
    Version: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: "NA"
    },
    IsActive: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    IsBilayer: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    IsBilayerLbl: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: "NULL"
    },
    IsTrilayer: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    IsTrilayerLbl: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: "NULL"
    },
    IsCoated: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    IsGranulation: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    IsCompress: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    NominalNomenclature: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: "NULL"
    },
    locked: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    userID: {
      type: DataTypes.STRING(200),
      allowNull: false,
      defaultValue: "NULL"
    },
    ActivateChance: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    ISBfGChecked: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0,
      comment: "0:Unchecked,1:Checked"
    },
    ISPrdVersionChecked: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0,
      comment: "0:Unchecked,1:Checked"
    },
    ISVersionChecked: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0,
      comment: "0:Unchecked,1:Checked"
    },
    IsContent1: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0,
      comment: "0:Unchecked,1:Checked"
    },
    IsContent2: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0,
      comment: "0:Unchecked,1:Checked"
    },
    IsContent3: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0,
      comment: "0:Unchecked,1:Checked"
    },
    IsContent4: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0,
      comment: "0:Unchecked,1:Checked"
    },
    useBefore: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    editCounter: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    Sys_Appearance: {
      type: DataTypes.STRING(500),
      allowNull: false,
      defaultValue: "NULL"
    },
    Sys_MachineSpeed_Min: {
      type: DataTypes.STRING(100),
      allowNull: false,
      defaultValue: "NULL"
    },
    Sys_MachineSpeed_Max: {
      type: DataTypes.STRING(100),
      allowNull: false,
      defaultValue: "NULL"
    },
    Individual: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    Group: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    Friability: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    DT: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    GenericName: {
      type: DataTypes.STRING(200),
      allowNull: false,
      defaultValue: "NA"
    },
    BatchUnit: {
      type: DataTypes.STRING(10),
      allowNull: false,
      defaultValue: "NULL"
    },
    BatchSize: {
      type: DataTypes.STRING(100),
      allowNull: false,
      defaultValue: "NULL"
    },
    isBinWeighing: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    Upper_Surface: {
      type: DataTypes.STRING(500),
      allowNull: false,
      defaultValue: "NULL"
    },
    Lower_Surface: {
      type: DataTypes.STRING(500),
      allowNull: false,
      defaultValue: "NULL"
    },
    Appearance_Desc: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    Appearance_Desc_Coat: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    }
  }, {
    sequelize,
    tableName: 'tbl_product_master',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "Id" },
        ]
      },
    ]
  });
};
