const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  var seq = sequelize.define('tbl_tab_friability_archived', {
    RepSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    MstSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    SrNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Area: {
      type: DataTypes.STRING(300),
      allowNull: true
    },
    CubicleName: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    CubicalNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    CubicleType: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    IPQCType: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    ProductType: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 1
    },
    ReportType: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    BFGCode: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    ProductName: {
      type: DataTypes.STRING(250),
      allowNull: true
    },
    PVersion: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Version: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    BatchNo: {
      type: DataTypes.STRING(25),
      allowNull: true
    },
    BMRNo: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    BatchSize: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    MachineCode: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    BalanceId: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    FriabilityID: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    IdsNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Qty: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    UserId: {
      type: DataTypes.STRING(25),
      allowNull: true
    },
    UserName: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    PrDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    PrTime: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    PrEndDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    PrEndTime: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    Side: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Unit: {
      type: DataTypes.STRING(5),
      allowNull: true
    },
    DecimalPoint: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    NMT: {
      type: DataTypes.STRING(10),
      allowNull: true
    },
    SetCount: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    SetRPM: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    PrintNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    IsArchived: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    BatchComplete: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    CheckedByID: {
      type: DataTypes.STRING(25),
      allowNull: true
    },
    CheckedByName: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    CheckedByDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    ActualCount: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    ActualRPM: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Inprocess: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    LBefore: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    LAfter: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    LPercentage: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    LRemark: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    RBefore: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    RAfter: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    RPercentage: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    RRemark: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    NBefore: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    NAfter: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    NPercentage: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    NRemark: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    CheckedByTime: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    Sys_Validation: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
      comment: "0:unchecked,1:checked"
    },
    Department: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    FailedRemark: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    }
  }, {
    sequelize,
    tableName: 'tbl_tab_friability_archived',
    schema: 'dbo',
    timestamps: false
  });
  seq.removeAttribute('id');
  return seq;
};
