const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  var seq = sequelize.define('tbl_calibration_periodic_detail_failed', {
    SRNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    Periodic_RepNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    Periodic_RecNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Periodic_BalStdWt: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: 0.00000
    },
    Periodic_BalNegTol: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: 0.00000
    },
    Periodic_BalPosTol: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: 0.00000
    },
    Periodic_ActualWt: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: 0.00000
    },
    Periodic_StdWtBoxID: {
      type: DataTypes.STRING(5000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Periodic_StdWt: {
      type: DataTypes.STRING(5000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Periodic_WtIdentification: {
      type: DataTypes.STRING(5000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Periodic_WeightBox_certfctNo: {
      type: DataTypes.STRING(5000),
      allowNull: true,
      defaultValue: "NULL"
    },
    Periodic_DP: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    PercentofCapacity: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },    
    Periodic_ValDate: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Periodic_Tolerance: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Periodic_Remark: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    } 
  }, {
    sequelize,
    tableName: 'tbl_calibration_periodic_detail_failed',
    timestamps: false
  });
  seq.removeAttribute('id')
  return seq
};
