<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function round

Round a value towards the nearest integer.
For matrices, the function is evaluated element wise.


## Syntax

```js
math.round(x)
math.round(x, n)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; BigNumber &#124; Fraction &#124; Complex &#124; Array &#124; Matrix | Number to be rounded
`n` | number &#124; BigNumber &#124; Array | Number of decimals Default value: 0.

### Returns

Type | Description
---- | -----------
number &#124; BigNumber &#124; Fraction &#124; Complex &#124; Array &#124; Matrix | Rounded value


## Examples

```js
math.round(3.22)             // returns number 3
math.round(3.82)             // returns number 4
math.round(-4.2)             // returns number -4
math.round(-4.7)             // returns number -5
math.round(3.22, 1)          // returns number 3.2
math.round(3.88, 1)          // returns number 3.8
math.round(-4.21, 1)         // returns number -4.2
math.round(-4.71, 1)         // returns number -4.7
math.round(math.pi, 3)       // returns number 3.142
math.round(123.45678, 2)     // returns number 123.46

const c = math.complex(3.2, -2.7)
math.round(c)                // returns Complex 3 - 3i

math.round([3.2, 3.8, -4.7]) // returns Array [3, 4, -5]
```


## See also

[ceil](ceil.md),
[fix](fix.md),
[floor](floor.md)
