/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mondrian.olap.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionIterator<T>
implements Iterator<T> {
    private final Iterator<Iterable<? extends T>> iterableIterator;
    private Iterator<? extends T> iterator;

    public UnionIterator(Iterable<? extends T> ... iterables) {
        List<Iterable<T>> list;
        if (Util.Retrowoven) {
            list = new ArrayList<Iterable<? extends T>>(iterables.length);
            for (Iterable<? extends T> iterable : iterables) {
                list.add(new MyIterable<T>(iterable));
            }
        } else {
            list = Arrays.asList(iterables);
        }
        this.iterableIterator = list.iterator();
        this.moveToNext();
    }

    public UnionIterator(Collection<? extends T> ... iterables) {
        ArrayList<MyIterable<? extends T>> list = new ArrayList<MyIterable<? extends T>>(iterables.length);
        for (Collection<? extends T> iterable : iterables) {
            list.add(new MyIterable<T>(iterable));
        }
        this.iterableIterator = list.iterator();
        this.moveToNext();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        T t = this.iterator.next();
        if (!this.iterator.hasNext()) {
            this.moveToNext();
        }
        return t;
    }

    private void moveToNext() {
        do {
            if (!this.iterableIterator.hasNext()) {
                this.iterator = Collections.emptyList().iterator();
                break;
            }
            this.iterator = this.iterableIterator.next().iterator();
        } while (!this.iterator.hasNext());
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyIterable<T>
    implements Iterable {
        private final Iterable<T> iterable;

        public MyIterable(Iterable<T> iterable) {
            this.iterable = iterable;
        }

        @Override
        public Iterator<T> iterator() {
            return this.iterable.iterator();
        }
    }
}

