/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IntegerCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.SchemaReader;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.type.SetType;

class TopBottomCountFunDef
extends FunDefBase {
    boolean top;
    static final MultiResolver TopCountResolver = new MultiResolver("TopCount", "TopCount(<Set>, <Count>[, <Numeric Expression>])", "Returns a specified number of items from the top of a set, optionally ordering the set first.", new String[]{"fxxnn", "fxxn"}){

        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            return new TopBottomCountFunDef(dummyFunDef, true);
        }
    };
    static final MultiResolver BottomCountResolver = new MultiResolver("BottomCount", "BottomCount(<Set>, <Count>[, <Numeric Expression>])", "Returns a specified number of items from the bottom of a set, optionally ordering the set first.", new String[]{"fxxnn", "fxxn"}){

        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            return new TopBottomCountFunDef(dummyFunDef, false);
        }
    };

    public TopBottomCountFunDef(FunDef dummyFunDef, boolean top) {
        super(dummyFunDef);
        this.top = top;
    }

    public Calc compileCall(final ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc = compiler.compileList(call.getArg(0), true);
        final IntegerCalc integerCalc = compiler.compileInteger(call.getArg(1));
        final Calc orderCalc = call.getArgCount() > 2 ? compiler.compileScalar(call.getArg(2), true) : null;
        final int arity = ((SetType)call.getType()).getArity();
        return new AbstractListCalc(call, new Calc[]{listCalc, integerCalc, orderCalc}){

            public List evaluateList(Evaluator evaluator) {
                SchemaReader schemaReader = evaluator.getSchemaReader();
                NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(call.getFunDef(), call.getArgs(), evaluator, this);
                if (nativeEvaluator != null) {
                    return (List)nativeEvaluator.execute(ResultStyle.LIST);
                }
                List list = listCalc.evaluateList(evaluator);
                if (list.isEmpty()) {
                    return list;
                }
                int n = integerCalc.evaluateInteger(evaluator);
                if (n == 0 || n == -2147483647) {
                    return new ArrayList();
                }
                if (orderCalc == null) {
                    if (list instanceof AbstractList && list.size() < n) {
                        return list;
                    }
                    return list.subList(0, n);
                }
                return this.partiallySortList(evaluator, list, this.hasHighCardDimension(list), n, arity);
            }

            private List partiallySortList(Evaluator evaluator, List list, boolean highCard, int n, int arity2) {
                if (highCard) {
                    int chunkSize = 6400;
                    ArrayList allChunkResults = new ArrayList();
                    Iterator listIter = list.iterator();
                    while (listIter.hasNext()) {
                        ArrayList chunk = new ArrayList();
                        for (int count = 0; count < 6400 && listIter.hasNext(); ++count) {
                            chunk.add(listIter.next());
                        }
                        List chunkResult = this.partiallySortList(evaluator, chunk, false, n, arity2);
                        allChunkResults.addAll(chunkResult);
                    }
                    return this.partiallySortList(evaluator, allChunkResults, false, n, arity2);
                }
                if (arity2 == 1) {
                    return FunUtil.partiallySortMembers(evaluator.push(), list, orderCalc, n, TopBottomCountFunDef.this.top);
                }
                return FunUtil.partiallySortTuples(evaluator.push(), list, orderCalc, n, TopBottomCountFunDef.this.top, arity2);
            }

            public boolean dependsOn(Dimension dimension) {
                return 3.anyDependsButFirst(this.getCalcs(), dimension);
            }

            private boolean hasHighCardDimension(List l) {
                Object trial = l.get(0);
                if (trial instanceof Member) {
                    Member m = (Member)trial;
                    return m.getHierarchy().getDimension().isHighCardinality();
                }
                for (Member m : (Member[])trial) {
                    if (!m.getHierarchy().getDimension().isHighCardinality()) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

