/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import mondrian.olap.Connection;
import mondrian.olap.Exp;
import mondrian.olap.FunTable;
import mondrian.olap.Parser;
import mondrian.olap.Query;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import org.apache.log4j.Logger;

public abstract class ConnectionBase
implements Connection {
    public static void memoryUsageNotification(Query query, String msg) {
        query.setOutOfMemory(msg);
    }

    protected ConnectionBase() {
    }

    protected abstract Logger getLogger();

    public String getFullConnectString() {
        String s = this.getConnectString();
        String catalogName = this.getCatalogName();
        if (catalogName != null) {
            int len = s.length() + catalogName.length() + 32;
            StringBuilder buf = new StringBuilder(len);
            buf.append(s);
            if (!s.endsWith(";")) {
                buf.append(';');
            }
            buf.append("Initial Catalog=");
            buf.append(catalogName);
            buf.append(';');
            s = buf.toString();
        }
        return s;
    }

    public Query parseQuery(String query) {
        return this.parseQuery(query, null, false, false);
    }

    public Query parseQuery(String query, boolean load) {
        return this.parseQuery(query, null, load, false);
    }

    public Query parseQuery(String query, FunTable funTable, boolean strictValidation) {
        return this.parseQuery(query, funTable, false, strictValidation);
    }

    public Exp parseExpression(String expr) {
        boolean debug = false;
        if (this.getLogger().isDebugEnabled()) {
            StringBuilder buf = new StringBuilder(256);
            buf.append(Util.nl);
            buf.append(expr);
            this.getLogger().debug((Object)buf.toString());
        }
        try {
            Parser parser = new Parser();
            FunTable funTable = this.getSchema().getFunTable();
            Exp q = parser.parseExpression(this, expr, debug, funTable);
            return q;
        }
        catch (Throwable exception) {
            throw MondrianResource.instance().FailedToParseQuery.ex(expr, exception);
        }
    }

    private Query parseQuery(String query, FunTable cftab, boolean load, boolean strictValidation) {
        Parser parser = new Parser();
        boolean debug = false;
        FunTable funTable = cftab == null ? this.getSchema().getFunTable() : cftab;
        if (this.getLogger().isDebugEnabled()) {
            StringBuilder buf = new StringBuilder(256);
            buf.append(Util.nl);
            buf.append(query);
            this.getLogger().debug((Object)buf.toString());
        }
        try {
            Query q = parser.parseInternal(this, query, debug, funTable, load, strictValidation);
            return q;
        }
        catch (Throwable e) {
            throw MondrianResource.instance().FailedToParseQuery.ex(query, e);
        }
    }
}

