/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetReader;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.rowset.OracleCachedRowSet;

public class OracleCachedRowSetReader
implements RowSetReader,
Serializable {
    static final transient int UNICODESTREAM = 273;
    static final transient int BINARYSTREAM = 546;
    static final transient int ASCIISTREAM = 819;
    static final transient int TWO_PARAMETERS = 2;
    static final transient int THREE_PARAMETERS = 3;
    private static transient boolean driverManagerInitialized = false;

    Connection getConnection(RowSetInternal rowSetInternal) throws SQLException {
        Connection connection = null;
        Connection connection2 = rowSetInternal.getConnection();
        if (connection2 != null && !connection2.isClosed()) {
            connection = connection2;
        } else if (((RowSet)((Object)rowSetInternal)).getDataSourceName() != null) {
            try {
                Object object;
                InitialContext initialContext = null;
                try {
                    object = System.getProperties();
                    initialContext = new InitialContext((Hashtable<?, ?>)object);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (initialContext == null) {
                    initialContext = new InitialContext();
                }
                object = (DataSource)initialContext.lookup(((RowSet)((Object)rowSetInternal)).getDataSourceName());
                String string = ((RowSet)((Object)rowSetInternal)).getUsername();
                String string2 = ((RowSet)((Object)rowSetInternal)).getPassword();
                if (string == null && string2 == null) {
                    connection = object.getConnection();
                }
                connection = object.getConnection(string, string2);
            }
            catch (NamingException namingException) {
                throw new SQLException("Unable to connect through the DataSource\n" + namingException.getMessage());
            }
        } else if (((RowSet)((Object)rowSetInternal)).getUrl() != null) {
            if (!driverManagerInitialized) {
                DriverManager.registerDriver(new OracleDriver());
                driverManagerInitialized = true;
            }
            String string = ((RowSet)((Object)rowSetInternal)).getUrl();
            String string3 = ((RowSet)((Object)rowSetInternal)).getUsername();
            String string4 = ((RowSet)((Object)rowSetInternal)).getPassword();
            if (string.equals("") || string3.equals("") || string4.equals("")) {
                throw new SQLException("One or more of the authenticating parameter not set");
            }
            connection = DriverManager.getConnection(string, string3, string4);
        }
        return connection;
    }

    private void setParams(Object[] objectArray, PreparedStatement preparedStatement) throws SQLException {
        for (int i = 0; i < objectArray.length; ++i) {
            int n = 0;
            try {
                n = Array.getLength(objectArray[i]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                preparedStatement.setObject(i + 1, objectArray[i]);
                continue;
            }
            Object[] objectArray2 = (Object[])objectArray[i];
            if (n == 2) {
                if (objectArray2[0] == null) {
                    preparedStatement.setNull(i + 1, (Integer)objectArray2[1]);
                    continue;
                }
                if (objectArray2[0] instanceof Date || objectArray2[0] instanceof Time || objectArray2[0] instanceof Timestamp) {
                    if (objectArray2[1] instanceof Calendar) {
                        preparedStatement.setDate(i + 1, (Date)objectArray2[0], (Calendar)objectArray2[1]);
                        continue;
                    }
                    throw new SQLException("Unable to deduce param type");
                }
                if (objectArray2[0] instanceof Reader) {
                    preparedStatement.setCharacterStream(i + 1, (Reader)objectArray2[0], (Integer)objectArray2[1]);
                    continue;
                }
                if (!(objectArray2[1] instanceof Integer)) continue;
                preparedStatement.setObject(i + 1, objectArray2[0], (Integer)objectArray2[1]);
                continue;
            }
            if (n != 3) continue;
            if (objectArray2[0] == null) {
                preparedStatement.setNull(i + 1, (Integer)objectArray2[1], (String)objectArray2[2]);
            } else if (objectArray2[0] instanceof InputStream) {
                switch ((Integer)objectArray2[2]) {
                    case 273: {
                        preparedStatement.setUnicodeStream(i + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                    }
                    case 546: {
                        preparedStatement.setBinaryStream(i + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                    }
                    case 819: {
                        preparedStatement.setAsciiStream(i + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                    }
                }
                throw new SQLException("Unable to deduce parameter type");
            }
            if (objectArray2[1] instanceof Integer && objectArray2[2] instanceof Integer) {
                preparedStatement.setObject(i + 1, objectArray2[0], (Integer)objectArray2[1], (int)((Integer)objectArray2[2]));
                continue;
            }
            throw new SQLException("Unable to deduce param type");
        }
    }

    public synchronized void readData(RowSetInternal rowSetInternal) throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)rowSetInternal;
        Connection connection = this.getConnection(rowSetInternal);
        if (connection == null || oracleCachedRowSet.getCommand() == null) {
            throw new SQLException("Sorry, Could not obtain connection");
        }
        try {
            connection.setTransactionIsolation(oracleCachedRowSet.getTransactionIsolation());
        }
        catch (Exception exception) {
            // empty catch block
        }
        PreparedStatement preparedStatement = connection.prepareStatement(oracleCachedRowSet.getCommand());
        this.setParams(rowSetInternal.getParams(), preparedStatement);
        try {
            preparedStatement.setMaxRows(oracleCachedRowSet.getMaxRows());
            preparedStatement.setMaxFieldSize(oracleCachedRowSet.getMaxFieldSize());
            preparedStatement.setEscapeProcessing(oracleCachedRowSet.getEscapeProcessing());
            preparedStatement.setQueryTimeout(oracleCachedRowSet.getQueryTimeout());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        oracleCachedRowSet.populate(resultSet);
        resultSet.close();
        preparedStatement.close();
        try {
            connection.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (!oracleCachedRowSet.isConnectionStayingOpen()) {
            connection.close();
        }
    }
}

